/**
*     Copyright (c) 2023, Nations Technologies Inc.
* 
*     All rights reserved.
*
*     This software is the exclusive property of Nations Technologies Inc. (Hereinafter 
* referred to as NATIONS). This software, and the product of NATIONS described herein 
* (Hereinafter referred to as the Product) are owned by NATIONS under the laws and treaties
* of the People's Republic of China and other applicable jurisdictions worldwide.
*
*     NATIONS does not grant any license under its patents, copyrights, trademarks, or other 
* intellectual property rights. Names and brands of third party may be mentioned or referred 
* thereto (if any) for identification purposes only.
*
*     NATIONS reserves the right to make changes, corrections, enhancements, modifications, and 
* improvements to this software at any time without notice. Please contact NATIONS and obtain 
* the latest version of this software before placing orders.

*     Although NATIONS has attempted to provide accurate and reliable information, NATIONS assumes 
* no responsibility for the accuracy and reliability of this software.
* 
*     It is the responsibility of the user of this software to properly design, program, and test 
* the functionality and safety of any application made of this information and any resulting product. 
* In no event shall NATIONS be liable for any direct, indirect, incidental, special,exemplary, or 
* consequential damages arising in any way out of the use of this software or the Product.
*
*     NATIONS Products are neither intended nor warranted for usage in systems or equipment, any
* malfunction or failure of which may cause loss of human life, bodily injury or severe property 
* damage. Such applications are deemed, "Insecure Usage".
*
*     All Insecure Usage shall be made at user's risk. User shall indemnify NATIONS and hold NATIONS 
* harmless from and against all claims, costs, damages, and other liabilities, arising from or related 
* to any customer's Insecure Usage.

*     Any express or implied warranty with regard to this software or the Product, including,but not 
* limited to, the warranties of merchantability, fitness for a particular purpose and non-infringement
* are disclaimed to the fullest extent permitted by law.

*     Unless otherwise explicitly permitted by NATIONS, anyone may not duplicate, modify, transcribe
* or otherwise distribute this software for any purposes, in whole or in part.
*
*     NATIONS products and technologies shall not be used for or incorporated into any products or systems
* whose manufacture, use, or sale is prohibited under any applicable domestic or foreign laws or regulations. 
* User shall comply with any applicable export control laws and regulations promulgated and administered by 
* the governments of any countries asserting jurisdiction over the parties or transactions.
**/

/**
*\*\file n32g05x_led.h
*\*\author Nations
*\*\version v1.0.0
*\*\copyright Copyright (c) 2023, Nations Technologies Inc. All rights reserved.
**/

#ifndef __N32G05X_LED_H__
#define __N32G05X_LED_H__

#ifdef __cplusplus
 extern "C" {
#endif

#include "n32g05x.h"
#include "n32g05x_rcc.h"
#include "n32g05x_gpio.h"
#include "n32g05x_spi.h"

/*** LED Structure Definition Start ***/
#define SPI_LED         SPI3
#define SPIx_CLK        RCC_APB2_PERIPH_SPI3

#define SPIx_LED_CLK    (RCC_APB2_PERIPH_GPIOA | RCC_APB2_PERIPH_GPIOD)

#define SPIx_LED_GCLK_PORT   GPIOD      
#define SPIx_LED_GCLK_PIN    GPIO_PIN_1 /* PD1 */

#define SPIx_LED_SCK_PORT    GPIOD
#define SPIx_LED_SCK_PIN     GPIO_PIN_3 /* PD3 */
#define SPIx_LED_SCK_AFIO    GPIO_AF0_SPI3

#define SPIx_LED_NSS_PORT    GPIOD 
#define SPIx_LED_NSS_PIN     GPIO_PIN_2 /* PD2 */
#define SPIx_LED_NSS_AFIO    GPIO_AF0_SPI3

#define SPIx_LED_MOSI_PORT   GPIOA      
#define SPIx_LED_MOSI_PIN    GPIO_PIN_0 /* PA0 */
#define SPIx_LED_MOSI_AFIO   GPIO_AF4_SPI3

#define SPIx_LED_MISO_PORT   GPIOA 
#define SPIx_LED_MISO_PIN    GPIO_PIN_1 /* PA1 */
#define SPIx_LED_MISO_AFIO   GPIO_AF0_SPI3



/*** LED COM PORT Defination ***/
#define COM0_2_PORT       GPIOB
#define COM3_PORT         GPIOC
#define COM4_PORT         GPIOA
#define COM5_9_PORT       GPIOD

 /*** LED COM PIN Defination ***/
#define COM0_PIN        GPIO_PIN_12
#define COM1_PIN        GPIO_PIN_14
#define COM2_PIN        GPIO_PIN_15
#define COM3_PIN        GPIO_PIN_8
#define COM4_PIN        GPIO_PIN_15
#define COM5_PIN        GPIO_PIN_10
#define COM6_PIN        GPIO_PIN_9
#define COM7_PIN        GPIO_PIN_8
#define COM8_PIN        GPIO_PIN_7
#define COM9_PIN        GPIO_PIN_6


/*** LED SEG PORT Defination ***/
#define SEG0_2PORT      GPIOB
#define SEG3_PORT       GPIOC
#define SEG4_PORT       GPIOB
#define SEG5_15_PORT    GPIOC


 /*** LED SEG PIN Defination ***/
#define SEG0_PIN        GPIO_PIN_6
#define SEG1_PIN        GPIO_PIN_8
#define SEG2_PIN        GPIO_PIN_9
#define SEG3_PIN        GPIO_PIN_4
#define SEG4_PIN        GPIO_PIN_7
#define SEG5_PIN        GPIO_PIN_11
#define SEG6_PIN        GPIO_PIN_10
#define SEG7_PIN        GPIO_PIN_9
#define SEG8_PIN        GPIO_PIN_5
#define SEG9_PIN        GPIO_PIN_6
#define SEG10_PIN       GPIO_PIN_7
#define SEG11_PIN       GPIO_PIN_2
#define SEG12_PIN       GPIO_PIN_3
#define SEG13_PIN       GPIO_PIN_0
#define SEG14_PIN       GPIO_PIN_1
#define SEG15_PIN       GPIO_PIN_12


/** LED Init structure definition **/
typedef struct
{
    uint8_t GCLK_LowLevelNum;    /* Specifies the GCLK low level number , the value must be greater than 19 */

    uint8_t COM_WorkNum;         /* Specifies the total number of COM-IO eable to work. eg : when COMWorkNumer = 4 it means
                                    COM0,COM1,COM2,COM3 will eable to work*/
    uint8_t  SEG_WorkCurrent;    /* Specifies LED SEG working current,the value 0 ~30 to 5~20mA */

    uint8_t  ScanMode;           /* Specifies LED display mode  */

    uint16_t SEG_WorkStatus;     /* Specifies which SEG-IO is enable to work,Bit0 - SEG0,Bit1 - SEG1...Bit15 - SEG15
                                    eg :when SEG_WorkStatus = 0x1841 it means SEG0,SEG6,SEG11,SEG15 will eable to work*/
} LED_InitType;



typedef struct
{
    uint8_t Trim_Rset;  

    uint8_t Trim_BG; 
                                    
    uint8_t Trim_SEG[6];

    uint16_t SEG_WorkCurrent;           

    uint8_t ScanMode;   

    uint8_t EnableStaus; 

    uint8_t ComNum;
    
    uint16_t SEG_Status;
    
    uint8_t Cur_ScanCOM;
    
    uint8_t SEG_Duty[16];    
} LED_StatusType;



#define     PROTOCOL_HEAD_CMD                ((uint16_t)0x8000U )
#define     PROTOCOL_BASE_CMD                ((uint16_t)0x0000U )
#define     PROTOCOL_TRIM_CMD                ((uint16_t)0x1000U )
#define     PROTOCOL_GLOBAL_CMD              ((uint16_t)0x2000U )
#define     PROTOCOL_SEG_DUTY_CMD            ((uint16_t)0x3000U )

/*LED Base Command Definition*/
#define     LED_CMD_COM_FORCE_SHUTDOWM       ((uint16_t)(PROTOCOL_HEAD_CMD | PROTOCOL_BASE_CMD | 0x0000U))
#define     LED_CMD_COM_SCAN_RESET           ((uint16_t)(PROTOCOL_HEAD_CMD | PROTOCOL_BASE_CMD | 0x0100U))
#define     LED_CMD_COM_SCAN_ON              ((uint16_t)(PROTOCOL_HEAD_CMD | PROTOCOL_BASE_CMD | 0x0200U))
#define     LED_CMD_READ_REG                 ((uint16_t)(PROTOCOL_HEAD_CMD | PROTOCOL_BASE_CMD | 0x0300U))
#define     LED_CMD_READ_OFF                 ((uint16_t)(PROTOCOL_HEAD_CMD | PROTOCOL_BASE_CMD | 0x0400U))
#define     LED_CMD_CHIP_WAKEUP              ((uint16_t)(PROTOCOL_HEAD_CMD | PROTOCOL_BASE_CMD | 0x0700U))

/*LED Triming Command Definition*/
#define     LED_CMD_SEG_TRIM_REG0_WRITE      ((uint16_t)(PROTOCOL_HEAD_CMD | PROTOCOL_TRIM_CMD | 0x0000U))
#define     LED_CMD_SEG_TRIM_REG1_WRITE      ((uint16_t)(PROTOCOL_HEAD_CMD | PROTOCOL_TRIM_CMD | 0x0100U))
#define     LED_CMD_SEG_TRIM_REG2_WRITE      ((uint16_t)(PROTOCOL_HEAD_CMD | PROTOCOL_TRIM_CMD | 0x0200U))
#define     LED_CMD_SEG_TRIM_REG3_WRITE      ((uint16_t)(PROTOCOL_HEAD_CMD | PROTOCOL_TRIM_CMD | 0x0300U))
#define     LED_CMD_SEG_TRIM_REG4_WRITE      ((uint16_t)(PROTOCOL_HEAD_CMD | PROTOCOL_TRIM_CMD | 0x0400U))
#define     LED_CMD_SEG_TRIM_REG5_WRITE      ((uint16_t)(PROTOCOL_HEAD_CMD | PROTOCOL_TRIM_CMD | 0x0500U))
#define     LED_CMD_RSET_TRIM_REG_WRITE      ((uint16_t)(PROTOCOL_HEAD_CMD | PROTOCOL_TRIM_CMD | 0x0600U))
#define     LED_CMD_BG_TRIM_REG_WRITE        ((uint16_t)(PROTOCOL_HEAD_CMD | PROTOCOL_TRIM_CMD | 0x0700U))

/*LED Global Command Definition*/
#define     LED_CMD_SEG_CUR_DISP_MODE_CHIP_EN      ((uint16_t)(PROTOCOL_HEAD_CMD | PROTOCOL_GLOBAL_CMD | 0x0000U))
#define     LED_CMD_COM_NUM_COM0_1_WORK_STATUS     ((uint16_t)(PROTOCOL_HEAD_CMD | PROTOCOL_GLOBAL_CMD | 0x0100U))
#define     LED_CMD_COM2_9_WORK_STATUS             ((uint16_t)(PROTOCOL_HEAD_CMD | PROTOCOL_GLOBAL_CMD | 0x0200U))
#define     LED_CMD_SEG0_7_WORK_STATUS             ((uint16_t)(PROTOCOL_HEAD_CMD | PROTOCOL_GLOBAL_CMD | 0x0300U))
#define     LED_CMD_SEG8_15_WORK_STATUS            ((uint16_t)(PROTOCOL_HEAD_CMD | PROTOCOL_GLOBAL_CMD | 0x0400U))

/*LED Seg Duty Data Command Definition*/
#define     LED_CMD_SEG0_DUTY_DATA           ((uint16_t)(PROTOCOL_HEAD_CMD | PROTOCOL_SEG_DUTY_CMD | 0x0000U))
#define     LED_CMD_SEG1_DUTY_DATA           ((uint16_t)(PROTOCOL_HEAD_CMD | PROTOCOL_SEG_DUTY_CMD | 0x0100U))
#define     LED_CMD_SEG2_DUTY_DATA           ((uint16_t)(PROTOCOL_HEAD_CMD | PROTOCOL_SEG_DUTY_CMD | 0x0200U))
#define     LED_CMD_SEG3_DUTY_DATA           ((uint16_t)(PROTOCOL_HEAD_CMD | PROTOCOL_SEG_DUTY_CMD | 0x0300U))
#define     LED_CMD_SEG4_DUTY_DATA           ((uint16_t)(PROTOCOL_HEAD_CMD | PROTOCOL_SEG_DUTY_CMD | 0x0400U))
#define     LED_CMD_SEG5_DUTY_DATA           ((uint16_t)(PROTOCOL_HEAD_CMD | PROTOCOL_SEG_DUTY_CMD | 0x0500U))
#define     LED_CMD_SEG6_DUTY_DATA           ((uint16_t)(PROTOCOL_HEAD_CMD | PROTOCOL_SEG_DUTY_CMD | 0x0600U))
#define     LED_CMD_SEG7_DUTY_DATA           ((uint16_t)(PROTOCOL_HEAD_CMD | PROTOCOL_SEG_DUTY_CMD | 0x0700U))
#define     LED_CMD_SEG8_DUTY_DATA           ((uint16_t)(PROTOCOL_HEAD_CMD | PROTOCOL_SEG_DUTY_CMD | 0x0800U))
#define     LED_CMD_SEG9_DUTY_DATA           ((uint16_t)(PROTOCOL_HEAD_CMD | PROTOCOL_SEG_DUTY_CMD | 0x0900U))
#define     LED_CMD_SEG10_DUTY_DATA          ((uint16_t)(PROTOCOL_HEAD_CMD | PROTOCOL_SEG_DUTY_CMD | 0x0A00U))
#define     LED_CMD_SEG11_DUTY_DATA          ((uint16_t)(PROTOCOL_HEAD_CMD | PROTOCOL_SEG_DUTY_CMD | 0x0B00U))
#define     LED_CMD_SEG12_DUTY_DATA          ((uint16_t)(PROTOCOL_HEAD_CMD | PROTOCOL_SEG_DUTY_CMD | 0x0C00U))
#define     LED_CMD_SEG13_DUTY_DATA          ((uint16_t)(PROTOCOL_HEAD_CMD | PROTOCOL_SEG_DUTY_CMD | 0x0D00U))
#define     LED_CMD_SEG14_DUTY_DATA          ((uint16_t)(PROTOCOL_HEAD_CMD | PROTOCOL_SEG_DUTY_CMD | 0x0E00U))
#define     LED_CMD_SEG15_DUTY_DATA          ((uint16_t)(PROTOCOL_HEAD_CMD | PROTOCOL_SEG_DUTY_CMD | 0x0F00U))

/*LED GCLK Prescale Definition*/
#define     LED_GCLK_DIV1                    RCC_LEDCLK_DIV1   
#define     LED_GCLK_DIV32                   RCC_LEDCLK_DIV32   
#define     LED_GCLK_DIV40                   RCC_LEDCLK_DIV40   
#define     LED_GCLK_DIV50                   RCC_LEDCLK_DIV50   
#define     LED_GCLK_DIV64                   RCC_LEDCLK_DIV64   
#define     LED_GCLK_DIV80                   RCC_LEDCLK_DIV80   
#define     LED_GCLK_DIV160                  RCC_LEDCLK_DIV160   

/*LED GCLK clock source Definition*/
#define     LED_GCLK_SRC_HSI                 RCC_LEDCLK_SRC_HSI   
#define     LED_GCLK_SRC_HSE                 RCC_LEDCLK_SRC_HSE  

#define     SPI_DUMMY_DATA                   (0xFFFFU)


#define     MAX_LED_SEG_ID                   (0x10U)
#define     MAX_LED_SEG_DUTY                 (0x003FU)
/* this value must be fix at 130 */
#define     LED_CLOCK_CYCLE_NUMBER           (0x82U) 


#define     NVR_ADDR_90H_TRIM                (0x1FFFF938U) 
#define     NVR_ADDR_91H_TRIM                (0x1FFFF940U) 
#define     NVR_ADDR_92H_TRIM                (0x1FFFF948U) 
#define     NVR_ADDR_93H_TRIM                (0x1FFFF950U) 
#define     NVR_ADDR_94H_TRIM                (0x1FFFF958U) 
#define     NVR_ADDR_95H_TRIM                (0x1FFFF960U) 
#define     NVR_ADDR_96H_TRIM                (0x1FFFF968U) 
#define     NVR_ADDR_97H_TRIM                (0x1FFFF970U)  

/*** LED Macro Definition End ***/
                                            
                                            

/*** LED Driving Functions Declaration ***/
void LED_InitStruct(LED_InitType* LED_InitStruct);
void LED_Init(LED_InitType* LED_InitStruct);
void LED_SEG_DutyDataSet(uint8_t SegId, uint8_t duty);
                                            
void LED_Get_RegData(void);
uint16_t SPI_SendDataToLED(uint16_t data) ;

void LED_GclkConfiguration(uint32_t LED_clksrc, uint32_t LED_prescaler);
void LED_SpiInit(void);
void LED_RccConfiguration(void);
void LED_GpioConfiguration(uint8_t COM_WorkNum, uint16_t SEG_WorkStatus);
                                            
#ifdef __cplusplus
}
#endif

#endif /* __N32G05X_LED_H__ */


