/**
*     Copyright (c) 2023, Nations Technologies Inc.
* 
*     All rights reserved.
*
*     This software is the exclusive property of Nations Technologies Inc. (Hereinafter 
* referred to as NATIONS). This software, and the product of NATIONS described herein 
* (Hereinafter referred to as the Product) are owned by NATIONS under the laws and treaties
* of the People's Republic of China and other applicable jurisdictions worldwide.
*
*     NATIONS does not grant any license under its patents, copyrights, trademarks, or other 
* intellectual property rights. Names and brands of third party may be mentioned or referred 
* thereto (if any) for identification purposes only.
*
*     NATIONS reserves the right to make changes, corrections, enhancements, modifications, and 
* improvements to this software at any time without notice. Please contact NATIONS and obtain 
* the latest version of this software before placing orders.

*     Although NATIONS has attempted to provide accurate and reliable information, NATIONS assumes 
* no responsibility for the accuracy and reliability of this software.
* 
*     It is the responsibility of the user of this software to properly design, program, and test 
* the functionality and safety of any application made of this information and any resulting product. 
* In no event shall NATIONS be liable for any direct, indirect, incidental, special,exemplary, or 
* consequential damages arising in any way out of the use of this software or the Product.
*
*     NATIONS Products are neither intended nor warranted for usage in systems or equipment, any
* malfunction or failure of which may cause loss of human life, bodily injury or severe property 
* damage. Such applications are deemed, "Insecure Usage".
*
*     All Insecure Usage shall be made at user's risk. User shall indemnify NATIONS and hold NATIONS 
* harmless from and against all claims, costs, damages, and other liabilities, arising from or related 
* to any customer's Insecure Usage.

*     Any express or implied warranty with regard to this software or the Product, including,but not 
* limited to, the warranties of merchantability, fitness for a particular purpose and non-infringement
* are disclaimed to the fullest extent permitted by law.

*     Unless otherwise explicitly permitted by NATIONS, anyone may not duplicate, modify, transcribe
* or otherwise distribute this software for any purposes, in whole or in part.
*
*     NATIONS products and technologies shall not be used for or incorporated into any products or systems
* whose manufacture, use, or sale is prohibited under any applicable domestic or foreign laws or regulations. 
* User shall comply with any applicable export control laws and regulations promulgated and administered by 
* the governments of any countries asserting jurisdiction over the parties or transactions.
**/

/**
*\*\file bsp_ov5640.c
*\*\author Nations
*\*\version v1.0.0
*\*\copyright Copyright (c) 2023, Nations Technologies Inc. All rights reserved.
**/

#include "bsp_ov5640.h"


#define SCCB_SDA_IN()  {GPIOB->PMODE&=~(3<<14);GPIOB->PMODE|=0<<14;}    
#define SCCB_SDA_OUT() {GPIOB->PMODE&=~(3<<14);GPIOB->PMODE|=1<<14;}    

#define SCCB_SCL_H        GPIO_SetBits(GPIOB,GPIO_PIN_6)//SCL H
#define SCCB_SCL_L        GPIO_ResetBits(GPIOB,GPIO_PIN_6)//SCL L

#define SCCB_SDA_H        GPIO_SetBits(GPIOB,GPIO_PIN_7)//SDA H
#define SCCB_SDA_L        GPIO_ResetBits(GPIOB,GPIO_PIN_7)//SDA L

#define SCCB_READ_SDA     GPIO_ReadInputDataBit(GPIOB,GPIO_PIN_7)



const int16_t ov5640_init_reg_tb[][2]= 
{   
//    0x3008, 0x82, 
//    0x3008, 0x42, // software power down, bit[6]
//    0x3103, 0x01, ////0x03												//Input clk from Pad cloc, bit[1]
//    0x3017, 0xff, 												// FREX, Vsync, HREF, PCLK, D[9:6] output enable
//    0x3018, 0xff, 												// D[5:0], GPIO[1:0] output enable
//    0x3034, 0x18,													//8 bit mode           //0x1a, // MIPI 10-bit
//    0x3037, 0x14,////0x12,	//0x13,													// PLL root divider, bit[4], PLL pre-divider, bit[3:0]
//    0x3108, 0x01, 												//PCLK root divider, bit[5:4], SCLK2x root divider, bit[3:2]

//    0x460c,0x22, //0x20:auto;0x22:not auto
    
    // 24MHz input clock, 24MHz PCLK
    0x3103, 0x01, // system clock from pad, bit[1]
    0x3008, 0x82, // software reset, bit[7]
    // delay 5ms
    0x3008, 0x42, // software power down, bit[6]
    0x3103, 0x03, // system clock from PLL, bit[1]
    0x3017, 0xff, // FREX, Vsync, HREF, PCLK, D[9:6] output enable
    0x3018, 0xff, // D[5:0], GPIO[1:0] output enable
    0x3034, 0x1a, // MIPI 10-bit
    0x3037, 0x13, // PLL root divider, bit[4], PLL pre-divider, bit[3:0]
    0x3108, 0x01, // PCLK root divider, bit[5:4], SCLK2x root divider, bit[3:2]
		
		
    // SCLK root divider, bit[1:0]
    0x3630, 0x36,
    0x3631, 0x0e,
    0x3632, 0xe2,
    0x3633, 0x12,
    0x3621, 0xe0,
    0x3704, 0xa0,
    0x3703, 0x5a,
    0x3715, 0x78,
    0x3717, 0x01,
    0x370b, 0x60,
    0x3705, 0x1a,
    0x3905, 0x02,
    0x3906, 0x10,
    0x3901, 0x0a,
    0x3731, 0x12,
    0x3600, 0x08, // VCM control
    0x3601, 0x33, // VCM control
    0x302d, 0x60, // system control
    0x3620, 0x52,
    0x371b, 0x20,
    0x471c, 0x50,
    0x3a13, 0x43, // pre-gain = 1.047x
    0x3a18, 0x00, // gain ceiling
    ////0x3a19, 0xf8, //// gain ceiling = 15.5x
    0x3635, 0x13,
    0x3636, 0x03,
    0x3634, 0x40,
    0x3622, 0x01,
    // 50/60Hz detection 50/60Hz 
    ////0x3c01, 0x34, //// Band auto, bit[7]
    0x3c04, 0x28, //// threshold low sum
    0x3c05, 0x98, //// threshold high sum
    0x3c06, 0x00, //// light meter 1 threshold[15:8]
    0x3c07, 0x08, //// light meter 1 threshold[7:0]
    0x3c08, 0x00, //// light meter 2 threshold[15:8]
    0x3c09, 0x1c, //// light meter 2 threshold[7:0]
    0x3c0a, 0x9c, //// sample number[15:8]
    0x3c0b, 0x40, //// sample number[7:0]
    0x3810, 0x00, //// Timing Hoffset[11:8]
    0x3811, 0x10,////0x10,//0x10, // Timing Hoffset[7:0]
    0x3812, 0x00, //// Timing Voffset[10:8]
    0x3708, 0x64,
    0x4001, 0x02, // BLC start from line 2
    0x4005, 0x1a, // BLC always update
    0x3000, 0x00, // enable blocks
    0x3004, 0xff, // enable clocks
    0x300e, 0x58, // MIPI power down, DVP enable
    0x302e, 0x00, ////
    #if DVP_OUTPUT_FORMAT == DVP_OUTPUT_YUV422	
    0x4300, 0x30,//YUV 422, YUYV
    0x501f, 0x00,// YUV 422
    #else 
    0x4300, 0x6f,//0x61 RGB565
    0x501f, 0x01,// RGB
    #endif

    //0x4300, 0x30,//0x6F,RGB565			//	//0x30, YUV 422, YUYV
    //0x501f, 0x01,	//RGB									//0x00,	// YUV 422
    0x440e, 0x00,   ////
    0x5000, 0xa7, // Lenc on, raw gamma on, BPC on, WPC on, CIP on
    // AEC target 
    0x3a0f, 0x30, // stable range in high
    0x3a10, 0x28, // stable range in low
    0x3a1b, 0x30, // stable range out high
    0x3a1e, 0x26, // stable range out low
    0x3a11, 0x60, // fast zone high
    0x3a1f, 0x14, // fast zone low
    #if DVP_OUTPUT_FORMAT == DVP_OUTPUT_YUV422	
    //0x4300, 0x30,//YUV 422, YUYV
    //0x501f, 0x00,// YUV 422


    //0x3a19, 0x7c, //// gain ceiling = 15.5x
    //0x3c01, 0xb4, //// Band auto, bit[7]
    0x3a19, 0xf8, //// gain ceiling = 15.5x
    0x3c01, 0x34, //// Band auto, bit[7]
    /*0x3c00, 0x04,
    0x3a02, 0x03,
    0x3a03, 0xe0,
    0x3a08, 0x01,
    0x3a09, 0x27,
    0x3a0a, 0x00,
    0x3a0b, 0xf6,
    0x3a0e, 0x03,
    0x3a0d, 0x04,
    0x3a14, 0x03,
    0x3a15, 0xd8,*/

    // Lens correction for 
    0x5800, 0x2c,
    0x5801, 0x17,
    0x5802, 0x11,
    0x5803, 0x11,
    0x5804, 0x15,
    0x5805, 0x29,
    0x5806, 0x08,
    0x5807, 0x06,
    0x5808, 0x04,
    0x5809, 0x04,
    0x580a, 0x05,

    0x580b, 0x07,
    0x580c, 0x06,
    0x580d, 0x03,
    0x580e, 0x01,
    0x580f, 0x01,
    0x5810, 0x03,
    0x5811, 0x06,
    0x5812, 0x06,
    0x5813, 0x02,
    0x5814, 0x01,
    0x5815, 0x01,
    0x5816, 0x04,
    0x5817, 0x07,
    0x5818, 0x06,
    0x5819, 0x07,
    0x581a, 0x06,
    0x581b, 0x06,
    0x581c, 0x06,
    0x581d, 0x0e,
    0x581e, 0x31,
    0x581f, 0x12,
    0x5820, 0x11,
    0x5821, 0x11,
    0x5822, 0x11,
    0x5823, 0x2f,
    0x5824, 0x12,
    0x5825, 0x25,
    0x5826, 0x39,
    0x5827, 0x29,
    0x5828, 0x27,
    0x5829, 0x39,
    0x582a, 0x26,
    0x582b, 0x33,
    0x582c, 0x24,
    0x582d, 0x39,
    0x582e, 0x28,
    0x582f, 0x21,
    0x5830, 0x40,
    0x5831, 0x21,
    0x5832, 0x17,
    0x5833, 0x17,
    0x5834, 0x15,
    0x5835, 0x11,
    0x5836, 0x24,
    0x5837, 0x27,
    0x5838, 0x26,
    0x5839, 0x26,
    0x583a, 0x26,
    0x583b, 0x28,
    0x583c, 0x14,
    0x583d, 0xee, // lenc BR offset

    // AWB 
    0x5180, 0xff, // AWB B block
    0x5181, 0xf2, // AWB control
    0x5182, 0x11, // [7:4] max local counter, [3:0] max fast counter
    0x5183, 0x14, // AWB advanced
    0x5184, 0x25,
    0x5185, 0x24,
    0x5186, 0x10,
    0x5187, 0x12,
    0x5188, 0x10,
    0x5189, 0x80,////
    0x518a, 0x54,
    0x518b, 0xb8,////
    0x518c, 0xb2,
    0x518d, 0x42,////
    0x518e, 0x3a,////
    0x518f, 0x56,////
    0x5190, 0x46,
    0x5191, 0xf0, // AWB top limit
    0x5192, 0x0f, // AWB bottom limit
    0x5193, 0x70, // red limit
    0x5194, 0xf0, // green limit
    0x5195, 0xf0, // blue limit
    0x5196, 0x03, // AWB control
    0x5197, 0x01, // local limit
    0x5198, 0x06,
    0x5199, 0x62, ////
    0x519a, 0x04,
    0x519b, 0x00,
    0x519c, 0x04, ////
    0x519d, 0xe7, ////
    0x519e, 0x38, // AWB control
    // Gamma 
    0x5480, 0x01, // Gamma bias plus on, bit[0]
    0x5481, 0x08,
    0x5482, 0x14,
    0x5483, 0x28,
    0x5484, 0x51,
    0x5485, 0x65,
    0x5486, 0x71,
    0x5487, 0x7d,
    0x5488, 0x87,
    0x5489, 0x91,
    0x548a, 0x9a,
    0x548b, 0xaa,
    0x548c, 0xb8,
    0x548d, 0xcd,
    0x548e, 0xdd,
    0x548f, 0xea,
    0x5490, 0x1d,
    // color matrix 	
    0x5381, 0x26, // CMX1 for Y
    0x5382, 0x50, // CMX2 for Y
    0x5383, 0x0c, // CMX3 for Y
    0x5384, 0x09, // CMX4 for U
    0x5385, 0x74, // CMX5 for U
    0x5386, 0x7d, // CMX6 for U
    0x5387, 0x7e, // CMX7 for V
    0x5388, 0x75, // CMX8 for V
    0x5389, 0x09, // CMX9 for V
    0x538a, 0x01, // sign[9]
    0x538b, 0x98, // sign[8:1]
    // UV adjust UV 
    0x5580, 0x02, // saturation on, bit[1]
    0x5583, 0x40,
    0x5584, 0x10, 
    0x5589, 0x0f,
    0x558a, 0x00,
    0x558b, 0x3f,
    #else 
    //0x4300, 0x6F,//RGB565
    //0x501f, 0x01,// RGB

    0x3a19, 0xf8, //// gain ceiling = 15.5x
    0x3c01, 0x34, //// Band auto, bit[7]

    // Lens correction for 
    0x5800, 0x23,
    0x5801, 0x14,
    0x5802, 0x0f,
    0x5803, 0x0f,
    0x5804, 0x12,
    0x5805, 0x26,
    0x5806, 0x0c,
    0x5807, 0x08,
    0x5808, 0x05,
    0x5809, 0x05,
    0x580a, 0x08,

    0x580b, 0x0d,
    0x580c, 0x08,
    0x580d, 0x03,
    0x580e, 0x00,
    0x580f, 0x00,
    0x5810, 0x03,
    0x5811, 0x09,
    0x5812, 0x07,
    0x5813, 0x03,
    0x5814, 0x00,
    0x5815, 0x01,
    0x5816, 0x03,
    0x5817, 0x08,
    0x5818, 0x0d,
    0x5819, 0x08,
    0x581a, 0x05,
    0x581b, 0x06,
    0x581c, 0x08,
    0x581d, 0x0e,
    0x581e, 0x29,
    0x581f, 0x17,
    0x5820, 0x11,
    0x5821, 0x11,
    0x5822, 0x15,
    0x5823, 0x28,
    0x5824, 0x46,
    0x5825, 0x26,
    0x5826, 0x08,
    0x5827, 0x26,
    0x5828, 0x64,
    0x5829, 0x26,
    0x582a, 0x24,
    0x582b, 0x22,
    0x582c, 0x24,
    0x582d, 0x24,
    0x582e, 0x06,
    0x582f, 0x22,
    0x5830, 0x40,
    0x5831, 0x42,
    0x5832, 0x24,
    0x5833, 0x26,
    0x5834, 0x24,
    0x5835, 0x22,
    0x5836, 0x22,
    0x5837, 0x26,
    0x5838, 0x44,
    0x5839, 0x24,
    0x583a, 0x26,
    0x583b, 0x28,
    0x583c, 0x42,
    0x583d, 0xce, // lenc BR offset

    // AWB 
    0x5180, 0xff, // AWB B block
    0x5181, 0xf2, // AWB control
    0x5182, 0x00, // [7:4] max local counter, [3:0] max fast counter
    0x5183, 0x14, // AWB advanced
    0x5184, 0x25,
    0x5185, 0x24,
    0x5186, 0x09,
    0x5187, 0x09,
    0x5188, 0x09,
    0x5189, 0x75,////
    0x518a, 0x54,
    0x518b, 0xe0,////
    0x518c, 0xb2,
    0x518d, 0x42,////
    0x518e, 0x3d,////
    0x518f, 0x56,////
    0x5190, 0x46,
    0x5191, 0xf8, // AWB top limit
    0x5192, 0x04, // AWB bottom limit
    0x5193, 0x70, // red limit
    0x5194, 0xf0, // green limit
    0x5195, 0xf0, // blue limit
    0x5196, 0x03, // AWB control
    0x5197, 0x01, // local limit
    0x5198, 0x04,
    0x5199, 0x12, ////
    0x519a, 0x04,
    0x519b, 0x00,
    0x519c, 0x06, ////
    0x519d, 0x82, ////
    0x519e, 0x38, // AWB control
    // Gamma 
    0x5480, 0x01, // Gamma bias plus on, bit[0]
    0x5481, 0x08,
    0x5482, 0x14,
    0x5483, 0x28,
    0x5484, 0x51,
    0x5485, 0x65,
    0x5486, 0x71,
    0x5487, 0x7d,
    0x5488, 0x87,
    0x5489, 0x91,
    0x548a, 0x9a,
    0x548b, 0xaa,
    0x548c, 0xb8,
    0x548d, 0xcd,
    0x548e, 0xdd,
    0x548f, 0xea,
    0x5490, 0x1d,
    // color matrix 	
    0x5381, 0x1e, // CMX1 for Y
    0x5382, 0x5b, // CMX2 for Y
    0x5383, 0x08, // CMX3 for Y
    0x5384, 0x0a, // CMX4 for U
    0x5385, 0x7e, // CMX5 for U
    0x5386, 0x88, // CMX6 for U
    0x5387, 0x7c, // CMX7 for V
    0x5388, 0x6c, // CMX8 for V
    0x5389, 0x10, // CMX9 for V
    0x538a, 0x01, // sign[9]
    0x538b, 0x98, // sign[8:1]
    // UV adjust UV 
    0x5580, 0x06, // saturation on, bit[1]
    0x5583, 0x40,
    0x5584, 0x10, 
    0x5589, 0x10,
    0x558a, 0x00,
    0x558b, 0xf8,
    #endif
    0x501d, 0x40, //// enable manual offset of contrast
    // CIP
    0x5300, 0x08, // CIP sharpen MT threshold 1
    0x5301, 0x30, // CIP sharpen MT threshold 2
    0x5302, 0x10, // CIP sharpen MT offset 1
    0x5303, 0x00, // CIP sharpen MT offset 2
    0x5304, 0x08, // CIP DNS threshold 1
    0x5305, 0x30, // CIP DNS threshold 2
    0x5306, 0x08, // CIP DNS offset 1
    0x5307, 0x16, // CIP DNS offset 2
    0x5309, 0x08, // CIP sharpen TH threshold 1
    0x530a, 0x30, // CIP sharpen TH threshold 2
    0x530b, 0x04, // CIP sharpen TH offset 1
    0x530c, 0x06, // CIP sharpen TH offset 2
    0x5025, 0x00, 
    //	0x3008, 0x02, // wake up from standby, bit[6]
    #ifdef DVP_TEST_PATTERN
    0x503d, 0x80,//0x83,	//color bar eanble, 
    #else
    0x503d, 0x00,						//Color bar disable	
    #endif	
    0x4740, 0x00,//0x02,	////Data update at PCLK rising; HREF_active high; V_SYNC_active low;			
    //0x4741, 0x01,	////Test pattern_8 bit test pattern. 	 
    0x3008, 0x02, //// wake up from standby, bit[6]
    
};


const int16_t ov5640_rgb565_reg_tb[][2]=
{
    //0x4300, 0x6F, //0x6F,RGB565
    //0x501f, 0x01,//0x01, RGB    
    // Input clock = 24Mhz
//    0x3035, 0x11,//0x21, // PLL  
//    0x3036, 0x50,//0x28,		//0x69, // PLL 
    0x3035, 0x31,//0x21, // PLL  
    0x3036, 0x72,//0x28,		//0x69, // PLL 
    0x3c07, 0x07, // lightmeter 1 threshold[7:0] 
    0x3820, 0x46, // flip
    ////0x3821, 0x20, // mirror				//JPEC enable								 
    0x3821, 0x00,		//JPEG disable
    0x3814, 0x31, // timing X inc 
    0x3815, 0x31, // timing Y inc 

    0x3800, 0x00, // HS 
    0x3801, 0x00, // HS 
    0x3802, 0x00, // VS 
    0x3803, 0x00, // VS 
    0x3804, 0x0a, // HW (HE)		 
    0x3805, 0x3f, // HW (HE)
    0x3806, 0x06, //0x06,//0x07, // VH (VE)		 
    0x3807, 0xa9, //0xa9,//0x9f, // VH (VE) 

    0x3808, IMAGE_WIDTH_H,//0x00, //0x02, //0x00, // DVPHO 	   
    0x3809, IMAGE_WIDTH_L,//DVP_IMAGE_WIDTH, //0x80, //0xc0,//0x10, // DVPHO								//Data output H_size = 192 
    0x380a, IMAGE_HEIGHT_H,//0x00, //0x01, //0x00, // DVPVO 		
    0x380b, IMAGE_HEIGHT_L,//DVP_IMAGE_HEIGHT, //0xE0, //0xc0, //0x10, // DVPVO							//Data output V_size = 192

    0x380c, 0x08, //08 NG:0x05,//OK:0x0b, // HTS high		
    0x380d, 0x00, //00   NG:0xF8,//OK:0x1C  // HTS low
    0x380e, 0x06, //06 NG:0x03,//OK:0x07  // VTS high		
    0x380f, 0x00, //00   NG:0x84,//OK:0xB0  // VTS low
    0x3813, 0x04,//0x04, // timing V offset   04
    0x3618, 0x00,
    0x3612, 0x29,
    0x3709, 0x52,
    0x370c, 0x03, 
    /*     0x3a02, 0x02, // 60Hz max exposure
    0x3a03, 0xe0, // 60Hz max exposure 

    0x3a14, 0x02, // 50Hz max exposure
    0x3a15, 0xe0, // 50Hz max exposure*/

    0x4004, 0x02, // BLC line number 
    0x3002, 0x1c, // enable JFIFO, SFIFO, JPG 
    0x3006, 0xc3, // enable clock of JPEG2x, JPEG
    0x4713, 0x03, // JPEG mode 3
    0x4407, 0x04, // Quantization sacle 
    0x460b, 0x37,
	0x460c, 0x20,
    0x4837, 0x16, // MIPI global timing 
    0x3824, 8, //0x04,0x02, //0x01, // PCLK manual divider 
    0x303b, 8, ////
    0x303d, 0, ////
    0x5001, 0xA3,//0xA3, // SDE on, Scaling on, CMX on, AWB on 
    0x3503, 0x00, // AEC/AGC on	
    
};

const unsigned char OV5640_AF_Config[] =
{
	0x02, 0x0f, 0xd6, 0x02, 0x0a, 0x39, 0xc2, 0x01, 0x22, 0x22, 0x00, 0x02, 0x0f, 0xb2, 0xe5, 0x1f, //0x8000,
	0x70, 0x72, 0xf5, 0x1e, 0xd2, 0x35, 0xff, 0xef, 0x25, 0xe0, 0x24, 0x4e, 0xf8, 0xe4, 0xf6, 0x08, //0x8010,
	0xf6, 0x0f, 0xbf, 0x34, 0xf2, 0x90, 0x0e, 0x93, 0xe4, 0x93, 0xff, 0xe5, 0x4b, 0xc3, 0x9f, 0x50, //0x8020,
	0x04, 0x7f, 0x05, 0x80, 0x02, 0x7f, 0xfb, 0x78, 0xbd, 0xa6, 0x07, 0x12, 0x0f, 0x04, 0x40, 0x04, //0x8030,
	0x7f, 0x03, 0x80, 0x02, 0x7f, 0x30, 0x78, 0xbc, 0xa6, 0x07, 0xe6, 0x18, 0xf6, 0x08, 0xe6, 0x78, //0x8040,
	0xb9, 0xf6, 0x78, 0xbc, 0xe6, 0x78, 0xba, 0xf6, 0x78, 0xbf, 0x76, 0x33, 0xe4, 0x08, 0xf6, 0x78, //0x8050,
	0xb8, 0x76, 0x01, 0x75, 0x4a, 0x02, 0x78, 0xb6, 0xf6, 0x08, 0xf6, 0x74, 0xff, 0x78, 0xc1, 0xf6, //0x8060,
	0x08, 0xf6, 0x75, 0x1f, 0x01, 0x78, 0xbc, 0xe6, 0x75, 0xf0, 0x05, 0xa4, 0xf5, 0x4b, 0x12, 0x0a, //0x8070,
	0xff, 0xc2, 0x37, 0x22, 0x78, 0xb8, 0xe6, 0xd3, 0x94, 0x00, 0x40, 0x02, 0x16, 0x22, 0xe5, 0x1f, //0x8080,
	0xb4, 0x05, 0x23, 0xe4, 0xf5, 0x1f, 0xc2, 0x01, 0x78, 0xb6, 0xe6, 0xfe, 0x08, 0xe6, 0xff, 0x78, //0x8090,
	0x4e, 0xa6, 0x06, 0x08, 0xa6, 0x07, 0xa2, 0x37, 0xe4, 0x33, 0xf5, 0x3c, 0x90, 0x30, 0x28, 0xf0, //0x80a0,
	0x75, 0x1e, 0x10, 0xd2, 0x35, 0x22, 0xe5, 0x4b, 0x75, 0xf0, 0x05, 0x84, 0x78, 0xbc, 0xf6, 0x90, //0x80b0,
	0x0e, 0x8c, 0xe4, 0x93, 0xff, 0x25, 0xe0, 0x24, 0x0a, 0xf8, 0xe6, 0xfc, 0x08, 0xe6, 0xfd, 0x78, //0x80c0,
	0xbc, 0xe6, 0x25, 0xe0, 0x24, 0x4e, 0xf8, 0xa6, 0x04, 0x08, 0xa6, 0x05, 0xef, 0x12, 0x0f, 0x0b, //0x80d0,
	0xd3, 0x78, 0xb7, 0x96, 0xee, 0x18, 0x96, 0x40, 0x0d, 0x78, 0xbc, 0xe6, 0x78, 0xb9, 0xf6, 0x78, //0x80e0,
	0xb6, 0xa6, 0x06, 0x08, 0xa6, 0x07, 0x90, 0x0e, 0x8c, 0xe4, 0x93, 0x12, 0x0f, 0x0b, 0xc3, 0x78, //0x80f0,
	0xc2, 0x96, 0xee, 0x18, 0x96, 0x50, 0x0d, 0x78, 0xbc, 0xe6, 0x78, 0xba, 0xf6, 0x78, 0xc1, 0xa6, //0x8100,
	0x06, 0x08, 0xa6, 0x07, 0x78, 0xb6, 0xe6, 0xfe, 0x08, 0xe6, 0xc3, 0x78, 0xc2, 0x96, 0xff, 0xee, //0x8110,
	0x18, 0x96, 0x78, 0xc3, 0xf6, 0x08, 0xa6, 0x07, 0x90, 0x0e, 0x95, 0xe4, 0x18, 0x12, 0x0e, 0xe9, //0x8120,
	0x40, 0x02, 0xd2, 0x37, 0x78, 0xbc, 0xe6, 0x08, 0x26, 0x08, 0xf6, 0xe5, 0x1f, 0x64, 0x01, 0x70, //0x8130,
	0x4a, 0xe6, 0xc3, 0x78, 0xc0, 0x12, 0x0e, 0xdf, 0x40, 0x05, 0x12, 0x0e, 0xda, 0x40, 0x39, 0x12, //0x8140,
	0x0f, 0x02, 0x40, 0x04, 0x7f, 0xfe, 0x80, 0x02, 0x7f, 0x02, 0x78, 0xbd, 0xa6, 0x07, 0x78, 0xb9, //0x8150,
	0xe6, 0x24, 0x03, 0x78, 0xbf, 0xf6, 0x78, 0xb9, 0xe6, 0x24, 0xfd, 0x78, 0xc0, 0xf6, 0x12, 0x0f, //0x8160,
	0x02, 0x40, 0x06, 0x78, 0xc0, 0xe6, 0xff, 0x80, 0x04, 0x78, 0xbf, 0xe6, 0xff, 0x78, 0xbe, 0xa6, //0x8170,
	0x07, 0x75, 0x1f, 0x02, 0x78, 0xb8, 0x76, 0x01, 0x02, 0x02, 0x4a, 0xe5, 0x1f, 0x64, 0x02, 0x60, //0x8180,
	0x03, 0x02, 0x02, 0x2a, 0x78, 0xbe, 0xe6, 0xff, 0xc3, 0x78, 0xc0, 0x12, 0x0e, 0xe0, 0x40, 0x08, //0x8190,
	0x12, 0x0e, 0xda, 0x50, 0x03, 0x02, 0x02, 0x28, 0x12, 0x0f, 0x02, 0x40, 0x04, 0x7f, 0xff, 0x80, //0x81a0,
	0x02, 0x7f, 0x01, 0x78, 0xbd, 0xa6, 0x07, 0x78, 0xb9, 0xe6, 0x04, 0x78, 0xbf, 0xf6, 0x78, 0xb9, //0x81b0,
	0xe6, 0x14, 0x78, 0xc0, 0xf6, 0x18, 0x12, 0x0f, 0x04, 0x40, 0x04, 0xe6, 0xff, 0x80, 0x02, 0x7f, //0x81c0,
	0x00, 0x78, 0xbf, 0xa6, 0x07, 0xd3, 0x08, 0xe6, 0x64, 0x80, 0x94, 0x80, 0x40, 0x04, 0xe6, 0xff, //0x81d0,
	0x80, 0x02, 0x7f, 0x00, 0x78, 0xc0, 0xa6, 0x07, 0xc3, 0x18, 0xe6, 0x64, 0x80, 0x94, 0xb3, 0x50, //0x81e0,
	0x04, 0xe6, 0xff, 0x80, 0x02, 0x7f, 0x33, 0x78, 0xbf, 0xa6, 0x07, 0xc3, 0x08, 0xe6, 0x64, 0x80, //0x81f0,
	0x94, 0xb3, 0x50, 0x04, 0xe6, 0xff, 0x80, 0x02, 0x7f, 0x33, 0x78, 0xc0, 0xa6, 0x07, 0x12, 0x0f, //0x8200,
	0x02, 0x40, 0x06, 0x78, 0xc0, 0xe6, 0xff, 0x80, 0x04, 0x78, 0xbf, 0xe6, 0xff, 0x78, 0xbe, 0xa6, //0x8210,
	0x07, 0x75, 0x1f, 0x03, 0x78, 0xb8, 0x76, 0x01, 0x80, 0x20, 0xe5, 0x1f, 0x64, 0x03, 0x70, 0x26, //0x8220,
	0x78, 0xbe, 0xe6, 0xff, 0xc3, 0x78, 0xc0, 0x12, 0x0e, 0xe0, 0x40, 0x05, 0x12, 0x0e, 0xda, 0x40, //0x8230,
	0x09, 0x78, 0xb9, 0xe6, 0x78, 0xbe, 0xf6, 0x75, 0x1f, 0x04, 0x78, 0xbe, 0xe6, 0x75, 0xf0, 0x05, //0x8240,
	0xa4, 0xf5, 0x4b, 0x02, 0x0a, 0xff, 0xe5, 0x1f, 0xb4, 0x04, 0x10, 0x90, 0x0e, 0x94, 0xe4, 0x78, //0x8250,
	0xc3, 0x12, 0x0e, 0xe9, 0x40, 0x02, 0xd2, 0x37, 0x75, 0x1f, 0x05, 0x22, 0x30, 0x01, 0x03, 0x02, //0x8260,
	0x04, 0xc0, 0x30, 0x02, 0x03, 0x02, 0x04, 0xc0, 0x90, 0x51, 0xa5, 0xe0, 0x78, 0x93, 0xf6, 0xa3, //0x8270,
	0xe0, 0x08, 0xf6, 0xa3, 0xe0, 0x08, 0xf6, 0xe5, 0x1f, 0x70, 0x3c, 0x75, 0x1e, 0x20, 0xd2, 0x35, //0x8280,
	0x12, 0x0c, 0x7a, 0x78, 0x7e, 0xa6, 0x06, 0x08, 0xa6, 0x07, 0x78, 0x8b, 0xa6, 0x09, 0x18, 0x76, //0x8290,
	0x01, 0x12, 0x0c, 0x5b, 0x78, 0x4e, 0xa6, 0x06, 0x08, 0xa6, 0x07, 0x78, 0x8b, 0xe6, 0x78, 0x6e, //0x82a0,
	0xf6, 0x75, 0x1f, 0x01, 0x78, 0x93, 0xe6, 0x78, 0x90, 0xf6, 0x78, 0x94, 0xe6, 0x78, 0x91, 0xf6, //0x82b0,
	0x78, 0x95, 0xe6, 0x78, 0x92, 0xf6, 0x22, 0x79, 0x90, 0xe7, 0xd3, 0x78, 0x93, 0x96, 0x40, 0x05, //0x82c0,
	0xe7, 0x96, 0xff, 0x80, 0x08, 0xc3, 0x79, 0x93, 0xe7, 0x78, 0x90, 0x96, 0xff, 0x78, 0x88, 0x76, //0x82d0,
	0x00, 0x08, 0xa6, 0x07, 0x79, 0x91, 0xe7, 0xd3, 0x78, 0x94, 0x96, 0x40, 0x05, 0xe7, 0x96, 0xff, //0x82e0,
	0x80, 0x08, 0xc3, 0x79, 0x94, 0xe7, 0x78, 0x91, 0x96, 0xff, 0x12, 0x0c, 0x8e, 0x79, 0x92, 0xe7, //0x82f0,
	0xd3, 0x78, 0x95, 0x96, 0x40, 0x05, 0xe7, 0x96, 0xff, 0x80, 0x08, 0xc3, 0x79, 0x95, 0xe7, 0x78, //0x8300,
	0x92, 0x96, 0xff, 0x12, 0x0c, 0x8e, 0x12, 0x0c, 0x5b, 0x78, 0x8a, 0xe6, 0x25, 0xe0, 0x24, 0x4e, //0x8310,
	0xf8, 0xa6, 0x06, 0x08, 0xa6, 0x07, 0x78, 0x8a, 0xe6, 0x24, 0x6e, 0xf8, 0xa6, 0x09, 0x78, 0x8a, //0x8320,
	0xe6, 0x24, 0x01, 0xff, 0xe4, 0x33, 0xfe, 0xd3, 0xef, 0x94, 0x0f, 0xee, 0x64, 0x80, 0x94, 0x80, //0x8330,
	0x40, 0x04, 0x7f, 0x00, 0x80, 0x05, 0x78, 0x8a, 0xe6, 0x04, 0xff, 0x78, 0x8a, 0xa6, 0x07, 0xe5, //0x8340,
	0x1f, 0xb4, 0x01, 0x0a, 0xe6, 0x60, 0x03, 0x02, 0x04, 0xc0, 0x75, 0x1f, 0x02, 0x22, 0x12, 0x0c, //0x8350,
	0x7a, 0x78, 0x80, 0xa6, 0x06, 0x08, 0xa6, 0x07, 0x12, 0x0c, 0x7a, 0x78, 0x82, 0xa6, 0x06, 0x08, //0x8360,
	0xa6, 0x07, 0x78, 0x6e, 0xe6, 0x78, 0x8c, 0xf6, 0x78, 0x6e, 0xe6, 0x78, 0x8d, 0xf6, 0x7f, 0x01, //0x8370,
	0xef, 0x25, 0xe0, 0x24, 0x4f, 0xf9, 0xc3, 0x78, 0x81, 0xe6, 0x97, 0x18, 0xe6, 0x19, 0x97, 0x50, //0x8380,
	0x0a, 0x12, 0x0c, 0x82, 0x78, 0x80, 0xa6, 0x04, 0x08, 0xa6, 0x05, 0x74, 0x6e, 0x2f, 0xf9, 0x78, //0x8390,
	0x8c, 0xe6, 0xc3, 0x97, 0x50, 0x08, 0x74, 0x6e, 0x2f, 0xf8, 0xe6, 0x78, 0x8c, 0xf6, 0xef, 0x25, //0x83a0,
	0xe0, 0x24, 0x4f, 0xf9, 0xd3, 0x78, 0x83, 0xe6, 0x97, 0x18, 0xe6, 0x19, 0x97, 0x40, 0x0a, 0x12, //0x83b0,
	0x0c, 0x82, 0x78, 0x82, 0xa6, 0x04, 0x08, 0xa6, 0x05, 0x74, 0x6e, 0x2f, 0xf9, 0x78, 0x8d, 0xe6, //0x83c0,
	0xd3, 0x97, 0x40, 0x08, 0x74, 0x6e, 0x2f, 0xf8, 0xe6, 0x78, 0x8d, 0xf6, 0x0f, 0xef, 0x64, 0x10, //0x83d0,
	0x70, 0x9e, 0xc3, 0x79, 0x81, 0xe7, 0x78, 0x83, 0x96, 0xff, 0x19, 0xe7, 0x18, 0x96, 0x78, 0x84, //0x83e0,
	0xf6, 0x08, 0xa6, 0x07, 0xc3, 0x79, 0x8c, 0xe7, 0x78, 0x8d, 0x96, 0x08, 0xf6, 0xd3, 0x79, 0x81, //0x83f0,
	0xe7, 0x78, 0x7f, 0x96, 0x19, 0xe7, 0x18, 0x96, 0x40, 0x05, 0x09, 0xe7, 0x08, 0x80, 0x06, 0xc3, //0x8400,
	0x79, 0x7f, 0xe7, 0x78, 0x81, 0x96, 0xff, 0x19, 0xe7, 0x18, 0x96, 0xfe, 0x78, 0x86, 0xa6, 0x06, //0x8410,
	0x08, 0xa6, 0x07, 0x79, 0x8c, 0xe7, 0xd3, 0x78, 0x8b, 0x96, 0x40, 0x05, 0xe7, 0x96, 0xff, 0x80, //0x8420,
	0x08, 0xc3, 0x79, 0x8b, 0xe7, 0x78, 0x8c, 0x96, 0xff, 0x78, 0x8f, 0xa6, 0x07, 0xe5, 0x1f, 0x64, //0x8430,
	0x02, 0x70, 0x69, 0x90, 0x0e, 0x91, 0x93, 0xff, 0x18, 0xe6, 0xc3, 0x9f, 0x50, 0x72, 0x12, 0x0c, //0x8440,
	0x4a, 0x12, 0x0c, 0x2f, 0x90, 0x0e, 0x8e, 0x12, 0x0c, 0x38, 0x78, 0x80, 0x12, 0x0c, 0x6b, 0x7b, //0x8450,
	0x04, 0x12, 0x0c, 0x1d, 0xc3, 0x12, 0x06, 0x45, 0x50, 0x56, 0x90, 0x0e, 0x92, 0xe4, 0x93, 0xff, //0x8460,
	0x78, 0x8f, 0xe6, 0x9f, 0x40, 0x02, 0x80, 0x11, 0x90, 0x0e, 0x90, 0xe4, 0x93, 0xff, 0xd3, 0x78, //0x8470,
	0x89, 0xe6, 0x9f, 0x18, 0xe6, 0x94, 0x00, 0x40, 0x03, 0x75, 0x1f, 0x05, 0x12, 0x0c, 0x4a, 0x12, //0x8480,
	0x0c, 0x2f, 0x90, 0x0e, 0x8f, 0x12, 0x0c, 0x38, 0x78, 0x7e, 0x12, 0x0c, 0x6b, 0x7b, 0x40, 0x12, //0x8490,
	0x0c, 0x1d, 0xd3, 0x12, 0x06, 0x45, 0x40, 0x18, 0x75, 0x1f, 0x05, 0x22, 0xe5, 0x1f, 0xb4, 0x05, //0x84a0,
	0x0f, 0xd2, 0x01, 0xc2, 0x02, 0xe4, 0xf5, 0x1f, 0xf5, 0x1e, 0xd2, 0x35, 0xd2, 0x33, 0xd2, 0x36, //0x84b0,
	0x22, 0xef, 0x8d, 0xf0, 0xa4, 0xa8, 0xf0, 0xcf, 0x8c, 0xf0, 0xa4, 0x28, 0xce, 0x8d, 0xf0, 0xa4, //0x84c0,
	0x2e, 0xfe, 0x22, 0xbc, 0x00, 0x0b, 0xbe, 0x00, 0x29, 0xef, 0x8d, 0xf0, 0x84, 0xff, 0xad, 0xf0, //0x84d0,
	0x22, 0xe4, 0xcc, 0xf8, 0x75, 0xf0, 0x08, 0xef, 0x2f, 0xff, 0xee, 0x33, 0xfe, 0xec, 0x33, 0xfc, //0x84e0,
	0xee, 0x9d, 0xec, 0x98, 0x40, 0x05, 0xfc, 0xee, 0x9d, 0xfe, 0x0f, 0xd5, 0xf0, 0xe9, 0xe4, 0xce, //0x84f0,
	0xfd, 0x22, 0xed, 0xf8, 0xf5, 0xf0, 0xee, 0x84, 0x20, 0xd2, 0x1c, 0xfe, 0xad, 0xf0, 0x75, 0xf0, //0x8500,
	0x08, 0xef, 0x2f, 0xff, 0xed, 0x33, 0xfd, 0x40, 0x07, 0x98, 0x50, 0x06, 0xd5, 0xf0, 0xf2, 0x22, //0x8510,
	0xc3, 0x98, 0xfd, 0x0f, 0xd5, 0xf0, 0xea, 0x22, 0xe8, 0x8f, 0xf0, 0xa4, 0xcc, 0x8b, 0xf0, 0xa4, //0x8520,
	0x2c, 0xfc, 0xe9, 0x8e, 0xf0, 0xa4, 0x2c, 0xfc, 0x8a, 0xf0, 0xed, 0xa4, 0x2c, 0xfc, 0xea, 0x8e, //0x8530,
	0xf0, 0xa4, 0xcd, 0xa8, 0xf0, 0x8b, 0xf0, 0xa4, 0x2d, 0xcc, 0x38, 0x25, 0xf0, 0xfd, 0xe9, 0x8f, //0x8540,
	0xf0, 0xa4, 0x2c, 0xcd, 0x35, 0xf0, 0xfc, 0xeb, 0x8e, 0xf0, 0xa4, 0xfe, 0xa9, 0xf0, 0xeb, 0x8f, //0x8550,
	0xf0, 0xa4, 0xcf, 0xc5, 0xf0, 0x2e, 0xcd, 0x39, 0xfe, 0xe4, 0x3c, 0xfc, 0xea, 0xa4, 0x2d, 0xce, //0x8560,
	0x35, 0xf0, 0xfd, 0xe4, 0x3c, 0xfc, 0x22, 0x75, 0xf0, 0x08, 0x75, 0x82, 0x00, 0xef, 0x2f, 0xff, //0x8570,
	0xee, 0x33, 0xfe, 0xcd, 0x33, 0xcd, 0xcc, 0x33, 0xcc, 0xc5, 0x82, 0x33, 0xc5, 0x82, 0x9b, 0xed, //0x8580,
	0x9a, 0xec, 0x99, 0xe5, 0x82, 0x98, 0x40, 0x0c, 0xf5, 0x82, 0xee, 0x9b, 0xfe, 0xed, 0x9a, 0xfd, //0x8590,
	0xec, 0x99, 0xfc, 0x0f, 0xd5, 0xf0, 0xd6, 0xe4, 0xce, 0xfb, 0xe4, 0xcd, 0xfa, 0xe4, 0xcc, 0xf9, //0x85a0,
	0xa8, 0x82, 0x22, 0xb8, 0x00, 0xc1, 0xb9, 0x00, 0x59, 0xba, 0x00, 0x2d, 0xec, 0x8b, 0xf0, 0x84, //0x85b0,
	0xcf, 0xce, 0xcd, 0xfc, 0xe5, 0xf0, 0xcb, 0xf9, 0x78, 0x18, 0xef, 0x2f, 0xff, 0xee, 0x33, 0xfe, //0x85c0,
	0xed, 0x33, 0xfd, 0xec, 0x33, 0xfc, 0xeb, 0x33, 0xfb, 0x10, 0xd7, 0x03, 0x99, 0x40, 0x04, 0xeb, //0x85d0,
	0x99, 0xfb, 0x0f, 0xd8, 0xe5, 0xe4, 0xf9, 0xfa, 0x22, 0x78, 0x18, 0xef, 0x2f, 0xff, 0xee, 0x33, //0x85e0,
	0xfe, 0xed, 0x33, 0xfd, 0xec, 0x33, 0xfc, 0xc9, 0x33, 0xc9, 0x10, 0xd7, 0x05, 0x9b, 0xe9, 0x9a, //0x85f0,
	0x40, 0x07, 0xec, 0x9b, 0xfc, 0xe9, 0x9a, 0xf9, 0x0f, 0xd8, 0xe0, 0xe4, 0xc9, 0xfa, 0xe4, 0xcc, //0x8600,
	0xfb, 0x22, 0x75, 0xf0, 0x10, 0xef, 0x2f, 0xff, 0xee, 0x33, 0xfe, 0xed, 0x33, 0xfd, 0xcc, 0x33, //0x8610,
	0xcc, 0xc8, 0x33, 0xc8, 0x10, 0xd7, 0x07, 0x9b, 0xec, 0x9a, 0xe8, 0x99, 0x40, 0x0a, 0xed, 0x9b, //0x8620,
	0xfd, 0xec, 0x9a, 0xfc, 0xe8, 0x99, 0xf8, 0x0f, 0xd5, 0xf0, 0xda, 0xe4, 0xcd, 0xfb, 0xe4, 0xcc, //0x8630,
	0xfa, 0xe4, 0xc8, 0xf9, 0x22, 0xeb, 0x9f, 0xf5, 0xf0, 0xea, 0x9e, 0x42, 0xf0, 0xe9, 0x9d, 0x42, //0x8640,
	0xf0, 0xe8, 0x9c, 0x45, 0xf0, 0x22, 0xe8, 0x60, 0x0f, 0xec, 0xc3, 0x13, 0xfc, 0xed, 0x13, 0xfd, //0x8650,
	0xee, 0x13, 0xfe, 0xef, 0x13, 0xff, 0xd8, 0xf1, 0x22, 0xe8, 0x60, 0x0f, 0xef, 0xc3, 0x33, 0xff, //0x8660,
	0xee, 0x33, 0xfe, 0xed, 0x33, 0xfd, 0xec, 0x33, 0xfc, 0xd8, 0xf1, 0x22, 0xe4, 0x93, 0xfc, 0x74, //0x8670,
	0x01, 0x93, 0xfd, 0x74, 0x02, 0x93, 0xfe, 0x74, 0x03, 0x93, 0xff, 0x22, 0xe6, 0xfb, 0x08, 0xe6, //0x8680,
	0xf9, 0x08, 0xe6, 0xfa, 0x08, 0xe6, 0xcb, 0xf8, 0x22, 0xec, 0xf6, 0x08, 0xed, 0xf6, 0x08, 0xee, //0x8690,
	0xf6, 0x08, 0xef, 0xf6, 0x22, 0xa4, 0x25, 0x82, 0xf5, 0x82, 0xe5, 0xf0, 0x35, 0x83, 0xf5, 0x83, //0x86a0,
	0x22, 0xd0, 0x83, 0xd0, 0x82, 0xf8, 0xe4, 0x93, 0x70, 0x12, 0x74, 0x01, 0x93, 0x70, 0x0d, 0xa3, //0x86b0,
	0xa3, 0x93, 0xf8, 0x74, 0x01, 0x93, 0xf5, 0x82, 0x88, 0x83, 0xe4, 0x73, 0x74, 0x02, 0x93, 0x68, //0x86c0,
	0x60, 0xef, 0xa3, 0xa3, 0xa3, 0x80, 0xdf, 0x90, 0x38, 0x04, 0x78, 0x52, 0x12, 0x0b, 0xfd, 0x90, //0x86d0,
	0x38, 0x00, 0xe0, 0xfe, 0xa3, 0xe0, 0xfd, 0xed, 0xff, 0xc3, 0x12, 0x0b, 0x9e, 0x90, 0x38, 0x10, //0x86e0,
	0x12, 0x0b, 0x92, 0x90, 0x38, 0x06, 0x78, 0x54, 0x12, 0x0b, 0xfd, 0x90, 0x38, 0x02, 0xe0, 0xfe, //0x86f0,
	0xa3, 0xe0, 0xfd, 0xed, 0xff, 0xc3, 0x12, 0x0b, 0x9e, 0x90, 0x38, 0x12, 0x12, 0x0b, 0x92, 0xa3, //0x8700,
	0xe0, 0xb4, 0x31, 0x07, 0x78, 0x52, 0x79, 0x52, 0x12, 0x0c, 0x13, 0x90, 0x38, 0x14, 0xe0, 0xb4, //0x8710,
	0x71, 0x15, 0x78, 0x52, 0xe6, 0xfe, 0x08, 0xe6, 0x78, 0x02, 0xce, 0xc3, 0x13, 0xce, 0x13, 0xd8, //0x8720,
	0xf9, 0x79, 0x53, 0xf7, 0xee, 0x19, 0xf7, 0x90, 0x38, 0x15, 0xe0, 0xb4, 0x31, 0x07, 0x78, 0x54, //0x8730,
	0x79, 0x54, 0x12, 0x0c, 0x13, 0x90, 0x38, 0x15, 0xe0, 0xb4, 0x71, 0x15, 0x78, 0x54, 0xe6, 0xfe, //0x8740,
	0x08, 0xe6, 0x78, 0x02, 0xce, 0xc3, 0x13, 0xce, 0x13, 0xd8, 0xf9, 0x79, 0x55, 0xf7, 0xee, 0x19, //0x8750,
	0xf7, 0x79, 0x52, 0x12, 0x0b, 0xd9, 0x09, 0x12, 0x0b, 0xd9, 0xaf, 0x47, 0x12, 0x0b, 0xb2, 0xe5, //0x8760,
	0x44, 0xfb, 0x7a, 0x00, 0xfd, 0x7c, 0x00, 0x12, 0x04, 0xd3, 0x78, 0x5a, 0xa6, 0x06, 0x08, 0xa6, //0x8770,
	0x07, 0xaf, 0x45, 0x12, 0x0b, 0xb2, 0xad, 0x03, 0x7c, 0x00, 0x12, 0x04, 0xd3, 0x78, 0x56, 0xa6, //0x8780,
	0x06, 0x08, 0xa6, 0x07, 0xaf, 0x48, 0x78, 0x54, 0x12, 0x0b, 0xb4, 0xe5, 0x43, 0xfb, 0xfd, 0x7c, //0x8790,
	0x00, 0x12, 0x04, 0xd3, 0x78, 0x5c, 0xa6, 0x06, 0x08, 0xa6, 0x07, 0xaf, 0x46, 0x7e, 0x00, 0x78, //0x87a0,
	0x54, 0x12, 0x0b, 0xb6, 0xad, 0x03, 0x7c, 0x00, 0x12, 0x04, 0xd3, 0x78, 0x58, 0xa6, 0x06, 0x08, //0x87b0,
	0xa6, 0x07, 0xc3, 0x78, 0x5b, 0xe6, 0x94, 0x08, 0x18, 0xe6, 0x94, 0x00, 0x50, 0x05, 0x76, 0x00, //0x87c0,
	0x08, 0x76, 0x08, 0xc3, 0x78, 0x5d, 0xe6, 0x94, 0x08, 0x18, 0xe6, 0x94, 0x00, 0x50, 0x05, 0x76, //0x87d0,
	0x00, 0x08, 0x76, 0x08, 0x78, 0x5a, 0x12, 0x0b, 0xc6, 0xff, 0xd3, 0x78, 0x57, 0xe6, 0x9f, 0x18, //0x87e0,
	0xe6, 0x9e, 0x40, 0x0e, 0x78, 0x5a, 0xe6, 0x13, 0xfe, 0x08, 0xe6, 0x78, 0x57, 0x12, 0x0c, 0x08, //0x87f0,
	0x80, 0x04, 0x7e, 0x00, 0x7f, 0x00, 0x78, 0x5e, 0x12, 0x0b, 0xbe, 0xff, 0xd3, 0x78, 0x59, 0xe6, //0x8800,
	0x9f, 0x18, 0xe6, 0x9e, 0x40, 0x0e, 0x78, 0x5c, 0xe6, 0x13, 0xfe, 0x08, 0xe6, 0x78, 0x59, 0x12, //0x8810,
	0x0c, 0x08, 0x80, 0x04, 0x7e, 0x00, 0x7f, 0x00, 0xe4, 0xfc, 0xfd, 0x78, 0x62, 0x12, 0x06, 0x99, //0x8820,
	0x78, 0x5a, 0x12, 0x0b, 0xc6, 0x78, 0x57, 0x26, 0xff, 0xee, 0x18, 0x36, 0xfe, 0x78, 0x66, 0x12, //0x8830,
	0x0b, 0xbe, 0x78, 0x59, 0x26, 0xff, 0xee, 0x18, 0x36, 0xfe, 0xe4, 0xfc, 0xfd, 0x78, 0x6a, 0x12, //0x8840,
	0x06, 0x99, 0x12, 0x0b, 0xce, 0x78, 0x66, 0x12, 0x06, 0x8c, 0xd3, 0x12, 0x06, 0x45, 0x40, 0x08, //0x8850,
	0x12, 0x0b, 0xce, 0x78, 0x66, 0x12, 0x06, 0x99, 0x78, 0x54, 0x12, 0x0b, 0xd0, 0x78, 0x6a, 0x12, //0x8860,
	0x06, 0x8c, 0xd3, 0x12, 0x06, 0x45, 0x40, 0x0a, 0x78, 0x54, 0x12, 0x0b, 0xd0, 0x78, 0x6a, 0x12, //0x8870,
	0x06, 0x99, 0x78, 0x61, 0xe6, 0x90, 0x60, 0x01, 0xf0, 0x78, 0x65, 0xe6, 0xa3, 0xf0, 0x78, 0x69, //0x8880,
	0xe6, 0xa3, 0xf0, 0x78, 0x55, 0xe6, 0xa3, 0xf0, 0x7d, 0x01, 0x78, 0x61, 0x12, 0x0b, 0xe9, 0x24, //0x8890,
	0x01, 0x12, 0x0b, 0xa6, 0x78, 0x65, 0x12, 0x0b, 0xe9, 0x24, 0x02, 0x12, 0x0b, 0xa6, 0x78, 0x69, //0x88a0,
	0x12, 0x0b, 0xe9, 0x24, 0x03, 0x12, 0x0b, 0xa6, 0x78, 0x6d, 0x12, 0x0b, 0xe9, 0x24, 0x04, 0x12, //0x88b0,
	0x0b, 0xa6, 0x0d, 0xbd, 0x05, 0xd4, 0xc2, 0x0e, 0xc2, 0x06, 0x22, 0x85, 0x08, 0x41, 0x90, 0x30, //0x88c0,
	0x24, 0xe0, 0xf5, 0x3d, 0xa3, 0xe0, 0xf5, 0x3e, 0xa3, 0xe0, 0xf5, 0x3f, 0xa3, 0xe0, 0xf5, 0x40, //0x88d0,
	0xa3, 0xe0, 0xf5, 0x3c, 0xd2, 0x34, 0xe5, 0x41, 0x12, 0x06, 0xb1, 0x09, 0x31, 0x03, 0x09, 0x35, //0x88e0,
	0x04, 0x09, 0x3b, 0x05, 0x09, 0x3e, 0x06, 0x09, 0x41, 0x07, 0x09, 0x4a, 0x08, 0x09, 0x5b, 0x12, //0x88f0,
	0x09, 0x73, 0x18, 0x09, 0x89, 0x19, 0x09, 0x5e, 0x1a, 0x09, 0x6a, 0x1b, 0x09, 0xad, 0x80, 0x09, //0x8900,
	0xb2, 0x81, 0x0a, 0x1d, 0x8f, 0x0a, 0x09, 0x90, 0x0a, 0x1d, 0x91, 0x0a, 0x1d, 0x92, 0x0a, 0x1d, //0x8910,
	0x93, 0x0a, 0x1d, 0x94, 0x0a, 0x1d, 0x98, 0x0a, 0x17, 0x9f, 0x0a, 0x1a, 0xec, 0x00, 0x00, 0x0a, //0x8920,
	0x38, 0x12, 0x0f, 0x74, 0x22, 0x12, 0x0f, 0x74, 0xd2, 0x03, 0x22, 0xd2, 0x03, 0x22, 0xc2, 0x03, //0x8930,
	0x22, 0xa2, 0x37, 0xe4, 0x33, 0xf5, 0x3c, 0x02, 0x0a, 0x1d, 0xc2, 0x01, 0xc2, 0x02, 0xc2, 0x03, //0x8940,
	0x12, 0x0d, 0x0d, 0x75, 0x1e, 0x70, 0xd2, 0x35, 0x02, 0x0a, 0x1d, 0x02, 0x0a, 0x04, 0x85, 0x40, //0x8950,
	0x4a, 0x85, 0x3c, 0x4b, 0x12, 0x0a, 0xff, 0x02, 0x0a, 0x1d, 0x85, 0x4a, 0x40, 0x85, 0x4b, 0x3c, //0x8960,
	0x02, 0x0a, 0x1d, 0xe4, 0xf5, 0x22, 0xf5, 0x23, 0x85, 0x40, 0x31, 0x85, 0x3f, 0x30, 0x85, 0x3e, //0x8970,
	0x2f, 0x85, 0x3d, 0x2e, 0x12, 0x0f, 0x46, 0x80, 0x1f, 0x75, 0x22, 0x00, 0x75, 0x23, 0x01, 0x74, //0x8980,
	0xff, 0xf5, 0x2d, 0xf5, 0x2c, 0xf5, 0x2b, 0xf5, 0x2a, 0x12, 0x0f, 0x46, 0x85, 0x2d, 0x40, 0x85, //0x8990,
	0x2c, 0x3f, 0x85, 0x2b, 0x3e, 0x85, 0x2a, 0x3d, 0xe4, 0xf5, 0x3c, 0x80, 0x70, 0x12, 0x0f, 0x16, //0x89a0,
	0x80, 0x6b, 0x85, 0x3d, 0x45, 0x85, 0x3e, 0x46, 0xe5, 0x47, 0xc3, 0x13, 0xff, 0xe5, 0x45, 0xc3, //0x89b0,
	0x9f, 0x50, 0x02, 0x8f, 0x45, 0xe5, 0x48, 0xc3, 0x13, 0xff, 0xe5, 0x46, 0xc3, 0x9f, 0x50, 0x02, //0x89c0,
	0x8f, 0x46, 0xe5, 0x47, 0xc3, 0x13, 0xff, 0xfd, 0xe5, 0x45, 0x2d, 0xfd, 0xe4, 0x33, 0xfc, 0xe5, //0x89d0,
	0x44, 0x12, 0x0f, 0x90, 0x40, 0x05, 0xe5, 0x44, 0x9f, 0xf5, 0x45, 0xe5, 0x48, 0xc3, 0x13, 0xff, //0x89e0,
	0xfd, 0xe5, 0x46, 0x2d, 0xfd, 0xe4, 0x33, 0xfc, 0xe5, 0x43, 0x12, 0x0f, 0x90, 0x40, 0x05, 0xe5, //0x89f0,
	0x43, 0x9f, 0xf5, 0x46, 0x12, 0x06, 0xd7, 0x80, 0x14, 0x85, 0x40, 0x48, 0x85, 0x3f, 0x47, 0x85, //0x8a00,
	0x3e, 0x46, 0x85, 0x3d, 0x45, 0x80, 0x06, 0x02, 0x06, 0xd7, 0x12, 0x0d, 0x7e, 0x90, 0x30, 0x24, //0x8a10,
	0xe5, 0x3d, 0xf0, 0xa3, 0xe5, 0x3e, 0xf0, 0xa3, 0xe5, 0x3f, 0xf0, 0xa3, 0xe5, 0x40, 0xf0, 0xa3, //0x8a20,
	0xe5, 0x3c, 0xf0, 0x90, 0x30, 0x23, 0xe4, 0xf0, 0x22, 0xc0, 0xe0, 0xc0, 0x83, 0xc0, 0x82, 0xc0, //0x8a30,
	0xd0, 0x90, 0x3f, 0x0c, 0xe0, 0xf5, 0x32, 0xe5, 0x32, 0x30, 0xe3, 0x74, 0x30, 0x36, 0x66, 0x90, //0x8a40,
	0x60, 0x19, 0xe0, 0xf5, 0x0a, 0xa3, 0xe0, 0xf5, 0x0b, 0x90, 0x60, 0x1d, 0xe0, 0xf5, 0x14, 0xa3, //0x8a50,
	0xe0, 0xf5, 0x15, 0x90, 0x60, 0x21, 0xe0, 0xf5, 0x0c, 0xa3, 0xe0, 0xf5, 0x0d, 0x90, 0x60, 0x29, //0x8a60,
	0xe0, 0xf5, 0x0e, 0xa3, 0xe0, 0xf5, 0x0f, 0x90, 0x60, 0x31, 0xe0, 0xf5, 0x10, 0xa3, 0xe0, 0xf5, //0x8a70,
	0x11, 0x90, 0x60, 0x39, 0xe0, 0xf5, 0x12, 0xa3, 0xe0, 0xf5, 0x13, 0x30, 0x01, 0x06, 0x30, 0x33, //0x8a80,
	0x03, 0xd3, 0x80, 0x01, 0xc3, 0x92, 0x09, 0x30, 0x02, 0x06, 0x30, 0x33, 0x03, 0xd3, 0x80, 0x01, //0x8a90,
	0xc3, 0x92, 0x0a, 0x30, 0x33, 0x0c, 0x30, 0x03, 0x09, 0x20, 0x02, 0x06, 0x20, 0x01, 0x03, 0xd3, //0x8aa0,
	0x80, 0x01, 0xc3, 0x92, 0x0b, 0x90, 0x30, 0x01, 0xe0, 0x44, 0x40, 0xf0, 0xe0, 0x54, 0xbf, 0xf0, //0x8ab0,
	0xe5, 0x32, 0x30, 0xe1, 0x14, 0x30, 0x34, 0x11, 0x90, 0x30, 0x22, 0xe0, 0xf5, 0x08, 0xe4, 0xf0, //0x8ac0,
	0x30, 0x00, 0x03, 0xd3, 0x80, 0x01, 0xc3, 0x92, 0x08, 0xe5, 0x32, 0x30, 0xe5, 0x12, 0x90, 0x56, //0x8ad0,
	0xa1, 0xe0, 0xf5, 0x09, 0x30, 0x31, 0x09, 0x30, 0x05, 0x03, 0xd3, 0x80, 0x01, 0xc3, 0x92, 0x0d, //0x8ae0,
	0x90, 0x3f, 0x0c, 0xe5, 0x32, 0xf0, 0xd0, 0xd0, 0xd0, 0x82, 0xd0, 0x83, 0xd0, 0xe0, 0x32, 0x90, //0x8af0,
	0x0e, 0x7e, 0xe4, 0x93, 0xfe, 0x74, 0x01, 0x93, 0xff, 0xc3, 0x90, 0x0e, 0x7c, 0x74, 0x01, 0x93, //0x8b00,
	0x9f, 0xff, 0xe4, 0x93, 0x9e, 0xfe, 0xe4, 0x8f, 0x3b, 0x8e, 0x3a, 0xf5, 0x39, 0xf5, 0x38, 0xab, //0x8b10,
	0x3b, 0xaa, 0x3a, 0xa9, 0x39, 0xa8, 0x38, 0xaf, 0x4b, 0xfc, 0xfd, 0xfe, 0x12, 0x05, 0x28, 0x12, //0x8b20,
	0x0d, 0xe1, 0xe4, 0x7b, 0xff, 0xfa, 0xf9, 0xf8, 0x12, 0x05, 0xb3, 0x12, 0x0d, 0xe1, 0x90, 0x0e, //0x8b30,
	0x69, 0xe4, 0x12, 0x0d, 0xf6, 0x12, 0x0d, 0xe1, 0xe4, 0x85, 0x4a, 0x37, 0xf5, 0x36, 0xf5, 0x35, //0x8b40,
	0xf5, 0x34, 0xaf, 0x37, 0xae, 0x36, 0xad, 0x35, 0xac, 0x34, 0xa3, 0x12, 0x0d, 0xf6, 0x8f, 0x37, //0x8b50,
	0x8e, 0x36, 0x8d, 0x35, 0x8c, 0x34, 0xe5, 0x3b, 0x45, 0x37, 0xf5, 0x3b, 0xe5, 0x3a, 0x45, 0x36, //0x8b60,
	0xf5, 0x3a, 0xe5, 0x39, 0x45, 0x35, 0xf5, 0x39, 0xe5, 0x38, 0x45, 0x34, 0xf5, 0x38, 0xe4, 0xf5, //0x8b70,
	0x22, 0xf5, 0x23, 0x85, 0x3b, 0x31, 0x85, 0x3a, 0x30, 0x85, 0x39, 0x2f, 0x85, 0x38, 0x2e, 0x02, //0x8b80,
	0x0f, 0x46, 0xe0, 0xa3, 0xe0, 0x75, 0xf0, 0x02, 0xa4, 0xff, 0xae, 0xf0, 0xc3, 0x08, 0xe6, 0x9f, //0x8b90,
	0xf6, 0x18, 0xe6, 0x9e, 0xf6, 0x22, 0xff, 0xe5, 0xf0, 0x34, 0x60, 0x8f, 0x82, 0xf5, 0x83, 0xec, //0x8ba0,
	0xf0, 0x22, 0x78, 0x52, 0x7e, 0x00, 0xe6, 0xfc, 0x08, 0xe6, 0xfd, 0x02, 0x04, 0xc1, 0xe4, 0xfc, //0x8bb0,
	0xfd, 0x12, 0x06, 0x99, 0x78, 0x5c, 0xe6, 0xc3, 0x13, 0xfe, 0x08, 0xe6, 0x13, 0x22, 0x78, 0x52, //0x8bc0,
	0xe6, 0xfe, 0x08, 0xe6, 0xff, 0xe4, 0xfc, 0xfd, 0x22, 0xe7, 0xc4, 0xf8, 0x54, 0xf0, 0xc8, 0x68, //0x8bd0,
	0xf7, 0x09, 0xe7, 0xc4, 0x54, 0x0f, 0x48, 0xf7, 0x22, 0xe6, 0xfc, 0xed, 0x75, 0xf0, 0x04, 0xa4, //0x8be0,
	0x22, 0x12, 0x06, 0x7c, 0x8f, 0x48, 0x8e, 0x47, 0x8d, 0x46, 0x8c, 0x45, 0x22, 0xe0, 0xfe, 0xa3, //0x8bf0,
	0xe0, 0xfd, 0xee, 0xf6, 0xed, 0x08, 0xf6, 0x22, 0x13, 0xff, 0xc3, 0xe6, 0x9f, 0xff, 0x18, 0xe6, //0x8c00,
	0x9e, 0xfe, 0x22, 0xe6, 0xc3, 0x13, 0xf7, 0x08, 0xe6, 0x13, 0x09, 0xf7, 0x22, 0xad, 0x39, 0xac, //0x8c10,
	0x38, 0xfa, 0xf9, 0xf8, 0x12, 0x05, 0x28, 0x8f, 0x3b, 0x8e, 0x3a, 0x8d, 0x39, 0x8c, 0x38, 0xab, //0x8c20,
	0x37, 0xaa, 0x36, 0xa9, 0x35, 0xa8, 0x34, 0x22, 0x93, 0xff, 0xe4, 0xfc, 0xfd, 0xfe, 0x12, 0x05, //0x8c30,
	0x28, 0x8f, 0x37, 0x8e, 0x36, 0x8d, 0x35, 0x8c, 0x34, 0x22, 0x78, 0x84, 0xe6, 0xfe, 0x08, 0xe6, //0x8c40,
	0xff, 0xe4, 0x8f, 0x37, 0x8e, 0x36, 0xf5, 0x35, 0xf5, 0x34, 0x22, 0x90, 0x0e, 0x8c, 0xe4, 0x93, //0x8c50,
	0x25, 0xe0, 0x24, 0x0a, 0xf8, 0xe6, 0xfe, 0x08, 0xe6, 0xff, 0x22, 0xe6, 0xfe, 0x08, 0xe6, 0xff, //0x8c60,
	0xe4, 0x8f, 0x3b, 0x8e, 0x3a, 0xf5, 0x39, 0xf5, 0x38, 0x22, 0x78, 0x4e, 0xe6, 0xfe, 0x08, 0xe6, //0x8c70,
	0xff, 0x22, 0xef, 0x25, 0xe0, 0x24, 0x4e, 0xf8, 0xe6, 0xfc, 0x08, 0xe6, 0xfd, 0x22, 0x78, 0x89, //0x8c80,
	0xef, 0x26, 0xf6, 0x18, 0xe4, 0x36, 0xf6, 0x22, 0x75, 0x89, 0x03, 0x75, 0xa8, 0x01, 0x75, 0xb8, //0x8c90,
	0x04, 0x75, 0x34, 0xff, 0x75, 0x35, 0x0e, 0x75, 0x36, 0x15, 0x75, 0x37, 0x0d, 0x12, 0x0e, 0x9a, //0x8ca0,
	0x12, 0x00, 0x09, 0x12, 0x0f, 0x16, 0x12, 0x00, 0x06, 0xd2, 0x00, 0xd2, 0x34, 0xd2, 0xaf, 0x75, //0x8cb0,
	0x34, 0xff, 0x75, 0x35, 0x0e, 0x75, 0x36, 0x49, 0x75, 0x37, 0x03, 0x12, 0x0e, 0x9a, 0x30, 0x08, //0x8cc0,
	0x09, 0xc2, 0x34, 0x12, 0x08, 0xcb, 0xc2, 0x08, 0xd2, 0x34, 0x30, 0x0b, 0x09, 0xc2, 0x36, 0x12, //0x8cd0,
	0x02, 0x6c, 0xc2, 0x0b, 0xd2, 0x36, 0x30, 0x09, 0x09, 0xc2, 0x36, 0x12, 0x00, 0x0e, 0xc2, 0x09, //0x8ce0,
	0xd2, 0x36, 0x30, 0x0e, 0x03, 0x12, 0x06, 0xd7, 0x30, 0x35, 0xd3, 0x90, 0x30, 0x29, 0xe5, 0x1e, //0x8cf0,
	0xf0, 0xb4, 0x10, 0x05, 0x90, 0x30, 0x23, 0xe4, 0xf0, 0xc2, 0x35, 0x80, 0xc1, 0xe4, 0xf5, 0x4b, //0x8d00,
	0x90, 0x0e, 0x7a, 0x93, 0xff, 0xe4, 0x8f, 0x37, 0xf5, 0x36, 0xf5, 0x35, 0xf5, 0x34, 0xaf, 0x37, //0x8d10,
	0xae, 0x36, 0xad, 0x35, 0xac, 0x34, 0x90, 0x0e, 0x6a, 0x12, 0x0d, 0xf6, 0x8f, 0x37, 0x8e, 0x36, //0x8d20,
	0x8d, 0x35, 0x8c, 0x34, 0x90, 0x0e, 0x72, 0x12, 0x06, 0x7c, 0xef, 0x45, 0x37, 0xf5, 0x37, 0xee, //0x8d30,
	0x45, 0x36, 0xf5, 0x36, 0xed, 0x45, 0x35, 0xf5, 0x35, 0xec, 0x45, 0x34, 0xf5, 0x34, 0xe4, 0xf5, //0x8d40,
	0x22, 0xf5, 0x23, 0x85, 0x37, 0x31, 0x85, 0x36, 0x30, 0x85, 0x35, 0x2f, 0x85, 0x34, 0x2e, 0x12, //0x8d50,
	0x0f, 0x46, 0xe4, 0xf5, 0x22, 0xf5, 0x23, 0x90, 0x0e, 0x72, 0x12, 0x0d, 0xea, 0x12, 0x0f, 0x46, //0x8d60,
	0xe4, 0xf5, 0x22, 0xf5, 0x23, 0x90, 0x0e, 0x6e, 0x12, 0x0d, 0xea, 0x02, 0x0f, 0x46, 0xe5, 0x40, //0x8d70,
	0x24, 0xf2, 0xf5, 0x37, 0xe5, 0x3f, 0x34, 0x43, 0xf5, 0x36, 0xe5, 0x3e, 0x34, 0xa2, 0xf5, 0x35, //0x8d80,
	0xe5, 0x3d, 0x34, 0x28, 0xf5, 0x34, 0xe5, 0x37, 0xff, 0xe4, 0xfe, 0xfd, 0xfc, 0x78, 0x18, 0x12, //0x8d90,
	0x06, 0x69, 0x8f, 0x40, 0x8e, 0x3f, 0x8d, 0x3e, 0x8c, 0x3d, 0xe5, 0x37, 0x54, 0xa0, 0xff, 0xe5, //0x8da0,
	0x36, 0xfe, 0xe4, 0xfd, 0xfc, 0x78, 0x07, 0x12, 0x06, 0x56, 0x78, 0x10, 0x12, 0x0f, 0x9a, 0xe4, //0x8db0,
	0xff, 0xfe, 0xe5, 0x35, 0xfd, 0xe4, 0xfc, 0x78, 0x0e, 0x12, 0x06, 0x56, 0x12, 0x0f, 0x9d, 0xe4, //0x8dc0,
	0xff, 0xfe, 0xfd, 0xe5, 0x34, 0xfc, 0x78, 0x18, 0x12, 0x06, 0x56, 0x78, 0x08, 0x12, 0x0f, 0x9a, //0x8dd0,
	0x22, 0x8f, 0x3b, 0x8e, 0x3a, 0x8d, 0x39, 0x8c, 0x38, 0x22, 0x12, 0x06, 0x7c, 0x8f, 0x31, 0x8e, //0x8de0,
	0x30, 0x8d, 0x2f, 0x8c, 0x2e, 0x22, 0x93, 0xf9, 0xf8, 0x02, 0x06, 0x69, 0x00, 0x00, 0x00, 0x00, //0x8df0,
	0x12, 0x01, 0x17, 0x08, 0x31, 0x15, 0x53, 0x54, 0x44, 0x20, 0x20, 0x20, 0x20, 0x20, 0x13, 0x01, //0x8e00,
	0x10, 0x01, 0x56, 0x40, 0x1a, 0x30, 0x29, 0x7e, 0x00, 0x30, 0x04, 0x20, 0xdf, 0x30, 0x05, 0x40, //0x8e10,
	0xbf, 0x50, 0x03, 0x00, 0xfd, 0x50, 0x27, 0x01, 0xfe, 0x60, 0x00, 0x11, 0x00, 0x3f, 0x05, 0x30, //0x8e20,
	0x00, 0x3f, 0x06, 0x22, 0x00, 0x3f, 0x01, 0x2a, 0x00, 0x3f, 0x02, 0x00, 0x00, 0x36, 0x06, 0x07, //0x8e30,
	0x00, 0x3f, 0x0b, 0x0f, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x30, 0x01, 0x40, 0xbf, 0x30, 0x01, 0x00, //0x8e40,
	0xbf, 0x30, 0x29, 0x70, 0x00, 0x3a, 0x00, 0x00, 0xff, 0x3a, 0x00, 0x00, 0xff, 0x36, 0x03, 0x36, //0x8e50,
	0x02, 0x41, 0x44, 0x58, 0x20, 0x18, 0x10, 0x0a, 0x04, 0x04, 0x00, 0x03, 0xff, 0x64, 0x00, 0x00, //0x8e60,
	0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0x04, 0x06, 0x06, 0x00, 0x03, 0x51, 0x00, 0x7a, //0x8e70,
	0x50, 0x3c, 0x28, 0x1e, 0x10, 0x10, 0x50, 0x2d, 0x28, 0x16, 0x10, 0x10, 0x02, 0x00, 0x10, 0x0c, //0x8e80,
	0x10, 0x04, 0x0c, 0x6e, 0x06, 0x05, 0x00, 0xa5, 0x5a, 0x00, 0xae, 0x35, 0xaf, 0x36, 0xe4, 0xfd, //0x8e90,
	0xed, 0xc3, 0x95, 0x37, 0x50, 0x33, 0x12, 0x0f, 0xe2, 0xe4, 0x93, 0xf5, 0x38, 0x74, 0x01, 0x93, //0x8ea0,
	0xf5, 0x39, 0x45, 0x38, 0x60, 0x23, 0x85, 0x39, 0x82, 0x85, 0x38, 0x83, 0xe0, 0xfc, 0x12, 0x0f, //0x8eb0,
	0xe2, 0x74, 0x03, 0x93, 0x52, 0x04, 0x12, 0x0f, 0xe2, 0x74, 0x02, 0x93, 0x42, 0x04, 0x85, 0x39, //0x8ec0,
	0x82, 0x85, 0x38, 0x83, 0xec, 0xf0, 0x0d, 0x80, 0xc7, 0x22, 0x78, 0xbe, 0xe6, 0xd3, 0x08, 0xff, //0x8ed0,
	0xe6, 0x64, 0x80, 0xf8, 0xef, 0x64, 0x80, 0x98, 0x22, 0x93, 0xff, 0x7e, 0x00, 0xe6, 0xfc, 0x08, //0x8ee0,
	0xe6, 0xfd, 0x12, 0x04, 0xc1, 0x78, 0xc1, 0xe6, 0xfc, 0x08, 0xe6, 0xfd, 0xd3, 0xef, 0x9d, 0xee, //0x8ef0,
	0x9c, 0x22, 0x78, 0xbd, 0xd3, 0xe6, 0x64, 0x80, 0x94, 0x80, 0x22, 0x25, 0xe0, 0x24, 0x0a, 0xf8, //0x8f00,
	0xe6, 0xfe, 0x08, 0xe6, 0xff, 0x22, 0xe5, 0x3c, 0xd3, 0x94, 0x00, 0x40, 0x0b, 0x90, 0x0e, 0x88, //0x8f10,
	0x12, 0x0b, 0xf1, 0x90, 0x0e, 0x86, 0x80, 0x09, 0x90, 0x0e, 0x82, 0x12, 0x0b, 0xf1, 0x90, 0x0e, //0x8f20,
	0x80, 0xe4, 0x93, 0xf5, 0x44, 0xa3, 0xe4, 0x93, 0xf5, 0x43, 0xd2, 0x06, 0x30, 0x06, 0x03, 0xd3, //0x8f30,
	0x80, 0x01, 0xc3, 0x92, 0x0e, 0x22, 0xa2, 0xaf, 0x92, 0x32, 0xc2, 0xaf, 0xe5, 0x23, 0x45, 0x22, //0x8f40,
	0x90, 0x0e, 0x5d, 0x60, 0x0e, 0x12, 0x0f, 0xcb, 0xe0, 0xf5, 0x2c, 0x12, 0x0f, 0xc8, 0xe0, 0xf5, //0x8f50,
	0x2d, 0x80, 0x0c, 0x12, 0x0f, 0xcb, 0xe5, 0x30, 0xf0, 0x12, 0x0f, 0xc8, 0xe5, 0x31, 0xf0, 0xa2, //0x8f60,
	0x32, 0x92, 0xaf, 0x22, 0xd2, 0x01, 0xc2, 0x02, 0xe4, 0xf5, 0x1f, 0xf5, 0x1e, 0xd2, 0x35, 0xd2, //0x8f70,
	0x33, 0xd2, 0x36, 0xd2, 0x01, 0xc2, 0x02, 0xf5, 0x1f, 0xf5, 0x1e, 0xd2, 0x35, 0xd2, 0x33, 0x22, //0x8f80,
	0xfb, 0xd3, 0xed, 0x9b, 0x74, 0x80, 0xf8, 0x6c, 0x98, 0x22, 0x12, 0x06, 0x69, 0xe5, 0x40, 0x2f, //0x8f90,
	0xf5, 0x40, 0xe5, 0x3f, 0x3e, 0xf5, 0x3f, 0xe5, 0x3e, 0x3d, 0xf5, 0x3e, 0xe5, 0x3d, 0x3c, 0xf5, //0x8fa0,
	0x3d, 0x22, 0xc0, 0xe0, 0xc0, 0x83, 0xc0, 0x82, 0x90, 0x3f, 0x0d, 0xe0, 0xf5, 0x33, 0xe5, 0x33, //0x8fb0,
	0xf0, 0xd0, 0x82, 0xd0, 0x83, 0xd0, 0xe0, 0x32, 0x90, 0x0e, 0x5f, 0xe4, 0x93, 0xfe, 0x74, 0x01, //0x8fc0,
	0x93, 0xf5, 0x82, 0x8e, 0x83, 0x22, 0x78, 0x7f, 0xe4, 0xf6, 0xd8, 0xfd, 0x75, 0x81, 0xcd, 0x02, //0x8fd0,
	0x0c, 0x98, 0x8f, 0x82, 0x8e, 0x83, 0x75, 0xf0, 0x04, 0xed, 0x02, 0x06, 0xa5,                   //0x8fe0
}; 


const static uint8_t OV5640_LIGHTMODE_TBL[5][7]=
{ 
    0x04,0X00,0X04,0X00,0X04,0X00,0X00,//Auto
    0x06,0X1C,0X04,0X00,0X04,0XF3,0X01,//Sunny,
    0x05,0X48,0X04,0X00,0X07,0XCF,0X01,//Office,
    0x06,0X48,0X04,0X00,0X04,0XD3,0X01,//Cloudy,
    0x04,0X10,0X04,0X00,0X08,0X40,0X01,//Home,
};


const static uint8_t OV5640_SATURATION_TBL[7][6]=
{ 
    0X0C,0x30,0X3D,0X3E,0X3D,0X01,//-3 
    0X10,0x3D,0X4D,0X4E,0X4D,0X01,//-2	
    0X15,0x52,0X66,0X68,0X66,0X02,//-1	
    0X1A,0x66,0X80,0X82,0X80,0X02,//+0	
    0X1F,0x7A,0X9A,0X9C,0X9A,0X02,//+1	
    0X24,0x8F,0XB3,0XB6,0XB3,0X03,//+2
    0X2B,0xAB,0XD6,0XDA,0XD6,0X04,//+3
};


void OV5640_Delay1( __IO uint32_t x)
{
    uint32_t j;	
    uint32_t i;
    for(j=0;j<x;j++)
    {
        for(i=0;i<50000;i++);       
    }    
}

void OV5640_Delay(void)
{
    uint32_t i;
    for(i=0;i<500;i++);
}




static void SCCB_Start(void)
{
    SCCB_SDA_H;     
    SCCB_SCL_H;    
    OV5640_Delay();
    SCCB_SDA_L;
    OV5640_Delay();
    SCCB_SCL_L;    
}


static void SCCB_Stop(void)
{
    SCCB_SDA_L;
    OV5640_Delay();
    SCCB_SCL_H;
    OV5640_Delay();
    SCCB_SDA_H;
    OV5640_Delay();
}


static void SCCB_No_Ack(void)
{
    OV5640_Delay();
    SCCB_SDA_H;
    SCCB_SCL_H;
    OV5640_Delay();
    SCCB_SCL_L;
    OV5640_Delay();
    SCCB_SDA_L;
    OV5640_Delay();
}


static uint8_t SCCB_WR_Byte(uint8_t dat)
{
    uint8_t j,res;	 
    for(j=0;j<8;j++) 
    {
        if(dat&0x80)
        {
            SCCB_SDA_H;
        }
        else
        {
            SCCB_SDA_L;
        }
        dat<<=1;
        OV5640_Delay();
        SCCB_SCL_H;
        OV5640_Delay();
        SCCB_SCL_L;
    } 
    SCCB_SDA_IN();    
    OV5640_Delay();
    SCCB_SCL_H;    
    OV5640_Delay();
    if(SCCB_READ_SDA)
    {
        res=1;  
    }
    else
    {
        res=0;         
    }
    SCCB_SCL_L;
    SCCB_SDA_OUT();   
    return res;  
}


static uint8_t SCCB_RD_Byte(void)
{
    u8 temp=0,j;    
    SCCB_SDA_IN();     
    for(j=8;j>0;j--)    
    {
        OV5640_Delay();
        SCCB_SCL_H;
        temp=temp<<1;
        if(SCCB_READ_SDA)temp++;   
        OV5640_Delay();
        SCCB_SCL_L;
    }
    SCCB_SDA_OUT();     
    return temp;
}



static uint8_t OV5640_RD_Reg(uint16_t reg)
{
    uint8_t val=0;
    SCCB_Start();              
    SCCB_WR_Byte(OV5640_ADDR);  
    SCCB_WR_Byte(reg>>8);       
    SCCB_WR_Byte(reg);          
    SCCB_Stop();   

    SCCB_Start();
    SCCB_WR_Byte(OV5640_ADDR|0X01); 
    val=SCCB_RD_Byte();             
    SCCB_No_Ack();
    SCCB_Stop();
    return val;
}


static uint8_t OV5640_WR_Reg(uint16_t reg,uint8_t data)
{
    uint8_t res=0;
    SCCB_Start();                      
    if(SCCB_WR_Byte(OV5640_ADDR))res=1;   
    if(SCCB_WR_Byte(reg>>8))res=1;      
    if(SCCB_WR_Byte(reg))res=1;           
    if(SCCB_WR_Byte(data))res=1;         
    SCCB_Stop();
    return	res;
}

uint8_t OV5640_Init(void)
{
    uint16_t i=0;
    uint16_t reg=0;
    
    GPIO_ResetBits(CAMERA_RST_PORT, CAMERA_RST );   
    OV5640_Delay1(41);
    
    GPIO_SetBits(CAMERA_RST_PORT, CAMERA_RST ); 
    OV5640_Delay1(41);

    reg=OV5640_RD_Reg(OV5640_CHIPIDH);	
    reg<<=8;
    reg|=OV5640_RD_Reg(OV5640_CHIPIDL);	
    printf("\n\r camera ID : 0x%x\n\r", reg);
    if(reg!=OV5640_ID)
    {
        return 1;
    } 
    
    OV5640_WR_Reg(0x3103,0X11); //system clock from pad, bit[1]
    OV5640_WR_Reg(0X3008,0X82); //software reset, 
    OV5640_Delay1(10);
   
    for(i=0;i<(sizeof(ov5640_init_reg_tb)/sizeof(ov5640_init_reg_tb[0]));i++)
    {
        OV5640_WR_Reg(ov5640_init_reg_tb[i][0],ov5640_init_reg_tb[i][1]);
    }    
    OV5640_Delay1(50);
    
    return 0x00;         //ok    
    
}
void OV5640_InitPort(void)
{
    GPIO_InitType GPIO_InitStructure;

    /* Enable GPIO and AFIO clock */
    RCC_EnableAHB1PeriphClk(RCC_AHB_PERIPHEN_GPIOA | RCC_AHB_PERIPHEN_GPIOB | RCC_AHB_PERIPHEN_GPIOC | RCC_AHB_PERIPHEN_GPIOE | RCC_AHB_PERIPHEN_GPIOG |RCC_AHB_PERIPHEN_GPIOH, ENABLE);
    RCC_EnableAPB2PeriphClk(RCC_APB2_PERIPH_AFIO, ENABLE);  

    GPIO_InitStruct(&GPIO_InitStructure);
    
    /*DVP Pin*/
    /*DVP_HSYNC*/
    GPIO_InitStructure.GPIO_Mode  = GPIO_MODE_INPUT;    
    GPIO_InitStructure.Pin = DVP_MODULE_REMAP0_HSYNC_PIN;
    GPIO_InitStructure.GPIO_Alternate  = DVP_MODULE_REMAP0_HSYNC_AF;          
    GPIO_InitPeripheral(DVP_MODULE_REMAP0_HSYNC_PORT,&GPIO_InitStructure);
    AFIO_ConfigPinAnalogSignalChannel(DVP_MODULE_REMAP0_HSYNC_PORT, DVP_MODULE_REMAP0_HSYNC_PIN,DISABLE);
    
    /*DVP_YSYNC*/
    GPIO_InitStructure.Pin = DVP_MODULE_REMAP0_VSYNC_PIN;
    GPIO_InitStructure.GPIO_Alternate  = DVP_MODULE_REMAP0_VSYNC_AF;         
    GPIO_InitPeripheral(DVP_MODULE_REMAP0_VSYNC_PORT,&GPIO_InitStructure);
    AFIO_ConfigPinAnalogSignalChannel(DVP_MODULE_REMAP0_VSYNC_PORT, DVP_MODULE_REMAP0_VSYNC_PIN,DISABLE);
                                                                          
    /*DVP_PIXCLK*/
    GPIO_InitStructure.Pin = DVP_MODULE_REMAP0_PCLK_PIN;                  
    GPIO_InitStructure.GPIO_Alternate  = DVP_MODULE_REMAP0_PCLK_AF;       
    GPIO_InitPeripheral(DVP_MODULE_REMAP0_PCLK_PORT,&GPIO_InitStructure);
    AFIO_ConfigPinAnalogSignalChannel(DVP_MODULE_REMAP0_PCLK_PORT, DVP_MODULE_REMAP0_PCLK_PIN,DISABLE);                                                                          
                                                                          
    /*DVP_D0*/
    GPIO_InitStructure.Pin = DVP_MODULE_REMAP0_DATA0_PIN;                 
    GPIO_InitStructure.GPIO_Alternate  = DVP_MODULE_REMAP0_DATA0_AF;      
    GPIO_InitPeripheral(DVP_MODULE_REMAP0_DATA0_PORT,&GPIO_InitStructure);
    AFIO_ConfigPinAnalogSignalChannel(DVP_MODULE_REMAP0_DATA0_PORT, DVP_MODULE_REMAP0_DATA0_PIN,DISABLE);
                                                                          
    /*DVP_D1*/
    GPIO_InitStructure.Pin = DVP_MODULE_REMAP0_DATA1_PIN;                 
    GPIO_InitStructure.GPIO_Alternate  = DVP_MODULE_REMAP0_DATA1_AF;      
    GPIO_InitPeripheral(DVP_MODULE_REMAP0_DATA1_PORT,&GPIO_InitStructure);
    AFIO_ConfigPinAnalogSignalChannel(DVP_MODULE_REMAP0_DATA1_PORT, DVP_MODULE_REMAP0_DATA1_PIN,DISABLE);
                                                                          
    /*DVP_D2*/
    GPIO_InitStructure.Pin = DVP_MODULE_REMAP0_DATA2_PIN;                 
    GPIO_InitStructure.GPIO_Alternate  = DVP_MODULE_REMAP0_DATA2_AF;      
    GPIO_InitPeripheral(DVP_MODULE_REMAP0_DATA2_PORT,&GPIO_InitStructure);
    AFIO_ConfigPinAnalogSignalChannel(DVP_MODULE_REMAP0_DATA2_PORT, DVP_MODULE_REMAP0_DATA2_PIN,DISABLE);

    /*DVP_D3*/
    GPIO_InitStructure.Pin = DVP_MODULE_REMAP0_DATA3_PIN;
    GPIO_InitStructure.GPIO_Alternate  = DVP_MODULE_REMAP0_DATA3_AF;              
    GPIO_InitPeripheral(DVP_MODULE_REMAP0_DATA3_PORT,&GPIO_InitStructure);	
    AFIO_ConfigPinAnalogSignalChannel(DVP_MODULE_REMAP0_DATA3_PORT, DVP_MODULE_REMAP0_DATA3_PIN,DISABLE);

    /*DVP_D4*/
    GPIO_InitStructure.Pin = DVP_MODULE_REMAP0_DATA4_PIN;
    GPIO_InitStructure.GPIO_Alternate  = DVP_MODULE_REMAP0_DATA4_AF;              
    GPIO_InitPeripheral(DVP_MODULE_REMAP0_DATA4_PORT,&GPIO_InitStructure);	
    AFIO_ConfigPinAnalogSignalChannel(DVP_MODULE_REMAP0_DATA4_PORT, DVP_MODULE_REMAP0_DATA4_PIN,DISABLE);

    /*DVP_D5*/
    GPIO_InitStructure.Pin = DVP_MODULE_REMAP0_DATA5_PIN;
    GPIO_InitStructure.GPIO_Alternate  = DVP_MODULE_REMAP0_DATA5_AF;              
    GPIO_InitPeripheral(DVP_MODULE_REMAP0_DATA5_PORT,&GPIO_InitStructure);	
    AFIO_ConfigPinAnalogSignalChannel(DVP_MODULE_REMAP0_DATA5_PORT, DVP_MODULE_REMAP0_DATA5_PIN,DISABLE);

    /*DVP_D6*/
    GPIO_InitStructure.Pin = DVP_MODULE_REMAP0_DATA6_PIN;
    GPIO_InitStructure.GPIO_Alternate  = DVP_MODULE_REMAP0_DATA6_AF;              
    GPIO_InitPeripheral(DVP_MODULE_REMAP0_DATA6_PORT,&GPIO_InitStructure);
    AFIO_ConfigPinAnalogSignalChannel(DVP_MODULE_REMAP0_DATA6_PORT, DVP_MODULE_REMAP0_DATA6_PIN,DISABLE);

    /*DVP_D7*/
    GPIO_InitStructure.Pin = DVP_MODULE_REMAP0_DATA7_PIN;
    GPIO_InitStructure.GPIO_Alternate  = DVP_MODULE_REMAP0_DATA7_AF;              
    GPIO_InitPeripheral(DVP_MODULE_REMAP0_DATA7_PORT,&GPIO_InitStructure);
    AFIO_ConfigPinAnalogSignalChannel(DVP_MODULE_REMAP0_DATA7_PORT, DVP_MODULE_REMAP0_DATA7_PIN,DISABLE);
    
    /*Camera contral pin*/
    GPIO_InitStruct(&GPIO_InitStructure);
    
    /*RST: PB4*/
    GPIO_InitStructure.Pin = CAMERA_RST;
    GPIO_InitStructure.GPIO_Mode = GPIO_MODE_OUTPUT_PP;
    GPIO_InitStructure.GPIO_Pull = GPIO_PULL_UP;
    GPIO_InitPeripheral(CAMERA_RST_PORT, &GPIO_InitStructure);

    GPIO_ConfigPinRemap(GPIOB_PORT_SOURCE,GPIO_PIN_SOURCE4,GPIO_RMP_SWJ_SWD);    

    /*SCCB Pin*/
    GPIO_InitStructure.Pin = SCCB_SCL;
    GPIO_InitStructure.GPIO_Mode = GPIO_MODE_OUTPUT_PP;
    GPIO_InitStructure.GPIO_Pull = GPIO_PULL_UP;
    GPIO_InitPeripheral(SCCB_SCL_PORT, &GPIO_InitStructure);

    GPIO_InitStructure.Pin = SCCB_SDA;
    GPIO_InitStructure.GPIO_Mode = GPIO_MODE_OUTPUT_PP;
    GPIO_InitStructure.GPIO_Pull = GPIO_PULL_UP;
    GPIO_InitPeripheral(SCCB_SDA_PORT, &GPIO_InitStructure);

}



void OV5640_Flash_Ctrl(uint8_t sw)
{
    OV5640_WR_Reg(0x3016,0X02);
    OV5640_WR_Reg(0x301C,0X02); 
    if(sw)
    {
        OV5640_WR_Reg(0X3019,0X02);
    } 
    else
    {
        OV5640_WR_Reg(0X3019,0X00);
    }
} 




void OV5640_RGB565_Mode(void) 
{
    uint16_t i=0;

    for(i=0;i<(sizeof(ov5640_rgb565_reg_tb)/sizeof(ov5640_rgb565_reg_tb[0]));i++)
    {
        OV5640_WR_Reg(ov5640_rgb565_reg_tb[i][0],ov5640_rgb565_reg_tb[i][1]); 
    } 

} 



uint8_t OV5640_Focus_Init(void)
{ 
    uint16_t i; 
    uint16_t addr=0x8000;
    uint8_t state=0x8F;
    OV5640_WR_Reg(0x3000, 0x20);             
    for(i=0;i<sizeof(OV5640_AF_Config);i++) 
    {
        OV5640_WR_Reg(addr,OV5640_AF_Config[i]);
        addr++;
    }  
    OV5640_WR_Reg(0x3022,0x00);
    OV5640_WR_Reg(0x3023,0x00);
    OV5640_WR_Reg(0x3024,0x00);
    OV5640_WR_Reg(0x3025,0x00);
    OV5640_WR_Reg(0x3026,0x00);
    OV5640_WR_Reg(0x3027,0x00);
    OV5640_WR_Reg(0x3028,0x00);
    OV5640_WR_Reg(0x3029,0x7f);
    OV5640_WR_Reg(0x3000,0x00); 
    i=0;
    do
    {
        state=OV5640_RD_Reg(0x3029);    
        OV5640_Delay();         //about 5ms
        OV5640_Delay();
        OV5640_Delay();
        OV5640_Delay();
        OV5640_Delay();
        OV5640_Delay();
        OV5640_Delay();
        OV5640_Delay();
        i++;
        if(i>1000)return 1;
    }while(state!=0x70); 
    return 0;    
}



void OV5640_Light_Mode(uint8_t mode)
{
    uint8_t i;
    OV5640_WR_Reg(0x3212,0x03);                                             
    for(i=0;i<7;i++)OV5640_WR_Reg(0x3400+i,OV5640_LIGHTMODE_TBL[mode][i]);  
    OV5640_WR_Reg(0x3212,0x13);                                             
    OV5640_WR_Reg(0x3212,0xa3);                                             
}



void OV5640_Color_Saturation(uint8_t sat)
{ 
    uint8_t i;
    OV5640_WR_Reg(0x3212,0x03);                                            
    OV5640_WR_Reg(0x5381,0x1c);
    OV5640_WR_Reg(0x5382,0x5a);
    OV5640_WR_Reg(0x5383,0x06);
    for(i=0;i<6;i++)OV5640_WR_Reg(0x5384+i,OV5640_SATURATION_TBL[sat][i]);  
    OV5640_WR_Reg(0x538b, 0x98);
    OV5640_WR_Reg(0x538a, 0x01);
    OV5640_WR_Reg(0x3212, 0x13);                                          
    OV5640_WR_Reg(0x3212, 0xa3);                                            
}



void OV5640_Brightness(uint8_t bright)
{
    uint8_t brtval;
    if(bright<4)brtval=4-bright;
    else brtval=bright-4;
    OV5640_WR_Reg(0x3212,0x03);             //start group 3
    OV5640_WR_Reg(0x5587,brtval<<4);
    if(bright<4)OV5640_WR_Reg(0x5588,0x09);
    else OV5640_WR_Reg(0x5588,0x01);
    OV5640_WR_Reg(0x3212,0x13);             //end group 3
    OV5640_WR_Reg(0x3212,0xa3);             //launch group 3
}


void OV5640_Contrast(uint8_t contrast)
{
    uint8_t reg0val=0X00;
    uint8_t reg1val=0X20;
    switch(contrast)
    {
        case 0://-3
            reg1val=reg0val=0X14;
            break;	
        case 1://-2
            reg1val=reg0val=0X18;
            break;	
        case 2://-1
            reg1val=reg0val=0X1C;
            break;
        case 4://1
            reg0val=0X10;
            reg1val=0X24;
            break;
        case 5://2
            reg0val=0X18;
            reg1val=0X28;
            break;	
        case 6://3
            reg0val=0X1C;
            reg1val=0X2C;
            break;
    } 
    OV5640_WR_Reg(0x3212,0x03); //start group 3
    OV5640_WR_Reg(0x5585,reg0val);
    OV5640_WR_Reg(0x5586,reg1val); 
    OV5640_WR_Reg(0x3212,0x13); //end group 3
    OV5640_WR_Reg(0x3212,0xa3); //launch group 3
}


void OV5640_Sharpness(uint8_t sharp)
{
    if(sharp<33)
    {
        OV5640_WR_Reg(0x5308,0x65);
        OV5640_WR_Reg(0x5302,sharp);
    }else	
    {
        OV5640_WR_Reg(0x5308,0x25);
        OV5640_WR_Reg(0x5300,0x08);
        OV5640_WR_Reg(0x5301,0x30);
        OV5640_WR_Reg(0x5302,0x10);
        OV5640_WR_Reg(0x5303,0x00);
        OV5640_WR_Reg(0x5309,0x08);
        OV5640_WR_Reg(0x530a,0x30);
        OV5640_WR_Reg(0x530b,0x04);
        OV5640_WR_Reg(0x530c,0x06);
    }

}

uint8_t OV5640_Focus_Constant(void)
{
    uint8_t temp=0;   
    u16 retry=0; 
    OV5640_WR_Reg(0x3023,0x01);
    OV5640_WR_Reg(0x3022,0x08);
    do 
    {
        temp=OV5640_RD_Reg(0x3023); 
        retry++;
        if(retry>1000)return 2;
        OV5640_Delay1(5);
    } while(temp!=0x00);   
    OV5640_WR_Reg(0x3023,0x01);
    OV5640_WR_Reg(0x3022,0x04);
    retry=0;
    do 
    {
        temp=OV5640_RD_Reg(0x3023); 
        retry++;
        if(retry>1000)return 2;
        OV5640_Delay1(5);
    }while(temp!=0x00);
    return 0;
} 

void OV5640_RGB565_Config(void)
{
    OV5640_Flash_Ctrl(1);
    OV5640_Delay1(500);
    OV5640_Flash_Ctrl(0);
    OV5640_RGB565_Mode();        
    OV5640_Focus_Init();         
    OV5640_Light_Mode(0);       
    OV5640_Color_Saturation(3); 
    OV5640_Brightness(4);       
    OV5640_Contrast(3);         
    OV5640_Sharpness(33);       
    OV5640_Focus_Constant();    
    OV5640_Flash_Ctrl(1);
    OV5640_Delay1(500);
    OV5640_Flash_Ctrl(0);
}

