/**
*     Copyright (c) 2023, Nations Technologies Inc.
* 
*     All rights reserved.
*
*     This software is the exclusive property of Nations Technologies Inc. (Hereinafter 
* referred to as NATIONS). This software, and the product of NATIONS described herein 
* (Hereinafter referred to as the Product) are owned by NATIONS under the laws and treaties
* of the People's Republic of China and other applicable jurisdictions worldwide.
*
*     NATIONS does not grant any license under its patents, copyrights, trademarks, or other 
* intellectual property rights. Names and brands of third party may be mentioned or referred 
* thereto (if any) for identification purposes only.
*
*     NATIONS reserves the right to make changes, corrections, enhancements, modifications, and 
* improvements to this software at any time without notice. Please contact NATIONS and obtain 
* the latest version of this software before placing orders.

*     Although NATIONS has attempted to provide accurate and reliable information, NATIONS assumes 
* no responsibility for the accuracy and reliability of this software.
* 
*     It is the responsibility of the user of this software to properly design, program, and test 
* the functionality and safety of any application made of this information and any resulting product. 
* In no event shall NATIONS be liable for any direct, indirect, incidental, special,exemplary, or 
* consequential damages arising in any way out of the use of this software or the Product.
*
*     NATIONS Products are neither intended nor warranted for usage in systems or equipment, any
* malfunction or failure of which may cause loss of human life, bodily injury or severe property 
* damage. Such applications are deemed, "Insecure Usage".
*
*     All Insecure Usage shall be made at user's risk. User shall indemnify NATIONS and hold NATIONS 
* harmless from and against all claims, costs, damages, and other liabilities, arising from or related 
* to any customer's Insecure Usage.

*     Any express or implied warranty with regard to this software or the Product, including,but not 
* limited to, the warranties of merchantability, fitness for a particular purpose and non-infringement
* are disclaimed to the fullest extent permitted by law.

*     Unless otherwise explicitly permitted by NATIONS, anyone may not duplicate, modify, transcribe
* or otherwise distribute this software for any purposes, in whole or in part.
*
*     NATIONS products and technologies shall not be used for or incorporated into any products or systems
* whose manufacture, use, or sale is prohibited under any applicable domestic or foreign laws or regulations. 
* User shall comply with any applicable export control laws and regulations promulgated and administered by 
* the governments of any countries asserting jurisdiction over the parties or transactions.
**/

/**
*\*\file usbfsd_endp.c
*\*\author Nations
*\*\version v1.0.0
*\*\copyright Copyright (c) 2023, Nations Technologies Inc. All rights reserved.
**/

#include "hw_config.h"
#include "usbfsd_lib.h"
#include "usbfsd_istr.h"
#include "usbfsd_desc.h"
#include "usbfsd_pwr.h"

uint8_t Receive_Buffer[2];
extern __IO uint8_t PrevXferComplete;

/* Interval between sending IN packets in frame number (1 frame = 1ms) */
#define VCOMPORT_IN_FRAME_INTERVAL             5

uint8_t USB_Rx_Buffer[VIRTUAL_COM_PORT_DATA_SIZE];
extern  uint8_t USART_Rx_Buffer[];
extern uint32_t USART_Rx_ptr_out;
extern uint32_t USART_Rx_length;
extern uint8_t  USB_Tx_State;

/**
*\*\name    EP1_OUT_Callback.
*\*\fun     EP1 OUT Callback Routine.
*\*\param   none
*\*\return  none 
**/
void EP1_OUT_Callback(void)
{
    Bit_OperateType Led_State;

    /* Read received data (2 bytes) */  
    USB_SilRead(EP1_OUT, Receive_Buffer);

    if (Receive_Buffer[1] == 0)
    {
        Led_State = Bit_RESET;
    }
    else 
    {
        Led_State = Bit_SET;
    }

    switch (Receive_Buffer[0])
    {
    case 1: /* Led 1 */
        if (Led_State != Bit_RESET)
        {
        LED_On(LED1_PORT, LED1_PIN);
        }
        else
        {
        LED_Off(LED1_PORT, LED1_PIN);
        }
        break;
    case 2: /* Led 2 */
        if (Led_State != Bit_RESET)
        {
        LED_On(LED2_PORT, LED2_PIN);
        }
        else
        {
        LED_Off(LED2_PORT, LED2_PIN);
        }
        break;
    case 3: /* Led 3 */
        if (Led_State != Bit_RESET)
        {
            LED_On(LED3_PORT, LED3_PIN);
        }
        else
        {
            LED_Off(LED3_PORT, LED3_PIN);
        }
        break;
    default:
        LED_Off(LED1_PORT, LED1_PIN);
        LED_Off(LED2_PORT, LED2_PIN);
        LED_Off(LED3_PORT, LED3_PIN);
        break;
    }

    /* Enable the receive of data on EP1 */
    SetEPRxStatus(ENDP1, EP_RX_VALID);
}

/**
*\*\name    EP1_IN_Callback.
*\*\fun     EP1 IN Callback Routine.
*\*\param   none
*\*\return  none 
**/
void EP1_IN_Callback(void)
{
    PrevXferComplete = 1;
}


/**
*\*\name    EP2_IN_Callback.
*\*\fun     EP2 IN Callback Routine.
*\*\param   none
*\*\return  none 
**/
void EP3_IN_Callback (void)
{
    uint16_t USB_Tx_ptr;
    uint16_t USB_Tx_length;

    if (USB_Tx_State == 1)
    {
        if (USART_Rx_length == 0) 
        {
            USB_Tx_State = 0;
        }
        else 
        {
            if (USART_Rx_length > VIRTUAL_COM_PORT_DATA_SIZE)
            {
                USB_Tx_ptr = USART_Rx_ptr_out;
                USB_Tx_length = VIRTUAL_COM_PORT_DATA_SIZE;

                USART_Rx_ptr_out += VIRTUAL_COM_PORT_DATA_SIZE;
                USART_Rx_length -= VIRTUAL_COM_PORT_DATA_SIZE;    
            }
            else 
            {
                USB_Tx_ptr = USART_Rx_ptr_out;
                USB_Tx_length = USART_Rx_length;

                USART_Rx_ptr_out += USART_Rx_length;
                USART_Rx_length = 0;
            }
            USB_CopyUserToPMABuf(&USART_Rx_Buffer[USB_Tx_ptr], ENDP3_TXADDR, USB_Tx_length);
            USB_SetEpTxCnt(ENDP3, USB_Tx_length);
            USB_SetEpTxValid(ENDP3); 
        }
    }
}

/**
*\*\name    EP3_OUT_Callback.
*\*\fun     EP3 OUT Callback Routine.
*\*\param   none
*\*\return  none 
**/
void EP3_OUT_Callback(void)
{
    uint16_t USB_Rx_Cnt;

    /* Get the received data buffer and update the counter */
    USB_Rx_Cnt = USB_SilRead(EP3_OUT, USB_Rx_Buffer);

    /* USB data will be immediately processed, this allow next USB traffic being 
    NAKed till the end of the USART Xfer */

    USB_To_USART_Send_Data(USB_Rx_Buffer, USB_Rx_Cnt);

    /* Enable the receive of data on EP3 */
    USB_SetEpRxValid(ENDP3);
}

/**
*\*\name    SOF_Callback.
*\*\fun     SOF Callback Routine.
*\*\param   none
*\*\return  none 
**/
void SOF_Callback(void)
{
    static uint32_t FrameCount = 0;

    if(bDeviceState == CONFIGURED)
    {
        if (FrameCount++ == VCOMPORT_IN_FRAME_INTERVAL)
        {
            /* Reset the frame counter */
            FrameCount = 0;

            /* Check the data to be sent through IN pipe */
            Handle_USBAsynchXfer();
        }
    }  
}

