/**
*     Copyright (c) 2023, Nations Technologies Inc.
* 
*     All rights reserved.
*
*     This software is the exclusive property of Nations Technologies Inc. (Hereinafter 
* referred to as NATIONS). This software, and the product of NATIONS described herein 
* (Hereinafter referred to as the Product) are owned by NATIONS under the laws and treaties
* of the People's Republic of China and other applicable jurisdictions worldwide.
*
*     NATIONS does not grant any license under its patents, copyrights, trademarks, or other 
* intellectual property rights. Names and brands of third party may be mentioned or referred 
* thereto (if any) for identification purposes only.
*
*     NATIONS reserves the right to make changes, corrections, enhancements, modifications, and 
* improvements to this software at any time without notice. Please contact NATIONS and obtain 
* the latest version of this software before placing orders.

*     Although NATIONS has attempted to provide accurate and reliable information, NATIONS assumes 
* no responsibility for the accuracy and reliability of this software.
* 
*     It is the responsibility of the user of this software to properly design, program, and test 
* the functionality and safety of any application made of this information and any resulting product. 
* In no event shall NATIONS be liable for any direct, indirect, incidental, special,exemplary, or 
* consequential damages arising in any way out of the use of this software or the Product.
*
*     NATIONS Products are neither intended nor warranted for usage in systems or equipment, any
* malfunction or failure of which may cause loss of human life, bodily injury or severe property 
* damage. Such applications are deemed, "Insecure Usage".
*
*     All Insecure Usage shall be made at user's risk. User shall indemnify NATIONS and hold NATIONS 
* harmless from and against all claims, costs, damages, and other liabilities, arising from or related 
* to any customer's Insecure Usage.

*     Any express or implied warranty with regard to this software or the Product, including,but not 
* limited to, the warranties of merchantability, fitness for a particular purpose and non-infringement
* are disclaimed to the fullest extent permitted by law.

*     Unless otherwise explicitly permitted by NATIONS, anyone may not duplicate, modify, transcribe
* or otherwise distribute this software for any purposes, in whole or in part.
*
*     NATIONS products and technologies shall not be used for or incorporated into any products or systems
* whose manufacture, use, or sale is prohibited under any applicable domestic or foreign laws or regulations. 
* User shall comply with any applicable export control laws and regulations promulgated and administered by 
* the governments of any countries asserting jurisdiction over the parties or transactions.
**/

/**
*\*\file n32h47x_48x.h
*\*\author Nations
*\*\version v1.0.0
*\*\copyright Copyright (c) 2023, Nations Technologies Inc. All rights reserved.
 */
#ifndef __N32H47X_48X_H__
#define __N32H47X_48X_H__

#ifdef __cplusplus
extern "C" {
#endif

/**  N32H47x_48x_Library_Basic **/

#if !defined USE_STDPERIPH_DRIVER
/*
 * Comment the line below if you will not use the peripherals drivers.
   In this case, these drivers will not be included and the application code will
   be based on direct access to peripherals registers
   */
#define USE_STDPERIPH_DRIVER
#endif

/*
 * In the following line adjust the value of External High Speed oscillator (HSE)
   used in your application

   Tip: To avoid modifying this file each time you need to use different HSE, you
        can define the HSE value in your toolchain compiler preprocessor.
  */
#if !defined HSE_VALUE
#if defined (N32H473) || defined (N32H474) || defined (N32H475)
#define HSE_VALUE (8000000U) /* Value of the External oscillator in Hz */
#else
#define HSE_VALUE (16000000U) /* Value of the External oscillator in Hz */
#endif  

#endif                      /* HSE_VALUE */

/** In the following line adjust the HSE\HSI\LSI\LSE Startup
   Timeout value **/
#define HSE_STARTUP_TIMEOUT ((uint16_t)0x4000)  /* SYSCLK= 240M Time out for HSE start up */
#define HSI_STARTUP_TIMEOUT ((uint16_t)0x0C00)  /* SYSCLK= 240M Time out for HSI start up */
#define LSI_STARTUP_TIMEOUT ((uint16_t)0x0C00)  /* SYSCLK= 240M Time out for LSI start up */
#define LSE_STARTUP_TIMEOUT ((uint32_t)0x00C00000)  /* SYSCLK= 240M Time out for LSE start up */

#define HSI_VALUE (8000000U) /* Value of the Internal oscillator in Hz*/
#define LSI_VALUE (32000U) /* Value of the Internal Low Speed oscillator in Hz*/

#define __N32H47X_48X_STDPERIPH_VERSION_MAIN (0x00) /* [31:24] main version */
#define __N32H47X_48X_STDPERIPH_VERSION_SUB1 (0x04) /* [23:16] sub1 version */
#define __N32H47X_48X_STDPERIPH_VERSION_SUB2 (0x00) /* [15:8]  sub2 version */
#define __N32H47X_48X_STDPERIPH_VERSION_RC   (0x00) /* [7:0]  release candidate */

/**
 * @brief N32H47X_48X Standard Peripheral Library version number
 */
#define __N32H47X_48X_STDPERIPH_VERSION                                                                                    \
    ((__N32H47X_48X_STDPERIPH_VERSION_MAIN << 24) | (__N32H47X_48X_STDPERIPH_VERSION_SUB1 << 16)                               \
     | (__N32H47X_48X_STDPERIPH_VERSION_SUB2 << 8) | (__N32H47X_48X_STDPERIPH_VERSION_RC))

/*
 * Configuration of the Cortex-M4 Processor and Core Peripherals
 */
#define __MPU_PRESENT 1          /* MPU present*/
#define __FPU_PRESENT 1          /* FPU present                            */
                                 /* N32H47X_48X */
#define __NVIC_PRIO_BITS       4 /* N32H47X_48X uses 4 Bits for the Priority Levels    */
#define __Vendor_SysTickConfig 0 /* Set to 1 if different SysTick Config is used */

/**
 * N32H47X_48X Interrupt Number Definition
 */
typedef enum IRQn
{
    /******  Cortex-M4 Processor Exceptions Numbers ***************************************************/
    NonMaskableInt_IRQn         = -14,  /* 2 Non Maskable Interrupt                                    */
    HardFault_IRQn              = -13,  /* 3 Hard Fault Interrupt                                      */
    MemoryManagement_IRQn       = -12,  /* 4 Cortex-M4 Memory Management Interrupt                     */
    BusFault_IRQn               = -11,  /* 5 Cortex-M4 Bus Fault Interrupt                             */
    UsageFault_IRQn             = -10,  /* 6 Cortex-M4 Usage Fault Interrupt                           */
    SVCall_IRQn                 = -5,   /* 11 Cortex-M4 SV Call Interrupt                              */
    DebugMonitor_IRQn           = -4,   /* 12 Cortex-M4 Debug Monitor Interrupt                        */
    PendSV_IRQn                 = -2,   /* 14 Cortex-M4 Pend SV Interrupt                              */
    SysTick_IRQn                = -1,   /* 15 Cortex-M4 System Tick Interrupt                          */
#if defined (N32H473)
    /******  N32H473 specific Interrupt Numbers ********************************************************/
    WWDG_IRQn                   = 0,   /* Window WatchDog Interrupt                                    */
    PVD_IRQn                    = 1,   /* PVD through EXTI Line16 detection Interrupt                  */
    RTC_TAMPER_IRQn             = 2,   /* RTC Tamper or LSE-CSS through EXTI Line19 Interrupt          */
    RTC_WKUP_IRQn               = 3,   /* RTC Wakeup timer through EXTI Line20  Interrupt              */
    FLASH_IRQn                  = 4,   /* FLASH global Interrupt                                       */
    RCC_IRQn                    = 5,   /* RCC global Interrupt                                         */
    EXTI0_IRQn                  = 6,   /* EXTI Line0 Interrupt                                         */
    EXTI1_IRQn                  = 7,   /* EXTI Line1 Interrupt                                         */
    EXTI2_IRQn                  = 8,   /* EXTI Line2 Interrupt                                         */
    EXTI3_IRQn                  = 9,   /* EXTI Line3 Interrupt                                         */
    EXTI4_IRQn                  = 10,  /* EXTI Line4 Interrupt                                         */
    DMA1_Channel1_IRQn          = 11,  /* DMA1 Channel 1 global Interrupt                              */
    DMA1_Channel2_IRQn          = 12,  /* DMA1 Channel 2 global Interrupt                              */
    DMA1_Channel3_IRQn          = 13,  /* DMA1 Channel 3 global Interrupt                              */
    DMA1_Channel4_IRQn          = 14,  /* DMA1 Channel 4 global Interrupt                              */
    DMA1_Channel5_IRQn          = 15,  /* DMA1 Channel 5 global Interrupt                              */
     
    DMA1_Channel6_IRQn          = 16,  /* DMA1 Channel 6 global Interrupt                              */
    DMA1_Channel7_IRQn          = 17,  /* DMA1 Channel 7 global Interrupt                              */
    ADC1_2_IRQn                 = 18,  /* ADC1 and ADC2 global Interrupt                               */
    USB_FS_HP_IRQn              = 19,  /* USB FS Device High Priority Interrupts                       */
    USB_FS_LP_IRQn              = 20,  /* USB FS Device Low Priority Interrupts                        */
    FDCAN1_INT0_IRQn            = 21,  /* FDCAN1 Interrupt Line 0                                      */
    FDCAN1_INT1_IRQn            = 22,  /* FDCAN1 Interrupt Line 1                                      */
    EXTI9_5_IRQn                = 23,  /* EXTI Line[9:5] Interrupts                                    */
    ATIM1_BRK_IRQn              = 24,  /* ATIM1 Break Interrupt                                        */
    ATIM1_UP_IRQn               = 25,  /* ATIM1 Update Interrupt                                       */
    ATIM1_TRG_COM_IRQn          = 26,  /* ATIM1 Trigger and Commutation Interrupt                      */
    ATIM1_CC_IRQn               = 27,  /* ATIM1 Capture Compare Interrupt                              */
    GTIM1_IRQn                  = 28,  /* GTIM1 global Interrupt                                       */
    GTIM2_IRQn                  = 29,  /* GTIM2 global Interrupt                                       */
    GTIM3_IRQn                  = 30,  /* GTIM3 global Interrupt                                       */
    I2C1_EV_IRQn                = 31,  /* I2C1 Event Interrupt                                         */
 
    I2C1_ER_IRQn                = 32,  /* I2C1 Error Interrupt                                         */
    I2C2_EV_IRQn                = 33,  /* I2C2 Event Interrupt                                         */
    I2C2_ER_IRQn                = 34,  /* I2C2 Error Interrupt                                         */
    SPI1_IRQn                   = 35,  /* SPI1 global Interrupt                                        */
    SPI2_I2S2_IRQn              = 36,  /* SPI2/I2S2 global Interrupt                                   */
    USART1_IRQn                 = 37,  /* USART1 global Interrupt                                      */
    USART2_IRQn                 = 38,  /* USART2 global Interrupt                                      */
    USART3_IRQn                 = 39,  /* USART3 global Interrupt                                      */
    EXTI15_10_IRQn              = 40,  /* EXTI Line[15:10] Interrupts                                  */
    RTCAlarm_IRQn               = 41,  /* RTC Alarm through EXTI Line17 Interrupt                      */
    USB_FS_WKUP_IRQn            = 42,  /* USB FS Device WakeUp from suspend through EXTI Line18 Interrupt*/
    ATIM2_BRK_IRQn              = 43,  /* ATIM2 Break Interrupt                                        */
    ATIM2_UP_IRQn               = 44,  /* ATIM2 Update Interrupt                                       */
    ATIM2_TRG_COM_IRQn          = 45,  /* ATIM2 Trigger and Commutation Interrupt                      */
    ATIM2_CC_IRQn               = 46,  /* ATIM2 Capture Compare Interrupt                              */
    ADC3_4_IRQn                 = 47,  /* ADC3 and ADC4 global Interrupt                               */
 
    UCDR_IRQn                   = 48,  /* UCDR error Interrupt                                         */
    GTIM4_IRQn                  = 50,  /* GTIM4 global Interrupt                                       */
    SPI3_I2S3_IRQn              = 51,  /* SPI3/I2S3 global Interrupt                                   */
    USART4_IRQn                 = 52,  /* USART4 global Interrupt                                      */
    UART5_IRQn                  = 53,  /* UART5 global Interrupt                                       */
    BTIM1_IRQn                  = 54,  /* BTIM1 global Interrupt                                       */
    BTIM2_IRQn                  = 55,  /* BTIM2 global Interrupt                                       */
    DMA2_Channel1_IRQn          = 56,  /* DMA2 Channel 1 global Interrupt                              */
    DMA2_Channel2_IRQn          = 57,  /* DMA2 Channel 2 global Interrupt                              */
    DMA2_Channel3_IRQn          = 58,  /* DMA2 Channel 3 global Interrupt                              */
    DMA2_Channel4_IRQn          = 59,  /* DMA2 Channel 4 global Interrupt                              */
    DMA2_Channel5_IRQn          = 60,  /* DMA2 Channel 5 global Interrupt                              */
    SRAM_ERR_IRQn               = 61,  /* SRAM ECC error Interrupt                                     */
    COMP4_5_6_IRQn              = 62,  /* COMP4/5/6 through EXTI Line22/30/31 interrupt                */
    FDCAN2_INT0_IRQn            = 63,  /* FDCAN2 Interrupt 0                                           */
 
    FDCAN2_INT1_IRQn            = 64,  /* FDCAN2 Interrupt 1                                           */
    FDCAN3_INT0_IRQn            = 65,  /* FDCAN3 Interrupt 0                                           */
    FDCAN3_INT1_IRQn            = 66,  /* FDCAN3 Interrupt 1                                           */
    XSPI_IRQn                   = 67,  /* xSPI global Interrupt                                        */
    DMA2_Channel6_IRQn          = 68,  /* DMA2 Channel 6 global Interrupt                              */
    DMA2_Channel7_IRQn          = 69,  /* DMA2 Channel 7 global Interrupt                              */
    I2C3_EV_IRQn                = 70,  /* I2C3 Event Interrupt                                         */
    I2C3_ER_IRQn                = 71,  /* I2C3 Error Interrupt                                         */
    I2C4_EV_IRQn                = 72,  /* I2C4 Event Interrupt                                         */
    I2C4_ER_IRQn                = 73,  /* I2C4 Error Interrupt                                         */
    UART6_IRQn                  = 74,  /* UART6 global Interrupt                                       */
    UART7_IRQn                  = 75,  /* UART7 global Interrupt                                       */
    DMA1_Channel8_IRQn          = 76,  /* DMA1 Channel 8 global Interrupt                              */
    DMA2_Channel8_IRQn          = 77,  /* DMA2 Channel 8 global Interrupt                              */
    SAC_IRQn                    = 79,  /* SAC global Interrupt                                         */
 
    SMPU_IRQn                   = 80,  /* SMPU global Interrupt                                        */
    COMP1_2_3_IRQn              = 81,  /* COMP1/2/3 through EXTI Line21/28/29 Interrupt                */
    UART8_IRQn                  = 85,  /* UART8 global Interrupt                                       */
    SPI4_IRQn                   = 86,  /* SPI4 global Interrupt                                        */
    GTIM5_IRQn                  = 89,  /* GTIM5 global Interrupt                                       */
    COMP7_IRQn                  = 90,  /* COMP7 through EXTI Line24 Interrupt                          */
    
    ATIM3_BRK_IRQn              = 99,  /* ATIM3 Break Interrupt                                        */
    ATIM3_UP_IRQn               = 100, /* ATIM3 Update Interrupt                                       */
    ATIM3_TRG_COM_IRQn          = 101, /* ATIM3 Trigger and Commutation Interrupt                      */
    ATIM3_CC_IRQn               = 102, /* ATIM3 Capture Compare Interrupt                              */
    GTIM6_IRQn                  = 103, /* GTIM6 global Interrupt                                       */
    LPTIM1_WKUP_IRQn            = 104, /* LPTIM1 wakeup through EXTI line Interrupt                    */
    LPTIM2_WKUP_IRQn            = 105, /* LPTIM2 wakeup through EXTI line Interrupt                    */
    FMAC_IRQn                   = 106, /* FMAC global Interrupt                                        */
    Cordic_IRQn                 = 107, /* Cordic global Interrupt                                      */
    SPI5_IRQn                   = 108, /* SPI5 global Interrupt                                        */
    SPI6_IRQn                   = 109, /* SPI6 global Interrupt                                        */
    GTIM7_IRQn                  = 110, /* GTIM7 global Interrupt                                       */
    GTIM8_IRQn                  = 111, /* GTIM8 global Interrupt                                       */

    GTIM9_IRQn                  = 112, /* GTIM9 global Interrupt                                       */
    GTIM10_IRQn                 = 113, /* GTIM10 global Interrupt                                      */
    DAC1_2_3_4_Underflow_IRQn   = 114, /* DAC1/2/3/4 underflow Interrupt                               */
    DAC5_6_7_8_Underflow_IRQn   = 115, /* DAC5/6/7/8 underflow Interrupt                               */
    FEMC_IRQn                   = 117  /* FEMC nand Interrupt                                           */
#elif defined (N32H474)
    /******  N32H474 specific Interrupt Numbers ********************************************************/
    WWDG_IRQn                   = 0,   /* Window WatchDog Interrupt                                    */
    PVD_IRQn                    = 1,   /* PVD through EXTI Line16 detection Interrupt                  */
    RTC_TAMPER_IRQn             = 2,   /* RTC Tamper or LSE-CSS through EXTI Line19 Interrupt          */
    RTC_WKUP_IRQn               = 3,   /* RTC Wakeup timer through EXTI Line20  Interrupt              */
    FLASH_IRQn                  = 4,   /* FLASH global Interrupt                                       */
    RCC_IRQn                    = 5,   /* RCC global Interrupt                                         */
    EXTI0_IRQn                  = 6,   /* EXTI Line0 Interrupt                                         */
    EXTI1_IRQn                  = 7,   /* EXTI Line1 Interrupt                                         */
    EXTI2_IRQn                  = 8,   /* EXTI Line2 Interrupt                                         */
    EXTI3_IRQn                  = 9,   /* EXTI Line3 Interrupt                                         */
    EXTI4_IRQn                  = 10,  /* EXTI Line4 Interrupt                                         */
    DMA1_Channel1_IRQn          = 11,  /* DMA1 Channel 1 global Interrupt                              */
    DMA1_Channel2_IRQn          = 12,  /* DMA1 Channel 2 global Interrupt                              */
    DMA1_Channel3_IRQn          = 13,  /* DMA1 Channel 3 global Interrupt                              */
    DMA1_Channel4_IRQn          = 14,  /* DMA1 Channel 4 global Interrupt                              */
    DMA1_Channel5_IRQn          = 15,  /* DMA1 Channel 5 global Interrupt                              */
     
    DMA1_Channel6_IRQn          = 16,  /* DMA1 Channel 6 global Interrupt                              */
    DMA1_Channel7_IRQn          = 17,  /* DMA1 Channel 7 global Interrupt                              */
    ADC1_2_IRQn                 = 18,  /* ADC1 and ADC2 global Interrupt                               */
    USB_FS_HP_IRQn              = 19,  /* USB FS Device High Priority Interrupts                       */
    USB_FS_LP_IRQn              = 20,  /* USB FS Device Low Priority Interrupts                        */
    FDCAN1_INT0_IRQn            = 21,  /* FDCAN1 Interrupt Line 0                                      */
    FDCAN1_INT1_IRQn            = 22,  /* FDCAN1 Interrupt Line 1                                      */
    EXTI9_5_IRQn                = 23,  /* EXTI Line[9:5] Interrupts                                    */
    ATIM1_BRK_IRQn              = 24,  /* ATIM1 Break Interrupt                                        */
    ATIM1_UP_IRQn               = 25,  /* ATIM1 Update Interrupt                                       */
    ATIM1_TRG_COM_IRQn          = 26,  /* ATIM1 Trigger and Commutation Interrupt                      */
    ATIM1_CC_IRQn               = 27,  /* ATIM1 Capture Compare Interrupt                              */
    GTIM1_IRQn                  = 28,  /* GTIM1 global Interrupt                                       */
    GTIM2_IRQn                  = 29,  /* GTIM2 global Interrupt                                       */
    GTIM3_IRQn                  = 30,  /* GTIM3 global Interrupt                                       */
    I2C1_EV_IRQn                = 31,  /* I2C1 Event Interrupt                                         */
 
    I2C1_ER_IRQn                = 32,  /* I2C1 Error Interrupt                                         */
    I2C2_EV_IRQn                = 33,  /* I2C2 Event Interrupt                                         */
    I2C2_ER_IRQn                = 34,  /* I2C2 Error Interrupt                                         */
    SPI1_IRQn                   = 35,  /* SPI1 global Interrupt                                        */
    SPI2_I2S2_IRQn              = 36,  /* SPI2/I2S2 global Interrupt                                   */
    USART1_IRQn                 = 37,  /* USART1 global Interrupt                                      */
    USART2_IRQn                 = 38,  /* USART2 global Interrupt                                      */
    USART3_IRQn                 = 39,  /* USART3 global Interrupt                                      */
    EXTI15_10_IRQn              = 40,  /* EXTI Line[15:10] Interrupts                                  */
    RTCAlarm_IRQn               = 41,  /* RTC Alarm through EXTI Line17 Interrupt                      */
    USB_FS_WKUP_IRQn            = 42,  /* USB FS Device WakeUp from suspend through EXTI Line18 Interrupt*/
    ATIM2_BRK_IRQn              = 43,  /* ATIM2 Break Interrupt                                        */
    ATIM2_UP_IRQn               = 44,  /* ATIM2 Update Interrupt                                       */
    ATIM2_TRG_COM_IRQn          = 45,  /* ATIM2 Trigger and Commutation Interrupt                      */
    ATIM2_CC_IRQn               = 46,  /* ATIM2 Capture Compare Interrupt                              */
    ADC3_4_IRQn                 = 47,  /* ADC3 and ADC4 global Interrupt                               */
 
    UCDR_IRQn                   = 48,  /* UCDR error Interrupt                                         */
    GTIM4_IRQn                  = 50,  /* GTIM4 global Interrupt                                       */
    SPI3_I2S3_IRQn              = 51,  /* SPI3/I2S3 global Interrupt                                   */
    USART4_IRQn                 = 52,  /* USART4 global Interrupt                                      */
    UART5_IRQn                  = 53,  /* UART5 global Interrupt                                       */
    BTIM1_IRQn                  = 54,  /* BTIM1 global Interrupt                                       */
    BTIM2_IRQn                  = 55,  /* BTIM2 global Interrupt                                       */
    DMA2_Channel1_IRQn          = 56,  /* DMA2 Channel 1 global Interrupt                              */
    DMA2_Channel2_IRQn          = 57,  /* DMA2 Channel 2 global Interrupt                              */
    DMA2_Channel3_IRQn          = 58,  /* DMA2 Channel 3 global Interrupt                              */
    DMA2_Channel4_IRQn          = 59,  /* DMA2 Channel 4 global Interrupt                              */
    DMA2_Channel5_IRQn          = 60,  /* DMA2 Channel 5 global Interrupt                              */
    SRAM_ERR_IRQn               = 61,  /* SRAM ECC error Interrupt                                     */
    COMP4_5_6_IRQn              = 62,  /* COMP4/5/6 through EXTI Line22/30/31 interrupt                */
    FDCAN2_INT0_IRQn            = 63,  /* FDCAN2 Interrupt 0                                           */
 
    FDCAN2_INT1_IRQn            = 64,  /* FDCAN2 Interrupt 1                                           */
    FDCAN3_INT0_IRQn            = 65,  /* FDCAN3 Interrupt 0                                           */
    FDCAN3_INT1_IRQn            = 66,  /* FDCAN3 Interrupt 1                                           */
    XSPI_IRQn                   = 67,  /* xSPI global Interrupt                                        */
    DMA2_Channel6_IRQn          = 68,  /* DMA2 Channel 6 global Interrupt                              */
    DMA2_Channel7_IRQn          = 69,  /* DMA2 Channel 7 global Interrupt                              */
    I2C3_EV_IRQn                = 70,  /* I2C3 Event Interrupt                                         */
    I2C3_ER_IRQn                = 71,  /* I2C3 Error Interrupt                                         */
    I2C4_EV_IRQn                = 72,  /* I2C4 Event Interrupt                                         */
    I2C4_ER_IRQn                = 73,  /* I2C4 Error Interrupt                                         */
    UART6_IRQn                  = 74,  /* UART6 global Interrupt                                       */
    UART7_IRQn                  = 75,  /* UART7 global Interrupt                                       */
    DMA1_Channel8_IRQn          = 76,  /* DMA1 Channel 8 global Interrupt                              */
    DMA2_Channel8_IRQn          = 77,  /* DMA2 Channel 8 global Interrupt                              */
    SAC_IRQn                    = 79,  /* SAC global Interrupt                                         */
 
    SMPU_IRQn                   = 80,  /* SMPU global Interrupt                                        */
    COMP1_2_3_IRQn              = 81,  /* COMP1/2/3 through EXTI Line21/28/29 Interrupt                */
    UART8_IRQn                  = 85,  /* UART8 global Interrupt                                       */
    SPI4_IRQn                   = 86,  /* SPI4 global Interrupt                                        */
    GTIM5_IRQn                  = 89,  /* GTIM5 global Interrupt                                       */
    COMP7_IRQn                  = 90,  /* COMP7 through EXTI Line24 Interrupt                          */
    SHRT1_MST_IRQn              = 91,  /* SHRTIM1 master Interrupt                                     */
    SHRT1_TIMA_IRQn             = 92,  /* SHRTIM1 timer A Interrupt                                    */
    SHRT1_TIMB_IRQn             = 93,  /* SHRTIM1 timer B Interrupt                                    */
    SHRT1_TIMC_IRQn             = 94,  /* SHRTIM1 timer C Interrupt                                    */
    SHRT1_TIMD_IRQn             = 95,  /* SHRTIM1 timer D Interrupt                                    */

    SHRT1_TIME_IRQn             = 96,  /* SHRTIM1 timer E Interrupt                                    */
    SHRT1_TIMF_IRQn             = 97,  /* SHRTIM1 timer F Interrupt                                    */
    SHRT1_FLT_IRQn              = 98,  /* SHRTIM1 fault Interrupt                                      */
    ATIM3_BRK_IRQn              = 99,  /* ATIM3 Break Interrupt                                        */
    ATIM3_UP_IRQn               = 100, /* ATIM3 Update Interrupt                                       */
    ATIM3_TRG_COM_IRQn          = 101, /* ATIM3 Trigger and Commutation Interrupt                      */
    ATIM3_CC_IRQn               = 102, /* ATIM3 Capture Compare Interrupt                              */
    GTIM6_IRQn                  = 103, /* GTIM6 global Interrupt                                       */
    LPTIM1_WKUP_IRQn            = 104, /* LPTIM1 wakeup through EXTI line Interrupt                    */
    LPTIM2_WKUP_IRQn            = 105, /* LPTIM2 wakeup through EXTI line Interrupt                    */
    FMAC_IRQn                   = 106, /* FMAC global Interrupt                                        */
    Cordic_IRQn                 = 107, /* Cordic global Interrupt                                      */
    SPI5_IRQn                   = 108, /* SPI5 global Interrupt                                        */
    SPI6_IRQn                   = 109, /* SPI6 global Interrupt                                        */
    GTIM7_IRQn                  = 110, /* GTIM7 global Interrupt                                       */
    GTIM8_IRQn                  = 111, /* GTIM8 global Interrupt                                       */

    GTIM9_IRQn                  = 112, /* GTIM9 global Interrupt                                       */
    GTIM10_IRQn                 = 113, /* GTIM10 global Interrupt                                      */
    DAC1_2_3_4_Underflow_IRQn   = 114, /* DAC1/2/3/4 underflow Interrupt                               */
    DAC5_6_7_8_Underflow_IRQn   = 115, /* DAC5/6/7/8 underflow Interrupt                               */
    FEMC_IRQn                   = 117  /* FEMC nand Interrupt                                          */
#elif defined (N32H475)
    /******  N32H475 specific Interrupt Numbers ********************************************************/
    WWDG_IRQn                   = 0,   /* Window WatchDog Interrupt                                    */
    PVD_IRQn                    = 1,   /* PVD through EXTI Line16 detection Interrupt                  */
    RTC_TAMPER_IRQn             = 2,   /* RTC Tamper or LSE-CSS through EXTI Line19 Interrupt          */
    FLASH_IRQn                  = 4,   /* FLASH global Interrupt                                       */
    RCC_IRQn                    = 5,   /* RCC global Interrupt                                         */
    EXTI0_IRQn                  = 6,   /* EXTI Line0 Interrupt                                         */
    EXTI1_IRQn                  = 7,   /* EXTI Line1 Interrupt                                         */
    EXTI2_IRQn                  = 8,   /* EXTI Line2 Interrupt                                         */
    EXTI3_IRQn                  = 9,   /* EXTI Line3 Interrupt                                         */
    EXTI4_IRQn                  = 10,  /* EXTI Line4 Interrupt                                         */
    DMA1_Channel1_IRQn          = 11,  /* DMA1 Channel 1 global Interrupt                              */
    DMA1_Channel2_IRQn          = 12,  /* DMA1 Channel 2 global Interrupt                              */
    DMA1_Channel3_IRQn          = 13,  /* DMA1 Channel 3 global Interrupt                              */
    DMA1_Channel4_IRQn          = 14,  /* DMA1 Channel 4 global Interrupt                              */
    DMA1_Channel5_IRQn          = 15,  /* DMA1 Channel 5 global Interrupt                              */
     
    DMA1_Channel6_IRQn          = 16,  /* DMA1 Channel 6 global Interrupt                              */
    DMA1_Channel7_IRQn          = 17,  /* DMA1 Channel 7 global Interrupt                              */
    ADC1_2_IRQn                 = 18,  /* ADC1 and ADC2 global Interrupt                               */
    FDCAN1_INT0_IRQn            = 21,  /* FDCAN1 Interrupt Line 0                                      */
    FDCAN1_INT1_IRQn            = 22,  /* FDCAN1 Interrupt Line 1                                      */
    EXTI9_5_IRQn                = 23,  /* EXTI Line[9:5] Interrupts                                    */
    ATIM1_BRK_IRQn              = 24,  /* ATIM1 Break Interrupt                                        */
    ATIM1_UP_IRQn               = 25,  /* ATIM1 Update Interrupt                                       */
    ATIM1_TRG_COM_IRQn          = 26,  /* ATIM1 Trigger and Commutation Interrupt                      */
    ATIM1_CC_IRQn               = 27,  /* ATIM1 Capture Compare Interrupt                              */
    GTIM1_IRQn                  = 28,  /* GTIM1 global Interrupt                                       */
    GTIM2_IRQn                  = 29,  /* GTIM2 global Interrupt                                       */
    GTIM3_IRQn                  = 30,  /* GTIM3 global Interrupt                                       */
    I2C1_EV_IRQn                = 31,  /* I2C1 Event Interrupt                                         */
 
    I2C1_ER_IRQn                = 32,  /* I2C1 Error Interrupt                                         */
    I2C2_EV_IRQn                = 33,  /* I2C2 Event Interrupt                                         */
    I2C2_ER_IRQn                = 34,  /* I2C2 Error Interrupt                                         */
    SPI1_IRQn                   = 35,  /* SPI1 global Interrupt                                        */
    SPI2_I2S2_IRQn              = 36,  /* SPI2/I2S2 global Interrupt                                   */
    USART1_IRQn                 = 37,  /* USART1 global Interrupt                                      */
    USART2_IRQn                 = 38,  /* USART2 global Interrupt                                      */
    USART3_IRQn                 = 39,  /* USART3 global Interrupt                                      */
    EXTI15_10_IRQn              = 40,  /* EXTI Line[15:10] Interrupts                                  */
    ATIM2_BRK_IRQn              = 43,  /* ATIM2 Break Interrupt                                        */
    ATIM2_UP_IRQn               = 44,  /* ATIM2 Update Interrupt                                       */
    ATIM2_TRG_COM_IRQn          = 45,  /* ATIM2 Trigger and Commutation Interrupt                      */
    ATIM2_CC_IRQn               = 46,  /* ATIM2 Capture Compare Interrupt                              */
    ADC3_4_IRQn                 = 47,  /* ADC3 and ADC4 global Interrupt                               */
 
    UCDR_IRQn                   = 48,  /* UCDR error Interrupt                                         */
    GTIM4_IRQn                  = 50,  /* GTIM4 global Interrupt                                       */
    SPI3_I2S3_IRQn              = 51,  /* SPI3/I2S3 global Interrupt                                   */
    USART4_IRQn                 = 52,  /* USART4 global Interrupt                                      */
    UART5_IRQn                  = 53,  /* UART5 global Interrupt                                       */
    BTIM1_IRQn                  = 54,  /* BTIM1 global Interrupt                                       */
    BTIM2_IRQn                  = 55,  /* BTIM2 global Interrupt                                       */
    DMA2_Channel1_IRQn          = 56,  /* DMA2 Channel 1 global Interrupt                              */
    DMA2_Channel2_IRQn          = 57,  /* DMA2 Channel 2 global Interrupt                              */
    DMA2_Channel3_IRQn          = 58,  /* DMA2 Channel 3 global Interrupt                              */
    DMA2_Channel4_IRQn          = 59,  /* DMA2 Channel 4 global Interrupt                              */
    DMA2_Channel5_IRQn          = 60,  /* DMA2 Channel 5 global Interrupt                              */
    SRAM_ERR_IRQn               = 61,  /* SRAM ECC error Interrupt                                     */
    COMP4_5_6_IRQn              = 62,  /* COMP4/5/6 through EXTI Line22/30/31 interrupt                */
    FDCAN2_INT0_IRQn            = 63,  /* FDCAN2 Interrupt 0                                           */
 
    FDCAN2_INT1_IRQn            = 64,  /* FDCAN2 Interrupt 1                                           */
    FDCAN3_INT0_IRQn            = 65,  /* FDCAN3 Interrupt 0                                           */
    FDCAN3_INT1_IRQn            = 66,  /* FDCAN3 Interrupt 1                                           */
    DMA2_Channel6_IRQn          = 68,  /* DMA2 Channel 6 global Interrupt                              */
    DMA2_Channel7_IRQn          = 69,  /* DMA2 Channel 7 global Interrupt                              */
    I2C3_EV_IRQn                = 70,  /* I2C3 Event Interrupt                                         */
    I2C3_ER_IRQn                = 71,  /* I2C3 Error Interrupt                                         */
    I2C4_EV_IRQn                = 72,  /* I2C4 Event Interrupt                                         */
    I2C4_ER_IRQn                = 73,  /* I2C4 Error Interrupt                                         */
    UART6_IRQn                  = 74,  /* UART6 global Interrupt                                       */
    UART7_IRQn                  = 75,  /* UART7 global Interrupt                                       */
    DMA1_Channel8_IRQn          = 76,  /* DMA1 Channel 8 global Interrupt                              */
    DMA2_Channel8_IRQn          = 77,  /* DMA2 Channel 8 global Interrupt                              */
    SAC_IRQn                    = 79,  /* SAC global Interrupt                                         */
 
    SMPU_IRQn                   = 80,  /* SMPU global Interrupt                                        */
    COMP1_2_3_IRQn              = 81,  /* COMP1/2/3 through EXTI Line21/28/29 Interrupt                */
    UART8_IRQn                  = 85,  /* UART8 global Interrupt                                       */
    SPI4_IRQn                   = 86,  /* SPI4 global Interrupt                                        */
    GTIM5_IRQn                  = 89,  /* GTIM5 global Interrupt                                       */
    COMP7_IRQn                  = 90,  /* COMP7 through EXTI Line24 Interrupt                          */
    
    ATIM3_BRK_IRQn              = 99,  /* ATIM3 Break Interrupt                                        */
    ATIM3_UP_IRQn               = 100, /* ATIM3 Update Interrupt                                       */
    ATIM3_TRG_COM_IRQn          = 101, /* ATIM3 Trigger and Commutation Interrupt                      */
    ATIM3_CC_IRQn               = 102, /* ATIM3 Capture Compare Interrupt                              */
    GTIM6_IRQn                  = 103, /* GTIM6 global Interrupt                                       */
    LPTIM1_WKUP_IRQn            = 104, /* LPTIM1 wakeup through EXTI line Interrupt                    */
    LPTIM2_WKUP_IRQn            = 105, /* LPTIM2 wakeup through EXTI line Interrupt                    */
    FMAC_IRQn                   = 106, /* FMAC global Interrupt                                        */
    Cordic_IRQn                 = 107, /* Cordic global Interrupt                                      */
    SPI5_IRQn                   = 108, /* SPI5 global Interrupt                                        */
    SPI6_IRQn                   = 109, /* SPI6 global Interrupt                                        */
    GTIM7_IRQn                  = 110, /* GTIM7 global Interrupt                                       */
    GTIM8_IRQn                  = 111, /* GTIM8 global Interrupt                                       */

    GTIM9_IRQn                  = 112, /* GTIM9 global Interrupt                                       */
    GTIM10_IRQn                 = 113, /* GTIM10 global Interrupt                                      */
    DAC1_2_3_4_Underflow_IRQn   = 114, /* DAC1/2/3/4 underflow Interrupt                               */
    DAC5_6_7_8_Underflow_IRQn   = 115, /* DAC5/6/7/8 underflow Interrupt                                         */
#elif defined (N32H481)
    /******  N32H481 specific Interrupt Numbers ********************************************************/
    WWDG_IRQn                   = 0,   /* Window WatchDog Interrupt                                    */
    PVD_IRQn                    = 1,   /* PVD through EXTI Line16 detection Interrupt                  */
    RTC_TAMPER_IRQn             = 2,   /* RTC Tamper or LSE-CSS through EXTI Line19 Interrupt          */
    RTC_WKUP_IRQn               = 3,   /* RTC Wakeup timer through EXTI Line20  Interrupt              */
    FLASH_IRQn                  = 4,   /* FLASH global Interrupt                                       */
    RCC_IRQn                    = 5,   /* RCC global Interrupt                                         */
    EXTI0_IRQn                  = 6,   /* EXTI Line0 Interrupt                                         */
    EXTI1_IRQn                  = 7,   /* EXTI Line1 Interrupt                                         */
    EXTI2_IRQn                  = 8,   /* EXTI Line2 Interrupt                                         */
    EXTI3_IRQn                  = 9,   /* EXTI Line3 Interrupt                                         */
    EXTI4_IRQn                  = 10,  /* EXTI Line4 Interrupt                                         */
    DMA1_Channel1_IRQn          = 11,  /* DMA1 Channel 1 global Interrupt                              */
    DMA1_Channel2_IRQn          = 12,  /* DMA1 Channel 2 global Interrupt                              */
    DMA1_Channel3_IRQn          = 13,  /* DMA1 Channel 3 global Interrupt                              */
    DMA1_Channel4_IRQn          = 14,  /* DMA1 Channel 4 global Interrupt                              */
    DMA1_Channel5_IRQn          = 15,  /* DMA1 Channel 5 global Interrupt                              */
     
    DMA1_Channel6_IRQn          = 16,  /* DMA1 Channel 6 global Interrupt                              */
    DMA1_Channel7_IRQn          = 17,  /* DMA1 Channel 7 global Interrupt                              */
    ADC1_2_IRQn                 = 18,  /* ADC1 and ADC2 global Interrupt                               */
    EXTI9_5_IRQn                = 23,  /* EXTI Line[9:5] Interrupts                                    */
    ATIM1_BRK_IRQn              = 24,  /* ATIM1 Break Interrupt                                        */
    ATIM1_UP_IRQn               = 25,  /* ATIM1 Update Interrupt                                       */
    ATIM1_TRG_COM_IRQn          = 26,  /* ATIM1 Trigger and Commutation Interrupt                      */
    ATIM1_CC_IRQn               = 27,  /* ATIM1 Capture Compare Interrupt                              */
    GTIM1_IRQn                  = 28,  /* GTIM1 global Interrupt                                       */
    GTIM2_IRQn                  = 29,  /* GTIM2 global Interrupt                                       */
    GTIM3_IRQn                  = 30,  /* GTIM3 global Interrupt                                       */
    I2C1_EV_IRQn                = 31,  /* I2C1 Event Interrupt                                         */
 
    I2C1_ER_IRQn                = 32,  /* I2C1 Error Interrupt                                         */
    I2C2_EV_IRQn                = 33,  /* I2C2 Event Interrupt                                         */
    I2C2_ER_IRQn                = 34,  /* I2C2 Error Interrupt                                         */
    SPI1_IRQn                   = 35,  /* SPI1 global Interrupt                                        */
    SPI2_I2S2_IRQn              = 36,  /* SPI2/I2S2 global Interrupt                                   */
    USART1_IRQn                 = 37,  /* USART1 global Interrupt                                      */
    USART2_IRQn                 = 38,  /* USART2 global Interrupt                                      */
    USART3_IRQn                 = 39,  /* USART3 global Interrupt                                      */
    EXTI15_10_IRQn              = 40,  /* EXTI Line[15:10] Interrupts                                  */
    RTCAlarm_IRQn               = 41,  /* RTC Alarm through EXTI Line17 Interrupt                      */
    ATIM2_BRK_IRQn              = 43,  /* ATIM2 Break Interrupt                                        */
    ATIM2_UP_IRQn               = 44,  /* ATIM2 Update Interrupt                                       */
    ATIM2_TRG_COM_IRQn          = 45,  /* ATIM2 Trigger and Commutation Interrupt                      */
    ATIM2_CC_IRQn               = 46,  /* ATIM2 Capture Compare Interrupt                              */
    ADC3_4_IRQn                 = 47,  /* ADC3 and ADC4 global Interrupt                               */
 
    UCDR_IRQn                   = 48,  /* UCDR error Interrupt                                         */
    GTIM4_IRQn                  = 50,  /* GTIM4 global Interrupt                                       */
    SPI3_I2S3_IRQn              = 51,  /* SPI3/I2S3 global Interrupt                                   */
    USART4_IRQn                 = 52,  /* USART4 global Interrupt                                      */
    UART5_IRQn                  = 53,  /* UART5 global Interrupt                                       */
    BTIM1_IRQn                  = 54,  /* BTIM1 global Interrupt                                       */
    BTIM2_IRQn                  = 55,  /* BTIM2 global Interrupt                                       */
    DMA2_Channel1_IRQn          = 56,  /* DMA2 Channel 1 global Interrupt                              */
    DMA2_Channel2_IRQn          = 57,  /* DMA2 Channel 2 global Interrupt                              */
    DMA2_Channel3_IRQn          = 58,  /* DMA2 Channel 3 global Interrupt                              */
    DMA2_Channel4_IRQn          = 59,  /* DMA2 Channel 4 global Interrupt                              */
    DMA2_Channel5_IRQn          = 60,  /* DMA2 Channel 5 global Interrupt                              */
    SRAM_ERR_IRQn               = 61,  /* SRAM ECC error Interrupt                                     */
    XSPI_IRQn                   = 67,  /* xSPI global Interrupt                                        */
    DMA2_Channel6_IRQn          = 68,  /* DMA2 Channel 6 global Interrupt                              */
    DMA2_Channel7_IRQn          = 69,  /* DMA2 Channel 7 global Interrupt                              */
    I2C3_EV_IRQn                = 70,  /* I2C3 Event Interrupt                                         */
    I2C3_ER_IRQn                = 71,  /* I2C3 Error Interrupt                                         */
    I2C4_EV_IRQn                = 72,  /* I2C4 Event Interrupt                                         */
    I2C4_ER_IRQn                = 73,  /* I2C4 Error Interrupt                                         */
    UART6_IRQn                  = 74,  /* UART6 global Interrupt                                       */
    UART7_IRQn                  = 75,  /* UART7 global Interrupt                                       */
    DMA1_Channel8_IRQn          = 76,  /* DMA1 Channel 8 global Interrupt                              */
    DMA2_Channel8_IRQn          = 77,  /* DMA2 Channel 8 global Interrupt                              */
    SAC_IRQn                    = 79,  /* SAC global Interrupt                                         */
 
    SMPU_IRQn                   = 80,  /* SMPU global Interrupt                                        */
    USB_HS_EPx_OUT_IRQn         = 82,  /* USB HS End Point Out global Interrupt                    */
    USB_HS_EPx_IN_IRQn          = 83,  /* USB HS End Point In global Interrupt                     */
    USB_HS_WKUP_IRQn            = 84,  /* USB HS wakeup from suspend through EXTI Line23 Interrupt */
    UART8_IRQn                  = 85,  /* UART8 global Interrupt                                       */
    SPI4_IRQn                   = 86,  /* SPI4 global Interrupt                                        */
    GTIM5_IRQn                  = 89,  /* GTIM5 global Interrupt                                       */
                                      
    ATIM3_BRK_IRQn              = 99,  /* ATIM3 Break Interrupt                                        */
    ATIM3_UP_IRQn               = 100, /* ATIM3 Update Interrupt                                       */
    ATIM3_TRG_COM_IRQn          = 101, /* ATIM3 Trigger and Commutation Interrupt                      */
    ATIM3_CC_IRQn               = 102, /* ATIM3 Capture Compare Interrupt                              */
    GTIM6_IRQn                  = 103, /* GTIM6 global Interrupt                                       */
    LPTIM1_WKUP_IRQn            = 104, /* LPTIM1 wakeup through EXTI line Interrupt                    */
    LPTIM2_WKUP_IRQn            = 105, /* LPTIM2 wakeup through EXTI line Interrupt                    */
    SPI5_IRQn                   = 108, /* SPI5 global Interrupt                                        */
    SPI6_IRQn                   = 109, /* SPI6 global Interrupt                                        */
    GTIM7_IRQn                  = 110, /* GTIM7 global Interrupt                                       */
    GTIM8_IRQn                  = 111, /* GTIM8 global Interrupt                                       */

    GTIM9_IRQn                  = 112, /* GTIM9 global Interrupt                                       */
    GTIM10_IRQn                 = 113, /* GTIM10 global Interrupt                                      */
    DAC1_2_3_4_Underflow_IRQn   = 114, /* DAC1/2/3/4 underflow Interrupt                               */
    DAC5_6_7_8_Underflow_IRQn   = 115, /* DAC5/6/7/8 underflow Interrupt                               */
    USB_HS_IRQn                 = 116, /* USB HS global Interrupt                                  */
#elif defined (N32H482) || defined (N32H480)
    /******  N32H482 specific Interrupt Numbers ********************************************************/
    WWDG_IRQn                   = 0,   /* Window WatchDog Interrupt                                    */
    PVD_IRQn                    = 1,   /* PVD through EXTI Line16 detection Interrupt                  */
    RTC_TAMPER_IRQn             = 2,   /* RTC Tamper or LSE-CSS through EXTI Line19 Interrupt          */
    RTC_WKUP_IRQn               = 3,   /* RTC Wakeup timer through EXTI Line20  Interrupt              */
    FLASH_IRQn                  = 4,   /* FLASH global Interrupt                                       */
    RCC_IRQn                    = 5,   /* RCC global Interrupt                                         */
    EXTI0_IRQn                  = 6,   /* EXTI Line0 Interrupt                                         */
    EXTI1_IRQn                  = 7,   /* EXTI Line1 Interrupt                                         */
    EXTI2_IRQn                  = 8,   /* EXTI Line2 Interrupt                                         */
    EXTI3_IRQn                  = 9,   /* EXTI Line3 Interrupt                                         */
    EXTI4_IRQn                  = 10,  /* EXTI Line4 Interrupt                                         */
    DMA1_Channel1_IRQn          = 11,  /* DMA1 Channel 1 global Interrupt                              */
    DMA1_Channel2_IRQn          = 12,  /* DMA1 Channel 2 global Interrupt                              */
    DMA1_Channel3_IRQn          = 13,  /* DMA1 Channel 3 global Interrupt                              */
    DMA1_Channel4_IRQn          = 14,  /* DMA1 Channel 4 global Interrupt                              */
    DMA1_Channel5_IRQn          = 15,  /* DMA1 Channel 5 global Interrupt                              */
     
    DMA1_Channel6_IRQn          = 16,  /* DMA1 Channel 6 global Interrupt                              */
    DMA1_Channel7_IRQn          = 17,  /* DMA1 Channel 7 global Interrupt                              */
    ADC1_2_IRQn                 = 18,  /* ADC1 and ADC2 global Interrupt                               */
    USB_FS_HP_IRQn              = 19,  /* USB FS Device High Priority Interrupts                       */
    USB_FS_LP_IRQn              = 20,  /* USB FS Device Low Priority Interrupts                        */
    FDCAN1_INT0_IRQn            = 21,  /* FDCAN1 Interrupt Line 0                                      */
    FDCAN1_INT1_IRQn            = 22,  /* FDCAN1 Interrupt Line 1                                      */
    EXTI9_5_IRQn                = 23,  /* EXTI Line[9:5] Interrupts                                    */
    ATIM1_BRK_IRQn              = 24,  /* ATIM1 Break Interrupt                                        */
    ATIM1_UP_IRQn               = 25,  /* ATIM1 Update Interrupt                                       */
    ATIM1_TRG_COM_IRQn          = 26,  /* ATIM1 Trigger and Commutation Interrupt                      */
    ATIM1_CC_IRQn               = 27,  /* ATIM1 Capture Compare Interrupt                              */
    GTIM1_IRQn                  = 28,  /* GTIM1 global Interrupt                                       */
    GTIM2_IRQn                  = 29,  /* GTIM2 global Interrupt                                       */
    GTIM3_IRQn                  = 30,  /* GTIM3 global Interrupt                                       */
    I2C1_EV_IRQn                = 31,  /* I2C1 Event Interrupt                                         */
 
    I2C1_ER_IRQn                = 32,  /* I2C1 Error Interrupt                                         */
    I2C2_EV_IRQn                = 33,  /* I2C2 Event Interrupt                                         */
    I2C2_ER_IRQn                = 34,  /* I2C2 Error Interrupt                                         */
    SPI1_IRQn                   = 35,  /* SPI1 global Interrupt                                        */
    SPI2_I2S2_IRQn              = 36,  /* SPI2/I2S2 global Interrupt                                   */
    USART1_IRQn                 = 37,  /* USART1 global Interrupt                                      */
    USART2_IRQn                 = 38,  /* USART2 global Interrupt                                      */
    USART3_IRQn                 = 39,  /* USART3 global Interrupt                                      */
    EXTI15_10_IRQn              = 40,  /* EXTI Line[15:10] Interrupts                                  */
    RTCAlarm_IRQn               = 41,  /* RTC Alarm through EXTI Line17 Interrupt                      */
    USB_FS_WKUP_IRQn            = 42,  /* USB FS Device WakeUp from suspend through EXTI Line18 Interrupt*/
    ATIM2_BRK_IRQn              = 43,  /* ATIM2 Break Interrupt                                        */
    ATIM2_UP_IRQn               = 44,  /* ATIM2 Update Interrupt                                       */
    ATIM2_TRG_COM_IRQn          = 45,  /* ATIM2 Trigger and Commutation Interrupt                      */
    ATIM2_CC_IRQn               = 46,  /* ATIM2 Capture Compare Interrupt                              */
    ADC3_4_IRQn                 = 47,  /* ADC3 and ADC4 global Interrupt                               */
 
    UCDR_IRQn                   = 48,  /* UCDR error Interrupt                                         */
    SDIO_IRQn                   = 49,  /* SDIO global Interrupt                                        */
    GTIM4_IRQn                  = 50,  /* GTIM4 global Interrupt                                       */
    SPI3_I2S3_IRQn              = 51,  /* SPI3/I2S3 global Interrupt                                   */
    USART4_IRQn                 = 52,  /* USART4 global Interrupt                                      */
    UART5_IRQn                  = 53,  /* UART5 global Interrupt                                       */
    BTIM1_IRQn                  = 54,  /* BTIM1 global Interrupt                                       */
    BTIM2_IRQn                  = 55,  /* BTIM2 global Interrupt                                       */
    DMA2_Channel1_IRQn          = 56,  /* DMA2 Channel 1 global Interrupt                              */
    DMA2_Channel2_IRQn          = 57,  /* DMA2 Channel 2 global Interrupt                              */
    DMA2_Channel3_IRQn          = 58,  /* DMA2 Channel 3 global Interrupt                              */
    DMA2_Channel4_IRQn          = 59,  /* DMA2 Channel 4 global Interrupt                              */
    DMA2_Channel5_IRQn          = 60,  /* DMA2 Channel 5 global Interrupt                              */
    SRAM_ERR_IRQn               = 61,  /* SRAM ECC error Interrupt                                     */
    FDCAN2_INT0_IRQn            = 63,  /* FDCAN2 Interrupt 0                                           */
 
    FDCAN2_INT1_IRQn            = 64,  /* FDCAN2 Interrupt 1                                           */
    FDCAN3_INT0_IRQn            = 65,  /* FDCAN3 Interrupt 0                                           */
    FDCAN3_INT1_IRQn            = 66,  /* FDCAN3 Interrupt 1                                           */
    XSPI_IRQn                   = 67,  /* xSPI global Interrupt                                        */
    DMA2_Channel6_IRQn          = 68,  /* DMA2 Channel 6 global Interrupt                              */
    DMA2_Channel7_IRQn          = 69,  /* DMA2 Channel 7 global Interrupt                              */
    I2C3_EV_IRQn                = 70,  /* I2C3 Event Interrupt                                         */
    I2C3_ER_IRQn                = 71,  /* I2C3 Error Interrupt                                         */
    I2C4_EV_IRQn                = 72,  /* I2C4 Event Interrupt                                         */
    I2C4_ER_IRQn                = 73,  /* I2C4 Error Interrupt                                         */
    UART6_IRQn                  = 74,  /* UART6 global Interrupt                                       */
    UART7_IRQn                  = 75,  /* UART7 global Interrupt                                       */
    DMA1_Channel8_IRQn          = 76,  /* DMA1 Channel 8 global Interrupt                              */
    DMA2_Channel8_IRQn          = 77,  /* DMA2 Channel 8 global Interrupt                              */
    SAC_IRQn                    = 79,  /* SAC global Interrupt                                         */
 
    SMPU_IRQn                   = 80,  /* SMPU global Interrupt                                        */
    USB_HS_EPx_OUT_IRQn         = 82,  /* USB HS End Point Out global Interrupt                    */
    USB_HS_EPx_IN_IRQn          = 83,  /* USB HS End Point In global Interrupt                     */
    USB_HS_WKUP_IRQn            = 84,  /* USB HS wakeup from suspend through EXTI Line23 Interrupt */
    UART8_IRQn                  = 85,  /* UART8 global Interrupt                                       */
    SPI4_IRQn                   = 86,  /* SPI4 global Interrupt                                        */
    GTIM5_IRQn                  = 89,  /* GTIM5 global Interrupt                                       */
                                      
    ATIM3_BRK_IRQn              = 99,  /* ATIM3 Break Interrupt                                        */
    ATIM3_UP_IRQn               = 100, /* ATIM3 Update Interrupt                                       */
    ATIM3_TRG_COM_IRQn          = 101, /* ATIM3 Trigger and Commutation Interrupt                      */
    ATIM3_CC_IRQn               = 102, /* ATIM3 Capture Compare Interrupt                              */
    GTIM6_IRQn                  = 103, /* GTIM6 global Interrupt                                       */
    LPTIM1_WKUP_IRQn            = 104, /* LPTIM1 wakeup through EXTI line Interrupt                    */
    LPTIM2_WKUP_IRQn            = 105, /* LPTIM2 wakeup through EXTI line Interrupt                    */
    FMAC_IRQn                   = 106, /* FMAC global Interrupt                                        */
    Cordic_IRQn                 = 107, /* Cordic global Interrupt                                      */
    SPI5_IRQn                   = 108, /* SPI5 global Interrupt                                        */
    SPI6_IRQn                   = 109, /* SPI6 global Interrupt                                        */
    GTIM7_IRQn                  = 110, /* GTIM7 global Interrupt                                       */
    GTIM8_IRQn                  = 111, /* GTIM8 global Interrupt                                       */

    GTIM9_IRQn                  = 112, /* GTIM9 global Interrupt                                       */
    GTIM10_IRQn                 = 113, /* GTIM10 global Interrupt                                      */
    DAC1_2_3_4_Underflow_IRQn   = 114, /* DAC1/2/3/4 underflow Interrupt                               */
    DAC5_6_7_8_Underflow_IRQn   = 115, /* DAC5/6/7/8 underflow Interrupt                               */
    USB_HS_IRQn                 = 116, /* USB HS global Interrupt                                  */
    FEMC_IRQn                   = 117  /* FEMC nand Interrupt                                            */
#elif defined (N32H487)
    /******  N32H487 specific Interrupt Numbers ********************************************************/
    WWDG_IRQn                   = 0,   /* Window WatchDog Interrupt                                    */
    PVD_IRQn                    = 1,   /* PVD through EXTI Line16 detection Interrupt                  */
    RTC_TAMPER_IRQn             = 2,   /* RTC Tamper or LSE-CSS through EXTI Line19 Interrupt          */
    RTC_WKUP_IRQn               = 3,   /* RTC Wakeup timer through EXTI Line20  Interrupt              */
    FLASH_IRQn                  = 4,   /* FLASH global Interrupt                                       */
    RCC_IRQn                    = 5,   /* RCC global Interrupt                                         */
    EXTI0_IRQn                  = 6,   /* EXTI Line0 Interrupt                                         */
    EXTI1_IRQn                  = 7,   /* EXTI Line1 Interrupt                                         */
    EXTI2_IRQn                  = 8,   /* EXTI Line2 Interrupt                                         */
    EXTI3_IRQn                  = 9,   /* EXTI Line3 Interrupt                                         */
    EXTI4_IRQn                  = 10,  /* EXTI Line4 Interrupt                                         */
    DMA1_Channel1_IRQn          = 11,  /* DMA1 Channel 1 global Interrupt                              */
    DMA1_Channel2_IRQn          = 12,  /* DMA1 Channel 2 global Interrupt                              */
    DMA1_Channel3_IRQn          = 13,  /* DMA1 Channel 3 global Interrupt                              */
    DMA1_Channel4_IRQn          = 14,  /* DMA1 Channel 4 global Interrupt                              */
    DMA1_Channel5_IRQn          = 15,  /* DMA1 Channel 5 global Interrupt                              */
     
    DMA1_Channel6_IRQn          = 16,  /* DMA1 Channel 6 global Interrupt                              */
    DMA1_Channel7_IRQn          = 17,  /* DMA1 Channel 7 global Interrupt                              */
    ADC1_2_IRQn                 = 18,  /* ADC1 and ADC2 global Interrupt                               */
    USB_FS_HP_IRQn              = 19,  /* USB FS Device High Priority Interrupts                       */
    USB_FS_LP_IRQn              = 20,  /* USB FS Device Low Priority Interrupts                        */
    FDCAN1_INT0_IRQn            = 21,  /* FDCAN1 Interrupt Line 0                                      */
    FDCAN1_INT1_IRQn            = 22,  /* FDCAN1 Interrupt Line 1                                      */
    EXTI9_5_IRQn                = 23,  /* EXTI Line[9:5] Interrupts                                    */
    ATIM1_BRK_IRQn              = 24,  /* ATIM1 Break Interrupt                                        */
    ATIM1_UP_IRQn               = 25,  /* ATIM1 Update Interrupt                                       */
    ATIM1_TRG_COM_IRQn          = 26,  /* ATIM1 Trigger and Commutation Interrupt                      */
    ATIM1_CC_IRQn               = 27,  /* ATIM1 Capture Compare Interrupt                              */
    GTIM1_IRQn                  = 28,  /* GTIM1 global Interrupt                                       */
    GTIM2_IRQn                  = 29,  /* GTIM2 global Interrupt                                       */
    GTIM3_IRQn                  = 30,  /* GTIM3 global Interrupt                                       */
    I2C1_EV_IRQn                = 31,  /* I2C1 Event Interrupt                                         */
 
    I2C1_ER_IRQn                = 32,  /* I2C1 Error Interrupt                                         */
    I2C2_EV_IRQn                = 33,  /* I2C2 Event Interrupt                                         */
    I2C2_ER_IRQn                = 34,  /* I2C2 Error Interrupt                                         */
    SPI1_IRQn                   = 35,  /* SPI1 global Interrupt                                        */
    SPI2_I2S2_IRQn              = 36,  /* SPI2/I2S2 global Interrupt                                   */
    USART1_IRQn                 = 37,  /* USART1 global Interrupt                                      */
    USART2_IRQn                 = 38,  /* USART2 global Interrupt                                      */
    USART3_IRQn                 = 39,  /* USART3 global Interrupt                                      */
    EXTI15_10_IRQn              = 40,  /* EXTI Line[15:10] Interrupts                                  */
    RTCAlarm_IRQn               = 41,  /* RTC Alarm through EXTI Line17 Interrupt                      */
    USB_FS_WKUP_IRQn            = 42,  /* USB FS Device WakeUp from suspend through EXTI Line18 Interrupt*/
    ATIM2_BRK_IRQn              = 43,  /* ATIM2 Break Interrupt                                        */
    ATIM2_UP_IRQn               = 44,  /* ATIM2 Update Interrupt                                       */
    ATIM2_TRG_COM_IRQn          = 45,  /* ATIM2 Trigger and Commutation Interrupt                      */
    ATIM2_CC_IRQn               = 46,  /* ATIM2 Capture Compare Interrupt                              */
    ADC3_4_IRQn                 = 47,  /* ADC3 and ADC4 global Interrupt                               */
 
    UCDR_IRQn                   = 48,  /* UCDR error Interrupt                                         */
    SDIO_IRQn                   = 49,  /* SDIO global Interrupt                                        */
    GTIM4_IRQn                  = 50,  /* GTIM4 global Interrupt                                       */
    SPI3_I2S3_IRQn              = 51,  /* SPI3/I2S3 global Interrupt                                   */
    USART4_IRQn                 = 52,  /* USART4 global Interrupt                                      */
    UART5_IRQn                  = 53,  /* UART5 global Interrupt                                       */
    BTIM1_IRQn                  = 54,  /* BTIM1 global Interrupt                                       */
    BTIM2_IRQn                  = 55,  /* BTIM2 global Interrupt                                       */
    DMA2_Channel1_IRQn          = 56,  /* DMA2 Channel 1 global Interrupt                              */
    DMA2_Channel2_IRQn          = 57,  /* DMA2 Channel 2 global Interrupt                              */
    DMA2_Channel3_IRQn          = 58,  /* DMA2 Channel 3 global Interrupt                              */
    DMA2_Channel4_IRQn          = 59,  /* DMA2 Channel 4 global Interrupt                              */
    DMA2_Channel5_IRQn          = 60,  /* DMA2 Channel 5 global Interrupt                              */
    SRAM_ERR_IRQn               = 61,  /* SRAM ECC error Interrupt                                     */
    FDCAN2_INT0_IRQn            = 63,  /* FDCAN2 Interrupt 0                                           */
 
    FDCAN2_INT1_IRQn            = 64,  /* FDCAN2 Interrupt 1                                           */
    FDCAN3_INT0_IRQn            = 65,  /* FDCAN3 Interrupt 0                                           */
    FDCAN3_INT1_IRQn            = 66,  /* FDCAN3 Interrupt 1                                           */
    XSPI_IRQn                   = 67,  /* xSPI global Interrupt                                        */
    DMA2_Channel6_IRQn          = 68,  /* DMA2 Channel 6 global Interrupt                              */
    DMA2_Channel7_IRQn          = 69,  /* DMA2 Channel 7 global Interrupt                              */
    I2C3_EV_IRQn                = 70,  /* I2C3 Event Interrupt                                         */
    I2C3_ER_IRQn                = 71,  /* I2C3 Error Interrupt                                         */
    I2C4_EV_IRQn                = 72,  /* I2C4 Event Interrupt                                         */
    I2C4_ER_IRQn                = 73,  /* I2C4 Error Interrupt                                         */
    UART6_IRQn                  = 74,  /* UART6 global Interrupt                                       */
    UART7_IRQn                  = 75,  /* UART7 global Interrupt                                       */
    DMA1_Channel8_IRQn          = 76,  /* DMA1 Channel 8 global Interrupt                              */
    DMA2_Channel8_IRQn          = 77,  /* DMA2 Channel 8 global Interrupt                              */
    DVP_IRQn                    = 78,  /* DVP global Interrupt                                         */
    SAC_IRQn                    = 79,  /* SAC global Interrupt                                         */
 
    SMPU_IRQn                   = 80,  /* SMPU global Interrupt                                        */
    USB_HS_EPx_OUT_IRQn         = 82,  /* USB HS End Point Out global Interrupt                    */
    USB_HS_EPx_IN_IRQn          = 83,  /* USB HS End Point In global Interrupt                     */
    USB_HS_WKUP_IRQn            = 84,  /* USB HS wakeup from suspend through EXTI Line23 Interrupt */
    UART8_IRQn                  = 85,  /* UART8 global Interrupt                                       */
    SPI4_IRQn                   = 86,  /* SPI4 global Interrupt                                        */
    ETH_IRQn                    = 87,  /* ETH global Interrupt                                         */
    ETH_WKUP_IRQn               = 88,  /* ETH wakeup through EXTI Line27 Interrupt                     */
    GTIM5_IRQn                  = 89,  /* GTIM5 global Interrupt                                       */
                                      
    ATIM3_BRK_IRQn              = 99,  /* ATIM3 Break Interrupt                                        */
    ATIM3_UP_IRQn               = 100, /* ATIM3 Update Interrupt                                       */
    ATIM3_TRG_COM_IRQn          = 101, /* ATIM3 Trigger and Commutation Interrupt                      */
    ATIM3_CC_IRQn               = 102, /* ATIM3 Capture Compare Interrupt                              */
    GTIM6_IRQn                  = 103, /* GTIM6 global Interrupt                                       */
    LPTIM1_WKUP_IRQn            = 104, /* LPTIM1 wakeup through EXTI line Interrupt                    */
    LPTIM2_WKUP_IRQn            = 105, /* LPTIM2 wakeup through EXTI line Interrupt                    */
    FMAC_IRQn                   = 106, /* FMAC global Interrupt                                        */
    Cordic_IRQn                 = 107, /* Cordic global Interrupt                                      */
    SPI5_IRQn                   = 108, /* SPI5 global Interrupt                                        */
    SPI6_IRQn                   = 109, /* SPI6 global Interrupt                                        */
    GTIM7_IRQn                  = 110, /* GTIM7 global Interrupt                                       */
    GTIM8_IRQn                  = 111, /* GTIM8 global Interrupt                                       */

    GTIM9_IRQn                  = 112, /* GTIM9 global Interrupt                                       */
    GTIM10_IRQn                 = 113, /* GTIM10 global Interrupt                                      */
    DAC1_2_3_4_Underflow_IRQn   = 114, /* DAC1/2/3/4 underflow Interrupt                               */
    DAC5_6_7_8_Underflow_IRQn   = 115, /* DAC5/6/7/8 underflow Interrupt                               */
    USB_HS_IRQn                 = 116, /* USB HS global Interrupt                                  */
    FEMC_IRQn                   = 117  /* FEMC nand Interrupt                                          */
#elif defined (N32H488)
    /******  N32H488 specific Interrupt Numbers ********************************************************/
    WWDG_IRQn                   = 0,   /* Window WatchDog Interrupt                                    */
    PVD_IRQn                    = 1,   /* PVD through EXTI Line16 detection Interrupt                  */
    RTC_TAMPER_IRQn             = 2,   /* RTC Tamper or LSE-CSS through EXTI Line19 Interrupt          */
    RTC_WKUP_IRQn               = 3,   /* RTC Wakeup timer through EXTI Line20  Interrupt              */
    FLASH_IRQn                  = 4,   /* FLASH global Interrupt                                       */
    RCC_IRQn                    = 5,   /* RCC global Interrupt                                         */
    EXTI0_IRQn                  = 6,   /* EXTI Line0 Interrupt                                         */
    EXTI1_IRQn                  = 7,   /* EXTI Line1 Interrupt                                         */
    EXTI2_IRQn                  = 8,   /* EXTI Line2 Interrupt                                         */
    EXTI3_IRQn                  = 9,   /* EXTI Line3 Interrupt                                         */
    EXTI4_IRQn                  = 10,  /* EXTI Line4 Interrupt                                         */
    DMA1_Channel1_IRQn          = 11,  /* DMA1 Channel 1 global Interrupt                              */
    DMA1_Channel2_IRQn          = 12,  /* DMA1 Channel 2 global Interrupt                              */
    DMA1_Channel3_IRQn          = 13,  /* DMA1 Channel 3 global Interrupt                              */
    DMA1_Channel4_IRQn          = 14,  /* DMA1 Channel 4 global Interrupt                              */
    DMA1_Channel5_IRQn          = 15,  /* DMA1 Channel 5 global Interrupt                              */
     
    DMA1_Channel6_IRQn          = 16,  /* DMA1 Channel 6 global Interrupt                              */
    DMA1_Channel7_IRQn          = 17,  /* DMA1 Channel 7 global Interrupt                              */
    ADC1_2_IRQn                 = 18,  /* ADC1 and ADC2 global Interrupt                               */
    USB_FS_HP_IRQn              = 19,  /* USB FS Device High Priority Interrupts                       */
    USB_FS_LP_IRQn              = 20,  /* USB FS Device Low Priority Interrupts                        */
    FDCAN1_INT0_IRQn            = 21,  /* FDCAN1 Interrupt Line 0                                      */
    FDCAN1_INT1_IRQn            = 22,  /* FDCAN1 Interrupt Line 1                                      */
    EXTI9_5_IRQn                = 23,  /* EXTI Line[9:5] Interrupts                                    */
    ATIM1_BRK_IRQn              = 24,  /* ATIM1 Break Interrupt                                        */
    ATIM1_UP_IRQn               = 25,  /* ATIM1 Update Interrupt                                       */
    ATIM1_TRG_COM_IRQn          = 26,  /* ATIM1 Trigger and Commutation Interrupt                      */
    ATIM1_CC_IRQn               = 27,  /* ATIM1 Capture Compare Interrupt                              */
    GTIM1_IRQn                  = 28,  /* GTIM1 global Interrupt                                       */
    GTIM2_IRQn                  = 29,  /* GTIM2 global Interrupt                                       */
    GTIM3_IRQn                  = 30,  /* GTIM3 global Interrupt                                       */
    I2C1_EV_IRQn                = 31,  /* I2C1 Event Interrupt                                         */
 
    I2C1_ER_IRQn                = 32,  /* I2C1 Error Interrupt                                         */
    I2C2_EV_IRQn                = 33,  /* I2C2 Event Interrupt                                         */
    I2C2_ER_IRQn                = 34,  /* I2C2 Error Interrupt                                         */
    SPI1_IRQn                   = 35,  /* SPI1 global Interrupt                                        */
    SPI2_I2S2_IRQn              = 36,  /* SPI2/I2S2 global Interrupt                                   */
    USART1_IRQn                 = 37,  /* USART1 global Interrupt                                      */
    USART2_IRQn                 = 38,  /* USART2 global Interrupt                                      */
    USART3_IRQn                 = 39,  /* USART3 global Interrupt                                      */
    EXTI15_10_IRQn              = 40,  /* EXTI Line[15:10] Interrupts                                  */
    RTCAlarm_IRQn               = 41,  /* RTC Alarm through EXTI Line17 Interrupt                      */
    USB_FS_WKUP_IRQn            = 42,  /* USB FS Device WakeUp from suspend through EXTI Line18 Interrupt*/
    ATIM2_BRK_IRQn              = 43,  /* ATIM2 Break Interrupt                                        */
    ATIM2_UP_IRQn               = 44,  /* ATIM2 Update Interrupt                                       */
    ATIM2_TRG_COM_IRQn          = 45,  /* ATIM2 Trigger and Commutation Interrupt                      */
    ATIM2_CC_IRQn               = 46,  /* ATIM2 Capture Compare Interrupt                              */
    ADC3_4_IRQn                 = 47,  /* ADC3 and ADC4 global Interrupt                               */
 
    UCDR_IRQn                   = 48,  /* UCDR error Interrupt                                         */
    SDIO_IRQn                   = 49,  /* SDIO global Interrupt                                        */
    GTIM4_IRQn                  = 50,  /* GTIM4 global Interrupt                                       */
    SPI3_I2S3_IRQn              = 51,  /* SPI3/I2S3 global Interrupt                                   */
    USART4_IRQn                 = 52,  /* USART4 global Interrupt                                      */
    UART5_IRQn                  = 53,  /* UART5 global Interrupt                                       */
    BTIM1_IRQn                  = 54,  /* BTIM1 global Interrupt                                       */
    BTIM2_IRQn                  = 55,  /* BTIM2 global Interrupt                                       */
    DMA2_Channel1_IRQn          = 56,  /* DMA2 Channel 1 global Interrupt                              */
    DMA2_Channel2_IRQn          = 57,  /* DMA2 Channel 2 global Interrupt                              */
    DMA2_Channel3_IRQn          = 58,  /* DMA2 Channel 3 global Interrupt                              */
    DMA2_Channel4_IRQn          = 59,  /* DMA2 Channel 4 global Interrupt                              */
    DMA2_Channel5_IRQn          = 60,  /* DMA2 Channel 5 global Interrupt                              */
    SRAM_ERR_IRQn               = 61,  /* SRAM ECC error Interrupt                                     */
    COMP4_5_6_IRQn              = 62,  /* COMP4/5/6 through EXTI Line22/30/31 interrupt                */
    FDCAN2_INT0_IRQn            = 63,  /* FDCAN2 Interrupt 0                                           */
 
    FDCAN2_INT1_IRQn            = 64,  /* FDCAN2 Interrupt 1                                           */
    FDCAN3_INT0_IRQn            = 65,  /* FDCAN3 Interrupt 0                                           */
    FDCAN3_INT1_IRQn            = 66,  /* FDCAN3 Interrupt 1                                           */
    XSPI_IRQn                   = 67,  /* xSPI global Interrupt                                        */
    DMA2_Channel6_IRQn          = 68,  /* DMA2 Channel 6 global Interrupt                              */
    DMA2_Channel7_IRQn          = 69,  /* DMA2 Channel 7 global Interrupt                              */
    I2C3_EV_IRQn                = 70,  /* I2C3 Event Interrupt                                         */
    I2C3_ER_IRQn                = 71,  /* I2C3 Error Interrupt                                         */
    I2C4_EV_IRQn                = 72,  /* I2C4 Event Interrupt                                         */
    I2C4_ER_IRQn                = 73,  /* I2C4 Error Interrupt                                         */
    UART6_IRQn                  = 74,  /* UART6 global Interrupt                                       */
    UART7_IRQn                  = 75,  /* UART7 global Interrupt                                       */
    DMA1_Channel8_IRQn          = 76,  /* DMA1 Channel 8 global Interrupt                              */
    DMA2_Channel8_IRQn          = 77,  /* DMA2 Channel 8 global Interrupt                              */
    DVP_IRQn                    = 78,  /* DVP global Interrupt                                         */
    SAC_IRQn                    = 79,  /* SAC global Interrupt                                         */
 
    SMPU_IRQn                   = 80,  /* SMPU global Interrupt                                        */
    COMP1_2_3_IRQn              = 81,  /* COMP1/2/3 through EXTI Line21/28/29 Interrupt                */
    USB_HS_EPx_OUT_IRQn         = 82,  /* USB HS End Point Out global Interrupt                    */
    USB_HS_EPx_IN_IRQn          = 83,  /* USB HS End Point In global Interrupt                     */
    USB_HS_WKUP_IRQn            = 84,  /* USB HS wakeup from suspend through EXTI Line23 Interrupt */
    UART8_IRQn                  = 85,  /* UART8 global Interrupt                                       */
    SPI4_IRQn                   = 86,  /* SPI4 global Interrupt                                        */
    ETH_IRQn                    = 87,  /* ETH global Interrupt                                         */
    ETH_WKUP_IRQn               = 88,  /* ETH wakeup through EXTI Line27 Interrupt                     */
    GTIM5_IRQn                  = 89,  /* GTIM5 global Interrupt                                       */
    COMP7_IRQn                  = 90,  /* COMP7 through EXTI Line24 Interrupt                          */
    SHRT1_MST_IRQn              = 91,  /* SHRTIM1 master Interrupt                                     */
    SHRT1_TIMA_IRQn             = 92,  /* SHRTIM1 timer A Interrupt                                    */
    SHRT1_TIMB_IRQn             = 93,  /* SHRTIM1 timer B Interrupt                                    */
    SHRT1_TIMC_IRQn             = 94,  /* SHRTIM1 timer C Interrupt                                    */
    SHRT1_TIMD_IRQn             = 95,  /* SHRTIM1 timer D Interrupt                                    */

    SHRT1_TIME_IRQn             = 96,  /* SHRTIM1 timer E Interrupt                                    */
    SHRT1_TIMF_IRQn             = 97,  /* SHRTIM1 timer F Interrupt                                    */
    SHRT1_FLT_IRQn              = 98,  /* SHRTIM1 fault Interrupt                                      */
                                      
    ATIM3_BRK_IRQn              = 99,  /* ATIM3 Break Interrupt                                        */
    ATIM3_UP_IRQn               = 100, /* ATIM3 Update Interrupt                                       */
    ATIM3_TRG_COM_IRQn          = 101, /* ATIM3 Trigger and Commutation Interrupt                      */
    ATIM3_CC_IRQn               = 102, /* ATIM3 Capture Compare Interrupt                              */
    GTIM6_IRQn                  = 103, /* GTIM6 global Interrupt                                       */
    LPTIM1_WKUP_IRQn            = 104, /* LPTIM1 wakeup through EXTI line Interrupt                    */
    LPTIM2_WKUP_IRQn            = 105, /* LPTIM2 wakeup through EXTI line Interrupt                    */
    FMAC_IRQn                   = 106, /* FMAC global Interrupt                                        */
    Cordic_IRQn                 = 107, /* Cordic global Interrupt                                      */
    SPI5_IRQn                   = 108, /* SPI5 global Interrupt                                        */
    SPI6_IRQn                   = 109, /* SPI6 global Interrupt                                        */
    GTIM7_IRQn                  = 110, /* GTIM7 global Interrupt                                       */
    GTIM8_IRQn                  = 111, /* GTIM8 global Interrupt                                       */

    GTIM9_IRQn                  = 112, /* GTIM9 global Interrupt                                       */
    GTIM10_IRQn                 = 113, /* GTIM10 global Interrupt                                      */
    DAC1_2_3_4_Underflow_IRQn   = 114, /* DAC1/2/3/4 underflow Interrupt                               */
    DAC5_6_7_8_Underflow_IRQn   = 115, /* DAC5/6/7/8 underflow Interrupt                               */
    USB_HS_IRQn                 = 116, /* USB HS global Interrupt                                  */
    FEMC_IRQn                   = 117  /* FEMC nand Interrupt                                          */
#endif
} IRQn_Type;

#include "core_cm4.h"
#include "system_n32h47x_48x.h"
#include <stdint.h>
#include <stdbool.h>

typedef int32_t s32;
typedef int16_t s16;
typedef int8_t s8;

typedef const int32_t sc32; /* Read Only */
typedef const int16_t sc16; /* Read Only */
typedef const int8_t sc8;   /* Read Only */

typedef __IO int32_t vs32;
typedef __IO int16_t vs16;
typedef __IO int8_t vs8;

typedef __I int32_t vsc32; /* Read Only */
typedef __I int16_t vsc16; /* Read Only */
typedef __I int8_t vsc8;   /* Read Only */

typedef uint32_t u32;
typedef uint16_t u16;
typedef uint8_t u8;

typedef const uint32_t uc32; /* Read Only */
typedef const uint16_t uc16; /* Read Only */
typedef const uint8_t uc8;   /* Read Only */

typedef __IO uint32_t vu32;
typedef __IO uint16_t vu16;
typedef __IO uint8_t vu8;

typedef __I uint32_t vuc32; /* Read Only */
typedef __I uint16_t vuc16; /* Read Only */
typedef __I uint8_t vuc8;   /* Read Only */
typedef enum
{
    RESET = 0,
    SET   = !RESET
} FlagStatus,
    INTStatus;

typedef enum
{
    DISABLE = 0,
    ENABLE  = !DISABLE
} FunctionalState,FunctionalStatus;
#define IS_FUNCTIONAL_STATE(STATE) (((STATE) == DISABLE) || ((STATE) == ENABLE))

typedef enum
{
    ERROR   = 0,
    SUCCESS = !ERROR
} ErrorStatus;

/* N32H47X_48X Standard Peripheral Library old definitions (maintained for legacy purpose) */
#define HSEStartUp_TimeOut HSE_STARTUP_TIMEOUT
#define HSE_Value          HSE_VALUE
#define HSI_Value          HSI_VALUE

/**
 * @brief FMAC
 */
typedef struct
{
    __IO uint32_t X1BUFCFG; //0x00 
    __IO uint32_t X2BUFCFG; //0x04      
    __IO uint32_t YBUFCFG;  //0x08 
    __IO uint32_t PARAMCFG; //0x0C   
    __IO uint32_t CTRL;     //0x10
    __IO uint32_t STS;      //0x14
    __IO uint32_t WDAT;     //0x18
    __IO uint32_t RDAT;     //0x1C 
} FMAC_Module;  


/*** CORDIC ***/
typedef struct
{
    __IO uint32_t CTRLSTS; /* Offset: 0x0000 */
    __IO uint32_t WDAT;    /* Offset: 0x0004 */     
    __IO uint32_t RDAT;    /* Offset: 0x0008 */
} CORDIC_Module;


/**
 * @brief Analog to Digital Converter
 */
typedef struct
{
    __IO uint32_t STS;      //0x00
    __IO uint32_t CTRL1;    //0x04
    __IO uint32_t CTRL2;    //0x08
    __IO uint32_t CTRL3;    //0x0C
    __IO uint32_t SAMPT1;   //0x10
    __IO uint32_t SAMPT2;   //0x14
    __IO uint32_t SAMPT3;   //0x18
    __IO uint32_t DIFSEL;   //0x1C
    __IO uint32_t CALFACT;  //0x20
    __IO uint32_t OFFSET1;  //0x24
    __IO uint32_t OFFSET2;  //0x28
    __IO uint32_t OFFSET3;  //0x2C
    __IO uint32_t OFFSET4;  //0x30
    __IO uint32_t WDG1HIGH; //0x34
    __IO uint32_t WDG1LOW;  //0x38
    __IO uint32_t WDG2HIGH; //0x3C
    __IO uint32_t WDG2LOW;  //0x40
    __IO uint32_t WDG3HIGH; //0x44
    __IO uint32_t WDG3LOW;  //0x48
    __IO uint32_t WDG2EN;   //0x4C
    __IO uint32_t WDG3EN;   //0x50
    __IO uint32_t WDG2INTEN;//0x54
    __IO uint32_t WDG3INTEN;//0x58
    __IO uint32_t WDG2STS;  //0x5C
    __IO uint32_t WDG3STS;  //0x60
    __IO uint32_t RSEQ1;    //0x64
    __IO uint32_t RSEQ2;    //0x68
    __IO uint32_t RSEQ3;    //0x6C
    __IO uint32_t JSEQ;     //0x70
    __IO uint32_t JDAT1;    //0x74
    __IO uint32_t JDAT2;    //0x78
    __IO uint32_t JDAT3;    //0x7C
    __IO uint32_t JDAT4;    //0x80
    __IO uint32_t DAT;      //0x84
    __IO uint32_t FIFOCFG;  //0x88
    __IO uint32_t FIFOSTS;  //0x8C
    __IO uint32_t PCTRL;    //0x90
    __IO uint32_t CTRL4;    //0x94
    __IO uint32_t INTEN;    //0x98
    __IO uint32_t GCOMP;    //0x9C
} ADC_Module;

/**
 * @brief PGA_Single
 */
typedef struct
{
    __IO uint32_t CTRL;
    __IO uint32_t TRIM;
    __IO uint32_t RES[2];
} PGA_SingleType;

/**
 * @brief PGA
 */
typedef struct
{
    PGA_SingleType Pga[4];  //0x00
    __IO uint32_t LOCK;     //0x40
    __IO uint32_t RES[3];    
    __IO uint32_t IBIASEN;  //0x50
} PGA_Module;

/**
 * @brief COMP_Single
 */
typedef struct
{
    __IO uint32_t CTRL;
    __IO uint32_t FILC;
    __IO uint32_t FILP;
    __IO uint32_t RES;
} COMP_SingleType;

/**
 * @brief COMP
 */
typedef struct
{
    __IO uint32_t RES4[4];  
    COMP_SingleType Cmp[7]; //0x10
    __IO uint32_t RES0[2];  
    __IO uint32_t WINMODE;  //0x88
    __IO uint32_t LOCK;     //0x8C
    __IO uint32_t INTEN;    //0x90
    __IO uint32_t INTSTS;   //0x94
    __IO uint32_t INVREF;   //0x98
    __IO uint32_t OTIMEN;   //0x9C
} COMP_Module;


/**
 * @brief Digital to Analog Converter
 */
typedef struct
{
    __IO uint32_t CTRL;     //0x00
    __IO uint32_t SOTTR;    //0x04
    __IO uint32_t DATO1;    //0x08
    __IO uint32_t DATO2;    //0x0C
    __IO uint32_t DR8CH1;   //0x10
    __IO uint32_t DL12CH1;  //0x14
    __IO uint32_t DR12CH1;  //0x18
    __IO uint32_t DR8CH2;   //0x1C
    __IO uint32_t DL12CH2;  //0x20
    __IO uint32_t DR12CH2;  //0x24
    __IO uint32_t DR8DCH;   //0x28
    __IO uint32_t DL12DCH;  //0x2C
    __IO uint32_t DR12DCH;  //0x30
    __IO uint32_t RES0;     //0x34
    __IO uint32_t SELCTRL;  //0x38
    __IO uint32_t STS;      //0x3C
    __IO uint32_t GCTRL;    //0x40
    __IO uint32_t STINC;    //0x44
    __IO uint32_t STRST;    //0x48
    __IO uint32_t RES1[4];  
    __IO uint32_t CALC;     //0x5C
} DAC_Module;


/*** CRC calculation unit ***/
typedef struct
{
    __IO uint32_t CRC32CTRL;    //0x00
    __IO uint32_t CRC32DAT;     //0x04
    __IO uint8_t  CRC32IDAT;    //0x08    
    uint8_t RESERVED0;
    uint16_t RESERVED1;
    __IO uint32_t CRC32D;       //0x0C 
    __IO uint32_t CRC16CTRL;    //0x10 
    __IO uint8_t  CRC16DAT;     //0x14
    uint8_t RESERVED2;
    uint16_t RESERVED3;
    __IO uint16_t CRC16D;       //0x18 
    uint16_t RESERVED4;
    __IO uint8_t LRC;           //0x1C
    uint8_t RESERVED5;
    uint16_t RESERVED6;            
} CRC_Module;

/**
 * @brief Digital to Analog Converter
 */

/**
 * @brief USB
 */

/** Flexible Extended Memory Controller SRAM/NOR Flash **/
typedef struct
{
    __IO uint32_t   CTRL;
    __IO uint32_t   TCFG;
    __IO uint32_t   WTCFG;
} FEMC_SN_Bank_Block;

/** Flexible Extended Memory Controller NAND **/
typedef struct
{
    __IO uint32_t CTRL;
    __IO uint32_t STS;
    __IO uint32_t CMEMTM;
    __IO uint32_t ATTMEMTM;
    uint32_t RESERVED0;
    __IO uint32_t ECC;
    uint32_t RESERVED1[2];
} FEMC_NAND_Bank;


typedef struct 
{
    FEMC_SN_Bank_Block  block1;
    FEMC_SN_Bank_Block  block2;
    FEMC_SN_Bank_Block  block3;
    FEMC_SN_Bank_Block  block4;
    uint32_t            RESERVED0[12];
    FEMC_NAND_Bank      bank2;
    FEMC_NAND_Bank      bank3;
} FEMC_Module;


/*** USB Full speed Device ***/
typedef struct
{
    __IO uint32_t EP0;              /* Endpoint0 control register     Address offset: 0x00 */      
    __IO uint32_t EP1;              /* Endpoint1 control register     Address offset: 0x04 */ 
    __IO uint32_t EP2;              /* Endpoint2 control register     Address offset: 0x08 */     
    __IO uint32_t EP3;              /* Endpoint3 control register     Address offset: 0x0C */ 
    __IO uint32_t EP4;              /* Endpoint4 control register     Address offset: 0x10 */     
    __IO uint32_t EP5;              /* Endpoint5 control register     Address offset: 0x14 */ 
    __IO uint32_t EP6;              /* Endpoint6 control register     Address offset: 0x18 */ 
    __IO uint32_t EP7;              /* Endpoint7 control register     Address offset: 0x1C */ 
    __IO uint32_t Reserve20h;
    __IO uint32_t Reserve24h;
    __IO uint32_t Reserve28h;
    __IO uint32_t Reserve2Ch;
    __IO uint32_t Reserve30h;
    __IO uint32_t Reserve34h;
    __IO uint32_t Reserve38h;
    __IO uint32_t Reserve3Ch;
    __IO uint32_t CTRL;             /* USBFS control register                           Address offset: 0x40*/     
    __IO uint32_t STS;              /* USBFS Status register                            Address offset: 0x44*/
    __IO uint32_t BUFTAB;           /* USBFS buffer describes table address register    Address offset: 0x48*/
    __IO uint32_t FN;               /* USBFS Frame number register                      Address offset: 0x4C*/
    __IO uint32_t ADDR;             /* USBFS device address register                    Address offset: 0x50*/
} USBFS_Module;

/*** USB High Speed Global Register ***/

typedef struct
{
    __IO uint32_t GCTRLSTS;                 /* USBHS global Control and Status Register     Address offset: 0x000 */
    uint32_t Reserved04;                    /* Reserved04                                   Address offset: 0x004 */
    __IO uint32_t GAHBCFG;                  /* Core AHB Configuration Register              Address offset: 0x008 */
    __IO uint32_t GCFG;                     /* Core USB Configuration Register              Address offset: 0x00C */
    __IO uint32_t GRSTCTRL;                 /* Core Reset Register                          Address offset: 0x010 */
    __IO uint32_t GINTSTS;                  /* Core Interrupt Register                      Address offset: 0x014 */
    __IO uint32_t GINTEN;                   /* Core Interrupt Mask Register                 Address offset: 0x018 */
    __IO uint32_t GRXSTS;                   /* Receive Sts Q Read Register                  Address offset: 0x01C */
    __IO uint32_t GRXSTSP;                  /* Receive Sts Q Read & POP Register            Address offset: 0x020 */
    __IO uint32_t GRXFSIZ;                  /* Receive FIFO Size Register                   Address offset: 0x024 */
    __IO uint32_t GNPTXFSIZ_DINEP0TXFSIZ;   /* Non Periodic/EP0 Tx FIFO Size/ Register      Address offset: 0x028 */
    __IO uint32_t GNPTXFSTS;                /* Non Periodic Tx FIFO/Queue Sts reg           Address offset: 0x02C */
    uint32_t Reserved30[3];                 /* Reserved                                     Address offset: 0x030 */
    __IO uint32_t CID;                      /* User ID Register                             Address offset: 0x03C */
    __IO uint32_t Reserved40[6];            /* Reserved40                                   Address offset: 0x040 */
    __IO uint32_t GPD;                      /* Power Down Register                          Address offset: 0x058 */
    __IO uint32_t GDFCFG;                   /* DFIFO Software Config Register               Address offset: 0x05C */
    uint32_t  Reserved58[40];               /* Reserved                                     Address offset: 0x60-0xFC */
    __IO uint32_t HPTXFSIZ;                 /* Host Periodic Tx FIFO Size Reg               Address offset: 0x100 */
    __IO uint32_t DINEPPTXFSIZ[8];          /* Device IN EP Periodic Transmit FIFO */
} USB_Global_Registers;

/*** USBHS Host Mode Register ***/
typedef struct 
{
    __IO uint32_t HCFG;                     /* Host Configuration Register                  Address offset: 0x400 */
    __IO uint32_t HFRI;                     /* Host Frame Interval Register                 Address offset: 0x404 */
    __IO uint32_t HFNUM;                    /* Host Frame number and Frame Remaining        Address offset: 0x408 */
    uint32_t Reserved0C;                    /* Reserved                                     Address offset: 0x40C */
    __IO uint32_t HPTXFQSTS;                /* Host Periodic Tx FIFO/Queue Status register  Address offset: 0x410 */
    __IO uint32_t HACHINT;                  /* Host All Channels Interrupt Register         Address offset: 0x414 */
    __IO uint32_t HACHINTEN;                /* Host All Channels Interrupt Enable           Address offset: 0x418 */
    uint32_t Reserved1C[0x0A];              /* Reserved                                     Address offset: 0x41C */
} USB_Host_Registers;

/*** USBHS Host Channel Register ***/

typedef struct
{
    __IO uint32_t HCHCTRL;                    /* Host Channel Control Register             Address offset: 0x500 */
    __IO uint32_t HCSCTRL;                    /* Host Channel Split Control Register       Address offset: 0x504 */
    __IO uint32_t HCHINTSTS;                  /* Host Channel Interrupt Register           Address offset: 0x508 */
    __IO uint32_t HCHINTEN;                   /* Host Channel Interrupt Enable Register    Address offset: 0x50C */
    __IO uint32_t HCHTXSIZ;                   /* Host Channel Transfer Size Register       Address offset: 0x510 */
    __IO uint32_t HCHDMADD;                   /* Host Channel DMA Address Register         Address offset: 0x514 */
    uint32_t Reserved[2];                     /* Reserved  */
} USB_HostCH_Registers;


/*** USBHS Device Register ***/

typedef struct 
{
    __IO uint32_t DCFG;                       /* dev Configuration Register                Address offset: 0x800 */
    __IO uint32_t DCTRL;                      /* dev Control Register                      Address offset: 0x804 */
    __IO uint32_t DSTS;                       /* dev Status Register                       Address offset: 0x808 */
    uint32_t Reserved0C;                      /* Reserved                                  Address offset: 0x80C */
    __IO uint32_t DINEPINTEN;                 /* dev IN Endpoint Interrupt Enable          Address offset: 0x810 */
    __IO uint32_t DOUTEPINTEN;                /* dev OUT Endpoint Interrupt Enable         Address offset: 0x814 */
    __IO uint32_t DAEPINTSTS;                 /* dev All Endpoints Interrupt Status        Address offset: 0x818 */
    __IO uint32_t DAEPINTEN;                  /* dev All Endpoints Interrupt Enable        Address offset: 0x81C */
    uint32_t  Reserved20[4];                  /* Reserved                                  Address offset: 0x820-0x82C*/
    __IO uint32_t DTHRCTRL;                   /* dev threshold Contrl register             Address offset: 0x830 */
    __IO uint32_t DINEPFEINTEN;               /* dev IN EP fifo empty interrupt enable     Address offset: 0x834 */
    __IO uint32_t DEEPINTSTS;                 /* Each EP interrupt Status register         Address offset: 0x838 */
    __IO uint32_t DEEPINTEN;                  /* Each EP interrupt enable                  Address offset: 0x83C */  
    __IO uint32_t DINEPXINTEN[9];             /* dedicated EP mask                         Address offset: 0x840-0x860 */
    uint32_t  Reserved64[7];                  /* Reserved                                  Address offset: 0x864-0x87C */
    __IO uint32_t DOUTEPXINTEN[16];           /* dedicated EP msk                          Address offset: 0x880-0x8A0 */   
} USB_Device_Registers;


/*** USBHS IN Endpoint Register ***/

typedef struct 
{
    __IO uint32_t DINEPCTRL;                    /* dev IN Endpoint Control Register       Address offset: 0x900 + (ep_num * 0x20) + 0x00 */
    uint32_t Reserved04;                        /* Reserved                               Address offset: 0x900 + (ep_num * 0x20) + 0x04 */
    __IO uint32_t DINEPINTSTS;                  /* dev IN Endpoint Interrupt Stauts       Address offset: 0x900 + (ep_num * 0x20) + 0x08 */
    uint32_t Reserved0C;                        /* Reserved                               Address offset: 0x900 + (ep_num * 0x20) + 0x0C */
    __IO uint32_t DINEPTXSIZ;                   /* dev IN Endpoint Txfer Size             Address offset: 0x900 + (ep_num * 0x20) + 0x10 */
    __IO uint32_t DINEPDMADD;                   /* dev IN Endpoint DMA Address            Address offset: 0x900 + (ep_num * 0x20) + 0x14 */
    __IO uint32_t DINEPTXFSTS;                  /* dev IN Endpoint Tx FIFO Status         Address offset: 0x900 + (ep_num * 0x20) + 0x18 */
    uint32_t Reserved1C;                        /* Reserved                               Address offset: 0x900 + (ep_num * 0x20) + 0x1C */
} USB_INEP_Registers;


/*** USBHS OUT Endpoint Register ***/

typedef struct 
{  
    __IO uint32_t DOUTEPCTRL;                   /* dev OUT Endpoint Control Register      Address offset: 0xB00 + (ep_num * 0x20) + 00 */
    uint32_t Reserved04;                         /* Reserved                               Address offset: 0xB00 + (ep_num * 0x20) + 04 */
    __IO uint32_t DOUTEPINTSTS;                 /* dev OUT Endpoint Interrupt Stauts      Address offset: 0xB00 + (ep_num * 0x20) + 08 */
    uint32_t Reserved0C;                         /* Reserved                               Address offset: 0xB00 + (ep_num * 0x20) + 0C */
    __IO uint32_t DOUTEPTXSIZ;                  /* dev OUT Endpoint Txfer Size            Address offset: 0xB00 + (ep_num * 0x20) + 10 */
    __IO uint32_t DOUTEPDMADD;                  /* dev OUT Endpoint DMA Address           Address offset: 0xB00 + (ep_num * 0x20) + 14 */
    uint32_t Reserved18[2];                     /* Reserved */
} USB_OUTEP_Registers;

/*** USBHS PWR Control Register ***/

typedef struct 
{
    __IO uint32_t PWRCTRL;                     /* USBHS Power Control Register          Address offset: 0xE00 */
    __IO uint32_t PWRCTRL1;                    /* USBHS Power Control1 Register         Address offset: 0xE04 */
} USB_PWR_Registers;


/*** @brief Debug MCU ***/

typedef struct
{
    __IO uint32_t ID;           /* ID register          Address offset: 0x00 */
    __IO uint32_t CTRL;         /* Control register     Address offset: 0x04 */
} DBG_Module;



/*** DMA Controller ***/
typedef struct
{
    __IO uint32_t CHCFG; /* Offset: 0x00+0x14 * (x - 1)  DMA channel x configuration register */
    __IO uint32_t MADDR; /* Offset: 0x04+0x14 * (x - 1)  DMA channel x memory address register */
    __IO uint32_t PADDR; /* Offset: 0x08+0x14 * (x - 1)  DMA channel x peripheral address register */
    __IO uint32_t CHSEL; /* Offset: 0x0C+0x14 * (x - 1)  DMA channel x channel selection register */
    __IO uint32_t TXNUM; /* Offset: 0x10+0x14 * (x - 1)  DMA channel x transfer number register */

} DMA_ChannelType;


typedef struct
{
    __IO DMA_ChannelType DMA_Channel[8];
    __IO uint32_t INTCLR;  /* Offset: 0xA0  DMA interrupt flag register */
    __IO uint32_t INTSTS;  /* Offset: 0xA4  DMA interrupt status register */
    __IO uint32_t BURSTEN; /* Offset: 0xA8  DMA burst transfer enable register */
} DMA_Module;


/*** Ethernet MAC ***/
typedef struct
{
    __IO uint32_t MACCFG;         /* Offset: 0x0000 */
    __IO uint32_t MACEXTCFG;      /* Offset: 0x0004 */
    __IO uint32_t MACPFLT;        /* Offset: 0x0008 */
    __IO uint32_t MACWDGTO;       /* Offset: 0x000C */
    __IO uint32_t MACHASHTR0;     /* Offset: 0x0010 */
    __IO uint32_t MACHASHTR1;     /* Offset: 0x0014 */
    uint32_t      RESERVED0[14];
    __IO uint32_t MACVLANTAG;     /* Offset: 0x0050 */
    uint32_t      RESERVED1;
    __IO uint32_t MACVHASHT;      /* Offset: 0x0058 */
    uint32_t      RESERVED2[5];
    __IO uint32_t MACTXFLWCTRL;   /* Offset: 0x0070 */
    uint32_t      RESERVED3[7];
    __IO uint32_t MACRXFLWCTRL;   /* Offset: 0x0090 */
    uint32_t      RESERVED4[7];
    __IO uint32_t MACINTSTS;      /* Offset: 0x00B0 */
    __IO uint32_t MACINTEN;       /* Offset: 0x00B4 */
    __IO uint32_t MACRXTXSTS;     /* Offset: 0x00B8 */
    uint32_t      RESERVED5;
    __IO uint32_t MACPMTCTRLSTS;  /* Offset: 0x00C0 */
    __IO uint32_t MACRWUPFLT;     /* Offset: 0x00C4 */
    uint32_t      RESERVED6[18];
    __IO uint32_t MACVER;         /* Offset: 0x0110 */
    __IO uint32_t MACDBG;         /* Offset: 0x0114 */
    uint32_t      RESERVED7;
    __IO uint32_t MACHWF0;        /* Offset: 0x011C */
    __IO uint32_t MACHWF1;        /* Offset: 0x0120 */
    __IO uint32_t MACHWF2;        /* Offset: 0x0124 */
    __IO uint32_t MACHWF3;        /* Offset: 0x0128 */
    uint32_t      RESERVED8[53];
    __IO uint32_t MACMDIOADDR;    /* Offset: 0x0200 */
    __IO uint32_t MACMDIODATA;    /* Offset: 0x0204 */
    uint32_t      RESERVED9[10];
    __IO uint32_t MACCSRSWCTRL;   /* Offset: 0x0230 */
    uint32_t      RESERVED10[51];
    __IO uint32_t MACADDR0H;      /* Offset: 0x0300 */
    __IO uint32_t MACADDR0L;      /* Offset: 0x0304 */
    __IO uint32_t MACADDR1H;      /* Offset: 0x0308 */
    __IO uint32_t MACADDR1L;      /* Offset: 0x030C */
    __IO uint32_t MACADDR2H;      /* Offset: 0x0310 */
    __IO uint32_t MACADDR2L;      /* Offset: 0x0314 */
    __IO uint32_t MACADDR3H;      /* Offset: 0x0318 */
    __IO uint32_t MACADDR3L;      /* Offset: 0x031C */
    uint32_t      RESERVED11[248];
    __IO uint32_t MMCCTRL;        /* Offset: 0x0700 */
    __IO uint32_t MMCRXINT;       /* Offset: 0x0704 */
    __IO uint32_t MMCTXINT;       /* Offset: 0x0708 */
    __IO uint32_t MMCRXINTMSK;    /* Offset: 0x070C */
    __IO uint32_t MMCTXINTMSK;    /* Offset: 0x0710 */
    uint32_t      RESERVED12[14];
    __IO uint32_t MMCTXSCGP;      /* Offset: 0x074C */
    __IO uint32_t MMCTXMCGP;      /* Offset: 0x0750 */
    uint32_t      RESERVED13[5];
    __IO uint32_t MMCTXPCG;       /* Offset: 0x0768 */
    uint32_t      RESERVED14[8];
    __IO uint32_t MMCRXBPG;       /* Offset: 0x078C */
    __IO uint32_t MMCRXMPG;       /* Offset: 0x0790 */
    __IO uint32_t MMCRXCRCEP;     /* Offset: 0x0794 */
    __IO uint32_t MMCRXAEP;       /* Offset: 0x0798 */
    uint32_t      RESERVED15[10];
    __IO uint32_t MMCRXUPG;       /* Offset: 0x07C4 */
    uint32_t      RESERVED16[206];
    __IO uint32_t MACTSCTRL;      /* Offset: 0x0B00 */
    __IO uint32_t MACSUBSINC;     /* Offset: 0x0B04 */
    __IO uint32_t MACSYSTS;       /* Offset: 0x0B08 */
    __IO uint32_t MACSYSTNS;      /* Offset: 0x0B0C */
    __IO uint32_t MACSYSTSUP;     /* Offset: 0x0B10 */
    __IO uint32_t MACSYSTNSUP;    /* Offset: 0x0B14 */
    __IO uint32_t MACTSADD;       /* Offset: 0x0B18 */
    uint32_t      RESERVED17;
    __IO uint32_t MACTSSTS;       /* Offset: 0x0B20 */
    uint32_t      RESERVED18[3];
    __IO uint32_t MACTXTSSTSNS;   /* Offset: 0x0B30 */
    __IO uint32_t MACTXTSSTSS;    /* Offset: 0x0B34 */
    uint32_t      RESERVED19[8];
    __IO uint32_t MACTSIGCNS;     /* Offset: 0x0B58 */
    __IO uint32_t MACTSEGCNS;     /* Offset: 0x0B5C */
    uint32_t      RESERVED20[2];
    __IO uint32_t MACTSIGLAT;     /* Offset: 0x0B68 */
    __IO uint32_t MACTSEGLAT;     /* Offset: 0x0B6C */
    __IO uint32_t MACPPSCTRL;     /* Offset: 0x0B70 */
    uint32_t      RESERVED21[3];
    __IO uint32_t MACPPSTTS;      /* Offset: 0x0B80 */
    __IO uint32_t MACPPSTTNS;     /* Offset: 0x0B84 */
    uint32_t      RESERVED22[30];

    __IO uint32_t MTLOPMOD;       /* Offset: 0x0C00 */
    uint32_t      RESERVED23[7];
    __IO uint32_t MTLINTSTS;      /* Offset: 0x0C20 */
    uint32_t      RESERVED24[55];
    __IO uint32_t MTLTXQOPMOD;    /* Offset: 0x0D00 */
    __IO uint32_t MTLTXQUDF;      /* Offset: 0x0D04 */
    __IO uint32_t MTLTXQDBG;      /* Offset: 0x0D08 */
    uint32_t      RESERVED25[8];
    __IO uint32_t MTLQINTCTRLSTS; /* Offset: 0x0D2C */
    __IO uint32_t MTLRXQOPMOD;    /* Offset: 0x0D30 */
    __IO uint32_t MTLRXQMPOFCNT;  /* Offset: 0x0D34 */
    __IO uint32_t MTLRXQDBG;      /* Offset: 0x0D38 */
    uint32_t      RESERVED26[177];

    __IO uint32_t DMAMODE;        /* Offset: 0x1000 */
    __IO uint32_t DMASBMODE;      /* Offset: 0x1004 */
    __IO uint32_t DMAINTSTS;      /* Offset: 0x1008 */
    __IO uint32_t DMADBGSTS;      /* Offset: 0x100C */
    uint32_t      RESERVED27[60];
    __IO uint32_t DMACH0CTRL;     /* Offset: 0x1100 */
    __IO uint32_t DMACH0TXCTRL;   /* Offset: 0x1104 */
    __IO uint32_t DMACH0RXCTRL;   /* Offset: 0x1108 */
    uint32_t      RESERVED28[2];
    __IO uint32_t DMACH0TXDLA;    /* Offset: 0x1114 */
    uint32_t      RESERVED29;
    __IO uint32_t DMACH0RXDLA;    /* Offset: 0x111C */
    __IO uint32_t DMACH0TXDTP;    /* Offset: 0x1120 */
    uint32_t      RESERVED30;
    __IO uint32_t DMACH0RXDTP;    /* Offset: 0x1128 */
    __IO uint32_t DMACH0TXDRLEN;  /* Offset: 0x112C */
    __IO uint32_t DMACH0RXCTRL2;  /* Offset: 0x1130 */
    __IO uint32_t DMACH0INTEN;    /* Offset: 0x1134 */
    __IO uint32_t DMACH0RXINTWT;  /* Offset: 0x1138 */
    uint32_t      RESERVED31[2];
    __IO uint32_t DMACH0CATXD;    /* Offset: 0x1144 */
    uint32_t      RESERVED32;
    __IO uint32_t DMACH0CARXD;    /* Offset: 0x114C */
    uint32_t      RESERVED33;
    __IO uint32_t DMACH0CATXB;    /* Offset: 0x1154 */
    uint32_t      RESERVED34;
    __IO uint32_t DMACH0CARXB;    /* Offset: 0x115C */
    __IO uint32_t DMACH0STS;      /* Offset: 0x1160 */
    __IO uint32_t DMACH0DPCNT;    /* Offset: 0x1164 */
    uint32_t      RESERVED35;
    __IO uint32_t DMACH0RXERICNT; /* Offset: 0x116C */
} ETH_Module;

/***  EXTI(External Interrupt/Event Controller) Regiters ***/
typedef struct
{
    __IO uint32_t EMASK;        //0x00
    __IO uint32_t IMASK;        //0x04
    __IO uint32_t FT_CFG;       //0x08
    __IO uint32_t RT_CFG;       //0x0C
    __IO uint32_t PEND;         //0x10
    __IO uint32_t SWIE;         //0x14
    __IO uint32_t TSSEL;        //0x18
} EXTI_Module;

/*** FDCAN(Flexible Datarate Controller Area Network) Registers ***/
typedef struct
{
    __IO uint32_t CREL;         //0x000
    __IO uint32_t ENDN;         //0x004
    __IO uint32_t RESERVED1;    //0x008
    __IO uint32_t DBTP;         //0x00C
    __IO uint32_t TEST;         //0x010
    __IO uint32_t RWD;          //0x014
    __IO uint32_t CCCR;         //0x018
    __IO uint32_t NBTP;         //0x01C
    __IO uint32_t TSCC;         //0x020
    __IO uint32_t TSCV;         //0x024
    __IO uint32_t TOCC;         //0x028
    __IO uint32_t TOCV;         //0x02C
    __IO uint32_t RESERVED2[4]; //0x030
    __IO uint32_t ECR;          //0x040
    __IO uint32_t PSR;          //0x044
    __IO uint32_t TDCR;         //0x048
    __IO uint32_t RESERVED3;    //0x04C
    __IO uint32_t IR;           //0x050
    __IO uint32_t IE;           //0x054
    __IO uint32_t ILS;          //0x058
    __IO uint32_t ILE;          //0x05C
    __IO uint32_t RESERVED4[8]; //0x060
    __IO uint32_t GFC;          //0x080
    __IO uint32_t SIDFC;        //0x084
    __IO uint32_t XIDFC;        //0x088
    __IO uint32_t RESERVED5;    //0x08C
    __IO uint32_t XIDAM;        //0x090
    __IO uint32_t HPMS;         //0x094
    __IO uint32_t NDAT1;        //0x098
    __IO uint32_t NDAT2;        //0x09C
    __IO uint32_t RXF0C;        //0x0A0
    __IO uint32_t RXF0S;        //0x0A4
    __IO uint32_t RXF0A;        //0x0A8
    __IO uint32_t RXBC;         //0x0AC
    __IO uint32_t RXF1C;        //0x0B0
    __IO uint32_t RXF1S;        //0x0B4
    __IO uint32_t RXF1A;        //0x0B8
    __IO uint32_t RXESC;        //0x0BC
    __IO uint32_t TXBC;         //0x0C0
    __IO uint32_t TXFQS;        //0x0C4
    __IO uint32_t TXESC;        //0x0C8
    __IO uint32_t TXBRP;        //0x0CC
    __IO uint32_t TXBAR;        //0x0D0
    __IO uint32_t TXBCR;        //0x0D4
    __IO uint32_t TXBTO;        //0x0D8
    __IO uint32_t TXBCF;        //0x0DC
    __IO uint32_t TXBTIE;       //0x0E0
    __IO uint32_t TXBCIE;       //0x0E4
    __IO uint32_t RESERVED6[2]; //0x0EC
    __IO uint32_t TXEFC;        //0x0F0
    __IO uint32_t TXEFS;        //0x0F4
    __IO uint32_t TXEFA;        //0x0F8
    __IO uint32_t RESERVED7[18];//0x0FC
    __IO uint32_t TTSS;         //0x144
} FDCAN_Module;

/*** FLASH Registers ***/
typedef struct
{
    __IO uint32_t AC;           //0x00
    __IO uint32_t CTRL;         //0x04
    __IO uint32_t STS;          //0x08
    __IO uint32_t ADD;          //0x0C
    __IO uint32_t KEY;          //0x10
    __IO uint32_t OPTKEY;       //0x14
    __IO uint32_t OB;           //0x18
    __IO uint32_t WRP;          //0x1C
    __IO uint32_t ECC;          //0x20
    __IO uint32_t RESERVED0[2];
    __IO uint32_t RDN;          //0x2C
    __IO uint32_t CAHR;         //0x30
    __IO uint32_t ROWP;         //0x34
    __IO uint32_t CCM_WRP1;     //0x38
    __IO uint32_t CCM_KEY;      //0x3C
    __IO uint32_t CCM_ERASE;    //0x40
    __IO uint32_t CCM_WRP2;     //0x44
    __IO uint32_t CCM_MODE;     //0x48
    __IO uint32_t XSPI_DSTRADD; //0x4C
    __IO uint32_t XSPI_DENDADD; //0x50
    __IO uint32_t FEMC_DSTRADD; //0x54
    __IO uint32_t FEMC_DENDADD; //0x58
    __IO uint32_t RTPD_KEY;     //0x5C
    __IO uint32_t JTAG_SEAL;    //0x60
    __IO uint32_t RTPD_KEY_WCNT;//0x64
    __IO uint32_t RESERVED1;
    __IO uint32_t XSPI_FEMC_DEN;//0x6C
    __IO uint32_t XUID;         //0x70
} FLASH_Module;

/*** Option Bytes Registers ***/

typedef struct
{
    __IO uint32_t USER_RDP;     //0x00 
    __IO uint32_t Data1_Data0;  //0x04
    __IO uint32_t WRP1_WRP0;    //0x08
    __IO uint32_t WRP3_WRP2;    //0x0C
    __IO uint32_t USER2_RDP2;   //0x10
    __IO uint32_t USER3;        //0x14
    __IO uint32_t CCMSRAM_RST;  //0x18
    __IO uint32_t RESERVED;
} OB_Module;

/*** GPIO(General Purpose I/O) Registers ***/
typedef struct
{
    __IO uint32_t PMODE;            //0x00
    __IO uint32_t PUPD;             //0x04
    __IO uint32_t POTYPE;           //0x08
    __IO uint32_t AFSEL[4];         //0x0C
    __IO uint32_t DS;               //0x1C
    __IO uint32_t SR;               //0x20
    __IO uint32_t PBSC;             //0x24
    __IO uint32_t PBC;              //0x28
    __IO uint32_t PID;              //0x2C
    __IO uint32_t POD;              //0x30
    __IO uint32_t PLOCK;            //0x34
} GPIO_Module;

/*** AFIO(Alternate Function I/O) Registers ***/
typedef struct
{
    __IO uint32_t RMP_CFG;          //0x00
    __IO uint32_t EXTI_CFG[4];      //0x04
    __IO uint32_t ANAEN_CFG[4];     //0x14
    __IO uint32_t FILTER_CFG[4];    //0x24
    __IO uint32_t EMC_CFG;          //0x34
    __IO uint32_t EMC_CNT;          //0x38
    __IO uint32_t SHRT_EXEV_CFG[3];  //0x3C
} AFIO_Module;

/*** Low-Power Timer ***/
typedef struct
{
    __IO uint32_t INTSTS; /* Offset: 0x0000 */
    __IO uint32_t INTCLR; /* Offset: 0x0004 */
    __IO uint32_t INTEN;  /* Offset: 0x0008 */
    __IO uint32_t CFG;    /* Offset: 0x000C */
    __IO uint32_t CTRL;   /* Offset: 0x0010 */
    __IO uint32_t CMP;    /* Offset: 0x0014 */
    __IO uint32_t ARR;    /* Offset: 0x0018 */
    __IO uint32_t CNT;    /* Offset: 0x001C */
    __IO uint32_t OPT;    /* Offset: 0x0020 */
} LPTIM_Module;

/*** Inter Integrated Circuit Interface ***/

typedef struct
{
    __IO uint32_t CTRL1;          //0x00 
    __IO uint32_t CTRL2;          //0x04
    __IO uint32_t OADDR1;         //0x08   
    __IO uint32_t OADDR2;         //0x0C 
    __IO uint32_t DAT;            //0x10 
    __IO uint32_t STS1;           //0x14  
    __IO uint32_t STS2;           //0x18  
    __IO uint32_t CLKCTRL;        //0x1C  
    __IO uint32_t TMRISE;         //0x20  
    __IO uint32_t BYTENUM;        //0x24   
    __IO uint32_t GFLTRCTRL;      //0x28  
    __IO uint32_t FIFODAT;        //0x2C  
} I2C_Module;

/**
 * @brief Independent WATCHDOG
 */

typedef struct
{
    __IO uint32_t KEY;
    __IO uint32_t STS;
    __IO uint32_t PREDIV; /* IWDG PREDIV */
    __IO uint32_t RELV;
} IWDG_Module;

/** Power Control **/

typedef struct
{
    __IO uint32_t CTRL;        //0x00
    __IO uint32_t CTRLSTS;     //0x04
    __IO uint32_t CTRL2;       //0x08
    __IO uint32_t CTRL3;       //0x0C
    __IO uint32_t CTRL4;       //0x10
    uint32_t RESERVED1;        //0x14
    uint32_t RESERVED2;        //0x18
    uint32_t RESERVED3;        //0x1C
    __IO uint32_t NRSTCTRL;    //0x20
    uint32_t RESERVED5;        //0x24
    __IO uint32_t CTRL5;       //0x28
    __IO uint32_t CTRL6;       //0x2C
    uint32_t RESERVED8;        //0x30
    uint32_t RESERVED9;        //0x34
    uint32_t RESERVED10;       //0x38
    uint32_t RESERVED11;       //0x3C
    uint32_t RESERVED12;       //0x40
    uint32_t RESERVED13;       //0x44
    uint32_t RESERVED14;       //0x48
    uint32_t RESERVED15;       //0x4C
    uint32_t RESERVED16;       //0x50
    uint32_t RESERVED17;       //0x54
    uint32_t RESERVED18;       //0x58
    uint32_t RESERVED19;       //0x5C
    uint32_t RESERVED20;       //0x60
    uint32_t RESERVED21;       //0x64
    uint32_t RESERVED22;       //0x68
    uint32_t RESERVED23;       //0x6C
    uint32_t RESERVED24;       //0x70
    uint32_t RESERVED25;       //0x74
    uint32_t RESERVED26;       //0x78
    uint32_t RESERVED27;       //0x7C
    uint32_t RESERVED28;       //0x80
    uint32_t RESERVED29;       //0x84
    uint32_t RESERVED30;       //0x88
    uint32_t RESERVED31;       //0x8C
    uint32_t RESERVED32;       //0x90
    uint32_t RESERVED33;       //0x94
    uint32_t RESERVED34;       //0x98
    uint32_t RESERVED35;       //0x9C
    uint32_t RESERVED36;       //0xA0
    uint32_t RESERVED37;       //0xA4
    uint32_t RESERVED38;       //0xA8
    uint32_t RESERVED39;       //0xAC
    uint32_t RESERVED40;       //0xB0
    uint32_t RESERVED41;       //0xB4
    uint32_t RESERVED42;       //0xB8
    uint32_t RESERVED43;       //0xBC
    __IO uint32_t EMCCTRL;     //0xC0
    __IO uint32_t EMCCTRL2;    //0xC4
    __IO uint32_t EMCCNT;      //0xC8
} PWR_Module;

/** Reset and Clock Control **/

typedef struct
{
    __IO uint32_t CTRL;         //0x00
    __IO uint32_t CFG;          //0x04
    __IO uint32_t CFG2;         //0x08
    __IO uint32_t CFG3;         //0x0C
    __IO uint32_t CLKINT;       //0x10
    __IO uint32_t CTRLSTS;      //0x14
    __IO uint32_t AHBPCLKEN;    //0x18
    __IO uint32_t APB1PCLKEN;   //0x1C
    __IO uint32_t APB2PCLKEN;   //0x20
    __IO uint32_t AHBPRST;      //0x24
    __IO uint32_t APB1PRST;     //0x28
    __IO uint32_t APB2PRST;     //0x2C
    __IO uint32_t MCOCFG;       //0x30
    __IO uint32_t BDCTRL;       //0x34
    __IO uint32_t CSSCTRL;      //0x38
    __IO uint32_t AHB1PCLKEN;   //0x3C
    __IO uint32_t PLLCTRL;      //0x40
    __IO uint32_t VREFCTRL;     //0x44
    __IO uint32_t SHRTPLLCTRL1; //0x48
    __IO uint32_t SHRTPLLCTRL2; //0x4C
    __IO uint32_t SHRTPLLCTRL3; //0x50
    uint32_t RESERVED1;         //0x54
    uint32_t RESERVED2;         //0x58
    uint32_t RESERVED3;         //0x5C
    uint32_t RESERVED4;         //0x60
    uint32_t RESERVED5;         //0x64
    uint32_t RESERVED6;         //0x68
    uint32_t RESERVED7;         //0x6C
    __IO uint32_t SRAMCFG1;     //0x70
    __IO uint32_t SRAMCFG2;     //0x74
    __IO uint32_t SRAMCFG3;     //0x78
    __IO uint32_t SRAMCFG4;     //0x7C
    uint32_t RESERVED8;         //0x80
    __IO uint32_t USBHSCTRL1;  //0x84
    __IO uint32_t USBHSCTRL2;  //0x88
    __IO uint32_t BOOTREMAP;    //0x8C
    __IO uint32_t FDCANBADDR;   //0x90
} RCC_Module;

/**
 * @brief Real-Time Clock
 */

typedef struct
{
    __IO uint32_t INITSTS;     /* RTC initialization and status register,                    Address offset: 0x00 */
    __IO uint32_t CTRL;        /* RTC control register,                                      Address offset: 0x04 */
    __IO uint32_t TSH;         /* RTC time register,                                         Address offset: 0x08 */
    __IO uint32_t DATE;        /* RTC date register,                                         Address offset: 0x0C */
    __IO uint32_t WRP;         /* RTC write protection register,                             Address offset: 0x10 */
    __IO uint32_t SCTRL;       /* RTC shift control register,                                Address offset: 0x14 */
    __IO uint32_t SUBS;        /* RTC sub second register,                                   Address offset: 0x18 */
    __IO uint32_t TST;         /* RTC time stamp time register,                              Address offset: 0x1C */
    __IO uint32_t ALARMA;      /* RTC alarm A register,                                      Address offset: 0x20 */
    __IO uint32_t PRE;         /* RTC prescaler register,                                    Address offset: 0x24 */
    __IO uint32_t ALARMB;      /* RTC alarm B register,                                      Address offset: 0x28 */
    __IO uint32_t WKUPT;       /* RTC wakeup timer register,                                 Address offset: 0x2C */
    __IO uint32_t TMPCFG;      /* RTC tamper configuration register,                         Address offset: 0x30 */
    __IO uint32_t ALRMASS;     /* RTC alarm A sub second register,                           Address offset: 0x34 */
    __IO uint32_t OPT;         /* RTC option register,                                       Address offset: 0x38 */
    __IO uint32_t ALRMBSS;     /* RTC alarm B sub second register,                           Address offset: 0x3C */
    __IO uint32_t CALIB;       /* RTC calibration register,                                  Address offset: 0x40 */
    __IO uint32_t TSSS;        /* RTC time-stamp sub second register,                        Address offset: 0x44 */
    __IO uint32_t TSD;         /* RTC time stamp date register,                              Address offset: 0x48 */
    __IO uint32_t BKP1;        /* RTC backup register 1,                                     Address offset: 0x4C */
    __IO uint32_t BKP2;        /* RTC backup register 2,                                     Address offset: 0x50 */
    __IO uint32_t BKP3;        /* RTC backup register 3,                                     Address offset: 0x54 */
    __IO uint32_t BKP4;        /* RTC backup register 4,                                     Address offset: 0x58 */
    __IO uint32_t BKP5;        /* RTC backup register 5,                                     Address offset: 0x5C */
    __IO uint32_t BKP6;        /* RTC backup register 6,                                     Address offset: 0x60 */
    __IO uint32_t BKP7;        /* RTC backup register 7,                                     Address offset: 0x64 */
    __IO uint32_t BKP8;        /* RTC backup register 8,                                     Address offset: 0x68 */
    __IO uint32_t BKP9;        /* RTC backup register 9,                                     Address offset: 0x6C */
    __IO uint32_t BKP10;       /* RTC backup register 10,                                    Address offset: 0x70 */
    __IO uint32_t BKP11;       /* RTC backup register 11,                                    Address offset: 0x74 */
    __IO uint32_t BKP12;       /* RTC backup register 12,                                    Address offset: 0x78 */
    __IO uint32_t BKP13;       /* RTC backup register 13,                                    Address offset: 0x7C */
    __IO uint32_t BKP14;       /* RTC backup register 14,                                    Address offset: 0x80 */
    __IO uint32_t BKP15;       /* RTC backup register 15,                                    Address offset: 0x84 */
    __IO uint32_t BKP16;       /* RTC backup register 16,                                    Address offset: 0x88 */
    __IO uint32_t BKP17;       /* RTC backup register 17,                                    Address offset: 0x8C */
    __IO uint32_t BKP18;       /* RTC backup register 18,                                    Address offset: 0x90 */
    __IO uint32_t BKP19;       /* RTC backup register 19,                                    Address offset: 0x94 */
    __IO uint32_t BKP20;       /* RTC backup register 20,                                    Address offset: 0x98 */

} RTC_Module;

/**
 * @brief SD host Interface
 */

typedef struct
{
    __IO uint32_t PWRCTRL;  //0x00
    __IO uint32_t CLKCTRL;  //0x04
    __IO uint32_t CMDARG;   //0x04
    __IO uint32_t CMDCTRL;  //0x0C
    __I uint32_t CMDRESP;   //0x10
    __I uint32_t RESPONSE1; //0x14
    __I uint32_t RESPONSE2; //0x18
    __I uint32_t RESPONSE3; //0x1C
    __I uint32_t RESPONSE4; //0x20
    __IO uint32_t DTIMER;   //0x24
    __IO uint32_t DATLEN;   //0x28
    __IO uint32_t DATCTRL;  //0x2C
    __I uint32_t DATCOUNT;  //0x30
    __I uint32_t STS;       //0x34
    __IO uint32_t INTCLR;   //0x38
    __IO uint32_t INTEN;    //0x3C
    uint32_t RESERVED0[2];  //0x40
    __I uint32_t FIFOCOUNT; //0x48
    uint32_t RESERVED1[13]; //0x4C
    __IO uint32_t DATFIFO;  //0x80
} SDIO_Module;

/*** Serial Peripheral Interface ***/

typedef struct
{
    __IO uint16_t CTRL1;                //0x00 
    uint16_t RESERVED0;
    __IO uint16_t CTRL2;                //0x04   
    uint16_t RESERVED1;
    __IO uint16_t STS;                    //0x08 
    uint16_t RESERVED2;    
    __IO uint16_t DAT;                    //0x0C 
    uint16_t RESERVED3;
        __IO uint16_t CRCTDAT;            //0x10 
    uint16_t RESERVED4;
    __IO uint16_t CRCRDAT;            //0x14
    uint16_t RESERVED5;  
    __IO uint16_t CRCPOLY;            //0x18  
    uint16_t RESERVED6;
    __IO uint16_t SPI_I2S_CFGR;    //0x1C  
    uint16_t RESERVED7;
    __IO uint16_t I2SPREDIV;        //0x20  
    uint16_t RESERVED8;
    __IO uint16_t RX_FIFO;            //0x24   
    uint16_t RESERVED9;
    __IO uint16_t FIFONUM;            //0x28  
    uint16_t RESERVED10;    
    uint16_t RESERVED11;      //0x2C  
    uint16_t RESERVED12;
    __IO uint16_t FIFOCNT;            //0x30 
    uint16_t RESERVED13;  
    __IO uint16_t TRANSNUM;          //0x34  
    uint16_t RESERVED14;
    __IO uint16_t CR3;                //0x38  
} SPI_Module;

/*** Extend Inter-IC Sound ***/

typedef struct
{
        uint32_t RESERVED0; 
        __IO uint16_t I2S_CTRL2;        //0x04  
        uint16_t RESERVED1;
        __IO uint16_t I2S_STS;            //0x08
        uint16_t RESERVED2;   
        __IO uint16_t I2S_DAT;            //0x0C 
        uint16_t RESERVED3; 
        uint32_t RESERVED4; 
        uint32_t RESERVED5; 
        uint32_t RESERVED6;     
        __IO uint16_t I2S_CFGR;            //0x1C  
        uint16_t RESERVED17; 

}I2S_EXT_Module;

/**
 * @brief TIM
 */

typedef struct
{
    __IO uint32_t CTRL1;    //0x00
    __IO uint32_t CTRL2;       //0x04
    __IO uint32_t STS;        //0x08
    __IO uint32_t EVTGEN;    //0x0C
    __IO uint32_t SMCTRL;    //0x10
    __IO uint32_t DINTEN;    //0x14
    __IO uint32_t CCMOD1;    //0x18
    __IO uint32_t CCMOD2;    //0x1C
    __IO uint32_t CCMOD3;    //0x20
    __IO uint32_t CCEN;        //0x24
    __IO uint32_t CCDAT1;    //0x28
    __IO uint32_t CCDAT2;    //0x2C
    __IO uint32_t CCDAT3;    //0x30
    __IO uint32_t CCDAT4;    //0x34
    __IO uint32_t CCDAT5;    //0x38
    __IO uint32_t CCDAT6;    //0x3C    
    __IO uint32_t PSC;        //0x40   
    __IO uint32_t AR;        //0x44
    __IO uint32_t CNT;        //0x48
    __IO uint32_t REPCNT;    //0x4C
    __IO uint32_t BKDT;        //0x50
    __IO uint32_t CCDAT7;    //0x54
    __IO uint32_t CCDAT8;    //0x58
    __IO uint32_t CCDAT9;    //0x5C
    __IO uint32_t BKFR;        //0x60
    __IO uint32_t C1FILT;    //0x64
    __IO uint32_t C2FILT;    //0x68
    __IO uint32_t C3FILT;    //0x6C
    __IO uint32_t C4FILT;    //0x70
    __IO uint32_t FILTO;    //0x74
    __IO uint32_t INSEL;    //0x78
    __IO uint32_t AF1;        //0x7C
    __IO uint32_t AF2;        //0x80
    __IO uint32_t BKFR2;    //0x84
    __IO uint32_t SLIDFPSC;    //0x88
    __IO uint32_t RESERVED0[2];    
    __IO uint32_t DCTRL;    //0x94
    __IO uint32_t DADDR;    //0x98
} TIM_Module;


/** Universal Synchronous Asynchronous Receiver Transmitter **/

typedef struct
{
    __IO uint32_t CTRL1;    //0x00
    __IO uint32_t CTRL2;    //0x04
    __IO uint32_t CTRL3;    //0x08
    __IO uint32_t STS;      //0x0C
    __IO uint32_t DAT;      //0x10
    __IO uint32_t BRCF;     //0x14
    __IO uint32_t GTP;      //0x18
    __IO uint32_t FIFO;     //0x1C
    __IO uint32_t IFW;      //0x20
    __IO uint32_t RTO;      //0x24
} USART_Module;

/**
 * @brief Window WATCHDOG
 */

typedef struct
{
    __IO uint32_t CFG;      /* WWDG Configuration Register      Address offset: 0x00 */
    __IO uint32_t CTRL;     /* WWDG Control Register            Address offset: 0x04 */
    __IO uint32_t STS;      /* WWDG Stauts Register             Address offset: 0x08 */
} WWDG_Module;

/*** xSPI ***/

typedef struct
{
    __IO uint32_t CTRL0;                //0x00 
    __IO uint32_t CTRL1;                //0x04 
    __IO uint32_t EN;                    //0x08 
    __IO uint32_t MW_CTRL;                //0x0C 
    __IO uint32_t SLAVE_EN;                //0x10 
    __IO uint32_t BAUD;                    //0x14 
    __IO uint32_t TXFT;                    //0x18 
    __IO uint32_t RXFT;                    //0x1C 
    __IO uint32_t TXFN;                 //0x20 
    __IO uint32_t RXFN;                    //0x24 
    __IO uint32_t STS;                    //0x28 
    __IO uint32_t IMASK;                //0x2C 
    __IO uint32_t ISTS;                    //0x30 
    __IO uint32_t RISTS;                //0x34 
    __IO uint32_t TXEICR_CLR;            //0x38 
    __IO uint32_t RXFOI_CLR;            //0x3C 
    __IO uint32_t RXFUI_CLR;            //0x40 
    __IO uint32_t MMCI_CLR;             //0x44 
    __IO uint32_t ICLR;                    //0x48 
    __IO uint32_t DMA_CTRL;                //0x4C 
    __IO uint32_t DMATDL_CTRL;          //0x50 
    __IO uint32_t DMARDL_CTRL;            //0x54 
    __IO uint32_t IDR;                    //0x58 
    __IO uint32_t VERSION_ID;             //0x5C 
    __IO uint32_t DAT0;                    //0x60                
    __IO uint32_t DAT1;        
    __IO uint32_t DAT2;
    __IO uint32_t DAT3;
    __IO uint32_t DAT4;
    __IO uint32_t DAT5;
    __IO uint32_t DAT6;
    __IO uint32_t DAT7;
    __IO uint32_t DAT8;
    __IO uint32_t DAT9;
    __IO uint32_t DAT10;
    __IO uint32_t DAT11;
    __IO uint32_t DAT12;
    __IO uint32_t DAT13;
    __IO uint32_t DAT14;
    __IO uint32_t DAT15;
    __IO uint32_t DAT16;
    __IO uint32_t DAT17;
    __IO uint32_t DAT18;
    __IO uint32_t DAT19;
    __IO uint32_t DAT20;
    __IO uint32_t DAT21;
    __IO uint32_t DAT22;
    __IO uint32_t DAT23;
    __IO uint32_t DAT24;
    __IO uint32_t DAT25;
    __IO uint32_t DAT26;
    __IO uint32_t DAT27;
    __IO uint32_t DAT28;
    __IO uint32_t DAT29;
    __IO uint32_t DAT30;
    __IO uint32_t DAT31;
    __IO uint32_t RESERVED2;                //Reserved
    __IO uint32_t RESERVED3;                //Reserved
    __IO uint32_t RESERVED4;                //Reserved
    __IO uint32_t RESERVED5;                //Reserved
    __IO uint32_t RX_DELAY;                    //0xF0 
    __IO uint32_t ENH_CTRL0;                //0xF4 
    __IO uint32_t DDR_TXDE;                    //0xF8 
    __IO uint32_t XIP_MODE;                    //0xFC 
    __IO uint32_t XIP_INCR_TOC;                //0x100 
    __IO uint32_t XIP_WRAP_TOC;                //0x104 
    __IO uint32_t XIP_CTRL;                    //0x108 
    __IO uint32_t XIP_SLAVE_EN;                //0x10C 
    __IO uint32_t XIP_RXFOI_CLR;            //0x110 
    __IO uint32_t XIP_TOUT;                    //0x114
    uint32_t      RESERVED1[10];            //Reserved
    __IO uint32_t XIP_WRITE_INCR_INST;      //0x140 
    __IO uint32_t XIP_WRITE_WRAP_INST;      //0x144 
    __IO uint32_t XIP_WRITE_CTRL;            //0x148 
} XSPI_Module;

/**
 * @brief Touch Sensor Controller
 */
typedef struct
{
    __IO uint32_t CTRL;
    __IO uint32_t CHNEN;
    __IO uint32_t STS;
    __IO uint32_t RESERVED;
    __IO uint32_t ANA_CTRL;
    __IO uint32_t ANA_SEL;
    __IO uint32_t RESR0;
    __IO uint32_t RESR1;
    __IO uint32_t RESR2;
    __IO uint32_t THRHD0;
    __IO uint32_t THRHD1;
    __IO uint32_t THRHD2;
    __IO uint32_t THRHD3;
    __IO uint32_t THRHD4;
    __IO uint32_t THRHD5;
    __IO uint32_t THRHD6;
    __IO uint32_t THRHD7;
    __IO uint32_t THRHD8;
    __IO uint32_t THRHD9;
    __IO uint32_t THRHD10;
    __IO uint32_t THRHD11;
    __IO uint32_t THRHD12;
    __IO uint32_t THRHD13;
    __IO uint32_t THRHD14;
    __IO uint32_t THRHD15;
    __IO uint32_t THRHD16;
    __IO uint32_t THRHD17;
    __IO uint32_t THRHD18;
    __IO uint32_t THRHD19;
    __IO uint32_t THRHD20;
    __IO uint32_t THRHD21;
    __IO uint32_t THRHD22;
    __IO uint32_t THRHD23;
} TSC_Module;

/**
 * @brief DVP
 */
typedef struct
{
    __IO uint32_t CTRL;    /* DVP control register */
    __IO uint32_t INTEN;   /* DVP interrupt enable register */
    __IO uint32_t INTSTS;  /* DVP interrupt flag and status register */
    __IO uint32_t PORTCFG; /* DVP control port configuration register */
    __IO uint32_t FIFOCFG; /* DVP control fifo configuration register */
    __IO uint32_t SMADDR1; /* DVP frame 1 start memory address register */
    __IO uint32_t SMADDR2; /* DVP frame 2 start memory address register */
    __IO uint32_t FBS;     /* DVP frame buffer size register */
    __IO uint32_t FPBC1;   /* DVP frame 1 PIXEL byte count register */
    __IO uint32_t FPBC2;   /* DVP frame 2 PIXEL byte count register */
    __IO uint32_t CSXY;    /* DVP crop start XY register */
    __IO uint32_t CEXY;    /* DVP crop end XY register */
    __IO uint32_t EMSC;    /* DVP embedded sync code marker register */
    __IO uint32_t EMSCM;   /* DVP embedded sync code mask register */
} DVP_Module;

typedef struct
{
    __IO uint32_t MCTRL;    /* SHRTIM configuration register for master timer, address offset: 0x00 */
    __IO uint32_t MINTSTS;  /* SHRTIM status register for master timer interrupt, address offset: 0x04 */
    __IO uint32_t MINTCLR;  /* SHRTIM master timer interrupt clear register, address offset: 0x08 */
    __IO uint32_t MIDEN;    /* SHRTIM master timer interrupt and DMA request enable register, address offset: 0x0C */
    __IO uint32_t MCNT;     /* SHRTIM master timer counter register, address offset: 0x10 */
    __IO uint32_t MPRD;     /* SHRTIM master timer period register, address offset: 0x14 */
    __IO uint32_t MREPT;    /* SHRTIM master timer repetition register, address offset: 0x18 */
    __IO uint32_t MCMP1DAT; /* SHRTIM master timer compare 1 register, address offset: 0x1C */
    uint32_t      RESERVED0;/* Reserved, address offset: 0x20 */
    __IO uint32_t MCMP2DAT; /* SHRTIM master timer compare 2 register, address offset: 0x24 */
    __IO uint32_t MCMP3DAT; /* SHRTIM master timer compare 3 register, address offset: 0x28 */
    __IO uint32_t MCMP4DAT; /* SHRTIM master timer compare 4 register, address offset: 0x2C */
    __IO uint32_t SYNCOUT;   /* SHRTIM SYNCOUT configure register, address offset: 0x30 */
    __IO uint32_t FRZDIS;   /* SHRTIM Timer behavior during CPU freeze, address offset: 0x34 */
    uint32_t      RESERVED1[18];  /* Reserved, 0x30..0x7C */
}SHRTIM_Master_Submodule;

/* SHRTIM Timer A to F registers definition */
typedef struct
{
    __IO uint32_t TxCTRL;      /* SHRTIM timer x control register, address offset: 0x00 */
    __IO uint32_t TxINTSTS;    /* SHRTIM timer x interrupt status register, address offset: 0x04 */
    __IO uint32_t TxINTCLR;    /* SHRTIM timer x interrupt clear register, address offset: 0x08 */
    __IO uint32_t TxIDEN;      /* SHRTIM timer x interrupt DMA  enable register, address offset: 0x0C */
    __IO uint32_t TxCNT;       /* SHRTIM timer x counter register, address offset: 0x10 */
    __IO uint32_t TxPRD;       /* SHRTIM timer x period register, address offset: 0x14 */
    __IO uint32_t TxREPT;      /* SHRTIM timer x repetition register, address offset: 0x18 */
    __IO uint32_t TxCMP1DAT;   /* SHRTIM timer x compare 1 register, address offset: 0x1C */
    __IO uint32_t TxRCMP1DAT;  /* SHRTIM timer x compare 1 repetition alias register, address offset: 0x20 */
    __IO uint32_t TxCMP2DAT;   /* SHRTIM timer x compare 2 register, address offset: 0x24 */
    __IO uint32_t TxCMP3DAT;   /* SHRTIM timer x compare 3 register, address offset: 0x28 */
    __IO uint32_t TxCMP4DAT;   /* SHRTIM timer x compare 4 register, address offset: 0x2C */
    __IO uint32_t TxCPT1;      /* SHRTIM timer x compare 1 register, address offset: 0x30 */
    __IO uint32_t TxCPT2;      /* SHRTIM timer x compare 2 register, address offset: 0x34 */
    __IO uint32_t TxDT;        /* SHRTIM timer x deadtime register, address offset: 0x38 */
    __IO uint32_t TxSET1;      /* SHRTIM timer x set register 1, address offset: 0x3C */
    __IO uint32_t TxRST1;      /* SHRTIM timer x reset register 1, address offset: 0x40 */
    __IO uint32_t TxSET2;      /* SHRTIM timer x set register 2, address offset: 0x44 */
    __IO uint32_t TxRST2;      /* SHRTIM timer x reset register 2, address offset: 0x48 */
    __IO uint32_t TxEXEVFLT1;  /* SHRTIM timer x external event filtering register 1, address offset: 0x4C */
    __IO uint32_t TxEXEVFLT2;  /* SHRTIM timer x external event filtering register 1, address offset: 0x50 */
    __IO uint32_t TxCNTRST;    /* SHRTIM timer x reset, address offset: 0x54 */
    __IO uint32_t TxCHOP;      /* SHRTIM timer x chopper register, address offset: 0x58 */
    __IO uint32_t TxCPT1CTRL;  /* SHRTIM timer x capture 1 control register, address offset: 0x5C */
    __IO uint32_t TxCPT2CTRL;  /* SHRTIM timer x capture 2 control register, address offset: 0x60 */
    __IO uint32_t TxOUT;       /* SHRTIM timer x output register, address offset: 0x64 */
    __IO uint32_t TxFALT;      /* SHRTIM timer x fault register, address offset: 0x68 */
    __IO uint32_t TxCTRL2;     /* SHRTIM timer x control register 2, address offset: 0x6C */
    __IO uint32_t TxEXEVFLT3;  /* SHRTIM timer x external event filter register 3, address offset: 0x70 */
    __IO uint32_t TxCMP5DAT;   /* SHRTIM timer x compare 5 register, address offset: 0x74 */
    uint32_t RESERVED0[2];     /* Reserved, address offset:0x78...0x7c */
}SHRTIM_Timerx_Submodule;


/* SHRTIM common register definition */
typedef struct
{
    __IO uint32_t CTRL1;        /* SHRTIM control register 1, address offset: 0x00 */
    __IO uint32_t CTRL2;        /* SHRTIM control register 2, address offset: 0x04 */
    __IO uint32_t INTSTS;       /* SHRTIM interrupt status register, address offset: 0x08 */
    __IO uint32_t INTCLR;       /* SHRTIM interrupt clear register, address offset: 0x0C */
    __IO uint32_t INTEN;        /* SHRTIM interrupt enable register, address offset: 0x10 */
    __IO uint32_t OEN;        /* SHRTIM output channel enable register, address offset: 0x14 */
    __IO uint32_t ODIS;       /* SHRTIM output channel disable register, address offset: 0x18 */
    __IO uint32_t ODISSTS;    /* SHRTIM output channel disable status register, address offset: 0x1C */
    __IO uint32_t BMCTRL;       /* SHRTIM burst mode control register, address offset: 0x20 */
    __IO uint32_t BMTG;         /* SHRTIM burst mode trigger register, address offset: 0x24 */
    __IO uint32_t BMCMP;        /* SHRTIM burst mode compare register, address offset: 0x28 */
    __IO uint32_t BMPRD;        /* SHRTIM burst mode period register, address offset: 0x2C */
    __IO uint32_t EXEVCTRL1;    /* SHRTIM external event control register 1, address offset: 0x30 */
    __IO uint32_t EXEVCTRL2;    /* SHRTIM external event control register 2, address offset: 0x34 */
    __IO uint32_t EXEVCTRL3;    /* SHRTIM external event control register 4, address offset: 0x38 */
    __IO uint32_t EXEVCTRL4;    /* SHRTIM external event control register 3, address offset: 0x3C */
    __IO uint32_t ADTG1SRC1;  /* SHRTIM ADC trigger 1's source group1 register, address offset: 0x40 */
    __IO uint32_t ADTG1SRC2;  /* SHRTIM ADC trigger 1's source group2 register, address offset: 0x44 */
    __IO uint32_t ADTG2SRC1;  /* SHRTIM ADC trigger 2's source group1 register, address offset: 0x48 */
    __IO uint32_t ADTG2SRC2;  /* SHRTIM ADC trigger 2's source group2 register, address offset: 0x4C */
    __IO uint32_t ADTG3SRC1;  /* SHRTIM ADC trigger 3's source group1 register, address offset: 0x50 */
    __IO uint32_t ADTG3SRC2;  /* SHRTIM ADC trigger 3's source group2 register, address offset: 0x54 */
    __IO uint32_t ADTG4SRC1;  /* SHRTIM ADC trigger 4's source group1 register, address offset: 0x58 */
    __IO uint32_t ADTG4SRC2;  /* SHRTIM ADC trigger 4's source group2 register, address offset: 0x5C */
    __IO uint32_t FALTIN1;      /* SHRTIM fault input register 1, address offset: 0x60 */
    __IO uint32_t FALTIN2;      /* SHRTIM fault input register 2, address offset: 0x64 */
    __IO uint32_t FALTIN3;      /* SHRTIM fault input register 3, address offset: 0x68 */
    __IO uint32_t FALTIN4;      /* SHRTIM fault input register 4, address offset: 0x6C */
    __IO uint32_t BDMTUPD;      /* SHRTIM burst DMA master timer update register, address offset: 0x70 */
    __IO uint32_t BDTAUPD;      /* SHRTIM burst DMA timer A update register, address offset: 0x74 */
    __IO uint32_t BDTBUPD;      /* SHRTIM burst DMA timer B update register, address offset: 0x78 */
    __IO uint32_t BDTCUPD;      /* SHRTIM burst DMA timer C update register, address offset: 0x7C */
    __IO uint32_t BDTDUPD;      /* SHRTIM burst DMA timer D update register, address offset: 0x80 */
    __IO uint32_t BDTEUPD;      /* SHRTIM burst DMA timer E update register, address offset: 0x84 */
    __IO uint32_t BDTFUPD;      /* SHRTIM burst DMA timer F update register, address offset: 0x88 */
    __IO uint32_t BDDAT;        /* SHRTIM burst DMA data register, address offset: 0x8C */
    __IO uint32_t ADTRGEX1;     /* SHRTIM ADC extended trigger register 1, address offset: 0x90 */
    __IO uint32_t ADTRGEX2;     /* SHRTIM ADC extended trigger register 2, address offset: 0x94 */
    __IO uint32_t ADTRGUPD;     /* SHRTIM ADC trigger update register, address offset: 0x98 */
    __IO uint32_t ADCPSC1;      /* SHRTIM ADC post scaler register 1, address offset: 0x9C */
    __IO uint32_t ADCPSC2;      /* SHRTIM ADC post scaler register 2, address offset: 0xA0 */
    uint32_t RESERVED0;         /* address offset: 0xA4 */
    __IO uint32_t SFTFALT;      /* SHRTIM soft fault trigger register, address offset: 0xA8 */
    __IO uint32_t SFTDP;        /* SHRTIM soft  delayed protection trigger register, address offset: 0xAC */
    __IO uint32_t FALTIN5;      /* SHRTIM fault input register 5, address offset: 0xB0 */
    __IO uint32_t EXEVCTRL5;    /* SHRTIM external event control register 5, address offset: 0xB4 */
}SHRTIM_Common_Submodule;

/* SHRTIM  register definition */
typedef struct {
  SHRTIM_Master_Submodule sMasterRegs;
  SHRTIM_Timerx_Submodule sTimerxRegs[6];
  SHRTIM_Common_Submodule sCommonRegs;
}SHRTIM_Module;

#define FLASH_BASE  ((uint32_t)0x08000000U) /* FLASH base address in the alias region */
#define SRAM_BASE   ((uint32_t)0x20000000U) /* SRAM base address in the alias region */
#define PERIPH_BASE ((uint32_t)0x40000000U) /* Peripheral base address in the alias region */

#define SRAM_BB_BASE   ((uint32_t)0x22000000U) /* SRAM base address in the bit-band region */
#define PERIPH_BB_BASE ((uint32_t)0x42000000U) /* Peripheral base address in the bit-band region */

#define UCID_BASE           ((uint32_t)0x1FFFC740U) /* UCID Address : 0x1FFF_F740 */
#define UCID_LENGTH         ((uint32_t)0x10U)       /* UCID Length  : 16Bytes */
#define UID_BASE            ((uint32_t)0x1FFFC760U) /* UID Address  : 0x1FFF_C760 */
#define UID_LENGTH          ((uint32_t)0x0CU)       /* UID Length   : 12Bytes */
#define DBGMCU_ID_BASE      ((uint32_t)0xE0042000U) /* DBGMCU_ID Address */
#define DBGMCU_ID_LENGTH    ((uint32_t)0x04U)       /* DBGMCU_ID Length : 4 Bytes */

/* Peripheral memory map */
#define APB1PERIPH_BASE (PERIPH_BASE)
#define APB2PERIPH_BASE (PERIPH_BASE + 0x10000U)
#define AHBPERIPH_BASE  (PERIPH_BASE + 0x20000U)

/* APB1 */
#define PWR_BASE            (APB1PERIPH_BASE + 0x0000U)
#define WWDG_BASE           (APB1PERIPH_BASE + 0x0400U)
#define RTC_BASE            (APB1PERIPH_BASE + 0x0800U)
#define USART2_BASE         (APB1PERIPH_BASE + 0x0C00U)
#define USART3_BASE         (APB1PERIPH_BASE + 0x1000U)
#define UART8_BASE          (APB1PERIPH_BASE + 0x1400U)
#define IWDG_BASE           (APB1PERIPH_BASE + 0x1800U)
#define I2C1_BASE           (APB1PERIPH_BASE + 0x1C00U)
#define I2C2_BASE           (APB1PERIPH_BASE + 0x2000U)
#define SPI2_BASE           (APB1PERIPH_BASE + 0x2400U)
#define SPI3_BASE           (APB1PERIPH_BASE + 0x2800U)
#define GTIM1_BASE          (APB1PERIPH_BASE + 0x2C00U)
#define GTIM2_BASE          (APB1PERIPH_BASE + 0x3000U)
#define GTIM3_BASE          (APB1PERIPH_BASE + 0x3400U)
#define GTIM4_BASE          (APB1PERIPH_BASE + 0x3800U)
#define BTIM1_BASE          (APB1PERIPH_BASE + 0x3C00U)
#define BTIM2_BASE          (APB1PERIPH_BASE + 0x4000U)
#define UCDR_BASE           (APB1PERIPH_BASE + 0x4400U)
#define USB_BASE            (APB1PERIPH_BASE + 0x4800U)
#define USB_SRAM_BASE       (APB1PERIPH_BASE + 0x4C00U)
#define FDCAN1_BASE         (APB1PERIPH_BASE + 0x5000U)
#define FDCAN2_BASE         (APB1PERIPH_BASE + 0x5400U)
#define FDCAN3_BASE         (APB1PERIPH_BASE + 0x5800U)
#define GTIM5_BASE          (APB1PERIPH_BASE + 0x5C00U)
#define GTIM6_BASE          (APB1PERIPH_BASE + 0x6000U)
#define GTIM7_BASE          (APB1PERIPH_BASE + 0x6400U)
#define UART5_BASE          (APB1PERIPH_BASE + 0x6800U)
#define LPTIM1_BASE         (APB1PERIPH_BASE + 0x6C00U)
#define LPTIM2_BASE         (APB1PERIPH_BASE + 0x7000U)
#define I2C3_BASE           (APB1PERIPH_BASE + 0x7400U)
#define I2C4_BASE           (APB1PERIPH_BASE + 0x7800U)
#define DAC12_BASE          (APB1PERIPH_BASE + 0x7C00U)
#define DAC34_BASE          (APB1PERIPH_BASE + 0x8000U)
#define DVP_BASE            (APB1PERIPH_BASE + 0x8400U)

/* APB2 */
#define EXTI_BASE           (APB2PERIPH_BASE + 0x0400U)
#define AFIO_BASE           (APB2PERIPH_BASE + 0x0800U)
#define GTIM8_BASE          (APB2PERIPH_BASE + 0x0C00U)
#define GTIM9_BASE          (APB2PERIPH_BASE + 0x1000U)
#define GTIM10_BASE         (APB2PERIPH_BASE + 0x1400U)
#define SPI1_BASE           (APB2PERIPH_BASE + 0x1800U)
#define USART1_BASE         (APB2PERIPH_BASE + 0x1C00U)
#define UART6_BASE          (APB2PERIPH_BASE + 0x2000U)
#define UART7_BASE          (APB2PERIPH_BASE + 0x2400U)
#define USART4_BASE         (APB2PERIPH_BASE + 0x2800U)
#define SPI4_BASE           (APB2PERIPH_BASE + 0x2C00U)
#define SPI5_BASE           (APB2PERIPH_BASE + 0x3000U)
#define SPI6_BASE           (APB2PERIPH_BASE + 0x3400U)
#define COMP_BASE           (APB2PERIPH_BASE + 0x3800U)
#define PGA_BASE            (APB2PERIPH_BASE + 0x3C00U)

/* AHB */
#define DMA1_BASE           (AHBPERIPH_BASE + 0x0000U)
#define DMA1_CH1_BASE       (DMA1_BASE)        /* (0x40020000) */
#define DMA1_CH2_BASE       (DMA1_BASE + 0x14U)/* (0x40020014) */
#define DMA1_CH3_BASE       (DMA1_BASE + 0x28U)/* (0x40020028) */
#define DMA1_CH4_BASE       (DMA1_BASE + 0x3CU)/* (0x4002003C) */
#define DMA1_CH5_BASE       (DMA1_BASE + 0x50U)/* (0x40020050) */
#define DMA1_CH6_BASE       (DMA1_BASE + 0x64U)/* (0x40020064) */
#define DMA1_CH7_BASE       (DMA1_BASE + 0x78U)/* (0x40020078) */
#define DMA1_CH8_BASE       (DMA1_BASE + 0x8CU)/* (0x4002008C) */
#define DMA2_BASE           (AHBPERIPH_BASE + 0x0400U)
#define DMA2_CH1_BASE       (DMA2_BASE)       /* (0x40020400) */
#define DMA2_CH2_BASE       (DMA2_BASE + 0x14U)/* (0x40020414) */
#define DMA2_CH3_BASE       (DMA2_BASE + 0x28U)/* (0x40020428) */
#define DMA2_CH4_BASE       (DMA2_BASE + 0x3CU)/* (0x4002043C) */
#define DMA2_CH5_BASE       (DMA2_BASE + 0x50U)/* (0x40020450) */
#define DMA2_CH6_BASE       (DMA2_BASE + 0x64U)/* (0x40020464) */
#define DMA2_CH7_BASE       (DMA2_BASE + 0x78U)/* (0x40020478) */
#define DMA2_CH8_BASE       (DMA2_BASE + 0x8CU)/* (0x4002048C) */
#define RCC_BASE            (AHBPERIPH_BASE + 0x1000U)
#define SDIO_BASE           (AHBPERIPH_BASE + 0x1400U)
#define CRC_BASE            (AHBPERIPH_BASE + 0x1800U)
#define FMAC_BASE           (AHBPERIPH_BASE + 0x1C00U)
#define FLASH_R_BASE        (AHBPERIPH_BASE + 0x2000U) /* Flash registers base address */
#define OB_BASE             ((uint32_t)0x1FFFE000U)    /* Flash Option Bytes base address */
#define CORDIC_BASE         (AHBPERIPH_BASE + 0x2400U) 
#define BKP_SRAM_BASE       (AHBPERIPH_BASE + 0x3000U)
#define SMPU_BASE           (AHBPERIPH_BASE + 0x4C00U)
#define ETH_BASE            (AHBPERIPH_BASE + 0x5000U)
#define SAC_BASE            (AHBPERIPH_BASE + 0xA000U)
#define SAC_SRAM_BASE       (AHBPERIPH_BASE + 0xA400U)
#define DAC56_BASE          (AHBPERIPH_BASE + 0xA800U)
#define DAC78_BASE          (AHBPERIPH_BASE + 0xAC00U)
#define ADC1_BASE           (AHBPERIPH_BASE + 0xB000U)
#define ADC2_BASE           (AHBPERIPH_BASE + 0xB400U)
#define ADC3_BASE           (AHBPERIPH_BASE + 0xB800U)
#define ADC4_BASE           (AHBPERIPH_BASE + 0xBC00U)
#define GPIOA_BASE          (AHBPERIPH_BASE + 0xC000U)
#define GPIOB_BASE          (AHBPERIPH_BASE + 0xC400U)
#define GPIOC_BASE          (AHBPERIPH_BASE + 0xC800U)
#define GPIOD_BASE          (AHBPERIPH_BASE + 0xCC00U)
#define GPIOE_BASE          (AHBPERIPH_BASE + 0xD000U)
#define GPIOF_BASE          (AHBPERIPH_BASE + 0xD400U)
#define GPIOG_BASE          (AHBPERIPH_BASE + 0xD800U)
#define GPIOH_BASE          (AHBPERIPH_BASE + 0xDC00U)
#define SHRTIM1_BASE        (AHBPERIPH_BASE + 0x10000U)
#define ATIM1_BASE          (AHBPERIPH_BASE + 0x12000U)
#define ATIM2_BASE          (AHBPERIPH_BASE + 0x12400U)
#define ATIM3_BASE          (AHBPERIPH_BASE + 0x12800U)
#define USBHS_BASE         (AHBPERIPH_BASE + 0x20000U)

#define XSPI_BASE           ((uint32_t)0xA0001000U)
#define FEMC_BASE           ((uint32_t)0xA0002000U)

#define FEMC_SNBANK_BLOCK1_BASE     (FEMC_BASE + 0x0000U) 
#define FEMC_SNBANK_BLOCK2_BASE     (FEMC_BASE + 0x000CU) 
#define FEMC_SNBANK_BLOCK3_BASE     (FEMC_BASE + 0x0018U) 
#define FEMC_SNBANK_BLOCK4_BASE     (FEMC_BASE + 0x0024U) 
#define FEMC_NAND_BANK2_BASE        (FEMC_BASE + 0x0060U) 
#define FEMC_NAND_BANK3_BASE        (FEMC_BASE + 0x0080U) 

#define DBG_BASE            ((uint32_t)0xE0042000U) /* Debug MCU registers base address */

#define PWR                 ((PWR_Module*)PWR_BASE)
#define WWDG                ((WWDG_Module*)WWDG_BASE)
#define RTC                 ((RTC_Module*)RTC_BASE)
#define USART2              ((USART_Module*)USART2_BASE)
#define USART3              ((USART_Module*)USART3_BASE)
#define UART8               ((USART_Module*)UART8_BASE)
#define IWDG                ((IWDG_Module*)IWDG_BASE)
#define I2C1                ((I2C_Module*)I2C1_BASE)
#define I2C2                ((I2C_Module*)I2C2_BASE)
#define SPI2                ((SPI_Module*)SPI2_BASE)
#define I2S2_EXT            ((I2S_EXT_Module*)(SPI2_BASE + 0x200))
#define SPI3                ((SPI_Module*)SPI3_BASE)
#define I2S3_EXT            ((I2S_EXT_Module*)(SPI3_BASE + 0x200))
#define GTIM1               ((TIM_Module*)GTIM1_BASE)
#define GTIM2               ((TIM_Module*)GTIM2_BASE)
#define GTIM3               ((TIM_Module*)GTIM3_BASE)
#define GTIM4               ((TIM_Module*)GTIM4_BASE)
#define BTIM1               ((TIM_Module*)BTIM1_BASE)
#define BTIM2               ((TIM_Module*)BTIM2_BASE)
#define UCDR                ((UCDR_Module*)UCDR_BASE)
#define USB                 ((USB_Module*)USB_BASE)
#define FDCAN1              ((FDCAN_Module*)FDCAN1_BASE)
#define FDCAN2              ((FDCAN_Module*)FDCAN2_BASE)
#define FDCAN3              ((FDCAN_Module*)FDCAN3_BASE)
#define GTIM5               ((TIM_Module*)GTIM5_BASE)
#define GTIM6               ((TIM_Module*)GTIM6_BASE)
#define GTIM7               ((TIM_Module*)GTIM7_BASE)
#define UART5               ((USART_Module*)UART5_BASE)
#define LPTIM1              ((LPTIM_Module*)LPTIM1_BASE)
#define LPTIM2              ((LPTIM_Module*)LPTIM2_BASE)
#define I2C3                ((I2C_Module*)I2C3_BASE)
#define I2C4                ((I2C_Module*)I2C4_BASE)
#define DAC12               ((DAC_Module*)DAC12_BASE)
#define DAC34               ((DAC_Module*)DAC34_BASE)
#define DVP                 ((DVP_Module*)DVP_BASE)

#define EXTI                ((EXTI_Module*)EXTI_BASE)
#define AFIO                ((AFIO_Module*)AFIO_BASE)
#define GTIM8               ((TIM_Module*)GTIM8_BASE)
#define GTIM9               ((TIM_Module*)GTIM9_BASE)
#define GTIM10              ((TIM_Module*)GTIM10_BASE)
#define SPI1                ((SPI_Module*)SPI1_BASE)
#define USART1              ((USART_Module*)USART1_BASE)
#define UART6               ((USART_Module*)UART6_BASE)
#define UART7               ((USART_Module*)UART7_BASE)
#define USART4              ((USART_Module*)USART4_BASE)
#define SPI4                ((SPI_Module*)SPI4_BASE)
#define SPI5                ((SPI_Module*)SPI5_BASE)
#define SPI6                ((SPI_Module*)SPI6_BASE)
#define COMP                ((COMP_Module*)COMP_BASE)
#define PGA                 ((PGA_Module*)PGA_BASE)

#define DMA1                ((DMA_Module*)DMA1_BASE)
#define DMA2                ((DMA_Module*)DMA2_BASE)
#define DMA1_CH1            ((DMA_ChannelType *) DMA1_CH1_BASE)
#define DMA1_CH2            ((DMA_ChannelType *) DMA1_CH2_BASE)
#define DMA1_CH3            ((DMA_ChannelType *) DMA1_CH3_BASE)
#define DMA1_CH4            ((DMA_ChannelType *) DMA1_CH4_BASE)
#define DMA1_CH5            ((DMA_ChannelType *) DMA1_CH5_BASE)
#define DMA1_CH6            ((DMA_ChannelType *) DMA1_CH6_BASE)
#define DMA1_CH7            ((DMA_ChannelType *) DMA1_CH7_BASE)
#define DMA1_CH8            ((DMA_ChannelType *) DMA1_CH8_BASE)
#define DMA2_CH1            ((DMA_ChannelType *) DMA2_CH1_BASE)
#define DMA2_CH2            ((DMA_ChannelType *) DMA2_CH2_BASE)
#define DMA2_CH3            ((DMA_ChannelType *) DMA2_CH3_BASE)
#define DMA2_CH4            ((DMA_ChannelType *) DMA2_CH4_BASE)
#define DMA2_CH5            ((DMA_ChannelType *) DMA2_CH5_BASE)
#define DMA2_CH6            ((DMA_ChannelType *) DMA2_CH6_BASE)
#define DMA2_CH7            ((DMA_ChannelType *) DMA2_CH7_BASE)
#define DMA2_CH8            ((DMA_ChannelType *) DMA2_CH8_BASE)
#define RCC                 ((RCC_Module*)RCC_BASE)
#define SDIO                ((SDIO_Module*)SDIO_BASE)
#define CRC                 ((CRC_Module*)CRC_BASE)
#define FMAC                ((FMAC_Module*)FMAC_BASE)
#define FLASH               ((FLASH_Module*)FLASH_R_BASE)
#define OBT                 ((OB_Module *) OB_BASE)
#define CORDIC              ((CORDIC_Module*)CORDIC_BASE)
#define ETH                 ((ETH_Module*)ETH_BASE)
#define SAC                 ((SAC_Module*)SAC_BASE)
#define DAC56               ((DAC_Module*)DAC56_BASE)
#define DAC78               ((DAC_Module*)DAC78_BASE)
#define ADC1                ((ADC_Module*)ADC1_BASE)
#define ADC2                ((ADC_Module*)ADC2_BASE)
#define ADC3                ((ADC_Module*)ADC3_BASE)
#define ADC4                ((ADC_Module*)ADC4_BASE)
#define GPIOA               ((GPIO_Module*)GPIOA_BASE)
#define GPIOB               ((GPIO_Module*)GPIOB_BASE)
#define GPIOC               ((GPIO_Module*)GPIOC_BASE)
#define GPIOD               ((GPIO_Module*)GPIOD_BASE)
#define GPIOE               ((GPIO_Module*)GPIOE_BASE)
#define GPIOF               ((GPIO_Module*)GPIOF_BASE)
#define GPIOG               ((GPIO_Module*)GPIOG_BASE)
#define GPIOH               ((GPIO_Module*)GPIOH_BASE)
#define SHRTIM1             ((SHRTIM_Module*)SHRTIM1_BASE)
#define ATIM1               ((TIM_Module*)ATIM1_BASE)
#define ATIM2               ((TIM_Module*)ATIM2_BASE)
#define ATIM3               ((TIM_Module*)ATIM3_BASE)
#define USBHS               ((USBHS_Module*)USBHS_BASE)

#define XSPI                    ((XSPI_Module*)XSPI_BASE)
#define FEMC                    ((FEMC_Module*)FEMC_BASE)
#define FEMC_SN_BANK_BLOCK1     ((FEMC_SN_Bank_Block*)FEMC_SNBANK_BLOCK1_BASE)
#define FEMC_SN_BANK_BLOCK2     ((FEMC_SN_Bank_Block*)FEMC_SNBANK_BLOCK2_BASE)
#define FEMC_SN_BANK_BLOCK3     ((FEMC_SN_Bank_Block*)FEMC_SNBANK_BLOCK3_BASE)
#define FEMC_SN_BANK_BLOCK4     ((FEMC_SN_Bank_Block*)FEMC_SNBANK_BLOCK4_BASE)
#define FEMC_NAND_BANK2         ((FEMC_NAND_Bank*)FEMC_NAND_BANK2_BASE)
#define FEMC_NAND_BANK3         ((FEMC_NAND_Bank*)FEMC_NAND_BANK3_BASE)
    
#define DBG                     ((DBG_Module*)DBG_BASE)

/******************************************************************************/
/*                         Peripheral Registers_Bits_Definition               */
/******************************************************************************/

/*** CRC calculation unit ***/

/** Bit definition for CRC_CRC32DAT register **/
#define CRC32_DAT_DAT           ((uint32_t)0xFFFFFFFFU) /* Data register bits */

/** Bit definition for CRC_CRC32IDAT register **/
#define CRC32_IDAT_IDAT         ((uint8_t)0xFFU) /* General-purpose 8-bit data register bits */

/** Bit definition for CRC_CRC32CTRL register **/
#define CRC32_CTRL_RESET        ((uint8_t)0x01U) /* RESET bit */

/** Bit definition for CRC16_CR register **/
#define CRC16_CTRL_LITTLE       ((uint8_t)0x02U)
#define CRC16_CTRL_BIG          ((uint8_t)0xFDU)

#define CRC16_CTRL_RESET        ((uint8_t)0x04U)
#define CRC16_CTRL_NO_RESET     ((uint8_t)0xFBU)


/*** Power Control   ***/

/** Bit definition for PWR_CTRL register  **/
#define PWR_CTRL_CWKUP5F          ((uint32_t)0x00010000U) /*Clear PH6 wake-up flag */
#define PWR_CTRL_CWKUP4F          ((uint32_t)0x00008000U) /*Clear PC5 wake-up flag */
#define PWR_CTRL_CWKUP3F          ((uint32_t)0x00004000U) /*Clear PA2 wake-up flag */
#define PWR_CTRL_CWKUPPF          ((uint32_t)0x00002000U) /*Clear RTC/LSECSS/LPTIM1/LPTIM2 wake-up flag */
#define PWR_CTRL_CWKUP2F          ((uint32_t)0x00001000U) /*Clear PC13 wake-up flag */
#define PWR_CTRL_CWKUP1F          ((uint32_t)0x00000800U) /*Clear PA0 wake-up flag */
#define PWR_CTRL_CWKUP0F          ((uint32_t)0x00000400U) /*Clear PE6 wake-up flag */
#define PWR_CTRL_MSB              ((uint32_t)0x00000200U) /*PVD level select */
#define PWR_CTRL_DBKP             ((uint32_t)0x00000100U) /*Cancel write-protection of the backup domain */

#define PWR_CTRL_PLS              ((uint32_t)0x000000E0U) /*PVD level select */
#define PWR_CTRL_PLS_0            ((uint32_t)0x00000020U) /*PWR_CTRL Bit5*/
#define PWR_CTRL_PLS_1            ((uint32_t)0x00000040U) /*PWR_CTRL Bit6*/
#define PWR_CTRL_PLS_2            ((uint32_t)0x00000080U) /*PWR_CTRL Bit7*/

#define PWR_CTRL_PLS_LVL0         ((uint32_t)0x00000000U) /*PVD level 0 */
#define PWR_CTRL_PLS_LVL1         ((uint32_t)0x00000020U) /*PVD level 1 */
#define PWR_CTRL_PLS_LVL2         ((uint32_t)0x00000040U) /*PVD level 2 */
#define PWR_CTRL_PLS_LVL3         ((uint32_t)0x00000060U) /*PVD level 3 */
#define PWR_CTRL_PLS_LVL4         ((uint32_t)0x00000080U) /*PVD level 4 */
#define PWR_CTRL_PLS_LVL5         ((uint32_t)0x000000A0U) /*PVD level 5 */
#define PWR_CTRL_PLS_LVL6         ((uint32_t)0x000000C0U) /*PVD level 6 */
#define PWR_CTRL_PLS_LVL7         ((uint32_t)0x000000E0U) /*PVD level 7 */


#define PWR_CTRL_PVDEN            ((uint32_t)0x00000010U) /*PVD enable */
#define PWR_CTRL_CSBVBF           ((uint32_t)0x00000008U) /*Clear standby and VBAT flag */
#define PWR_CTRL_PDS              ((uint32_t)0x00000002U) /*Power-down deep sleep bit.  */
#define PWR_CTRL_LPS              ((uint32_t)0x00000001U) /*Low power under deep sleep. */

/** Bit definition for PWR_CTRLSTS register  **/
#define PWR_CTRLSTS_WKUP5EN          ((uint32_t)0x00800000U) /*PH6 wake-up enable */
#define PWR_CTRLSTS_WKUP5F           ((uint32_t)0x00400000U) /*PH6 wake-up flag */
#define PWR_CTRLSTS_WKUP4F           ((uint32_t)0x00200000U) /*PC5 wake-up flag */
#define PWR_CTRLSTS_WKUP3F           ((uint32_t)0x00100000U) /*PA2 wake-up flag */
#define PWR_CTRLSTS_WKUP4POL         ((uint32_t)0x00080000U) /*PC5 wake-up polarity */
#define PWR_CTRLSTS_WKUP3POL         ((uint32_t)0x00040000U) /*PA2 wake-up polarity */
#define PWR_CTRLSTS_WKUP4EN          ((uint32_t)0x00020000U) /*PC5 wake-up enable */
#define PWR_CTRLSTS_WKUP3EN          ((uint32_t)0x00010000U) /*PA2 wake-up enable */
#define PWR_CTRLSTS_VBATF            ((uint32_t)0x00008000U) /*VBAT flag */
#define PWR_CTRLSTS_WKUP2POL         ((uint32_t)0x00004000U) /*PC13 wake-up polarity */
#define PWR_CTRLSTS_WKUP1POL         ((uint32_t)0x00002000U) /*PA0  wake-up polarity */
#define PWR_CTRLSTS_WKUP0POL         ((uint32_t)0x00001000U) /*PE6  wake-up polarity */
#define PWR_CTRLSTS_WKUPP1EN         ((uint32_t)0x00000800U) /*RTC/LSECSS wake-up enable */
#define PWR_CTRLSTS_WKUP2EN          ((uint32_t)0x00000400U) /*PC13 wake-up enable */
#define PWR_CTRLSTS_WKUP1EN          ((uint32_t)0x00000200U) /*PA0 wake-up enable */
#define PWR_CTRLSTS_WKUP0EN          ((uint32_t)0x00000100U) /*PE6 wake-up enable */
#define PWR_CTRLSTS_WKUPP0EN         ((uint32_t)0x00000080U) /*LPTIM1/LPTIM2 wake-up enable */
#define PWR_CTRLSTS_WKUPPF           ((uint32_t)0x00000040U) /*RTC/LSECSS/LPTIM1/LPTIM2 wake-up flag */
#define PWR_CTRLSTS_WKUP2F           ((uint32_t)0x00000020U) /*PC13 wake-up flag */
#define PWR_CTRLSTS_WKUP1F           ((uint32_t)0x00000010U) /*PA0 wake-up flag */
#define PWR_CTRLSTS_WKUP0F           ((uint32_t)0x00000008U) /*PE6 wake-up flag */
#define PWR_CTRLSTS_PVDO             ((uint32_t)0x00000004U) /*PVD output flag */
#define PWR_CTRLSTS_SBF              ((uint32_t)0x00000002U) /*Standby flag */

/** Bit definition for PWR_CTRL2 register  **/
#define PWR_CTRL2_IWDGRSTEN        ((uint32_t)0x00000400U) /*Independent watchdog reset enable */
#define PWR_CTRL2_BSRSTBRET        ((uint32_t)0x00000004U) /*The BKP SRAM holds in standby mode */
#define PWR_CTRL2_BSRVBRET         ((uint32_t)0x00000002U) /*The BKP SRAM holds in vbat mode */

/** Bit definition for PWR_CTRL3 register  **/
#define PWR_CTRL3_BKRSEL           ((uint32_t)0x00004000U) /*BKR regulator output level selection */

/** Bit definition for PWR_CTRL4 register  **/
#define PWR_CTRL4_LSENIMEN         ((uint32_t)0x00000400U) /*LSE Noise Elimination Enable */

/** Bit definition for PWR_NRSTCTRL register  **/
#define PWR_NRSTCTRL_NRSTDFW        ((uint32_t)0x00000FF0U) /*NRST digital filtering width */
#define PWR_NRSTCTRL_NRSTDFEN       ((uint32_t)0x00000008U) /*NRST Digital Filter Enable */
#define PWR_NRSTCTRL_NRSTAFEN       ((uint32_t)0x00000004U) /*NRST Analog Filter Enable */

/** Bit definition for PWR_CTRL5 register  **/
#define PWR_CTRL5_LSECSSIEN        ((uint32_t)0x80000000U) /*LSE Crystal Mode Clock Safety System Interrupt Enable */
#define PWR_CTRL5_LSECSSCRYF       ((uint32_t)0x20000000U) /*LSE Crystal Mode Clock Safety Fault Flag */

/** Bit definition for PWR_CTRL6 register  **/
#define PWR_CTRL6_LSECSSSW         ((uint32_t)0x80000000U) /*LSE Clock Safety System Switching */
#define PWR_CTRL6_LPWKUPSEL        ((uint32_t)0x40000000U) /*Low power mode wake-up clock selection */

#define PWR_CTRL6_NRSTSEL          ((uint32_t)0x30000000U) /*NRST (PH6) Pin Function Configuration */
#define PWR_CTRL6_NRSTSEL_0        ((uint32_t)0x10000000U) /*Bit0*/
#define PWR_CTRL6_NRSTSEL_1        ((uint32_t)0x20000000U) /*Bit1*/

#define PWR_CTRL6_LSEFHF           ((uint32_t)0x08000000U) /*LSE Frequency Exceeds High Limit Flag */
#define PWR_CTRL6_LSEFLF           ((uint32_t)0x04000000U) /*LSE frequency exceeds low limit value flag */
#define PWR_CTRL6_LSECSSF          ((uint32_t)0x02000000U) /*LSE Clock Safety System Flag */

#define PWR_CTRL6_LCOSEL           ((uint32_t)0x00001000U) /*LCO low-speed clock output selection */
#define PWR_CTRL6_LCOEN            ((uint32_t)0x00000800U) /*LCO low-speed clock output enable */
#define PWR_CTRL6_LSEFHTHR         ((uint32_t)0x00000400U) /*Bypass mode LSE frequency high limit value configuration */
#define PWR_CTRL6_PVDSRC           ((uint32_t)0x00000020U) /*PVD input source selection */

/** Bit definition for PWR_EMCCTRL register  **/
#define PWR_EMCCTRL_BSRECCF          ((uint32_t)0x0000C000U) /*BKP SRAM ECC error flag bit */
#define PWR_EMCCTRL_BSRECCF_0        ((uint32_t)0x00004000U) /*Bit0*/
#define PWR_EMCCTRL_BSRECCF_1        ((uint32_t)0x00008000U) /*Bit1*/
#define PWR_EMCCTRL_BSRECCRSTEN      ((uint32_t)0x00003000U) /*BKP SRAM ECC error reset enable */
#define PWR_EMCCTRL_BSRECCRSTEN_0    ((uint32_t)0x00001000U) /*Bit0*/
#define PWR_EMCCTRL_BSRECCRSTEN_1    ((uint32_t)0x00002000U) /*Bit1*/
#define PWR_EMCCTRL_BSRECCIEN        ((uint32_t)0x00000C00U) /*BKP SRAM ECC error interrupt enable */
#define PWR_EMCCTRL_BSRECCIEN_0      ((uint32_t)0x00000400U) /*Bit0*/
#define PWR_EMCCTRL_BSRECCIEN_1      ((uint32_t)0x00000800U) /*Bit1*/
#define PWR_EMCCTRL_EMCRST           ((uint32_t)0x00000200U) /*Main and backup domain EMC reset enable */
#define PWR_EMCCTRL_BKPGBRST         ((uint32_t)0x00000100U) /*Backup domain GB reset enable */
#define PWR_EMCCTRL_BKPGBNRST        ((uint32_t)0x00000080U) /*Backup domain GBN reset enable*/
#define PWR_EMCCTRL_BKPCLPRST        ((uint32_t)0x00000040U) /*Backup domain CLP reset enable*/
#define PWR_EMCCTRL_BKPGBDET         ((uint32_t)0x00000020U) /*Backup domain GB detect enable */
#define PWR_EMCCTRL_BKPGBNDET        ((uint32_t)0x00000010U) /*Backup domain GBN detect enable*/
#define PWR_EMCCTRL_BKPCLPDET        ((uint32_t)0x00000008U) /*Backup domain CLP detect enable*/

/** Bit definition for PWR_EMCCTRL2 register  **/
#define PWR_EMCCTRL2_BKPGBF           ((uint32_t)0x00008000U) /*Backup domain GB flag */
#define PWR_EMCCTRL2_BKPGBNF          ((uint32_t)0x00004000U) /*Backup domain GBN flag */
#define PWR_EMCCTRL2_BKPCLPF          ((uint32_t)0x00002000U) /*Backup domain CLP flag */
#define PWR_EMCCTRL2_GB3F             ((uint32_t)0x00001000U) /*Main domain GB3 flag */
#define PWR_EMCCTRL2_GB2F             ((uint32_t)0x00000800U) /*Main domain GB2 flag */
#define PWR_EMCCTRL2_GB1F             ((uint32_t)0x00000400U) /*Main domain GB1 flag */
#define PWR_EMCCTRL2_GB0F             ((uint32_t)0x00000200U) /*Main domain GB0 flag */
#define PWR_EMCCTRL2_GBN3F            ((uint32_t)0x00000100U) /*Main domain GBN3 flag */
#define PWR_EMCCTRL2_GBN2F            ((uint32_t)0x00000080U) /*Main domain GBN2 flag */
#define PWR_EMCCTRL2_GBN1F            ((uint32_t)0x00000040U) /*Main domain GBN1 flag */
#define PWR_EMCCTRL2_GBN0F            ((uint32_t)0x00000020U) /*Main domain GBN0 flag */
#define PWR_EMCCTRL2_CLP3F            ((uint32_t)0x00000010U) /*Main domain CLP3 flag */
#define PWR_EMCCTRL2_CLP2F            ((uint32_t)0x00000008U) /*Main domain CLP2 flag */
#define PWR_EMCCTRL2_CLP1F            ((uint32_t)0x00000004U) /*Main domain CLP1 flag */
#define PWR_EMCCTRL2_CLP0F            ((uint32_t)0x00000002U) /*Main domain CLP0 flag */
#define PWR_EMCCTRL2_EMCFCLR          ((uint32_t)0x00000001U) /*EMC Flag Bit Clear */

/*** Reset and Clock Control ***/

/** Bit definition for RCC_CTRL register **/
#define RCC_CTRL_PLLEN    ((uint32_t)0x00000001U) /* PLL enable */
#define RCC_CTRL_PLLRDF   ((uint32_t)0x00000002U) /* PLL clock ready flag */
#define RCC_CTRL_HSIEN    ((uint32_t)0x00000004U) /* Internal High Speed clock enable */
#define RCC_CTRL_HSIRDF   ((uint32_t)0x00000008U) /* Internal High Speed clock ready flag */
#define RCC_CTRL_HSEEN    ((uint32_t)0x00000010U) /* External High Speed clock enable */
#define RCC_CTRL_HSERDF   ((uint32_t)0x00000020U) /* External High Speed clock ready flag */
#define RCC_CTRL_HSEBP    ((uint32_t)0x00000040U) /* External High Speed clock Bypass */
#define RCC_CTRL_HSECSSEN ((uint32_t)0x00000080U) /* HSE Clock Security System enable */
#define RCC_CTRL_HSICAL   ((uint32_t)0x000FFF00U) /* Internal High Speed clock Calibration */
#define RCC_CTRL_HSITRIM  ((uint32_t)0x07F00000U) /* Internal High Speed clock trimming */


/**  Bit definition for RCC_CFG register  **/

#define RCC_CFG_PLLSRC     ((uint32_t)0x00000001U) /* PLL entry clock source */
#define RCC_CFG_PLLHSEPRES ((uint32_t)0x00000002U) /* HSE divider for PLL entry */
#define RCC_CFG_PLLHSIPRES ((uint32_t)0x00000004U) /* HSI divider for PLL entry */
/* PLLMULFCT configuration */
#define RCC_CFG_PLLMULFCT   ((uint32_t)0x000001F8U) /* PLLMUL[5:0] bits (PLL multiplication factor) */
#define RCC_CFG_PLLMULFCT_0 ((uint32_t)0x00000008U) /* Bit 0 */
#define RCC_CFG_PLLMULFCT_1 ((uint32_t)0x00000010U) /* Bit 1 */
#define RCC_CFG_PLLMULFCT_2 ((uint32_t)0x00000020U) /* Bit 2 */
#define RCC_CFG_PLLMULFCT_3 ((uint32_t)0x00000040U) /* Bit 3 */
#define RCC_CFG_PLLMULFCT_4 ((uint32_t)0x00000080U) /* Bit 4 */
#define RCC_CFG_PLLMULFCT_5 ((uint32_t)0x00000100U) /* Bit 5 */

#define RCC_CFG_PLLMULFCT4   ((uint32_t)0x00000000U) /* PLL input clock*4 */
#define RCC_CFG_PLLMULFCT6   ((uint32_t)0x00000008U) /* PLL input clock*6 */
#define RCC_CFG_PLLMULFCT8   ((uint32_t)0x00000010U) /* PLL input clock*8 */
#define RCC_CFG_PLLMULFCT10  ((uint32_t)0x00000018U) /* PLL input clock*10 */
#define RCC_CFG_PLLMULFCT12  ((uint32_t)0x00000020U) /* PLL input clock*12 */
#define RCC_CFG_PLLMULFCT14  ((uint32_t)0x00000028U) /* PLL input clock*14 */
#define RCC_CFG_PLLMULFCT16  ((uint32_t)0x00000030U) /* PLL input clock*16 */
#define RCC_CFG_PLLMULFCT18  ((uint32_t)0x00000038U) /* PLL input clock*18 */
#define RCC_CFG_PLLMULFCT20  ((uint32_t)0x00000040U) /* PLL input clock*20 */
#define RCC_CFG_PLLMULFCT22  ((uint32_t)0x00000048U) /* PLL input clock*22 */
#define RCC_CFG_PLLMULFCT24  ((uint32_t)0x00000050U) /* PLL input clock*24 */
#define RCC_CFG_PLLMULFCT26  ((uint32_t)0x00000058U) /* PLL input clock*26 */
#define RCC_CFG_PLLMULFCT28  ((uint32_t)0x00000060U) /* PLL input clock*28 */
#define RCC_CFG_PLLMULFCT30  ((uint32_t)0x00000068U) /* PLL input clock*30 */
#define RCC_CFG_PLLMULFCT32  ((uint32_t)0x00000070U) /* PLL input clock*32 */
#define RCC_CFG_PLLMULFCT34  ((uint32_t)0x00000078U) /* PLL input clock*34 */
#define RCC_CFG_PLLMULFCT36  ((uint32_t)0x00000080U) /* PLL input clock*36 */
#define RCC_CFG_PLLMULFCT38  ((uint32_t)0x00000088U) /* PLL input clock*38 */
#define RCC_CFG_PLLMULFCT40  ((uint32_t)0x00000090U) /* PLL input clock*40 */
#define RCC_CFG_PLLMULFCT42  ((uint32_t)0x00000098U) /* PLL input clock*42 */
#define RCC_CFG_PLLMULFCT44  ((uint32_t)0x000000A0U) /* PLL input clock*44 */
#define RCC_CFG_PLLMULFCT46  ((uint32_t)0x000000A8U) /* PLL input clock*46 */
#define RCC_CFG_PLLMULFCT48  ((uint32_t)0x000000B0U) /* PLL input clock*48 */
#define RCC_CFG_PLLMULFCT50  ((uint32_t)0x000000B8U) /* PLL input clock*50 */
#define RCC_CFG_PLLMULFCT52  ((uint32_t)0x000000C0U) /* PLL input clock*52 */
#define RCC_CFG_PLLMULFCT54  ((uint32_t)0x000000C8U) /* PLL input clock*54 */
#define RCC_CFG_PLLMULFCT56  ((uint32_t)0x000000D0U) /* PLL input clock*56 */
#define RCC_CFG_PLLMULFCT58  ((uint32_t)0x000000D8U) /* PLL input clock*58 */
#define RCC_CFG_PLLMULFCT60  ((uint32_t)0x000000E0U) /* PLL input clock*60 */
#define RCC_CFG_PLLMULFCT62  ((uint32_t)0x000000E8U) /* PLL input clock*62 */
#define RCC_CFG_PLLMULFCT64  ((uint32_t)0x000000F0U) /* PLL input clock*64 */
#define RCC_CFG_PLLMULFCT66  ((uint32_t)0x000000F8U) /* PLL input clock*66 */
#define RCC_CFG_PLLMULFCT68  ((uint32_t)0x00000100U) /* PLL input clock*68 */
#define RCC_CFG_PLLMULFCT70  ((uint32_t)0x00000108U) /* PLL input clock*70 */
#define RCC_CFG_PLLMULFCT72  ((uint32_t)0x00000110U) /* PLL input clock*72 */
#define RCC_CFG_PLLMULFCT74  ((uint32_t)0x00000118U) /* PLL input clock*74 */
#define RCC_CFG_PLLMULFCT76  ((uint32_t)0x00000120U) /* PLL input clock*76 */

/* APB1PRES configuration */
#define RCC_CFG_APB1PRES   ((uint32_t)0x00000E00U) /* PRE1[2:0] bits (APB1 prescaler) */
#define RCC_CFG_APB1PRES_0 ((uint32_t)0x00000200U) /* Bit 0 */
#define RCC_CFG_APB1PRES_1 ((uint32_t)0x00000400U) /* Bit 1 */
#define RCC_CFG_APB1PRES_2 ((uint32_t)0x00000800U) /* Bit 2 */

#define RCC_CFG_APB1PRES_DIV1  ((uint32_t)0x00000000U) /* HCLK not divided */
#define RCC_CFG_APB1PRES_DIV2  ((uint32_t)0x00000800U) /* HCLK divided by 2 */
#define RCC_CFG_APB1PRES_DIV4  ((uint32_t)0x00000A00U) /* HCLK divided by 4 */
#define RCC_CFG_APB1PRES_DIV8  ((uint32_t)0x00000C00U) /* HCLK divided by 8 */
#define RCC_CFG_APB1PRES_DIV16 ((uint32_t)0x00000E00U) /* HCLK divided by 16 */

/* APB2PRES configuration */
#define RCC_CFG_APB2PRES   ((uint32_t)0x00007000U) /* PRE2[2:0] bits (APB2 prescaler) */
#define RCC_CFG_APB2PRES_0 ((uint32_t)0x00001000U) /* Bit 0 */
#define RCC_CFG_APB2PRES_1 ((uint32_t)0x00002000U) /* Bit 1 */
#define RCC_CFG_APB2PRES_2 ((uint32_t)0x00004000U) /* Bit 2 */

#define RCC_CFG_APB2PRES_DIV1  ((uint32_t)0x00000000U) /* HCLK not divided */
#define RCC_CFG_APB2PRES_DIV2  ((uint32_t)0x00004000U) /* HCLK divided by 2 */
#define RCC_CFG_APB2PRES_DIV4  ((uint32_t)0x00005000U) /* HCLK divided by 4 */
#define RCC_CFG_APB2PRES_DIV8  ((uint32_t)0x00006000U) /* HCLK divided by 8 */
#define RCC_CFG_APB2PRES_DIV16 ((uint32_t)0x00007000U) /* HCLK divided by 16 */

/* AHBPRES configuration */
#define RCC_CFG_AHBPRES   ((uint32_t)0x000F0000U) /* HPRE[3:0] bits (AHB prescaler) */
#define RCC_CFG_AHBPRES_0 ((uint32_t)0x00010000U) /* Bit 0 */
#define RCC_CFG_AHBPRES_1 ((uint32_t)0x00020000U) /* Bit 1 */
#define RCC_CFG_AHBPRES_2 ((uint32_t)0x00040000U) /* Bit 2 */
#define RCC_CFG_AHBPRES_3 ((uint32_t)0x00080000U) /* Bit 3 */

#define RCC_CFG_AHBPRES_DIV1   ((uint32_t)0x00000000U) /* SYSCLK not divided */
#define RCC_CFG_AHBPRES_DIV2   ((uint32_t)0x00080000U) /* SYSCLK divided by 2 */
#define RCC_CFG_AHBPRES_DIV4   ((uint32_t)0x00090000U) /* SYSCLK divided by 4 */
#define RCC_CFG_AHBPRES_DIV8   ((uint32_t)0x000A0000U) /* SYSCLK divided by 8 */
#define RCC_CFG_AHBPRES_DIV16  ((uint32_t)0x000B0000U) /* SYSCLK divided by 16 */
#define RCC_CFG_AHBPRES_DIV64  ((uint32_t)0x000C0000U) /* SYSCLK divided by 64 */
#define RCC_CFG_AHBPRES_DIV128 ((uint32_t)0x000D0000U) /* SYSCLK divided by 128 */
#define RCC_CFG_AHBPRES_DIV256 ((uint32_t)0x000E0000U) /* SYSCLK divided by 256 */
#define RCC_CFG_AHBPRES_DIV512 ((uint32_t)0x000F0000U) /* SYSCLK divided by 512 */

/* MCOPRES configuration */
#define RCC_CFG_MCOPRES   ((uint32_t)0x00F00000U) /* MCOPRE[3:0] bits ( PLL prescaler to MCO.) */
#define RCC_CFG_MCOPRES_0 ((uint32_t)0x00100000U) /* Bit 0 */
#define RCC_CFG_MCOPRES_1 ((uint32_t)0x00200000U) /* Bit 1 */
#define RCC_CFG_MCOPRES_2 ((uint32_t)0x00400000U) /* Bit 2 */
#define RCC_CFG_MCOPRES_3 ((uint32_t)0x00800000U) /* Bit 3 */

#define RCC_CFG_MCOPRES_PLLDIV2  ((uint32_t)0x00200000U) /* PLL clock is divided by 2 */
#define RCC_CFG_MCOPRES_PLLDIV3  ((uint32_t)0x00300000U) /* PLL clock is divided by 3 */
#define RCC_CFG_MCOPRES_PLLDIV4  ((uint32_t)0x00400000U) /* PLL clock is divided by 4 */
#define RCC_CFG_MCOPRES_PLLDIV5  ((uint32_t)0x00500000U) /* PLL clock is divided by 5 */
#define RCC_CFG_MCOPRES_PLLDIV6  ((uint32_t)0x00600000U) /* PLL clock is divided by 6 */
#define RCC_CFG_MCOPRES_PLLDIV7  ((uint32_t)0x00700000U) /* PLL clock is divided by 7 */
#define RCC_CFG_MCOPRES_PLLDIV8  ((uint32_t)0x00800000U) /* PLL clock is divided by 8 */
#define RCC_CFG_MCOPRES_PLLDIV9  ((uint32_t)0x00900000U) /* PLL clock is divided by 9 */
#define RCC_CFG_MCOPRES_PLLDIV10 ((uint32_t)0x00A00000U) /* PLL clock is divided by 10 */
#define RCC_CFG_MCOPRES_PLLDIV11 ((uint32_t)0x00B00000U) /* PLL clock is divided by 11 */
#define RCC_CFG_MCOPRES_PLLDIV12 ((uint32_t)0x00C00000U) /* PLL clock is divided by 12 */
#define RCC_CFG_MCOPRES_PLLDIV13 ((uint32_t)0x00D00000U) /* PLL clock is divided by 13 */
#define RCC_CFG_MCOPRES_PLLDIV14 ((uint32_t)0x00E00000U) /* PLL clock is divided by 14 */
#define RCC_CFG_MCOPRES_PLLDIV15 ((uint32_t)0x00F00000U) /* PLL clock is divided by 15 */

/* SCLKSTS configuration */
#define RCC_CFG_SCLKSTS   ((uint32_t)0x03000000U) /* SWS[1:0] bits (System Clock Switch Status) */
#define RCC_CFG_SCLKSTS_0 ((uint32_t)0x01000000U) /* Bit 0 */
#define RCC_CFG_SCLKSTS_1 ((uint32_t)0x02000000U) /* Bit 1 */

#define RCC_CFG_SCLKSTS_HSI ((uint32_t)0x00000000U) /* HSI clock used as system clock*/
#define RCC_CFG_SCLKSTS_HSE ((uint32_t)0x01000000U) /* HSE oscillator used as system clock */
#define RCC_CFG_SCLKSTS_PLL ((uint32_t)0x02000000U) /* PLL used as system clock  */

/* SCLKSW configuration */
#define RCC_CFG_SCLKSW   ((uint32_t)0x0C000000U) /* SW[1:0] bits (System clock Switch) */
#define RCC_CFG_SCLKSW_0 ((uint32_t)0x04000000U) /* Bit 0 */
#define RCC_CFG_SCLKSW_1 ((uint32_t)0x08000000U) /* Bit 1 */

#define RCC_CFG_SCLKSW_HSI ((uint32_t)0x00000000U) /* HSI selected as system clock */
#define RCC_CFG_SCLKSW_HSE ((uint32_t)0x04000000U) /* HSE selected as system clock */
#define RCC_CFG_SCLKSW_PLL ((uint32_t)0x08000000U) /* PLL selected as system clock (optional PLL, SHRTPLL, USBHS240M) */

/* MCOPLLSEL configuration */
#define RCC_CFG_MCOPLLSEL   ((uint32_t)0xC0000000U) /* SW[1:0] bits (System clock Switch) */
#define RCC_CFG_MCOPLLSEL_0 ((uint32_t)0x40000000U) /* Bit 0 */
#define RCC_CFG_MCOPLLSEL_1 ((uint32_t)0x80000000U) /* Bit 1 */

#define RCC_CFG_MCOPLLSEL_PLL        ((uint32_t)0x00000000U) /* PLL selected as MCO output */
#define RCC_CFG_MCOPLLSEL_SHRTPLL    ((uint32_t)0x40000000U) /* SHRTPLL selected as MCO output */
#define RCC_CFG_MCOPLLSEL_USBHS240M ((uint32_t)0xC0000000U) /* USBHS240M selected as MCO output */

/** Bit definition for RCC_CFG2 register  **/
/* ADCHPRE configuration */
#define RCC_CFG2_ADCHPRES        ((uint32_t)0x0000000FU) /*ADCHPRE[3:0] */
#define RCC_CFG2_ADCHPRES_0      ((uint32_t)0x00000001U) /*Bit0*/
#define RCC_CFG2_ADCHPRES_1      ((uint32_t)0x00000002U) /*Bit1*/
#define RCC_CFG2_ADCHPRES_2      ((uint32_t)0x00000004U) /*Bit2*/
#define RCC_CFG2_ADCHPRES_3      ((uint32_t)0x00000008U) /*Bit3*/

#define RCC_CFG2_ADCHPRES_DIV1   ((uint32_t)0x00000000U) /* HCLK clock divided by 1 */
#define RCC_CFG2_ADCHPRES_DIV2   ((uint32_t)0x00000001U) /* HCLK clock divided by 2 */
#define RCC_CFG2_ADCHPRES_DIV3   ((uint32_t)0x00000002U) /* HCLK clock divided by 3 */
#define RCC_CFG2_ADCHPRES_DIV4   ((uint32_t)0x00000003U) /* HCLK clock divided by 4 */
#define RCC_CFG2_ADCHPRES_DIV6   ((uint32_t)0x00000004U) /* HCLK clock divided by 6 */
#define RCC_CFG2_ADCHPRES_DIV8   ((uint32_t)0x00000005U) /* HCLK clock divided by 8  */
#define RCC_CFG2_ADCHPRES_DIV10  ((uint32_t)0x00000006U) /* HCLK clock divided by 10 */
#define RCC_CFG2_ADCHPRES_DIV12  ((uint32_t)0x00000007U) /* HCLK clock divided by 12 */
#define RCC_CFG2_ADCHPRES_DIV16  ((uint32_t)0x00000008U) /* HCLK clock divided by 16 */
#define RCC_CFG2_ADCHPRES_DIV32  ((uint32_t)0x00000009U) /* HCLK clock divided by 32 */

/* ADCOTGPLLPRES configuration */
#define RCC_CFG2_ADCOTGPLLPRES        ((uint32_t)0x00000070U) /*ADCOTGPLLPRES[2:0] */
#define RCC_CFG2_ADCOTGPLLPRES_0      ((uint32_t)0x00000010U) /*Bit0*/
#define RCC_CFG2_ADCOTGPLLPRES_1      ((uint32_t)0x00000020U) /*Bit1*/
#define RCC_CFG2_ADCOTGPLLPRES_2      ((uint32_t)0x00000040U) /*Bit2*/

#define RCC_CFG2_ADCOTGPLLPRES_DIV1   ((uint32_t)0x00000000U) /* USBHS or PLL clock divided by 1 */
#define RCC_CFG2_ADCOTGPLLPRES_DIV2   ((uint32_t)0x00000010U) /* USBHS or PLL clock divided by 2 */
#define RCC_CFG2_ADCOTGPLLPRES_DIV3   ((uint32_t)0x00000020U) /* USBHS or PLL clock divided by 3 */
#define RCC_CFG2_ADCOTGPLLPRES_DIV4   ((uint32_t)0x00000030U) /* USBHS or PLL clock divided by 4 */
#define RCC_CFG2_ADCOTGPLLPRES_DIV6   ((uint32_t)0x00000040U) /* USBHS or PLL clock divided by 6 */
#define RCC_CFG2_ADCOTGPLLPRES_DIV8   ((uint32_t)0x00000050U) /* USBHS or PLL clock divided by 8  */
#define RCC_CFG2_ADCOTGPLLPRES_DIV10  ((uint32_t)0x00000060U) /* USBHS or PLL clock divided by 10 */
#define RCC_CFG2_ADCOTGPLLPRES_DIV12  ((uint32_t)0x00000070U) /* USBHS or PLL clock divided by 12 */

#define RCC_CFG2_ADCOTGPLLSEL         ((uint32_t)0x00000080U) /* ADC clock source USBHS 240M or PLL selection */
#define RCC_CFG2_ADCOTGPLLEN          ((uint32_t)0x00000100U) /* ADC clock source USBHS 240M or PLL enable */

/* ADC1MPRES configuration */
#define RCC_CFG2_ADC1MPRES            ((uint32_t)0x0001F000U) /*ADC1MPRES[4:0]*/
#define RCC_CFG2_ADC1MPRES_0          ((uint32_t)0x00001000U) /*Bit0*/
#define RCC_CFG2_ADC1MPRES_1          ((uint32_t)0x00002000U) /*Bit1*/
#define RCC_CFG2_ADC1MPRES_2          ((uint32_t)0x00004000U) /*Bit2*/
#define RCC_CFG2_ADC1MPRES_3          ((uint32_t)0x00008000U) /*Bit3*/
#define RCC_CFG2_ADC1MPRES_4          ((uint32_t)0x00010000U) /*Bit4*/

#define RCC_CFG2_ADC1MPRES_DIV1       ((uint32_t)0x00000000U) /* ADC1M source clock is divided by 1 */
#define RCC_CFG2_ADC1MPRES_DIV2       ((uint32_t)0x00001000U) /* ADC1M source clock is divided by 2 */
#define RCC_CFG2_ADC1MPRES_DIV3       ((uint32_t)0x00002000U) /* ADC1M source clock is divided by 3 */
#define RCC_CFG2_ADC1MPRES_DIV4       ((uint32_t)0x00003000U) /* ADC1M source clock is divided by 4 */
#define RCC_CFG2_ADC1MPRES_DIV5       ((uint32_t)0x00004000U) /* ADC1M source clock is divided by 5 */
#define RCC_CFG2_ADC1MPRES_DIV6       ((uint32_t)0x00005000U) /* ADC1M source clock is divided by 6 */
#define RCC_CFG2_ADC1MPRES_DIV7       ((uint32_t)0x00006000U) /* ADC1M source clock is divided by 7 */
#define RCC_CFG2_ADC1MPRES_DIV8       ((uint32_t)0x00007000U) /* ADC1M source clock is divided by 8 */
#define RCC_CFG2_ADC1MPRES_DIV9       ((uint32_t)0x00008000U) /* ADC1M source clock is divided by 9 */
#define RCC_CFG2_ADC1MPRES_DIV10      ((uint32_t)0x00009000U) /* ADC1M source clock is divided by 10 */
#define RCC_CFG2_ADC1MPRES_DIV11      ((uint32_t)0x0000A000U) /* ADC1M source clock is divided by 11 */
#define RCC_CFG2_ADC1MPRES_DIV12      ((uint32_t)0x0000B000U) /* ADC1M source clock is divided by 12 */
#define RCC_CFG2_ADC1MPRES_DIV13      ((uint32_t)0x0000C000U) /* ADC1M source clock is divided by 13 */
#define RCC_CFG2_ADC1MPRES_DIV14      ((uint32_t)0x0000D000U) /* ADC1M source clock is divided by 14 */
#define RCC_CFG2_ADC1MPRES_DIV15      ((uint32_t)0x0000E000U) /* ADC1M source clock is divided by 15 */
#define RCC_CFG2_ADC1MPRES_DIV16      ((uint32_t)0x0000F000U) /* ADC1M source clock is divided by 16 */
#define RCC_CFG2_ADC1MPRES_DIV17      ((uint32_t)0x00010000U) /* ADC1M source clock is divided by 17 */
#define RCC_CFG2_ADC1MPRES_DIV18      ((uint32_t)0x00011000U) /* ADC1M source clock is divided by 18 */
#define RCC_CFG2_ADC1MPRES_DIV19      ((uint32_t)0x00012000U) /* ADC1M source clock is divided by 19 */
#define RCC_CFG2_ADC1MPRES_DIV20      ((uint32_t)0x00013000U) /* ADC1M source clock is divided by 20 */
#define RCC_CFG2_ADC1MPRES_DIV21      ((uint32_t)0x00014000U) /* ADC1M source clock is divided by 21 */
#define RCC_CFG2_ADC1MPRES_DIV22      ((uint32_t)0x00015000U) /* ADC1M source clock is divided by 22 */
#define RCC_CFG2_ADC1MPRES_DIV23      ((uint32_t)0x00016000U) /* ADC1M source clock is divided by 23 */
#define RCC_CFG2_ADC1MPRES_DIV24      ((uint32_t)0x00017000U) /* ADC1M source clock is divided by 24 */
#define RCC_CFG2_ADC1MPRES_DIV25      ((uint32_t)0x00018000U) /* ADC1M source clock is divided by 25 */
#define RCC_CFG2_ADC1MPRES_DIV26      ((uint32_t)0x00019000U) /* ADC1M source clock is divided by 26 */
#define RCC_CFG2_ADC1MPRES_DIV27      ((uint32_t)0x0001A000U) /* ADC1M source clock is divided by 27 */
#define RCC_CFG2_ADC1MPRES_DIV28      ((uint32_t)0x0001B000U) /* ADC1M source clock is divided by 28 */
#define RCC_CFG2_ADC1MPRES_DIV29      ((uint32_t)0x0001C000U) /* ADC1M source clock is divided by 29 */
#define RCC_CFG2_ADC1MPRES_DIV30      ((uint32_t)0x0001D000U) /* ADC1M source clock is divided by 30 */
#define RCC_CFG2_ADC1MPRES_DIV31      ((uint32_t)0x0001E000U) /* ADC1M source clock is divided by 31 */
#define RCC_CFG2_ADC1MPRES_DIV32      ((uint32_t)0x0001F000U) /* ADC1M source clock is divided by 32 */

/* ADC1MSEL configuration */
#define RCC_CFG2_ADC1MSEL ((uint32_t)0x00080000U) /* ADC1M clock source select */

#define RCC_CFG2_ADC1MSEL_HSI ((uint32_t)0x00000000U) /* HSI clock selected as ADC1M input clock */
#define RCC_CFG2_ADC1MSEL_HSE ((uint32_t)0x00080000U) /* HSE clock selected as ADC1M input clock */

/* RNGCPRES configuration */
#define RCC_CFG2_RNGCPRES         ((uint32_t)0x01F00000U) /*RNGCPRES[4:0] */
#define RCC_CFG2_RNGCPRES_0       ((uint32_t)0x00100000U) /*Bit0*/
#define RCC_CFG2_RNGCPRES_1       ((uint32_t)0x00200000U) /*Bit1*/
#define RCC_CFG2_RNGCPRES_2       ((uint32_t)0x00400000U) /*Bit2*/
#define RCC_CFG2_RNGCPRES_3       ((uint32_t)0x00800000U) /*Bit3*/
#define RCC_CFG2_RNGCPRES_4       ((uint32_t)0x01000000U) /*Bit4*/

#define RCC_CFG2_RNGCPRES_DIV1    ((uint32_t)0x00000000U) /* SYSCLK source clock is divided by 1 */
#define RCC_CFG2_RNGCPRES_DIV2    ((uint32_t)0x00100000U) /* SYSCLK source clock is divided by 2 */
#define RCC_CFG2_RNGCPRES_DIV3    ((uint32_t)0x00200000U) /* SYSCLK source clock is divided by 3 */
#define RCC_CFG2_RNGCPRES_DIV4    ((uint32_t)0x00300000U) /* SYSCLK source clock is divided by 4 */
#define RCC_CFG2_RNGCPRES_DIV5    ((uint32_t)0x00400000U) /* SYSCLK source clock is divided by 5 */
#define RCC_CFG2_RNGCPRES_DIV6    ((uint32_t)0x00500000U) /* SYSCLK source clock is divided by 6 */
#define RCC_CFG2_RNGCPRES_DIV7    ((uint32_t)0x00600000U) /* SYSCLK source clock is divided by 7 */
#define RCC_CFG2_RNGCPRES_DIV8    ((uint32_t)0x00700000U) /* SYSCLK source clock is divided by 8 */
#define RCC_CFG2_RNGCPRES_DIV9    ((uint32_t)0x00800000U) /* SYSCLK source clock is divided by 9 */
#define RCC_CFG2_RNGCPRES_DIV10   ((uint32_t)0x00900000U) /* SYSCLK source clock is divided by 10 */
#define RCC_CFG2_RNGCPRES_DIV11   ((uint32_t)0x00A00000U) /* SYSCLK source clock is divided by 11 */
#define RCC_CFG2_RNGCPRES_DIV12   ((uint32_t)0x00B00000U) /* SYSCLK source clock is divided by 12 */
#define RCC_CFG2_RNGCPRES_DIV13   ((uint32_t)0x00C00000U) /* SYSCLK source clock is divided by 13 */
#define RCC_CFG2_RNGCPRES_DIV14   ((uint32_t)0x00D00000U) /* SYSCLK source clock is divided by 14 */
#define RCC_CFG2_RNGCPRES_DIV15   ((uint32_t)0x00E00000U) /* SYSCLK source clock is divided by 15 */
#define RCC_CFG2_RNGCPRES_DIV16   ((uint32_t)0x00F00000U) /* SYSCLK source clock is divided by 16 */
#define RCC_CFG2_RNGCPRES_DIV17   ((uint32_t)0x01000000U) /* SYSCLK source clock is divided by 17 */
#define RCC_CFG2_RNGCPRES_DIV18   ((uint32_t)0x01100000U) /* SYSCLK source clock is divided by 18 */
#define RCC_CFG2_RNGCPRES_DIV19   ((uint32_t)0x01200000U) /* SYSCLK source clock is divided by 19 */
#define RCC_CFG2_RNGCPRES_DIV20   ((uint32_t)0x01300000U) /* SYSCLK source clock is divided by 20 */
#define RCC_CFG2_RNGCPRES_DIV21   ((uint32_t)0x01400000U) /* SYSCLK source clock is divided by 21 */
#define RCC_CFG2_RNGCPRES_DIV22   ((uint32_t)0x01500000U) /* SYSCLK source clock is divided by 22 */
#define RCC_CFG2_RNGCPRES_DIV23   ((uint32_t)0x01600000U) /* SYSCLK source clock is divided by 23 */
#define RCC_CFG2_RNGCPRES_DIV24   ((uint32_t)0x01700000U) /* SYSCLK source clock is divided by 24 */
#define RCC_CFG2_RNGCPRES_DIV25   ((uint32_t)0x01800000U) /* SYSCLK source clock is divided by 25 */
#define RCC_CFG2_RNGCPRES_DIV26   ((uint32_t)0x01900000U) /* SYSCLK source clock is divided by 26 */
#define RCC_CFG2_RNGCPRES_DIV27   ((uint32_t)0x01A00000U) /* SYSCLK source clock is divided by 27 */
#define RCC_CFG2_RNGCPRES_DIV28   ((uint32_t)0x01B00000U) /* SYSCLK source clock is divided by 28 */
#define RCC_CFG2_RNGCPRES_DIV29   ((uint32_t)0x01C00000U) /* SYSCLK source clock is divided by 29 */
#define RCC_CFG2_RNGCPRES_DIV30   ((uint32_t)0x01D00000U) /* SYSCLK source clock is divided by 30 */
#define RCC_CFG2_RNGCPRES_DIV31   ((uint32_t)0x01E00000U) /* SYSCLK source clock is divided by 31 */
#define RCC_CFG2_RNGCPRES_DIV32   ((uint32_t)0x01F00000U) /* SYSCLK source clock is divided by 32 */

#define RCC_CFG2_HCLKPRES             ((uint32_t)0x04000000U)     /* SAC/SDIO/USBHS/ETH access clock HCLK prescaler */
#define RCC_CFG2_GTIMCLKSEL           ((uint32_t)0x08000000U)     /* GTIM8/9/10 clock source selection */
#define RCC_CFG2_ATIMCLKSEL           ((uint32_t)0x10000000U)     /* ATIM1/2/3 clock source selection */ 


/** Bit definition for RCC_CFG3 register  **/
#define RCC_CFG3_BORRSTEN             ((uint32_t)0x00000001U) /*BOR reset enable */
#define RCC_CFG3_TRNG1MSEL            ((uint32_t)0x00000002U) /*TRNG 1M clock select */
#define RCC_CFG3_TRNG1MEN             ((uint32_t)0x00000004U) /*TRNG 1M Clock Enable*/

/* TRNG1MPRES configuration */
#define RCC_CFG3_TRNG1MPRES           ((uint32_t)0x000001E0U) /*TRNG1MPRES[3:0] */
#define RCC_CFG3_TRNG1MPRES_0         ((uint32_t)0x00000020U) /*Bit0*/
#define RCC_CFG3_TRNG1MPRES_1         ((uint32_t)0x00000040U) /*Bit1*/
#define RCC_CFG3_TRNG1MPRES_2         ((uint32_t)0x00000080U) /*Bit2*/
#define RCC_CFG3_TRNG1MPRES_3         ((uint32_t)0x00000100U) /*Bit3*/

#define RCC_CFG3_TRNG1MPRES_DIV2       ((uint32_t)0x00000000U) /* TRNG 1M clock source 2  divisions */
#define RCC_CFG3_TRNG1MPRES_DIV4       ((uint32_t)0x00000020U) /* TRNG 1M clock source 4  divisions */
#define RCC_CFG3_TRNG1MPRES_DIV6       ((uint32_t)0x00000040U) /* TRNG 1M clock source 6  divisions */
#define RCC_CFG3_TRNG1MPRES_DIV8       ((uint32_t)0x00000060U) /* TRNG 1M clock source 8  divisions */
#define RCC_CFG3_TRNG1MPRES_DIV10      ((uint32_t)0x00000080U) /* TRNG 1M clock source 10 divisions */
#define RCC_CFG3_TRNG1MPRES_DIV12      ((uint32_t)0x000000A0U) /* TRNG 1M clock source 12 divisions */
#define RCC_CFG3_TRNG1MPRES_DIV14      ((uint32_t)0x000000C0U) /* TRNG 1M clock source 14 divisions */
#define RCC_CFG3_TRNG1MPRES_DIV16      ((uint32_t)0x000000E0U) /* TRNG 1M clock source 16 divisions */
#define RCC_CFG3_TRNG1MPRES_DIV18      ((uint32_t)0x00000100U) /* TRNG 1M clock source 18 divisions */
#define RCC_CFG3_TRNG1MPRES_DIV20      ((uint32_t)0x00000120U) /* TRNG 1M clock source 20 divisions */
#define RCC_CFG3_TRNG1MPRES_DIV22      ((uint32_t)0x00000140U) /* TRNG 1M clock source 22 divisions */
#define RCC_CFG3_TRNG1MPRES_DIV24      ((uint32_t)0x00000160U) /* TRNG 1M clock source 24 divisions */
#define RCC_CFG3_TRNG1MPRES_DIV26      ((uint32_t)0x00000180U) /* TRNG 1M clock source 26 divisions */
#define RCC_CFG3_TRNG1MPRES_DIV28      ((uint32_t)0x000001A0U) /* TRNG 1M clock source 28 divisions */
#define RCC_CFG3_TRNG1MPRES_DIV30      ((uint32_t)0x000001C0U) /* TRNG 1M clock source 30 divisions */
#define RCC_CFG3_TRNG1MPRES_DIV32      ((uint32_t)0x000001E0U) /* TRNG 1M clock source 32 divisions */

#define RCC_CFG3_USBFSTM               ((uint32_t)0x00000200U) /*USBFS48M Timing Mode Selection*/

/* USBFSSEL configuration */
#define RCC_CFG3_USBFSSEL              ((uint32_t)0x00000C00U) /*USBFSSEL[1:0] */
#define RCC_CFG3_USBFSSEL_0            ((uint32_t)0x00000400U) /*Bit0*/
#define RCC_CFG3_USBFSSEL_1            ((uint32_t)0x00000800U) /*Bit1*/

#define RCC_CFG3_USBFSSEL_UCDR         ((uint32_t)0x00000000U) /* UCDR clock as USBFS clock source */
#define RCC_CFG3_USBFSSEL_PLL          ((uint32_t)0x00000400U) /* PLL clock as USBFS clock source */
#define RCC_CFG3_USBFSSEL_USBHS48M    ((uint32_t)0x00000800U) /* USBHS48M clock as USBFS clock source */

#define RCC_CFG3_RPINTF                ((uint32_t)0x00001000U) /*Row programming interrupt flag */
#define RCC_CFG3_RPINTEN               ((uint32_t)0x00002000U) /*Row programming interrupt flag enable*/
#define RCC_CFG3_RPDMAEN               ((uint32_t)0x00004000U) /*DMA access to Flash privilege enable during Row programming */
#define RCC_CFG3_USBPLLSEL             ((uint32_t)0x00008000U) /*USB PLL Divided Clock Source Selection */

/* USBPLLPRES configuration */
#define RCC_CFG3_USBPLLPRES            ((uint32_t)0x000F0000U) /*USBPLLPRES[3:0]*/
#define RCC_CFG3_USBPLLPRES_0          ((uint32_t)0x00010000U) /*Bit0*/
#define RCC_CFG3_USBPLLPRES_1          ((uint32_t)0x00020000U) /*Bit1*/
#define RCC_CFG3_USBPLLPRES_2          ((uint32_t)0x00040000U) /*Bit2*/
#define RCC_CFG3_USBPLLPRES_3          ((uint32_t)0x00080000U) /*Bit3*/

#define RCC_CFG3_USBPLLPRES_DIV1       ((uint32_t)0x00010000U) /* PLL or SHRTPLL clock divided by 1 */
#define RCC_CFG3_USBPLLPRES_DIV2       ((uint32_t)0x00020000U) /* PLL or SHRTPLL clock divided by 2 */
#define RCC_CFG3_USBPLLPRES_DIV3       ((uint32_t)0x00030000U) /* PLL or SHRTPLL clock divided by 3 */
#define RCC_CFG3_USBPLLPRES_DIV4       ((uint32_t)0x00040000U) /* PLL or SHRTPLL clock divided by 4 */
#define RCC_CFG3_USBPLLPRES_DIV5       ((uint32_t)0x00050000U) /* PLL or SHRTPLL clock divided by 5 */
#define RCC_CFG3_USBPLLPRES_DIV6       ((uint32_t)0x00060000U) /* PLL or SHRTPLL clock divided by 6 */
#define RCC_CFG3_USBPLLPRES_DIV7       ((uint32_t)0x00070000U) /* PLL or SHRTPLL clock divided by 7 */
#define RCC_CFG3_USBPLLPRES_DIV8       ((uint32_t)0x00080000U) /* PLL or SHRTPLL clock divided by 8 */
#define RCC_CFG3_USBPLLPRES_DIV9       ((uint32_t)0x00090000U) /* PLL or SHRTPLL clock divided by 9 */
#define RCC_CFG3_USBPLLPRES_DIV10      ((uint32_t)0x000A0000U) /* PLL or SHRTPLL clock divided by 10 */
#define RCC_CFG3_USBPLLPRES_DIV11      ((uint32_t)0x000B0000U) /* PLL or SHRTPLL clock divided by 11 */
#define RCC_CFG3_USBPLLPRES_DIV12      ((uint32_t)0x000C0000U) /* PLL or SHRTPLL clock divided by 12 */
#define RCC_CFG3_USBPLLPRES_DIV13      ((uint32_t)0x000D0000U) /* PLL or SHRTPLL clock divided by 13 */
#define RCC_CFG3_USBPLLPRES_DIV14      ((uint32_t)0x000E0000U) /* PLL or SHRTPLL clock divided by 14 */
#define RCC_CFG3_USBPLLPRES_DIV15      ((uint32_t)0x000F0000U) /* PLL or SHRTPLL clock divided by 15 */

/* TRACEPRES configuration */
#define RCC_CFG3_TRACEPRES             ((uint32_t)0x00300000U) /*TRACEPRES[1:0]*/
#define RCC_CFG3_TRACEPRES_0           ((uint32_t)0x00100000U) /*Bit0*/
#define RCC_CFG3_TRACEPRES_1           ((uint32_t)0x00200000U) /*Bit1*/

#define RCC_CFG3_TRACEPRES_DIV2       ((uint32_t)0x00000000U) /* HCLK divided by 2 */
#define RCC_CFG3_TRACEPRES_DIV4       ((uint32_t)0x00100000U) /* HCLK divided by 4 */
#define RCC_CFG3_TRACEPRES_DIV8       ((uint32_t)0x00200000U) /* HCLK divided by 8 */
#define RCC_CFG3_TRACEPRES_DIV1       ((uint32_t)0x00300000U) /* HCLK divided by 1 */

/* FDCANSEL configuration */
#define RCC_CFG3_FDCANSEL                ((uint32_t)0x00C00000U) /*FDCANSEL[1:0]*/
#define RCC_CFG3_FDCANSEL_0              ((uint32_t)0x00400000U) /*Bit0*/
#define RCC_CFG3_FDCANSEL_1              ((uint32_t)0x00800000U) /*Bit1*/

#define RCC_CFG3_FDCANSEL_PLL            ((uint32_t)0x00000000U) /* Select PLL division as input clock */
#define RCC_CFG3_FDCANSEL_SHRTPLL        ((uint32_t)0x00400000U) /* Select SHRTPLL division as input clock */
#define RCC_CFG3_FDCANSEL_HSE            ((uint32_t)0x00800000U) /* Select HSE division as input clock */

/* I2S2SEL configuration */
#define RCC_CFG3_I2S2SEL               ((uint32_t)0x03000000U) /*I2S2SEL[1:0]*/
#define RCC_CFG3_I2S2SEL_0             ((uint32_t)0x01000000U) /*Bit0*/
#define RCC_CFG3_I2S2SEL_1             ((uint32_t)0x02000000U) /*Bit1*/

#define RCC_CFG3_I2S2SEL_SYSCLK         ((uint32_t)0x00000000U)    /* Select SYSCLK division as input clock */
#define RCC_CFG3_I2S2SEL_SHRTPLL        ((uint32_t)0x01000000U)    /* Select SHRTPLL division as input clock */
#define RCC_CFG3_I2S2SEL_CLKIN          ((uint32_t)0x02000000U)    /* Select I2S_CLKIN pin division as input clock */
#define RCC_CFG3_I2S2SEL_HSI            ((uint32_t)0x03000000U)    /* Select HSI division as input clock */

/* I2S3SEL configuration */
#define RCC_CFG3_I2S3SEL               ((uint32_t)0x0C000000U) /*I2S3SEL[1:0] */
#define RCC_CFG3_I2S3SEL_0             ((uint32_t)0x04000000U) /*Bit0*/
#define RCC_CFG3_I2S3SEL_1             ((uint32_t)0x08000000U) /*Bit1*/

#define RCC_CFG3_I2S3SEL_SYSCLK         ((uint32_t)0x00000000U)    /* Select SYSCLK division as input clock */
#define RCC_CFG3_I2S3SEL_SHRTPLL        ((uint32_t)0x04000000U)    /* Select SHRTPLL division as input clock */
#define RCC_CFG3_I2S3SEL_CLKIN          ((uint32_t)0x08000000U)    /* Select I2S_CLKIN pin division as input clock */
#define RCC_CFG3_I2S3SEL_HSI            ((uint32_t)0x0C000000U)    /* Select HSI division as input clock */

/* FDCANPLLPRES configuration */
#define RCC_CFG3_FDCANPLLPRES            ((uint32_t)0xF0000000U) /*FDCANPLLPRES[3:0]*/
#define RCC_CFG3_FDCANPLLPRES_0          ((uint32_t)0x10000000U) /*Bit0*/
#define RCC_CFG3_FDCANPLLPRES_1          ((uint32_t)0x20000000U) /*Bit1*/
#define RCC_CFG3_FDCANPLLPRES_2          ((uint32_t)0x40000000U) /*Bit2*/
#define RCC_CFG3_FDCANPLLPRES_3          ((uint32_t)0x80000000U) /*Bit3*/

#define RCC_CFG3_FDCANPLLPRES_DIV1       ((uint32_t)0x10000000U) /* PLL or SHRTPLL clock divided by 1 */
#define RCC_CFG3_FDCANPLLPRES_DIV2       ((uint32_t)0x20000000U) /* PLL or SHRTPLL clock divided by 2 */
#define RCC_CFG3_FDCANPLLPRES_DIV3       ((uint32_t)0x30000000U) /* PLL or SHRTPLL clock divided by 3 */
#define RCC_CFG3_FDCANPLLPRES_DIV4       ((uint32_t)0x40000000U) /* PLL or SHRTPLL clock divided by 4 */
#define RCC_CFG3_FDCANPLLPRES_DIV5       ((uint32_t)0x50000000U) /* PLL or SHRTPLL clock divided by 5 */
#define RCC_CFG3_FDCANPLLPRES_DIV6       ((uint32_t)0x60000000U) /* PLL or SHRTPLL clock divided by 6 */
#define RCC_CFG3_FDCANPLLPRES_DIV7       ((uint32_t)0x70000000U) /* PLL or SHRTPLL clock divided by 7 */
#define RCC_CFG3_FDCANPLLPRES_DIV8       ((uint32_t)0x80000000U) /* PLL or SHRTPLL clock divided by 8 */
#define RCC_CFG3_FDCANPLLPRES_DIV9       ((uint32_t)0x90000000U) /* PLL or SHRTPLL clock divided by 9 */
#define RCC_CFG3_FDCANPLLPRES_DIV10      ((uint32_t)0xA0000000U) /* PLL or SHRTPLL clock divided by 10 */
#define RCC_CFG3_FDCANPLLPRES_DIV11      ((uint32_t)0xB0000000U) /* PLL or SHRTPLL clock divided by 11 */
#define RCC_CFG3_FDCANPLLPRES_DIV12      ((uint32_t)0xC0000000U) /* PLL or SHRTPLL clock divided by 12 */
#define RCC_CFG3_FDCANPLLPRES_DIV13      ((uint32_t)0xD0000000U) /* PLL or SHRTPLL clock divided by 13 */
#define RCC_CFG3_FDCANPLLPRES_DIV14      ((uint32_t)0xE0000000U) /* PLL or SHRTPLL clock divided by 14 */
#define RCC_CFG3_FDCANPLLPRES_DIV15      ((uint32_t)0xF0000000U) /* PLL or SHRTPLL clock divided by 15 */

/** Bit definition for RCC_CLKINT register  **/
#define RCC_CLKINT_HSICSSIF            ((uint32_t)0x20000000U) /* HSI CSS Interrupt flag */ 
#define RCC_CLKINT_HSICSSF             ((uint32_t)0x10000000U) /* HSI CSS flag */ 
#define RCC_CLKINT_HSECSSF             ((uint32_t)0x08000000U) /* HSE CSS flag */
#define RCC_CLKINT_LSECSSF             ((uint32_t)0x04000000U) /* LSE CSS flag */
#define RCC_CLKINT_HSICSSIEN           ((uint32_t)0x02000000U) /* HSI CSS Interrupt Enable */
#define RCC_CLKINT_HSICSSICLR          ((uint32_t)0x01000000U) /* HSI CSS Interrupt Clear */ 

#define RCC_CLKINT_LSECSSICLR          ((uint32_t)0x00800000U) /* LSE CSS Interrupt Clear */
#define RCC_CLKINT_BORICLR             ((uint32_t)0x00400000U) /* BOR Interrupt Clear */
#define RCC_CLKINT_LSERDICLR           ((uint32_t)0x00200000U) /* LSE Ready Interrupt Clear */
#define RCC_CLKINT_LSIRDICLR           ((uint32_t)0x00100000U) /* LSI Ready Interrupt Clear */
#define RCC_CLKINT_HSECSSICLR          ((uint32_t)0x00080000U) /* HSE CSS Interrupt Clear */
#define RCC_CLKINT_HSERDICLR           ((uint32_t)0x00040000U) /* HSE Ready Interrupt Clear */
#define RCC_CLKINT_HSIRDICLR           ((uint32_t)0x00020000U) /* HSI Ready Interrupt Clear */
#define RCC_CLKINT_PLLRDICLR           ((uint32_t)0x00010000U) /* PLL Ready Interrupt Clear */

#define RCC_CLKINT_LSECSSIEN           ((uint32_t)0x00008000U) /* LSE CSS Interrupt Enable */
#define RCC_CLKINT_BORIEN              ((uint32_t)0x00004000U) /* BOR Interrupt Enable */
#define RCC_CLKINT_LSERDIEN            ((uint32_t)0x00002000U) /* LSE Ready Interrupt Enable */
#define RCC_CLKINT_LSIRDIEN            ((uint32_t)0x00001000U) /* LSI Ready Interrupt Enable */
#define RCC_CLKINT_HSECSSIEN           ((uint32_t)0x00000800U) /* HSE CSS Interrupt Enable */
#define RCC_CLKINT_HSERDIEN            ((uint32_t)0x00000400U) /* HSE Ready Interrupt Enable */
#define RCC_CLKINT_HSIRDIEN            ((uint32_t)0x00000200U) /* HSI Ready Interrupt Enable */
#define RCC_CLKINT_PLLRDIEN            ((uint32_t)0x00000100U) /* PLL Ready Interrupt Enable */

#define RCC_CLKINT_LSECSSIF            ((uint32_t)0x00000080U) /* LSE CSS Interrupt flag */
#define RCC_CLKINT_BORIF               ((uint32_t)0x00000040U) /* BOR Interrupt flag */
#define RCC_CLKINT_LSERDIF             ((uint32_t)0x00000020U) /* LSE Ready Interrupt flag */
#define RCC_CLKINT_LSIRDIF             ((uint32_t)0x00000010U) /* LSI Ready Interrupt flag */
#define RCC_CLKINT_HSECSSIF            ((uint32_t)0x00000008U) /* HSE CSS Interrupt flag */
#define RCC_CLKINT_HSERDIF             ((uint32_t)0x00000004U) /* HSE Ready Interrupt flag */
#define RCC_CLKINT_HSIRDIF             ((uint32_t)0x00000002U) /* HSI Ready Interrupt flag */
#define RCC_CLKINT_PLLRDIF             ((uint32_t)0x00000001U) /* PLL Ready Interrupt flag */

/** Bit definition for RCC_CTRLSTS register  **/
#define RCC_CTRLSTS_LPWRRSTF           ((uint32_t)0x80000000U) /* Low-Power reset flag */
#define RCC_CTRLSTS_WWDGRSTF           ((uint32_t)0x40000000U) /* Window watchdog reset flag */
#define RCC_CTRLSTS_IWDGRSTF           ((uint32_t)0x20000000U) /* Independent Watchdog reset flag */
#define RCC_CTRLSTS_SFTRSTF            ((uint32_t)0x10000000U) /* Software Reset flag */
#define RCC_CTRLSTS_PORRSTF            ((uint32_t)0x08000000U) /* POR/PDR reset flag */ 
#define RCC_CTRLSTS_PINRSTF            ((uint32_t)0x04000000U) /* PIN reset flag */ 
#define RCC_CTRLSTS_SMPURSTF           ((uint32_t)0x02000000U) /* SMPU reset flag */ 
#define RCC_CTRLSTS_RAMERSTF           ((uint32_t)0x00800000U) /* RAM reset flag */ 
#define RCC_CTRLSTS_BKPEMCF            ((uint32_t)0x00200000U) /* BKP_EMC reset flag */ 
#define RCC_CTRLSTS_MAINEMCF           ((uint32_t)0x00100000U) /* MAIN_EMC reset flag */
#define RCC_CTRLSTS_BORRSTF            ((uint32_t)0x00080000U) /* BOR reset flag */ 
#define RCC_CTRLSTS_RMRSTF             ((uint32_t)0x00000008U) /* Remove reset flag */ 
#define RCC_CTRLSTS_LSIRD              ((uint32_t)0x00000002U) /* Internal Low Speed oscillator Ready */ 
#define RCC_CTRLSTS_LSIEN              ((uint32_t)0x00000001U) /* Internal Low Speed oscillator enable */ 

/** Bit definition for RCC_AHBPCLKEN register  **/
#define RCC_AHBPCLKEN_SHRTIMEN         ((uint32_t)0x00040000U) /* SHRTIM clock enabled*/ 
#define RCC_AHBPCLKEN_ATIM3EN          ((uint32_t)0x00020000U) /* ATIM3 clock enabled*/ 
#define RCC_AHBPCLKEN_ATIM2EN          ((uint32_t)0x00010000U) /* ATIM2 clock enabled*/ 
#define RCC_AHBPCLKEN_ATIM1EN          ((uint32_t)0x00008000U) /* ATIM1 clock enabled*/ 
#define RCC_AHBPCLKEN_DVPEN            ((uint32_t)0x00004000U) /* DVP clock enabled*/ 
#define RCC_AHBPCLKEN_CORDICEN         ((uint32_t)0x00002000U) /* CORDIC clock enabled*/ 
#define RCC_AHBPCLKEN_FMACEN           ((uint32_t)0x00001000U) /* FMAC clock enabled*/ 
#define RCC_AHBPCLKEN_USBHSEN         ((uint32_t)0x00000800U) /* USBHS clock enabled*/ 
#define RCC_AHBPCLKEN_ETHEN            ((uint32_t)0x00000400U) /* ETH clock enabled*/ 
#define RCC_AHBPCLKEN_CRCEN            ((uint32_t)0x00000200U) /* CRC clock enabled*/
#define RCC_AHBPCLKEN_DMA2EN           ((uint32_t)0x00000100U) /* DMA2 clock enabled*/
#define RCC_AHBPCLKEN_DMA1EN           ((uint32_t)0x00000080U) /* DMA1 clock enabled*/
#define RCC_AHBPCLKEN_SDIOEN           ((uint32_t)0x00000040U) /* SDIO clock enabled*/
#define RCC_AHBPCLKEN_XSPIEN           ((uint32_t)0x00000020U) /* XSPI clock enabled*/
#define RCC_AHBPCLKEN_RNGCEN           ((uint32_t)0x00000010U) /* RNGC clock enabled*/
#define RCC_AHBPCLKEN_BKPSRAMEN        ((uint32_t)0x00000008U) /* BKPSRAM clock enabled*/
#define RCC_AHBPCLKEN_FEMCEN           ((uint32_t)0x00000004U) /* FEMC clock enabled*/
#define RCC_AHBPCLKEN_FLITFEN          ((uint32_t)0x00000002U) /* FLITF clock enabled*/
#define RCC_AHBPCLKEN_SRAMEN           ((uint32_t)0x00000001U) /* SRAM clock enabled*/

/** Bit definition for RCC_APB1PCLKEN register  **/
#define RCC_APB1PCLKEN_DAC34EN          ((uint32_t)0x80000000U) /* DAC34 clock enabled*/ 
#define RCC_APB1PCLKEN_DAC12EN          ((uint32_t)0x40000000U) /* DAC12 clock enabled*/ 
#define RCC_APB1PCLKEN_WWDGEN           ((uint32_t)0x20000000U) /* WWDG clock enabled*/ 
#define RCC_APB1PCLKEN_I2C4EN           ((uint32_t)0x10000000U) /* I2C4 clock enabled*/ 
#define RCC_APB1PCLKEN_I2C3EN           ((uint32_t)0x08000000U) /* I2C3 clock enabled*/ 
#define RCC_APB1PCLKEN_FDCAN3OFFEN      ((uint32_t)0x04000000U) /* FDCAN3 OFF request enabled*/ 
#define RCC_APB1PCLKEN_FDCAN2OFFEN      ((uint32_t)0x02000000U) /* FDCAN2 OFF request enabled*/ 
#define RCC_APB1PCLKEN_FDCAN1OFFEN      ((uint32_t)0x01000000U) /* FDCAN1 OFF request enabled*/ 
#define RCC_APB1PCLKEN_BTIM2EN          ((uint32_t)0x00800000U) /* BTIM2 clock enabled*/ 
#define RCC_APB1PCLKEN_BTIM1EN          ((uint32_t)0x00400000U) /* BTIM1 clock enabled*/ 
#define RCC_APB1PCLKEN_FDCAN3EN         ((uint32_t)0x00200000U) /* FDCAN3 clock enabled*/ 
#define RCC_APB1PCLKEN_FDCAN2EN         ((uint32_t)0x00100000U) /* FDCAN2 clock enabled*/ 
#define RCC_APB1PCLKEN_FDCAN1EN         ((uint32_t)0x00080000U) /* FDCAN1 clock enabled*/ 
#define RCC_APB1PCLKEN_USBFSEN          ((uint32_t)0x00040000U) /* USBFS clock enabled*/ 
#define RCC_APB1PCLKEN_UCDREN           ((uint32_t)0x00020000U) /* UCDR clock enabled*/ 
#define RCC_APB1PCLKEN_GTIM7EN          ((uint32_t)0x00010000U) /* GTIM7 clock enabled*/ 
#define RCC_APB1PCLKEN_GTIM6EN          ((uint32_t)0x00008000U) /* GTIM6 clock enabled*/ 
#define RCC_APB1PCLKEN_GTIM5EN          ((uint32_t)0x00004000U) /* GTIM5 clock enabled*/ 
#define RCC_APB1PCLKEN_GTIM4EN          ((uint32_t)0x00002000U) /* GTIM4 clock enabled*/ 
#define RCC_APB1PCLKEN_GTIM3EN          ((uint32_t)0x00001000U) /* GTIM3 clock enabled*/ 
#define RCC_APB1PCLKEN_GTIM2EN          ((uint32_t)0x00000800U) /* GTIM2 clock enabled*/ 
#define RCC_APB1PCLKEN_GTIM1EN          ((uint32_t)0x00000400U) /* GTIM1 clock enabled*/ 
#define RCC_APB1PCLKEN_SPI3EN           ((uint32_t)0x00000200U) /* SPI3 clock enabled*/
#define RCC_APB1PCLKEN_SPI2EN           ((uint32_t)0x00000100U) /* SPI2 clock enabled*/
#define RCC_APB1PCLKEN_I2C2EN           ((uint32_t)0x00000080U) /* I2C2 clock enabled*/
#define RCC_APB1PCLKEN_I2C1EN           ((uint32_t)0x00000040U) /* I2C1 clock enabled*/
#define RCC_APB1PCLKEN_UART5EN          ((uint32_t)0x00000020U) /* UART5 clock enabled*/
#define RCC_APB1PCLKEN_UART8EN          ((uint32_t)0x00000010U) /* UART8 clock enabled*/
#define RCC_APB1PCLKEN_USART3EN         ((uint32_t)0x00000008U) /* USART3 clock enabled*/
#define RCC_APB1PCLKEN_USART2EN         ((uint32_t)0x00000004U) /* USART2 clock enabled*/
#define RCC_APB1PCLKEN_BKPEN            ((uint32_t)0x00000002U) /* BKP clock enabled*/
#define RCC_APB1PCLKEN_PWREN            ((uint32_t)0x00000001U) /* PWR clock enabled*/

/** Bit definition for RCC_APB2PCLKEN register  **/
#define RCC_APB2PCLKEN_USART4EN         ((uint32_t)0x00004000U) /* USART4 clock enabled*/ 
#define RCC_APB2PCLKEN_COMPFILTEN       ((uint32_t)0x00002000U) /* COMP FILT clock enabled*/ 
#define RCC_APB2PCLKEN_PGAEN            ((uint32_t)0x00001000U) /* PGA clock enabled*/ 
#define RCC_APB2PCLKEN_COMPEN           ((uint32_t)0x00000800U) /* COMP clock enabled*/ 
#define RCC_APB2PCLKEN_GTIM10EN         ((uint32_t)0x00000400U) /* GTIM10 clock enabled*/ 
#define RCC_APB2PCLKEN_GTIM9EN          ((uint32_t)0x00000200U) /* GTIM9 clock enabled*/
#define RCC_APB2PCLKEN_GTIM8EN          ((uint32_t)0x00000100U) /* GTIM8 clock enabled*/
#define RCC_APB2PCLKEN_UART7EN          ((uint32_t)0x00000080U) /* UART7 clock enabled*/
#define RCC_APB2PCLKEN_UART6EN          ((uint32_t)0x00000040U) /* UART6 clock enabled*/
#define RCC_APB2PCLKEN_USART1EN         ((uint32_t)0x00000020U) /* USART1 clock enabled*/
#define RCC_APB2PCLKEN_SPI1EN           ((uint32_t)0x00000010U) /* SPI1 clock enabled*/
#define RCC_APB2PCLKEN_SPI4EN           ((uint32_t)0x00000008U) /* SPI4 clock enabled*/
#define RCC_APB2PCLKEN_SPI5EN           ((uint32_t)0x00000004U) /* SPI5 clock enabled*/
#define RCC_APB2PCLKEN_SPI6EN           ((uint32_t)0x00000002U) /* SPI6 clock enabled*/
#define RCC_APB2PCLKEN_AFIOEN           ((uint32_t)0x00000001U) /* AFIO clock enabled*/

/** Bit definition for RCC_AHBPRST register  **/
#define RCC_AHBPRST_ETHRST              ((uint32_t)0x80000000U) /* ETH reset */ 
#define RCC_AHBPRST_USBHSRST           ((uint32_t)0x40000000U) /* USBHS reset */ 
#define RCC_AHBPRST_FMACRST             ((uint32_t)0x20000000U) /* FMAC reset */ 
#define RCC_AHBPRST_CORDICRST           ((uint32_t)0x10000000U) /* CORDIC reset */ 
#define RCC_AHBPRST_ATIM3RST            ((uint32_t)0x08000000U) /* ATIM3 reset */ 
#define RCC_AHBPRST_ATIM2RST            ((uint32_t)0x04000000U) /* ATIM2 reset */ 
#define RCC_AHBPRST_ATIM1RST            ((uint32_t)0x02000000U) /* ATIM1 reset */ 
#define RCC_AHBPRST_DVPRST              ((uint32_t)0x01000000U) /* DVP reset */ 
#define RCC_AHBPRST_DAC78RST            ((uint32_t)0x00800000U) /* DAC78 reset */ 
#define RCC_AHBPRST_DAC56RST            ((uint32_t)0x00400000U) /* DAC56 reset */ 
#define RCC_AHBPRST_ADC4RST             ((uint32_t)0x00200000U) /* ADC4 reset */ 
#define RCC_AHBPRST_ADC3RST             ((uint32_t)0x00100000U) /* ADC3 reset */ 
#define RCC_AHBPRST_ADC2RST             ((uint32_t)0x00080000U) /* ADC2 reset */ 
#define RCC_AHBPRST_ADC1RST             ((uint32_t)0x00040000U) /* ADC1 reset */ 
#define RCC_AHBPRST_IOPHRST             ((uint32_t)0x00020000U) /* IOPH reset */ 
#define RCC_AHBPRST_IOPGRST             ((uint32_t)0x00010000U) /* IOPG reset */ 
#define RCC_AHBPRST_IOPFRST             ((uint32_t)0x00008000U) /* IOPF reset */ 
#define RCC_AHBPRST_IOPERST             ((uint32_t)0x00004000U) /* IOPE reset */ 
#define RCC_AHBPRST_IOPDRST             ((uint32_t)0x00002000U) /* IOPD reset */ 
#define RCC_AHBPRST_IOPCRST             ((uint32_t)0x00001000U) /* IOPC reset */ 
#define RCC_AHBPRST_IOPBRST             ((uint32_t)0x00000800U) /* IOPB reset */ 
#define RCC_AHBPRST_IOPARST             ((uint32_t)0x00000400U) /* IOPA reset */ 
#define RCC_AHBPRST_FEMCRST             ((uint32_t)0x00000100U) /* FEMC reset */
#define RCC_AHBPRST_SDIORST             ((uint32_t)0x00000080U) /* SDIO reset */
#define RCC_AHBPRST_USBHSPHYRST        ((uint32_t)0x00000040U) /* USBHS POR reset */
#define RCC_AHBPRST_XSPIRST             ((uint32_t)0x00000020U) /* XSPI reset */
#define RCC_AHBPRST_RNGCRST             ((uint32_t)0x00000010U) /* RNGC reset */
#define RCC_AHBPRST_SACRST              ((uint32_t)0x00000008U) /* SAC reset */
#define RCC_AHBPRST_SHRTPLLPHARST       ((uint32_t)0x00000004U) /* SHRTPLL phase reset */
#define RCC_AHBPRST_SHRTPLLRST          ((uint32_t)0x00000002U) /* SHRTPLL reset */
#define RCC_AHBPRST_SHRTIMRST           ((uint32_t)0x00000001U) /* SHRTIM reset */

/** Bit definition for RCC_APB1PRST register  **/
#define RCC_APB1PRST_DAC34RST            ((uint32_t)0x80000000U) /* DAC34 reset */ 
#define RCC_APB1PRST_DAC12RST            ((uint32_t)0x40000000U) /* DAC12 reset */ 
#define RCC_APB1PRST_WWDGRST             ((uint32_t)0x20000000U) /* WWDG reset */ 
#define RCC_APB1PRST_I2C4RST             ((uint32_t)0x10000000U) /* I2C4 reset */ 
#define RCC_APB1PRST_I2C3RST             ((uint32_t)0x08000000U) /* I2C3 reset */ 
#define RCC_APB1PRST_BTIM2RST            ((uint32_t)0x00800000U) /* BTIM2 reset */ 
#define RCC_APB1PRST_BTIM1RST            ((uint32_t)0x00400000U) /* BTIM1 reset */ 
#define RCC_APB1PRST_FDCAN3RST           ((uint32_t)0x00200000U) /* FDCAN3 reset */ 
#define RCC_APB1PRST_FDCAN2RST           ((uint32_t)0x00100000U) /* FDCAN2 reset */ 
#define RCC_APB1PRST_FDCAN1RST           ((uint32_t)0x00080000U) /* FDCAN1 reset */ 
#define RCC_APB1PRST_USBFSRST            ((uint32_t)0x00040000U) /* USBFS reset */ 
#define RCC_APB1PRST_UCDRRST             ((uint32_t)0x00020000U) /* UCDR reset */ 
#define RCC_APB1PRST_GTIM7RST            ((uint32_t)0x00010000U) /* GTIM7 reset */ 
#define RCC_APB1PRST_GTIM6RST            ((uint32_t)0x00008000U) /* GTIM6 reset */ 
#define RCC_APB1PRST_GTIM5RST            ((uint32_t)0x00004000U) /* GTIM5 reset */ 
#define RCC_APB1PRST_GTIM4RST            ((uint32_t)0x00002000U) /* GTIM4 reset */ 
#define RCC_APB1PRST_GTIM3RST            ((uint32_t)0x00001000U) /* GTIM3 reset */ 
#define RCC_APB1PRST_GTIM2RST            ((uint32_t)0x00000800U) /* GTIM2 reset */ 
#define RCC_APB1PRST_GTIM1RST            ((uint32_t)0x00000400U) /* GTIM1 reset */ 
#define RCC_APB1PRST_SPI3RST             ((uint32_t)0x00000200U) /* SPI3 reset */
#define RCC_APB1PRST_SPI2RST             ((uint32_t)0x00000100U) /* SPI2 reset */
#define RCC_APB1PRST_I2C2RST             ((uint32_t)0x00000080U) /* I2C2 reset */
#define RCC_APB1PRST_I2C1RST             ((uint32_t)0x00000040U) /* I2C1 reset */
#define RCC_APB1PRST_UART5RST            ((uint32_t)0x00000020U) /* UART5 reset */
#define RCC_APB1PRST_UART8RST            ((uint32_t)0x00000010U) /* UART8 reset */
#define RCC_APB1PRST_USART3RST           ((uint32_t)0x00000008U) /* USART3 reset */
#define RCC_APB1PRST_USART2RST           ((uint32_t)0x00000004U) /* USART2 reset */
#define RCC_APB1PRST_BKPRST              ((uint32_t)0x00000002U) /* BKP reset */
#define RCC_APB1PRST_PWRRST              ((uint32_t)0x00000001U) /* PWR reset */

/** Bit definition for RCC_APB2PRST register  **/
#define RCC_APB2PRST_USART4RST           ((uint32_t)0x00004000U) /* USART4 reset */ 
#define RCC_APB2PRST_PGARST              ((uint32_t)0x00001000U) /* PGA reset */ 
#define RCC_APB2PRST_COMPRST             ((uint32_t)0x00000800U) /* COMP reset */ 
#define RCC_APB2PRST_GTIM10RST           ((uint32_t)0x00000400U) /* GTIM10 reset */ 
#define RCC_APB2PRST_GTIM9RST            ((uint32_t)0x00000200U) /* GTIM9 reset */
#define RCC_APB2PRST_GTIM8RST            ((uint32_t)0x00000100U) /* GTIM8 reset */
#define RCC_APB2PRST_UART7RST            ((uint32_t)0x00000080U) /* UART7 reset */
#define RCC_APB2PRST_UART6RST            ((uint32_t)0x00000040U) /* UART6 reset */
#define RCC_APB2PRST_USART1RST           ((uint32_t)0x00000020U) /* USART1 reset */
#define RCC_APB2PRST_SPI1RST             ((uint32_t)0x00000010U) /* SPI1 reset */
#define RCC_APB2PRST_SPI4RST             ((uint32_t)0x00000008U) /* SPI4 reset */
#define RCC_APB2PRST_SPI5RST             ((uint32_t)0x00000004U) /* SPI5 reset */
#define RCC_APB2PRST_SPI6RST             ((uint32_t)0x00000002U) /* SPI6 reset */
#define RCC_APB2PRST_AFIORST             ((uint32_t)0x00000001U) /* AFIO reset */

/** Bit definition for RCC_MCOCFG register  **/
/* MCO2 configuration */
#define RCC_MCOCFG_MCO2             ((uint32_t)0x000000F0U) /*MCO2[3:0]*/
#define RCC_MCOCFG_MCO2_0           ((uint32_t)0x00000010U) /*Bit0*/
#define RCC_MCOCFG_MCO2_1           ((uint32_t)0x00000020U) /*Bit1*/
#define RCC_MCOCFG_MCO2_2           ((uint32_t)0x00000040U) /*Bit2*/
#define RCC_MCOCFG_MCO2_3           ((uint32_t)0x00000080U) /*Bit3*/

#define  RCC_MCOCFG_MCO2_NOCLK      ((uint32_t)0x00000000U) /* No clock */ 
#define  RCC_MCOCFG_MCO2_SYSCLK     ((uint32_t)0x00000080U) /* System clock selected as MCO source */ 
#define  RCC_MCOCFG_MCO2_HSI        ((uint32_t)0x00000090U) /* HSI clock selected as MCO source */
#define  RCC_MCOCFG_MCO2_HSE        ((uint32_t)0x000000A0U) /* HSE clock selected as MCO source  */ 
#define  RCC_MCOCFG_MCO2_PLL        ((uint32_t)0x000000B0U) /* PLL clock divided selected as MCO source */
#define  RCC_MCOCFG_MCO2_LSI        ((uint32_t)0x000000C0U) /* LSI clock selected as MCO source */
#define  RCC_MCOCFG_MCO2_LSE        ((uint32_t)0x000000D0U) /* LSE clock selected as MCO source */

/* MCO1 configuration */
#define RCC_MCOCFG_MCO1             ((uint32_t)0x0000000FU) /*MCO1[3:0] */
#define RCC_MCOCFG_MCO1_0           ((uint32_t)0x00000001U) /*Bit0*/
#define RCC_MCOCFG_MCO1_1           ((uint32_t)0x00000002U) /*Bit1*/
#define RCC_MCOCFG_MCO1_2           ((uint32_t)0x00000004U) /*Bit2*/
#define RCC_MCOCFG_MCO1_3           ((uint32_t)0x00000008U) /*Bit3*/

#define  RCC_MCOCFG_MCO1_NOCLK      ((uint32_t)0x00000000U) /* No clock */ 
#define  RCC_MCOCFG_MCO1_SYSCLK     ((uint32_t)0x00000008U) /* System clock selected as MCO source */ 
#define  RCC_MCOCFG_MCO1_HSI        ((uint32_t)0x00000009U) /* HSI clock selected as MCO source */
#define  RCC_MCOCFG_MCO1_HSE        ((uint32_t)0x0000000AU) /* HSE clock selected as MCO source  */ 
#define  RCC_MCOCFG_MCO1_PLL        ((uint32_t)0x0000000BU) /* PLL clock divided selected as MCO source */
#define  RCC_MCOCFG_MCO1_LSI        ((uint32_t)0x0000000CU) /* LSI clock selected as MCO source */
#define  RCC_MCOCFG_MCO1_LSE        ((uint32_t)0x0000000DU) /* LSE clock selected as MCO source */
/** Bit definition for RCC_BDCTRL register  **/
#define RCC_BDCTRL_LPTIM2RST         ((uint32_t)0x20000000U) /*Bit[29] */
#define RCC_BDCTRL_LPTIM1RST         ((uint32_t)0x10000000U) /*Bit[28]*/

#define RCC_BDCTRL_LPTIM2EN          ((uint32_t)0x08000000U) /*Bit[27] */
/* MCO1 configuration */
#define RCC_BDCTRL_LPTIM2SEL         ((uint32_t)0x07000000U) /*Bit[26:24] */
#define RCC_BDCTRL_LPTIM2SEL_0       ((uint32_t)0x01000000U) /*Bit24*/
#define RCC_BDCTRL_LPTIM2SEL_1       ((uint32_t)0x02000000U) /*Bit25*/
#define RCC_BDCTRL_LPTIM2SEL_2       ((uint32_t)0x04000000U) /*Bit26*/

#define RCC_BDCTRL_LPTIM2SEL_LSI     ((uint32_t)0x06000000U) /* LSI used as LPTIM2 clock, Note: B version chip  */
#define RCC_BDCTRL_LPTIM2SEL_LSE     ((uint32_t)0x07000000U) /* LSE used as LPTIM2 clock, Note: B version chip  */
#define RCC_BDCTRL_LPTIM2SEL_HSI     ((uint32_t)0x02000000U) /* HSI used as LPTIM2 clock */
#define RCC_BDCTRL_LPTIM2SEL_HSE     ((uint32_t)0x03000000U) /* HSE used as LPTIM2 clock */
#define RCC_BDCTRL_LPTIM2SEL_PCLK1   ((uint32_t)0x04000000U) /* PCLK1 used as LPTIM2 clock */

#define RCC_BDCTRL_LPTIM1EN          ((uint32_t)0x00800000U) /*Bit[23] */
/* MCO1 configuration */
#define RCC_BDCTRL_LPTIM1SEL         ((uint32_t)0x00700000U) /*Bit[22:20] */
#define RCC_BDCTRL_LPTIM1SEL_0       ((uint32_t)0x00100000U) /*Bit20*/
#define RCC_BDCTRL_LPTIM1SEL_1       ((uint32_t)0x00200000U) /*Bit21*/
#define RCC_BDCTRL_LPTIM1SEL_2       ((uint32_t)0x00400000U) /*Bit22*/


#define RCC_BDCTRL_LPTIM1SEL_LSI     ((uint32_t)0x00600000U) /* LSI used as LPTIM1 clock, Note: B version chip */
#define RCC_BDCTRL_LPTIM1SEL_LSE     ((uint32_t)0x00700000U) /* LSE used as LPTIM1 clock, Note: B version chip  */
#define RCC_BDCTRL_LPTIM1SEL_HSI     ((uint32_t)0x00200000U) /* HSI used as LPTIM1 clock */
#define RCC_BDCTRL_LPTIM1SEL_HSE     ((uint32_t)0x00300000U) /* HSE used as LPTIM1 clock */
#define RCC_BDCTRL_LPTIM1SEL_PCLK1   ((uint32_t)0x00400000U) /* PCLK1 used as LPTIM1 clock */

#define RCC_BDCTRL_BDSFTRST       ((uint32_t)0x00010000U) /*Bit[16] */

#define RCC_BDCTRL_RTCEN          ((uint32_t)0x00008000U) /*Bit[15] */
/* RTCSEL configuration */
#define RCC_BDCTRL_RTCSEL         ((uint32_t)0x00000300U) /*RTCSEL[1:0]*/
#define RCC_BDCTRL_RTCSEL_0       ((uint32_t)0x00000100U) /*Bit8*/
#define RCC_BDCTRL_RTCSEL_1       ((uint32_t)0x00000200U) /*Bit9*/

#define RCC_BDCTRL_RTCSEL_NOCLOCK ((uint32_t)0x00000000U) /* No clock */
#define RCC_BDCTRL_RTCSEL_LSE     ((uint32_t)0x00000100U) /* LSE oscillator clock used as RTC clock */
#define RCC_BDCTRL_RTCSEL_LSI     ((uint32_t)0x00000200U) /* LSI oscillator clock used as RTC clock */
#define RCC_BDCTRL_RTCSEL_HSE     ((uint32_t)0x00000300U) /* HSE oscillator clock divided by 128 used as RTC clock */

#define RCC_BDCTRL_LSECSSEN       ((uint32_t)0x00000008U) /* LSE CSS enable */
#define RCC_BDCTRL_LSEBP          ((uint32_t)0x00000004U) /* External Low Speed oscillator Bypass */
#define RCC_BDCTRL_LSERD          ((uint32_t)0x00000002U) /* External Low Speed oscillator Ready */  
#define RCC_BDCTRL_LSEEN          ((uint32_t)0x00000001U) /* External Low Speed oscillator enable */ 

/** Bit definition for RCC_CSSCTRL register  **/
#define RCC_CSSCTRL_HSICSSEN       ((uint32_t)0x00400000U) /* HSI clock security system enable */
#define RCC_CSSCTRL_WKUPCLKSEL     ((uint32_t)0x00100000U) /* STOP0 mode wake-up clock selection */
#define RCC_CSSCTRL_HSEPOF         ((uint32_t)0x00040000U) /* HSE frequency change rate out of range flag */
#define RCC_CSSCTRL_HSEFHF         ((uint32_t)0x00020000U) /* HSE frequency out of high limit flag */
#define RCC_CSSCTRL_HSEFLF         ((uint32_t)0x00010000U) /* HSE frequency out of low limit flag */
#define RCC_CSSCTRL_HSEPOEN        ((uint32_t)0x00008000U) /* HSE frequency change rate out of range enable */
#define RCC_CSSCTRL_HSEFHEN        ((uint32_t)0x00004000U) /* HSE frequency out of high limit enable */
#define RCC_CSSCTRL_HSEFLEN        ((uint32_t)0x00002000U) /* HSE frequency exceeds low limit value enable */
#define RCC_CSSCTRL_HSEDLSEL       ((uint32_t)0x00001000U) /* HSE detection delay selection */
#define RCC_CSSCTRL_HSEPOTHR       ((uint32_t)0x00000F00U) /* HSE frequency change rate threshold configuration */
#define RCC_CSSCTRL_HSEFHTHR       ((uint32_t)0x000000F0U) /* HSE frequency high limit value configuration */
#define RCC_CSSCTRL_HSEFLTHR       ((uint32_t)0x0000000FU) /* HSE frequency low limit value configuration */

/** Bit definition for RCC_AHB1PCLKEN register  **/
#define RCC_AHB1PCLKEN_SACEN       ((uint32_t)0x00008000U) /* SAC clock enabled*/ 
#define RCC_AHB1PCLKEN_DAC78EN     ((uint32_t)0x00004000U) /* DAC78 clock enabled*/ 
#define RCC_AHB1PCLKEN_DAC56EN     ((uint32_t)0x00002000U) /* DAC56 clock enabled*/ 
#define RCC_AHB1PCLKEN_ADC4EN      ((uint32_t)0x00001000U) /* ADC4 clock enabled*/ 
#define RCC_AHB1PCLKEN_ADC3EN      ((uint32_t)0x00000800U) /* ADC3 clock enabled*/ 
#define RCC_AHB1PCLKEN_ADC2EN      ((uint32_t)0x00000400U) /* ADC2 clock enabled*/ 
#define RCC_AHB1PCLKEN_ADC1EN      ((uint32_t)0x00000200U) /* ADC1 clock enabled*/
#define RCC_AHB1PCLKEN_IOFILTSEL   ((uint32_t)0x00000100U) /* IO filter clock enabled*/
#define RCC_AHB1PCLKEN_IOPHEN      ((uint32_t)0x00000080U) /* IOPH clock enabled*/
#define RCC_AHB1PCLKEN_IOPGEN      ((uint32_t)0x00000040U) /* IOPG clock enabled*/
#define RCC_AHB1PCLKEN_IOPFEN      ((uint32_t)0x00000020U) /* IOPF clock enabled*/
#define RCC_AHB1PCLKEN_IOPEEN      ((uint32_t)0x00000010U) /* IOPE clock enabled*/
#define RCC_AHB1PCLKEN_IOPDEN      ((uint32_t)0x00000008U) /* IOPD clock enabled*/
#define RCC_AHB1PCLKEN_IOPCEN      ((uint32_t)0x00000004U) /* IOPC clock enabled*/
#define RCC_AHB1PCLKEN_IOPBEN      ((uint32_t)0x00000002U) /* IOPB clock enabled*/
#define RCC_AHB1PCLKEN_IOPAEN      ((uint32_t)0x00000001U) /* IOPA clock enabled*/



/** Bit definition for RCC_PLLCTRL register  **/
/* SCLKPLLSEL configuration */
#define RCC_PLLCTRL_SCLKPLLSEL             ((uint32_t)0x00300000U) /*SCLKPLLSEL[1:0]*/
#define RCC_PLLCTRL_SCLKPLLSEL_0           ((uint32_t)0x00100000U) /*Bit0*/
#define RCC_PLLCTRL_SCLKPLLSEL_1           ((uint32_t)0x00200000U) /*Bit1*/

#define RCC_PLLCTRL_SCLKPLLSEL_PLL         ((uint32_t)0x00000000U) /* PLL selected as system clock */
#define RCC_PLLCTRL_SCLKPLLSEL_SHRTPLL     ((uint32_t)0x00100000U) /* SHRTPLL selected as system clock */
#define RCC_PLLCTRL_SCLKPLLSEL_USBHS240M  ((uint32_t)0x00300000U) /* USBHS240M selected as system clock */

/* PLLOUTPRES configuration */
#define RCC_PLLCTRL_PLLOUTPRES             ((uint32_t)0x000C0000U) /*PLLOUTPRES[1:0]*/
#define RCC_PLLCTRL_PLLOUTPRES_0           ((uint32_t)0x00040000U) /*Bit0*/
#define RCC_PLLCTRL_PLLOUTPRES_1           ((uint32_t)0x00080000U) /*Bit1*/

#define RCC_PLLCTRL_PLLOUTPRES_DIV1        ((uint32_t)0x00000000U)  /* PLL output 1 divisions */
#define RCC_PLLCTRL_PLLOUTPRES_DIV2        ((uint32_t)0x00040000U)  /* PLL output 2 divisions */
#define RCC_PLLCTRL_PLLOUTPRES_DIV4        ((uint32_t)0x00080000U)  /* PLL output 4 divisions */
#define RCC_PLLCTRL_PLLOUTPRES_DIV8        ((uint32_t)0x000C0000U)  /* PLL output 8 divisions */

/* PLLINPRES configuration */
#define RCC_PLLCTRL_PLLINPRES              ((uint32_t)0x00030000U) /*PLLINPRES[1:0]*/
#define RCC_PLLCTRL_PLLINPRES_0            ((uint32_t)0x00010000U) /*Bit0*/
#define RCC_PLLCTRL_PLLINPRES_1            ((uint32_t)0x00020000U) /*Bit1*/

#define RCC_PLLCTRL_PLLINPRES_DIV1        ((uint32_t)0x00000000U)  /* PLL input 1 divisions */
#define RCC_PLLCTRL_PLLINPRES_DIV2        ((uint32_t)0x00010000U)  /* PLL input 2 divisions */
#define RCC_PLLCTRL_PLLINPRES_DIV3        ((uint32_t)0x00020000U)  /* PLL input 3 divisions */
#define RCC_PLLCTRL_PLLINPRES_DIV4        ((uint32_t)0x00030000U)  /* PLL input 4 divisions */

#define RCC_PLLCTRL_DEADZEN              ((uint32_t)0x00008000U)  /* PLL frequency and phase monitor deadband adjustment */
#define RCC_PLLCTRL_LPFC2                ((uint32_t)0x00007000U)  /* Integral capacitor control of PLL filter loop */
#define RCC_PLLCTRL_LPFR                 ((uint32_t)0x00000F00U)  /* Zero Resistance Control of PLL Filter Loop */
#define RCC_PLLCTRL_LPFC1                ((uint32_t)0x000000F0U)  /* Bypass Capacitor Control for PLL Filter Loop */


/** Bit definition for RCC_VREFCTRL register  **/
#define RCC_VREFCTRL_TRIMDATA      ((uint32_t)0x0000003FU) /* TRIM_DATA[5:0]*/ 
#define RCC_VREFCTRL_TRIMDATA_0    ((uint32_t)0x00000001U) /* Bit 0 */
#define RCC_VREFCTRL_TRIMDATA_1    ((uint32_t)0x00000002U) /* Bit 1 */
#define RCC_VREFCTRL_TRIMDATA_2    ((uint32_t)0x00000004U) /* Bit 2 */
#define RCC_VREFCTRL_TRIMDATA_3    ((uint32_t)0x00000008U) /* Bit 3 */
#define RCC_VREFCTRL_TRIMDATA_4    ((uint32_t)0x00000010U) /* Bit 4 */
#define RCC_VREFCTRL_TRIMDATA_5    ((uint32_t)0x00000020U) /* Bit 5 */

#define RCC_VREFCTRL_VLSEL         ((uint32_t)0x000000C0U) /* VLSEL[1:0]*/ 
#define RCC_VREFCTRL_VLSEL_0       ((uint32_t)0x00000040U) /* Bit 0 */ 
#define RCC_VREFCTRL_VLSEL_1       ((uint32_t)0x00000080U) /* Bit 1 */ 

#define RCC_VREFCTRL_EN            ((uint32_t)0x00000100U) /* VREFNUF enable */ 
#define RCC_VREFCTRL_HIM           ((uint32_t)0x00000200U) /* VREFNUF high implement enable */
#define RCC_VREFCTRL_RDY           ((uint32_t)0x00001000U) /* VREFNUF ready flag */

#define RCC_VREFCTRL_TRIMEN        ((uint32_t)0x00004000U) /* VREFNUF trim enable */
/** Bit definition for RCC_SHRTPLLCTRL1 register  **/
#define RCC_SHRTPLLCTRL1_SATEN          ((uint32_t)0x40000000U) /* Bit[30]  */
#define RCC_SHRTPLLCTRL1_SHRTPLLMODE    ((uint32_t)0x10000000U) /* Bit[28]  */
#define RCC_SHRTPLLCTRL1_FRACEN         ((uint32_t)0x08000000U) /* Bit[27]  */
#define RCC_SHRTPLLCTRL1_CLKF           ((uint32_t)0x03FFFFFFU) /*SHRTPLL multiplication factor */

/** Bit definition for RCC_SHRTPLLCTRL2 register  **/
#define RCC_SHRTPLLCTRL2_CLKR           ((uint32_t)0xFC000000U) /*SHRTPLL dividing factor */

/** Bit definition for RCC_SHRTPLLCTRL3 register  **/
#define RCC_SHRTPLLCTRL3_SHRTPLLRDF     ((uint32_t)0x10000000U) /*SHRTPLL Clock Ready Flag */
#define RCC_SHRTPLLCTRL3_SHRTPLLLCK     ((uint32_t)0x08000000U) /*SHRTPLL clock lose lock control */
#define RCC_SHRTPLLCTRL3_SHRTPLLSRC     ((uint32_t)0x04000000U) /*SHRTPLL clock source */
#define RCC_SHRTPLLCTRL3_SHRTPLLEN      ((uint32_t)0x02000000U) /*SHRTPLL Enable */
#define RCC_SHRTPLLCTRL3_BWTRIM         ((uint32_t)0x00FFF000U) /*SHRTPLL band widths */

/** Bit definition for RCC_SRAMCFG1 register  **/
#define RCC_SRAMCFG1_CSRECCF       ((uint32_t)0x30000000U) /*SRAM3ECCF[1:0] */
#define RCC_SRAMCFG1_CSRECCF_0     ((uint32_t)0x10000000U) /*Bit0 */
#define RCC_SRAMCFG1_CSRECCF_1     ((uint32_t)0x20000000U) /*Bit1 */

#define RCC_SRAMCFG1_CSRECCF_NONE     ((uint32_t)0x00000000U) /*No ECC error occurred */
#define RCC_SRAMCFG1_CSRECCF_1BIT     ((uint32_t)0x10000000U) /*1bit ECC error occurred */
#define RCC_SRAMCFG1_CSRECCF_2BIT     ((uint32_t)0x20000000U) /*2bit ECC error occurred */
#define RCC_SRAMCFG1_CSRECCF_1_2BIT   ((uint32_t)0x30000000U) /*1bit and 2bit ECC error occurred */

#define RCC_SRAMCFG1_SR2PEF         ((uint32_t)0x04000000U) /*SRAM2 parity error flag bit */
#define RCC_SRAMCFG1_SR1PEF         ((uint32_t)0x01000000U) /*SRAM1 parity error flag bit */
#define RCC_SRAMCFG1_FECCRSTEN      ((uint32_t)0x00800000U) /*FLASH ECC error reset enable */
#define RCC_SRAMCFG1_CSRECCCLR      ((uint32_t)0x00400000U) /*CCM SRAM ECC Error Flag Bit Clear */
#define RCC_SRAMCFG1_SR2PECLR       ((uint32_t)0x00200000U) /*SRAM2 parity error flag bit clear */
#define RCC_SRAMCFG1_SR1PECLR       ((uint32_t)0x00100000U) /*SRAM1 parity error flag bit clear */

#define RCC_SRAMCFG1_CSRECCRSTEN     ((uint32_t)0x000C0000U) /*SRAM3ECCRSTEN[1:0] */
#define RCC_SRAMCFG1_CSRECCRST_0     ((uint32_t)0x00040000U) /*Bit0 */
#define RCC_SRAMCFG1_CSRECCRST_1     ((uint32_t)0x00080000U) /*Bit1 */

#define RCC_SRAMCFG1_CSRECCRST_NONE     ((uint32_t)0x00000000U) /*No reset generated when ECC error detected */
#define RCC_SRAMCFG1_CSRECCRST_1BIT     ((uint32_t)0x00040000U) /*Generate reset when 1bit ECC error is detected */
#define RCC_SRAMCFG1_CSRECCRST_2BIT     ((uint32_t)0x00080000U) /*Generate reset when 2bit ECC error is detected */
#define RCC_SRAMCFG1_CSRECCRST_1_2BIT   ((uint32_t)0x000C0000U) /*Generate reset when 1-bit and 2-bit ECC errors are detected */

#define RCC_SRAMCFG1_CSRECCIEN       ((uint32_t)0x00030000U) /*SRAM3ECCIEN[1:0] */
#define RCC_SRAMCFG1_CSRECCIEN_0     ((uint32_t)0x00010000U) /*Bit0 */
#define RCC_SRAMCFG1_CSRECCIEN_1     ((uint32_t)0x00020000U) /*Bit1 */

#define RCC_SRAMCFG1_CSRECCIEN_NONE     ((uint32_t)0x00000000U) /*No interrupt is triggered when an ECC error is detected */
#define RCC_SRAMCFG1_CSRECCIEN_1BIT     ((uint32_t)0x00010000U) /*Interrupt is triggered when 1bit ECC error is detected */
#define RCC_SRAMCFG1_CSRECCIEN_2BIT     ((uint32_t)0x00020000U) /*Interrupt triggered when 2bit ECC error is detected */
#define RCC_SRAMCFG1_CSRECCIEN_1_2BIT   ((uint32_t)0x00030000U) /*Interrupt is triggered when 1bit and 2bit ECC error is detected */

#define RCC_SRAMCFG1_SR2PERSTEN     ((uint32_t)0x00004000U) /*SRAM2 parity error reset enable */
#define RCC_SRAMCFG1_SR2PEIEN       ((uint32_t)0x00001000U) /*SRAM1 parity error interrupt enable */
#define RCC_SRAMCFG1_SR1PERSTEN     ((uint32_t)0x00000400U) /*SRAM2 parity error reset enable */
#define RCC_SRAMCFG1_SR1PEIEN       ((uint32_t)0x00000100U) /*SRAM1 parity error interrupt enable */
#define RCC_SRAMCFG1_SRAMFIN        ((uint32_t)0x00000040U) /*SRAM injection error enable */
#define RCC_SRAMCFG1_SRAMWEF        ((uint32_t)0x00000020U) /*SRAM write error flag bit */
#define RCC_SRAMCFG1_SRAMREF        ((uint32_t)0x00000010U) /*SRAM read error flag bit */
#define RCC_SRAMCFG1_CSRINIF        ((uint32_t)0x00000008U) /*CCM SRAM initialization complete flag bit */
#define RCC_SRAMCFG1_CSRINIEN       ((uint32_t)0x00000004U) /*CCM SRAM initialization enable */
#define RCC_SRAMCFG1_SRAMPEN        ((uint32_t)0x00000001U) /*CCM SRAM and BKP SRAM ECC enable */

/** Bit definition for RCC_SRAMCFG2 register  **/
#define RCC_SRAMCFG2_INIDAT         ((uint32_t)0xFFFFFFFFU) /*SRAM initialization data */

/** Bit definition for RCC_SRAMCFG3 register  **/
#define RCC_SRAMCFG3_INISTART       ((uint32_t)0xFFFFFFFFU) /*SRAM initialization start address */

/** Bit definition for RCC_SRAMCFG4 register  **/
#define RCC_SRAMCFG4_INIEND         ((uint32_t)0xFFFFFFFFU) /*SRAM initialization end address */

/** Bit definition for RCC_USBHSCTRL1 register  **/
#define RCC_USBHSCTRL1_RXTXPATH         ((uint32_t)0x40000000U) /* Transceiver asynchronous control  */
#define RCC_USBHSCTRL1_BSTHEN           ((uint32_t)0x20000000U) /* High Byte Transmission Bit-Stuffing Enable  */
#define RCC_USBHSCTRL1_BSTLEN           ((uint32_t)0x10000000U) /* Low byte transmission Bit-Stuffing enable  */
#define RCC_USBHSCTRL1_USBHSSEL        ((uint32_t)0x00800000U) /* USBHS Clock Source Selection */
#define RCC_USBHSCTRL1_SEBP             ((uint32_t)0x00400000U) /* Squelch Equalizer Bypass  */
#define RCC_USBHSCTRL1_RESSEL           ((uint32_t)0x00080000U) /* Calibration Resistor Selection  */
#define RCC_USBHSCTRL1_PDSEL            ((uint32_t)0x00008000U) /* Power-Down control signal selection for Common module  */
#define RCC_USBHSCTRL1_PLLBW            ((uint32_t)0x00000800U) /* USBHSPLL Bandwidth Adjustment  */
#define RCC_USBHSCTRL1_USBHSFSEL       ((uint32_t)0x00000700U) /* USBHS clock source frequency selection  */
#define RCC_USBHSCTRL1_USBHSFSEL_0     ((uint32_t)0x00000100U) /* Bit8 */
#define RCC_USBHSCTRL1_USBHSFSEL_1     ((uint32_t)0x00000200U) /* Bit9 */
#define RCC_USBHSCTRL1_USBHSFSEL_2     ((uint32_t)0x00000400U) /* Bit10 */
#define RCC_USBHSCTRL1_WKUPSEL          ((uint32_t)0x00000010U) /* Wake-up mode selection  */

/** Bit definition for RCC_USBHSCTRL2 register  **/
#define RCC_USBHSCTRL2_RESTRIM          ((uint32_t)0x00F00000U) /* Internal 200 ohm resistor adjustment  */
#define RCC_USBHSCTRL2_RESTRIM_0        ((uint32_t)0x00100000U) /* Bit0 */
#define RCC_USBHSCTRL2_RESTRIM_1        ((uint32_t)0x00200000U) /* Bit1 */
#define RCC_USBHSCTRL2_RESTRIM_2        ((uint32_t)0x00400000U) /* Bit2 */
#define RCC_USBHSCTRL2_RESTRIM_3        ((uint32_t)0x00800000U) /* Bit3 */
#define RCC_USBHSCTRL2_IDDQEN           ((uint32_t)0x00080000U) /* IDDQ Test Enable  */
#define RCC_USBHSCTRL2_IMPTRIM          ((uint32_t)0x0000C000U) /* USB signal source impedance adjustment  */
#define RCC_USBHSCTRL2_IMPTRIM_0        ((uint32_t)0x00004000U) /* Bit0 */
#define RCC_USBHSCTRL2_IMPTRIM_1        ((uint32_t)0x00008000U) /* Bit1 */
#define RCC_USBHSCTRL2_RFTRIM           ((uint32_t)0x00003000U) /* HS transmitter rise/fall time adjustment  */
#define RCC_USBHSCTRL2_RFTRIM_0         ((uint32_t)0x00001000U) /* Bit0 */
#define RCC_USBHSCTRL2_RFTRIM_1         ((uint32_t)0x00002000U) /* Bit1 */
#define RCC_USBHSCTRL2_CROSTRIM         ((uint32_t)0x00000C00U) /* Transmitter High Speed Crossover Adjustment  */
#define RCC_USBHSCTRL2_CROSTRIM_0       ((uint32_t)0x00000400U) /* Bit0 */
#define RCC_USBHSCTRL2_CROSTRIM_1       ((uint32_t)0x00000800U) /* Bit1 */
#define RCC_USBHSCTRL2_DATAVTRIM        ((uint32_t)0x00000300U) /* Data Detection Voltage Adjustment  */
#define RCC_USBHSCTRL2_DATAVTRIM_0      ((uint32_t)0x00000100U) /* Bit0 */
#define RCC_USBHSCTRL2_DATAVTRIM_1      ((uint32_t)0x00000200U) /* Bit1 */
#define RCC_USBHSCTRL2_HDCVTRIM         ((uint32_t)0x000000F0U) /* HS DC Voltage Level Adjustment  */
#define RCC_USBHSCTRL2_HDCVTRIM_0       ((uint32_t)0x00000010U) /* Bit0*/
#define RCC_USBHSCTRL2_HDCVTRIM_1       ((uint32_t)0x00000020U) /* Bit1*/
#define RCC_USBHSCTRL2_HDCVTRIM_2       ((uint32_t)0x00000040U) /* Bit2*/
#define RCC_USBHSCTRL2_HDCVTRIM_3       ((uint32_t)0x00000080U) /* Bit3*/
#define RCC_USBHSCTRL2_FLIMPTRIM        ((uint32_t)0x0000000FU) /* FS/LS signal source impedance adjustment  */
#define RCC_USBHSCTRL2_FLIMPTRIM_0      ((uint32_t)0x00000001U) /* Bit0 */
#define RCC_USBHSCTRL2_FLIMPTRIM_1      ((uint32_t)0x00000002U) /* Bit1 */
#define RCC_USBHSCTRL2_FLIMPTRIM_2      ((uint32_t)0x00000004U) /* Bit2 */
#define RCC_USBHSCTRL2_FLIMPTRIM_3      ((uint32_t)0x00000008U) /* Bit3 */

/** Bit definition for RCC_BOOTREMAP register  **/
#define RCC_BOOTREMAP_REMAPKEY     ((uint32_t)0x0000FF00U) /*System Remap Enable */

/* REMAPSEL configuration */
#define RCC_BOOTREMAP_REMAPSEL   ((uint32_t)0x00000007U) /* REMAPSEL[2:0] */
#define RCC_BOOTREMAP_REMAPSEL_0 ((uint32_t)0x00000001U) /* Bit 0 */
#define RCC_BOOTREMAP_REMAPSEL_1 ((uint32_t)0x00000002U) /* Bit 1 */
#define RCC_BOOTREMAP_REMAPSEL_2 ((uint32_t)0x00000004U) /* Bit 2 */

#define RCC_BOOTREMAP_REMAPSEL_SYS     ((uint32_t)0x00000000U) /* boot from system memory */
#define RCC_BOOTREMAP_REMAPSEL_BFLASH  ((uint32_t)0x00000001U) /* boot from bank before flash main */
#define RCC_BOOTREMAP_REMAPSEL_AFLASH  ((uint32_t)0x00000002U) /* boot from bank after flash main */
#define RCC_BOOTREMAP_REMAPSEL_SRAM    ((uint32_t)0x00000003U) /* boot from SRAM */
#define RCC_BOOTREMAP_REMAPSEL_FEMC    ((uint32_t)0x00000004U) /* boot from FEMC */
#define RCC_BOOTREMAP_REMAPSEL_XSPI    ((uint32_t)0x00000005U) /* boot from XSPI */

/** Bit definition for RCC_FDCANBADDR register  **/
#define RCC_FDCANBADDR_BADDR        ((uint32_t)0xFFFFFFFFU) /*Base address of the SRAM where the FDCAN module stores data */


/*** General Purpose and Alternate Function I/O ***/

/** Bit definition for GPIO_PMODE register **/
#define GPIO_PMODE_PMODE0           ((uint32_t)0x00000003U) /* Port x Pin 0 mode bits */
#define GPIO_PMODE_PMODE0_0         ((uint32_t)0x00000001U) /* Port x Pin 0 mode bit 0 */
#define GPIO_PMODE_PMODE0_1         ((uint32_t)0x00000002U) /* Port x Pin 0 mode bit 1 */

#define GPIO_PMODE_PMODE1           ((uint32_t)0x0000000CU) /* Port x Pin 1 mode bits */
#define GPIO_PMODE_PMODE1_0         ((uint32_t)0x00000004U) /* Port x Pin 1 mode bit 0 */
#define GPIO_PMODE_PMODE1_1         ((uint32_t)0x00000008U) /* Port x Pin 1 mode bit 1 */

#define GPIO_PMODE_PMODE2           ((uint32_t)0x00000030U) /* Port x Pin 2 mode bits */
#define GPIO_PMODE_PMODE2_0         ((uint32_t)0x00000010U) /* Port x Pin 2 mode bit 0 */
#define GPIO_PMODE_PMODE2_1         ((uint32_t)0x00000020U) /* Port x Pin 2 mode bit 1 */

#define GPIO_PMODE_PMODE3           ((uint32_t)0x000000C0U) /* Port x Pin 3 mode bits */
#define GPIO_PMODE_PMODE3_0         ((uint32_t)0x00000040U) /* Port x Pin 3 mode bit 0 */
#define GPIO_PMODE_PMODE3_1         ((uint32_t)0x00000080U) /* Port x Pin 3 mode bit 1 */

#define GPIO_PMODE_PMODE4           ((uint32_t)0x00000300U) /* Port x Pin 4 mode bits */
#define GPIO_PMODE_PMODE4_0         ((uint32_t)0x00000100U) /* Port x Pin 4 mode bit 0 */
#define GPIO_PMODE_PMODE4_1         ((uint32_t)0x00000200U) /* Port x Pin 4 mode bit 1 */

#define GPIO_PMODE_PMODE5           ((uint32_t)0x00000C00U) /* Port x Pin 5 mode bits */
#define GPIO_PMODE_PMODE5_0         ((uint32_t)0x00000400U) /* Port x Pin 5 mode bit 0 */
#define GPIO_PMODE_PMODE5_1         ((uint32_t)0x00000800U) /* Port x Pin 5 mode bit 1 */

#define GPIO_PMODE_PMODE6           ((uint32_t)0x00003000U) /* Port x Pin 6 mode bits */
#define GPIO_PMODE_PMODE6_0         ((uint32_t)0x00001000U) /* Port x Pin 6 mode bit 0 */
#define GPIO_PMODE_PMODE6_1         ((uint32_t)0x00002000U) /* Port x Pin 6 mode bit 1 */

#define GPIO_PMODE_PMODE7           ((uint32_t)0x0000C000U) /* Port x Pin 7 mode bits */
#define GPIO_PMODE_PMODE7_0         ((uint32_t)0x00004000U) /* Port x Pin 7 mode bit 0 */
#define GPIO_PMODE_PMODE7_1         ((uint32_t)0x00008000U) /* Port x Pin 7 mode bit 1 */

#define GPIO_PMODE_PMODE8           ((uint32_t)0x00030000U) /* Port x Pin 8 mode bits */
#define GPIO_PMODE_PMODE8_0         ((uint32_t)0x00010000U) /* Port x Pin 8 mode bit 0 */
#define GPIO_PMODE_PMODE8_1         ((uint32_t)0x00020000U) /* Port x Pin 8 mode bit 1 */

#define GPIO_PMODE_PMODE9           ((uint32_t)0x000C0000U) /* Port x Pin 9 mode bits */
#define GPIO_PMODE_PMODE9_0         ((uint32_t)0x00040000U) /* Port x Pin 9 mode bit 0 */
#define GPIO_PMODE_PMODE9_1         ((uint32_t)0x00080000U) /* Port x Pin 9 mode bit 1 */

#define GPIO_PMODE_PMODE10          ((uint32_t)0x00300000U) /* Port x Pin 10 mode bits */
#define GPIO_PMODE_PMODE10_0        ((uint32_t)0x00100000U) /* Port x Pin 10 mode bit 0 */
#define GPIO_PMODE_PMODE10_1        ((uint32_t)0x00200000U) /* Port x Pin 10 mode bit 1 */

#define GPIO_PMODE_PMODE11          ((uint32_t)0x00C00000U) /* Port x Pin 11 mode bits */
#define GPIO_PMODE_PMODE11_0        ((uint32_t)0x00400000U) /* Port x Pin 11 mode bit 0 */
#define GPIO_PMODE_PMODE11_1        ((uint32_t)0x00800000U) /* Port x Pin 11 mode bit 1 */

#define GPIO_PMODE_PMODE12          ((uint32_t)0x03000000U) /* Port x Pin 12 mode bits */
#define GPIO_PMODE_PMODE12_0        ((uint32_t)0x01000000U) /* Port x Pin 12 mode bit 0 */
#define GPIO_PMODE_PMODE12_1        ((uint32_t)0x02000000U) /* Port x Pin 12 mode bit 1 */

#define GPIO_PMODE_PMODE13          ((uint32_t)0x0C000000U) /* Port x Pin 13 mode bits */
#define GPIO_PMODE_PMODE13_0        ((uint32_t)0x04000000U) /* Port x Pin 13 mode bit 0 */
#define GPIO_PMODE_PMODE13_1        ((uint32_t)0x08000000U) /* Port x Pin 13 mode bit 1 */

#define GPIO_PMODE_PMODE14          ((uint32_t)0x30000000U) /* Port x Pin 14 mode bits */
#define GPIO_PMODE_PMODE14_0        ((uint32_t)0x10000000U) /* Port x Pin 14 mode bit 0 */
#define GPIO_PMODE_PMODE14_1        ((uint32_t)0x20000000U) /* Port x Pin 14 mode bit 1 */

#define GPIO_PMODE_PMODE15          ((uint32_t)0xC0000000U) /* Port x Pin 15 mode bits */
#define GPIO_PMODE_PMODE15_0        ((uint32_t)0x40000000U) /* Port x Pin 15 mode bit 0 */
#define GPIO_PMODE_PMODE15_1        ((uint32_t)0x80000000U) /* Port x Pin 15 mode bit 1 */

#define GPIO_PMODE_INPUT            ((uint32_t)0x00000000U)  /* Input mode */
#define GPIO_PMODE_OUTPUT           ((uint32_t)0x00000001U)  /* General output mode */
#define GPIO_PMODE_AF_OUTPUT        ((uint32_t)0x00000002U)  /* Alternate output mode */
#define GPIO_PMODE_ANALOG           ((uint32_t)0x00000003U)  /* Analog mode */

/** Bit definition for GPIO_PUPD register **/
#define GPIO_PUPD_PUPD0             ((uint32_t)0x00000003U)  /* Port x Pin 0 pull control bits */
#define GPIO_PUPD_PUPD0_0           ((uint32_t)0x00000001U)  /* Port x Pin 0 pull control bit 0 */
#define GPIO_PUPD_PUPD0_1           ((uint32_t)0x00000002U)  /* Port x Pin 0 pull control bit 1 */

#define GPIO_PUPD_PUPD1             ((uint32_t)0x0000000CU)  /* Port x Pin 1 pull control bits */
#define GPIO_PUPD_PUPD1_0           ((uint32_t)0x00000004U)  /* Port x Pin 1 pull control bit 0 */
#define GPIO_PUPD_PUPD1_1           ((uint32_t)0x00000008U)  /* Port x Pin 1 pull control bit 1 */

#define GPIO_PUPD_PUPD2             ((uint32_t)0x00000030U)  /* Port x Pin 2 pull control bits */
#define GPIO_PUPD_PUPD2_0           ((uint32_t)0x00000010U)  /* Port x Pin 2 pull control bit 0 */
#define GPIO_PUPD_PUPD2_1           ((uint32_t)0x00000020U)  /* Port x Pin 2 pull control bit 1 */

#define GPIO_PUPD_PUPD3             ((uint32_t)0x000000C0U)  /* Port x Pin 3 pull control bits */
#define GPIO_PUPD_PUPD3_0           ((uint32_t)0x00000040U)  /* Port x Pin 3 pull control bit 0 */
#define GPIO_PUPD_PUPD3_1           ((uint32_t)0x00000080U)  /* Port x Pin 3 pull control bit 1 */

#define GPIO_PUPD_PUPD4             ((uint32_t)0x00000300U)  /* Port x Pin 4 pull control bits */
#define GPIO_PUPD_PUPD4_0           ((uint32_t)0x00000100U)  /* Port x Pin 4 pull control bit 0 */
#define GPIO_PUPD_PUPD4_1           ((uint32_t)0x00000200U)  /* Port x Pin 4 pull control bit 1 */

#define GPIO_PUPD_PUPD5             ((uint32_t)0x00000C00U)  /* Port x Pin 5 pull control bits */
#define GPIO_PUPD_PUPD5_0           ((uint32_t)0x00000400U)  /* Port x Pin 5 pull control bit 0 */
#define GPIO_PUPD_PUPD5_1           ((uint32_t)0x00000800U)  /* Port x Pin 5 pull control bit 1 */

#define GPIO_PUPD_PUPD6             ((uint32_t)0x00003000U)  /* Port x Pin 6 pull control bits */
#define GPIO_PUPD_PUPD6_0           ((uint32_t)0x00001000U)  /* Port x Pin 6 pull control bit 0 */
#define GPIO_PUPD_PUPD6_1           ((uint32_t)0x00002000U)  /* Port x Pin 6 pull control bit 1 */

#define GPIO_PUPD_PUPD7             ((uint32_t)0x0000C000U)  /* Port x Pin 7 pull control bits */
#define GPIO_PUPD_PUPD7_0           ((uint32_t)0x00004000U)  /* Port x Pin 7 pull control bit 0 */
#define GPIO_PUPD_PUPD7_1           ((uint32_t)0x00008000U)  /* Port x Pin 7 pull control bit 1 */

#define GPIO_PUPD_PUPD8             ((uint32_t)0x00030000U)  /* Port x Pin 8 pull control bits */
#define GPIO_PUPD_PUPD8_0           ((uint32_t)0x00010000U)  /* Port x Pin 8 pull control bit 0 */
#define GPIO_PUPD_PUPD8_1           ((uint32_t)0x00020000U)  /* Port x Pin 8 pull control bit 1 */

#define GPIO_PUPD_PUPD9             ((uint32_t)0x000C0000U)  /* Port x Pin 9 pull control bits */
#define GPIO_PUPD_PUPD9_0           ((uint32_t)0x00040000U)  /* Port x Pin 9 pull control bit 0 */
#define GPIO_PUPD_PUPD9_1           ((uint32_t)0x00080000U)  /* Port x Pin 9 pull control bit 1 */

#define GPIO_PUPD_PUPD10            ((uint32_t)0x00300000U)  /* Port x Pin 10 pull control bits */
#define GPIO_PUPD_PUPD10_0          ((uint32_t)0x00100000U)  /* Port x Pin 10 pull control bit 0 */
#define GPIO_PUPD_PUPD10_1          ((uint32_t)0x00200000U)  /* Port x Pin 10 pull control bit 1 */

#define GPIO_PUPD_PUPD11            ((uint32_t)0x00C00000U)  /* Port x Pin 11 pull control bits */
#define GPIO_PUPD_PUPD11_0          ((uint32_t)0x00400000U)  /* Port x Pin 11 pull control bit 0 */
#define GPIO_PUPD_PUPD11_1          ((uint32_t)0x00800000U)  /* Port x Pin 11 pull control bit 1 */

#define GPIO_PUPD_PUPD12            ((uint32_t)0x03000000U)  /* Port x Pin 12 pull control bits */
#define GPIO_PUPD_PUPD12_0          ((uint32_t)0x01000000U)  /* Port x Pin 12 pull control bit 0 */
#define GPIO_PUPD_PUPD12_1          ((uint32_t)0x02000000U)  /* Port x Pin 12 pull control bit 1 */

#define GPIO_PUPD_PUPD13            ((uint32_t)0x0C000000U)  /* Port x Pin 13 pull control bits */
#define GPIO_PUPD_PUPD13_0          ((uint32_t)0x04000000U)  /* Port x Pin 13 pull control bit 0 */
#define GPIO_PUPD_PUPD13_1          ((uint32_t)0x08000000U)  /* Port x Pin 13 pull control bit 1 */

#define GPIO_PUPD_PUPD14            ((uint32_t)0x30000000U)  /* Port x Pin 14 pull control bits */
#define GPIO_PUPD_PUPD14_0          ((uint32_t)0x10000000U)  /* Port x Pin 14 pull control bit 0 */
#define GPIO_PUPD_PUPD14_1          ((uint32_t)0x20000000U)  /* Port x Pin 14 pull control bit 1 */

#define GPIO_PUPD_PUPD15            ((uint32_t)0xC0000000U)  /* Port x Pin 15 pull control bits */
#define GPIO_PUPD_PUPD15_0          ((uint32_t)0x40000000U)  /* Port x Pin 15 pull control bit 0 */
#define GPIO_PUPD_PUPD15_1          ((uint32_t)0x80000000U)  /* Port x Pin 15 pull control bit 1 */


#define GPIO_PUPD_NO_PULL           ((uint32_t)0x00000000U)  /* No pull */
#define GPIO_PUPD_PULL_UP           ((uint32_t)0x00000001U)  /* Pull up*/
#define GPIO_PUPD_PULL_DOWN         ((uint32_t)0x00000002U)  /* Pull down */


/** Bit definition for GPIO_POTYPE register **/
#define GPIO_POTYPE_POT0            ((uint32_t)0x00000001U)  /* Port x Pin 0 output type bits */
#define GPIO_POTYPE_POT1            ((uint32_t)0x00000002U)  /* Port x Pin 1 output type bits */
#define GPIO_POTYPE_POT2            ((uint32_t)0x00000004U)  /* Port x Pin 2 output type bits */
#define GPIO_POTYPE_POT3            ((uint32_t)0x00000008U)  /* Port x Pin 3 output type bits */
#define GPIO_POTYPE_POT4            ((uint32_t)0x00000010U)  /* Port x Pin 4 output type bits */
#define GPIO_POTYPE_POT5            ((uint32_t)0x00000020U)  /* Port x Pin 5 output type bits */
#define GPIO_POTYPE_POT6            ((uint32_t)0x00000040U)  /* Port x Pin 6 output type bits */
#define GPIO_POTYPE_POT7            ((uint32_t)0x00000080U)  /* Port x Pin 7 output type bits */
#define GPIO_POTYPE_POT8            ((uint32_t)0x00000100U)  /* Port x Pin 8 output type bits */
#define GPIO_POTYPE_POT9            ((uint32_t)0x00000200U)  /* Port x Pin 9 output type bits */
#define GPIO_POTYPE_POT10           ((uint32_t)0x00000400U)  /* Port x Pin 10 output type bits */
#define GPIO_POTYPE_POT11           ((uint32_t)0x00000800U)  /* Port x Pin 11 output type bits */
#define GPIO_POTYPE_POT12           ((uint32_t)0x00001000U)  /* Port x Pin 12 output type bits */
#define GPIO_POTYPE_POT13           ((uint32_t)0x00002000U)  /* Port x Pin 13 output type bits */
#define GPIO_POTYPE_POT14           ((uint32_t)0x00004000U)  /* Port x Pin 14 output type bits */
#define GPIO_POTYPE_POT15           ((uint32_t)0x00008000U)  /* Port x Pin 15 output type bits */

#define GPIO_POTYPE_PUSH_PULL       ((uint32_t)0x00000000U)
#define GPIO_POTYPE_OPEN_DRAIN      ((uint32_t)0x00000001U)

/** Bit definition for GPIO_AFSEL0 register **/
#define GPIO_AFSEL0_AFSEL0          ((uint32_t)0x0000001FU)  /* Port x Pin 0 alternate function bits */
#define GPIO_AFSEL0_AFSEL0_0        ((uint32_t)0x00000001U)  /* Port x Pin 0 alternate function bit 0 */
#define GPIO_AFSEL0_AFSEL0_1        ((uint32_t)0x00000002U)  /* Port x Pin 0 alternate function bit 1 */
#define GPIO_AFSEL0_AFSEL0_2        ((uint32_t)0x00000004U)  /* Port x Pin 0 alternate function bit 2 */
#define GPIO_AFSEL0_AFSEL0_3        ((uint32_t)0x00000008U)  /* Port x Pin 0 alternate function bit 3 */
#define GPIO_AFSEL0_AFSEL0_4        ((uint32_t)0x00000010U)  /* Port x Pin 0 alternate function bit 4 */

#define GPIO_AFSEL0_AFSEL1          ((uint32_t)0x00001F00U)  /* Port x Pin 1 alternate function bis */
#define GPIO_AFSEL0_AFSEL1_0        ((uint32_t)0x00000100U)  /* Port x Pin 1 alternate function bit 0 */
#define GPIO_AFSEL0_AFSEL1_1        ((uint32_t)0x00000200U)  /* Port x Pin 1 alternate function bit 1 */
#define GPIO_AFSEL0_AFSEL1_2        ((uint32_t)0x00000400U)  /* Port x Pin 1 alternate function bit 2 */
#define GPIO_AFSEL0_AFSEL1_3        ((uint32_t)0x00000800U)  /* Port x Pin 1 alternate function bit 3 */
#define GPIO_AFSEL0_AFSEL1_4        ((uint32_t)0x00001000U)  /* Port x Pin 1 alternate function bit 4 */

#define GPIO_AFSEL0_AFSEL2          ((uint32_t)0x001F0000U)  /* Port x Pin 2 alternate function bits */
#define GPIO_AFSEL0_AFSEL2_0        ((uint32_t)0x00010000U)  /* Port x Pin 2 alternate function bit 0 */
#define GPIO_AFSEL0_AFSEL2_1        ((uint32_t)0x00020000U)  /* Port x Pin 2 alternate function bit 1 */
#define GPIO_AFSEL0_AFSEL2_2        ((uint32_t)0x00040000U)  /* Port x Pin 2 alternate function bit 2 */
#define GPIO_AFSEL0_AFSEL2_3        ((uint32_t)0x00080000U)  /* Port x Pin 2 alternate function bit 3 */
#define GPIO_AFSEL0_AFSEL2_4        ((uint32_t)0x00100000U)  /* Port x Pin 2 alternate function bit 4 */

#define GPIO_AFSEL0_AFSEL3          ((uint32_t)0x1F000000U)  /* Port x Pin 3 alternate function bits */
#define GPIO_AFSEL0_AFSEL3_0        ((uint32_t)0x01000000U)  /* Port x Pin 3 alternate function bit 0 */
#define GPIO_AFSEL0_AFSEL3_1        ((uint32_t)0x02000000U)  /* Port x Pin 3 alternate function bit 1 */
#define GPIO_AFSEL0_AFSEL3_2        ((uint32_t)0x04000000U)  /* Port x Pin 3 alternate function bit 2 */
#define GPIO_AFSEL0_AFSEL3_3        ((uint32_t)0x08000000U)  /* Port x Pin 3 alternate function bit 3 */
#define GPIO_AFSEL0_AFSEL3_4        ((uint32_t)0x10000000U)  /* Port x Pin 3 alternate function bit 4 */

/** Bit definition for GPIO_AFSE1 register **/
#define GPIO_AFSEL1_AFSEL4          ((uint32_t)0x0000001FU)  /* Port x Pin 4 alternate function bits */
#define GPIO_AFSEL1_AFSEL4_0        ((uint32_t)0x00000001U)  /* Port x Pin 4 alternate function bit 0 */
#define GPIO_AFSEL1_AFSEL4_1        ((uint32_t)0x00000002U)  /* Port x Pin 4 alternate function bit 1 */
#define GPIO_AFSEL1_AFSEL4_2        ((uint32_t)0x00000004U)  /* Port x Pin 4 alternate function bit 2 */
#define GPIO_AFSEL1_AFSEL4_3        ((uint32_t)0x00000008U)  /* Port x Pin 4 alternate function bit 3 */
#define GPIO_AFSEL1_AFSEL4_4        ((uint32_t)0x00000010U)  /* Port x Pin 4 alternate function bit 4 */

#define GPIO_AFSEL1_AFSEL5          ((uint32_t)0x00001F00U)  /* Port x Pin 5 alternate function bis */
#define GPIO_AFSEL1_AFSEL5_0        ((uint32_t)0x00000100U)  /* Port x Pin 5 alternate function bit 0 */
#define GPIO_AFSEL1_AFSEL5_1        ((uint32_t)0x00000200U)  /* Port x Pin 5 alternate function bit 1 */
#define GPIO_AFSEL1_AFSEL5_2        ((uint32_t)0x00000400U)  /* Port x Pin 5 alternate function bit 2 */
#define GPIO_AFSEL1_AFSEL5_3        ((uint32_t)0x00000800U)  /* Port x Pin 5 alternate function bit 3 */
#define GPIO_AFSEL1_AFSEL5_4        ((uint32_t)0x00001000U)  /* Port x Pin 5 alternate function bit 4 */

#define GPIO_AFSEL1_AFSEL6          ((uint32_t)0x001F0000U)  /* Port x Pin 6 alternate function bits */
#define GPIO_AFSEL1_AFSEL6_0        ((uint32_t)0x00010000U)  /* Port x Pin 6 alternate function bit 0 */
#define GPIO_AFSEL1_AFSEL6_1        ((uint32_t)0x00020000U)  /* Port x Pin 6 alternate function bit 1 */
#define GPIO_AFSEL1_AFSEL6_2        ((uint32_t)0x00040000U)  /* Port x Pin 6 alternate function bit 2 */
#define GPIO_AFSEL1_AFSEL6_3        ((uint32_t)0x00080000U)  /* Port x Pin 6 alternate function bit 3 */
#define GPIO_AFSEL1_AFSEL6_4        ((uint32_t)0x00100000U)  /* Port x Pin 6 alternate function bit 4 */

#define GPIO_AFSEL1_AFSEL7          ((uint32_t)0x1F000000U)  /* Port x Pin 7 alternate function bits */
#define GPIO_AFSEL1_AFSEL7_0        ((uint32_t)0x01000000U)  /* Port x Pin 7 alternate function bit 0 */
#define GPIO_AFSEL1_AFSEL7_1        ((uint32_t)0x02000000U)  /* Port x Pin 7 alternate function bit 1 */
#define GPIO_AFSEL1_AFSEL7_2        ((uint32_t)0x04000000U)  /* Port x Pin 7 alternate function bit 2 */
#define GPIO_AFSEL1_AFSEL7_3        ((uint32_t)0x08000000U)  /* Port x Pin 7 alternate function bit 3 */
#define GPIO_AFSEL1_AFSEL7_4        ((uint32_t)0x10000000U)  /* Port x Pin 7 alternate function bit 4 */

/** Bit definition for GPIO_AFSEL2 register **/
#define GPIO_AFSEL2_AFSEL8          ((uint32_t)0x0000001FU)  /* Port x Pin 8 alternate function bits */
#define GPIO_AFSEL2_AFSEL8_0        ((uint32_t)0x00000001U)  /* Port x Pin 8 alternate function bit 0 */
#define GPIO_AFSEL2_AFSEL8_1        ((uint32_t)0x00000002U)  /* Port x Pin 8 alternate function bit 1 */
#define GPIO_AFSEL2_AFSEL8_2        ((uint32_t)0x00000004U)  /* Port x Pin 8 alternate function bit 2 */
#define GPIO_AFSEL2_AFSEL8_3        ((uint32_t)0x00000008U)  /* Port x Pin 8 alternate function bit 3 */
#define GPIO_AFSEL2_AFSEL8_4        ((uint32_t)0x00000010U)  /* Port x Pin 8 alternate function bit 4 */

#define GPIO_AFSEL2_AFSEL9          ((uint32_t)0x00001F00U)  /* Port x Pin 9 alternate function bis */
#define GPIO_AFSEL2_AFSEL9_0        ((uint32_t)0x00000100U)  /* Port x Pin 9 alternate function bit 0 */
#define GPIO_AFSEL2_AFSEL9_1        ((uint32_t)0x00000200U)  /* Port x Pin 9 alternate function bit 1 */
#define GPIO_AFSEL2_AFSEL9_2        ((uint32_t)0x00000400U)  /* Port x Pin 9 alternate function bit 2 */
#define GPIO_AFSEL2_AFSEL9_3        ((uint32_t)0x00000800U)  /* Port x Pin 9 alternate function bit 3 */
#define GPIO_AFSEL2_AFSEL9_4        ((uint32_t)0x00001000U)  /* Port x Pin 9 alternate function bit 4 */

#define GPIO_AFSEL2_AFSEL10         ((uint32_t)0x001F0000U)  /* Port x Pin 10 alternate function bits */
#define GPIO_AFSEL2_AFSEL10_0       ((uint32_t)0x00010000U)  /* Port x Pin 10 alternate function bit 0 */
#define GPIO_AFSEL2_AFSEL10_1       ((uint32_t)0x00020000U)  /* Port x Pin 10 alternate function bit 1 */
#define GPIO_AFSEL2_AFSEL10_2       ((uint32_t)0x00040000U)  /* Port x Pin 10 alternate function bit 2 */
#define GPIO_AFSEL2_AFSEL10_3       ((uint32_t)0x00080000U)  /* Port x Pin 10 alternate function bit 3 */
#define GPIO_AFSEL2_AFSEL10_4       ((uint32_t)0x00100000U)  /* Port x Pin 10 alternate function bit 4 */

#define GPIO_AFSEL2_AFSEL11         ((uint32_t)0x1F000000U)  /* Port x Pin 11 alternate function bits */
#define GPIO_AFSEL2_AFSEL11_0       ((uint32_t)0x01000000U)  /* Port x Pin 11 alternate function bit 0 */
#define GPIO_AFSEL2_AFSEL11_1       ((uint32_t)0x02000000U)  /* Port x Pin 11 alternate function bit 1 */
#define GPIO_AFSEL2_AFSEL11_2       ((uint32_t)0x04000000U)  /* Port x Pin 11 alternate function bit 2 */
#define GPIO_AFSEL2_AFSEL11_3       ((uint32_t)0x08000000U)  /* Port x Pin 11 alternate function bit 3 */
#define GPIO_AFSEL2_AFSEL11_4       ((uint32_t)0x10000000U)  /* Port x Pin 11 alternate function bit 4 */

/** Bit definition for GPIO_AFSEL3 register **/
#define GPIO_AFSEL3_AFSEL12         ((uint32_t)0x0000001FU)  /* Port x Pin 12 alternate function bits */
#define GPIO_AFSEL3_AFSEL12_0       ((uint32_t)0x00000001U)  /* Port x Pin 12 alternate function bit 0 */
#define GPIO_AFSEL3_AFSEL12_1       ((uint32_t)0x00000002U)  /* Port x Pin 12 alternate function bit 1 */
#define GPIO_AFSEL3_AFSEL12_2       ((uint32_t)0x00000004U)  /* Port x Pin 12 alternate function bit 2 */
#define GPIO_AFSEL3_AFSEL12_3       ((uint32_t)0x00000008U)  /* Port x Pin 12 alternate function bit 3 */
#define GPIO_AFSEL3_AFSEL12_4       ((uint32_t)0x00000010U)  /* Port x Pin 12 alternate function bit 4 */

#define GPIO_AFSEL3_AFSEL13         ((uint32_t)0x00001F00U)  /* Port x Pin 13 alternate function bis */
#define GPIO_AFSEL3_AFSEL13_0       ((uint32_t)0x00000100U)  /* Port x Pin 13 alternate function bit 0 */
#define GPIO_AFSEL3_AFSEL13_1       ((uint32_t)0x00000200U)  /* Port x Pin 13 alternate function bit 1 */
#define GPIO_AFSEL3_AFSEL13_2       ((uint32_t)0x00000400U)  /* Port x Pin 13 alternate function bit 2 */
#define GPIO_AFSEL3_AFSEL13_3       ((uint32_t)0x00000800U)  /* Port x Pin 13 alternate function bit 3 */
#define GPIO_AFSEL3_AFSEL13_4       ((uint32_t)0x00001000U)  /* Port x Pin 13 alternate function bit 4 */

#define GPIO_AFSEL3_AFSEL14         ((uint32_t)0x001F0000U)  /* Port x Pin 14 alternate function bits */
#define GPIO_AFSEL3_AFSEL14_0       ((uint32_t)0x00010000U)  /* Port x Pin 14 alternate function bit 0 */
#define GPIO_AFSEL3_AFSEL14_1       ((uint32_t)0x00020000U)  /* Port x Pin 14 alternate function bit 1 */
#define GPIO_AFSEL3_AFSEL14_2       ((uint32_t)0x00040000U)  /* Port x Pin 14 alternate function bit 2 */
#define GPIO_AFSEL3_AFSEL14_3       ((uint32_t)0x00080000U)  /* Port x Pin 14 alternate function bit 3 */
#define GPIO_AFSEL3_AFSEL14_4       ((uint32_t)0x00100000U)  /* Port x Pin 14 alternate function bit 4 */

#define GPIO_AFSEL3_AFSEL15         ((uint32_t)0x1F000000U)  /* Port x Pin 15 alternate function bits */
#define GPIO_AFSEL3_AFSEL15_0       ((uint32_t)0x01000000U)  /* Port x Pin 15 alternate function bit 0 */
#define GPIO_AFSEL3_AFSEL15_1       ((uint32_t)0x02000000U)  /* Port x Pin 15 alternate function bit 1 */
#define GPIO_AFSEL3_AFSEL15_2       ((uint32_t)0x04000000U)  /* Port x Pin 15 alternate function bit 2 */
#define GPIO_AFSEL3_AFSEL15_3       ((uint32_t)0x08000000U)  /* Port x Pin 15 alternate function bit 3 */
#define GPIO_AFSEL3_AFSEL15_4       ((uint32_t)0x10000000U)  /* Port x Pin 15 alternate function bit 4 */

#define GPIO_AFSEL_AF0              ((uint32_t)0x00000000U)  /* Alternate function 0  */
#define GPIO_AFSEL_AF1              ((uint32_t)0x00000001U)  /* Alternate function 1  */
#define GPIO_AFSEL_AF2              ((uint32_t)0x00000002U)  /* Alternate function 2  */
#define GPIO_AFSEL_AF3              ((uint32_t)0x00000003U)  /* Alternate function 3  */
#define GPIO_AFSEL_AF4              ((uint32_t)0x00000004U)  /* Alternate function 4  */
#define GPIO_AFSEL_AF5              ((uint32_t)0x00000005U)  /* Alternate function 5  */
#define GPIO_AFSEL_AF6              ((uint32_t)0x00000006U)  /* Alternate function 6  */
#define GPIO_AFSEL_AF7              ((uint32_t)0x00000007U)  /* Alternate function 7  */
#define GPIO_AFSEL_AF8              ((uint32_t)0x00000008U)  /* Alternate function 8  */
#define GPIO_AFSEL_AF9              ((uint32_t)0x00000009U)  /* Alternate function 9  */
#define GPIO_AFSEL_AF10             ((uint32_t)0x0000000AU)  /* Alternate function 10 */
#define GPIO_AFSEL_AF11             ((uint32_t)0x0000000BU)  /* Alternate function 11 */
#define GPIO_AFSEL_AF12             ((uint32_t)0x0000000CU)  /* Alternate function 12 */
#define GPIO_AFSEL_AF13             ((uint32_t)0x0000000DU)  /* Alternate function 13 */
#define GPIO_AFSEL_AF14             ((uint32_t)0x0000000EU)  /* Alternate function 14 */
#define GPIO_AFSEL_AF15             ((uint32_t)0x0000000FU)  /* Alternate function 15 */
#define GPIO_AFSEL_AF16             ((uint32_t)0x00000010U)  /* Alternate function 16 */
#define GPIO_AFSEL_AF17             ((uint32_t)0x00000011U)  /* Alternate function 17 */
#define GPIO_AFSEL_AF18             ((uint32_t)0x00000012U)  /* Alternate function 18 */
#define GPIO_AFSEL_AF19             ((uint32_t)0x00000013U)  /* Alternate function 19 */
#define GPIO_AFSEL_AF20             ((uint32_t)0x00000014U)  /* Alternate function 20 */
#define GPIO_AFSEL_AF21             ((uint32_t)0x00000015U)  /* Alternate function 21 */
#define GPIO_AFSEL_AF22             ((uint32_t)0x00000016U)  /* Alternate function 22 */
#define GPIO_AFSEL_AF23             ((uint32_t)0x00000017U)  /* Alternate function 23 */
#define GPIO_AFSEL_AF24             ((uint32_t)0x00000018U)  /* Alternate function 24 */
#define GPIO_AFSEL_AF25             ((uint32_t)0x00000019U)  /* Alternate function 25 */
#define GPIO_AFSEL_AF26             ((uint32_t)0x0000001AU)  /* Alternate function 26 */
#define GPIO_AFSEL_AF27             ((uint32_t)0x0000001BU)  /* Alternate function 27 */
#define GPIO_AFSEL_AF28             ((uint32_t)0x0000001CU)  /* Alternate function 28 */
#define GPIO_AFSEL_AF29             ((uint32_t)0x0000001DU)  /* Alternate function 29 */
#define GPIO_AFSEL_AF30             ((uint32_t)0x0000001EU)  /* Alternate function 30 */
#define GPIO_AFSEL_AF31             ((uint32_t)0x0000001FU)  /* Alternate function 31 */

/** Bit definition for GPIO_DS register **/
#define GPIO_DS_DS0                 ((uint32_t)0x00000003U) /* Port x Pin 0 Drive bitS */
#define GPIO_DS_DS0_0               ((uint32_t)0x00000001U) /* Port x Pin 0 Drive bit 0 */
#define GPIO_DS_DS0_1               ((uint32_t)0x00000002U) /* Port x Pin 0 Drive bit 1 */

#define GPIO_DS_DS1                 ((uint32_t)0x0000000CU) /* Port x Pin 1 Drive bitS */
#define GPIO_DS_DS1_0               ((uint32_t)0x00000004U) /* Port x Pin 1 Drive bit 0 */
#define GPIO_DS_DS1_1               ((uint32_t)0x00000008U) /* Port x Pin 1 Drive bit 1 */

#define GPIO_DS_DS2                 ((uint32_t)0x00000030U) /* Port x Pin 2 Drive bitS */
#define GPIO_DS_DS2_0               ((uint32_t)0x00000010U) /* Port x Pin 2 Drive bit 0 */
#define GPIO_DS_DS2_1               ((uint32_t)0x00000020U) /* Port x Pin 2 Drive bit 1 */

#define GPIO_DS_DS3                 ((uint32_t)0x000000C0U) /* Port x Pin 3 Drive bitS */
#define GPIO_DS_DS3_0               ((uint32_t)0x00000040U) /* Port x Pin 3 Drive bit 0 */
#define GPIO_DS_DS3_1               ((uint32_t)0x00000080U) /* Port x Pin 3 Drive bit 1 */

#define GPIO_DS_DS4                 ((uint32_t)0x00000300U) /* Port x Pin 4 Drive bitS */
#define GPIO_DS_DS4_0               ((uint32_t)0x00000100U) /* Port x Pin 4 Drive bit 0 */
#define GPIO_DS_DS4_1               ((uint32_t)0x00000200U) /* Port x Pin 4 Drive bit 1 */

#define GPIO_DS_DS5                 ((uint32_t)0x00000C00U) /* Port x Pin 5 Drive bitS */
#define GPIO_DS_DS5_0               ((uint32_t)0x00000400U) /* Port x Pin 5 Drive bit 0 */
#define GPIO_DS_DS5_1               ((uint32_t)0x00000800U) /* Port x Pin 5 Drive bit 1 */

#define GPIO_DS_DS6                 ((uint32_t)0x00003000U) /* Port x Pin 6 Drive bitS */
#define GPIO_DS_DS6_0               ((uint32_t)0x00001000U) /* Port x Pin 6 Drive bit 0 */
#define GPIO_DS_DS6_1               ((uint32_t)0x00002000U) /* Port x Pin 6 Drive bit 1 */

#define GPIO_DS_DS7                 ((uint32_t)0x0000C000U) /* Port x Pin 7 Drive bitS */
#define GPIO_DS_DS7_0               ((uint32_t)0x00004000U) /* Port x Pin 7 Drive bit 0 */
#define GPIO_DS_DS7_1               ((uint32_t)0x00008000U) /* Port x Pin 7 Drive bit 1 */

#define GPIO_DS_DS8                 ((uint32_t)0x00030000U) /* Port x Pin 8 Drive bitS */
#define GPIO_DS_DS8_0               ((uint32_t)0x00010000U) /* Port x Pin 8 Drive bit 0 */
#define GPIO_DS_DS8_1               ((uint32_t)0x00020000U) /* Port x Pin 8 Drive bit 1 */

#define GPIO_DS_DS9                 ((uint32_t)0x000C0000U) /* Port x Pin 9 Drive bitS */
#define GPIO_DS_DS9_0               ((uint32_t)0x00040000U) /* Port x Pin 9 Drive bit 0 */
#define GPIO_DS_DS9_1               ((uint32_t)0x00080000U) /* Port x Pin 9 Drive bit 1 */

#define GPIO_DS_DS10                ((uint32_t)0x00300000U) /* Port x Pin 10 Drive bitS */
#define GPIO_DS_DS10_0              ((uint32_t)0x00100000U) /* Port x Pin 10 Drive bit 0 */
#define GPIO_DS_DS10_1              ((uint32_t)0x00200000U) /* Port x Pin 10 Drive bit 1 */

#define GPIO_DS_DS11                ((uint32_t)0x00C00000U) /* Port x Pin 11 Drive bitS */
#define GPIO_DS_DS11_0              ((uint32_t)0x00400000U) /* Port x Pin 11 Drive bit 0 */
#define GPIO_DS_DS11_1              ((uint32_t)0x00800000U) /* Port x Pin 11 Drive bit 1 */

#define GPIO_DS_DS12                ((uint32_t)0x03000000U) /* Port x Pin 12 Drive bitS */
#define GPIO_DS_DS12_0              ((uint32_t)0x01000000U) /* Port x Pin 12 Drive bit 0 */
#define GPIO_DS_DS12_1              ((uint32_t)0x02000000U) /* Port x Pin 12 Drive bit 1 */

#define GPIO_DS_DS13                ((uint32_t)0x0C000000U) /* Port x Pin 13 Drive bitS */
#define GPIO_DS_DS13_0              ((uint32_t)0x04000000U) /* Port x Pin 13 Drive bit 0 */
#define GPIO_DS_DS13_1              ((uint32_t)0x08000000U) /* Port x Pin 13 Drive bit 1 */

#define GPIO_DS_DS14                ((uint32_t)0x30000000U) /* Port x Pin 14 Drive bitS */
#define GPIO_DS_DS14_0              ((uint32_t)0x10000000U) /* Port x Pin 14 Drive bit 0 */
#define GPIO_DS_DS14_1              ((uint32_t)0x20000000U) /* Port x Pin 14 Drive bit 1 */

#define GPIO_DS_DS15                ((uint32_t)0xC0000000U) /* Port x Pin 15 Drive bitS */
#define GPIO_DS_DS15_0              ((uint32_t)0x40000000U) /* Port x Pin 15 Drive bit 0 */
#define GPIO_DS_DS15_1              ((uint32_t)0x80000000U) /* Port x Pin 15 Drive bit 1 */

#define GPIO_DS_2mA                 ((uint32_t)0x00000000U) /* Drive strength is 2mA  */
#define GPIO_DS_4mA                 ((uint32_t)0x00000002U) /* Drive strength is 4mA  */
#define GPIO_DS_8mA                 ((uint32_t)0x00000001U) /* Drive strength is 8mA  */
#define GPIO_DS_12mA                ((uint32_t)0x00000003U) /* Drive strength is 12mA */

/** Bit definition for GPIO_SR register **/
#define GPIO_SR_SR0                 ((uint32_t)0x00000001U) /* Port x Pin 0 Slew rate bit  */
#define GPIO_SR_SR1                 ((uint32_t)0x00000002U) /* Port x Pin 1 Slew rate bit  */
#define GPIO_SR_SR2                 ((uint32_t)0x00000004U) /* Port x Pin 2 Slew rate bit  */
#define GPIO_SR_SR3                 ((uint32_t)0x00000008U) /* Port x Pin 3 Slew rate bit  */
#define GPIO_SR_SR4                 ((uint32_t)0x00000010U) /* Port x Pin 4 Slew rate bit  */
#define GPIO_SR_SR5                 ((uint32_t)0x00000020U) /* Port x Pin 5 Slew rate bit  */
#define GPIO_SR_SR6                 ((uint32_t)0x00000040U) /* Port x Pin 6 Slew rate bit  */
#define GPIO_SR_SR7                 ((uint32_t)0x00000080U) /* Port x Pin 7 Slew rate bit  */
#define GPIO_SR_SR8                 ((uint32_t)0x00000100U) /* Port x Pin 8 Slew rate bit  */
#define GPIO_SR_SR9                 ((uint32_t)0x00000200U) /* Port x Pin 9 Slew rate bit  */
#define GPIO_SR_SR10                ((uint32_t)0x00000400U) /* Port x Pin 10 Slew rate bit  */
#define GPIO_SR_SR11                ((uint32_t)0x00000800U) /* Port x Pin 11 Slew rate bit  */
#define GPIO_SR_SR12                ((uint32_t)0x00001000U) /* Port x Pin 12 Slew rate bit  */
#define GPIO_SR_SR13                ((uint32_t)0x00002000U) /* Port x Pin 13 Slew rate bit  */
#define GPIO_SR_SR14                ((uint32_t)0x00004000U) /* Port x Pin 14 Slew rate bit  */
#define GPIO_SR_SR15                ((uint32_t)0x00008000U) /* Port x Pin 15 Slew rate bit  */

#define GPIO_SR_FAST_SLEW           ((uint32_t)0x00000000U) /* Fast slew rate */
#define GPIO_SR_SLOW_SLEW           ((uint32_t)0x00000001U) /* Slow slew rate */

/** Bit definition for GPIO_PBSC register **/
#define GPIO_PBSC_PBS0              ((uint32_t)0x00000001U) /* Port x Pin 0 Set bit 0 */
#define GPIO_PBSC_PBS1              ((uint32_t)0x00000002U) /* Port x Pin 1 Set bit 1 */
#define GPIO_PBSC_PBS2              ((uint32_t)0x00000004U) /* Port x Pin 2 Set bit 2 */
#define GPIO_PBSC_PBS3              ((uint32_t)0x00000008U) /* Port x Pin 3 Set bit 3 */
#define GPIO_PBSC_PBS4              ((uint32_t)0x00000010U) /* Port x Pin 4 Set bit 4 */
#define GPIO_PBSC_PBS5              ((uint32_t)0x00000020U) /* Port x Pin 5 Set bit 5 */
#define GPIO_PBSC_PBS6              ((uint32_t)0x00000040U) /* Port x Pin 6 Set bit 6 */
#define GPIO_PBSC_PBS7              ((uint32_t)0x00000080U) /* Port x Pin 7 Set bit 7 */
#define GPIO_PBSC_PBS8              ((uint32_t)0x00000100U) /* Port x Pin 8 Set bit 8 */
#define GPIO_PBSC_PBS9              ((uint32_t)0x00000200U) /* Port x Pin 9 Set bit 9 */
#define GPIO_PBSC_PBS10             ((uint32_t)0x00000400U) /* Port x Pin 10 Set bit 10 */
#define GPIO_PBSC_PBS11             ((uint32_t)0x00000800U) /* Port x Pin 11 Set bit 11 */
#define GPIO_PBSC_PBS12             ((uint32_t)0x00001000U) /* Port x Pin 12 Set bit 12 */
#define GPIO_PBSC_PBS13             ((uint32_t)0x00002000U) /* Port x Pin 13 Set bit 13 */
#define GPIO_PBSC_PBS14             ((uint32_t)0x00004000U) /* Port x Pin 14 Set bit 14 */
#define GPIO_PBSC_PBS15             ((uint32_t)0x00008000U) /* Port x Pin 15 Set bit 15 */

#define GPIO_PBSC_PBC0              ((uint32_t)0x00010000U) /* Port x Pin 0 Reset bit 0 */
#define GPIO_PBSC_PBC1              ((uint32_t)0x00020000U) /* Port x Pin 1 Reset bit 1 */
#define GPIO_PBSC_PBC2              ((uint32_t)0x00040000U) /* Port x Pin 2 Reset bit 2 */
#define GPIO_PBSC_PBC3              ((uint32_t)0x00080000U) /* Port x Pin 3 Reset bit 3 */
#define GPIO_PBSC_PBC4              ((uint32_t)0x00100000U) /* Port x Pin 4 Reset bit 4 */
#define GPIO_PBSC_PBC5              ((uint32_t)0x00200000U) /* Port x Pin 5 Reset bit 5 */
#define GPIO_PBSC_PBC6              ((uint32_t)0x00400000U) /* Port x Pin 6 Reset bit 6 */
#define GPIO_PBSC_PBC7              ((uint32_t)0x00800000U) /* Port x Pin 7 Reset bit 7 */
#define GPIO_PBSC_PBC8              ((uint32_t)0x01000000U) /* Port x Pin 8 Reset bit 8 */
#define GPIO_PBSC_PBC9              ((uint32_t)0x02000000U) /* Port x Pin 9 Reset bit 9 */
#define GPIO_PBSC_PBC10             ((uint32_t)0x04000000U) /* Port x Pin 10 Reset bit 10 */
#define GPIO_PBSC_PBC11             ((uint32_t)0x08000000U) /* Port x Pin 11 Reset bit 11 */
#define GPIO_PBSC_PBC12             ((uint32_t)0x10000000U) /* Port x Pin 12 Reset bit 12 */
#define GPIO_PBSC_PBC13             ((uint32_t)0x20000000U) /* Port x Pin 13 Reset bit 13 */
#define GPIO_PBSC_PBC14             ((uint32_t)0x40000000U) /* Port x Pin 14 Reset bit 14 */
#define GPIO_PBSC_PBC15             ((uint32_t)0x80000000U) /* Port x Pin 15 Reset bit 15 */

/** Bit definition for GPIO_PBC register **/
#define GPIO_PBC_PBC0               ((uint16_t)0x0001U) /* Port x Pin 0 Reset bit 0 */
#define GPIO_PBC_PBC1               ((uint16_t)0x0002U) /* Port x Pin 1 Reset bit 1 */
#define GPIO_PBC_PBC2               ((uint16_t)0x0004U) /* Port x Pin 2 Reset bit 2 */
#define GPIO_PBC_PBC3               ((uint16_t)0x0008U) /* Port x Pin 3 Reset bit 3 */
#define GPIO_PBC_PBC4               ((uint16_t)0x0010U) /* Port x Pin 4 Reset bit 4 */
#define GPIO_PBC_PBC5               ((uint16_t)0x0020U) /* Port x Pin 5 Reset bit 5 */
#define GPIO_PBC_PBC6               ((uint16_t)0x0040U) /* Port x Pin 6 Reset bit 6 */
#define GPIO_PBC_PBC7               ((uint16_t)0x0080U) /* Port x Pin 7 Reset bit 7 */
#define GPIO_PBC_PBC8               ((uint16_t)0x0100U) /* Port x Pin 8 Reset bit 8 */
#define GPIO_PBC_PBC9               ((uint16_t)0x0200U) /* Port x Pin 9 Reset bit 9 */
#define GPIO_PBC_PBC10              ((uint16_t)0x0400U) /* Port x Pin 10 Reset bit 10 */
#define GPIO_PBC_PBC11              ((uint16_t)0x0800U) /* Port x Pin 11 Reset bit 11 */
#define GPIO_PBC_PBC12              ((uint16_t)0x1000U) /* Port x Pin 12 Reset bit 12 */
#define GPIO_PBC_PBC13              ((uint16_t)0x2000U) /* Port x Pin 13 Reset bit 13 */
#define GPIO_PBC_PBC14              ((uint16_t)0x4000U) /* Port x Pin 14 Reset bit 14 */
#define GPIO_PBC_PBC15              ((uint16_t)0x8000U) /* Port x Pin 15 Reset bit 15 */

/** Bit definition for GPIO_PID register **/
#define GPIO_PID_PID0               ((uint16_t)0x0001U) /* Port x Pin 0 input bit */
#define GPIO_PID_PID1               ((uint16_t)0x0002U) /* Port x Pin 1 input bit */
#define GPIO_PID_PID2               ((uint16_t)0x0004U) /* Port x Pin 2 input bit */
#define GPIO_PID_PID3               ((uint16_t)0x0008U) /* Port x Pin 3 input bit */
#define GPIO_PID_PID4               ((uint16_t)0x0010U) /* Port x Pin 4 input bit */
#define GPIO_PID_PID5               ((uint16_t)0x0020U) /* Port x Pin 5 input bit */
#define GPIO_PID_PID6               ((uint16_t)0x0040U) /* Port x Pin 6 input bit */
#define GPIO_PID_PID7               ((uint16_t)0x0080U) /* Port x Pin 7 input bit */
#define GPIO_PID_PID8               ((uint16_t)0x0100U) /* Port x Pin 8 input bit */
#define GPIO_PID_PID9               ((uint16_t)0x0200U) /* Port x Pin 9 input bit */
#define GPIO_PID_PID10              ((uint16_t)0x0400U) /* Port x Pin 10 input bit */
#define GPIO_PID_PID11              ((uint16_t)0x0800U) /* Port x Pin 11 input bit */
#define GPIO_PID_PID12              ((uint16_t)0x1000U) /* Port x Pin 12 input bit */
#define GPIO_PID_PID13              ((uint16_t)0x2000U) /* Port x Pin 13 input bit */
#define GPIO_PID_PID14              ((uint16_t)0x4000U) /* Port x Pin 14 input bit */
#define GPIO_PID_PID15              ((uint16_t)0x8000U) /* Port x Pin 15 input bit */

/** Bit definition for GPIO_POD register **/
#define GPIO_POD_POD0               ((uint16_t)0x0001U) /* Port x Pin 0 output bit */
#define GPIO_POD_POD1               ((uint16_t)0x0002U) /* Port x Pin 1 output bit */
#define GPIO_POD_POD2               ((uint16_t)0x0004U) /* Port x Pin 2 output bit */
#define GPIO_POD_POD3               ((uint16_t)0x0008U) /* Port x Pin 3 output bit */
#define GPIO_POD_POD4               ((uint16_t)0x0010U) /* Port x Pin 4 output bit */
#define GPIO_POD_POD5               ((uint16_t)0x0020U) /* Port x Pin 5 output bit */
#define GPIO_POD_POD6               ((uint16_t)0x0040U) /* Port x Pin 6 output bit */
#define GPIO_POD_POD7               ((uint16_t)0x0080U) /* Port x Pin 7 output bit */
#define GPIO_POD_POD8               ((uint16_t)0x0100U) /* Port x Pin 8 output bit */
#define GPIO_POD_POD9               ((uint16_t)0x0200U) /* Port x Pin 9 output bit */
#define GPIO_POD_POD10              ((uint16_t)0x0400U) /* Port x Pin 10 output bit */
#define GPIO_POD_POD11              ((uint16_t)0x0800U) /* Port x Pin 11 output bit */
#define GPIO_POD_POD12              ((uint16_t)0x1000U) /* Port x Pin 12 output bit */
#define GPIO_POD_POD13              ((uint16_t)0x2000U) /* Port x Pin 13 output bit */
#define GPIO_POD_POD14              ((uint16_t)0x4000U) /* Port x Pin 14 output bit */
#define GPIO_POD_POD15              ((uint16_t)0x8000U) /* Port x Pin 15 output bit */

/** Bit definition for GPIO_PLOCK register **/
#define GPIO_PLOCK_PLOCK0           ((uint32_t)0x00000001U) /* Port x Pin 0 Lock bit */
#define GPIO_PLOCK_PLOCK1           ((uint32_t)0x00000002U) /* Port x Pin 1 Lock bit */
#define GPIO_PLOCK_PLOCK2           ((uint32_t)0x00000004U) /* Port x Pin 2 Lock bit */
#define GPIO_PLOCK_PLOCK3           ((uint32_t)0x00000008U) /* Port x Pin 3 Lock bit */
#define GPIO_PLOCK_PLOCK4           ((uint32_t)0x00000010U) /* Port x Pin 4 Lock bit */
#define GPIO_PLOCK_PLOCK5           ((uint32_t)0x00000020U) /* Port x Pin 5 Lock bit */
#define GPIO_PLOCK_PLOCK6           ((uint32_t)0x00000040U) /* Port x Pin 6 Lock bit */
#define GPIO_PLOCK_PLOCK7           ((uint32_t)0x00000080U) /* Port x Pin 7 Lock bit */
#define GPIO_PLOCK_PLOCK8           ((uint32_t)0x00000100U) /* Port x Pin 8 Lock bit */
#define GPIO_PLOCK_PLOCK9           ((uint32_t)0x00000200U) /* Port x Pin 9 Lock bit */
#define GPIO_PLOCK_PLOCK10          ((uint32_t)0x00000400U) /* Port x Pin 10 Lock bit */
#define GPIO_PLOCK_PLOCK11          ((uint32_t)0x00000800U) /* Port x Pin 11 Lock bit */
#define GPIO_PLOCK_PLOCK12          ((uint32_t)0x00001000U) /* Port x Pin 12 Lock bit */
#define GPIO_PLOCK_PLOCK13          ((uint32_t)0x00002000U) /* Port x Pin 13 Lock bit */
#define GPIO_PLOCK_PLOCK14          ((uint32_t)0x00004000U) /* Port x Pin 14 Lock bit */
#define GPIO_PLOCK_PLOCK15          ((uint32_t)0x00008000U) /* Port x Pin 15 Lock bit */
#define GPIO_PLOCK_PLOCKK           ((uint32_t)0x00010000U) /* Port x Lock key */

/** Bit definition for AFIO_RMP_CFG register **/
#define AFIO_RMP_CFG_SPI1_NSS               ((uint32_t)0x00000100U)  /* SPI1 NSS mode config bit */
#define AFIO_RMP_CFG_SPI2_NSS               ((uint32_t)0x00000200U)  /* SPI2 NSS mode config bit */
#define AFIO_RMP_CFG_SPI3_NSS               ((uint32_t)0x00000400U)  /* SPI3 NSS mode config bit */
#define AFIO_RMP_CFG_SPI4_NSS               ((uint32_t)0x00000800U)  /* SPI4 NSS mode config bit */
#define AFIO_RMP_CFG_SPI5_NSS               ((uint32_t)0x00001000U)  /* SPI5 NSS mode config bit */
#define AFIO_RMP_CFG_SPI6_NSS               ((uint32_t)0x00002000U)  /* SPI6 NSS mode config bit */

#define AFIO_RMP_CFG_SWJ_CFG                ((uint32_t)0x0001C000U)  /* JTAG/SWD pin config bits */
#define AFIO_RMP_CFG_SWJ_CFG_0              ((uint32_t)0x00004000U)  /* JTAG/SWD pin config bit 0 */
#define AFIO_RMP_CFG_SWJ_CFG_1              ((uint32_t)0x00008000U)  /* JTAG/SWD pin config bit 1 */
#define AFIO_RMP_CFG_SWJ_CFG_2              ((uint32_t)0x00010000U)  /* JTAG/SWD pin config bit 2 */

#define AFIO_RMP_CFG_IO_FILTER              ((uint32_t)0x007E0000U)  /* IO filter stage config bits */
#define AFIO_RMP_CFG_IO_FILTER_0            ((uint32_t)0x00020000U)  /* IO filter stage config bit 0 */
#define AFIO_RMP_CFG_IO_FILTER_1            ((uint32_t)0x00040000U)  /* IO filter stage config bit 1 */
#define AFIO_RMP_CFG_IO_FILTER_2            ((uint32_t)0x00080000U)  /* IO filter stage config bit 2 */
#define AFIO_RMP_CFG_IO_FILTER_3            ((uint32_t)0x00100000U)  /* IO filter stage config bit 3 */
#define AFIO_RMP_CFG_IO_FILTER_4            ((uint32_t)0x00200000U)  /* IO filter stage config bit 4 */
#define AFIO_RMP_CFG_IO_FILTER_5            ((uint32_t)0x00400000U)  /* IO filter stage config bit 5 */

#define AFIO_RMP_CFG_FEMC_NADV              ((uint32_t)0x00800000U)  /* FEMC NADV pin config bit */
#define AFIO_RMP_CFG_EXTI_FILTER            ((uint32_t)0x01000000U)  /* EXTI agfilter config bit */
#define AFIO_RMP_CFG_XSPI_XIP_WR_BE         ((uint32_t)0x02000000U)  /* XSPI big-endian enable bit for writing in XIP mode */
#define AFIO_RMP_CFG_XSPI_HALF_DUPLEX       ((uint32_t)0x04000000U)  /* XSPI half duplex mode enable bit */
#define AFIO_RMP_CFG_XSPI_DUAL_QUAD         ((uint32_t)0x08000000U)  /* XSPI duan quad mode enable bit */
#define AFIO_RMP_CFG_ETH_MODE               ((uint32_t)0x10000000U)  /* ETH mode config bit:MII or RMII */
#define AFIO_RMP_CFG_XSPI_NSS_IN            ((uint32_t)0x20000000U)  /* xSPI NSS pin input control bit */
#define AFIO_RMP_CFG_XSPI_NSS_SEL           ((uint32_t)0x40000000U)  /* xSPI NSS pin input select bit */
#define AFIO_RMP_CFG_XSPI_FLASH2            ((uint32_t)0x80000000U)  /* xSPI flash2 enable bit in DUAL-QUAD mode */

/** Bit definition for AFIO_EXTI_CFG1 register **/
#define AFIO_EXTI_CFG1_EXTI0                ((uint32_t)0x0000007FU)  /* EXTI Line 0 input source config bits */
#define AFIO_EXTI_CFG1_EXTI0_0              ((uint32_t)0x00000001U)  /* EXTI Line 0 input source config bit 0 */
#define AFIO_EXTI_CFG1_EXTI0_1              ((uint32_t)0x00000002U)  /* EXTI Line 0 input source config bit 1 */
#define AFIO_EXTI_CFG1_EXTI0_2              ((uint32_t)0x00000004U)  /* EXTI Line 0 input source config bit 2 */
#define AFIO_EXTI_CFG1_EXTI0_3              ((uint32_t)0x00000008U)  /* EXTI Line 0 input source config bit 3 */
#define AFIO_EXTI_CFG1_EXTI0_4              ((uint32_t)0x00000010U)  /* EXTI Line 0 input source config bit 4 */
#define AFIO_EXTI_CFG1_EXTI0_5              ((uint32_t)0x00000020U)  /* EXTI Line 0 input source config bit 5 */
#define AFIO_EXTI_CFG1_EXTI0_6              ((uint32_t)0x00000040U)  /* EXTI Line 0 input source config bit 6 */

#define AFIO_EXTI_CFG1_EXTI1                ((uint32_t)0x00007F00U)  /* EXTI Line 1 input source config bits */
#define AFIO_EXTI_CFG1_EXTI1_0              ((uint32_t)0x00000100U)  /* EXTI Line 1 input source config bit 0 */
#define AFIO_EXTI_CFG1_EXTI1_1              ((uint32_t)0x00000200U)  /* EXTI Line 1 input source config bit 1 */
#define AFIO_EXTI_CFG1_EXTI1_2              ((uint32_t)0x00000400U)  /* EXTI Line 1 input source config bit 2 */
#define AFIO_EXTI_CFG1_EXTI1_3              ((uint32_t)0x00000800U)  /* EXTI Line 1 input source config bit 3 */
#define AFIO_EXTI_CFG1_EXTI1_4              ((uint32_t)0x00001000U)  /* EXTI Line 1 input source config bit 4 */
#define AFIO_EXTI_CFG1_EXTI1_5              ((uint32_t)0x00002000U)  /* EXTI Line 1 input source config bit 5 */
#define AFIO_EXTI_CFG1_EXTI1_6              ((uint32_t)0x00004000U)  /* EXTI Line 1 input source config bit 6 */

#define AFIO_EXTI_CFG1_EXTI2                ((uint32_t)0x007F0000U)  /* EXTI Line 2 input source config bits */
#define AFIO_EXTI_CFG1_EXTI2_0              ((uint32_t)0x00010000U)  /* EXTI Line 2 input source config bit 0 */
#define AFIO_EXTI_CFG1_EXTI2_1              ((uint32_t)0x00020000U)  /* EXTI Line 2 input source config bit 1 */
#define AFIO_EXTI_CFG1_EXTI2_2              ((uint32_t)0x00040000U)  /* EXTI Line 2 input source config bit 2 */
#define AFIO_EXTI_CFG1_EXTI2_3              ((uint32_t)0x00080000U)  /* EXTI Line 2 input source config bit 3 */
#define AFIO_EXTI_CFG1_EXTI2_4              ((uint32_t)0x00100000U)  /* EXTI Line 2 input source config bit 4 */
#define AFIO_EXTI_CFG1_EXTI2_5              ((uint32_t)0x00200000U)  /* EXTI Line 2 input source config bit 5 */
#define AFIO_EXTI_CFG1_EXTI2_6              ((uint32_t)0x00400000U)  /* EXTI Line 2 input source config bit 6 */

#define AFIO_EXTI_CFG1_EXTI3                ((uint32_t)0x7F000000U)  /* EXTI Line 3 input source config bits */
#define AFIO_EXTI_CFG1_EXTI3_0              ((uint32_t)0x01000000U)  /* EXTI Line 3 input source config bit 0 */
#define AFIO_EXTI_CFG1_EXTI3_1              ((uint32_t)0x02000000U)  /* EXTI Line 3 input source config bit 1 */
#define AFIO_EXTI_CFG1_EXTI3_2              ((uint32_t)0x04000000U)  /* EXTI Line 3 input source config bit 2 */
#define AFIO_EXTI_CFG1_EXTI3_3              ((uint32_t)0x08000000U)  /* EXTI Line 3 input source config bit 3 */
#define AFIO_EXTI_CFG1_EXTI3_4              ((uint32_t)0x10000000U)  /* EXTI Line 3 input source config bit 4 */
#define AFIO_EXTI_CFG1_EXTI3_5              ((uint32_t)0x20000000U)  /* EXTI Line 3 input source config bit 5 */
#define AFIO_EXTI_CFG1_EXTI3_6              ((uint32_t)0x40000000U)  /* EXTI Line 3 input source config bit 6 */

/** Bit definition for AFIO_EXTI_CFG2 register **/
#define AFIO_EXTI_CFG2_EXTI4                ((uint32_t)0x0000007FU)  /* EXTI Line 4 input source config bits */
#define AFIO_EXTI_CFG2_EXTI4_0              ((uint32_t)0x00000001U)  /* EXTI Line 4 input source config bit 0 */
#define AFIO_EXTI_CFG2_EXTI4_1              ((uint32_t)0x00000002U)  /* EXTI Line 4 input source config bit 1 */
#define AFIO_EXTI_CFG2_EXTI4_2              ((uint32_t)0x00000004U)  /* EXTI Line 4 input source config bit 2 */
#define AFIO_EXTI_CFG2_EXTI4_3              ((uint32_t)0x00000008U)  /* EXTI Line 4 input source config bit 3 */
#define AFIO_EXTI_CFG2_EXTI4_4              ((uint32_t)0x00000010U)  /* EXTI Line 4 input source config bit 4 */
#define AFIO_EXTI_CFG2_EXTI4_5              ((uint32_t)0x00000020U)  /* EXTI Line 4 input source config bit 5 */
#define AFIO_EXTI_CFG2_EXTI4_6              ((uint32_t)0x00000040U)  /* EXTI Line 4 input source config bit 6 */

#define AFIO_EXTI_CFG2_EXTI5                ((uint32_t)0x00007F00U)  /* EXTI Line 5 input source config bits */
#define AFIO_EXTI_CFG2_EXTI5_0              ((uint32_t)0x00000100U)  /* EXTI Line 5 input source config bit 0 */
#define AFIO_EXTI_CFG2_EXTI5_1              ((uint32_t)0x00000200U)  /* EXTI Line 5 input source config bit 1 */
#define AFIO_EXTI_CFG2_EXTI5_2              ((uint32_t)0x00000400U)  /* EXTI Line 5 input source config bit 2 */
#define AFIO_EXTI_CFG2_EXTI5_3              ((uint32_t)0x00000800U)  /* EXTI Line 5 input source config bit 3 */
#define AFIO_EXTI_CFG2_EXTI5_4              ((uint32_t)0x00001000U)  /* EXTI Line 5 input source config bit 4 */
#define AFIO_EXTI_CFG2_EXTI5_5              ((uint32_t)0x00002000U)  /* EXTI Line 5 input source config bit 5 */
#define AFIO_EXTI_CFG2_EXTI5_6              ((uint32_t)0x00004000U)  /* EXTI Line 5 input source config bit 6 */

#define AFIO_EXTI_CFG2_EXTI6                ((uint32_t)0x007F0000U)  /* EXTI Line 6 input source config bits */
#define AFIO_EXTI_CFG2_EXTI6_0              ((uint32_t)0x00010000U)  /* EXTI Line 6 input source config bit 0 */
#define AFIO_EXTI_CFG2_EXTI6_1              ((uint32_t)0x00020000U)  /* EXTI Line 6 input source config bit 1 */
#define AFIO_EXTI_CFG2_EXTI6_2              ((uint32_t)0x00040000U)  /* EXTI Line 6 input source config bit 2 */
#define AFIO_EXTI_CFG2_EXTI6_3              ((uint32_t)0x00080000U)  /* EXTI Line 6 input source config bit 3 */
#define AFIO_EXTI_CFG2_EXTI6_4              ((uint32_t)0x00100000U)  /* EXTI Line 6 input source config bit 4 */
#define AFIO_EXTI_CFG2_EXTI6_5              ((uint32_t)0x00200000U)  /* EXTI Line 6 input source config bit 5 */
#define AFIO_EXTI_CFG2_EXTI6_6              ((uint32_t)0x00400000U)  /* EXTI Line 6 input source config bit 6 */

#define AFIO_EXTI_CFG2_EXTI7                ((uint32_t)0x7F000000U)  /* EXTI Line 7 input source config bits */
#define AFIO_EXTI_CFG2_EXTI7_0              ((uint32_t)0x01000000U)  /* EXTI Line 7 input source config bit 0 */
#define AFIO_EXTI_CFG2_EXTI7_1              ((uint32_t)0x02000000U)  /* EXTI Line 7 input source config bit 1 */
#define AFIO_EXTI_CFG2_EXTI7_2              ((uint32_t)0x04000000U)  /* EXTI Line 7 input source config bit 2 */
#define AFIO_EXTI_CFG2_EXTI7_3              ((uint32_t)0x08000000U)  /* EXTI Line 7 input source config bit 3 */
#define AFIO_EXTI_CFG2_EXTI7_4              ((uint32_t)0x10000000U)  /* EXTI Line 7 input source config bit 4 */
#define AFIO_EXTI_CFG2_EXTI7_5              ((uint32_t)0x20000000U)  /* EXTI Line 7 input source config bit 5 */
#define AFIO_EXTI_CFG2_EXTI7_6              ((uint32_t)0x40000000U)  /* EXTI Line 7 input source config bit 6 */

/** Bit definition for AFIO_EXTI_CFG2 register **/
#define AFIO_EXTI_CFG3_EXTI8                ((uint32_t)0x0000007FU)  /* EXTI Line 8 input source config bits */
#define AFIO_EXTI_CFG3_EXTI8_0              ((uint32_t)0x00000001U)  /* EXTI Line 8 input source config bit 0 */
#define AFIO_EXTI_CFG3_EXTI8_1              ((uint32_t)0x00000002U)  /* EXTI Line 8 input source config bit 1 */
#define AFIO_EXTI_CFG3_EXTI8_2              ((uint32_t)0x00000004U)  /* EXTI Line 8 input source config bit 2 */
#define AFIO_EXTI_CFG3_EXTI8_3              ((uint32_t)0x00000008U)  /* EXTI Line 8 input source config bit 3 */
#define AFIO_EXTI_CFG3_EXTI8_4              ((uint32_t)0x00000010U)  /* EXTI Line 8 input source config bit 4 */
#define AFIO_EXTI_CFG3_EXTI8_5              ((uint32_t)0x00000020U)  /* EXTI Line 8 input source config bit 5 */
#define AFIO_EXTI_CFG3_EXTI8_6              ((uint32_t)0x00000040U)  /* EXTI Line 8 input source config bit 6 */

#define AFIO_EXTI_CFG3_EXTI9                ((uint32_t)0x00007F00U)  /* EXTI Line 9 input source config bits */
#define AFIO_EXTI_CFG3_EXTI9_0              ((uint32_t)0x00000100U)  /* EXTI Line 9 input source config bit 0 */
#define AFIO_EXTI_CFG3_EXTI9_1              ((uint32_t)0x00000200U)  /* EXTI Line 9 input source config bit 1 */
#define AFIO_EXTI_CFG3_EXTI9_2              ((uint32_t)0x00000400U)  /* EXTI Line 9 input source config bit 2 */
#define AFIO_EXTI_CFG3_EXTI9_3              ((uint32_t)0x00000800U)  /* EXTI Line 9 input source config bit 3 */
#define AFIO_EXTI_CFG3_EXTI9_4              ((uint32_t)0x00001000U)  /* EXTI Line 9 input source config bit 4 */
#define AFIO_EXTI_CFG3_EXTI9_5              ((uint32_t)0x00002000U)  /* EXTI Line 9 input source config bit 5 */
#define AFIO_EXTI_CFG3_EXTI9_6              ((uint32_t)0x00004000U)  /* EXTI Line 9 input source config bit 6 */

#define AFIO_EXTI_CFG3_EXTI10               ((uint32_t)0x007F0000U)  /* EXTI Line 10 input source config bits */
#define AFIO_EXTI_CFG3_EXTI10_0             ((uint32_t)0x00010000U)  /* EXTI Line 10 input source config bit 0 */
#define AFIO_EXTI_CFG3_EXTI10_1             ((uint32_t)0x00020000U)  /* EXTI Line 10 input source config bit 1 */
#define AFIO_EXTI_CFG3_EXTI10_2             ((uint32_t)0x00040000U)  /* EXTI Line 10 input source config bit 2 */
#define AFIO_EXTI_CFG3_EXTI10_3             ((uint32_t)0x00080000U)  /* EXTI Line 10 input source config bit 3 */
#define AFIO_EXTI_CFG3_EXTI10_4             ((uint32_t)0x00100000U)  /* EXTI Line 10 input source config bit 4 */
#define AFIO_EXTI_CFG3_EXTI10_5             ((uint32_t)0x00200000U)  /* EXTI Line 10 input source config bit 5 */
#define AFIO_EXTI_CFG3_EXTI10_6             ((uint32_t)0x00400000U)  /* EXTI Line 10 input source config bit 6 */

#define AFIO_EXTI_CFG3_EXTI11               ((uint32_t)0x7F000000U)  /* EXTI Line 11 input source config bits */
#define AFIO_EXTI_CFG3_EXTI11_0             ((uint32_t)0x01000000U)  /* EXTI Line 11 input source config bit 0 */
#define AFIO_EXTI_CFG3_EXTI11_1             ((uint32_t)0x02000000U)  /* EXTI Line 11 input source config bit 1 */
#define AFIO_EXTI_CFG3_EXTI11_2             ((uint32_t)0x04000000U)  /* EXTI Line 11 input source config bit 2 */
#define AFIO_EXTI_CFG3_EXTI11_3             ((uint32_t)0x08000000U)  /* EXTI Line 11 input source config bit 3 */
#define AFIO_EXTI_CFG3_EXTI11_4             ((uint32_t)0x10000000U)  /* EXTI Line 11 input source config bit 4 */
#define AFIO_EXTI_CFG3_EXTI11_5             ((uint32_t)0x20000000U)  /* EXTI Line 11 input source config bit 5 */
#define AFIO_EXTI_CFG3_EXTI11_6             ((uint32_t)0x40000000U)  /* EXTI Line 11 input source config bit 6 */

/** Bit definition for AFIO_EXTI_CFG4 register **/
#define AFIO_EXTI_CFG4_EXTI12               ((uint32_t)0x0000007FU)  /* EXTI Line 12 input source config bits */
#define AFIO_EXTI_CFG4_EXTI12_0             ((uint32_t)0x00000001U)  /* EXTI Line 12 input source config bit 0 */
#define AFIO_EXTI_CFG4_EXTI12_1             ((uint32_t)0x00000002U)  /* EXTI Line 12 input source config bit 1 */
#define AFIO_EXTI_CFG4_EXTI12_2             ((uint32_t)0x00000004U)  /* EXTI Line 12 input source config bit 2 */
#define AFIO_EXTI_CFG4_EXTI12_3             ((uint32_t)0x00000008U)  /* EXTI Line 12 input source config bit 3 */
#define AFIO_EXTI_CFG4_EXTI12_4             ((uint32_t)0x00000010U)  /* EXTI Line 12 input source config bit 4 */
#define AFIO_EXTI_CFG4_EXTI12_5             ((uint32_t)0x00000020U)  /* EXTI Line 12 input source config bit 5 */
#define AFIO_EXTI_CFG4_EXTI12_6             ((uint32_t)0x00000040U)  /* EXTI Line 12 input source config bit 6 */

#define AFIO_EXTI_CFG4_EXTI13               ((uint32_t)0x00007F00U)  /* EXTI Line 13 input source config bits */
#define AFIO_EXTI_CFG4_EXTI13_0             ((uint32_t)0x00000100U)  /* EXTI Line 13 input source config bit 0 */
#define AFIO_EXTI_CFG4_EXTI13_1             ((uint32_t)0x00000200U)  /* EXTI Line 13 input source config bit 1 */
#define AFIO_EXTI_CFG4_EXTI13_2             ((uint32_t)0x00000400U)  /* EXTI Line 13 input source config bit 2 */
#define AFIO_EXTI_CFG4_EXTI13_3             ((uint32_t)0x00000800U)  /* EXTI Line 13 input source config bit 3 */
#define AFIO_EXTI_CFG4_EXTI13_4             ((uint32_t)0x00001000U)  /* EXTI Line 13 input source config bit 4 */
#define AFIO_EXTI_CFG4_EXTI13_5             ((uint32_t)0x00002000U)  /* EXTI Line 13 input source config bit 5 */
#define AFIO_EXTI_CFG4_EXTI13_6             ((uint32_t)0x00004000U)  /* EXTI Line 13 input source config bit 6 */

#define AFIO_EXTI_CFG4_EXTI14               ((uint32_t)0x007F0000U)  /* EXTI Line 14 input source config bits */
#define AFIO_EXTI_CFG4_EXTI14_0             ((uint32_t)0x00010000U)  /* EXTI Line 14 input source config bit 0 */
#define AFIO_EXTI_CFG4_EXTI14_1             ((uint32_t)0x00020000U)  /* EXTI Line 14 input source config bit 1 */
#define AFIO_EXTI_CFG4_EXTI14_2             ((uint32_t)0x00040000U)  /* EXTI Line 14 input source config bit 2 */
#define AFIO_EXTI_CFG4_EXTI14_3             ((uint32_t)0x00080000U)  /* EXTI Line 14 input source config bit 3 */
#define AFIO_EXTI_CFG4_EXTI14_4             ((uint32_t)0x00100000U)  /* EXTI Line 14 input source config bit 4 */
#define AFIO_EXTI_CFG4_EXTI14_5             ((uint32_t)0x00200000U)  /* EXTI Line 14 input source config bit 5 */
#define AFIO_EXTI_CFG4_EXTI14_6             ((uint32_t)0x00400000U)  /* EXTI Line 14 input source config bit 6 */

#define AFIO_EXTI_CFG4_EXTI15               ((uint32_t)0x7F000000U)  /* EXTI Line 15 input source config bits */
#define AFIO_EXTI_CFG4_EXTI15_0             ((uint32_t)0x01000000U)  /* EXTI Line 15 input source config bit 0 */
#define AFIO_EXTI_CFG4_EXTI15_1             ((uint32_t)0x02000000U)  /* EXTI Line 15 input source config bit 1 */
#define AFIO_EXTI_CFG4_EXTI15_2             ((uint32_t)0x04000000U)  /* EXTI Line 15 input source config bit 2 */
#define AFIO_EXTI_CFG4_EXTI15_3             ((uint32_t)0x08000000U)  /* EXTI Line 15 input source config bit 3 */
#define AFIO_EXTI_CFG4_EXTI15_4             ((uint32_t)0x10000000U)  /* EXTI Line 15 input source config bit 4 */
#define AFIO_EXTI_CFG4_EXTI15_5             ((uint32_t)0x20000000U)  /* EXTI Line 15 input source config bit 5 */
#define AFIO_EXTI_CFG4_EXTI15_6             ((uint32_t)0x40000000U)  /* EXTI Line 15 input source config bit 6 */

/** Bit definition for AFIO_ANAEN_CFG1 register **/
#define AFIO_ANAEN_CFG1_PA0ANAEN            ((uint32_t)0x00000001U)  /* PA0 analog signal channel enable bit */
#define AFIO_ANAEN_CFG1_PA1ANAEN            ((uint32_t)0x00000002U)  /* PA1 analog signal channel enable bit */
#define AFIO_ANAEN_CFG1_PA2ANAEN            ((uint32_t)0x00000004U)  /* PA2 analog signal channel enable bit */
#define AFIO_ANAEN_CFG1_PA3ANAEN            ((uint32_t)0x00000008U)  /* PA3 analog signal channel enable bit */
#define AFIO_ANAEN_CFG1_PA4ANAEN            ((uint32_t)0x00000010U)  /* PA4 analog signal channel enable bit */
#define AFIO_ANAEN_CFG1_PA5ANAEN            ((uint32_t)0x00000020U)  /* PA5 analog signal channel enable bit */
#define AFIO_ANAEN_CFG1_PA6ANAEN            ((uint32_t)0x00000040U)  /* PA6 analog signal channel enable bit */
#define AFIO_ANAEN_CFG1_PA7ANAEN            ((uint32_t)0x00000080U)  /* PA7 analog signal channel enable bit */
#define AFIO_ANAEN_CFG1_PA8ANAEN            ((uint32_t)0x00000100U)  /* PA8 analog signal channel enable bit */
#define AFIO_ANAEN_CFG1_PA9ANAEN            ((uint32_t)0x00000200U)  /* PA9 analog signal channel enable bit */
#define AFIO_ANAEN_CFG1_PA10ANAEN           ((uint32_t)0x00000400U)  /* PA10 analog signal channel enable bit */

#define AFIO_ANAEN_CFG1_PB0ANAEN            ((uint32_t)0x00010000U)  /* PB0 analog signal channel enable bit */
#define AFIO_ANAEN_CFG1_PB1ANAEN            ((uint32_t)0x00020000U)  /* PB1 analog signal channel enable bit */
#define AFIO_ANAEN_CFG1_PB2ANAEN            ((uint32_t)0x00040000U)  /* PB2 analog signal channel enable bit */
#define AFIO_ANAEN_CFG1_PB10ANAEN           ((uint32_t)0x04000000U)  /* PB10 analog signal channel enable bit */
#define AFIO_ANAEN_CFG1_PB11ANAEN           ((uint32_t)0x08000000U)  /* PB11 analog signal channel enable bit */
#define AFIO_ANAEN_CFG1_PB12ANAEN           ((uint32_t)0x10000000U)  /* PB12 analog signal channel enable bit */
#define AFIO_ANAEN_CFG1_PB13ANAEN           ((uint32_t)0x20000000U)  /* PB13 analog signal channel enable bit */
#define AFIO_ANAEN_CFG1_PB14ANAEN           ((uint32_t)0x40000000U)  /* PB14 analog signal channel enable bit */
#define AFIO_ANAEN_CFG1_PB15ANAEN           ((uint32_t)0x80000000U)  /* PB15 analog signal channel enable bit */

/** Bit definition for AFIO_ANAEN_CFG2 register **/
#define AFIO_ANAEN_CFG2_PC0ANAEN            ((uint32_t)0x00000001U)  /* PC0 analog signal channel enable bit */
#define AFIO_ANAEN_CFG2_PC1ANAEN            ((uint32_t)0x00000002U)  /* PC1 analog signal channel enable bit */
#define AFIO_ANAEN_CFG2_PC2ANAEN            ((uint32_t)0x00000004U)  /* PC2 analog signal channel enable bit */
#define AFIO_ANAEN_CFG2_PC3ANAEN            ((uint32_t)0x00000008U)  /* PC3 analog signal channel enable bit */
#define AFIO_ANAEN_CFG2_PC4ANAEN            ((uint32_t)0x00000010U)  /* PC4 analog signal channel enable bit */
#define AFIO_ANAEN_CFG2_PC5ANAEN            ((uint32_t)0x00000020U)  /* PC5 analog signal channel enable bit */
#define AFIO_ANAEN_CFG2_PC9ANAEN            ((uint32_t)0x00000200U)  /* PC9 analog signal channel enable bit */

#define AFIO_ANAEN_CFG2_PD8ANAEN            ((uint32_t)0x01000000U)  /* PD8 analog signal channel enable bit */
#define AFIO_ANAEN_CFG2_PD9ANAEN            ((uint32_t)0x02000000U)  /* PD9 analog signal channel enable bit */
#define AFIO_ANAEN_CFG2_PD10ANAEN           ((uint32_t)0x04000000U)  /* PD10 analog signal channel enable bit */
#define AFIO_ANAEN_CFG2_PD11ANAEN           ((uint32_t)0x08000000U)  /* PD11 analog signal channel enable bit */
#define AFIO_ANAEN_CFG2_PD12ANAEN           ((uint32_t)0x10000000U)  /* PD12 analog signal channel enable bit */
#define AFIO_ANAEN_CFG2_PD13ANAEN           ((uint32_t)0x20000000U)  /* PD13 analog signal channel enable bit */
#define AFIO_ANAEN_CFG2_PD14ANAEN           ((uint32_t)0x40000000U)  /* PD14 analog signal channel enable bit */
#define AFIO_ANAEN_CFG2_PD15ANAEN           ((uint32_t)0x80000000U)  /* PD15 analog signal channel enable bit */

/** Bit definition for AFIO_ANAEN_CFG3 register **/
#define AFIO_ANAEN_CFG3_PE6ANAEN            ((uint32_t)0x00000040U)  /* PE6 analog signal channel enable bit */
#define AFIO_ANAEN_CFG3_PE7ANAEN            ((uint32_t)0x00000080U)  /* PE7 analog signal channel enable bit */
#define AFIO_ANAEN_CFG3_PE8ANAEN            ((uint32_t)0x00000100U)  /* PE8 analog signal channel enable bit */
#define AFIO_ANAEN_CFG3_PE9ANAEN            ((uint32_t)0x00000200U)  /* PE9 analog signal channel enable bit */
#define AFIO_ANAEN_CFG3_PE10ANAEN           ((uint32_t)0x00000400U)  /* PE10 analog signal channel enable bit */
#define AFIO_ANAEN_CFG3_PE11ANAEN           ((uint32_t)0x00000800U)  /* PE11 analog signal channel enable bit */
#define AFIO_ANAEN_CFG3_PE12ANAEN           ((uint32_t)0x00001000U)  /* PE12 analog signal channel enable bit */
#define AFIO_ANAEN_CFG3_PE13ANAEN           ((uint32_t)0x00002000U)  /* PE13 analog signal channel enable bit */
#define AFIO_ANAEN_CFG3_PE14ANAEN           ((uint32_t)0x00004000U)  /* PE14 analog signal channel enable bit */
#define AFIO_ANAEN_CFG3_PE15ANAEN           ((uint32_t)0x00008000U)  /* PE15 analog signal channel enable bit */

#define AFIO_ANAEN_CFG3_PF2ANAEN            ((uint32_t)0x00040000U)  /* PF2 analog signal channel enable bit */
#define AFIO_ANAEN_CFG3_PF3ANAEN            ((uint32_t)0x00080000U)  /* PF3 analog signal channel enable bit */
#define AFIO_ANAEN_CFG3_PF4ANAEN            ((uint32_t)0x00100000U)  /* PF4 analog signal channel enable bit */
#define AFIO_ANAEN_CFG3_PF5ANAEN            ((uint32_t)0x00200000U)  /* PF5 analog signal channel enable bit */
#define AFIO_ANAEN_CFG3_PF6ANAEN            ((uint32_t)0x00400000U)  /* PF6 analog signal channel enable bit */
#define AFIO_ANAEN_CFG3_PF7ANAEN            ((uint32_t)0x00800000U)  /* PF7 analog signal channel enable bit */
#define AFIO_ANAEN_CFG3_PF8ANAEN            ((uint32_t)0x01000000U)  /* PF8 analog signal channel enable bit */
#define AFIO_ANAEN_CFG3_PF9ANAEN            ((uint32_t)0x02000000U)  /* PF9 analog signal channel enable bit */
#define AFIO_ANAEN_CFG3_PF10ANAEN           ((uint32_t)0x04000000U)  /* PF10 analog signal channel enable bit */

/** Bit definition for AFIO_ANAEN_CFG4 register **/
#define AFIO_ANAEN_CFG3_PH0ANAEN            ((uint32_t)0x00000001U)  /* PH0 analog signal channel enable bit */
#define AFIO_ANAEN_CFG3_PH1ANAEN            ((uint32_t)0x00000002U)  /* PH1 analog signal channel enable bit */
#define AFIO_ANAEN_CFG3_PH6ANAEN            ((uint32_t)0x00000040U)  /* PH6 analog signal channel enable bit */

/** Bit definition for AFIO_FILTER_CFG1 register **/
#define AFIO_FILTER_CFG1_PA_FILTER          ((uint32_t)0x0000FFFFU)  /* PA port Digital filter enable bit */
#define AFIO_FILTER_CFG1_PA_FILTER_0        ((uint32_t)0x00000001U)  /* PA0 Digital filter enable bit  */
#define AFIO_FILTER_CFG1_PA_FILTER_1        ((uint32_t)0x00000002U)  /* PA1 Digital filter enable bit  */
#define AFIO_FILTER_CFG1_PA_FILTER_2        ((uint32_t)0x00000004U)  /* PA2 Digital filter enable bit  */
#define AFIO_FILTER_CFG1_PA_FILTER_3        ((uint32_t)0x00000008U)  /* PA3 Digital filter enable bit  */
#define AFIO_FILTER_CFG1_PA_FILTER_4        ((uint32_t)0x00000010U)  /* PA4 Digital filter enable bit  */
#define AFIO_FILTER_CFG1_PA_FILTER_5        ((uint32_t)0x00000020U)  /* PA5 Digital filter enable bit  */
#define AFIO_FILTER_CFG1_PA_FILTER_6        ((uint32_t)0x00000040U)  /* PA6 Digital filter enable bit  */
#define AFIO_FILTER_CFG1_PA_FILTER_7        ((uint32_t)0x00000080U)  /* PA7 Digital filter enable bit  */
#define AFIO_FILTER_CFG1_PA_FILTER_8        ((uint32_t)0x00000100U)  /* PA8 Digital filter enable bit  */
#define AFIO_FILTER_CFG1_PA_FILTER_9        ((uint32_t)0x00000200U)  /* PA9 Digital filter enable bit  */
#define AFIO_FILTER_CFG1_PA_EILFTR_10       ((uint32_t)0x00000400U)  /* PA10 Digital filter enable bit */
#define AFIO_FILTER_CFG1_PA_EILFTR_11       ((uint32_t)0x00000800U)  /* PA11 Digital filter enable bit */
#define AFIO_FILTER_CFG1_PA_EILFTR_12       ((uint32_t)0x00001000U)  /* PA12 Digital filter enable bit */
#define AFIO_FILTER_CFG1_PA_EILFTR_13       ((uint32_t)0x00002000U)  /* PA13 Digital filter enable bit */
#define AFIO_FILTER_CFG1_PA_EILFTR_14       ((uint32_t)0x00004000U)  /* PA14 Digital filter enable bit */
#define AFIO_FILTER_CFG1_PA_EILFTR_15       ((uint32_t)0x00008000U)  /* PA15 Digital filter enable bit */

#define AFIO_FILTER_CFG1_PB_FILTER          ((uint32_t)0xFFFF0000U)  /* PB port Digital filter enable bit */
#define AFIO_FILTER_CFG1_PB_FILTER_0        ((uint32_t)0x00010000U)  /* PB0 Digital filter enable bit */
#define AFIO_FILTER_CFG1_PB_FILTER_1        ((uint32_t)0x00020000U)  /* PB1 Digital filter enable bit */
#define AFIO_FILTER_CFG1_PB_FILTER_2        ((uint32_t)0x00040000U)  /* PB2 Digital filter enable bit */
#define AFIO_FILTER_CFG1_PB_FILTER_3        ((uint32_t)0x00080000U)  /* PB3 Digital filter enable bit */
#define AFIO_FILTER_CFG1_PB_FILTER_4        ((uint32_t)0x00100000U)  /* PB4 Digital filter enable bit */
#define AFIO_FILTER_CFG1_PB_FILTER_5        ((uint32_t)0x00200000U)  /* PB5 Digital filter enable bit */
#define AFIO_FILTER_CFG1_PB_FILTER_6        ((uint32_t)0x00400000U)  /* PB6 Digital filter enable bit */
#define AFIO_FILTER_CFG1_PB_FILTER_7        ((uint32_t)0x00800000U)  /* PB7 Digital filter enable bit */
#define AFIO_FILTER_CFG1_PB_FILTER_8        ((uint32_t)0x01000000U)  /* PB8 Digital filter enable bit */
#define AFIO_FILTER_CFG1_PB_FILTER_9        ((uint32_t)0x02000000U)  /* PB9 Digital filter enable bit */
#define AFIO_FILTER_CFG1_PB_FILTER_10       ((uint32_t)0x04000000U)  /* PB10 Digital filter enable bit */
#define AFIO_FILTER_CFG1_PB_FILTER_11       ((uint32_t)0x08000000U)  /* PB11 Digital filter enable bit */
#define AFIO_FILTER_CFG1_PB_FILTER_12       ((uint32_t)0x10000000U)  /* PB12 Digital filter enable bit */
#define AFIO_FILTER_CFG1_PB_FILTER_13       ((uint32_t)0x20000000U)  /* PB13 Digital filter enable bit */
#define AFIO_FILTER_CFG1_PB_FILTER_14       ((uint32_t)0x40000000U)  /* PB14 Digital filter enable bit */
#define AFIO_FILTER_CFG1_PB_FILTER_15       ((uint32_t)0x80000000U)  /* PB15 Digital filter enable bit */

/** Bit definition for AFIO_FILTER_CFG2 register **/
#define AFIO_FILTER_CFG2_PC_FILTER          ((uint32_t)0x0000FFFFU)  /* PC port Digital filter enable bit */
#define AFIO_FILTER_CFG2_PC_FILTER_0        ((uint32_t)0x00000001U)  /* PC0 Digital filter enable bit */
#define AFIO_FILTER_CFG2_PC_FILTER_1        ((uint32_t)0x00000002U)  /* PC1 Digital filter enable bit */
#define AFIO_FILTER_CFG2_PC_FILTER_2        ((uint32_t)0x00000004U)  /* PC2 Digital filter enable bit */
#define AFIO_FILTER_CFG2_PC_FILTER_3        ((uint32_t)0x00000008U)  /* PC3 Digital filter enable bit */
#define AFIO_FILTER_CFG2_PC_FILTER_4        ((uint32_t)0x00000010U)  /* PC4 Digital filter enable bit */
#define AFIO_FILTER_CFG2_PC_FILTER_5        ((uint32_t)0x00000020U)  /* PC5 Digital filter enable bit */
#define AFIO_FILTER_CFG2_PC_FILTER_6        ((uint32_t)0x00000040U)  /* PC6 Digital filter enable bit */
#define AFIO_FILTER_CFG2_PC_FILTER_7        ((uint32_t)0x00000080U)  /* PC7 Digital filter enable bit */
#define AFIO_FILTER_CFG2_PC_FILTER_8        ((uint32_t)0x00000100U)  /* PC8 Digital filter enable bit */
#define AFIO_FILTER_CFG2_PC_FILTER_9        ((uint32_t)0x00000200U)  /* PC9 Digital filter enable bit */
#define AFIO_FILTER_CFG2_PC_FILTER_10       ((uint32_t)0x00000400U)  /* PC10 Digital filter enable bit */
#define AFIO_FILTER_CFG2_PC_FILTER_11       ((uint32_t)0x00000800U)  /* PC11 Digital filter enable bit */
#define AFIO_FILTER_CFG2_PC_FILTER_12       ((uint32_t)0x00001000U)  /* PC12 Digital filter enable bit */
#define AFIO_FILTER_CFG2_PC_FILTER_13       ((uint32_t)0x00002000U)  /* PC13 Digital filter enable bit */
#define AFIO_FILTER_CFG2_PC_FILTER_14       ((uint32_t)0x00004000U)  /* PC14 Digital filter enable bit */
#define AFIO_FILTER_CFG2_PC_FILTER_15       ((uint32_t)0x00008000U)  /* PC15 Digital filter enable bit */

#define AFIO_FILTER_CFG2_PD_FILTER          ((uint32_t)0xFFFF0000U)  /* PD port Digital filter enable bit */
#define AFIO_FILTER_CFG2_PD_FILTER_0        ((uint32_t)0x00010000U)  /* PD0 Digital filter enable bit */
#define AFIO_FILTER_CFG2_PD_FILTER_1        ((uint32_t)0x00020000U)  /* PD1 Digital filter enable bit */
#define AFIO_FILTER_CFG2_PD_FILTER_2        ((uint32_t)0x00040000U)  /* PD2 Digital filter enable bit */
#define AFIO_FILTER_CFG2_PD_FILTER_3        ((uint32_t)0x00080000U)  /* PD3 Digital filter enable bit */
#define AFIO_FILTER_CFG2_PD_FILTER_4        ((uint32_t)0x00100000U)  /* PD4 Digital filter enable bit */
#define AFIO_FILTER_CFG2_PD_FILTER_5        ((uint32_t)0x00200000U)  /* PD5 Digital filter enable bit */
#define AFIO_FILTER_CFG2_PD_FILTER_6        ((uint32_t)0x00400000U)  /* PD6 Digital filter enable bit */
#define AFIO_FILTER_CFG2_PD_FILTER_7        ((uint32_t)0x00800000U)  /* PD7 Digital filter enable bit */
#define AFIO_FILTER_CFG2_PD_FILTER_8        ((uint32_t)0x01000000U)  /* PD8 Digital filter enable bit */
#define AFIO_FILTER_CFG2_PD_FILTER_9        ((uint32_t)0x02000000U)  /* PD9 Digital filter enable bit */
#define AFIO_FILTER_CFG2_PD_FILTER_10       ((uint32_t)0x04000000U)  /* PD10 Digital filter enable bit */
#define AFIO_FILTER_CFG2_PD_FILTER_11       ((uint32_t)0x08000000U)  /* PD11 Digital filter enable bit */
#define AFIO_FILTER_CFG2_PD_FILTER_12       ((uint32_t)0x10000000U)  /* PD12 Digital filter enable bit */
#define AFIO_FILTER_CFG2_PD_FILTER_13       ((uint32_t)0x20000000U)  /* PD13 Digital filter enable bit */
#define AFIO_FILTER_CFG2_PD_FILTER_14       ((uint32_t)0x40000000U)  /* PD14 Digital filter enable bit */
#define AFIO_FILTER_CFG2_PD_FILTER_15       ((uint32_t)0x80000000U)  /* PD15 Digital filter enable bit */


/** Bit definition for AFIO_FILTER_CFG3 register **/
#define AFIO_FILTER_CFG3_PE_FILTER          ((uint32_t)0x0000FFFFU)  /* PE port Digital filter enable bit */
#define AFIO_FILTER_CFG3_PE_FILTER_0        ((uint32_t)0x00000001U)  /* PE0 Digital filter enable bit */
#define AFIO_FILTER_CFG3_PE_FILTER_1        ((uint32_t)0x00000002U)  /* PE1 Digital filter enable bit */
#define AFIO_FILTER_CFG3_PE_FILTER_2        ((uint32_t)0x00000004U)  /* PE2 Digital filter enable bit */
#define AFIO_FILTER_CFG3_PE_FILTER_3        ((uint32_t)0x00000008U)  /* PE3 Digital filter enable bit */
#define AFIO_FILTER_CFG3_PE_FILTER_4        ((uint32_t)0x00000010U)  /* PE4 Digital filter enable bit */
#define AFIO_FILTER_CFG3_PE_FILTER_5        ((uint32_t)0x00000020U)  /* PE5 Digital filter enable bit */
#define AFIO_FILTER_CFG3_PE_FILTER_6        ((uint32_t)0x00000040U)  /* PE6 Digital filter enable bit */
#define AFIO_FILTER_CFG3_PE_FILTER_7        ((uint32_t)0x00000080U)  /* PE7 Digital filter enable bit */
#define AFIO_FILTER_CFG3_PE_FILTER_8        ((uint32_t)0x00000100U)  /* PE8 Digital filter enable bit */
#define AFIO_FILTER_CFG3_PE_FILTER_9        ((uint32_t)0x00000200U)  /* PE9 Digital filter enable bit */
#define AFIO_FILTER_CFG3_PE_FILTER_10       ((uint32_t)0x00000400U)  /* PE10 Digital filter enable bit */
#define AFIO_FILTER_CFG3_PE_FILTER_11       ((uint32_t)0x00000800U)  /* PE11 Digital filter enable bit */
#define AFIO_FILTER_CFG3_PE_FILTER_12       ((uint32_t)0x00001000U)  /* PE12 Digital filter enable bit */
#define AFIO_FILTER_CFG3_PE_FILTER_13       ((uint32_t)0x00002000U)  /* PE13 Digital filter enable bit */
#define AFIO_FILTER_CFG3_PE_FILTER_14       ((uint32_t)0x00004000U)  /* PE14 Digital filter enable bit */
#define AFIO_FILTER_CFG3_PE_FILTER_15       ((uint32_t)0x00008000U)  /* PE15 Digital filter enable bit */

#define AFIO_FILTER_CFG3_PF_FILTER          ((uint32_t)0xFFFF0000U)  /* PF port Digital filter enable bit */
#define AFIO_FILTER_CFG3_PF_FILTER_0        ((uint32_t)0x00010000U)  /* PF0 Digital filter enable bit */
#define AFIO_FILTER_CFG3_PF_FILTER_1        ((uint32_t)0x00020000U)  /* PF1 Digital filter enable bit */
#define AFIO_FILTER_CFG3_PF_FILTER_2        ((uint32_t)0x00040000U)  /* PF2 Digital filter enable bit */
#define AFIO_FILTER_CFG3_PF_FILTER_3        ((uint32_t)0x00080000U)  /* PF3 Digital filter enable bit */
#define AFIO_FILTER_CFG3_PF_FILTER_4        ((uint32_t)0x00100000U)  /* PF4 Digital filter enable bit */
#define AFIO_FILTER_CFG3_PF_FILTER_5        ((uint32_t)0x00200000U)  /* PF5 Digital filter enable bit */
#define AFIO_FILTER_CFG3_PF_FILTER_6        ((uint32_t)0x00400000U)  /* PF6 Digital filter enable bit */
#define AFIO_FILTER_CFG3_PF_FILTER_7        ((uint32_t)0x00800000U)  /* PF7 Digital filter enable bit */
#define AFIO_FILTER_CFG3_PF_FILTER_8        ((uint32_t)0x01000000U)  /* PF8 Digital filter enable bit */
#define AFIO_FILTER_CFG3_PF_FILTER_9        ((uint32_t)0x02000000U)  /* PF9 Digital filter enable bit */
#define AFIO_FILTER_CFG3_PF_FILTER_10       ((uint32_t)0x04000000U)  /* PF10 Digital filter enable bit */
#define AFIO_FILTER_CFG3_PF_FILTER_11       ((uint32_t)0x08000000U)  /* PF11 Digital filter enable bit */
#define AFIO_FILTER_CFG3_PF_FILTER_12       ((uint32_t)0x10000000U)  /* PF12 Digital filter enable bit */
#define AFIO_FILTER_CFG3_PF_FILTER_13       ((uint32_t)0x20000000U)  /* PF13 Digital filter enable bit */
#define AFIO_FILTER_CFG3_PF_FILTER_14       ((uint32_t)0x40000000U)  /* PF14 Digital filter enable bit */
#define AFIO_FILTER_CFG3_PF_FILTER_15       ((uint32_t)0x80000000U)  /* PF15 Digital filter enable bit */

/** Bit definition for AFIO_FILTER_CFG4 register **/
#define AFIO_FILTER_CFG4_PG_FILTER          ((uint32_t)0x0000FFFFU)  /* PG port Digital filter enable bit */
#define AFIO_FILTER_CFG4_PG_FILTER_0        ((uint32_t)0x00000001U)  /* PG0 Digital filter enable bit */
#define AFIO_FILTER_CFG4_PG_FILTER_1        ((uint32_t)0x00000002U)  /* PG1 Digital filter enable bit */
#define AFIO_FILTER_CFG4_PG_FILTER_2        ((uint32_t)0x00000004U)  /* PG2 Digital filter enable bit */
#define AFIO_FILTER_CFG4_PG_FILTER_3        ((uint32_t)0x00000008U)  /* PG3 Digital filter enable bit */
#define AFIO_FILTER_CFG4_PG_FILTER_4        ((uint32_t)0x00000010U)  /* PG4 Digital filter enable bit */
#define AFIO_FILTER_CFG4_PG_FILTER_5        ((uint32_t)0x00000020U)  /* PG5 Digital filter enable bit */
#define AFIO_FILTER_CFG4_PG_FILTER_6        ((uint32_t)0x00000040U)  /* PG6 Digital filter enable bit */
#define AFIO_FILTER_CFG4_PG_FILTER_7        ((uint32_t)0x00000080U)  /* PG7 Digital filter enable bit */
#define AFIO_FILTER_CFG4_PG_FILTER_8        ((uint32_t)0x00000100U)  /* PG8 Digital filter enable bit */
#define AFIO_FILTER_CFG4_PG_FILTER_9        ((uint32_t)0x00000200U)  /* PG9 Digital filter enable bit */
#define AFIO_FILTER_CFG4_PG_FILTER_10       ((uint32_t)0x00000400U)  /* PG10 Digital filter enable bit */
#define AFIO_FILTER_CFG4_PG_FILTER_11       ((uint32_t)0x00000800U)  /* PG11 Digital filter enable bit */
#define AFIO_FILTER_CFG4_PG_FILTER_12       ((uint32_t)0x00001000U)  /* PG12 Digital filter enable bit */
#define AFIO_FILTER_CFG4_PG_FILTER_13       ((uint32_t)0x00002000U)  /* PG13 Digital filter enable bit */
#define AFIO_FILTER_CFG4_PG_FILTER_14       ((uint32_t)0x00004000U)  /* PG14 Digital filter enable bit */
#define AFIO_FILTER_CFG4_PG_FILTER_15       ((uint32_t)0x00008000U)  /* PG15 Digital filter enable bit */

#define AFIO_FILTER_CFG4_PH_FILTER          ((uint32_t)0x007F0000U)  /* PH port Digital filter enable bit */
#define AFIO_FILTER_CFG4_PH_FILTER_0        ((uint32_t)0x00010000U)  /* PH0 Digital filter enable bit */
#define AFIO_FILTER_CFG4_PH_FILTER_1        ((uint32_t)0x00020000U)  /* PH1 Digital filter enable bit */
#define AFIO_FILTER_CFG4_PH_FILTER_2        ((uint32_t)0x00040000U)  /* PH2 Digital filter enable bit */
#define AFIO_FILTER_CFG4_PH_FILTER_3        ((uint32_t)0x00080000U)  /* PH3 Digital filter enable bit */
#define AFIO_FILTER_CFG4_PH_FILTER_4        ((uint32_t)0x00100000U)  /* PH4 Digital filter enable bit */
#define AFIO_FILTER_CFG4_PH_FILTER_5        ((uint32_t)0x00200000U)  /* PH5 Digital filter enable bit */
#define AFIO_FILTER_CFG4_PH_FILTER_6        ((uint32_t)0x00400000U)  /* PH6 Digital filter enable bit */

/** Bit definition for AFIO_EMC_CFG register **/
#define AFIO_EMC_CFG_CLAMP1_RST             ((uint32_t)0x00000001U)  /* EMC CLAMP1 reset enable bit */
#define AFIO_EMC_CFG_CLAMP2_RST             ((uint32_t)0x00000002U)  /* EMC CLAMP2 reset enable bit */
#define AFIO_EMC_CFG_CLAMP3_RST             ((uint32_t)0x00000004U)  /* EMC CLAMP3 reset enable bit */
#define AFIO_EMC_CFG_CLAMP4_RST             ((uint32_t)0x00000008U)  /* EMC CLAMP4 reset enable bit */

#define AFIO_EMC_CFG_GBN1_RST               ((uint32_t)0x00000010U)  /* EMC GBN1 reset enable bit */
#define AFIO_EMC_CFG_GBN2_RST               ((uint32_t)0x00000020U)  /* EMC GBN2 reset enable bit */
#define AFIO_EMC_CFG_GBN3_RST               ((uint32_t)0x00000040U)  /* EMC GBN3 reset enable bit */
#define AFIO_EMC_CFG_GBN4_RST               ((uint32_t)0x00000080U)  /* EMC GBN4 reset enable bit */

#define AFIO_EMC_CFG_GB1_RST                ((uint32_t)0x00000100U)  /* EMC GB1 reset enable bit */
#define AFIO_EMC_CFG_GB2_RST                ((uint32_t)0x00000200U)  /* EMC GB2 reset enable bit */
#define AFIO_EMC_CFG_GB3_RST                ((uint32_t)0x00000400U)  /* EMC GB3 reset enable bit */
#define AFIO_EMC_CFG_GB4_RST                ((uint32_t)0x00000800U)  /* EMC GB4 reset enable bit */

#define AFIO_EMC_CFG_CLAMP1_DET             ((uint32_t)0x00001000U)  /* EMC CLAMP1 detect enable bit */
#define AFIO_EMC_CFG_CLAMP2_DET             ((uint32_t)0x00002000U)  /* EMC CLAMP2 detect enable bit */
#define AFIO_EMC_CFG_CLAMP3_DET             ((uint32_t)0x00004000U)  /* EMC CLAMP3 detect enable bit */
#define AFIO_EMC_CFG_CLAMP4_DET             ((uint32_t)0x00008000U)  /* EMC CLAMP4 detect enable bit */

#define AFIO_EMC_CFG_GBN1_DET               ((uint32_t)0x00010000U)  /* EMC GBN1 detect enable bit */
#define AFIO_EMC_CFG_GBN2_DET               ((uint32_t)0x00020000U)  /* EMC GBN2 detect enable bit */
#define AFIO_EMC_CFG_GBN3_DET               ((uint32_t)0x00040000U)  /* EMC GBN3 detect enable bit */
#define AFIO_EMC_CFG_GBN4_DET               ((uint32_t)0x00080000U)  /* EMC GBN4 detect enable bit */

#define AFIO_EMC_CFG_GB1_DET                ((uint32_t)0x00100000U)  /* EMC GB1 detect enable bit */
#define AFIO_EMC_CFG_GB2_DET                ((uint32_t)0x00200000U)  /* EMC GB2 detect enable bit */
#define AFIO_EMC_CFG_GB3_DET                ((uint32_t)0x00400000U)  /* EMC GB3 detect enable bit */
#define AFIO_EMC_CFG_GB4_DET                ((uint32_t)0x00800000U)  /* EMC GB4 detect enable bit */

#define AFIO_EMC_CFG_XSPI_RXDS              ((uint32_t)0x03000000U)  /* xSPI RXDS signal sample delay time config bits */
#define AFIO_EMC_CFG_XSPI_RXDS_0            ((uint32_t)0x01000000U)  /* xSPI RXDS signal sample delay time config bit 0 */
#define AFIO_EMC_CFG_XSPI_RXDS_1            ((uint32_t)0x02000000U)  /* xSPI RXDS signal sample delay time config bit 1 */

#define AFIO_EMC_CFG_XSPI_WR_BE             ((uint32_t)0x04000000U)  /* xSPI big-endian enable bit for writting in non-xip mode */
#define AFIO_EMC_CFG_XSPI_RD_BE             ((uint32_t)0x08000000U)  /* xSPI big-endian enable bit for reading in non-xip mode */

#define AFIO_EMC_CFG_XSPI_EXTEND            ((uint32_t)0x30000000U)  /* xSPI setup time and hold time extension config bits */
#define AFIO_EMC_CFG_XSPI_EXTEND_0          ((uint32_t)0x10000000U)  /* xSPI setup time and hold time extension config bit 0 */
#define AFIO_EMC_CFG_XSPI_EXTEND_1          ((uint32_t)0x20000000U)  /* xSPI setup time and hold time extension config bit 1 */

/** Bit definition for AFIO_EMC_CNT register **/
#define AFIO_EMC_CNT_EMC_CNT                ((uint32_t)0x000003FFU)  /* EMC Counter bits */

#define AFIO_EMC_CNT_XSPI_NSS_HIGH          ((uint32_t)0x00003C00U)  /* xSPI NSS invalid(high level) time before two transfer frame */
#define AFIO_EMC_CNT_XSPI_NSS_HIGH_0        ((uint32_t)0x00000400U)  /* xSPI NSS invalid(high level) time bit 0 */
#define AFIO_EMC_CNT_XSPI_NSS_HIGH_1        ((uint32_t)0x00000800U)  /* xSPI NSS invalid(high level) time bit 1 */
#define AFIO_EMC_CNT_XSPI_NSS_HIGH_2        ((uint32_t)0x00001000U)  /* xSPI NSS invalid(high level) time bit 2 */
#define AFIO_EMC_CNT_XSPI_NSS_HIGH_3        ((uint32_t)0x00002000U)  /* xSPI NSS invalid(high level) time bit 3 */

#define AFIO_EMC_CNT_PC_RD_DELAY_EN         ((uint32_t)0x00004000U)  /* GPIOC register back to back read delay enable bit */

/** Bit definition for AFIO_SHRT_EXEV_CFG1 register **/
#define AFIO_SHRT_EXEV_CFG1_SHRT1_EXEV1       ((uint32_t)0x0000007FU)  /* SHRT1_EXEV1 input source select bits */
#define AFIO_SHRT_EXEV_CFG1_SHRT1_EXEV1_0     ((uint32_t)0x00000001U)  /* SHRT1_EXEV1 input source select bit 0 */
#define AFIO_SHRT_EXEV_CFG1_SHRT1_EXEV1_1     ((uint32_t)0x00000002U)  /* SHRT1_EXEV1 input source select bit 1 */
#define AFIO_SHRT_EXEV_CFG1_SHRT1_EXEV1_2     ((uint32_t)0x00000004U)  /* SHRT1_EXEV1 input source select bit 2 */
#define AFIO_SHRT_EXEV_CFG1_SHRT1_EXEV1_3     ((uint32_t)0x00000008U)  /* SHRT1_EXEV1 input source select bit 3 */
#define AFIO_SHRT_EXEV_CFG1_SHRT1_EXEV1_4     ((uint32_t)0x00000010U)  /* SHRT1_EXEV1 input source select bit 4 */
#define AFIO_SHRT_EXEV_CFG1_SHRT1_EXEV1_5     ((uint32_t)0x00000020U)  /* SHRT1_EXEV1 input source select bit 5 */
#define AFIO_SHRT_EXEV_CFG1_SHRT1_EXEV1_6     ((uint32_t)0x00000040U)  /* SHRT1_EXEV1 input source select bit 6 */

#define AFIO_SHRT_EXEV_CFG1_SHRT1_EXEV2       ((uint32_t)0x00007F00U)  /* SHRT1_EXEV2 input source select bits */
#define AFIO_SHRT_EXEV_CFG1_SHRT1_EXEV2_0     ((uint32_t)0x00000100U)  /* SHRT1_EXEV2 input source select bit 0 */
#define AFIO_SHRT_EXEV_CFG1_SHRT1_EXEV2_1     ((uint32_t)0x00000200U)  /* SHRT1_EXEV2 input source select bit 1 */
#define AFIO_SHRT_EXEV_CFG1_SHRT1_EXEV2_2     ((uint32_t)0x00000400U)  /* SHRT1_EXEV2 input source select bit 2 */
#define AFIO_SHRT_EXEV_CFG1_SHRT1_EXEV2_3     ((uint32_t)0x00000800U)  /* SHRT1_EXEV2 input source select bit 3 */
#define AFIO_SHRT_EXEV_CFG1_SHRT1_EXEV2_4     ((uint32_t)0x00001000U)  /* SHRT1_EXEV2 input source select bit 4 */
#define AFIO_SHRT_EXEV_CFG1_SHRT1_EXEV2_5     ((uint32_t)0x00002000U)  /* SHRT1_EXEV2 input source select bit 5 */
#define AFIO_SHRT_EXEV_CFG1_SHRT1_EXEV2_6     ((uint32_t)0x00004000U)  /* SHRT1_EXEV2 input source select bit 6 */

#define AFIO_SHRT_EXEV_CFG1_SHRT1_EXEV3       ((uint32_t)0x007F0000U)  /* SHRT1_EXEV3 input source select bits */
#define AFIO_SHRT_EXEV_CFG1_SHRT1_EXEV3_0     ((uint32_t)0x00010000U)  /* SHRT1_EXEV3 input source select bit 0 */
#define AFIO_SHRT_EXEV_CFG1_SHRT1_EXEV3_1     ((uint32_t)0x00020000U)  /* SHRT1_EXEV3 input source select bit 1 */
#define AFIO_SHRT_EXEV_CFG1_SHRT1_EXEV3_2     ((uint32_t)0x00040000U)  /* SHRT1_EXEV3 input source select bit 2 */
#define AFIO_SHRT_EXEV_CFG1_SHRT1_EXEV3_3     ((uint32_t)0x00080000U)  /* SHRT1_EXEV3 input source select bit 3 */
#define AFIO_SHRT_EXEV_CFG1_SHRT1_EXEV3_4     ((uint32_t)0x00100000U)  /* SHRT1_EXEV3 input source select bit 4 */
#define AFIO_SHRT_EXEV_CFG1_SHRT1_EXEV3_5     ((uint32_t)0x00200000U)  /* SHRT1_EXEV3 input source select bit 5 */
#define AFIO_SHRT_EXEV_CFG1_SHRT1_EXEV3_6     ((uint32_t)0x00400000U)  /* SHRT1_EXEV3 input source select bit 6 */

#define AFIO_SHRT_EXEV_CFG1_SHRT1_EXEV4       ((uint32_t)0x7F000000U)  /* SHRT1_EXEV4 input source select bits */
#define AFIO_SHRT_EXEV_CFG1_SHRT1_EXEV4_0     ((uint32_t)0x01000000U)  /* SHRT1_EXEV4 input source select bit 0 */
#define AFIO_SHRT_EXEV_CFG1_SHRT1_EXEV4_1     ((uint32_t)0x02000000U)  /* SHRT1_EXEV4 input source select bit 1 */
#define AFIO_SHRT_EXEV_CFG1_SHRT1_EXEV4_2     ((uint32_t)0x04000000U)  /* SHRT1_EXEV4 input source select bit 2 */
#define AFIO_SHRT_EXEV_CFG1_SHRT1_EXEV4_3     ((uint32_t)0x08000000U)  /* SHRT1_EXEV4 input source select bit 3 */
#define AFIO_SHRT_EXEV_CFG1_SHRT1_EXEV4_4     ((uint32_t)0x10000000U)  /* SHRT1_EXEV4 input source select bit 4 */
#define AFIO_SHRT_EXEV_CFG1_SHRT1_EXEV4_5     ((uint32_t)0x20000000U)  /* SHRT1_EXEV4 input source select bit 5 */
#define AFIO_SHRT_EXEV_CFG1_SHRT1_EXEV4_6     ((uint32_t)0x40000000U)  /* SHRT1_EXEV4 input source select bit 6 */

/** Bit definition for AFIO_SHRT_EXEV_CFG2 register **/
#define AFIO_SHRT_EXEV_CFG2_SHRT1_EXEV5       ((uint32_t)0x0000007FU)  /* SHRT1_EXEV5 input source select bits */
#define AFIO_SHRT_EXEV_CFG2_SHRT1_EXEV5_0     ((uint32_t)0x00000001U)  /* SHRT1_EXEV5 input source select bit 0 */
#define AFIO_SHRT_EXEV_CFG2_SHRT1_EXEV5_1     ((uint32_t)0x00000002U)  /* SHRT1_EXEV5 input source select bit 1 */
#define AFIO_SHRT_EXEV_CFG2_SHRT1_EXEV5_2     ((uint32_t)0x00000004U)  /* SHRT1_EXEV5 input source select bit 2 */
#define AFIO_SHRT_EXEV_CFG2_SHRT1_EXEV5_3     ((uint32_t)0x00000008U)  /* SHRT1_EXEV5 input source select bit 3 */
#define AFIO_SHRT_EXEV_CFG2_SHRT1_EXEV5_4     ((uint32_t)0x00000010U)  /* SHRT1_EXEV5 input source select bit 4 */
#define AFIO_SHRT_EXEV_CFG2_SHRT1_EXEV5_5     ((uint32_t)0x00000020U)  /* SHRT1_EXEV5 input source select bit 5 */
#define AFIO_SHRT_EXEV_CFG2_SHRT1_EXEV5_6     ((uint32_t)0x00000040U)  /* SHRT1_EXEV5 input source select bit 6 */

#define AFIO_SHRT_EXEV_CFG2_SHRT1_EXEV6       ((uint32_t)0x00007F00U)  /* SHRT1_EXEV6 input source select bits */
#define AFIO_SHRT_EXEV_CFG2_SHRT1_EXEV6_0     ((uint32_t)0x00000100U)  /* SHRT1_EXEV6 input source select bit 0 */
#define AFIO_SHRT_EXEV_CFG2_SHRT1_EXEV6_1     ((uint32_t)0x00000200U)  /* SHRT1_EXEV6 input source select bit 1 */
#define AFIO_SHRT_EXEV_CFG2_SHRT1_EXEV6_2     ((uint32_t)0x00000400U)  /* SHRT1_EXEV6 input source select bit 2 */
#define AFIO_SHRT_EXEV_CFG2_SHRT1_EXEV6_3     ((uint32_t)0x00000800U)  /* SHRT1_EXEV6 input source select bit 3 */
#define AFIO_SHRT_EXEV_CFG2_SHRT1_EXEV6_4     ((uint32_t)0x00001000U)  /* SHRT1_EXEV6 input source select bit 4 */
#define AFIO_SHRT_EXEV_CFG2_SHRT1_EXEV6_5     ((uint32_t)0x00002000U)  /* SHRT1_EXEV6 input source select bit 5 */
#define AFIO_SHRT_EXEV_CFG2_SHRT1_EXEV6_6     ((uint32_t)0x00004000U)  /* SHRT1_EXEV6 input source select bit 6 */

#define AFIO_SHRT_EXEV_CFG2_SHRT1_EXEV7       ((uint32_t)0x007F0000U)  /* SHRT1_EXEV7 input source select bits */
#define AFIO_SHRT_EXEV_CFG2_SHRT1_EXEV7_0     ((uint32_t)0x00010000U)  /* SHRT1_EXEV7 input source select bit 0 */
#define AFIO_SHRT_EXEV_CFG2_SHRT1_EXEV7_1     ((uint32_t)0x00020000U)  /* SHRT1_EXEV7 input source select bit 1 */
#define AFIO_SHRT_EXEV_CFG2_SHRT1_EXEV7_2     ((uint32_t)0x00040000U)  /* SHRT1_EXEV7 input source select bit 2 */
#define AFIO_SHRT_EXEV_CFG2_SHRT1_EXEV7_3     ((uint32_t)0x00080000U)  /* SHRT1_EXEV7 input source select bit 3 */
#define AFIO_SHRT_EXEV_CFG2_SHRT1_EXEV7_4     ((uint32_t)0x00100000U)  /* SHRT1_EXEV7 input source select bit 4 */
#define AFIO_SHRT_EXEV_CFG2_SHRT1_EXEV7_5     ((uint32_t)0x00200000U)  /* SHRT1_EXEV7 input source select bit 5 */
#define AFIO_SHRT_EXEV_CFG2_SHRT1_EXEV7_6     ((uint32_t)0x00400000U)  /* SHRT1_EXEV7 input source select bit 6 */

#define AFIO_SHRT_EXEV_CFG2_SHRT1_EXEV8       ((uint32_t)0x7F000000U)  /* SHRT1_EXEV8 input source select bits */
#define AFIO_SHRT_EXEV_CFG2_SHRT1_EXEV8_0     ((uint32_t)0x01000000U)  /* SHRT1_EXEV8 input source select bit 0 */
#define AFIO_SHRT_EXEV_CFG2_SHRT1_EXEV8_1     ((uint32_t)0x02000000U)  /* SHRT1_EXEV8 input source select bit 1 */
#define AFIO_SHRT_EXEV_CFG2_SHRT1_EXEV8_2     ((uint32_t)0x04000000U)  /* SHRT1_EXEV8 input source select bit 2 */
#define AFIO_SHRT_EXEV_CFG2_SHRT1_EXEV8_3     ((uint32_t)0x08000000U)  /* SHRT1_EXEV8 input source select bit 3 */
#define AFIO_SHRT_EXEV_CFG2_SHRT1_EXEV8_4     ((uint32_t)0x10000000U)  /* SHRT1_EXEV8 input source select bit 4 */
#define AFIO_SHRT_EXEV_CFG2_SHRT1_EXEV8_5     ((uint32_t)0x20000000U)  /* SHRT1_EXEV8 input source select bit 5 */
#define AFIO_SHRT_EXEV_CFG2_SHRT1_EXEV8_6     ((uint32_t)0x40000000U)  /* SHRT1_EXEV8 input source select bit 6 */

/** Bit definition for AFIO_SHRT_EXEV_CFG3 register **/
#define AFIO_SHRT_EXEV_CFG3_SHRT1_EXEV9       ((uint32_t)0x0000007FU)  /* SHRT1_EXEV9 input source select bits */
#define AFIO_SHRT_EXEV_CFG3_SHRT1_EXEV9_0     ((uint32_t)0x00000001U)  /* SHRT1_EXEV9 input source select bit 0 */
#define AFIO_SHRT_EXEV_CFG3_SHRT1_EXEV9_1     ((uint32_t)0x00000002U)  /* SHRT1_EXEV9 input source select bit 1 */
#define AFIO_SHRT_EXEV_CFG3_SHRT1_EXEV9_2     ((uint32_t)0x00000004U)  /* SHRT1_EXEV9 input source select bit 2 */
#define AFIO_SHRT_EXEV_CFG3_SHRT1_EXEV9_3     ((uint32_t)0x00000008U)  /* SHRT1_EXEV9 input source select bit 3 */
#define AFIO_SHRT_EXEV_CFG3_SHRT1_EXEV9_4     ((uint32_t)0x00000010U)  /* SHRT1_EXEV9 input source select bit 4 */
#define AFIO_SHRT_EXEV_CFG3_SHRT1_EXEV9_5     ((uint32_t)0x00000020U)  /* SHRT1_EXEV9 input source select bit 5 */
#define AFIO_SHRT_EXEV_CFG3_SHRT1_EXEV9_6     ((uint32_t)0x00000040U)  /* SHRT1_EXEV9 input source select bit 6 */

#define AFIO_SHRT_EXEV_CFG3_SHRT1_EXEV10      ((uint32_t)0x00007F00U)  /* SHRT1_EXEV10 input source select bits */
#define AFIO_SHRT_EXEV_CFG3_SHRT1_EXEV10_0    ((uint32_t)0x00000100U)  /* SHRT1_EXEV10 input source select bit 0 */
#define AFIO_SHRT_EXEV_CFG3_SHRT1_EXEV10_1    ((uint32_t)0x00000200U)  /* SHRT1_EXEV10 input source select bit 1 */
#define AFIO_SHRT_EXEV_CFG3_SHRT1_EXEV10_2    ((uint32_t)0x00000400U)  /* SHRT1_EXEV10 input source select bit 2 */
#define AFIO_SHRT_EXEV_CFG3_SHRT1_EXEV10_3    ((uint32_t)0x00000800U)  /* SHRT1_EXEV10 input source select bit 3 */
#define AFIO_SHRT_EXEV_CFG3_SHRT1_EXEV10_4    ((uint32_t)0x00001000U)  /* SHRT1_EXEV10 input source select bit 4 */
#define AFIO_SHRT_EXEV_CFG3_SHRT1_EXEV10_5    ((uint32_t)0x00002000U)  /* SHRT1_EXEV10 input source select bit 5 */
#define AFIO_SHRT_EXEV_CFG3_SHRT1_EXEV10_6    ((uint32_t)0x00004000U)  /* SHRT1_EXEV10 input source select bit 6 */


/*** SystemTick ***/

/** Bit definition for SysTick_CTRL register **/
#define SysTick_CTRL_ENABLE    ((uint32_t)0x00000001U) /* Counter enable */
#define SysTick_CTRL_TICKINT   ((uint32_t)0x00000002U) /* Counting down to 0 pends the SysTick handler */
#define SysTick_CTRL_CLKSOURCE ((uint32_t)0x00000004U) /* Clock source */
#define SysTick_CTRL_COUNTFLAG ((uint32_t)0x00010000U) /* Count Flag */

/** Bit definition for SysTick_LOAD register **/
#define SysTick_LOAD_RELOAD ((uint32_t)0x00FFFFFFU) /* Value to load into the SysTick Current Value Register when the counter reaches 0 */
/** Bit definition for SysTick_VAL register **/
#define SysTick_VAL_CURRENT ((uint32_t)0x00FFFFFFU) /* Current value at the time the register is accessed */

/** Bit definition for SysTick_CALIB register **/
#define SysTick_CALIB_TENMS ((uint32_t)0x00FFFFFFU) /* Reload value to use for 10ms timing */
#define SysTick_CALIB_SKEW  ((uint32_t)0x40000000U) /* Calibration value is not exactly 10 ms */
#define SysTick_CALIB_NOREF ((uint32_t)0x80000000U) /* The reference clock is not provided */

/*** Nested Vectored Interrupt Controller ***/

/** Bit definition for NVIC_ISER register **/
#define NVIC_ISER_SETENA    ((uint32_t)0xFFFFFFFFU) /* Interrupt set enable bits */
#define NVIC_ISER_SETENA_0  ((uint32_t)0x00000001U) /* bit 0 */
#define NVIC_ISER_SETENA_1  ((uint32_t)0x00000002U) /* bit 1 */
#define NVIC_ISER_SETENA_2  ((uint32_t)0x00000004U) /* bit 2 */
#define NVIC_ISER_SETENA_3  ((uint32_t)0x00000008U) /* bit 3 */
#define NVIC_ISER_SETENA_4  ((uint32_t)0x00000010U) /* bit 4 */
#define NVIC_ISER_SETENA_5  ((uint32_t)0x00000020U) /* bit 5 */
#define NVIC_ISER_SETENA_6  ((uint32_t)0x00000040U) /* bit 6 */
#define NVIC_ISER_SETENA_7  ((uint32_t)0x00000080U) /* bit 7 */
#define NVIC_ISER_SETENA_8  ((uint32_t)0x00000100U) /* bit 8 */
#define NVIC_ISER_SETENA_9  ((uint32_t)0x00000200U) /* bit 9 */
#define NVIC_ISER_SETENA_10 ((uint32_t)0x00000400U) /* bit 10 */
#define NVIC_ISER_SETENA_11 ((uint32_t)0x00000800U) /* bit 11 */
#define NVIC_ISER_SETENA_12 ((uint32_t)0x00001000U) /* bit 12 */
#define NVIC_ISER_SETENA_13 ((uint32_t)0x00002000U) /* bit 13 */
#define NVIC_ISER_SETENA_14 ((uint32_t)0x00004000U) /* bit 14 */
#define NVIC_ISER_SETENA_15 ((uint32_t)0x00008000U) /* bit 15 */
#define NVIC_ISER_SETENA_16 ((uint32_t)0x00010000U) /* bit 16 */
#define NVIC_ISER_SETENA_17 ((uint32_t)0x00020000U) /* bit 17 */
#define NVIC_ISER_SETENA_18 ((uint32_t)0x00040000U) /* bit 18 */
#define NVIC_ISER_SETENA_19 ((uint32_t)0x00080000U) /* bit 19 */
#define NVIC_ISER_SETENA_20 ((uint32_t)0x00100000U) /* bit 20 */
#define NVIC_ISER_SETENA_21 ((uint32_t)0x00200000U) /* bit 21 */
#define NVIC_ISER_SETENA_22 ((uint32_t)0x00400000U) /* bit 22 */
#define NVIC_ISER_SETENA_23 ((uint32_t)0x00800000U) /* bit 23 */
#define NVIC_ISER_SETENA_24 ((uint32_t)0x01000000U) /* bit 24 */
#define NVIC_ISER_SETENA_25 ((uint32_t)0x02000000U) /* bit 25 */
#define NVIC_ISER_SETENA_26 ((uint32_t)0x04000000U) /* bit 26 */
#define NVIC_ISER_SETENA_27 ((uint32_t)0x08000000U) /* bit 27 */
#define NVIC_ISER_SETENA_28 ((uint32_t)0x10000000U) /* bit 28 */
#define NVIC_ISER_SETENA_29 ((uint32_t)0x20000000U) /* bit 29 */
#define NVIC_ISER_SETENA_30 ((uint32_t)0x40000000U) /* bit 30 */
#define NVIC_ISER_SETENA_31 ((uint32_t)0x80000000U) /* bit 31 */

/** Bit definition for NVIC_ICER register ***/
#define NVIC_ICER_CLRENA    ((uint32_t)0xFFFFFFFFU) /* Interrupt clear-enable bits */
#define NVIC_ICER_CLRENA_0  ((uint32_t)0x00000001U) /* bit 0 */
#define NVIC_ICER_CLRENA_1  ((uint32_t)0x00000002U) /* bit 1 */
#define NVIC_ICER_CLRENA_2  ((uint32_t)0x00000004U) /* bit 2 */
#define NVIC_ICER_CLRENA_3  ((uint32_t)0x00000008U) /* bit 3 */
#define NVIC_ICER_CLRENA_4  ((uint32_t)0x00000010U) /* bit 4 */
#define NVIC_ICER_CLRENA_5  ((uint32_t)0x00000020U) /* bit 5 */
#define NVIC_ICER_CLRENA_6  ((uint32_t)0x00000040U) /* bit 6 */
#define NVIC_ICER_CLRENA_7  ((uint32_t)0x00000080U) /* bit 7 */
#define NVIC_ICER_CLRENA_8  ((uint32_t)0x00000100U) /* bit 8 */
#define NVIC_ICER_CLRENA_9  ((uint32_t)0x00000200U) /* bit 9 */
#define NVIC_ICER_CLRENA_10 ((uint32_t)0x00000400U) /* bit 10 */
#define NVIC_ICER_CLRENA_11 ((uint32_t)0x00000800U) /* bit 11 */
#define NVIC_ICER_CLRENA_12 ((uint32_t)0x00001000U) /* bit 12 */
#define NVIC_ICER_CLRENA_13 ((uint32_t)0x00002000U) /* bit 13 */
#define NVIC_ICER_CLRENA_14 ((uint32_t)0x00004000U) /* bit 14 */
#define NVIC_ICER_CLRENA_15 ((uint32_t)0x00008000U) /* bit 15 */
#define NVIC_ICER_CLRENA_16 ((uint32_t)0x00010000U) /* bit 16 */
#define NVIC_ICER_CLRENA_17 ((uint32_t)0x00020000U) /* bit 17 */
#define NVIC_ICER_CLRENA_18 ((uint32_t)0x00040000U) /* bit 18 */
#define NVIC_ICER_CLRENA_19 ((uint32_t)0x00080000U) /* bit 19 */
#define NVIC_ICER_CLRENA_20 ((uint32_t)0x00100000U) /* bit 20 */
#define NVIC_ICER_CLRENA_21 ((uint32_t)0x00200000U) /* bit 21 */
#define NVIC_ICER_CLRENA_22 ((uint32_t)0x00400000U) /* bit 22 */
#define NVIC_ICER_CLRENA_23 ((uint32_t)0x00800000U) /* bit 23 */
#define NVIC_ICER_CLRENA_24 ((uint32_t)0x01000000U) /* bit 24 */
#define NVIC_ICER_CLRENA_25 ((uint32_t)0x02000000U) /* bit 25 */
#define NVIC_ICER_CLRENA_26 ((uint32_t)0x04000000U) /* bit 26 */
#define NVIC_ICER_CLRENA_27 ((uint32_t)0x08000000U) /* bit 27 */
#define NVIC_ICER_CLRENA_28 ((uint32_t)0x10000000U) /* bit 28 */
#define NVIC_ICER_CLRENA_29 ((uint32_t)0x20000000U) /* bit 29 */
#define NVIC_ICER_CLRENA_30 ((uint32_t)0x40000000U) /* bit 30 */
#define NVIC_ICER_CLRENA_31 ((uint32_t)0x80000000U) /* bit 31 */

/** Bit definition for NVIC_ISPR register **/
#define NVIC_ISPR_SETPEND    ((uint32_t)0xFFFFFFFFU) /* Interrupt set-pending bits */
#define NVIC_ISPR_SETPEND_0  ((uint32_t)0x00000001U) /* bit 0 */
#define NVIC_ISPR_SETPEND_1  ((uint32_t)0x00000002U) /* bit 1 */
#define NVIC_ISPR_SETPEND_2  ((uint32_t)0x00000004U) /* bit 2 */
#define NVIC_ISPR_SETPEND_3  ((uint32_t)0x00000008U) /* bit 3 */
#define NVIC_ISPR_SETPEND_4  ((uint32_t)0x00000010U) /* bit 4 */
#define NVIC_ISPR_SETPEND_5  ((uint32_t)0x00000020U) /* bit 5 */
#define NVIC_ISPR_SETPEND_6  ((uint32_t)0x00000040U) /* bit 6 */
#define NVIC_ISPR_SETPEND_7  ((uint32_t)0x00000080U) /* bit 7 */
#define NVIC_ISPR_SETPEND_8  ((uint32_t)0x00000100U) /* bit 8 */
#define NVIC_ISPR_SETPEND_9  ((uint32_t)0x00000200U) /* bit 9 */
#define NVIC_ISPR_SETPEND_10 ((uint32_t)0x00000400U) /* bit 10 */
#define NVIC_ISPR_SETPEND_11 ((uint32_t)0x00000800U) /* bit 11 */
#define NVIC_ISPR_SETPEND_12 ((uint32_t)0x00001000U) /* bit 12 */
#define NVIC_ISPR_SETPEND_13 ((uint32_t)0x00002000U) /* bit 13 */
#define NVIC_ISPR_SETPEND_14 ((uint32_t)0x00004000U) /* bit 14 */
#define NVIC_ISPR_SETPEND_15 ((uint32_t)0x00008000U) /* bit 15 */
#define NVIC_ISPR_SETPEND_16 ((uint32_t)0x00010000U) /* bit 16 */
#define NVIC_ISPR_SETPEND_17 ((uint32_t)0x00020000U) /* bit 17 */
#define NVIC_ISPR_SETPEND_18 ((uint32_t)0x00040000U) /* bit 18 */
#define NVIC_ISPR_SETPEND_19 ((uint32_t)0x00080000U) /* bit 19 */
#define NVIC_ISPR_SETPEND_20 ((uint32_t)0x00100000U) /* bit 20 */
#define NVIC_ISPR_SETPEND_21 ((uint32_t)0x00200000U) /* bit 21 */
#define NVIC_ISPR_SETPEND_22 ((uint32_t)0x00400000U) /* bit 22 */
#define NVIC_ISPR_SETPEND_23 ((uint32_t)0x00800000U) /* bit 23 */
#define NVIC_ISPR_SETPEND_24 ((uint32_t)0x01000000U) /* bit 24 */
#define NVIC_ISPR_SETPEND_25 ((uint32_t)0x02000000U) /* bit 25 */
#define NVIC_ISPR_SETPEND_26 ((uint32_t)0x04000000U) /* bit 26 */
#define NVIC_ISPR_SETPEND_27 ((uint32_t)0x08000000U) /* bit 27 */
#define NVIC_ISPR_SETPEND_28 ((uint32_t)0x10000000U) /* bit 28 */
#define NVIC_ISPR_SETPEND_29 ((uint32_t)0x20000000U) /* bit 29 */
#define NVIC_ISPR_SETPEND_30 ((uint32_t)0x40000000U) /* bit 30 */
#define NVIC_ISPR_SETPEND_31 ((uint32_t)0x80000000U) /* bit 31 */

/** Bit definition for NVIC_ICPR register **/
#define NVIC_ICPR_CLRPEND    ((uint32_t)0xFFFFFFFFU) /* Interrupt clear-pending bits */
#define NVIC_ICPR_CLRPEND_0  ((uint32_t)0x00000001U) /* bit 0 */
#define NVIC_ICPR_CLRPEND_1  ((uint32_t)0x00000002U) /* bit 1 */
#define NVIC_ICPR_CLRPEND_2  ((uint32_t)0x00000004U) /* bit 2 */
#define NVIC_ICPR_CLRPEND_3  ((uint32_t)0x00000008U) /* bit 3 */
#define NVIC_ICPR_CLRPEND_4  ((uint32_t)0x00000010U) /* bit 4 */
#define NVIC_ICPR_CLRPEND_5  ((uint32_t)0x00000020U) /* bit 5 */
#define NVIC_ICPR_CLRPEND_6  ((uint32_t)0x00000040U) /* bit 6 */
#define NVIC_ICPR_CLRPEND_7  ((uint32_t)0x00000080U) /* bit 7 */
#define NVIC_ICPR_CLRPEND_8  ((uint32_t)0x00000100U) /* bit 8 */
#define NVIC_ICPR_CLRPEND_9  ((uint32_t)0x00000200U) /* bit 9 */
#define NVIC_ICPR_CLRPEND_10 ((uint32_t)0x00000400U) /* bit 10 */
#define NVIC_ICPR_CLRPEND_11 ((uint32_t)0x00000800U) /* bit 11 */
#define NVIC_ICPR_CLRPEND_12 ((uint32_t)0x00001000U) /* bit 12 */
#define NVIC_ICPR_CLRPEND_13 ((uint32_t)0x00002000U) /* bit 13 */
#define NVIC_ICPR_CLRPEND_14 ((uint32_t)0x00004000U) /* bit 14 */
#define NVIC_ICPR_CLRPEND_15 ((uint32_t)0x00008000U) /* bit 15 */
#define NVIC_ICPR_CLRPEND_16 ((uint32_t)0x00010000U) /* bit 16 */
#define NVIC_ICPR_CLRPEND_17 ((uint32_t)0x00020000U) /* bit 17 */
#define NVIC_ICPR_CLRPEND_18 ((uint32_t)0x00040000U) /* bit 18 */
#define NVIC_ICPR_CLRPEND_19 ((uint32_t)0x00080000U) /* bit 19 */
#define NVIC_ICPR_CLRPEND_20 ((uint32_t)0x00100000U) /* bit 20 */
#define NVIC_ICPR_CLRPEND_21 ((uint32_t)0x00200000U) /* bit 21 */
#define NVIC_ICPR_CLRPEND_22 ((uint32_t)0x00400000U) /* bit 22 */
#define NVIC_ICPR_CLRPEND_23 ((uint32_t)0x00800000U) /* bit 23 */
#define NVIC_ICPR_CLRPEND_24 ((uint32_t)0x01000000U) /* bit 24 */
#define NVIC_ICPR_CLRPEND_25 ((uint32_t)0x02000000U) /* bit 25 */
#define NVIC_ICPR_CLRPEND_26 ((uint32_t)0x04000000U) /* bit 26 */
#define NVIC_ICPR_CLRPEND_27 ((uint32_t)0x08000000U) /* bit 27 */
#define NVIC_ICPR_CLRPEND_28 ((uint32_t)0x10000000U) /* bit 28 */
#define NVIC_ICPR_CLRPEND_29 ((uint32_t)0x20000000U) /* bit 29 */
#define NVIC_ICPR_CLRPEND_30 ((uint32_t)0x40000000U) /* bit 30 */
#define NVIC_ICPR_CLRPEND_31 ((uint32_t)0x80000000U) /* bit 31 */

/** Bit definition for NVIC_IABR register **/
#define NVIC_IABR_ACTIVE    ((uint32_t)0xFFFFFFFFU) /* Interrupt active flags */
#define NVIC_IABR_ACTIVE_0  ((uint32_t)0x00000001U) /* bit 0 */
#define NVIC_IABR_ACTIVE_1  ((uint32_t)0x00000002U) /* bit 1 */
#define NVIC_IABR_ACTIVE_2  ((uint32_t)0x00000004U) /* bit 2 */
#define NVIC_IABR_ACTIVE_3  ((uint32_t)0x00000008U) /* bit 3 */
#define NVIC_IABR_ACTIVE_4  ((uint32_t)0x00000010U) /* bit 4 */
#define NVIC_IABR_ACTIVE_5  ((uint32_t)0x00000020U) /* bit 5 */
#define NVIC_IABR_ACTIVE_6  ((uint32_t)0x00000040U) /* bit 6 */
#define NVIC_IABR_ACTIVE_7  ((uint32_t)0x00000080U) /* bit 7 */
#define NVIC_IABR_ACTIVE_8  ((uint32_t)0x00000100U) /* bit 8 */
#define NVIC_IABR_ACTIVE_9  ((uint32_t)0x00000200U) /* bit 9 */
#define NVIC_IABR_ACTIVE_10 ((uint32_t)0x00000400U) /* bit 10 */
#define NVIC_IABR_ACTIVE_11 ((uint32_t)0x00000800U) /* bit 11 */
#define NVIC_IABR_ACTIVE_12 ((uint32_t)0x00001000U) /* bit 12 */
#define NVIC_IABR_ACTIVE_13 ((uint32_t)0x00002000U) /* bit 13 */
#define NVIC_IABR_ACTIVE_14 ((uint32_t)0x00004000U) /* bit 14 */
#define NVIC_IABR_ACTIVE_15 ((uint32_t)0x00008000U) /* bit 15 */
#define NVIC_IABR_ACTIVE_16 ((uint32_t)0x00010000U) /* bit 16 */
#define NVIC_IABR_ACTIVE_17 ((uint32_t)0x00020000U) /* bit 17 */
#define NVIC_IABR_ACTIVE_18 ((uint32_t)0x00040000U) /* bit 18 */
#define NVIC_IABR_ACTIVE_19 ((uint32_t)0x00080000U) /* bit 19 */
#define NVIC_IABR_ACTIVE_20 ((uint32_t)0x00100000U) /* bit 20 */
#define NVIC_IABR_ACTIVE_21 ((uint32_t)0x00200000U) /* bit 21 */
#define NVIC_IABR_ACTIVE_22 ((uint32_t)0x00400000U) /* bit 22 */
#define NVIC_IABR_ACTIVE_23 ((uint32_t)0x00800000U) /* bit 23 */
#define NVIC_IABR_ACTIVE_24 ((uint32_t)0x01000000U) /* bit 24 */
#define NVIC_IABR_ACTIVE_25 ((uint32_t)0x02000000U) /* bit 25 */
#define NVIC_IABR_ACTIVE_26 ((uint32_t)0x04000000U) /* bit 26 */
#define NVIC_IABR_ACTIVE_27 ((uint32_t)0x08000000U) /* bit 27 */
#define NVIC_IABR_ACTIVE_28 ((uint32_t)0x10000000U) /* bit 28 */
#define NVIC_IABR_ACTIVE_29 ((uint32_t)0x20000000U) /* bit 29 */
#define NVIC_IABR_ACTIVE_30 ((uint32_t)0x40000000U) /* bit 30 */
#define NVIC_IABR_ACTIVE_31 ((uint32_t)0x80000000U) /* bit 31 */

/** Bit definition for NVIC_PRI0 register **/
#define NVIC_IPR0_PRI_0 ((uint32_t)0x000000FFU) /* Priority of interrupt 0 */
#define NVIC_IPR0_PRI_1 ((uint32_t)0x0000FF00U) /* Priority of interrupt 1 */
#define NVIC_IPR0_PRI_2 ((uint32_t)0x00FF0000U) /* Priority of interrupt 2 */
#define NVIC_IPR0_PRI_3 ((uint32_t)0xFF000000U) /* Priority of interrupt 3 */

/** Bit definition for NVIC_PRI1 register **/
#define NVIC_IPR1_PRI_4 ((uint32_t)0x000000FFU) /* Priority of interrupt 4 */
#define NVIC_IPR1_PRI_5 ((uint32_t)0x0000FF00U) /* Priority of interrupt 5 */
#define NVIC_IPR1_PRI_6 ((uint32_t)0x00FF0000U) /* Priority of interrupt 6 */
#define NVIC_IPR1_PRI_7 ((uint32_t)0xFF000000U) /* Priority of interrupt 7 */

/** Bit definition for NVIC_PRI2 register **/
#define NVIC_IPR2_PRI_8  ((uint32_t)0x000000FFU) /* Priority of interrupt 8 */
#define NVIC_IPR2_PRI_9  ((uint32_t)0x0000FF00U) /* Priority of interrupt 9 */
#define NVIC_IPR2_PRI_10 ((uint32_t)0x00FF0000U) /* Priority of interrupt 10 */
#define NVIC_IPR2_PRI_11 ((uint32_t)0xFF000000U) /* Priority of interrupt 11 */

/** Bit definition for NVIC_PRI3 register **/
#define NVIC_IPR3_PRI_12 ((uint32_t)0x000000FFU) /* Priority of interrupt 12 */
#define NVIC_IPR3_PRI_13 ((uint32_t)0x0000FF00U) /* Priority of interrupt 13 */
#define NVIC_IPR3_PRI_14 ((uint32_t)0x00FF0000U) /* Priority of interrupt 14 */
#define NVIC_IPR3_PRI_15 ((uint32_t)0xFF000000U) /* Priority of interrupt 15 */

/** Bit definition for NVIC_PRI4 register **/
#define NVIC_IPR4_PRI_16 ((uint32_t)0x000000FFU) /* Priority of interrupt 16 */
#define NVIC_IPR4_PRI_17 ((uint32_t)0x0000FF00U) /* Priority of interrupt 17 */
#define NVIC_IPR4_PRI_18 ((uint32_t)0x00FF0000U) /* Priority of interrupt 18 */
#define NVIC_IPR4_PRI_19 ((uint32_t)0xFF000000U) /* Priority of interrupt 19 */

/** Bit definition for NVIC_PRI5 register **/
#define NVIC_IPR5_PRI_20 ((uint32_t)0x000000FFU) /* Priority of interrupt 20 */
#define NVIC_IPR5_PRI_21 ((uint32_t)0x0000FF00U) /* Priority of interrupt 21 */
#define NVIC_IPR5_PRI_22 ((uint32_t)0x00FF0000U) /* Priority of interrupt 22 */
#define NVIC_IPR5_PRI_23 ((uint32_t)0xFF000000U) /* Priority of interrupt 23 */

/** Bit definition for NVIC_PRI6 register **/
#define NVIC_IPR6_PRI_24 ((uint32_t)0x000000FFU) /* Priority of interrupt 24 */
#define NVIC_IPR6_PRI_25 ((uint32_t)0x0000FF00U) /* Priority of interrupt 25 */
#define NVIC_IPR6_PRI_26 ((uint32_t)0x00FF0000U) /* Priority of interrupt 26 */
#define NVIC_IPR6_PRI_27 ((uint32_t)0xFF000000U) /* Priority of interrupt 27 */

/** Bit definition for NVIC_PRI7 register **/
#define NVIC_IPR7_PRI_28 ((uint32_t)0x000000FFU) /* Priority of interrupt 28 */
#define NVIC_IPR7_PRI_29 ((uint32_t)0x0000FF00U) /* Priority of interrupt 29 */
#define NVIC_IPR7_PRI_30 ((uint32_t)0x00FF0000U) /* Priority of interrupt 30 */
#define NVIC_IPR7_PRI_31 ((uint32_t)0xFF000000U) /* Priority of interrupt 31 */

/** Bit definition for SCB_CPUID register **/
#define SCB_CPUID_REVISION    ((uint32_t)0x0000000FU) /* Implementation defined revision number */
#define SCB_CPUID_PARTNO      ((uint32_t)0x0000FFF0U) /* Number of processor within family */
#define SCB_CPUID_Constant    ((uint32_t)0x000F0000U) /* Reads as 0x0F */
#define SCB_CPUID_VARIANT     ((uint32_t)0x00F00000U) /* Implementation defined variant number */
#define SCB_CPUID_IMPLEMENTER ((uint32_t)0xFF000000U) /* Implementer code. ARM is 0x41 */

/** Bit definition for SCB_ICSR register **/
#define SCB_ICSR_VECTACTIVE  ((uint32_t)0x000001FFU) /* Active INTSTS number field */
#define SCB_ICSR_RETTOBASE   ((uint32_t)0x00000800U) /* All active exceptions minus the IPSR_current_exception yields the empty set */
#define SCB_ICSR_VECTPENDING ((uint32_t)0x003FF000U) /* Pending INTSTS number field */
#define SCB_ICSR_ISRPENDING  ((uint32_t)0x00400000U) /* Interrupt pending flag */
#define SCB_ICSR_ISRPREEMPT  ((uint32_t)0x00800000U) /* It indicates that a pending interrupt becomes active in the next running cycle */
#define SCB_ICSR_PENDSTCLR   ((uint32_t)0x02000000U) /* Clear pending SysTick bit */
#define SCB_ICSR_PENDSTSET   ((uint32_t)0x04000000U) /* Set pending SysTick bit */
#define SCB_ICSR_PENDSVCLR   ((uint32_t)0x08000000U) /* Clear pending pendSV bit */
#define SCB_ICSR_PENDSVSET   ((uint32_t)0x10000000U) /* Set pending pendSV bit */
#define SCB_ICSR_NMIPENDSET  ((uint32_t)0x80000000U) /* Set pending NMI bit */

/** Bit definition for SCB_VTOR register **/
#define SCB_VTOR_TBLOFF  ((uint32_t)0x1FFFFF80U) /* Vector table base offset field */
#define SCB_VTOR_TBLBASE ((uint32_t)0x20000000U) /* Table base in code(0) or RAM(1) */

/** Bit definition for SCB_AIRCR register **/
#define SCB_AIRCR_VECTRESET     ((uint32_t)0x00000001U) /* System Reset bit */
#define SCB_AIRCR_VECTCLRACTIVE ((uint32_t)0x00000002U) /* Clear active vector bit */
#define SCB_AIRCR_SYSRESETREQ   ((uint32_t)0x00000004U) /* Requests chip control logic to generate a reset */

#define SCB_AIRCR_PRIGROUP   ((uint32_t)0x00000700U) /* PRIGROUP[2:0] bits (Priority group) */
#define SCB_AIRCR_PRIGROUP_0 ((uint32_t)0x00000100U) /* Bit 0 */
#define SCB_AIRCR_PRIGROUP_1 ((uint32_t)0x00000200U) /* Bit 1 */
#define SCB_AIRCR_PRIGROUP_2 ((uint32_t)0x00000400U) /* Bit 2  */

/** prority group configuration **/
#define SCB_AIRCR_PRIGROUP0   ((uint32_t)0x00000000U) /* Priority group=0 (7 bits of pre-emption priority, 1 bit of subpriority) */
#define SCB_AIRCR_PRIGROUP1   ((uint32_t)0x00000100U) /* Priority group=1 (6 bits of pre-emption priority, 2 bits of subpriority) */
#define SCB_AIRCR_PRIGROUP2   ((uint32_t)0x00000200U) /* Priority group=2 (5 bits of pre-emption priority, 3 bits of subpriority) */
#define SCB_AIRCR_PRIGROUP3   ((uint32_t)0x00000300U) /* Priority group=3 (4 bits of pre-emption priority, 4 bits of subpriority) */
#define SCB_AIRCR_PRIGROUP4   ((uint32_t)0x00000400U) /* Priority group=4 (3 bits of pre-emption priority, 5 bits of subpriority) */
#define SCB_AIRCR_PRIGROUP5   ((uint32_t)0x00000500U) /* Priority group=5 (2 bits of pre-emption priority, 6 bits of subpriority) */
#define SCB_AIRCR_PRIGROUP6   ((uint32_t)0x00000600U) /* Priority group=6 (1 bit of pre-emption priority, 7 bits of subpriority) */
#define SCB_AIRCR_PRIGROUP7   ((uint32_t)0x00000700U) /* Priority group=7 (no pre-emption priority, 8 bits of subpriority) */

#define SCB_AIRCR_ENDIANESS ((uint32_t)0x00008000U) /* Data endianness bit */
#define SCB_AIRCR_VECTKEY   ((uint32_t)0xFFFF0000U) /* Register key (VECTKEY) - Reads as 0xFA05 (VECTKEYSTAT) */

/** Bit definition for SCB_SCR register **/
#define SCB_SCR_SLEEPONEXIT ((uint8_t)0x02U) /* Sleep on exit bit */
#define SCB_SCR_SLEEPDEEP   ((uint8_t)0x04U) /* Sleep deep bit */
#define SCB_SCR_SEVONPEND   ((uint8_t)0x10U) /* Wake up from WFE */

/** Bit definition for SCB_CCR register **/
#define SCB_CCR_NONBASETHRDENA   ((uint16_t)0x0001U) /* Thread mode can be entered from any level in Handler mode by controlled return value */
#define SCB_CCR_USERSETMPEND     ((uint16_t)0x0002U) /* Enables user code to write the Software Trigger Interrupt register to trigger (pend) a     \
                          Main exception */
#define SCB_CCR_UNALIGN_TRP ((uint16_t)0x0008U) /* Trap for unaligned access */
#define SCB_CCR_DIV_0_TRP   ((uint16_t)0x0010U) /* Trap on Divide by 0 */
#define SCB_CCR_BFHFNMIGN   ((uint16_t)0x0100U) /* Handlers running at priority -1 and -2 */
#define SCB_CCR_STKALIGN    ((uint16_t)0x0200U) /* On exception entry, the SP used prior to the exception is adjusted to be 8-byte aligned */

/** Bit definition for SCB_SHPR register **/
#define SCB_SHPR_PRI_N    ((uint32_t)0x000000FFU) /* Priority of system handler 4,8, and 12. Mem Manage, reserved and Debug Monitor */
#define SCB_SHPR_PRI_N1   ((uint32_t)0x0000FF00U) /* Priority of system handler 5,9, and 13. Bus Fault, reserved and reserved */
#define SCB_SHPR_PRI_N2   ((uint32_t)0x00FF0000U) /* Priority of system handler 6,10, and 14. Usage Fault, reserved and PendSV */
#define SCB_SHPR_PRI_N3   ((uint32_t)0xFF000000U) /* Priority of system handler 7,11, and 15. Reserved, SVCall and SysTick */

/** Bit definition for SCB_SHCSR register **/
#define SCB_SHCSR_MEMFAULTACT    ((uint32_t)0x00000001U) /* MemManage is active */
#define SCB_SHCSR_BUSFAULTACT    ((uint32_t)0x00000002U) /* BusFault is active */
#define SCB_SHCSR_USGFAULTACT    ((uint32_t)0x00000008U) /* UsageFault is active */
#define SCB_SHCSR_SVCALLACT      ((uint32_t)0x00000080U) /* SVCall is active */
#define SCB_SHCSR_MONITORACT     ((uint32_t)0x00000100U) /* Monitor is active */
#define SCB_SHCSR_PENDSVACT      ((uint32_t)0x00000400U) /* PendSV is active */
#define SCB_SHCSR_SYSTICKACT     ((uint32_t)0x00000800U) /* SysTick is active */
#define SCB_SHCSR_USGFAULTPENDED ((uint32_t)0x00001000U) /* Usage Fault is pended */
#define SCB_SHCSR_MEMFAULTPENDED ((uint32_t)0x00002000U) /* MemManage is pended */
#define SCB_SHCSR_BUSFAULTPENDED ((uint32_t)0x00004000U) /* Bus Fault is pended */
#define SCB_SHCSR_SVCALLPENDED   ((uint32_t)0x00008000U) /* SVCall is pended */
#define SCB_SHCSR_MEMFAULTENA    ((uint32_t)0x00010000U) /* MemManage enable */
#define SCB_SHCSR_BUSFAULTENA    ((uint32_t)0x00020000U) /* Bus Fault enable */
#define SCB_SHCSR_USGFAULTENA    ((uint32_t)0x00040000U) /* UsageFault enable */

/*** Bit definition for SCB_CFSR register ***/
/** MFSR **/
#define SCB_CFSR_IACCVIOL  ((uint32_t)0x00000001U) /* Instruction access violation */
#define SCB_CFSR_DACCVIOL  ((uint32_t)0x00000002U) /* Data access violation */
#define SCB_CFSR_MUNSTKERR ((uint32_t)0x00000008U) /* Unstacking error */
#define SCB_CFSR_MSTKERR   ((uint32_t)0x00000010U) /* Stacking error */
#define SCB_CFSR_MMARVALID ((uint32_t)0x00000080U) /* Memory Manage Address Register address valid flag */
/** BFSR **/
#define SCB_CFSR_IBUSERR     ((uint32_t)0x00000100U) /* Instruction bus error flag */
#define SCB_CFSR_PRECISERR   ((uint32_t)0x00000200U) /* Precise data bus error */
#define SCB_CFSR_IMPRECISERR ((uint32_t)0x00000400U) /* Imprecise data bus error */
#define SCB_CFSR_UNSTKERR    ((uint32_t)0x00000800U) /* Unstacking error */
#define SCB_CFSR_STKERR      ((uint32_t)0x00001000U) /* Stacking error */
#define SCB_CFSR_BFARVALID   ((uint32_t)0x00008000U) /* Bus Fault Address Register address valid flag */
/** UFSR **/
#define SCB_CFSR_UNDEFINSTR ((uint32_t)0x00010000U) /* The processor attempt to execute an undefined instruction */
#define SCB_CFSR_INVSTATE   ((uint32_t)0x00020000U) /* Invalid combination of EPSR and instruction */
#define SCB_CFSR_INVPC      ((uint32_t)0x00040000U) /* Attempt to load EXC_RETURN into pc illegally */
#define SCB_CFSR_NOCP       ((uint32_t)0x00080000U) /* Attempt to use a coprocessor instruction */
#define SCB_CFSR_UNALIGNED  ((uint32_t)0x01000000U) /* Fault occurs when there is an attempt to make an unaligned memory access */
#define SCB_CFSR_DIVBYZERO  ((uint32_t)0x02000000U) /* Fault occurs when SDIV or DIV instruction is used with a divisor of 0 */

/** Bit definition for SCB_HFSR register **/
#define SCB_HFSR_VECTTBL  ((uint32_t)0x00000002U) /* Fault occurs because of vector table read on exception processing */
#define SCB_HFSR_FORCED   ((uint32_t)0x40000000U) /* Hard Fault activated when a configurable Fault was received and cannot activate */
#define SCB_HFSR_DEBUGEVT ((uint32_t)0x80000000U) /* Fault related to debug */

/** Bit definition for SCB_DFSR register **/
#define SCB_DFSR_HALTED   ((uint8_t)0x01U) /* Halt request flag */
#define SCB_DFSR_BKPT     ((uint8_t)0x02U) /* BKPT flag */
#define SCB_DFSR_DWTTRAP  ((uint8_t)0x04U) /* Data Watchpoint and Trace (DWT) flag */
#define SCB_DFSR_VCATCH   ((uint8_t)0x08U) /* Vector catch flag */
#define SCB_DFSR_EXTERNAL ((uint8_t)0x10U) /* External debug request flag */

/** Bit definition for SCB_MMFAR register **/
#define SCB_MMFAR_ADDRESS ((uint32_t)0xFFFFFFFFU) /* Mem Manage fault address field */

/** Bit definition for SCB_BFAR register **/
#define SCB_BFAR_ADDRESS ((uint32_t)0xFFFFFFFFU) /* Bus fault address field */

/** Bit definition for SCB_afsr register **/
#define SCB_AFSR_IMPDEF ((uint32_t)0xFFFFFFFFU) /* Implementation defined */

/*** External Interrupt/Event Controller ***/

/** Bit definition for EXTI_EMASK register **/
#define EXTI_EMASK_EMASK0                   ((uint32_t)0x00000001U) /* Event Mask on line 0 */
#define EXTI_EMASK_EMASK1                   ((uint32_t)0x00000002U) /* Event Mask on line 1 */
#define EXTI_EMASK_EMASK2                   ((uint32_t)0x00000004U) /* Event Mask on line 2 */
#define EXTI_EMASK_EMASK3                   ((uint32_t)0x00000008U) /* Event Mask on line 3 */
#define EXTI_EMASK_EMASK4                   ((uint32_t)0x00000010U) /* Event Mask on line 4 */
#define EXTI_EMASK_EMASK5                   ((uint32_t)0x00000020U) /* Event Mask on line 5 */
#define EXTI_EMASK_EMASK6                   ((uint32_t)0x00000040U) /* Event Mask on line 6 */
#define EXTI_EMASK_EMASK7                   ((uint32_t)0x00000080U) /* Event Mask on line 7 */
#define EXTI_EMASK_EMASK8                   ((uint32_t)0x00000100U) /* Event Mask on line 8 */
#define EXTI_EMASK_EMASK9                   ((uint32_t)0x00000200U) /* Event Mask on line 9 */
#define EXTI_EMASK_EMASK10                  ((uint32_t)0x00000400U) /* Event Mask on line 10 */
#define EXTI_EMASK_EMASK11                  ((uint32_t)0x00000800U) /* Event Mask on line 11 */
#define EXTI_EMASK_EMASK12                  ((uint32_t)0x00001000U) /* Event Mask on line 12 */
#define EXTI_EMASK_EMASK13                  ((uint32_t)0x00002000U) /* Event Mask on line 13 */
#define EXTI_EMASK_EMASK14                  ((uint32_t)0x00004000U) /* Event Mask on line 14 */
#define EXTI_EMASK_EMASK15                  ((uint32_t)0x00008000U) /* Event Mask on line 15 */
#define EXTI_EMASK_EMASK16                  ((uint32_t)0x00010000U) /* Event Mask on line 16 */
#define EXTI_EMASK_EMASK17                  ((uint32_t)0x00020000U) /* Event Mask on line 17 */
#define EXTI_EMASK_EMASK18                  ((uint32_t)0x00040000U) /* Event Mask on line 18 */
#define EXTI_EMASK_EMASK19                  ((uint32_t)0x00080000U) /* Event Mask on line 19 */
#define EXTI_EMASK_EMASK20                  ((uint32_t)0x00100000U) /* Event Mask on line 20 */
#define EXTI_EMASK_EMASK21                  ((uint32_t)0x00200000U) /* Event Mask on line 21 */
#define EXTI_EMASK_EMASK22                  ((uint32_t)0x00400000U) /* Event Mask on line 22 */
#define EXTI_EMASK_EMASK23                  ((uint32_t)0x00800000U) /* Event Mask on line 23 */
#define EXTI_EMASK_EMASK24                  ((uint32_t)0x01000000U) /* Event Mask on line 24 */
#define EXTI_EMASK_EMASK25                  ((uint32_t)0x02000000U) /* Event Mask on line 25 */
#define EXTI_EMASK_EMASK26                  ((uint32_t)0x04000000U) /* Event Mask on line 26 */
#define EXTI_EMASK_EMASK27                  ((uint32_t)0x08000000U) /* Event Mask on line 27 */
#define EXTI_EMASK_EMASK28                  ((uint32_t)0x10000000U) /* Event Mask on line 28 */
#define EXTI_EMASK_EMASK29                  ((uint32_t)0x20000000U) /* Event Mask on line 29 */
#define EXTI_EMASK_EMASK30                  ((uint32_t)0x40000000U) /* Event Mask on line 30 */
#define EXTI_EMASK_EMASK31                  ((uint32_t)0x80000000U) /* Event Mask on line 31 */

/** Bit definition for EXTI_IMASK register **/
#define EXTI_IMASK_IMASK0                   ((uint32_t)0x00000001U) /* Interrupt Mask on line 0 */
#define EXTI_IMASK_IMASK1                   ((uint32_t)0x00000002U) /* Interrupt Mask on line 1 */
#define EXTI_IMASK_IMASK2                   ((uint32_t)0x00000004U) /* Interrupt Mask on line 2 */
#define EXTI_IMASK_IMASK3                   ((uint32_t)0x00000008U) /* Interrupt Mask on line 3 */
#define EXTI_IMASK_IMASK4                   ((uint32_t)0x00000010U) /* Interrupt Mask on line 4 */
#define EXTI_IMASK_IMASK5                   ((uint32_t)0x00000020U) /* Interrupt Mask on line 5 */
#define EXTI_IMASK_IMASK6                   ((uint32_t)0x00000040U) /* Interrupt Mask on line 6 */
#define EXTI_IMASK_IMASK7                   ((uint32_t)0x00000080U) /* Interrupt Mask on line 7 */
#define EXTI_IMASK_IMASK8                   ((uint32_t)0x00000100U) /* Interrupt Mask on line 8 */
#define EXTI_IMASK_IMASK9                   ((uint32_t)0x00000200U) /* Interrupt Mask on line 9 */
#define EXTI_IMASK_IMASK10                  ((uint32_t)0x00000400U) /* Interrupt Mask on line 10 */
#define EXTI_IMASK_IMASK11                  ((uint32_t)0x00000800U) /* Interrupt Mask on line 11 */
#define EXTI_IMASK_IMASK12                  ((uint32_t)0x00001000U) /* Interrupt Mask on line 12 */
#define EXTI_IMASK_IMASK13                  ((uint32_t)0x00002000U) /* Interrupt Mask on line 13 */
#define EXTI_IMASK_IMASK14                  ((uint32_t)0x00004000U) /* Interrupt Mask on line 14 */
#define EXTI_IMASK_IMASK15                  ((uint32_t)0x00008000U) /* Interrupt Mask on line 15 */
#define EXTI_IMASK_IMASK16                  ((uint32_t)0x00010000U) /* Interrupt Mask on line 16 */
#define EXTI_IMASK_IMASK17                  ((uint32_t)0x00020000U) /* Interrupt Mask on line 17 */
#define EXTI_IMASK_IMASK18                  ((uint32_t)0x00040000U) /* Interrupt Mask on line 18 */
#define EXTI_IMASK_IMASK19                  ((uint32_t)0x00080000U) /* Interrupt Mask on line 19 */
#define EXTI_IMASK_IMASK20                  ((uint32_t)0x00100000U) /* Interrupt Mask on line 20 */
#define EXTI_IMASK_IMASK21                  ((uint32_t)0x00200000U) /* Interrupt Mask on line 21 */
#define EXTI_IMASK_IMASK22                  ((uint32_t)0x00400000U) /* Interrupt Mask on line 22 */
#define EXTI_IMASK_IMASK23                  ((uint32_t)0x00800000U) /* Interrupt Mask on line 23 */
#define EXTI_IMASK_IMASK24                  ((uint32_t)0x01000000U) /* Interrupt Mask on line 24 */
#define EXTI_IMASK_IMASK25                  ((uint32_t)0x02000000U) /* Interrupt Mask on line 25 */
#define EXTI_IMASK_IMASK26                  ((uint32_t)0x04000000U) /* Interrupt Mask on line 26 */
#define EXTI_IMASK_IMASK27                  ((uint32_t)0x08000000U) /* Interrupt Mask on line 27 */
#define EXTI_IMASK_IMASK28                  ((uint32_t)0x10000000U) /* Interrupt Mask on line 28 */
#define EXTI_IMASK_IMASK29                  ((uint32_t)0x20000000U) /* Interrupt Mask on line 29 */
#define EXTI_IMASK_IMASK30                  ((uint32_t)0x40000000U) /* Interrupt Mask on line 30 */
#define EXTI_IMASK_IMASK31                  ((uint32_t)0x80000000U) /* Interrupt Mask on line 31 */


/** Bit definition for EXTI_FT_CFG register **/
#define EXTI_FT_CFG_FT_CFG0                 ((uint32_t)0x00000001U) /* Falling trigger event configuration bit of line 0 */
#define EXTI_FT_CFG_FT_CFG1                 ((uint32_t)0x00000002U) /* Falling trigger event configuration bit of line 1 */
#define EXTI_FT_CFG_FT_CFG2                 ((uint32_t)0x00000004U) /* Falling trigger event configuration bit of line 2 */
#define EXTI_FT_CFG_FT_CFG3                 ((uint32_t)0x00000008U) /* Falling trigger event configuration bit of line 3 */
#define EXTI_FT_CFG_FT_CFG4                 ((uint32_t)0x00000010U) /* Falling trigger event configuration bit of line 4 */
#define EXTI_FT_CFG_FT_CFG5                 ((uint32_t)0x00000020U) /* Falling trigger event configuration bit of line 5 */
#define EXTI_FT_CFG_FT_CFG6                 ((uint32_t)0x00000040U) /* Falling trigger event configuration bit of line 6 */
#define EXTI_FT_CFG_FT_CFG7                 ((uint32_t)0x00000080U) /* Falling trigger event configuration bit of line 7 */
#define EXTI_FT_CFG_FT_CFG8                 ((uint32_t)0x00000100U) /* Falling trigger event configuration bit of line 8 */
#define EXTI_FT_CFG_FT_CFG9                 ((uint32_t)0x00000200U) /* Falling trigger event configuration bit of line 9 */
#define EXTI_FT_CFG_FT_CFG10                ((uint32_t)0x00000400U) /* Falling trigger event configuration bit of line 10 */
#define EXTI_FT_CFG_FT_CFG11                ((uint32_t)0x00000800U) /* Falling trigger event configuration bit of line 11 */
#define EXTI_FT_CFG_FT_CFG12                ((uint32_t)0x00001000U) /* Falling trigger event configuration bit of line 12 */
#define EXTI_FT_CFG_FT_CFG13                ((uint32_t)0x00002000U) /* Falling trigger event configuration bit of line 13 */
#define EXTI_FT_CFG_FT_CFG14                ((uint32_t)0x00004000U) /* Falling trigger event configuration bit of line 14 */
#define EXTI_FT_CFG_FT_CFG15                ((uint32_t)0x00008000U) /* Falling trigger event configuration bit of line 15 */
#define EXTI_FT_CFG_FT_CFG16                ((uint32_t)0x00010000U) /* Falling trigger event configuration bit of line 16 */
#define EXTI_FT_CFG_FT_CFG17                ((uint32_t)0x00020000U) /* Falling trigger event configuration bit of line 17 */
#define EXTI_FT_CFG_FT_CFG18                ((uint32_t)0x00040000U) /* Falling trigger event configuration bit of line 18 */
#define EXTI_FT_CFG_FT_CFG19                ((uint32_t)0x00080000U) /* Falling trigger event configuration bit of line 19 */
#define EXTI_FT_CFG_FT_CFG20                ((uint32_t)0x00100000U) /* Falling trigger event configuration bit of line 20 */
#define EXTI_FT_CFG_FT_CFG21                ((uint32_t)0x00200000U) /* Falling trigger event configuration bit of line 21 */
#define EXTI_FT_CFG_FT_CFG22                ((uint32_t)0x00400000U) /* Falling trigger event configuration bit of line 22 */
#define EXTI_FT_CFG_FT_CFG23                ((uint32_t)0x00800000U) /* Falling trigger event configuration bit of line 23 */
#define EXTI_FT_CFG_FT_CFG24                ((uint32_t)0x01000000U) /* Falling trigger event configuration bit of line 24 */
#define EXTI_FT_CFG_FT_CFG25                ((uint32_t)0x02000000U) /* Falling trigger event configuration bit of line 25 */
#define EXTI_FT_CFG_FT_CFG26                ((uint32_t)0x04000000U) /* Falling trigger event configuration bit of line 26 */
#define EXTI_FT_CFG_FT_CFG27                ((uint32_t)0x08000000U) /* Falling trigger event configuration bit of line 27 */
#define EXTI_FT_CFG_FT_CFG28                ((uint32_t)0x10000000U) /* Falling trigger event configuration bit of line 28 */
#define EXTI_FT_CFG_FT_CFG29                ((uint32_t)0x20000000U) /* Falling trigger event configuration bit of line 29 */
#define EXTI_FT_CFG_FT_CFG30                ((uint32_t)0x40000000U) /* Falling trigger event configuration bit of line 30 */
#define EXTI_FT_CFG_FT_CFG31                ((uint32_t)0x80000000U) /* Falling trigger event configuration bit of line 31 */


/** Bit definition for EXTI_RT_CFG register **/
#define EXTI_RT_CFG_RT_CFG0                 ((uint32_t)0x00000001U) /* Rising trigger event configuration bit of line 0 */
#define EXTI_RT_CFG_RT_CFG1                 ((uint32_t)0x00000002U) /* Rising trigger event configuration bit of line 1 */
#define EXTI_RT_CFG_RT_CFG2                 ((uint32_t)0x00000004U) /* Rising trigger event configuration bit of line 2 */
#define EXTI_RT_CFG_RT_CFG3                 ((uint32_t)0x00000008U) /* Rising trigger event configuration bit of line 3 */
#define EXTI_RT_CFG_RT_CFG4                 ((uint32_t)0x00000010U) /* Rising trigger event configuration bit of line 4 */
#define EXTI_RT_CFG_RT_CFG5                 ((uint32_t)0x00000020U) /* Rising trigger event configuration bit of line 5 */
#define EXTI_RT_CFG_RT_CFG6                 ((uint32_t)0x00000040U) /* Rising trigger event configuration bit of line 6 */
#define EXTI_RT_CFG_RT_CFG7                 ((uint32_t)0x00000080U) /* Rising trigger event configuration bit of line 7 */
#define EXTI_RT_CFG_RT_CFG8                 ((uint32_t)0x00000100U) /* Rising trigger event configuration bit of line 8 */
#define EXTI_RT_CFG_RT_CFG9                 ((uint32_t)0x00000200U) /* Rising trigger event configuration bit of line 9 */
#define EXTI_RT_CFG_RT_CFG10                ((uint32_t)0x00000400U) /* Rising trigger event configuration bit of line 10 */
#define EXTI_RT_CFG_RT_CFG11                ((uint32_t)0x00000800U) /* Rising trigger event configuration bit of line 11 */
#define EXTI_RT_CFG_RT_CFG12                ((uint32_t)0x00001000U) /* Rising trigger event configuration bit of line 12 */
#define EXTI_RT_CFG_RT_CFG13                ((uint32_t)0x00002000U) /* Rising trigger event configuration bit of line 13 */
#define EXTI_RT_CFG_RT_CFG14                ((uint32_t)0x00004000U) /* Rising trigger event configuration bit of line 14 */
#define EXTI_RT_CFG_RT_CFG15                ((uint32_t)0x00008000U) /* Rising trigger event configuration bit of line 15 */
#define EXTI_RT_CFG_RT_CFG16                ((uint32_t)0x00010000U) /* Rising trigger event configuration bit of line 16 */
#define EXTI_RT_CFG_RT_CFG17                ((uint32_t)0x00020000U) /* Rising trigger event configuration bit of line 17 */
#define EXTI_RT_CFG_RT_CFG18                ((uint32_t)0x00040000U) /* Rising trigger event configuration bit of line 18 */
#define EXTI_RT_CFG_RT_CFG19                ((uint32_t)0x00080000U) /* Rising trigger event configuration bit of line 19 */
#define EXTI_RT_CFG_RT_CFG20                ((uint32_t)0x00100000U) /* Rising trigger event configuration bit of line 20 */
#define EXTI_RT_CFG_RT_CFG21                ((uint32_t)0x00200000U) /* Rising trigger event configuration bit of line 21 */
#define EXTI_RT_CFG_RT_CFG22                ((uint32_t)0x00400000U) /* Rising trigger event configuration bit of line 22 */
#define EXTI_RT_CFG_RT_CFG23                ((uint32_t)0x00800000U) /* Rising trigger event configuration bit of line 23 */
#define EXTI_RT_CFG_RT_CFG24                ((uint32_t)0x01000000U) /* Rising trigger event configuration bit of line 24 */
#define EXTI_RT_CFG_RT_CFG25                ((uint32_t)0x02000000U) /* Rising trigger event configuration bit of line 25 */
#define EXTI_RT_CFG_RT_CFG26                ((uint32_t)0x04000000U) /* Rising trigger event configuration bit of line 26 */
#define EXTI_RT_CFG_RT_CFG27                ((uint32_t)0x08000000U) /* Rising trigger event configuration bit of line 27 */
#define EXTI_RT_CFG_RT_CFG28                ((uint32_t)0x10000000U) /* Rising trigger event configuration bit of line 28 */
#define EXTI_RT_CFG_RT_CFG29                ((uint32_t)0x20000000U) /* Rising trigger event configuration bit of line 29 */
#define EXTI_RT_CFG_RT_CFG30                ((uint32_t)0x40000000U) /* Rising trigger event configuration bit of line 30 */
#define EXTI_RT_CFG_RT_CFG31                ((uint32_t)0x80000000U) /* Rising trigger event configuration bit of line 31 */

/** Bit definition for EXTI_PEND register **/
#define EXTI_PEND_PEND0                     ((uint32_t)0x00000001U) /* Pending bit for line 0 */
#define EXTI_PEND_PEND1                     ((uint32_t)0x00000002U) /* Pending bit for line 1 */
#define EXTI_PEND_PEND2                     ((uint32_t)0x00000004U) /* Pending bit for line 2 */
#define EXTI_PEND_PEND3                     ((uint32_t)0x00000008U) /* Pending bit for line 3 */
#define EXTI_PEND_PEND4                     ((uint32_t)0x00000010U) /* Pending bit for line 4 */
#define EXTI_PEND_PEND5                     ((uint32_t)0x00000020U) /* Pending bit for line 5 */
#define EXTI_PEND_PEND6                     ((uint32_t)0x00000040U) /* Pending bit for line 6 */
#define EXTI_PEND_PEND7                     ((uint32_t)0x00000080U) /* Pending bit for line 7 */
#define EXTI_PEND_PEND8                     ((uint32_t)0x00000100U) /* Pending bit for line 8 */
#define EXTI_PEND_PEND9                     ((uint32_t)0x00000200U) /* Pending bit for line 9 */
#define EXTI_PEND_PEND10                    ((uint32_t)0x00000400U) /* Pending bit for line 10 */
#define EXTI_PEND_PEND11                    ((uint32_t)0x00000800U) /* Pending bit for line 11 */
#define EXTI_PEND_PEND12                    ((uint32_t)0x00001000U) /* Pending bit for line 12 */
#define EXTI_PEND_PEND13                    ((uint32_t)0x00002000U) /* Pending bit for line 13 */
#define EXTI_PEND_PEND14                    ((uint32_t)0x00004000U) /* Pending bit for line 14 */
#define EXTI_PEND_PEND15                    ((uint32_t)0x00008000U) /* Pending bit for line 15 */
#define EXTI_PEND_PEND16                    ((uint32_t)0x00010000U) /* Pending bit for line 16 */
#define EXTI_PEND_PEND17                    ((uint32_t)0x00020000U) /* Pending bit for line 17 */
#define EXTI_PEND_PEND18                    ((uint32_t)0x00040000U) /* Pending bit for line 18 */
#define EXTI_PEND_PEND19                    ((uint32_t)0x00080000U) /* Pending bit for line 19 */
#define EXTI_PEND_PEND20                    ((uint32_t)0x00100000U) /* Pending bit for line 20 */
#define EXTI_PEND_PEND21                    ((uint32_t)0x00200000U) /* Pending bit for line 21 */
#define EXTI_PEND_PEND22                    ((uint32_t)0x00400000U) /* Pending bit for line 22 */
#define EXTI_PEND_PEND23                    ((uint32_t)0x00800000U) /* Pending bit for line 23 */
#define EXTI_PEND_PEND24                    ((uint32_t)0x01000000U) /* Pending bit for line 24 */
#define EXTI_PEND_PEND25                    ((uint32_t)0x02000000U) /* Pending bit for line 25 */
#define EXTI_PEND_PEND26                    ((uint32_t)0x04000000U) /* Pending bit for line 26 */
#define EXTI_PEND_PEND27                    ((uint32_t)0x08000000U) /* Pending bit for line 27 */
#define EXTI_PEND_PEND28                    ((uint32_t)0x10000000U) /* Pending bit for line 28 */
#define EXTI_PEND_PEND29                    ((uint32_t)0x20000000U) /* Pending bit for line 29 */
#define EXTI_PEND_PEND30                    ((uint32_t)0x40000000U) /* Pending bit for line 30 */
#define EXTI_PEND_PEND31                    ((uint32_t)0x80000000U) /* Pending bit for line 31 */


/** Bit definition for EXTI_SWIE register **/
#define EXTI_SWIE_SWIE0                     ((uint32_t)0x00000001U) /* Software Interrupt request bit for line 0 */
#define EXTI_SWIE_SWIE1                     ((uint32_t)0x00000002U) /* Software Interrupt request bit for line 1 */
#define EXTI_SWIE_SWIE2                     ((uint32_t)0x00000004U) /* Software Interrupt request bit for line 2 */
#define EXTI_SWIE_SWIE3                     ((uint32_t)0x00000008U) /* Software Interrupt request bit for line 3 */
#define EXTI_SWIE_SWIE4                     ((uint32_t)0x00000010U) /* Software Interrupt request bit for line 4 */
#define EXTI_SWIE_SWIE5                     ((uint32_t)0x00000020U) /* Software Interrupt request bit for line 5 */
#define EXTI_SWIE_SWIE6                     ((uint32_t)0x00000040U) /* Software Interrupt request bit for line 6 */
#define EXTI_SWIE_SWIE7                     ((uint32_t)0x00000080U) /* Software Interrupt request bit for line 7 */
#define EXTI_SWIE_SWIE8                     ((uint32_t)0x00000100U) /* Software Interrupt request bit for line 8 */
#define EXTI_SWIE_SWIE9                     ((uint32_t)0x00000200U) /* Software Interrupt request bit for line 9 */
#define EXTI_SWIE_SWIE10                    ((uint32_t)0x00000400U) /* Software Interrupt request bit for line 10 */
#define EXTI_SWIE_SWIE11                    ((uint32_t)0x00000800U) /* Software Interrupt request bit for line 11 */
#define EXTI_SWIE_SWIE12                    ((uint32_t)0x00001000U) /* Software Interrupt request bit for line 12 */
#define EXTI_SWIE_SWIE13                    ((uint32_t)0x00002000U) /* Software Interrupt request bit for line 13 */
#define EXTI_SWIE_SWIE14                    ((uint32_t)0x00004000U) /* Software Interrupt request bit for line 14 */
#define EXTI_SWIE_SWIE15                    ((uint32_t)0x00008000U) /* Software Interrupt request bit for line 15 */
#define EXTI_SWIE_SWIE16                    ((uint32_t)0x00010000U) /* Software Interrupt request bit for line 16 */
#define EXTI_SWIE_SWIE17                    ((uint32_t)0x00020000U) /* Software Interrupt request bit for line 17 */
#define EXTI_SWIE_SWIE18                    ((uint32_t)0x00040000U) /* Software Interrupt request bit for line 18 */
#define EXTI_SWIE_SWIE19                    ((uint32_t)0x00080000U) /* Software Interrupt request bit for line 19 */
#define EXTI_SWIE_SWIE20                    ((uint32_t)0x00100000U) /* Software Interrupt request bit for line 20 */
#define EXTI_SWIE_SWIE21                    ((uint32_t)0x00200000U) /* Software Interrupt request bit for line 21 */
#define EXTI_SWIE_SWIE22                    ((uint32_t)0x00400000U) /* Software Interrupt request bit for line 22 */
#define EXTI_SWIE_SWIE23                    ((uint32_t)0x00800000U) /* Software Interrupt request bit for line 23 */
#define EXTI_SWIE_SWIE24                    ((uint32_t)0x01000000U) /* Software Interrupt request bit for line 24 */
#define EXTI_SWIE_SWIE25                    ((uint32_t)0x02000000U) /* Software Interrupt request bit for line 25 */
#define EXTI_SWIE_SWIE26                    ((uint32_t)0x04000000U) /* Software Interrupt request bit for line 26 */
#define EXTI_SWIE_SWIE27                    ((uint32_t)0x08000000U) /* Software Interrupt request bit for line 27 */
#define EXTI_SWIE_SWIE28                    ((uint32_t)0x10000000U) /* Software Interrupt request bit for line 28 */
#define EXTI_SWIE_SWIE29                    ((uint32_t)0x20000000U) /* Software Interrupt request bit for line 29 */
#define EXTI_SWIE_SWIE30                    ((uint32_t)0x40000000U) /* Software Interrupt request bit for line 30 */
#define EXTI_SWIE_SWIE31                    ((uint32_t)0x80000000U) /* Software Interrupt request bit for line 31 */

/** Bit definition for EXTI_TS_SEL register **/
#define EXTI_TS_SEL_TSSEL                   ((uint32_t)0x0000000FU) /* RTC timestamp input source select bits */
#define EXTI_TS_SEL_TSSEL_0                 ((uint32_t)0x00000001U) /* RTC timestamp input source select bit 0 */
#define EXTI_TS_SEL_TSSEL_1                 ((uint32_t)0x00000002U) /* RTC timestamp input source select bit 1 */
#define EXTI_TS_SEL_TSSEL_2                 ((uint32_t)0x00000004U) /* RTC timestamp input source select bit 2 */
#define EXTI_TS_SEL_TSSEL_3                 ((uint32_t)0x00000008U) /* RTC timestamp input source select bit 3 */

#define EXTI_TS_SEL_EXTI0                   ((uint32_t)0x00000000U) /* Select EXTI0  as trigger source of timestamp event */
#define EXTI_TS_SEL_EXTI1                   ((uint32_t)0x00000001U) /* Select EXTI1  as trigger source of timestamp event */
#define EXTI_TS_SEL_EXTI2                   ((uint32_t)0x00000002U) /* Select EXTI2  as trigger source of timestamp event */
#define EXTI_TS_SEL_EXTI3                   ((uint32_t)0x00000003U) /* Select EXTI3  as trigger source of timestamp event */
#define EXTI_TS_SEL_EXTI4                   ((uint32_t)0x00000004U) /* Select EXTI4  as trigger source of timestamp event */
#define EXTI_TS_SEL_EXTI5                   ((uint32_t)0x00000005U) /* Select EXTI5  as trigger source of timestamp event */
#define EXTI_TS_SEL_EXTI6                   ((uint32_t)0x00000006U) /* Select EXTI6  as trigger source of timestamp event */
#define EXTI_TS_SEL_EXTI7                   ((uint32_t)0x00000007U) /* Select EXTI7  as trigger source of timestamp event */
#define EXTI_TS_SEL_EXTI8                   ((uint32_t)0x00000008U) /* Select EXTI8  as trigger source of timestamp event */
#define EXTI_TS_SEL_EXTI9                   ((uint32_t)0x00000009U) /* Select EXTI9  as trigger source of timestamp event */
#define EXTI_TS_SEL_EXTI10                  ((uint32_t)0x0000000AU) /* Select EXTI10 as trigger source of timestamp event */
#define EXTI_TS_SEL_EXTI11                  ((uint32_t)0x0000000BU) /* Select EXTI11 as trigger source of timestamp event */
#define EXTI_TS_SEL_EXTI12                  ((uint32_t)0x0000000CU) /* Select EXTI12 as trigger source of timestamp event */
#define EXTI_TS_SEL_EXTI13                  ((uint32_t)0x0000000DU) /* Select EXTI13 as trigger source of timestamp event */
#define EXTI_TS_SEL_EXTI14                  ((uint32_t)0x0000000EU) /* Select EXTI14 as trigger source of timestamp event */
#define EXTI_TS_SEL_EXTI15                  ((uint32_t)0x0000000FU) /* Select EXTI15 as trigger source of timestamp event */

/*** Direct Memory Access controller ***/

/** Bit definition for DMA_CHCFG1 register **/
#define  DMA_CHCFG1_CHEN              ((uint16_t)0x0001U)      /* Channel enable*/
#define  DMA_CHCFG1_TXCIE             ((uint16_t)0x0002U)      /* Transfer complete interrupt enable */
#define  DMA_CHCFG1_HTXIE             ((uint16_t)0x0004U)      /* Half Transfer interrupt enable */
#define  DMA_CHCFG1_ERRIE             ((uint16_t)0x0008U)      /* Transfer error interrupt enable */
#define  DMA_CHCFG1_DIR               ((uint16_t)0x0010U)      /* Data transfer direction */
#define  DMA_CHCFG1_CIRC              ((uint16_t)0x0020U)      /* Circular mode */
#define  DMA_CHCFG1_PINC              ((uint16_t)0x0040U)      /* Peripheral increment mode */
#define  DMA_CHCFG1_MINC              ((uint16_t)0x0080U)      /* Memory increment mode */
                  
#define  DMA_CHCFG1_PSIZE             ((uint16_t)0x0300U)     /* PSIZE[1:0] bits (Peripheral size) */
#define  DMA_CHCFG1_PSIZE_0           ((uint16_t)0x0100U)     /* Bit 0 */
#define  DMA_CHCFG1_PSIZE_1           ((uint16_t)0x0200U)     /* Bit 1 */
                  
#define  DMA_CHCFG1_MSIZE             ((uint16_t)0x0C00U)     /* MSIZE[1:0] bits (Memory size) */
#define  DMA_CHCFG1_MSIZE_0           ((uint16_t)0x0400U)     /* Bit 0 */
#define  DMA_CHCFG1_MSIZE_1           ((uint16_t)0x0800U)     /* Bit 1 */
                  
#define  DMA_CHCFG1_PRIOLVL           ((uint16_t)0x3000U)     /* PRIOLVL[1:0] bits(Channel Priority level) */
#define  DMA_CHCFG1_PRIOLVL_0         ((uint16_t)0x1000U)     /* Bit 0 */
#define  DMA_CHCFG1_PRIOLVL_1         ((uint16_t)0x2000U)     /* Bit 1 */
                  
#define  DMA_CHCFG1_MEM2MEM           ((uint16_t)0x4000U)     /* Memory to memory mode */
                  
#define  DMA_CHCFG1_BURST_ALMOST      ((uint32_t)0x00000000U) /* BURST almost mode */
#define  DMA_CHCFG1_BURST_DYNAMIC     ((uint32_t)0x00008000U) /* BURST dynamic mode */
#define  DMA_CHCFG1_BURST_BLEN        ((uint32_t)0x000F0000U) /* BURST length is same as single mode */
#define  DMA_CHCFG1_BURST_BLEN_0      ((uint32_t)0x00010000U) /* Bit 0 */
#define  DMA_CHCFG1_BURST_BLEN_1      ((uint32_t)0x00020000U) /* Bit 1 */
#define  DMA_CHCFG1_BURST_BLEN_2      ((uint32_t)0x00040000U) /* Bit 2 */
#define  DMA_CHCFG1_BURST_BLEN_3      ((uint32_t)0x00080000U) /* Bit 3 */

/** Bit definition for DMA_CHCFG2 register **/
#define  DMA_CHCFG2_CHEN              ((uint16_t)0x0001U)     /* Channel enable*/
#define  DMA_CHCFG2_TXCIE             ((uint16_t)0x0002U)     /* Transfer complete interrupt enable */
#define  DMA_CHCFG2_HTXIE             ((uint16_t)0x0004U)     /* Half Transfer interrupt enable */
#define  DMA_CHCFG2_ERRIE             ((uint16_t)0x0008U)     /* Transfer error interrupt enable */
#define  DMA_CHCFG2_DIR               ((uint16_t)0x0010U)     /* Data transfer direction */
#define  DMA_CHCFG2_CIRC              ((uint16_t)0x0020U)     /* Circular mode */
#define  DMA_CHCFG2_PINC              ((uint16_t)0x0040U)     /* Peripheral increment mode */
#define  DMA_CHCFG2_MINC              ((uint16_t)0x0080U)     /* Memory increment mode */
                                      
#define  DMA_CHCFG2_PSIZE             ((uint16_t)0x0300U)     /* PSIZE[1:0] bits (Peripheral size) */
#define  DMA_CHCFG2_PSIZE_0           ((uint16_t)0x0100U)     /* Bit 0 */
#define  DMA_CHCFG2_PSIZE_1           ((uint16_t)0x0200U)     /* Bit 1 */
                                      
#define  DMA_CHCFG2_MSIZE             ((uint16_t)0x0C00U)     /* MSIZE[1:0] bits (Memory size) */
#define  DMA_CHCFG2_MSIZE_0           ((uint16_t)0x0400U)     /* Bit 0 */
#define  DMA_CHCFG2_MSIZE_1           ((uint16_t)0x0800U)     /* Bit 1 */
                                      
#define  DMA_CHCFG2_PRIOLVL           ((uint16_t)0x3000U)     /* PRIOLVL[1:0] bits(Channel Priority level) */
#define  DMA_CHCFG2_PRIOLVL_0         ((uint16_t)0x1000U)     /* Bit 0 */
#define  DMA_CHCFG2_PRIOLVL_1         ((uint16_t)0x2000U)     /* Bit 1 */
                                      
#define  DMA_CHCFG2_MEM2MEM           ((uint16_t)0x4000U)     /* Memory to memory mode */
                  
#define  DMA_CHCFG2_BURST_ALMOST      ((uint32_t)0x00000000U) /* BURST almost mode */
#define  DMA_CHCFG2_BURST_DYNAMIC     ((uint32_t)0x00008000U) /* BURST dynamic mode */
#define  DMA_CHCFG2_BURST_BLEN        ((uint32_t)0x000F0000U) /* BURST length is same as single mode */
#define  DMA_CHCFG2_BURST_BLEN_0      ((uint32_t)0x00010000U) /* Bit 0 */
#define  DMA_CHCFG2_BURST_BLEN_1      ((uint32_t)0x00020000U) /* Bit 1 */
#define  DMA_CHCFG2_BURST_BLEN_2      ((uint32_t)0x00040000U) /* Bit 2 */
#define  DMA_CHCFG2_BURST_BLEN_3      ((uint32_t)0x00080000U) /* Bit 3 */

/** Bit definition for DMA_CHCFG3 register **/
#define  DMA_CHCFG3_CHEN              ((uint16_t)0x0001U)     /* Channel enable*/
#define  DMA_CHCFG3_TXCIE             ((uint16_t)0x0002U)     /* Transfer complete interrupt enable */
#define  DMA_CHCFG3_HTXIE             ((uint16_t)0x0004U)     /* Half Transfer interrupt enable */
#define  DMA_CHCFG3_ERRIE             ((uint16_t)0x0008U)     /* Transfer error interrupt enable */
#define  DMA_CHCFG3_DIR               ((uint16_t)0x0010U)     /* Data transfer direction */
#define  DMA_CHCFG3_CIRC              ((uint16_t)0x0020U)     /* Circular mode */
#define  DMA_CHCFG3_PINC              ((uint16_t)0x0040U)     /* Peripheral increment mode */
#define  DMA_CHCFG3_MINC              ((uint16_t)0x0080U)     /* Memory increment mode */
                  
#define  DMA_CHCFG3_PSIZE             ((uint16_t)0x0300U)     /* PSIZE[1:0] bits (Peripheral size) */
#define  DMA_CHCFG3_PSIZE_0           ((uint16_t)0x0100U)     /* Bit 0 */
#define  DMA_CHCFG3_PSIZE_1           ((uint16_t)0x0200U)     /* Bit 1 */
                  
#define  DMA_CHCFG3_MSIZE             ((uint16_t)0x0C00U)     /* MSIZE[1:0] bits (Memory size) */
#define  DMA_CHCFG3_MSIZE_0           ((uint16_t)0x0400U)     /* Bit 0 */
#define  DMA_CHCFG3_MSIZE_1           ((uint16_t)0x0800U)     /* Bit 1 */
                  
#define  DMA_CHCFG3_PRIOLVL           ((uint16_t)0x3000U)     /* PRIOLVL[1:0] bits(Channel Priority level) */
#define  DMA_CHCFG3_PRIOLVL_0         ((uint16_t)0x1000U)     /* Bit 0 */
#define  DMA_CHCFG3_PRIOLVL_1         ((uint16_t)0x2000U)     /* Bit 1 */
                  
#define  DMA_CHCFG3_MEM2MEM           ((uint16_t)0x4000U)     /* Memory to memory mode */
                  
#define  DMA_CHCFG3_BURST_ALMOST      ((uint32_t)0x00000000U) /* BURST almost mode */
#define  DMA_CHCFG3_BURST_DYNAMIC     ((uint32_t)0x00008000U) /* BURST dynamic mode */
#define  DMA_CHCFG3_BURST_BLEN        ((uint32_t)0x000F0000U) /* BURST length is same as single mode */
#define  DMA_CHCFG3_BURST_BLEN_0      ((uint32_t)0x00010000U) /* Bit 0 */
#define  DMA_CHCFG3_BURST_BLEN_1      ((uint32_t)0x00020000U) /* Bit 1 */
#define  DMA_CHCFG3_BURST_BLEN_2      ((uint32_t)0x00040000U) /* Bit 2 */
#define  DMA_CHCFG3_BURST_BLEN_3      ((uint32_t)0x00080000U) /* Bit 3 */

/** Bit definition for DMA_CHCFG4 register **/
#define  DMA_CHCFG4_CHEN              ((uint16_t)0x0001U)     /* Channel enable*/
#define  DMA_CHCFG4_TXCIE             ((uint16_t)0x0002U)     /* Transfer complete interrupt enable */
#define  DMA_CHCFG4_HTXIE             ((uint16_t)0x0004U)     /* Half Transfer interrupt enable */
#define  DMA_CHCFG4_ERRIE             ((uint16_t)0x0008U)     /* Transfer error interrupt enable */
#define  DMA_CHCFG4_DIR               ((uint16_t)0x0010U)     /* Data transfer direction */
#define  DMA_CHCFG4_CIRC              ((uint16_t)0x0020U)     /* Circular mode */
#define  DMA_CHCFG4_PINC              ((uint16_t)0x0040U)     /* Peripheral increment mode */
#define  DMA_CHCFG4_MINC              ((uint16_t)0x0080U)     /* Memory increment mode */
                  
#define  DMA_CHCFG4_PSIZE             ((uint16_t)0x0300U)     /* PSIZE[1:0] bits (Peripheral size) */
#define  DMA_CHCFG4_PSIZE_0           ((uint16_t)0x0100U)     /* Bit 0 */
#define  DMA_CHCFG4_PSIZE_1           ((uint16_t)0x0200U)     /* Bit 1 */
                  
#define  DMA_CHCFG4_MSIZE             ((uint16_t)0x0C00U)     /* MSIZE[1:0] bits (Memory size) */
#define  DMA_CHCFG4_MSIZE_0           ((uint16_t)0x0400U)     /* Bit 0 */
#define  DMA_CHCFG4_MSIZE_1           ((uint16_t)0x0800U)     /* Bit 1 */
                                                      
#define  DMA_CHCFG4_PRIOLVL           ((uint16_t)0x3000U)     /* PRIOLVL[1:0] bits(Channel Priority level) */
#define  DMA_CHCFG4_PRIOLVL_0         ((uint16_t)0x1000U)     /* Bit 0 */
#define  DMA_CHCFG4_PRIOLVL_1         ((uint16_t)0x2000U)     /* Bit 1 */
                  
#define  DMA_CHCFG4_MEM2MEM           ((uint16_t)0x4000U)     /* Memory to memory mode */
                  
#define  DMA_CHCFG4_BURST_ALMOST      ((uint32_t)0x00000000U) /* BURST almost mode */
#define  DMA_CHCFG4_BURST_DYNAMIC     ((uint32_t)0x00008000U) /* BURST dynamic mode */
#define  DMA_CHCFG4_BURST_BLEN        ((uint32_t)0x000F0000U) /* BURST length is same as single mode */
#define  DMA_CHCFG4_BURST_BLEN_0      ((uint32_t)0x00010000U) /* Bit 0 */
#define  DMA_CHCFG4_BURST_BLEN_1      ((uint32_t)0x00020000U) /* Bit 1 */
#define  DMA_CHCFG4_BURST_BLEN_2      ((uint32_t)0x00040000U) /* Bit 2 */
#define  DMA_CHCFG4_BURST_BLEN_3      ((uint32_t)0x00080000U) /* Bit 3 */

/** Bit definition for DMA_CHCFG5 register **/
#define  DMA_CHCFG5_CHEN              ((uint16_t)0x0001U)     /* Channel enable*/
#define  DMA_CHCFG5_TXCIE             ((uint16_t)0x0002U)     /* Transfer complete interrupt enable */
#define  DMA_CHCFG5_HTXIE             ((uint16_t)0x0004U)     /* Half Transfer interrupt enable */
#define  DMA_CHCFG5_ERRIE             ((uint16_t)0x0008U)     /* Transfer error interrupt enable */
#define  DMA_CHCFG5_DIR               ((uint16_t)0x0010U)     /* Data transfer direction */
#define  DMA_CHCFG5_CIRC              ((uint16_t)0x0020U)     /* Circular mode */
#define  DMA_CHCFG5_PINC              ((uint16_t)0x0040U)     /* Peripheral increment mode */
#define  DMA_CHCFG5_MINC              ((uint16_t)0x0080U)     /* Memory increment mode */
                                                       
#define  DMA_CHCFG5_PSIZE             ((uint16_t)0x0300U)     /* PSIZE[1:0] bits (Peripheral size) */
#define  DMA_CHCFG5_PSIZE_0           ((uint16_t)0x0100U)     /* Bit 0 */
#define  DMA_CHCFG5_PSIZE_1           ((uint16_t)0x0200U)     /* Bit 1 */
                                                       
#define  DMA_CHCFG5_MSIZE             ((uint16_t)0x0C00U)     /* MSIZE[1:0] bits (Memory size) */
#define  DMA_CHCFG5_MSIZE_0           ((uint16_t)0x0400U)     /* Bit 0 */
#define  DMA_CHCFG5_MSIZE_1           ((uint16_t)0x0800U)     /* Bit 1 */
                                                      
#define  DMA_CHCFG5_PRIOLVL           ((uint16_t)0x3000U)     /* PRIOLVL[1:0] bits(Channel Priority level) */
#define  DMA_CHCFG5_PRIOLVL_0         ((uint16_t)0x1000U)     /* Bit 0 */
#define  DMA_CHCFG5_PRIOLVL_1         ((uint16_t)0x2000U)     /* Bit 1 */
                                                      
#define  DMA_CHCFG5_MEM2MEM           ((uint16_t)0x4000U)     /* Memory to memory mode */
                  
#define  DMA_CHCFG5_BURST_ALMOST      ((uint32_t)0x00000000U) /* BURST almost mode */
#define  DMA_CHCFG5_BURST_DYNAMIC     ((uint32_t)0x00008000U) /* BURST dynamic mode */
#define  DMA_CHCFG5_BURST_BLEN        ((uint32_t)0x000F0000U) /* BURST length is same as single mode */
#define  DMA_CHCFG5_BURST_BLEN_0      ((uint32_t)0x00010000U) /* Bit 0 */
#define  DMA_CHCFG5_BURST_BLEN_1      ((uint32_t)0x00020000U) /* Bit 1 */
#define  DMA_CHCFG5_BURST_BLEN_2      ((uint32_t)0x00040000U) /* Bit 2 */
#define  DMA_CHCFG5_BURST_BLEN_3      ((uint32_t)0x00080000U) /* Bit 3 */

/** Bit definition for DMA_CHCFG6 register **/
#define  DMA_CHCFG6_CHEN              ((uint16_t)0x0001U)     /* Channel enable*/
#define  DMA_CHCFG6_TXCIE             ((uint16_t)0x0002U)     /* Transfer complete interrupt enable */
#define  DMA_CHCFG6_HTXIE             ((uint16_t)0x0004U)     /* Half Transfer interrupt enable */
#define  DMA_CHCFG6_ERRIE             ((uint16_t)0x0008U)     /* Transfer error interrupt enable */
#define  DMA_CHCFG6_DIR               ((uint16_t)0x0010U)     /* Data transfer direction */
#define  DMA_CHCFG6_CIRC              ((uint16_t)0x0020U)     /* Circular mode */
#define  DMA_CHCFG6_PINC              ((uint16_t)0x0040U)     /* Peripheral increment mode */
#define  DMA_CHCFG6_MINC              ((uint16_t)0x0080U)     /* Memory increment mode */
                                                      
#define  DMA_CHCFG6_PSIZE             ((uint16_t)0x0300U)     /* PSIZE[1:0] bits (Peripheral size) */
#define  DMA_CHCFG6_PSIZE_0           ((uint16_t)0x0100U)     /* Bit 0 */
#define  DMA_CHCFG6_PSIZE_1           ((uint16_t)0x0200U)     /* Bit 1 */
                                                     
#define  DMA_CHCFG6_MSIZE             ((uint16_t)0x0C00U)     /* MSIZE[1:0] bits (Memory size) */
#define  DMA_CHCFG6_MSIZE_0           ((uint16_t)0x0400U)     /* Bit 0 */
#define  DMA_CHCFG6_MSIZE_1           ((uint16_t)0x0800U)     /* Bit 1 */
                                                      
#define  DMA_CHCFG6_PRIOLVL           ((uint16_t)0x3000U)     /* PRIOLVL[1:0] bits(Channel Priority level) */
#define  DMA_CHCFG6_PRIOLVL_0         ((uint16_t)0x1000U)     /* Bit 0 */
#define  DMA_CHCFG6_PRIOLVL_1         ((uint16_t)0x2000U)     /* Bit 1 */
                                                     
#define  DMA_CHCFG6_MEM2MEM           ((uint16_t)0x4000U)     /* Memory to memory mode */
                  
#define  DMA_CHCFG6_BURST_ALMOST      ((uint32_t)0x00000000U) /* BURST almost mode */
#define  DMA_CHCFG6_BURST_DYNAMIC     ((uint32_t)0x00008000U) /* BURST dynamic mode */
#define  DMA_CHCFG6_BURST_BLEN        ((uint32_t)0x000F0000U) /* BURST length is same as single mode */
#define  DMA_CHCFG6_BURST_BLEN_0      ((uint32_t)0x00010000U) /* Bit 0 */
#define  DMA_CHCFG6_BURST_BLEN_1      ((uint32_t)0x00020000U) /* Bit 1 */
#define  DMA_CHCFG6_BURST_BLEN_2      ((uint32_t)0x00040000U) /* Bit 2 */
#define  DMA_CHCFG6_BURST_BLEN_3      ((uint32_t)0x00080000U) /* Bit 3 */

/** Bit definition for DMA_CHCFG7 register **/
#define  DMA_CHCFG7_CHEN              ((uint16_t)0x0001U)     /* Channel enable*/
#define  DMA_CHCFG7_TXCIE             ((uint16_t)0x0002U)     /* Transfer complete interrupt enable */
#define  DMA_CHCFG7_HTXIE             ((uint16_t)0x0004U)     /* Half Transfer interrupt enable */
#define  DMA_CHCFG7_ERRIE             ((uint16_t)0x0008U)     /* Transfer error interrupt enable */
#define  DMA_CHCFG7_DIR               ((uint16_t)0x0010U)     /* Data transfer direction */
#define  DMA_CHCFG7_CIRC              ((uint16_t)0x0020U)     /* Circular mode */
#define  DMA_CHCFG7_PINC              ((uint16_t)0x0040U)     /* Peripheral increment mode */
#define  DMA_CHCFG7_MINC              ((uint16_t)0x0080U)     /* Memory increment mode */
                                                      
#define  DMA_CHCFG7_PSIZE             ((uint16_t)0x0300U)     /* PSIZE[1:0] bits (Peripheral size) */
#define  DMA_CHCFG7_PSIZE_0           ((uint16_t)0x0100U)     /* Bit 0 */
#define  DMA_CHCFG7_PSIZE_1           ((uint16_t)0x0200U)     /* Bit 1 */
                                                      
#define  DMA_CHCFG7_MSIZE             ((uint16_t)0x0C00U)     /* MSIZE[1:0] bits (Memory size) */
#define  DMA_CHCFG7_MSIZE_0           ((uint16_t)0x0400U)     /* Bit 0 */
#define  DMA_CHCFG7_MSIZE_1           ((uint16_t)0x0800U)     /* Bit 1 */
                                                     
#define  DMA_CHCFG7_PRIOLVL           ((uint16_t)0x3000U)     /* PRIOLVL[1:0] bits(Channel Priority level) */
#define  DMA_CHCFG7_PRIOLVL_0         ((uint16_t)0x1000U)     /* Bit 0 */
#define  DMA_CHCFG7_PRIOLVL_1         ((uint16_t)0x2000U)     /* Bit 1 */
                                                      
#define  DMA_CHCFG7_MEM2MEM           ((uint16_t)0x4000U)     /* Memory to memory mode */
                  
#define  DMA_CHCFG7_BURST_ALMOST      ((uint32_t)0x00000000U) /* BURST almost mode */
#define  DMA_CHCFG7_BURST_DYNAMIC     ((uint32_t)0x00008000U) /* BURST dynamic mode */
#define  DMA_CHCFG7_BURST_BLEN        ((uint32_t)0x000F0000U) /* BURST length is same as single mode */
#define  DMA_CHCFG7_BURST_BLEN_0      ((uint32_t)0x00010000U) /* Bit 0 */
#define  DMA_CHCFG7_BURST_BLEN_1      ((uint32_t)0x00020000U) /* Bit 1 */
#define  DMA_CHCFG7_BURST_BLEN_2      ((uint32_t)0x00040000U) /* Bit 2 */
#define  DMA_CHCFG7_BURST_BLEN_3      ((uint32_t)0x00080000U) /* Bit 3 */

/** Bit definition for DMA_CHCFG8 register **/
#define  DMA_CHCFG8_CHEN              ((uint16_t)0x0001U)     /* Channel enable*/
#define  DMA_CHCFG8_TXCIE             ((uint16_t)0x0002U)     /* Transfer complete interrupt enable */
#define  DMA_CHCFG8_HTXIE             ((uint16_t)0x0004U)     /* Half Transfer interrupt enable */
#define  DMA_CHCFG8_ERRIE             ((uint16_t)0x0008U)     /* Transfer error interrupt enable */
#define  DMA_CHCFG8_DIR               ((uint16_t)0x0010U)     /* Data transfer direction */
#define  DMA_CHCFG8_CIRC              ((uint16_t)0x0020U)     /* Circular mode */
#define  DMA_CHCFG8_PINC              ((uint16_t)0x0040U)     /* Peripheral increment mode */
#define  DMA_CHCFG8_MINC              ((uint16_t)0x0080U)     /* Memory increment mode */
                                                      
#define  DMA_CHCFG8_PSIZE             ((uint16_t)0x0300U)     /* PSIZE[1:0] bits (Peripheral size) */
#define  DMA_CHCFG8_PSIZE_0           ((uint16_t)0x0100U)     /* Bit 0 */
#define  DMA_CHCFG8_PSIZE_1           ((uint16_t)0x0200U)     /* Bit 1 */
                                                      
#define  DMA_CHCFG8_MSIZE             ((uint16_t)0x0C00U)     /* MSIZE[1:0] bits (Memory size) */
#define  DMA_CHCFG8_MSIZE_0           ((uint16_t)0x0400U)     /* Bit 0 */
#define  DMA_CHCFG8_MSIZE_1           ((uint16_t)0x0800U)     /* Bit 1 */
                                                      
#define  DMA_CHCFG8_PRIOLVL           ((uint16_t)0x3000U)     /* PRIOLVL[1:0] bits(Channel Priority level) */
#define  DMA_CHCFG8_PRIOLVL_0         ((uint16_t)0x1000U)     /* Bit 0 */
#define  DMA_CHCFG8_PRIOLVL_1         ((uint16_t)0x2000U)     /* Bit 1 */
                                                       
#define  DMA_CHCFG8_MEM2MEM           ((uint16_t)0x4000U)     /* Memory to memory mode */
                  
#define  DMA_CHCFG8_BURST_ALMOST      ((uint32_t)0x00000000U) /* BURST almost mode */
#define  DMA_CHCFG8_BURST_DYNAMIC     ((uint32_t)0x00008000U) /* BURST dynamic mode */
#define  DMA_CHCFG8_BURST_BLEN        ((uint32_t)0x000F0000U) /* BURST length is same as single mode */
#define  DMA_CHCFG8_BURST_BLEN_0      ((uint32_t)0x00010000U) /* Bit 0 */
#define  DMA_CHCFG8_BURST_BLEN_1      ((uint32_t)0x00020000U) /* Bit 1 */
#define  DMA_CHCFG8_BURST_BLEN_2      ((uint32_t)0x00040000U) /* Bit 2 */
#define  DMA_CHCFG8_BURST_BLEN_3      ((uint32_t)0x00080000U) /* Bit 3 */

/** Bit definition for DMA_MADDR1 register **/
#define DMA_MADDR1_ADDR ((uint32_t)0xFFFFFFFFU) /* Memory Address of Channel1 */
                                                                           
/** Bit definition for DMA_MADDR2 register **/                             
#define DMA_MADDR2_ADDR ((uint32_t)0xFFFFFFFFU) /* Memory Address of Channel2 */
                                                                           
/** Bit definition for DMA_MADDR3 register **/                             
#define DMA_MADDR3_ADDR ((uint32_t)0xFFFFFFFFU) /* Memory Address of Channel3 */
                                                                           
/** Bit definition for DMA_MADDR4 register **/                             
#define DMA_MADDR4_ADDR ((uint32_t)0xFFFFFFFFU) /* Memory Address of Channel4 */
                                                                           
/** Bit definition for DMA_MADDR5 register **/                             
#define DMA_MADDR5_ADDR ((uint32_t)0xFFFFFFFFU) /* Memory Address of Channel5 */
                                                                           
/** Bit definition for DMA_MADDR6 register **/                             
#define DMA_MADDR6_ADDR ((uint32_t)0xFFFFFFFFU) /* Memory Address of Channel6 */
                                                                           
/** Bit definition for DMA_MADDR7 register **/                             
#define DMA_MADDR7_ADDR ((uint32_t)0xFFFFFFFFU) /* Memory Address of Channel7 */
                                                                           
/** Bit definition for DMA_MADDR8 register **/                             
#define DMA_MADDR8_ADDR ((uint32_t)0xFFFFFFFFU) /* Memory Address of Channel8 */
                                             
/** Bit definition for DMA_PADDR1 register **/
#define DMA_PADDR1_ADDR ((uint32_t)0xFFFFFFFFU) /* Peripheral Address of Channel1 */
                                             
/** Bit definition for DMA_PADDR2 register **/
#define DMA_PADDR2_ADDR ((uint32_t)0xFFFFFFFFU) /* Peripheral Address of Channel2 */
                                             
/** Bit definition for DMA_PADDR3 register **/
#define DMA_PADDR3_ADDR ((uint32_t)0xFFFFFFFFU) /* Peripheral Address of Channel3 */
                                             
/** Bit definition for DMA_PADDR4 register **/
#define DMA_PADDR4_ADDR ((uint32_t)0xFFFFFFFFU) /* Peripheral Address of Channel4 */
                                             
/** Bit definition for DMA_PADDR5 register **/
#define DMA_PADDR5_ADDR ((uint32_t)0xFFFFFFFFU) /* Peripheral Address of Channel5 */
                                             
/** Bit definition for DMA_PADDR6 register **/
#define DMA_PADDR6_ADDR ((uint32_t)0xFFFFFFFFU) /* Peripheral Address of Channel6 */
                                             
/** Bit definition for DMA_PADDR7 register **/
#define DMA_PADDR7_ADDR ((uint32_t)0xFFFFFFFFU) /* Peripheral Address of Channel7 */
                                             
/** Bit definition for DMA_PADDR8 register **/
#define DMA_PADDR8_ADDR ((uint32_t)0xFFFFFFFFU) /* Peripheral Address of Channel8 */

/** Bit definition for DMA_CHSEL1 register **/
#define DMA_CHSEL1_CH_SEL ((uint8_t)0xFFU) /* Channel select of Channel1 */
                                                                                 
/** Bit definition for DMA_CHSEL2 register **/                                   
#define DMA_CHSEL2_CH_SEL ((uint8_t)0xFFU) /* Channel select of Channel2 */
                                                                       
/** Bit definition for DMA_CHSEL3 register **/                         
#define DMA_CHSEL3_CH_SEL ((uint8_t)0xFFU) /* Channel select of Channel3 */
                                                                       
/** Bit definition for DMA_CHSEL4 register **/                         
#define DMA_CHSEL4_CH_SEL ((uint8_t)0xFFU) /* Channel select of Channel4 */
                                                                       
/** Bit definition for DMA_CHSEL5 register **/                         
#define DMA_CHSEL5_CH_SEL ((uint8_t)0xFFU) /* Channel select of Channel5 */
                                                                       
/** Bit definition for DMA_CHSEL6 register **/                         
#define DMA_CHSEL6_CH_SEL ((uint8_t)0xFFU) /* Channel select of Channel6 */
                                                                       
/** Bit definition for DMA_CHSEL7 register **/                         
#define DMA_CHSEL7_CH_SEL ((uint8_t)0xFFU) /* Channel select of Channel7 */
                                                                       
/** Bit definition for DMA_CHSEL8 register **/                         
#define DMA_CHSEL8_CH_SEL ((uint8_t)0xFFU) /* Channel select of Channel8 */

/** Bit definition for DMA_TXNUM1 register **/
#define DMA_TXNUM1_NDTX ((uint16_t)0xFFFFU) /* Channel1 number of data to transfer */
                                                     
/** Bit definition for DMA_TXNUM2 register **/       
#define DMA_TXNUM2_NDTX ((uint16_t)0xFFFFU) /* Channel2 number of data to transfer */
                                                     
/** Bit definition for DMA_TXNUM3 register **/       
#define DMA_TXNUM3_NDTX ((uint16_t)0xFFFFU) /* Channel3 number of data to transfer */
                                                     
/** Bit definition for DMA_TXNUM4 register **/       
#define DMA_TXNUM4_NDTX ((uint16_t)0xFFFFU) /* Channel4 number of data to transfer */
                                                     
/** Bit definition for DMA_TXNUM5 register **/       
#define DMA_TXNUM5_NDTX ((uint16_t)0xFFFFU) /* Channel5 number of data to transfer */
                                                     
/** Bit definition for DMA_TXNUM6 register **/       
#define DMA_TXNUM6_NDTX ((uint16_t)0xFFFFU) /* Channel6 number of data to transfer */
                                                     
/** Bit definition for DMA_TXNUM7 register **/       
#define DMA_TXNUM7_NDTX ((uint16_t)0xFFFFU) /* Channel7 number of data to transfer */
                                                     
/** Bit definition for DMA_TXNUM8 register **/       
#define DMA_TXNUM8_NDTX ((uint16_t)0xFFFFU) /* Channel8 number of data to transfer */

/** Bit definition for DMA_INTCLR register **/
#define  DMA_INTCLR_CGLBF1 ((uint32_t)0x00000001U) /* Channel 1 Global interrupt clear */
#define  DMA_INTCLR_CTXCF1 ((uint32_t)0x00000002U) /* Channel 1 Transfer Complete clear */
#define  DMA_INTCLR_CHTXF1 ((uint32_t)0x00000004U) /* Channel 1 Half Transfer clear */
#define  DMA_INTCLR_CERRF1 ((uint32_t)0x00000008U) /* Channel 1 Transfer Error clear */
#define  DMA_INTCLR_CGLBF2 ((uint32_t)0x00000010U) /* Channel 2 Global interrupt clear */
#define  DMA_INTCLR_CTXCF2 ((uint32_t)0x00000020U) /* Channel 2 Transfer Complete clear */
#define  DMA_INTCLR_CHTXF2 ((uint32_t)0x00000040U) /* Channel 2 Half Transfer clear */
#define  DMA_INTCLR_CERRF2 ((uint32_t)0x00000080U) /* Channel 2 Transfer Error clear */
#define  DMA_INTCLR_CGLBF3 ((uint32_t)0x00000100U) /* Channel 3 Global interrupt clear */
#define  DMA_INTCLR_CTXCF3 ((uint32_t)0x00000200U) /* Channel 3 Transfer Complete clear */
#define  DMA_INTCLR_CHTXF3 ((uint32_t)0x00000400U) /* Channel 3 Half Transfer clear */
#define  DMA_INTCLR_CERRF3 ((uint32_t)0x00000800U) /* Channel 3 Transfer Error clear */
#define  DMA_INTCLR_CGLBF4 ((uint32_t)0x00001000U) /* Channel 4 Global interrupt clear */
#define  DMA_INTCLR_CTXCF4 ((uint32_t)0x00002000U) /* Channel 4 Transfer Complete clear */
#define  DMA_INTCLR_CHTXF4 ((uint32_t)0x00004000U) /* Channel 4 Half Transfer clear */
#define  DMA_INTCLR_CERRF4 ((uint32_t)0x00008000U) /* Channel 4 Transfer Error clear */
#define  DMA_INTCLR_CGLBF5 ((uint32_t)0x00010000U) /* Channel 5 Global interrupt clear */
#define  DMA_INTCLR_CTXCF5 ((uint32_t)0x00020000U) /* Channel 5 Transfer Complete clear */
#define  DMA_INTCLR_CHTXF5 ((uint32_t)0x00040000U) /* Channel 5 Half Transfer clear */
#define  DMA_INTCLR_CERRF5 ((uint32_t)0x00080000U) /* Channel 5 Transfer Error clear */
#define  DMA_INTCLR_CGLBF6 ((uint32_t)0x00100000U) /* Channel 6 Global interrupt clear */
#define  DMA_INTCLR_CTXCF6 ((uint32_t)0x00200000U) /* Channel 6 Transfer Complete clear */
#define  DMA_INTCLR_CHTXF6 ((uint32_t)0x00400000U) /* Channel 6 Half Transfer clear */
#define  DMA_INTCLR_CERRF6 ((uint32_t)0x00800000U) /* Channel 6 Transfer Error clear */
#define  DMA_INTCLR_CGLBF7 ((uint32_t)0x01000000U) /* Channel 7 Global interrupt clear */
#define  DMA_INTCLR_CTXCF7 ((uint32_t)0x02000000U) /* Channel 7 Transfer Complete clear */
#define  DMA_INTCLR_CHTXF7 ((uint32_t)0x04000000U) /* Channel 7 Half Transfer clear */
#define  DMA_INTCLR_CERRF7 ((uint32_t)0x08000000U) /* Channel 7 Transfer Error clear */
#define  DMA_INTCLR_CGLBF8 ((uint32_t)0x10000000U) /* Channel 7 Global interrupt clear */
#define  DMA_INTCLR_CTXCF8 ((uint32_t)0x20000000U) /* Channel 7 Transfer Complete clear */
#define  DMA_INTCLR_CHTXF8 ((uint32_t)0x40000000U) /* Channel 7 Half Transfer clear */
#define  DMA_INTCLR_CERRF8 ((uint32_t)0x80000000U) /* Channel 7 Transfer Error clear */

/** Bit definition for DMA_INTSTS register **/
#define  DMA_INTSTS_GLBF1 ((uint32_t)0x00000001U) /* Channel 1 Global interrupt flag */
#define  DMA_INTSTS_TXCF1 ((uint32_t)0x00000002U) /* Channel 1 Transfer Complete flag */
#define  DMA_INTSTS_HTXF1 ((uint32_t)0x00000004U) /* Channel 1 Half Transfer flag */
#define  DMA_INTSTS_ERRF1 ((uint32_t)0x00000008U) /* Channel 1 Transfer Error flag */
#define  DMA_INTSTS_GLBF2 ((uint32_t)0x00000010U) /* Channel 2 Global interrupt flag */
#define  DMA_INTSTS_TXCF2 ((uint32_t)0x00000020U) /* Channel 2 Transfer Complete flag */
#define  DMA_INTSTS_HTXF2 ((uint32_t)0x00000040U) /* Channel 2 Half Transfer flag */
#define  DMA_INTSTS_ERRF2 ((uint32_t)0x00000080U) /* Channel 2 Transfer Error flag */
#define  DMA_INTSTS_GLBF3 ((uint32_t)0x00000100U) /* Channel 3 Global interrupt flag */
#define  DMA_INTSTS_TXCF3 ((uint32_t)0x00000200U) /* Channel 3 Transfer Complete flag */
#define  DMA_INTSTS_HTXF3 ((uint32_t)0x00000400U) /* Channel 3 Half Transfer flag */
#define  DMA_INTSTS_ERRF3 ((uint32_t)0x00000800U) /* Channel 3 Transfer Error flag */
#define  DMA_INTSTS_GLBF4 ((uint32_t)0x00001000U) /* Channel 4 Global interrupt flag */
#define  DMA_INTSTS_TXCF4 ((uint32_t)0x00002000U) /* Channel 4 Transfer Complete flag */
#define  DMA_INTSTS_HTXF4 ((uint32_t)0x00004000U) /* Channel 4 Half Transfer flag */
#define  DMA_INTSTS_ERRF4 ((uint32_t)0x00008000U) /* Channel 4 Transfer Error flag */
#define  DMA_INTSTS_GLBF5 ((uint32_t)0x00010000U) /* Channel 5 Global interrupt flag */
#define  DMA_INTSTS_TXCF5 ((uint32_t)0x00020000U) /* Channel 5 Transfer Complete flag */
#define  DMA_INTSTS_HTXF5 ((uint32_t)0x00040000U) /* Channel 5 Half Transfer flag */
#define  DMA_INTSTS_ERRF5 ((uint32_t)0x00080000U) /* Channel 5 Transfer Error flag */
#define  DMA_INTSTS_GLBF6 ((uint32_t)0x00100000U) /* Channel 6 Global interrupt flag */
#define  DMA_INTSTS_TXCF6 ((uint32_t)0x00200000U) /* Channel 6 Transfer Complete flag */
#define  DMA_INTSTS_HTXF6 ((uint32_t)0x00400000U) /* Channel 6 Half Transfer flag */
#define  DMA_INTSTS_ERRF6 ((uint32_t)0x00800000U) /* Channel 6 Transfer Error flag */
#define  DMA_INTSTS_GLBF7 ((uint32_t)0x01000000U) /* Channel 7 Global interrupt flag */
#define  DMA_INTSTS_TXCF7 ((uint32_t)0x02000000U) /* Channel 7 Transfer Complete flag */
#define  DMA_INTSTS_HTXF7 ((uint32_t)0x04000000U) /* Channel 7 Half Transfer flag */
#define  DMA_INTSTS_ERRF7 ((uint32_t)0x08000000U) /* Channel 7 Transfer Error flag */
#define  DMA_INTSTS_GLBF8 ((uint32_t)0x10000000U) /* Channel 7 Global interrupt flag */
#define  DMA_INTSTS_TXCF8 ((uint32_t)0x20000000U) /* Channel 7 Transfer Complete flag */
#define  DMA_INTSTS_HTXF8 ((uint32_t)0x40000000U) /* Channel 7 Half Transfer flag */
#define  DMA_INTSTS_ERRF8 ((uint32_t)0x80000000U) /* Channel 7 Transfer Error flag */

/** Bit definition for DMA_BURSTEN register **/
#define  DMA_BURSTEN_BURST_BYPASS ((uint8_t)0x01U) /* Burst mode enable */



/******************************************************************************/
/*                                                                            */
/*                        Analog to Digital Converter                         */
/*                                                                            */
/******************************************************************************/

/********************  Bit definition for ADC_STS register  ********************/
#define ADC_STS_ENDC        ((uint32_t)0x00000001U) /* End of conversion */
#define ADC_STS_ENDCA       ((uint32_t)0x00000002U) /* Any end of conversion */
#define ADC_STS_JENDC       ((uint32_t)0x00000004U) /* Injected channel end of conversion */
#define ADC_STS_JENDCA      ((uint32_t)0x00000008U) /* Any injected channel end of conversion */
#define ADC_STS_AWDG1       ((uint32_t)0x00000010U) /* Analog watchdog 1 flag */
#define ADC_STS_ENDCERR     ((uint32_t)0x00000020U) /* End of conversion error */
#define ADC_STS_RDY         ((uint32_t)0x00000040U) /* ADC power up ready */
#define ADC_STS_PDRDY       ((uint32_t)0x00000080U) /* ADC power down ready */
#define ADC_STS_EOSAMP      ((uint32_t)0x00000100U) /* End of Sampling */
#define ADC_STS_TCFLAG      ((uint32_t)0x00000200U) /* Turncate flag */
#define ADC_STS_STR         ((uint32_t)0x00000400U) /* Regular channel Start flag */
#define ADC_STS_JSTR        ((uint32_t)0x00000800U) /* Injected channel Start flag */
#define ADC_STS_ALL         ((uint32_t)0x00000FFFU) /* All flag bit  */

/*******************  Bit definition for ADC_CTRL1 register  ********************/
#define ADC_CTRL1_SCANMD    ((uint32_t)0x00000001U) /* Scan mode */
#define ADC_CTRL1_AUTOJC    ((uint32_t)0x00000002U) /* Automatic injected group conversion */

#define ADC_CTRL1_DCTU      ((uint32_t)0x0000001CU) /* DISC_NUM[2:0] bits (Discontinuous mode channel count) */
#define ADC_CTRL1_DCTU_0    ((uint32_t)0x00000004U) /* Bit 0 */
#define ADC_CTRL1_DCTU_1    ((uint32_t)0x00000008U) /* Bit 1 */
#define ADC_CTRL1_DCTU_2    ((uint32_t)0x00000010U) /* Bit 2 */

#define ADC_CTRL1_DREGCH    ((uint32_t)0x00000020U) /* Discontinuous mode on regular channels */
#define ADC_CTRL1_DJCH      ((uint32_t)0x00000040U) /* Discontinuous mode on injected channels */

#define ADC_CTRL1_MULTMODE    ((uint32_t)0x00000F80U) /* Mult-ADC mode selection*/
#define ADC_CTRL1_MULTMODE_0  ((uint32_t)0x00000080U) /* Bit 0 */
#define ADC_CTRL1_MULTMODE_1  ((uint32_t)0x00000100U) /* Bit 1 */
#define ADC_CTRL1_MULTMODE_2  ((uint32_t)0x00000200U) /* Bit 2 */
#define ADC_CTRL1_MULTMODE_3  ((uint32_t)0x00000400U) /* Bit 3 */
#define ADC_CTRL1_MULTMODE_4  ((uint32_t)0x00000800U) /* Bit 4 */

#define ADC_CTRL1_AWD1CH    ((uint32_t)0x0001F000U) /* AWD1CH[4:0] bits (Analog watchdog 1 channel select bits) */
#define ADC_CTRL1_AWD1CH_0  ((uint32_t)0x00001000U) /* Bit 0 */
#define ADC_CTRL1_AWD1CH_1  ((uint32_t)0x00002000U) /* Bit 1 */
#define ADC_CTRL1_AWD1CH_2  ((uint32_t)0x00004000U) /* Bit 2 */
#define ADC_CTRL1_AWD1CH_3  ((uint32_t)0x00008000U) /* Bit 3 */
#define ADC_CTRL1_AWD1CH_4  ((uint32_t)0x00010000U) /* Bit 4 */

#define ADC_CTRL1_AWD1ERCH  ((uint32_t)0x00020000U) /* Analog watchdog 1 enable on regular channels */
#define ADC_CTRL1_AWD1EJCH  ((uint32_t)0x00040000U) /* Analog watchdog 1 enable on injected channels */
#define ADC_CTRL1_AWD1SGLEN ((uint32_t)0x00080000U) /* Enable the watchdog 1 on a single channel in scan mode */

#define ADC_CTRL1_DELAY     ((uint32_t)0x00F00000U) /* The delay time when operating on interleaved mode of dual-ADC or Tripple- ADC  */
#define ADC_CTRL1_DELAY_0   ((uint32_t)0x00100000U) /* Bit 0 */
#define ADC_CTRL1_DELAY_1   ((uint32_t)0x00200000U) /* Bit 1 */
#define ADC_CTRL1_DELAY_2   ((uint32_t)0x00400000U) /* Bit 2 */
#define ADC_CTRL1_DELAY_3   ((uint32_t)0x00800000U) /* Bit 3 */

/*******************  Bit definition for ADC_CTRL2 register  ********************/
#define ADC_CTRL2_ON        ((uint32_t)0x00000001U) /* A/D Converter ON / OFF */
#define ADC_CTRL2_CTU       ((uint32_t)0x00000002U) /* Continuous Conversion */
#define ADC_CTRL2_ENCAL     ((uint32_t)0x00000004U) /* A/D Calibration */
#define ADC_CTRL2_RSTCAL    ((uint32_t)0x00000008U) /* A/D Calibration Reset*/

#define ADC_CTRL2_EXTPRSEL   ((uint32_t)0x00000030U) /* EXTPRSEL[1:0] bits (External trigger enable and polarity selection for regular channels) */
#define ADC_CTRL2_EXTPRSEL_0 ((uint32_t)0x00000010U) /* Bit 0 */
#define ADC_CTRL2_EXTPRSEL_1 ((uint32_t)0x00000020U) /* Bit 1 */

#define ADC_CTRL2_EXTPJSEL   ((uint32_t)0x000000C0U) /* EXTPJSEL[1:0] bits (External trigger enable and polarity selection for injected channels) */
#define ADC_CTRL2_EXTPJSEL_0 ((uint32_t)0x00000040U) /* Bit 0 */
#define ADC_CTRL2_EXTPJSEL_1 ((uint32_t)0x00000080U) /* Bit 1 */

#define ADC_CTRL2_EXTJSEL   ((uint32_t)0x0000FC00U) /* EXTJSEL[5:0] bits (External event select for injected group) */
#define ADC_CTRL2_EXTJSEL_0 ((uint32_t)0x00000400U) /* Bit 0 */
#define ADC_CTRL2_EXTJSEL_1 ((uint32_t)0x00000800U) /* Bit 1 */
#define ADC_CTRL2_EXTJSEL_2 ((uint32_t)0x00001000U) /* Bit 2 */
#define ADC_CTRL2_EXTJSEL_3 ((uint32_t)0x00002000U) /* Bit 3 */
#define ADC_CTRL2_EXTJSEL_4 ((uint32_t)0x00004000U) /* Bit 4 */
#define ADC_CTRL2_EXTJSEL_5 ((uint32_t)0x00008000U) /* Bit 5 */

#define ADC_CTRL2_EXTRSEL   ((uint32_t)0x003F0000U) /* EXTRSEL[5:0] bits (External event select for regular group) */
#define ADC_CTRL2_EXTRSEL_0 ((uint32_t)0x00010000U) /* Bit 0 */
#define ADC_CTRL2_EXTRSEL_1 ((uint32_t)0x00020000U) /* Bit 1 */
#define ADC_CTRL2_EXTRSEL_2 ((uint32_t)0x00040000U) /* Bit 2 */
#define ADC_CTRL2_EXTRSEL_3 ((uint32_t)0x00080000U) /* Bit 3 */
#define ADC_CTRL2_EXTRSEL_4 ((uint32_t)0x00100000U) /* Bit 4 */
#define ADC_CTRL2_EXTRSEL_5 ((uint32_t)0x00200000U) /* Bit 5 */

#define ADC_CTRL2_DMAMD     ((uint32_t)0x00C00000U) /* DMAMD[1:0] bits (DMA mode) */
#define ADC_CTRL2_DMAMD_0   ((uint32_t)0x00400000U) /* Bit 0 */
#define ADC_CTRL2_DMAMD_1   ((uint32_t)0x00800000U) /* Bit 1 */

#define ADC_CTRL2_ALIG      ((uint32_t)0x01000000U) /* Data Alignment */
#define ADC_CTRL2_TEMPEN    ((uint32_t)0x02000000U) /* Temperature Sensor Enable */
#define ADC_CTRL2_GCOMPEN   ((uint32_t)0x04000000U) /* Gain compensation Enable */
#define ADC_CTRL2_SWSTRJCH  ((uint32_t)0x08000000U) /* Start Conversion of injected channels */
#define ADC_CTRL2_SWSTRRCH  ((uint32_t)0x10000000U) /* Start Conversion of regular channels */
#define ADC_CTRL2_SWJSTOP   ((uint32_t)0x20000000U) /* Stop Conversion of injected channels */
#define ADC_CTRL2_SWRSTOP   ((uint32_t)0x40000000U) /* Stop Conversion of regular channels */

/********************  Bit definition for ADC_CTRL3 register  *****************/
#define ADC_CTRL3_RES       ((uint32_t)0x00000003U) /* RES[1:0] bits (Data resolution) */
#define ADC_CTRL3_RES_0     ((uint32_t)0x00000001U) /* Bit 0 */
#define ADC_CTRL3_RES_1     ((uint32_t)0x00000002U) /* Bit 1 */

#define ADC_CTRL3_CALDIF    ((uint32_t)0x00000004U) /* Differential mode for calibration */
#define ADC_CTRL3_CALALD    ((uint32_t)0x00000008U) /* Calibration value auto load */
#define ADC_CTRL3_CLOCKMOD  ((uint32_t)0x00000010U) /* Clock Mode */
#define ADC_CTRL3_BPCAL     ((uint32_t)0x00000020U) /* Bypass calibration */
#define ADC_CTRL3_DPWMOD    ((uint32_t)0x00000040U) /* Deep Power Mode */
#define ADC_CTRL3_VBATMEN   ((uint32_t)0x00000080U) /* Vbat monitor enable */

#define ADC_CTRL3_OSR       ((uint32_t)0x00000F00U) /* OSR[3:0] bits (ADC oversampling ratio times) */
#define ADC_CTRL3_OSR_0     ((uint32_t)0x00000100U) /* Bit 0 */
#define ADC_CTRL3_OSR_1     ((uint32_t)0x00000200U) /* Bit 1 */
#define ADC_CTRL3_OSR_2     ((uint32_t)0x00000400U) /* Bit 2 */
#define ADC_CTRL3_OSR_3     ((uint32_t)0x00000800U) /* Bit 3 */

#define ADC_CTRL3_OSS       ((uint32_t)0x0000F000U) /* OSS[3:0] bits (Oversample data right shift) */
#define ADC_CTRL3_OSS_0     ((uint32_t)0x00001000U) /* Bit 0 */
#define ADC_CTRL3_OSS_1     ((uint32_t)0x00002000U) /* Bit 1 */
#define ADC_CTRL3_OSS_2     ((uint32_t)0x00004000U) /* Bit 2 */
#define ADC_CTRL3_OSS_3     ((uint32_t)0x00008000U) /* Bit 3 */

#define ADC_CTRL3_OSRE      ((uint32_t)0x00010000U) /* Regular channels oversample enable */
#define ADC_CTRL3_OSJE      ((uint32_t)0x00020000U) /* Injected channels oversample enable */
#define ADC_CTRL3_OSRTRIG   ((uint32_t)0x00040000U) /* Regular channels oversample triagger mode */
#define ADC_CTRL3_OSRMD     ((uint32_t)0x00080000U) /* Regular channels oversample mode */
#define ADC_CTRL3_INP1SEL   ((uint32_t)0x00100000U) /* ADC channel 1 positive end select */
#define ADC_CTRL3_INN1SEL   ((uint32_t)0x00200000U) /* ADC channel 1 negtive end select */
#define ADC_CTRL3_INP2SEL   ((uint32_t)0x00400000U) /* ADC channel 2 positive end select */

/******************  Bit definition for ADC_SAMPT1 register  *******************/
#define ADC_SAMPT1_SAMP0    ((uint32_t)0x0000000FU) /* SAMP0[3:0] bits (Channel 0 Sample time selection) */
#define ADC_SAMPT1_SAMP0_0  ((uint32_t)0x00000001U) /* Bit 0 */
#define ADC_SAMPT1_SAMP0_1  ((uint32_t)0x00000002U) /* Bit 1 */
#define ADC_SAMPT1_SAMP0_2  ((uint32_t)0x00000004U) /* Bit 2 */
#define ADC_SAMPT1_SAMP0_3  ((uint32_t)0x00000008U) /* Bit 3 */

#define ADC_SAMPT1_SAMP1    ((uint32_t)0x000000F0U) /* SAMP1[3:0] bits (Channel 1 Sample time selection) */
#define ADC_SAMPT1_SAMP1_0  ((uint32_t)0x00000010U) /* Bit 0 */
#define ADC_SAMPT1_SAMP1_1  ((uint32_t)0x00000020U) /* Bit 1 */
#define ADC_SAMPT1_SAMP1_2  ((uint32_t)0x00000040U) /* Bit 2 */
#define ADC_SAMPT1_SAMP1_3  ((uint32_t)0x00000080U) /* Bit 3 */

#define ADC_SAMPT1_SAMP2    ((uint32_t)0x00000F00U) /* SAMP2[3:0] bits (Channel 2 Sample time selection) */
#define ADC_SAMPT1_SAMP2_0  ((uint32_t)0x00000100U) /* Bit 0 */
#define ADC_SAMPT1_SAMP2_1  ((uint32_t)0x00000200U) /* Bit 1 */
#define ADC_SAMPT1_SAMP2_2  ((uint32_t)0x00000400U) /* Bit 2 */
#define ADC_SAMPT1_SAMP2_3  ((uint32_t)0x00000800U) /* Bit 3 */

#define ADC_SAMPT1_SAMP3    ((uint32_t)0x0000F000U) /* SAMP3[3:0] bits (Channel 3 Sample time selection) */
#define ADC_SAMPT1_SAMP3_0  ((uint32_t)0x00001000U) /* Bit 0 */
#define ADC_SAMPT1_SAMP3_1  ((uint32_t)0x00002000U) /* Bit 1 */
#define ADC_SAMPT1_SAMP3_2  ((uint32_t)0x00004000U) /* Bit 2 */
#define ADC_SAMPT1_SAMP3_3  ((uint32_t)0x00008000U) /* Bit 3 */

#define ADC_SAMPT1_SAMP4    ((uint32_t)0x000F0000U) /* SAMP4[3:0] bits (Channel 4 Sample time selection) */
#define ADC_SAMPT1_SAMP4_0  ((uint32_t)0x00010000U) /* Bit 0 */
#define ADC_SAMPT1_SAMP4_1  ((uint32_t)0x00020000U) /* Bit 1 */
#define ADC_SAMPT1_SAMP4_2  ((uint32_t)0x00040000U) /* Bit 2 */
#define ADC_SAMPT1_SAMP4_3  ((uint32_t)0x00080000U) /* Bit 3 */

#define ADC_SAMPT1_SAMP5    ((uint32_t)0x00F00000U) /* SAMP5[3:0] bits (Channel 5 Sample time selection) */
#define ADC_SAMPT1_SAMP5_0  ((uint32_t)0x00100000U) /* Bit 0 */
#define ADC_SAMPT1_SAMP5_1  ((uint32_t)0x00200000U) /* Bit 1 */
#define ADC_SAMPT1_SAMP5_2  ((uint32_t)0x00400000U) /* Bit 2 */
#define ADC_SAMPT1_SAMP5_3  ((uint32_t)0x00800000U) /* Bit 3 */

#define ADC_SAMPT1_SAMP6    ((uint32_t)0x0F000000U) /* SAMP6[3:0] bits (Channel 6 Sample time selection) */
#define ADC_SAMPT1_SAMP6_0  ((uint32_t)0x01000000U) /* Bit 0 */
#define ADC_SAMPT1_SAMP6_1  ((uint32_t)0x02000000U) /* Bit 1 */
#define ADC_SAMPT1_SAMP6_2  ((uint32_t)0x04000000U) /* Bit 2 */
#define ADC_SAMPT1_SAMP6_3  ((uint32_t)0x08000000U) /* Bit 3 */

#define ADC_SAMPT1_SAMP7    ((uint32_t)0xF0000000U) /* SAMP7[3:0] bits (Channel 7 Sample time selection) */
#define ADC_SAMPT1_SAMP7_0  ((uint32_t)0x10000000U) /* Bit 0 */
#define ADC_SAMPT1_SAMP7_1  ((uint32_t)0x20000000U) /* Bit 1 */
#define ADC_SAMPT1_SAMP7_2  ((uint32_t)0x40000000U) /* Bit 2 */
#define ADC_SAMPT1_SAMP7_3  ((uint32_t)0x80000000U) /* Bit 3 */

/******************  Bit definition for ADC_SAMPT2 register  *******************/
#define ADC_SAMPT2_SAMP8    ((uint32_t)0x0000000FU) /* SAMP8[3:0] bits (Channel 8 Sample time selection) */
#define ADC_SAMPT2_SAMP8_0  ((uint32_t)0x00000001U) /* Bit 0 */
#define ADC_SAMPT2_SAMP8_1  ((uint32_t)0x00000002U) /* Bit 1 */
#define ADC_SAMPT2_SAMP8_2  ((uint32_t)0x00000004U) /* Bit 2 */
#define ADC_SAMPT2_SAMP8_3  ((uint32_t)0x00000008U) /* Bit 3 */

#define ADC_SAMPT2_SAMP9    ((uint32_t)0x000000F0U) /* SAMP9[3:0] bits (Channel 9 Sample time selection) */
#define ADC_SAMPT2_SAMP9_0  ((uint32_t)0x00000010U) /* Bit 0 */
#define ADC_SAMPT2_SAMP9_1  ((uint32_t)0x00000020U) /* Bit 1 */
#define ADC_SAMPT2_SAMP9_2  ((uint32_t)0x00000040U) /* Bit 2 */
#define ADC_SAMPT2_SAMP9_3  ((uint32_t)0x00000080U) /* Bit 3 */

#define ADC_SAMPT2_SAMP10   ((uint32_t)0x00000F00U) /* SAMP10[3:0] bits (Channel 10 Sample time selection) */
#define ADC_SAMPT2_SAMP10_0 ((uint32_t)0x00000100U) /* Bit 0 */
#define ADC_SAMPT2_SAMP10_1 ((uint32_t)0x00000200U) /* Bit 1 */
#define ADC_SAMPT2_SAMP10_2 ((uint32_t)0x00000400U) /* Bit 2 */
#define ADC_SAMPT2_SAMP10_3 ((uint32_t)0x00000800U) /* Bit 3 */

#define ADC_SAMPT2_SAMP11   ((uint32_t)0x0000F000U) /* SAMP11[3:0] bits (Channel 11 Sample time selection) */
#define ADC_SAMPT2_SAMP11_0 ((uint32_t)0x00001000U) /* Bit 0 */
#define ADC_SAMPT2_SAMP11_1 ((uint32_t)0x00002000U) /* Bit 1 */
#define ADC_SAMPT2_SAMP11_2 ((uint32_t)0x00004000U) /* Bit 2 */
#define ADC_SAMPT2_SAMP11_3 ((uint32_t)0x00008000U) /* Bit 3 */

#define ADC_SAMPT2_SAMP12   ((uint32_t)0x000F0000U) /* SAMP12[3:0] bits (Channel 12 Sample time selection) */
#define ADC_SAMPT2_SAMP12_0 ((uint32_t)0x00010000U) /* Bit 0 */
#define ADC_SAMPT2_SAMP12_1 ((uint32_t)0x00020000U) /* Bit 1 */
#define ADC_SAMPT2_SAMP12_2 ((uint32_t)0x00040000U) /* Bit 2 */
#define ADC_SAMPT2_SAMP12_3 ((uint32_t)0x00080000U) /* Bit 3 */

#define ADC_SAMPT2_SAMP13   ((uint32_t)0x00F00000U) /* SAMP13[3:0] bits (Channel 13 Sample time selection) */
#define ADC_SAMPT2_SAMP13_0 ((uint32_t)0x00100000U) /* Bit 0 */
#define ADC_SAMPT2_SAMP13_1 ((uint32_t)0x00200000U) /* Bit 1 */
#define ADC_SAMPT2_SAMP13_2 ((uint32_t)0x00400000U) /* Bit 2 */
#define ADC_SAMPT2_SAMP13_3 ((uint32_t)0x00800000U) /* Bit 3 */

#define ADC_SAMPT2_SAMP14   ((uint32_t)0x0F000000U) /* SAMP14[3:0] bits (Channel 14 Sample time selection) */
#define ADC_SAMPT2_SAMP14_0 ((uint32_t)0x01000000U) /* Bit 0 */
#define ADC_SAMPT2_SAMP14_1 ((uint32_t)0x02000000U) /* Bit 1 */
#define ADC_SAMPT2_SAMP14_2 ((uint32_t)0x04000000U) /* Bit 2 */
#define ADC_SAMPT2_SAMP14_3 ((uint32_t)0x08000000U) /* Bit 3 */

#define ADC_SAMPT2_SAMP15   ((uint32_t)0xF0000000U) /* SAMP15[3:0] bits (Channel 15 Sample time selection) */
#define ADC_SAMPT2_SAMP15_0 ((uint32_t)0x10000000U) /* Bit 0 */
#define ADC_SAMPT2_SAMP15_1 ((uint32_t)0x20000000U) /* Bit 1 */
#define ADC_SAMPT2_SAMP15_2 ((uint32_t)0x40000000U) /* Bit 2 */
#define ADC_SAMPT2_SAMP15_3 ((uint32_t)0x80000000U) /* Bit 3 */

/******************  Bit definition for ADC_SAMPT3 register  *******************/
#define ADC_SAMPT3_SAMP16   ((uint32_t)0x0000000FU) /* SAMP16[3:0] bits (Channel 16 Sample time selection) */
#define ADC_SAMPT3_SAMP16_0 ((uint32_t)0x00000001U) /* Bit 0 */
#define ADC_SAMPT3_SAMP16_1 ((uint32_t)0x00000002U) /* Bit 1 */
#define ADC_SAMPT3_SAMP16_2 ((uint32_t)0x00000004U) /* Bit 2 */
#define ADC_SAMPT3_SAMP16_3 ((uint32_t)0x00000008U) /* Bit 3 */

#define ADC_SAMPT3_SAMP17   ((uint32_t)0x000000F0U) /* SAMP17[3:0] bits (Channel 17 Sample time selection) */
#define ADC_SAMPT3_SAMP17_0 ((uint32_t)0x00000010U) /* Bit 0 */
#define ADC_SAMPT3_SAMP17_1 ((uint32_t)0x00000020U) /* Bit 1 */
#define ADC_SAMPT3_SAMP17_2 ((uint32_t)0x00000040U) /* Bit 2 */
#define ADC_SAMPT3_SAMP17_3 ((uint32_t)0x00000080U) /* Bit 3 */

#define ADC_SAMPT3_SAMP18   ((uint32_t)0x00000F00U) /* SAMP18[3:0] bits (Channel 18 Sample time selection) */
#define ADC_SAMPT3_SAMP18_0 ((uint32_t)0x00000100U) /* Bit 0 */
#define ADC_SAMPT3_SAMP18_1 ((uint32_t)0x00000200U) /* Bit 1 */
#define ADC_SAMPT3_SAMP18_2 ((uint32_t)0x00000400U) /* Bit 2 */
#define ADC_SAMPT3_SAMP18_3 ((uint32_t)0x00000800U) /* Bit 3 */

/********************  Bit definition for ADC_DIFSEL register  *****************/
#define ADC_DIFSEL_DIFSEL      ((uint32_t)0x0007FFFEU)
#define ADC_DIFSEL_DIFSEL_CH1  ((uint32_t)0x00000002U)
#define ADC_DIFSEL_DIFSEL_CH2  ((uint32_t)0x00000004U)
#define ADC_DIFSEL_DIFSEL_CH3  ((uint32_t)0x00000008U)
#define ADC_DIFSEL_DIFSEL_CH4  ((uint32_t)0x00000010U)
#define ADC_DIFSEL_DIFSEL_CH5  ((uint32_t)0x00000020U)
#define ADC_DIFSEL_DIFSEL_CH6  ((uint32_t)0x00000040U)
#define ADC_DIFSEL_DIFSEL_CH7  ((uint32_t)0x00000080U)
#define ADC_DIFSEL_DIFSEL_CH8  ((uint32_t)0x00000100U)
#define ADC_DIFSEL_DIFSEL_CH9  ((uint32_t)0x00000200U)
#define ADC_DIFSEL_DIFSEL_CH10 ((uint32_t)0x00000400U)
#define ADC_DIFSEL_DIFSEL_CH11 ((uint32_t)0x00000800U)
#define ADC_DIFSEL_DIFSEL_CH12 ((uint32_t)0x00001000U)
#define ADC_DIFSEL_DIFSEL_CH13 ((uint32_t)0x00002000U)
#define ADC_DIFSEL_DIFSEL_CH14 ((uint32_t)0x00004000U)
#define ADC_DIFSEL_DIFSEL_CH15 ((uint32_t)0x00008000U)
#define ADC_DIFSEL_DIFSEL_CH16 ((uint32_t)0x00010000U)
#define ADC_DIFSEL_DIFSEL_CH17 ((uint32_t)0x00020000U)
#define ADC_DIFSEL_DIFSEL_CH18 ((uint32_t)0x00040000U)

/********************  Bit definition for ADC_CALFACT register  ***************/
#define ADC_CALFACT_CALFACTD   ((uint32_t)0x007F0000U)
#define ADC_CALFACT_CALFACTS   ((uint32_t)0x0000007FU)

/******************  Bit definition for ADC_OFFSET1 register  *******************/
#define ADC_OFFSET1_OFFSCH1DAT    ((uint32_t)0x00000FFFU) /* ADC offset number 1 offset date */
#define ADC_OFFSET1_OFFSCH1DIR    ((uint32_t)0x01000000U) /* ADC offset number 1 positive */
#define ADC_OFFSET1_OFFSCH1SATEN  ((uint32_t)0x02000000U) /* ADC offset number 1 saturation enable */

#define ADC_OFFSET1_OFFSCH1CH     ((uint32_t)0x7C000000U) /* OFFSCH1CH[4:0] bits (ADC offset number 1 channel selection) */
#define ADC_OFFSET1_OFFSCH1CH_0   ((uint32_t)0x04000000U) /* Bit 0 */
#define ADC_OFFSET1_OFFSCH1CH_1   ((uint32_t)0x08000000U) /* Bit 1 */
#define ADC_OFFSET1_OFFSCH1CH_2   ((uint32_t)0x10000000U) /* Bit 2 */
#define ADC_OFFSET1_OFFSCH1CH_3   ((uint32_t)0x20000000U) /* Bit 3 */
#define ADC_OFFSET1_OFFSCH1CH_4   ((uint32_t)0x40000000U) /* Bit 4 */

#define ADC_OFFSET1_OFFSCH1EN     ((uint32_t)0x80000000U) /* ADC offset number 1 offset enable */
/******************  Bit definition for ADC_OFFSET2 register  *******************/
#define ADC_OFFSET2_OFFSCH2DAT    ((uint32_t)0x00000FFFU) /* ADC offset number 2 offset date */
#define ADC_OFFSET2_OFFSCH2DIR    ((uint32_t)0x01000000U) /* ADC offset number 2 positive */
#define ADC_OFFSET2_OFFSCH2SATEN  ((uint32_t)0x02000000U) /* ADC offset number 2 saturation enable */

#define ADC_OFFSET2_OFFSCH2CH     ((uint32_t)0x7C000000U) /* OFFSCH2CH[4:0] bits (ADC offset number 2 channel selection) */
#define ADC_OFFSET2_OFFSCH2CH_0   ((uint32_t)0x04000000U) /* Bit 0 */
#define ADC_OFFSET2_OFFSCH2CH_1   ((uint32_t)0x08000000U) /* Bit 1 */
#define ADC_OFFSET2_OFFSCH2CH_2   ((uint32_t)0x10000000U) /* Bit 2 */
#define ADC_OFFSET2_OFFSCH2CH_3   ((uint32_t)0x20000000U) /* Bit 3 */
#define ADC_OFFSET2_OFFSCH2CH_4   ((uint32_t)0x40000000U) /* Bit 4 */

#define ADC_OFFSET2_OFFSCH2EN     ((uint32_t)0x80000000U) /* ADC offset number 2 offset enable */
/******************  Bit definition for ADC_OFFSET3 register  *******************/
#define ADC_OFFSET3_OFFSCH3DAT    ((uint32_t)0x00000FFFU) /* ADC offset number 3 offset date */
#define ADC_OFFSET3_OFFSCH3DIR    ((uint32_t)0x01000000U) /* ADC offset number 3 positive */
#define ADC_OFFSET3_OFFSCH3SATEN  ((uint32_t)0x02000000U) /* ADC offset number 3 saturation enable */

#define ADC_OFFSET3_OFFSCH3CH     ((uint32_t)0x7C000000U) /* OFFSCH3CH[4:0] bits (ADC offset number 3 channel selection) */
#define ADC_OFFSET3_OFFSCH3CH_0   ((uint32_t)0x04000000U) /* Bit 0 */
#define ADC_OFFSET3_OFFSCH3CH_1   ((uint32_t)0x08000000U) /* Bit 1 */
#define ADC_OFFSET3_OFFSCH3CH_2   ((uint32_t)0x10000000U) /* Bit 2 */
#define ADC_OFFSET3_OFFSCH3CH_3   ((uint32_t)0x20000000U) /* Bit 3 */
#define ADC_OFFSET3_OFFSCH3CH_4   ((uint32_t)0x40000000U) /* Bit 4 */

#define ADC_OFFSET3_OFFSCH3EN     ((uint32_t)0x80000000U) /* ADC offset number 3 offset enable */

/******************  Bit definition for ADC_OFFSET4 register  *******************/
#define ADC_OFFSET4_OFFSCH4DAT    ((uint32_t)0x00000FFFU) /* ADC offset number 4 offset date */
#define ADC_OFFSET4_OFFSCH4DIR    ((uint32_t)0x01000000U) /* ADC offset number 4 positive */
#define ADC_OFFSET4_OFFSCH4SATEN  ((uint32_t)0x02000000U) /* ADC offset number 4 saturation enable */

#define ADC_OFFSET4_OFFSCH4CH     ((uint32_t)0x7C000000U) /* OFFSCH4CH[4:0] bits (ADC offset number 4 channel selection) */
#define ADC_OFFSET4_OFFSCH4CH_0   ((uint32_t)0x04000000U) /* Bit 0 */
#define ADC_OFFSET4_OFFSCH4CH_1   ((uint32_t)0x08000000U) /* Bit 1 */
#define ADC_OFFSET4_OFFSCH4CH_2   ((uint32_t)0x10000000U) /* Bit 2 */
#define ADC_OFFSET4_OFFSCH4CH_3   ((uint32_t)0x20000000U) /* Bit 3 */
#define ADC_OFFSET4_OFFSCH4CH_4   ((uint32_t)0x40000000U) /* Bit 4 */

#define ADC_OFFSET4_OFFSCH2EN     ((uint32_t)0x80000000U) /* ADC offset number 4 offset enable */

/****************** Bit definition for ADC_AWD1HIGH register  *******************/
#define ADC_AWD1HIGH_HTH          ((uint32_t)0x00000FFFU) /* Analog watchdog 1 high threshold */

/****************** Bit definition for ADC_AWD1LOW register  ********************/
#define ADC_AWD1LOW_LTH           ((uint32_t)0x00000FFFU) /* Analog watchdog 1 low threshold */

#define ADC_AWD1LOW_AWDFIL        ((uint32_t)0x00007000U) /* AWDFIL[2:0] bits (Analog watchdog 1 Filter value) */
#define ADC_AWD1LOW_AWDFIL_0      ((uint32_t)0x00001000U) /* Bit 0 */
#define ADC_AWD1LOW_AWDFIL_1      ((uint32_t)0x00002000U) /* Bit 1 */
#define ADC_AWD1LOW_AWDFIL_2      ((uint32_t)0x00004000U) /* Bit 2 */

/******************* Bit definition for ADC_AWD2HIGH register  *****************/
#define ADC_AWD2HIGH_HTH          ((uint32_t)0x00000FFFU) /* Analog watchdog 2 high threshold */

/******************* Bit definition for ADC_AWD2LOW register  ******************/
#define ADC_AWD2LOW_LTH           ((uint32_t)0x00000FFFU) /* Analog watchdog 2 low threshold */

/*******************  Bit definition for ADC_AWD3HIGH register *****************/
#define ADC_AWD3HIGH_HTH          ((uint32_t)0x00000FFFU) /* Analog watchdog 3 high threshold */

/******************* Bit definition for ADC_AWD3LOW register  ******************/
#define ADC_AWD3LOW_LTH           ((uint32_t)0x00000FFFU) /* Analog watchdog 3 low threshold */

/********************  Bit definition for ADC_AWD2EN register  ****************/
#define ADC_AWD2EN_AWD2EN         ((uint32_t)0x0007FFFFU) /* AWD2EN[18:0] bits (ADC analog watchdog 2 monitored channel selection) */
#define ADC_AWD2EN_AWD2EN_CH0     ((uint32_t)0x00000001U) /* ADC analog watchdog 2 monitored channel 0 */
#define ADC_AWD2EN_AWD2EN_CH1     ((uint32_t)0x00000002U) /* ADC analog watchdog 2 monitored channel 1 */
#define ADC_AWD2EN_AWD2EN_CH2     ((uint32_t)0x00000004U) /* ADC analog watchdog 2 monitored channel 2 */
#define ADC_AWD2EN_AWD2EN_CH3     ((uint32_t)0x00000008U) /* ADC analog watchdog 2 monitored channel 3 */
#define ADC_AWD2EN_AWD2EN_CH4     ((uint32_t)0x00000010U) /* ADC analog watchdog 2 monitored channel 4 */
#define ADC_AWD2EN_AWD2EN_CH5     ((uint32_t)0x00000020U) /* ADC analog watchdog 2 monitored channel 5 */
#define ADC_AWD2EN_AWD2EN_CH6     ((uint32_t)0x00000040U) /* ADC analog watchdog 2 monitored channel 6 */
#define ADC_AWD2EN_AWD2EN_CH7     ((uint32_t)0x00000080U) /* ADC analog watchdog 2 monitored channel 7 */
#define ADC_AWD2EN_AWD2EN_CH8     ((uint32_t)0x00000100U) /* ADC analog watchdog 2 monitored channel 8 */
#define ADC_AWD2EN_AWD2EN_CH9     ((uint32_t)0x00000200U) /* ADC analog watchdog 2 monitored channel 9 */
#define ADC_AWD2EN_AWD2EN_CH10    ((uint32_t)0x00000400U) /* ADC analog watchdog 2 monitored channel 10 */
#define ADC_AWD2EN_AWD2EN_CH11    ((uint32_t)0x00000800U) /* ADC analog watchdog 2 monitored channel 11 */
#define ADC_AWD2EN_AWD2EN_CH12    ((uint32_t)0x00001000U) /* ADC analog watchdog 2 monitored channel 12 */
#define ADC_AWD2EN_AWD2EN_CH13    ((uint32_t)0x00002000U) /* ADC analog watchdog 2 monitored channel 13 */
#define ADC_AWD2EN_AWD2EN_CH14    ((uint32_t)0x00004000U) /* ADC analog watchdog 2 monitored channel 14 */
#define ADC_AWD2EN_AWD2EN_CH15    ((uint32_t)0x00008000U) /* ADC analog watchdog 2 monitored channel 15 */
#define ADC_AWD2EN_AWD2EN_CH16    ((uint32_t)0x00010000U) /* ADC analog watchdog 2 monitored channel 16 */
#define ADC_AWD2EN_AWD2EN_CH17    ((uint32_t)0x00020000U) /* ADC analog watchdog 2 monitored channel 17 */
#define ADC_AWD2EN_AWD2EN_CH18    ((uint32_t)0x00040000U) /* ADC analog watchdog 2 monitored channel 18 */

/********************  Bit definition for ADC_AWD3EN register  ****************/
#define ADC_AWD3EN_AWD3EN         ((uint32_t)0x0007FFFFU) /* AWD3EN[18:0] bits (ADC analog watchdog 3 monitored channel selection) */
#define ADC_AWD3EN_AWD3EN_CH0     ((uint32_t)0x00000001U) /* ADC analog watchdog 3 monitored channel 0 */
#define ADC_AWD3EN_AWD3EN_CH1     ((uint32_t)0x00000002U) /* ADC analog watchdog 3 monitored channel 1 */
#define ADC_AWD3EN_AWD3EN_CH2     ((uint32_t)0x00000004U) /* ADC analog watchdog 3 monitored channel 2 */
#define ADC_AWD3EN_AWD3EN_CH3     ((uint32_t)0x00000008U) /* ADC analog watchdog 3 monitored channel 3 */
#define ADC_AWD3EN_AWD3EN_CH4     ((uint32_t)0x00000010U) /* ADC analog watchdog 3 monitored channel 4 */
#define ADC_AWD3EN_AWD3EN_CH5     ((uint32_t)0x00000020U) /* ADC analog watchdog 3 monitored channel 5 */
#define ADC_AWD3EN_AWD3EN_CH6     ((uint32_t)0x00000040U) /* ADC analog watchdog 3 monitored channel 6 */
#define ADC_AWD3EN_AWD3EN_CH7     ((uint32_t)0x00000080U) /* ADC analog watchdog 3 monitored channel 7 */
#define ADC_AWD3EN_AWD3EN_CH8     ((uint32_t)0x00000100U) /* ADC analog watchdog 3 monitored channel 8 */
#define ADC_AWD3EN_AWD3EN_CH9     ((uint32_t)0x00000200U) /* ADC analog watchdog 3 monitored channel 9 */
#define ADC_AWD3EN_AWD3EN_CH10    ((uint32_t)0x00000400U) /* ADC analog watchdog 3 monitored channel 10 */
#define ADC_AWD3EN_AWD3EN_CH11    ((uint32_t)0x00000800U) /* ADC analog watchdog 3 monitored channel 11 */
#define ADC_AWD3EN_AWD3EN_CH12    ((uint32_t)0x00001000U) /* ADC analog watchdog 3 monitored channel 12 */
#define ADC_AWD3EN_AWD3EN_CH13    ((uint32_t)0x00002000U) /* ADC analog watchdog 3 monitored channel 13 */
#define ADC_AWD3EN_AWD3EN_CH14    ((uint32_t)0x00004000U) /* ADC analog watchdog 3 monitored channel 14 */
#define ADC_AWD3EN_AWD3EN_CH15    ((uint32_t)0x00008000U) /* ADC analog watchdog 3 monitored channel 15 */
#define ADC_AWD3EN_AWD3EN_CH16    ((uint32_t)0x00010000U) /* ADC analog watchdog 3 monitored channel 16 */
#define ADC_AWD3EN_AWD3EN_CH17    ((uint32_t)0x00020000U) /* ADC analog watchdog 3 monitored channel 17 */
#define ADC_AWD3EN_AWD3EN_CH18    ((uint32_t)0x00040000U) /* ADC analog watchdog 3 monitored channel 18 */

/********************  Bit definition for ADC_AWD2INTEN register  ****************/
#define ADC_AWD2INTEN             ((uint32_t)0x0007FFFFU) /* AWD2INTEN[18:0] bits (ADC analog watchdog 2 channel interrupt enable) */
#define ADC_AWD2INTEN_CH0         ((uint32_t)0x00000001U) /* ADC analog watchdog 2 channel0 interrupt enable */
#define ADC_AWD2INTEN_CH1         ((uint32_t)0x00000002U) /* ADC analog watchdog 2 channel1 interrupt enable */
#define ADC_AWD2INTEN_CH2         ((uint32_t)0x00000004U) /* ADC analog watchdog 2 channel2 interrupt enable */
#define ADC_AWD2INTEN_CH3         ((uint32_t)0x00000008U) /* ADC analog watchdog 2 channel3 interrupt enable */
#define ADC_AWD2INTEN_CH4         ((uint32_t)0x00000010U) /* ADC analog watchdog 2 channel4 interrupt enable */
#define ADC_AWD2INTEN_CH5         ((uint32_t)0x00000020U) /* ADC analog watchdog 2 channel5 interrupt enable */
#define ADC_AWD2INTEN_CH6         ((uint32_t)0x00000040U) /* ADC analog watchdog 2 channel6 interrupt enable */
#define ADC_AWD2INTEN_CH7         ((uint32_t)0x00000080U) /* ADC analog watchdog 2 channel7 interrupt enable */
#define ADC_AWD2INTEN_CH8         ((uint32_t)0x00000100U) /* ADC analog watchdog 2 channel8 interrupt enable */
#define ADC_AWD2INTEN_CH9         ((uint32_t)0x00000200U) /* ADC analog watchdog 2 channel9 interrupt enable */
#define ADC_AWD2INTEN_CH10        ((uint32_t)0x00000400U) /* ADC analog watchdog 2 channel10 interrupt enable */
#define ADC_AWD2INTEN_CH11        ((uint32_t)0x00000800U) /* ADC analog watchdog 2 channel11 interrupt enable */
#define ADC_AWD2INTEN_CH12        ((uint32_t)0x00001000U) /* ADC analog watchdog 2 channel12 interrupt enable */
#define ADC_AWD2INTEN_CH13        ((uint32_t)0x00002000U) /* ADC analog watchdog 2 channel13 interrupt enable */
#define ADC_AWD2INTEN_CH14        ((uint32_t)0x00004000U) /* ADC analog watchdog 2 channel14 interrupt enable */
#define ADC_AWD2INTEN_CH15        ((uint32_t)0x00008000U) /* ADC analog watchdog 2 channel15 interrupt enable */
#define ADC_AWD2INTEN_CH16        ((uint32_t)0x00010000U) /* ADC analog watchdog 2 channel16 interrupt enable */
#define ADC_AWD2INTEN_CH17        ((uint32_t)0x00020000U) /* ADC analog watchdog 2 channel17 interrupt enable */
#define ADC_AWD2INTEN_CH18        ((uint32_t)0x00040000U) /* ADC analog watchdog 2 channel18 interrupt enable */

/********************  Bit definition for ADC_AWD3EN register  ****************/
#define ADC_AWD3INTEN             ((uint32_t)0x0007FFFFU) /* AWD3INTEN[18:0] bits (ADC analog watchdog 3 channel interrupt enable) */
#define ADC_AWD3INTEN_CH0         ((uint32_t)0x00000001U) /* ADC analog watchdog 3 channel0 interrupt enable */
#define ADC_AWD3INTEN_CH1         ((uint32_t)0x00000002U) /* ADC analog watchdog 3 channel1 interrupt enable */
#define ADC_AWD3INTEN_CH2         ((uint32_t)0x00000004U) /* ADC analog watchdog 3 channel2 interrupt enable */
#define ADC_AWD3INTEN_CH3         ((uint32_t)0x00000008U) /* ADC analog watchdog 3 channel3 interrupt enable */
#define ADC_AWD3INTEN_CH4         ((uint32_t)0x00000010U) /* ADC analog watchdog 3 channel4 interrupt enable */
#define ADC_AWD3INTEN_CH5         ((uint32_t)0x00000020U) /* ADC analog watchdog 3 channel5 interrupt enable */
#define ADC_AWD3INTEN_CH6         ((uint32_t)0x00000040U) /* ADC analog watchdog 3 channel6 interrupt enable */
#define ADC_AWD3INTEN_CH7         ((uint32_t)0x00000080U) /* ADC analog watchdog 3 channel7 interrupt enable */
#define ADC_AWD3INTEN_CH8         ((uint32_t)0x00000100U) /* ADC analog watchdog 3 channel8 interrupt enable */
#define ADC_AWD3INTEN_CH9         ((uint32_t)0x00000200U) /* ADC analog watchdog 3 channel9 interrupt enable */
#define ADC_AWD3INTEN_CH10        ((uint32_t)0x00000400U) /* ADC analog watchdog 3 channel10 interrupt enable */
#define ADC_AWD3INTEN_CH11        ((uint32_t)0x00000800U) /* ADC analog watchdog 3 channel11 interrupt enable */
#define ADC_AWD3INTEN_CH12        ((uint32_t)0x00001000U) /* ADC analog watchdog 3 channel12 interrupt enable */
#define ADC_AWD3INTEN_CH13        ((uint32_t)0x00002000U) /* ADC analog watchdog 3 channel13 interrupt enable */
#define ADC_AWD3INTEN_CH14        ((uint32_t)0x00004000U) /* ADC analog watchdog 3 channel14 interrupt enable */
#define ADC_AWD3INTEN_CH15        ((uint32_t)0x00008000U) /* ADC analog watchdog 3 channel15 interrupt enable */
#define ADC_AWD3INTEN_CH16        ((uint32_t)0x00010000U) /* ADC analog watchdog 3 channel16 interrupt enable */
#define ADC_AWD3INTEN_CH17        ((uint32_t)0x00020000U) /* ADC analog watchdog 3 channel17 interrupt enable */
#define ADC_AWD3INTEN_CH18        ((uint32_t)0x00040000U) /* ADC analog watchdog 3 channel18 interrupt enable */

/********************  Bit definition for ADC_AWD2STS register  ****************/
#define ADC_AWD2STS               ((uint32_t)0x0007FFFFU) /* AWD2FLAG[18:0] bits (ADC analog watchdog 2 status flag) */
#define ADC_AWD2STS_AWD2FLAG_CH0  ((uint32_t)0x00000001U) /* ADC analog watchdog 2 channel0 status flag */
#define ADC_AWD2STS_AWD2FLAG_CH1  ((uint32_t)0x00000002U) /* ADC analog watchdog 2 channel1 status flag */
#define ADC_AWD2STS_AWD2FLAG_CH2  ((uint32_t)0x00000004U) /* ADC analog watchdog 2 channel2 status flag */
#define ADC_AWD2STS_AWD2FLAG_CH3  ((uint32_t)0x00000008U) /* ADC analog watchdog 2 channel3 status flag */
#define ADC_AWD2STS_AWD2FLAG_CH4  ((uint32_t)0x00000010U) /* ADC analog watchdog 2 channel4 status flag */
#define ADC_AWD2STS_AWD2FLAG_CH5  ((uint32_t)0x00000020U) /* ADC analog watchdog 2 channel5 status flag */
#define ADC_AWD2STS_AWD2FLAG_CH6  ((uint32_t)0x00000040U) /* ADC analog watchdog 2 channel6 status flag */
#define ADC_AWD2STS_AWD2FLAG_CH7  ((uint32_t)0x00000080U) /* ADC analog watchdog 2 channel7 status flag */
#define ADC_AWD2STS_AWD2FLAG_CH8  ((uint32_t)0x00000100U) /* ADC analog watchdog 2 channel8 status flag */
#define ADC_AWD2STS_AWD2FLAG_CH9  ((uint32_t)0x00000200U) /* ADC analog watchdog 2 channel9 status flag */
#define ADC_AWD2STS_AWD2FLAG_CH10 ((uint32_t)0x00000400U) /* ADC analog watchdog 2 channel10 status flag */
#define ADC_AWD2STS_AWD2FLAG_CH11 ((uint32_t)0x00000800U) /* ADC analog watchdog 2 channel11 status flag */
#define ADC_AWD2STS_AWD2FLAG_CH12 ((uint32_t)0x00001000U) /* ADC analog watchdog 2 channel12 status flag */
#define ADC_AWD2STS_AWD2FLAG_CH13 ((uint32_t)0x00002000U) /* ADC analog watchdog 2 channel13 status flag */
#define ADC_AWD2STS_AWD2FLAG_CH14 ((uint32_t)0x00004000U) /* ADC analog watchdog 2 channel14 status flag */
#define ADC_AWD2STS_AWD2FLAG_CH15 ((uint32_t)0x00008000U) /* ADC analog watchdog 2 channel15 status flag */
#define ADC_AWD2STS_AWD2FLAG_CH16 ((uint32_t)0x00010000U) /* ADC analog watchdog 2 channel16 status flag */
#define ADC_AWD2STS_AWD2FLAG_CH17 ((uint32_t)0x00020000U) /* ADC analog watchdog 2 channel17 status flag */
#define ADC_AWD2STS_AWD2FLAG_CH18 ((uint32_t)0x00040000U) /* ADC analog watchdog 2 channel18 status flag */

/********************  Bit definition for ADC_AWD3STS register  ****************/
#define ADC_AWD3STS               ((uint32_t)0x0007FFFFU) /* AWD3FLAG[18:0] bits (ADC analog watchdog 3 status flag) */
#define ADC_AWD3STS_AWD3FLAG_CH0  ((uint32_t)0x00000001U) /* ADC analog watchdog 3 channel0 status flag */
#define ADC_AWD3STS_AWD3FLAG_CH1  ((uint32_t)0x00000002U) /* ADC analog watchdog 3 channel1 status flag */
#define ADC_AWD3STS_AWD3FLAG_CH2  ((uint32_t)0x00000004U) /* ADC analog watchdog 3 channel2 status flag */
#define ADC_AWD3STS_AWD3FLAG_CH3  ((uint32_t)0x00000008U) /* ADC analog watchdog 3 channel3 status flag */
#define ADC_AWD3STS_AWD3FLAG_CH4  ((uint32_t)0x00000010U) /* ADC analog watchdog 3 channel4 status flag */
#define ADC_AWD3STS_AWD3FLAG_CH5  ((uint32_t)0x00000020U) /* ADC analog watchdog 3 channel5 status flag */
#define ADC_AWD3STS_AWD3FLAG_CH6  ((uint32_t)0x00000040U) /* ADC analog watchdog 3 channel6 status flag */
#define ADC_AWD3STS_AWD3FLAG_CH7  ((uint32_t)0x00000080U) /* ADC analog watchdog 3 channel7 status flag */
#define ADC_AWD3STS_AWD3FLAG_CH8  ((uint32_t)0x00000100U) /* ADC analog watchdog 3 channel8 status flag */
#define ADC_AWD3STS_AWD3FLAG_CH9  ((uint32_t)0x00000200U) /* ADC analog watchdog 3 channel9 status flag */
#define ADC_AWD3STS_AWD3FLAG_CH10 ((uint32_t)0x00000400U) /* ADC analog watchdog 3 channel10 status flag */
#define ADC_AWD3STS_AWD3FLAG_CH11 ((uint32_t)0x00000800U) /* ADC analog watchdog 3 channel11 status flag */
#define ADC_AWD3STS_AWD3FLAG_CH12 ((uint32_t)0x00001000U) /* ADC analog watchdog 3 channel12 status flag */
#define ADC_AWD3STS_AWD3FLAG_CH13 ((uint32_t)0x00002000U) /* ADC analog watchdog 3 channel13 status flag */
#define ADC_AWD3STS_AWD3FLAG_CH14 ((uint32_t)0x00004000U) /* ADC analog watchdog 3 channel14 status flag */
#define ADC_AWD3STS_AWD3FLAG_CH15 ((uint32_t)0x00008000U) /* ADC analog watchdog 3 channel15 status flag */
#define ADC_AWD3STS_AWD3FLAG_CH16 ((uint32_t)0x00010000U) /* ADC analog watchdog 3 channel16 status flag */
#define ADC_AWD3STS_AWD3FLAG_CH17 ((uint32_t)0x00020000U) /* ADC analog watchdog 3 channel17 status flag */
#define ADC_AWD3STS_AWD3FLAG_CH18 ((uint32_t)0x00040000U) /* ADC analog watchdog 3 channel18 status flag */

/*******************  Bit definition for ADC_RSEQ1 register  *******************/
#define ADC_RSEQ1_SEQ1            ((uint32_t)0x0000001FU) /* SEQ1[4:0] bits (1st conversion in regular sequence) */
#define ADC_RSEQ1_SEQ1_0          ((uint32_t)0x00000001U) /* Bit 0 */
#define ADC_RSEQ1_SEQ1_1          ((uint32_t)0x00000002U) /* Bit 1 */
#define ADC_RSEQ1_SEQ1_2          ((uint32_t)0x00000004U) /* Bit 2 */
#define ADC_RSEQ1_SEQ1_3          ((uint32_t)0x00000008U) /* Bit 3 */
#define ADC_RSEQ1_SEQ1_4          ((uint32_t)0x00000010U) /* Bit 4 */

#define ADC_RSEQ1_SEQ2            ((uint32_t)0x000003E0U) /* SEQ2[4:0] bits (2nd conversion in regular sequence) */
#define ADC_RSEQ1_SEQ2_0          ((uint32_t)0x00000020U) /* Bit 0 */
#define ADC_RSEQ1_SEQ2_1          ((uint32_t)0x00000040U) /* Bit 1 */
#define ADC_RSEQ1_SEQ2_2          ((uint32_t)0x00000080U) /* Bit 2 */
#define ADC_RSEQ1_SEQ2_3          ((uint32_t)0x00000100U) /* Bit 3 */
#define ADC_RSEQ1_SEQ2_4          ((uint32_t)0x00000200U) /* Bit 4 */

#define ADC_RSEQ1_SEQ3            ((uint32_t)0x00007C00U) /* SEQ3[4:0] bits (3rd conversion in regular sequence) */
#define ADC_RSEQ1_SEQ3_0          ((uint32_t)0x00000400U) /* Bit 0 */
#define ADC_RSEQ1_SEQ3_1          ((uint32_t)0x00000800U) /* Bit 1 */
#define ADC_RSEQ1_SEQ3_2          ((uint32_t)0x00001000U) /* Bit 2 */
#define ADC_RSEQ1_SEQ3_3          ((uint32_t)0x00002000U) /* Bit 3 */
#define ADC_RSEQ1_SEQ3_4          ((uint32_t)0x00004000U) /* Bit 4 */

#define ADC_RSEQ1_SEQ4            ((uint32_t)0x000F8000U) /* SEQ4[4:0] bits (4th conversion in regular sequence) */
#define ADC_RSEQ1_SEQ4_0          ((uint32_t)0x00008000U) /* Bit 0 */
#define ADC_RSEQ1_SEQ4_1          ((uint32_t)0x00010000U) /* Bit 1 */
#define ADC_RSEQ1_SEQ4_2          ((uint32_t)0x00020000U) /* Bit 2 */
#define ADC_RSEQ1_SEQ4_3          ((uint32_t)0x00040000U) /* Bit 3 */
#define ADC_RSEQ1_SEQ4_4          ((uint32_t)0x00080000U) /* Bit 4 */

#define ADC_RSEQ1_SEQ5            ((uint32_t)0x01F00000U) /* SEQ5[4:0] bits (5th conversion in regular sequence) */
#define ADC_RSEQ1_SEQ5_0          ((uint32_t)0x00100000U) /* Bit 0 */
#define ADC_RSEQ1_SEQ5_1          ((uint32_t)0x00200000U) /* Bit 1 */
#define ADC_RSEQ1_SEQ5_2          ((uint32_t)0x00400000U) /* Bit 2 */
#define ADC_RSEQ1_SEQ5_3          ((uint32_t)0x00800000U) /* Bit 3 */
#define ADC_RSEQ1_SEQ5_4          ((uint32_t)0x01000000U) /* Bit 4 */

#define ADC_RSEQ1_SEQ6            ((uint32_t)0x3E000000U) /* SEQ6[4:0] bits (6th conversion in regular sequence) */
#define ADC_RSEQ1_SEQ6_0          ((uint32_t)0x02000000U) /* Bit 0 */
#define ADC_RSEQ1_SEQ6_1          ((uint32_t)0x04000000U) /* Bit 1 */
#define ADC_RSEQ1_SEQ6_2          ((uint32_t)0x08000000U) /* Bit 2 */
#define ADC_RSEQ1_SEQ6_3          ((uint32_t)0x10000000U) /* Bit 3 */
#define ADC_RSEQ1_SEQ6_4          ((uint32_t)0x20000000U) /* Bit 4 */

/*******************  Bit definition for ADC_RSEQ2 register  *******************/
#define ADC_RSEQ2_SEQ7            ((uint32_t)0x0000001FU) /* SEQ7[4:0] bits (7th conversion in regular sequence) */
#define ADC_RSEQ2_SEQ7_0          ((uint32_t)0x00000001U) /* Bit 0 */
#define ADC_RSEQ2_SEQ7_1          ((uint32_t)0x00000002U) /* Bit 1 */
#define ADC_RSEQ2_SEQ7_2          ((uint32_t)0x00000004U) /* Bit 2 */
#define ADC_RSEQ2_SEQ7_3          ((uint32_t)0x00000008U) /* Bit 3 */
#define ADC_RSEQ2_SEQ7_4          ((uint32_t)0x00000010U) /* Bit 4 */

#define ADC_RSEQ2_SEQ8            ((uint32_t)0x000003E0U) /* SEQ8[4:0] bits (8th conversion in regular sequence) */
#define ADC_RSEQ2_SEQ8_0          ((uint32_t)0x00000020U) /* Bit 0 */
#define ADC_RSEQ2_SEQ8_1          ((uint32_t)0x00000040U) /* Bit 1 */
#define ADC_RSEQ2_SEQ8_2          ((uint32_t)0x00000080U) /* Bit 2 */
#define ADC_RSEQ2_SEQ8_3          ((uint32_t)0x00000100U) /* Bit 3 */
#define ADC_RSEQ2_SEQ8_4          ((uint32_t)0x00000200U) /* Bit 4 */

#define ADC_RSEQ2_SEQ9            ((uint32_t)0x00007C00U) /* SEQ9[4:0] bits (9th conversion in regular sequence) */
#define ADC_RSEQ2_SEQ9_0          ((uint32_t)0x00000400U) /* Bit 0 */
#define ADC_RSEQ2_SEQ9_1          ((uint32_t)0x00000800U) /* Bit 1 */
#define ADC_RSEQ2_SEQ9_2          ((uint32_t)0x00001000U) /* Bit 2 */
#define ADC_RSEQ2_SEQ9_3          ((uint32_t)0x00002000U) /* Bit 3 */
#define ADC_RSEQ2_SEQ9_4          ((uint32_t)0x00004000U) /* Bit 4 */

#define ADC_RSEQ2_SEQ10           ((uint32_t)0x000F8000U) /* SEQ10[4:0] bits (10th conversion in regular sequence) */
#define ADC_RSEQ2_SEQ10_0         ((uint32_t)0x00008000U) /* Bit 0 */
#define ADC_RSEQ2_SEQ10_1         ((uint32_t)0x00010000U) /* Bit 1 */
#define ADC_RSEQ2_SEQ10_2         ((uint32_t)0x00020000U) /* Bit 2 */
#define ADC_RSEQ2_SEQ10_3         ((uint32_t)0x00040000U) /* Bit 3 */
#define ADC_RSEQ2_SEQ10_4         ((uint32_t)0x00080000U) /* Bit 4 */

#define ADC_RSEQ2_SEQ11           ((uint32_t)0x01F00000U) /* SEQ11[4:0] bits (11th conversion in regular sequence) */
#define ADC_RSEQ2_SEQ11_0         ((uint32_t)0x00100000U) /* Bit 0 */
#define ADC_RSEQ2_SEQ11_1         ((uint32_t)0x00200000U) /* Bit 1 */
#define ADC_RSEQ2_SEQ11_2         ((uint32_t)0x00400000U) /* Bit 2 */
#define ADC_RSEQ2_SEQ11_3         ((uint32_t)0x00800000U) /* Bit 3 */
#define ADC_RSEQ2_SEQ11_4         ((uint32_t)0x01000000U) /* Bit 4 */

#define ADC_RSEQ2_SEQ12           ((uint32_t)0x3E000000U) /* SEQ12[4:0] bits (12th conversion in regular sequence) */
#define ADC_RSEQ2_SEQ12_0         ((uint32_t)0x02000000U) /* Bit 0 */
#define ADC_RSEQ2_SEQ12_1         ((uint32_t)0x04000000U) /* Bit 1 */
#define ADC_RSEQ2_SEQ12_2         ((uint32_t)0x08000000U) /* Bit 2 */
#define ADC_RSEQ2_SEQ12_3         ((uint32_t)0x10000000U) /* Bit 3 */
#define ADC_RSEQ2_SEQ12_4         ((uint32_t)0x20000000U) /* Bit 4 */

/*******************  Bit definition for ADC_RSEQ3 register  *******************/
#define ADC_RSEQ3_SEQ13           ((uint32_t)0x0000001FU) /* SEQ13[4:0] bits (13th conversion in regular sequence) */
#define ADC_RSEQ3_SEQ13_0         ((uint32_t)0x00000001U) /* Bit 0 */
#define ADC_RSEQ3_SEQ13_1         ((uint32_t)0x00000002U) /* Bit 1 */
#define ADC_RSEQ3_SEQ13_2         ((uint32_t)0x00000004U) /* Bit 2 */
#define ADC_RSEQ3_SEQ13_3         ((uint32_t)0x00000008U) /* Bit 3 */
#define ADC_RSEQ3_SEQ13_4         ((uint32_t)0x00000010U) /* Bit 4 */

#define ADC_RSEQ3_SEQ14           ((uint32_t)0x000003E0U) /* SEQ14[4:0] bits (14th conversion in regular sequence) */
#define ADC_RSEQ3_SEQ14_0         ((uint32_t)0x00000020U) /* Bit 0 */
#define ADC_RSEQ3_SEQ14_1         ((uint32_t)0x00000040U) /* Bit 1 */
#define ADC_RSEQ3_SEQ14_2         ((uint32_t)0x00000080U) /* Bit 2 */
#define ADC_RSEQ3_SEQ14_3         ((uint32_t)0x00000100U) /* Bit 3 */
#define ADC_RSEQ3_SEQ14_4         ((uint32_t)0x00000200U) /* Bit 4 */

#define ADC_RSEQ3_SEQ15           ((uint32_t)0x00007C00U) /* SEQ15[4:0] bits (15th conversion in regular sequence) */
#define ADC_RSEQ3_SEQ15_0         ((uint32_t)0x00000400U) /* Bit 0 */
#define ADC_RSEQ3_SEQ15_1         ((uint32_t)0x00000800U) /* Bit 1 */
#define ADC_RSEQ3_SEQ15_2         ((uint32_t)0x00001000U) /* Bit 2 */
#define ADC_RSEQ3_SEQ15_3         ((uint32_t)0x00002000U) /* Bit 3 */
#define ADC_RSEQ3_SEQ15_4         ((uint32_t)0x00004000U) /* Bit 4 */

#define ADC_RSEQ3_SEQ16           ((uint32_t)0x000F8000U) /* SEQ16[4:0] bits (16th conversion in regular sequence) */
#define ADC_RSEQ3_SEQ16_0         ((uint32_t)0x00008000U) /* Bit 0 */
#define ADC_RSEQ3_SEQ16_1         ((uint32_t)0x00010000U) /* Bit 1 */
#define ADC_RSEQ3_SEQ16_2         ((uint32_t)0x00020000U) /* Bit 2 */
#define ADC_RSEQ3_SEQ16_3         ((uint32_t)0x00040000U) /* Bit 3 */
#define ADC_RSEQ3_SEQ16_4         ((uint32_t)0x00080000U) /* Bit 4 */

#define ADC_RSEQ3_LEN             ((uint32_t)0x1E000000U) /* LEN[3:0] bits (Regular channel sequence length) */
#define ADC_RSEQ3_LEN_0           ((uint32_t)0x02000000U) /* Bit 0 */
#define ADC_RSEQ3_LEN_1           ((uint32_t)0x04000000U) /* Bit 1 */
#define ADC_RSEQ3_LEN_2           ((uint32_t)0x08000000U) /* Bit 2 */
#define ADC_RSEQ3_LEN_3           ((uint32_t)0x10000000U) /* Bit 3 */

/*******************  Bit definition for ADC_JSEQ register  *******************/
#define ADC_JSEQ_JSEQ1            ((uint32_t)0x0000001FU) /* JSEQ1[4:0] bits (1st conversion in injected sequence) */
#define ADC_JSEQ_JSEQ1_0          ((uint32_t)0x00000001U) /* Bit 0 */
#define ADC_JSEQ_JSEQ1_1          ((uint32_t)0x00000002U) /* Bit 1 */
#define ADC_JSEQ_JSEQ1_2          ((uint32_t)0x00000004U) /* Bit 2 */
#define ADC_JSEQ_JSEQ1_3          ((uint32_t)0x00000008U) /* Bit 3 */
#define ADC_JSEQ_JSEQ1_4          ((uint32_t)0x00000010U) /* Bit 4 */

#define ADC_JSEQ_JSEQ2            ((uint32_t)0x000003E0U) /* JSEQ2[4:0] bits (2nd conversion in injected sequence) */
#define ADC_JSEQ_JSEQ2_0          ((uint32_t)0x00000020U) /* Bit 0 */
#define ADC_JSEQ_JSEQ2_1          ((uint32_t)0x00000040U) /* Bit 1 */
#define ADC_JSEQ_JSEQ2_2          ((uint32_t)0x00000080U) /* Bit 2 */
#define ADC_JSEQ_JSEQ2_3          ((uint32_t)0x00000100U) /* Bit 3 */
#define ADC_JSEQ_JSEQ2_4          ((uint32_t)0x00000200U) /* Bit 4 */

#define ADC_JSEQ_JSEQ3            ((uint32_t)0x00007C00U) /* JSEQ3[4:0] bits (3rd conversion in injected sequence) */
#define ADC_JSEQ_JSEQ3_0          ((uint32_t)0x00000400U) /* Bit 0 */
#define ADC_JSEQ_JSEQ3_1          ((uint32_t)0x00000800U) /* Bit 1 */
#define ADC_JSEQ_JSEQ3_2          ((uint32_t)0x00001000U) /* Bit 2 */
#define ADC_JSEQ_JSEQ3_3          ((uint32_t)0x00002000U) /* Bit 3 */
#define ADC_JSEQ_JSEQ3_4          ((uint32_t)0x00004000U) /* Bit 4 */

#define ADC_JSEQ_JSEQ4            ((uint32_t)0x000F8000U) /* JSEQ4[4:0] bits (4th conversion in injected sequence) */
#define ADC_JSEQ_JSEQ4_0          ((uint32_t)0x00008000U) /* Bit 0 */
#define ADC_JSEQ_JSEQ4_1          ((uint32_t)0x00010000U) /* Bit 1 */
#define ADC_JSEQ_JSEQ4_2          ((uint32_t)0x00020000U) /* Bit 2 */
#define ADC_JSEQ_JSEQ4_3          ((uint32_t)0x00040000U) /* Bit 3 */
#define ADC_JSEQ_JSEQ4_4          ((uint32_t)0x00080000U) /* Bit 4 */

#define ADC_JSEQ_JLEN             ((uint32_t)0x06000000U) /* JLEN[1:0] bits (Injected Sequence length) */
#define ADC_JSEQ_JLEN_0           ((uint32_t)0x02000000U) /* Bit 0 */
#define ADC_JSEQ_JLEN_1           ((uint32_t)0x04000000U) /* Bit 1 */

/*******************  Bit definition for ADC_JDAT1 register  *******************/
#define ADC_JDAT1_JDAT            ((uint16_t)0xFFFFU) /* Injected data */

/*******************  Bit definition for ADC_JDAT2 register  *******************/
#define ADC_JDAT2_JDAT            ((uint16_t)0xFFFFU) /* Injected data */

/*******************  Bit definition for ADC_JDAT3 register  *******************/
#define ADC_JDAT3_JDAT            ((uint16_t)0xFFFFU) /* Injected data */

/*******************  Bit definition for ADC_JDAT4 register  *******************/
#define ADC_JDAT4_JDAT            ((uint16_t)0xFFFFU) /* Injected data */

/********************  Bit definition for ADC_DAT register  ********************/
#define ADC_DAT_DAT               ((uint32_t)0x0000FFFFU) /* Regular data */
#define ADC_DAT_ADC2DAT           ((uint32_t)0xFFFF0000U) /* Slave ADC data when operating on Muti-ADC */

/********************  Bit definition for ADC_FIFOCFG register  ********************/
#define ADC_FIFOCFG_REINTEN       ((uint32_t)0x00000001U) /* FIFO read error interrup enable */
#define ADC_FIFOCFG_WEINTEN       ((uint32_t)0x00000002U) /* FIFO write error interrup enable */
#define ADC_FIFOCFG_FINTEN        ((uint32_t)0x00000004U) /* FIFO full interrup enable */
#define ADC_FIFOCFG_EINTEN        ((uint32_t)0x00000008U) /* FIFO empty interrup enable */
#define ADC_FIFOCFG_HFINTEN       ((uint32_t)0x00000010U) /* FIFO half-full interrup enable */
#define ADC_FIFOCFG_EN            ((uint32_t)0x00000020U) /* FIFO enable */

#define ADC_FIFOCFG_WL            ((uint32_t)0x000003C0U) /* WL[1:0] bits (FIFO water level) */
#define ADC_FIFOCFG_WL_0          ((uint32_t)0x00000040U) /* Bit 0 */
#define ADC_FIFOCFG_WL_1          ((uint32_t)0x00000080U) /* Bit 1 */
#define ADC_FIFOCFG_WL_2          ((uint32_t)0x00000100U) /* Bit 2 */
#define ADC_FIFOCFG_WL_3          ((uint32_t)0x00000200U) /* Bit 3 */

#define ADC_FIFOCFG_CLR           ((uint32_t)0x00000400U) /* FIFO clear enable */
#define ADC_FIFOCFG_NEINTEN       ((uint32_t)0x00000800U) /* FIFO non-empty interrupt enable */

/********************  Bit definition for ADC_FIFOSTS register  ********************/
#define ADC_FIFOSTS_REFLAG        ((uint32_t)0x00000001U) /* FIFO read error status flag */
#define ADC_FIFOSTS_WEFLAG        ((uint32_t)0x00000002U) /* FIFO write error status flag */
#define ADC_FIFOSTS_FFLAG         ((uint32_t)0x00000004U) /* FIFO full status flag */
#define ADC_FIFOSTS_EFLAG         ((uint32_t)0x00000008U) /* FIFO empty status flag*/
#define ADC_FIFOSTS_HFFLAG        ((uint32_t)0x00000010U) /* FIFO half-full status flag */

#define ADC_FIFOSTS_DATCNT        ((uint32_t)0x000003E0U) /* DATCNT[4:0] bits (FIFO invalid data count) */
#define ADC_FIFOSTS_DATCNT_0      ((uint32_t)0x00000020U) /* Bit 0 */
#define ADC_FIFOSTS_DATCNT_1      ((uint32_t)0x00000040U) /* Bit 1 */
#define ADC_FIFOSTS_DATCNT_2      ((uint32_t)0x00000080U) /* Bit 2 */
#define ADC_FIFOSTS_DATCNT_3      ((uint32_t)0x00000100U) /* Bit 3 */
#define ADC_FIFOSTS_DATCNT_4      ((uint32_t)0x00000200U) /* Bit 4 */

#define ADC_FIFOSTS_NEFLAG        ((uint32_t)0x00000800U) /* FIFO non-empty status flag */

/********************  Bit definition for ADC_PTRL register  ********************/
#define ADC_PCTRL_VREFLDOEN       ((uint32_t)0x00000008U) 
#define ADC_PCTRL_RANGESEL        ((uint32_t)0x00000010U) 
#define ADC_PCTRL_EXTPEN          ((uint32_t)0x00000020U) 

/********************  Bit definition for ADC_CTRL4 register  ********************/
#define ADC_CTRL4_EXTRRSEL        ((uint32_t)0x000F0000U) /* EXTRRSEL[3:0] bits (regular channel exti line source select) */
#define ADC_CTRL4_EXTRISEL        ((uint32_t)0x00F00000U) /* EXTRISEL[3:0] bits (injected channel exti line source select)  */

/********************  Bit definition for ADC_INTEN register  ********************/
#define ADC_INTEN_ENDCIEN         ((uint32_t)0x00000001U) /* End of conversion interrupt enable */
#define ADC_INTEN_ENDCAIEN        ((uint32_t)0x00000002U) /* Any end of conversion interrupt enable */
#define ADC_INTEN_JENDCIEN        ((uint32_t)0x00000004U) /* Injected channel end of conversion interrupt enable */
#define ADC_INTEN_JENDCAIEN       ((uint32_t)0x00000008U) /* Any injected channel end of conversion interrupt enable */
#define ADC_INTEN_AWD1IEN         ((uint32_t)0x00000010U) /* Analog watchdog 1 interrupt enable */
#define ADC_INTEN_ENDCERRIEN      ((uint32_t)0x00000020U) /* End of conversion error interrupt enable */
#define ADC_INTEN_RDYIEN          ((uint32_t)0x00000040U) /* ADC power up ready interrupt enable */
#define ADC_INTEN_PDRDYIEN        ((uint32_t)0x00000080U) /* ADC power down ready interrupt enable */
#define ADC_INTEN_EOSMPIEN        ((uint32_t)0x00000100U) /* End of Sampling interrupt enable */

/********************  Bit definition for ADC_GCOMP register  ****************/
#define ADC_GCOMP_GCOMPDAT        ((uint32_t)0x00003FFFU) /* GCOMPDAT[13:0] bits (ADC Gain Compensation Coefficient) */ 

/******************************************************************************/
/*                                                                            */
/*                      Digital to Analog Converter                           */
/*                                                                            */
/******************************************************************************/

/********************  Bit definition for DAC_CTRL register  ********************/
#define DAC_CTRL_DACxEN           ((uint32_t)0x00000001U) /* DACx enable */
#define DAC_CTRL_DMAxEN           ((uint32_t)0x00000002U) /* DACx DMA enable */
#define DAC_CTRL_BxEN             ((uint32_t)0x00000004U) /* DACx output buffer enable */
#define DAC_CTRL_TxEN             ((uint32_t)0x00000008U) /* DACx Trigger enable */
#define DAC_CTRL_DMAUDRxIEn       ((uint32_t)0x00000010U) /* DACx DMA underrun interrupt enable */
#define DAC_CTRL_HDBxEN           ((uint32_t)0x00000020U) /* DACx high driver output buffer enable */
#define DAC_CTRL_DMADOUBLExEN     ((uint32_t)0x00000040U) /* DACx DMA double data mode enable */
#define DAC_CTRL_SINFORMATxEN     ((uint32_t)0x00000080U) /* DACx signed format enable */

#define DAC_CTRL_WxEN             ((uint32_t)0x00000700U) /* WAVE1[1:0] (DACx noise/triangle wave generation enable) */
#define DAC_CTRL_WxEN_0           ((uint32_t)0x00000100U) /* Bit 0 */
#define DAC_CTRL_WxEN_1           ((uint32_t)0x00000200U) /* Bit 1 */
#define DAC_CTRL_WxEN_2           ((uint32_t)0x00000400U) /* Bit 2 */

#define DAC_CTRL_CALxEN           ((uint32_t)0x00000800U) /* DACx calibrate enable */
#define DAC_CTRL_INOUTx           ((uint32_t)0x00001000U) /* DACx is connected to on chip peripherals enable */
#define DAC_CTRL_EXOUTx           ((uint32_t)0x00002000U) /* DACx is connected to external pin enable */
#define DAC_CTRL_TROVCxIEN        ((uint32_t)0x00004000U) /* DACx's trigger overclock interrupt enable */

#define DAC_CTRL_DACyEN           ((uint32_t)0x00010000U) /* DACy enable */
#define DAC_CTRL_DMAyEN           ((uint32_t)0x00020000U) /* DACy DMA enable */
#define DAC_CTRL_ByEN             ((uint32_t)0x00040000U) /* DACy output buffer enable */
#define DAC_CTRL_TyEN             ((uint32_t)0x00080000U) /* DACy Trigger enable */
#define DAC_CTRL_DMAUDRyIEn       ((uint32_t)0x00100000U) /* DACy DMA underrun interrupt enable */
#define DAC_CTRL_HDByEN           ((uint32_t)0x00200000U) /* DACy high driver output buffer enable */
#define DAC_CTRL_DMADOUBLEyEN     ((uint32_t)0x00400000U) /* DACy DMA double data mode enable */
#define DAC_CTRL_SINFORMATyEN     ((uint32_t)0x00800000U) /* DACy signed format enable */

#define DAC_CTRL_WyEN             ((uint32_t)0x07000000U) /* WAVE2[1:0] (DACy noise/triangle wave generation enable) */
#define DAC_CTRL_WyEN_0           ((uint32_t)0x01000000U) /* Bit 0 */
#define DAC_CTRL_WyEN_1           ((uint32_t)0x02000000U) /* Bit 1 */
#define DAC_CTRL_WyEN_2           ((uint32_t)0x04000000U) /* Bit 2 */

#define DAC_CTRL_CALyEN           ((uint32_t)0x08000000U) /* DACy calibrate enable */
#define DAC_CTRL_INOUTy           ((uint32_t)0x10000000U) /* DACy is connected to on chip peripherals enable */
#define DAC_CTRL_EXOUTy           ((uint32_t)0x20000000U) /* DACy is connected to external pin enable */
#define DAC_CTRL_TROVCyIEN        ((uint32_t)0x40000000U) /* DACy's trigger overclock interrupt enable */

/*****************  Bit definition for DAC_SOTTR register  ******************/
#define DAC_SOTTR_TRxEN           ((uint32_t)0x00000001U) /* DACx software trigger */
#define DAC_SOTTR_TRyEN           ((uint32_t)0x00000002U) /* DACy software trigger */
#define DAC_SOTTR_TRBxEN          ((uint32_t)0x00010000U) /* DACx sawtooth step signal software trigger */
#define DAC_SOTTR_TRByEN          ((uint32_t)0x00020000U) /* DACy sawtooth step signal software trigger */

/*******************  Bit definition for DAC_DATO1 register  *******************/
#define DACx_DATO_DACxDO          ((uint16_t)0x0FFFU) /* DACx data output */

/*******************  Bit definition for DAC_DATO2 register  *******************/
#define DACy_DATO_DACyDO          ((uint16_t)0x0FFFU) /* DACy data output */

/******************  Bit definition for DAC_DR8CH1 register  ******************/
#define DACx_DR8_DACxD            ((uint16_t)0xFF00U) /* DACx 8-bit Right aligned data */
#define DACx_DR8_DACxDB           ((uint16_t)0x00FFU) /* DACx 8-bit Right aligned data, operating only on double data mode */

/*****************  Bit definition for DAC_DL12CH1 register  ******************/
#define DACx_DL12_DACxDB          ((uint32_t)0x0000FFF0U) /* DACx 12-bit Left aligned data */
#define DACx_DL12_DACxD           ((uint32_t)0xFFF00000U) /* DACx 12-bit Left aligned data, operating only on double data mode  */

/*****************  Bit definition for DAC_DR12CH1 register  ******************/
#define DACx_DR12_DACxDB          ((uint32_t)0x00000FFFU) /* DACx 12-bit Right aligned data */
#define DACx_DR12_DACxD           ((uint32_t)0x0FFF0000U) /* DACx 12-bit Right aligned data, operating only on double data mode  */

/******************  Bit definition for DAC_DR8CH2 register  ******************/
#define DACy_DR8_DACyD            ((uint16_t)0xFF00U) /* DACy 8-bit Right aligned data */
#define DACy_DR8_DACyDB           ((uint16_t)0x00FFU) /* DACy 8-bit Right aligned data, operating only on double data mode */

/*****************  Bit definition for DAC_DL12CH2 register  ******************/
#define DACy_DL12_DACyDB          ((uint32_t)0x0000FFF0U) /* DACy 12-bit Left aligned data */
#define DACy_DL12_DACyD           ((uint32_t)0xFFF00000U) /* DACy 12-bit Left aligned data, operating only on double data mode  */

/*****************  Bit definition for DAC_DR12CH2 register  ******************/
#define DACy_DR12_DACyDB          ((uint32_t)0x00000FFFU) /* DACy 12-bit Right aligned data */
#define DACy_DR12_DACyD           ((uint32_t)0x0FFF0000U) /* DACy 12-bit Right aligned data, operating only on double data mode  */

/******************  Bit definition for DAC_DR8DCH register  ******************/
#define DAC_DR8D_DACxD            ((uint16_t)0x00FFU) /* DACx 8-bit Right aligned data */
#define DAC_DR8D_DACyD            ((uint16_t)0xFF00U) /* DACy 8-bit Right aligned data */

/*****************  Bit definition for DAC_DL12DCH register  ******************/
#define DAC_DL12D_DACxD           ((uint32_t)0x0000FFF0U) /* DACx 12-bit Left aligned data */
#define DAC_DL12D_DACyD           ((uint32_t)0xFFF00000U) /* DACy 12-bit Left aligned data */

/*****************  Bit definition for DAC_DR12DCH register  ******************/
#define DAC_DR12D_DACxD           ((uint32_t)0x00000FFFU) /* DACx 12-bit Right aligned data */
#define DAC_DR12D_DACyD           ((uint32_t)0x0FFF0000U) /* DACy 12-bit Right aligned data */

/*****************  Bit definition for DAC_SELCTRL register  ******************/
#define DAC_SETCTRL_SINCSELx      ((uint32_t)0x0000003EU) /* DACx sawtooth increment trigger selection */
#define DAC_SETCTRL_SINCSELx_0    ((uint32_t)0x00000002U) /* Bit 0 */
#define DAC_SETCTRL_SINCSELx_1    ((uint32_t)0x00000004U) /* Bit 1 */
#define DAC_SETCTRL_SINCSELx_2    ((uint32_t)0x00000008U) /* Bit 2 */
#define DAC_SETCTRL_SINCSELx_3    ((uint32_t)0x00000010U) /* Bit 3 */
#define DAC_SETCTRL_SINCSELx_4    ((uint32_t)0x00000020U) /* Bit 4 */

#define DAC_SETCTRL_MAxSEL        ((uint32_t)0x000003C0U) /* MAMPx[3:0] (DACx Mask/Amplitude selector) */
#define DAC_SETCTRL_MAxSEL_0      ((uint32_t)0x00000040U) /* Bit 0 */
#define DAC_SETCTRL_MAxSEL_1      ((uint32_t)0x00000080U) /* Bit 1 */
#define DAC_SETCTRL_MAxSEL_2      ((uint32_t)0x00000100U) /* Bit 2 */
#define DAC_SETCTRL_MAxSEL_3      ((uint32_t)0x00000200U) /* Bit 3 */

#define DAC_SETCTRL_TxSEL         ((uint32_t)0x0000F100U) /* TSELx[4:0] (DACx Trigger source selection) */
#define DAC_SETCTRL_TxSEL_0       ((uint32_t)0x00000100U) /* Bit 0 */
#define DAC_SETCTRL_TxSEL_1       ((uint32_t)0x00001000U) /* Bit 1 */
#define DAC_SETCTRL_TxSEL_2       ((uint32_t)0x00002000U) /* Bit 2 */
#define DAC_SETCTRL_TxSEL_3       ((uint32_t)0x00004000U) /* Bit 3 */
#define DAC_SETCTRL_TxSEL_4       ((uint32_t)0x00008000U) /* Bit 4 */

#define DAC_SETCTRL_SINCSELy      ((uint32_t)0x003E0000U) /* SINCSELy[3:0] (DACy sawtooth increment trigger selection) */
#define DAC_SETCTRL_SINCSELy_0    ((uint32_t)0x00020000U) /* Bit 0 */
#define DAC_SETCTRL_SINCSELy_1    ((uint32_t)0x00040000U) /* Bit 1 */
#define DAC_SETCTRL_SINCSELy_2    ((uint32_t)0x00080000U) /* Bit 2 */
#define DAC_SETCTRL_SINCSELy_3    ((uint32_t)0x00100000U) /* Bit 3 */
#define DAC_SETCTRL_SINCSELy_4    ((uint32_t)0x00200000U) /* Bit 4 */

#define DAC_SETCTRL_MAySEL        ((uint32_t)0x03C00000U) /* MAMPy[3:0] (DACy Mask/Amplitude selector) */
#define DAC_SETCTRL_MAySEL_0      ((uint32_t)0x00400000U) /* Bit 0 */
#define DAC_SETCTRL_MAySEL_1      ((uint32_t)0x00800000U) /* Bit 1 */
#define DAC_SETCTRL_MAySEL_2      ((uint32_t)0x01000000U) /* Bit 2 */
#define DAC_SETCTRL_MAySEL_3      ((uint32_t)0x02000000U) /* Bit 3 */

#define DAC_SETCTRL_TySEL         ((uint32_t)0xF1000000U) /* TSELy[4:0] (DACy Trigger source selection) */
#define DAC_SETCTRL_TySEL_0       ((uint32_t)0x01000000U) /* Bit 0 */
#define DAC_SETCTRL_TySEL_1       ((uint32_t)0x10000000U) /* Bit 1 */
#define DAC_SETCTRL_TySEL_2       ((uint32_t)0x20000000U) /* Bit 2 */
#define DAC_SETCTRL_TySEL_3       ((uint32_t)0x40000000U) /* Bit 3 */
#define DAC_SETCTRL_TySEL_4       ((uint32_t)0x80000000U) /* Bit 4 */

/*****************  Bit definition for DAC_STS register  ******************/
#define DAC_STS_DMAUDRx           ((uint32_t)0x00000001U) /* DACx DMA underrun status flag  */
#define DAC_STS_CALFLAGx          ((uint32_t)0x00000002U) /* DACx calibrate offset status flag  */
#define DAC_STS_DORSTATx          ((uint32_t)0x00000004U) /* DACx data output register status flag  */
#define DAC_STS_TROVCFLAGx        ((uint32_t)0x00000008U) /* DACx trigger source overclock status flag  */
#define DAC_STS_VFLAGxCOMP        ((uint32_t)0x00000010U) /* Status flag that indicates DACx output is stable or not */

#define DAC_STS_DMAUDRy           ((uint32_t)0x00010000U) /* DACy DMA underrun status flag  */
#define DAC_STS_CALFLAGy          ((uint32_t)0x00020000U) /* DACy calibrate offset status flag  */
#define DAC_STS_DORSTATy          ((uint32_t)0x00040000U) /* DACy data output register status flag  */
#define DAC_STS_TROVCFLAGy        ((uint32_t)0x00080000U) /* DACy trigger source overclock status flag  */
#define DAC_STS_VFLAGyCOMP        ((uint32_t)0x00100000U) /* Status flag that indicates DACy output is stable or not */
/*****************  Bit definition for DAC_GCTRL register  ******************/
#define DAC_GCTRL_SYNSEL          ((uint32_t)0x00000001U) /* The trigger source of DACy is same as DACx  */

#define DAC_GCTRL_HFSEL           ((uint32_t)0x00000006U) /* HFSEL[1:0] (High frequency interface mode selection)  */
#define DAC_GCTRL_HFSEL_0         ((uint32_t)0x00000002U) /* Bit 0 */
#define DAC_GCTRL_HFSEL_1         ((uint32_t)0x00000004U) /* Bit 1 */

#define DAC1234_GCTRL_PCS         ((uint32_t)0x00FF0000U) /* PCS[7:0] (The clock prescale of DAC1/DAC2/DAC3/DAC4 selection)  */
#define DAC1234_GCTRL_PCS_0       ((uint32_t)0x00010000U) /* Bit 0 */
#define DAC1234_GCTRL_PCS_1       ((uint32_t)0x00020000U) /* Bit 1 */
#define DAC1234_GCTRL_PCS_2       ((uint32_t)0x00040000U) /* Bit 2 */
#define DAC1234_GCTRL_PCS_3       ((uint32_t)0x00080000U) /* Bit 3 */
#define DAC1234_GCTRL_PCS_4       ((uint32_t)0x00100000U) /* Bit 4 */
#define DAC1234_GCTRL_PCS_5       ((uint32_t)0x00200000U) /* Bit 5 */
#define DAC1234_GCTRL_PCS_6       ((uint32_t)0x00400000U) /* Bit 6 */
#define DAC1234_GCTRL_PCS_7       ((uint32_t)0x00800000U) /* Bit 7 */

#define DAC5678_GCTRL_PCS         ((uint32_t)0x001F0000U) /* PCS[4:0] (The clock prescale of DAC5/DAC6/DAC7/DAC8 selection)  */
#define DAC5678_GCTRL_PCS_0       ((uint32_t)0x00010000U) /* Bit 0 */
#define DAC5678_GCTRL_PCS_1       ((uint32_t)0x00020000U) /* Bit 1 */
#define DAC5678_GCTRL_PCS_2       ((uint32_t)0x00040000U) /* Bit 2 */
#define DAC5678_GCTRL_PCS_3       ((uint32_t)0x00080000U) /* Bit 3 */
#define DAC5678_GCTRL_PCS_4       ((uint32_t)0x00100000U) /* Bit 4 */


/*****************  Bit definition for DAC_STINC register  ******************/
#define DAC_STINC_STINCDATAx      ((uint32_t)0x00000FFFU) /* STINCDATAx[11:0] (The sawtooth step value of DACx)  */
#define DAC_STINC_STINCDATAy      ((uint32_t)0x0FFF0000U) /* STINCDATAy[11:0] (The sawtooth step value of DACy)  */

/*****************  Bit definition for DAC_STRST register  ******************/
#define DAC_STRST_STRSTDATAx      ((uint32_t)0x00000FFFU) /* STRSTDATAx[11:0] (The sawtooth reset value of DACx)  */
#define DAC_STRST_STRSTDATAy      ((uint32_t)0x0FFF0000U) /* STRSTDATAy[11:0] (The sawtooth reset value of DACy)  */

/*****************  Bit definition for DAC_CALC register  ******************/
#define DAC_CALC_OTRIMx           ((uint32_t)0x0000001FU) /* OTRIMx[4:0] (The calibration offset value of DACx)  */
#define DAC_CALC_OTRIMy           ((uint32_t)0x001F0000U) /* OTRIMy[4:0] (The calibration offset value of DACy)  */


/******************************************************************************/
/*                                                                            */
/*                     Comparators Peripheral Interface                       */
/*                                                                            */
/******************************************************************************/
/********************  Bit definition for COMP1_CTRL register  ********************/
#define COMP1_CTRL_EN        ((uint32_t)0x00000001U)     /* Comparator_1 enable */

#define COMP1_CTRL_INMSEL    ((uint32_t)0x0000000EU)     /* Inverting input select of Comparator_1 */
#define COMP1_CTRL_INMSEL_0  ((uint32_t)0x00000002U)     /* Bit 0 */
#define COMP1_CTRL_INMSEL_1  ((uint32_t)0x00000004U)     /* Bit 1 */
#define COMP1_CTRL_INMSEL_2  ((uint32_t)0x00000008U)     /* Bit 2 */

#define COMP1_CTRL_INPSEL    ((uint32_t)0x000001E0U)     /* Non inverting input select of Comparator_1 */
#define COMP1_CTRL_INPSEL_0  ((uint32_t)0x00000020U)     /* Bit 0 */
#define COMP1_CTRL_INPSEL_1  ((uint32_t)0x00000040U)     /* Bit 1 */
#define COMP1_CTRL_INPSEL_2  ((uint32_t)0x00000080U)     /* Bit 2 */
#define COMP1_CTRL_INPSEL_3  ((uint32_t)0x00000100U)     /* Bit 3 */
 
#define COMP1_CTRL_POL       ((uint32_t)0x00002000U)     /* Output polarity select of Comparator_1 */

#define COMP1_CTRL_HYST      ((uint32_t)0x0001C000U)     /* Hysteresis level select of Comparator_1 */
#define COMP1_CTRL_HYST_0    ((uint32_t)0x00004000U)     /* Bit 0 */
#define COMP1_CTRL_HYST_1    ((uint32_t)0x00008000U)     /* Bit 1 */
#define COMP1_CTRL_HYST_2    ((uint32_t)0x00010000U)     /* Bit 2 */

#define COMP1_CTRL_BLKING    ((uint32_t)0x000E0000U)     /* Blanking source select of Comparator_1 */
#define COMP1_CTRL_BLKING_0  ((uint32_t)0x00020000U)     /* Bit 0 */
#define COMP1_CTRL_BLKING_1  ((uint32_t)0x00040000U)     /* Bit 1 */
#define COMP1_CTRL_BLKING_2  ((uint32_t)0x00080000U)     /* Bit 2 */

#define COMP1_CTRL_OUT       ((uint32_t)0x00100000U)     /* Output state of Comparator_1 */

#define COMP1_CTRL_FIL_OUT   ((uint32_t)0x00200000U)     /* Output state of Comparator_1 Fiter */

/********************  Bit definition for COMP1_FILC register  ********************/
#define COMP1_FILC_FILEN     ((uint32_t)0x00000001U)     /* Comparator_1 filter enable */
#define COMP1_FILC_THRESH    ((uint32_t)0x0000003EU)     /* Comparator_1 filter threshold size */
#define COMP1_FILC_SAMPW     ((uint32_t)0x000007C0U)     /* Comparator_1 filter window size */
#define COMP1_FILC_DACEN     ((uint32_t)0x00000800U)     /* using DAC stable value as Comparator_1's input  */

/********************  Bit definition for COMP1_FILP register  ********************/
#define COMP1_FILP_CLKPSC    ((uint32_t)0x0000FFFFU)     /* Comparator_1 filter sample clock prescale */

/********************  Bit definition for COMP2_CTRL register  ********************/
#define COMP2_CTRL_EN        ((uint32_t)0x00000001U)     /* Comparator_2 enable */

#define COMP2_CTRL_INMSEL    ((uint32_t)0x0000001EU)     /* Inverting input select of Comparator_2 */
#define COMP2_CTRL_INMSEL_0  ((uint32_t)0x00000002U)     /* Bit 0 */
#define COMP2_CTRL_INMSEL_1  ((uint32_t)0x00000004U)     /* Bit 1 */
#define COMP2_CTRL_INMSEL_2  ((uint32_t)0x00000008U)     /* Bit 2 */
#define COMP2_CTRL_INMSEL_3  ((uint32_t)0x00000010U)     /* Bit 3 */

#define COMP2_CTRL_INPSEL    ((uint32_t)0x000001E0U)     /* Non inverting input select of Comparator_2 */
#define COMP2_CTRL_INPSEL_0  ((uint32_t)0x00000020U)     /* Bit 0 */
#define COMP2_CTRL_INPSEL_1  ((uint32_t)0x00000040U)     /* Bit 1 */
#define COMP2_CTRL_INPSEL_2  ((uint32_t)0x00000080U)     /* Bit 2 */
#define COMP2_CTRL_INPSEL_3  ((uint32_t)0x00000100U)     /* Bit 3 */
 
#define COMP2_CTRL_POL       ((uint32_t)0x00002000U)     /* Output polarity select of Comparator_2 */

#define COMP2_CTRL_HYST      ((uint32_t)0x0001C000U)     /* Hysteresis level select of Comparator_2 */
#define COMP2_CTRL_HYST_0    ((uint32_t)0x00004000U)     /* Bit 0 */
#define COMP2_CTRL_HYST_1    ((uint32_t)0x00008000U)     /* Bit 1 */
#define COMP2_CTRL_HYST_2    ((uint32_t)0x00010000U)     /* Bit 2 */

#define COMP2_CTRL_BLKING    ((uint32_t)0x000E0000U)     /* Blanking source select of Comparator_2 */
#define COMP2_CTRL_BLKING_0  ((uint32_t)0x00020000U)     /* Bit 0 */
#define COMP2_CTRL_BLKING_1  ((uint32_t)0x00040000U)     /* Bit 1 */
#define COMP2_CTRL_BLKING_2  ((uint32_t)0x00080000U)     /* Bit 2 */

#define COMP2_CTRL_OUT       ((uint32_t)0x00100000U)     /* Output state of Comparator_2 */

#define COMP2_CTRL_FIL_OUT   ((uint32_t)0x00200000U)     /* Output state of Comparator_2 Fiter */

/********************  Bit definition for COMP2_FILC register  ********************/
#define COMP2_FILC_FILEN     ((uint32_t)0x00000001U)     /* Comparator_2 filter enable */
#define COMP2_FILC_THRESH    ((uint32_t)0x0000003EU)     /* Comparator_2 filter threshold size */
#define COMP2_FILC_SAMPW     ((uint32_t)0x000007C0U)     /* Comparator_2 filter window size */
#define COMP2_FILC_DACEN     ((uint32_t)0x00000800U)     /* using DAC stable value as Comparator_2's input  */

/********************  Bit definition for COMP2_FILP register  ********************/
#define COMP2_FILP_CLKPSC    ((uint32_t)0x0000FFFFU)     /* Comparator_2 filter sample clock prescale */


/********************  Bit definition for COMP3_CTRL register  ********************/
#define COMP3_CTRL_EN        ((uint32_t)0x00000001U)     /* Comparator_3 enable */

#define COMP3_CTRL_INMSEL    ((uint32_t)0x0000001EU)     /* Inverting input select of Comparator_3 */
#define COMP3_CTRL_INMSEL_0  ((uint32_t)0x00000002U)     /* Bit 0 */
#define COMP3_CTRL_INMSEL_1  ((uint32_t)0x00000004U)     /* Bit 1 */
#define COMP3_CTRL_INMSEL_2  ((uint32_t)0x00000008U)     /* Bit 2 */
#define COMP3_CTRL_INMSEL_3  ((uint32_t)0x00000010U)     /* Bit 3 */

#define COMP3_CTRL_INPSEL    ((uint32_t)0x000001E0U)     /* Non inverting input select of Comparator_3 */
#define COMP3_CTRL_INPSEL_0  ((uint32_t)0x00000020U)     /* Bit 0 */
#define COMP3_CTRL_INPSEL_1  ((uint32_t)0x00000040U)     /* Bit 1 */
#define COMP3_CTRL_INPSEL_2  ((uint32_t)0x00000080U)     /* Bit 2 */
#define COMP3_CTRL_INPSEL_3  ((uint32_t)0x00000100U)     /* Bit 3 */
 
#define COMP3_CTRL_POL       ((uint32_t)0x00002000U)     /* Output polarity select of Comparator_3 */

#define COMP3_CTRL_HYST      ((uint32_t)0x0001C000U)     /* Hysteresis level select of Comparator_3 */
#define COMP3_CTRL_HYST_0    ((uint32_t)0x00004000U)     /* Bit 0 */
#define COMP3_CTRL_HYST_1    ((uint32_t)0x00008000U)     /* Bit 1 */
#define COMP3_CTRL_HYST_2    ((uint32_t)0x00010000U)     /* Bit 2 */

#define COMP3_CTRL_BLKING    ((uint32_t)0x000E0000U)     /* Blanking source select of Comparator_3 */
#define COMP3_CTRL_BLKING_0  ((uint32_t)0x00020000U)     /* Bit 0 */
#define COMP3_CTRL_BLKING_1  ((uint32_t)0x00040000U)     /* Bit 1 */
#define COMP3_CTRL_BLKING_2  ((uint32_t)0x00080000U)     /* Bit 2 */

#define COMP3_CTRL_OUT       ((uint32_t)0x00100000U)     /* Output state of Comparator_3 */

#define COMP3_CTRL_FIL_OUT   ((uint32_t)0x00200000U)     /* Output state of Comparator_3 Fiter */

/********************  Bit definition for COMP3_FILC register  ********************/
#define COMP3_FILC_FILEN     ((uint32_t)0x00000001U)     /* Comparator_3 filter enable */
#define COMP3_FILC_THRESH    ((uint32_t)0x0000003EU)     /* Comparator_3 filter threshold size */
#define COMP3_FILC_SAMPW     ((uint32_t)0x000007C0U)     /* Comparator_3 filter window size */
#define COMP3_FILC_DACEN     ((uint32_t)0x00000800U)     /* using DAC stable value as Comparator_3's input  */

/********************  Bit definition for COMP3_FILP register  ********************/
#define COMP3_FILP_CLKPSC    ((uint32_t)0x0000FFFFU)     /* Comparator_3 filter sample clock prescale */

/********************  Bit definition for COMP4_CTRL register  ********************/
#define COMP4_CTRL_EN        ((uint32_t)0x00000001U)     /* Comparator_4 enable */

#define COMP4_CTRL_INMSEL    ((uint32_t)0x0000001EU)     /* Inverting input select of Comparator_4 */
#define COMP4_CTRL_INMSEL_0  ((uint32_t)0x00000002U)     /* Bit 0 */
#define COMP4_CTRL_INMSEL_1  ((uint32_t)0x00000004U)     /* Bit 1 */
#define COMP4_CTRL_INMSEL_2  ((uint32_t)0x00000008U)     /* Bit 2 */
#define COMP4_CTRL_INMSEL_3  ((uint32_t)0x00000010U)     /* Bit 3 */

#define COMP4_CTRL_INPSEL    ((uint32_t)0x000001E0U)     /* Non inverting input select of Comparator_4 */
#define COMP4_CTRL_INPSEL_0  ((uint32_t)0x00000020U)     /* Bit 0 */
#define COMP4_CTRL_INPSEL_1  ((uint32_t)0x00000040U)     /* Bit 1 */
#define COMP4_CTRL_INPSEL_2  ((uint32_t)0x00000080U)     /* Bit 2 */
#define COMP4_CTRL_INPSEL_3  ((uint32_t)0x00000100U)     /* Bit 3 */
 
#define COMP4_CTRL_POL       ((uint32_t)0x00002000U)     /* Output polarity select of Comparator_4 */

#define COMP4_CTRL_HYST      ((uint32_t)0x0001C000U)     /* Hysteresis level select of Comparator_4 */
#define COMP4_CTRL_HYST_0    ((uint32_t)0x00004000U)     /* Bit 0 */
#define COMP4_CTRL_HYST_1    ((uint32_t)0x00008000U)     /* Bit 1 */
#define COMP4_CTRL_HYST_2    ((uint32_t)0x00010000U)     /* Bit 2 */

#define COMP4_CTRL_BLKING    ((uint32_t)0x000E0000U)     /* Blanking source select of Comparator_4 */
#define COMP4_CTRL_BLKING_0  ((uint32_t)0x00020000U)     /* Bit 0 */
#define COMP4_CTRL_BLKING_1  ((uint32_t)0x00040000U)     /* Bit 1 */
#define COMP4_CTRL_BLKING_2  ((uint32_t)0x00080000U)     /* Bit 2 */

#define COMP4_CTRL_OUT       ((uint32_t)0x00100000U)     /* Output state of Comparator_4 */

#define COMP4_CTRL_FIL_OUT   ((uint32_t)0x00200000U)     /* Output state of Comparator_4 Fiter */

/********************  Bit definition for COMP4_FILC register  ********************/
#define COMP4_FILC_FILEN     ((uint32_t)0x00000001U)     /* Comparator_4 filter enable */
#define COMP4_FILC_THRESH    ((uint32_t)0x0000003EU)     /* Comparator_4 filter threshold size */
#define COMP4_FILC_SAMPW     ((uint32_t)0x000007C0U)     /* Comparator_4 filter window size */
#define COMP4_FILC_DACEN     ((uint32_t)0x00000800U)     /* using DAC stable value as Comparator_4's input  */

/********************  Bit definition for COMP4_FILP register  ********************/
#define COMP4_FILP_CLKPSC    ((uint32_t)0x0000FFFFU)     /* Comparator_4 filter sample clock prescale */

/********************  Bit definition for COMP5_CTRL register  ********************/
#define COMP5_CTRL_EN        ((uint32_t)0x00000001U)     /* Comparator_5 enable */

#define COMP5_CTRL_INMSEL    ((uint32_t)0x0000000EU)     /* Inverting input select of Comparator_5 */
#define COMP5_CTRL_INMSEL_0  ((uint32_t)0x00000002U)     /* Bit 0 */
#define COMP5_CTRL_INMSEL_1  ((uint32_t)0x00000004U)     /* Bit 1 */
#define COMP5_CTRL_INMSEL_2  ((uint32_t)0x00000008U)     /* Bit 2 */

#define COMP5_CTRL_INPSEL    ((uint32_t)0x000001E0U)     /* Non inverting input select of Comparator_5 */
#define COMP5_CTRL_INPSEL_0  ((uint32_t)0x00000020U)     /* Bit 0 */
#define COMP5_CTRL_INPSEL_1  ((uint32_t)0x00000040U)     /* Bit 1 */
#define COMP5_CTRL_INPSEL_2  ((uint32_t)0x00000080U)     /* Bit 2 */
#define COMP5_CTRL_INPSEL_3  ((uint32_t)0x00000100U)     /* Bit 3 */
 
#define COMP5_CTRL_POL       ((uint32_t)0x00002000U)     /* Output polarity select of Comparator_5 */

#define COMP5_CTRL_HYST      ((uint32_t)0x0001C000U)     /* Hysteresis level select of Comparator_5 */
#define COMP5_CTRL_HYST_0    ((uint32_t)0x00004000U)     /* Bit 0 */
#define COMP5_CTRL_HYST_1    ((uint32_t)0x00008000U)     /* Bit 1 */
#define COMP5_CTRL_HYST_2    ((uint32_t)0x00010000U)     /* Bit 2 */

#define COMP5_CTRL_BLKING    ((uint32_t)0x000E0000U)     /* Blanking source select of Comparator_5 */
#define COMP5_CTRL_BLKING_0  ((uint32_t)0x00020000U)     /* Bit 0 */
#define COMP5_CTRL_BLKING_1  ((uint32_t)0x00040000U)     /* Bit 1 */
#define COMP5_CTRL_BLKING_2  ((uint32_t)0x00080000U)     /* Bit 2 */

#define COMP5_CTRL_OUT       ((uint32_t)0x00100000U)     /* Output state of Comparator_5 */

#define COMP5_CTRL_FIL_OUT   ((uint32_t)0x00200000U)     /* Output state of Comparator_5 Fiter */

/********************  Bit definition for COMP5_FILC register  ********************/
#define COMP5_FILC_FILEN     ((uint32_t)0x00000001U)     /* Comparator_5 filter enable */
#define COMP5_FILC_THRESH    ((uint32_t)0x0000003EU)     /* Comparator_5 filter threshold size */
#define COMP5_FILC_SAMPW     ((uint32_t)0x000007C0U)     /* Comparator_5 filter window size */
#define COMP5_FILC_DACEN     ((uint32_t)0x00000800U)     /* using DAC stable value as Comparator_5's input  */

/********************  Bit definition for COMP5_FILP register  ********************/
#define COMP5_FILP_CLKPSC    ((uint32_t)0x0000FFFFU)     /* Comparator_5 filter sample clock prescale */

/********************  Bit definition for COMP6_CTRL register  ********************/
#define COMP6_CTRL_EN        ((uint32_t)0x00000001U)     /* Comparator_6 enable */

#define COMP6_CTRL_INMSEL    ((uint32_t)0x0000001EU)     /* Inverting input select of Comparator_6 */
#define COMP6_CTRL_INMSEL_0  ((uint32_t)0x00000002U)     /* Bit 0 */
#define COMP6_CTRL_INMSEL_1  ((uint32_t)0x00000004U)     /* Bit 1 */
#define COMP6_CTRL_INMSEL_2  ((uint32_t)0x00000008U)     /* Bit 2 */
#define COMP6_CTRL_INMSEL_3  ((uint32_t)0x00000010U)     /* Bit 3 */

#define COMP6_CTRL_INPSEL    ((uint32_t)0x000001E0U)     /* Non inverting input select of Comparator_6 */
#define COMP6_CTRL_INPSEL_0  ((uint32_t)0x00000020U)     /* Bit 0 */
#define COMP6_CTRL_INPSEL_1  ((uint32_t)0x00000040U)     /* Bit 1 */
#define COMP6_CTRL_INPSEL_2  ((uint32_t)0x00000080U)     /* Bit 2 */
#define COMP6_CTRL_INPSEL_3  ((uint32_t)0x00000100U)     /* Bit 3 */
 
#define COMP6_CTRL_POL       ((uint32_t)0x00002000U)     /* Output polarity select of Comparator_6 */

#define COMP6_CTRL_HYST      ((uint32_t)0x0001C000U)     /* Hysteresis level select of Comparator_6 */
#define COMP6_CTRL_HYST_0    ((uint32_t)0x00004000U)     /* Bit 0 */
#define COMP6_CTRL_HYST_1    ((uint32_t)0x00008000U)     /* Bit 1 */
#define COMP6_CTRL_HYST_2    ((uint32_t)0x00010000U)     /* Bit 2 */

#define COMP6_CTRL_BLKING    ((uint32_t)0x000E0000U)     /* Blanking source select of Comparator_6 */
#define COMP6_CTRL_BLKING_0  ((uint32_t)0x00020000U)     /* Bit 0 */
#define COMP6_CTRL_BLKING_1  ((uint32_t)0x00040000U)     /* Bit 1 */
#define COMP6_CTRL_BLKING_2  ((uint32_t)0x00080000U)     /* Bit 2 */

#define COMP6_CTRL_OUT       ((uint32_t)0x00100000U)     /* Output state of Comparator_6 */

#define COMP6_CTRL_FIL_OUT   ((uint32_t)0x00200000U)     /* Output state of Comparator_6 Fiter */

/********************  Bit definition for COMP6_FILC register  ********************/
#define COMP6_FILC_FILEN     ((uint32_t)0x00000001U)     /* Comparator_6 filter enable */
#define COMP6_FILC_THRESH    ((uint32_t)0x0000003EU)     /* Comparator_6 filter threshold size */
#define COMP6_FILC_SAMPW     ((uint32_t)0x000007C0U)     /* Comparator_6 filter window size */
#define COMP6_FILC_DACEN     ((uint32_t)0x00000800U)     /* using DAC stable value as Comparator_6's input  */

/********************  Bit definition for COMP6_FILP register  ********************/
#define COMP6_FILP_CLKPSC    ((uint32_t)0x0000FFFFU)     /* Comparator_6 filter sample clock prescale */


/********************  Bit definition for COMP7_CTRL register  ********************/
#define COMP7_CTRL_EN        ((uint32_t)0x00000001U)     /* Comparator_7 enable */

#define COMP7_CTRL_INMSEL    ((uint32_t)0x0000000EU)     /* Inverting input select of Comparator_7 */
#define COMP7_CTRL_INMSEL_0  ((uint32_t)0x00000002U)     /* Bit 0 */
#define COMP7_CTRL_INMSEL_1  ((uint32_t)0x00000004U)     /* Bit 1 */
#define COMP7_CTRL_INMSEL_2  ((uint32_t)0x00000008U)     /* Bit 2 */

#define COMP7_CTRL_INPSEL    ((uint32_t)0x000001E0U)     /* Non inverting input select of Comparator_7 */
#define COMP7_CTRL_INPSEL_0  ((uint32_t)0x00000020U)     /* Bit 0 */
#define COMP7_CTRL_INPSEL_1  ((uint32_t)0x00000040U)     /* Bit 1 */
#define COMP7_CTRL_INPSEL_2  ((uint32_t)0x00000080U)     /* Bit 2 */
#define COMP7_CTRL_INPSEL_3  ((uint32_t)0x00000100U)     /* Bit 3 */
 
#define COMP7_CTRL_POL       ((uint32_t)0x00002000U)     /* Output polarity select of Comparator_7 */

#define COMP7_CTRL_HYST      ((uint32_t)0x0001C000U)     /* Hysteresis level select of Comparator_7 */
#define COMP7_CTRL_HYST_0    ((uint32_t)0x00004000U)     /* Bit 0 */
#define COMP7_CTRL_HYST_1    ((uint32_t)0x00008000U)     /* Bit 1 */
#define COMP7_CTRL_HYST_2    ((uint32_t)0x00010000U)     /* Bit 2 */

#define COMP7_CTRL_BLKING    ((uint32_t)0x000E0000U)     /* Blanking source select of Comparator_7 */
#define COMP7_CTRL_BLKING_0  ((uint32_t)0x00020000U)     /* Bit 0 */
#define COMP7_CTRL_BLKING_1  ((uint32_t)0x00040000U)     /* Bit 1 */
#define COMP7_CTRL_BLKING_2  ((uint32_t)0x00080000U)     /* Bit 2 */

#define COMP7_CTRL_OUT       ((uint32_t)0x00100000U)     /* Output state of Comparator_7 */

#define COMP7_CTRL_FIL_OUT   ((uint32_t)0x00200000U)     /* Output state of Comparator_7 Fiter */

/********************  Bit definition for COMP7_FILC register  ********************/
#define COMP7_FILC_FILEN     ((uint32_t)0x00000001U)     /* Comparator_7 filter enable */
#define COMP7_FILC_THRESH    ((uint32_t)0x0000003EU)     /* Comparator_7 filter threshold size */
#define COMP7_FILC_SAMPW     ((uint32_t)0x000007C0U)     /* Comparator_7 filter window size */
#define COMP7_FILC_DACEN     ((uint32_t)0x00000800U)     /* using DAC stable value as Comparator_7's input  */

/********************  Bit definition for COMP7_FILP register  ********************/
#define COMP7_FILP_CLKPSC    ((uint32_t)0x0000FFFFU)     /* Comparator_7 filter sample clock prescale */

/********************  Bit definition for COMP_WINMODE register  ********************/
#define COMP_WINMODE_COMP56MD ((uint32_t)0x00000004U)     /* Comparator_5&6 XOR output */
#define COMP_WINMODE_COMP34MD ((uint32_t)0x00000002U)     /* Comparator_3&4 XOR output */
#define COMP_WINMODE_COMP12MD ((uint32_t)0x00000001U)     /* Comparator_1&2 XOR output */

/********************  Bit definition for COMP_LOCK register  ********************/
#define COMP_LOCK            ((uint32_t)0x0000007FU)     /* All comparator lock enable */
#define COMP_LOCK_CMP1LK     ((uint32_t)0x00000001U)     /* Comparator_1 lock enable */
#define COMP_LOCK_CMP2LK     ((uint32_t)0x00000002U)     /* Comparator_2 lock enable */
#define COMP_LOCK_CMP3LK     ((uint32_t)0x00000004U)     /* Comparator_3 lock enable */
#define COMP_LOCK_CMP4LK     ((uint32_t)0x00000008U)     /* Comparator_4 lock enable */
#define COMP_LOCK_CMP5LK     ((uint32_t)0x00000010U)     /* Comparator_5 lock enable */
#define COMP_LOCK_CMP6LK     ((uint32_t)0x00000020U)     /* Comparator_6 lock enable */
#define COMP_LOCK_CMP7LK     ((uint32_t)0x00000040U)     /* Comparator_7 lock enable */

/********************  Bit definition for COMP_INTEN register  ********************/
#define COMP_INTEN           ((uint32_t)0x0000007FU)     /* Interrupt enable for all COMP */
#define COMP_INTEN_CMP1IEN   ((uint32_t)0x00000001U)     /* Interrupt enable for COMP1 */
#define COMP_INTEN_CMP2IEN   ((uint32_t)0x00000002U)     /* Interrupt enable for COMP2 */
#define COMP_INTEN_CMP3IEN   ((uint32_t)0x00000004U)     /* Interrupt enable for COMP3 */
#define COMP_INTEN_CMP4IEN   ((uint32_t)0x00000008U)     /* Interrupt enable for COMP4 */
#define COMP_INTEN_CMP5IEN   ((uint32_t)0x00000010U)     /* Interrupt enable for COMP5 */
#define COMP_INTEN_CMP6IEN   ((uint32_t)0x00000020U)     /* Interrupt enable for COMP6 */
#define COMP_INTEN_CMP7IEN   ((uint32_t)0x00000040U)     /* Interrupt enable for COMP7 */

/********************  Bit definition for COMP_INTSTS register  ********************/
#define COMP_INTSTS          ((uint32_t)0x0000007FU)     /* Interrupt status of all Comparator */
#define COMP_INTSTS_COMP1IS  ((uint32_t)0x00000001U)     /* Interrupt status of Comparator_1 */
#define COMP_INTSTS_COMP2IS  ((uint32_t)0x00000002U)     /* Interrupt status of Comparator_2 */
#define COMP_INTSTS_COMP3IS  ((uint32_t)0x00000004U)     /* Interrupt status of Comparator_3 */
#define COMP_INTSTS_COMP4IS  ((uint32_t)0x00000008U)     /* Interrupt status of Comparator_4 */
#define COMP_INTSTS_COMP5IS  ((uint32_t)0x00000010U)     /* Interrupt status of Comparator_5 */
#define COMP_INTSTS_COMP6IS  ((uint32_t)0x00000020U)     /* Interrupt status of Comparator_6 */
#define COMP_INTSTS_COMP7IS  ((uint32_t)0x00000040U)     /* Interrupt status of Comparator_7 */

/********************  Bit definition for COMP_VREFSCL register  ********************/
#define COMP_VREFSCL_VV1EN   ((uint32_t)0x00000001U)     /* Low-Power internal dac1 enable */
#define COMP_VREFSCL_VV1TRM  ((uint32_t)0x0000007EU)     /* Low-Power internal dac1 output voltage size */
#define COMP_VREFSCL_VV2EN   ((uint32_t)0x00000080U)     /* Low-Power internal dac2 enable */
#define COMP_VREFSCL_VV2TRM  ((uint32_t)0x00003F00U)     /* Low-Power internal dac2 output voltage size */
#define COMP_VREFSCL_VV3EN   ((uint32_t)0x00004000U)     /* Low-Power internal dac3 enable */
#define COMP_VREFSCL_VV3TRM  ((uint32_t)0x001F8000U)     /* Low-Power internal dac3 output voltage size */

/********************  Bit definition for COMP_TIM_OSEN register  ********************/
#define COMP_TIM_EN          ((uint32_t)0x000000EFU)     /* Output to timer for all Comparator */
#define CMP1_TIM_EN          ((uint32_t)0x00000001U)     /* Comparator_1 output to timer enable */
#define CMP2_TIM_EN          ((uint32_t)0x00000002U)     /* Comparator_2 output to timer enable */
#define CMP3_TIM_EN          ((uint32_t)0x00000004U)     /* Comparator_3 output to timer enable */
#define CMP4_TIM_EN          ((uint32_t)0x00000008U)     /* Comparator_4 output to timer enable */
#define CMP5_TIM_EN          ((uint32_t)0x00000010U)     /* Comparator_5 output to timer enable */
#define CMP6_TIM_EN          ((uint32_t)0x00000020U)     /* Comparator_6 output to timer enable */
#define CMP7_TIM_EN          ((uint32_t)0x00000040U)     /* Comparator_7 output to timer enable */

/******************************************************************************/
/*                                                                            */
/*             Programmable Gain Amplifier(PGA) Peripheral Interface          */
/*                                                                            */
/******************************************************************************/

/********************  Bit definition for PGA1_CTRL register  **********************/
#define PGA1_CH1EN           ((uint32_t)0x00000001U)     /* PGA1 Channel1 enable */
#define PGA1_CH2EN           ((uint32_t)0x00000002U)     /* PGA1 Channel2 enable */
#define PGA1_DIFFEN          ((uint32_t)0x00000004U)     /* PGA1 differential mode enable */
#define PGA1_TCMEN           ((uint32_t)0x00000008U)     /* PGA1 timer controlled Mux mode enable */

#define PGA1_CH1GAIN         ((uint32_t)0x00000070U)     /* PGA1 Channel1 gain value */
#define PGA1_CH1GAIN_0       ((uint32_t)0x00000010U)     /* Bit 0 */
#define PGA1_CH1GAIN_1       ((uint32_t)0x00000020U)     /* Bit 1 */
#define PGA1_CH1GAIN_2       ((uint32_t)0x00000040U)     /* Bit 2 */

#define PGA1_CH2GAIN         ((uint32_t)0x00000700U)     /* PGA1 Channel2 gain value */
#define PGA1_CH2GAIN_0       ((uint32_t)0x00000100U)     /* Bit 0 */
#define PGA1_CH2GAIN_1       ((uint32_t)0x00000200U)     /* Bit 1 */
#define PGA1_CH2GAIN_2       ((uint32_t)0x00000400U)     /* Bit 2 */

#define PGA1_VPSEL           ((uint32_t)0x0000F000U)     /* PGA1 Non-inverted input selection */
#define PGA1_VPSEL_0         ((uint32_t)0x00001000U)     /* Bit 0 */
#define PGA1_VPSEL_1         ((uint32_t)0x00002000U)     /* Bit 1 */
#define PGA1_VPSEL_2         ((uint32_t)0x00004000U)     /* Bit 2 */
#define PGA1_VPSEL_3         ((uint32_t)0x00008000U)     /* Bit 3 */

#define PGA1_VMSEL           ((uint32_t)0x000F0000U)     /* PGA1 Inverted input selection */
#define PGA1_VMSEL_0         ((uint32_t)0x00010000U)     /* Bit 0 */
#define PGA1_VMSEL_1         ((uint32_t)0x00020000U)     /* Bit 1 */
#define PGA1_VMSEL_2         ((uint32_t)0x00040000U)     /* Bit 2 */
#define PGA1_VMSEL_3         ((uint32_t)0x00080000U)     /* Bit 3 */

#define PGA1_VPSSEL          ((uint32_t)0x00F00000U)     /* PGA1 Non-inverted secondary input selection */
#define PGA1_VPSSEL_0        ((uint32_t)0x00100000U)     /* Bit 0 */
#define PGA1_VPSSEL_1        ((uint32_t)0x00200000U)     /* Bit 1 */
#define PGA1_VPSSEL_2        ((uint32_t)0x00400000U)     /* Bit 2 */
#define PGA1_VPSSEL_3        ((uint32_t)0x00800000U)     /* Bit 3 */

#define PGA1_VMSSEL          ((uint32_t)0x0F000000U)     /* PGA1 Inverted secondary input selection */
#define PGA1_VMSSEL_0        ((uint32_t)0x01000000U)     /* Bit 0 */
#define PGA1_VMSSEL_1        ((uint32_t)0x02000000U)     /* Bit 1 */
#define PGA1_VMSSEL_2        ((uint32_t)0x04000000U)     /* Bit 2 */
#define PGA1_VMSSEL_3        ((uint32_t)0x08000000U)     /* Bit 3 */

#define PGA1_TRIMEN          ((uint32_t)0x10000000U)     /* PGA1 MOS triming enable */

/********************  Bit definition for PGA1_TRIM register  **********************/
#define PGA1_TRIMCH1P        ((uint32_t)0x0000003FU)     /* PGA1 Channel 1 PMOS triming value */
#define PGA1_TRIMCH1N        ((uint32_t)0x00000FC0U)     /* PGA1 Channel 1 NMOS triming value */
#define PGA1_TRIMCH2P        ((uint32_t)0x0003F000U)     /* PGA1 Channel 2 PMOS triming value */
#define PGA1_TRIMCH2N        ((uint32_t)0x00FC0000U)     /* PGA1 Channel 2 NMOS triming value */

#define PGA1_TRIMCH1FLAG     ((uint32_t)0x01000000U)     /* PGA1 Channel 1 triming finish flag */
#define PGA1_TRIMCH2FLAG     ((uint32_t)0x02000000U)     /* PGA1 Channel 2 triming finish flag */

/********************  Bit definition for PGA2_CTRL register  **********************/
#define PGA2_CH1EN           ((uint32_t)0x00000001U)     /* PGA2 Channel1 enable */
#define PGA2_CH2EN           ((uint32_t)0x00000002U)     /* PGA2 Channel2 enable */
#define PGA2_DIFFEN          ((uint32_t)0x00000004U)     /* PGA2 differential mode enable */
#define PGA2_TCMEN           ((uint32_t)0x00000008U)     /* PGA2 timer controlled Mux mode enable */

#define PGA2_CH1GAIN         ((uint32_t)0x00000070U)     /* PGA2 Channel1 gain value */
#define PGA2_CH1GAIN_0       ((uint32_t)0x00000010U)     /* Bit 0 */
#define PGA2_CH1GAIN_1       ((uint32_t)0x00000020U)     /* Bit 1 */
#define PGA2_CH1GAIN_2       ((uint32_t)0x00000040U)     /* Bit 2 */

#define PGA2_CH2GAIN         ((uint32_t)0x00000700U)     /* PGA2 Channel2 gain value */
#define PGA2_CH2GAIN_0       ((uint32_t)0x00000100U)     /* Bit 0 */
#define PGA2_CH2GAIN_1       ((uint32_t)0x00000200U)     /* Bit 1 */
#define PGA2_CH2GAIN_2       ((uint32_t)0x00000400U)     /* Bit 2 */

#define PGA2_VPSEL           ((uint32_t)0x0000F000U)     /* PGA2 Non-inverted input selection */
#define PGA2_VPSEL_0         ((uint32_t)0x00001000U)     /* Bit 0 */
#define PGA2_VPSEL_1         ((uint32_t)0x00002000U)     /* Bit 1 */
#define PGA2_VPSEL_2         ((uint32_t)0x00004000U)     /* Bit 2 */
#define PGA2_VPSEL_3         ((uint32_t)0x00008000U)     /* Bit 3 */

#define PGA2_VMSEL           ((uint32_t)0x000F0000U)     /* PGA2 Inverted input selection */
#define PGA2_VMSEL_0         ((uint32_t)0x00010000U)     /* Bit 0 */
#define PGA2_VMSEL_1         ((uint32_t)0x00020000U)     /* Bit 1 */
#define PGA2_VMSEL_2         ((uint32_t)0x00040000U)     /* Bit 2 */
#define PGA2_VMSEL_3         ((uint32_t)0x00080000U)     /* Bit 3 */

#define PGA2_VPSSEL          ((uint32_t)0x00F00000U)     /* PGA2 Non-inverted secondary input selection */
#define PGA2_VPSSEL_0        ((uint32_t)0x00100000U)     /* Bit 0 */
#define PGA2_VPSSEL_1        ((uint32_t)0x00200000U)     /* Bit 1 */
#define PGA2_VPSSEL_2        ((uint32_t)0x00400000U)     /* Bit 2 */
#define PGA2_VPSSEL_3        ((uint32_t)0x00800000U)     /* Bit 3 */

#define PGA2_VMSSEL          ((uint32_t)0x0F000000U)     /* PGA2 Inverted secondary input selection */
#define PGA2_VMSSEL_0        ((uint32_t)0x01000000U)     /* Bit 0 */
#define PGA2_VMSSEL_1        ((uint32_t)0x02000000U)     /* Bit 1 */
#define PGA2_VMSSEL_2        ((uint32_t)0x04000000U)     /* Bit 2 */
#define PGA2_VMSSEL_3        ((uint32_t)0x08000000U)     /* Bit 3 */

#define PGA2_TRIMEN          ((uint32_t)0x10000000U)     /* PGA2 MOS triming enable */

/********************  Bit definition for PGA2_TRIM register  **********************/
#define PGA2_TRIMCH1P        ((uint32_t)0x0000003FU)     /* PGA2 Channel 1 PMOS triming value */
#define PGA2_TRIMCH1N        ((uint32_t)0x00000FC0U)     /* PGA2 Channel 1 NMOS triming value */
#define PGA2_TRIMCH2P        ((uint32_t)0x0003F000U)     /* PGA2 Channel 2 PMOS triming value */
#define PGA2_TRIMCH2N        ((uint32_t)0x00FC0000U)     /* PGA2 Channel 2 NMOS triming value */

#define PGA2_TRIMCH1FLAG     ((uint32_t)0x01000000U)     /* PGA2 Channel 1 triming finish flag */
#define PGA2_TRIMCH2FLAG     ((uint32_t)0x02000000U)     /* PGA2 Channel 2 triming finish flag */

/********************  Bit definition for PGA3_CTRL register  **********************/
#define PGA3_CH1EN           ((uint32_t)0x00000001U)     /* PGA3 Channel1 enable */
#define PGA3_CH2EN           ((uint32_t)0x00000002U)     /* PGA3 Channel2 enable */
#define PGA3_DIFFEN          ((uint32_t)0x00000004U)     /* PGA3 differential mode enable */
#define PGA3_TCMEN           ((uint32_t)0x00000008U)     /* PGA3 timer controlled Mux mode enable */

#define PGA3_CH1GAIN         ((uint32_t)0x00000070U)     /* PGA3 Channel1 gain value */
#define PGA3_CH1GAIN_0       ((uint32_t)0x00000010U)     /* Bit 0 */
#define PGA3_CH1GAIN_1       ((uint32_t)0x00000020U)     /* Bit 1 */
#define PGA3_CH1GAIN_2       ((uint32_t)0x00000040U)     /* Bit 2 */

#define PGA3_CH2GAIN         ((uint32_t)0x00000700U)     /* PGA3 Channel2 gain value */
#define PGA3_CH2GAIN_0       ((uint32_t)0x00000100U)     /* Bit 0 */
#define PGA3_CH2GAIN_1       ((uint32_t)0x00000200U)     /* Bit 1 */
#define PGA3_CH2GAIN_2       ((uint32_t)0x00000400U)     /* Bit 2 */

#define PGA3_VPSEL           ((uint32_t)0x0000F000U)     /* PGA3 Non-inverted input selection */
#define PGA3_VPSEL_0         ((uint32_t)0x00001000U)     /* Bit 0 */
#define PGA3_VPSEL_1         ((uint32_t)0x00002000U)     /* Bit 1 */
#define PGA3_VPSEL_2         ((uint32_t)0x00004000U)     /* Bit 2 */
#define PGA3_VPSEL_3         ((uint32_t)0x00008000U)     /* Bit 3 */

#define PGA3_VMSEL           ((uint32_t)0x000F0000U)     /* PGA3 Inverted input selection */
#define PGA3_VMSEL_0         ((uint32_t)0x00010000U)     /* Bit 0 */
#define PGA3_VMSEL_1         ((uint32_t)0x00020000U)     /* Bit 1 */
#define PGA3_VMSEL_2         ((uint32_t)0x00040000U)     /* Bit 2 */
#define PGA3_VMSEL_3         ((uint32_t)0x00080000U)     /* Bit 3 */

#define PGA3_VPSSEL          ((uint32_t)0x00F00000U)     /* PGA3 Non-inverted secondary input selection */
#define PGA3_VPSSEL_0        ((uint32_t)0x00100000U)     /* Bit 0 */
#define PGA3_VPSSEL_1        ((uint32_t)0x00200000U)     /* Bit 1 */
#define PGA3_VPSSEL_2        ((uint32_t)0x00400000U)     /* Bit 2 */
#define PGA3_VPSSEL_3        ((uint32_t)0x00800000U)     /* Bit 3 */

#define PGA3_VMSSEL          ((uint32_t)0x0F000000U)     /* PGA3 Inverted secondary input selection */
#define PGA3_VMSSEL_0        ((uint32_t)0x01000000U)     /* Bit 0 */
#define PGA3_VMSSEL_1        ((uint32_t)0x02000000U)     /* Bit 1 */
#define PGA3_VMSSEL_2        ((uint32_t)0x04000000U)     /* Bit 2 */
#define PGA3_VMSSEL_3        ((uint32_t)0x08000000U)     /* Bit 3 */

#define PGA3_TRIMEN          ((uint32_t)0x10000000U)     /* PGA3 MOS triming enable */

/********************  Bit definition for PGA3_TRIM register  **********************/
#define PGA3_TRIMCH1P        ((uint32_t)0x0000003FU)     /* PGA3 Channel 1 PMOS triming value */
#define PGA3_TRIMCH1N        ((uint32_t)0x00000FC0U)     /* PGA3 Channel 1 NMOS triming value */
#define PGA3_TRIMCH2P        ((uint32_t)0x0003F000U)     /* PGA3 Channel 2 PMOS triming value */
#define PGA3_TRIMCH2N        ((uint32_t)0x00FC0000U)     /* PGA3 Channel 2 NMOS triming value */

#define PGA3_TRIMCH1FLAG     ((uint32_t)0x01000000U)     /* PGA3 Channel 1 triming finish flag */
#define PGA3_TRIMCH2FLAG     ((uint32_t)0x02000000U)     /* PGA3 Channel 2 triming finish flag */

/********************  Bit definition for PGA4_CTRL register  **********************/
#define PGA4_CH1EN           ((uint32_t)0x00000001U)     /* PGA4 Channel1 enable */
#define PGA4_CH2EN           ((uint32_t)0x00000002U)     /* PGA4 Channel2 enable */
#define PGA4_DIFFEN          ((uint32_t)0x00000004U)     /* PGA4 differential mode enable */
#define PGA4_TCMEN           ((uint32_t)0x00000008U)     /* PGA4 timer controlled Mux mode enable */

#define PGA4_CH1GAIN         ((uint32_t)0x00000070U)     /* PGA4 Channel1 gain value */
#define PGA4_CH1GAIN_0       ((uint32_t)0x00000010U)     /* Bit 0 */
#define PGA4_CH1GAIN_1       ((uint32_t)0x00000020U)     /* Bit 1 */
#define PGA4_CH1GAIN_2       ((uint32_t)0x00000040U)     /* Bit 2 */

#define PGA4_CH2GAIN         ((uint32_t)0x00000700U)     /* PGA4 Channel2 gain value */
#define PGA4_CH2GAIN_0       ((uint32_t)0x00000100U)     /* Bit 0 */
#define PGA4_CH2GAIN_1       ((uint32_t)0x00000200U)     /* Bit 1 */
#define PGA4_CH2GAIN_2       ((uint32_t)0x00000400U)     /* Bit 2 */

#define PGA4_VPSEL           ((uint32_t)0x0000F000U)     /* PGA4 Non-inverted input selection */
#define PGA4_VPSEL_0         ((uint32_t)0x00001000U)     /* Bit 0 */
#define PGA4_VPSEL_1         ((uint32_t)0x00002000U)     /* Bit 1 */
#define PGA4_VPSEL_2         ((uint32_t)0x00004000U)     /* Bit 2 */
#define PGA4_VPSEL_3         ((uint32_t)0x00008000U)     /* Bit 3 */

#define PGA4_VMSEL           ((uint32_t)0x000F0000U)     /* PGA4 Inverted input selection */
#define PGA4_VMSEL_0         ((uint32_t)0x00010000U)     /* Bit 0 */
#define PGA4_VMSEL_1         ((uint32_t)0x00020000U)     /* Bit 1 */
#define PGA4_VMSEL_2         ((uint32_t)0x00040000U)     /* Bit 2 */
#define PGA4_VMSEL_3         ((uint32_t)0x00080000U)     /* Bit 3 */

#define PGA4_VPSSEL          ((uint32_t)0x00F00000U)     /* PGA4 Non-inverted secondary input selection */
#define PGA4_VPSSEL_0        ((uint32_t)0x00100000U)     /* Bit 0 */
#define PGA4_VPSSEL_1        ((uint32_t)0x00200000U)     /* Bit 1 */
#define PGA4_VPSSEL_2        ((uint32_t)0x00400000U)     /* Bit 2 */
#define PGA4_VPSSEL_3        ((uint32_t)0x00800000U)     /* Bit 3 */

#define PGA4_VMSSEL          ((uint32_t)0x0F000000U)     /* PGA4 Inverted secondary input selection */
#define PGA4_VMSSEL_0        ((uint32_t)0x01000000U)     /* Bit 0 */
#define PGA4_VMSSEL_1        ((uint32_t)0x02000000U)     /* Bit 1 */
#define PGA4_VMSSEL_2        ((uint32_t)0x04000000U)     /* Bit 2 */
#define PGA4_VMSSEL_3        ((uint32_t)0x08000000U)     /* Bit 3 */

#define PGA4_TRIMEN          ((uint32_t)0x10000000U)     /* PGA4 MOS triming enable */

/********************  Bit definition for PGA4_TRIM register  **********************/
#define PGA4_TRIMCH1P        ((uint32_t)0x0000003FU)     /* PGA4 Channel 1 PMOS triming value */
#define PGA4_TRIMCH1N        ((uint32_t)0x00000FC0U)     /* PGA4 Channel 1 NMOS triming value */
#define PGA4_TRIMCH2P        ((uint32_t)0x0003F000U)     /* PGA4 Channel 2 PMOS triming value */
#define PGA4_TRIMCH2N        ((uint32_t)0x00FC0000U)     /* PGA4 Channel 2 NMOS triming value */

#define PGA4_TRIMCH1FLAG     ((uint32_t)0x01000000U)     /* PGA4 Channel 1 triming finish flag */
#define PGA4_TRIMCH2FLAG     ((uint32_t)0x02000000U)     /* PGA4 Channel 2 triming finish flag */


/********************  Bit definition for PGA_LOCK register  **********************/
#define PGA_LOCK             ((uint32_t)0x0000000FU)     /* All PGA lock enable */
#define PGA_LOCK_PGA1LK      ((uint32_t)0x00000001U)     /* PGA1 lock enable */
#define PGA_LOCK_PGA2LK      ((uint32_t)0x00000002U)     /* PGA2 lock enable */
#define PGA_LOCK_PGA3LK      ((uint32_t)0x00000004U)     /* PGA3 lock enable */
#define PGA_LOCK_PGA4LK      ((uint32_t)0x00000008U)     /* PGA4 lock enable */

/********************  Bit definition for PGA_IBIAS_EN register  **********************/
#define PGA_IBIAS_EN         ((uint32_t)0x00000001U)     /* PGA bias current source enable */

/*** TIM ***/

/** Bit definition for TIM_CTRL1 register  **/
#define TIM_CTRL1_CNTEN                         ((uint32_t)0x00000001U) /* Counter enable */
#define TIM_CTRL1_DIR                           ((uint32_t)0x00000002U) /* Direction */

#define TIM_CTRL1_CAMSEL                        ((uint32_t)0x0000000CU) /* CMS[1:0] bits (Center-aligned mode selection) */
#define TIM_CTRL1_CAMSEL_0                      ((uint32_t)0x00000004U) /* Bit 0 */
#define TIM_CTRL1_CAMSEL_1                      ((uint32_t)0x00000008U) /* Bit 1 */

#define TIM_CTRL1_UPRS                          ((uint32_t)0x00000010U) /* Update request source */
#define TIM_CTRL1_UPDIS                         ((uint32_t)0x00000020U) /* Update disable */

#define TIM_CTRL1_CLKD                          ((uint32_t)0x000000C0U) /* CKD[1:0] bits (clock division) */
#define TIM_CTRL1_CLKD_0                        ((uint32_t)0x00000040U) /* Bit 0 */
#define TIM_CTRL1_CLKD_1                        ((uint32_t)0x00000080U) /* Bit 1 */

#define TIM_CTRL1_ONEPM                         ((uint32_t)0x00000100U) /* One pulse mode */
#define TIM_CTRL1_ARPEN                         ((uint32_t)0x00000200U) /* Auto-reload preload enable */
#define TIM_CTRL1_LBKPEN                        ((uint32_t)0x00000400U) /* LOCKUP as bkp Enable*/
#define TIM_CTRL1_PBKPEN                        ((uint32_t)0x00000800U) /* PVD as bkp Enable */
#define TIM_CTRL1_SMPARERREN                    ((uint32_t)0x00001000U) /* Sram parity error as bkp Enable */
#define TIM_CTRL1_CLRSEL                        ((uint32_t)0x00002000U) /* OCxRef clear selection */
#define TIM_CTRL1_FLECCERREN                    ((uint32_t)0x00004000U) /* Flash ecc error as bkp Enable */
#define TIM_CTRL1_SMECCERREN                    ((uint32_t)0x00008000U) /* Sram ecc error as bkp Enable */

#define TIM_CTRL1_C1SEL                         ((uint32_t)0x00010000U) /* Channel 1 selection */
#define TIM_CTRL1_C2SEL                         ((uint32_t)0x00020000U) /* Channel 2 selection */
#define TIM_CTRL1_C3SEL                         ((uint32_t)0x00040000U) /* Channel 3 selection */
#define TIM_CTRL1_C4SEL                         ((uint32_t)0x00080000U) /* Channel 4 selection */

#define TIM_CTRL1_CMODE                         ((uint32_t)0x00300000U)  /* In center-aligned mode, channel 4/7/8/9 trigger mode */
#define TIM_CTRL1_CMODE_0                       ((uint32_t)0x00100000U)  /* Bit0 */
#define TIM_CTRL1_CMODE_1                       ((uint32_t)0x00200000U)  /* Bit1 */

#define TIM_CTRL1_ASMMETRIC                     ((uint32_t)0x00800000U)  /* Asynmmetric mode enable in center-aligned */
#define TIM_CTRL1_UDITFREMAP                    ((uint32_t)0x01000000U)  /* UDITF status bit remapping */

/** Bit definition for TIM_CTRL2 register **/
#define TIM_CTRL2_OI1                           ((uint32_t)0x00000001U) /* Output Idle state 1 (OC1 output) */
#define TIM_CTRL2_OI1N                          ((uint32_t)0x00000002U) /* Output Idle state 1 (OC1N output) */
#define TIM_CTRL2_OI2                           ((uint32_t)0x00000004U) /* Output Idle state 2 (OC2 output) */
#define TIM_CTRL2_OI2N                          ((uint32_t)0x00000008U) /* Output Idle state 2 (OC2N output) */
#define TIM_CTRL2_OI3                           ((uint32_t)0x00000010U) /* Output Idle state 3 (OC3 output) */
#define TIM_CTRL2_OI3N                          ((uint32_t)0x00000020U) /* Output Idle state 3 (OC3N output) */
#define TIM_CTRL2_OI4                           ((uint32_t)0x00000040U) /* Output Idle state 4 (OC4 output) */
#define TIM_CTRL2_OI4N                          ((uint32_t)0x00000080U) /* Output Idle state 4 (OC4N output) */
#define TIM_CTRL2_OI5                           ((uint32_t)0x00000100U) /* Output Idle state 5 (OC5 output) */
#define TIM_CTRL2_OI6                           ((uint32_t)0x00000400U) /* Output Idle state 6 (OC6 output) */

#define TIM_CTRL2_MMSEL                         ((uint32_t)0x0000F000U) /* MMSEL[3:0] bits (Master Mode Selection) */
#define TIM_CTRL2_MMSEL_0                       ((uint32_t)0x00001000U) /* Bit 0 */
#define TIM_CTRL2_MMSEL_1                       ((uint32_t)0x00002000U) /* Bit 1 */
#define TIM_CTRL2_MMSEL_2                       ((uint32_t)0x00004000U) /* Bit 2 */
#define TIM_CTRL2_MMSEL_3                       ((uint32_t)0x00008000U) /* Bit 3 */

#define TIM_CTRL2_CCUSEL                        ((uint32_t)0x00010000U) /* Capture/Compare Control Update Selection */
#define TIM_CTRL2_CCDSEL                        ((uint32_t)0x00020000U) /* Capture/Compare DMA Selection */
#define TIM_CTRL2_CCPCTL                        ((uint32_t)0x00040000U) /* Capture/Compare Preloaded Control */
#define TIM_CTRL2_TI1SEL                        ((uint32_t)0x00080000U) /* TI1 Selection */
#define TIM_CTRL2_TRIG4                         ((uint32_t)0x00100000U) /* OC4REF trigger to ADC enable */
#define TIM_CTRL2_TRIG7                         ((uint32_t)0x00200000U) /* OC7REF trigger to ADC enable */
#define TIM_CTRL2_TRIG8                         ((uint32_t)0x00400000U) /* OC7REF trigger to ADC enable */
#define TIM_CTRL2_TRIG9                         ((uint32_t)0x00800000U) /* OC7REF trigger to ADC enable */

#define TIM_CTRL2_MMSEL2                        ((uint32_t)0x0F000000U) /* MMSEL2[3:0] bits (Master Mode Selection) */
#define TIM_CTRL2_MMSEL2_0                      ((uint32_t)0x01000000U) /* Bit 0 */
#define TIM_CTRL2_MMSEL2_1                      ((uint32_t)0x02000000U) /* Bit 1 */
#define TIM_CTRL2_MMSEL2_2                      ((uint32_t)0x04000000U) /* Bit 2 */
#define TIM_CTRL2_MMSEL2_3                      ((uint32_t)0x08000000U) /* Bit 3 */

/** Bit definition for TIM_STS register **/
#define TIM_STS_CC1ITF                          ((uint32_t)0x00000001U) /* Capture/Compare 1 interrupt Flag */
#define TIM_STS_CC2ITF                          ((uint32_t)0x00000002U) /* Capture/Compare 2 interrupt Flag */
#define TIM_STS_CC3ITF                          ((uint32_t)0x00000004U) /* Capture/Compare 3 interrupt Flag */
#define TIM_STS_CC4ITF                          ((uint32_t)0x00000008U) /* Capture/Compare 4 interrupt Flag */
#define TIM_STS_CC5ITF                          ((uint32_t)0x00000010U) /* Capture/Compare 5 interrupt Flag */
#define TIM_STS_CC6ITF                          ((uint32_t)0x00000020U) /* Capture/Compare 6 interrupt Flag */
#define TIM_STS_CC1OCF                          ((uint32_t)0x00000100U) /* Capture/Compare 1 Overcapture Flag */
#define TIM_STS_CC2OCF                          ((uint32_t)0x00000200U) /* Capture/Compare 2 Overcapture Flag */
#define TIM_STS_CC3OCF                          ((uint32_t)0x00000400U) /* Capture/Compare 3 Overcapture Flag */
#define TIM_STS_CC4OCF                          ((uint32_t)0x00000800U) /* Capture/Compare 4 Overcapture Flag */
#define TIM_STS_UDITF                           ((uint32_t)0x00010000U) /* Update interrupt Flag */
#define TIM_STS_COMITF                          ((uint32_t)0x00020000U) /* COM interrupt Flag */
#define TIM_STS_TITF                            ((uint32_t)0x00040000U) /* Trigger interrupt Flag */
#define TIM_STS_BITF                            ((uint32_t)0x00080000U) /* Break interrupt Flag */
#define TIM_STS_BITF2                           ((uint32_t)0x00100000U) /* Break2 interrupt Flag */
#define TIM_STS_SBITF                           ((uint32_t)0x00200000U) /* System Break interrupt Flag */
#define TIM_STS_CC7ITF                          ((uint32_t)0x01000000U) /* Capture/Compare 7 interrupt Flag */
#define TIM_STS_CC8ITF                          ((uint32_t)0x02000000U) /* Capture/Compare 8 interrupt Flag */
#define TIM_STS_CC9ITF                          ((uint32_t)0x04000000U) /* Capture/Compare 9 interrupt Flag */

/** Bit definition for TIM_EVTGEN register **/
#define TIM_EVTGEN_CC1GN                        ((uint32_t)0x00000001U) /* Capture/Compare 1 Generation */
#define TIM_EVTGEN_CC2GN                        ((uint32_t)0x00000002U) /* Capture/Compare 2 Generation */
#define TIM_EVTGEN_CC3GN                        ((uint32_t)0x00000004U) /* Capture/Compare 3 Generation */
#define TIM_EVTGEN_CC4GN                        ((uint32_t)0x00000008U) /* Capture/Compare 4 Generation */
#define TIM_EVTGEN_UDGN                         ((uint32_t)0x00000100U) /* Update Generation */
#define TIM_EVTGEN_CCUDGN                       ((uint32_t)0x00000200U) /* Capture/Compare Control Update Generation */
#define TIM_EVTGEN_TGN                          ((uint32_t)0x00000400U) /* Trigger Generation */
#define TIM_EVTGEN_BGN                          ((uint32_t)0x00000800U) /* Break Generation */
#define TIM_EVTGEN_BGN2                         ((uint32_t)0x00001000U) /* Break2 Generation */

/** Bit definition for TIM_SMCTRL register **/
#define TIM_SMCTRL_TSEL                         ((uint32_t)0x00000007U) /* TS[2:0] bits (Trigger selection) */
#define TIM_SMCTRL_TSEL_0                       ((uint32_t)0x00000001U) /* Bit 0 */
#define TIM_SMCTRL_TSEL_1                       ((uint32_t)0x00000002U) /* Bit 1 */
#define TIM_SMCTRL_TSEL_2                       ((uint32_t)0x00000004U) /* Bit 2 */

#define TIM_SMCTRL_SMSEL                        ((uint32_t)0x000000F0U) /* SMS[2:0] bits (Slave mode selection) */
#define TIM_SMCTRL_SMSEL_0                      ((uint32_t)0x00000010U) /* Bit 0 */
#define TIM_SMCTRL_SMSEL_1                      ((uint32_t)0x00000020U) /* Bit 1 */
#define TIM_SMCTRL_SMSEL_2                      ((uint32_t)0x00000040U) /* Bit 2 */
#define TIM_SMCTRL_SMSEL_3                      ((uint32_t)0x00000080U) /* Bit 3 */

#define TIM_SMCTRL_EXTPS                        ((uint32_t)0x00000300U) /* ETPS[1:0] bits (External trigger prescaler) */
#define TIM_SMCTRL_EXTPS_0                      ((uint32_t)0x00000100U) /* Bit 0 */
#define TIM_SMCTRL_EXTPS_1                      ((uint32_t)0x00000200U) /* Bit 1 */

#define TIM_SMCTRL_EXCEN                        ((uint32_t)0x00000400U) /* External clock enable */
#define TIM_SMCTRL_EXTP                         ((uint32_t)0x00000800U) /* External trigger polarity */

#define TIM_SMCTRL_EXTF                         ((uint32_t)0x0000F000U) /* ETF[3:0] bits (External trigger filter) */
#define TIM_SMCTRL_EXTF_0                       ((uint32_t)0x00001000U) /* Bit 0 */
#define TIM_SMCTRL_EXTF_1                       ((uint32_t)0x00002000U) /* Bit 1 */
#define TIM_SMCTRL_EXTF_2                       ((uint32_t)0x00004000U) /* Bit 2 */
#define TIM_SMCTRL_EXTF_3                       ((uint32_t)0x00008000U) /* Bit 3 */

#define TIM_SMCTRL_MSMD                         ((uint32_t)0x00010000U) /* Master/slave mode */

#define TIM_SMCTRL_OCREFCLRP                    ((uint32_t)0x00080000U) /* Ocrefclear signal polarity */

#define TIM_SMCTRL_OCREFCLRF                    ((uint32_t)0x00F00000U) /* OCREFCLRF[3:0] bits (Ocrefclear signal prescaler) */
#define TIM_SMCTRL_OCREFCLRF_0                  ((uint32_t)0x00100000U) /* Bit 0 */
#define TIM_SMCTRL_OCREFCLRF_1                  ((uint32_t)0x00200000U) /* Bit 1 */
#define TIM_SMCTRL_OCREFCLRF_2                  ((uint32_t)0x00400000U) /* Bit 2 */
#define TIM_SMCTRL_OCREFCLRF_3                  ((uint32_t)0x00800000U) /* Bit 3 */

/** Bit definition for TIM_DINTEN register **/
#define TIM_DINTEN_CC1IEN                       ((uint32_t)0x00000001U) /* Capture/Compare 1 interrupt enable */
#define TIM_DINTEN_CC2IEN                       ((uint32_t)0x00000002U) /* Capture/Compare 2 interrupt enable */
#define TIM_DINTEN_CC3IEN                       ((uint32_t)0x00000004U) /* Capture/Compare 3 interrupt enable */
#define TIM_DINTEN_CC4IEN                       ((uint32_t)0x00000008U) /* Capture/Compare 4 interrupt enable */
#define TIM_DINTEN_CC5IEN                       ((uint32_t)0x00000010U) /* Capture/Compare 5 interrupt enable */
#define TIM_DINTEN_CC6IEN                       ((uint32_t)0x00000020U) /* Capture/Compare 6 interrupt enable */
#define TIM_DINTEN_CC7IEN                       ((uint32_t)0x00000040U) /* Capture/Compare 7 interrupt enable */
#define TIM_DINTEN_CC8IEN                       ((uint32_t)0x00000080U) /* Capture/Compare 8 interrupt enable */
#define TIM_DINTEN_CC1DEN                       ((uint32_t)0x00000100U) /* Capture/Compare 1 DMA request enable */
#define TIM_DINTEN_CC2DEN                       ((uint32_t)0x00000200U) /* Capture/Compare 2 DMA request enable */
#define TIM_DINTEN_CC3DEN                       ((uint32_t)0x00000400U) /* Capture/Compare 3 DMA request enable */
#define TIM_DINTEN_CC4DEN                       ((uint32_t)0x00000800U) /* Capture/Compare 4 DMA request enable */
#define TIM_DINTEN_UIEN                         ((uint32_t)0x00010000U) /* Update interrupt enable */
#define TIM_DINTEN_TIEN                         ((uint32_t)0x00020000U) /* Trigger interrupt enable */
#define TIM_DINTEN_BIEN                         ((uint32_t)0x00040000U) /* Break interrupt enable */
#define TIM_DINTEN_UDEN                         ((uint32_t)0x00080000U) /* Update DMA request enable */
#define TIM_DINTEN_COMDEN                       ((uint32_t)0x00100000U) /* COM DMA request enable */
#define TIM_DINTEN_TDEN                         ((uint32_t)0x00200000U) /* Trigger DMA request enable */
#define TIM_DINTEN_COMIEN                       ((uint32_t)0x00400000U) /* COM interrupt enable */
#define TIM_DINTEN_CC9IEN                       ((uint32_t)0x00800000U) /* Capture/Compare 9 interrupt enable */

/** Bit definition for TIM_CCMOD1 register **/
#define TIM_CCMOD1_CC1SEL                       ((uint32_t)0x00000003U) /* CC1S[1:0] bits (Capture/Compare 1 Selection) */
#define TIM_CCMOD1_CC1SEL_0                     ((uint32_t)0x00000001U) /* Bit 0 */
#define TIM_CCMOD1_CC1SEL_1                     ((uint32_t)0x00000002U) /* Bit 1 */

#define TIM_CCMOD1_OC1PEN                       ((uint32_t)0x00000004U) /* Output Compare 1 Preload enable */
#define TIM_CCMOD1_OC1FEN                       ((uint32_t)0x00000008U) /* Output Compare 1 Fast enable */
#define TIM_CCMOD1_OC1CEN                       ((uint32_t)0x00000010U) /* Output Compare 1 Clear Enable */

#define TIM_CCMOD1_OC1MD                        ((uint32_t)0x000000E0U) /* OC1MD[2:0] bits (Output Compare 1 Mode) */
#define TIM_CCMOD1_OC1MD_0                      ((uint32_t)0x00000020U) /* Bit 0 */
#define TIM_CCMOD1_OC1MD_1                      ((uint32_t)0x00000040U) /* Bit 1 */
#define TIM_CCMOD1_OC1MD_2                      ((uint32_t)0x00000080U) /* Bit 2 */

#define TIM_CCMOD1_CC2SEL                       ((uint32_t)0x00000300U) /* CC2S[1:0] bits (Capture/Compare 2 Selection) */
#define TIM_CCMOD1_CC2SEL_0                     ((uint32_t)0x00000100U) /* Bit 0 */
#define TIM_CCMOD1_CC2SEL_1                     ((uint32_t)0x00000200U) /* Bit 1 */

#define TIM_CCMOD1_OC2PEN                       ((uint32_t)0x00000400U) /* Output Compare 2 Preload enable */
#define TIM_CCMOD1_OC2FEN                       ((uint32_t)0x00000800U) /* Output Compare 2 Fast enable */
#define TIM_CCMOD1_OC2CEN                       ((uint32_t)0x00001000U) /* Output Compare 2 Clear Enable */

#define TIM_CCMOD1_OC2MD                        ((uint32_t)0x0000E000U) /* OC2MD[2:0] bits (Output Compare 2 Mode) */
#define TIM_CCMOD1_OC2MD_0                      ((uint32_t)0x00002000U) /* Bit 0 */
#define TIM_CCMOD1_OC2MD_1                      ((uint32_t)0x00004000U) /* Bit 1 */
#define TIM_CCMOD1_OC2MD_2                      ((uint32_t)0x00008000U) /* Bit 2 */

#define TIM_CCMOD1_OC1MD_3                      ((uint32_t)0x00020000U) /* OC1MD3 bit (Output Compare 1 Mode) */
#define TIM_CCMOD1_OC2MD_3                      ((uint32_t)0x00040000U) /* OC2MD3 bit (Output Compare 2 Mode) */

#define TIM_CCMOD1_IC1PSC                       ((uint32_t)0x0000000CU) /* IC1PSC[1:0] bits (Input Capture 1 Prescaler) */
#define TIM_CCMOD1_IC1PSC_0                     ((uint32_t)0x00000004U) /* Bit 0 */
#define TIM_CCMOD1_IC1PSC_1                     ((uint32_t)0x00000008U) /* Bit 1 */

#define TIM_CCMOD1_IC1F                         ((uint32_t)0x000000F0U) /* IC1F[3:0] bits (Input Capture 1 Filter) */
#define TIM_CCMOD1_IC1F_0                       ((uint32_t)0x00000010U) /* Bit 0 */
#define TIM_CCMOD1_IC1F_1                       ((uint32_t)0x00000020U) /* Bit 1 */
#define TIM_CCMOD1_IC1F_2                       ((uint32_t)0x00000040U) /* Bit 2 */
#define TIM_CCMOD1_IC1F_3                       ((uint32_t)0x00000080U) /* Bit 3 */

#define TIM_CCMOD1_IC2PSC                       ((uint32_t)0x00000C00U) /* IC2PSC[1:0] bits (Input Capture 2 Prescaler) */
#define TIM_CCMOD1_IC2PSC_0                     ((uint32_t)0x00000400U) /* Bit 0 */
#define TIM_CCMOD1_IC2PSC_1                     ((uint32_t)0x00000800U) /* Bit 1 */

#define TIM_CCMOD1_IC2F                         ((uint32_t)0x0000F000U) /* IC2F[3:0] bits (Input Capture 2 Filter) */
#define TIM_CCMOD1_IC2F_0                       ((uint32_t)0x00001000U) /* Bit 0 */
#define TIM_CCMOD1_IC2F_1                       ((uint32_t)0x00002000U) /* Bit 1 */
#define TIM_CCMOD1_IC2F_2                       ((uint32_t)0x00004000U) /* Bit 2 */
#define TIM_CCMOD1_IC2F_3                       ((uint32_t)0x00008000U) /* Bit 3 */

/** Bit definition for TIM_CCMOD2 register **/
#define TIM_CCMOD2_CC3SEL                       ((uint32_t)0x00000003U) /* CC3S[1:0] bits (Capture/Compare 3 Selection) */
#define TIM_CCMOD2_CC3SEL_0                     ((uint32_t)0x00000001U) /* Bit 0 */
#define TIM_CCMOD2_CC3SEL_1                     ((uint32_t)0x00000002U) /* Bit 1 */

#define TIM_CCMOD2_OC3PEN                       ((uint32_t)0x00000004U) /* Output Compare 3 Preload enable */
#define TIM_CCMOD2_OC3FEN                       ((uint32_t)0x00000008U) /* Output Compare 3 Fast enable */
#define TIM_CCMOD2_OC3CEN                       ((uint32_t)0x00000010U) /* Output Compare 3 Clear Enable */

#define TIM_CCMOD2_OC3MD                        ((uint32_t)0x000000E0U) /* OC3MD[2:0] bits (Output Compare 3 Mode) */
#define TIM_CCMOD2_OC3MD_0                      ((uint32_t)0x00000020U) /* Bit 0 */
#define TIM_CCMOD2_OC3MD_1                      ((uint32_t)0x00000040U) /* Bit 1 */
#define TIM_CCMOD2_OC3MD_2                      ((uint32_t)0x00000080U) /* Bit 2 */

#define TIM_CCMOD2_CC4SEL                       ((uint32_t)0x00000300U) /* CC3S[1:0] bits (Capture/Compare 4 Selection) */
#define TIM_CCMOD2_CC4SEL_0                     ((uint32_t)0x00000100U) /* Bit 0 */
#define TIM_CCMOD2_CC4SEL_1                     ((uint32_t)0x00000200U) /* Bit 1 */

#define TIM_CCMOD2_OC4PEN                       ((uint32_t)0x00000400U) /* Output Compare 4 Preload enable */
#define TIM_CCMOD2_OC4FEN                       ((uint32_t)0x00000800U) /* Output Compare 4 Fast enable */
#define TIM_CCMOD2_OC4CEN                       ((uint32_t)0x00001000U) /* Output Compare 4 Clear Enable */

#define TIM_CCMOD2_OC4MD                        ((uint32_t)0x0000E000U) /* OC4MD[2:0] bits (Output Compare 4 Mode) */
#define TIM_CCMOD2_OC4MD_0                      ((uint32_t)0x00002000U) /* Bit 0 */
#define TIM_CCMOD2_OC4MD_1                      ((uint32_t)0x00004000U) /* Bit 1 */
#define TIM_CCMOD2_OC4MD_2                      ((uint32_t)0x00008000U) /* Bit 2 */

#define TIM_CCMOD2_OC3MD_3                      ((uint32_t)0x00020000U) /* OC3MD3 bit (Output Compare 3 Mode) */
#define TIM_CCMOD2_OC4MD_3                      ((uint32_t)0x00040000U) /* OC4MD3 bit (Output Compare 4 Mode) */

#define TIM_CCMOD2_IC3PSC                       ((uint32_t)0x0000000CU) /* IC3PSC[1:0] bits (Input Capture 3 Prescaler) */
#define TIM_CCMOD2_IC3PSC_0                     ((uint32_t)0x00000004U) /* Bit 0 */
#define TIM_CCMOD2_IC3PSC_1                     ((uint32_t)0x00000008U) /* Bit 1 */

#define TIM_CCMOD2_IC3F                         ((uint32_t)0x000000F0U) /* IC3F[3:0] bits (Input Capture 3 Filter) */
#define TIM_CCMOD2_IC3F_0                       ((uint32_t)0x00000010U) /* Bit 0 */
#define TIM_CCMOD2_IC3F_1                       ((uint32_t)0x00000020U) /* Bit 1 */
#define TIM_CCMOD2_IC3F_2                       ((uint32_t)0x00000040U) /* Bit 2 */
#define TIM_CCMOD2_IC3F_3                       ((uint32_t)0x00000080U) /* Bit 3 */

#define TIM_CCMOD2_IC4PSC                       ((uint32_t)0x00000C00U) /* IC4PSC[1:0] bits (Input Capture 4 Prescaler) */
#define TIM_CCMOD2_IC4PSC_0                     ((uint32_t)0x00000400U) /* Bit 0 */
#define TIM_CCMOD2_IC4PSC_1                     ((uint32_t)0x00000800U) /* Bit 1 */

#define TIM_CCMOD2_IC4F                         ((uint32_t)0x0000F000U) /* IC4F[3:0] bits (Input Capture 4 Filter) */
#define TIM_CCMOD2_IC4F_0                       ((uint32_t)0x00001000U) /* Bit 0 */
#define TIM_CCMOD2_IC4F_1                       ((uint32_t)0x00002000U) /* Bit 1 */
#define TIM_CCMOD2_IC4F_2                       ((uint32_t)0x00004000U) /* Bit 2 */
#define TIM_CCMOD2_IC4F_3                       ((uint32_t)0x00008000U) /* Bit 3 */

/** Bit definition for TIM_CCMOD3 register **/
#define TIM_CCMOD3_OC5PEN                       ((uint32_t)0x00000004U) /* Output Compare 5 Preload enable */
#define TIM_CCMOD3_OC5FEN                       ((uint32_t)0x00000008U) /* Output Compare 5 Fast enable */
#define TIM_CCMOD3_OC5CEN                       ((uint32_t)0x00000010U) /* Output Compare 5 Clear Enable */

#define TIM_CCMOD3_OC5MD                        ((uint32_t)0x000000E0U) /* OC5M[2:0] bits (Output Compare 5 Mode) */
#define TIM_CCMOD3_OC5MD_0                      ((uint32_t)0x00000020U) /* Bit 0 */
#define TIM_CCMOD3_OC5MD_1                      ((uint32_t)0x00000040U) /* Bit 1 */
#define TIM_CCMOD3_OC5MD_2                      ((uint32_t)0x00000080U) /* Bit 2 */

#define TIM_CCMOD3_OC6PEN                       ((uint32_t)0x00000400U) /* Output Compare 6 Preload enable */
#define TIM_CCMOD3_OC6FEN                       ((uint32_t)0x00000800U) /* Output Compare 6 Fast enable */
#define TIM_CCMOD3_OC6CEN                       ((uint32_t)0x00001000U) /* Output Compare 6 Clear Enable */

#define TIM_CCMOD3_OC6MD                        ((uint32_t)0x0000E000U) /* OC6M[2:0] bits (Output Compare 6 Mode) */
#define TIM_CCMOD3_OC6MD_0                      ((uint32_t)0x00002000U) /* Bit 0 */
#define TIM_CCMOD3_OC6MD_1                      ((uint32_t)0x00004000U) /* Bit 1 */
#define TIM_CCMOD3_OC6MD_2                      ((uint32_t)0x00008000U) /* Bit 2 */

#define TIM_CCMOD3_OC7PEN                       ((uint32_t)0x00010000U) /* Output Compare 7 Preload enable */
#define TIM_CCMOD3_OC8PEN                       ((uint32_t)0x00100000U) /* Output Compare 8 Preload enable */
#define TIM_CCMOD3_OC9PEN                       ((uint32_t)0x01000000U) /* Output Compare 9 Preload enable */

/** Bit definition for TIM_CCEN register **/
#define TIM_CCEN_CC1NEN                         ((uint32_t)0x00000001U) /* Capture/Compare 1 Complementary output enable */
#define TIM_CCEN_CC1NP                          ((uint32_t)0x00000002U) /* Capture/Compare 1 Complementary output Polarity */
#define TIM_CCEN_CC1EN                          ((uint32_t)0x00000004U) /* Capture/Compare 1 output enable */
#define TIM_CCEN_CC1P                           ((uint32_t)0x00000008U) /* Capture/Compare 1 output Polarity */
#define TIM_CCEN_CC2NEN                         ((uint32_t)0x00000010U) /* Capture/Compare 2 Complementary output enable */
#define TIM_CCEN_CC2NP                          ((uint32_t)0x00000020U) /* Capture/Compare 2 Complementary output Polarity */
#define TIM_CCEN_CC2EN                          ((uint32_t)0x00000040U) /* Capture/Compare 2 output enable */
#define TIM_CCEN_CC2P                           ((uint32_t)0x00000080U) /* Capture/Compare 2 output Polarity */
#define TIM_CCEN_CC3NEN                         ((uint32_t)0x00000100U) /* Capture/Compare 3 Complementary output enable */
#define TIM_CCEN_CC3NP                          ((uint32_t)0x00000200U) /* Capture/Compare 3 Complementary output Polarity */
#define TIM_CCEN_CC3EN                          ((uint32_t)0x00000400U) /* Capture/Compare 3 output enable */
#define TIM_CCEN_CC3P                           ((uint32_t)0x00000800U) /* Capture/Compare 3 output Polarity */
#define TIM_CCEN_CC4NEN                         ((uint32_t)0x00001000U) /* Capture/Compare 4 Complementary output enable */
#define TIM_CCEN_CC4NP                          ((uint32_t)0x00002000U) /* Capture/Compare 4 Complementary output Polarity */
#define TIM_CCEN_CC4EN                          ((uint32_t)0x00004000U) /* Capture/Compare 4 output enable */
#define TIM_CCEN_CC4P                           ((uint32_t)0x00008000U) /* Capture/Compare 4 output Polarity */
#define TIM_CCEN_CC5EN                          ((uint32_t)0x00040000U) /* Capture/Compare 5 output enable */
#define TIM_CCEN_CC5P                           ((uint32_t)0x00080000U) /* Capture/Compare 5 output Polarity */
#define TIM_CCEN_CC6EN                          ((uint32_t)0x00400000U) /* Capture/Compare 6 output enable */
#define TIM_CCEN_CC6P                           ((uint32_t)0x00800000U) /* Capture/Compare 6 output Polarity */

/** Bit definition for TIM_CCDAT1 register **/
#define TIM_CCDAT1_CCDAT1                       ((uint32_t)0x0000FFFFU)  /* Capture/Compare 1 Value */
#define TIM_CCDAT1_CCDDAT1                      ((uint32_t)0xFFFF0000U)  /* Capture/Compare 1 down-counting Value */

/** Bit definition for TIM_CCDAT2 register **/
#define TIM_CCDAT2_CCDAT2                       ((uint32_t)0x0000FFFFU)  /* Capture/Compare 2 Value */
#define TIM_CCDAT2_CCDDAT2                      ((uint32_t)0xFFFF0000U)  /* Capture/Compare 2 down-counting Value */

/** Bit definition for TIM_CCDAT3 register **/
#define TIM_CCDAT3_CCDAT3                       ((uint32_t)0x0000FFFFU)  /* Capture/Compare 3 Value */
#define TIM_CCDAT3_CCDDAT3                      ((uint32_t)0xFFFF0000U)  /* Capture/Compare 3 down-counting Value */

/** Bit definition for TIM_CCDAT4 register **/
#define TIM_CCDAT4_CCDAT4                       ((uint32_t)0x0000FFFFU)  /* Capture/Compare 4 Value */
#define TIM_CCDAT4_CCDDAT4                      ((uint32_t)0xFFFF0000U)  /* Capture/Compare 4 down-counting Value */

/** Bit definition for TIM_CCDAT5 register **/
#define TIM_CCDAT5_CCDAT5                       ((uint32_t)0x0000FFFFU)  /* Capture/Compare 5 Value */

/** Bit definition for TIM_CCDAT6 register **/
#define TIM_CCDAT6_CCDAT6                       ((uint32_t)0x0000FFFFU)  /* Capture/Compare 6 Value */

/** Bit definition for TIM_PSC register **/
#define TIM_PSC_PSC                             ((uint32_t)0x0000FFFFU)  /* Prescaler Value */

/** Bit definition for TIM_AR register **/
#define TIM_AR_AR                               ((uint32_t)0x0000FFFFU)  /* actual auto-reload Value */

/** Bit definition for TIM_CNT register **/
#define TIM_CNT_CNT                             ((uint32_t)0xFFFFFFFFU)  /* Counter Value */

/** Bit definition for TIM_REPCNT register **/
#define TIM_REPCNT_REPCNT                       ((uint32_t)0x000000FFU) /* Repetition Counter Value */

/** Bit definition for TIM_BKDT register **/
#define TIM_BKDT_DTGN                           ((uint32_t)0x000000FFU) /* DTG[0:7] bits (Dead-Time Generator set-up) */
#define TIM_BKDT_DTGN_0                         ((uint32_t)0x00000001U) /* Bit 0 */
#define TIM_BKDT_DTGN_1                         ((uint32_t)0x00000002U) /* Bit 1 */
#define TIM_BKDT_DTGN_2                         ((uint32_t)0x00000004U) /* Bit 2 */
#define TIM_BKDT_DTGN_3                         ((uint32_t)0x00000008U) /* Bit 3 */
#define TIM_BKDT_DTGN_4                         ((uint32_t)0x00000010U) /* Bit 4 */
#define TIM_BKDT_DTGN_5                         ((uint32_t)0x00000020U) /* Bit 5 */
#define TIM_BKDT_DTGN_6                         ((uint32_t)0x00000040U) /* Bit 6 */
#define TIM_BKDT_DTGN_7                         ((uint32_t)0x00000080U) /* Bit 7 */

#define TIM_BKDT_MOEN                           ((uint32_t)0x00000100U) /* Main Output enable */
#define TIM_BKDT_AOEN                           ((uint32_t)0x00000200U) /* Automatic Output enable */
#define TIM_BKDT_BKP                            ((uint32_t)0x00000400U) /* Break Polarity */
#define TIM_BKDT_BKEN                           ((uint32_t)0x00000800U) /* Break enable */
#define TIM_BKDT_OSSI                           ((uint32_t)0x00001000U) /* Off-State Selection for Idle mode */
#define TIM_BKDT_OSSR                           ((uint32_t)0x00002000U) /* Off-State Selection for Run mode */

#define TIM_BKDT_LCKCFG                         ((uint32_t)0x0000C000U) /* LOCK[1:0] bits (Lock Configuration) */
#define TIM_BKDT_LCKCFG_0                       ((uint32_t)0x00004000U) /* Bit 0 */
#define TIM_BKDT_LCKCFG_1                       ((uint32_t)0x00008000U) /* Bit 1 */

#define TIM_BKDT_BK2P                           ((uint32_t)0x00010000U) /* Break2 Polarity */
#define TIM_BKDT_BK2EN                           ((uint32_t)0x00020000U) /* Break2 enable */
#define TIM_BKDT_BRKDSRM                        ((uint32_t)0x00040000U) /* Break disarm */
#define TIM_BKDT_BRK2DSRM                       ((uint32_t)0x00080000U) /* Break2 disarm */
#define TIM_BKDT_BRKBID                         ((uint32_t)0x00100000U) /* Break bidirectional enable */
#define TIM_BKDT_BRK2BID                        ((uint32_t)0x00200000U) /* Break2 bidirectional enable */

/** Bit definition for TIM_CCDAT7 register **/
#define TIM_CCDAT7_CCDAT7                       ((uint32_t)0x0000FFFFU)  /* Capture/Compare 7 Value */

/** Bit definition for TIM_CCDAT8 register **/
#define TIM_CCDAT8_CCDAT8                       ((uint32_t)0x0000FFFFU)  /* Capture/Compare 8 Value */

/** Bit definition for TIM_CCDAT9 register **/
#define TIM_CCDAT9_CCDAT9                       ((uint32_t)0x0000FFFFU)  /* Capture/Compare 9 Value */

/** Bit definition for TIM_BKFR register **/     
#define TIM_BKFR_THRESH                         ((uint32_t)0x3F000000U) /* Break1 filter threshold */
#define TIM_BKFR_THRESH_0                       ((uint32_t)0x01000000U) /* Bit 0 */
#define TIM_BKFR_THRESH_1                       ((uint32_t)0x02000000U) /* Bit 1 */
#define TIM_BKFR_THRESH_2                       ((uint32_t)0x04000000U) /* Bit 2 */
#define TIM_BKFR_THRESH_3                       ((uint32_t)0x08000000U) /* Bit 3 */
#define TIM_BKFR_THRESH_4                       ((uint32_t)0x10000000U) /* Bit 4 */
#define TIM_BKFR_THRESH_5                       ((uint32_t)0x20000000U) /* Bit 5 */

#define TIM_BKFR_WSIZE                          ((uint32_t)0x007E0000U) /* Break1 filter window size */
#define TIM_BKFR_WSIZE_0                        ((uint32_t)0x00020000U) /* Bit 0 */
#define TIM_BKFR_WSIZE_1                        ((uint32_t)0x00040000U) /* Bit 1 */
#define TIM_BKFR_WSIZE_2                        ((uint32_t)0x00080000U) /* Bit 2 */
#define TIM_BKFR_WSIZE_3                        ((uint32_t)0x00100000U) /* Bit 3 */
#define TIM_BKFR_WSIZE_4                        ((uint32_t)0x00200000U) /* Bit 4 */
#define TIM_BKFR_WSIZE_5                        ((uint32_t)0x00400000U) /* Bit 5 */

#define TIM_BKFR_FILTEN                         ((uint32_t)0x00010000U) /* Break1 filter enable */

/** Bit definition for TIM_C1FILT register **/
#define TIM_C1FILT_THRESH                       ((uint32_t)0x3F000000U) /* CH1 filter threshold */
#define TIM_C1FILT_THRESH_0                     ((uint32_t)0x01000000U) /* Bit 0 */
#define TIM_C1FILT_THRESH_1                     ((uint32_t)0x02000000U) /* Bit 1 */
#define TIM_C1FILT_THRESH_2                     ((uint32_t)0x04000000U) /* Bit 2 */
#define TIM_C1FILT_THRESH_3                     ((uint32_t)0x08000000U) /* Bit 3 */
#define TIM_C1FILT_THRESH_4                     ((uint32_t)0x10000000U) /* Bit 4 */
#define TIM_C1FILT_THRESH_5                     ((uint32_t)0x20000000U) /* Bit 5 */

#define TIM_C1FILT_WSIZE                        ((uint32_t)0x007E0000U) /* CH1 filter window size */
#define TIM_C1FILT_WSIZE_0                      ((uint32_t)0x00020000U) /* Bit 0 */
#define TIM_C1FILT_WSIZE_1                      ((uint32_t)0x00040000U) /* Bit 1 */
#define TIM_C1FILT_WSIZE_2                      ((uint32_t)0x00080000U) /* Bit 2 */
#define TIM_C1FILT_WSIZE_3                      ((uint32_t)0x00100000U) /* Bit 3 */
#define TIM_C1FILT_WSIZE_4                      ((uint32_t)0x00200000U) /* Bit 4 */
#define TIM_C1FILT_WSIZE_5                      ((uint32_t)0x00400000U) /* Bit 5 */

#define TIM_C1FILT_FILTEN                       ((uint32_t)0x00010000U)

/** Bit definition for TIM_C2FILT register **/
#define TIM_C2FILT_THRESH                       ((uint32_t)0x3F000000U) /* CH2 filter threshold */
#define TIM_C2FILT_THRESH_0                     ((uint32_t)0x01000000U) /* Bit 0 */
#define TIM_C2FILT_THRESH_1                     ((uint32_t)0x02000000U) /* Bit 1 */
#define TIM_C2FILT_THRESH_2                     ((uint32_t)0x04000000U) /* Bit 2 */
#define TIM_C2FILT_THRESH_3                     ((uint32_t)0x08000000U) /* Bit 3 */
#define TIM_C2FILT_THRESH_4                     ((uint32_t)0x10000000U) /* Bit 4 */
#define TIM_C2FILT_THRESH_5                     ((uint32_t)0x20000000U) /* Bit 5 */

#define TIM_C2FILT_WSIZE                        ((uint32_t)0x007E0000U) /* CH2 filter window size */
#define TIM_C2FILT_WSIZE_0                      ((uint32_t)0x00020000U) /* Bit 0 */
#define TIM_C2FILT_WSIZE_1                      ((uint32_t)0x00040000U) /* Bit 1 */
#define TIM_C2FILT_WSIZE_2                      ((uint32_t)0x00080000U) /* Bit 2 */
#define TIM_C2FILT_WSIZE_3                      ((uint32_t)0x00100000U) /* Bit 3 */
#define TIM_C2FILT_WSIZE_4                      ((uint32_t)0x00200000U) /* Bit 4 */
#define TIM_C2FILT_WSIZE_5                      ((uint32_t)0x00400000U) /* Bit 5 */

#define TIM_C2FILT_FILTEN                       ((uint32_t)0x00010000U)

/** Bit definition for TIM_C3FILT register **/
#define TIM_C3FILT_THRESH                       ((uint32_t)0x3F000000U) /* CH3 filter threshold */
#define TIM_C3FILT_THRESH_0                     ((uint32_t)0x01000000U) /* Bit 0 */
#define TIM_C3FILT_THRESH_1                     ((uint32_t)0x02000000U) /* Bit 1 */
#define TIM_C3FILT_THRESH_2                     ((uint32_t)0x04000000U) /* Bit 2 */
#define TIM_C3FILT_THRESH_3                     ((uint32_t)0x08000000U) /* Bit 3 */
#define TIM_C3FILT_THRESH_4                     ((uint32_t)0x10000000U) /* Bit 4 */
#define TIM_C3FILT_THRESH_5                     ((uint32_t)0x20000000U) /* Bit 5 */

#define TIM_C3FILT_WSIZE                        ((uint32_t)0x007E0000U) /* CH3 filter window size */
#define TIM_C3FILT_WSIZE_0                      ((uint32_t)0x00020000U) /* Bit 0 */
#define TIM_C3FILT_WSIZE_1                      ((uint32_t)0x00040000U) /* Bit 1 */
#define TIM_C3FILT_WSIZE_2                      ((uint32_t)0x00080000U) /* Bit 2 */
#define TIM_C3FILT_WSIZE_3                      ((uint32_t)0x00100000U) /* Bit 3 */
#define TIM_C3FILT_WSIZE_4                      ((uint32_t)0x00200000U) /* Bit 4 */
#define TIM_C3FILT_WSIZE_5                      ((uint32_t)0x00400000U) /* Bit 5 */

#define TIM_C3FILT_FILTEN                       ((uint32_t)0x00010000U)

/** Bit definition for TIM_C4FILT register **/
#define TIM_C4FILT_THRESH                       ((uint32_t)0x3F000000U) /* CH4 filter threshold */
#define TIM_C4FILT_THRESH_0                     ((uint32_t)0x01000000U) /* Bit 0 */
#define TIM_C4FILT_THRESH_1                     ((uint32_t)0x02000000U) /* Bit 1 */
#define TIM_C4FILT_THRESH_2                     ((uint32_t)0x04000000U) /* Bit 2 */
#define TIM_C4FILT_THRESH_3                     ((uint32_t)0x08000000U) /* Bit 3 */
#define TIM_C4FILT_THRESH_4                     ((uint32_t)0x10000000U) /* Bit 4 */
#define TIM_C4FILT_THRESH_5                     ((uint32_t)0x20000000U) /* Bit 5 */

#define TIM_C4FILT_WSIZE                        ((uint32_t)0x007E0000U) /* CH4 filter window size */
#define TIM_C4FILT_WSIZE_0                      ((uint32_t)0x00020000U) /* Bit 0 */
#define TIM_C4FILT_WSIZE_1                      ((uint32_t)0x00040000U) /* Bit 1 */
#define TIM_C4FILT_WSIZE_2                      ((uint32_t)0x00080000U) /* Bit 2 */
#define TIM_C4FILT_WSIZE_3                      ((uint32_t)0x00100000U) /* Bit 3 */
#define TIM_C4FILT_WSIZE_4                      ((uint32_t)0x00200000U) /* Bit 4 */
#define TIM_C4FILT_WSIZE_5                      ((uint32_t)0x00400000U) /* Bit 5 */

#define TIM_C4FILT_FILTEN                       ((uint32_t)0x00010000U)

/** Bit definition for TIM_FILTO register **/
#define TIM_FILTO_C1FILTO                       ((uint32_t)0x00000001U) /* CH1 filter output state */
#define TIM_FILTO_C2FILTO                       ((uint32_t)0x00000002U) /* CH2 filter output state */
#define TIM_FILTO_C3FILTO                       ((uint32_t)0x00000004U) /* CH3 filter output state */
#define TIM_FILTO_C4FILTO                       ((uint32_t)0x00000008U) /* CH4 filter output state */

/** Bit definition for TIM_INSEL register **/
#define TIM_INSEL_TI1S                          ((uint32_t)0x0000000FU) /* TI1 signal selection */
#define TIM_INSEL_TI1S_0                        ((uint32_t)0x00000001U) /* Bit 0 */
#define TIM_INSEL_TI1S_1                        ((uint32_t)0x00000002U) /* Bit 1 */
#define TIM_INSEL_TI1S_2                        ((uint32_t)0x00000004U) /* Bit 2 */
#define TIM_INSEL_TI1S_3                        ((uint32_t)0x00000008U) /* Bit 3 */

#define TIM_INSEL_TI2S                          ((uint32_t)0x000000F0U) /* TI2 signal selection */
#define TIM_INSEL_TI2S_0                        ((uint32_t)0x00000010U) /* Bit 0 */
#define TIM_INSEL_TI2S_1                        ((uint32_t)0x00000020U) /* Bit 1 */
#define TIM_INSEL_TI2S_2                        ((uint32_t)0x00000040U) /* Bit 2 */
#define TIM_INSEL_TI2S_3                        ((uint32_t)0x00000080U) /* Bit 3 */

#define TIM_INSEL_TI3S                          ((uint32_t)0x00000F00U) /* TI3 signal selection */
#define TIM_INSEL_TI3S_0                        ((uint32_t)0x00000100U) /* Bit 0 */
#define TIM_INSEL_TI3S_1                        ((uint32_t)0x00000200U) /* Bit 1 */
#define TIM_INSEL_TI3S_2                        ((uint32_t)0x00000400U) /* Bit 2 */
#define TIM_INSEL_TI3S_3                        ((uint32_t)0x00000800U) /* Bit 3 */

#define TIM_INSEL_TI4S                          ((uint32_t)0x0000F000U) /* TI4 signal selection */
#define TIM_INSEL_TI4S_0                        ((uint32_t)0x00001000U) /* Bit 0 */
#define TIM_INSEL_TI4S_1                        ((uint32_t)0x00002000U) /* Bit 1 */
#define TIM_INSEL_TI4S_2                        ((uint32_t)0x00004000U) /* Bit 2 */
#define TIM_INSEL_TI4S_3                        ((uint32_t)0x00008000U) /* Bit 3 */

#define TIM_INSEL_ETRS                          ((uint32_t)0x000F0000U) /* etr signal selection */
#define TIM_INSEL_ETRS_0                        ((uint32_t)0x00010000U) /* Bit 0 */
#define TIM_INSEL_ETRS_1                        ((uint32_t)0x00020000U) /* Bit 1 */
#define TIM_INSEL_ETRS_2                        ((uint32_t)0x00040000U) /* Bit 2 */
#define TIM_INSEL_ETRS_3                        ((uint32_t)0x00080000U) /* Bit 3 */

#define TIM_INSEL_ITRS                          ((uint32_t)0x00F00000U) /* itr signal selection */
#define TIM_INSEL_ITRS_0                        ((uint32_t)0x00100000U) /* Bit 0 */
#define TIM_INSEL_ITRS_1                        ((uint32_t)0x00200000U) /* Bit 1 */
#define TIM_INSEL_ITRS_2                        ((uint32_t)0x00400000U) /* Bit 2 */
#define TIM_INSEL_ITRS_3                        ((uint32_t)0x00800000U) /* Bit 3 */

#define TIM_INSEL_CLRS                          ((uint32_t)0x0F000000U) /* Ocrefclear signal selection */
#define TIM_INSEL_CLRS_0                        ((uint32_t)0x01000000U) /* Bit 0 */
#define TIM_INSEL_CLRS_1                        ((uint32_t)0x02000000U) /* Bit 1 */
#define TIM_INSEL_CLRS_2                        ((uint32_t)0x04000000U) /* Bit 2 */
#define TIM_INSEL_CLRS_3                        ((uint32_t)0x08000000U) /* Bit 3 */

/** Bit definition for TIM_AF1 register **/
#define TIM_AF1_IOMBRKEN                        ((uint32_t)0x00000001U) /* Enable IOM as break1 input */
#define TIM_AF1_COMP1BRKEN                      ((uint32_t)0x00000002U) /* Enable COMP1 as break1 input */
#define TIM_AF1_COMP2BRKEN                      ((uint32_t)0x00000004U) /* Enable COMP2 as break1 input */
#define TIM_AF1_COMP3BRKEN                      ((uint32_t)0x00000008U) /* Enable COMP3 as break1 input */
#define TIM_AF1_COMP4BRKEN                      ((uint32_t)0x00000010U) /* Enable COMP4 as break1 input */
#define TIM_AF1_COMP5BRKEN                      ((uint32_t)0x00000020U) /* Enable COMP5 as break1 input */
#define TIM_AF1_COMP6BRKEN                      ((uint32_t)0x00000040U) /* Enable COMP6 as break1 input */
#define TIM_AF1_COMP7BRKEN                      ((uint32_t)0x00000080U) /* Enable COMP7 as break1 input */

#define TIM_AF1_IOMBRKP                         ((uint32_t)0x00000200U) /* Select polarity of break1 input from IOM */
#define TIM_AF1_COMP1BRKP                       ((uint32_t)0x00000400U) /* Select polarity of break1 input from COMP1 */
#define TIM_AF1_COMP2BRKP                       ((uint32_t)0x00000800U) /* Select polarity of break1 input from COMP2 */
#define TIM_AF1_COMP3BRKP                       ((uint32_t)0x00001000U) /* Select polarity of break1 input from COMP3 */
#define TIM_AF1_COMP4BRKP                       ((uint32_t)0x00002000U) /* Select polarity of break1 input from COMP4 */

/** Bit definition for TIM_AF2 register **/
#define TIM_AF2_IOMBRK2EN                       ((uint32_t)0x00000001U) /* Enable IOM as break2 input */
#define TIM_AF2_COMP1BRK2EN                     ((uint32_t)0x00000002U) /* Enable COMP1 as break2 input */
#define TIM_AF2_COMP2BRK2EN                     ((uint32_t)0x00000004U) /* Enable COMP2 as break2 input */
#define TIM_AF2_COMP3BRK2EN                     ((uint32_t)0x00000008U) /* Enable COMP3 as break2 input */
#define TIM_AF2_COMP4BRK2EN                     ((uint32_t)0x00000010U) /* Enable COMP4 as break2 input */
#define TIM_AF2_COMP5BRK2EN                     ((uint32_t)0x00000020U) /* Enable COMP5 as break2 input */
#define TIM_AF2_COMP6BRK2EN                     ((uint32_t)0x00000040U) /* Enable COMP6 as break2 input */
#define TIM_AF2_COMP7BRK2EN                     ((uint32_t)0x00000080U) /* Enable COMP7 as break2 input */

#define TIM_AF2_IOMBRK2P                        ((uint32_t)0x00000200U) /* Select polarity of break2 input from IOM */
#define TIM_AF2_COMP1BRK2P                      ((uint32_t)0x00000400U) /* Select polarity of break2 input from COMP1 */
#define TIM_AF2_COMP2BRK2P                      ((uint32_t)0x00000800U) /* Select polarity of break2 input from COMP2 */
#define TIM_AF2_COMP3BRK2P                      ((uint32_t)0x00001000U) /* Select polarity of break2 input from COMP3 */
#define TIM_AF2_COMP4BRK2P                      ((uint32_t)0x00002000U) /* Select polarity of break2 input from COMP4 */

/** Bit definition for TIM_BKFR2 register **/
#define TIM_BKFR2_THRESH                        ((uint32_t)0x3F000000U) /* Break2 filter threshold */
#define TIM_BKFR2_THRESH_0                      ((uint32_t)0x01000000U) /* Bit 0 */
#define TIM_BKFR2_THRESH_1                      ((uint32_t)0x02000000U) /* Bit 1 */
#define TIM_BKFR2_THRESH_2                      ((uint32_t)0x04000000U) /* Bit 2 */
#define TIM_BKFR2_THRESH_3                      ((uint32_t)0x08000000U) /* Bit 3 */
#define TIM_BKFR2_THRESH_4                      ((uint32_t)0x10000000U) /* Bit 4 */
#define TIM_BKFR2_THRESH_5                      ((uint32_t)0x20000000U) /* Bit 5 */

#define TIM_BKFR2_WSIZE                         ((uint32_t)0x007E0000U)  /* Break2 filter window size */
#define TIM_BKFR2_WSIZE_0                       ((uint32_t)0x00020000U) /* Bit 0 */
#define TIM_BKFR2_WSIZE_1                       ((uint32_t)0x00040000U) /* Bit 1 */
#define TIM_BKFR2_WSIZE_2                       ((uint32_t)0x00080000U) /* Bit 2 */
#define TIM_BKFR2_WSIZE_3                       ((uint32_t)0x00100000U) /* Bit 3 */
#define TIM_BKFR2_WSIZE_4                       ((uint32_t)0x00200000U) /* Bit 4 */
#define TIM_BKFR2_WSIZE_5                       ((uint32_t)0x00400000U) /* Bit 5 */

#define TIM_BKFR2_FILTEN                        ((uint32_t)0x00010000U)

/** Bit definition for TIM_SLIDFPSC register **/
#define TIM_SLIDFPSC_SFPSC                      ((uint32_t)0x0000FFFFU)

/** Bit definition for TIM_DCTRL register **/
#define TIM_DCTRL_DBADDR                        ((uint32_t)0x00003F00U) /* DBA[5:0] bits (DMA Base Address) */
#define TIM_DCTRL_DBADDR_0                      ((uint32_t)0x00000100U) /* Bit 0 */
#define TIM_DCTRL_DBADDR_1                      ((uint32_t)0x00000200U) /* Bit 1 */
#define TIM_DCTRL_DBADDR_2                      ((uint32_t)0x00000400U) /* Bit 2 */
#define TIM_DCTRL_DBADDR_3                      ((uint32_t)0x00000800U) /* Bit 3 */
#define TIM_DCTRL_DBADDR_4                      ((uint32_t)0x00001000U) /* Bit 4 */
#define TIM_DCTRL_DBADDR_5                      ((uint32_t)0x00002000U) /* Bit 5 */

#define TIM_DCTRL_DBLEN                         ((uint32_t)0x0000003FU) /* DBL[5:0] bits (DMA Burst Length) */
#define TIM_DCTRL_DBLEN_0                       ((uint32_t)0x00000001U) /* Bit 0 */
#define TIM_DCTRL_DBLEN_1                       ((uint32_t)0x00000002U) /* Bit 1 */
#define TIM_DCTRL_DBLEN_2                       ((uint32_t)0x00000004U) /* Bit 2 */
#define TIM_DCTRL_DBLEN_3                       ((uint32_t)0x00000008U) /* Bit 3 */
#define TIM_DCTRL_DBLEN_4                       ((uint32_t)0x00000010U) /* Bit 4 */
#define TIM_DCTRL_DBLEN_5                       ((uint32_t)0x00000020U) /* Bit 5 */

/** Bit definition for TIM_DADDR register **/
#define TIM_DADDR_BURST                         ((uint32_t)0xFFFFFFFFU) /* DMA register for burst accesses */


/*** Real-Time Clock (RTC) ***/
/** Bits definition for RTC_INITSTS register **/
#define RTC_INITSTS_RECPF  ((uint32_t)0x00010000U)
#define RTC_INITSTS_TAM3F  ((uint32_t)0x00008000U)
#define RTC_INITSTS_TAM2F  ((uint32_t)0x00004000U)
#define RTC_INITSTS_TAM1F  ((uint32_t)0x00002000U)
#define RTC_INITSTS_TISOVF ((uint32_t)0x00001000U)
#define RTC_INITSTS_TISF   ((uint32_t)0x00000800U)
#define RTC_INITSTS_WTF    ((uint32_t)0x00000400U)
#define RTC_INITSTS_ALBF   ((uint32_t)0x00000200U)
#define RTC_INITSTS_ALAF   ((uint32_t)0x00000100U)
#define RTC_INITSTS_INITM  ((uint32_t)0x00000080U)
#define RTC_INITSTS_INITF  ((uint32_t)0x00000040U)
#define RTC_INITSTS_RSYF   ((uint32_t)0x00000020U)
#define RTC_INITSTS_INITSF ((uint32_t)0x00000010U)
#define RTC_INITSTS_SHOPF  ((uint32_t)0x00000008U)
#define RTC_INITSTS_WTWF   ((uint32_t)0x00000004U)
#define RTC_INITSTS_ALBWF  ((uint32_t)0x00000002U)
#define RTC_INITSTS_ALAWF  ((uint32_t)0x00000001U)

/** Bits definition for RTC_CTRL register **/
#define RTC_CTRL_TAMPOE   ((uint32_t)0x02000000U)
#define RTC_CTRL_OUT2EN   ((uint32_t)0x01000000U)
#define RTC_CTRL_COEN     ((uint32_t)0x00800000U)
#define RTC_CTRL_OUTSEL   ((uint32_t)0x00600000U)
#define RTC_CTRL_OUTSEL_0 ((uint32_t)0x00200000U)
#define RTC_CTRL_OUTSEL_1 ((uint32_t)0x00400000U)
#define RTC_CTRL_OPOL     ((uint32_t)0x00100000U)
#define RTC_CTRL_CALOSEL  ((uint32_t)0x00080000U)
#define RTC_CTRL_BAKP     ((uint32_t)0x00040000U)
#define RTC_CTRL_SU1H     ((uint32_t)0x00020000U)
#define RTC_CTRL_AD1H     ((uint32_t)0x00010000U)
#define RTC_CTRL_TSIEN    ((uint32_t)0x00008000U)
#define RTC_CTRL_WTIEN    ((uint32_t)0x00004000U)
#define RTC_CTRL_ALBIEN   ((uint32_t)0x00002000U)
#define RTC_CTRL_ALAIEN   ((uint32_t)0x00001000U)
#define RTC_CTRL_TSEN     ((uint32_t)0x00000800U)
#define RTC_CTRL_WTEN     ((uint32_t)0x00000400U)
#define RTC_CTRL_ALBEN    ((uint32_t)0x00000200U)
#define RTC_CTRL_ALAEN    ((uint32_t)0x00000100U)

#define RTC_CTRL_HFMT      ((uint32_t)0x00000040U)
#define RTC_CTRL_BYPS      ((uint32_t)0x00000020U)
#define RTC_CTRL_REFCLKEN  ((uint32_t)0x00000010U)
#define RTC_CTRL_TEDGE     ((uint32_t)0x00000008U)
#define RTC_CTRL_WKUPSEL   ((uint32_t)0x00000007U)
#define RTC_CTRL_WKUPSEL_0 ((uint32_t)0x00000001U)
#define RTC_CTRL_WKUPSEL_1 ((uint32_t)0x00000002U)
#define RTC_CTRL_WKUPSEL_2 ((uint32_t)0x00000004U)

/** Bits definition for RTC_TSH register **/
#define RTC_TSH_APM        ((uint32_t)0x00400000U)
#define RTC_TSH_HOT        ((uint32_t)0x00300000U)
#define RTC_TSH_HOT_0      ((uint32_t)0x00100000U)
#define RTC_TSH_HOT_1      ((uint32_t)0x00200000U)
#define RTC_TSH_HOU        ((uint32_t)0x000F0000U)
#define RTC_TSH_HOU_0      ((uint32_t)0x00010000U)
#define RTC_TSH_HOU_1      ((uint32_t)0x00020000U)
#define RTC_TSH_HOU_2      ((uint32_t)0x00040000U)
#define RTC_TSH_HOU_3      ((uint32_t)0x00080000U)
#define RTC_TSH_MIT        ((uint32_t)0x00007000U)
#define RTC_TSH_MIT_0      ((uint32_t)0x00001000U)
#define RTC_TSH_MIT_1      ((uint32_t)0x00002000U)
#define RTC_TSH_MIT_2      ((uint32_t)0x00004000U)
#define RTC_TSH_MIU        ((uint32_t)0x00000F00U)
#define RTC_TSH_MIU_0      ((uint32_t)0x00000100U)
#define RTC_TSH_MIU_1      ((uint32_t)0x00000200U)
#define RTC_TSH_MIU_2      ((uint32_t)0x00000400U)
#define RTC_TSH_MIU_3      ((uint32_t)0x00000800U)
#define RTC_TSH_SCT        ((uint32_t)0x00000070U)
#define RTC_TSH_SCT_0      ((uint32_t)0x00000010U)
#define RTC_TSH_SCT_1      ((uint32_t)0x00000020U)
#define RTC_TSH_SCT_2      ((uint32_t)0x00000040U)
#define RTC_TSH_SCU        ((uint32_t)0x0000000FU)
#define RTC_TSH_SCU_0      ((uint32_t)0x00000001U)
#define RTC_TSH_SCU_1      ((uint32_t)0x00000002U)
#define RTC_TSH_SCU_2      ((uint32_t)0x00000004U)
#define RTC_TSH_SCU_3      ((uint32_t)0x00000008U)

/** Bits definition for RTC_DATE register **/
#define RTC_DATE_YRT       ((uint32_t)0x00F00000U)
#define RTC_DATE_YRT_0     ((uint32_t)0x00100000U)
#define RTC_DATE_YRT_1     ((uint32_t)0x00200000U)
#define RTC_DATE_YRT_2     ((uint32_t)0x00400000U)
#define RTC_DATE_YRT_3     ((uint32_t)0x00800000U)
#define RTC_DATE_YRU       ((uint32_t)0x000F0000U)
#define RTC_DATE_YRU_0     ((uint32_t)0x00010000U)
#define RTC_DATE_YRU_1     ((uint32_t)0x00020000U)
#define RTC_DATE_YRU_2     ((uint32_t)0x00040000U)
#define RTC_DATE_YRU_3     ((uint32_t)0x00080000U)
#define RTC_DATE_WDU       ((uint32_t)0x0000E000U)
#define RTC_DATE_WDU_0     ((uint32_t)0x00002000U)
#define RTC_DATE_WDU_1     ((uint32_t)0x00004000U)
#define RTC_DATE_WDU_2     ((uint32_t)0x00008000U)
#define RTC_DATE_MOT       ((uint32_t)0x00001000U)
#define RTC_DATE_MOU       ((uint32_t)0x00000F00U)
#define RTC_DATE_MOU_0     ((uint32_t)0x00000100U)
#define RTC_DATE_MOU_1     ((uint32_t)0x00000200U)
#define RTC_DATE_MOU_2     ((uint32_t)0x00000400U)
#define RTC_DATE_MOU_3     ((uint32_t)0x00000800U)
#define RTC_DATE_DAT       ((uint32_t)0x00000030U)
#define RTC_DATE_DAT_0     ((uint32_t)0x00000010U)
#define RTC_DATE_DAT_1     ((uint32_t)0x00000020U)
#define RTC_DATE_DAU       ((uint32_t)0x0000000FU)
#define RTC_DATE_DAU_0     ((uint32_t)0x00000001U)
#define RTC_DATE_DAU_1     ((uint32_t)0x00000002U)
#define RTC_DATE_DAU_2     ((uint32_t)0x00000004U)
#define RTC_DATE_DAU_3     ((uint32_t)0x00000008U)

/** Bits definition for RTC_WRP register **/
#define RTC_WRP_PKEY      ((uint32_t)0x000000FFU)

/** Bits definition for RTC_SCTRL register **/
#define RTC_SCTRL_AD1S    ((uint32_t)0x80000000U)
#define RTC_SCTRL_SUBF    ((uint32_t)0x00007FFFU)

/** Bits definition for RTC_SUBS register **/
#define RTC_SUBS_SS       ((uint32_t)0x0000FFFFU)

/** Bits definition for RTC_TST register **/
#define RTC_TST_APM       ((uint32_t)0x00400000U)
#define RTC_TST_HOT       ((uint32_t)0x00300000U)
#define RTC_TST_HOT_0     ((uint32_t)0x00100000U)
#define RTC_TST_HOT_1     ((uint32_t)0x00200000U)
#define RTC_TST_HOU       ((uint32_t)0x000F0000U)
#define RTC_TST_HOU_0     ((uint32_t)0x00010000U)
#define RTC_TST_HOU_1     ((uint32_t)0x00020000U)
#define RTC_TST_HOU_2     ((uint32_t)0x00040000U)
#define RTC_TST_HOU_3     ((uint32_t)0x00080000U)
#define RTC_TST_MIT       ((uint32_t)0x00007000U)
#define RTC_TST_MIT_0     ((uint32_t)0x00001000U)
#define RTC_TST_MIT_1     ((uint32_t)0x00002000U)
#define RTC_TST_MIT_2     ((uint32_t)0x00004000U)
#define RTC_TST_MIU       ((uint32_t)0x00000F00U)
#define RTC_TST_MIU_0     ((uint32_t)0x00000100U)
#define RTC_TST_MIU_1     ((uint32_t)0x00000200U)
#define RTC_TST_MIU_2     ((uint32_t)0x00000400U)
#define RTC_TST_MIU_3     ((uint32_t)0x00000800U)
#define RTC_TST_SET       ((uint32_t)0x00000070U)
#define RTC_TST_SET_0     ((uint32_t)0x00000010U)
#define RTC_TST_SET_1     ((uint32_t)0x00000020U)
#define RTC_TST_SET_2     ((uint32_t)0x00000040U)
#define RTC_TST_SEU       ((uint32_t)0x0000000FU)
#define RTC_TST_SEU_0     ((uint32_t)0x00000001U)
#define RTC_TST_SEU_1     ((uint32_t)0x00000002U)
#define RTC_TST_SEU_2     ((uint32_t)0x00000004U)
#define RTC_TST_SEU_3     ((uint32_t)0x00000008U)

/** Bits definition for RTC_ALARMA register **/
#define RTC_ALARMA_MASK4  ((uint32_t)0x80000000U)
#define RTC_ALARMA_WKDSEL ((uint32_t)0x40000000U)
#define RTC_ALARMA_DTT    ((uint32_t)0x30000000U)
#define RTC_ALARMA_DTT_0  ((uint32_t)0x10000000U)
#define RTC_ALARMA_DTT_1  ((uint32_t)0x20000000U)
#define RTC_ALARMA_DTU    ((uint32_t)0x0F000000U)
#define RTC_ALARMA_DTU_0  ((uint32_t)0x01000000U)
#define RTC_ALARMA_DTU_1  ((uint32_t)0x02000000U)
#define RTC_ALARMA_DTU_2  ((uint32_t)0x04000000U)
#define RTC_ALARMA_DTU_3  ((uint32_t)0x08000000U)
#define RTC_ALARMA_MASK3  ((uint32_t)0x00800000U)
#define RTC_ALARMA_APM    ((uint32_t)0x00400000U)
#define RTC_ALARMA_HOT    ((uint32_t)0x00300000U)
#define RTC_ALARMA_HOT_0  ((uint32_t)0x00100000U)
#define RTC_ALARMA_HOT_1  ((uint32_t)0x00200000U)
#define RTC_ALARMA_HOU    ((uint32_t)0x000F0000U)
#define RTC_ALARMA_HOU_0  ((uint32_t)0x00010000U)
#define RTC_ALARMA_HOU_1  ((uint32_t)0x00020000U)
#define RTC_ALARMA_HOU_2  ((uint32_t)0x00040000U)
#define RTC_ALARMA_HOU_3  ((uint32_t)0x00080000U)
#define RTC_ALARMA_MASK2  ((uint32_t)0x00008000U)
#define RTC_ALARMA_MIT    ((uint32_t)0x00007000U)
#define RTC_ALARMA_MIT_0  ((uint32_t)0x00001000U)
#define RTC_ALARMA_MIT_1  ((uint32_t)0x00002000U)
#define RTC_ALARMA_MIT_2  ((uint32_t)0x00004000U)
#define RTC_ALARMA_MIU    ((uint32_t)0x00000F00U)
#define RTC_ALARMA_MIU_0  ((uint32_t)0x00000100U)
#define RTC_ALARMA_MIU_1  ((uint32_t)0x00000200U)
#define RTC_ALARMA_MIU_2  ((uint32_t)0x00000400U)
#define RTC_ALARMA_MIU_3  ((uint32_t)0x00000800U)
#define RTC_ALARMA_MASK1  ((uint32_t)0x00000080U)
#define RTC_ALARMA_SET    ((uint32_t)0x00000070U)
#define RTC_ALARMA_SET_0  ((uint32_t)0x00000010U)
#define RTC_ALARMA_SET_1  ((uint32_t)0x00000020U)
#define RTC_ALARMA_SET_2  ((uint32_t)0x00000040U)
#define RTC_ALARMA_SEU    ((uint32_t)0x0000000FU)
#define RTC_ALARMA_SEU_0  ((uint32_t)0x00000001U)
#define RTC_ALARMA_SEU_1  ((uint32_t)0x00000002U)
#define RTC_ALARMA_SEU_2  ((uint32_t)0x00000004U)
#define RTC_ALARMA_SEU_3  ((uint32_t)0x00000008U)

/** Bits definition for RTC_PRE register **/
#define RTC_PRE_DIVA      ((uint32_t)0x007F0000U)
#define RTC_PRE_DIVS      ((uint32_t)0x00007FFFU)

/** Bits definition for RTC_ALARMB register **/
#define RTC_ALARMB_MASK4  ((uint32_t)0x80000000U)
#define RTC_ALARMB_WKDSEL ((uint32_t)0x40000000U)
#define RTC_ALARMB_DTT    ((uint32_t)0x30000000U)
#define RTC_ALARMB_DTT_0  ((uint32_t)0x10000000U)
#define RTC_ALARMB_DTT_1  ((uint32_t)0x20000000U)
#define RTC_ALARMB_DTU    ((uint32_t)0x0F000000U)
#define RTC_ALARMB_DTU_0  ((uint32_t)0x01000000U)
#define RTC_ALARMB_DTU_1  ((uint32_t)0x02000000U)
#define RTC_ALARMB_DTU_2  ((uint32_t)0x04000000U)
#define RTC_ALARMB_DTU_3  ((uint32_t)0x08000000U)
#define RTC_ALARMB_MASK3  ((uint32_t)0x00800000U)
#define RTC_ALARMB_APM    ((uint32_t)0x00400000U)
#define RTC_ALARMB_HOT    ((uint32_t)0x00300000U)
#define RTC_ALARMB_HOT_0  ((uint32_t)0x00100000U)
#define RTC_ALARMB_HOT_1  ((uint32_t)0x00200000U)
#define RTC_ALARMB_HOU    ((uint32_t)0x000F0000U)
#define RTC_ALARMB_HOU_0  ((uint32_t)0x00010000U)
#define RTC_ALARMB_HOU_1  ((uint32_t)0x00020000U)
#define RTC_ALARMB_HOU_2  ((uint32_t)0x00040000U)
#define RTC_ALARMB_HOU_3  ((uint32_t)0x00080000U)
#define RTC_ALARMB_MASK2  ((uint32_t)0x00008000U)
#define RTC_ALARMB_MIT    ((uint32_t)0x00007000U)
#define RTC_ALARMB_MIT_0  ((uint32_t)0x00001000U)
#define RTC_ALARMB_MIT_1  ((uint32_t)0x00002000U)
#define RTC_ALARMB_MIT_2  ((uint32_t)0x00004000U)
#define RTC_ALARMB_MIU    ((uint32_t)0x00000F00U)
#define RTC_ALARMB_MIU_0  ((uint32_t)0x00000100U)
#define RTC_ALARMB_MIU_1  ((uint32_t)0x00000200U)
#define RTC_ALARMB_MIU_2  ((uint32_t)0x00000400U)
#define RTC_ALARMB_MIU_3  ((uint32_t)0x00000800U)
#define RTC_ALARMB_MASK1  ((uint32_t)0x00000080U)
#define RTC_ALARMB_SET    ((uint32_t)0x00000070U)
#define RTC_ALARMB_SET_0  ((uint32_t)0x00000010U)
#define RTC_ALARMB_SET_1  ((uint32_t)0x00000020U)
#define RTC_ALARMB_SET_2  ((uint32_t)0x00000040U)
#define RTC_ALARMB_SEU    ((uint32_t)0x0000000FU)
#define RTC_ALARMB_SEU_0  ((uint32_t)0x00000001U)
#define RTC_ALARMB_SEU_1  ((uint32_t)0x00000002U)
#define RTC_ALARMB_SEU_2  ((uint32_t)0x00000004U)
#define RTC_ALARMB_SEU_3  ((uint32_t)0x00000008U)

/** Bits definition for RTC_WKUPT register **/
#define RTC_WKUPT_WKUPT   ((uint32_t)0x0000FFFFU)

/** Bits definition for RTC_TMPCFG register **/
#define RTC_TMPCFG_TP3MF      ((uint32_t)0x08000000U)
#define RTC_TMPCFG_TP3NOE     ((uint32_t)0x04000000U)
#define RTC_TMPCFG_TP3INTEN   ((uint32_t)0x02000000U)
#define RTC_TMPCFG_TP2MF      ((uint32_t)0x01000000U)
#define RTC_TMPCFG_TP2NOE     ((uint32_t)0x00800000U)
#define RTC_TMPCFG_TP2INTEN   ((uint32_t)0x00400000U)
#define RTC_TMPCFG_TP1MF      ((uint32_t)0x00200000U)
#define RTC_TMPCFG_TP1NOE     ((uint32_t)0x00100000U)
#define RTC_TMPCFG_TP1INTEN   ((uint32_t)0x00080000U)

#define RTC_TMPCFG_TPPUDIS    ((uint32_t)0x00040000U)
#define RTC_TMPCFG_TPPRCH     ((uint32_t)0x00030000U)
#define RTC_TMPCFG_TPPRCH_0   ((uint32_t)0x00010000U)
#define RTC_TMPCFG_TPPRCH_1   ((uint32_t)0x00020000U)
#define RTC_TMPCFG_TPFLT      ((uint32_t)0x00003000U)
#define RTC_TMPCFG_TPFLT_0    ((uint32_t)0x00001000U)
#define RTC_TMPCFG_TPFLT_1    ((uint32_t)0x00002000U)

#define RTC_TMPCFG_TPFREQ     ((uint32_t)0x00000700U)
#define RTC_TMPCFG_TPFREQ_0   ((uint32_t)0x00000100U)
#define RTC_TMPCFG_TPFREQ_1   ((uint32_t)0x00000200U)
#define RTC_TMPCFG_TPFREQ_2   ((uint32_t)0x00000400U)
#define RTC_TMPCFG_TPTS       ((uint32_t)0x00000080U)
#define RTC_TMPCFG_TP3TRG     ((uint32_t)0x00000040U)
#define RTC_TMPCFG_TP3EN      ((uint32_t)0x00000020U)
#define RTC_TMPCFG_TP2TRG     ((uint32_t)0x00000010U)
#define RTC_TMPCFG_TP2EN      ((uint32_t)0x00000008U)
#define RTC_TMPCFG_TPINTEN    ((uint32_t)0x00000004U)
#define RTC_TMPCFG_TP1TRG     ((uint32_t)0x00000002U)
#define RTC_TMPCFG_TP1EN      ((uint32_t)0x00000001U)

/** Bits definition for RTC_ALRMASS register **/
#define RTC_ALRMASS_MASKSSB     ((uint32_t)0x000F0000U)
#define RTC_ALRMASS_MASKSSB_0   ((uint32_t)0x00010000U)
#define RTC_ALRMASS_MASKSSB_1   ((uint32_t)0x00020000U)
#define RTC_ALRMASS_MASKSSB_2   ((uint32_t)0x00040000U)
#define RTC_ALRMASS_MASKSSB_3   ((uint32_t)0x00080000U)
#define RTC_ALRMASS_SSV         ((uint32_t)0x00007FFFU)

/** Bits definition for RTC_OPT register **/
#define RTC_OPT_TYPE  ((uint32_t)0x00000001U)

/** Bits definition for RTC_ALRMBSS register **/
#define RTC_ALRMBSS_MASKSSB     ((uint32_t)0x000F0000U)
#define RTC_ALRMBSS_MASKSSB_0   ((uint32_t)0x00010000U)
#define RTC_ALRMBSS_MASKSSB_1   ((uint32_t)0x00020000U)
#define RTC_ALRMBSS_MASKSSB_2   ((uint32_t)0x00040000U)
#define RTC_ALRMBSS_MASKSSB_3   ((uint32_t)0x00080000U)
#define RTC_ALRMBSS_SSV         ((uint32_t)0x00007FFFU)

/** Bits definition for RTC_CALIB register **/
#define RTC_CALIB_CP    ((uint32_t)0x00000800U)
#define RTC_CALIB_CW8   ((uint32_t)0x00000400U)
#define RTC_CALIB_CW16  ((uint32_t)0x00000200U)
#define RTC_CALIB_CM    ((uint32_t)0x000001FFU)
#define RTC_CALIB_CM_0  ((uint32_t)0x00000001U)
#define RTC_CALIB_CM_1  ((uint32_t)0x00000002U)
#define RTC_CALIB_CM_2  ((uint32_t)0x00000004U)
#define RTC_CALIB_CM_3  ((uint32_t)0x00000008U)
#define RTC_CALIB_CM_4  ((uint32_t)0x00000010U)
#define RTC_CALIB_CM_5  ((uint32_t)0x00000020U)
#define RTC_CALIB_CM_6  ((uint32_t)0x00000040U)
#define RTC_CALIB_CM_7  ((uint32_t)0x00000080U)
#define RTC_CALIB_CM_8  ((uint32_t)0x00000100U)

/** Bits definition for RTC_TSSS register **/
#define RTC_TSSS_SSE ((uint32_t)0x0000FFFFU)

/** Bits definition for RTC_TSD register **/
#define RTC_TSD_MOT   ((uint32_t)0x00008000U)
#define RTC_TSD_WDU   ((uint32_t)0x00007000U)
#define RTC_TSD_WDU_0 ((uint32_t)0x00001000U)
#define RTC_TSD_WDU_1 ((uint32_t)0x00002000U)
#define RTC_TSD_WDU_2 ((uint32_t)0x00004000U)
#define RTC_TSD_MOU   ((uint32_t)0x00000F00U)
#define RTC_TSD_MOU_0 ((uint32_t)0x00000100U)
#define RTC_TSD_MOU_1 ((uint32_t)0x00000200U)
#define RTC_TSD_MOU_2 ((uint32_t)0x00000400U)
#define RTC_TSD_MOU_3 ((uint32_t)0x00000800U)
#define RTC_TSD_DAT   ((uint32_t)0x00000030U)
#define RTC_TSD_DAT_0 ((uint32_t)0x00000010U)
#define RTC_TSD_DAT_1 ((uint32_t)0x00000020U)
#define RTC_TSD_DAU   ((uint32_t)0x0000000FU)
#define RTC_TSD_DAU_0 ((uint32_t)0x00000001U)
#define RTC_TSD_DAU_1 ((uint32_t)0x00000002U)
#define RTC_TSD_DAU_2 ((uint32_t)0x00000004U)
#define RTC_TSD_DAU_3 ((uint32_t)0x00000008U)

#define RTC_BKP1      ((uint32_t)0xFFFFFFFFU)
#define RTC_BKP2      ((uint32_t)0xFFFFFFFFU)
#define RTC_BKP3      ((uint32_t)0xFFFFFFFFU)
#define RTC_BKP4      ((uint32_t)0xFFFFFFFFU)
#define RTC_BKP5      ((uint32_t)0xFFFFFFFFU)
#define RTC_BKP6      ((uint32_t)0xFFFFFFFFU)
#define RTC_BKP7      ((uint32_t)0xFFFFFFFFU)
#define RTC_BKP8      ((uint32_t)0xFFFFFFFFU)
#define RTC_BKP9      ((uint32_t)0xFFFFFFFFU)
#define RTC_BKP10     ((uint32_t)0xFFFFFFFFU)
#define RTC_BKP11     ((uint32_t)0xFFFFFFFFU)
#define RTC_BKP12     ((uint32_t)0xFFFFFFFFU)
#define RTC_BKP13     ((uint32_t)0xFFFFFFFFU)
#define RTC_BKP14     ((uint32_t)0xFFFFFFFFU)
#define RTC_BKP15     ((uint32_t)0xFFFFFFFFU)
#define RTC_BKP16     ((uint32_t)0xFFFFFFFFU)
#define RTC_BKP17     ((uint32_t)0xFFFFFFFFU)
#define RTC_BKP18     ((uint32_t)0xFFFFFFFFU)
#define RTC_BKP19     ((uint32_t)0xFFFFFFFFU)
#define RTC_BKP20     ((uint32_t)0xFFFFFFFFU)


/*** Independent watchdog ***/

/** Bit definition for IWDG_KEY register **/
#define IWDG_KEY_KEYV     ((uint16_t)0xFFFFU) /* Key value (write only, read 0000h) */

/** Bit definition for IWDG_STS register **/
#define IWDG_STS_PVU      ((uint8_t)0x01U)    /* Watchdog prescaler value update */
#define IWDG_STS_CRVU     ((uint8_t)0x02U)    /* Watchdog counter reload value update */
#define IWDG_STS_FRZF     ((uint8_t)0x04U)    /* The freeze flag */

/** Bit definition for IWDG_PREDIV register **/
#define IWDG_PREDIV_PD    ((uint8_t)0x07U)    /* PD[2:0] (Prescaler divider) */
#define IWDG_PREDIV_PD0   ((uint8_t)0x01U)    /* Bit 0 */
#define IWDG_PREDIV_PD1   ((uint8_t)0x02U)    /* Bit 1 */
#define IWDG_PREDIV_PD2   ((uint8_t)0x04U)    /* Bit 2 */

/** Bit definition for IWDG_RELV register **/
#define IWDG_RELV_REL     ((uint16_t)0x0FFFU) /* Watchdog counter reload value */


/*** Window WATCHDOG ***/

/**  Bit definition for WWDG_CFG register **/
#define WWDG_CFG_W       ((uint32_t)0x00003FFFU) /* W[13:0] bits (14-bit window value) */
#define WWDG_CFG_W0      ((uint32_t)0x00000001U) /* Bit 0 */
#define WWDG_CFG_W1      ((uint32_t)0x00000002U) /* Bit 1 */
#define WWDG_CFG_W2      ((uint32_t)0x00000004U) /* Bit 2 */
#define WWDG_CFG_W3      ((uint32_t)0x00000008U) /* Bit 3 */
#define WWDG_CFG_W4      ((uint32_t)0x00000010U) /* Bit 4 */
#define WWDG_CFG_W5      ((uint32_t)0x00000020U) /* Bit 5 */
#define WWDG_CFG_W6      ((uint32_t)0x00000040U) /* Bit 6 */
#define WWDG_CFG_W7      ((uint32_t)0x00000080U) /* Bit 7  */
#define WWDG_CFG_W8      ((uint32_t)0x00000100U) /* Bit 8  */
#define WWDG_CFG_W9      ((uint32_t)0x00000200U) /* Bit 9  */
#define WWDG_CFG_W10     ((uint32_t)0x00000400U) /* Bit 10 */
#define WWDG_CFG_W11     ((uint32_t)0x00000800U) /* Bit 11 */
#define WWDG_CFG_W12     ((uint32_t)0x00001000U) /* Bit 12 */
#define WWDG_CFG_W13     ((uint32_t)0x00002000U) /* Bit 13 */

#define WWDG_CFG_TIMERB  ((uint32_t)0x0000C000U) /* WDGTB[1:0] bits (Timer Base) */
#define WWDG_CFG_TIMERB0 ((uint32_t)0x00004000U) /* Bit 0 */
#define WWDG_CFG_TIMERB1 ((uint32_t)0x00008000U) /* Bit 1 */

#define WWDG_CFG_EWINT   ((uint32_t)0x00010000U) /* Early Wakeup Interrupt */

/** Bit definition for WWDG_CTRL register **/
#define WWDG_CTRL_T      ((uint16_t)0x3FFFU)     /*T[13:0] bits(14-bit counter (MSB to LSB)) */
#define WWDG_CTRL_T0     ((uint16_t)0x0001U)     /* Bit 0  */
#define WWDG_CTRL_T1     ((uint16_t)0x0002U)     /* Bit 1  */
#define WWDG_CTRL_T2     ((uint16_t)0x0004U)     /* Bit 2  */
#define WWDG_CTRL_T3     ((uint16_t)0x0008U)     /* Bit 3  */
#define WWDG_CTRL_T4     ((uint16_t)0x0010U)     /* Bit 4  */
#define WWDG_CTRL_T5     ((uint16_t)0x0020U)     /* Bit 5  */
#define WWDG_CTRL_T6     ((uint16_t)0x0040U)     /* Bit 6  */
#define WWDG_CTRL_T7     ((uint16_t)0x0080U)     /* Bit 7  */
#define WWDG_CTRL_T8     ((uint16_t)0x0100U)     /* Bit 8  */
#define WWDG_CTRL_T9     ((uint16_t)0x0200U)     /* Bit 9  */
#define WWDG_CTRL_T10    ((uint16_t)0x0400U)     /* Bit 10 */
#define WWDG_CTRL_T11    ((uint16_t)0x0800U)     /* Bit 11 */
#define WWDG_CTRL_T12    ((uint16_t)0x1000U)     /* Bit 12 */
#define WWDG_CTRL_T13    ((uint16_t)0x2000U)     /* Bit 13 */

#define WWDG_CTRL_ACTB   ((uint16_t)0x4000U)     /* Activation bit */

/** Bit definition for WWDG_STS register **/
#define WWDG_STS_EWINTF  ((uint8_t)0x01U)        /* Early Wakeup Interrupt Flag */


/*** Flexible Extended Memory Controller  ***/

/** Bit definition for FEMC_SNCTRL1/2/3/4 register **/
#define FEMC_SNCTRL_NADVDIR               ((uint32_t)0x00080000U)    /* NADV signal polarity bit */
#define FEMC_SNCTRL_PGSIZE                ((uint32_t)0x00070000U)    /* CRAM page size */
#define FEMC_SNCTRL_PGSIZE_0              ((uint32_t)0x00010000U)    /* Bit 0 */
#define FEMC_SNCTRL_PGSIZE_1              ((uint32_t)0x00020000U)    /* Bit 1 */
#define FEMC_SNCTRL_PGSIZE_2              ((uint32_t)0x00040000U)    /* Bit 2 */
#define FEMC_SNCTRL_BURSTWREN             ((uint32_t)0x00008000U)    /* Write burst enable */
#define FEMC_SNCTRL_WCFG                  ((uint32_t)0x00004000U)    /* Wait timing configuration */
#define FEMC_SNCTRL_WAITDIR               ((uint32_t)0x00002000U)    /* Wait signal polarity bit */
#define FEMC_SNCTRL_WAITEN                ((uint32_t)0x00001000U)    /* Wait enable bit */
#define FEMC_SNCTRL_WRAPEN                ((uint32_t)0x00000800U)    /* Wrapped burst mode support */
#define FEMC_SNCTRL_BURSTEN               ((uint32_t)0x00000400U)    /* Burst enable bit */
#define FEMC_SNCTRL_MUXEN                 ((uint32_t)0x00000200U)    /* Address/data multiplexing enable bit */
#define FEMC_SNCTRL_WAITASYNC             ((uint32_t)0x00000100U)    /* Asynchronous wait */
#define FEMC_SNCTRL_EXTEN                 ((uint32_t)0x00000080U)    /* Extended mode enable */
#define FEMC_SNCTRL_ACCEN                 ((uint32_t)0x00000040U)    /* Flash access enable */
#define FEMC_SNCTRL_WREN                  ((uint32_t)0x00000020U)    /* Write enable bit */
#define FEMC_SNCTRL_MBEN                  ((uint32_t)0x00000010U)    /* Memory bank enable bit */
#define FEMC_SNCTRL_MDBW                  ((uint32_t)0x0000000CU)    /* MDBW[1:0] bits (Memory data bus width) */
#define FEMC_SNCTRL_MDBW_0                ((uint32_t)0x00000004U)    /* Bit 0 */
#define FEMC_SNCTRL_MDBW_1                ((uint32_t)0x00000008U)    /* Bit 1 */
#define FEMC_SNCTRL_MTYPE                 ((uint32_t)0x00000003U)    /* MTYPE[1:0] bits (Memory type) */
#define FEMC_SNCTRL_MTYPE_0               ((uint32_t)0x00000001U)    /* Bit 0 */
#define FEMC_SNCTRL_MTYPE_1               ((uint32_t)0x00000002U)    /* Bit 1 */

/** Bit definition for FEMC_SNTCFG1/2/3/4 register **/
#define FEMC_SNTCFG_ACCMODE               ((uint32_t)0x30000000U) /* ACCMODE[1:0] bits (Access mode) */
#define FEMC_SNTCFG_ACCMODE_0             ((uint32_t)0x20000000U) /* Bit 0 */
#define FEMC_SNTCFG_ACCMODE_1             ((uint32_t)0x10000000U) /* Bit 1 */
#define FEMC_SNTCFG_CLKDIV                ((uint32_t)0x0F000000U) /* CLKDIV[3:0] bits (Clock divide ratio) */
#define FEMC_SNTCFG_CLKDIV_0              ((uint32_t)0x01000000U) /* Bit 0 */
#define FEMC_SNTCFG_CLKDIV_1              ((uint32_t)0x02000000U) /* Bit 1 */
#define FEMC_SNTCFG_CLKDIV_2              ((uint32_t)0x04000000U) /* Bit 2 */
#define FEMC_SNTCFG_CLKDIV_3              ((uint32_t)0x08000000U) /* Bit 3 */
#define FEMC_SNTCFG_BUSRECOVERY           ((uint32_t)0x00F00000U) /* BUSTURN[3:0] bits (Bus turnaround phase duration) */
#define FEMC_SNTCFG_BUSRECOVERY_0         ((uint32_t)0x00100000U) /* Bit 0 */
#define FEMC_SNTCFG_BUSRECOVERY_1         ((uint32_t)0x00200000U) /* Bit 1 */
#define FEMC_SNTCFG_BUSRECOVERY_2         ((uint32_t)0x00400000U) /* Bit 2 */
#define FEMC_SNTCFG_BUSRECOVERY_3         ((uint32_t)0x00800000U) /* Bit 3 */

#define FEMC_SNTCFG_DATAHLD               ((uint32_t)0x000F0000U) /* DATLA[3:0] bits (Data latency) */
#define FEMC_SNTCFG_DATAHLD_0             ((uint32_t)0x00010000U) /* Bit 0 */
#define FEMC_SNTCFG_DATAHLD_1             ((uint32_t)0x00020000U) /* Bit 1 */
#define FEMC_SNTCFG_DATAHLD_2             ((uint32_t)0x00040000U) /* Bit 2 */
#define FEMC_SNTCFG_DATAHLD_3             ((uint32_t)0x00080000U) /* Bit 3 */
#define FEMC_SNTCFG_DATABLD               ((uint32_t)0x0000FF00U) /* DATAST [7:0] bits (Data-phase duration) */
#define FEMC_SNTCFG_DATABLD_0             ((uint32_t)0x00000100U) /* Bit 0 */
#define FEMC_SNTCFG_DATABLD_1             ((uint32_t)0x00000200U) /* Bit 1 */
#define FEMC_SNTCFG_DATABLD_2             ((uint32_t)0x00000400U) /* Bit 2 */
#define FEMC_SNTCFG_DATABLD_3             ((uint32_t)0x00000800U) /* Bit 3 */
#define FEMC_SNTCFG_DATABLD_4             ((uint32_t)0x00001000U) /* Bit 4 */
#define FEMC_SNTCFG_DATABLD_5             ((uint32_t)0x00002000U) /* Bit 5 */
#define FEMC_SNTCFG_DATABLD_6             ((uint32_t)0x00004000U) /* Bit 6 */
#define FEMC_SNTCFG_DATABLD_7             ((uint32_t)0x00008000U) /* Bit 7 */

#define FEMC_SNTCFG_ADDHLD                ((uint32_t)0x000000F0U) /* ADDHLD[3:0] bits (Address-hold phase duration) */
#define FEMC_SNTCFG_ADDHLD_0              ((uint32_t)0x00000010U) /* Bit 0 */
#define FEMC_SNTCFG_ADDHLD_1              ((uint32_t)0x00000020U) /* Bit 1 */
#define FEMC_SNTCFG_ADDHLD_2              ((uint32_t)0x00000040U) /* Bit 2 */
#define FEMC_SNTCFG_ADDHLD_3              ((uint32_t)0x00000080U) /* Bit 3 */
#define FEMC_SNTCFG_ADDBLD                ((uint32_t)0x0000000FU) /* ADDBLD[3:0] bits (Address setup phase duration) */
#define FEMC_SNTCFG_ADDBLD_0              ((uint32_t)0x00000001U) /* Bit 0 */
#define FEMC_SNTCFG_ADDBLD_1              ((uint32_t)0x00000002U) /* Bit 1 */
#define FEMC_SNTCFG_ADDBLD_2              ((uint32_t)0x00000004U) /* Bit 2 */
#define FEMC_SNTCFG_ADDBLD_3              ((uint32_t)0x00000008U) /* Bit 3 */

/** Bit definition for FEMC_SNWTCFG1/2/3/4 register **/
#define FEMC_SNWTCFG_ACCMODE              ((uint32_t)0x30000000U) /* ACCMODE[1:0] bits (Access mode) */
#define FEMC_SNWTCFG_ACCMODE_0            ((uint32_t)0x20000000U) /* Bit 0 */
#define FEMC_SNWTCFG_ACCMODE_1            ((uint32_t)0x10000000U) /* Bit 1 */

#define FEMC_SNWTCFG_BUSRECOVERY          ((uint32_t)0x000F0000U) /* BUSTURN[3:0] bits (Bus turnaround phase duration) */
#define FEMC_SNWTCFG_BUSRECOVERY_0        ((uint32_t)0x00010000U) /* Bit 0 */
#define FEMC_SNWTCFG_BUSRECOVERY_1        ((uint32_t)0x00020000U) /* Bit 1 */
#define FEMC_SNWTCFG_BUSRECOVERY_2        ((uint32_t)0x00040000U) /* Bit 2 */
#define FEMC_SNWTCFG_BUSRECOVERY_3        ((uint32_t)0x00080000U) /* Bit 3 */

#define FEMC_SNWTCFG_DATABLD              ((uint32_t)0x0000FF00U) /* DATAST [7:0] bits (Data-phase duration) */
#define FEMC_SNWTCFG_DATABLD_0            ((uint32_t)0x00000100U) /* Bit 0 */
#define FEMC_SNWTCFG_DATABLD_1            ((uint32_t)0x00000200U) /* Bit 1 */
#define FEMC_SNWTCFG_DATABLD_2            ((uint32_t)0x00000400U) /* Bit 2 */
#define FEMC_SNWTCFG_DATABLD_3            ((uint32_t)0x00000800U) /* Bit 3 */
#define FEMC_SNWTCFG_DATABLD_4            ((uint32_t)0x00001000U) /* Bit 4 */
#define FEMC_SNWTCFG_DATABLD_5            ((uint32_t)0x00002000U) /* Bit 5 */
#define FEMC_SNWTCFG_DATABLD_6            ((uint32_t)0x00004000U) /* Bit 6 */
#define FEMC_SNWTCFG_DATABLD_7            ((uint32_t)0x00008000U) /* Bit 7 */

#define FEMC_SNWTCFG_ADDHLD               ((uint32_t)0x000000F0U) /* ADDHLD[3:0] bits (Address-hold phase duration) */
#define FEMC_SNWTCFG_ADDHLD_0             ((uint32_t)0x00000010U) /* Bit 0 */
#define FEMC_SNWTCFG_ADDHLD_1             ((uint32_t)0x00000020U) /* Bit 1 */
#define FEMC_SNWTCFG_ADDHLD_2             ((uint32_t)0x00000040U) /* Bit 2 */
#define FEMC_SNWTCFG_ADDHLD_3             ((uint32_t)0x00000080U) /* Bit 3 */
#define FEMC_SNWTCFG_ADDBLD               ((uint32_t)0x0000000FU) /* ADDBLD[3:0] bits (Address setup phase duration) */
#define FEMC_SNWTCFG_ADDBLD_0             ((uint32_t)0x00000001U) /* Bit 0 */
#define FEMC_SNWTCFG_ADDBLD_1             ((uint32_t)0x00000002U) /* Bit 1 */
#define FEMC_SNWTCFG_ADDBLD_2             ((uint32_t)0x00000004U) /* Bit 2 */
#define FEMC_SNWTCFG_ADDBLD_3             ((uint32_t)0x00000008U) /* Bit 3 */

/** Bit definition for FEMC_NCTRL2/3 register **/
#define FEMC_NCTRL_ECCPGS                 ((uint32_t)0x0001C000U) /* ECCPS[2:0] bits (ECC page size) */
#define FEMC_NCTRL_ECCPGS_0               ((uint32_t)0x00004000U) /* Bit 0 */
#define FEMC_NCTRL_ECCPGS_1               ((uint32_t)0x00008000U) /* Bit 1 */
#define FEMC_NCTRL_ECCPGS_2               ((uint32_t)0x00010000U) /* Bit 2 */
#define FEMC_NCTRL_ECCEN                  ((uint32_t)0x00002000U) /* ECC computation logic enable bit */

#define FEMC_NCTRL_ARDLY                  ((uint32_t)0x00001E00U) /* ARDLY[3:0] bits (ALE to RE delay) */
#define FEMC_NCTRL_ARDLY_0                ((uint32_t)0x00000200U) /* Bit 0 */
#define FEMC_NCTRL_ARDLY_1                ((uint32_t)0x00000400U) /* Bit 1 */
#define FEMC_NCTRL_ARDLY_2                ((uint32_t)0x00000800U) /* Bit 2 */
#define FEMC_NCTRL_ARDLY_3                ((uint32_t)0x00001000U) /* Bit 3 */
#define FEMC_NCTRL_CRDLY                  ((uint32_t)0x000001E0U) /* CRDLY[3:0] bits (CLE to RE delay) */
#define FEMC_NCTRL_CRDLY_0                ((uint32_t)0x00000020U) /* Bit 0 */
#define FEMC_NCTRL_CRDLY_1                ((uint32_t)0x00000040U) /* Bit 1 */
#define FEMC_NCTRL_CRDLY_2                ((uint32_t)0x00000080U) /* Bit 2 */
#define FEMC_NCTRL_CRDLY_3                ((uint32_t)0x00000100U) /* Bit 3 */
#define FEMC_NCTRL_WAITEN                 ((uint32_t)0x00000010U) /* Wait feature enable bit */
#define FEMC_NCTRL_BUSWID                 ((uint32_t)0x0000000CU) /* BUSWID[1:0] bits (NAND Flash databus width) */
#define FEMC_NCTRL_BUSWID_0               ((uint32_t)0x00000004U) /* Bit 0 */
#define FEMC_NCTRL_BUSWID_1               ((uint32_t)0x00000008U) /* Bit 1 */
#define FEMC_NCTRL_BANKEN                 ((uint32_t)0x00000001U) /* NAND Flash memory bank enable bit */

/** Bit definition for FEMC_NSTS2/3 register **/
#define FEMC_NSTS_FIFOEMPT                ((uint32_t)0x00000040U) /* DATFIFO empty */
#define FEMC_NSTS_IHLEN                   ((uint32_t)0x00000020U) /* High level detect interrupt enable */
#define FEMC_NSTS_IREEN                   ((uint32_t)0x00000010U) /* Rising edge detect interrupt enable */
#define FEMC_NSTS_IFEEN                   ((uint32_t)0x00000008U) /* Falling edge detect interrupt enable */
#define FEMC_NSTS_IHLF                    ((uint32_t)0x00000004U) /* High level detect interrupt flag */
#define FEMC_NSTS_IRLF                    ((uint32_t)0x00000002U) /* Rising edge detect interrupt flag */
#define FEMC_NSTS_IFEF                    ((uint32_t)0x00000001U) /* Falling edge detect interrupt flag */

/** Bit definition for FEMC_NCMEMTM2/3 register **/
#define FEMC_NCMEMTM_WAIT                 ((uint32_t)0xFF000000U) /* WAIT2[7:0] bits (Common memory 2 wait time) */
#define FEMC_NCMEMTM_WAIT_0               ((uint32_t)0x01000000U) /* Bit 0 */
#define FEMC_NCMEMTM_WAIT_1               ((uint32_t)0x02000000U) /* Bit 1 */
#define FEMC_NCMEMTM_WAIT_2               ((uint32_t)0x04000000U) /* Bit 2 */
#define FEMC_NCMEMTM_WAIT_3               ((uint32_t)0x08000000U) /* Bit 3 */
#define FEMC_NCMEMTM_WAIT_4               ((uint32_t)0x10000000U) /* Bit 4 */
#define FEMC_NCMEMTM_WAIT_5               ((uint32_t)0x20000000U) /* Bit 5 */
#define FEMC_NCMEMTM_WAIT_6               ((uint32_t)0x40000000U) /* Bit 6 */
#define FEMC_NCMEMTM_WAIT_7               ((uint32_t)0x80000000U) /* Bit 7 */
#define FEMC_NCMEMTM_SET                  ((uint32_t)0x00FF0000U) /* SET[7:0] bits (Common memory 2 setup time) */
#define FEMC_NCMEMTM_SET_0                ((uint32_t)0x00010000U) /* Bit 0 */
#define FEMC_NCMEMTM_SET_1                ((uint32_t)0x00020000U) /* Bit 1 */
#define FEMC_NCMEMTM_SET_2                ((uint32_t)0x00040000U) /* Bit 2 */
#define FEMC_NCMEMTM_SET_3                ((uint32_t)0x00080000U) /* Bit 3 */
#define FEMC_NCMEMTM_SET_4                ((uint32_t)0x00100000U) /* Bit 4 */
#define FEMC_NCMEMTM_SET_5                ((uint32_t)0x00200000U) /* Bit 5 */
#define FEMC_NCMEMTM_SET_6                ((uint32_t)0x00400000U) /* Bit 6 */
#define FEMC_NCMEMTM_SET_7                ((uint32_t)0x00800000U) /* Bit 7 */

#define FEMC_NCMEMTM_HIZ                  ((uint32_t)0x0000FF00U) /* HIZ[7:0] bits (Common memory 2 databus HiZ time) */
#define FEMC_NCMEMTM_HIZ_0                ((uint32_t)0x00000100U) /* Bit 0 */
#define FEMC_NCMEMTM_HIZ_1                ((uint32_t)0x00000200U) /* Bit 1 */
#define FEMC_NCMEMTM_HIZ_2                ((uint32_t)0x00000400U) /* Bit 2 */
#define FEMC_NCMEMTM_HIZ_3                ((uint32_t)0x00000800U) /* Bit 3 */
#define FEMC_NCMEMTM_HIZ_4                ((uint32_t)0x00001000U) /* Bit 4 */
#define FEMC_NCMEMTM_HIZ_5                ((uint32_t)0x00002000U) /* Bit 5 */
#define FEMC_NCMEMTM_HIZ_6                ((uint32_t)0x00004000U) /* Bit 6 */
#define FEMC_NCMEMTM_HIZ_7                ((uint32_t)0x00008000U) /* Bit 7 */
#define FEMC_NCMEMTM_HLD                  ((uint32_t)0x000000FFU) /* HOLD2[7:0] bits (Common memory 2 hold time) */
#define FEMC_NCMEMTM_HLD_0                ((uint32_t)0x00000001U) /* Bit 0 */
#define FEMC_NCMEMTM_HLD_1                ((uint32_t)0x00000002U) /* Bit 1 */
#define FEMC_NCMEMTM_HLD_2                ((uint32_t)0x00000004U) /* Bit 2 */
#define FEMC_NCMEMTM_HLD_3                ((uint32_t)0x00000008U) /* Bit 3 */
#define FEMC_NCMEMTM_HLD_4                ((uint32_t)0x00000010U) /* Bit 4 */
#define FEMC_NCMEMTM_HLD_5                ((uint32_t)0x00000020U) /* Bit 5 */
#define FEMC_NCMEMTM_HLD_6                ((uint32_t)0x00000040U) /* Bit 6 */
#define FEMC_NCMEMTM_HLD_7                ((uint32_t)0x00000080U) /* Bit 7 */

/** Bit definition for FEMC_NATTMEMTM2/3 register **/
#define FEMC_NATTMEMTM_WAIT               ((uint32_t)0xFF000000U) /* WAIT2[7:0] bits (Common memory 2 wait time) */
#define FEMC_NATTMEMTM_WAIT_0             ((uint32_t)0x01000000U) /* Bit 0 */
#define FEMC_NATTMEMTM_WAIT_1             ((uint32_t)0x02000000U) /* Bit 1 */
#define FEMC_NATTMEMTM_WAIT_2             ((uint32_t)0x04000000U) /* Bit 2 */
#define FEMC_NATTMEMTM_WAIT_3             ((uint32_t)0x08000000U) /* Bit 3 */
#define FEMC_NATTMEMTM_WAIT_4             ((uint32_t)0x10000000U) /* Bit 4 */
#define FEMC_NATTMEMTM_WAIT_5             ((uint32_t)0x20000000U) /* Bit 5 */
#define FEMC_NATTMEMTM_WAIT_6             ((uint32_t)0x40000000U) /* Bit 6 */
#define FEMC_NATTMEMTM_WAIT_7             ((uint32_t)0x80000000U) /* Bit 7 */
#define FEMC_NATTMEMTM_SET                ((uint32_t)0x00FF0000U) /* SET[7:0] bits (Common memory 2 setup time) */
#define FEMC_NATTMEMTM_SET_0              ((uint32_t)0x00010000U) /* Bit 0 */
#define FEMC_NATTMEMTM_SET_1              ((uint32_t)0x00020000U) /* Bit 1 */
#define FEMC_NATTMEMTM_SET_2              ((uint32_t)0x00040000U) /* Bit 2 */
#define FEMC_NATTMEMTM_SET_3              ((uint32_t)0x00080000U) /* Bit 3 */
#define FEMC_NATTMEMTM_SET_4              ((uint32_t)0x00100000U) /* Bit 4 */
#define FEMC_NATTMEMTM_SET_5              ((uint32_t)0x00200000U) /* Bit 5 */
#define FEMC_NATTMEMTM_SET_6              ((uint32_t)0x00400000U) /* Bit 6 */
#define FEMC_NATTMEMTM_SET_7              ((uint32_t)0x00800000U) /* Bit 7 */

#define FEMC_NATTMEMTM_HIZ                ((uint32_t)0x0000FF00U) /* HIZ[7:0] bits (Common memory 2 databus HiZ time) */
#define FEMC_NATTMEMTM_HIZ_0              ((uint32_t)0x00000100U) /* Bit 0 */
#define FEMC_NATTMEMTM_HIZ_1              ((uint32_t)0x00000200U) /* Bit 1 */
#define FEMC_NATTMEMTM_HIZ_2              ((uint32_t)0x00000400U) /* Bit 2 */
#define FEMC_NATTMEMTM_HIZ_3              ((uint32_t)0x00000800U) /* Bit 3 */
#define FEMC_NATTMEMTM_HIZ_4              ((uint32_t)0x00001000U) /* Bit 4 */
#define FEMC_NATTMEMTM_HIZ_5              ((uint32_t)0x00002000U) /* Bit 5 */
#define FEMC_NATTMEMTM_HIZ_6              ((uint32_t)0x00004000U) /* Bit 6 */
#define FEMC_NATTMEMTM_HIZ_7              ((uint32_t)0x00008000U) /* Bit 7 */
#define FEMC_NATTMEMTM_HLD                ((uint32_t)0x000000FFU) /* HOLD2[7:0] bits (Common memory 2 hold time) */
#define FEMC_NATTMEMTM_HLD_0              ((uint32_t)0x00000001U) /* Bit 0 */
#define FEMC_NATTMEMTM_HLD_1              ((uint32_t)0x00000002U) /* Bit 1 */
#define FEMC_NATTMEMTM_HLD_2              ((uint32_t)0x00000004U) /* Bit 2 */
#define FEMC_NATTMEMTM_HLD_3              ((uint32_t)0x00000008U) /* Bit 3 */
#define FEMC_NATTMEMTM_HLD_4              ((uint32_t)0x00000010U) /* Bit 4 */
#define FEMC_NATTMEMTM_HLD_5              ((uint32_t)0x00000020U) /* Bit 5 */
#define FEMC_NATTMEMTM_HLD_6              ((uint32_t)0x00000040U) /* Bit 6 */
#define FEMC_NATTMEMTM_HLD_7              ((uint32_t)0x00000080U) /* Bit 7 */

/** Bit definition for FEMC_ECC2/3 register **/
#define FEMC_ECC_ECC                      ((uint32_t)0xFFFFFFFFU)
#define FEMC_ECC_PAGE_256BYTE_MASK        ((uint32_t)0x003FFFFFU)
#define FEMC_ECC_PAGE_512BYTE_MASK        ((uint32_t)0x00FFFFFFU)
#define FEMC_ECC_PBAE_1024BYTE_MASK       ((uint32_t)0x03FFFFFFU)
#define FEMC_ECC_PBAE_2048BYTE_MASK       ((uint32_t)0x0FFFFFFFU)
#define FEMC_ECC_PBAE_4096BYTE_MASK       ((uint32_t)0x3FFFFFFFU)
#define FEMC_ECC_PBAE_8192BYTE_MASK       ((uint32_t)0xFFFFFFFFU)

/******************************************************************************/
/*                                                                            */
/*                    Filter Mathematical ACcelerator unit (FMAC)                      */
/*                                                                            */
/******************************************************************************/

/*****************  Bit definition for FMAC_X1BUFCFG register  ****************/
#define FMAC_X1BUFCFG_X1BASE          ((uint32_t)0x000000FF)                /* Base address of X1 buffer */
#define FMAC_X1BUFCFG_X1BUFSIZE       ((uint32_t)0x0000FF00)                /* Allocated size of X1 buffer in 16-bit words */
#define FMAC_X1BUFCFG_X1BUFWM         ((uint32_t)0x03000000)                /* Watermark for buffer full flag */
#define FMAC_X1BUFCFG_X1BUFWM_0       ((uint32_t)0x01000000U)               /* Bit 0 */
#define FMAC_X1BUFCFG_X1BUFWM_1       ((uint32_t)0x02000000U)               /* Bit 1 */
/*****************  Bit definition for FMAC_X2BUFCFG register  ************/
#define FMAC_X2BUFCFG_X2BASE          ((uint32_t)0x000000FF)                /* Base address of X2 buffer */
#define FMAC_X2BUFCFG_X2BUFSIZE       ((uint32_t)0x0000FF00)                /* Size of X2 buffer in 16-bit words */
/*****************  Bit definition for FMAC_YBUFCFG register  *************/
#define FMAC_YBUFCFG_YBASE            ((uint32_t)0x000000FF)                /* Base address of Y buffer */
#define FMAC_YBUFCFG_YBUFSIZE         ((uint32_t)0x0000FF00)                /* Size of Y buffer in 16-bit words */
#define FMAC_YBUFCFG_YBUFWM           ((uint32_t)0x03000000)                /* Watermark for buffer empty flag */
#define FMAC_YBUFCFG_YBUFWM_0         ((uint32_t)0x01000000U)               /* Bit 0 */
#define FMAC_YBUFCFG_YBUFWM_1         ((uint32_t)0x02000000U)               /* Bit 1 */

/******************  Bit definition for FMAC_PARAMCFG register  **************/
#define FMAC_PARAMCFG_P               ((uint32_t)0x000000FF)                /* Input parameter P */
#define FMAC_PARAMCFG_Q               ((uint32_t)0x0000FF00)                /* Input parameter Q */
#define FMAC_PARAMCFG_R               ((uint32_t)0x00FF0000)                /* Input parameter R */
#define FMAC_PARAMCFG_FUNC            ((uint32_t)0x7F000000)                /* Function */
#define FMAC_PARAMCFG_START           ((uint32_t)0x80000000)                /* Enable execution */
/******************** Bit definition for FMAC_CTRL register  ***************/
#define FMAC_CTRL_RINTEN              ((uint32_t)0x00000001)                /* Enable read interrupt */
#define FMAC_CTRL_WIINEN              ((uint32_t)0x00000002)                /* Enable write interrupt */
#define FMAC_CTRL_OVINTEN             ((uint32_t)0x00000004)                /* Enable overflow error interrupts */
#define FMAC_CTRL_UNINTEN             ((uint32_t)0x00000008)                /* Enable underflow error interrupts */
#define FMAC_CTRL_SATINTEN            ((uint32_t)0x00000010)                /* Enable saturation error interrupts */
#define FMAC_CTRL_DMAREN              ((uint32_t)0x00000100)                /* Enable DMA read channel requests */
#define FMAC_CTRL_DMAWEN              ((uint32_t)0x00000200)                /* Enable DMA write channel requests */
#define FMAC_CTRL_LIMITEN             ((uint32_t)0x00008000)                /* Enable limit */
#define FMAC_CTRL_RESET               ((uint32_t)0x00010000)                /* Reset filter mathematical accelerator unit */
/******************* Bit definition for FMAC_STS register  ****************/
#define FMAC_STS_YBUFEF               ((uint32_t)0x00000001)                /* Y buffer empty flag */
#define FMAC_STS_X1BUFFF              ((uint32_t)0x00000002)                /* X1 buffer full flag */
#define FMAC_STS_OVF                  ((uint32_t)0x00000100)                /* Overflow error flag */
#define FMAC_STS_UNF                  ((uint32_t)0x00000200)                /* Underflow error flag */
#define FMAC_STS_SATF                 ((uint32_t)0x00000400)                /* Saturation error flag */
/******************  Bit definition for FMAC_WDAT register  **************/
#define FMAC_WDAT_WDAT                ((uint32_t)0x0000FFFF)                /* Write data */
/******************  Bit definition for FMACX_RDAT register  *************/
#define FMAC_RDAT_RDAT                ((uint32_t)0x0000FFFF)                /* Read data */


/*** CORDIC ***/

/** Bit definition for CORDIC_CTRLSTS register **/
#define CORDIC_CTRLSTS_FUNC             ((uint32_t)0x0000000FU) /* FUNC[3:0]: Function */
#define CORDIC_CTRLSTS_FUNC_0           ((uint32_t)0x00000001U) /* FUNC bit 0 */
#define CORDIC_CTRLSTS_FUNC_1           ((uint32_t)0x00000002U) /* FUNC bit 1 */
#define CORDIC_CTRLSTS_FUNC_2           ((uint32_t)0x00000004U) /* FUNC bit 2 */
#define CORDIC_CTRLSTS_FUNC_3           ((uint32_t)0x00000008U) /* FUNC bit 3 */
#define CORDIC_CTRLSTS_PRECISION        ((uint32_t)0x000000F0U) /* Precision required (number of iterations) */
#define CORDIC_CTRLSTS_PRECISION_0      ((uint32_t)0x00000010U) /* PRECISION bit 0 */
#define CORDIC_CTRLSTS_PRECISION_1      ((uint32_t)0x00000020U) /* PRECISION bit 1 */
#define CORDIC_CTRLSTS_PRECISION_2      ((uint32_t)0x00000040U) /* PRECISION bit 2 */
#define CORDIC_CTRLSTS_PRECISION_3      ((uint32_t)0x00000080U) /* PRECISION bit 3 */
#define CORDIC_CTRLSTS_SCALE            ((uint32_t)0x00000700U) /* SCALE[2:0]: Scaling factor */
#define CORDIC_CTRLSTS_SCALE_0          ((uint32_t)0x00000100U) /* SCALE bit 0 */
#define CORDIC_CTRLSTS_SCALE_1          ((uint32_t)0x00000200U) /* SCALE bit 1 */
#define CORDIC_CTRLSTS_SCALE_2          ((uint32_t)0x00000400U) /* SCALE bit 2 */
#define CORDIC_CTRLSTS_INTEN            ((uint32_t)0x00010000U) /* Interrupt Enable */
#define CORDIC_CTRLSTS_DMAREN           ((uint32_t)0x00020000U) /* DMA read Enable */
#define CORDIC_CTRLSTS_DMAWEN           ((uint32_t)0x00040000U) /* DMA write Enable */
#define CORDIC_CTRLSTS_NUMREAD          ((uint32_t)0x00080000U) /* Number of results in the CORDIC_RDATA register */
#define CORDIC_CTRLSTS_NUMWRITE         ((uint32_t)0x00100000U) /* Number of arguments expected by the CORDIC_WDATA register */
#define CORDIC_CTRLSTS_OUTSIZE          ((uint32_t)0x00200000U) /* Size of output data */
#define CORDIC_CTRLSTS_INSIZE           ((uint32_t)0x00400000U) /* Size of input data */
#define CORDIC_CTRLSTS_FLOATIN          ((uint32_t)0x00800000U) /* Floating-point fixed-point input control */
#define CORDIC_CTRLSTS_FLOATOUT         ((uint32_t)0x01000000U) /* Floating-point fixed-point output control */
#define CORDIC_CTRLSTS_PHASELIMIT       ((uint32_t)0x02000000U) /* Phase Output Limit Control */
#define CORDIC_CTRLSTS_CODINLIMIT       ((uint32_t)0x04000000U) /* Coordinate output limit control */
#define CORDIC_CTRLSTS_INOVINTEN        ((uint32_t)0x08000000U) /* Input parameter overflow interrupt control bit */
#define CORDIC_CTRLSTS_INOVF            ((uint32_t)0x40000000U) /* Input parameter overflow flag */
#define CORDIC_CTRLSTS_RRF              ((uint32_t)0x80000000U) /* Result ready flag */

/** Bit definition for CORDIC_WDAT register **/
#define CORDIC_WDAT_WDAT                ((uint32_t)0xFFFFFFFFU) /* Write data */

/** Bit definition for CORDIC_RDAT register **/
#define CORDIC_RDAT_RDAT                ((uint32_t)0xFFFFFFFFU) /* Read data */

/*** Secure Digital Input and Output (SDIO) host interface ***/

/** Bit definition for SDIO_PWRCTRL register **/
#define SDIO_PWRCTRL_PWRCTRL        ((uint32_t)0x00000003U) /* PWRCTRL[1:0] bits (Power supply control bits) */
#define SDIO_PWRCTRL_PWRCTRL_0      ((uint32_t)0x00000001U) /* Bit 0 */
#define SDIO_PWRCTRL_PWRCTRL_1      ((uint32_t)0x00000002U) /* Bit 1 */

/******************  Bit definition for SDIO_CLKCTRL register  ******************/
#define SDIO_CLKCTRL_DIV            ((uint32_t)0x000001FFU) /* Clock divide factor */

#define SDIO_CLKCTRL_BUSMODE        ((uint32_t)0x00001800U) /* WIDBUS[1:0] bits (Wide bus mode enable bit) */
#define SDIO_CLKCTRL_BUSMODE_0      ((uint32_t)0x00000800U) /* Bit 0 */
#define SDIO_CLKCTRL_BUSMODE_1      ((uint32_t)0x00001000U) /* Bit 1 */

#define SDIO_CLKCTRL_CLOCKEN        ((uint32_t)0x00002000U) /* Clock enable bit */
#define SDIO_CLKCTRL_CLKBYP         ((uint32_t)0x00004000U) /* Clock divider bypass enable bit */
#define SDIO_CLKCTRL_PWRCFG         ((uint32_t)0x00008000U) /* Power saving configuration bit */
#define SDIO_CLKCTRL_CLKEDGE        ((uint32_t)0x00010000U) /* SDIO_CK dephasing selection bit */
#define SDIO_CLKCTRL_HWCLKEN        ((uint32_t)0x00020000U) /* HW Flow Control enable */

/*******************  Bit definition for SDIO_CMDARG register  *******************/
#define SDIO_CMDARG_CMDARG          ((uint32_t)0xFFFFFFFFU) /* Command argument */

/*******************  Bit definition for SDIO_CMDCTRL register  *******************/
#define SDIO_CMDCTRL_CPSMEN         ((uint32_t)0x00000001U) /* Command path state machine (CPSM) Enable bit */
#define SDIO_CMDCTRL_WDATEND        ((uint32_t)0x00000002U) /* CPSM Waits for ends of data transfer (CmdPend internal signal) */
#define SDIO_CMDCTRL_WINTREQ        ((uint32_t)0x00000004U) /* CPSM Waits for Interrupt Request */
#define SDIO_CMDCTRL_ENCMDF         ((uint32_t)0x00000008U) /* Enable CMDCTRL completion */
#define SDIO_CMDCTRL_SUSPEND        ((uint32_t)0x00000010U) /* SD I/O suspend command */
#define SDIO_CMDCTRL_CMDIDX         ((uint32_t)0x00003F00U) /* Command Index */
#define SDIO_CMDCTRL_CMDRESP        ((uint32_t)0x0000C000U) /* WAITRESP[1:0] bits (Wait for response bits) */
#define SDIO_CMDCTRL_CMDRESP_0      ((uint32_t)0x00004000U) /*  Bit 0 */
#define SDIO_CMDCTRL_CMDRESP_1      ((uint32_t)0x00008000U) /*  Bit 1 */

/*****************  Bit definition for SDIO_CMDRESP register  *****************/
#define SDIO_CMDRESP_RESPCMDIDX     ((uint32_t)0x0000003FU) /* Response command index */

/******************  Bit definition for SDIO_RESPONSE0 register  ******************/
#define SDIO_RESPONSE1_CARDSTS1     ((uint32_t)0xFFFFFFFFU) /* Card Status register 1 */

/******************  Bit definition for SDIO_RESPONSE1 register  ******************/
#define SDIO_RESPONSE2_CARDSTS2     ((uint32_t)0xFFFFFFFFU) /* Card Status register 2 */

/******************  Bit definition for SDIO_RESPONSE2 register  ******************/
#define SDIO_RESPONSE3_CARDSTS3     ((uint32_t)0xFFFFFFFFU) /* Card Status register 3 */

/******************  Bit definition for SDIO_RESPONSE3 register  ******************/
#define SDIO_RESPONSE4_CARDSTS4     ((uint32_t)0xFFFFFFFFU) /* Card Status register 4 */

/******************  Bit definition for SDIO_DTIMEER register  *****************/
#define SDIO_DTIMER_DATTIMEOUT      ((uint32_t)0xFFFFFFFFU) /* Data timeout period. */

/******************  Bit definition for SDIO_DATLEN register  *******************/
#define SDIO_DATLEN_DATLEN          ((uint32_t)0x01FFFFFFU) /* Data length value */

/******************  Bit definition for SDIO_DATCTRL register  ******************/
#define SDIO_DATCTRL_DATEN          ((uint32_t)0x00000001U) /* Data transfer enabled bit */
#define SDIO_DATCTRL_TRANSMOD       ((uint32_t)0x00000002U) /* Data transfer mode selection */
#define SDIO_DATCTRL_DATDIR         ((uint32_t)0x00000004U) /* Data transfer direction selection */
#define SDIO_DATCTRL_DMAEN          ((uint32_t)0x00000008U) /* DMA enabled bit */
#define SDIO_DATCTRL_RWAITEN        ((uint32_t)0x00000010U) /* Read wait start */
#define SDIO_DATCTRL_RWAITMOD       ((uint32_t)0x00000020U) /* Read wait mode */
#define SDIO_DATCTRL_RWAITSTOP      ((uint32_t)0x00000040U) /* Read wait stop */
#define SDIO_DATCTRL_SDIOEN         ((uint32_t)0x00000080U) /* SD I/O enable functions */

#define SDIO_DATCTRL_BLKSIZE        ((uint32_t)0x00000F00U) /* DBLOCKSIZE[3:0] bits (Data block size) */
#define SDIO_DATCTRL_BLKSIZE_1      ((uint32_t)0x00000000U) /* DBLOCKSIZE[3:0] = 1     */
#define SDIO_DATCTRL_BLKSIZE_2      ((uint32_t)0x00000100U) /* DBLOCKSIZE[3:0] = 2     */
#define SDIO_DATCTRL_BLKSIZE_4      ((uint32_t)0x00000200U) /* DBLOCKSIZE[3:0] = 4     */
#define SDIO_DATCTRL_BLKSIZE_8      ((uint32_t)0x00000300U) /* DBLOCKSIZE[3:0] = 8     */
#define SDIO_DATCTRL_BLKSIZE_16     ((uint32_t)0x00000400U) /* DBLOCKSIZE[3:0] = 16    */
#define SDIO_DATCTRL_BLKSIZE_32     ((uint32_t)0x00000500U) /* DBLOCKSIZE[3:0] = 32    */
#define SDIO_DATCTRL_BLKSIZE_64     ((uint32_t)0x00000600U) /* DBLOCKSIZE[3:0] = 64    */
#define SDIO_DATCTRL_BLKSIZE_128    ((uint32_t)0x00000700U) /* DBLOCKSIZE[3:0] = 128   */
#define SDIO_DATCTRL_BLKSIZE_256    ((uint32_t)0x00000800U) /* DBLOCKSIZE[3:0] = 256   */
#define SDIO_DATCTRL_BLKSIZE_512    ((uint32_t)0x00000900U) /* DBLOCKSIZE[3:0] = 512   */
#define SDIO_DATCTRL_BLKSIZE_1024   ((uint32_t)0x00000A00U) /* DBLOCKSIZE[3:0] = 1024  */
#define SDIO_DATCTRL_BLKSIZE_2048   ((uint32_t)0x00000B00U) /* DBLOCKSIZE[3:0] = 2048  */
#define SDIO_DATCTRL_BLKSIZE_4096   ((uint32_t)0x00000C00U) /* DBLOCKSIZE[3:0] = 4096  */
#define SDIO_DATCTRL_BLKSIZE_8192   ((uint32_t)0x00000D00U) /* DBLOCKSIZE[3:0] = 8192  */
#define SDIO_DATCTRL_BLKSIZE_16384  ((uint32_t)0x00000E00U) /* DBLOCKSIZE[3:0] = 16384 */

#define SDIO_DATCTRL_DMADIR         ((uint32_t)0x00001000U) /* DMA transfer direction selection */



/******************  Bit definition for SDIO_DATCOUNT register  *****************/
#define SDIO_DATCOUNT_DATCOUNT      ((uint32_t)0x01FFFFFFU) /* Data count value */

/******************  Bit definition for SDIO_STS register  ********************/
#define SDIO_STS_CCRCERR            ((uint32_t)0x00000001U) /* Command response received (CRC check failed) */
#define SDIO_STS_DCRCERR            ((uint32_t)0x00000002U) /* Data block sent/received (CRC check failed) */
#define SDIO_STS_CMDTIMEOUT         ((uint32_t)0x00000004U) /* Command response timeout */
#define SDIO_STS_DATTIMEOUT         ((uint32_t)0x00000008U) /* Data timeout */
#define SDIO_STS_TXURERR            ((uint32_t)0x00000010U) /* Transmit DATFIFO underrun error */
#define SDIO_STS_RXORERR            ((uint32_t)0x00000020U) /* Received DATFIFO overrun error */
#define SDIO_STS_CMDRESPRECV        ((uint32_t)0x00000040U) /* Command response received (CRC check passed) */
#define SDIO_STS_CMDSEND            ((uint32_t)0x00000080U) /* Command sent (no response required) */
#define SDIO_STS_DATEND             ((uint32_t)0x00000100U) /* Data end (data counter, SDIDCOUNT, is zero) */
#define SDIO_STS_SBERR              ((uint32_t)0x00000200U) /* Start bit not detected on all data signals in wide bus mode */
#define SDIO_STS_DATBLKEND          ((uint32_t)0x00000400U) /* Data block sent/received (CRC check passed) */
#define SDIO_STS_CMDRUN             ((uint32_t)0x00000800U) /* Command transfer in progress */
#define SDIO_STS_TXRUN              ((uint32_t)0x00001000U) /* Data transmit in progress */
#define SDIO_STS_RXRUN              ((uint32_t)0x00002000U) /* Data receive in progress */
#define SDIO_STS_TFIFOE             ((uint32_t)0x00004000U) /* Transmit DATFIFO empty */
#define SDIO_STS_TFIFOHE            ((uint32_t)0x00008000U) /* Transmit DATFIFO Half Empty: at least 8 words can be written into the DATFIFO */
#define SDIO_STS_TFIFOF             ((uint32_t)0x00010000U) /* Transmit DATFIFO full */
#define SDIO_STS_TDATVALID          ((uint32_t)0x00020000U) /* Data available in transmit DATFIFO */
#define SDIO_STS_RFIFOE             ((uint32_t)0x00040000U) /* Receive DATFIFO empty */
#define SDIO_STS_RFIFOHF            ((uint32_t)0x00080000U) /* Receive DATFIFO Half Full: there are at least 8 words in the DATFIFO */
#define SDIO_STS_RFIFOF             ((uint32_t)0x00100000U) /* Receive DATFIFO full */
#define SDIO_STS_RDATVALID          ((uint32_t)0x00200000U) /* Data available in receive DATFIFO */
#define SDIO_STS_SDIOINT            ((uint32_t)0x00400000U) /* SDIO interrupt received */

/*******************  Bit definition for SDIO_INTCLR register  *******************/
#define SDIO_INTCLR_CCRCERRC        ((uint32_t)0x00000001U) /* CCRCFAIL flag clear bit */
#define SDIO_INTCLR_DCRCERRC        ((uint32_t)0x00000002U) /* DCRCFAIL flag clear bit */
#define SDIO_INTCLR_CMDTIMEOUTC     ((uint32_t)0x00000004U) /* CTIMEOUT flag clear bit */
#define SDIO_INTCLR_DATTIMEOUTC     ((uint32_t)0x00000008U) /* DTIMEOUT flag clear bit */
#define SDIO_INTCLR_TXURERRC        ((uint32_t)0x00000010U) /* TXUNDERR flag clear bit */
#define SDIO_INTCLR_RXORERRC        ((uint32_t)0x00000020U) /* RXOVERR flag clear bit */
#define SDIO_INTCLR_CMDRESPRECVC    ((uint32_t)0x00000040U) /* CMDREND flag clear bit */
#define SDIO_INTCLR_CMDSENDC        ((uint32_t)0x00000080U) /* CMDSEND flag clear bit */
#define SDIO_INTCLR_DATENDC         ((uint32_t)0x00000100U) /* DATAEND flag clear bit */
#define SDIO_INTCLR_SBERRC          ((uint32_t)0x00000200U) /* STBITERR flag clear bit */
#define SDIO_INTCLR_DATBLKENDC      ((uint32_t)0x00000400U) /* DBCKEND flag clear bit */
#define SDIO_INTCLR_SDIOINTC        ((uint32_t)0x00400000U) /* SDIOIT flag clear bit */

/******************  Bit definition for SDIO_INTEN register  *******************/
#define SDIO_INTEN_CCRCERREN        ((uint32_t)0x00000001U) /* Command CRC Fail Interrupt Enable */
#define SDIO_INTEN_DCRCERREN        ((uint32_t)0x00000002U) /* Data CRC Fail Interrupt Enable */
#define SDIO_INTEN_CMDTIMEOUTEN     ((uint32_t)0x00000004U) /* Command TimeOut Interrupt Enable */
#define SDIO_INTEN_DATTIMEOUTEN     ((uint32_t)0x00000008U) /* Data TimeOut Interrupt Enable */
#define SDIO_INTEN_TXURERREN        ((uint32_t)0x00000010U) /* Tx DATFIFO UnderRun Error Interrupt Enable */
#define SDIO_INTEN_RXORERREN        ((uint32_t)0x00000020U) /* Rx DATFIFO OverRun Error Interrupt Enable */
#define SDIO_INTEN_CMDRESPRECVEN    ((uint32_t)0x00000040U) /* Command Response Received Interrupt Enable */
#define SDIO_INTEN_CMDSENDEN        ((uint32_t)0x00000080U) /* Command Sent Interrupt Enable */
#define SDIO_INTEN_DATENDEN         ((uint32_t)0x00000100U) /* Data End Interrupt Enable */
#define SDIO_INTEN_SBERREN          ((uint32_t)0x00000200U) /* Start Bit Error Interrupt Enable */
#define SDIO_INTEN_DATBLKENDEN      ((uint32_t)0x00000400U) /* Data Block End Interrupt Enable */
#define SDIO_INTEN_CMDRUNEN         ((uint32_t)0x00000800U) /* Command Acting Interrupt Enable */
#define SDIO_INTEN_TXRUNEN          ((uint32_t)0x00001000U) /* Data Transmit Acting Interrupt Enable */
#define SDIO_INTEN_RXRUNEN          ((uint32_t)0x00002000U) /* Data receive acting interrupt enabled */
#define SDIO_INTEN_TFIFOEEN         ((uint32_t)0x00004000U) /* Tx DATFIFO Empty interrupt Enable */
#define SDIO_INTEN_TFIFOHEEN        ((uint32_t)0x00008000U) /* Tx DATFIFO Half Empty interrupt Enable */
#define SDIO_INTEN_TFIFOFEN         ((uint32_t)0x00010000U) /* Tx DATFIFO Full interrupt Enable */
#define SDIO_INTEN_TDATVALIDEN      ((uint32_t)0x00020000U) /* Data available in Tx DATFIFO interrupt Enable */
#define SDIO_INTEN_RFIFOEEN         ((uint32_t)0x00040000U) /* Rx DATFIFO Empty interrupt Enable */
#define SDIO_INTEN_RFIFOHFEN        ((uint32_t)0x00080000U) /* Rx DATFIFO Half Full interrupt Enable */
#define SDIO_INTEN_RFIFOFEN         ((uint32_t)0x00100000U) /* Rx DATFIFO Full interrupt Enable */
#define SDIO_INTEN_RDATVALIDEN      ((uint32_t)0x00200000U) /* Data available in Rx DATFIFO interrupt Enable */
#define SDIO_INTEN_SDIOINTEN        ((uint32_t)0x00400000U) /* SDIO Mode Interrupt Received interrupt Enable */

/*****************  Bit definition for SDIO_FIFOCOUNT register  *****************/
#define SDIO_FIFOCOUNT_FIFOCOUNT    ((uint32_t)0x00FFFFFFU) /* Remaining number of words to be written to or read from the DATFIFO */

/******************  Bit definition for SDIO_DATFIFO register  *******************/
#define SDIO_DATFIFO_FIFIDAT        ((uint32_t)0xFFFFFFFFU) /* Receive and transmit DATFIFO data */


/*** USB FS Device ***/

/** Bit definition for USB_EP0/1/2/3/4/5/6/7 register **/
#define USB_EP_STS_TX       ((uint16_t)0xC000U) /* STS_TX[1:0] bits (Status bits, for transmission transfers) */
#define USB_EP_STS_TX_0     ((uint16_t)0x4000U) /* Bit 0 */
#define USB_EP_STS_TX_1     ((uint16_t)0x8000U) /* Bit 1 */

#define USB_EP_DATTOG_TX    ((uint16_t)0x2000U) /* Data Toggle, for transmission transfers */
#define USB_EP_CTRS_TX      ((uint16_t)0x1000U) /* Correct Transfer for transmission */

#define USB_EP_STS_RX       ((uint16_t)0x0C00U) /* STS_RX[1:0] bits (Status bits, for reception transfers) */
#define USB_EP_STS_RX_0     ((uint16_t)0x0400U) /* Bit 0 */
#define USB_EP_STS_RX_1     ((uint16_t)0x0800U) /* Bit 1 */

#define USB_EP_DATTOG_RX    ((uint16_t)0x0200U) /* Data Toggle, for reception transfers */
#define USB_EP_CTRS_RX      ((uint16_t)0x0100U) /* Correct Transfer for reception */

#define USB_EP_EP_TYPE      ((uint16_t)0x00C0U) /* EP_TYPE[1:0] bits (Endpoint type) */
#define USB_EP_EP_TYPE_0    ((uint16_t)0x0040U) /* Bit 0 */
#define USB_EP_EP_TYPE_1    ((uint16_t)0x0080U) /* Bit 1 */

#define USB_EP_EP_KIND      ((uint16_t)0x0020U) /* Endpoint Kind */
#define USB_EP_SETUP        ((uint16_t)0x0010U) /* Setup transaction completed */
#define USB_EP_EPADDR       ((uint16_t)0x000FU) /* Endpoint Address */

/** Bit definition for USB_CTRL register **/
#define USB_CTRL_PU         ((uint16_t)0x2000U) /* USB D+ pull up resistance */
#define USB_CTRL_RESUM      ((uint16_t)0x1000U) /* Resume request */
#define USB_CTRL_FSUSPD     ((uint16_t)0x0800U) /* Force suspend */
#define USB_CTRL_LP_MODE    ((uint16_t)0x0400U) /* Low-power mode */
#define USB_CTRL_PD         ((uint16_t)0x0200U) /* Power down */
#define USB_CTRL_FRST       ((uint16_t)0x0100U) /* Force USB Reset */
#define USB_CTRL_PMAOM      ((uint16_t)0x0080U) /* Packet Memory Area Over / Underrun Interrupt Mask */
#define USB_CTRL_CTRSM      ((uint16_t)0x0040U) /* Correct Transfer Interrupt Mask */
#define USB_CTRL_ERRORM     ((uint16_t)0x0020U) /* Error Interrupt Mask */
#define USB_CTRL_WKUPM      ((uint16_t)0x0010U) /* Wakeup Interrupt Mask */
#define USB_CTRL_SUSPDM     ((uint16_t)0x0008U) /* Suspend mode Interrupt Mask */
#define USB_CTRL_RSTM       ((uint16_t)0x0004U) /* RESET Interrupt Mask */
#define USB_CTRL_SOFM       ((uint16_t)0x0002U) /* Start Of Frame Interrupt Mask */
#define USB_CTRL_ESOFM      ((uint16_t)0x0001U) /* Expected Start Of Frame Interrupt Mask */

/** Bit definition for USB_STS register **/
#define USB_STS_DIR         ((uint16_t)0x1000U) /* Direction of transaction */
#define USB_STS_EP_ID       ((uint16_t)0x0F00U) /* Endpoint Identifier */
#define USB_STS_EP_ID_0     ((uint16_t)0x0100U) /* Bit 0 */
#define USB_STS_EP_ID_1     ((uint16_t)0x0200U) /* Bit 1 */
#define USB_STS_EP_ID_2     ((uint16_t)0x0400U) /* Bit 2 */
#define USB_STS_EP_ID_3     ((uint16_t)0x0800U) /* Bit 3 */
#define USB_STS_PMAO        ((uint16_t)0x0080U) /* Packet Memory Area Over / Underrun */
#define USB_STS_CTRS        ((uint16_t)0x0040U) /* Correct Transfer */
#define USB_STS_ERROR       ((uint16_t)0x0020U) /* Error */
#define USB_STS_WKUP        ((uint16_t)0x0010U) /* Wake up */
#define USB_STS_SUSPD       ((uint16_t)0x0008U) /* Suspend mode request */
#define USB_STS_RST         ((uint16_t)0x0004U) /* USB RESET request */
#define USB_STS_SOF         ((uint16_t)0x0002U) /* Start Of Frame */
#define USB_STS_ESOF        ((uint16_t)0x0001U) /* Expected Start Of Frame */


/** Bit definition for USB_BUFTAB register **/
#define USB_BUFTAB_BUFTAB   ((uint16_t)0xFFF8U) /* Buffer Table */

/** Bit definition for USB_FN register **/
#define USB_FN_RXDP_STS ((uint16_t)0x8000U) /* Receive Data + Line Status */
#define USB_FN_RXDM_STS ((uint16_t)0x4000U) /* Receive Data - Line Status */
#define USB_FN_LSTSOF   ((uint16_t)0x3000U) /* Lost SOF */
#define USB_FN_LSTSOF_0 ((uint16_t)0x1000U) /* Bit 0 */
#define USB_FN_LSTSOF_1 ((uint16_t)0x2000U) /* Bit 1 */
#define USB_FNR_LOCK    ((uint16_t)0x0800U) /* Locked */
#define USB_FN_FNUM     ((uint16_t)0x07FFU) /* Frame Number */


/**  Bit definition for USB_DADDR register **/
#define USB_ADDR_EFUC   ((uint8_t)0x80U) /* Enable Function */
#define USB_ADDR_ADDR   ((uint8_t)0x7FU) /* ADD[6:0] bits (Device Address) */
#define USB_ADDR_ADDR0  ((uint8_t)0x01U) /* Bit 0 */
#define USB_ADDR_ADDR1  ((uint8_t)0x02U) /* Bit 1 */
#define USB_ADDR_ADDR2  ((uint8_t)0x04U) /* Bit 2 */
#define USB_ADDR_ADDR3  ((uint8_t)0x08U) /* Bit 3 */
#define USB_ADDR_ADDR4  ((uint8_t)0x10U) /* Bit 4 */
#define USB_ADDR_ADDR5  ((uint8_t)0x20U) /* Bit 5 */
#define USB_ADDR_ADDR6  ((uint8_t)0x40U) /* Bit 6 */

/**  Bit definition for USB_ADDR0_TX register **/
#define USB_ADDR0_TX_ADDR0_TX ((uint16_t)0xFFFEU) /* Reception Buffer Address 0 */

/**  Bit definition for USB_ADDR1_TX register **/
#define USB_ADDR1_TX_ADDR1_TX ((uint16_t)0xFFFEU) /* Reception Buffer Address 1 */

/**  Bit definition for USB_ADDR2_TX register **/
#define USB_ADDR2_TX_ADDR2_TX ((uint16_t)0xFFFEU) /* Reception Buffer Address 2 */

/**  Bit definition for USB_ADDR3_TX register **/
#define USB_ADDR3_TX_ADDR3_TX ((uint16_t)0xFFFEU) /* Reception Buffer Address 3 */

/**  Bit definition for USB_ADDR4_TX register **/
#define USB_ADDR4_TX_ADDR4_TX ((uint16_t)0xFFFEU) /* Reception Buffer Address 4 */

/**  Bit definition for USB_ADDR5_TX register **/
#define USB_ADDR5_TX_ADDR5_TX ((uint16_t)0xFFFEU) /* Reception Buffer Address 5 */

/**  Bit definition for USB_ADDR6_TX register **/
#define USB_ADDR6_TX_ADDR6_TX ((uint16_t)0xFFFEU) /* Reception Buffer Address 6 */

/**  Bit definition for USB_ADDR7_TX register **/
#define USB_ADDR7_TX_ADDR7_TX ((uint16_t)0xFFFEU) /* Reception Buffer Address 7 */

/**  Bit definition for USB_CNT0_TX register **/
#define USB_CNT0_TX_CNT0_TX   ((uint16_t)0x03FFU) /* Transmission Byte Count 0 */

/**  Bit definition for USB_CNT1_TX register **/
#define USB_CNT1_TX_CNT1_TX   ((uint16_t)0x03FFU) /* Transmission Byte Count 1 */

/**  Bit definition for USB_CNT2_TX register **/
#define USB_CNT2_TX_CNT2_TX   ((uint16_t)0x03FFU) /* Transmission Byte Count 2 */

/**  Bit definition for USB_CNT3_TX register **/
#define USB_CNT3_TX_CNT3_TX   ((uint16_t)0x03FFU) /* Transmission Byte Count 3 */

/**  Bit definition for USB_CNT4_TX register **/
#define USB_CNT4_TX_CNT4_TX   ((uint16_t)0x03FFU) /* Transmission Byte Count 4 */

/**  Bit definition for USB_CNT5_TX register **/
#define USB_CNT5_TX_CNT5_TX   ((uint16_t)0x03FFU) /* Transmission Byte Count 5 */

/**  Bit definition for USB_CNT6_TX register **/
#define USB_CNT6_TX_CNT6_TX   ((uint16_t)0x03FFU) /* Transmission Byte Count 6 */

/**  Bit definition for USB_CNT7_TX register **/
#define USB_CNT7_TX_CNT7_TX   ((uint16_t)0x03FFU) /* Transmission Byte Count 7 */


/**  Bit definition for USB_ADDR0_RX register **/
#define USB_ADDR0_RX_ADDR0_RX ((uint16_t)0xFFFEU) /* Reception Buffer Address 0 */

/**  Bit definition for USB_ADDR1_RX register **/
#define USB_ADDR1_RX_ADDR1_RX ((uint16_t)0xFFFEU) /* Reception Buffer Address 1 */

/**  Bit definition for USB_ADDR2_RX register **/
#define USB_ADDR2_RX_ADDR2_RX ((uint16_t)0xFFFEU) /* Reception Buffer Address 2 */

/**  Bit definition for USB_ADDR3_RX register **/
#define USB_ADDR3_RX_ADDR3_RX ((uint16_t)0xFFFEU) /* Reception Buffer Address 3 */

/**  Bit definition for USB_ADDR4_RX register **/
#define USB_ADDR4_RX_ADDR4_RX ((uint16_t)0xFFFEU) /* Reception Buffer Address 4 */

/**  Bit definition for USB_ADDR5_RX register **/
#define USB_ADDR5_RX_ADDR5_RX ((uint16_t)0xFFFEU) /* Reception Buffer Address 5 */

/**  Bit definition for USB_ADDR6_RX register **/
#define USB_ADDR6_RX_ADDR6_RX ((uint16_t)0xFFFEU) /* Reception Buffer Address 6 */

/**  Bit definition for USB_ADDR7_RX register **/
#define USB_ADDR7_RX_ADDR7_RX ((uint16_t)0xFFFEU) /* Reception Buffer Address 7 */

/**  Bit definition for USB_CNT0_RX register  **/
#define USB_CNT0_RX_CNT0_RX   ((uint16_t)0x03FFU) /* Reception Byte Count */

#define USB_CNT0_RX_NUM_BLK   ((uint16_t)0x7C00U) /* NUM_BLOCK[4:0] bits (Number of blocks) */
#define USB_CNT0_RX_NUM_BLK_0 ((uint16_t)0x0400U) /* Bit 0 */
#define USB_CNT0_RX_NUM_BLK_1 ((uint16_t)0x0800U) /* Bit 1 */
#define USB_CNT0_RX_NUM_BLK_2 ((uint16_t)0x1000U) /* Bit 2 */
#define USB_CNT0_RX_NUM_BLK_3 ((uint16_t)0x2000U) /* Bit 3 */
#define USB_CNT0_RX_NUM_BLK_4 ((uint16_t)0x4000U) /* Bit 4 */

#define USB_CNT0_RX_BLSIZE    ((uint16_t)0x8000U) /* BLock SIZE */

/**  Bit definition for USB_CNT1_RX register  **/
#define USB_CNT1_RX_CNT1_RX   ((uint16_t)0x03FFU) /* Reception Byte Count */

#define USB_CNT1_RX_NUM_BLK   ((uint16_t)0x7C00U) /* NUM_BLOCK[4:0] bits (Number of blocks) */
#define USB_CNT1_RX_NUM_BLK_0 ((uint16_t)0x0400U) /* Bit 0 */
#define USB_CNT1_RX_NUM_BLK_1 ((uint16_t)0x0800U) /* Bit 1 */
#define USB_CNT1_RX_NUM_BLK_2 ((uint16_t)0x1000U) /* Bit 2 */
#define USB_CNT1_RX_NUM_BLK_3 ((uint16_t)0x2000U) /* Bit 3 */
#define USB_CNT1_RX_NUM_BLK_4 ((uint16_t)0x4000U) /* Bit 4 */

#define USB_CNT1_RX_BLSIZE    ((uint16_t)0x8000U) /* BLock SIZE */

/**  Bit definition for USB_CNT2_RX register  **/
#define USB_CNT2_RX_CNT2_RX   ((uint16_t)0x03FFU) /* Reception Byte Count */

#define USB_CNT2_RX_NUM_BLK   ((uint16_t)0x7C00U) /* NUM_BLOCK[4:0] bits (Number of blocks) */
#define USB_CNT2_RX_NUM_BLK_0 ((uint16_t)0x0400U) /* Bit 0 */
#define USB_CNT2_RX_NUM_BLK_1 ((uint16_t)0x0800U) /* Bit 1 */
#define USB_CNT2_RX_NUM_BLK_2 ((uint16_t)0x1000U) /* Bit 2 */
#define USB_CNT2_RX_NUM_BLK_3 ((uint16_t)0x2000U) /* Bit 3 */
#define USB_CNT2_RX_NUM_BLK_4 ((uint16_t)0x4000U) /* Bit 4 */

#define USB_CNT2_RX_BLSIZE    ((uint16_t)0x8000U) /* BLock SIZE */

/**  Bit definition for USB_CNT3_RX register  **/
#define USB_CNT3_RX_CNT3_RX   ((uint16_t)0x03FFU) /* Reception Byte Count */

#define USB_CNT3_RX_NUM_BLK   ((uint16_t)0x7C00U) /* NUM_BLOCK[4:0] bits (Number of blocks) */
#define USB_CNT3_RX_NUM_BLK_0 ((uint16_t)0x0400U) /* Bit 0 */
#define USB_CNT3_RX_NUM_BLK_1 ((uint16_t)0x0800U) /* Bit 1 */
#define USB_CNT3_RX_NUM_BLK_2 ((uint16_t)0x1000U) /* Bit 2 */
#define USB_CNT3_RX_NUM_BLK_3 ((uint16_t)0x2000U) /* Bit 3 */
#define USB_CNT3_RX_NUM_BLK_4 ((uint16_t)0x4000U) /* Bit 4 */

#define USB_CNT3_RX_BLSIZE    ((uint16_t)0x8000U) /* BLock SIZE */

/**  Bit definition for USB_CNT4_RX register  **/
#define USB_CNT4_RX_CNT4_RX   ((uint16_t)0x03FFU) /* Reception Byte Count */

#define USB_CNT4_RX_NUM_BLK   ((uint16_t)0x7C00U) /* NUM_BLOCK[4:0] bits (Number of blocks) */
#define USB_CNT4_RX_NUM_BLK_0 ((uint16_t)0x0400U) /* Bit 0 */
#define USB_CNT4_RX_NUM_BLK_1 ((uint16_t)0x0800U) /* Bit 1 */
#define USB_CNT4_RX_NUM_BLK_2 ((uint16_t)0x1000U) /* Bit 2 */
#define USB_CNT4_RX_NUM_BLK_3 ((uint16_t)0x2000U) /* Bit 3 */
#define USB_CNT4_RX_NUM_BLK_4 ((uint16_t)0x4000U) /* Bit 4 */

#define USB_CNT4_RX_BLSIZE    ((uint16_t)0x8000U) /* BLock SIZE */

/**  Bit definition for USB_CNT5_RX register  **/
#define USB_CNT5_RX_CNT5_RX   ((uint16_t)0x03FFU) /* Reception Byte Count */

#define USB_CNT5_RX_NUM_BLK   ((uint16_t)0x7C00U) /* NUM_BLOCK[4:0] bits (Number of blocks) */
#define USB_CNT5_RX_NUM_BLK_0 ((uint16_t)0x0400U) /* Bit 0 */
#define USB_CNT5_RX_NUM_BLK_1 ((uint16_t)0x0800U) /* Bit 1 */
#define USB_CNT5_RX_NUM_BLK_2 ((uint16_t)0x1000U) /* Bit 2 */
#define USB_CNT5_RX_NUM_BLK_3 ((uint16_t)0x2000U) /* Bit 3 */
#define USB_CNT5_RX_NUM_BLK_4 ((uint16_t)0x4000U) /* Bit 4 */

#define USB_CNT5_RX_BLSIZE    ((uint16_t)0x8000U) /* BLock SIZE */

/**  Bit definition for USB_CNT6_RX register  **/
#define USB_CNT6_RX_CNT6_RX   ((uint16_t)0x03FFU) /* Reception Byte Count */

#define USB_CNT6_RX_NUM_BLK   ((uint16_t)0x7C00U) /* NUM_BLOCK[4:0] bits (Number of blocks) */
#define USB_CNT6_RX_NUM_BLK_0 ((uint16_t)0x0400U) /* Bit 0 */
#define USB_CNT6_RX_NUM_BLK_1 ((uint16_t)0x0800U) /* Bit 1 */
#define USB_CNT6_RX_NUM_BLK_2 ((uint16_t)0x1000U) /* Bit 2 */
#define USB_CNT6_RX_NUM_BLK_3 ((uint16_t)0x2000U) /* Bit 3 */
#define USB_CNT6_RX_NUM_BLK_4 ((uint16_t)0x4000U) /* Bit 4 */

#define USB_CNT6_RX_BLSIZE    ((uint16_t)0x8000U) /* BLock SIZE */

/**  Bit definition for USB_CNT7_RX register  **/
#define USB_CNT7_RX_CNT7_RX   ((uint16_t)0x03FFU) /* Reception Byte Count */

#define USB_CNT7_RX_NUM_BLK   ((uint16_t)0x7C00U) /* NUM_BLOCK[4:0] bits (Number of blocks) */
#define USB_CNT7_RX_NUM_BLK_0 ((uint16_t)0x0400U) /* Bit 0 */
#define USB_CNT7_RX_NUM_BLK_1 ((uint16_t)0x0800U) /* Bit 1 */
#define USB_CNT7_RX_NUM_BLK_2 ((uint16_t)0x1000U) /* Bit 2 */
#define USB_CNT7_RX_NUM_BLK_3 ((uint16_t)0x2000U) /* Bit 3 */
#define USB_CNT7_RX_NUM_BLK_4 ((uint16_t)0x4000U) /* Bit 4 */

#define USB_CNT7_RX_BLSIZE    ((uint16_t)0x8000U) /* BLock SIZE */

/**  Bit definition for USB_CNT0_RX_0 register  **/
#define USB_CNT0_RX_0_CNT0_RX_0   ((uint32_t)0x000003FFU) /* Reception Byte Count (low) */

#define USB_CNT0_RX_0_NUM_BLK_0   ((uint32_t)0x00007C00U) /* NUM_BLOCK_0[4:0] bits (Number of blocks) (low) */
#define USB_CNT0_RX_0_NUM_BLK_0_0 ((uint32_t)0x00000400U) /* Bit 0 */
#define USB_CNT0_RX_0_NUM_BLK_0_1 ((uint32_t)0x00000800U) /* Bit 1 */
#define USB_CNT0_RX_0_NUM_BLK_0_2 ((uint32_t)0x00001000U) /* Bit 2 */
#define USB_CNT0_RX_0_NUM_BLK_0_3 ((uint32_t)0x00002000U) /* Bit 3 */
#define USB_CNT0_RX_0_NUM_BLK_0_4 ((uint32_t)0x00004000U) /* Bit 4 */

#define USB_CNT0_RX_0_BLSIZE_0    ((uint32_t)0x00008000U) /* BLock SIZE (low) */

/**  Bit definition for USB_CNT0_RX_1 register  **/
#define USB_CNT0_RX_1_CNT0_RX_1   ((uint32_t)0x03FF0000U) /* Reception Byte Count (high) */

#define USB_CNT0_RX_1_NUM_BLK_1   ((uint32_t)0x7C000000U) /* NUM_BLOCK_1[4:0] bits (Number of blocks) (high) */
#define USB_CNT0_RX_1_NUM_BLK_1_0 ((uint32_t)0x04000000U) /* Bit 1 */
#define USB_CNT0_RX_1_NUM_BLK_1_1 ((uint32_t)0x08000000U) /* Bit 1 */
#define USB_CNT0_RX_1_NUM_BLK_1_2 ((uint32_t)0x10000000U) /* Bit 2 */
#define USB_CNT0_RX_1_NUM_BLK_1_3 ((uint32_t)0x20000000U) /* Bit 3 */
#define USB_CNT0_RX_1_NUM_BLK_1_4 ((uint32_t)0x40000000U) /* Bit 4 */

#define USB_CNT0_RX_1_BLSIZE_1    ((uint32_t)0x80000000U) /* BLock SIZE (high) */

/**  Bit definition for USB_CNT1_RX_0 register  **/
#define USB_CNT1_RX_0_CNT1_RX_0   ((uint32_t)0x000003FFU) /* Reception Byte Count (low) */

#define USB_CNT1_RX_0_NUM_BLK_0   ((uint32_t)0x00007C00U) /* NUM_BLOCK_0[4:0] bits (Number of blocks) (low) */
#define USB_CNT1_RX_0_NUM_BLK_0_0 ((uint32_t)0x00000400U) /* Bit 0 */
#define USB_CNT1_RX_0_NUM_BLK_0_1 ((uint32_t)0x00000800U) /* Bit 1 */
#define USB_CNT1_RX_0_NUM_BLK_0_2 ((uint32_t)0x00001000U) /* Bit 2 */
#define USB_CNT1_RX_0_NUM_BLK_0_3 ((uint32_t)0x00002000U) /* Bit 3 */
#define USB_CNT1_RX_0_NUM_BLK_0_4 ((uint32_t)0x00004000U) /* Bit 4 */

#define USB_CNT1_RX_0_BLSIZE_0    ((uint32_t)0x00008000U) /* BLock SIZE (low) */

/**  Bit definition for USB_CNT1_RX_1 register  **/
#define USB_CNT1_RX_1_CNT1_RX_1   ((uint32_t)0x03FF0000U) /* Reception Byte Count (high) */

#define USB_CNT1_RX_1_NUM_BLK_1   ((uint32_t)0x7C000000U) /* NUM_BLOCK_1[4:0] bits (Number of blocks) (high) */
#define USB_CNT1_RX_1_NUM_BLK_1_0 ((uint32_t)0x04000000U) /* Bit 0 */
#define USB_CNT1_RX_1_NUM_BLK_1_1 ((uint32_t)0x08000000U) /* Bit 1 */
#define USB_CNT1_RX_1_NUM_BLK_1_2 ((uint32_t)0x10000000U) /* Bit 2 */
#define USB_CNT1_RX_1_NUM_BLK_1_3 ((uint32_t)0x20000000U) /* Bit 3 */
#define USB_CNT1_RX_1_NUM_BLK_1_4 ((uint32_t)0x40000000U) /* Bit 4 */

#define USB_CNT1_RX_1_BLSIZE_1    ((uint32_t)0x80000000U) /* BLock SIZE (high) */

/**  Bit definition for USB_CNT2_RX_0 register  **/
#define USB_CNT2_RX_0_CNT2_RX_0   ((uint32_t)0x000003FFU) /* Reception Byte Count (low) */

#define USB_CNT2_RX_0_NUM_BLK_0   ((uint32_t)0x00007C00U) /* NUM_BLOCK_0[4:0] bits (Number of blocks) (low) */
#define USB_CNT2_RX_0_NUM_BLK_0_0 ((uint32_t)0x00000400U) /* Bit 0 */
#define USB_CNT2_RX_0_NUM_BLK_0_1 ((uint32_t)0x00000800U) /* Bit 1 */
#define USB_CNT2_RX_0_NUM_BLK_0_2 ((uint32_t)0x00001000U) /* Bit 2 */
#define USB_CNT2_RX_0_NUM_BLK_0_3 ((uint32_t)0x00002000U) /* Bit 3 */
#define USB_CNT2_RX_0_NUM_BLK_0_4 ((uint32_t)0x00004000U) /* Bit 4 */

#define USB_CNT2_RX_0_BLSIZE_0    ((uint32_t)0x00008000U) /* BLock SIZE (low) */

/**  Bit definition for USB_CNT2_RX_1 register  **/
#define USB_CNT2_RX_1_CNT2_RX_1   ((uint32_t)0x03FF0000U) /* Reception Byte Count (high) */

#define USB_CNT2_RX_1_NUM_BLK_1   ((uint32_t)0x7C000000U) /* NUM_BLOCK_1[4:0] bits (Number of blocks) (high) */
#define USB_CNT2_RX_1_NUM_BLK_1_0 ((uint32_t)0x04000000U) /* Bit 0 */
#define USB_CNT2_RX_1_NUM_BLK_1_1 ((uint32_t)0x08000000U) /* Bit 1 */
#define USB_CNT2_RX_1_NUM_BLK_1_2 ((uint32_t)0x10000000U) /* Bit 2 */
#define USB_CNT2_RX_1_NUM_BLK_1_3 ((uint32_t)0x20000000U) /* Bit 3 */
#define USB_CNT2_RX_1_NUM_BLK_1_4 ((uint32_t)0x40000000U) /* Bit 4 */

#define USB_CNT2_RX_1_BLSIZE_1    ((uint32_t)0x80000000U) /* BLock SIZE (high) */

/**  Bit definition for USB_CNT3_RX_0 register  **/
#define USB_CNT3_RX_0_CNT3_RX_0   ((uint32_t)0x000003FFU) /* Reception Byte Count (low) */

#define USB_CNT3_RX_0_NUM_BLK_0   ((uint32_t)0x00007C00U) /* NUM_BLOCK_0[4:0] bits (Number of blocks) (low) */
#define USB_CNT3_RX_0_NUM_BLK_0_0 ((uint32_t)0x00000400U) /* Bit 0 */
#define USB_CNT3_RX_0_NUM_BLK_0_1 ((uint32_t)0x00000800U) /* Bit 1 */
#define USB_CNT3_RX_0_NUM_BLK_0_2 ((uint32_t)0x00001000U) /* Bit 2 */
#define USB_CNT3_RX_0_NUM_BLK_0_3 ((uint32_t)0x00002000U) /* Bit 3 */
#define USB_CNT3_RX_0_NUM_BLK_0_4 ((uint32_t)0x00004000U) /* Bit 4 */

#define USB_CNT3_RX_0_BLSIZE_0    ((uint32_t)0x00008000U) /* BLock SIZE (low) */

/**  Bit definition for USB_CNT3_RX_1 register  **/
#define USB_CNT3_RX_1_CNT3_RX_1   ((uint32_t)0x03FF0000U) /* Reception Byte Count (high) */

#define USB_CNT3_RX_1_NUM_BLK_1   ((uint32_t)0x7C000000U) /* NUM_BLOCK_1[4:0] bits (Number of blocks) (high) */
#define USB_CNT3_RX_1_NUM_BLK_1_0 ((uint32_t)0x04000000U) /* Bit 0 */
#define USB_CNT3_RX_1_NUM_BLK_1_1 ((uint32_t)0x08000000U) /* Bit 1 */
#define USB_CNT3_RX_1_NUM_BLK_1_2 ((uint32_t)0x10000000U) /* Bit 2 */
#define USB_CNT3_RX_1_NUM_BLK_1_3 ((uint32_t)0x20000000U) /* Bit 3 */
#define USB_CNT3_RX_1_NUM_BLK_1_4 ((uint32_t)0x40000000U) /* Bit 4 */

#define USB_CNT3_RX_1_BLSIZE_1    ((uint32_t)0x80000000U) /* BLock SIZE (high) */

/**  Bit definition for USB_CNT4_RX_0 register  **/
#define USB_CNT4_RX_0_CNT4_RX_0   ((uint32_t)0x000003FFU) /* Reception Byte Count (low) */

#define USB_CNT4_RX_0_NUM_BLK_0   ((uint32_t)0x00007C00U) /* NUM_BLOCK_0[4:0] bits (Number of blocks) (low) */
#define USB_CNT4_RX_0_NUM_BLK_0_0 ((uint32_t)0x00000400U) /* Bit 0 */
#define USB_CNT4_RX_0_NUM_BLK_0_1 ((uint32_t)0x00000800U) /* Bit 1 */
#define USB_CNT4_RX_0_NUM_BLK_0_2 ((uint32_t)0x00001000U) /* Bit 2 */
#define USB_CNT4_RX_0_NUM_BLK_0_3 ((uint32_t)0x00002000U) /* Bit 3 */
#define USB_CNT4_RX_0_NUM_BLK_0_4 ((uint32_t)0x00004000U) /* Bit 4 */

#define USB_CNT4_RX_0_BLSIZE_0    ((uint32_t)0x00008000U) /* BLock SIZE (low) */

/**  Bit definition for USB_CNT4_RX_1 register  **/
#define USB_CNT4_RX_1_CNT4_RX_1   ((uint32_t)0x03FF0000U) /* Reception Byte Count (high) */

#define USB_CNT4_RX_1_NUM_BLK_1   ((uint32_t)0x7C000000U) /* NUM_BLOCK_1[4:0] bits (Number of blocks) (high) */
#define USB_CNT4_RX_1_NUM_BLK_1_0 ((uint32_t)0x04000000U) /* Bit 0 */
#define USB_CNT4_RX_1_NUM_BLK_1_1 ((uint32_t)0x08000000U) /* Bit 1 */
#define USB_CNT4_RX_1_NUM_BLK_1_2 ((uint32_t)0x10000000U) /* Bit 2 */
#define USB_CNT4_RX_1_NUM_BLK_1_3 ((uint32_t)0x20000000U) /* Bit 3 */
#define USB_CNT4_RX_1_NUM_BLK_1_4 ((uint32_t)0x40000000U) /* Bit 4 */

#define USB_CNT4_RX_1_BLSIZE_1    ((uint32_t)0x80000000U) /* BLock SIZE (high) */

/**  Bit definition for USB_CNT5_RX_0 register  **/
#define USB_CNT5_RX_0_CNT5_RX_0   ((uint32_t)0x000003FFU) /* Reception Byte Count (low) */

#define USB_CNT5_RX_0_NUM_BLK_0   ((uint32_t)0x00007C00U) /* NUM_BLOCK_0[4:0] bits (Number of blocks) (low) */
#define USB_CNT5_RX_0_NUM_BLK_0_0 ((uint32_t)0x00000400U) /* Bit 0 */
#define USB_CNT5_RX_0_NUM_BLK_0_1 ((uint32_t)0x00000800U) /* Bit 1 */
#define USB_CNT5_RX_0_NUM_BLK_0_2 ((uint32_t)0x00001000U) /* Bit 2 */
#define USB_CNT5_RX_0_NUM_BLK_0_3 ((uint32_t)0x00002000U) /* Bit 3 */
#define USB_CNT5_RX_0_NUM_BLK_0_4 ((uint32_t)0x00004000U) /* Bit 4 */

#define USB_CNT5_RX_0_BLSIZE_0    ((uint32_t)0x00008000U) /* BLock SIZE (low) */

/**  Bit definition for USB_CNT5_RX_1 register  **/
#define USB_CNT5_RX_1_CNT5_RX_1   ((uint32_t)0x03FF0000U) /* Reception Byte Count (high) */

#define USB_CNT5_RX_1_NUM_BLK_1   ((uint32_t)0x7C000000U) /* NUM_BLOCK_1[4:0] bits (Number of blocks) (high) */
#define USB_CNT5_RX_1_NUM_BLK_1_0 ((uint32_t)0x04000000U) /* Bit 0 */
#define USB_CNT5_RX_1_NUM_BLK_1_1 ((uint32_t)0x08000000U) /* Bit 1 */
#define USB_CNT5_RX_1_NUM_BLK_1_2 ((uint32_t)0x10000000U) /* Bit 2 */
#define USB_CNT5_RX_1_NUM_BLK_1_3 ((uint32_t)0x20000000U) /* Bit 3 */
#define USB_CNT5_RX_1_NUM_BLK_1_4 ((uint32_t)0x40000000U) /* Bit 4 */

#define USB_CNT5_RX_1_BLSIZE_1    ((uint32_t)0x80000000U) /* BLock SIZE (high) */

/**  Bit definition for USB_CNT6_RX_0  register  **/
#define USB_CNT6_RX_0_CNT6_RX_0   ((uint32_t)0x000003FFU) /* Reception Byte Count (low) */

#define USB_CNT6_RX_0_NUM_BLK_0   ((uint32_t)0x00007C00U) /* NUM_BLOCK_0[4:0] bits (Number of blocks) (low) */
#define USB_CNT6_RX_0_NUM_BLK_0_0 ((uint32_t)0x00000400U) /* Bit 0 */
#define USB_CNT6_RX_0_NUM_BLK_0_1 ((uint32_t)0x00000800U) /* Bit 1 */
#define USB_CNT6_RX_0_NUM_BLK_0_2 ((uint32_t)0x00001000U) /* Bit 2 */
#define USB_CNT6_RX_0_NUM_BLK_0_3 ((uint32_t)0x00002000U) /* Bit 3 */
#define USB_CNT6_RX_0_NUM_BLK_0_4 ((uint32_t)0x00004000U) /* Bit 4 */

#define USB_CNT6_RX_0_BLSIZE_0    ((uint32_t)0x00008000U) /* BLock SIZE (low) */

/**  Bit definition for USB_CNT6_RX_1 register  **/
#define USB_CNT6_RX_1_CNT6_RX_1   ((uint32_t)0x03FF0000U) /* Reception Byte Count (high) */

#define USB_CNT6_RX_1_NUM_BLK_1   ((uint32_t)0x7C000000U) /* NUM_BLOCK_1[4:0] bits (Number of blocks) (high) */
#define USB_CNT6_RX_1_NUM_BLK_1_0 ((uint32_t)0x04000000U) /* Bit 0 */
#define USB_CNT6_RX_1_NUM_BLK_1_1 ((uint32_t)0x08000000U) /* Bit 1 */
#define USB_CNT6_RX_1_NUM_BLK_1_2 ((uint32_t)0x10000000U) /* Bit 2 */
#define USB_CNT6_RX_1_NUM_BLK_1_3 ((uint32_t)0x20000000U) /* Bit 3 */
#define USB_CNT6_RX_1_NUM_BLK_1_4 ((uint32_t)0x40000000U) /* Bit 4 */

#define USB_CNT6_RX_1_BLSIZE_1    ((uint32_t)0x80000000U) /* BLock SIZE (high) */

/**  Bit definition for USB_CNT7_RX_0 register  **/
#define USB_CNT7_RX_0_CNT7_RX_0   ((uint32_t)0x000003FFU) /* Reception Byte Count (low) */

#define USB_CNT7_RX_0_NUM_BLK_0   ((uint32_t)0x00007C00U) /* NUM_BLOCK_0[4:0] bits (Number of blocks) (low) */
#define USB_CNT7_RX_0_NUM_BLK_0_0 ((uint32_t)0x00000400U) /* Bit 0 */
#define USB_CNT7_RX_0_NUM_BLK_0_1 ((uint32_t)0x00000800U) /* Bit 1 */
#define USB_CNT7_RX_0_NUM_BLK_0_2 ((uint32_t)0x00001000U) /* Bit 2 */
#define USB_CNT7_RX_0_NUM_BLK_0_3 ((uint32_t)0x00002000U) /* Bit 3 */
#define USB_CNT7_RX_0_NUM_BLK_0_4 ((uint32_t)0x00004000U) /* Bit 4 */

#define USB_CNT7_RX_0_BLSIZE_0    ((uint32_t)0x00008000U) /* BLock SIZE (low) */

/**  Bit definition for USB_CNT7_RX_1 register  **/
#define USB_CNT7_RX_1_CNT7_RX_1   ((uint32_t)0x03FF0000U) /* Reception Byte Count (high) */

#define USB_CNT7_RX_1_NUM_BLK_1   ((uint32_t)0x7C000000U) /* NUM_BLOCK_1[4:0] bits (Number of blocks) (high) */
#define USB_CNT7_RX_1_NUM_BLK_1_0 ((uint32_t)0x04000000U) /* Bit 0 */
#define USB_CNT7_RX_1_NUM_BLK_1_1 ((uint32_t)0x08000000U) /* Bit 1 */
#define USB_CNT7_RX_1_NUM_BLK_1_2 ((uint32_t)0x10000000U) /* Bit 2 */
#define USB_CNT7_RX_1_NUM_BLK_1_3 ((uint32_t)0x20000000U) /* Bit 3 */
#define USB_CNT7_RX_1_NUM_BLK_1_4 ((uint32_t)0x40000000U) /* Bit 4 */

#define USB_CNT7_RX_1_BLSIZE_1    ((uint32_t)0x80000000U) /* BLock SIZE (high) */


/*** USB High Speed ***/
/** Bit definition for USBHS_GCTRLSTS register **/
#define USBHS_GCTRLSTS_VBVALOVEN_POS                   (2U)
#define USBHS_GCTRLSTS_VBVALOVEN                       ((uint32_t)0x00000004U)   /* VBUS valid override enable */
#define USBHS_GCTRLSTS_VBVALOVAL_POS                   (3U)
#define USBHS_GCTRLSTS_VBVALOVAL                       ((uint32_t)0x00000008U)   /* VBUS valid override value */
#define USBHS_GCTRLSTS_AVALOVEN_POS                    (4U)
#define USBHS_GCTRLSTS_AVALOVEN                        ((uint32_t)0x00000010U)   /* A perpheral session valid override enable */
#define USBHS_GCTRLSTS_AVALOVAL_POS                    (5U)
#define USBHS_GCTRLSTS_AVALOVAL                        ((uint32_t)0x00000020U)   /* A perpheral session valid override value */
#define USBHS_GCTRLSTS_BVALOVEN_POS                    (6U)
#define USBHS_GCTRLSTS_BVALOVEN                        ((uint32_t)0x00000040U)   /* B perpheral session valid override enable */
#define USBHS_GCTRLSTS_BVALOVAL_POS                    (7U)
#define USBHS_GCTRLSTS_BVALOVAL                        ((uint32_t)0x00000080U)   /* B perpheral session valid override value */
#define USBHS_GCTRLSTS_IDSTS_POS                       (16U)
#define USBHS_GCTRLSTS_IDSTS                           ((uint32_t)0x00010000U)   /* ID pin status */
#define USBHS_GCTRLSTS_DETIM_POS                       (17U)
#define USBHS_GCTRLSTS_DETIM                           ((uint32_t)0x00020000U)   /* Debounce valid */
#define USBHS_GCTRLSTS_ASVLD_POS                       (18U)
#define USBHS_GCTRLSTS_ASVLD                           ((uint32_t)0x00040000U)   /* A session valid */
#define USBHS_GCTRLSTS_BSVLD_POS                       (19U)
#define USBHS_GCTRLSTS_BSVLD                           ((uint32_t)0x00080000U)   /* B session valid */ 
#define USBHS_GCTRLSTS_CMODE_POS                       (21U)
#define USBHS_GCTRLSTS_CMODE                           ((uint32_t)0x00200000U)   /* Current mode */                          


/** Bit definition for USBHS_GAHBCFG register **/
#define USBHS_GAHBCFG_GINTEN_POS                       (0U)
#define USBHS_GAHBCFG_GINTEN                           ((uint32_t)0x00000001U)
#define USBHS_GAHBCFG_BURSTTYP_POS                     (1U)
#define USBHS_GAHBCFG_BURSTTYP                         ((uint32_t)0x0000001EU)
#define USBHS_GAHBCFG_DMAEN_POS                        (5U)
#define USBHS_GAHBCFG_DMAEN                            ((uint32_t)0x00000020U)
#define USBHS_GAHBCFG_NPTXFETH_POS                     (7U)
#define USBHS_GAHBCFG_NPTXFETH                         ((uint32_t)0x00000080U)
#define USBHS_GAHBCFG_PTXFETH_POS                      (8U)
#define USBHS_GAHBCFG_PTXFETH                          ((uint32_t)0x00000100U)

/**  Bit definition for USBHS_GCFG register **/
#define USBHS_GCFG_TOCAL_POS                           (0U)
#define USBHS_GCFG_TOCAL                               ((uint32_t)0x00000007U)
#define USBHS_GCFG_PHYIF_POS                           (3U)
#define USBHS_GCFG_PHYIF                               ((uint32_t)0x00000008U)
#define USBHS_GCFG_PHYSEL_POS                          (6U)
#define USBHS_GCFG_PHYSEL                              ((uint32_t)0x00000040U)
#define USBHS_GCFG_TRDTIM_POS                          (10U)
#define USBHS_GCFG_TRDTIM                              ((uint32_t)0x00003C00U)
#define USBHS_GCFG_FHMODE_POS                          (29U)
#define USBHS_GCFG_FHMODE                              ((uint32_t)0x20000000U)
#define USBHS_GCFG_FDMODE_POS                          (30U)
#define USBHS_GCFG_FDMODE                              ((uint32_t)0x40000000U)

/**  Bit definition for USBHS_GRSTCTRL register **/
#define USBHS_GRSTCTRL_CSRST_POS                        (0U)
#define USBHS_GRSTCTRL_CSRST                            ((uint32_t)0x00000001U)
#define USBHS_GRSTCTRL_PFSSRST_POS                      (1U)
#define USBHS_GRSTCTRL_PFSSRST                          ((uint32_t)0x00000002U)
#define USBHS_GRSTCTRL_HFCRST_POS                       (2U)
#define USBHS_GRSTCTRL_HFCRST                           ((uint32_t)0x00000004U)
#define USBHS_GRSTCTRL_RXFFLSH_POS                      (4U)
#define USBHS_GRSTCTRL_RXFFLSH                          ((uint32_t)0x00000010U)
#define USBHS_GRSTCTRL_TXFFLSH_POS                      (5U)
#define USBHS_GRSTCTRL_TXFFLSH                          ((uint32_t)0x00000020U)
#define USBHS_GRSTCTRL_TXFNUM_POS                       (6U)
#define USBHS_GRSTCTRL_TXFNUM                           ((uint32_t)0x000007C0U)
#define USBHS_GRSTCTRL_SRSTDNE_POS                      (29U)
#define USBHS_GRSTCTRL_SRSTDNE                          ((uint32_t)0x20000000U)
#define USBHS_GRSTCTRL_DMAREQ_POS                       (30U)
#define USBHS_GRSTCTRL_DMAREQ                           ((uint32_t)0x40000000U)
#define USBHS_GRSTCTRL_AHBIDLE_POS                      (31U)
#define USBHS_GRSTCTRL_AHBIDLE                          ((uint32_t)0x80000000U)

/** Bit definition for USBHS_GINTSTS register **/
#define USBHS_GINTSTS_CMODE_POS                        (0U)
#define USBHS_GINTSTS_CMODE                            ((uint32_t)0x00000001U)
#define USBHS_GINTSTS_MODMISIF_POS                     (1U)
#define USBHS_GINTSTS_MODMISIF                         ((uint32_t)0x00000002U)
#define USBHS_GINTSTS_SOFIF_POS                        (3U)
#define USBHS_GINTSTS_SOFIF                            ((uint32_t)0x00000008U)
#define USBHS_GINTSTS_RXFNEIF_POS                      (4U)
#define USBHS_GINTSTS_RXFNEIF                          ((uint32_t)0x00000010U)
#define USBHS_GINTSTS_NPTXFEIF_POS                     (5U)
#define USBHS_GINTSTS_NPTXFEIF                         ((uint32_t)0x00000020U)
#define USBHS_GINTSTS_GINNPNAKEIF_POS                  (6U)
#define USBHS_GINTSTS_GINNPNAKEIF                      ((uint32_t)0x00000040U)
#define USBHS_GINTSTS_GOUTNAKEIF_POS                   (7U)
#define USBHS_GINTSTS_GOUTNAKEIF                       ((uint32_t)0x00000080U)
#define USBHS_GINTSTS_ESUSPIF_POS                      (10U)
#define USBHS_GINTSTS_ESUSPIF                          ((uint32_t)0x00000400U)
#define USBHS_GINTSTS_USBSUSPIF_POS                    (11U)
#define USBHS_GINTSTS_USBSUSPIF                        ((uint32_t)0x00000800U)
#define USBHS_GINTSTS_USBRSTIF_POS                     (12U)
#define USBHS_GINTSTS_USBRSTIF                         ((uint32_t)0x00001000U)
#define USBHS_GINTSTS_ENUMDIF_POS                      (13U)
#define USBHS_GINTSTS_ENUMDIF                          ((uint32_t)0x00002000U)
#define USBHS_GINTSTS_ISOUTPDIF_POS                    (14U)
#define USBHS_GINTSTS_ISOUTPDIF                        ((uint32_t)0x00004000U)
#define USBHS_GINTSTS_EOPFIF_POS                       (15U)
#define USBHS_GINTSTS_EOPFIF                           ((uint32_t)0x00008000U)
#define USBHS_GINTSTS_INEPIF_POS                       (18U)
#define USBHS_GINTSTS_INEPIF                           ((uint32_t)0x00040000U)
#define USBHS_GINTSTS_OUTEPIF_POS                      (19U)
#define USBHS_GINTSTS_OUTEPIF                          ((uint32_t)0x00080000U)
#define USBHS_GINTSTS_ISOINCIF_POS                     (20U)
#define USBHS_GINTSTS_ISOINCIF                         ((uint32_t)0x00100000U)
#define USBHS_GINTSTS_PTNCIF_ISOUTNCIF_POS             (21U)
#define USBHS_GINTSTS_PTNCIF_ISOUTNCIF                 ((uint32_t)0x00200000U)
#define USBHS_GINTSTS_FETSUSPIF_POS                    (22U)
#define USBHS_GINTSTS_FETSUSPIF                        ((uint32_t)0x00400000U)
#define USBHS_GINTSTS_RSTDIF_POS                       (23U)
#define USBHS_GINTSTS_RSTDIF                           ((uint32_t)0x00800000U)
#define USBHS_GINTSTS_HPIF_POS                         (24U)
#define USBHS_GINTSTS_HPIF                             ((uint32_t)0x01000000U)
#define USBHS_GINTSTS_HCHIF_POS                        (25U)
#define USBHS_GINTSTS_HCHIF                            ((uint32_t)0x02000000U)
#define USBHS_GINTSTS_PTXFEIF_POS                      (26U)
#define USBHS_GINTSTS_PTXFEIF                          ((uint32_t)0x04000000U)
#define USBHS_GINTSTS_IDSTSCIF_POS                     (28U)
#define USBHS_GINTSTS_IDSTSCIF                         ((uint32_t)0x10000000U)
#define USBHS_GINTSTS_DISCIF_POS                       (29U)
#define USBHS_GINTSTS_DISCIF                           ((uint32_t)0x20000000U)
#define USBHS_GINTSTS_WKUPIF_POS                       (31U)
#define USBHS_GINTSTS_WKUPIF                           ((uint32_t)0x80000000U)

/** Bit definition for USBHS_GINTEN register **/
#define USBHS_GINTEN_MODMISIEN_POS                     (1U)
#define USBHS_GINTEN_MODMISIEN                         ((uint32_t)0x00000002U)
#define USBHS_GINTEN_USBHSIEN_POS                      (2U)
#define USBHS_GINTEN_USBHSIEN                          ((uint32_t)0x00000004U)
#define USBHS_GINTEN_SOFIEN_POS                        (3U)
#define USBHS_GINTEN_SOFIEN                            ((uint32_t)0x00000008U)
#define USBHS_GINTEN_RXFNEIEN_POS                      (4U)
#define USBHS_GINTEN_RXFNEIEN                          ((uint32_t)0x00000010U)
#define USBHS_GINTEN_NPTXFEIEN_POS                     (5U)
#define USBHS_GINTEN_NPTXFEIEN                         ((uint32_t)0x00000020U)
#define USBHS_GINTEN_GINNPNAKEIEN_POS                  (6U)
#define USBHS_GINTEN_GINNPNAKEIEN                      ((uint32_t)0x00000040U)
#define USBHS_GINTEN_GOUTNAKEIEN_POS                   (7U)
#define USBHS_GINTEN_GOUTNAKEIEN                       ((uint32_t)0x00000080U)
#define USBHS_GINTEN_ESUSPIEN_POS                      (10U)
#define USBHS_GINTEN_ESUSPIEN                          ((uint32_t)0x00000400U)
#define USBHS_GINTEN_USBSUSPIEN_POS                    (11U)
#define USBHS_GINTEN_USBSUSPIEN                        ((uint32_t)0x00000800U)
#define USBHS_GINTEN_USBRSTIEN_POS                     (12U)
#define USBHS_GINTEN_USBRSTIEN                         ((uint32_t)0x00001000U)
#define USBHS_GINTEN_ENUMDIEN_POS                      (13U)
#define USBHS_GINTEN_ENUMDIEN                          ((uint32_t)0x00002000U)
#define USBHS_GINTEN_ISOUTPDIEN_POS                    (14U)
#define USBHS_GINTEN_ISOUTPDIEN                        ((uint32_t)0x00004000U)
#define USBHS_GINTEN_EOPFIEN_POS                       (15U)
#define USBHS_GINTEN_EOPFIEN                           ((uint32_t)0x00008000U)
#define USBHS_GINTEN_INEPIEN_POS                       (18U)
#define USBHS_GINTEN_INEPIEN                           ((uint32_t)0x00040000U)
#define USBHS_GINTEN_OUTEPIEN_POS                      (19U)
#define USBHS_GINTEN_OUTEPIEN                          ((uint32_t)0x00080000U)
#define USBHS_GINTEN_ISOINCIEN_POS                     (20U)
#define USBHS_GINTEN_ISOINCIEN                         ((uint32_t)0x00100000U)
#define USBHS_GINTEN_PTNCIEN_ISOUTNCIEN_POS            (21U)
#define USBHS_GINTEN_PTNCIEN_ISOUTNCIEN                ((uint32_t)0x00200000U)
#define USBHS_GINTEN_FETSUSPIEN_POS                    (22U)
#define USBHS_GINTEN_FETSUSPIEN                        ((uint32_t)0x00400000U)
#define USBHS_GINTEN_RSTDIEN_POS                       (23U)
#define USBHS_GINTEN_RSTDIEN                           ((uint32_t)0x00800000U)
#define USBHS_GINTEN_HPIEN_POS                         (24U)
#define USBHS_GINTEN_HPIEN                             ((uint32_t)0x01000000U)
#define USBHS_GINTEN_HCHIEN_POS                        (25U)
#define USBHS_GINTEN_HCHIEN                            ((uint32_t)0x02000000U)
#define USBHS_GINTEN_PTXFEIEN_POS                      (26U)
#define USBHS_GINTEN_PTXFEIEN                          ((uint32_t)0x04000000U)
#define USBHS_GINTEN_IDSTSCIEN_POS                     (28U)
#define USBHS_GINTEN_IDSTSCIEN                         ((uint32_t)0x10000000U)
#define USBHS_GINTEN_DISCIEN_POS                       (29U)
#define USBHS_GINTEN_DISCIEN                           ((uint32_t)0x20000000U)
#define USBHS_GINTEN_VBUSVIF_POS                       (30U)
#define USBHS_GINTEN_VBUSVIF                           ((uint32_t)0x40000000U)
#define USBHS_GINTEN_WKUPIEN_POS                       (31U)
#define USBHS_GINTEN_WKUPIEN                           ((uint32_t)0x80000000U)

/** Bit definition for USBHS_GRXSTS/USBHS_GRXSTSP register **/
#define USBHS_GRXSTS_CHEPNUM_POS                      (0U)
#define USBHS_GRXSTS_CHEPNUM                          ((uint32_t)0x0000000FU)
#define USBHS_GRXSTS_BCNT_POS                         (4U)
#define USBHS_GRXSTS_BCNT                             ((uint32_t)0x00007FF0U)
#define USBHS_GRXSTS_DPID_POS                         (15U)
#define USBHS_GRXSTS_DPID                             ((uint32_t)0x00018000U)
#define USBHS_GRXSTS_PKTSTS_POS                       (17U)
#define USBHS_GRXSTS_PKTSTS                           ((uint32_t)0x001E0000U)
#define USBHS_GRXSTS_FUNM_POS                         (21U)
#define USBHS_GRXSTS_FUNM                             ((uint32_t)0x01E00000U)

/** Bit definition for USBHS_GRXFSIZ register **/
#define USBHS_GRXFSIZ_RXFDEP                           ((uint32_t)0x000007FFU)

/** Bit definition for USBHS_HNPTXFSIZ register **/
#define USBHS_HNPTXFSIZ_NPTXFSADD_POS                  (0U)
#define USBHS_HNPTXFSIZ_NPTXFSADD                      ((uint32_t)0x000007FFU)
#define USBHS_HNPTXFSIZ_IEP0TXFDEP_POS                 (16U)
#define USBHS_HNPTXFSIZ_IEP0TXFDEP                     ((uint32_t)0x07FF0000U)

/** Bit definition for USBHS_DINEP0TXSIZ register **/
#define USBHS_DINEP0TXSIZ_IEP0TXFRSADD_POS             (0U)
#define USBHS_DINEP0TXSIZ_IEP0TXFRSADD                 ((uint32_t)0x000007FFU)
#define USBHS_DINEP0TXSIZ_NPTXFDEP_POS                 (16U)
#define USBHS_DINEP0TXSIZ_NPTXFDEP                     ((uint32_t)0x07FF0000U)

/** Bit definition for USBHS_GNPTXFSTS register **/
#define USBHS_GNPTXFSTS_NPTXFSAV_POS                   (0U)
#define USBHS_GNPTXFSTS_NPTXFSAV                       ((uint32_t)0x0000FFFFU)
#define USBHS_GNPTXFSTS_NPTXRQSAV_POS                  (16U)
#define USBHS_GNPTXFSTS_NPTXRQSAV                      ((uint32_t)0x00FF0000U)
#define USBHS_GNPTXFSTS_NPTXRQTOP_POS                  (24U)
#define USBHS_GNPTXFSTS_NPTXRQTOP                      ((uint32_t)0x7F000000U)
#define USBHS_GNPTXFSTS_NPTXRQTOP_END_POS              (24U)
#define USBHS_GNPTXFSTS_NPTXRQTOP_END                  ((uint32_t)0x01000000U)
#define USBHS_GNPTXFSTS_NPTXRQTOP_TOKEN_POS            (25U)
#define USBHS_GNPTXFSTS_NPTXRQTOP_TOKEN                ((uint32_t)0x06000000U)
#define USBHS_GNPTXFSTS_NPTXRQTOP_CHNUM_POS            (27U)
#define USBHS_GNPTXFSTS_NPTXRQTOP_CHNUM                ((uint32_t)0x78000000U)

/** Bit definition for USBHS_CID register **/
#define USBHS_CID                                      ((uint32_t)0xFFFFFFFFU)

/** Bit definition for USBHS_GPD register **/
#define USBHS_GPD_LINSTSCHNGSTS_POS                    (7U)
#define USBHS_GPD_LINSTSCHNGSTS                        ((uint32_t)0x00000080U)
#define USBHS_GPD_LINSTSCHNGINTEN_POS                  (8U)
#define USBHS_GPD_LINSTSCHNGINTEN                      ((uint32_t)0x00000100U)
#define USBHS_GPD_RESTDETSTS_POS                       (9U)
#define USBHS_GPD_RESTDETSTS                           ((uint32_t)0x00000200U)
#define USBHS_GPD_RESTDETINTEN_POS                     (10U)
#define USBHS_GPD_RESTDETINTEN                         ((uint32_t)0x00000400U)
#define USBHS_GPD_DISCONNDETSTS_POS                    (11U)
#define USBHS_GPD_DISCONNDETSTS                        ((uint32_t)0x00000800U)
#define USBHS_GPD_DISCONNDETINTEN_POS                  (12U)
#define USBHS_GPD_DISCONNDETINTEN                      ((uint32_t)0x00001000U)
#define USBHS_GPD_CONNDETSTS_POS                       (13U)
#define USBHS_GPD_CONNDETSTS                           ((uint32_t)0x00002000U)
#define USBHS_GPD_CONNDETINTEN_POS                     (14U)
#define USBHS_GPD_CONNDETINTEN                         ((uint32_t)0x00004000U)
#define USBHS_GPD_STSCHNGINTSTS_POS                    (17U)
#define USBHS_GPD_STSCHNGINTSTS                        ((uint32_t)0x00020000U)
#define USBHS_GPD_STSCHNGINTEN_POS                     (18U)
#define USBHS_GPD_STSCHNGINTEN                         ((uint32_t)0x00040000U)
#define USBHS_GPD_LINSTS_POS                           (19U)
#define USBHS_GPD_LINSTS                               ((uint32_t)0x00180000U)
#define USBHS_GPD_IDDIG_POS                            (21U)
#define USBHS_GPD_IDDIG                                ((uint32_t)0x00200000U)

/** Bit definition for USBHS_HPTXFSIZ register **/
#define USBHS_HPTXFSIZ_HPTXFSADD_POS                   (0U)
#define USBHS_HPTXFSIZ_HPTXFSADD                       ((uint32_t)0x0000FFFFU)
#define USBHS_HPTXFSIZ_HPTXFDEP_POS                    (16U)
#define USBHS_HPTXFSIZ_HPTXFDEP                        ((uint32_t)0xFFFF0000U)

/** Bit definition for USBHS_DINEPPTXFSIZ1/2/3/4/5/6/7/8 register **/
#define USBHS_DINEPPTXFSIZ_INEPTXSADD_POS                   (0U)
#define USBHS_DINEPPTXFSIZ_INEPTXSADD                       ((uint32_t)0x0000FFFFU)
#define USBHS_DINEPPTXFSIZ_INEPTXFDEP_POS                   (16U)
#define USBHS_DINEPPTXFSIZ_INEPTXFDEP                       ((uint32_t)0xFFFF0000U)

/** Bit definition for USBHS_HCFG register **/
#define USBHS_HCFG_SPSEL_POS                           (2U)
#define USBHS_HCFG_SPSEL                               ((uint32_t)0x00000004U)

/** Bit definition for USBHS_HFRI register **/
#define USBHS_HFRI_FRI_POS                             (0U)
#define USBHS_HFRI_FRI                                 ((uint32_t)0x0000FFFFU)
#define USBHS_HFRI_DRLDEN_POS                          (16U)
#define USBHS_HFRI_DRLDEN                              ((uint32_t)0x00010000U)

/** Bit definition for USBHS_HFNUM register **/
#define USBHS_HFNUM_FRNUM_POS                          (0U)
#define USBHS_HFNUM_FRNUM                              ((uint32_t)0x0000FFFFU)
#define USBHS_HFNUM_FRT_POS                            (16U)
#define USBHS_HFNUM_FRT                                ((uint32_t)0xFFFF0000U)

/** Bit definition for USBHS_HPTXFQSTS register **/
#define USBHS_HPTXFQSTS_PTXFSAVL_POS                   (0U)
#define USBHS_HPTXFQSTS_PTXFSAVL                       ((uint32_t)0x0000FFFFU)
#define USBHS_HPTXFQSTS_PTXRQSAV_POS                   (16U)
#define USBHS_HPTXFQSTS_PTXRQSAV                       ((uint32_t)0x007F0000U)
#define USBHS_HPTXFQSTS_PTXRQTOP_POS                   (23U)
#define USBHS_HPTXFQSTS_PTXRQTOP                       ((uint32_t)0xFF800000U)
#define USBHS_HPTXFQSTS_PTXRQTOP_END_POS               (23U)
#define USBHS_HPTXFQSTS_PTXRQTOP_END                   ((uint32_t)0x00800000U)
#define USBHS_HPTXFQSTS_PTXRQTOP_PEND_POS              (24U)
#define USBHS_HPTXFQSTS_PTXRQTOP_PEND                  ((uint32_t)0x01000000U)
#define USBHS_HPTXFQSTS_PTXRQTOP_TOKEN_POS             (25U)
#define USBHS_HPTXFQSTS_PTXRQTOP_TOKEN                 ((uint32_t)0x06000000U)
#define USBHS_HPTXFQSTS_PTXRQTOP_CHNUM_POS             (27U)
#define USBHS_HPTXFQSTS_PTXRQTOP_CHNUM                 ((uint32_t)0x78000000U)
#define USBHS_HPTXFQSTS_PTXRQTOP_OEFRM_POS             (31U)
#define USBHS_HPTXFQSTS_PTXRQTOP_OEFRM                 ((uint32_t)0x80000000U)



/** Bit definition for USBHS_HACHINT register **/
#define USBHS_HACHINT_POS                              (0U)
#define USBHS_HACHINT                                  ((uint32_t)0x0000FFFFU)

/** Bit definition for USBHS_HACHINTEN register **/
#define USBHS_HACHINTEN_POS                            (0U)
#define USBHS_HACHINTEN                                ((uint32_t)0x0000FFFFU)

/** Bit definition for USBHS_HPCS register **/
#define USBHS_HPCS_PCSTS_POS                           (0U)
#define USBHS_HPCS_PCSTS                               ((uint32_t)0x00000001U)
#define USBHS_HPCS_PCDET_POS                           (1U)
#define USBHS_HPCS_PCDET                               ((uint32_t)0x00000002U)
#define USBHS_HPCS_PEN_POS                             (2U)
#define USBHS_HPCS_PEN                                 ((uint32_t)0x00000004U)
#define USBHS_HPCS_PENC_POS                            (3U)
#define USBHS_HPCS_PENC                                ((uint32_t)0x00000008U)
#define USBHS_HPCS_POCA_POS                            (4U)
#define USBHS_HPCS_POCA                                ((uint32_t)0x00000010U)
#define USBHS_HPCS_POCC_POS                            (5U)
#define USBHS_HPCS_POCC                                ((uint32_t)0x00000020U)
#define USBHS_HPCS_PRES_POS                            (6U)
#define USBHS_HPCS_PRES                                ((uint32_t)0x00000040U)
#define USBHS_HPCS_PSUSP_POS                           (7U)
#define USBHS_HPCS_PSUSP                               ((uint32_t)0x00000080U)
#define USBHS_HPCS_PRST_POS                            (8U)
#define USBHS_HPCS_PRST                                ((uint32_t)0x00000100U)
#define USBHS_HPCS_PLSTS_POS                           (10U)
#define USBHS_HPCS_PLSTS                               ((uint32_t)0x00000C00U)
#define USBHS_HPCS_PPWR_POS                            (12U)
#define USBHS_HPCS_PPWR                                ((uint32_t)0x00001000U)
#define USBHS_HPCS_PTCTRL_POS                          (13U)
#define USBHS_HPCS_PTCTRL                              ((uint32_t)0x0001E000U)
#define USBHS_HPCS_PSPD_POS                            (17U)
#define USBHS_HPCS_PSPD                                ((uint32_t)0x00060000U)

/** Bit definition for USBHS_HCHCTRL(0~15) register **/
#define USBHS_HCHCTRL_MPS_POS                          (0U)
#define USBHS_HCHCTRL_MPS                              ((uint32_t)0x000007FFU)
#define USBHS_HCHCTRL_EPNUM_POS                        (11U)
#define USBHS_HCHCTRL_EPNUM                            ((uint32_t)0x00007800U)
#define USBHS_HCHCTRL_EPDIR_POS                        (15U)
#define USBHS_HCHCTRL_EPDIR                            ((uint32_t)0x00008000U)
#define USBHS_HCHCTRL_LSPDDEV_POS                      (17U)
#define USBHS_HCHCTRL_LSPDDEV                          ((uint32_t)0x00020000U)
#define USBHS_HCHCTRL_EPTYPE_POS                       (18U)
#define USBHS_HCHCTRL_EPTYPE                           ((uint32_t)0x000C0000U)
#define USBHS_HCHCTRL_DEVADDR_POS                      (22U)
#define USBHS_HCHCTRL_DEVADR                           ((uint32_t)0x1FC00000U)
#define USBHS_HCHCTRL_ODDFRM_POS                       (29U)
#define USBHS_HCHCTRL_ODDFRM                           ((uint32_t)0x20000000U)
#define USBHS_HCHCTRL_CHDIS_POS                        (30U)
#define USBHS_HCHCTRL_CHDIS                            ((uint32_t)0x40000000U)
#define USBHS_HCHCTRL_CHEN_POS                         (31U)
#define USBHS_HCHCTRL_CHEN                             ((uint32_t)0x80000000U)

/** Bit definition for USBHS_HCHSCTRL(0~15) register **/
#define USBHS_HCHSCTRL_PRTADD_POS                      (0U)
#define USBHS_HCHSCTRL_PRTADD                          ((uint32_t)0x0000007FU)
#define USBHS_HCHSCTRL_HUBADD_POS                      (7U)
#define USBHS_HCHSCTRL_HUBADD                          ((uint32_t)0x00003FC0U)
#define USBHS_HCHSCTRL_TRANPOS_POS                     (14U)
#define USBHS_HCHSCTRL_TRANPOS                         ((uint32_t)0x0000C000U)
#define USBHS_HCHSCTRL_COMPSPLF_POS                    (16U)
#define USBHS_HCHSCTRL_COMPSPLF                        ((uint32_t)0x00010000U)
#define USBHS_HCHCTRL_SPLEN_POS                        (31U)
#define USBHS_HCHCTRL_SPLEN                            ((uint32_t)0x80000000U)

/** Bit definition for USBHS_HCINTSTS(0~15) register **/
#define USBHS_HCHINTSTS_TXCFIF_POS                     (0U)
#define USBHS_HCHINTSTS_TXCFIF                         ((uint32_t)0x00000001U)
#define USBHS_HCHINTSTS_CHHTDIF_POS                    (1U)
#define USBHS_HCHINTSTS_CHHTDIF                        ((uint32_t)0x00000002U)
#define USBHS_HCHINTSTS_AHBERRIF_POS                   (2U)
#define USBHS_HCHINTSTS_AHBERRIF                       ((uint32_t)0x00000004U)
#define USBHS_HCHINTSTS_STALLIF_POS                    (3U)
#define USBHS_HCHINTSTS_STALLIF                        ((uint32_t)0x00000008U)
#define USBHS_HCHINTSTS_NAKIF_POS                      (4U)
#define USBHS_HCHINTSTS_NAKIF                          ((uint32_t)0x00000010U)
#define USBHS_HCHINTSTS_ACKIF_POS                      (5U)
#define USBHS_HCHINTSTS_ACKIF                          ((uint32_t)0x00000020U)
#define USBHS_HCHINTSTS_NYETIF_POS                     (6U)
#define USBHS_HCHINTSTS_NYETIF                         ((uint32_t)0x00000040U)
#define USBHS_HCHINTSTS_TXERRIF_POS                    (7U)
#define USBHS_HCHINTSTS_TXERRIF                        ((uint32_t)0x00000080U)
#define USBHS_HCHINTSTS_BBERRIF_POS                    (8U)
#define USBHS_HCHINTSTS_BBERRIF                        ((uint32_t)0x00000100U)
#define USBHS_HCHINTSTS_FOVRIF_POS                     (9U)
#define USBHS_HCHINTSTS_FOVRIF                         ((uint32_t)0x00000200U)
#define USBHS_HCHINTSTS_DTERRIF_POS                    (10U)
#define USBHS_HCHINTSTS_DTERRIF                        ((uint32_t)0x00000400U)

/** Bit definition for USBHS_HCHINTEN(0~15) register **/
#define USBHS_HCHINTEN_TXCIEN_POS                      (0U)
#define USBHS_HCHINTEN_TXCIEN                          ((uint32_t)0x00000001U)
#define USBHS_HCHINTEN_CHHTDIEN_POS                    (1U)
#define USBHS_HCHINTEN_CHHTDIEN                        ((uint32_t)0x00000002U)
#define USBHS_HCHINTEN_AHBERRIEN_POS                   (2U)
#define USBHS_HCHINTEN_AHBERRIEN                       ((uint32_t)0x00000004U)
#define USBHS_HCHINTEN_STALLIEN_POS                    (3U)
#define USBHS_HCHINTEN_STALLIEN                        ((uint32_t)0x00000008U)
#define USBHS_HCHINTEN_NAKIEN_POS                      (4U)
#define USBHS_HCHINTEN_NAKIEN                          ((uint32_t)0x00000010U)
#define USBHS_HCHINTEN_ACKIEN_POS                      (5U)
#define USBHS_HCHINTEN_ACKIEN                          ((uint32_t)0x00000020U)
#define USBHS_HCHINTEN_NYETIEN_POS                     (6U)
#define USBHS_HCHINTEN_NYETIEN                         ((uint32_t)0x00000020U)
#define USBHS_HCHINTEN_TXERRIEN_POS                    (7U)
#define USBHS_HCHINTEN_TXERRIEN                        ((uint32_t)0x00000080U)
#define USBHS_HCHINTEN_BBERRIEN_POS                    (8U)
#define USBHS_HCHINTEN_BBERRIEN                        ((uint32_t)0x00000100U)
#define USBHS_HCHINTEN_FOVRIEN_POS                     (9U)
#define USBHS_HCHINTEN_FOVRIEN                         ((uint32_t)0x00000200U)
#define USBHS_HCHINTEN_DTERRIEN_POS                    (10U)
#define USBHS_HCHINTEN_DTERRIEN                        ((uint32_t)0x00000400U)

/** Bit definition for USBHS_HCHTXSIZ(0~15) register **/
#define USBHS_HCHTXSIZ_TXSIZ_POS                       (0U)
#define USBHS_HCHTXSIZ_TXSIZ                           ((uint32_t)0x0007FFFFU)
#define USBHS_HCHTXSIZ_PKCNT_POS                       (19U)
#define USBHS_HCHTXSIZ_PKCNT                           ((uint32_t)0x1FF80000U)
#define USBHS_HCHTXSIZ_PID_POS                         (29U)
#define USBHS_HCHTXSIZ_PID                             ((uint32_t)0x60000000U)
#define USBHS_HCHCTRL_DPING_POS                        (31U)
#define USBHS_HCHCTRL_DPING                            ((uint32_t)0x80000000U)

/** Bit definition for USBHS_HCDMA(0~15) register **/
#define USBHS_HCDMA                                    ((uint32_t)0xFFFFFFFFU)

/** Bit definition for USBHS_DCFG register **/
#define USBHS_DCFG_DEVSPD_POS                          (0U)
#define USBHS_DCFG_DEVSPD                              ((uint32_t)0x00000003U)
#define USBHS_DCFG_NZLSOUTHSK_POS                      (2U)
#define USBHS_DCFG_NZLSOUTHSK                          ((uint32_t)0x00000004U)
#define USBHS_DCFG_DEVARR_POS                          (4U)
#define USBHS_DCFG_DEVARR                              ((uint32_t)0x000007F0U)
#define USBHS_DCFG_PFRITVL_POS                         (11U)
#define USBHS_DCFG_PFRITVL                             ((uint32_t)0x00001800U)
#define USBHS_DCFG_XCVDRLY_POS                         (14U)
#define USBHS_DCFG_XCVDRLY                             ((uint32_t)0x00004000U)
#define USBHS_DCFG_EERRAIEN_POS                        (15U)
#define USBHS_DCFG_EERRAIEN                            ((uint32_t)0x00008000U)
#define USBHS_DCFG_PSITVL_POS                          (24U)
#define USBHS_DCFG_PSITVL                              ((uint32_t)0x03000000U)

/** Bit definition for USBHS_DCTRL register **/
#define USBHS_DCTRL_RMWKUP_POS                         (0U)
#define USBHS_DCTRL_RMWKUP                             ((uint32_t)0x00000001U)
#define USBHS_DCTRL_SFTDIS_POS                         (1U)
#define USBHS_DCTRL_SFTDIS                             ((uint32_t)0x00000002U)
#define USBHS_DCTRL_GINAKSTS_POS                       (2U)
#define USBHS_DCTRL_GINAKSTS                           ((uint32_t)0x00000004U)
#define USBHS_DCTRL_GONAKSTS_POS                       (3U)
#define USBHS_DCTRL_GONAKSTS                           ((uint32_t)0x00000008U)
#define USBHS_DCTRL_TSCTRL_POS                         (4U)
#define USBHS_DCTRL_TSCTRL                             ((uint32_t)0x00000070U)
#define USBHS_DCTRL_SGINAK_POS                         (7U)
#define USBHS_DCTRL_SGINAK                             ((uint32_t)0x00000080U)
#define USBHS_DCTRL_CGNPINAK_POS                       (8U)
#define USBHS_DCTRL_CGNPINAK                           ((uint32_t)0x00000100U)
#define USBHS_DCTRL_SGONAK_POS                         (9U)
#define USBHS_DCTRL_SGONAK                             ((uint32_t)0x00000200U)
#define USBHS_DCTRL_CGONAK_POS                         (10U)
#define USBHS_DCTRL_CGONAK                             ((uint32_t)0x00000400U)
#define USBHS_DCTRL_POPDNE_POS                         (11U)
#define USBHS_DCTRL_POPDNE                             ((uint32_t)0x00000800U)
#define USBHS_DCTRL_NAKOBBLE_POS                       (16U)
#define USBHS_DCTRL_NAKOBBLE                           ((uint32_t)0x00010000U)

/** Bit definition for USBHS_DSTS register **/
#define USBHS_DSTS_SUSPF_POS                           (0U)
#define USBHS_DSTS_SUSPF                               ((uint32_t)0x00000001U)
#define USBHS_DSTS_ENUMSPD_POS                         (1U)
#define USBHS_DSTS_ENUMSPD                             ((uint32_t)0x00000006U)
#define USBHS_DSTS_ERERRF_POS                          (3U)
#define USBHS_DSTS_ERERRF                              ((uint32_t)0x00000008U)
#define USBHS_DSTS_SOFFN_POS                           (8U)
#define USBHS_DSTS_SOFFN                               ((uint32_t)0x003FFF00U)
#define USBHS_DSTS_DEVLINSTS_POS                       (22U)
#define USBHS_DSTS_DEVLINSTS                           ((uint32_t)0x00C00000U)

/** Bit definition for USBHS_DINEPINTEN register **/
#define USBHS_DINEPINTEN_TXCIEN_POS                    (0U)
#define USBHS_DINEPINTEN_TXCIEN                        ((uint32_t)0x00000001U)
#define USBHS_DINEPINTEN_EPDIEN_POS                    (1U)
#define USBHS_DINEPINTEN_EPDIEN                        ((uint32_t)0x00000002U)
#define USBHS_DINEPINTEN_AHBERRIEN_POS                 (2U)
#define USBHS_DINEPINTEN_AHBERRIEN                     ((uint32_t)0x00000004U)
#define USBHS_DINEPINTEN_TOIEN_POS                     (3U)
#define USBHS_DINEPINTEN_TOIEN                         ((uint32_t)0x00000008U)
#define USBHS_DINEPINTEN_TXFERINTKIEN_POS              (4U)
#define USBHS_DINEPINTEN_TXFERINTKIEN                  ((uint32_t)0x00000010U)
#define USBHS_DINEPINTEN_INTREPMISIEN_POS              (5U)
#define USBHS_DINEPINTEN_INTREPMISIEN                  ((uint32_t)0x00000020U)
#define USBHS_DINEPINTEN_INEPNAKEIEN_POS               (6U)
#define USBHS_DINEPINTEN_INEPNAKEIEN                   ((uint32_t)0x00000040U)
#define USBHS_DINEPINTEN_TXFUDIEN_POS                  (8U)
#define USBHS_DINEPINTEN_TXFUDIEN                      ((uint32_t)0x00000100U)
#define USBHS_DINEPINTEN_NAKIEN_POS                    (13U)
#define USBHS_DINEPINTEN_NAKIEN                        ((uint32_t)0x00002000U)

/** Bit definition for USBHS_DOUTEPINTEN register **/
#define USBHS_DOUTEPINTEN_TXCIEN_POS                   (0U)
#define USBHS_DOUTEPINTEN_TXCIEN                       ((uint32_t)0x00000001U)
#define USBHS_DOUTEPINTEN_EPDIEN_POS                   (1U)
#define USBHS_DOUTEPINTEN_EPDIEN                       ((uint32_t)0x00000002U)
#define USBHS_DOUTEPINTEN_AHBERRIEN_POS                (2U)
#define USBHS_DOUTEPINTEN_AHBERRIEN                    ((uint32_t)0x00000004U)
#define USBHS_DOUTEPINTEN_STUPDNEIEN_POS               (3U)
#define USBHS_DOUTEPINTEN_STUPDNEIEN                   ((uint32_t)0x00000008U)
#define USBHS_DOUTEPINTEN_EPDISROTIEN_POS              (4U)
#define USBHS_DOUTEPINTEN_EPDISROTIEN                  ((uint32_t)0x00000010U)
#define USBHS_DOUTEPINTEN_B2BSTUPIEN_POS               (6U)
#define USBHS_DOUTEPINTEN_B2BSTUPIEN                   ((uint32_t)0x00000040U)
#define USBHS_DOUTEPINTEN_OPERRIEN_POS                 (8U)
#define USBHS_DOUTEPINTEN_OPERRIEN                     ((uint32_t)0x00000100U)
#define USBHS_DOUTEPINTEN_BERRIEN_POS                  (12U)
#define USBHS_DOUTEPINTEN_BERRIEN                      ((uint32_t)0x00001000U)
#define USBHS_DOUTEPINTEN_NAKIEN_POS                   (13U)
#define USBHS_DOUTEPINTEN_NAKIEN                       ((uint32_t)0x00002000U)
#define USBHS_DOUTEPINTEN_NYETIEN_POS                  (14U)
#define USBHS_DOUTEPINTEN_NYETIEN                      ((uint32_t)0x00004000U)

/** Bit definition for USBHS_DAEPINTSTS register **/
#define USBHS_DAEPINTSTS_INEPINT_POS                   (0U)
#define USBHS_DAEPINTSTS_IEPINT                        ((uint32_t)0x000001FFU)
#define USBHS_DAEPINTSTS_OUTEPINT_POS                  (16U)
#define USBHS_DAEPINTSTS_OUTEPINT                      ((uint32_t)0x01FF0000U)

/** Bit definition for USBHS_DAEPINTEN register **/
#define USBHS_DAEPINTEN_INEPIEN_POS                    (0U)
#define USBHS_DAEPINTEN_INEPIEN                        ((uint32_t)0x000001FFU)
#define USBHS_DAEPINTEN_OUTEPIEN_POS                   (16U)
#define USBHS_DAEPINTEN_OUTEPIEN                       ((uint32_t)0x01FF0000U)

/** Bit definition for USBHS_DTHRCTRL register **/
#define USBHS_DTHRCTRL_NISOINEPTHREN_POS               (0U)
#define USBHS_DTHRCTRL_NISOINEPTHREN                   ((uint32_t)0x00000001U)
#define USBHS_DTHRCTRL_ISOINEPTHREN_POS                (1U)
#define USBHS_DTHRCTRL_ISOINEPTHREN                    ((uint32_t)0x00000002U)
#define USBHS_DTHRCTRL_TXTHRLEN_POS                    (2U)
#define USBHS_DTHRCTRL_TXTHRLEN                        ((uint32_t)0x000007FCU)
#define USBHS_DTHRCTRL_RXTHREN_POS                     (16U)
#define USBHS_DTHRCTRL_RXTHREN                         ((uint32_t)0x00010000U)
#define USBHS_DTHRCTRL_RXTHRLEN_POS                    (17U)
#define USBHS_DTHRCTRL_RXTHRLEN                        ((uint32_t)0x03FE0000U)
#define USBHS_DTHRCTRL_ARPEN_POS                       (27U)
#define USBHS_DTHRCTRL_ARPEN                           ((uint32_t)0x08000000U)

/** Bit definition for USBHS_DINEPFEINTEN register **/
#define USBHS_DINEPFEINTEN_INEPTXFEIEN                 ((uint32_t)0x0000FFFFU)

/** Bit definition for USBHS_DEEPINTSTS register **/
#define USBHS_DEEPINTSTS_INEPINT_POS                   (0U)
#define USBHS_DEEPINTSTS_IEPINT                        ((uint32_t)0x000000FFU)
#define USBHS_DEEPINTSTS_OUTEPINT_POS                  (16U)
#define USBHS_DEEPINTSTS_OUTEPINT                      ((uint32_t)0x00FF0000U)

/** Bit definition for USBHS_DEEPINTEN register **/
#define USBHS_DEEPINTEN_INEPIEN_POS                    (0U)
#define USBHS_DEEPINTEN_INEPIEN                        ((uint32_t)0x000000FFU)
#define USBHS_DEEPINTEN_OUTEPIEN_POS                   (16U)
#define USBHS_DEEPINTEN_OUTEPIEN                       ((uint32_t)0x00FF0000U)

/** Bit definition for USBHS_DINEPXINTEN(0~8) register **/
#define USBHS_DINEPXINTEN_TXCIEN_POS                   (0U)
#define USBHS_DINEPXINTEN_TXCIEN                       ((uint32_t)0x00000001U)
#define USBHS_DINEPXINTEN_EPDISIEN_POS                 (1U)
#define USBHS_DINEPXINTEN_EPDISIEN                     ((uint32_t)0x00000002U)
#define USBHS_DINEPXINTEN_AHBERRIEN_POS                (2U)
#define USBHS_DINEPXINTEN_AHBERRIEN                    ((uint32_t)0x00000004U)
#define USBHS_DINEPXINTEN_TOIEN_POS                    (3U)
#define USBHS_DINEPXINTEN_TOIEN                        ((uint32_t)0x00000008U)
#define USBHS_DINEPXINTEN_TXFERINTKIEN_POS             (4U)
#define USBHS_DINEPXINTEN_TXFERINTKIEN                 ((uint32_t)0x00000010U)
#define USBHS_DINEPXINTEN_INTREPMISIEN_POS             (5U)
#define USBHS_DINEPXINTEN_INTREPMISIEN                 ((uint32_t)0x00000020U)
#define USBHS_DINEPXINTEN_INEPNAKEIEN_POS              (6U)
#define USBHS_DINEPXINTEN_INEPNAKEIEN                  ((uint32_t)0x00000040U)
#define USBHS_DINEPXINTEN_TXFUDIEN_POS                 (8U)
#define USBHS_DINEPXINTEN_TXFUDIEN                     ((uint32_t)0x00000100U)
#define USBHS_DINEPXINTEN_NAKIEN_POS                   (13U)
#define USBHS_DINEPXINTEN_NAKIEN                       ((uint32_t)0x00002000U)

/** Bit definition for USBHS_DOUTEPXINTEN(0~8) register **/
#define USBHS_DOUTEPXINTEN_TXCIEN_POS                  (0U)
#define USBHS_DOUTEPXINTEN_TXCIEN                      ((uint32_t)0x00000001U)
#define USBHS_DOUTEPXINTEN_EPDIEN_POS                  (1U)
#define USBHS_DOUTEPXINTEN_EPDIEN                      ((uint32_t)0x00000002U)
#define USBHS_DOUTEPXINTEN_AHBERRIEN_POS               (2U)
#define USBHS_DOUTEPXINTEN_AHBERRIEN                   ((uint32_t)0x00000004U)
#define USBHS_DOUTEPXINTEN_STUPDNEIEN_POS              (3U)
#define USBHS_DOUTEPXINTEN_STUPDNEIEN                  ((uint32_t)0x00000008U)
#define USBHS_DOUTEPXINTEN_EPDISROTIEN_POS             (4U)
#define USBHS_DOUTEPXINTEN_EPDISROTIEN                 ((uint32_t)0x00000010U)
#define USBHS_DOUTEPXINTEN_B2BSTUPIEN_POS              (6U)
#define USBHS_DOUTEPXINTEN_B2BSTUPIEN                  ((uint32_t)0x00000040U)
#define USBHS_DOUTEPXINTEN_OPERRIEN_POS                (8U)
#define USBHS_DOUTEPXINTEN_OPERRIEN                    ((uint32_t)0x00000100U)
#define USBHS_DOUTEPXINTEN_BERRIEN_POS                 (12U)
#define USBHS_DOUTEPXINTEN_BERRIEN                     ((uint32_t)0x00001000U)
#define USBHS_DOUTEPXINTEN_NAKIEN_POS                  (13U)
#define USBHS_DOUTEPXINTEN_NAKIEN                      ((uint32_t)0x00002000U)
#define USBHS_DOUTEPXINTEN_NYETIEN_POS                 (14U)
#define USBHS_DOUTEPXINTEN_NYETIEN                     ((uint32_t)0x00004000U)

/** Bit definition for USBHS_DINEP0CTRL register **/
#define USBHS_DINEP0CTRL_MPLEN_POS                     (0U)
#define USBHS_DINEP0CTRL_MPLEN                         ((uint32_t)0x00000003U)
#define USBHS_DINEP0CTRL_EPACT_POS                     (15U)
#define USBHS_DINEP0CTRL_EPACT                         ((uint32_t)0x00008000U)
#define USBHS_DINEP0CTRL_NAKSTS_POS                    (17U)
#define USBHS_DINEP0CTRL_NAKSTS                        ((uint32_t)0x00020000U)
#define USBHS_DINEP0CTRL_EPTYPE_POS                    (18U)
#define USBHS_DINEP0CTRL_EPTYPE                        ((uint32_t)0x000C0000U)
#define USBHS_DINEP0CTRL_STALL_POS                     (21U)
#define USBHS_DINEP0CTRL_STALL                         ((uint32_t)0x00200000U)
#define USBHS_DINEP0CTRL_TXFNUM_POS                    (22U)
#define USBHS_DINEP0CTRL_TXFNUM                        ((uint32_t)0x03C00000U)
#define USBHS_DINEP0CTRL_CNAK_POS                      (26U)
#define USBHS_DINEP0CTRL_CNAK                          ((uint32_t)0x04000000U)
#define USBHS_DINEP0CTRL_SNAK_POS                      (27U)
#define USBHS_DINEP0CTRL_SNAK                          ((uint32_t)0x08000000U)
#define USBHS_DINEP0CTRL_EPDIS_POS                     (30U)
#define USBHS_DINEP0CTRL_EPDIS                         ((uint32_t)0x40000000U)
#define USBHS_DINEP0CTRL_EPEN_POS                      (31U)
#define USBHS_DINEP0CTRL_EPEN                          ((uint32_t)0x80000000U)

/** Bit definition for USBHS_DINEPCTRL(1~8) register **/
#define USBHS_DINEPCTRL_MPLEN_POS                      (0U)
#define USBHS_DINEPCTRL_MPLEN                          ((uint32_t)0x000007FFU)
#define USBHS_DINEPCTRL_EPACT_POS                      (15U)
#define USBHS_DINEPCTRL_EPACT                          ((uint32_t)0x00008000U)
#define USBHS_DINEPCTRL_EPDPID_EPEOFRM_POS             (16U)
#define USBHS_DINEPCTRL_EPDPID_EPEOFRM                 ((uint32_t)0x00010000U)
#define USBHS_DINEPCTRL_NAKSTS_POS                     (17U)
#define USBHS_DINEPCTRL_NAKSTS                         ((uint32_t)0x00020000U)
#define USBHS_DINEPCTRL_EPTYPE_POS                     (18U)
#define USBHS_DINEPCTRL_EPTYPE                         ((uint32_t)0x000C0000U)
#define USBHS_DINEPCTRL_STALL_POS                      (21U)
#define USBHS_DINEPCTRL_STALL                          ((uint32_t)0x00200000U)
#define USBHS_DINEPCTRL_TXFNUM_POS                     (22U)
#define USBHS_DINEPCTRL_TXFNUM                         ((uint32_t)0x03C00000U)
#define USBHS_DINEPCTRL_CNAK_POS                       (26U)
#define USBHS_DINEPCTRL_CNAK                           ((uint32_t)0x04000000U)
#define USBHS_DINEPCTRL_SNAK_POS                       (27U)
#define USBHS_DINEPCTRL_SNAK                           ((uint32_t)0x08000000U)
#define USBHS_DINEPCTRL_SD0PID_SEVNFRM_POS             (28U)
#define USBHS_DINEPCTRL_SD0PID_SEVNFRM                 ((uint32_t)0x10000000U)
#define USBHS_DINEPCTRL_SD1PID_SODDFRM_POS             (29U)
#define USBHS_DINEPCTRL_SD1PID_SODDFRM                 ((uint32_t)0x20000000U)
#define USBHS_DINEPCTRL_EPDIS_POS                      (30U)
#define USBHS_DINEPCTRL_EPDIS                          ((uint32_t)0x40000000U)
#define USBHS_DINEPCTRL_EPEN_POS                       (31U)
#define USBHS_DINEPCTRL_EPEN                           ((uint32_t)0x80000000U)

/** Bit definition for USBHS_DINEPINTSTS(0~8) register **/
#define USBHS_DINEPINTSTS_TXCIF_POS                    (0U)
#define USBHS_DINEPINTSTS_TXCIF                        ((uint32_t)0x00000001U)
#define USBHS_DINEPINTSTS_EPDISIF_POS                  (1U)
#define USBHS_DINEPINTSTS_EPDISIF                      ((uint32_t)0x00000002U)
#define USBHS_DINEPINTSTS_AHBERRIF_POS                 (2U)
#define USBHS_DINEPINTSTS_AHBERRIF                     ((uint32_t)0x00000004U)
#define USBHS_DINEPINTSTS_TOUTIF_POS                   (3U)
#define USBHS_DINEPINTSTS_TOUTIF                       ((uint32_t)0x00000008U)
#define USBHS_DINEPINTSTS_TXFERINTIF_POS               (4U)
#define USBHS_DINEPINTSTS_TXFERINTIF                   ((uint32_t)0x00000010U)
#define USBHS_DINEPINTSTS_INEPMISIF_POS                (5U)
#define USBHS_DINEPINTSTS_INEPMISIF                    ((uint32_t)0x00000020U)
#define USBHS_DINEPINTSTS_INEPNAKEIF_POS               (6U)
#define USBHS_DINEPINTSTS_INEPNAKEIF                   ((uint32_t)0x00000040U)
#define USBHS_DINEPINTSTS_TXFEIF_POS                   (7U)
#define USBHS_DINEPINTSTS_TXFEIF                       ((uint32_t)0x00000080U)
#define USBHS_DINEPINTSTS_TXFUDRIF_POS                 (8U)
#define USBHS_DINEPINTSTS_TXFUDRIF                     ((uint32_t)0x00000100U)
#define USBHS_DINEPINTSTS_PKDRPSTS_POS                 (11U)
#define USBHS_DINEPINTSTS_PKDRPSTS                     ((uint32_t)0x00000800U)
#define USBHS_DINEPINTSTS_BBERRIF_POS                  (12U)
#define USBHS_DINEPINTSTS_BBERRIF                      ((uint32_t)0x00001000U)
#define USBHS_DINEPINTSTS_NAKIF_POS                    (13U)
#define USBHS_DINEPINTSTS_NAKIF                        ((uint32_t)0x00002000U)
#define USBHS_DINEPINTSTS_NYETIF_POS                   (14U)
#define USBHS_DINEPINTSTS_NYETIF                       ((uint32_t)0x00004000U)

/** Bit definition for USBHS_DINEP0TXSIZ register **/
#define USBHS_DINEP0TXSIZ_TLEN_POS                     (0U)
#define USBHS_DINEP0TXSIZ_TLEN                         ((uint32_t)0x0000007FU)
#define USBHS_DINEP0TXSIZ_PKTCNT_POS                   (19U)
#define USBHS_DINEP0TXSIZ_PKTCNT                       ((uint32_t)0x00180000U)

/** Bit definition for USBHS_DINEPTXSIZ(1~8) register **/
#define USBHS_DINEPTXSIZ_TLEN_POS                      (0U)
#define USBHS_DINEPTXSIZ_TLEN                          ((uint32_t)0x0007FFFFU)
#define USBHS_DINEPTXSIZ_PKTCNT_POS                    (19U)
#define USBHS_DINEPTXSIZ_PKTCNT                        ((uint32_t)0x1FF80000U)
#define USBHS_DINEPTXSIZ_MCNT_POS                      (29U)
#define USBHS_DINEPTXSIZ_MCNT                          ((uint32_t)0x60000000U)

/** Bit definition for USBHS_DIEPDMADD(0~8) register **/
#define USBHS_DIEPDMADD_DMADD_POS                      (0U)
#define USBHS_DIEPDMADD_DMADD                          ((uint32_t)0xFFFFFFFFU)

/** Bit definition for USBHS_DINEPTXFSTS(0~8) register **/
#define USBHS_DINEPTXFSTS_TXFSPCAVL_POS                (0U)
#define USBHS_DINEPTXFSTS_TXFSPCAVL                    ((uint32_t)0x0000FFFFU)

/** Bit definition for USBHS_DOUTEP0CTRL register **/
#define USBHS_DOUTEP0CTRL_MPLEN_POS                    (0U)
#define USBHS_DOUTEP0CTRL_MPLEN                        ((uint32_t)0x00000003U)
#define USBHS_DOUTEP0CTRL_EPACT_POS                    (15U)
#define USBHS_DOUTEP0CTRL_EPACT                        ((uint32_t)0x00008000U)
#define USBHS_DOUTEP0CTRL_NAKSTS_POS                   (17U)
#define USBHS_DOUTEP0CTRL_NAKSTS                       ((uint32_t)0x00020000U)
#define USBHS_DOUTEP0CTRL_EPTYPE_POS                   (18U)
#define USBHS_DOUTEP0CTRL_EPTYPE                       ((uint32_t)0x000C0000U)
#define USBHS_DOUTEP0CTRL_STALL_POS                    (21U)
#define USBHS_DOUTEP0CTRL_STALL                        ((uint32_t)0x00200000U)
#define USBHS_DOUTEP0CTRL_CNAK_POS                     (26U)
#define USBHS_DOUTEP0CTRL_CNAK                         ((uint32_t)0x04000000U)
#define USBHS_DOUTEP0CTRL_SNAK_POS                     (27U)
#define USBHS_DOUTEP0CTRL_SNAK                         ((uint32_t)0x08000000U)
#define USBHS_DOUTEP0CTRL_EPDIS_POS                    (30U)
#define USBHS_DOUTEP0CTRL_EPDIS                        ((uint32_t)0x40000000U)
#define USBHS_DOUTEP0CTRL_EPEN_POS                     (31U)
#define USBHS_DOUTEP0CTRL_EPEN                         ((uint32_t)0x80000000U)


/** Bit definition for USBHS_DOUTEPCTRL(1~8) register **/
#define USBHS_DOUTEPCTRL_MPLEN_POS                     (0U)
#define USBHS_DOUTEPCTRL_MPLEN                         ((uint32_t)0x00000003U)
#define USBHS_DOUTEPCTRL_EPACT_POS                     (15U)
#define USBHS_DOUTEPCTRL_EPACT                         ((uint32_t)0x00008000U)
#define USBHS_DOUTEPCTRL_EPDPID_EPEOFRM_POS            (16U)
#define USBHS_DOUTEPCTRL_EPDPID_EPEOFRM                ((uint32_t)0x00010000U)
#define USBHS_DOUTEPCTRL_NAKSTS_POS                    (17U)
#define USBHS_DOUTEPCTRL_NAKSTS                        ((uint32_t)0x00020000U)
#define USBHS_DOUTEPCTRL_EPTYPE_POS                    (18U)
#define USBHS_DOUTEPCTRL_EPTYPE                        ((uint32_t)0x000C0000U)
#define USBHS_DOUTEPCTRL_STALL_POS                     (21U)
#define USBHS_DOUTEPCTRL_STALL                         ((uint32_t)0x00200000U)
#define USBHS_DOUTEPCTRL_CNAK_POS                      (26U)
#define USBHS_DOUTEPCTRL_CNAK                          ((uint32_t)0x04000000U)
#define USBHS_DOUTEPCTRL_SNAK_POS                      (27U)
#define USBHS_DOUTEPCTRL_SNAK                          ((uint32_t)0x08000000U)
#define USBHS_DOUTEPCTRL_SD0PID_SEVNFRM_POS            (28U)
#define USBHS_DOUTEPCTRL_SD0PID_SEVNFRM                ((uint32_t)0x10000000U)
#define USBHS_DOUTEPCTRL_SD1PID_SODDFRM_POS            (29U)
#define USBHS_DOUTEPCTRL_SD1PID_SODDFRM                ((uint32_t)0x20000000U)
#define USBHS_DOUTEPCTRL_EPDIS_POS                     (30U)
#define USBHS_DOUTEPCTRL_EPDIS                         ((uint32_t)0x40000000U)
#define USBHS_DOUTEPCTRL_EPEN_POS                      (31U)
#define USBHS_DOUTEPCTRL_EPEN                          ((uint32_t)0x80000000U)


/** Bit definition for USBHS_DOUTEPINTSTS(0~8) register **/
#define USBHS_DOUTEPINTSTS_TXCIF_POS                    (0U)
#define USBHS_DOUTEPINTSTS_TXCIF                        ((uint32_t)0x00000001U)
#define USBHS_DOUTEPINTSTS_EPDISIF_POS                  (1U)
#define USBHS_DOUTEPINTSTS_EPDISIF                      ((uint32_t)0x00000002U)
#define USBHS_DOUTEPINTSTS_AHBERRIF_POS                 (2U)
#define USBHS_DOUTEPINTSTS_AHBERRIF                     ((uint32_t)0x00000004U)
#define USBHS_DOUTEPINTSTS_STUPPDNEIF_POS               (3U)
#define USBHS_DOUTEPINTSTS_STUPPDNEIF                   ((uint32_t)0x00000008U)
#define USBHS_DOUTEPINTSTS_OUTTRXEPDISIF_POS            (4U)
#define USBHS_DOUTEPINTSTS_OUTTRXEPDISIF                ((uint32_t)0x00000010U)
#define USBHS_DOUTEPINTSTS_STSPRXIF_POS                 (5U)
#define USBHS_DOUTEPINTSTS_STSPRXIF                     ((uint32_t)0x00000020U)
#define USBHS_DOUTEPINTSTS_B2BSTUPRIF_POS               (6U)
#define USBHS_DOUTEPINTSTS_B2BSTUPRIF                   ((uint32_t)0x00000040U)
#define USBHS_DOUTEPINTSTS_OUTPCKERRIF_POS              (8U)
#define USBHS_DOUTEPINTSTS_OUTPCKERRIF                  ((uint32_t)0x00000100U)
#define USBHS_DOUTEPINTSTS_PKDRPSTS_POS                 (11U)
#define USBHS_DOUTEPINTSTS_PKDRPSTS                     ((uint32_t)0x00000800U)
#define USBHS_DOUTEPINTSTS_BBERRIF_POS                  (12U)
#define USBHS_DOUTEPINTSTS_BBERRIF                      ((uint32_t)0x00001000U)
#define USBHS_DOUTEPINTSTS_NAKIF_POS                    (13U)
#define USBHS_DOUTEPINTSTS_NAKIF                        ((uint32_t)0x00002000U)
#define USBHS_DOUTEPINTSTS_NYETIF_POS                   (14U)
#define USBHS_DOUTEPINTSTS_NYETIF                       ((uint32_t)0x00004000U)
#define USBHS_DOUTEPINTSTS_STUPPRXIF_POS                (15U)
#define USBHS_DOUTEPINTSTS_STUPPRXIF                    ((uint32_t)0x00008000U)


/** Bit definition for USBHS_DOUTEP0TXSIZ register **/
#define USBHS_DOUTEP0TXSIZ_TLEN_POS                    (0U)
#define USBHS_DOUTEP0TXSIZ_TLEN                        ((uint32_t)0x0000007FU)
#define USBHS_DOUTEP0TXSIZ_PKTCNT_POS                  (19U)
#define USBHS_DOUTEP0TXSIZ_PKTCNT                      ((uint32_t)0x00080000U)
#define USBHS_DOUTEP0TXSIZ_STUPPCNT_POS                (29U)
#define USBHS_DOUTEP0TXSIZ_STUPPCNT                    ((uint32_t)0x60000000U)

/** Bit definition for USBHS_DOUTEPTXSIZ(1~8) register **/
#define USBHS_DOUTEPTXSIZ_TLEN_POS                     (0U)
#define USBHS_DOUTEPTXSIZ_TLEN                         ((uint32_t)0x0007FFFFU)
#define USBHS_DOUTEPTXSIZ_PKTCNT_POS                   (19U)
#define USBHS_DOUTEPTXSIZ_PKTCNT                       ((uint32_t)0x1FF80000U)
#define USBHS_DOUTEPTXSIZ_STUPPCNT_POS                 (29U)
#define USBHS_DOUTEPTXSIZ_STUPPCNT_RXDPID              ((uint32_t)0x60000000U)

/** Bit definition for USBHS_DINEPDMADD(0~8) register **/
#define USBHS_DINEPDMADD_DMADD                         ((uint32_t)0xFFFFFFFFU)

/** Bit definition for USBHS_PWRCTRL register **/
#define USBHS_PWRCTRL_PHYSTP_POS                       (0U)
#define USBHS_PWRCTRL_PHYSTP                           ((uint32_t)0x00000001U)
#define USBHS_PWRCTRL_GATEHCLK_POS                     (1U)
#define USBHS_PWRCTRL_GATEHCLK                         ((uint32_t)0x00000002U)
#define USBHS_PWRCTRL_PDMRST_POS                       (3U)
#define USBHS_PWRCTRL_PDMRST                           ((uint32_t)0x00000008U)
#define USBHS_PWRCTRL_PHYSLEEP_POS                     (6U)
#define USBHS_PWRCTRL_PHYSLEEP                         ((uint32_t)0x00000040U)
#define USBHS_PWRCTRL_DSLEEP_POS                       (7U)
#define USBHS_PWRCTRL_DSLEEP                           ((uint32_t)0x00000080U)

/** Bit definition for USBHS_PWRCTRL1 register **/
#define USBHS_PWRCTRL1_GATEN_POS                       (0U)
#define USBHS_PWRCTRL1_GATEN                           ((uint32_t)0x00000001U)
#define USBHS_PWRCTRL1_CNT_POS                         (1U)
#define USBHS_PWRCTRL1_CNT                             ((uint32_t)0x00000006U)
#define USBHS_PWRCTRL1_RAMCLKEN_POS                    (3U)
#define USBHS_PWRCTRL1_RAMCLKEN                        ((uint32_t)0x00000008U)


/*** Flexible Datarate Controller Area Network ***/

/** Bit definition for FDCAN_CREL register **/
#define FDCAN_CREL_DAY          ((uint32_t)0x000000FFU)  /* Timestamp Day bits  */
#define FDCAN_CREL_DAY_0        ((uint32_t)0x00000001U)  /* Timestamp Day bit 0 */
#define FDCAN_CREL_DAY_1        ((uint32_t)0x00000002U)  /* Timestamp Day bit 1 */
#define FDCAN_CREL_DAY_2        ((uint32_t)0x00000004U)  /* Timestamp Day bit 2 */
#define FDCAN_CREL_DAY_3        ((uint32_t)0x00000008U)  /* Timestamp Day bit 3 */
#define FDCAN_CREL_DAY_4        ((uint32_t)0x00000010U)  /* Timestamp Day bit 4 */
#define FDCAN_CREL_DAY_5        ((uint32_t)0x00000020U)  /* Timestamp Day bit 5 */
#define FDCAN_CREL_DAY_6        ((uint32_t)0x00000040U)  /* Timestamp Day bit 6 */
#define FDCAN_CREL_DAY_7        ((uint32_t)0x00000080U)  /* Timestamp Day bit 7 */

#define FDCAN_CREL_MON          ((uint32_t)0x0000FF00U)  /* Timestamp Month bits  */
#define FDCAN_CREL_MON_0        ((uint32_t)0x00000100U)  /* Timestamp Month bit 0 */
#define FDCAN_CREL_MON_1        ((uint32_t)0x00000200U)  /* Timestamp Month bit 1 */
#define FDCAN_CREL_MON_2        ((uint32_t)0x00000400U)  /* Timestamp Month bit 2 */
#define FDCAN_CREL_MON_3        ((uint32_t)0x00000800U)  /* Timestamp Month bit 3 */
#define FDCAN_CREL_MON_4        ((uint32_t)0x00001000U)  /* Timestamp Month bit 4 */
#define FDCAN_CREL_MON_5        ((uint32_t)0x00002000U)  /* Timestamp Month bit 5 */
#define FDCAN_CREL_MON_6        ((uint32_t)0x00004000U)  /* Timestamp Month bit 6 */
#define FDCAN_CREL_MON_7        ((uint32_t)0x00008000U)  /* Timestamp Month bit 7 */

#define FDCAN_CREL_YEAR         ((uint32_t)0x000F0000U)  /* Timestamp Year bits  */
#define FDCAN_CREL_YEAR_0       ((uint32_t)0x00010000U)  /* Timestamp Year bit 0 */
#define FDCAN_CREL_YEAR_1       ((uint32_t)0x00020000U)  /* Timestamp Year bit 1 */
#define FDCAN_CREL_YEAR_2       ((uint32_t)0x00040000U)  /* Timestamp Year bit 2 */
#define FDCAN_CREL_YEAR_3       ((uint32_t)0x00080000U)  /* Timestamp Year bit 3 */

#define FDCAN_CREL_SUBSTEP      ((uint32_t)0x00F00000U)  /* Sub-step of Core release bits  */
#define FDCAN_CREL_SUBSTEP_0    ((uint32_t)0x00100000U)  /* Sub-step of Core release bit 0 */
#define FDCAN_CREL_SUBSTEP_1    ((uint32_t)0x00200000U)  /* Sub-step of Core release bit 1 */
#define FDCAN_CREL_SUBSTEP_2    ((uint32_t)0x00400000U)  /* Sub-step of Core release bit 2 */
#define FDCAN_CREL_SUBSTEP_3    ((uint32_t)0x00800000U)  /* Sub-step of Core release bit 3 */

#define FDCAN_CREL_STEP         ((uint32_t)0x0F000000U)  /* Step of Core release bits  */
#define FDCAN_CREL_STEP_0       ((uint32_t)0x01000000U)  /* Step of Core release bit 0 */
#define FDCAN_CREL_STEP_1       ((uint32_t)0x02000000U)  /* Step of Core release bit 1 */
#define FDCAN_CREL_STEP_2       ((uint32_t)0x04000000U)  /* Step of Core release bit 2 */
#define FDCAN_CREL_STEP_3       ((uint32_t)0x08000000U)  /* Step of Core release bit 3 */

#define FDCAN_CREL_REL          ((uint32_t)0xF0000000U)  /* Core release bits   */
#define FDCAN_CREL_REL_0        ((uint32_t)0x10000000U)  /* Core release bits 0 */
#define FDCAN_CREL_REL_1        ((uint32_t)0x20000000U)  /* Core release bits 1 */
#define FDCAN_CREL_REL_2        ((uint32_t)0x40000000U)  /* Core release bits 2 */
#define FDCAN_CREL_REL_3        ((uint32_t)0x80000000U)  /* Core release bits 3 */

/** Bit definition for FDCAN_ENDN register **/
#define FDCAN_ENDN_ETV          ((uint32_t)0xFFFFFFFFU)  /* Endianness Test Value */

/** Bit definition for FDCAN_DBTP register **/
#define FDCAN_DBTP_DSJW         ((uint32_t)0x0000000FU)  /* Synchronization Jump Width bits  */
#define FDCAN_DBTP_DTSEG2       ((uint32_t)0x000000F0U)  /* Data time segment after sample point bits  */
#define FDCAN_DBTP_DTSEG1       ((uint32_t)0x00001F00U)  /* Data time segment before sample point bits  */
#define FDCAN_DBTP_DBRP         ((uint32_t)0x001F0000U)  /* Data BIt Rate Prescaler bits  */

#define FDCAN_DBTP_TDC          ((uint32_t)0x00800000U)  /* Transceiver Delay Compensation */

/** Bit definition for FDCAN_TEST register **/
#define FDCAN_TEST_LBCK         ((uint32_t)0x00000010U)  /* Loop Back Mode                */
#define FDCAN_TEST_TX           ((uint32_t)0x00000060U)  /* Control bits of Transmit Pin  */
#define FDCAN_TEST_RX           ((uint32_t)0x00000080U)  /* Receive Pin status */

/** Bit definition for FDCAN_RWD register **/
#define FDCAN_RWD_WDC           ((uint32_t)0x000000FFU)  /* Watchdog Configuration bits  */
#define FDCAN_RWD_WDC_0         ((uint32_t)0x00000001U)  /* Watchdog Configuration bit 0 */
#define FDCAN_RWD_WDC_1         ((uint32_t)0x00000002U)  /* Watchdog Configuration bit 1 */
#define FDCAN_RWD_WDC_2         ((uint32_t)0x00000004U)  /* Watchdog Configuration bit 2 */
#define FDCAN_RWD_WDC_3         ((uint32_t)0x00000008U)  /* Watchdog Configuration bit 3 */
#define FDCAN_RWD_WDC_4         ((uint32_t)0x00000010U)  /* Watchdog Configuration bit 4 */
#define FDCAN_RWD_WDC_5         ((uint32_t)0x00000020U)  /* Watchdog Configuration bit 5 */
#define FDCAN_RWD_WDC_6         ((uint32_t)0x00000040U)  /* Watchdog Configuration bit 6 */
#define FDCAN_RWD_WDC_7         ((uint32_t)0x00000080U)  /* Watchdog Configuration bit 7 */

#define FDCAN_RWD_WDV           ((uint32_t)0x0000FF00U)  /* Watchdog Value bits  */
#define FDCAN_RWD_WDV_0         ((uint32_t)0x00000100U)  /* Watchdog Value bit 0 */
#define FDCAN_RWD_WDV_1         ((uint32_t)0x00000200U)  /* Watchdog Value bit 1 */
#define FDCAN_RWD_WDV_2         ((uint32_t)0x00000400U)  /* Watchdog Value bit 2 */
#define FDCAN_RWD_WDV_3         ((uint32_t)0x00000800U)  /* Watchdog Value bit 3 */
#define FDCAN_RWD_WDV_4         ((uint32_t)0x00001000U)  /* Watchdog Value bit 4 */
#define FDCAN_RWD_WDV_5         ((uint32_t)0x00002000U)  /* Watchdog Value bit 5 */
#define FDCAN_RWD_WDV_6         ((uint32_t)0x00004000U)  /* Watchdog Value bit 6 */
#define FDCAN_RWD_WDV_7         ((uint32_t)0x00008000U)  /* Watchdog Value bit 7 */

/** Bit definition for FDCAN_CCCR register **/
#define FDCAN_CCCR_INIT         ((uint32_t)0x00000001U)  /* Initialization                        */
#define FDCAN_CCCR_CCE          ((uint32_t)0x00000002U)  /* Configuration Change Enable           */
#define FDCAN_CCCR_ASM          ((uint32_t)0x00000004U)  /* ASM Restricted Operation Mode         */
#define FDCAN_CCCR_CSA          ((uint32_t)0x00000008U)  /* Clock Stop Acknowledge                */
#define FDCAN_CCCR_CSR          ((uint32_t)0x00000010U)  /* Clock Stop Request                    */
#define FDCAN_CCCR_MON          ((uint32_t)0x00000020U)  /* Bus Monitoring Mode                   */
#define FDCAN_CCCR_DAR          ((uint32_t)0x00000040U)  /* Disable Automatic Retransmission      */
#define FDCAN_CCCR_TEST         ((uint32_t)0x00000080U)  /* Test Mode Enable                      */
#define FDCAN_CCCR_FDOE         ((uint32_t)0x00000100U)  /* FD Operation Enable                   */
#define FDCAN_CCCR_BRSE         ((uint32_t)0x00000200U)  /* FDCAN Bit Rate Switch Enable          */
#define FDCAN_CCCR_PXHD         ((uint32_t)0x00001000U)  /* Protocol Exception Handling Disable   */
#define FDCAN_CCCR_EFBI         ((uint32_t)0x00002000U)  /* Edge Filtering during Bus Integration */
#define FDCAN_CCCR_TXP          ((uint32_t)0x00004000U)  /* Two CAN bit times Transmit Pause      */
#define FDCAN_CCCR_NISO         ((uint32_t)0x00008000U)  /* Non ISO Operation                     */

/** Bit definition for FDCAN_NBTP register **/
#define FDCAN_NBTP_NTSEG2       ((uint32_t)0x0000007FU)  /* Nominal Time segment after sample point  */
#define FDCAN_NBTP_NTSEG1       ((uint32_t)0x0000FF00U)  /* Nominal Time segment before sample point bits bits  */
#define FDCAN_NBTP_NBRP         ((uint32_t)0x01FF0000U)  /* Bit Rate Prescaler bits  */
#define FDCAN_NBTP_NSJW         ((uint32_t)0xFE000000U)  /* Nominal (Re)Synchronization Jump Width bits   */

/** Bit definition for FDCAN_TSCC register **/
#define FDCAN_TSCC_TSS          ((uint32_t)0x00000003U)  /* Timestamp Select bits  */
#define FDCAN_TSCC_CONSTANT     ((uint32_t)0x00000000U)  /* Timestamp counter is always 0x0000  */
#define FDCAN_TSCC_INC_TCP      ((uint32_t)0x00000001U)  /* Timestamp counter is increasd according to TCP  */
#define FDCAN_TSCC_USE_EXT      ((uint32_t)0x00000002U)  /* Use Extern Timestamp counter   */

#define FDCAN_TSCC_TCP          ((uint32_t)0x000F0000U)  /* Timestamp Counter Prescaler bits  */
#define FDCAN_TSCC_TCP_DIV1     ((uint32_t)0x00000000U) /* Timestamp counter time unit in equal to CAN bit time                 */
#define FDCAN_TSCC_TCP_DIV2     ((uint32_t)0x00010000U) /* Timestamp counter time unit in equal to CAN bit time multiplied by 2  */
#define FDCAN_TSCC_TCP_DIV3     ((uint32_t)0x00020000U) /* Timestamp counter time unit in equal to CAN bit time multiplied by 3  */
#define FDCAN_TSCC_TCP_DIV4     ((uint32_t)0x00030000U) /* Timestamp counter time unit in equal to CAN bit time multiplied by 4  */
#define FDCAN_TSCC_TCP_DIV5     ((uint32_t)0x00040000U) /* Timestamp counter time unit in equal to CAN bit time multiplied by 5  */
#define FDCAN_TSCC_TCP_DIV6     ((uint32_t)0x00050000U) /* Timestamp counter time unit in equal to CAN bit time multiplied by 6  */
#define FDCAN_TSCC_TCP_DIV7     ((uint32_t)0x00060000U) /* Timestamp counter time unit in equal to CAN bit time multiplied by 7  */
#define FDCAN_TSCC_TCP_DIV8     ((uint32_t)0x00070000U) /* Timestamp counter time unit in equal to CAN bit time multiplied by 8  */
#define FDCAN_TSCC_TCP_DIV9     ((uint32_t)0x00080000U) /* Timestamp counter time unit in equal to CAN bit time multiplied by 9  */
#define FDCAN_TSCC_TCP_DIV10    ((uint32_t)0x00090000U) /* Timestamp counter time unit in equal to CAN bit time multiplied by 10 */
#define FDCAN_TSCC_TCP_DIV11    ((uint32_t)0x000A0000U) /* Timestamp counter time unit in equal to CAN bit time multiplied by 11 */
#define FDCAN_TSCC_TCP_DIV12    ((uint32_t)0x000B0000U) /* Timestamp counter time unit in equal to CAN bit time multiplied by 12 */
#define FDCAN_TSCC_TCP_DIV13    ((uint32_t)0x000C0000U) /* Timestamp counter time unit in equal to CAN bit time multiplied by 13 */
#define FDCAN_TSCC_TCP_DIV14    ((uint32_t)0x000D0000U) /* Timestamp counter time unit in equal to CAN bit time multiplied by 14 */
#define FDCAN_TSCC_TCP_DIV15    ((uint32_t)0x000E0000U) /* Timestamp counter time unit in equal to CAN bit time multiplied by 15 */
#define FDCAN_TSCC_TCP_DIV16    ((uint32_t)0x000F0000U) /* Timestamp counter time unit in equal to CAN bit time multiplied by 16 */

/** Bit definition for FDCAN_TSCV register **/
#define FDCAN_TSCV_TSC          ((uint32_t)0x0000FFFFU)  /* Timestamp Counter */

/** Bit definition for FDCAN_TOCC register **/
#define FDCAN_TOCC_ETOC         ((uint32_t)0x00000001U)  /* Enable Timeout Counter */

#define FDCAN_TOCC_TOS                  ((uint32_t)0x00000006U)  /* Timeout Select bits  */
#define FDCAN_TOCC_TOS_CONTINUOUS       ((uint32_t)0x00000000U)  /* Continuous operation   */
#define FDCAN_TOCC_TOS_TX_EVENT_FIFO    ((uint32_t)0x00000002U)  /* Controlled  by Tx event FIFO  */
#define FDCAN_TOCC_TOS_RX_FIFO0         ((uint32_t)0x00000004U)  /* Controlled  by Rx FIFO 0  */
#define FDCAN_TOCC_TOS_RX_FIFO1         ((uint32_t)0x00000006U)  /* Controlled  by Rx FIFO 1  */

#define FDCAN_TOCC_TOP          ((uint32_t)0xFFFF0000U)  /* Timeout Period */

/** Bit definition for FDCAN_TOCV register **/
#define FDCAN_TOCV_TOC          ((uint32_t)0x0000FFFFU)  /* Timeout Counter */

/** Bit definition for FDCAN_ECR register **/
#define FDCAN_ECR_TEC           ((uint32_t)0x000000FFU)  /* Transmit Error Counter */
#define FDCAN_ECR_REC           ((uint32_t)0x00007F00U)  /* Receive Error Counter  */
#define FDCAN_ECR_RP            ((uint32_t)0x00008000U)  /* Receive Error Passive  */
#define FDCAN_ECR_CEL           ((uint32_t)0x00FF0000U)  /* CAN Error Logging      */

/** Bit definition for FDCAN_PSR register **/
#define FDCAN_PSR_LEC           ((uint32_t)0x00000007U)  /* Last Error Code bits  */
#define FDCAN_PSR_LEC_NONE      ((uint32_t)0x00000000U)  /* No error occurred         */
#define FDCAN_PSR_LEC_STUFF     ((uint32_t)0x00000001U)  /* Stuff error               */
#define FDCAN_PSR_LEC_FORM      ((uint32_t)0x00000002U)  /* Form error                */
#define FDCAN_PSR_LEC_ACK       ((uint32_t)0x00000003U)  /* Acknowledge error         */
#define FDCAN_PSR_LEC_BIT1      ((uint32_t)0x00000004U)  /* Bit 1 (recessive) error   */
#define FDCAN_PSR_LEC_BIT0      ((uint32_t)0x00000005U)  /* Bit 0 (dominant) error    */
#define FDCAN_PSR_LEC_CRC       ((uint32_t)0x00000006U)  /* CRC check sum error       */
#define FDCAN_PSR_LEC_NO_CHANGE ((uint32_t)0x00000007U)  /* No change since last read */

#define FDCAN_PSR_ACT           ((uint32_t)0x00000018U)  /* Activity bits  */
#define FDCAN_PSR_ACT_SYNC      ((uint32_t)0x00000000U)  /* Node is synchronizing on CAN communication */
#define FDCAN_PSR_ACT_IDLE      ((uint32_t)0x00000008U)  /* Node is neither receiver nor transmitter   */
#define FDCAN_PSR_ACT_RX        ((uint32_t)0x00000010U)  /* Node is operating as receiver              */
#define FDCAN_PSR_ACT_TX        ((uint32_t)0x00000018U)  /* Node is operating as transmitter           */

#define FDCAN_PSR_EP            ((uint32_t)0x00000020U)  /* Error Passive bit */
#define FDCAN_PSR_EW            ((uint32_t)0x00000040U)  /* Warning Status bit */
#define FDCAN_PSR_BO            ((uint32_t)0x00000080U)  /* Bus_Off Status */

#define FDCAN_PSR_DLEC              ((uint32_t)0x00000700U)  /* Data Last Error Code bits  */
#define FDCAN_PSR_DLEC_NONE         ((uint32_t)0x00000000U)  /* No error occurred         */
#define FDCAN_PSR_DLEC_STUFF        ((uint32_t)0x00000100U)  /* Stuff error               */
#define FDCAN_PSR_DLEC_FORM         ((uint32_t)0x00000200U)  /* Form error                */
#define FDCAN_PSR_DLEC_ACK          ((uint32_t)0x00000300U)  /* Acknowledge error         */
#define FDCAN_PSR_DLEC_BIT1         ((uint32_t)0x00000400U)  /* Bit 1 (recessive) error   */
#define FDCAN_PSR_DLEC_BIT0         ((uint32_t)0x00000500U)  /* Bit 0 (dominant) error    */
#define FDCAN_PSR_DLEC_CRC          ((uint32_t)0x00000600U)  /* CRC check sum error       */
#define FDCAN_PSR_DLEC_NO_CHANGE    ((uint32_t)0x00000700U)  /* No change since last read */

#define FDCAN_PSR_RESI          ((uint32_t)0x00000800U)  /* ESI flag of last received FDCAN Message  */
#define FDCAN_PSR_RBRS          ((uint32_t)0x00001000U)  /* BRS flag of last received FDCAN Message  */
#define FDCAN_PSR_RFDF          ((uint32_t)0x00002000U)  /* Received FDCAN Message                   */
#define FDCAN_PSR_PXE           ((uint32_t)0x00004000U)  /* Protocol Exception Event                 */

#define FDCAN_PSR_TDCV          ((uint32_t)0x007F0000U)  /* Transmitter Delay Compensation Value bits  */

/** Bit definition for FDCAN_TDCR register **/
#define FDCAN_TDCR_TDCF         ((uint32_t)0x0000007FU)  /* Transmitter Delay Compensation Filter bits  */
#define FDCAN_TDCR_TDCF_0       ((uint32_t)0x00000001U)  /* Transmitter Delay Compensation Filter bit 0 */
#define FDCAN_TDCR_TDCF_1       ((uint32_t)0x00000002U)  /* Transmitter Delay Compensation Filter bit 1 */
#define FDCAN_TDCR_TDCF_2       ((uint32_t)0x00000004U)  /* Transmitter Delay Compensation Filter bit 2 */
#define FDCAN_TDCR_TDCF_3       ((uint32_t)0x00000008U)  /* Transmitter Delay Compensation Filter bit 3 */
#define FDCAN_TDCR_TDCF_4       ((uint32_t)0x00000010U)  /* Transmitter Delay Compensation Filter bit 4 */
#define FDCAN_TDCR_TDCF_5       ((uint32_t)0x00000020U)  /* Transmitter Delay Compensation Filter bit 5 */
#define FDCAN_TDCR_TDCF_6       ((uint32_t)0x00000040U)  /* Transmitter Delay Compensation Filter bit 6 */

#define FDCAN_TDCR_TDCO         ((uint32_t)0x00007F00U)  /* Transmitter Delay Compensation Offset bits  */
#define FDCAN_TDCR_TDCO_0       ((uint32_t)0x00000100U)  /* Transmitter Delay Compensation Offset bit 0 */
#define FDCAN_TDCR_TDCO_1       ((uint32_t)0x00000200U)  /* Transmitter Delay Compensation Offset bit 1 */
#define FDCAN_TDCR_TDCO_2       ((uint32_t)0x00000400U)  /* Transmitter Delay Compensation Offset bit 2 */
#define FDCAN_TDCR_TDCO_3       ((uint32_t)0x00000800U)  /* Transmitter Delay Compensation Offset bit 3 */
#define FDCAN_TDCR_TDCO_4       ((uint32_t)0x00001000U)  /* Transmitter Delay Compensation Offset bit 4 */
#define FDCAN_TDCR_TDCO_5       ((uint32_t)0x00002000U)  /* Transmitter Delay Compensation Offset bit 5 */
#define FDCAN_TDCR_TDCO_6       ((uint32_t)0x00004000U)  /* Transmitter Delay Compensation Offset bit 6 */

/** Bit definition for FDCAN_IR register **/
#define FDCAN_IR_RF0N           ((uint32_t)0x00000001U)  /* Rx FIFO 0 New Message                 */
#define FDCAN_IR_RF0W           ((uint32_t)0x00000002U)  /* Rx FIFO 0 Watermark Reached           */
#define FDCAN_IR_RF0F           ((uint32_t)0x00000004U)  /* Rx FIFO 0 Full                        */
#define FDCAN_IR_RF0L           ((uint32_t)0x00000008U)  /* Rx FIFO 0 Message Lost                */
#define FDCAN_IR_RF1N           ((uint32_t)0x00000010U)  /* Rx FIFO 1 New Message                 */
#define FDCAN_IR_RF1W           ((uint32_t)0x00000020U)  /* Rx FIFO 1 Watermark Reached           */
#define FDCAN_IR_RF1F           ((uint32_t)0x00000040U)  /* Rx FIFO 1 Full                        */
#define FDCAN_IR_RF1L           ((uint32_t)0x00000080U)  /* Rx FIFO 1 Message Lost                */
#define FDCAN_IR_HPM            ((uint32_t)0x00000100U)  /* High Priority Message                 */
#define FDCAN_IR_TC             ((uint32_t)0x00000200U)  /* Transmission Completed                */
#define FDCAN_IR_TCF            ((uint32_t)0x00000400U)  /* Transmission Cancellation Finished    */
#define FDCAN_IR_TFE            ((uint32_t)0x00000800U)  /* Tx FIFO Empty                         */
#define FDCAN_IR_TEFN           ((uint32_t)0x00001000U)  /* Tx Event FIFO New Entry               */
#define FDCAN_IR_TEFW           ((uint32_t)0x00002000U)  /* Tx Event FIFO Watermark Reached       */
#define FDCAN_IR_TEFF           ((uint32_t)0x00004000U)  /* Tx Event FIFO Full                    */
#define FDCAN_IR_TEFL           ((uint32_t)0x00008000U)  /* Tx Event FIFO Element Lost            */
#define FDCAN_IR_TSW            ((uint32_t)0x00010000U)  /* Timestamp Wraparound                  */
#define FDCAN_IR_MRAF           ((uint32_t)0x00020000U)  /* Message RAM Access Failure            */
#define FDCAN_IR_TOO            ((uint32_t)0x00040000U)  /* Timeout Occurred                      */
#define FDCAN_IR_DRX            ((uint32_t)0x00080000U)  /* Message stored to Dedicated Rx Buffer */
#define FDCAN_IR_ELO            ((uint32_t)0x00400000U)  /* Error Logging Overflow                */
#define FDCAN_IR_EP             ((uint32_t)0x00800000U)  /* Error Passive                         */
#define FDCAN_IR_EW             ((uint32_t)0x01000000U)  /* Warning Status                        */
#define FDCAN_IR_BO             ((uint32_t)0x02000000U)  /* Bus_Off Status                        */
#define FDCAN_IR_WDI            ((uint32_t)0x04000000U)  /* Watchdog Interrupt                    */
#define FDCAN_IR_PEA            ((uint32_t)0x08000000U)  /* Protocol Error in Arbitration Phase   */
#define FDCAN_IR_PED            ((uint32_t)0x10000000U)  /* Protocol Error in Data Phase          */
#define FDCAN_IR_ARA            ((uint32_t)0x20000000U)  /* Access to Reserved Address            */

/** Bit definition for FDCAN_IE register **/
#define FDCAN_IE_RF0NE          ((uint32_t)0x00000001U)  /* Rx FIFO 0 New Message interrupt enable                 */
#define FDCAN_IE_RF0WE          ((uint32_t)0x00000002U)  /* Rx FIFO 0 Watermark Reached interrupt enable           */
#define FDCAN_IE_RF0FE          ((uint32_t)0x00000004U)  /* Rx FIFO 0 Full interrupt enable                        */
#define FDCAN_IE_RF0LE          ((uint32_t)0x00000008U)  /* Rx FIFO 0 Message Lost interrupt enable                */
#define FDCAN_IE_RF1NE          ((uint32_t)0x00000010U)  /* Rx FIFO 1 New Message interrupt enable                 */
#define FDCAN_IE_RF1WE          ((uint32_t)0x00000020U)  /* Rx FIFO 1 Watermark Reached interrupt enable           */
#define FDCAN_IE_RF1FE          ((uint32_t)0x00000040U)  /* Rx FIFO 1 Full interrupt enable                        */
#define FDCAN_IE_RF1LE          ((uint32_t)0x00000080U)  /* Rx FIFO 1 Message Lost interrupt enable                */
#define FDCAN_IE_HPME           ((uint32_t)0x00000100U)  /* High Priority Message interrupt enable                 */
#define FDCAN_IE_TCE            ((uint32_t)0x00000200U)  /* Transmission Completed interrupt enable                */
#define FDCAN_IE_TCFE           ((uint32_t)0x00000400U)  /* Transmission Cancellation Finished interrupt enable    */
#define FDCAN_IE_TFEE           ((uint32_t)0x00000800U)  /* Tx FIFO Empty interrupt enable                         */
#define FDCAN_IE_TEFNE          ((uint32_t)0x00001000U)  /* Tx Event FIFO New Entry interrupt enable               */
#define FDCAN_IE_TEFWE          ((uint32_t)0x00002000U)  /* Tx Event FIFO Watermark Reached interrupt enable       */
#define FDCAN_IE_TEFFE          ((uint32_t)0x00004000U)  /* Tx Event FIFO Full interrupt enable                    */
#define FDCAN_IE_TEFLE          ((uint32_t)0x00008000U)  /* Tx Event FIFO Element Lost interrupt enable            */
#define FDCAN_IE_TSWE           ((uint32_t)0x00010000U)  /* Timestamp Wraparound interrupt enable                  */
#define FDCAN_IE_MRAFE          ((uint32_t)0x00020000U)  /* Message RAM Access Failure interrupt enable            */
#define FDCAN_IE_TOOE           ((uint32_t)0x00040000U)  /* Timeout Occurred interrupt enable                      */
#define FDCAN_IE_DRXE           ((uint32_t)0x00080000U)  /* Message stored to Dedicated Rx Buffer interrupt enable */
#define FDCAN_IE_ELOE           ((uint32_t)0x00400000U)  /* Error Logging Overflow interrupt enable                */
#define FDCAN_IE_EPE            ((uint32_t)0x00800000U)  /* Error Passive interrupt enable                         */
#define FDCAN_IE_EWE            ((uint32_t)0x01000000U)  /* Warning Status interrupt enable                        */
#define FDCAN_IE_BOE            ((uint32_t)0x02000000U)  /* Bus_Off Status interrupt enable                        */
#define FDCAN_IE_WDIE           ((uint32_t)0x04000000U)  /* Watchdog Interrupt enable                              */
#define FDCAN_IE_PEAE           ((uint32_t)0x08000000U)  /* Protocol Error in Arbitration Phase interrupt enable   */
#define FDCAN_IE_PEDE           ((uint32_t)0x10000000U)  /* Protocol Error in Data Phase interrupt enable          */
#define FDCAN_IE_ARAE           ((uint32_t)0x20000000U)  /* AcEcess to Reserved Address interrupt enable           */

/** Bit definition for FDCAN_ILS register **/
#define FDCAN_ILS_RF0NL         ((uint32_t)0x00000001U)  /* Rx FIFO 0 New Message Line                 */
#define FDCAN_ILS_RF0WL         ((uint32_t)0x00000002U)  /* Rx FIFO 0 Watermark Reached Line           */
#define FDCAN_ILS_RF0FL         ((uint32_t)0x00000004U)  /* Rx FIFO 0 Full Line                        */
#define FDCAN_ILS_RF0LL         ((uint32_t)0x00000008U)  /* Rx FIFO 0 Message Lost Line                */
#define FDCAN_ILS_RF1NL         ((uint32_t)0x00000010U)  /* Rx FIFO 1 New Message Line                 */
#define FDCAN_ILS_RF1WL         ((uint32_t)0x00000020U)  /* Rx FIFO 1 Watermark Reached Line           */
#define FDCAN_ILS_RF1FL         ((uint32_t)0x00000040U)  /* Rx FIFO 1 Full Line                        */
#define FDCAN_ILS_RF1LL         ((uint32_t)0x00000080U)  /* Rx FIFO 1 Message Lost Line                */
#define FDCAN_ILS_HPML          ((uint32_t)0x00000100U)  /* High Priority Message Line                 */
#define FDCAN_ILS_TCL           ((uint32_t)0x00000200U)  /* Transmission Completed Line                */
#define FDCAN_ILS_TCFL          ((uint32_t)0x00000400U)  /* Transmission Cancellation Finished Line    */
#define FDCAN_ILS_TFEL          ((uint32_t)0x00000800U)  /* Tx FIFO Empty Line                         */
#define FDCAN_ILS_TEFNL         ((uint32_t)0x00001000U)  /* Tx Event FIFO New Entry Line               */
#define FDCAN_ILS_TEFWL         ((uint32_t)0x00002000U)  /* Tx Event FIFO Watermark Reached Line       */
#define FDCAN_ILS_TEFFL         ((uint32_t)0x00004000U)  /* Tx Event FIFO Full Line                    */
#define FDCAN_ILS_TEFLL         ((uint32_t)0x00008000U)  /* Tx Event FIFO Element Lost Line            */
#define FDCAN_ILS_TSWL          ((uint32_t)0x00010000U)  /* Timestamp Wraparound Line                  */
#define FDCAN_ILS_MRAFL         ((uint32_t)0x00020000U)  /* Message RAM Access Failure Line            */
#define FDCAN_ILS_TOOL          ((uint32_t)0x00040000U)  /* Timeout Occurred Line                      */
#define FDCAN_ILS_DRXL          ((uint32_t)0x00080000U)  /* Message stored to Dedicated Rx Buffer Line */
#define FDCAN_ILS_ELOL          ((uint32_t)0x00400000U)  /* Error Logging Overflow Line                */
#define FDCAN_ILS_EPL           ((uint32_t)0x00800000U)  /* Error Passive Line                         */
#define FDCAN_ILS_EWL           ((uint32_t)0x01000000U)  /* Warning Status Line                        */
#define FDCAN_ILS_BOL           ((uint32_t)0x02000000U)  /* Bus_Off Status Line                        */
#define FDCAN_ILS_WDIL          ((uint32_t)0x04000000U)  /* Watchdog Line                              */
#define FDCAN_ILS_PEAL          ((uint32_t)0x08000000U)  /* Protocol Error in Arbitration Phase Line   */
#define FDCAN_ILS_PEDL          ((uint32_t)0x10000000U)  /* Protocol Error in Data Phase Line          */
#define FDCAN_ILS_ARAL          ((uint32_t)0x20000000U)  /* Access to Reserved Address Line            */

/** Bit definition for FDCAN_ILE register **/
#define FDCAN_ILE_EINT0         ((uint32_t)0x00000001U)  /* Enable Interrupt Line 0 */
#define FDCAN_ILE_EINT1         ((uint32_t)0x00000002U)  /* Enable Interrupt Line 1 */

/** Bit definition for FDCAN_GFC register **/
#define FDCAN_GFC_RRFE          ((uint32_t)0x00000001U)  /* Reject Extended Remote Frames */
#define FDCAN_GFC_RRFS          ((uint32_t)0x00000002U)  /* Reject Standard Remote Frames */

#define FDCAN_GFC_ANFE          ((uint32_t)0x0000000CU)  /* Accept Extended Non-matching Frames bits  */
#define FDCAN_GFC_ANFE_0        ((uint32_t)0x00000004U)  /* Accept Extended Non-matching Frames bit 0 */
#define FDCAN_GFC_ANFE_1        ((uint32_t)0x00000008U)  /* Accept Extended Non-matching Frames bit 1 */

#define FDCAN_GFC_ANFS          ((uint32_t)0x00000030U)  /* Accept Standard Non-matching Frames bits  */
#define FDCAN_GFC_ANFS_0        ((uint32_t)0x00000010U)  /* Accept Standard Non-matching Frames bit 0 */
#define FDCAN_GFC_ANFS_1        ((uint32_t)0x00000020U)  /* Accept Standard Non-matching Frames bit 1 */

/** Bit definition for FDCAN_SIDFC register **/
#define FDCAN_SIDFC_FLSSA       ((uint32_t)0x0000FFFCU)  /* Filter List Standard Start Address */
#define FDCAN_SIDFC_LSS         ((uint32_t)0x00FF0000U)  /* List Size Standard                 */

/** Bit definition for FDCAN_XIDFC register **/
#define FDCAN_XIDFC_FLESA       ((uint32_t)0x0000FFFCU)  /* Filter List Extended Start Address */
#define FDCAN_XIDFC_LSE         ((uint32_t)0x007F0000U)  /* List Size Extended                 */

/** Bit definition for FDCAN_XIDAM register **/
#define FDCAN_XIDAM_EIDM        ((uint32_t)0x1FFFFFFFU)  /* Extended ID Mask */

/** Bit definition for FDCAN_HPMS register **/
#define FDCAN_HPMS_BIDX         ((uint32_t)0x0000003FU)  /* Buffer Index bits  */

#define FDCAN_HPMS_MSI          ((uint32_t)0x000000C0U)  /* Message Storage Indicator bits  */
#define FDCAN_HPMS_MSI_NO_FIFO  ((uint32_t)0x00000000U)  /* No fifo selected */
#define FDCAN_HPMS_MSI_MSG_LOST ((uint32_t)0x00000040U)  /* Message lost */
#define FDCAN_HPMS_MSI_FIFO0    ((uint32_t)0x00000080U)  /* Message Stored in FIFO 0 */
#define FDCAN_HPMS_MSI_FIFO1    ((uint32_t)0x000000C0U)  /* Message Stored in FIFO 1 */

#define FDCAN_HPMS_FIDX         ((uint32_t)0x00007F00U)  /* Filter Index bits  */

#define FDCAN_HPMS_FLST         ((uint32_t)0x00008000U)  /* Filter List */
#define FDCAN_HPMS_FLST_STD     ((uint32_t)0x00000000U)  /* Standard Filter List */
#define FDCAN_HPMS_FLST_EXT     ((uint32_t)0x00008000U)  /* Extended Filter List */

/** Bit definition for FDCAN_NDAT1 register **/
#define FDCAN_NDAT1_ND0         ((uint32_t)0x00000001U)  /* New Data flag of Rx Buffer 0  */
#define FDCAN_NDAT1_ND1         ((uint32_t)0x00000002U)  /* New Data flag of Rx Buffer 1  */
#define FDCAN_NDAT1_ND2         ((uint32_t)0x00000004U)  /* New Data flag of Rx Buffer 2  */
#define FDCAN_NDAT1_ND3         ((uint32_t)0x00000008U)  /* New Data flag of Rx Buffer 3  */
#define FDCAN_NDAT1_ND4         ((uint32_t)0x00000010U)  /* New Data flag of Rx Buffer 4  */
#define FDCAN_NDAT1_ND5         ((uint32_t)0x00000020U)  /* New Data flag of Rx Buffer 5  */
#define FDCAN_NDAT1_ND6         ((uint32_t)0x00000040U)  /* New Data flag of Rx Buffer 6  */
#define FDCAN_NDAT1_ND7         ((uint32_t)0x00000080U)  /* New Data flag of Rx Buffer 7  */
#define FDCAN_NDAT1_ND8         ((uint32_t)0x00000100U)  /* New Data flag of Rx Buffer 8  */
#define FDCAN_NDAT1_ND9         ((uint32_t)0x00000200U)  /* New Data flag of Rx Buffer 9  */
#define FDCAN_NDAT1_ND10        ((uint32_t)0x00000400U)  /* New Data flag of Rx Buffer 10 */
#define FDCAN_NDAT1_ND11        ((uint32_t)0x00000800U)  /* New Data flag of Rx Buffer 11 */
#define FDCAN_NDAT1_ND12        ((uint32_t)0x00001000U)  /* New Data flag of Rx Buffer 12 */
#define FDCAN_NDAT1_ND13        ((uint32_t)0x00002000U)  /* New Data flag of Rx Buffer 13 */
#define FDCAN_NDAT1_ND14        ((uint32_t)0x00004000U)  /* New Data flag of Rx Buffer 14 */
#define FDCAN_NDAT1_ND15        ((uint32_t)0x00008000U)  /* New Data flag of Rx Buffer 15 */
#define FDCAN_NDAT1_ND16        ((uint32_t)0x00010000U)  /* New Data flag of Rx Buffer 16 */
#define FDCAN_NDAT1_ND17        ((uint32_t)0x00020000U)  /* New Data flag of Rx Buffer 17 */
#define FDCAN_NDAT1_ND18        ((uint32_t)0x00040000U)  /* New Data flag of Rx Buffer 18 */
#define FDCAN_NDAT1_ND19        ((uint32_t)0x00080000U)  /* New Data flag of Rx Buffer 19 */
#define FDCAN_NDAT1_ND20        ((uint32_t)0x00100000U)  /* New Data flag of Rx Buffer 20 */
#define FDCAN_NDAT1_ND21        ((uint32_t)0x00200000U)  /* New Data flag of Rx Buffer 21 */
#define FDCAN_NDAT1_ND22        ((uint32_t)0x00400000U)  /* New Data flag of Rx Buffer 22 */
#define FDCAN_NDAT1_ND23        ((uint32_t)0x00800000U)  /* New Data flag of Rx Buffer 23 */
#define FDCAN_NDAT1_ND24        ((uint32_t)0x01000000U)  /* New Data flag of Rx Buffer 24 */
#define FDCAN_NDAT1_ND25        ((uint32_t)0x02000000U)  /* New Data flag of Rx Buffer 25 */
#define FDCAN_NDAT1_ND26        ((uint32_t)0x04000000U)  /* New Data flag of Rx Buffer 26 */
#define FDCAN_NDAT1_ND27        ((uint32_t)0x08000000U)  /* New Data flag of Rx Buffer 27 */
#define FDCAN_NDAT1_ND28        ((uint32_t)0x10000000U)  /* New Data flag of Rx Buffer 28 */
#define FDCAN_NDAT1_ND29        ((uint32_t)0x20000000U)  /* New Data flag of Rx Buffer 29 */
#define FDCAN_NDAT1_ND30        ((uint32_t)0x40000000U)  /* New Data flag of Rx Buffer 30 */
#define FDCAN_NDAT1_ND31        ((uint32_t)0x80000000U)  /* New Data flag of Rx Buffer 31 */

/** Bit definition for FDCAN_NDAT2 register **/
#define FDCAN_NDAT2_ND32        ((uint32_t)0x00000001U)  /* New Data flag of Rx Buffer 32 */
#define FDCAN_NDAT2_ND33        ((uint32_t)0x00000002U)  /* New Data flag of Rx Buffer 33 */
#define FDCAN_NDAT2_ND34        ((uint32_t)0x00000004U)  /* New Data flag of Rx Buffer 34 */
#define FDCAN_NDAT2_ND35        ((uint32_t)0x00000008U)  /* New Data flag of Rx Buffer 35 */
#define FDCAN_NDAT2_ND36        ((uint32_t)0x00000010U)  /* New Data flag of Rx Buffer 36 */
#define FDCAN_NDAT2_ND37        ((uint32_t)0x00000020U)  /* New Data flag of Rx Buffer 37 */
#define FDCAN_NDAT2_ND38        ((uint32_t)0x00000040U)  /* New Data flag of Rx Buffer 38 */
#define FDCAN_NDAT2_ND39        ((uint32_t)0x00000080U)  /* New Data flag of Rx Buffer 39 */
#define FDCAN_NDAT2_ND40        ((uint32_t)0x00000100U)  /* New Data flag of Rx Buffer 40 */
#define FDCAN_NDAT2_ND41        ((uint32_t)0x00000200U)  /* New Data flag of Rx Buffer 41 */
#define FDCAN_NDAT2_ND42        ((uint32_t)0x00000400U)  /* New Data flag of Rx Buffer 42 */
#define FDCAN_NDAT2_ND43        ((uint32_t)0x00000800U)  /* New Data flag of Rx Buffer 43 */
#define FDCAN_NDAT2_ND44        ((uint32_t)0x00001000U)  /* New Data flag of Rx Buffer 44 */
#define FDCAN_NDAT2_ND45        ((uint32_t)0x00002000U)  /* New Data flag of Rx Buffer 45 */
#define FDCAN_NDAT2_ND46        ((uint32_t)0x00004000U)  /* New Data flag of Rx Buffer 46 */
#define FDCAN_NDAT2_ND47        ((uint32_t)0x00008000U)  /* New Data flag of Rx Buffer 47 */
#define FDCAN_NDAT2_ND48        ((uint32_t)0x00010000U)  /* New Data flag of Rx Buffer 48 */
#define FDCAN_NDAT2_ND49        ((uint32_t)0x00020000U)  /* New Data flag of Rx Buffer 49 */
#define FDCAN_NDAT2_ND50        ((uint32_t)0x00040000U)  /* New Data flag of Rx Buffer 50 */
#define FDCAN_NDAT2_ND51        ((uint32_t)0x00080000U)  /* New Data flag of Rx Buffer 51 */
#define FDCAN_NDAT2_ND52        ((uint32_t)0x00100000U)  /* New Data flag of Rx Buffer 52 */
#define FDCAN_NDAT2_ND53        ((uint32_t)0x00200000U)  /* New Data flag of Rx Buffer 53 */
#define FDCAN_NDAT2_ND54        ((uint32_t)0x00400000U)  /* New Data flag of Rx Buffer 54 */
#define FDCAN_NDAT2_ND55        ((uint32_t)0x00800000U)  /* New Data flag of Rx Buffer 55 */
#define FDCAN_NDAT2_ND56        ((uint32_t)0x01000000U)  /* New Data flag of Rx Buffer 56 */
#define FDCAN_NDAT2_ND57        ((uint32_t)0x02000000U)  /* New Data flag of Rx Buffer 57 */
#define FDCAN_NDAT2_ND58        ((uint32_t)0x04000000U)  /* New Data flag of Rx Buffer 58 */
#define FDCAN_NDAT2_ND59        ((uint32_t)0x08000000U)  /* New Data flag of Rx Buffer 59 */
#define FDCAN_NDAT2_ND60        ((uint32_t)0x10000000U)  /* New Data flag of Rx Buffer 60 */
#define FDCAN_NDAT2_ND61        ((uint32_t)0x20000000U)  /* New Data flag of Rx Buffer 61 */
#define FDCAN_NDAT2_ND62        ((uint32_t)0x40000000U)  /* New Data flag of Rx Buffer 62 */
#define FDCAN_NDAT2_ND63        ((uint32_t)0x80000000U)  /* New Data flag of Rx Buffer 63 */

/** Bit definition for FDCAN_RXF0C register **/
#define FDCAN_RXF0C_F0SA        ((uint32_t)0x0000FFFCU)  /* Rx FIFO 0 Start Address  */
#define FDCAN_RXF0C_F0S         ((uint32_t)0x007F0000U)  /* Rx FIFO 0 Size           */
#define FDCAN_RXF0C_F0WM        ((uint32_t)0x7F000000U)  /* Rx FIFO 0 Watermark      */
#define FDCAN_RXF0C_F0OM        ((uint32_t)0x80000000U)  /* Rx FIFO 0 Operation Mode */

/** Bit definition for FDCAN_RXF0S register **/
#define FDCAN_RXF0S_F0FL        ((uint32_t)0x0000007FU)  /* Rx FIFO 0 Fill Level bits  */
#define FDCAN_RXF0S_F0GI        ((uint32_t)0x00003F00U)  /* Rx FIFO 0 Get Index bits  */
#define FDCAN_RXF0S_F0PI        ((uint32_t)0x003F0000U)  /* Rx FIFO 0 Put Index bits  */
#define FDCAN_RXF0S_F0F         ((uint32_t)0x01000000U)  /* Rx FIFO 0 Full         */
#define FDCAN_RXF0S_RF0L        ((uint32_t)0x02000000U)  /* Rx FIFO 0 Message Lost */

/** Bit definition for FDCAN_RXF0A register **/
#define FDCAN_RXF0A_F0AI        ((uint32_t)0x0000003FU)  /* Rx FIFO 0 Acknowledge Index bits  */

/** Bit definition for FDCAN_RXBC register **/
#define FDCAN_RXBC_RBSA         ((uint32_t)0x0000FFFCU)  /* Rx Buffer Start Address */

/** Bit definition for FDCAN_RXF1C register **/
#define FDCAN_RXF1C_F1SA        ((uint32_t)0x0000FFFCU)  /* Rx FIFO 1 Start Address  */
#define FDCAN_RXF1C_F1S         ((uint32_t)0x007F0000U)  /* Rx FIFO 1 Size           */
#define FDCAN_RXF1C_F1WM        ((uint32_t)0x7F000000U)  /* Rx FIFO 1 Watermark      */
#define FDCAN_RXF1C_F1OM        ((uint32_t)0x80000000U)  /* Rx FIFO 1 Operation Mode */

/** Bit definition for FDCAN_RXF1S register **/
#define FDCAN_RXF1S_F1FL        ((uint32_t)0x0000007FU)  /* Rx FIFO 1 Fill Level bits  */
#define FDCAN_RXF1S_F1GI        ((uint32_t)0x00003F00U)  /* Rx FIFO 1 Get Index bits  */
#define FDCAN_RXF1S_F1PI        ((uint32_t)0x003F0000U)  /* Rx FIFO 1 Put Index bits  */
#define FDCAN_RXF1S_F1F         ((uint32_t)0x01000000U)  /* Rx FIFO 1 Full         */
#define FDCAN_RXF1S_RF1L        ((uint32_t)0x02000000U)  /* Rx FIFO 1 Message Lost */

#define FDCAN_RXF1S_DMS         ((uint32_t)0xC0000000U)  /* Debug message status bits  */
#define FDCAN_RXF1S_DMS_0       ((uint32_t)0x40000000U)  /* Debug message status bit 0 */
#define FDCAN_RXF1S_DMS_1       ((uint32_t)0x80000000U)  /* Debug message status bit 1 */
        
/** Bit definition for FDCAN_RXF1A register **/
#define FDCAN_RXF1A_F1AI        ((uint32_t)0x0000003FU)  /* Rx FIFO 1 Acknowledge Index bits  */

/** Bit definition for FDCAN_RXESC register **/
#define FDCAN_RXESC_F0DS        ((uint32_t)0x00000007U)  /* Rx FIFO 1 Data Field Size bits  */
#define FDCAN_RXESC_F1DS        ((uint32_t)0x00000070U)  /* Rx FIFO 0 Data Field Size bits  */
#define FDCAN_RXESC_RBDS        ((uint32_t)0x00000700U)  /* Rx Buffer Data Field Size bits  */

/** Bit definition for FDCAN_TXBC register **/
#define FDCAN_TXBC_TBSA         ((uint32_t)0x0000FFFCU)  /* Tx Buffers Start Address */
#define FDCAN_TXBC_NDTB         ((uint32_t)0x003F0000U)  /* Number of Dedicated Transmit Buffers bits  */
#define FDCAN_TXBC_TFQS         ((uint32_t)0x3F000000U)  /* Transmit FIFO/Queue Size bits  */
#define FDCAN_TXBC_TFQM         ((uint32_t)0x40000000U)  /* Tx FIFO/Queue Mode */

/** Bit definition for FDCAN_TXFQS register **/
#define FDCAN_TXFQS_TFFL        ((uint32_t)0x0000003FU)  /* Tx FIFO Free Level bits  */
#define FDCAN_TXFQS_TFGI        ((uint32_t)0x00001F00U)  /* Tx FIFO Get Index bits  */
#define FDCAN_TXFQS_TFQPI       ((uint32_t)0x001F0000U)  /* Tx FIFO/Queue Put Index bis   */
#define FDCAN_TXFQS_TFQF        ((uint32_t)0x00200000U)  /* Tx FIFO/Queue Full */

/** Bit definition for FDCAN_TXESC register **/
#define FDCAN_TXESC_TBDS        ((uint32_t)0x00000007U)  /* Tx Buffer Data Field Size  */

#define FDCAN_TXESC_TBDS_8BYTE  ((uint32_t)0x00000000U)  /* Tx Buffer Data Field Size is 8  Byte */
#define FDCAN_TXESC_TBDS_12BYTE ((uint32_t)0x00000001U)  /* Tx Buffer Data Field Size is 12 Byte */
#define FDCAN_TXESC_TBDS_16BYTE ((uint32_t)0x00000002U)  /* Tx Buffer Data Field Size is 16 Byte */
#define FDCAN_TXESC_TBDS_20BYTE ((uint32_t)0x00000003U)  /* Tx Buffer Data Field Size is 20 Byte */
#define FDCAN_TXESC_TBDS_24BYTE ((uint32_t)0x00000004U)  /* Tx Buffer Data Field Size is 24 Byte */
#define FDCAN_TXESC_TBDS_32BYTE ((uint32_t)0x00000005U)  /* Tx Buffer Data Field Size is 32 Byte */
#define FDCAN_TXESC_TBDS_48BYTE ((uint32_t)0x00000006U)  /* Tx Buffer Data Field Size is 48 Byte */
#define FDCAN_TXESC_TBDS_64BYTE ((uint32_t)0x00000007U)  /* Tx Buffer Data Field Size is 64 Byte */

/** Bit definition for FDCAN_TXBRP register **/
#define FDCAN_TXBRP_TRP0        ((uint32_t)0x00000001U)  /* Transmission Request Pending 0  */
#define FDCAN_TXBRP_TRP1        ((uint32_t)0x00000002U)  /* Transmission Request Pending 1  */
#define FDCAN_TXBRP_TRP2        ((uint32_t)0x00000004U)  /* Transmission Request Pending 2  */
#define FDCAN_TXBRP_TRP3        ((uint32_t)0x00000008U)  /* Transmission Request Pending 3  */
#define FDCAN_TXBRP_TRP4        ((uint32_t)0x00000010U)  /* Transmission Request Pending 4  */
#define FDCAN_TXBRP_TRP5        ((uint32_t)0x00000020U)  /* Transmission Request Pending 5  */
#define FDCAN_TXBRP_TRP6        ((uint32_t)0x00000040U)  /* Transmission Request Pending 6  */
#define FDCAN_TXBRP_TRP7        ((uint32_t)0x00000080U)  /* Transmission Request Pending 7  */
#define FDCAN_TXBRP_TRP8        ((uint32_t)0x00000100U)  /* Transmission Request Pending 8  */
#define FDCAN_TXBRP_TRP9        ((uint32_t)0x00000200U)  /* Transmission Request Pending 9  */
#define FDCAN_TXBRP_TRP10       ((uint32_t)0x00000400U)  /* Transmission Request Pending 10 */
#define FDCAN_TXBRP_TRP11       ((uint32_t)0x00000800U)  /* Transmission Request Pending 11 */
#define FDCAN_TXBRP_TRP12       ((uint32_t)0x00001000U)  /* Transmission Request Pending 12 */
#define FDCAN_TXBRP_TRP13       ((uint32_t)0x00002000U)  /* Transmission Request Pending 13 */
#define FDCAN_TXBRP_TRP14       ((uint32_t)0x00004000U)  /* Transmission Request Pending 14 */
#define FDCAN_TXBRP_TRP15       ((uint32_t)0x00008000U)  /* Transmission Request Pending 15 */
#define FDCAN_TXBRP_TRP16       ((uint32_t)0x00010000U)  /* Transmission Request Pending 16 */
#define FDCAN_TXBRP_TRP17       ((uint32_t)0x00020000U)  /* Transmission Request Pending 17 */
#define FDCAN_TXBRP_TRP18       ((uint32_t)0x00040000U)  /* Transmission Request Pending 18 */
#define FDCAN_TXBRP_TRP19       ((uint32_t)0x00080000U)  /* Transmission Request Pending 19 */
#define FDCAN_TXBRP_TRP20       ((uint32_t)0x00100000U)  /* Transmission Request Pending 20 */
#define FDCAN_TXBRP_TRP21       ((uint32_t)0x00200000U)  /* Transmission Request Pending 21 */
#define FDCAN_TXBRP_TRP22       ((uint32_t)0x00400000U)  /* Transmission Request Pending 22 */
#define FDCAN_TXBRP_TRP23       ((uint32_t)0x00800000U)  /* Transmission Request Pending 23 */
#define FDCAN_TXBRP_TRP24       ((uint32_t)0x01000000U)  /* Transmission Request Pending 24 */
#define FDCAN_TXBRP_TRP25       ((uint32_t)0x02000000U)  /* Transmission Request Pending 25 */
#define FDCAN_TXBRP_TRP26       ((uint32_t)0x04000000U)  /* Transmission Request Pending 26 */
#define FDCAN_TXBRP_TRP27       ((uint32_t)0x08000000U)  /* Transmission Request Pending 27 */
#define FDCAN_TXBRP_TRP28       ((uint32_t)0x10000000U)  /* Transmission Request Pending 28 */
#define FDCAN_TXBRP_TRP29       ((uint32_t)0x20000000U)  /* Transmission Request Pending 29 */
#define FDCAN_TXBRP_TRP30       ((uint32_t)0x40000000U)  /* Transmission Request Pending 30 */
#define FDCAN_TXBRP_TRP31       ((uint32_t)0x80000000U)  /* Transmission Request Pending 31 */

/** Bit definition for FDCAN_TXBAR register **/
#define FDCAN_TXBAR_AR0         ((uint32_t)0x00000001U)  /* Add Request 0  */
#define FDCAN_TXBAR_AR1         ((uint32_t)0x00000002U)  /* Add Request 1  */
#define FDCAN_TXBAR_AR2         ((uint32_t)0x00000004U)  /* Add Request 2  */
#define FDCAN_TXBAR_AR3         ((uint32_t)0x00000008U)  /* Add Request 3  */
#define FDCAN_TXBAR_AR4         ((uint32_t)0x00000010U)  /* Add Request 4  */
#define FDCAN_TXBAR_AR5         ((uint32_t)0x00000020U)  /* Add Request 5  */
#define FDCAN_TXBAR_AR6         ((uint32_t)0x00000040U)  /* Add Request 6  */
#define FDCAN_TXBAR_AR7         ((uint32_t)0x00000080U)  /* Add Request 7  */
#define FDCAN_TXBAR_AR8         ((uint32_t)0x00000100U)  /* Add Request 8  */
#define FDCAN_TXBAR_AR9         ((uint32_t)0x00000200U)  /* Add Request 9  */
#define FDCAN_TXBAR_AR10        ((uint32_t)0x00000400U)  /* Add Request 10 */
#define FDCAN_TXBAR_AR11        ((uint32_t)0x00000800U)  /* Add Request 11 */
#define FDCAN_TXBAR_AR12        ((uint32_t)0x00001000U)  /* Add Request 12 */
#define FDCAN_TXBAR_AR13        ((uint32_t)0x00002000U)  /* Add Request 13 */
#define FDCAN_TXBAR_AR14        ((uint32_t)0x00004000U)  /* Add Request 14 */
#define FDCAN_TXBAR_AR15        ((uint32_t)0x00008000U)  /* Add Request 15 */
#define FDCAN_TXBAR_AR16        ((uint32_t)0x00010000U)  /* Add Request 16 */
#define FDCAN_TXBAR_AR17        ((uint32_t)0x00020000U)  /* Add Request 17 */
#define FDCAN_TXBAR_AR18        ((uint32_t)0x00040000U)  /* Add Request 18 */
#define FDCAN_TXBAR_AR19        ((uint32_t)0x00080000U)  /* Add Request 19 */
#define FDCAN_TXBAR_AR20        ((uint32_t)0x00100000U)  /* Add Request 20 */
#define FDCAN_TXBAR_AR21        ((uint32_t)0x00200000U)  /* Add Request 21 */
#define FDCAN_TXBAR_AR22        ((uint32_t)0x00400000U)  /* Add Request 22 */
#define FDCAN_TXBAR_AR23        ((uint32_t)0x00800000U)  /* Add Request 23 */
#define FDCAN_TXBAR_AR24        ((uint32_t)0x01000000U)  /* Add Request 24 */
#define FDCAN_TXBAR_AR25        ((uint32_t)0x02000000U)  /* Add Request 25 */
#define FDCAN_TXBAR_AR26        ((uint32_t)0x04000000U)  /* Add Request 26 */
#define FDCAN_TXBAR_AR27        ((uint32_t)0x08000000U)  /* Add Request 27 */
#define FDCAN_TXBAR_AR28        ((uint32_t)0x10000000U)  /* Add Request 28 */
#define FDCAN_TXBAR_AR29        ((uint32_t)0x20000000U)  /* Add Request 29 */
#define FDCAN_TXBAR_AR30        ((uint32_t)0x40000000U)  /* Add Request 30 */
#define FDCAN_TXBAR_AR31        ((uint32_t)0x80000000U)  /* Add Request 31 */

/** Bit definition for FDCAN_TXBCR register **/
#define FDCAN_TXBCR_CR0         ((uint32_t)0x00000001U)  /* Cancellation Request 0  */
#define FDCAN_TXBCR_CR1         ((uint32_t)0x00000002U)  /* Cancellation Request 1  */
#define FDCAN_TXBCR_CR2         ((uint32_t)0x00000004U)  /* Cancellation Request 2  */
#define FDCAN_TXBCR_CR3         ((uint32_t)0x00000008U)  /* Cancellation Request 3  */
#define FDCAN_TXBCR_CR4         ((uint32_t)0x00000010U)  /* Cancellation Request 4  */
#define FDCAN_TXBCR_CR5         ((uint32_t)0x00000020U)  /* Cancellation Request 5  */
#define FDCAN_TXBCR_CR6         ((uint32_t)0x00000040U)  /* Cancellation Request 6  */
#define FDCAN_TXBCR_CR7         ((uint32_t)0x00000080U)  /* Cancellation Request 7  */
#define FDCAN_TXBCR_CR8         ((uint32_t)0x00000100U)  /* Cancellation Request 8  */
#define FDCAN_TXBCR_CR9         ((uint32_t)0x00000200U)  /* Cancellation Request 9  */
#define FDCAN_TXBCR_CR10        ((uint32_t)0x00000400U)  /* Cancellation Request 10 */
#define FDCAN_TXBCR_CR11        ((uint32_t)0x00000800U)  /* Cancellation Request 11 */
#define FDCAN_TXBCR_CR12        ((uint32_t)0x00001000U)  /* Cancellation Request 12 */
#define FDCAN_TXBCR_CR13        ((uint32_t)0x00002000U)  /* Cancellation Request 13 */
#define FDCAN_TXBCR_CR14        ((uint32_t)0x00004000U)  /* Cancellation Request 14 */
#define FDCAN_TXBCR_CR15        ((uint32_t)0x00008000U)  /* Cancellation Request 15 */
#define FDCAN_TXBCR_CR16        ((uint32_t)0x00010000U)  /* Cancellation Request 16 */
#define FDCAN_TXBCR_CR17        ((uint32_t)0x00020000U)  /* Cancellation Request 17 */
#define FDCAN_TXBCR_CR18        ((uint32_t)0x00040000U)  /* Cancellation Request 18 */
#define FDCAN_TXBCR_CR19        ((uint32_t)0x00080000U)  /* Cancellation Request 19 */
#define FDCAN_TXBCR_CR20        ((uint32_t)0x00100000U)  /* Cancellation Request 20 */
#define FDCAN_TXBCR_CR21        ((uint32_t)0x00200000U)  /* Cancellation Request 21 */
#define FDCAN_TXBCR_CR22        ((uint32_t)0x00400000U)  /* Cancellation Request 22 */
#define FDCAN_TXBCR_CR23        ((uint32_t)0x00800000U)  /* Cancellation Request 23 */
#define FDCAN_TXBCR_CR24        ((uint32_t)0x01000000U)  /* Cancellation Request 24 */
#define FDCAN_TXBCR_CR25        ((uint32_t)0x02000000U)  /* Cancellation Request 25 */
#define FDCAN_TXBCR_CR26        ((uint32_t)0x04000000U)  /* Cancellation Request 26 */
#define FDCAN_TXBCR_CR27        ((uint32_t)0x08000000U)  /* Cancellation Request 27 */
#define FDCAN_TXBCR_CR28        ((uint32_t)0x10000000U)  /* Cancellation Request 28 */
#define FDCAN_TXBCR_CR29        ((uint32_t)0x20000000U)  /* Cancellation Request 29 */
#define FDCAN_TXBCR_CR30        ((uint32_t)0x40000000U)  /* Cancellation Request 30 */
#define FDCAN_TXBCR_CR31        ((uint32_t)0x80000000U)  /* Cancellation Request 31 */

/** Bit definition for FDCAN_TXBTO register **/
#define FDCAN_TXBTO_TO0         ((uint32_t)0x00000001U)  /* Transmission Occurred 0  */
#define FDCAN_TXBTO_TO1         ((uint32_t)0x00000002U)  /* Transmission Occurred 1  */
#define FDCAN_TXBTO_TO2         ((uint32_t)0x00000004U)  /* Transmission Occurred 2  */
#define FDCAN_TXBTO_TO3         ((uint32_t)0x00000008U)  /* Transmission Occurred 3  */
#define FDCAN_TXBTO_TO4         ((uint32_t)0x00000010U)  /* Transmission Occurred 4  */
#define FDCAN_TXBTO_TO5         ((uint32_t)0x00000020U)  /* Transmission Occurred 5  */
#define FDCAN_TXBTO_TO6         ((uint32_t)0x00000040U)  /* Transmission Occurred 6  */
#define FDCAN_TXBTO_TO7         ((uint32_t)0x00000080U)  /* Transmission Occurred 7  */
#define FDCAN_TXBTO_TO8         ((uint32_t)0x00000100U)  /* Transmission Occurred 8  */
#define FDCAN_TXBTO_TO9         ((uint32_t)0x00000200U)  /* Transmission Occurred 9  */
#define FDCAN_TXBTO_TO10        ((uint32_t)0x00000400U)  /* Transmission Occurred 10 */
#define FDCAN_TXBTO_TO11        ((uint32_t)0x00000800U)  /* Transmission Occurred 11 */
#define FDCAN_TXBTO_TO12        ((uint32_t)0x00001000U)  /* Transmission Occurred 12 */
#define FDCAN_TXBTO_TO13        ((uint32_t)0x00002000U)  /* Transmission Occurred 13 */
#define FDCAN_TXBTO_TO14        ((uint32_t)0x00004000U)  /* Transmission Occurred 14 */
#define FDCAN_TXBTO_TO15        ((uint32_t)0x00008000U)  /* Transmission Occurred 15 */
#define FDCAN_TXBTO_TO16        ((uint32_t)0x00010000U)  /* Transmission Occurred 16 */
#define FDCAN_TXBTO_TO17        ((uint32_t)0x00020000U)  /* Transmission Occurred 17 */
#define FDCAN_TXBTO_TO18        ((uint32_t)0x00040000U)  /* Transmission Occurred 18 */
#define FDCAN_TXBTO_TO19        ((uint32_t)0x00080000U)  /* Transmission Occurred 19 */
#define FDCAN_TXBTO_TO20        ((uint32_t)0x00100000U)  /* Transmission Occurred 20 */
#define FDCAN_TXBTO_TO21        ((uint32_t)0x00200000U)  /* Transmission Occurred 21 */
#define FDCAN_TXBTO_TO22        ((uint32_t)0x00400000U)  /* Transmission Occurred 22 */
#define FDCAN_TXBTO_TO23        ((uint32_t)0x00800000U)  /* Transmission Occurred 23 */
#define FDCAN_TXBTO_TO24        ((uint32_t)0x01000000U)  /* Transmission Occurred 24 */
#define FDCAN_TXBTO_TO25        ((uint32_t)0x02000000U)  /* Transmission Occurred 25 */
#define FDCAN_TXBTO_TO26        ((uint32_t)0x04000000U)  /* Transmission Occurred 26 */
#define FDCAN_TXBTO_TO27        ((uint32_t)0x08000000U)  /* Transmission Occurred 27 */
#define FDCAN_TXBTO_TO28        ((uint32_t)0x10000000U)  /* Transmission Occurred 28 */
#define FDCAN_TXBTO_TO29        ((uint32_t)0x20000000U)  /* Transmission Occurred 29 */
#define FDCAN_TXBTO_TO30        ((uint32_t)0x40000000U)  /* Transmission Occurred 30 */
#define FDCAN_TXBTO_TO31        ((uint32_t)0x80000000U)  /* Transmission Occurred 31 */

/** Bit definition for FDCAN_TXBCF register **/
#define FDCAN_TXBCF_CF0         ((uint32_t)0x00000001U)  /* Cancellation Finished 0  */
#define FDCAN_TXBCF_CF1         ((uint32_t)0x00000002U)  /* Cancellation Finished 1  */
#define FDCAN_TXBCF_CF2         ((uint32_t)0x00000004U)  /* Cancellation Finished 2  */
#define FDCAN_TXBCF_CF3         ((uint32_t)0x00000008U)  /* Cancellation Finished 3  */
#define FDCAN_TXBCF_CF4         ((uint32_t)0x00000010U)  /* Cancellation Finished 4  */
#define FDCAN_TXBCF_CF5         ((uint32_t)0x00000020U)  /* Cancellation Finished 5  */
#define FDCAN_TXBCF_CF6         ((uint32_t)0x00000040U)  /* Cancellation Finished 6  */
#define FDCAN_TXBCF_CF7         ((uint32_t)0x00000080U)  /* Cancellation Finished 7  */
#define FDCAN_TXBCF_CF8         ((uint32_t)0x00000100U)  /* Cancellation Finished 8  */
#define FDCAN_TXBCF_CF9         ((uint32_t)0x00000200U)  /* Cancellation Finished 9  */
#define FDCAN_TXBCF_CF10        ((uint32_t)0x00000400U)  /* Cancellation Finished 10 */
#define FDCAN_TXBCF_CF11        ((uint32_t)0x00000800U)  /* Cancellation Finished 11 */
#define FDCAN_TXBCF_CF12        ((uint32_t)0x00001000U)  /* Cancellation Finished 12 */
#define FDCAN_TXBCF_CF13        ((uint32_t)0x00002000U)  /* Cancellation Finished 13 */
#define FDCAN_TXBCF_CF14        ((uint32_t)0x00004000U)  /* Cancellation Finished 14 */
#define FDCAN_TXBCF_CF15        ((uint32_t)0x00008000U)  /* Cancellation Finished 15 */
#define FDCAN_TXBCF_CF16        ((uint32_t)0x00010000U)  /* Cancellation Finished 16 */
#define FDCAN_TXBCF_CF17        ((uint32_t)0x00020000U)  /* Cancellation Finished 17 */
#define FDCAN_TXBCF_CF18        ((uint32_t)0x00040000U)  /* Cancellation Finished 18 */
#define FDCAN_TXBCF_CF19        ((uint32_t)0x00080000U)  /* Cancellation Finished 19 */
#define FDCAN_TXBCF_CF20        ((uint32_t)0x00100000U)  /* Cancellation Finished 20 */
#define FDCAN_TXBCF_CF21        ((uint32_t)0x00200000U)  /* Cancellation Finished 21 */
#define FDCAN_TXBCF_CF22        ((uint32_t)0x00400000U)  /* Cancellation Finished 22 */
#define FDCAN_TXBCF_CF23        ((uint32_t)0x00800000U)  /* Cancellation Finished 23 */
#define FDCAN_TXBCF_CF24        ((uint32_t)0x01000000U)  /* Cancellation Finished 24 */
#define FDCAN_TXBCF_CF25        ((uint32_t)0x02000000U)  /* Cancellation Finished 25 */
#define FDCAN_TXBCF_CF26        ((uint32_t)0x04000000U)  /* Cancellation Finished 26 */
#define FDCAN_TXBCF_CF27        ((uint32_t)0x08000000U)  /* Cancellation Finished 27 */
#define FDCAN_TXBCF_CF28        ((uint32_t)0x10000000U)  /* Cancellation Finished 28 */
#define FDCAN_TXBCF_CF29        ((uint32_t)0x20000000U)  /* Cancellation Finished 29 */
#define FDCAN_TXBCF_CF30        ((uint32_t)0x40000000U)  /* Cancellation Finished 30 */
#define FDCAN_TXBCF_CF31        ((uint32_t)0x80000000U)  /* Cancellation Finished 31 */

/** Bit definition for FDCAN_TXBTIE register **/
#define FDCAN_TXBTIE_TIE0       ((uint32_t)0x00000001U)  /* Transmission Interrupt Enable 0  */
#define FDCAN_TXBTIE_TIE1       ((uint32_t)0x00000002U)  /* Transmission Interrupt Enable 1  */
#define FDCAN_TXBTIE_TIE2       ((uint32_t)0x00000004U)  /* Transmission Interrupt Enable 2  */
#define FDCAN_TXBTIE_TIE3       ((uint32_t)0x00000008U)  /* Transmission Interrupt Enable 3  */
#define FDCAN_TXBTIE_TIE4       ((uint32_t)0x00000010U)  /* Transmission Interrupt Enable 4  */
#define FDCAN_TXBTIE_TIE5       ((uint32_t)0x00000020U)  /* Transmission Interrupt Enable 5  */
#define FDCAN_TXBTIE_TIE6       ((uint32_t)0x00000040U)  /* Transmission Interrupt Enable 6  */
#define FDCAN_TXBTIE_TIE7       ((uint32_t)0x00000080U)  /* Transmission Interrupt Enable 7  */
#define FDCAN_TXBTIE_TIE8       ((uint32_t)0x00000100U)  /* Transmission Interrupt Enable 8  */
#define FDCAN_TXBTIE_TIE9       ((uint32_t)0x00000200U)  /* Transmission Interrupt Enable 9  */
#define FDCAN_TXBTIE_TIE10      ((uint32_t)0x00000400U)  /* Transmission Interrupt Enable 10 */
#define FDCAN_TXBTIE_TIE11      ((uint32_t)0x00000800U)  /* Transmission Interrupt Enable 11 */
#define FDCAN_TXBTIE_TIE12      ((uint32_t)0x00001000U)  /* Transmission Interrupt Enable 12 */
#define FDCAN_TXBTIE_TIE13      ((uint32_t)0x00002000U)  /* Transmission Interrupt Enable 13 */
#define FDCAN_TXBTIE_TIE14      ((uint32_t)0x00004000U)  /* Transmission Interrupt Enable 14 */
#define FDCAN_TXBTIE_TIE15      ((uint32_t)0x00008000U)  /* Transmission Interrupt Enable 15 */
#define FDCAN_TXBTIE_TIE16      ((uint32_t)0x00010000U)  /* Transmission Interrupt Enable 16 */
#define FDCAN_TXBTIE_TIE17      ((uint32_t)0x00020000U)  /* Transmission Interrupt Enable 17 */
#define FDCAN_TXBTIE_TIE18      ((uint32_t)0x00040000U)  /* Transmission Interrupt Enable 18 */
#define FDCAN_TXBTIE_TIE19      ((uint32_t)0x00080000U)  /* Transmission Interrupt Enable 19 */
#define FDCAN_TXBTIE_TIE20      ((uint32_t)0x00100000U)  /* Transmission Interrupt Enable 20 */
#define FDCAN_TXBTIE_TIE21      ((uint32_t)0x00200000U)  /* Transmission Interrupt Enable 21 */
#define FDCAN_TXBTIE_TIE22      ((uint32_t)0x00400000U)  /* Transmission Interrupt Enable 22 */
#define FDCAN_TXBTIE_TIE23      ((uint32_t)0x00800000U)  /* Transmission Interrupt Enable 23 */
#define FDCAN_TXBTIE_TIE24      ((uint32_t)0x01000000U)  /* Transmission Interrupt Enable 24 */
#define FDCAN_TXBTIE_TIE25      ((uint32_t)0x02000000U)  /* Transmission Interrupt Enable 25 */
#define FDCAN_TXBTIE_TIE26      ((uint32_t)0x04000000U)  /* Transmission Interrupt Enable 26 */
#define FDCAN_TXBTIE_TIE27      ((uint32_t)0x08000000U)  /* Transmission Interrupt Enable 27 */
#define FDCAN_TXBTIE_TIE28      ((uint32_t)0x10000000U)  /* Transmission Interrupt Enable 28 */
#define FDCAN_TXBTIE_TIE29      ((uint32_t)0x20000000U)  /* Transmission Interrupt Enable 29 */
#define FDCAN_TXBTIE_TIE30      ((uint32_t)0x40000000U)  /* Transmission Interrupt Enable 30 */
#define FDCAN_TXBTIE_TIE31      ((uint32_t)0x80000000U)  /* Transmission Interrupt Enable 31 */

/** Bit definition for TXBCIE register **/
#define FDCAN_TXBCIE_CFIE0      ((uint32_t)0x00000001U)  /* Cancellation Finished Interrupt Enable 0  */
#define FDCAN_TXBCIE_CFIE1      ((uint32_t)0x00000002U)  /* Cancellation Finished Interrupt Enable 1  */
#define FDCAN_TXBCIE_CFIE2      ((uint32_t)0x00000004U)  /* Cancellation Finished Interrupt Enable 2  */
#define FDCAN_TXBCIE_CFIE3      ((uint32_t)0x00000008U)  /* Cancellation Finished Interrupt Enable 3  */
#define FDCAN_TXBCIE_CFIE4      ((uint32_t)0x00000010U)  /* Cancellation Finished Interrupt Enable 4  */
#define FDCAN_TXBCIE_CFIE5      ((uint32_t)0x00000020U)  /* Cancellation Finished Interrupt Enable 5  */
#define FDCAN_TXBCIE_CFIE6      ((uint32_t)0x00000040U)  /* Cancellation Finished Interrupt Enable 6  */
#define FDCAN_TXBCIE_CFIE7      ((uint32_t)0x00000080U)  /* Cancellation Finished Interrupt Enable 7  */
#define FDCAN_TXBCIE_CFIE8      ((uint32_t)0x00000100U)  /* Cancellation Finished Interrupt Enable 8  */
#define FDCAN_TXBCIE_CFIE9      ((uint32_t)0x00000200U)  /* Cancellation Finished Interrupt Enable 9  */
#define FDCAN_TXBCIE_CFIE10     ((uint32_t)0x00000400U)  /* Cancellation Finished Interrupt Enable 10 */
#define FDCAN_TXBCIE_CFIE11     ((uint32_t)0x00000800U)  /* Cancellation Finished Interrupt Enable 11 */
#define FDCAN_TXBCIE_CFIE12     ((uint32_t)0x00001000U)  /* Cancellation Finished Interrupt Enable 12 */
#define FDCAN_TXBCIE_CFIE13     ((uint32_t)0x00002000U)  /* Cancellation Finished Interrupt Enable 13 */
#define FDCAN_TXBCIE_CFIE14     ((uint32_t)0x00004000U)  /* Cancellation Finished Interrupt Enable 14 */
#define FDCAN_TXBCIE_CFIE15     ((uint32_t)0x00008000U)  /* Cancellation Finished Interrupt Enable 15 */
#define FDCAN_TXBCIE_CFIE16     ((uint32_t)0x00010000U)  /* Cancellation Finished Interrupt Enable 16 */
#define FDCAN_TXBCIE_CFIE17     ((uint32_t)0x00020000U)  /* Cancellation Finished Interrupt Enable 17 */
#define FDCAN_TXBCIE_CFIE18     ((uint32_t)0x00040000U)  /* Cancellation Finished Interrupt Enable 18 */
#define FDCAN_TXBCIE_CFIE19     ((uint32_t)0x00080000U)  /* Cancellation Finished Interrupt Enable 19 */
#define FDCAN_TXBCIE_CFIE20     ((uint32_t)0x00100000U)  /* Cancellation Finished Interrupt Enable 20 */
#define FDCAN_TXBCIE_CFIE21     ((uint32_t)0x00200000U)  /* Cancellation Finished Interrupt Enable 21 */
#define FDCAN_TXBCIE_CFIE22     ((uint32_t)0x00400000U)  /* Cancellation Finished Interrupt Enable 22 */
#define FDCAN_TXBCIE_CFIE23     ((uint32_t)0x00800000U)  /* Cancellation Finished Interrupt Enable 23 */
#define FDCAN_TXBCIE_CFIE24     ((uint32_t)0x01000000U)  /* Cancellation Finished Interrupt Enable 24 */
#define FDCAN_TXBCIE_CFIE25     ((uint32_t)0x02000000U)  /* Cancellation Finished Interrupt Enable 25 */
#define FDCAN_TXBCIE_CFIE26     ((uint32_t)0x04000000U)  /* Cancellation Finished Interrupt Enable 26 */
#define FDCAN_TXBCIE_CFIE27     ((uint32_t)0x08000000U)  /* Cancellation Finished Interrupt Enable 27 */
#define FDCAN_TXBCIE_CFIE28     ((uint32_t)0x10000000U)  /* Cancellation Finished Interrupt Enable 28 */
#define FDCAN_TXBCIE_CFIE29     ((uint32_t)0x20000000U)  /* Cancellation Finished Interrupt Enable 29 */
#define FDCAN_TXBCIE_CFIE30     ((uint32_t)0x40000000U)  /* Cancellation Finished Interrupt Enable 30 */
#define FDCAN_TXBCIE_CFIE31     ((uint32_t)0x80000000U)  /* Cancellation Finished Interrupt Enable 31 */

/** Bit definition for FDCAN_TXEFC register **/
#define FDCAN_TXEFC_EFSA        ((uint32_t)0x0000FFFCU)  /* Event FIFO Start Address */
#define FDCAN_TXEFC_EFS         ((uint32_t)0x003F0000U)  /* Event FIFO Size bits  */
#define FDCAN_TXEFC_EFWM        ((uint32_t)0x3F000000U)  /* Event FIFO Watermark bits  */

/** Bit definition for FDCAN_TXEFS register **/
#define FDCAN_TXEFS_EFFL        ((uint32_t)0x0000003FU)  /* Event FIFO Fill Level bits  */
#define FDCAN_TXEFS_EFGI        ((uint32_t)0x00001F00U)  /* Event FIFO Get Index bits  */
#define FDCAN_TXEFS_EFPI        ((uint32_t)0x001F0000U)  /* Event FIFO Put Index bits  */
#define FDCAN_TXEFS_EFF         ((uint32_t)0x01000000U)  /* Event FIFO Full            */
#define FDCAN_TXEFS_TEFL        ((uint32_t)0x02000000U)  /* Tx Event FIFO Element Lost */

/** Bit definition for FDCAN_TXEFA register **/
#define FDCAN_TXEFA_EFAI        ((uint32_t)0x0000001FU)  /* Event FIFO Acknowledge Index bits  */

/** Bit definition for FDCAN_TTTS register **/
#define FDCAN_TTSS_TS_SEL       ((uint32_t)0x000000E0U)  /* Select External timestamp clock divided bits  */
#define FDCAN_TTSS_TS_SEL_0     ((uint32_t)0x00000020U)  /* Select External timestamp clock divided bit 0 */
#define FDCAN_TTSS_TS_SEL_1     ((uint32_t)0x00000040U)  /* Select External timestamp clock divided bit 1 */
#define FDCAN_TTSS_TS_SEL_2     ((uint32_t)0x00000080U)  /* Select External timestamp clock divided bit 2 */

#define FDCAN_TTSS_TS_SEL_DIV4      ((uint32_t)0x00000000U)  /* Select External timestamp clock divided is 4   */
#define FDCAN_TTSS_TS_SEL_DIV8      ((uint32_t)0x00000020U)  /* Select External timestamp clock divided is 8   */
#define FDCAN_TTSS_TS_SEL_DIV16     ((uint32_t)0x00000040U)  /* Select External timestamp clock divided is 16  */
#define FDCAN_TTSS_TS_SEL_DIV32     ((uint32_t)0x00000060U)  /* Select External timestamp clock divided is 32  */
#define FDCAN_TTSS_TS_SEL_DIV64     ((uint32_t)0x00000080U)  /* Select External timestamp clock divided is 64  */
#define FDCAN_TTSS_TS_SEL_DIV128    ((uint32_t)0x000000A0U)  /* Select External timestamp clock divided is 128 */
#define FDCAN_TTSS_TS_SEL_DIV256    ((uint32_t)0x000000C0U)  /* Select External timestamp clock divided is 256 */
#define FDCAN_TTSS_TS_SEL_DIV512    ((uint32_t)0x000000E0U)  /* Select External timestamp clock divided is 512 */

#define FDCAN_TTSS_TS_EN        ((uint32_t)0x00000100U)  /* External timestamp vector enable */

/*** Serial Peripheral Interface ***/

/** Bit definition for SPI_CTRL1 register **/
#define SPI_CTRL1_BR             ((uint16_t)0x0007U) /* BR[2:0] bits (Baud Rate Control) */
#define SPI_CTRL1_CTRL1_BR0      ((uint16_t)0x0001U) /* Bit 0 */
#define SPI_CTRL1_CTRL1_BR1      ((uint16_t)0x0002U) /* Bit 1 */
#define SPI_CTRL1_CTRL1_BR2      ((uint16_t)0x0004U) /* Bit 2 */

#define SPI_CLKPOL                 ((uint16_t)0x0010U) /* Clock Polarity */
#define SPI_CLKPHA                 ((uint16_t)0x0020U) /* Clock Phase */

#define SPI_CTRL1_MSEL               ((uint16_t)0x0040U) /* Master Selection */
#define SPI_CTRL1_LSBFF              ((uint16_t)0x0080U) /* Frame Format */
#define SPI_CTRL1_DATFF              ((uint16_t)0x0100U) /* Data Frame Format */
#define SPI_CTRL1_CRCNEXT            ((uint16_t)0x0200U) /* Transmit CRC next Software slave management */
#define SPI_CTRL1_SSOEN              ((uint16_t)0x0400U) /* SS Output Enable */
#define SPI_CTRL1_SSEL               ((uint16_t)0x0800U) /* Internal slave select  */
#define SPI_CTRL1_SSMEN              ((uint16_t)0x1000U) /* Software slave management */
#define SPI_CTRL1_RONLY              ((uint16_t)0x2000U) /* Receive only  */
#define SPI_CTRL1_BIDIROEN           ((uint16_t)0x4000U) /* Output enable in bidirectional mode */
#define SPI_CTRL1_BIDIRMODE          ((uint16_t)0x8000U) /* Bidirectional data mode enable */

/** Bit definition for SPI_CTRL2 register **/
#define SPI_CTRL2_SPIEN               ((uint16_t)0x0001U) /* SPI enable */
#define SPI_CTRL2_RDMAEN              ((uint16_t)0x0002U) /* Rx buffer DMA enable */
#define SPI_CTRL2_TDMAEN              ((uint16_t)0x0004U) /* Tx buffer DMA enable */
#define SPI_CTRL2_CRCEN               ((uint16_t)0x0008U) /* Hardware CRC calculation enable */
#define SPI_CTRL2_TEINTEN             ((uint16_t)0x0010U) /* Tx buffer empty interrupt enable */
#define SPI_CTRL2_RNEINTEN            ((uint16_t)0x0020U) /* RX buffer not empty interrupt enable */
#define SPI_CTRL2_ERRINTEN            ((uint16_t)0x0040U) /* Error interrupt enable */
#define SPI_CTRL2_SS_POL              ((uint16_t)0x0080U) /* NSS polarity control */
#define SPI_CTRL2_FIFOEN              ((uint16_t)0x0100U) /* FIFO mode enable */
#define SPI_CTRL2_FIFOCLR             ((uint16_t)0x0200U) /* FIFO clear enable */
#define SPI_CTRL2_TXFHEINTEN          ((uint16_t)0x0400U) /* Send FIFO half empty interrupt enable */
#define SPI_CTRL2_RXFHFINTEN          ((uint16_t)0x0800U) /* Receive FIFO half full interrupt enable */
#define SPI_CTRL2_RXFFUINTEN          ((uint16_t)0x1000U) /* Receive FIFO full interrupt enable */
#define SPI_CTRL2_CRCNMISEN           ((uint16_t)0x2000U) /* CRC stop calculation enable */
#define SPI_CTRL2_RXCPINTEN           ((uint16_t)0x4000U) /* Receive transfer complete interrupt enable */
#define SPI_CTRL2_RDMABYPASS          ((uint16_t)0x8000U) /* rxne for dma is bypass */

/** Bit definition for SPI_STS register **/
#define SPI_STS_TE              ((uint16_t)0x0001U) /* Transmit buffer Empty */
#define SPI_STS_RNE             ((uint16_t)0x0002U) /* Receive buffer Not Empty */
#define SPI_STS_BUSY            ((uint16_t)0x0004U) /* Busy flag */
#define SPI_STS_CRCERR          ((uint16_t)0x0008U) /* CRC Error flag */
#define SPI_STS_MODERR          ((uint16_t)0x0010U) /* Mode fault */
#define SPI_STS_OVER            ((uint16_t)0x0020U) /* Overrun flag */
#define SPI_STS_UNDER           ((uint16_t)0x0040U) /* Underrun flag */
#define SPI_STS_CHSIDE          ((uint16_t)0x0080U) /* Channel side */
#define SPI_STS_TXFIFHE         ((uint16_t)0x0100U) /* TX FIFO half empty flag */
#define SPI_STS_RXFIFHF         ((uint16_t)0x0200U) /* RX FIFO half empty flag */
#define SPI_STS_TXFIFFU         ((uint16_t)0x0400U) /* TX FIFO full flag */
#define SPI_STS_RXFIFFU         ((uint16_t)0x0800U) /* RX FIFO full flag */
#define SPI_STS_RXTSCP          ((uint16_t)0x1000U) /* In receive-only mode, the transmission complete status */

/** Bit definition for SPI_DAT register **/
#define SPI_DAT_DAT                         ((uint16_t)0xFFFFU) /* Data Register */

/** Bit definition for SPI_CRCTDAT register **/
#define SPI_CRCTDAT_CRCTDAT                 ((uint16_t)0xFFFFU) /* Tx CRC Register */

/** Bit definition for SPI_CRCRDAT register **/
#define SPI_CRCRDAT_CRCRDAT                 ((uint16_t)0xFFFFU) /* Rx CRC Register */

/** Bit definition for SPI_CRCPOLY register **/
#define SPI_CRCPOLY_CRCPOLY                 ((uint16_t)0xFFFFU) /* CRC polynomial register */

/** Bit definition for SPI_I2SCFG register **/
#define SPI_I2SCFG_I2SEN                      ((uint16_t)0x0001U) /* I2S Enable */
#define SPI_I2SCFG_MODSEL                     ((uint16_t)0x0002U) /* I2S mode selection */
#define SPI_I2SCFG_STDSEL                     ((uint16_t)0x000CU) /* STDSEL[1:0] bits (I2S standard selection) */
#define SPI_I2SCFG_STDSEL0                    ((uint16_t)0x0004U) /* Bit 0 */
#define SPI_I2SCFG_STDSEL1                    ((uint16_t)0x0008U) /* Bit 1 */
#define SPI_I2SCFG_MODCFG                     ((uint16_t)0x0030U) /* MODCFG[1:0] bits (I2S configuration mode) */
#define SPI_I2SCFG_MODCFG0                    ((uint16_t)0x0010U) /* Bit 0 */
#define SPI_I2SCFG_MODCFG1                    ((uint16_t)0x0020U) /* Bit 1 */
#define SPI_I2SCFG_TDATLEN                    ((uint16_t)0x00C0U) /* TDATLEN[1:0] bits (Data length to be transferred) */
#define SPI_I2SCFG_TDATLEN0                   ((uint16_t)0x0040U) /* Bit 0 */
#define SPI_I2SCFG_TDATLEN1                   ((uint16_t)0x0080U) /* Bit 1 */
#define SPI_I2SCFG_CHBITS                     ((uint16_t)0x0100U) /* Channel length (number of bits per audio channel) */
#define SPI_I2SCFG_PCMFSYNC                   ((uint16_t)0x0200U) /* PCM frame synchronization */
#define SPI_I2SCFG_CLKPOL                     ((uint16_t)0x0400U) /* steady state clock polarity */
#define SPI_I2SCFG_PCMBYPASS                  ((uint16_t)0x0800U) /* pcm long for 13bit is bypass */

/** Bit definition for SPI_I2SPREDIV register **/
#define SPI_I2SPREDIV_LDIV                 ((uint16_t)0x03FFU) /* I2S Linear prescaler */
#define SPI_I2SPREDIV_ODDEVEN              ((uint16_t)0x0400U) /* Odd factor for the prescaler */
#define SPI_I2SPREDIV_MCLKOEN              ((uint16_t)0x0800U) /* Master Clock Output Enable */

/** Bit definition for SPI_RX_FIFO register **/
#define SPI_RXFIFDAT                     ((uint16_t)0xFFFFU) /* RX FIFO Data Register */

/** Bit definition for SPI_FIFO_NUM register **/
#define SPI_FIFO_NUM_TXFBSNUM          ((uint16_t)0x0007U) /* FIFO_NUM [2:0] bits (TX FIFO half empty NUM configuration) */
#define SPI_FIFO_NUM_TXFBSNUM0         ((uint16_t)0x0001U) /* Bit 0 */
#define SPI_FIFO_NUM_TXFBSNUM1         ((uint16_t)0x0002U) /* Bit 1 */
#define SPI_FIFO_NUM_TXFBSNUM2         ((uint16_t)0x0004U) /* Bit 2*/
#define SPI_FIFO_NUM_RXFBSNUM          ((uint16_t)0x0070U) /* FIFO_NUM [2:0] bits (RX FIFO half full NUM configuration) */
#define SPI_FIFO_NUM_RXFBSNUM0         ((uint16_t)0x0010U) /* Bit 0 */
#define SPI_FIFO_NUM_RXFBSNUM1         ((uint16_t)0x0020U) /* Bit 1 */
#define SPI_FIFO_NUM_RXFBSNUM2         ((uint16_t)0x0040U) /* Bit 2*/

/** Bit definition for SPI_FIFO_CNT register **/
#define SPI_FIFO_CNT_TXFIFCNT                  ((uint16_t)0x000FU) /* FIFO_CNT[3:0] bits (TX FIFO Valid number) */
#define SPI_FIFO_CNT_TXFIFCNT0                 ((uint16_t)0x0001U) /* Bit 0 */
#define SPI_FIFO_CNT_TXFIFCNT1                 ((uint16_t)0x0002U) /* Bit 1 */
#define SPI_FIFO_CNT_TXFIFCNT2                 ((uint16_t)0x0004U) /* Bit 2*/
#define SPI_FIFO_CNT_TXFIFCNT3                 ((uint16_t)0x0008U) /* Bit 3*/
#define SPI_FIFO_CNT_RXFIFCNT                  ((uint16_t)0x00F0U) /* FIFO_CNT [3:0] bits (RX FIFO Valid number) */
#define SPI_FIFO_CNT_RXFIFCNT0                 ((uint16_t)0x0010U) /* Bit 0 */
#define SPI_FIFO_CNT_RXFIFCNT1                 ((uint16_t)0x0020U) /* Bit 1 */
#define SPI_FIFO_CNT_RXFIFCNT2                 ((uint16_t)0x0040U) /* Bit 2*/
#define SPI_FIFO_CNT_RXFIFCNT3                 ((uint16_t)0x0080U) /* Bit 3*/

/** Bit definition for SPI_TRANS_NUM register **/
#define SPI_TRANS_NUM_TRANSNUM              ((uint16_t)0xFFFFU) /* RX FIFO Data Register */

/** Bit definition for SPI_CR3 register **/
#define SPI_CR3_DELAYTIME                      ((uint16_t)0x000FU) /* CR[3:0] bits (Clock Sample Delay Register) */
#define SPI_CR3_DELAYTIME0                     ((uint16_t)0x0001U) /* Bit 0 */
#define SPI_CR3_DELAYTIME1                     ((uint16_t)0x0002U) /* Bit 1 */
#define SPI_CR3_DELAYTIME2                     ((uint16_t)0x0004U) /* Bit 2 */
#define SPI_CR3_DELAYTIME3                     ((uint16_t)0x0008U) /* Bit 3 */

/** Bit definition for I2SEXT_CTRL2 register **/
#define I2SEXT_CTRL2_RDMAEN             ((uint16_t)0x0002U) /* Rx buffer DMA enable */
#define I2SEXT_CTRL2_TDMAEN             ((uint16_t)0x0004U) /* Tx buffer DMA enable */
#define I2SEXT_CTRL2_TEINTEN            ((uint16_t)0x0010U) /* Tx buffer empty interrupt enable */
#define I2SEXT_CTRL2_RNEINTEN           ((uint16_t)0x0020U) /* RX buffer not empty interrupt enable */
#define I2SEXT_CTRL2_ERRINTEN           ((uint16_t)0x0040U) /* Error interrupt enable */
#define I2SEXT_CTRL2_RDMABYPASS         ((uint16_t)0x8000U) /* rxne for dma is bypass */

/** Bit definition for I2SEXT_STS register **/
#define I2SEXT_STS_TE                     ((uint16_t)0x0001U) /* Transmit buffer Empty */
#define I2SEXT_STS_RNE                    ((uint16_t)0x0002U) /* Receive buffer Not Empty */
#define I2SEXT_STS_BUSY                   ((uint16_t)0x0004U) /* Busy flag */
#define I2SEXT_STS_OVER                   ((uint16_t)0x0020U) /* Overrun flag */
#define I2SEXT_STS_UNDER                  ((uint16_t)0x0040U) /* Underrun flag */
#define I2SEXT_STS_CHSIDE                 ((uint16_t)0x0080U) /* Channel side */

/** Bit definition for I2SEXT_DAT register **/
#define I2SEXT_DAT_DAT                 ((uint16_t)0xFFFFU) /* Data Register */

/** Bit definition for I2SEXT_I2SCFG register **/
#define I2SEXT_I2SCFG_I2SEN          ((uint16_t)0x0001U) /* I2S Enable */
#define I2SEXT_I2SCFG_MODSEL         ((uint16_t)0x0002U) /* I2S mode selection */
#define I2SEXT_I2SCFG_STDSEL         ((uint16_t)0x000CU) /* STDSEL[1:0] bits (I2S standard selection) */
#define I2SEXT_I2SCFG_STDSEL0        ((uint16_t)0x0004U) /* Bit 0 */
#define I2SEXT_I2SCFG_STDSEL1        ((uint16_t)0x0008U) /* Bit 1 */
#define I2SEXT_I2SCFG_MODCFG         ((uint16_t)0x0030U) /* MODCFG[1:0] bits (I2S configuration mode) */
#define I2SEXT_I2SCFG_MODCFG0        ((uint16_t)0x0010U) /* Bit 0 */
#define I2SEXT_I2SCFG_MODCFG1        ((uint16_t)0x0020U) /* Bit 1 */
#define I2SEXT_I2SCFG_TDATLEN        ((uint16_t)0x00C0U) /* TDATLEN[1:0] bits (Data length to be transferred) */
#define I2SEXT_I2SCFG_TDATLEN0       ((uint16_t)0x0040U) /* Bit 0 */
#define I2SEXT_I2SCFG_TDATLEN1       ((uint16_t)0x0080U) /* Bit 1 */
#define I2SEXT_I2SCFG_CHBITS         ((uint16_t)0x0100U) /* Channel length (number of bits per audio channel) */
#define I2SEXT_I2SCFG_PCMFSYNC       ((uint16_t)0x0200U) /* PCM frame synchronization */
#define I2SEXT_I2SCFG_CLKPOL         ((uint16_t)0x0400U) /* steady state clock polarity */


/*** Low-Power Timer ***/

/** Bit definition for LPTIM_INTSTS register **/
#define LPTIM_INTSTS_CMPM   ((uint32_t)0x00000001U) /* Compare match */
#define LPTIM_INTSTS_ARRM   ((uint32_t)0x00000002U) /* Autoreload match */
#define LPTIM_INTSTS_EXTRIG ((uint32_t)0x00000004U) /* External trigger edge event */
#define LPTIM_INTSTS_CMPUPD ((uint32_t)0x00000008U) /* Compare register update OK */
#define LPTIM_INTSTS_ARRUPD ((uint32_t)0x00000010U) /* Autoreload register update OK */
#define LPTIM_INTSTS_UP     ((uint32_t)0x00000020U) /* Counter direction change down to up */
#define LPTIM_INTSTS_DOWN   ((uint32_t)0x00000040U) /* Counter direction change up to down */

/** Bit definition for LPTIM_INTCLR register **/
#define LPTIM_INTCLR_CMPMCF   ((uint32_t)0x00000001U) /* Compare match Clear Flag */
#define LPTIM_INTCLR_ARRMCF   ((uint32_t)0x00000002U) /* Autoreload match Clear Flag */
#define LPTIM_INTCLR_EXTRIGCF ((uint32_t)0x00000004U) /* External trigger edge event Clear Flag */
#define LPTIM_INTCLR_CMPUPDCF ((uint32_t)0x00000008U) /* Compare register update OK Clear Flag */
#define LPTIM_INTCLR_ARRUPDCF ((uint32_t)0x00000010U) /* Autoreload register update OK Clear Flag */
#define LPTIM_INTCLR_UPCF     ((uint32_t)0x00000020U) /* Counter direction change down to up Clear Flag */
#define LPTIM_INTCLR_DOWNCF   ((uint32_t)0x00000040U) /* Counter direction change up to down Clear Flag */

/** Bit definition for LPTIM_INTEN register **/
#define LPTIM_INTEN_CMPMIE   ((uint32_t)0x00000001U) /* Compare match Interrupt Enable */
#define LPTIM_INTEN_ARRMIE   ((uint32_t)0x00000002U) /* Autoreload match Interrupt Enable */
#define LPTIM_INTEN_EXTRIGIE ((uint32_t)0x00000004U) /* External trigger edge event Interrupt Enable */
#define LPTIM_INTEN_CMPUPDIE ((uint32_t)0x00000008U) /* Compare register update OK Interrupt Enable */
#define LPTIM_INTEN_ARRUPDIE ((uint32_t)0x00000010U) /* Autoreload register update OK Interrupt Enable */
#define LPTIM_INTEN_UPIE     ((uint32_t)0x00000020U) /* Counter direction change down to up Interrupt Enable */
#define LPTIM_INTEN_DOWNIE   ((uint32_t)0x00000040U) /* Counter direction change up to down Interrupt Enable */

/** Bit definition for LPTIM_CFG register **/
#define LPTIM_CFG_CLKSEL    ((uint32_t)0x00000001U) /* Clock selector */

#define LPTIM_CFG_CLKPOL    ((uint32_t)0x00000006U) /* CLKPOL[1:0] bits (Clock polarity) */
#define LPTIM_CFG_CLKPOL_0  ((uint32_t)0x00000002U) /* CLKPOL bit 0 */
#define LPTIM_CFG_CLKPOL_1  ((uint32_t)0x00000004U) /* CLKPOL bit 1 */

#define LPTIM_CFG_CLKFLT    ((uint32_t)0x00000018U) /* CLKFLT[1:0] bits (Configurable digital filter for external clock) */
#define LPTIM_CFG_CLKFLT_0  ((uint32_t)0x00000008U) /* CLKFLT bit 0 */
#define LPTIM_CFG_CLKFLT_1  ((uint32_t)0x00000010U) /* CLKFLT bit 1 */

#define LPTIM_CFG_TRIGFLT   ((uint32_t)0x000000C0U) /* TRIGFLT[1:0] bits (Configurable digital filter for trigger) */
#define LPTIM_CFG_TRIGFLT_0 ((uint32_t)0x00000040U) /* TRIGFLT bit 0 */
#define LPTIM_CFG_TRIGFLT_1 ((uint32_t)0x00000080U) /* TRIGFLT bit 1 */

#define LPTIM_CFG_CLKPRE    ((uint32_t)0x00000E00U) /* CLKPRE[2:0] bits (Clock prescaler) */
#define LPTIM_CFG_CLKPRE_0  ((uint32_t)0x00000200U) /* CLKPRE bit 0 */
#define LPTIM_CFG_CLKPRE_1  ((uint32_t)0x00000400U) /* CLKPRE bit 1 */
#define LPTIM_CFG_CLKPRE_2  ((uint32_t)0x00000800U) /* CLKPRE bit 2 */

#define LPTIM_CFG_TRGSEL    ((uint32_t)0x0001E000U) /* TRGSEL[3:0]] bits (Trigger selector) */
#define LPTIM_CFG_TRGSEL_0  ((uint32_t)0x00002000U) /* TRGSEL bit 0 */
#define LPTIM_CFG_TRGSEL_1  ((uint32_t)0x00004000U) /* TRGSEL bit 1 */
#define LPTIM_CFG_TRGSEL_2  ((uint32_t)0x00008000U) /* TRGSEL bit 2 */
#define LPTIM_CFG_TRGSEL_3  ((uint32_t)0x00010000U) /* TRGSEL bit 3 */

#define LPTIM_CFG_TRGEN     ((uint32_t)0x00060000U) /* TRGEN[1:0] bits (Trigger enable and polarity) */
#define LPTIM_CFG_TRGEN_0   ((uint32_t)0x00020000U) /* TRGEN bit 0 */
#define LPTIM_CFG_TRGEN_1   ((uint32_t)0x00040000U) /* TRGEN bit 1 */

#define LPTIM_CFG_TIMOUTEN  ((uint32_t)0x00080000U) /* Timout enable */
#define LPTIM_CFG_WAVE      ((uint32_t)0x00100000U) /* Waveform shape */
#define LPTIM_CFG_WAVEPOL   ((uint32_t)0x00200000U) /* Waveform shape polarity */
#define LPTIM_CFG_RELOAD    ((uint32_t)0x00400000U) /* Reg update mode */
#define LPTIM_CFG_CNTMEN    ((uint32_t)0x00800000U) /* Counter mode enable */
#define LPTIM_CFG_ENC       ((uint32_t)0x01000000U) /* Encoder mode enable */
#define LPTIM_CFG_NENC      ((uint32_t)0x02000000U) /* NONEncoder mode enable */

/** Bit definition for LPTIM_CTRL register **/
#define LPTIM_CTRL_LPTIMEN ((uint32_t)0x00000001U) /* LPTIMer enable */
#define LPTIM_CTRL_SNGMST  ((uint32_t)0x00000002U) /* Timer start in single mode */
#define LPTIM_CTRL_TSTCM   ((uint32_t)0x00000004U) /* Timer start in continuous mode */

/** Bit definition for LPTIM_CMP register **/
#define LPTIM_CMP_CMPVAL ((uint16_t)0xFFFFU) /* Compare register */

/** Bit definition for LPTIM_ARR register **/
#define LPTIM_ARR_ARRVAL ((uint16_t)0xFFFFU) /* Auto reload register */

/** Bit definition for LPTIM_CNT register **/
#define LPTIM_CNT_CNTVAL ((uint16_t)0xFFFFU) /* Counter register */

/** Bit definition for LPTIM_OPT register **/
#define LPTIM_OPT_OPT1   ((uint32_t)0x00000007U) /* OPT1[2:0]] bits (LPTIM input1 connection option bits) */
#define LPTIM_OPT_OPT1_0 ((uint32_t)0x00000001U) /* OPT1 bit 0 */
#define LPTIM_OPT_OPT1_1 ((uint32_t)0x00000002U) /* OPT1 bit 1 */
#define LPTIM_OPT_OPT1_2 ((uint32_t)0x00000004U) /* OPT1 bit 2 */
#define LPTIM_OPT_OPT2   ((uint32_t)0x00000038U) /* OPT2[2:0]] bits (LPTIM input2 connection option bits) */
#define LPTIM_OPT_OPT2_0 ((uint32_t)0x00000008U) /* OPT2 bit 0 */
#define LPTIM_OPT_OPT2_1 ((uint32_t)0x00000010U) /* OPT2 bit 1 */
#define LPTIM_OPT_OPT2_2 ((uint32_t)0x00000020U) /* OPT2 bit 2 */


/*** Inter-integrated Circuit Interface ***/

/** Bit definition for I2C_CTRL1 register **/
#define I2C_CTRL1_EN               ((uint32_t)0x00000001U) /* Peripheral Enable */
#define I2C_CTRL1_SMBMODE          ((uint32_t)0x00000002U) /* SMBus Mode */
#define I2C_CTRL1_SMBTYPE          ((uint32_t)0x00000004U) /* SMBus Type */
#define I2C_CTRL1_ARPEN            ((uint32_t)0x00000008U) /* ARP Enable */
#define I2C_CTRL1_PECEN            ((uint32_t)0x00000010U) /* PEC Enable */
#define I2C_CTRL1_GCEN             ((uint32_t)0x00000020U) /* General Call Enable */
#define I2C_CTRL1_NOEXTEND         ((uint32_t)0x00000040U) /* Clock Stretching Disable (Slave mode) */
#define I2C_CTRL1_STARTGEN         ((uint32_t)0x00000080U) /* Start Generation */
#define I2C_CTRL1_STOPGEN          ((uint32_t)0x00000100U) /* Stop Generation */
#define I2C_CTRL1_ACKEN            ((uint32_t)0x00000200U) /* Acknowledge Enable */
#define I2C_CTRL1_ACKPOS           ((uint32_t)0x00000400U) /* Acknowledge/PEC Position (for data reception) */
#define I2C_CTRL1_PEC              ((uint32_t)0x00000800U) /* Packet Error Checking */
#define I2C_CTRL1_ALERT            ((uint32_t)0x00001000U) /* SMBus Alert */
#define I2C_CTRL1_SWRST            ((uint32_t)0x00002000U) /* Software Reset */
#define I2C_CTRL1_MTHALL           ((uint32_t)0x00004000U) /* Full address match */
#define I2C_CTRL1_NMENA            ((uint32_t)0x00008000U) /* Monitor enable */
#define I2C_CTRL1_FIFOEN           ((uint32_t)0x00010000U) /* FIFO enable */
#define I2C_CTRL1_FIFOCLR          ((uint32_t)0x00020000U) /* FIFO clear */
#define I2C_CTRL1_THRFIFOF         ((uint32_t)0x00700000U) /* FIFO full threshold */
#define I2C_CTRL1_THRFIFOF_0       ((uint32_t)0x00100000U) /* Bit 0 */
#define I2C_CTRL1_THRFIFOF_1       ((uint32_t)0x00200000U) /* Bit 1 */
#define I2C_CTRL1_THRFIFOF_2       ((uint32_t)0x00400000U) /* Bit 2 */
#define I2C_CTRL1_THRFIFOE         ((uint32_t)0x07000000U) /* FIFO empty threshold */
#define I2C_CTRL1_THRFIFOE_0       ((uint32_t)0x01000000U) /* Bit 0 */
#define I2C_CTRL1_THRFIFOE_1       ((uint32_t)0x02000000U) /* Bit 1 */
#define I2C_CTRL1_THRFIFOE_2       ((uint32_t)0x04000000U) /* Bit 2 */
#define I2C_CTRL1_HTC              ((uint32_t)0x18000000U) /* High timeout choose */
#define I2C_CTRL1_HTC_0            ((uint32_t)0x08000000U) /* Bit 0 */
#define I2C_CTRL1_HTC_1            ((uint32_t)0x10000000U) /* Bit 1 */
#define I2C_CTRL1_LTC              ((uint32_t)0x60000000U) /* Low timeout choose */
#define I2C_CTRL1_LTC_0            ((uint32_t)0x20000000U) /* Bit 0 */
#define I2C_CTRL1_LTC_1            ((uint32_t)0x40000000U) /* Bit 1 */

/** Bit definition for I2C_CTRL2 register **/
#define I2C_CTRL2_CLKFREQ               ((uint32_t)0x000000FFU) /* FREQ[7:0] bits (Peripheral Clock Frequency) */
#define I2C_CTRL2_CLKFREQ_0             ((uint32_t)0x00000001U) /* Bit 0 */
#define I2C_CTRL2_CLKFREQ_1             ((uint32_t)0x00000002U) /* Bit 1 */
#define I2C_CTRL2_CLKFREQ_2             ((uint32_t)0x00000004U) /* Bit 2 */
#define I2C_CTRL2_CLKFREQ_3             ((uint32_t)0x00000008U) /* Bit 3 */
#define I2C_CTRL2_CLKFREQ_4             ((uint32_t)0x00000010U) /* Bit 4 */
#define I2C_CTRL2_CLKFREQ_5             ((uint32_t)0x00000020U) /* Bit 5 */
#define I2C_CTRL2_CLKFREQ_6             ((uint32_t)0x00000040U) /* Bit 6 */
#define I2C_CTRL2_CLKFREQ_7             ((uint32_t)0x00000080U) /* Bit 7 */

#define I2C_CTRL2_DMALAST               ((uint32_t)0x00000100U) /* DMA Last Transfer */
#define I2C_CTRL2_BUFINTEN              ((uint32_t)0x00001000U) /* Buffer Interrupt Enable */
#define I2C_CTRL2_EVTINTEN              ((uint32_t)0x00002000U) /* Event Interrupt Enable */
#define I2C_CTRL2_ERRINTEN              ((uint32_t)0x00004000U) /* Error Interrupt Enable */
#define I2C_CTRL2_DMAEN                 ((uint32_t)0x00008000U) /* DMA Requests Enable */
#define I2C_CTRL2_FIFOFINTEN            ((uint32_t)0x00010000U) /* FIFO full interrupt enable */
#define I2C_CTRL2_FIFOEINTEN            ((uint32_t)0x00020000U) /* FIFO empty interrupt enable */
#define I2C_CTRL2_FIFOHFINTEN           ((uint32_t)0x00040000U) /* FIFOHF interrupt enable when fifo enable */
#define I2C_CTRL2_FIFOHEINTEN           ((uint32_t)0x00080000U) /* FIFOHE interrupt enable when fifo enable */
#define I2C_CTRL2_FIFORDEIEN            ((uint32_t)0x00100000U) /* FIFORDEIEN interrupt enable when fifo enable */
#define I2C_CTRL2_FIFOWREIEN            ((uint32_t)0x00200000U) /* FIFOWREIEN interrupt enable when fifo enable */
#define I2C_CTRL2_DMAETOEIEN            ((uint32_t)0x00400000U) /* DMAETOEIEN interrupt enable when fifo enable */
#define I2C_CTRL2_DMAFIFOEN             ((uint32_t)0x00800000U) /* DMAFIFOEN enable */
#define I2C_CTRL2_FIFONEINTEN           ((uint32_t)0x01000000U) /* FIFO not empty interrupt enable */
#define I2C_CTRL2_FIFONFINTEN           ((uint32_t)0x02000000U) /* FIFO not full interrupt enable */
#define I2C_CTRL2_SDATOLIEN             ((uint32_t)0x04000000U) /* SDA low timeout interrupt enable */
#define I2C_CTRL2_SCLTOHIEN             ((uint32_t)0x08000000U) /* SCL high timeout interrupt enable */
#define I2C_CTRL2_SCLTOLIEN             ((uint32_t)0x10000000U) /* SCL low timeout interrupt enable */
#define I2C_CTRL2_TOHEN                 ((uint32_t)0x20000000U) /* HIGH_TIMEOUT enable */
#define I2C_CTRL2_TOLEN                 ((uint32_t)0x40000000U) /* LOW_TIMEOUT enable */

/** Bit definition for I2C_OADDR1 register **/
#define I2C_OADDR1_ADDR1_7 ((uint32_t)0x000000FEU) /* Interface Address */
#define I2C_OADDR1_ADDR8_9 ((uint32_t)0x00000300U) /* Interface Address */

#define I2C_OADDR1_ADDR0   ((uint32_t)0x00000001U) /* Bit 0 */
#define I2C_OADDR1_ADDR1   ((uint32_t)0x00000002U) /* Bit 1 */
#define I2C_OADDR1_ADDR2   ((uint32_t)0x00000004U) /* Bit 2 */
#define I2C_OADDR1_ADDR3   ((uint32_t)0x00000008U) /* Bit 3 */
#define I2C_OADDR1_ADDR4   ((uint32_t)0x00000010U) /* Bit 4 */
#define I2C_OADDR1_ADDR5   ((uint32_t)0x00000020U) /* Bit 5 */
#define I2C_OADDR1_ADDR6   ((uint32_t)0x00000040U) /* Bit 6 */
#define I2C_OADDR1_ADDR7   ((uint32_t)0x00000080U) /* Bit 7 */
#define I2C_OADDR1_ADDR8   ((uint32_t)0x00000100U) /* Bit 8 */
#define I2C_OADDR1_ADDR9   ((uint32_t)0x00000200U) /* Bit 9 */

#define I2C_OADDR1_ADDRMODE             ((uint32_t)0x00008000U) /* Addressing Mode (Slave mode) */

/** Bit definition for I2C_OADDR2 register **/
#define I2C_OADDR2_DUALEN                 ((uint8_t)0x01U) /* Dual addressing mode enable */
#define I2C_OADDR2_ADDR2                  ((uint8_t)0xFEU) /* Interface address */

/** Bit definition for I2C_DAT register **/
#define I2C_DAT_DATA                             ((uint8_t)0xFFU) /* 8-bit Data Register */

/** Bit definition for I2C_STS1 register **/
#define I2C_STS1_STARTBF                  ((uint32_t)0x00000001U) /* Start Bit (Master mode) */
#define I2C_STS1_ADDRF                    ((uint32_t)0x00000002U) /* Address sent (master mode)/matched (slave mode) */
#define I2C_STS1_BSF                      ((uint32_t)0x00000004U) /* Byte Transfer Finished */
#define I2C_STS1_STOPF                    ((uint32_t)0x00000008U) /* Stop detection (Slave mode) */
#define I2C_STS1_RXDATNE                  ((uint32_t)0x00000010U) /* Data Register not Empty (receivers) */
#define I2C_STS1_TXDATE                   ((uint32_t)0x00000020U) /* Data Register Empty (transmitters) */
#define I2C_STS1_ADDR10F                  ((uint32_t)0x00000040U) /* 10-bit header sent (Master mode) */
#define I2C_STS1_ACKFAIL                  ((uint32_t)0x00000100U) /* Acknowledge Failure */
#define I2C_STS1_ARLOST                   ((uint32_t)0x00000200U) /* Arbitration Lost (master mode) */
#define I2C_STS1_BUSERR                   ((uint32_t)0x00000400U) /* Bus Error */
#define I2C_STS1_OVERRUN                  ((uint32_t)0x00000800U) /* Overrun/Underrun */
#define I2C_STS1_PECERR                   ((uint32_t)0x00001000U) /* PEC Error in reception */
#define I2C_STS1_SMBALERT                 ((uint32_t)0x00004000U) /* SMBus Alert */
#define I2C_STS1_FIFOF                    ((uint32_t)0x00010000U) /* FIFO full */
#define I2C_STS1_FIFOE                    ((uint32_t)0x00020000U) /* FIFO empty */
#define I2C_STS1_FIFOHF                   ((uint32_t)0x00040000U) /* FIFO half full */
#define I2C_STS1_FIFOHE                   ((uint32_t)0x00080000U) /* FIFO half empty */
#define I2C_STS1_FIFORDERR                ((uint32_t)0x00100000U) /* Read data when FIFO is empty */
#define I2C_STS1_FIFOWRERR                ((uint32_t)0x00200000U) /* Write data when FIFO is full */
#define I2C_STS1_DMAETOERR                ((uint32_t)0x00400000U) /* Prove that the DMA transmission is complete but no ETO signal is given */
#define I2C_STS1_SDALTO                   ((uint32_t)0x00800000U) /* SDA timeout low error */
#define I2C_STS1_SCLHTO                   ((uint32_t)0x01000000U) /* SCL timeout high error */
#define I2C_STS1_SCLLTO                   ((uint32_t)0x02000000U) /* SCL timeout low error */

/** Bit definition for I2C_STS2 register **/
#define I2C_STS2_BUSY      ((uint32_t)0x0001U) /* Bus Busy */
#define I2C_STS2_MSMODE    ((uint32_t)0x0002U) /* Master/Slave */
#define I2C_STS2_TRF       ((uint32_t)0x0004U) /* Transmitter/Receiver */
#define I2C_STS2_GCALLADDR ((uint32_t)0x0010U) /* General Call Address (Slave mode) */
#define I2C_STS2_DUALFLAG  ((uint32_t)0x0020U) /* Dual Flag (Slave mode) */
#define I2C_STS2_SMBDADDR  ((uint32_t)0x0040U) /* SMBus Device Default Address (Slave mode) */
#define I2C_STS2_SMBHADDR  ((uint32_t)0x0080U) /* SMBus Host Header (Slave mode) */

#define I2C_STS2_PECVAL    ((uint32_t)0xFF00U) /* Packet Error Checking Register */

/** Bit definition for I2C_CLKCTRL register **/
#define I2C_CLKCTRL_CLKCTRL ((uint32_t)0x0FFFU) /* Clock Control Register in Fast/Standard mode (Master mode) */
#define I2C_CLKCTRL_FSMODE  ((uint32_t)0x4000U) /* I2C Master Mode Selection */
#define I2C_CLKCTRL_DUTY    ((uint32_t)0x8000U) /* Fast Mode Duty Cycle */

/** Bit definition for I2C_TRISE register **/
#define I2C_TMRISE_TMRISE   ((uint8_t)0xFFU) /* Maximum Rise Time in Fast/Standard mode (Master mode) */

/** Bit definition for I2C_BYTENUM register **/
#define I2C_BYTENUM_BYTENUM         ((uint32_t)0x3FFFU) /* Master receive byte num*/
#define I2C_BYTENUM_STASTOLB        ((uint32_t)0x4000U) /* Enter the process configuration after the master receives */
#define I2C_BYTENUM_BTNUMEN         ((uint32_t)0x8000U) /* Fast Mode Duty Cycle */

/** Bit definition for I2C_GFLTRCTRL register **/
#define I2C_GFLTRCTRL_SDADFW   ((uint32_t)0x000FU) /* SDA digital filter width selection */
#define I2C_GFLTRCTRL_SDADFW_0 ((uint32_t)0x0001U) /* Bit 0 */
#define I2C_GFLTRCTRL_SDADFW_1 ((uint32_t)0x0002U) /* Bit 1 */
#define I2C_GFLTRCTRL_SDADFW_2 ((uint32_t)0x0004U) /* Bit 2 */
#define I2C_GFLTRCTRL_SDADFW_3 ((uint32_t)0x0008U) /* Bit 3 */

#define I2C_GFLTRCTRL_SCLDFW   ((uint32_t)0x00F0U) /* SCL digital filter width selection */
#define I2C_GFLTRCTRL_SCLDFW_0 ((uint32_t)0x0010U) /* Bit 0 */
#define I2C_GFLTRCTRL_SCLDFW_1 ((uint32_t)0x0020U) /* Bit 1 */
#define I2C_GFLTRCTRL_SCLDFW_2 ((uint32_t)0x0040U) /* Bit 2 */
#define I2C_GFLTRCTRL_SCLDFW_3 ((uint32_t)0x0080U) /* Bit 3 */

#define I2C_GFLTRCTRL_SDAAFW   ((uint32_t)0x0300U) /* SDA analog filter width selection */
#define I2C_GFLTRCTRL_SDAAFW_0 ((uint32_t)0x0100U) /* Bit 0 */
#define I2C_GFLTRCTRL_SDAAFW_1 ((uint32_t)0x0200U) /* Bit 1 */

#define I2C_GFLTRCTRL_SDAAFENN ((uint32_t)0x8000U) /* SDA analog filter enable */

#define I2C_GFLTRCTRL_SCLAFW   ((uint32_t)0x3000U) /* SCL analog filter width selection */
#define I2C_GFLTRCTRL_SCLAFW_0 ((uint32_t)0x1000U) /* Bit 0 */
#define I2C_GFLTRCTRL_SCLAFW_1 ((uint32_t)0x2000U) /* Bit 1 */

#define I2C_GFLTRCTRL_SCLAFENN ((uint32_t)0x8000U) /* SCL analog filter enable */

/** Bit definition for I2C_FIFODAT register **/
#define I2C_FIFODAT_FIFODAT    ((uint8_t)0xFFU) /* FIFIO data */

/** Universal Synchronous Asynchronous Receiver Transmitter **/

/** Bit definition for USART_CTRL1 register **/
#define USART_CTRL1_UEN         ((uint32_t)0x00000001U) /* USART Enable */
#define USART_CTRL1_RXEN        ((uint32_t)0x00000002U) /* Receiver Enable */
#define USART_CTRL1_TXEN        ((uint32_t)0x00000004U) /* Transmitter Enable */
#define USART_CTRL1_PSEL        ((uint32_t)0x00000008U) /* Parity Selection */
#define USART_CTRL1_PCEN        ((uint32_t)0x00000010U) /* Parity Control Enable */
#define USART_CTRL1_WL          ((uint32_t)0x00000020U) /* Word length */
#define USART_CTRL1_RCVWU       ((uint32_t)0x00000040U) /* Receiver wakeup */
#define USART_CTRL1_WUM         ((uint32_t)0x00000080U) /* Wakeup method */
#define USART_CTRL1_IDLEIEN     ((uint32_t)0x00000100U) /* IDLE Interrupt Enable */
#define USART_CTRL1_RXDNEIEN    ((uint32_t)0x00000200U) /* RXNE Interrupt Enable */
#define USART_CTRL1_TXDEIEN     ((uint32_t)0x00000400U) /* PE Interrupt Enable */
#define USART_CTRL1_TXCIEN      ((uint32_t)0x00000800U) /* Transmission Complete Interrupt Enable */
#define USART_CTRL1_PEIEN       ((uint32_t)0x00001000U) /* PE Interrupt Enable */
#define USART_CTRL1_SDBRK       ((uint32_t)0x00002000U) /* Send Break */
#define USART_CTRL1_DEM         ((uint32_t)0x00004000U) /* Driver enable mode */
#define USART_CTRL1_DEP         ((uint32_t)0x00008000U) /* Driver enable polarity selection */
#define USART_CTRL1_DEDT_MASK   ((uint32_t)0x001F0000U) /* Driver Enable deassertion time mask */
#define USART_CTRL1_DEAT_MASK   ((uint32_t)0x03E00000U) /* Driver Enable assertion time mask */
#define USART_CTRL1_OSPM        ((uint32_t)0x04000000U) /* Oversampling mode */
#define USART_CTRL1_SWAP        ((uint32_t)0x08000000U) /* Swap TX/RX pins */
#define USART_CTRL1_IFCEN       ((uint32_t)0x10000000U) /* Idle frame controllable enable */

/** Bit definition for USART_CTRL2 register **/
#define USART_CTRL2_ADDR        ((uint32_t)0x0000000FU) /* Address of the USART node */
#define USART_CTRL2_STPB        ((uint32_t)0x00000060U) /* STOP[1:0] bits (STOP bits) */
#define USART_CTRL2_STPB_0      ((uint32_t)0x00000020U) /* Bit 0 */
#define USART_CTRL2_STPB_1      ((uint32_t)0x00000040U) /* Bit 1 */
#define USART_CTRL2_CLKEN       ((uint32_t)0x00000100U) /* Clock Enable */
#define USART_CTRL2_CLKPOL      ((uint32_t)0x00000200U) /* Clock Polarity */
#define USART_CTRL2_CLKPHA      ((uint32_t)0x00000400U) /* Clock Phase */
#define USART_CTRL2_LBCLK       ((uint32_t)0x00000800U) /* Last Bit Clock pulse */
#define USART_CTRL2_LINMEN      ((uint32_t)0x00001000U) /* LIN mode enable */
#define USART_CTRL2_LINBDIEN    ((uint32_t)0x00002000U) /* LIN Break Detection Interrupt Enable */
#define USART_CTRL2_LINBDL      ((uint32_t)0x00004000U) /* LIN Break Detection Length */
#define USART_CTRL2_RTOEN       ((uint32_t)0x00008000U) /* Receiver timeout enable */
#define USART_CTRL2_RTOCF       ((uint32_t)0x00010000U) /* Receiver timeout clear flag */
#define USART_CTRL2_RTOITE      ((uint32_t)0x00020000U) /* Receiver timeout interrupt enable */
#define USART_CTRL2_PEFLOSE     ((uint32_t)0x00040000U) /* PEF Data Discard Enable Bit */
#define USART_CTRL2_NEFLOSE     ((uint32_t)0x00080000U) /* NEF Data Discard Enable Bit */
#define USART_CTRL2_FEFLOSE     ((uint32_t)0x00100000U) /* FEF Data Discard Enable Bit */

/** Bit definition for USART_CTRL3 register **/
#define USART_CTRL3_CTSEN   ((uint32_t)0x00000001U) /* CTS Enable */
#define USART_CTRL3_CTSIEN  ((uint32_t)0x00000002U) /* CTS Interrupt Enable */
#define USART_CTRL3_RTSEN   ((uint32_t)0x00000004U) /* RTS Enable */
#define USART_CTRL3_HDMEN   ((uint32_t)0x00000008U) /* Half-Duplex Selection */
#define USART_CTRL3_DMATXEN ((uint32_t)0x00000010U) /* DMA Enable Transmitter */
#define USART_CTRL3_DMARXEN ((uint32_t)0x00000020U) /* DMA Enable Receiver */
#define USART_CTRL3_ERRIEN  ((uint32_t)0x00000040U) /* Error Interrupt Enable */
#define USART_CTRL3_IRDAMEN ((uint32_t)0x00000080U) /* IrDA mode Enable */
#define USART_CTRL3_IRDALP  ((uint32_t)0x00000100U) /* IrDA Low-Power */
#define USART_CTRL3_SCMEN   ((uint32_t)0x00000200U) /* Smartcard mode enable */
#define USART_CTRL3_SCNACK  ((uint32_t)0x00000400U) /* Smartcard NACK enable */

/** Bit definition for USART_STS register **/
#define USART_STS_TXFF      ((uint32_t)0x00000001U) /* Send FIFO full */
#define USART_STS_RXFF      ((uint32_t)0x00000002U) /* Receive FIFO full */
#define USART_STS_TXFE      ((uint32_t)0x00000004U) /* Send FIFO empty*/
#define USART_STS_RXFE      ((uint32_t)0x00000008U) /* Receive FIFO empty */
#define USART_STS_RXFT      ((uint32_t)0x00000010U) /* RX FIFO threshold */
#define USART_STS_TXFT      ((uint32_t)0x00000020U) /* TX FIFO threshold*/
#define USART_STS_IDLEF     ((uint32_t)0x00000040U) /* IDLE line detected */
#define USART_STS_TXDE      ((uint32_t)0x00000080U) /* Transmit Data Register Empty */
#define USART_STS_TXC       ((uint32_t)0x00000100U) /* Transmission Complete */
#define USART_STS_RXDNE     ((uint32_t)0x00000200U) /* Read Data Register Not Empty */
#define USART_STS_CTSF      ((uint32_t)0x00000400U) /* CTS Flag */
#define USART_STS_LINBDF    ((uint32_t)0x00000800U) /* LIN Break Detection Flag */
#define USART_STS_PEF       ((uint32_t)0x00001000U) /* Parity Error */
#define USART_STS_OREF      ((uint32_t)0x00002000U) /* OverRun Error */
#define USART_STS_NEF       ((uint32_t)0x00004000U) /* Noise Error Flag */
#define USART_STS_FEF       ((uint32_t)0x00008000U) /* Framing Error */
#define USART_STS_RTOF      ((uint32_t)0x00010000U) /* recevier timeout */
#define USART_STS_PELOSEF   ((uint32_t)0x00020000U) /* Received Data PE Error Discard Flag */
#define USART_STS_NELOSEF   ((uint32_t)0x00040000U) /* Received Data NE Error Discard Flag */
#define USART_STS_FELOSEF   ((uint32_t)0x00080000U) /* Received Data FE Error Discard Flag */

/** Bit definition for USART_DAT register **/
#define USART_DAT_DATV      ((uint32_t)0x000001FFU) /* Data value */

/** Bit definition for USART_BRCF register **/
#define USART_BRCF_DIV_Decimal ((uint32_t)0x000FU) /* Fraction of USARTDIV */
#define USART_BRCF_DIV_Integer ((uint32_t)0xFFF0U) /* Mantissa of USARTDIV */

/** Bit definition for USART_GTP register **/
#define USART_GTP_PSCV   ((uint32_t)0x00FFU) /* PSC[7:0] bits (Prescaler value) */
#define USART_GTP_PSCV_0 ((uint32_t)0x0001U) /* Bit 0 */
#define USART_GTP_PSCV_1 ((uint32_t)0x0002U) /* Bit 1 */
#define USART_GTP_PSCV_2 ((uint32_t)0x0004U) /* Bit 2 */
#define USART_GTP_PSCV_3 ((uint32_t)0x0008U) /* Bit 3 */
#define USART_GTP_PSCV_4 ((uint32_t)0x0010U) /* Bit 4 */
#define USART_GTP_PSCV_5 ((uint32_t)0x0020U) /* Bit 5 */
#define USART_GTP_PSCV_6 ((uint32_t)0x0040U) /* Bit 6 */
#define USART_GTP_PSCV_7 ((uint32_t)0x0080U) /* Bit 7 */

#define USART_GTP_GTV ((uint32_t)0xFF00U) /* Guard time value */

/** Bit definition for USART_FIFO register **/
#define USART_FIFO_EN               ((uint32_t)0x00000001U) /* FIFO model enable */
#define USART_FIFO_CLR              ((uint32_t)0x00000002U) /* FIFO clear */
#define USART_FIFO_TXFTCFG_MASK     ((uint32_t)0x0000001CU) /* TXFIFO threshold configuration */
#define USART_FIFO_RXFTCFG_MASK     ((uint32_t)0x000000E0U) /* RXFIFO threshold configuration */
#define USART_FIFO_TXFFITE          ((uint32_t)0x00000100U) /* TXFIFO full interrupt enable */
#define USART_FIFO_RXFFITE          ((uint32_t)0x00000200U) /* RXFIFO full interrupt enable */
#define USART_FIFO_TXFEITE          ((uint32_t)0x00000400U) /* TXFIFO empty interrupt enable */
#define USART_FIFO_RXFEITE          ((uint32_t)0x00000800U) /* RXFIFO empty interrupt enable */
#define USART_FIFO_RXFTITE          ((uint32_t)0x00001000U) /* RXFIFO threshold interrupt enable */
#define USART_FIFO_TXFTITE          ((uint32_t)0x00002000U) /* TXFIFO threshold interrupt enable */
#define USART_FIFO_RXCNT_MASK       ((uint32_t)0x0003C000U) /* number of  RXFIFO valid data mask */
#define USART_FIFO_TXCNT_MASK       ((uint32_t)0x003C0000U) /* number of  TXFIFO valid data mask */

/** Bit definition for USART_IFW register **/
#define USART_IFW_WIDTH_MASK        ((uint32_t)0x0FFFFFFFU) /* Receiver timeout value */


/*** Debug MCU  ***/

/** Bit definition for DBG_ID register **/
#define DBG_ID_DEV    ((uint32_t)0x00000FFFU) /* Device Identifier */

#define DBG_ID_REV    ((uint32_t)0xFFFF0000U) /* REV_ID[15:0] bits (Revision Identifier) */
#define DBG_ID_REV_0  ((uint32_t)0x00010000U) /* Bit 0 */
#define DBG_ID_REV_1  ((uint32_t)0x00020000U) /* Bit 1 */
#define DBG_ID_REV_2  ((uint32_t)0x00040000U) /* Bit 2 */
#define DBG_ID_REV_3  ((uint32_t)0x00080000U) /* Bit 3 */
#define DBG_ID_REV_4  ((uint32_t)0x00100000U) /* Bit 4 */
#define DBG_ID_REV_5  ((uint32_t)0x00200000U) /* Bit 5 */
#define DBG_ID_REV_6  ((uint32_t)0x00400000U) /* Bit 6 */
#define DBG_ID_REV_7  ((uint32_t)0x00800000U) /* Bit 7 */
#define DBG_ID_REV_8  ((uint32_t)0x01000000U) /* Bit 8 */
#define DBG_ID_REV_9  ((uint32_t)0x02000000U) /* Bit 9 */
#define DBG_ID_REV_10 ((uint32_t)0x04000000U) /* Bit 10 */
#define DBG_ID_REV_11 ((uint32_t)0x08000000U) /* Bit 11 */
#define DBG_ID_REV_12 ((uint32_t)0x10000000U) /* Bit 12 */
#define DBG_ID_REV_13 ((uint32_t)0x20000000U) /* Bit 13 */
#define DBG_ID_REV_14 ((uint32_t)0x40000000U) /* Bit 14 */
#define DBG_ID_REV_15 ((uint32_t)0x80000000U) /* Bit 15 */

/** Bit definition for DBG_CTRL register **/
#define DBG_CTRL_SLEEP        ((uint32_t)0x00000001U) /* Debug Sleep Mode */
#define DBG_CTRL_STOP         ((uint32_t)0x00000002U) /* Debug Stop Mode */
#define DBG_CTRL_STDBY        ((uint32_t)0x00000004U) /* Debug Standby mode */

#define DBG_CTRL_IWDG_STOP    ((uint32_t)0x00000100U) /* Debug Independent Watchdog stopped when Core is halted */
#define DBG_CTRL_WWDG_STOP    ((uint32_t)0x00000200U) /* Debug Window Watchdog stopped when Core is halted */
#define DBG_CTRL_I2C1SMBUS_TO ((uint32_t)0x00000400U) /* I2C1 SMBUS timeout mode stopped when Core is halted */
#define DBG_CTRL_I2C2SMBUS_TO ((uint32_t)0x00000800U) /* I2C2 SMBUS timeout mode stopped when Core is halted */
#define DBG_CTRL_I2C3SMBUS_TO ((uint32_t)0x00001000U) /* I2C3 SMBUS timeout mode stopped when Core is halted */
#define DBG_CTRL_I2C4SMBUS_TO ((uint32_t)0x00002000U) /* I2C4 SMBUS timeout mode stopped when Core is halted */
#define DBG_CTRL_ATIM1_STOP   ((uint32_t)0x00004000U) /* ATIM1 counter stopped when core is halted */
#define DBG_CTRL_ATIM2_STOP   ((uint32_t)0x00008000U) /* ATIM2 counter stopped when core is halted */
#define DBG_CTRL_ATIM3_STOP   ((uint32_t)0x00010000U) /* ATIM3 counter stopped when core is halted */
#define DBG_CTRL_BTIM1_STOP   ((uint32_t)0x00020000U) /* BTIM1 counter stopped when core is halted */
#define DBG_CTRL_BTIM2_STOP   ((uint32_t)0x00040000U) /* BTIM2 counter stopped when core is halted */
#define DBG_CTRL_GTIM1_STOP   ((uint32_t)0x00080000U) /* GTIM1 counter stopped when core is halted */
#define DBG_CTRL_GTIM2_STOP   ((uint32_t)0x00100000U) /* GTIM2 counter stopped when core is halted */
#define DBG_CTRL_GTIM3_STOP   ((uint32_t)0x00200000U) /* GTIM3 counter stopped when core is halted */
#define DBG_CTRL_GTIM4_STOP   ((uint32_t)0x00400000U) /* GTIM4 counter stopped when core is halted */
#define DBG_CTRL_GTIM5_STOP   ((uint32_t)0x00800000U) /* GTIM5 counter stopped when core is halted */
#define DBG_CTRL_GTIM6_STOP   ((uint32_t)0x01000000U) /* GTIM6 counter stopped when core is halted */
#define DBG_CTRL_GTIM7_STOP   ((uint32_t)0x02000000U) /* GTIM7 counter stopped when core is halted */
#define DBG_CTRL_GTIM8_STOP   ((uint32_t)0x04000000U) /* GTIM8 counter stopped when core is halted */
#define DBG_CTRL_GTIM9_STOP   ((uint32_t)0x08000000U) /* GTIM9 counter stopped when core is halted */
#define DBG_CTRL_GTIM10_STOP  ((uint32_t)0x10000000U) /* GTIM10 counter stopped when core is halted */
#define DBG_CTRL_SHRTIM1_STOP ((uint32_t)0x10000000U) /* SHRTIM1 counter stopped when core is halted */


/*** FLASH and Option Bytes Registers ***/

/** Bit definition for FLASH_AC register **/
#define FLASH_AC_LATENCY   ((uint32_t)0x00000007U) /* LATENCY[2:0] bits (Latency) */
#define FLASH_AC_LATENCY_0 ((uint32_t)0x00000000U) /* Bit 0 = 0 */
#define FLASH_AC_LATENCY_1 ((uint32_t)0x00000001U) /* Bit 0 = 1 */
#define FLASH_AC_LATENCY_2 ((uint32_t)0x00000002U) /* Bit 0 = 0; Bit 1 = 1 */
#define FLASH_AC_LATENCY_3 ((uint32_t)0x00000003U) /* Bit 0 = 1; Bit 1 = 1 */
#define FLASH_AC_LATENCY_4 ((uint32_t)0x00000004U) /* Bit 0 = 0; Bit 1 = 0; Bit 2 = 1 */
#define FLASH_AC_LATENCY_5 ((uint32_t)0x00000005U) /* Bit 0 = 1; Bit 1 = 0; Bit 2 = 1 */

#define FLASH_AC_ICAHEN    ((uint32_t)0x00000010U) /* Icache Enable */
#define FLASH_AC_ICAHRST   ((uint32_t)0x00000020U) /* Icache Reset */
#define FLASH_AC_PRFTBFSTS ((uint32_t)0x00000040U) /* Prefetch Buffer Status */
#define FLASH_AC_PRFTBFEN  ((uint32_t)0x00000080U) /* Prefetch Buffer Enable */

/** Bit definition for FLASH_CTRL register **/
#define FLASH_CTRL_LOCK      ((uint32_t)0x00000001U) /* Lock */
#define FLASH_CTRL_PG        ((uint32_t)0x00000002U) /* Programming */
#define FLASH_CTRL_PER       ((uint32_t)0x00000004U) /* Page Erase */
#define FLASH_CTRL_MER       ((uint32_t)0x00000008U) /* Mass Erase */
#define FLASH_CTRL_START     ((uint32_t)0x00000010U) /* Start */
#define FLASH_CTRL_OPTPG     ((uint32_t)0x00000020U) /* Option Byte Programming */
#define FLASH_CTRL_OPTER     ((uint32_t)0x00000040U) /* Option Byte Erase */
#define FLASH_CTRL_OPTWE     ((uint32_t)0x00000080U) /* Option Bytes Write Enable */
#define FLASH_CTRL_EOPITE    ((uint32_t)0x00000100U) /* End of operation Interrupt Enable */
#define FLASH_CTRL_ERRITE    ((uint32_t)0x00000200U) /* PG/WRP Error Interrupt Enable */
#define FLASH_CTRL_FERRITE   ((uint32_t)0x00000400U) /* EV/PV Error Interrupt Enable */
#define FLASH_CTRL_EC1ERRITE ((uint32_t)0x00000800U) /* 1bit ECC Error Interrupt Enable */
#define FLASH_CTRL_JSERRITE  ((uint32_t)0x00001000U) /* JTAG SEAL Error Interrupt Enable */
#define FLASH_CTRL_EC2ERRITE ((uint32_t)0x00002000U) /* 2bit ECC Error Interrupt Enable */
#define FLASH_CTRL_DECCERRITE  ((uint32_t)0x00004000U) /* XSPI/FEMC configure Error Interrupt Enable */
#define FLASH_CTRL_RPADDERRITE ((uint32_t)0x00008000U) /* ROW programmer address Error Interrupt Enable */

/**  Bit definition for FLASH_STS register  **/
#define FLASH_STS_EOP      ((uint32_t)0x00000001U) /* end of operation */
#define FLASH_STS_BUSY     ((uint32_t)0x00000002U) /* Busy */
#define FLASH_STS_PGERR    ((uint32_t)0x00000004U) /* Programming Error */
#define FLASH_STS_WRPERR   ((uint32_t)0x00000008U) /* Write Protection Error */
#define FLASH_STS_PVERR    ((uint32_t)0x00000010U) /* Programming Verify ERROR after program */
#define FLASH_STS_EVERR    ((uint32_t)0x00000020U) /* Erase Verify ERROR after page erase */
#define FLASH_STS_ECC1ERR  ((uint32_t)0x00000040U) /* 1 bit ECC error */
#define FLASH_STS_RDKEYERR ((uint32_t)0x00000080U) /* read key error */
#define FLASH_STS_RDXKEYERR   ((uint32_t)0x00000100U) /* xKEY match error */
#define FLASH_STS_NRDXKEYEN   ((uint32_t)0x00000200U) /* Not allowed to read RTPD_KEY enable */
#define FLASH_STS_JSERR       ((uint32_t)0x00000400U) /* JTAG/SRAM access JTAG_SEAL error */
#define FLASH_STS_RTPKEYERR   ((uint32_t)0x00000800U) /* read RTPD_KEY error */
#define FLASH_STS_ECC2ERR     ((uint32_t)0x00001000U) /* 2 bit ECC error */
#define FLASH_STS_DECCRDF     ((uint32_t)0x00002000U) /* XSPI/FEMC Decryption Configuration Completion Flag */
#define FLASH_STS_DECCERR     ((uint32_t)0x00004000U) /* XSPI/FEMC Decryption Configuration sequences error */
#define FLASH_STS_FWORDF      ((uint32_t)0x00008000U) /* first word write completion flag */
#define FLASH_STS_RPADDERR    ((uint32_t)0x00010000U) /* row programmmer address error */

/**  Bit definition for FLASH_ADD register  **/
#define FLASH_ADD_FADD ((uint32_t)0xFFFFFFFFU) /* Flash Address */

/**  Bit definition for FLASH_KEY register  **/
#define FLASH_KEY_FKEY ((uint32_t)0xFFFFFFFFU) /* FLASH Key */

/**  Bit definition for FLASH_OPTKEY register  **/
#define FLASH_OPTKEY_OPTKEY ((uint32_t)0xFFFFFFFFU) /* Option Byte Key */

/**  Bit definition for FLASH_OB register  **/
#define FLASH_OB_USER          ((uint32_t)0x000001BCU) /* User Option Bytes */
#define FLASH_OB_RDPRT1        ((uint32_t)0x00000001U) /* Read Protection Level 1 */
#define FLASH_OB_RDPRT2        ((uint32_t)0x00000002U) /* Read Protection Level 2 */
#define FLASH_OB_IWDG_SW       ((uint32_t)0x00000004U) /* IWDG_SW */
#define FLASH_OB_NRST_STDBY    ((uint32_t)0x00000008U) /* nRST_STDBY */
#define FLASH_OB_NRST_STOP     ((uint32_t)0x00000010U) /* nRST_STOP */
#define FLASH_OB_IWDGSTOPFRZ   ((uint32_t)0x00000020U) /* IWDGSTOPFRZ */
#define FLASH_OB_IWDGSTDBYFRZ  ((uint32_t)0x00000080U) /* IWDGSTDBYFRZ */
#define FLASH_OB_IWDGSLEEPFRZ  ((uint32_t)0x00000100U) /* IWDGSLEEPFRZ */
#define FLASH_OB_DATA0_MSK     ((uint32_t)0x000FF000U) /* Data0 Mask */
#define FLASH_OB_DATA1_MSK     ((uint32_t)0x0FF00000U) /* Data1 Mask */
#define FLASH_OB_nBOOT0        ((uint32_t)0x10000000U) /* nBOOT0 */
#define FLASH_OB_nBOOT1        ((uint32_t)0x20000000U) /* nBOOT1 */
#define FLASH_OB_nSWBOOT0      ((uint32_t)0x40000000U) /* nSWBOOT0 */
#define FLASH_OB_OBERR         ((uint32_t)0x80000000U) /* Option Byte Error */

/** Bit definition for FLASH_WRP register **/
#define FLASH_WRP_WRPT                          ((uint32_t)0xFFFFFFFFU) /* Write Protect */
#define FLASH_WRP_WRPT_0                        ((uint32_t)0x00000001U) /* bit 0  */
#define FLASH_WRP_WRPT_1                        ((uint32_t)0x00000002U) /* bit 1  */
#define FLASH_WRP_WRPT_2                        ((uint32_t)0x00000004U) /* bit 2  */
#define FLASH_WRP_WRPT_3                        ((uint32_t)0x00000008U) /* bit 3  */
#define FLASH_WRP_WRPT_4                        ((uint32_t)0x00000010U) /* bit 4  */
#define FLASH_WRP_WRPT_5                        ((uint32_t)0x00000020U) /* bit 5  */
#define FLASH_WRP_WRPT_6                        ((uint32_t)0x00000040U) /* bit 6  */
#define FLASH_WRP_WRPT_7                        ((uint32_t)0x00000080U) /* bit 7  */
#define FLASH_WRP_WRPT_8                        ((uint32_t)0x00000100U) /* bit 8  */
#define FLASH_WRP_WRPT_9                        ((uint32_t)0x00000200U) /* bit 9  */
#define FLASH_WRP_WRPT_10                       ((uint32_t)0x00000400U) /* bit 10 */
#define FLASH_WRP_WRPT_11                       ((uint32_t)0x00000800U) /* bit 11 */
#define FLASH_WRP_WRPT_12                       ((uint32_t)0x00001000U) /* bit 12 */
#define FLASH_WRP_WRPT_13                       ((uint32_t)0x00002000U) /* bit 13 */
#define FLASH_WRP_WRPT_14                       ((uint32_t)0x00004000U) /* bit 14 */
#define FLASH_WRP_WRPT_15                       ((uint32_t)0x00008000U) /* bit 15 */
#define FLASH_WRP_WRPT_16                       ((uint32_t)0x00010000U) /* bit 16 */
#define FLASH_WRP_WRPT_17                       ((uint32_t)0x00020000U) /* bit 17 */
#define FLASH_WRP_WRPT_18                       ((uint32_t)0x00040000U) /* bit 18 */
#define FLASH_WRP_WRPT_19                       ((uint32_t)0x00080000U) /* bit 19 */
#define FLASH_WRP_WRPT_20                       ((uint32_t)0x00100000U) /* bit 20 */
#define FLASH_WRP_WRPT_21                       ((uint32_t)0x00200000U) /* bit 21 */
#define FLASH_WRP_WRPT_22                       ((uint32_t)0x00400000U) /* bit 22 */
#define FLASH_WRP_WRPT_23                       ((uint32_t)0x00800000U) /* bit 23 */
#define FLASH_WRP_WRPT_24                       ((uint32_t)0x01000000U) /* bit 24 */
#define FLASH_WRP_WRPT_25                       ((uint32_t)0x02000000U) /* bit 25 */
#define FLASH_WRP_WRPT_26                       ((uint32_t)0x04000000U) /* bit 26 */
#define FLASH_WRP_WRPT_27                       ((uint32_t)0x08000000U) /* bit 27 */
#define FLASH_WRP_WRPT_28                       ((uint32_t)0x10000000U) /* bit 28 */
#define FLASH_WRP_WRPT_29                       ((uint32_t)0x20000000U) /* bit 29 */
#define FLASH_WRP_WRPT_30                       ((uint32_t)0x40000000U) /* bit 30 */
#define FLASH_WRP_WRPT_31                       ((uint32_t)0x80000000U) /* bit 31 */

/** Bit definition for FLASH_ECC register **/
#define FLASH_WRP_ECCLW                      ((uint32_t)0x0000003FU)        /* low 6-bit ecc result of a word data[31:0] in flash */
#define FLASH_WRP_ECCHW                      ((uint32_t)0x00003F00U)        /* high 6-bit ecc result of a word data[31:0] in flash */

/** Bit definition for FLASH_RDN register **/
#define FLASH_RDN_FLASH_RDN0_MSK ((uint32_t)0x000001FFU) /* RDN0 Mask */
#define FLASH_RDN_FLASH_RDN1_MSK ((uint32_t)0x01FF0000U) /* RDN1 Mask */

/** Bit definition for FLASH_CAHR register **/
#define FLASH_CAHR_LOCKSTRT_MSK ((uint32_t)0x000FU) /* LOCKSTRT Mask */
#define FLASH_CAHR_LOCKSTOP_MSK ((uint32_t)0x00F0U) /* LOCKSTOP Mask */

/** Bit definition for FLASH_ROWP register **/
#define FLASH_ROWP_RPEN         ((uint32_t)0x00000001U) /* row programmer enable */
#define FLASH_ROWP_RPNUM_MASK   ((uint32_t)0x0000001EU) /* row programmer number Mask */
#define FLASH_ROWP_RPADD_MASK   ((uint32_t)0x003FFFE0U) /* row programmer address Mask */
#define FLASH_ROWP_RPAREA       ((uint32_t)0x00400000U) /* row programmer area */

/** Bit definition for CCM_WRP1 register **/
#define CCM_WRP_WRPT_0                        ((uint32_t)0x00000001U) /* bit 0  */
#define CCM_WRP_WRPT_1                        ((uint32_t)0x00000002U) /* bit 1  */
#define CCM_WRP_WRPT_2                        ((uint32_t)0x00000004U) /* bit 2  */
#define CCM_WRP_WRPT_3                        ((uint32_t)0x00000008U) /* bit 3  */
#define CCM_WRP_WRPT_4                        ((uint32_t)0x00000010U) /* bit 4  */
#define CCM_WRP_WRPT_5                        ((uint32_t)0x00000020U) /* bit 5  */
#define CCM_WRP_WRPT_6                        ((uint32_t)0x00000040U) /* bit 6  */
#define CCM_WRP_WRPT_7                        ((uint32_t)0x00000080U) /* bit 7  */
#define CCM_WRP_WRPT_8                        ((uint32_t)0x00000100U) /* bit 8  */
#define CCM_WRP_WRPT_9                        ((uint32_t)0x00000200U) /* bit 9  */
#define CCM_WRP_WRPT_10                       ((uint32_t)0x00000400U) /* bit 10 */
#define CCM_WRP_WRPT_11                       ((uint32_t)0x00000800U) /* bit 11 */
#define CCM_WRP_WRPT_12                       ((uint32_t)0x00001000U) /* bit 12 */
#define CCM_WRP_WRPT_13                       ((uint32_t)0x00002000U) /* bit 13 */
#define CCM_WRP_WRPT_14                       ((uint32_t)0x00004000U) /* bit 14 */
#define CCM_WRP_WRPT_15                       ((uint32_t)0x00008000U) /* bit 15 */
#define CCM_WRP_WRPT_16                       ((uint32_t)0x00010000U) /* bit 16 */
#define CCM_WRP_WRPT_17                       ((uint32_t)0x00020000U) /* bit 17 */
#define CCM_WRP_WRPT_18                       ((uint32_t)0x00040000U) /* bit 18 */
#define CCM_WRP_WRPT_19                       ((uint32_t)0x00080000U) /* bit 19 */
#define CCM_WRP_WRPT_20                       ((uint32_t)0x00100000U) /* bit 20 */
#define CCM_WRP_WRPT_21                       ((uint32_t)0x00200000U) /* bit 21 */
#define CCM_WRP_WRPT_22                       ((uint32_t)0x00400000U) /* bit 22 */
#define CCM_WRP_WRPT_23                       ((uint32_t)0x00800000U) /* bit 23 */
#define CCM_WRP_WRPT_24                       ((uint32_t)0x01000000U) /* bit 24 */
#define CCM_WRP_WRPT_25                       ((uint32_t)0x02000000U) /* bit 25 */
#define CCM_WRP_WRPT_26                       ((uint32_t)0x04000000U) /* bit 26 */
#define CCM_WRP_WRPT_27                       ((uint32_t)0x08000000U) /* bit 27 */
#define CCM_WRP_WRPT_28                       ((uint32_t)0x10000000U) /* bit 28 */
#define CCM_WRP_WRPT_29                       ((uint32_t)0x20000000U) /* bit 29 */
#define CCM_WRP_WRPT_30                       ((uint32_t)0x40000000U) /* bit 30 */
#define CCM_WRP_WRPT_31                       ((uint32_t)0x80000000U) /* bit 31 */

/**  Bit definition for CCM_KEY register  **/
#define CCM_KEY_KEY             ((uint32_t)0xFFFFFFFFU) /* CCM Key */

/**  Bit definition for CCM_ERASE register  **/
#define CCM_ERASE_EN            ((uint32_t)0x00000001U) /* CCM erase enable */
#define CCM_ERASE_BUSY          ((uint32_t)0x00000002U) /* CCM is erasing */

/**  Bit definition for CCM_MODE register  **/
#define CCM_MODE_EN             ((uint32_t)0x00000001U) /* CCM mode enable */

/**  Bit definition for XSPI_DSTRADD register  **/
#define XSPI_DSTRADD_ADD        ((uint32_t)0xFFFFFFFFU) /* XSPI decryption start Address */

/**  Bit definition for XSPI_DENDADD register  **/
#define XSPI_DENDADD_ADD        ((uint32_t)0xFFFFFFFFU) /* XSPI decryption end Address */

/**  Bit definition for FEMC_DSTRADD register  **/
#define FEC_DSTRADD_ADD         ((uint32_t)0xFFFFFFFFU) /* FEMC decryption start Address */

/**  Bit definition for FEMC_DENDADD register  **/
#define FEMC_DENDADD_ADD        ((uint32_t)0xFFFFFFFFU) /* FEMC decryption end Address */

/**  Bit definition for RTPD_KEY register  **/
#define RTPD_KEY_KEY            ((uint32_t)0xFFFFFFFFU) /* RTPD_KEY */

/**  Bit definition for JTAG_SEAL register  **/
#define JTAG_SEAL_DATA_MASK     ((uint32_t)0x000000FFU) /* JTAG_SEAL data mask */

/**  Bit definition for RTPD_KEY_WCNT register  **/
#define RTPD_KEY_WCNT_CNT_MASK  ((uint32_t)0x00000007U) /* RTPD_KEY write cnt mask */

/**  Bit definition for XSPI_FEMC_DEN register  **/
#define XSPI_FEMC_DEN_EN        ((uint32_t)0x00000001U) /* XSPI/FEMC decryption enable */

/**  Bit definition for XUID register  **/
#define XFUID_MASK              ((uint32_t)0x0000001FU) /* XSPI/FEMC UID mask */
#define CCMUID_MASK             ((uint32_t)0x000003E0U) /* XSPI/FEMC UID mask */

/*** Option Bytes register ***/

/** Bit definition for FLASH_RDP register **/
#define FLASH_RDP_RDP1  ((uint32_t)0x000000FFU) /* Read protection option byte */
#define FLASH_RDP_NRDP1 ((uint32_t)0x0000FF00U) /* Read protection complemented option byte */

/** Bit definition for FLASH_USER register **/
#define FLASH_USER_USER  ((uint32_t)0x00FF0000U) /* User option byte */
#define FLASH_USER_NUSER ((uint32_t)0xFF000000U) /* User complemented option byte */

/** Bit definition for FLASH_Data0 register **/
#define FLASH_Data0_Data0  ((uint32_t)0x000000FFU) /* User data storage option byte */
#define FLASH_Data0_NData0 ((uint32_t)0x0000FF00U) /* User data storage complemented option byte */

/** Bit definition for FLASH_Data1 register **/
#define FLASH_Data1_Data1  ((uint32_t)0x00FF0000U) /* User data storage option byte */
#define FLASH_Data1_NData1 ((uint32_t)0xFF000000U) /* User data storage complemented option byte */

/** Bit definition for FLASH_WRP0 register **/
#define FLASH_WRP0_WRP0  ((uint32_t)0x000000FFU) /* Flash memory write protection option bytes */
#define FLASH_WRP0_NWRP0 ((uint32_t)0x0000FF00U) /* Flash memory write protection complemented option bytes */

/** Bit definition for FLASH_WRP1 register **/
#define FLASH_WRP1_WRP1  ((uint32_t)0x00FF0000U) /* Flash memory write protection option bytes */
#define FLASH_WRP1_NWRP1 ((uint32_t)0xFF000000U) /* Flash memory write protection complemented option bytes */

/** Bit definition for FLASH_WRP2 register **/
#define FLASH_WRP2_WRP2  ((uint32_t)0x000000FFU) /* Flash memory write protection option bytes */
#define FLASH_WRP2_NWRP2 ((uint32_t)0x0000FF00U) /* Flash memory write protection complemented option bytes */

/** Bit definition for FLASH_WRP3 register **/
#define FLASH_WRP3_WRP3  ((uint32_t)0x00FF0000U) /* Flash memory write protection option bytes */
#define FLASH_WRP3_NWRP3 ((uint32_t)0xFF000000U) /* Flash memory write protection complemented option bytes */

/** Bit definition for FLASH_RDP2 register **/
#define FLASH_RDP2_RDP2  ((uint32_t)0x000000FFU) /* Read protection level 2 option byte */
#define FLASH_RDP2_NRDP2 ((uint32_t)0x0000FF00U) /* Read protection level 2 complemented option byte */

/** Bit definition for FLASH_USER2 register **/
#define FLASH_USE2R_USER2  ((uint32_t)0x00FF0000U) /* User2 option byte */
#define FLASH_USER2_NUSER2 ((uint32_t)0xFF000000U) /* User2 complemented option byte */

/** Bit definition for FLASH_USER register **/
#define FLASH_USER3_USER3  ((uint32_t)0x000000FFU) /* User3 option byte */
#define FLASH_USER3_NUSER3 ((uint32_t)0x0000FF00U) /* User3 complemented option byte */

/** Bit definition for FLASH_USER register **/
#define FLASH_CCMSRAM_RST  ((uint32_t)0x000000FFU) /* CCMSRAM reset option byte */
#define FLASH_nCCMSRAM_RST ((uint32_t)0x0000FF00U) /* CCMSRAM reset complemented option byte */


/*** Ethernet MAC ***/

/** Bit definition for ETH_MACCFG register **/
#define ETH_MACCFG_RE       ((uint32_t)0x00000001U) /* Receiver Enable */
#define ETH_MACCFG_TE       ((uint32_t)0x00000002U) /* Transmitter Enable */
#define ETH_MACCFG_PRELEN   ((uint32_t)0x0000000CU) /* PRELEN[1:0]: Preamble Length for Transmit packets */
#define ETH_MACCFG_PRELEN_0 ((uint32_t)0x00000004U) /* PRELEN bit 0 */
#define ETH_MACCFG_PRELEN_1 ((uint32_t)0x00000008U) /* PRELEN bit 1 */
#define ETH_MACCFG_DC       ((uint32_t)0x00000010U) /* Deferral Check */
#define ETH_MACCFG_BL       ((uint32_t)0x00000060U) /* BL[1:0]: Back-Off Limit */
#define ETH_MACCFG_BL_0     ((uint32_t)0x00000020U) /* BL bit 0 */
#define ETH_MACCFG_BL_1     ((uint32_t)0x00000040U) /* BL bit 1 */
#define ETH_MACCFG_DR       ((uint32_t)0x00000100U) /* Disable Retry */
#define ETH_MACCFG_DCRS     ((uint32_t)0x00000200U) /* Disable Carrier Sense During Transmission */
#define ETH_MACCFG_DO       ((uint32_t)0x00000400U) /* Disable Receive Own */
#define ETH_MACCFG_ECRSFD   ((uint32_t)0x00000800U) /* Enable Carrier Sense Before Transmission in Full-Duplex Mode */
#define ETH_MACCFG_LM       ((uint32_t)0x00001000U) /* Loopback Mode */ 
#define ETH_MACCFG_DM       ((uint32_t)0x00002000U) /* Duplex Mode (0: Half-duplex, 1: Full-duplex) */ 
#define ETH_MACCFG_FES      ((uint32_t)0x00004000U) /* Speed (0: 10Mbps, 1: 100Mbps) */ 
#define ETH_MACCFG_PS       ((uint32_t)0x00008000U) /* Port Select (0: 1000Mbps, 1: 10 or 100Mbps) */ 
#define ETH_MACCFG_JE       ((uint32_t)0x00010000U) /* Jumbo Packet Enable */  
#define ETH_MACCFG_JD       ((uint32_t)0x00020000U) /* Jabber Disable */  
#define ETH_MACCFG_WD       ((uint32_t)0x00080000U) /* Watchdog Disable */
#define ETH_MACCFG_ACS      ((uint32_t)0x00100000U) /* Automatic Pad or CRC Stripping */
#define ETH_MACCFG_CST      ((uint32_t)0x00200000U) /* CRC stripping for Type packets */
#define ETH_MACCFG_S2KP     ((uint32_t)0x00400000U) /* IEEE 802.3as Support for 2K Packets */
#define ETH_MACCFG_GPSLCE   ((uint32_t)0x00800000U) /* Giant Packet Size Limit Control Enable */
#define ETH_MACCFG_IPG      ((uint32_t)0x07000000U) /* IPG[2:0]: Inter-Packet Gap */
#define ETH_MACCFG_IPG_0    ((uint32_t)0x01000000U) /* IPG bit 0 */
#define ETH_MACCFG_IPG_1    ((uint32_t)0x02000000U) /* IPG bit 1 */
#define ETH_MACCFG_IPG_2    ((uint32_t)0x04000000U) /* IPG bit 2 */
#define ETH_MACCFG_CSO      ((uint32_t)0x08000000U) /* Checksum Offload */

/** Bit definition for ETH_MACEXTCFG register **/
#define ETH_MACEXTCFG_GPSL   ((uint32_t)0x00003FFFU) /* Giant Packet Size Limit */
#define ETH_MACEXTCFG_DCRCC  ((uint32_t)0x00010000U) /* Disable CRC Checking for Received Packets */
#define ETH_MACEXTCFG_SPEN   ((uint32_t)0x00020000U) /* Slow Protocol Detection Enable */
#define ETH_MACEXTCFG_USP    ((uint32_t)0x00040000U) /* Unicast Slow Protocol Packet Detect */
#define ETH_MACEXTCFG_EIPGEN ((uint32_t)0x01000000U) /* Extended Inter-Packet Gap Enable */
#define ETH_MACEXTCFG_EIPG   ((uint32_t)0x3E000000U) /* EIPG[4:0]: Extended Inter-Packet Gap */
#define ETH_MACEXTCFG_EIPG_0 ((uint32_t)0x02000000U) /* EIPG bit 0 */
#define ETH_MACEXTCFG_EIPG_1 ((uint32_t)0x04000000U) /* EIPG bit 1 */
#define ETH_MACEXTCFG_EIPG_2 ((uint32_t)0x08000000U) /* EIPG bit 2 */
#define ETH_MACEXTCFG_EIPG_3 ((uint32_t)0x10000000U) /* EIPG bit 3 */
#define ETH_MACEXTCFG_EIPG_4 ((uint32_t)0x20000000U) /* EIPG bit 4 */

/** Bit definition for ETH_MACPFLT register **/
#define ETH_MACPFLT_PM    ((uint32_t)0x00000001U) /* Promiscuous Mode */
#define ETH_MACPFLT_HUC   ((uint32_t)0x00000002U) /* Hash Unicast */
#define ETH_MACPFLT_HMC   ((uint32_t)0x00000004U) /* Hash Multicast */
#define ETH_MACPFLT_DAIF  ((uint32_t)0x00000008U) /* DA Inverse Filtering */
#define ETH_MACPFLT_PAM   ((uint32_t)0x00000010U) /* Pass All Multicast */
#define ETH_MACPFLT_DBP   ((uint32_t)0x00000020U) /* Disable Broadcast Packets */
#define ETH_MACPFLT_PCP   ((uint32_t)0x000000C0U) /* PCF[1:0]: Pass Control Packets */
#define ETH_MACPFLT_PCP_0 ((uint32_t)0x00000040U) /* PCF bit 0 */
#define ETH_MACPFLT_PCP_1 ((uint32_t)0x00000080U) /* PCF bit 1 */
#define ETH_MACPFLT_SAIF  ((uint32_t)0x00000100U) /* SA Inverse Filtering */
#define ETH_MACPFLT_SAF   ((uint32_t)0x00000200U) /* SA Filter Enable */
#define ETH_MACPFLT_HPF   ((uint32_t)0x00000400U) /* Hash or Perfect Filter */
#define ETH_MACPFLT_VTFE  ((uint32_t)0x00010000U) /* VLAN Tag Filter Enable */
#define ETH_MACPFLT_RA    ((uint32_t)0x80000000U) /* Receive All */

/** Bit definition for ETH_MACWDGTO register **/
#define ETH_MACWDGTO_WTO   ((uint32_t)0x0000000FU) /* WTO[3:0]: Watchdog Timeout */
#define ETH_MACWDGTO_WTO_0 ((uint32_t)0x00000001U) /* WTO bit 0 */
#define ETH_MACWDGTO_WTO_1 ((uint32_t)0x00000002U) /* WTO bit 1 */
#define ETH_MACWDGTO_WTO_2 ((uint32_t)0x00000004U) /* WTO bit 2 */
#define ETH_MACWDGTO_WTO_3 ((uint32_t)0x00000008U) /* WTO bit 3 */
#define ETH_MACWDGTO_PWE   ((uint32_t)0x00000100U) /* Programmable Watchdog Enable */

/** Bit definition for ETH_MACHASHTR0 register **/
#define ETH_MACHASHTR0_HT31T0 ((uint32_t)0xFFFFFFFFU) /* MAC Hash Table First 32 Bits */

/** Bit definition for ETH_MACHASHTR1 register **/
#define ETH_MACHASHTR1_HT63T32 ((uint32_t)0xFFFFFFFFU) /* MAC Hash Table Second 32 Bits */

/** Bit definition for ETH_MACVLANTAG register **/
#define ETH_MACVLANTAG_VL        ((uint32_t)0x0000FFFFU) /* VLAN Tag Identifier for Receive Packets */
#define ETH_MACVLANTAG_VL_UP     ((uint32_t)0x0000E000U) /* VL[15:13]: User Priority */
#define ETH_MACVLANTAG_VL_UP_0   ((uint32_t)0x00002000U) /* VL_UP bit 0 */
#define ETH_MACVLANTAG_VL_UP_1   ((uint32_t)0x00004000U) /* VL_UP bit 1 */
#define ETH_MACVLANTAG_VL_UP_2   ((uint32_t)0x00008000U) /* VL_UP bit 2 */
#define ETH_MACVLANTAG_VL_CFIDEI ((uint32_t)0x00001000U) /* VL[12]: Canonical Format Indicator (CFI) or \
                                                           Drop Eligible Indicator (DEI) */
#define ETH_MACVLANTAG_VL_VID    ((uint32_t)0x00000FFFU) /* VL[11:0]: VLAN Identifier field of VLAN tag */
#define ETH_MACVLANTAG_ETV       ((uint32_t)0x00010000U) /* Enable 12-Bit VLAN Tag Comparison */
#define ETH_MACVLANTAG_VTIM      ((uint32_t)0x00020000U) /* VLAN Tag Inverse Match Enable */
#define ETH_MACVLANTAG_ESVL      ((uint32_t)0x00040000U) /* Enable S-VLAN */
#define ETH_MACVLANTAG_ERSVLM    ((uint32_t)0x00080000U) /* Enable Receive S-VLAN Match */
#define ETH_MACVLANTAG_DOVLTC    ((uint32_t)0x00100000U) /* Disable VLAN Type Check */
#define ETH_MACVLANTAG_EVLS      ((uint32_t)0x00600000U) /* EVLS[1:0]: Enable VLAN Tag Stripping on Receive */
#define ETH_MACVLANTAG_EVLS_0    ((uint32_t)0x00200000U) /* EVLS bit 0 */
#define ETH_MACVLANTAG_EVLS_1    ((uint32_t)0x00400000U) /* EVLS bit 1 */
#define ETH_MACVLANTAG_EVLRXS    ((uint32_t)0x01000000U) /* Enable VLAN Tag in Rx status */
#define ETH_MACVLANTAG_VTHM      ((uint32_t)0x02000000U) /* VLAN Tag Hash Table Match Enable */

/** Bit definition for ETH_MACVHASHT register **/
#define ETH_MACVHASHT_VLHT ((uint32_t)0x0000FFFFU) /* VLAN Hash Table */

/** Bit definition for ETH_MACTXFLWCTRL register **/
#define ETH_MACTXFLWCTRL_FCB   ((uint32_t)0x00000001U) /* Flow Control Busy */
#define ETH_MACTXFLWCTRL_BPA   ((uint32_t)0x00000001U) /* Backpressure Activate */
#define ETH_MACTXFLWCTRL_TFE   ((uint32_t)0x00000002U) /* Transmit Flow Control Enable */
#define ETH_MACTXFLWCTRL_PLT   ((uint32_t)0x00000070U) /* PLT[2:0]: Pause Low Threshold */
#define ETH_MACTXFLWCTRL_PLT_0 ((uint32_t)0x00000010U) /* PLT bit 0 */
#define ETH_MACTXFLWCTRL_PLT_1 ((uint32_t)0x00000020U) /* PLT bit 1 */
#define ETH_MACTXFLWCTRL_PLT_2 ((uint32_t)0x00000040U) /* PLT bit 2 */
#define ETH_MACTXFLWCTRL_DZPQ  ((uint32_t)0x00000080U) /* Disable Zero-Quanta Pause */
#define ETH_MACTXFLWCTRL_PT    ((uint32_t)0xFFFF0000U) /* Pause Time */

/** Bit definition for ETH_MACRXFLWCTRL register **/
#define ETH_MACRXFLWCTRL_RFE ((uint32_t)0x00000001U) /* Receive Flow Control Enable */
#define ETH_MACRXFLWCTRL_UP  ((uint32_t)0x00000002U) /* Unicast Pause Packet Detect */

/** Bit definition for ETH_MACINTSTS register **/
#define ETH_MACINTSTS_PHYIS     ((uint32_t)0x00000008U) /* PHY Interrupt */
#define ETH_MACINTSTS_PMTIS     ((uint32_t)0x00000010U) /* PMT Interrupt Status */
#define ETH_MACINTSTS_MMCIS     ((uint32_t)0x00000100U) /* MMC Interrupt Status */
#define ETH_MACINTSTS_MMCRXIS   ((uint32_t)0x00000200U) /* MMC Receive Interrupt Status */
#define ETH_MACINTSTS_MMCTXIS   ((uint32_t)0x00000400U) /* MMC Transmit Interrupt Status */
#define ETH_MACINTSTS_TSIS      ((uint32_t)0x00001000U) /* Timestamp Interrupt Status */
#define ETH_MACINTSTS_TXSTSIS   ((uint32_t)0x00002000U) /* Transmit Status Interrupt */
#define ETH_MACINTSTS_RXSTSIS   ((uint32_t)0x00004000U) /* Receive Status Interrupt */
#define ETH_MACINTSTS_MDIOIS    ((uint32_t)0x00040000U) /* MDIO Interrupt Status */

/** Bit definition for ETH_MACINTEN register **/
#define ETH_MACINTEN_PHYIE   ((uint32_t)0x00000008U) /* PHY Interrupt Enable */
#define ETH_MACINTEN_PMTIE   ((uint32_t)0x00000010U) /* PMT Interrupt Enable */
#define ETH_MACINTEN_TSIE    ((uint32_t)0x00001000U) /* Timestamp Interrupt Enable */
#define ETH_MACINTEN_TXSTSIE ((uint32_t)0x00002000U) /* Transmit Status Interrupt Enable */
#define ETH_MACINTEN_RXSTSIE ((uint32_t)0x00004000U) /* Receive Status Interrupt Enable */
#define ETH_MACINTEN_MDIOIE  ((uint32_t)0x00040000U) /* MDIO Interrupt Enable */

/** Bit definition for ETH_MACRXTXSTS register **/
#define ETH_MACRXTXSTS_TJT   ((uint32_t)0x00000001U) /* Transmit Jabber Timeout */
#define ETH_MACRXTXSTS_NCARR ((uint32_t)0x00000002U) /* No Carrier */
#define ETH_MACRXTXSTS_LCARR ((uint32_t)0x00000004U) /* Loss of Carrier */
#define ETH_MACRXTXSTS_EXDEF ((uint32_t)0x00000008U) /* Excessive Deferral */
#define ETH_MACRXTXSTS_LCOL  ((uint32_t)0x00000010U) /* Late Collision */
#define ETH_MACRXTXSTS_EXCOL ((uint32_t)0x00000020U) /* Excessive Collisions */
#define ETH_MACRXTXSTS_RWT   ((uint32_t)0x00000100U) /* Receive Watchdog Timeout */

/** Bit definition for ETH_MACPMTCTRLSTS register **/
#define ETH_MACPMTCTRLSTS_PWRDWN     ((uint32_t)0x00000001U) /* Power Down */
#define ETH_MACPMTCTRLSTS_MGKPKTEN   ((uint32_t)0x00000002U) /* Magic Packet Enable */
#define ETH_MACPMTCTRLSTS_RWKPKTEN   ((uint32_t)0x00000004U) /* Remote Wake-Up Packet Enable */
#define ETH_MACPMTCTRLSTS_MGKPRCVD   ((uint32_t)0x00000020U) /* Magic Packet Received */
#define ETH_MACPMTCTRLSTS_RWKPRCVD   ((uint32_t)0x00000040U) /* Remote Wake-Up Packet Received */
#define ETH_MACPMTCTRLSTS_GLBLUCAST  ((uint32_t)0x00000200U) /* Global Unicast */
#define ETH_MACPMTCTRLSTS_RWKPFE     ((uint32_t)0x00000400U) /* Remote Wake-up Packet Forwarding Enable */
#define ETH_MACPMTCTRLSTS_RWKPTR     ((uint32_t)0x1F000000U) /* Remote Wake-up FIFO Pointer */
#define ETH_MACPMTCTRLSTS_RWKFILTRST ((uint32_t)0x80000000U) /* Remote Wake-Up Packet Filter Register Pointer Reset */

/** Bit definition for ETH_MACRWUPFLT register **/
#define ETH_MACRWUPFLT_WKUPFRMFTR ((uint32_t)0xFFFFFFFFU) /* RWK Packet Filter */

/** Bit definition for ETH_MACVER register **/
#define ETH_MACVER_SNPSVER ((uint32_t)0x000000FFU) /* Synopsys-defined Version */
#define ETH_MACVER_USERVER ((uint32_t)0x0000FF00U) /* User-defined Version */

/** Bit definition for ETH_MACDBG register **/
#define ETH_MACDBG_RPESTS     ((uint32_t)0x00000001U) /* MAC GMII or MII Receive Protocol Engine Status */
#define ETH_MACDBG_RFCFCSTS   ((uint32_t)0x00000006U) /* RFCFCSTS[1:0]: MAC Receive Packet Controller FIFO Status */
#define ETH_MACDBG_RFCFCSTS_0 ((uint32_t)0x00000002U) /* RFCFCSTS bit 0 */
#define ETH_MACDBG_RFCFCSTS_1 ((uint32_t)0x00000004U) /* RFCFCSTS bit 1 */
#define ETH_MACDBG_TPESTS     ((uint32_t)0x00010000U) /* MAC GMII or MII Transmit Protocol Engine Status */
#define ETH_MACDBG_TFCSTS     ((uint32_t)0x00060000U) /* TFCSTS[1:0]: MAC Transmit Packet Controller Status */
#define ETH_MACDBG_TFCSTS_0   ((uint32_t)0x00020000U) /* TFCSTS bit 0 */
#define ETH_MACDBG_TFCSTS_1   ((uint32_t)0x00040000U) /* TFCSTS bit 1 */

/** Bit definition for ETH_MACHWF0 register **/
#define ETH_MACHWF0_MIISEL       ((uint32_t)0x00000001U) /* 10 or 100 Mbps Support */
#define ETH_MACHWF0_GMIISEL      ((uint32_t)0x00000002U) /* 1000 Mbps Support */
#define ETH_MACHWF0_HDSEL        ((uint32_t)0x00000004U) /* Half-duplex Support */
#define ETH_MACHWF0_VLHASH       ((uint32_t)0x00000010U) /* VLAN Hash Filter Selected */
#define ETH_MACHWF0_SMASEL       ((uint32_t)0x00000020U) /* SMA (MDIO) Interface */
#define ETH_MACHWF0_RWKSEL       ((uint32_t)0x00000040U) /* PMT Remote Wake-up Packet Enable */
#define ETH_MACHWF0_MGKSEL       ((uint32_t)0x00000080U) /* PMT Magic Packet Enable */
#define ETH_MACHWF0_MMCSEL       ((uint32_t)0x00000100U) /* RMON Module Enable */
#define ETH_MACHWF0_ARPOFFSEL    ((uint32_t)0x00000200U) /* ARP Offload Enabled */
#define ETH_MACHWF0_TSSEL        ((uint32_t)0x00001000U) /* IEEE 1588-2008 Timestamp Enabled */
#define ETH_MACHWF0_EEESEL       ((uint32_t)0x00002000U) /* Energy Efficient Ethernet Enabled */
#define ETH_MACHWF0_TXCOESEL     ((uint32_t)0x00004000U) /* Transmit Checksum Offload Enabled */
#define ETH_MACHWF0_RXCOESEL     ((uint32_t)0x00010000U) /* Receive Checksum Offload Enabled */
#define ETH_MACHWF0_ADDMACADRSEL ((uint32_t)0x007C0000U) /* MAC Addresses 1-31 Selected */
#define ETH_MACHWF0_MACADR32SEL  ((uint32_t)0x00800000U) /* MAC Addresses 32-63 Selected */
#define ETH_MACHWF0_MACADR64SEL  ((uint32_t)0x01000000U) /* MAC Addresses 64-127 Selected */
#define ETH_MACHWF0_TSSTSSEL     ((uint32_t)0x06000000U) /* Timestamp System Time Source */
#define ETH_MACHWF0_SAVLANINS    ((uint32_t)0x08000000U) /* Source Address or VLAN Insertion Enable */
#define ETH_MACHWF0_ACTPHYSEL    ((uint32_t)0x70000000U) /* Active PHY Selected */

/** Bit definition for ETH_MACHWF1 register **/
#define ETH_MACHWF1_RXFIFOSIZE ((uint32_t)0x0000001FU) /* MTL Receive FIFO Size */
#define ETH_MACHWF1_SPRAM      ((uint32_t)0x00000020U) /* Single Port RAM Enable */
#define ETH_MACHWF1_TXFIFOSIZE ((uint32_t)0x000007C0U) /* MTL Transmit FIFO Size */
#define ETH_MACHWF1_OSTEN      ((uint32_t)0x00000800U) /* One-Step Timestamping Enable */
#define ETH_MACHWF1_PTOEN      ((uint32_t)0x00001000U) /* PTP Offload Enable */
#define ETH_MACHWF1_ADVTHWORD  ((uint32_t)0x00002000U) /* IEEE 1588 High Word Register Enable */
#define ETH_MACHWF1_ADDR64     ((uint32_t)0x0000C000U) /* Address Width */
#define ETH_MACHWF1_DCBEN      ((uint32_t)0x00010000U) /* DCB Feature Enable */
#define ETH_MACHWF1_SPHEN      ((uint32_t)0x00020000U) /* Split Header Feature Enable */
#define ETH_MACHWF1_TSOEN      ((uint32_t)0x00040000U) /* TCP Segmentation Offload Enable */
#define ETH_MACHWF1_DBGMEMA    ((uint32_t)0x00080000U) /* DMA Debug Registers Enable */
#define ETH_MACHWF1_AVSEL      ((uint32_t)0x00100000U) /* AV Feature Enable */
#define ETH_MACHWF1_RAVSEL     ((uint32_t)0x00200000U) /* Rx Side Only AV Feature Enable */
#define ETH_MACHWF1_POUOST     ((uint32_t)0x00800000U) /* One Step for PTP over UDP/IP Feature Enable */
#define ETH_MACHWF1_HASHTBLSZ  ((uint32_t)0x03000000U) /* Hash Table Size */
#define ETH_MACHWF1_L3L4FNUM   ((uint32_t)0x78000000U) /* Total number of L3 or L4 Filters */

/** Bit definition for ETH_MACHWF2 register **/
#define ETH_MACHWF2_RXQCNT     ((uint32_t)0x0000000FU) /* Number of MTL Receive Queues */
#define ETH_MACHWF2_TXQCNT     ((uint32_t)0x000003C0U) /* Number of MTL Transmit Queues */
#define ETH_MACHWF2_RXCHCNT    ((uint32_t)0x0000F000U) /* Number of DMA Receive Channels */
#define ETH_MACHWF2_RDCSZ      ((uint32_t)0x00030000U) /* Rx DMA Descriptor Cache Size in terms of \
                                                         16 bytes descriptors */
#define ETH_MACHWF2_TXCHCNT    ((uint32_t)0x003C0000U) /* Number of DMA Transmit Channels */
#define ETH_MACHWF2_TDCSZ      ((uint32_t)0x00C00000U) /* Tx DMA Descriptor Cache Size in terms of \
                                                         16 bytes descriptors */
#define ETH_MACHWF2_PPSOUTNUM  ((uint32_t)0x03000000U) /* Number of PPS Outputs */
#define ETH_MACHWF2_AUXSNAPNUM ((uint32_t)0x70000000U) /* Number of Auxiliary Snapshot Inputs */

/** Bit definition for ETH_MACHWF3 register **/
#define ETH_MACHWF3_NRVF    ((uint32_t)0x00000007U) /* Number of Extended VLAN Tag Filters Enabled */
#define ETH_MACHWF3_CBTISEL ((uint32_t)0x00000010U) /* Queue/Channel based VLAN tag insertion on Tx Enable */
#define ETH_MACHWF3_DVLAN   ((uint32_t)0x00000020U) /* Double VLAN Tag Processing Selected */
#define ETH_MACHWF3_PDUPSEL ((uint32_t)0x00000200U) /* Broadcast/Multicast Packet Duplication */
#define ETH_MACHWF3_FRPSEL  ((uint32_t)0x00000200U) /* Flexible Receive Parser Selected */
#define ETH_MACHWF3_FRPBS   ((uint32_t)0x00001800U) /* Flexible Receive Parser Buffer size */
#define ETH_MACHWF3_FRPES   ((uint32_t)0x00006000U) /* Flexible Receive Parser Table Entries size */
#define ETH_MACHWF3_ESTSEL  ((uint32_t)0x00010000U) /* Enhancements to Scheduled Traffic Enable */
#define ETH_MACHWF3_ESTDEP  ((uint32_t)0x000E0000U) /* Depth of the Gate Control List */
#define ETH_MACHWF3_ESTWID  ((uint32_t)0x00300000U) /* Width of the Time Interval field in the Gate Control List */
#define ETH_MACHWF3_FPESEL  ((uint32_t)0x04000000U) /* Frame Preemption Enable */
#define ETH_MACHWF3_TBSSEL  ((uint32_t)0x08000000U) /* Time Based Scheduling Enable */
#define ETH_MACHWF3_ASP     ((uint32_t)0x30000000U) /* Automotive Safety Package */

/** Bit definition for ETH_MACMDIOADDR register **/
#define ETH_MACMDIOADDR_MB    ((uint32_t)0x00000001U) /* MII Busy */
#define ETH_MACMDIOADDR_C45E  ((uint32_t)0x00000002U) /* Clause 45 PHY Enable */
#define ETH_MACMDIOADDR_MOC   ((uint32_t)0x0000000CU) /* MII Operation Command */
#define ETH_MACMDIOADDR_MOC0  ((uint32_t)0x00000004U) /* MII Operation Command 0 */
#define ETH_MACMDIOADDR_MOC1  ((uint32_t)0x00000008U) /* MII Operation Command 1 */
#define ETH_MACMDIOADDR_SKAP  ((uint32_t)0x00000010U) /* Skip Address Packet */
#define ETH_MACMDIOADDR_CR    ((uint32_t)0x00000F00U) /* CR[3:0]: CSR Clock Range */
#define ETH_MACMDIOADDR_CR_0  ((uint32_t)0x00000100U) /* CR bit 0 */
#define ETH_MACMDIOADDR_CR_1  ((uint32_t)0x00000200U) /* CR bit 1 */
#define ETH_MACMDIOADDR_CR_2  ((uint32_t)0x00000400U) /* CR bit 2 */
#define ETH_MACMDIOADDR_CR_3  ((uint32_t)0x00000800U) /* CR bit 3 */
#define ETH_MACMDIOADDR_NTC   ((uint32_t)0x00007000U) /* Number of Trailing Clocks */
#define ETH_MACMDIOADDR_RDA   ((uint32_t)0x001F0000U) /* Register/Device Address */
#define ETH_MACMDIOADDR_PA    ((uint32_t)0x003E0000U) /* Physical Layer Address */
#define ETH_MACMDIOADDR_BTB   ((uint32_t)0x04000000U) /* Back to Back transactions */
#define ETH_MACMDIOADDR_PSE   ((uint32_t)0x08000000U) /* Preamble Suppression Enable */

/** Bit definition for ETH_MACMDIODATA register **/
#define ETH_MACMDIODATA_MD ((uint32_t)0x0000FFFFU) /* MII Data */
#define ETH_MACMDIODATA_RA ((uint32_t)0xFFFF0000U) /* Register Address */

/** Bit definition for ETH_MACCSRSWCTRL register **/
#define ETH_MACCSRSWCTRL_RCWE ((uint32_t)0x00000001U) /* Register Clear on Write 1 Enable */
#define ETH_MACCSRSWCTRL_SEEN ((uint32_t)0x00000100U) /* Slave Error Response Enable */

/** Bit definition for ETH_MACADDR0H register **/
#define ETH_MACADDR0H_ADDRHI ((uint32_t)0x0000FFFFU) /* MAC Address0[47:32] */
#define ETH_MACADDR0H_AE     ((uint32_t)0x80000000U) /* Address Enable */

/** Bit definition for ETH_MACADDR0L register **/
#define ETH_MACADDR0L_ADDRLO ((uint32_t)0xFFFFFFFFU) /* MAC Address0[31:0] */

/** Bit definition for ETH_MACADDR1H register **/
#define ETH_MACADDR1H_ADDRHI ((uint32_t)0x0000FFFFU) /* MAC Address1[47:32] */
#define ETH_MACADDR1H_MBC    ((uint32_t)0x3F000000U) /* MBC[5:0]: Mask Byte Control */
#define ETH_MACADDR1H_MBC_0  ((uint32_t)0x01000000U) /* MBC bit 0 */
#define ETH_MACADDR1H_MBC_1  ((uint32_t)0x02000000U) /* MBC bit 1 */
#define ETH_MACADDR1H_MBC_2  ((uint32_t)0x04000000U) /* MBC bit 2 */
#define ETH_MACADDR1H_MBC_3  ((uint32_t)0x08000000U) /* MBC bit 3 */
#define ETH_MACADDR1H_MBC_4  ((uint32_t)0x10000000U) /* MBC bit 4 */
#define ETH_MACADDR1H_MBC_5  ((uint32_t)0x20000000U) /* MBC bit 5 */
#define ETH_MACADDR1H_SA     ((uint32_t)0x40000000U) /* Source Address */
#define ETH_MACADDR1H_AE     ((uint32_t)0x80000000U) /* Address Enable */

/** Bit definition for ETH_MACADDR1L register **/
#define ETH_MACADDR1L_ADDRLO ((uint32_t)0xFFFFFFFFU) /* MAC Address1[31:0] */

/** Bit definition for ETH_MACADDR2H register **/
#define ETH_MACADDR2H_ADDRHI ((uint32_t)0x0000FFFFU) /* MAC Address2[47:32] */
#define ETH_MACADDR2H_MBC    ((uint32_t)0x3F000000U) /* MBC[5:0]: Mask Byte Control */
#define ETH_MACADDR2H_MBC_0  ((uint32_t)0x01000000U) /* MBC bit 0 */
#define ETH_MACADDR2H_MBC_1  ((uint32_t)0x02000000U) /* MBC bit 1 */
#define ETH_MACADDR2H_MBC_2  ((uint32_t)0x04000000U) /* MBC bit 2 */
#define ETH_MACADDR2H_MBC_3  ((uint32_t)0x08000000U) /* MBC bit 3 */
#define ETH_MACADDR2H_MBC_4  ((uint32_t)0x10000000U) /* MBC bit 4 */
#define ETH_MACADDR2H_MBC_5  ((uint32_t)0x20000000U) /* MBC bit 5 */
#define ETH_MACADDR2H_SA     ((uint32_t)0x40000000U) /* Source Address */
#define ETH_MACADDR2H_AE     ((uint32_t)0x80000000U) /* Address Enable */

/** Bit definition for ETH_MACADDR2L register **/
#define ETH_MACADDR2L_ADDRLO ((uint32_t)0xFFFFFFFFU) /* MAC Address2[31:0] */

/** Bit definition for ETH_MACADDR3H register **/
#define ETH_MACADDR3H_ADDRHI ((uint32_t)0x0000FFFFU) /* MAC Address3[47:32] */
#define ETH_MACADDR3H_MBC    ((uint32_t)0x3F000000U) /* MBC[5:0]: Mask Byte Control */
#define ETH_MACADDR3H_MBC_0  ((uint32_t)0x01000000U) /* MBC bit 0 */
#define ETH_MACADDR3H_MBC_1  ((uint32_t)0x02000000U) /* MBC bit 1 */
#define ETH_MACADDR3H_MBC_2  ((uint32_t)0x04000000U) /* MBC bit 2 */
#define ETH_MACADDR3H_MBC_3  ((uint32_t)0x08000000U) /* MBC bit 3 */
#define ETH_MACADDR3H_MBC_4  ((uint32_t)0x10000000U) /* MBC bit 4 */
#define ETH_MACADDR3H_MBC_5  ((uint32_t)0x20000000U) /* MBC bit 5 */
#define ETH_MACADDR3H_SA     ((uint32_t)0x40000000U) /* Source Address */
#define ETH_MACADDR3H_AE     ((uint32_t)0x80000000U) /* Address Enable */

/** Bit definition for ETH_MACADDR3L register **/
#define ETH_MACADDR3L_ADDRLO ((uint32_t)0xFFFFFFFFU) /* MAC Address3[31:0] */

/** Bit definition for ETH_MMCCTRL register **/
#define ETH_MMCCTRL_CNTRST     ((uint32_t)0x00000001U) /* Counters Reset */
#define ETH_MMCCTRL_CNTSTOPRO  ((uint32_t)0x00000002U) /* Counter Stop Rollover */
#define ETH_MMCCTRL_RSTONRD    ((uint32_t)0x00000004U) /* Reset on Read */
#define ETH_MMCCTRL_CNTFREEZ   ((uint32_t)0x00000008U) /* MMC Counter Freeze */
#define ETH_MMCCTRL_CNTPRST    ((uint32_t)0x00000010U) /* Counters Preset */
#define ETH_MMCCTRL_CNTPRSTLVL ((uint32_t)0x00000020U) /* Full-Half Preset */
#define ETH_MMCCTRL_UCDBC      ((uint32_t)0x00000100U) /* Update MMC Counters for Dropped Broadcast Packets */

/** Bit definition for ETH_MMCRXINT register **/
#define ETH_MMCRXINT_RXBCGPIS    ((uint32_t)0x00000008U) /* MMC RX Broadcast Good Packet Counter Interrupt Status */
#define ETH_MMCRXINT_RXMCGPIS    ((uint32_t)0x00000010U) /* MMC RX Multicast Good Packet Counter Interrupt Status */
#define ETH_MMCRXINT_RXCRCERPIS  ((uint32_t)0x00000020U) /* MMC RX CRC Error Packet Counter Interrupt Status */
#define ETH_MMCRXINT_RXALGNERPIS ((uint32_t)0x00000040U) /* MMC RX Alignment Error Packet Counter Interrupt Status */
#define ETH_MMCRXINT_RXUCGPIS    ((uint32_t)0x00020000U) /* MMC RX Unicast Good Packet Counter Interrupt Status */

/** Bit definition for ETH_MMCTXINT register **/
#define ETH_MMCTXINT_TXSCOLGPIS ((uint32_t)0x00004000U) /* MMC TX Single Collision Good Packet Counter Interrupt Status */
#define ETH_MMCTXINT_TXMCOLGPIS ((uint32_t)0x00008000U) /* MMC TX Multiple Collision Good Packet Counter Interrupt Status */
#define ETH_MMCTXINT_TXGPKTIS   ((uint32_t)0x00200000U) /* MMC TX Good Packet Counter Interrupt Status */

/** Bit definition for ETH_MMCRXINTMSK register **/
#define ETH_MMCRXINTMSK_RXBCGPIM    ((uint32_t)0x00000008U) /* MMC RX Broadcast Good Packet Counter Interrupt Mask */
#define ETH_MMCRXINTMSK_RXMCGPIM    ((uint32_t)0x00000010U) /* MMC RX Multicast Good Packet Counter Interrupt Mask */
#define ETH_MMCRXINTMSK_RXCRCERPIM  ((uint32_t)0x00000020U) /* MMC RX CRC Error Packet Counter Interrupt Mask */
#define ETH_MMCRXINTMSK_RXALGNERPIM ((uint32_t)0x00000040U) /* MMC RX Alignment Error Packet Counter Interrupt Mask */
#define ETH_MMCRXINTMSK_RXUCGPIM    ((uint32_t)0x00020000U) /* MMC RX Unicast Good Packet Counter Interrupt Mask */

/** Bit definition for ETH_MMCTXINTMSK register **/
#define ETH_MMCTXINTMSK_TXSCOLGPIM ((uint32_t)0x00004000U) /* MMC TX Single Collision Good Packet Counter Interrupt Mask */
#define ETH_MMCTXINTMSK_TXMCOLGPIM ((uint32_t)0x00008000U) /* MMC TX Multiple Collision Good Packet Counter Interrupt Mask */
#define ETH_MMCTXINTMSK_TXGPKTIM   ((uint32_t)0x00200000U) /* MMC TX Good Packet Counter Interrupt Mask */

/** Bit definition for ETH_MMCTXSCGP register **/
#define ETH_MMCTXSCGP_TXSNGLCOLG  ((uint32_t)0xFFFFFFFFU) /* Tx Single Collision Good Packets */

/** Bit definition for ETH_MMCTXMCGP register **/
#define ETH_MMCTXMCGP_TXMULTCOLG  ((uint32_t)0xFFFFFFFFU) /* Tx Multiple Collision Good Packets */

/** Bit definition for ETH_MMCTXPCG register **/
#define ETH_MMCTXPCG_TXPKTG       ((uint32_t)0xFFFFFFFFU) /* Tx Packet Count Good */

/** Bit definition for ETH_MMCRXBPG register **/
#define ETH_MMCRXBPG_RXBCASTG     ((uint32_t)0xFFFFFFFFU) /* Rx Broadcast Packets Good */

/** Bit definition for ETH_MMCRXMPG register **/
#define ETH_MMCRXMPG_RXMCASTG     ((uint32_t)0xFFFFFFFFU) /* Rx Multicast Packets Good */

/** Bit definition for ETH_MMCRXCRCEP register **/
#define ETH_MMCRXCRCEP_RXCRCERR   ((uint32_t)0xFFFFFFFFU) /* Rx CRC Error Packets */

/** Bit definition for ETH_MMCRXAEP register **/
#define ETH_MMCRXAEP_RXALGNERR    ((uint32_t)0xFFFFFFFFU) /* Rx Alignment Error Packets */

/** Bit definition for ETH_MMCRXUPG register **/
#define ETH_MMCRXUPG_RXUCASTG     ((uint32_t)0xFFFFFFFFU) /* Rx Unicast Packets Good */

/** Bit definition for ETH_MACTSCTRL register **/
#define ETH_MACTSCTRL_TSENA       ((uint32_t)0x00000001U) /* Enable Timestamp */
#define ETH_MACTSCTRL_TSCFUPDT    ((uint32_t)0x00000002U) /* Fine or Coarse Timestamp Update */
#define ETH_MACTSCTRL_TSINIT      ((uint32_t)0x00000004U) /* Initialize Timestamp */
#define ETH_MACTSCTRL_TSUPDT      ((uint32_t)0x00000008U) /* Update Timestamp */
#define ETH_MACTSCTRL_TTSTRIG     ((uint32_t)0x00000010U) /* Enable Timestamp Interrupt Trigger */
#define ETH_MACTSCTRL_TSADDREG    ((uint32_t)0x00000020U) /* Update Addend Register */
#define ETH_MACTSCTRL_TSENALL     ((uint32_t)0x00000100U) /* Enable Timestamp for All Packets */
#define ETH_MACTSCTRL_TSCTRLSSR   ((uint32_t)0x00000200U) /* Timestamp Digital or Binary Rollover Control */
#define ETH_MACTSCTRL_TSVER2ENA   ((uint32_t)0x00000400U) /* Enable PTP Packet Processing for Version 2 Format */
#define ETH_MACTSCTRL_TSIPENA     ((uint32_t)0x00000800U) /* Enable Processing of PTP over Ethernet Packets */
#define ETH_MACTSCTRL_TSIPV6ENA   ((uint32_t)0x00001000U) /* Enable Processing of PTP Packets Sent over IPv6-UDP */
#define ETH_MACTSCTRL_TSIPV4ENA   ((uint32_t)0x00002000U) /* Enable Processing of PTP Packets Sent over IPv4-UDP */
#define ETH_MACTSCTRL_TSEVNTENA   ((uint32_t)0x00004000U) /* Enable Timestamp Snapshot for Event Messages */
#define ETH_MACTSCTRL_TSMSTRENA   ((uint32_t)0x00008000U) /* Enable Snapshot for Messages Relevant to Master */
#define ETH_MACTSCTRL_SNAPTYPSEL  ((uint32_t)0x00030000U) /* Select PTP packets for Taking Snapshots */
#define ETH_MACTSCTRL_TSENMACADDR ((uint32_t)0x00040000U) /* Enable MAC Address for PTP Packet Filtering */
#define ETH_MACTSCTRL_TXTSSTSM    ((uint32_t)0x01000000U) /* Transmit Timestamp Status Mode */
#define ETH_MACTSCTRL_AV8021ASMEN ((uint32_t)0x10000000U) /* AV 802.1AS Mode Enable */

/** Bit definition for ETH_MACSUBSINC register **/
#define ETH_MACSUBSINC_SSINC ((uint32_t)0x00FF0000U) /* Sub-second Increment Value */

/** Bit definition for ETH_MACSYSTS register **/
#define ETH_MACSYSTS_TSS ((uint32_t)0xFFFFFFFFU) /* Timestamp Second */

/** Bit definition for ETH_MACSYSTNS register **/
#define ETH_MACSYSTNS_TSSS ((uint32_t)0x7FFFFFFFU) /* Timestamp Sub Seconds */

/** Bit definition for ETH_MACSYSTSUP register **/
#define ETH_MACSYSTSUP_TSS ((uint32_t)0xFFFFFFFFU) /* Timestamp Seconds */

/** Bit definition for ETH_MACSYSTNSUP register **/
#define ETH_MACSYSTNSUP_TSSS   ((uint32_t)0x7FFFFFFFU) /* Timestamp Sub Seconds */
#define ETH_MACSYSTNSUP_ADDSUB ((uint32_t)0x80000000U) /* Add or Subtract Time */

/** Bit definition for ETH_MACTSADD register **/
#define ETH_MACTSADD_TSAR ((uint32_t)0xFFFFFFFFU) /* Timestamp Addend Register */

/** Bit definition for ETH_MACTSSTS register **/
#define ETH_MACTSSTS_TSSOVF     ((uint32_t)0x00000001U) /* Timestamp Seconds Overflow */
#define ETH_MACTSSTS_TSTARGT0   ((uint32_t)0x00000002U) /* Timestamp Target Time Reached */
#define ETH_MACTSSTS_TSTRGTERR0 ((uint32_t)0x00000008U) /* Timestamp Target Time Error */
#define ETH_MACTSSTS_TXTSSIS    ((uint32_t)0x00008000U) /* Tx Timestamp Status Interrupt Status */

/** Bit definition for ETH_MACTXTSSTSNS register **/
#define ETH_MACTXTSSTSNS_TXTSSLO  ((uint32_t)0x7FFFFFFFU) /* Number of Auxiliary Timestamp Snapshots */
#define ETH_MACTXTSSTSNS_TXTSSMIS ((uint32_t)0x80000000U) /* Transmit Timestamp Status Missed */

/** Bit definition for ETH_MACTXTSSTSS register **/
#define ETH_MACTXTSSTSS_TXTSSHI ((uint32_t)0xFFFFFFFFU) /* Transmit Timestamp Status High */

/** Bit definition for ETH_MACTSIGCNS register **/
#define ETH_MACTSIGCNS_TSIC ((uint32_t)0xFFFFFFFFU) /* Timestamp Ingress Correction */

/** Bit definition for ETH_MACTSEGCNS register **/
#define ETH_MACTSEGCNS_TSEC ((uint32_t)0xFFFFFFFFU) /* Timestamp Egress Correction */

/** Bit definition for ETH_MACTSIGLAT register **/
#define ETH_MACTSIGLAT_ITLSNS ((uint32_t)0x0000FF00U) /* Ingress Timestamp Latency, in sub-nanoseconds */
#define ETH_MACTSIGLAT_ITLNS  ((uint32_t)0x0FFF0000U) /* Ingress Timestamp Latency, in nanoseconds */

/** Bit definition for ETH_MACTSEGLAT register **/
#define ETH_MACTSEGLAT_ETLSNS ((uint32_t)0x0000FF00U) /* Egress Timestamp Latency, in sub-nanoseconds */
#define ETH_MACTSEGLAT_ETLNS  ((uint32_t)0x0FFF0000U) /* Egress Timestamp Latency, in nanoseconds */

/** Bit definition for ETH_MACPPSCTRL register **/
#define ETH_MACPPSCTRL_PPSCTRL   ((uint32_t)0x0000000FU) /* PPSCTRL[3:0]: PPS Output Frequency Control */
#define ETH_MACPPSCTRL_PPSCTRL_0 ((uint32_t)0x00000001U) /* PPSCTRL bit 0 */
#define ETH_MACPPSCTRL_PPSCTRL_1 ((uint32_t)0x00000002U) /* PPSCTRL bit 1 */
#define ETH_MACPPSCTRL_PPSCTRL_2 ((uint32_t)0x00000004U) /* PPSCTRL bit 2 */
#define ETH_MACPPSCTRL_PPSCTRL_3 ((uint32_t)0x00000008U) /* PPSCTRL bit 3 */

/** Bit definition for ETH_MACPPSTTS register **/
#define ETH_MACPPSTTS_TSTRH0 ((uint32_t)0xFFFFFFFFU) /* PPS Target Time Seconds Register */

/** Bit definition for ETH_MACPPSTTNS register **/
#define ETH_MACPPSTTNS_TTSL0     ((uint32_t)0x7FFFFFFFU) /* Target Time Low for PPS Register */


/*** Ethernet MTL ***/

/** Bit definition for ETH_MTLOPMOD register **/
#define ETH_MTLOPMOD_DTXSTS  ((uint32_t)0x00000002U) /* Drop Transmit Status */
#define ETH_MTLOPMOD_CNTPRST ((uint32_t)0x00000100U) /* Counters Preset */
#define ETH_MTLOPMOD_CNTCLR  ((uint32_t)0x00000200U) /* Counters Reset */

/** Bit definition for ETH_MTLINTSTS register **/
#define ETH_MTLINTSTS_Q0IS ((uint32_t)0x00000001U) /* Queue 0 Interrupt status */


/*** Ethernet MTL Queue ***/

/** Bit definition for ETH_MTLTXQOPMOD register **/
#define ETH_MTLTXQOPMOD_FTQ   ((uint32_t)0x00000001U) /* Flush Transmit Queue */
#define ETH_MTLTXQOPMOD_TSF   ((uint32_t)0x00000002U) /* Transmit Store and Forward */
#define ETH_MTLTXQOPMOD_TTC   ((uint32_t)0x00000070U) /* TTC[2:0]: Transmit Threshold Control */
#define ETH_MTLTXQOPMOD_TTC_0 ((uint32_t)0x00000010U) /* TTC bit 0 */
#define ETH_MTLTXQOPMOD_TTC_1 ((uint32_t)0x00000020U) /* TTC bit 1 */
#define ETH_MTLTXQOPMOD_TTC_2 ((uint32_t)0x00000040U) /* TTC bit 2 */

/** Bit definition for ETH_MTLTXQUDF register **/
#define ETH_MTLTXQUDF_UFFRMCNT ((uint32_t)0x000007FFU) /* Underflow Packet Counter */
#define ETH_MTLTXQUDF_UFCNTOVF ((uint32_t)0x00000800U) /* Overflow Bit for Underflow Packet Counter */

/** Bit definition for ETH_MTLTXQDBG register **/
#define ETH_MTLTXQDBG_TXQPAUSED ((uint32_t)0x00000001U) /* Transmit Queue in Pause */
#define ETH_MTLTXQDBG_TRCSTS    ((uint32_t)0x00000006U) /* TRCSTS[1:0]: MTL Tx Queue Read Controller Status */
#define ETH_MTLTXQDBG_TRCSTS_0  ((uint32_t)0x00000002U) /* TRCSTS bit 0 */
#define ETH_MTLTXQDBG_TRCSTS_1  ((uint32_t)0x00000004U) /* TRCSTS bit 1 */
#define ETH_MTLTXQDBG_TWCSTS    ((uint32_t)0x00000008U) /* MTL Tx Queue Write Controller Status */
#define ETH_MTLTXQDBG_TXQSTS    ((uint32_t)0x00000010U) /* MTL Tx Queue Not Empty Status */
#define ETH_MTLTXQDBG_TXSTSFSTS ((uint32_t)0x00000020U) /* MTL Tx Status FIFO Full Status */
#define ETH_MTLTXQDBG_PTXQ      ((uint32_t)0x00070000U) /* Number of Packets in the Transmit Queue */
#define ETH_MTLTXQDBG_STXSTSF   ((uint32_t)0x00700000U) /* Number of Status Words in Tx Status FIFO of Queue */

/** Bit definition for ETH_MTLQINTCTRLSTS register **/
#define ETH_MTLQINTCTRLSTS_TXUNFIS ((uint32_t)0x00000001U) /* Transmit Queue Underflow Interrupt Status */
#define ETH_MTLQINTCTRLSTS_TXUIE   ((uint32_t)0x00000100U) /* Transmit Queue Underflow Interrupt Enable */
#define ETH_MTLQINTCTRLSTS_RXOVFIS ((uint32_t)0x00010000U) /* Receive Queue Overflow Interrupt Status */
#define ETH_MTLQINTCTRLSTS_RXOIE   ((uint32_t)0x01000000U) /* Receive Queue Overflow Interrupt Enable */

/** Bit definition for ETH_MTLRXQOPMOD register **/
#define ETH_MTLRXQOPMOD_RTC      ((uint32_t)0x00000003U) /* RTC[1:0]: Receive Queue Threshold Control */
#define ETH_MTLRXQOPMOD_RTC_0    ((uint32_t)0x00000001U) /* RTC bit 0 */
#define ETH_MTLRXQOPMOD_RTC_1    ((uint32_t)0x00000002U) /* RTC bit 1 */
#define ETH_MTLRXQOPMOD_FUP      ((uint32_t)0x00000008U) /* Forward Undersized Good Packets */
#define ETH_MTLRXQOPMOD_FEP      ((uint32_t)0x00000010U) /* Forward Error Packets */
#define ETH_MTLRXQOPMOD_RSF      ((uint32_t)0x00000020U) /* Receive Queue Store and Forward */
#define ETH_MTLRXQOPMOD_DISTCPEF ((uint32_t)0x00000040U) /* Disable Dropping of TCP/IP Checksum Error Packets */

/** Bit definition for ETH_MTLRXQMPOFCNT register **/
#define ETH_MTLRXQMPOFCNT_OVFPKTCNT ((uint32_t)0x000007FFU) /* Overflow Packet Counter */
#define ETH_MTLRXQMPOFCNT_OVFCNTOVF ((uint32_t)0x00000800U) /* Overflow Counter Overflow Bit */
#define ETH_MTLRXQMPOFCNT_MISPKTCNT ((uint32_t)0x07FF0000U) /* Missed Packet Counter */
#define ETH_MTLRXQMPOFCNT_MISCNTOVF ((uint32_t)0x08000000U) /* Missed Packet Counter Overflow Bit */

/** Bit definition for ETH_MTLRXQDBG register **/
#define ETH_MTLRXQDBG_RWCSTS    ((uint32_t)0x00000001U) /* MTL Rx Queue Write Controller Active Status */
#define ETH_MTLRXQDBG_RRCSTS    ((uint32_t)0x00000006U) /* RRCSTS[1:0]: MTL Rx Queue Read Controller State */
#define ETH_MTLRXQDBG_RRCSTS_0  ((uint32_t)0x00000002U) /* RRCSTS bit 0 */
#define ETH_MTLRXQDBG_RRCSTS_1  ((uint32_t)0x00000004U) /* RRCSTS bit 1 */
#define ETH_MTLRXQDBG_RXQSTS    ((uint32_t)0x00000030U) /* RXQSTS[1:0]: MTL Rx Queue Fill-Level Status */
#define ETH_MTLRXQDBG_RXQSTS_0  ((uint32_t)0x00000010U) /* RXQSTS bit 0 */
#define ETH_MTLRXQDBG_RXQSTS_1  ((uint32_t)0x00000020U) /* RXQSTS bit 1 */
#define ETH_MTLRXQDBG_PRXQ      ((uint32_t)0x3FFF0000U) /* Number of Packets in Receive Queue */


/*** Ethernet DMA ***/

/** Bit definition for ETH_DMAMODE register **/
#define ETH_DMAMODE_SWR    ((uint32_t)0x00000001U) /* Software Reset */
#define ETH_DMAMODE_DA     ((uint32_t)0x00000002U) /* DMA Tx or Rx Arbitration Scheme */
#define ETH_DMAMODE_TXPR   ((uint32_t)0x00000800U) /* Transmit Priority */
#define ETH_DMAMODE_PR     ((uint32_t)0x00007000U) /* PR[2:0]: Priority Ratio */
#define ETH_DMAMODE_PR_0   ((uint32_t)0x00001000U) /* PR bit 0 */
#define ETH_DMAMODE_PR_1   ((uint32_t)0x00002000U) /* PR bit 1 */
#define ETH_DMAMODE_PR_2   ((uint32_t)0x00004000U) /* PR bit 2 */
#define ETH_DMAMODE_INTM   ((uint32_t)0x00030000U) /* INTM[1:0]: Interrupt Mode */
#define ETH_DMAMODE_INTM_0 ((uint32_t)0x00010000U) /* INTM bit 0 */
#define ETH_DMAMODE_INTM_1 ((uint32_t)0x00020000U) /* INTM bit 1 */

/** Bit definition for ETH_DMASBMODE register **/
#define ETH_DMASBMODE_FB  ((uint32_t)0x00000001U) /* Fixed Burst Length */
#define ETH_DMASBMODE_AAL ((uint32_t)0x00001000U) /* Address-Aligned Beats */
#define ETH_DMASBMODE_MB  ((uint32_t)0x00004000U) /* Mixed Burst */
#define ETH_DMASBMODE_RB  ((uint32_t)0x00008000U) /* Rebuild INCRx Burst */

/** Bit definition for ETH_DMAINTSTS register **/
#define ETH_DMAINTSTS_DC0IS ((uint32_t)0x00000001U) /* DMA Channel 0 Interrupt Status */
#define ETH_DMAINTSTS_MTLIS ((uint32_t)0x00010000U) /* MTL Interrupt Status */
#define ETH_DMAINTSTS_MACIS ((uint32_t)0x00020000U) /* MAC Interrupt Status */

/** Bit definition for ETH_DMADBGSTS register **/
#define ETH_DMADBGSTS_AHBMS  ((uint32_t)0x00000001U) /* AHB Master Status */
#define ETH_DMADBGSTS_RPS0   ((uint32_t)0x00000F00U) /* RPS0[3:0]: DMA Channel 0 Receive Process State */
#define ETH_DMADBGSTS_RPS0_0 ((uint32_t)0x00000100U) /* RPS0 bit 0 */
#define ETH_DMADBGSTS_RPS0_1 ((uint32_t)0x00000200U) /* RPS0 bit 1 */
#define ETH_DMADBGSTS_RPS0_2 ((uint32_t)0x00000400U) /* RPS0 bit 2 */
#define ETH_DMADBGSTS_RPS0_3 ((uint32_t)0x00000800U) /* RPS0 bit 3 */
#define ETH_DMADBGSTS_TPS0   ((uint32_t)0x0000F000U) /* TPS0[3:0]: DMA Channel 0 Transmit Process State */
#define ETH_DMADBGSTS_TPS0_0 ((uint32_t)0x00001000U) /* TPS0 bit 0 */
#define ETH_DMADBGSTS_TPS0_1 ((uint32_t)0x00002000U) /* TPS0 bit 1 */
#define ETH_DMADBGSTS_TPS0_2 ((uint32_t)0x00004000U) /* TPS0 bit 2 */
#define ETH_DMADBGSTS_TPS0_3 ((uint32_t)0x00008000U) /* TPS0 bit 3 */


/*** Ethernet DMA Channel 0 ***/

/** Bit definition for ETH_DMACH0CTRL register **/
#define ETH_DMACH0CTRL_PBLx8 ((uint32_t)0x00010000U) /* 8xPBL mode */
#define ETH_DMACH0CTRL_DSL   ((uint32_t)0x001C0000U) /* DSL[2:0]: Descriptor Skip Length */
#define ETH_DMACH0CTRL_DSL_0 ((uint32_t)0x00040000U) /* DSL bit 0 */
#define ETH_DMACH0CTRL_DSL_1 ((uint32_t)0x00080000U) /* DSL bit 1 */
#define ETH_DMACH0CTRL_DSL_2 ((uint32_t)0x00100000U) /* DSL bit 2 */

/** Bit definition for ETH_DMACH0TXCTRL register **/
#define ETH_DMACH0TXCTRL_ST      ((uint32_t)0x00000001U) /* Start or Stop Transmission Command */
#define ETH_DMACH0TXCTRL_OSF     ((uint32_t)0x00000010U) /* Operate on Second Packet */
#define ETH_DMACH0TXCTRL_TxPBL   ((uint32_t)0x003F0000U) /* TxPBL[5:0]: Transmit Programmable Burst Length */
#define ETH_DMACH0TXCTRL_TxPBL_0 ((uint32_t)0x00010000U) /* TxPBL bit 0 */
#define ETH_DMACH0TXCTRL_TxPBL_1 ((uint32_t)0x00020000U) /* TxPBL bit 1 */
#define ETH_DMACH0TXCTRL_TxPBL_2 ((uint32_t)0x00040000U) /* TxPBL bit 2 */
#define ETH_DMACH0TXCTRL_TxPBL_3 ((uint32_t)0x00080000U) /* TxPBL bit 3 */
#define ETH_DMACH0TXCTRL_TxPBL_4 ((uint32_t)0x00100000U) /* TxPBL bit 4 */
#define ETH_DMACH0TXCTRL_TxPBL_5 ((uint32_t)0x00200000U) /* TxPBL bit 5 */
#define ETH_DMACH0TXCTRL_ETIC    ((uint32_t)0x00400000U) /* Early Transmit Interrupt Control */

/** Bit definition for ETH_DMACH0RXCTRL register **/
#define ETH_DMACH0RXCTRL_SR      ((uint32_t)0x00000001U) /* Start or Stop Receive Command */
#define ETH_DMACH0RXCTRL_RBSZL   ((uint32_t)0x00000006U) /* Receive Buffer size Low */
#define ETH_DMACH0RXCTRL_RBSZH   ((uint32_t)0x00007FF8U) /* Receive Buffer size High */
#define ETH_DMACH0RXCTRL_RxPBL   ((uint32_t)0x003F0000U) /* RxPBL[5:0]: Receive Programmable Burst Length */
#define ETH_DMACH0RXCTRL_RxPBL_0 ((uint32_t)0x00010000U) /* RxPBL bit 0 */
#define ETH_DMACH0RXCTRL_RxPBL_1 ((uint32_t)0x00020000U) /* RxPBL bit 1 */
#define ETH_DMACH0RXCTRL_RxPBL_2 ((uint32_t)0x00040000U) /* RxPBL bit 2 */
#define ETH_DMACH0RXCTRL_RxPBL_3 ((uint32_t)0x00080000U) /* RxPBL bit 3 */
#define ETH_DMACH0RXCTRL_RxPBL_4 ((uint32_t)0x00100000U) /* RxPBL bit 4 */
#define ETH_DMACH0RXCTRL_RxPBL_5 ((uint32_t)0x00200000U) /* RxPBL bit 5 */
#define ETH_DMACH0RXCTRL_ERIC    ((uint32_t)0x00400000U) /* Early Receive Interrupt Control */
#define ETH_DMACH0RXCTRL_RPF     ((uint32_t)0x80000000U) /* Rx Packet Flush */

/** Bit definition for ETH_DMACH0TXDLA register **/
#define ETH_DMACH0TXDLA_TDESLA ((uint32_t)0xFFFFFFFCU) /* Start of Transmit List */

/** Bit definition for ETH_DMACH0RXDLA register **/
#define ETH_DMACH0RXDLA_RDESLA ((uint32_t)0xFFFFFFFCU) /* Start of Receive List */

/** Bit definition for ETH_DMACH0TXDTP register **/
#define ETH_DMACH0TXDTP_TDTP ((uint32_t)0xFFFFFFFCU) /* Transmit Descriptor Tail Pointer */

/** Bit definition for ETH_DMACH0RXDTP register **/
#define ETH_DMACH0RXDTP_RDTP ((uint32_t)0xFFFFFFFCU) /* Receive Descriptor Tail Pointer */

/** Bit definition for ETH_DMACH0TXDRLEN register **/
#define ETH_DMACH0TXDRLEN_TDRL ((uint32_t)0x000003FFU) /* Transmit Descriptor Ring Length */

/** Bit definition for ETH_DMACH0RXCTRL2 register **/
#define ETH_DMACH0RXCTRL2_RDRL ((uint32_t)0x000003FFU) /* Receive Descriptor Ring Length */
#define ETH_DMACH0RXCTRL2_ARBS ((uint32_t)0x00FF0000U) /* Alternate Receive Buffer Size */

/** Bit definition for ETH_DMACH0INTEN register **/
#define ETH_DMACH0INTEN_TIE  ((uint32_t)0x00000001U) /* Transmit Interrupt Enable */
#define ETH_DMACH0INTEN_TXSE ((uint32_t)0x00000002U) /* Transmit Stopped Enable */
#define ETH_DMACH0INTEN_TBUE ((uint32_t)0x00000004U) /* Transmit Buffer Unavailable Enable */
#define ETH_DMACH0INTEN_RIE  ((uint32_t)0x00000040U) /* Receive Interrupt Enable */
#define ETH_DMACH0INTEN_RBUE ((uint32_t)0x00000080U) /* Receive Buffer Unavailable Enable */
#define ETH_DMACH0INTEN_RSE  ((uint32_t)0x00000100U) /* Receive Stopped Enable */
#define ETH_DMACH0INTEN_RWTE ((uint32_t)0x00000200U) /* Receive Watchdog Timeout Enable */
#define ETH_DMACH0INTEN_ETIE ((uint32_t)0x00000400U) /* Early Transmit Interrupt Enable */
#define ETH_DMACH0INTEN_ERIE ((uint32_t)0x00000800U) /* Early Receive Interrupt Enable */
#define ETH_DMACH0INTEN_FBEE ((uint32_t)0x00001000U) /* Fatal Bus Error Enable */
#define ETH_DMACH0INTEN_CDEE ((uint32_t)0x00002000U) /* Context Descriptor Error Enable */
#define ETH_DMACH0INTEN_AIE  ((uint32_t)0x00004000U) /* Abnormal Interrupt Summary Enable */
#define ETH_DMACH0INTEN_NIE  ((uint32_t)0x00008000U) /* Normal Interrupt Summary Enable */

/** Bit definition for ETH_DMACH0RXINTWT register **/
#define ETH_DMACH0RXINTWT_RWT    ((uint32_t)0x000000FFU) /* Receive Interrupt Watchdog Timer Count */
#define ETH_DMACH0RXINTWT_RWTU   ((uint32_t)0x00030000U) /* RWTU[1:0]: Receive Interrupt Watchdog Timer \
                                                           Count Units */
#define ETH_DMACH0RXINTWT_RWTU_0 ((uint32_t)0x00010000U) /* RWTU bit 0 */
#define ETH_DMACH0RXINTWT_RWTU_1 ((uint32_t)0x00020000U) /* RWTU bit 1 */

/** Bit definition for ETH_DMACH0CATXD register **/
#define ETH_DMACH0CATXD_CURTDESAPTR ((uint32_t)0xFFFFFFFFU) /* Application Transmit Descriptor Address Pointer */

/** Bit definition for ETH_DMACH0CARXD register **/
#define ETH_DMACH0CARXD_CURRDESAPTR ((uint32_t)0xFFFFFFFFU) /* Application Receive Descriptor Address Pointer */

/** Bit definition for ETH_DMACH0CATXB register **/
#define ETH_DMACH0CATXB_CURTBUFAPTR ((uint32_t)0xFFFFFFFFU) /* Application Transmit Buffer Address Pointer */

/** Bit definition for ETH_DMACH0CARXB register **/
#define ETH_DMACH0CARXB_CURRBUFAPTR ((uint32_t)0xFFFFFFFFU) /* Application Receive Buffer Address Pointer */

/** Bit definition for ETH_DMACH0STS register **/
#define ETH_DMACH0STS_TI    ((uint32_t)0x00000001U) /* Transmit Interrupt */
#define ETH_DMACH0STS_TPS   ((uint32_t)0x00000002U) /* Transmit Process Stopped */
#define ETH_DMACH0STS_TBU   ((uint32_t)0x00000004U) /* Transmit Buffer Unavailable */
#define ETH_DMACH0STS_RI    ((uint32_t)0x00000040U) /* Receive Interrupt */
#define ETH_DMACH0STS_RBU   ((uint32_t)0x00000080U) /* Receive Buffer Unavailable */
#define ETH_DMACH0STS_RPS   ((uint32_t)0x00000100U) /* Receive Process Stopped */
#define ETH_DMACH0STS_RWT   ((uint32_t)0x00000200U) /* Receive Watchdog Timeout */
#define ETH_DMACH0STS_ETI   ((uint32_t)0x00000400U) /* Early Transmit Interrupt */
#define ETH_DMACH0STS_ERI   ((uint32_t)0x00000800U) /* Early Receive Interrupt */
#define ETH_DMACH0STS_FBE   ((uint32_t)0x00001000U) /* Fatal Bus Error */
#define ETH_DMACH0STS_CDE   ((uint32_t)0x00002000U) /* Context Descriptor Error */
#define ETH_DMACH0STS_AIS   ((uint32_t)0x00004000U) /* Abnormal Interrupt Summary */
#define ETH_DMACH0STS_NIS   ((uint32_t)0x00008000U) /* Normal Interrupt Summary */
#define ETH_DMACH0STS_TEB   ((uint32_t)0x00070000U) /* TEB[2:0]: Tx DMA Error Bits */
#define ETH_DMACH0STS_TEB_0 ((uint32_t)0x00010000U) /* TEB bit 0 */
#define ETH_DMACH0STS_TEB_1 ((uint32_t)0x00020000U) /* TEB bit 1 */
#define ETH_DMACH0STS_TEB_2 ((uint32_t)0x00040000U) /* TEB bit 2 */
#define ETH_DMACH0STS_REB   ((uint32_t)0x00380000U) /* REB[2:0]: Rx DMA Error Bits */
#define ETH_DMACH0STS_REB_0 ((uint32_t)0x00080000U) /* REB bit 0 */
#define ETH_DMACH0STS_REB_1 ((uint32_t)0x00100000U) /* REB bit 1 */
#define ETH_DMACH0STS_REB_2 ((uint32_t)0x00200000U) /* REB bit 2 */

/** Bit definition for ETH_DMACH0DPCNT register **/
#define ETH_DMACH0DPCNT_DPC  ((uint32_t)0x000007FFU) /* Dropped Packet Counters */
#define ETH_DMACH0DPCNT_DPCO ((uint32_t)0x00008000U) /* Overflow status of the DPC Counter */

/** Bit definition for ETH_DMACH0RXERICNT register **/
#define ETH_DMACH0RXERICNT_ECNT ((uint32_t)0x00000FFFU) /* ERI Counter */


/*** XSPI Registers ***/

/** Bit definition for XSPI_CTRL0 register **/
#define XSPI_CTRL0_DFS                              ((uint32_t)0x0000001FU) /* DFS[4:0] bits (Data Frame Size) */
#define XSPI_CTRL0_DFS_0                            ((uint32_t)0x00000001U) /* Bit 0 */
#define XSPI_CTRL0_DFS_1                            ((uint32_t)0x00000002U) /* Bit 1 */
#define XSPI_CTRL0_DFS_2                            ((uint32_t)0x00000004U) /* Bit 2 */
#define XSPI_CTRL0_DFS_3                            ((uint32_t)0x00000008U) /* Bit 3 */
#define XSPI_CTRL0_DFS_4                            ((uint32_t)0x00000010U) /* Bit 4 */
#define XSPI_CTRL0_DFS_4_BIT                        ((uint32_t)0x00000003U)
#define XSPI_CTRL0_DFS_5_BIT                        ((uint32_t)0x00000004U)
#define XSPI_CTRL0_DFS_6_BIT                        ((uint32_t)0x00000005U)
#define XSPI_CTRL0_DFS_7_BIT                        ((uint32_t)0x00000006U)
#define XSPI_CTRL0_DFS_8_BIT                        ((uint32_t)0x00000007U)
#define XSPI_CTRL0_DFS_9_BIT                        ((uint32_t)0x00000008U)
#define XSPI_CTRL0_DFS_10_BIT                       ((uint32_t)0x00000009U)
#define XSPI_CTRL0_DFS_11_BIT                       ((uint32_t)0x0000000AU)
#define XSPI_CTRL0_DFS_12_BIT                       ((uint32_t)0x0000000BU)
#define XSPI_CTRL0_DFS_13_BIT                       ((uint32_t)0x0000000CU)
#define XSPI_CTRL0_DFS_14_BIT                       ((uint32_t)0x0000000DU)
#define XSPI_CTRL0_DFS_15_BIT                       ((uint32_t)0x0000000EU)
#define XSPI_CTRL0_DFS_16_BIT                       ((uint32_t)0x0000000FU)
#define XSPI_CTRL0_DFS_17_BIT                       ((uint32_t)0x00000010U)
#define XSPI_CTRL0_DFS_18_BIT                       ((uint32_t)0x00000011U)
#define XSPI_CTRL0_DFS_19_BIT                       ((uint32_t)0x00000012U)
#define XSPI_CTRL0_DFS_20_BIT                       ((uint32_t)0x00000013U)
#define XSPI_CTRL0_DFS_21_BIT                       ((uint32_t)0x00000014U)
#define XSPI_CTRL0_DFS_22_BIT                       ((uint32_t)0x00000015U)
#define XSPI_CTRL0_DFS_23_BIT                       ((uint32_t)0x00000016U)
#define XSPI_CTRL0_DFS_24_BIT                       ((uint32_t)0x00000017U)
#define XSPI_CTRL0_DFS_25_BIT                       ((uint32_t)0x00000018U)
#define XSPI_CTRL0_DFS_26_BIT                       ((uint32_t)0x00000019U)
#define XSPI_CTRL0_DFS_27_BIT                       ((uint32_t)0x0000001AU)
#define XSPI_CTRL0_DFS_28_BIT                       ((uint32_t)0x0000001BU)
#define XSPI_CTRL0_DFS_29_BIT                       ((uint32_t)0x0000001CU)
#define XSPI_CTRL0_DFS_30_BIT                       ((uint32_t)0x0000001DU)
#define XSPI_CTRL0_DFS_31_BIT                       ((uint32_t)0x0000001EU)
#define XSPI_CTRL0_DFS_32_BIT                       ((uint32_t)0x0000001FU)

#define XSPI_CTRL0_FRF                              ((uint32_t)0x000000C0U) /* FRF[1:0] bits (Frame Format) */
#define XSPI_CTRL0_FRF_0                            ((uint32_t)0x00000040U) /* Bit 0 */
#define XSPI_CTRL0_FRF_1                            ((uint32_t)0x00000080U) /* Bit 1 */
#define XSPI_CTRL0_FRF_MOTOROLA                     ((uint32_t)0x00000000U)
#define XSPI_CTRL0_FRF_TI                           ((uint32_t)0x00000040U)
#define XSPI_CTRL0_FRF_MICROWIRE                    ((uint32_t)0x00000080U)

#define XSPI_CTRL0_SCPH                             ((uint32_t)0x00000100U) /* SCPH (Serial Clock Phase) */
#define XSPI_CTRL0_SCPH_FIRST_EDGE                  ((uint32_t)0x00000000U)
#define XSPI_CTRL0_SCPH_SECOND_EDGE                 ((uint32_t)0x00000100U)

#define XSPI_CTRL0_SCPOL                            ((uint32_t)0x00000200U) /* SCPOL(Serial Clock Polarity) */
#define XSPI_CTRL0_SCPOL_LOW                        ((uint32_t)0x00000000U)
#define XSPI_CTRL0_SCPOL_HIGH                       ((uint32_t)0x00000200U)

#define XSPI_CTRL0_TMOD                             ((uint32_t)0x00000C00U) /* TMOD[1:0] bits (Transfer Mode) */
#define XSPI_CTRL0_TMOD_0                           ((uint32_t)0x00000400U) /* Bit 0 */
#define XSPI_CTRL0_TMOD_1                           ((uint32_t)0x00000800U) /* Bit 1 */
#define XSPI_CTRL0_TMOD_TX_AND_RX                   ((uint32_t)0x00000000U)
#define XSPI_CTRL0_TMOD_TX_ONLY                     ((uint32_t)0x00000400U)
#define XSPI_CTRL0_TMOD_RX_ONLY                     ((uint32_t)0x00000800U)
#define XSPI_CTRL0_TMOD_EEPROM_READ                 ((uint32_t)0x00000C00U)

#define XSPI_CTRL0_SLVOE                            ((uint32_t)0x00001000U) /* SLV (Slave Output Enable) */
#define XSPI_CTRL0_SRL_EN                           ((uint32_t)0x00002000U) /* SRL (Shift Register Loop) */
#define XSPI_CTRL0_SSTE_EN                          ((uint32_t)0x00004000U) /* SSTE(Slave Select Toggle Enable) */

#define XSPI_CTRL0_CFS                              ((uint32_t)0x000F0000U) /* CFS[3:0] bits (Control Frame Size) */
#define XSPI_CTRL0_CFS_0                            ((uint32_t)0x00010000U) /* Bit 0 */
#define XSPI_CTRL0_CFS_1                            ((uint32_t)0x00020000U) /* Bit 1 */
#define XSPI_CTRL0_CFS_2                            ((uint32_t)0x00040000U) /* Bit 2 */
#define XSPI_CTRL0_CFS_3                            ((uint32_t)0x00080000U) /* Bit 3 */
#define XSPI_CTRL0_CFS_1_BIT                        ((uint32_t)0x00000000U)
#define XSPI_CTRL0_CFS_2_BIT                        ((uint32_t)0x00010000U)
#define XSPI_CTRL0_CFS_3_BIT                        ((uint32_t)0x00020000U)
#define XSPI_CTRL0_CFS_4_BIT                        ((uint32_t)0x00030000U)
#define XSPI_CTRL0_CFS_5_BIT                        ((uint32_t)0x00040000U)
#define XSPI_CTRL0_CFS_6_BIT                        ((uint32_t)0x00050000U)
#define XSPI_CTRL0_CFS_7_BIT                        ((uint32_t)0x00060000U)
#define XSPI_CTRL0_CFS_8_BIT                        ((uint32_t)0x00070000U)
#define XSPI_CTRL0_CFS_9_BIT                        ((uint32_t)0x00080000U)
#define XSPI_CTRL0_CFS_10_BIT                       ((uint32_t)0x00090000U)
#define XSPI_CTRL0_CFS_11_BIT                       ((uint32_t)0x000A0000U)
#define XSPI_CTRL0_CFS_12_BIT                       ((uint32_t)0x000B0000U)
#define XSPI_CTRL0_CFS_13_BIT                       ((uint32_t)0x000C0000U)
#define XSPI_CTRL0_CFS_14_BIT                       ((uint32_t)0x000D0000U)
#define XSPI_CTRL0_CFS_15_BIT                       ((uint32_t)0x000E0000U)
#define XSPI_CTRL0_CFS_16_BIT                       ((uint32_t)0x000F0000U)

#define XSPI_CTRL0_SPIFRF                          ((uint32_t)0x00C00000U) /* SPIFRF[1:0] bits (SPI Frame Format) */
#define XSPI_CTRL0_SPIFRF_0                        ((uint32_t)0x00400000U) /* Bit 0 */
#define XSPI_CTRL0_SPIFRF_1                        ((uint32_t)0x00800000U) /* Bit 1 */

#define XSPI_CTRL0_SPIFRF_STANDARD_FORMAT          ((uint32_t)0x00000000U)
#define XSPI_CTRL0_SPIFRF_DUAL_FORMAT              ((uint32_t)0x00400000U)
#define XSPI_CTRL0_SPIFRF_QUAD_FORMAT              ((uint32_t)0x00800000U)
#define XSPI_CTRL0_SPIFRF_OCTAL_FORMAT             ((uint32_t)0x00C00000U)

#define XSPI_CTRL0_DWSEN                                   ((uint32_t)0x02000000U) /* Dynamic wait states */
#define XSPI_CTRL0_MST                                   ((uint32_t)0x80000000U) /* Selects if xspi is working in Master or Slave mode */

/** Bit definition for XSPI_CTRL1 register **/
#define XSPI_CTRL1_NDF                              ((uint32_t)0x0000FFFFU) /* NDF[15:0] bits (Numver of Data Frames) */
#define XSPI_CTRL1_NDF_0                            ((uint32_t)0x00000001U) /* Bit 0 */
#define XSPI_CTRL1_NDF_1                            ((uint32_t)0x00000002U) /* Bit 1 */
#define XSPI_CTRL1_NDF_2                            ((uint32_t)0x00000004U) /* Bit 2 */
#define XSPI_CTRL1_NDF_3                            ((uint32_t)0x00000008U) /* Bit 3 */
#define XSPI_CTRL1_NDF_4                            ((uint32_t)0x00000010U) /* Bit 4 */
#define XSPI_CTRL1_NDF_5                            ((uint32_t)0x00000020U) /* Bit 5 */
#define XSPI_CTRL1_NDF_6                            ((uint32_t)0x00000040U) /* Bit 6 */
#define XSPI_CTRL1_NDF_7                            ((uint32_t)0x00000080U) /* Bit 7 */
#define XSPI_CTRL1_NDF_8                            ((uint32_t)0x00000100U) /* Bit 8 */
#define XSPI_CTRL1_NDF_9                            ((uint32_t)0x00000200U) /* Bit 9 */
#define XSPI_CTRL1_NDF_10                           ((uint32_t)0x00000400U) /* Bit 10 */
#define XSPI_CTRL1_NDF_11                           ((uint32_t)0x00000800U) /* Bit 11 */
#define XSPI_CTRL1_NDF_12                           ((uint32_t)0x00001000U) /* Bit 12 */
#define XSPI_CTRL1_NDF_13                           ((uint32_t)0x00002000U) /* Bit 13 */
#define XSPI_CTRL1_NDF_14                           ((uint32_t)0x00004000U) /* Bit 14 */
#define XSPI_CTRL1_NDF_15                           ((uint32_t)0x00008000U) /* Bit 15 */

/** Bit definition for XSPI_EN_XSPIEN register **/
#define XSPI_EN_XSPIEN                              ((uint32_t)0x00000001U) /* XSPIEN (XSPI Enable) */

/** Bit definition for XSPI_MW_CTRL register **/
#define XSPI_MW_CTRL_MWMOD                          ((uint32_t)0x00000001U) /* MWMO (Microwire Transfer Mode) */
#define XSPI_MW_CTRL_MWMOD_UNSEQUENTIAL             ((uint32_t)0x00000000U)
#define XSPI_MW_CTRL_MWMOD_SEQUENTIAL               ((uint32_t)0x00000001U)

#define XSPI_MW_CTRL_MCDIR                          ((uint32_t)0x00000002U) /* MCDIR (Direction of Data when Microwire Control) */
#define XSPI_MW_CTRL_MCDIR_RX                       ((uint32_t)0x00000000U)
#define XSPI_MW_CTRL_MCDIR_TX                       ((uint32_t)0x00000002U)

#define XSPI_MW_CTRL_MHSEN                          ((uint32_t)0x00000004U) /* MHSEN (Microwire Handshaking Enable) */

/** Bit definition for XSPI_SLAVE_EN register **/
#define XSPI_SLAVE_EN_SEN                            ((uint32_t)0x00000003U) /* SEN (Slave Enable) */
#define XSPI_SLAVE_EN_SEN_0                          ((uint32_t)0x00000001U) /* bit0*/
#define XSPI_SLAVE_EN_SEN_1                          ((uint32_t)0x00000002U) /* bit1 */

/** Bit definition for XSPI_BAUD register **/
#define XSPI_BAUD_CLKDIV                           ((uint32_t)0x0000FFFEU) /* CLKDIV[15:1] (Clock Divider) */
#define XSPI_BAUD_CLKDIV_0                         ((uint32_t)0x00000002U) /* Bit 0*/
#define XSPI_BAUD_CLKDIV_1                         ((uint32_t)0x00000004U) /* Bit 1 */
#define XSPI_BAUD_CLKDIV_2                         ((uint32_t)0x00000008U) /* Bit 2 */
#define XSPI_BAUD_CLKDIV_3                         ((uint32_t)0x00000010U) /* Bit 3 */
#define XSPI_BAUD_CLKDIV_4                         ((uint32_t)0x00000020U) /* Bit 4 */
#define XSPI_BAUD_CLKDIV_5                         ((uint32_t)0x00000040U) /* Bit 5 */
#define XSPI_BAUD_CLKDIV_6                         ((uint32_t)0x00000080U) /* Bit 6 */
#define XSPI_BAUD_CLKDIV_7                         ((uint32_t)0x00000100U) /* Bit 7 */
#define XSPI_BAUD_CLKDIV_8                         ((uint32_t)0x00000200U) /* Bit 8 */
#define XSPI_BAUD_CLKDIV_9                         ((uint32_t)0x00000400U) /* Bit 9 */
#define XSPI_BAUD_CLKDIV_10                        ((uint32_t)0x00000800U) /* Bit 10 */
#define XSPI_BAUD_CLKDIV_11                        ((uint32_t)0x00001000U) /* Bit 11 */
#define XSPI_BAUD_CLKDIV_12                        ((uint32_t)0x00002000U) /* Bit 12 */
#define XSPI_BAUD_CLKDIV_13                        ((uint32_t)0x00004000U) /* Bit 13 */
#define XSPI_BAUD_CLKDIV_14                        ((uint32_t)0x00008000U) /* Bit 14 */

/** Bit definition for XSPI_TXFT register **/
#define XSPI_TXFTST                                ((uint32_t)0x0000000FU) /* TXFTST[3:0] (Transmit FIFO Threshold to Start to Transfer) */
#define XSPI_TXFTST_0                              ((uint32_t)0x00000001U) /* Bit 0 */
#define XSPI_TXFTST_1                              ((uint32_t)0x00000002U) /* Bit 1 */
#define XSPI_TXFTST_2                              ((uint32_t)0x00000004U) /* Bit 2 */
#define XSPI_TXFTST_3                              ((uint32_t)0x00000008U) /* Bit 3 */

#define XSPI_TXFTTEI                               ((uint32_t)0x0000000FU) /* TXFTTEI[3:0] (Transmit FIFO Threshold to Trigger Empty Interrupt) */
#define XSPI_TXFTTEI_0                             ((uint32_t)0x00000001U) /* Bit 0 */
#define XSPI_TXFTTEI_1                             ((uint32_t)0x00000002U) /* Bit 1 */
#define XSPI_TXFTTEI_2                             ((uint32_t)0x00000004U) /* Bit 2 */
#define XSPI_TXFTTEI_3                             ((uint32_t)0x00000008U) /* Bit 3 */

/** Bit definition for XSPI_RXFT register **/
#define XSPI_RXFTTFI                               ((uint32_t)0x0000000FU) /* RXFTTFI[3:0] (Receive FIFO Threshold to Trigger Full Interrupt) */
#define XSPI_RXFTTFI_0                             ((uint32_t)0x00000001U) /* Bit 0 */
#define XSPI_RXFTTFI_1                             ((uint32_t)0x00000002U) /* Bit 1 */
#define XSPI_RXFTTFI_2                             ((uint32_t)0x00000004U) /* Bit 2 */
#define XSPI_RXFTTFI_3                             ((uint32_t)0x00000008U) /* Bit 3 */

/** Bit definition for XSPI_TXFN register **/
#define XSPI_TXFN                                   ((uint32_t)0x0000001FU) /* TXFN[4:0] (Numver of Transmit FIFO) */
#define XSPI_TXFN_0                                 ((uint32_t)0x00000001U) /* Bit 0 */
#define XSPI_TXFN_1                                 ((uint32_t)0x00000002U) /* Bit 1 */
#define XSPI_TXFN_2                                 ((uint32_t)0x00000004U) /* Bit 2 */
#define XSPI_TXFN_3                                 ((uint32_t)0x00000008U) /* Bit 3 */
#define XSPI_TXFN_4                                 ((uint32_t)0x00000010U) /* Bit 4 */

/** Bit definition for XSPI_RXFN register **/
#define XSPI_RXFN                                   ((uint32_t)0x0000001FU) /* RXFN[4:0] (Numver of Receive FIFO) */
#define XSPI_RXFN_0                                 ((uint32_t)0x00000001U) /* Bit 0 */
#define XSPI_RXFN_1                                 ((uint32_t)0x00000002U) /* Bit 1 */
#define XSPI_RXFN_2                                 ((uint32_t)0x00000004U) /* Bit 2 */
#define XSPI_RXFN_3                                 ((uint32_t)0x00000008U) /* Bit 3 */
#define XSPI_RXFN_4                                 ((uint32_t)0x00000010U) /* Bit 4 */

/** Bit definition for XSPI_STS register **/
#define XSPI_STS                                    ((uint32_t)0x0000007FU) /* STS[6:0] (status flag) */
#define XSPI_STS_BUSY                               ((uint32_t)0x00000001U) /* BUSY (Transfer Busy Flag) */
#define XSPI_STS_TXFNF                              ((uint32_t)0x00000002U) /* TXFNF (Transmit FIFO not Full) */
#define XSPI_STS_TXFE                               ((uint32_t)0x00000004U) /* TXFE (Transmit FIFO not Empty) */
#define XSPI_STS_RXFNE                              ((uint32_t)0x00000008U) /* RXFNE (Receive FIFO not Empty) */
#define XSPI_STS_RXFF                               ((uint32_t)0x00000010U) /* RXFF (Receive FIFO not Full) */
#define XSPI_STS_TXE                                ((uint32_t)0x00000020U) /* TXE (Transmit FIFO error */
#define XSPI_STS_DCERR                              ((uint32_t)0x00000040U) /* DCERR (Data Conflict Error) */

#define XSPI_STS_CMPLTDF                              ((uint32_t)0x00001FFFF) /* NDF[15:0] bits (Numver of Data Frames) */
#define XSPI_STS_CMPLTDF_0                            ((uint32_t)0x00008000U) /* Bit 0 */
#define XSPI_STS_CMPLTDF_1                            ((uint32_t)0x00010000U) /* Bit 1 */
#define XSPI_STS_CMPLTDF_2                            ((uint32_t)0x00020000U) /* Bit 2 */
#define XSPI_STS_CMPLTDF_3                            ((uint32_t)0x00040000U) /* Bit 3 */
#define XSPI_STS_CMPLTDF_4                            ((uint32_t)0x00080000U) /* Bit 4 */
#define XSPI_STS_CMPLTDF_5                            ((uint32_t)0x00100000U) /* Bit 5 */
#define XSPI_STS_CMPLTDF_6                            ((uint32_t)0x00200000U) /* Bit 6 */
#define XSPI_STS_CMPLTDF_7                            ((uint32_t)0x00400000U) /* Bit 7 */
#define XSPI_STS_CMPLTDF_8                            ((uint32_t)0x00800000U) /* Bit 8 */
#define XSPI_STS_CMPLTDF_9                            ((uint32_t)0x01000000U) /* Bit 9 */
#define XSPI_STS_CMPLTDF_10                           ((uint32_t)0x02000000U) /* Bit 10 */
#define XSPI_STS_CMPLTDF_11                           ((uint32_t)0x04000000U) /* Bit 11 */
#define XSPI_STS_CMPLTDF_12                           ((uint32_t)0x08000000U) /* Bit 12 */
#define XSPI_STS_CMPLTDF_13                           ((uint32_t)0x10000000U) /* Bit 13 */
#define XSPI_STS_CMPLTDF_14                           ((uint32_t)0x20000000U) /* Bit 14 */
#define XSPI_STS_CMPLTDF_15                           ((uint32_t)0x40000000U) /* Bit 15 */
#define XSPI_STS_CMPLTDF_16                           ((uint32_t)0x80000000U) /* Bit 16 */

/** Bit definition for XSPI_IMASK register **/
#define XSPI_IMASK                                  ((uint32_t)0x0000007FU) /* IMASK[6:0] (Interrupt of Mask) */
#define XSPI_IMASK_TXFEIM                           ((uint32_t)0x00000001U) /* TXFEIM (Transmit FIFO Empty Interrupt Mask) */
#define XSPI_IMASK_TXFOIM                           ((uint32_t)0x00000002U) /* TXFOIM (Transmit FIFO Overflow Interrupt Mask) */
#define XSPI_IMASK_RXFUIM                           ((uint32_t)0x00000004U) /* RXFUIM (Receive FIFO Underflow Interrupt Mask) */
#define XSPI_IMASK_RXFOIM                           ((uint32_t)0x00000008U) /* RXFOIM (Receive FIFO Overflow Interrupt Mask) */
#define XSPI_IMASK_RXFFIM                           ((uint32_t)0x00000010U) /* RXFFIM (Receive FIFO Full Interrupt Mask) */
#define XSPI_IMASK_MMCIM                            ((uint32_t)0x00000020U) /* MMCIM (Multi-Master Contention Interrupt Mask) */
#define XSPI_IMASK_XRXOIM                           ((uint32_t)0x00000040U) /* XRXOIM (XIP Receive FIFO Overflow Interrupt Mask) */
#define XSPI_IMASK_TXUIM                            ((uint32_t)0x00000080U) /* TXUIM (Transmit FIFO Underflow Interrupt Mask) */

/** Bit definition for XSPI_ISTS register **/
#define XSPI_ISTS                                  ((uint32_t)0x0000007FU) /* All bits of interrupt stasus */
#define XSPI_ISTS_TXFEIS                           ((uint32_t)0x00000001U) /* TXFEIS (Transmit FIFO Empty Interrupt Stasus) */
#define XSPI_ISTS_TXFOIS                           ((uint32_t)0x00000002U) /* TXFOIS (Transmit FIFO Overflow Interrupt Stasus) */
#define XSPI_ISTS_RXFUIS                           ((uint32_t)0x00000004U) /* RXFUIS (Receive FIFO Underflow Interrupt Stasus) */
#define XSPI_ISTS_RXFOIS                           ((uint32_t)0x00000008U) /* RXFOIS (Receive FIFO Overflow Interrupt Stasus) */
#define XSPI_ISTS_RXFFIS                           ((uint32_t)0x00000010U) /* RXFFIS (Receive FIFO Full Interrupt Stasus) */
#define XSPI_ISTS_MMCIS                            ((uint32_t)0x00000020U) /* MMCIS (Multi-Master Contention Interrupt Stasus) */
#define XSPI_ISTS_XRXOIS                           ((uint32_t)0x00000040U) /* XRXOIS (XIP Receive FIFO Overflow Interrupt Stasus) */
#define XSPI_ISTS_TXUIS                            ((uint32_t)0x00000080U) /* TXUIS (Transmit FIFO Underflow Interrupt Status) */

/** Bit definition for XSPI_RISTS register **/
#define XSPI_RISTS                                  ((uint32_t)0x0000007FU) /* All bits of raw interrupt stasus */
#define XSPI_RISTS_TXFERIS                          ((uint32_t)0x00000001U) /* TXFERIS (Transmit FIFO Empty Raw Interrupt Stasus) */
#define XSPI_RISTS_TXFORIS                          ((uint32_t)0x00000002U) /* TXFORIS (Transmit FIFO Overflow Raw Interrupt Stasus) */
#define XSPI_RISTS_RXFURIS                          ((uint32_t)0x00000004U) /* RXFURIS (Receive FIFO Underflow Raw Interrupt Stasus) */
#define XSPI_RISTS_RXFORIS                          ((uint32_t)0x00000008U) /* RXFORIS (Receive FIFO Overflow Raw Interrupt Stasus) */
#define XSPI_RISTS_RXFFRIS                          ((uint32_t)0x00000010U) /* RXFFRIS (Receive FIFO Full Raw Interrupt Stasus) */
#define XSPI_RISTS_MMCRIS                           ((uint32_t)0x00000020U) /* MMCRIS (Multi-Master Contention Raw Interrupt Stasus) */
#define XSPI_RISTS_XRXORIS                          ((uint32_t)0x00000040U) /* XRXORIS (XIP Receive FIFO Overflow Raw Interrupt Stasus) */
#define XSPI_RISTS_TXUR                               ((uint32_t)0x00000080U) /* TXUIR (Transmit FIFO Underflow Interrupt Raw Status) */

/** Bit definition for XSPI_TXFOI_CLR register **/
#define XSPI_TXFOI_CLR_TXEICR                       ((uint32_t)0x00000001U) /* TXEICR_CLR (Clear Transmit FIFO Overflow/Underflow Interrupt) */

/** Bit definition for XSPI_RXFOI_CLR register **/
#define XSPI_RXFOI_CLR_RXFOIC                       ((uint32_t)0x00000001U) /* RXFOIC (Clear Receive FIFO Overflow Interrupt) */

/** Bit definition for XSPI_RXFUI_CLR register **/
#define XSPI_RXFUI_CLR_RXFUIC                       ((uint32_t)0x00000001U) /* RXFUIC (Clear Receive FIFO Underflow Interrupt) */

/** Bit definition for XSPI_MMCI_CLR register **/
#define XSPI_MMCI_CLR_MMCIC                         ((uint32_t)0x00000001U) /* MMCIC (Clear Multi-Master Contention Interrupt) */

/** Bit definition for XSPI_ICLR register **/
#define XSPI_ICLR_INTC                              ((uint32_t)0x00000001U) /* INTC (Clear Interrupts) */

/** Bit definition for XSPI_DMA_CTRL register **/
#define XSPI_DMA_CTRL_RXDMAEN                     ((uint32_t)0x00000001U) /* RXDMAEN (Receive DMA Enable) */
#define XSPI_DMA_CTRL_TXDMAEN                     ((uint32_t)0x00000002U) /* TXDMAEN (Transmit DMA Enable) */

/** Bit definition for XSPI_DMATDL_CTRL register **/
#define XSPI_DMATDL_CTRL_DMATDL                     ((uint32_t)0x0000000FU) /* DMATDL[3:0] (DMA Transmit Data Level) */
#define XSPI_DMATDL_CTRL_DMATDL_0                   ((uint32_t)0x00000001U) /* Bit 0 */
#define XSPI_DMATDL_CTRL_DMATDL_1                   ((uint32_t)0x00000002U) /* Bit 1 */
#define XSPI_DMATDL_CTRL_DMATDL_2                   ((uint32_t)0x00000004U) /* Bit 2 */
#define XSPI_DMATDL_CTRL_DMATDL_3                   ((uint32_t)0x00000008U) /* Bit 3 */


/** Bit definition for XSPI_DMARDL_CTRL register **/
#define XSPI_DMARDL_CTRL_DMARDL                     ((uint32_t)0x0000000FU) /* DMARDL[3:0] (DMA Receive Data Level) */
#define XSPI_DMARDL_CTRL_DMARDL_0                   ((uint32_t)0x00000001U) /* Bit 0 */
#define XSPI_DMARDL_CTRL_DMARDL_1                   ((uint32_t)0x00000002U) /* Bit 1 */
#define XSPI_DMARDL_CTRL_DMARDL_2                   ((uint32_t)0x00000004U) /* Bit 2 */
#define XSPI_DMARDL_CTRL_DMARDL_3                   ((uint32_t)0x00000008U) /* Bit 3 */

/** Bit definition for XSPI_IDR register **/
#define XSPI_IDR_IDCODE                             ((uint32_t)0xFFFF3621U) /* IDCOSE (Identification code) */

/** Bit definition for XSPI_ VERSION_ID register **/
#define XSPI_VERSION_ID_VERSION                     ((uint32_t)0x3130332AU) /* VERSION(Contains the hex representation of the Synopsys component version) */


/** Bit definition for XSPI_DAT0~XSPI_DAT31 register **/
#define XSPI_DATA_ALL                               ((uint32_t)0x0000FFFFU) /* XSPI_DAT[31:0] (DATA Register) */
#define XSPI_DATA_0                                 ((uint32_t)0x00000001U) /* Bit 0 */
#define XSPI_DATA_1                                 ((uint32_t)0x00000002U) /* Bit 1 */
#define XSPI_DATA_2                                 ((uint32_t)0x00000004U) /* Bit 2 */
#define XSPI_DATA_3                                 ((uint32_t)0x00000008U) /* Bit 3 */
#define XSPI_DATA_4                                 ((uint32_t)0x00000010U) /* Bit 4 */
#define XSPI_DATA_5                                 ((uint32_t)0x00000020U) /* Bit 5 */
#define XSPI_DATA_6                                 ((uint32_t)0x00000040U) /* Bit 6 */
#define XSPI_DATA_7                                 ((uint32_t)0x00000080U) /* Bit 7 */
#define XSPI_DATA_8                                 ((uint32_t)0x00000100U) /* Bit 8 */
#define XSPI_DATA_9                                 ((uint32_t)0x00000200U) /* Bit 9 */
#define XSPI_DATA_10                                ((uint32_t)0x00000400U) /* Bit 10 */
#define XSPI_DATA_11                                ((uint32_t)0x00000800U) /* Bit 11 */
#define XSPI_DATA_12                                ((uint32_t)0x00001000U) /* Bit 12 */
#define XSPI_DATA_13                                ((uint32_t)0x00002000U) /* Bit 13 */
#define XSPI_DATA_14                                ((uint32_t)0x00004000U) /* Bit 14 */
#define XSPI_DATA_15                                ((uint32_t)0x00008000U) /* Bit 15 */
#define XSPI_DATA_16                                ((uint32_t)0x00010000U) /* Bit 16 */
#define XSPI_DATA_17                                ((uint32_t)0x00020000U) /* Bit 17 */
#define XSPI_DATA_18                                ((uint32_t)0x00040000U) /* Bit 18 */
#define XSPI_DATA_19                                ((uint32_t)0x00080000U) /* Bit 19 */
#define XSPI_DATA_20                                ((uint32_t)0x00100000U) /* Bit 20 */
#define XSPI_DATA_21                                ((uint32_t)0x00200000U) /* Bit 21 */
#define XSPI_DATA_22                                ((uint32_t)0x00400000U) /* Bit 22 */
#define XSPI_DATA_23                                ((uint32_t)0x00800000U) /* Bit 23 */
#define XSPI_DATA_24                                ((uint32_t)0x01000000U) /* Bit 24 */
#define XSPI_DATA_25                                ((uint32_t)0x02000000U) /* Bit 25 */
#define XSPI_DATA_26                                ((uint32_t)0x04000000U) /* Bit 26 */
#define XSPI_DATA_27                                ((uint32_t)0x08000000U) /* Bit 27 */
#define XSPI_DATA_28                                ((uint32_t)0x10000000U) /* Bit 28 */
#define XSPI_DATA_29                                ((uint32_t)0x20000000U) /* Bit 29 */
#define XSPI_DATA_30                                ((uint32_t)0x40000000U) /* Bit 30 */
#define XSPI_DATA_31                                ((uint32_t)0x80000000U) /* Bit 31 */

/** Bit definition for XSPI_RX_DELAY register **/
#define XSPI_RX_DELAY_SDCN                          ((uint32_t)0x000000FFU) /* SDCN[7:0] (Sample Delay Cycle Number) */
#define XSPI_RX_DELAY_SDCN_0                        ((uint32_t)0x00000001U) /* Bit 0 */
#define XSPI_RX_DELAY_SDCN_1                        ((uint32_t)0x00000002U) /* Bit 1 */
#define XSPI_RX_DELAY_SDCN_2                        ((uint32_t)0x00000004U) /* Bit 2 */
#define XSPI_RX_DELAY_SDCN_3                        ((uint32_t)0x00000008U) /* Bit 3 */
#define XSPI_RX_DELAY_SDCN_4                        ((uint32_t)0x00000010U) /* Bit 4 */
#define XSPI_RX_DELAY_SDCN_5                        ((uint32_t)0x00000020U) /* Bit 5 */
#define XSPI_RX_DELAY_SDCN_6                        ((uint32_t)0x00000040U) /* Bit 6 */
#define XSPI_RX_DELAY_SDCN_7                        ((uint32_t)0x00000080U) /* Bit 7 */
#define XSPI_RX_DELAY_SDCN_0_CYCLES                 ((uint32_t)0x00000000U)
#define XSPI_RX_DELAY_SDCN_1_CYCLES                 ((uint32_t)0x00000001U)
#define XSPI_RX_DELAY_SDCN_2_CYCLES                 ((uint32_t)0x00000002U)
#define XSPI_RX_DELAY_SDCN_3_CYCLES                 ((uint32_t)0x00000003U)
#define XSPI_RX_DELAY_SDCN_4_CYCLES                 ((uint32_t)0x00000004U)
#define XSPI_RX_DELAY_SDCN_5_CYCLES                 ((uint32_t)0x00000005U)
#define XSPI_RX_DELAY_SDCN_6_CYCLES                 ((uint32_t)0x00000006U)

#define XSPI_RX_DELAY_SES                           ((uint32_t)0x00010000U) /* SES (Sample Edge Select of Receive Data) */
#define XSPI_RX_DELAY_SES_RISING_EDGE               ((uint32_t)0x00000000U)
#define XSPI_RX_DELAY_SES_FALLING_EDGE              ((uint32_t)0x00010000U)

/** Bit definition for XSPI_ENH_CTRL0 register **/
#define XSPI_ENH_CTRL0_TRANSTYPE                   ((uint32_t)0x00000003U) /* TRANSTYPE[1:0] (Address and instruction transfer format) */
#define XSPI_ENH_CTRL0_TRANSTYPE_0                 ((uint32_t)0x00000001U) /* Bit 0 */
#define XSPI_ENH_CTRL0_TRANSTYPE_1                 ((uint32_t)0x00000002U) /* Bit 1 */
#define XSPI_ENH_CTRL0_TRANSTYPE_STANDARD          ((uint32_t)0x00000000U)
#define XSPI_ENH_CTRL0_TRANSTYPE_ADDRESS_BY_FRF    ((uint32_t)0x00000001U)
#define XSPI_ENH_CTRL0_TRANSTYPE_ALL_BY_FRF        ((uint32_t)0x00000002U)

#define XSPI_ENH_CTRL0_ADDRLEN                     ((uint32_t)0x0000003CU) /* ADDRLEN[3:0] (Length of Address to transmit) */
#define XSPI_ENH_CTRL0_ADDRLEN_0                   ((uint32_t)0x00000004U) /* Bit 0 */
#define XSPI_ENH_CTRL0_ADDRLEN_1                   ((uint32_t)0x00000008U) /* Bit 1 */
#define XSPI_ENH_CTRL0_ADDRLEN_2                   ((uint32_t)0x00000010U) /* Bit 2 */
#define XSPI_ENH_CTRL0_ADDRLEN_3                   ((uint32_t)0x00000020U) /* Bit 3 */
#define XSPI_ENH_CTRL0_ADDRLEN_4_BIT               ((uint32_t)0x00000004U)
#define XSPI_ENH_CTRL0_ADDRLEN_8_BIT               ((uint32_t)0x00000008U)
#define XSPI_ENH_CTRL0_ADDRLEN_12_BIT              ((uint32_t)0x0000000CU)
#define XSPI_ENH_CTRL0_ADDRLEN_16_BIT              ((uint32_t)0x00000010U)
#define XSPI_ENH_CTRL0_ADDRLEN_20_BIT              ((uint32_t)0x00000014U)
#define XSPI_ENH_CTRL0_ADDRLEN_24_BIT              ((uint32_t)0x00000018U)
#define XSPI_ENH_CTRL0_ADDRLEN_28_BIT              ((uint32_t)0x0000001CU)
#define XSPI_ENH_CTRL0_ADDRLEN_32_BIT              ((uint32_t)0x00000020U)
#define XSPI_ENH_CTRL0_ADDRLEN_36_BIT              ((uint32_t)0x00000024U)
#define XSPI_ENH_CTRL0_ADDRLEN_40_BIT              ((uint32_t)0x00000028U)
#define XSPI_ENH_CTRL0_ADDRLEN_44_BIT              ((uint32_t)0x0000002CU)
#define XSPI_ENH_CTRL0_ADDRLEN_48_BIT              ((uint32_t)0x00000030U)
#define XSPI_ENH_CTRL0_ADDRLEN_52_BIT              ((uint32_t)0x00000034U)
#define XSPI_ENH_CTRL0_ADDRLEN_56_BIT              ((uint32_t)0x00000038U)
#define XSPI_ENH_CTRL0_ADDRLEN_60_BIT              ((uint32_t)0x0000003CU)

#define XSPI_ENH_CTRL0_INST_L                       ((uint32_t)0x00000300U) /* INST_L[1:0] (Dual/Quad mode instruction length in bits) */
#define XSPI_ENH_CTRL0_INST_L_0                     ((uint32_t)0x00000100U) /* Bit 0 */
#define XSPI_ENH_CTRL0_INST_L_1                     ((uint32_t)0x00000200U) /* Bit 1 */
#define XSPI_ENH_CTRL0_INST_L_0_LINE                ((uint32_t)0x00000000U)
#define XSPI_ENH_CTRL0_INST_L_4_LINE                ((uint32_t)0x00000100U)
#define XSPI_ENH_CTRL0_INST_L_8_LINE                ((uint32_t)0x00000200U)
#define XSPI_ENH_CTRL0_INST_L_16_LINE               ((uint32_t)0x00000300U)

#define XSPI_ENH_CTRL0_WAITCYCLES                   ((uint32_t)0x0000F800U) /* WAITCYCLES[4:0] (Wait Cycles in Dual/Quad mode between control frames transmit and data reception) */
#define XSPI_ENH_CTRL0_WAITCYCLES_0                 ((uint32_t)0x00000800U) /* Bit 0 */
#define XSPI_ENH_CTRL0_WAITCYCLES_1                 ((uint32_t)0x00001000U) /* Bit 1 */
#define XSPI_ENH_CTRL0_WAITCYCLES_2                 ((uint32_t)0x00002000U) /* Bit 2 */
#define XSPI_ENH_CTRL0_WAITCYCLES_3                 ((uint32_t)0x00004000U) /* Bit 3 */
#define XSPI_ENH_CTRL0_WAITCYCLES_4                 ((uint32_t)0x00008000U) /* Bit 4 */
#define XSPI_ENH_CTRL0_WAIT_1CYCLES                 ((uint32_t)0x00000800U)
#define XSPI_ENH_CTRL0_WAIT_2CYCLES                 ((uint32_t)0x00001000U)
#define XSPI_ENH_CTRL0_WAIT_3CYCLES                 ((uint32_t)0x00001800U)
#define XSPI_ENH_CTRL0_WAIT_4CYCLES                 ((uint32_t)0x00002000U)
#define XSPI_ENH_CTRL0_WAIT_5CYCLES                 ((uint32_t)0x00002800U)
#define XSPI_ENH_CTRL0_WAIT_6CYCLES                 ((uint32_t)0x00003000U)
#define XSPI_ENH_CTRL0_WAIT_7CYCLES                 ((uint32_t)0x00003800U)
#define XSPI_ENH_CTRL0_WAIT_8CYCLES                 ((uint32_t)0x00004000U)
#define XSPI_ENH_CTRL0_WAIT_9CYCLES                 ((uint32_t)0x00004800U)
#define XSPI_ENH_CTRL0_WAIT_10CYCLES                ((uint32_t)0x00005000U)
#define XSPI_ENH_CTRL0_WAIT_11CYCLES                ((uint32_t)0x00005800U)
#define XSPI_ENH_CTRL0_WAIT_12CYCLES                ((uint32_t)0x00006000U)
#define XSPI_ENH_CTRL0_WAIT_13CYCLES                ((uint32_t)0x00006800U)
#define XSPI_ENH_CTRL0_WAIT_14CYCLES                ((uint32_t)0x00007000U)
#define XSPI_ENH_CTRL0_WAIT_15CYCLES                ((uint32_t)0x00007800U)
#define XSPI_ENH_CTRL0_WAIT_16CYCLES                ((uint32_t)0x00008000U)
#define XSPI_ENH_CTRL0_WAIT_17CYCLES                ((uint32_t)0x00008800U)
#define XSPI_ENH_CTRL0_WAIT_18CYCLES                ((uint32_t)0x00009000U)
#define XSPI_ENH_CTRL0_WAIT_19CYCLES                ((uint32_t)0x00009800U)
#define XSPI_ENH_CTRL0_WAIT_20CYCLES                ((uint32_t)0x0000A000U)
#define XSPI_ENH_CTRL0_WAIT_21CYCLES                ((uint32_t)0x0000A800U)
#define XSPI_ENH_CTRL0_WAIT_22CYCLES                ((uint32_t)0x0000B000U)
#define XSPI_ENH_CTRL0_WAIT_23CYCLES                ((uint32_t)0x0000B800U)
#define XSPI_ENH_CTRL0_WAIT_24CYCLES                ((uint32_t)0x0000C000U)
#define XSPI_ENH_CTRL0_WAIT_25CYCLES                ((uint32_t)0x0000C800U)
#define XSPI_ENH_CTRL0_WAIT_26CYCLES                ((uint32_t)0x0000D000U)
#define XSPI_ENH_CTRL0_WAIT_27CYCLES                ((uint32_t)0x0000D800U)
#define XSPI_ENH_CTRL0_WAIT_28CYCLES                ((uint32_t)0x0000E000U)
#define XSPI_ENH_CTRL0_WAIT_29CYCLES                ((uint32_t)0x0000E800U)
#define XSPI_ENH_CTRL0_WAIT_30CYCLES                ((uint32_t)0x0000F000U)
#define XSPI_ENH_CTRL0_WAIT_31CYCLES                ((uint32_t)0x0000F800U)

#define XSPI_ENH_CTRL0_WRSPIDDREN                   ((uint32_t)0x00010000U) /* WRSPIDDREN (SPI DDR Enable) */
#define XSPI_ENH_CTRL0_WRINDDREN                    ((uint32_t)0x00020000U) /* WRINDDREN (XIP instruction enable) */
#define XSPI_ENH_CTRL0_SPIRXDSEN                    ((uint32_t)0x00040000U) /* SPIRXDSEN (Instruction DDR Enable bit) */

#define XSPI_ENH_CTRL0_SPIDMEN                          ((uint32_t)0x01000000U) /* SPIDMEN (SPI data mask enable) */
#define XSPI_ENH_CTRL0_CLKSTREN                     ((uint32_t)0x40000000U) /* CLKSTREN (Enable clock stretch capablity in SPI tramsfers) */

/** Bit definition for XSPI_DDR_TXDE register **/
#define XSPI_DDR_TXDE                               ((uint32_t)0x000000FFU) /* TXDE[7:0] (Transmit Drive Edge) */
#define XSPI_DDR_TXDE_0                             ((uint32_t)0x00000001U) /* Bit 0 */
#define XSPI_DDR_TXDE_1                             ((uint32_t)0x00000002U) /* Bit 1 */
#define XSPI_DDR_TXDE_2                             ((uint32_t)0x00000004U) /* Bit 2 */
#define XSPI_DDR_TXDE_3                             ((uint32_t)0x00000008U) /* Bit 3 */
#define XSPI_DDR_TXDE_4                             ((uint32_t)0x00000010U) /* Bit 4 */
#define XSPI_DDR_TXDE_5                             ((uint32_t)0x00000020U) /* Bit 5 */
#define XSPI_DDR_TXDE_6                             ((uint32_t)0x00000040U) /* Bit 6 */
#define XSPI_DDR_TXDE_7                             ((uint32_t)0x00000080U) /* Bit 7 */

/** Bit definition for XSPI_XIP_MODE register **/
#define XSPI_XIP_MODE_XIPMDBITS          ((uint32_t)0x0000FFFFU) /* XIPMDBITS[15:0] (XIP mode bits to be sent after address phase of XIP transfer) */
#define XSPI_XIP_MODE_XIPMDBITS_0        ((uint32_t)0x00000001U) /* Bit 0 */
#define XSPI_XIP_MODE_XIPMDBITS_1        ((uint32_t)0x00000002U) /* Bit 1 */
#define XSPI_XIP_MODE_XIPMDBITS_2        ((uint32_t)0x00000004U) /* Bit 2 */
#define XSPI_XIP_MODE_XIPMDBITS_3        ((uint32_t)0x00000008U) /* Bit 3 */
#define XSPI_XIP_MODE_XIPMDBITS_4        ((uint32_t)0x00000010U) /* Bit 4 */
#define XSPI_XIP_MODE_XIPMDBITS_5        ((uint32_t)0x00000020U) /* Bit 5 */
#define XSPI_XIP_MODE_XIPMDBITS_6        ((uint32_t)0x00000040U) /* Bit 6 */
#define XSPI_XIP_MODE_XIPMDBITS_7        ((uint32_t)0x00000080U) /* Bit 7 */
#define XSPI_XIP_MODE_XIPMDBITS_8        ((uint32_t)0x00000100U) /* Bit 8 */
#define XSPI_XIP_MODE_XIPMDBITS_9        ((uint32_t)0x00000200U) /* Bit 9 */
#define XSPI_XIP_MODE_XIPMDBITS_10       ((uint32_t)0x00000400U) /* Bit 10 */
#define XSPI_XIP_MODE_XIPMDBITS_11       ((uint32_t)0x00000800U) /* Bit 11 */
#define XSPI_XIP_MODE_XIPMDBITS_12       ((uint32_t)0x00001000U) /* Bit 12 */
#define XSPI_XIP_MODE_XIPMDBITS_13       ((uint32_t)0x00002000U) /* Bit 13 */
#define XSPI_XIP_MODE_XIPMDBITS_14       ((uint32_t)0x00004000U) /* Bit 14 */
#define XSPI_XIP_MODE_XIPMDBITS_15       ((uint32_t)0x00008000U) /* Bit 15 */

/** Bit definition for XSPI_XIP_INCR_TOC register **/
#define XSPI_XIP_INCR_TOC_ITOC             ((uint32_t)0x0000FFFFU) /* ITOC[15:0] (XIP INCR transfer OpCode) */
#define XSPI_XIP_INCR_TOC_ITOC_0           ((uint32_t)0x00000001U) /* Bit 0 */
#define XSPI_XIP_INCR_TOC_ITOC_1           ((uint32_t)0x00000002U) /* Bit 1 */
#define XSPI_XIP_INCR_TOC_ITOC_2           ((uint32_t)0x00000004U) /* Bit 2 */
#define XSPI_XIP_INCR_TOC_ITOC_3           ((uint32_t)0x00000008U) /* Bit 3 */
#define XSPI_XIP_INCR_TOC_ITOC_4           ((uint32_t)0x00000010U) /* Bit 4 */
#define XSPI_XIP_INCR_TOC_ITOC_5           ((uint32_t)0x00000020U) /* Bit 5 */
#define XSPI_XIP_INCR_TOC_ITOC_6           ((uint32_t)0x00000040U) /* Bit 6 */
#define XSPI_XIP_INCR_TOC_ITOC_7           ((uint32_t)0x00000080U) /* Bit 7 */
#define XSPI_XIP_INCR_TOC_ITOC_8           ((uint32_t)0x00000100U) /* Bit 8 */
#define XSPI_XIP_INCR_TOC_ITOC_9           ((uint32_t)0x00000200U) /* Bit 9 */
#define XSPI_XIP_INCR_TOC_ITOC_10          ((uint32_t)0x00000400U) /* Bit 10 */
#define XSPI_XIP_INCR_TOC_ITOC_11          ((uint32_t)0x00000800U) /* Bit 11 */
#define XSPI_XIP_INCR_TOC_ITOC_12          ((uint32_t)0x00001000U) /* Bit 12 */
#define XSPI_XIP_INCR_TOC_ITOC_13          ((uint32_t)0x00002000U) /* Bit 13 */
#define XSPI_XIP_INCR_TOC_ITOC_14          ((uint32_t)0x00004000U) /* Bit 14 */
#define XSPI_XIP_INCR_TOC_ITOC_15          ((uint32_t)0x00008000U) /* Bit 15 */

/** Bit definition for XSPI_XIP_WRAP_TOC register **/
#define XSPI_XIP_WRAP_TOC_WTOC             ((uint32_t)0x0000FFFFU) /* WTOC[15:0] (XIP WRAP transfer OpCode) */
#define XSPI_XIP_WRAP_TOC_WTOC_0           ((uint32_t)0x00000001U) /* Bit 0 */
#define XSPI_XIP_WRAP_TOC_WTOC_1           ((uint32_t)0x00000002U) /* Bit 1 */
#define XSPI_XIP_WRAP_TOC_WTOC_2           ((uint32_t)0x00000004U) /* Bit 2 */
#define XSPI_XIP_WRAP_TOC_WTOC_3           ((uint32_t)0x00000008U) /* Bit 3 */
#define XSPI_XIP_WRAP_TOC_WTOC_4           ((uint32_t)0x00000010U) /* Bit 4 */
#define XSPI_XIP_WRAP_TOC_WTOC_5           ((uint32_t)0x00000020U) /* Bit 5 */
#define XSPI_XIP_WRAP_TOC_WTOC_6           ((uint32_t)0x00000040U) /* Bit 6 */
#define XSPI_XIP_WRAP_TOC_WTOC_7           ((uint32_t)0x00000080U) /* Bit 7 */
#define XSPI_XIP_WRAP_TOC_WTOC_8           ((uint32_t)0x00000100U) /* Bit 8 */
#define XSPI_XIP_WRAP_TOC_WTOC_9           ((uint32_t)0x00000200U) /* Bit 9 */
#define XSPI_XIP_WRAP_TOC_WTOC_10          ((uint32_t)0x00000400U) /* Bit 10 */
#define XSPI_XIP_WRAP_TOC_WTOC_11          ((uint32_t)0x00000800U) /* Bit 11 */
#define XSPI_XIP_WRAP_TOC_WTOC_12          ((uint32_t)0x00001000U) /* Bit 12 */
#define XSPI_XIP_WRAP_TOC_WTOC_13          ((uint32_t)0x00002000U) /* Bit 13 */
#define XSPI_XIP_WRAP_TOC_WTOC_14          ((uint32_t)0x00004000U) /* Bit 14 */
#define XSPI_XIP_WRAP_TOC_WTOC_15          ((uint32_t)0x00008000U) /* Bit 15 */

/** Bit definition for XSPI_XIP_CTRL register **/
#define XSPI_XIP_CTRL_FRF                  ((uint32_t)0x00000003U) /* FRF[1:0] (Frame format) */
#define XSPI_XIP_CTRL_FRF_0                ((uint32_t)0x00000001U) /* Bit 0 */
#define XSPI_XIP_CTRL_FRF_1                ((uint32_t)0x00000002U) /* Bit 1 */
#define XSPI_XIP_CTRL_FRF_2_LINE           ((uint32_t)0x00000001U)
#define XSPI_XIP_CTRL_FRF_4_LINE           ((uint32_t)0x00000002U)

#define XSPI_XIP_CTRL_TRANSTYPE                         ((uint32_t)0x00000003U) /* TRANSTYPE[1:0] (Address and instruction transfer format) */
#define XSPI_XIP_CTRL_TRANSTYPE_0                       ((uint32_t)0x00000001U) /* Bit 0 */
#define XSPI_XIP_CTRL_TRANSTYPE_1                       ((uint32_t)0x00000002U) /* Bit 1 */
#define XSPI_XIP_CTRL_TRANSTYPE_STANDARD_SPI            ((uint32_t)0x00000000U)
#define XSPI_XIP_CTRL_TRANSTYPE_ADDRESS_BY_XIP_FRF         ((uint32_t)0x00000004U)
#define XSPI_XIP_CTRL_TRANSTYPE_INSTRUCT_BY_XIP_FRF        ((uint32_t)0x00000008U)

#define XSPI_XIP_CTRL_ADDRLEN                ((uint32_t)0x000000F0U) /* ADDRLEN[3:0] (Length of Address to transmit) */
#define XSPI_XIP_CTRL_ADDRLEN_0              ((uint32_t)0x00000010U) /* Bit 0 */
#define XSPI_XIP_CTRL_ADDRLEN_1              ((uint32_t)0x00000020U) /* Bit 1 */
#define XSPI_XIP_CTRL_ADDRLEN_2              ((uint32_t)0x00000040U) /* Bit 2 */
#define XSPI_XIP_CTRL_ADDRLEN_3              ((uint32_t)0x00000080U) /* Bit 3 */
#define XSPI_XIP_CTRL_ADDR_4BIT           ((uint32_t)0x00000010U)
#define XSPI_XIP_CTRL_ADDR_8BIT           ((uint32_t)0x00000020U)
#define XSPI_XIP_CTRL_ADDR_12BIT          ((uint32_t)0x00000030U)
#define XSPI_XIP_CTRL_ADDR_16BIT          ((uint32_t)0x00000040U)
#define XSPI_XIP_CTRL_ADDR_20BIT          ((uint32_t)0x00000050U)
#define XSPI_XIP_CTRL_ADDR_24BIT          ((uint32_t)0x00000060U)
#define XSPI_XIP_CTRL_ADDR_28BIT          ((uint32_t)0x00000070U)
#define XSPI_XIP_CTRL_ADDR_32BIT          ((uint32_t)0x00000080U)
#define XSPI_XIP_CTRL_ADDR_36BIT          ((uint32_t)0x00000090U)
#define XSPI_XIP_CTRL_ADDR_40BIT          ((uint32_t)0x000000A0U)
#define XSPI_XIP_CTRL_ADDR_44BIT          ((uint32_t)0x000000B0U)
#define XSPI_XIP_CTRL_ADDR_48BIT          ((uint32_t)0x000000C0U)
#define XSPI_XIP_CTRL_ADDR_52BIT          ((uint32_t)0x000000D0U)
#define XSPI_XIP_CTRL_ADDR_56BIT          ((uint32_t)0x000000E0U)
#define XSPI_XIP_CTRL_ADDR_60BIT          ((uint32_t)0x000000F0U)

#define XSPI_XIP_CTRL_INST_L              ((uint32_t)0x00000600U) /* INST_L[1:0] (Dual/Quad mode instruction length in bits) */
#define XSPI_XIP_CTRL_INST_L_0            ((uint32_t)0x00000200U) /* Bit 0 */
#define XSPI_XIP_CTRL_INST_L_1            ((uint32_t)0x00000400U) /* Bit 1 */
#define XSPI_XIP_CTRL_INST_L_0_LINE       ((uint32_t)0x00000000U)
#define XSPI_XIP_CTRL_INST_L_4_LINE       ((uint32_t)0x00000200U)
#define XSPI_XIP_CTRL_INST_L_8_LINE       ((uint32_t)0x00000400U)
#define XSPI_XIP_CTRL_INST_L_16_LINE      ((uint32_t)0x00000600U)

#define XSPI_XIP_CTRL_MDBITSEN               ((uint32_t)0x00001000U) /* MDBITSEN (Mode bits enable in XIP mode) */

#define XSPI_XIP_CTRL_WAITCYCLES             ((uint32_t)0x0003E000U) /* WAITCYCLES[4:0] (Wait Cycles in Dual/Quad mode between control frames transmit and data reception) */
#define XSPI_XIP_CTRL_WAITCYCLES_0           ((uint32_t)0x00002000U) /* Bit 0 */
#define XSPI_XIP_CTRL_WAITCYCLES_1           ((uint32_t)0x00004000U) /* Bit 1 */
#define XSPI_XIP_CTRL_WAITCYCLES_2           ((uint32_t)0x00008000U) /* Bit 2 */
#define XSPI_XIP_CTRL_WAITCYCLES_3           ((uint32_t)0x00010000U) /* Bit 3 */
#define XSPI_XIP_CTRL_WAITCYCLES_4           ((uint32_t)0x00020000U) /* Bit 4 */
#define XSPI_XIP_CTRL_WAIT_1CYCLES        ((uint32_t)0x00002000U)
#define XSPI_XIP_CTRL_WAIT_2CYCLES        ((uint32_t)0x00004000U)
#define XSPI_XIP_CTRL_WAIT_3CYCLES        ((uint32_t)0x00006000U)
#define XSPI_XIP_CTRL_WAIT_4CYCLES        ((uint32_t)0x00008000U)
#define XSPI_XIP_CTRL_WAIT_5CYCLES        ((uint32_t)0x0000A000U)
#define XSPI_XIP_CTRL_WAIT_6CYCLES        ((uint32_t)0x0000C000U)
#define XSPI_XIP_CTRL_WAIT_7CYCLES        ((uint32_t)0x0000E000U)
#define XSPI_XIP_CTRL_WAIT_8CYCLES        ((uint32_t)0x00010000U)
#define XSPI_XIP_CTRL_WAIT_9CYCLES        ((uint32_t)0x00012000U)
#define XSPI_XIP_CTRL_WAIT_10CYCLES       ((uint32_t)0x00014000U)
#define XSPI_XIP_CTRL_WAIT_11CYCLES       ((uint32_t)0x00016000U)
#define XSPI_XIP_CTRL_WAIT_12CYCLES       ((uint32_t)0x00018000U)
#define XSPI_XIP_CTRL_WAIT_13CYCLES       ((uint32_t)0x0001A000U)
#define XSPI_XIP_CTRL_WAIT_14CYCLES       ((uint32_t)0x0001C000U)
#define XSPI_XIP_CTRL_WAIT_15CYCLES       ((uint32_t)0x0001E000U)
#define XSPI_XIP_CTRL_WAIT_16CYCLES       ((uint32_t)0x00020000U)
#define XSPI_XIP_CTRL_WAIT_17CYCLES       ((uint32_t)0x00022000U)
#define XSPI_XIP_CTRL_WAIT_18CYCLES       ((uint32_t)0x00024000U)
#define XSPI_XIP_CTRL_WAIT_19CYCLES       ((uint32_t)0x00026000U)
#define XSPI_XIP_CTRL_WAIT_20CYCLES       ((uint32_t)0x00028000U)
#define XSPI_XIP_CTRL_WAIT_21CYCLES       ((uint32_t)0x0002A000U)
#define XSPI_XIP_CTRL_WAIT_22CYCLES       ((uint32_t)0x0002C000U)
#define XSPI_XIP_CTRL_WAIT_23CYCLES       ((uint32_t)0x0002E000U)
#define XSPI_XIP_CTRL_WAIT_24CYCLES       ((uint32_t)0x00030000U)
#define XSPI_XIP_CTRL_WAIT_25CYCLES       ((uint32_t)0x00032000U)
#define XSPI_XIP_CTRL_WAIT_26CYCLES       ((uint32_t)0x00034000U)
#define XSPI_XIP_CTRL_WAIT_27CYCLES       ((uint32_t)0x00036000U)
#define XSPI_XIP_CTRL_WAIT_28CYCLES       ((uint32_t)0x00038000U)
#define XSPI_XIP_CTRL_WAIT_29CYCLES       ((uint32_t)0x0003A000U)
#define XSPI_XIP_CTRL_WAIT_30CYCLES       ((uint32_t)0x0003C000U)
#define XSPI_XIP_CTRL_WAIT_31CYCLES       ((uint32_t)0x0003E000U)

#define XSPI_XIP_CTRL_DFSHC             ((uint32_t)0x00040000U) /* DFSHC (Fix DFS for XIP transfers) */
#define XSPI_XIP_CTRL_DDREN             ((uint32_t)0x00080000U) /* DDREN (SPI DDR Enable) */
#define XSPI_XIP_CTRL_WRINDDREN         ((uint32_t)0x00100000U) /* WRINDDREN (XIP instruction enable) */
#define XSPI_XIP_CTRL_RXDSEN                 ((uint32_t)0x00200000U) /* RXDSEN (Read data strobe enable) */
#define XSPI_XIP_CTRL_XIPINSTEN         ((uint32_t)0x00400000U) /* XIPINSTEN (XIP instruction enable) */
#define XSPI_XIP_CTRL_XIPCTEN           ((uint32_t)0x00800000U) /* XIPCTEN (Enable Continuous Transfer in XIP mode) */
#define XSPI_XIP_CTRL_XIPHYPEEN         ((uint32_t)0x01000000U) /* XIPHYPEEN (SPI Hyperbus Frame format enable for XIP transfers) */
#define XSPI_XIP_CTRL_RXDSSIGEN         ((uint32_t)0x02000000U) /* RXDSSIGEN (Enable rxds signaling during address and command phase of Hyperbus transfer) */


#define XSPI_XIP_CTRL_XIPMBL             ((uint32_t)0x0C000000U) /* XIPMBL[1:0] (XIP Mode bits length) */
#define XSPI_XIP_CTRL_XIPMBL_0           ((uint32_t)0x04000000U) /* Bit 0 */
#define XSPI_XIP_CTRL_XIPMBL_1           ((uint32_t)0x08000000U) /* Bit 1 */
#define XSPI_XIP_CTRL_XIPMBL_LEN_2_BIT   ((uint32_t)0x00000000U)
#define XSPI_XIP_CTRL_XIPMBL_LEN_4_BIT   ((uint32_t)0x04000000U)
#define XSPI_XIP_CTRL_XIPMBL_LEN_8_BIT   ((uint32_t)0x08000000U)
#define XSPI_XIP_CTRL_XIPMBL_LEN_16_BIT  ((uint32_t)0x0C000000U)

#define XSPI_XIP_CTRL_XIPPREEN            ((uint32_t)0x20000000U) /* XIPPREEN (Enables XIP pre-fetch functionality) */

/** Bit definition for XSPI_XIP_SLAVE_EN register **/
#define XSPI_XIP_SLAVE_EN_SEN             ((uint32_t)0x00000003U) /* SEN (Slave Enable) */
#define XSPI_XIP_SLAVE_EN_SEN_0           ((uint32_t)0x00000001U) /* Bit0 */
#define XSPI_XIP_SLAVE_EN_SEN_1           ((uint32_t)0x00000002U) /* Bit1 */

/** Bit definition for XSPI_XIP_RXFOI_CLR register **/
#define XSPI_XIP_RXFOI_CLR_XRXFOIC        ((uint32_t)0x00000001U) /* XRXFOIC (Clear XIP Receive FIFO Overflow Interrupt) */

/** Bit definition for XSPI_XIP_OUT register **/
#define XSPI_XIP_OUT_XTOUT                ((uint32_t)0x0000FFFFU) /* XTOUT[7:0] (XIP time out value in terms of HCLK) */
#define XSPI_XIP_OUT_XTOUT_0              ((uint32_t)0x00000001U) /* Bit 0 */
#define XSPI_XIP_OUT_XTOUT_1              ((uint32_t)0x00000002U) /* Bit 1 */
#define XSPI_XIP_OUT_XTOUT_2              ((uint32_t)0x00000004U) /* Bit 2 */
#define XSPI_XIP_OUT_XTOUT_3              ((uint32_t)0x00000008U) /* Bit 3 */
#define XSPI_XIP_OUT_XTOUT_4              ((uint32_t)0x00000010U) /* Bit 4 */
#define XSPI_XIP_OUT_XTOUT_5              ((uint32_t)0x00000020U) /* Bit 5 */
#define XSPI_XIP_OUT_XTOUT_6              ((uint32_t)0x00000040U) /* Bit 6 */
#define XSPI_XIP_OUT_XTOUT_7              ((uint32_t)0x00000080U) /* Bit 7 */

/** Bit definition for XSPI_XIP_WRITE_INCR_INST register **/
#define XSPI_XIP_WRITE_INCR_INST_INCRWRINST             ((uint32_t)0x0000FFFFU) /* INCRWRINST [15:0] (XIP Write INCR transfer opcode) */
#define XSPI_XIP_WRITE_INCR_INST_INCRWRINST_0           ((uint32_t)0x00000001U) /* Bit 0 */
#define XSPI_XIP_WRITE_INCR_INST_INCRWRINST_1           ((uint32_t)0x00000002U) /* Bit 1 */
#define XSPI_XIP_WRITE_INCR_INST_INCRWRINST_2           ((uint32_t)0x00000004U) /* Bit 2 */
#define XSPI_XIP_WRITE_INCR_INST_INCRWRINST_3           ((uint32_t)0x00000008U) /* Bit 3 */
#define XSPI_XIP_WRITE_INCR_INST_INCRWRINST_4           ((uint32_t)0x00000010U) /* Bit 4 */
#define XSPI_XIP_WRITE_INCR_INST_INCRWRINST_5           ((uint32_t)0x00000020U) /* Bit 5 */
#define XSPI_XIP_WRITE_INCR_INST_INCRWRINST_6           ((uint32_t)0x00000040U) /* Bit 6 */
#define XSPI_XIP_WRITE_INCR_INST_INCRWRINST_7           ((uint32_t)0x00000080U) /* Bit 7 */
#define XSPI_XIP_WRITE_INCR_INST_INCRWRINST_8           ((uint32_t)0x00000100U) /* Bit 8 */
#define XSPI_XIP_WRITE_INCR_INST_INCRWRINST_9           ((uint32_t)0x00000200U) /* Bit 9 */
#define XSPI_XIP_WRITE_INCR_INST_INCRWRINST_10          ((uint32_t)0x00000400U) /* Bit 10 */
#define XSPI_XIP_WRITE_INCR_INST_INCRWRINST_11          ((uint32_t)0x00000800U) /* Bit 11 */
#define XSPI_XIP_WRITE_INCR_INST_INCRWRINST_12          ((uint32_t)0x00001000U) /* Bit 12 */
#define XSPI_XIP_WRITE_INCR_INST_INCRWRINST_13          ((uint32_t)0x00002000U) /* Bit 13 */
#define XSPI_XIP_WRITE_INCR_INST_INCRWRINST_14          ((uint32_t)0x00004000U) /* Bit 14 */
#define XSPI_XIP_WRITE_INCR_INST_INCRWRINST_15          ((uint32_t)0x00008000U) /* Bit 15 */

/** Bit definition for XSPI_XIP_WRITE_WRAP_INST register **/
#define XSPI_XIP_WRITE_WRAP_INST_WRAPWRINST             ((uint32_t)0x0000FFFFU) /* WRAPWRINST [15:0] (XIP Write WRAP transfer opcode) */
#define XSPI_XIP_WRITE_WRAP_INST_WRAPWRINST_0           ((uint32_t)0x00000001U) /* Bit 0 */
#define XSPI_XIP_WRITE_WRAP_INST_WRAPWRINST_1           ((uint32_t)0x00000002U) /* Bit 1 */
#define XSPI_XIP_WRITE_WRAP_INST_WRAPWRINST_2           ((uint32_t)0x00000004U) /* Bit 2 */
#define XSPI_XIP_WRITE_WRAP_INST_WRAPWRINST_3           ((uint32_t)0x00000008U) /* Bit 3 */
#define XSPI_XIP_WRITE_WRAP_INST_WRAPWRINST_4           ((uint32_t)0x00000010U) /* Bit 4 */
#define XSPI_XIP_WRITE_WRAP_INST_WRAPWRINST_5           ((uint32_t)0x00000020U) /* Bit 5 */
#define XSPI_XIP_WRITE_WRAP_INST_WRAPWRINST_6           ((uint32_t)0x00000040U) /* Bit 6 */
#define XSPI_XIP_WRITE_WRAP_INST_WRAPWRINST_7           ((uint32_t)0x00000080U) /* Bit 7 */
#define XSPI_XIP_WRITE_WRAP_INST_WRAPWRINST_8           ((uint32_t)0x00000100U) /* Bit 8 */
#define XSPI_XIP_WRITE_WRAP_INST_WRAPWRINST_9           ((uint32_t)0x00000200U) /* Bit 9 */
#define XSPI_XIP_WRITE_WRAP_INST_WRAPWRINST_10          ((uint32_t)0x00000400U) /* Bit 10 */
#define XSPI_XIP_WRITE_WRAP_INST_WRAPWRINST_11          ((uint32_t)0x00000800U) /* Bit 11 */
#define XSPI_XIP_WRITE_WRAP_INST_WRAPWRINST_12          ((uint32_t)0x00001000U) /* Bit 12 */
#define XSPI_XIP_WRITE_WRAP_INST_WRAPWRINST_13          ((uint32_t)0x00002000U) /* Bit 13 */
#define XSPI_XIP_WRITE_WRAP_INST_WRAPWRINST_14          ((uint32_t)0x00004000U) /* Bit 14 */
#define XSPI_XIP_WRITE_WRAP_INST_WRAPWRINST_15          ((uint32_t)0x00008000U) /* Bit 15 */


/** Bit definition for XSPI_XIP_WRITE_CTRL register **/
#define XSPI_XIP_CTRL_WRFRF                        ((uint32_t)0x00000003U) /* WRFRF[1:0] (Frame format) */
#define XSPI_XIP_WRITE_CTRL_WRFRF_0                ((uint32_t)0x00000001U) /* Bit 0 */
#define XSPI_XIP_WRITE_CTRL_WRFRF_1                ((uint32_t)0x00000002U) /* Bit 1 */
#define XSPI_XIP_WRITE_CTRL_WRFRF_2_LINE           ((uint32_t)0x00000001U)
#define XSPI_XIP_WRITE_CTRL_WRFRF_4_LINE           ((uint32_t)0x00000002U)
#define XSPI_XIP_WRITE_CTRL_WRFRF_8_LINE           ((uint32_t)0x00000003U)

#define XSPI_XIP_WRITE_CTRL_WRTRTYPE                                ((uint32_t)0x00000003U) /* WRTRTYPE[1:0] (Address and instruction transfer format) */
#define XSPI_XIP_WRITE_CTRL_WRTRTYPE_0                              ((uint32_t)0x00000001U) /* Bit 0 */
#define XSPI_XIP_WRITE_CTRL_WRTRTYPE_1                              ((uint32_t)0x00000002U) /* Bit 1 */
#define XSPI_XIP_WRITE_CTRL_WRTRTYPE_STANDARD_SPI                   ((uint32_t)0x00000000U)
#define XSPI_XIP_WRITE_CTRL_WRTRTYPE_ADDRESS_BY_XIP_WRITE_WRFRF     ((uint32_t)0x00000004U)
#define XSPI_XIP_WRITE_CTRL_WRTRTYPE_INSTRUCT_BY_XIP_WRITE_WRFRF    ((uint32_t)0x00000008U)

#define XSPI_XIP_WRITE_CTRL_WRADDRL               ((uint32_t)0x000000F0U) /* WRADDRL[3:0] (Length of Address to transmit) */
#define XSPI_XIP_WRITE_CTRL_WRADDRL_0             ((uint32_t)0x00000010U) /* Bit 0 */
#define XSPI_XIP_WRITE_CTRL_WRADDRL_1             ((uint32_t)0x00000020U) /* Bit 1 */
#define XSPI_XIP_WRITE_CTRL_WRADDRL_2             ((uint32_t)0x00000040U) /* Bit 2 */
#define XSPI_XIP_WRITE_CTRL_WRADDRL_3             ((uint32_t)0x00000080U) /* Bit 3 */
#define XSPI_XIP_WRITE_CTRL_WRADDR_4BIT           ((uint32_t)0x00000010U)
#define XSPI_XIP_WRITE_CTRL_WRADDR_8BIT           ((uint32_t)0x00000020U)
#define XSPI_XIP_WRITE_CTRL_WRADDR_12BIT          ((uint32_t)0x00000030U)
#define XSPI_XIP_WRITE_CTRL_WRADDR_16BIT          ((uint32_t)0x00000040U)
#define XSPI_XIP_WRITE_CTRL_WRADDR_20BIT          ((uint32_t)0x00000050U)
#define XSPI_XIP_WRITE_CTRL_WRADDR_24BIT          ((uint32_t)0x00000060U)
#define XSPI_XIP_WRITE_CTRL_WRADDR_28BIT          ((uint32_t)0x00000070U)
#define XSPI_XIP_WRITE_CTRL_WRADDR_32BIT          ((uint32_t)0x00000080U)

#define XSPI_XIP_WRITE_CTRL_WRINSTL              ((uint32_t)0x00000300U) /* WRINSTL[1:0] (Dual/Quad mode instruction length in bits) */
#define XSPI_XIP_WRITE_CTRL_WRINSTL_0            ((uint32_t)0x00000100U) /* Bit 0 */
#define XSPI_XIP_WRITE_CTRL_WRINSTL_1            ((uint32_t)0x00000200U) /* Bit 1 */
#define XSPI_XIP_WRITE_CTRL_WRINSTL_0_LINE       ((uint32_t)0x00000000U)
#define XSPI_XIP_WRITE_CTRL_WRINSTL_4_LINE       ((uint32_t)0x00000200U)
#define XSPI_XIP_WRITE_CTRL_WRINSTL_8_LINE       ((uint32_t)0x00000400U)
#define XSPI_XIP_WRITE_CTRL_WRINSTL_16_LINE      ((uint32_t)0x00000600U)

#define XSPI_XIP_WRITE_CTRL_WRSPIDDREN           ((uint32_t)0x00000400U) /* WRSPIDDREN (SPI DDR Enable) */
#define XSPI_XIP_WRITE_CTRL_WRINDDREN            ((uint32_t)0x00000800U) /* WRINDDREN (Instruction DDR Enable) */

#define XSPI_XIP_WRITE_CTRL_XIPWRWCY            ((uint32_t)0x001F0000U) /* XIPWRWCY[4:0] (Wait cycles in Dual/Quad/Octal mode between control frames transmit and data reception.) */
#define XSPI_XIP_WRITE_CTRL_XIPWRWCY_0          ((uint32_t)0x00010000U) /* Bit 0 */
#define XSPI_XIP_WRITE_CTRL_XIPWRWCY_1          ((uint32_t)0x00020000U) /* Bit 1 */
#define XSPI_XIP_WRITE_CTRL_XIPWRWCY_2          ((uint32_t)0x00040000U) /* Bit 2 */
#define XSPI_XIP_WRITE_CTRL_XIPWRWCY_3          ((uint32_t)0x00080000U) /* Bit 3 */
#define XSPI_XIP_WRITE_CTRL_XIPWRWCY_4          ((uint32_t)0x00100000U) /* Bit 4 */
#define XSPI_XIP_WRITE_CTRL_WAIT_1CYCLES        ((uint32_t)0x00010000U)
#define XSPI_XIP_WRITE_CTRL_WAIT_2CYCLES        ((uint32_t)0x00020000U)
#define XSPI_XIP_WRITE_CTRL_WAIT_3CYCLES        ((uint32_t)0x00030000U)
#define XSPI_XIP_WRITE_CTRL_WAIT_4CYCLES        ((uint32_t)0x00040000U)
#define XSPI_XIP_WRITE_CTRL_WAIT_5CYCLES        ((uint32_t)0x00050000U)
#define XSPI_XIP_WRITE_CTRL_WAIT_6CYCLES        ((uint32_t)0x00060000U)
#define XSPI_XIP_WRITE_CTRL_WAIT_7CYCLES        ((uint32_t)0x00070000U)
#define XSPI_XIP_WRITE_CTRL_WAIT_8CYCLES        ((uint32_t)0x00080000U)
#define XSPI_XIP_WRITE_CTRL_WAIT_9CYCLES        ((uint32_t)0x00090000U)
#define XSPI_XIP_WRITE_CTRL_WAIT_10CYCLES       ((uint32_t)0x000A0000U)
#define XSPI_XIP_WRITE_CTRL_WAIT_11CYCLES       ((uint32_t)0x000B0000U)
#define XSPI_XIP_WRITE_CTRL_WAIT_12CYCLES       ((uint32_t)0x000C0000U)
#define XSPI_XIP_WRITE_CTRL_WAIT_13CYCLES       ((uint32_t)0x000D0000U)
#define XSPI_XIP_WRITE_CTRL_WAIT_14CYCLES       ((uint32_t)0x000E0000U)
#define XSPI_XIP_WRITE_CTRL_WAIT_15CYCLES       ((uint32_t)0x000F0000U)
#define XSPI_XIP_WRITE_CTRL_WAIT_16CYCLES       ((uint32_t)0x00100000U)
#define XSPI_XIP_WRITE_CTRL_WAIT_17CYCLES       ((uint32_t)0x00110000U)
#define XSPI_XIP_WRITE_CTRL_WAIT_18CYCLES       ((uint32_t)0x00120000U)
#define XSPI_XIP_WRITE_CTRL_WAIT_19CYCLES       ((uint32_t)0x00130000U)
#define XSPI_XIP_WRITE_CTRL_WAIT_20CYCLES       ((uint32_t)0x00140000U)
#define XSPI_XIP_WRITE_CTRL_WAIT_21CYCLES       ((uint32_t)0x00150000U)
#define XSPI_XIP_WRITE_CTRL_WAIT_22CYCLES       ((uint32_t)0x00160000U)
#define XSPI_XIP_WRITE_CTRL_WAIT_23CYCLES       ((uint32_t)0x00170000U)
#define XSPI_XIP_WRITE_CTRL_WAIT_24CYCLES       ((uint32_t)0x00180000U)
#define XSPI_XIP_WRITE_CTRL_WAIT_25CYCLES       ((uint32_t)0x00190000U)
#define XSPI_XIP_WRITE_CTRL_WAIT_26CYCLES       ((uint32_t)0x001A0000U)
#define XSPI_XIP_WRITE_CTRL_WAIT_27CYCLES       ((uint32_t)0x001B0000U)
#define XSPI_XIP_WRITE_CTRL_WAIT_28CYCLES       ((uint32_t)0x001C0000U)
#define XSPI_XIP_WRITE_CTRL_WAIT_29CYCLES       ((uint32_t)0x001D0000U)
#define XSPI_XIP_WRITE_CTRL_WAIT_30CYCLES       ((uint32_t)0x001E0000U)
#define XSPI_XIP_WRITE_CTRL_WAIT_31CYCLES       ((uint32_t)0x001F0000U)



/*** Digital Video Port controller ***/

/** Bit definition for DVP_CTRL register **/
#define DVP_CTRL_DVPEN        ((uint32_t)0x00000001U) /* DVP port enable bit. */
#define DVP_CTRL_CM           ((uint32_t)0x00000002U) /* Capture Mode Control. */
#define DVP_CTRL_CROPEN       ((uint32_t)0x00000100U) /* Cropping Feature Enable bit */
#define DVP_CTRL_VBFLT        ((uint32_t)0xF0000000U) /* VSYNC blanking glitch filtering control */
#define DVP_CTRL_VBFLT_BIT0   ((uint32_t)0x10000000U) /* BIT0 */
#define DVP_CTRL_VBFLT_BIT1   ((uint32_t)0x20000000U) /* BIT1 */
#define DVP_CTRL_VBFLT_BIT2   ((uint32_t)0x40000000U) /* BIT2 */
#define DVP_CTRL_VBFLT_BIT3   ((uint32_t)0x80000000U) /* BIT3 */

/** Bit definition for DVP_INTEN register **/
#define DVP_INTEN_M1SIE       ((uint32_t)0x00000001U) /* Frame Buffer 1 is started to receive image data interrupt enable bit */
#define DVP_INTEN_M2SIE       ((uint32_t)0x00000002U) /* Frame Buffer 2 is started to receive image data interrupt enable bit. */
#define DVP_INTEN_M1TCIE      ((uint32_t)0x00000004U) /* Image data to Frame Buffer 1 transfer complete interrupt enable bit. */
#define DVP_INTEN_M2TCIE      ((uint32_t)0x00000008U) /* Image data to Frame Buffer 2 transfer complete interrupt enable bit. */
#define DVP_INTEN_FOIE        ((uint32_t)0x00000020U) /* Data FIFO Over Flow interrupt enable bit. */
#define DVP_INTEN_AHBERR      ((uint32_t)0x00000080U) /* AHB bus error response interrupt enable bit. */
#define DVP_INTEN_MOIE        ((uint32_t)0x00000100U) /* Frame Buffer Over Flow interrupt enable bit. */
#define DVP_INTEN_SKIPIE      ((uint32_t)0x00010000U) /* Frame skipping interrupt enable bit. */
#define DVP_INTEN_CERRIE      ((uint32_t)0x00020000U) /* SYNC Code mismatch detected interrupt enable bit. */
#define DVP_INTEN_SERRIE      ((uint32_t)0x00040000U) /* SYNC Code error sequence detected interrupt enable bit. */
#define DVP_INTEN_FMSIE       ((uint32_t)0x00080000U) /* Start of Frame detection interrupt Enable bit. */

/** Bit definition for DVP_INTSTS register **/
#define DVP_INTSTS_M1SF       ((uint32_t)0x00000001U) /* Data to Frame Buffer 1 start flag */
#define DVP_INTSTS_M2SF       ((uint32_t)0x00000002U) /* Data to Frame Buffer 2 start flag. */
#define DVP_INTSTS_M1TCF      ((uint32_t)0x00000004U) /* Data to Frame Buffer 1 completion flag. */
#define DVP_INTSTS_M2TCF      ((uint32_t)0x00000008U) /* Data to Frame Buffer 2 completion flag. */
#define DVP_INTSTS_M1FOF      ((uint32_t)0x00000010U) /* Frame Buffer 1 FIFO over flow flag. */
#define DVP_INTSTS_M2FOF      ((uint32_t)0x00000020U) /* Frame Buffer 2 FIFO over flow flag. */
#define DVP_INTSTS_AHBERR1F   ((uint32_t)0x00000040U) /* Receiving AHB bus error response on accessing to Frame Buffer 1 flag. */
#define DVP_INTSTS_AHBERR2F   ((uint32_t)0x00000080U) /* Receiving AHB bus error response on accessing to Frame Buffer 2 flag. */
#define DVP_INTSTS_M1OF       ((uint32_t)0x00000100U) /* Frame Buffer 1 Over Flow */
#define DVP_INTSTS_M2OF       ((uint32_t)0x00000200U) /* Frame Buffer 2 Over Flow */
#define DVP_INTSTS_SKIPF      ((uint32_t)0x00010000U) /* Frame skipping detected flag. */
#define DVP_INTSTS_CERRF      ((uint32_t)0x00020000U) /* SYNC Code mismatch error detected flag. */
#define DVP_INTSTS_SERRF      ((uint32_t)0x00040000U) /* SYNC Code sequence error detected flag. */
#define DVP_INTSTS_FMSF       ((uint32_t)0x00080000U) /* Start of Frame detected flag. */
#define DVP_INTSTS_DVPDIS     ((uint32_t)0x01000000U) /* SDVP port disable bit. */
 
/** Bit definition for DVP_PORTCFG register **/
#define DVP_PORTCFG_PCLKPOL   ((uint32_t)0x00000001U) /* DVP port pixel clock polarity control. */
#define DVP_PORTCFG_HSPOL     ((uint32_t)0x00000002U) /* HSYNC polarity control. */
#define DVP_PORTCFG_VSPOL     ((uint32_t)0x00000004U) /* VSYNC polarity control. */
#define DVP_PORTCFG_DATINV    ((uint32_t)0x00000008U) /* Data bit inversion. */
#define DVP_PORTCFG_DATRVS    ((uint32_t)0x00000010U) /* To reverse data bit order. */
#define DVP_PORTCFG_SLC       ((uint32_t)0x00000040U) /* Embedded Synchronization Code Position. */
#define DVP_PORTCFG_EMBSEN    ((uint32_t)0x00000080U) /* Embedded Synchronization Mode enable bit. */
#define DVP_PORTCFG_DBIT      ((uint32_t)0x00000700U) /* DVP data port mode. */
#define DVP_PORTCFG_DBIT0     ((uint32_t)0x00000100U) /* BIT0. */
#define DVP_PORTCFG_DBIT1     ((uint32_t)0x00000200U) /* BIT1. */
#define DVP_PORTCFG_DBIT2     ((uint32_t)0x00000400U) /* BIT2. */
#define DVP_PORTCFG_PIXELDB   ((uint32_t)0x00001000U) /* 2 bytes per pixel */
#define DVP_PORTCFG_BMAP      ((uint32_t)0x00FF0000U) /* Received pixel data to Frame Buffer mapping. */
#define DVP_PORTCFG_BMAP0     ((uint32_t)0x00010000U) /* BIT0. */
#define DVP_PORTCFG_BMAP1     ((uint32_t)0x00020000U) /* BIT1. */
#define DVP_PORTCFG_BMAP2     ((uint32_t)0x00040000U) /* BIT2. */
#define DVP_PORTCFG_BMAP3     ((uint32_t)0x00080000U) /* BIT3. */
#define DVP_PORTCFG_BMAP4     ((uint32_t)0x00100000U) /* BIT4. */
#define DVP_PORTCFG_BMAP5     ((uint32_t)0x00200000U) /* BIT5. */
#define DVP_PORTCFG_BMAP6     ((uint32_t)0x00400000U) /* BIT6. */
#define DVP_PORTCFG_BMAP7     ((uint32_t)0x00800000U) /* BIT7. */                        
#define DVP_PORTCFG_HISKIP    ((uint32_t)0x0F000000U) /* Initial Frame Line Skip Control */
#define DVP_PORTCFG_HRSKIP    ((uint32_t)0xF0000000U) /* Repeat Line Skip Pattern Control (include even/odd line capturing) */

/** Bit definition for DVP_FIFOCFG register **/
#define DVP_FIFOCFG_M1ADDREN  ((uint32_t)0x00000001U) /* DVP frame buffer 1 enable control. */
#define DVP_FIFOCFG_M2ADDREN  ((uint32_t)0x00000002U) /* DVP frame buffer 2 enable control. */
#define DVP_FIFOCFG_DISPMODE  ((uint32_t)0x00000010U) /* DVP show current frame buffer status. */
#define DVP_FIFOCFG_EN1KBD    ((uint32_t)0x00000020U) /* DVP bursting across 1K boundary control. */
#define DVP_FIFOCFG_TXFTH     ((uint32_t)0x00000300U) /* DVP FIFO transmit threshold setting. */
#define DVP_FIFOCFG_TXFTH0    ((uint32_t)0x00000100U) /* BIT0. */
#define DVP_FIFOCFG_TXFTH1    ((uint32_t)0x00000200U) /* BIT1. */
#define DVP_FIFOCFG_TXBURSZ   ((uint32_t)0x00070000U) /* DVP AHB master data burst setting. */
#define DVP_FIFOCFG_TXBURSZ0  ((uint32_t)0x00010000U) /* BIT0. */
#define DVP_FIFOCFG_TXBURSZ1  ((uint32_t)0x00020000U) /* BIT1. */
#define DVP_FIFOCFG_TXBURSZ2  ((uint32_t)0x00040000U) /* BIT2. */

/** Bit definition for DVP_SMADDR1 register **/
#define DVP_SMADDR1_MADDR     ((uint32_t)0xFFFFFFFFU) /* Frame Buffer 1 Start Address. */

/** Bit definition for DVP_SMADDR2 register **/
#define DVP_SMADDR2_MADDR     ((uint32_t)0xFFFFFFFFU) /* Frame Buffer 2 Start Address. */

/** Bit definition for DVP_FBS register **/
#define DVP_FBS_FMSIZE        ((uint32_t)0x003FFFFFU) /* Frame Buffer Size. */

/** Bit definition for DVP_CSXY register **/
#define DVP_CSXY_CSTAX        ((uint32_t)0x000007FFU) /* X-coordinate of crop image start point. */
#define DVP_CSXY_CSTAY        ((uint32_t)0x07FF0000U) /* Y-coordinate of crop image start point.*/

/** Bit definition for DVP_CEXY register **/
#define DVP_CEXY_CENDX        ((uint32_t)0x000007FFU) /* X-coordinate of crop image end point. */
#define DVP_CEXY_CENDY        ((uint32_t)0x07FF0000U) /* Y-coordinate of crop image end point.*/

/** Bit definition for DVP_EMSC register **/
#define DVP_EMSC_VS_PTTN      ((uint32_t)0x000000FFU) /* Frame start synchronization code. */
#define DVP_EMSC_VE_PTTN      ((uint32_t)0x0000FF00U) /* Frame end synchronization code. */
#define DVP_EMSC_HS_PTTN      ((uint32_t)0x00FF0000U) /* Active line start synchronization code. */
#define DVP_EMSC_HE_PTTN      ((uint32_t)0xFF000000U) /* Active line end synchronization code. */

/** Bit definition for DVP_EMSCM register **/
#define DVP_EMSCM_VS_MASK     ((uint32_t)0x000000FFU) /* Frame start synchronization code Mask. */
#define DVP_EMSCM_VE_MASK     ((uint32_t)0x0000FF00U) /* Frame end synchronization code Mask. */
#define DVP_EMSCM_HS_MASK     ((uint32_t)0x00FF0000U) /* Active line start synchronization code Mask. */
#define DVP_EMSCM_HE_MASK     ((uint32_t)0xFF000000U) /* Active line end synchronization code Mask. */

/** Bit definition for SHRTIM_MCTRL register  **/
#define SHRTIM_MCTRL_BRSTDMA                                 ((uint32_t)0xC0000000U)            /* Bit[31:30] Burst DMA update */
#define SHRTIM_MCTRL_BRSTDMA_0                               ((uint32_t)0x40000000U)            /* Bit30 */
#define SHRTIM_MCTRL_BRSTDMA_1                               ((uint32_t)0x80000000U)            /* Bit31 */
#define SHRTIM_MCTRL_MREPTUEN                                  ((uint32_t)0x20000000U)            /* Bit[29] Master timer repetitiion update */
#define SHRTIM_MCTRL_PLEN                                    ((uint32_t)0x08000000U)            /* Bit[27] Preload enable */
#define SHRTIM_MCTRL_DACTRIG                                 ((uint32_t)0x06000000U)            /* Bit[26:25] DAC synchronization trigger */
#define SHRTIM_MCTRL_DACTRIG_0                               ((uint32_t)0x02000000U)            /* Bit25 */
#define SHRTIM_MCTRL_DACTRIG_1                               ((uint32_t)0x04000000U)            /* Bit26 */
#define SHRTIM_MCTRL_TFCNTEN                                 ((uint32_t)0x00400000U)            /* Bit[22] Timer F counter enable */
#define SHRTIM_MCTRL_TECNTEN                                 ((uint32_t)0x00200000U)            /* Bit[21] Timer E counter enable */
#define SHRTIM_MCTRL_TDCNTEN                                 ((uint32_t)0x00100000U)            /* Bit[20] Timer D counter enable */
#define SHRTIM_MCTRL_TCCNTEN                                 ((uint32_t)0x00080000U)            /* Bit[19] Timer C counter enable */
#define SHRTIM_MCTRL_TBCNTEN                                 ((uint32_t)0x00040000U)            /* Bit[18] Timer B counter enable */
#define SHRTIM_MCTRL_TACNTEN                                 ((uint32_t)0x00020000U)            /* Bit[17] Timer A counter enable */
#define SHRTIM_MCTRL_MCNTEN                                  ((uint32_t)0x00010000U)            /* Bit[16] Master timer counter enable */
#define SHRTIM_MCTRL_SYNCOSRC                                ((uint32_t)0x0000C000U)            /* Bit[15:14] Synchronization source */
#define SHRTIM_MCTRL_SYNCOSRC_0                              ((uint32_t)0x00004000U)            /* Bit14 */
#define SHRTIM_MCTRL_SYNCOSRC_1                              ((uint32_t)0x00008000U)            /* Bit15 */
#define SHRTIM_MCTRL_SYNCSTRT                                ((uint32_t)0x00002000U)            /* Bit[13] Synchronization to allow master start */
#define SHRTIM_MCTRL_SYNCRST                                 ((uint32_t)0x00001000U)            /* Bit[12] Synchronization to allow master reset */
#define SHRTIM_MCTRL_SYNCIN                                  ((uint32_t)0x00000700U)            /* Bit[10:8] Synchronization input */
#define SHRTIM_MCTRL_SYNCIN_0                                ((uint32_t)0x00000100U)            /* Bit8 */
#define SHRTIM_MCTRL_SYNCIN_1                                ((uint32_t)0x00000200U)            /* Bit9 */
#define SHRTIM_MCTRL_SYNCIN_2                                ((uint32_t)0x00000400U)            /* Bit10 */
#define SHRTIM_MCTRL_ILV                                     ((uint32_t)0x000000C0U)            /* Bit[7:6] Master interleaved mode */
#define SHRTIM_MCTRL_ILV_0                                   ((uint32_t)0x00000040U)            /* Bit6 */
#define SHRTIM_MCTRL_ILV_1                                   ((uint32_t)0x00000080U)            /* Bit7 */
#define SHRTIM_MCTRL_HLF                                     ((uint32_t)0x00000020U)            /* Bit[5] Half mode. */
#define SHRTIM_MCTRL_RTG                                     ((uint32_t)0x00000010U)            /* Bit[4] Master retrigger mode */
#define SHRTIM_MCTRL_CONT                                    ((uint32_t)0x00000008U)            /* Bit[3] Master continues mode */
#define SHRTIM_MCTRL_CKPSC                                   ((uint32_t)0x00000007U)            /* Bit[2:0] Master clock prescaler */
#define SHRTIM_MCTRL_CKPSC_0                                 ((uint32_t)0x00000001U)            /* Bit0 */
#define SHRTIM_MCTRL_CKPSC_1                                 ((uint32_t)0x00000002U)            /* Bit1 */
#define SHRTIM_MCTRL_CKPSC_2                                 ((uint32_t)0x00000004U)            /* Bit2 */

/** Bit definition for SHRTIM_MINTSTS register  **/
#define SHRTIM_MINTSTS_MUPDITF                                 ((uint32_t)0x00000040U)            /* Bit[6] Master registers update interrupt flag */
#define SHRTIM_MINTSTS_SYNCINITF                                ((uint32_t)0x00000020U)            /* Bit[5] Synchronization input interrupt flag */
#define SHRTIM_MINTSTS_MREPTITF                                ((uint32_t)0x00000010U)            /* Bit[4] Master repetition interrupt flag */
#define SHRTIM_MINTSTS_MCMP4ITF                                ((uint32_t)0x00000008U)            /* Bit[3] Master timer compare 4 interrupt flag */
#define SHRTIM_MINTSTS_MCMP3ITF                                ((uint32_t)0x00000004U)            /* Bit[2] Master timer compare 3 interrupt flag */
#define SHRTIM_MINTSTS_MCMP2ITF                                ((uint32_t)0x00000002U)            /* Bit[1] Master timer compare 2 interrupt flag */
#define SHRTIM_MINTSTS_MCMP1ITF                                ((uint32_t)0x00000001U)            /* Bit[0] Master timer compare 1 interrupt flag */

/** Bit definition for SHRTIM_MINTCLR register  **/
#define SHRTIM_MINTCLR_MUPDIC                                  ((uint32_t)0x00000040U)            /* Bit[6] Master update interrupt flag clear */
#define SHRTIM_MINTCLR_SYNCINIC                                ((uint32_t)0x00000020U)            /* Bit[5] Master sync interrupt flag clear */
#define SHRTIM_MINTCLR_MREPTIC                                 ((uint32_t)0x00000010U)            /* Bit[4] Master repetition interrupt flag clear */
#define SHRTIM_MINTCLR_MCMP4IC                                 ((uint32_t)0x00000008U)            /* Bit[3] Master compare4 interrupt flag clear */
#define SHRTIM_MINTCLR_MCMP3IC                                 ((uint32_t)0x00000004U)            /* Bit[2] Master compare3 interrupt flag clear */
#define SHRTIM_MINTCLR_MCMP2IC                                 ((uint32_t)0x00000002U)            /* Bit[1] Master compare2 interrupt flag clear */
#define SHRTIM_MINTCLR_MCMP1IC                                 ((uint32_t)0x00000001U)            /* Bit[0] Master compare1 interrupt flag clear */

/** Bit definition for SHRTIM_MIDEN register  **/
#define SHRTIM_MIDEN_MUPDDEN                                 ((uint32_t)0x00400000U)            /* Bit[22] Master registers update DMA request enable */
#define SHRTIM_MIDEN_SYNCINDEN                                ((uint32_t)0x00200000U)            /* Bit[21] Synchronization input DMA request enable */
#define SHRTIM_MIDEN_MREPTDEN                                ((uint32_t)0x00100000U)            /* Bit[20] Master repetition counter DMA request enable */
#define SHRTIM_MIDEN_MCMP4DEN                                ((uint32_t)0x00080000U)            /* Bit[19] Master timer compare 4 DMA request enable */
#define SHRTIM_MIDEN_MCMP3DEN                                ((uint32_t)0x00040000U)            /* Bit[18] Master timer compare 3 DMA request enable */
#define SHRTIM_MIDEN_MCMP2DEN                                ((uint32_t)0x00020000U)            /* Bit[17] Master timer compare 2 DMA request enable */
#define SHRTIM_MIDEN_MCMP1DEN                                ((uint32_t)0x00010000U)            /* Bit[16] Master timer compare 1 DMA request enable */
#define SHRTIM_MIDEN_MUPDIEN                                 ((uint32_t)0x00000040U)            /* Bit[6] Master registers update interrupt request enable */
#define SHRTIM_MIDEN_SYNCINIEN                               ((uint32_t)0x00000020U)            /* Bit[5] Synchronization input interrupt request enable */
#define SHRTIM_MIDEN_MREPTIEN                                ((uint32_t)0x00000010U)            /* Bit[4] Master repetition counter interrupt request enable */
#define SHRTIM_MIDEN_MCMP4IEN                                ((uint32_t)0x00000008U)            /* Bit[3] Master timer compare 4 interrupt request enable */
#define SHRTIM_MIDEN_MCMP3IEN                                ((uint32_t)0x00000004U)            /* Bit[2] Master timer compare 3 interrupt request enable */
#define SHRTIM_MIDEN_MCMP2IEN                                ((uint32_t)0x00000002U)            /* Bit[1] Master timer compare 2 interrupt request enable */
#define SHRTIM_MIDEN_MCMP1IEN                                ((uint32_t)0x00000001U)            /* Bit[0] Master timer compare 1 interrupt request enable */

/** Bit definition for SHRTIM_MCNT register  **/
#define SHRTIM_MCNT_MCOUNT                                  ((uint32_t)0x0000FFFFU)            /* Bit[15:0] Master timer counter */
#define SHRTIM_MCNT_MCOUNT_0                                ((uint32_t)0x00000001U)            /* Bit0 */
#define SHRTIM_MCNT_MCOUNT_1                                ((uint32_t)0x00000002U)            /* Bit1 */
#define SHRTIM_MCNT_MCOUNT_2                                ((uint32_t)0x00000004U)            /* Bit2 */
#define SHRTIM_MCNT_MCOUNT_3                                ((uint32_t)0x00000008U)            /* Bit3 */
#define SHRTIM_MCNT_MCOUNT_4                                ((uint32_t)0x00000010U)            /* Bit4 */
#define SHRTIM_MCNT_MCOUNT_5                                ((uint32_t)0x00000020U)            /* Bit5 */
#define SHRTIM_MCNT_MCOUNT_6                                ((uint32_t)0x00000040U)            /* Bit6 */
#define SHRTIM_MCNT_MCOUNT_7                                ((uint32_t)0x00000080U)            /* Bit7 */
#define SHRTIM_MCNT_MCOUNT_8                                ((uint32_t)0x00000100U)            /* Bit8 */
#define SHRTIM_MCNT_MCOUNT_9                                ((uint32_t)0x00000200U)            /* Bit9 */
#define SHRTIM_MCNT_MCOUNT_10                               ((uint32_t)0x00000400U)            /* Bit10 */
#define SHRTIM_MCNT_MCOUNT_11                               ((uint32_t)0x00000800U)            /* Bit11 */
#define SHRTIM_MCNT_MCOUNT_12                               ((uint32_t)0x00001000U)            /* Bit12 */
#define SHRTIM_MCNT_MCOUNT_13                               ((uint32_t)0x00002000U)            /* Bit13 */
#define SHRTIM_MCNT_MCOUNT_14                               ((uint32_t)0x00004000U)            /* Bit14 */
#define SHRTIM_MCNT_MCOUNT_15                               ((uint32_t)0x00008000U)            /* Bit15 */

/** Bit definition for SHRTIM_MPRD register  **/
#define SHRTIM_MPRD_MPRD                                    ((uint32_t)0x0000FFFFU)            /* Bit[15:0] Master timer period */
#define SHRTIM_MPRD_MPRD_0                                  ((uint32_t)0x00000001U)            /* Bit0 */
#define SHRTIM_MPRD_MPRD_1                                  ((uint32_t)0x00000002U)            /* Bit1 */
#define SHRTIM_MPRD_MPRD_2                                  ((uint32_t)0x00000004U)            /* Bit2 */
#define SHRTIM_MPRD_MPRD_3                                  ((uint32_t)0x00000008U)            /* Bit3 */
#define SHRTIM_MPRD_MPRD_4                                  ((uint32_t)0x00000010U)            /* Bit4 */
#define SHRTIM_MPRD_MPRD_5                                  ((uint32_t)0x00000020U)            /* Bit5 */
#define SHRTIM_MPRD_MPRD_6                                  ((uint32_t)0x00000040U)            /* Bit6 */
#define SHRTIM_MPRD_MPRD_7                                  ((uint32_t)0x00000080U)            /* Bit7 */
#define SHRTIM_MPRD_MPRD_8                                  ((uint32_t)0x00000100U)            /* Bit8 */
#define SHRTIM_MPRD_MPRD_9                                  ((uint32_t)0x00000200U)            /* Bit9 */
#define SHRTIM_MPRD_MPRD_10                                 ((uint32_t)0x00000400U)            /* Bit10 */
#define SHRTIM_MPRD_MPRD_11                                 ((uint32_t)0x00000800U)            /* Bit11 */
#define SHRTIM_MPRD_MPRD_12                                 ((uint32_t)0x00001000U)            /* Bit12 */
#define SHRTIM_MPRD_MPRD_13                                 ((uint32_t)0x00002000U)            /* Bit13 */
#define SHRTIM_MPRD_MPRD_14                                 ((uint32_t)0x00004000U)            /* Bit14 */
#define SHRTIM_MPRD_MPRD_15                                 ((uint32_t)0x00008000U)            /* Bit15 */

/** Bit definition for SHRTIM_MREPT register  **/
#define SHRTIM_MREPT_MREPT                                   ((uint32_t)0x000000FFU)            /* Bit[7:0] Master timer repetition period */
#define SHRTIM_MREPT_MREPT_0                                 ((uint32_t)0x00000001U)            /* Bit0 */
#define SHRTIM_MREPT_MREPT_1                                 ((uint32_t)0x00000002U)            /* Bit1 */
#define SHRTIM_MREPT_MREPT_2                                 ((uint32_t)0x00000004U)            /* Bit2 */
#define SHRTIM_MREPT_MREPT_3                                 ((uint32_t)0x00000008U)            /* Bit3 */
#define SHRTIM_MREPT_MREPT_4                                 ((uint32_t)0x00000010U)            /* Bit4 */
#define SHRTIM_MREPT_MREPT_5                                 ((uint32_t)0x00000020U)            /* Bit5 */
#define SHRTIM_MREPT_MREPT_6                                 ((uint32_t)0x00000040U)            /* Bit6 */
#define SHRTIM_MREPT_MREPT_7                                 ((uint32_t)0x00000080U)            /* Bit7 */

/** Bit definition for SHRTIM_MCMP1DAT register  **/
#define SHRTIM_MCMP1DAT_MCMP1DAT                                ((uint32_t)0x0000FFFFU)            /* Bit[15:0] Master timer compare 1 data */
#define SHRTIM_MCMP1DAT_MCMP1DAT_0                              ((uint32_t)0x00000001U)            /* Bit0 */
#define SHRTIM_MCMP1DAT_MCMP1DAT_1                              ((uint32_t)0x00000002U)            /* Bit1 */
#define SHRTIM_MCMP1DAT_MCMP1DAT_2                              ((uint32_t)0x00000004U)            /* Bit2 */
#define SHRTIM_MCMP1DAT_MCMP1DAT_3                              ((uint32_t)0x00000008U)            /* Bit3 */
#define SHRTIM_MCMP1DAT_MCMP1DAT_4                              ((uint32_t)0x00000010U)            /* Bit4 */
#define SHRTIM_MCMP1DAT_MCMP1DAT_5                              ((uint32_t)0x00000020U)            /* Bit5 */
#define SHRTIM_MCMP1DAT_MCMP1DAT_6                              ((uint32_t)0x00000040U)            /* Bit6 */
#define SHRTIM_MCMP1DAT_MCMP1DAT_7                              ((uint32_t)0x00000080U)            /* Bit7 */
#define SHRTIM_MCMP1DAT_MCMP1DAT_8                              ((uint32_t)0x00000100U)            /* Bit8 */
#define SHRTIM_MCMP1DAT_MCMP1DAT_9                              ((uint32_t)0x00000200U)            /* Bit9 */
#define SHRTIM_MCMP1DAT_MCMP1DAT_10                             ((uint32_t)0x00000400U)            /* Bit10 */
#define SHRTIM_MCMP1DAT_MCMP1DAT_11                             ((uint32_t)0x00000800U)            /* Bit11 */
#define SHRTIM_MCMP1DAT_MCMP1DAT_12                             ((uint32_t)0x00001000U)            /* Bit12 */
#define SHRTIM_MCMP1DAT_MCMP1DAT_13                             ((uint32_t)0x00002000U)            /* Bit13 */
#define SHRTIM_MCMP1DAT_MCMP1DAT_14                             ((uint32_t)0x00004000U)            /* Bit14 */
#define SHRTIM_MCMP1DAT_MCMP1DAT_15                             ((uint32_t)0x00008000U)            /* Bit15 */

/** Bit definition for SHRTIM_MCMP2DAT register  **/
#define SHRTIM_MCMP2DAT_MCMP2DAT                                ((uint32_t)0x0000FFFFU)            /* Bit[15:0] Master timer compare 2 data */
#define SHRTIM_MCMP2DAT_MCMP2DAT_0                              ((uint32_t)0x00000001U)            /* Bit0 */
#define SHRTIM_MCMP2DAT_MCMP2DAT_1                              ((uint32_t)0x00000002U)            /* Bit1 */
#define SHRTIM_MCMP2DAT_MCMP2DAT_2                              ((uint32_t)0x00000004U)            /* Bit2 */
#define SHRTIM_MCMP2DAT_MCMP2DAT_3                              ((uint32_t)0x00000008U)            /* Bit3 */
#define SHRTIM_MCMP2DAT_MCMP2DAT_4                              ((uint32_t)0x00000010U)            /* Bit4 */
#define SHRTIM_MCMP2DAT_MCMP2DAT_5                              ((uint32_t)0x00000020U)            /* Bit5 */
#define SHRTIM_MCMP2DAT_MCMP2DAT_6                              ((uint32_t)0x00000040U)            /* Bit6 */
#define SHRTIM_MCMP2DAT_MCMP2DAT_7                              ((uint32_t)0x00000080U)            /* Bit7 */
#define SHRTIM_MCMP2DAT_MCMP2DAT_8                              ((uint32_t)0x00000100U)            /* Bit8 */
#define SHRTIM_MCMP2DAT_MCMP2DAT_9                              ((uint32_t)0x00000200U)            /* Bit9 */
#define SHRTIM_MCMP2DAT_MCMP2DAT_10                             ((uint32_t)0x00000400U)            /* Bit10 */
#define SHRTIM_MCMP2DAT_MCMP2DAT_11                             ((uint32_t)0x00000800U)            /* Bit11 */
#define SHRTIM_MCMP2DAT_MCMP2DAT_12                             ((uint32_t)0x00001000U)            /* Bit12 */
#define SHRTIM_MCMP2DAT_MCMP2DAT_13                             ((uint32_t)0x00002000U)            /* Bit13 */
#define SHRTIM_MCMP2DAT_MCMP2DAT_14                             ((uint32_t)0x00004000U)            /* Bit14 */
#define SHRTIM_MCMP2DAT_MCMP2DAT_15                             ((uint32_t)0x00008000U)            /* Bit15 */

/** Bit definition for SHRTIM_MCMP3DAT register  **/
#define SHRTIM_MCMP3DAT_MCMP3DAT                                ((uint32_t)0x0000FFFFU)            /* Bit[15:0] Master timer compare 3 data */
#define SHRTIM_MCMP3DAT_MCMP3DAT_0                              ((uint32_t)0x00000001U)            /* Bit0 */
#define SHRTIM_MCMP3DAT_MCMP3DAT_1                              ((uint32_t)0x00000002U)            /* Bit1 */
#define SHRTIM_MCMP3DAT_MCMP3DAT_2                              ((uint32_t)0x00000004U)            /* Bit2 */
#define SHRTIM_MCMP3DAT_MCMP3DAT_3                              ((uint32_t)0x00000008U)            /* Bit3 */
#define SHRTIM_MCMP3DAT_MCMP3DAT_4                              ((uint32_t)0x00000010U)            /* Bit4 */
#define SHRTIM_MCMP3DAT_MCMP3DAT_5                              ((uint32_t)0x00000020U)            /* Bit5 */
#define SHRTIM_MCMP3DAT_MCMP3DAT_6                              ((uint32_t)0x00000040U)            /* Bit6 */
#define SHRTIM_MCMP3DAT_MCMP3DAT_7                              ((uint32_t)0x00000080U)            /* Bit7 */
#define SHRTIM_MCMP3DAT_MCMP3DAT_8                              ((uint32_t)0x00000100U)            /* Bit8 */
#define SHRTIM_MCMP3DAT_MCMP3DAT_9                              ((uint32_t)0x00000200U)            /* Bit9 */
#define SHRTIM_MCMP3DAT_MCMP3DAT_10                             ((uint32_t)0x00000400U)            /* Bit10 */
#define SHRTIM_MCMP3DAT_MCMP3DAT_11                             ((uint32_t)0x00000800U)            /* Bit11 */
#define SHRTIM_MCMP3DAT_MCMP3DAT_12                             ((uint32_t)0x00001000U)            /* Bit12 */
#define SHRTIM_MCMP3DAT_MCMP3DAT_13                             ((uint32_t)0x00002000U)            /* Bit13 */
#define SHRTIM_MCMP3DAT_MCMP3DAT_14                             ((uint32_t)0x00004000U)            /* Bit14 */
#define SHRTIM_MCMP3DAT_MCMP3DAT_15                             ((uint32_t)0x00008000U)            /* Bit15 */

/** Bit definition for SHRTIM_MCMP4DAT register  **/
#define SHRTIM_MCMP4DAT_MCMP4DAT                                ((uint32_t)0x0000FFFFU)            /* Bit[15:0] Master timer compare 4 data */
#define SHRTIM_MCMP4DAT_MCMP4DAT_0                              ((uint32_t)0x00000001U)            /* Bit0 */
#define SHRTIM_MCMP4DAT_MCMP4DAT_1                              ((uint32_t)0x00000002U)            /* Bit1 */
#define SHRTIM_MCMP4DAT_MCMP4DAT_2                              ((uint32_t)0x00000004U)            /* Bit2 */
#define SHRTIM_MCMP4DAT_MCMP4DAT_3                              ((uint32_t)0x00000008U)            /* Bit3 */
#define SHRTIM_MCMP4DAT_MCMP4DAT_4                              ((uint32_t)0x00000010U)            /* Bit4 */
#define SHRTIM_MCMP4DAT_MCMP4DAT_5                              ((uint32_t)0x00000020U)            /* Bit5 */
#define SHRTIM_MCMP4DAT_MCMP4DAT_6                              ((uint32_t)0x00000040U)            /* Bit6 */
#define SHRTIM_MCMP4DAT_MCMP4DAT_7                              ((uint32_t)0x00000080U)            /* Bit7 */
#define SHRTIM_MCMP4DAT_MCMP4DAT_8                              ((uint32_t)0x00000100U)            /* Bit8 */
#define SHRTIM_MCMP4DAT_MCMP4DAT_9                              ((uint32_t)0x00000200U)            /* Bit9 */
#define SHRTIM_MCMP4DAT_MCMP4DAT_10                             ((uint32_t)0x00000400U)            /* Bit10 */
#define SHRTIM_MCMP4DAT_MCMP4DAT_11                             ((uint32_t)0x00000800U)            /* Bit11 */
#define SHRTIM_MCMP4DAT_MCMP4DAT_12                             ((uint32_t)0x00001000U)            /* Bit12 */
#define SHRTIM_MCMP4DAT_MCMP4DAT_13                             ((uint32_t)0x00002000U)            /* Bit13 */
#define SHRTIM_MCMP4DAT_MCMP4DAT_14                             ((uint32_t)0x00004000U)            /* Bit14 */
#define SHRTIM_MCMP4DAT_MCMP4DAT_15                             ((uint32_t)0x00008000U)            /* Bit15 */

/** Bit definition for SHRTIM_SYNCOUT register  **/
#define SHRTIM_SYNCOUT_SYNCOUT2PUS                             ((uint32_t)0x00000030U)            /* Bit[5:4] Synchronization output to shrtimx_out_sync2 (to internal peripherals), These bitfield define the polarity of pulse of shrtimx_out_sync2. */
#define SHRTIM_SYNCOUT_SYNCOUT2PUS_0                           ((uint32_t)0x00000010U)            /* Bit4 */
#define SHRTIM_SYNCOUT_SYNCOUT2PUS_1                           ((uint32_t)0x00000020U)            /* Bit5 */
#define SHRTIM_SYNCOUT_SYNCOUT1PUS                             ((uint32_t)0x00000003U)            /* Bit[1:0] Synchronization output to shrtimx_out_sync1 (to SHRTIMx_SCOUT pin), These bitfield define the polarity of pulse of SHRTIMx_SCOUT. */
#define SHRTIM_SYNCOUT_SYNCOUT1PUS_0                           ((uint32_t)0x00000001U)            /* Bit0 */
#define SHRTIM_SYNCOUT_SYNCOUT1PUS_1                           ((uint32_t)0x00000002U)            /* Bit1 */

/** Bit definition for SHRTIM_FRZDIS register  **/
#define SHRTIM_FRZDIS_ALLTIMDBGEN                                ((uint32_t)0x00000080U)            /* Bit[7] Debug freeze bit used to hault all timers (master + slave) while in debug mode */
#define SHRTIM_FRZDIS_TFDBGEN                                 ((uint32_t)0x00000040U)            /* Bit[6] Debug freeze bit used to skip haulting the timer F while in debug mode */
#define SHRTIM_FRZDIS_TEDBGEN                                 ((uint32_t)0x00000020U)            /* Bit[5] Debug freeze bit used to skip haulting the timer E while in debug mode */
#define SHRTIM_FRZDIS_TDDBGEN                                 ((uint32_t)0x00000010U)            /* Bit[4] Debug freeze bit used to skip haulting the timer D while in debug mode */
#define SHRTIM_FRZDIS_TCDBGEN                                 ((uint32_t)0x00000008U)            /* Bit[3] Debug freeze bit used to skip haulting the timer C while in debug mode */
#define SHRTIM_FRZDIS_TBDBGEN                                 ((uint32_t)0x00000004U)            /* Bit[2] Debug freeze bit used to skip haulting the timer B while in debug mode */
#define SHRTIM_FRZDIS_TADBGEN                                 ((uint32_t)0x00000002U)            /* Bit[1] Debug freeze bit used to skip haulting the timer A while in debug mode */
#define SHRTIM_FRZDIS_MDBGEN                                  ((uint32_t)0x00000001U)            /* Bit[0] Debug freeze bit used to skip haulting the master timer while in debug mode */

/** Bit definition for SHRTIM_TXCTRL register  **/
#define SHRTIM_TXCTRL_UPDGAT                                  ((uint32_t)0xF0000000U)            /* Bit[31:28] Register update events for timer x */
#define SHRTIM_TXCTRL_UPDGAT_0                                ((uint32_t)0x10000000U)            /* Bit28 */
#define SHRTIM_TXCTRL_UPDGAT_1                                ((uint32_t)0x20000000U)            /* Bit29 */
#define SHRTIM_TXCTRL_UPDGAT_2                                ((uint32_t)0x40000000U)            /* Bit30 */
#define SHRTIM_TXCTRL_UPDGAT_3                                ((uint32_t)0x80000000U)            /* Bit31 */
#define SHRTIM_TXCTRL_PLEN                                    ((uint32_t)0x08000000U)            /* Bit[27] timer x preload enable */
#define SHRTIM_TXCTRL_DACTRIG                                 ((uint32_t)0x06000000U)            /* Bit[26:25] The update event can be used to generate a DAC synchronization. The active output is chosen based on this register configuration. */
#define SHRTIM_TXCTRL_DACTRIG_0                               ((uint32_t)0x02000000U)            /* Bit25 */
#define SHRTIM_TXCTRL_DACTRIG_1                               ((uint32_t)0x04000000U)            /* Bit26 */
#define SHRTIM_TXCTRL_MUEN                                    ((uint32_t)0x01000000U)            /* Bit[24] Master timer update */
#define SHRTIM_TXCTRL_TEUEN                                   ((uint32_t)0x00800000U)            /* Bit[23] Timer E update */
#define SHRTIM_TXCTRL_TDUEN                                   ((uint32_t)0x00400000U)            /* Bit[22] Timer D update */
#define SHRTIM_TXCTRL_TCUEN                                   ((uint32_t)0x00200000U)            /* Bit[21] Timer C update */
#define SHRTIM_TXCTRL_TBUEN                                   ((uint32_t)0x00100000U)            /* Bit[20] Timer B update */
#define SHRTIM_TXCTRL_TAUEN                                   ((uint32_t)0x00080000U)            /* Bit[19] Timer A update */
#define SHRTIM_TXCTRL_RSTROUEN                                ((uint32_t)0x00040000U)            /* Bit[18] Timer A reset update */
#define SHRTIM_TXCTRL_REPTUEN                                 ((uint32_t)0x00020000U)            /* Bit[17] Timer A repetitiion update */
#define SHRTIM_TXCTRL_TFUEN                                   ((uint32_t)0x00010000U)            /* Bit[16] Timer F update */
#define SHRTIM_TXCTRL_DELCMP4M                                ((uint32_t)0x0000C000U)            /* Bit[15:14] CMP4 delayed mode */
#define SHRTIM_TXCTRL_DELCMP4M_0                              ((uint32_t)0x00004000U)            /* Bit14 */
#define SHRTIM_TXCTRL_DELCMP4M_1                              ((uint32_t)0x00008000U)            /* Bit15 */
#define SHRTIM_TXCTRL_DELCMP2M                                ((uint32_t)0x00003000U)            /* Bit[13:12] CMP2 delayed mode */
#define SHRTIM_TXCTRL_DELCMP2M_0                              ((uint32_t)0x00001000U)            /* Bit12 */
#define SHRTIM_TXCTRL_DELCMP2M_1                              ((uint32_t)0x00002000U)            /* Bit13 */
#define SHRTIM_TXCTRL_SYNCSTRT                                ((uint32_t)0x00000800U)            /* Bit[11] Synchronizationto allow timer x start */
#define SHRTIM_TXCTRL_SYNCRST                                 ((uint32_t)0x00000400U)            /* Bit[10] Synchronizationto allow timer x reset */
#define SHRTIM_TXCTRL_RSYNCUPD                                 ((uint32_t)0x00000200U)            /* Bit[9] Update on resynchronization */
#define SHRTIM_TXCTRL_ILV                                     ((uint32_t)0x00000180U)            /* Bit[8:7] Timer A interleaved mode */
#define SHRTIM_TXCTRL_ILV_0                                   ((uint32_t)0x00000080U)            /* Bit7 */
#define SHRTIM_TXCTRL_ILV_1                                   ((uint32_t)0x00000100U)            /* Bit8 */
#define SHRTIM_TXCTRL_PP                                      ((uint32_t)0x00000040U)            /* Bit[6] Push pull mode enable */
#define SHRTIM_TXCTRL_HLF                                     ((uint32_t)0x00000020U)            /* Bit[5] Half mode. */
#define SHRTIM_TXCTRL_RTG                                     ((uint32_t)0x00000010U)            /* Bit[4] Retrigger mode */
#define SHRTIM_TXCTRL_CONT                                    ((uint32_t)0x00000008U)            /* Bit[3] Continuous mode */
#define SHRTIM_TXCTRL_CKPSC                                   ((uint32_t)0x00000007U)            /* Bit[2:0] Clock prescaler */
#define SHRTIM_TXCTRL_CKPSC_0                                 ((uint32_t)0x00000001U)            /* Bit0 */
#define SHRTIM_TXCTRL_CKPSC_1                                 ((uint32_t)0x00000002U)            /* Bit1 */
#define SHRTIM_TXCTRL_CKPSC_2                                 ((uint32_t)0x00000004U)            /* Bit2 */

/** Bit definition for SHRTIM_TXINTSTS register  **/
#define SHRTIM_TXINTSTS_O2BCKUP                                ((uint32_t)0x00200000U)            /* Bit[21] Timer x channel 2 output backup. */
#define SHRTIM_TXINTSTS_O1BCKUP                                ((uint32_t)0x00100000U)            /* Bit[20] Timer x channel 2 output backup. */
#define SHRTIM_TXINTSTS_O2DIPSTS                               ((uint32_t)0x00080000U)            /* Bit[19] Timer x channnel 2 delayed idle protection status. */
#define SHRTIM_TXINTSTS_O1DIPSTS                               ((uint32_t)0x00040000U)            /* Bit[18] Timer x channnel 1 delayed idle protection status. */
#define SHRTIM_TXINTSTS_IPPSTS                                  ((uint32_t)0x00020000U)            /* Bit[17] Idle push pull status. */
#define SHRTIM_TXINTSTS_CPPSTS                                  ((uint32_t)0x00010000U)            /* Bit[16] Push pull status */
#define SHRTIM_TXINTSTS_DPITF                                   ((uint32_t)0x00004000U)            /* Bit[14] Delayed protection interrupt flag */
#define SHRTIM_TXINTSTS_RSTROITF                                ((uint32_t)0x00002000U)            /* Bit[13] Counter reset or roll-over status */
#define SHRTIM_TXINTSTS_RST2ITF                                 ((uint32_t)0x00001000U)            /* Bit[12] Output 2 reset interrupt flag */
#define SHRTIM_TXINTSTS_SET2ITF                                 ((uint32_t)0x00000800U)            /* Bit[11] Output 2 set interrupt flag */
#define SHRTIM_TXINTSTS_RST1ITF                                 ((uint32_t)0x00000400U)            /* Bit[10] Output 1  reset interrupt flag */
#define SHRTIM_TXINTSTS_SET1ITF                                 ((uint32_t)0x00000200U)            /* Bit[9] Output 1  set interrupt flag */
#define SHRTIM_TXINTSTS_CPT2ITF                                 ((uint32_t)0x00000100U)            /* Bit[8] Capture 2 interrupt flag */
#define SHRTIM_TXINTSTS_CPT1ITF                                 ((uint32_t)0x00000080U)            /* Bit[7] Capture 1 interrupt flag */
#define SHRTIM_TXINTSTS_UPDITF                                  ((uint32_t)0x00000040U)            /* Bit[6] Update interrupt flag */
#define SHRTIM_TXINTSTS_REPTITF                                 ((uint32_t)0x00000020U)            /* Bit[5] Repetition interrupt flag */
#define SHRTIM_TXINTSTS_CMP5ITF                                 ((uint32_t)0x00000010U)            /* Bit[4] Compare 5 flag */
#define SHRTIM_TXINTSTS_CMP4ITF                                 ((uint32_t)0x00000008U)            /* Bit[3] Compare 4 interrupt flag */
#define SHRTIM_TXINTSTS_CMP3ITF                                 ((uint32_t)0x00000004U)            /* Bit[2] Compare 3 interrupt flag */
#define SHRTIM_TXINTSTS_CMP2ITF                                 ((uint32_t)0x00000002U)            /* Bit[1] Compare 2 interrupt flag */
#define SHRTIM_TXINTSTS_CMP1ITF                                 ((uint32_t)0x00000001U)            /* Bit[0] Compare 1 interrupt flag */

/** Bit definition for SHRTIM_TXINTCLR register  **/
#define SHRTIM_TXINTCLR_DPIC                                    ((uint32_t)0x00004000U)            /* Bit[14] Delayed protection interrupt flag clear */
#define SHRTIM_TXINTCLR_RSTROIC                                 ((uint32_t)0x00002000U)            /* Bit[13] Reset and/or roll-over interrupt flag clear */
#define SHRTIM_TXINTCLR_RST2IC                                  ((uint32_t)0x00001000U)            /* Bit[12] Output channel 2 reset interrupt flag clear */
#define SHRTIM_TXINTCLR_SET2IC                                  ((uint32_t)0x00000800U)            /* Bit[11] Output channel 2 set interrupt flag clear */
#define SHRTIM_TXINTCLR_RST1IC                                  ((uint32_t)0x00000400U)            /* Bit[10] Output channel 2 reset interrupt flag clear */
#define SHRTIM_TXINTCLR_SET1IC                                  ((uint32_t)0x00000200U)            /* Bit[9] Output channel 2 set interrupt flag clear */
#define SHRTIM_TXINTCLR_CPT2IC                                  ((uint32_t)0x00000100U)            /* Bit[8] Capture 2 interrupt flag clear */
#define SHRTIM_TXINTCLR_CPT1IC                                  ((uint32_t)0x00000080U)            /* Bit[7] Capture 1 interrupt flag clear */
#define SHRTIM_TXINTCLR_UPDIC                                   ((uint32_t)0x00000040U)            /* Bit[6] Update interrupt flag clear */
#define SHRTIM_TXINTCLR_REPTIC                                  ((uint32_t)0x00000020U)            /* Bit[5] Repetition interrupt flag clear */
#define SHRTIM_TXINTCLR_CMP5IC                                  ((uint32_t)0x00000010U)            /* Bit[4] Compare 5 flag clear */
#define SHRTIM_TXINTCLR_CMP4IC                                  ((uint32_t)0x00000008U)            /* Bit[3] Compare 4 interrupt flag clear */
#define SHRTIM_TXINTCLR_CMP3IC                                  ((uint32_t)0x00000004U)            /* Bit[2] Compare 3 interrupt flag clear */
#define SHRTIM_TXINTCLR_CMP2IC                                  ((uint32_t)0x00000002U)            /* Bit[1] Compare 2 interrupt flag clear */
#define SHRTIM_TXINTCLR_CMP1IC                                  ((uint32_t)0x00000001U)            /* Bit[0] Compare 1 interrupt flag clear */

/** Bit definition for SHRTIM_TXIDEN register  **/
#define SHRTIM_TXIDEN_DPDEN                                   ((uint32_t)0x40000000U)            /* Bit[30] Reserved, must be kept at reset value */
#define SHRTIM_TXIDEN_RSTRODEN                                ((uint32_t)0x20000000U)            /* Bit[29] Reset/roll-over DMA request enable */
#define SHRTIM_TXIDEN_RST2DEN                                 ((uint32_t)0x10000000U)            /* Bit[28] Output 2 reset DMA request enable */
#define SHRTIM_TXIDEN_SET2DEN                                 ((uint32_t)0x08000000U)            /* Bit[27] Output 2 set DMA request enable */
#define SHRTIM_TXIDEN_RST1DEN                                 ((uint32_t)0x04000000U)            /* Bit[26] Output 1  reset DMA request enable */
#define SHRTIM_TXIDEN_SET1DEN                                 ((uint32_t)0x02000000U)            /* Bit[25] Output 1  set DMA request enable */
#define SHRTIM_TXIDEN_CPT2DEN                                 ((uint32_t)0x01000000U)            /* Bit[24] Capture 2 DMA request enable */
#define SHRTIM_TXIDEN_CPT1DEN                                 ((uint32_t)0x00800000U)            /* Bit[23] Capture 1 DMA request enable */
#define SHRTIM_TXIDEN_UPDDEN                                  ((uint32_t)0x00400000U)            /* Bit[22] Update DMA request enable */
#define SHRTIM_TXIDEN_REPTDEN                                 ((uint32_t)0x00100000U)            /* Bit[20] Repetition DMA request enable */
#define SHRTIM_TXIDEN_CMP4DEN                                 ((uint32_t)0x00080000U)            /* Bit[19] Compare 4 DMA request enable */
#define SHRTIM_TXIDEN_CMP3DEN                                 ((uint32_t)0x00040000U)            /* Bit[18] Compare 3 DMA request enable */
#define SHRTIM_TXIDEN_CMP2DEN                                 ((uint32_t)0x00020000U)            /* Bit[17] Compare 2 DMA request enable */
#define SHRTIM_TXIDEN_CMP1DEN                                 ((uint32_t)0x00010000U)            /* Bit[16] Compare 1 DMA request enable */
#define SHRTIM_TXIDEN_DPIEN                                   ((uint32_t)0x00004000U)            /* Bit[14] Delayed protection interrupt enable */
#define SHRTIM_TXIDEN_RSTROIEN                                ((uint32_t)0x00002000U)            /* Bit[13] Reset/roll-over interrupt enable */
#define SHRTIM_TXIDEN_RST2IEN                                 ((uint32_t)0x00001000U)            /* Bit[12] Output 2 reset interrupt enable */
#define SHRTIM_TXIDEN_SET2IEN                                 ((uint32_t)0x00000800U)            /* Bit[11] Output 2 set interrupt enable */
#define SHRTIM_TXIDEN_RST1IEN                                 ((uint32_t)0x00000400U)            /* Bit[10] Output 1  reset interrupt enable */
#define SHRTIM_TXIDEN_SET1IEN                                 ((uint32_t)0x00000200U)            /* Bit[9] Output 1  set interrupt enable */
#define SHRTIM_TXIDEN_CPT2IEN                                 ((uint32_t)0x00000100U)            /* Bit[8] Capture interrupt enable */
#define SHRTIM_TXIDEN_CPT1IEN                                 ((uint32_t)0x00000080U)            /* Bit[7] Capture interrupt enable */
#define SHRTIM_TXIDEN_UPDIEN                                  ((uint32_t)0x00000040U)            /* Bit[6] Update interrupt enable */
#define SHRTIM_TXIDEN_REPTIEN                                 ((uint32_t)0x00000020U)            /* Bit[5] Repetition interrupt enable */
#define SHRTIM_TXIDEN_CMP4IEN                                 ((uint32_t)0x00000008U)            /* Bit[3] Compare 4 interrupt enable */
#define SHRTIM_TXIDEN_CMP3IEN                                 ((uint32_t)0x00000004U)            /* Bit[2] Compare 3 interrupt enable */
#define SHRTIM_TXIDEN_CMP2IEN                                 ((uint32_t)0x00000002U)            /* Bit[1] Compare 2 interrupt enable */
#define SHRTIM_TXIDEN_CMP1IEN                                 ((uint32_t)0x00000001U)            /* Bit[0] Compare 1 interrupt enable */

/** Bit definition for SHRTIM_TXCNT register  **/
#define SHRTIM_TXCNT_COUNT                                   ((uint32_t)0x0000FFFFU)            /* Bit[15:0] Timer x counter value */
#define SHRTIM_TXCNT_COUNT_0                                 ((uint32_t)0x00000001U)            /* Bit0 */
#define SHRTIM_TXCNT_COUNT_1                                 ((uint32_t)0x00000002U)            /* Bit1 */
#define SHRTIM_TXCNT_COUNT_2                                 ((uint32_t)0x00000004U)            /* Bit2 */
#define SHRTIM_TXCNT_COUNT_3                                 ((uint32_t)0x00000008U)            /* Bit3 */
#define SHRTIM_TXCNT_COUNT_4                                 ((uint32_t)0x00000010U)            /* Bit4 */
#define SHRTIM_TXCNT_COUNT_5                                 ((uint32_t)0x00000020U)            /* Bit5 */
#define SHRTIM_TXCNT_COUNT_6                                 ((uint32_t)0x00000040U)            /* Bit6 */
#define SHRTIM_TXCNT_COUNT_7                                 ((uint32_t)0x00000080U)            /* Bit7 */
#define SHRTIM_TXCNT_COUNT_8                                 ((uint32_t)0x00000100U)            /* Bit8 */
#define SHRTIM_TXCNT_COUNT_9                                 ((uint32_t)0x00000200U)            /* Bit9 */
#define SHRTIM_TXCNT_COUNT_10                                ((uint32_t)0x00000400U)            /* Bit10 */
#define SHRTIM_TXCNT_COUNT_11                                ((uint32_t)0x00000800U)            /* Bit11 */
#define SHRTIM_TXCNT_COUNT_12                                ((uint32_t)0x00001000U)            /* Bit12 */
#define SHRTIM_TXCNT_COUNT_13                                ((uint32_t)0x00002000U)            /* Bit13 */
#define SHRTIM_TXCNT_COUNT_14                                ((uint32_t)0x00004000U)            /* Bit14 */
#define SHRTIM_TXCNT_COUNT_15                                ((uint32_t)0x00008000U)            /* Bit15 */

/** Bit definition for SHRTIM_TXPRD register  **/
#define SHRTIM_TXPRD_PRD                                     ((uint32_t)0x0000FFFFU)            /* Bit[15:0] Timer x period value */
#define SHRTIM_TXPRD_PRD_0                                   ((uint32_t)0x00000001U)            /* Bit0 */
#define SHRTIM_TXPRD_PRD_1                                   ((uint32_t)0x00000002U)            /* Bit1 */
#define SHRTIM_TXPRD_PRD_2                                   ((uint32_t)0x00000004U)            /* Bit2 */
#define SHRTIM_TXPRD_PRD_3                                   ((uint32_t)0x00000008U)            /* Bit3 */
#define SHRTIM_TXPRD_PRD_4                                   ((uint32_t)0x00000010U)            /* Bit4 */
#define SHRTIM_TXPRD_PRD_5                                   ((uint32_t)0x00000020U)            /* Bit5 */
#define SHRTIM_TXPRD_PRD_6                                   ((uint32_t)0x00000040U)            /* Bit6 */
#define SHRTIM_TXPRD_PRD_7                                   ((uint32_t)0x00000080U)            /* Bit7 */
#define SHRTIM_TXPRD_PRD_8                                   ((uint32_t)0x00000100U)            /* Bit8 */
#define SHRTIM_TXPRD_PRD_9                                   ((uint32_t)0x00000200U)            /* Bit9 */
#define SHRTIM_TXPRD_PRD_10                                  ((uint32_t)0x00000400U)            /* Bit10 */
#define SHRTIM_TXPRD_PRD_11                                  ((uint32_t)0x00000800U)            /* Bit11 */
#define SHRTIM_TXPRD_PRD_12                                  ((uint32_t)0x00001000U)            /* Bit12 */
#define SHRTIM_TXPRD_PRD_13                                  ((uint32_t)0x00002000U)            /* Bit13 */
#define SHRTIM_TXPRD_PRD_14                                  ((uint32_t)0x00004000U)            /* Bit14 */
#define SHRTIM_TXPRD_PRD_15                                  ((uint32_t)0x00008000U)            /* Bit15 */

/** Bit definition for SHRTIM_TXREPT register  **/
#define SHRTIM_TXREPT_REPT                                    ((uint32_t)0x000000FFU)            /* Bit[7:0] Timer x repetition period value */
#define SHRTIM_TXREPT_REPT_0                                  ((uint32_t)0x00000001U)            /* Bit0 */
#define SHRTIM_TXREPT_REPT_1                                  ((uint32_t)0x00000002U)            /* Bit1 */
#define SHRTIM_TXREPT_REPT_2                                  ((uint32_t)0x00000004U)            /* Bit2 */
#define SHRTIM_TXREPT_REPT_3                                  ((uint32_t)0x00000008U)            /* Bit3 */
#define SHRTIM_TXREPT_REPT_4                                  ((uint32_t)0x00000010U)            /* Bit4 */
#define SHRTIM_TXREPT_REPT_5                                  ((uint32_t)0x00000020U)            /* Bit5 */
#define SHRTIM_TXREPT_REPT_6                                  ((uint32_t)0x00000040U)            /* Bit6 */
#define SHRTIM_TXREPT_REPT_7                                  ((uint32_t)0x00000080U)            /* Bit7 */

/** Bit definition for SHRTIM_TXCMP1DAT register  **/
#define SHRTIM_TXCMP1DAT_CMP1DAT                                 ((uint32_t)0x0000FFFFU)            /* Bit[15:0] Timer x compare 1 value */
#define SHRTIM_TXCMP1DAT_CMP1DAT_0                               ((uint32_t)0x00000001U)            /* Bit0 */
#define SHRTIM_TXCMP1DAT_CMP1DAT_1                               ((uint32_t)0x00000002U)            /* Bit1 */
#define SHRTIM_TXCMP1DAT_CMP1DAT_2                               ((uint32_t)0x00000004U)            /* Bit2 */
#define SHRTIM_TXCMP1DAT_CMP1DAT_3                               ((uint32_t)0x00000008U)            /* Bit3 */
#define SHRTIM_TXCMP1DAT_CMP1DAT_4                               ((uint32_t)0x00000010U)            /* Bit4 */
#define SHRTIM_TXCMP1DAT_CMP1DAT_5                               ((uint32_t)0x00000020U)            /* Bit5 */
#define SHRTIM_TXCMP1DAT_CMP1DAT_6                               ((uint32_t)0x00000040U)            /* Bit6 */
#define SHRTIM_TXCMP1DAT_CMP1DAT_7                               ((uint32_t)0x00000080U)            /* Bit7 */
#define SHRTIM_TXCMP1DAT_CMP1DAT_8                               ((uint32_t)0x00000100U)            /* Bit8 */
#define SHRTIM_TXCMP1DAT_CMP1DAT_9                               ((uint32_t)0x00000200U)            /* Bit9 */
#define SHRTIM_TXCMP1DAT_CMP1DAT_10                              ((uint32_t)0x00000400U)            /* Bit10 */
#define SHRTIM_TXCMP1DAT_CMP1DAT_11                              ((uint32_t)0x00000800U)            /* Bit11 */
#define SHRTIM_TXCMP1DAT_CMP1DAT_12                              ((uint32_t)0x00001000U)            /* Bit12 */
#define SHRTIM_TXCMP1DAT_CMP1DAT_13                              ((uint32_t)0x00002000U)            /* Bit13 */
#define SHRTIM_TXCMP1DAT_CMP1DAT_14                              ((uint32_t)0x00004000U)            /* Bit14 */
#define SHRTIM_TXCMP1DAT_CMP1DAT_15                              ((uint32_t)0x00008000U)            /* Bit15 */

/** Bit definition for SHRTIM_TXRCMP1DAT register  **/
#define SHRTIM_TXRCMP1DAT_REPT                                    ((uint32_t)0x00FF0000U)            /* Bit[23:16] Timer x repetititon counter alias */
#define SHRTIM_TXRCMP1DAT_REPT_0                                  ((uint32_t)0x00010000U)            /* Bit16 */
#define SHRTIM_TXRCMP1DAT_REPT_1                                  ((uint32_t)0x00020000U)            /* Bit17 */
#define SHRTIM_TXRCMP1DAT_REPT_2                                  ((uint32_t)0x00040000U)            /* Bit18 */
#define SHRTIM_TXRCMP1DAT_REPT_3                                  ((uint32_t)0x00080000U)            /* Bit19 */
#define SHRTIM_TXRCMP1DAT_REPT_4                                  ((uint32_t)0x00100000U)            /* Bit20 */
#define SHRTIM_TXRCMP1DAT_REPT_5                                  ((uint32_t)0x00200000U)            /* Bit21 */
#define SHRTIM_TXRCMP1DAT_REPT_6                                  ((uint32_t)0x00400000U)            /* Bit22 */
#define SHRTIM_TXRCMP1DAT_REPT_7                                  ((uint32_t)0x00800000U)            /* Bit23 */
#define SHRTIM_TXRCMP1DAT_CMP1DAT                                 ((uint32_t)0x0000FFFFU)            /* Bit[15:0] Timer x compare 1 data */
#define SHRTIM_TXRCMP1DAT_CMP1DAT_0                               ((uint32_t)0x00000001U)            /* Bit0 */
#define SHRTIM_TXRCMP1DAT_CMP1DAT_1                               ((uint32_t)0x00000002U)            /* Bit1 */
#define SHRTIM_TXRCMP1DAT_CMP1DAT_2                               ((uint32_t)0x00000004U)            /* Bit2 */
#define SHRTIM_TXRCMP1DAT_CMP1DAT_3                               ((uint32_t)0x00000008U)            /* Bit3 */
#define SHRTIM_TXRCMP1DAT_CMP1DAT_4                               ((uint32_t)0x00000010U)            /* Bit4 */
#define SHRTIM_TXRCMP1DAT_CMP1DAT_5                               ((uint32_t)0x00000020U)            /* Bit5 */
#define SHRTIM_TXRCMP1DAT_CMP1DAT_6                               ((uint32_t)0x00000040U)            /* Bit6 */
#define SHRTIM_TXRCMP1DAT_CMP1DAT_7                               ((uint32_t)0x00000080U)            /* Bit7 */
#define SHRTIM_TXRCMP1DAT_CMP1DAT_8                               ((uint32_t)0x00000100U)            /* Bit8 */
#define SHRTIM_TXRCMP1DAT_CMP1DAT_9                               ((uint32_t)0x00000200U)            /* Bit9 */
#define SHRTIM_TXRCMP1DAT_CMP1DAT_10                              ((uint32_t)0x00000400U)            /* Bit10 */
#define SHRTIM_TXRCMP1DAT_CMP1DAT_11                              ((uint32_t)0x00000800U)            /* Bit11 */
#define SHRTIM_TXRCMP1DAT_CMP1DAT_12                              ((uint32_t)0x00001000U)            /* Bit12 */
#define SHRTIM_TXRCMP1DAT_CMP1DAT_13                              ((uint32_t)0x00002000U)            /* Bit13 */
#define SHRTIM_TXRCMP1DAT_CMP1DAT_14                              ((uint32_t)0x00004000U)            /* Bit14 */
#define SHRTIM_TXRCMP1DAT_CMP1DAT_15                              ((uint32_t)0x00008000U)            /* Bit15 */

/** Bit definition for SHRTIM_TxCMP2DAT register  **/
#define SHRTIM_TXCMP2DAT_CMP2DAT                                 ((uint32_t)0x0000FFFFU)            /* Bit[15:0] Timer x compare 2 data */
#define SHRTIM_TXCMP2DAT_CMP2DAT_0                               ((uint32_t)0x00000001U)            /* Bit0 */
#define SHRTIM_TXCMP2DAT_CMP2DAT_1                               ((uint32_t)0x00000002U)            /* Bit1 */
#define SHRTIM_TXCMP2DAT_CMP2DAT_2                               ((uint32_t)0x00000004U)            /* Bit2 */
#define SHRTIM_TXCMP2DAT_CMP2DAT_3                               ((uint32_t)0x00000008U)            /* Bit3 */
#define SHRTIM_TXCMP2DAT_CMP2DAT_4                               ((uint32_t)0x00000010U)            /* Bit4 */
#define SHRTIM_TXCMP2DAT_CMP2DAT_5                               ((uint32_t)0x00000020U)            /* Bit5 */
#define SHRTIM_TXCMP2DAT_CMP2DAT_6                               ((uint32_t)0x00000040U)            /* Bit6 */
#define SHRTIM_TXCMP2DAT_CMP2DAT_7                               ((uint32_t)0x00000080U)            /* Bit7 */
#define SHRTIM_TXCMP2DAT_CMP2DAT_8                               ((uint32_t)0x00000100U)            /* Bit8 */
#define SHRTIM_TXCMP2DAT_CMP2DAT_9                               ((uint32_t)0x00000200U)            /* Bit9 */
#define SHRTIM_TXCMP2DAT_CMP2DAT_10                              ((uint32_t)0x00000400U)            /* Bit10 */
#define SHRTIM_TXCMP2DAT_CMP2DAT_11                              ((uint32_t)0x00000800U)            /* Bit11 */
#define SHRTIM_TXCMP2DAT_CMP2DAT_12                              ((uint32_t)0x00001000U)            /* Bit12 */
#define SHRTIM_TXCMP2DAT_CMP2DAT_13                              ((uint32_t)0x00002000U)            /* Bit13 */
#define SHRTIM_TXCMP2DAT_CMP2DAT_14                              ((uint32_t)0x00004000U)            /* Bit14 */
#define SHRTIM_TXCMP2DAT_CMP2DAT_15                              ((uint32_t)0x00008000U)            /* Bit15 */

/** Bit definition for SHRTIM_TXCMP3DAT register  **/
#define SHRTIM_TXCMP3DAT_CMP3DAT                                 ((uint32_t)0x0000FFFFU)            /* Bit[15:0] Timer x compare 3 data */
#define SHRTIM_TXCMP3DAT_CMP3DAT_0                               ((uint32_t)0x00000001U)            /* Bit0 */
#define SHRTIM_TXCMP3DAT_CMP3DAT_1                               ((uint32_t)0x00000002U)            /* Bit1 */
#define SHRTIM_TXCMP3DAT_CMP3DAT_2                               ((uint32_t)0x00000004U)            /* Bit2 */
#define SHRTIM_TXCMP3DAT_CMP3DAT_3                               ((uint32_t)0x00000008U)            /* Bit3 */
#define SHRTIM_TXCMP3DAT_CMP3DAT_4                               ((uint32_t)0x00000010U)            /* Bit4 */
#define SHRTIM_TXCMP3DAT_CMP3DAT_5                               ((uint32_t)0x00000020U)            /* Bit5 */
#define SHRTIM_TXCMP3DAT_CMP3DAT_6                               ((uint32_t)0x00000040U)            /* Bit6 */
#define SHRTIM_TXCMP3DAT_CMP3DAT_7                               ((uint32_t)0x00000080U)            /* Bit7 */
#define SHRTIM_TXCMP3DAT_CMP3DAT_8                               ((uint32_t)0x00000100U)            /* Bit8 */
#define SHRTIM_TXCMP3DAT_CMP3DAT_9                               ((uint32_t)0x00000200U)            /* Bit9 */
#define SHRTIM_TXCMP3DAT_CMP3DAT_10                              ((uint32_t)0x00000400U)            /* Bit10 */
#define SHRTIM_TXCMP3DAT_CMP3DAT_11                              ((uint32_t)0x00000800U)            /* Bit11 */
#define SHRTIM_TXCMP3DAT_CMP3DAT_12                              ((uint32_t)0x00001000U)            /* Bit12 */
#define SHRTIM_TXCMP3DAT_CMP3DAT_13                              ((uint32_t)0x00002000U)            /* Bit13 */
#define SHRTIM_TXCMP3DAT_CMP3DAT_14                              ((uint32_t)0x00004000U)            /* Bit14 */
#define SHRTIM_TXCMP3DAT_CMP3DAT_15                              ((uint32_t)0x00008000U)            /* Bit15 */

/** Bit definition for SHRTIM_TXCMP4DAT register  **/
#define SHRTIM_TXCMP4DAT_CMP4DAT                                 ((uint32_t)0x0000FFFFU)            /* Bit[15:0] Timer x compare 4 data */
#define SHRTIM_TXCMP4DAT_CMP4DAT_0                               ((uint32_t)0x00000001U)            /* Bit0 */
#define SHRTIM_TXCMP4DAT_CMP4DAT_1                               ((uint32_t)0x00000002U)            /* Bit1 */
#define SHRTIM_TXCMP4DAT_CMP4DAT_2                               ((uint32_t)0x00000004U)            /* Bit2 */
#define SHRTIM_TXCMP4DAT_CMP4DAT_3                               ((uint32_t)0x00000008U)            /* Bit3 */
#define SHRTIM_TXCMP4DAT_CMP4DAT_4                               ((uint32_t)0x00000010U)            /* Bit4 */
#define SHRTIM_TXCMP4DAT_CMP4DAT_5                               ((uint32_t)0x00000020U)            /* Bit5 */
#define SHRTIM_TXCMP4DAT_CMP4DAT_6                               ((uint32_t)0x00000040U)            /* Bit6 */
#define SHRTIM_TXCMP4DAT_CMP4DAT_7                               ((uint32_t)0x00000080U)            /* Bit7 */
#define SHRTIM_TXCMP4DAT_CMP4DAT_8                               ((uint32_t)0x00000100U)            /* Bit8 */
#define SHRTIM_TXCMP4DAT_CMP4DAT_9                               ((uint32_t)0x00000200U)            /* Bit9 */
#define SHRTIM_TXCMP4DAT_CMP4DAT_10                              ((uint32_t)0x00000400U)            /* Bit10 */
#define SHRTIM_TXCMP4DAT_CMP4DAT_11                              ((uint32_t)0x00000800U)            /* Bit11 */
#define SHRTIM_TXCMP4DAT_CMP4DAT_12                              ((uint32_t)0x00001000U)            /* Bit12 */
#define SHRTIM_TXCMP4DAT_CMP4DAT_13                              ((uint32_t)0x00002000U)            /* Bit13 */
#define SHRTIM_TXCMP4DAT_CMP4DAT_14                              ((uint32_t)0x00004000U)            /* Bit14 */
#define SHRTIM_TXCMP4DAT_CMP4DAT_15                              ((uint32_t)0x00008000U)            /* Bit15 */

/** Bit definition for SHRTIM_TXCPT1 register  **/
#define SHRTIM_TXCPT1_UDSTS1                                  ((uint32_t)0x00010000U)            /* Bit[16] Status for timer x counting direction while capture 1 happened */
#define SHRTIM_TXCPT1_CPT1                                    ((uint32_t)0x0000FFFFU)            /* Bit[15:0] Timer x capture 1 data */
#define SHRTIM_TXCPT1_CPT1_0                                  ((uint32_t)0x00000001U)            /* Bit0 */
#define SHRTIM_TXCPT1_CPT1_1                                  ((uint32_t)0x00000002U)            /* Bit1 */
#define SHRTIM_TXCPT1_CPT1_2                                  ((uint32_t)0x00000004U)            /* Bit2 */
#define SHRTIM_TXCPT1_CPT1_3                                  ((uint32_t)0x00000008U)            /* Bit3 */
#define SHRTIM_TXCPT1_CPT1_4                                  ((uint32_t)0x00000010U)            /* Bit4 */
#define SHRTIM_TXCPT1_CPT1_5                                  ((uint32_t)0x00000020U)            /* Bit5 */
#define SHRTIM_TXCPT1_CPT1_6                                  ((uint32_t)0x00000040U)            /* Bit6 */
#define SHRTIM_TXCPT1_CPT1_7                                  ((uint32_t)0x00000080U)            /* Bit7 */
#define SHRTIM_TXCPT1_CPT1_8                                  ((uint32_t)0x00000100U)            /* Bit8 */
#define SHRTIM_TXCPT1_CPT1_9                                  ((uint32_t)0x00000200U)            /* Bit9 */
#define SHRTIM_TXCPT1_CPT1_10                                 ((uint32_t)0x00000400U)            /* Bit10 */
#define SHRTIM_TXCPT1_CPT1_11                                 ((uint32_t)0x00000800U)            /* Bit11 */
#define SHRTIM_TXCPT1_CPT1_12                                 ((uint32_t)0x00001000U)            /* Bit12 */
#define SHRTIM_TXCPT1_CPT1_13                                 ((uint32_t)0x00002000U)            /* Bit13 */
#define SHRTIM_TXCPT1_CPT1_14                                 ((uint32_t)0x00004000U)            /* Bit14 */
#define SHRTIM_TXCPT1_CPT1_15                                 ((uint32_t)0x00008000U)            /* Bit15 */

/** Bit definition for SHRTIM_TXCPT2 register  **/
#define SHRTIM_TXCPT2_UDSTS2                                  ((uint32_t)0x00010000U)            /* Bit[16] Status for timer x counting direction while capture 2 happened */
#define SHRTIM_TXCPT2_CPT2                                    ((uint32_t)0x0000FFFFU)            /* Bit[15:0] Timer x capture 2 data */
#define SHRTIM_TXCPT2_CPT2_0                                  ((uint32_t)0x00000001U)            /* Bit0 */
#define SHRTIM_TXCPT2_CPT2_1                                  ((uint32_t)0x00000002U)            /* Bit1 */
#define SHRTIM_TXCPT2_CPT2_2                                  ((uint32_t)0x00000004U)            /* Bit2 */
#define SHRTIM_TXCPT2_CPT2_3                                  ((uint32_t)0x00000008U)            /* Bit3 */
#define SHRTIM_TXCPT2_CPT2_4                                  ((uint32_t)0x00000010U)            /* Bit4 */
#define SHRTIM_TXCPT2_CPT2_5                                  ((uint32_t)0x00000020U)            /* Bit5 */
#define SHRTIM_TXCPT2_CPT2_6                                  ((uint32_t)0x00000040U)            /* Bit6 */
#define SHRTIM_TXCPT2_CPT2_7                                  ((uint32_t)0x00000080U)            /* Bit7 */
#define SHRTIM_TXCPT2_CPT2_8                                  ((uint32_t)0x00000100U)            /* Bit8 */
#define SHRTIM_TXCPT2_CPT2_9                                  ((uint32_t)0x00000200U)            /* Bit9 */
#define SHRTIM_TXCPT2_CPT2_10                                 ((uint32_t)0x00000400U)            /* Bit10 */
#define SHRTIM_TXCPT2_CPT2_11                                 ((uint32_t)0x00000800U)            /* Bit11 */
#define SHRTIM_TXCPT2_CPT2_12                                 ((uint32_t)0x00001000U)            /* Bit12 */
#define SHRTIM_TXCPT2_CPT2_13                                 ((uint32_t)0x00002000U)            /* Bit13 */
#define SHRTIM_TXCPT2_CPT2_14                                 ((uint32_t)0x00004000U)            /* Bit14 */
#define SHRTIM_TXCPT2_CPT2_15                                 ((uint32_t)0x00008000U)            /* Bit15 */

/** Bit definition for SHRTIM_TXDT register  **/
#define SHRTIM_TXDT_DTFLCK                                 ((uint32_t)0x80000000U)            /* Bit[31] Deadtime falling lock */
#define SHRTIM_TXDT_DTFSLCK                                 ((uint32_t)0x40000000U)            /* Bit[30] Deadtime falling sign lock */
#define SHRTIM_TXDT_SDTF                                    ((uint32_t)0x02000000U)            /* Bit[25] Sign deadtime falling value */
#define SHRTIM_TXDT_DTF                                    ((uint32_t)0x01FF0000U)            /* Bit[24:16] Deadtime falling value */
#define SHRTIM_TXDT_DTF_0                                  ((uint32_t)0x00010000U)            /* Bit16 */
#define SHRTIM_TXDT_DTF_1                                  ((uint32_t)0x00020000U)            /* Bit17 */
#define SHRTIM_TXDT_DTF_2                                  ((uint32_t)0x00040000U)            /* Bit18 */
#define SHRTIM_TXDT_DTF_3                                  ((uint32_t)0x00080000U)            /* Bit19 */
#define SHRTIM_TXDT_DTF_4                                  ((uint32_t)0x00100000U)            /* Bit20 */
#define SHRTIM_TXDT_DTF_5                                  ((uint32_t)0x00200000U)            /* Bit21 */
#define SHRTIM_TXDT_DTF_6                                  ((uint32_t)0x00400000U)            /* Bit22 */
#define SHRTIM_TXDT_DTF_7                                  ((uint32_t)0x00800000U)            /* Bit23 */
#define SHRTIM_TXDT_DTF_8                                  ((uint32_t)0x01000000U)            /* Bit24 */
#define SHRTIM_TXDT_DTRLCK                                 ((uint32_t)0x00008000U)            /* Bit[15] Deadtime rising lock */
#define SHRTIM_TXDT_DTRSLCK                                 ((uint32_t)0x00004000U)            /* Bit[14] Deadtime rising sign lock */
#define SHRTIM_TXDT_DTPSC                                   ((uint32_t)0x00001C00U)            /* Bit[12:10] Deadtime prescaler */
#define SHRTIM_TXDT_DTPSC_0                                 ((uint32_t)0x00000400U)            /* Bit10 */
#define SHRTIM_TXDT_DTPSC_1                                 ((uint32_t)0x00000800U)            /* Bit11 */
#define SHRTIM_TXDT_DTPSC_2                                 ((uint32_t)0x00001000U)            /* Bit12 */
#define SHRTIM_TXDT_SDTR                                    ((uint32_t)0x00000200U)            /* Bit[9] Sign deadtime rising value */
#define SHRTIM_TXDT_DTR                                    ((uint32_t)0x000001FFU)            /* Bit[8:0] Deadtime rising value */
#define SHRTIM_TXDT_DTR_0                                  ((uint32_t)0x00000001U)            /* Bit0 */
#define SHRTIM_TXDT_DTR_1                                  ((uint32_t)0x00000002U)            /* Bit1 */
#define SHRTIM_TXDT_DTR_2                                  ((uint32_t)0x00000004U)            /* Bit2 */
#define SHRTIM_TXDT_DTR_3                                  ((uint32_t)0x00000008U)            /* Bit3 */
#define SHRTIM_TXDT_DTR_4                                  ((uint32_t)0x00000010U)            /* Bit4 */
#define SHRTIM_TXDT_DTR_5                                  ((uint32_t)0x00000020U)            /* Bit5 */
#define SHRTIM_TXDT_DTR_6                                  ((uint32_t)0x00000040U)            /* Bit6 */
#define SHRTIM_TXDT_DTR_7                                  ((uint32_t)0x00000080U)            /* Bit7 */
#define SHRTIM_TXDT_DTR_8                                  ((uint32_t)0x00000100U)            /* Bit8 */

/** Bit definition for SHRTIM_TXSET1 register  **/
#define SHRTIM_TXSET1_UPD                                     ((uint32_t)0x80000000U)            /* Bit[31] Registers update (transfer preload to active) */
#define SHRTIM_TXSET1_EXEV10                                  ((uint32_t)0x40000000U)            /* Bit[30] External event 10 */
#define SHRTIM_TXSET1_EXEV9                                   ((uint32_t)0x20000000U)            /* Bit[29] External event 9 */
#define SHRTIM_TXSET1_EXEV8                                   ((uint32_t)0x10000000U)            /* Bit[28] External event 8 */
#define SHRTIM_TXSET1_EXEV7                                   ((uint32_t)0x08000000U)            /* Bit[27] External event 7 */
#define SHRTIM_TXSET1_EXEV6                                   ((uint32_t)0x04000000U)            /* Bit[26] External event 6 */
#define SHRTIM_TXSET1_EXEV5                                   ((uint32_t)0x02000000U)            /* Bit[25] External event 5 */
#define SHRTIM_TXSET1_EXEV4                                   ((uint32_t)0x01000000U)            /* Bit[24] External event 4 */
#define SHRTIM_TXSET1_EXEV3                                   ((uint32_t)0x00800000U)            /* Bit[23] External event 3 */
#define SHRTIM_TXSET1_EXEV2                                   ((uint32_t)0x00400000U)            /* Bit[22] External event 2 */
#define SHRTIM_TXSET1_EXEV1                                   ((uint32_t)0x00200000U)            /* Bit[21] External event 1 */
#define SHRTIM_TXSET1_TIMEV9                                  ((uint32_t)0x00100000U)            /* Bit[20] Timer event 9 */
#define SHRTIM_TXSET1_TIMEV8                                  ((uint32_t)0x00080000U)            /* Bit[19] Timer event 8 */
#define SHRTIM_TXSET1_TIMEV7                                  ((uint32_t)0x00040000U)            /* Bit[18] Timer event 7 */
#define SHRTIM_TXSET1_TIMEV6                                  ((uint32_t)0x00020000U)            /* Bit[17] Timer event 6 */
#define SHRTIM_TXSET1_TIMEV5                                  ((uint32_t)0x00010000U)            /* Bit[16] Timer event 5 */
#define SHRTIM_TXSET1_TIMEV4                                  ((uint32_t)0x00008000U)            /* Bit[15] Timer event 4 */
#define SHRTIM_TXSET1_TIMEV3                                  ((uint32_t)0x00004000U)            /* Bit[14] Timer event 3 */
#define SHRTIM_TXSET1_TIMEV2                                  ((uint32_t)0x00002000U)            /* Bit[13] Timer event 2 */
#define SHRTIM_TXSET1_TIMEV1                                  ((uint32_t)0x00001000U)            /* Bit[12] Timer event 1 */
#define SHRTIM_TXSET1_MCMP4                                   ((uint32_t)0x00000800U)            /* Bit[11] Master compare 4 */
#define SHRTIM_TXSET1_MCMP3                                   ((uint32_t)0x00000400U)            /* Bit[10] Master compare 3 */
#define SHRTIM_TXSET1_MCMP2                                   ((uint32_t)0x00000200U)            /* Bit[9] Master compare 2 */
#define SHRTIM_TXSET1_MCMP1                                   ((uint32_t)0x00000100U)            /* Bit[8] Master compare 1 */
#define SHRTIM_TXSET1_MPRD                                    ((uint32_t)0x00000080U)            /* Bit[7] Master period */
#define SHRTIM_TXSET1_CMP4                                    ((uint32_t)0x00000040U)            /* Bit[6] Timer x compare 4 */
#define SHRTIM_TXSET1_CMP3                                    ((uint32_t)0x00000020U)            /* Bit[5] Timer x compare 3 */
#define SHRTIM_TXSET1_CMP2                                    ((uint32_t)0x00000010U)            /* Bit[4] Timer x compare 2 */
#define SHRTIM_TXSET1_CMP1                                    ((uint32_t)0x00000008U)            /* Bit[3] Timer x compare 1 */
#define SHRTIM_TXSET1_PRD                                     ((uint32_t)0x00000004U)            /* Bit[2] Timer x period */
#define SHRTIM_TXSET1_RSYNC                                    ((uint32_t)0x00000002U)            /* Bit[1] Timer x resynchronization */
#define SHRTIM_TXSET1_SWT                                     ((uint32_t)0x00000001U)            /* Bit[0] Software set trigger */

/** Bit definition for SHRTIM_TXRST1 register  **/
#define SHRTIM_TXRST1_UPD                                     ((uint32_t)0x80000000U)            /* Bit[31] Refer to SHRTIM_TASET1 bits description. */
#define SHRTIM_TXRST1_EXEV10                                  ((uint32_t)0x40000000U)            /* Bit[30] Refer to SHRTIM_TASET1 bits description. */
#define SHRTIM_TXRST1_EXEV9                                   ((uint32_t)0x20000000U)            /* Bit[29] Refer to SHRTIM_TASET1 bits description. */
#define SHRTIM_TXRST1_EXEV8                                   ((uint32_t)0x10000000U)            /* Bit[28] Refer to SHRTIM_TASET1 bits description. */
#define SHRTIM_TXRST1_EXEV7                                   ((uint32_t)0x08000000U)            /* Bit[27] Refer to SHRTIM_TASET1 bits description. */
#define SHRTIM_TXRST1_EXEV6                                   ((uint32_t)0x04000000U)            /* Bit[26] Refer to SHRTIM_TASET1 bits description. */
#define SHRTIM_TXRST1_EXEV5                                   ((uint32_t)0x02000000U)            /* Bit[25] Refer to SHRTIM_TASET1 bits description. */
#define SHRTIM_TXRST1_EXEV4                                   ((uint32_t)0x01000000U)            /* Bit[24] Refer to SHRTIM_TASET1 bits description. */
#define SHRTIM_TXRST1_EXEV3                                   ((uint32_t)0x00800000U)            /* Bit[23] Refer to SHRTIM_TASET1 bits description. */
#define SHRTIM_TXRST1_EXEV2                                   ((uint32_t)0x00400000U)            /* Bit[22] Refer to SHRTIM_TASET1 bits description. */
#define SHRTIM_TXRST1_EXEV1                                   ((uint32_t)0x00200000U)            /* Bit[21] Refer to SHRTIM_TASET1 bits description. */
#define SHRTIM_TXRST1_TIMEV9                                  ((uint32_t)0x00100000U)            /* Bit[20] Refer to SHRTIM_TASET1 bits description. */
#define SHRTIM_TXRST1_TIMEV8                                  ((uint32_t)0x00080000U)            /* Bit[19] Refer to SHRTIM_TASET1 bits description. */
#define SHRTIM_TXRST1_TIMEV7                                  ((uint32_t)0x00040000U)            /* Bit[18] Refer to SHRTIM_TASET1 bits description. */
#define SHRTIM_TXRST1_TIMEV6                                  ((uint32_t)0x00020000U)            /* Bit[17] Refer to SHRTIM_TASET1 bits description. */
#define SHRTIM_TXRST1_TIMEV5                                  ((uint32_t)0x00010000U)            /* Bit[16] Refer to SHRTIM_TASET1 bits description. */
#define SHRTIM_TXRST1_TIMEV4                                  ((uint32_t)0x00008000U)            /* Bit[15] Refer to SHRTIM_TASET1 bits description. */
#define SHRTIM_TXRST1_TIMEV3                                  ((uint32_t)0x00004000U)            /* Bit[14] Refer to SHRTIM_TASET1 bits description. */
#define SHRTIM_TXRST1_TIMEV2                                  ((uint32_t)0x00002000U)            /* Bit[13] Refer to SHRTIM_TASET1 bits description. */
#define SHRTIM_TXRST1_TIMEV1                                  ((uint32_t)0x00001000U)            /* Bit[12] Refer to SHRTIM_TASET1 bits description. */
#define SHRTIM_TXRST1_MCMP4                                   ((uint32_t)0x00000800U)            /* Bit[11] Refer to SHRTIM_TASET1 bits description. */
#define SHRTIM_TXRST1_MCMP3                                   ((uint32_t)0x00000400U)            /* Bit[10] Refer to SHRTIM_TASET1 bits description. */
#define SHRTIM_TXRST1_MCMP2                                   ((uint32_t)0x00000200U)            /* Bit[9] Refer to SHRTIM_TASET1 bits description. */
#define SHRTIM_TXRST1_MCMP1                                   ((uint32_t)0x00000100U)            /* Bit[8] Refer to SHRTIM_TASET1 bits description. */
#define SHRTIM_TXRST1_MPRD                                    ((uint32_t)0x00000080U)            /* Bit[7] Refer to SHRTIM_TASET1 bits description. */
#define SHRTIM_TXRST1_CMP4                                    ((uint32_t)0x00000040U)            /* Bit[6] Refer to SHRTIM_TASET1 bits description. */
#define SHRTIM_TXRST1_CMP3                                    ((uint32_t)0x00000020U)            /* Bit[5] Refer to SHRTIM_TASET1 bits description. */
#define SHRTIM_TXRST1_CMP2                                    ((uint32_t)0x00000010U)            /* Bit[4] Refer to SHRTIM_TASET1 bits description. */
#define SHRTIM_TXRST1_CMP1                                    ((uint32_t)0x00000008U)            /* Bit[3] Refer to SHRTIM_TASET1 bits description. */
#define SHRTIM_TXRST1_PRD                                     ((uint32_t)0x00000004U)            /* Bit[2] Refer to SHRTIM_TASET1 bits description. */
#define SHRTIM_TXRST1_RSYNC                                    ((uint32_t)0x00000002U)            /* Bit[1] Refer to SHRTIM_TASET1 bits description. */
#define SHRTIM_TXRST1_SWT                                     ((uint32_t)0x00000001U)            /* Bit[0] Refer to SHRTIM_TASET1 bits description. */

/** Bit definition for SHRTIM_TXSET2 register  **/
#define SHRTIM_TXSET2_UPD                                     ((uint32_t)0x80000000U)            /* Bit[31] Refer to SHRTIM_TASET1 bits description. */
#define SHRTIM_TXSET2_EXEV10                                  ((uint32_t)0x40000000U)            /* Bit[30] Refer to SHRTIM_TASET1 bits description. */
#define SHRTIM_TXSET2_EXEV9                                   ((uint32_t)0x20000000U)            /* Bit[29] Refer to SHRTIM_TASET1 bits description. */
#define SHRTIM_TXSET2_EXEV8                                   ((uint32_t)0x10000000U)            /* Bit[28] Refer to SHRTIM_TASET1 bits description. */
#define SHRTIM_TXSET2_EXEV7                                   ((uint32_t)0x08000000U)            /* Bit[27] Refer to SHRTIM_TASET1 bits description. */
#define SHRTIM_TXSET2_EXEV6                                   ((uint32_t)0x04000000U)            /* Bit[26] Refer to SHRTIM_TASET1 bits description. */
#define SHRTIM_TXSET2_EXEV5                                   ((uint32_t)0x02000000U)            /* Bit[25] Refer to SHRTIM_TASET bits description. */
#define SHRTIM_TXSET2_EXEV4                                   ((uint32_t)0x01000000U)            /* Bit[24] Refer to SHRTIM_TASET bits description. */
#define SHRTIM_TXSET2_EXEV3                                   ((uint32_t)0x00800000U)            /* Bit[23] Refer to SHRTIM_TASET bits description. */
#define SHRTIM_TXSET2_EXEV2                                   ((uint32_t)0x00400000U)            /* Bit[22] Refer to SHRTIM_TASET bits description. */
#define SHRTIM_TXSET2_EXEV1                                   ((uint32_t)0x00200000U)            /* Bit[21] Refer to SHRTIM_TASET bits description. */
#define SHRTIM_TXSET2_TIMEV9                                  ((uint32_t)0x00100000U)            /* Bit[20] Refer to SHRTIM_TASET bits description. */
#define SHRTIM_TXSET2_TIMEV8                                  ((uint32_t)0x00080000U)            /* Bit[19] Refer to SHRTIM_TASET bits description. */
#define SHRTIM_TXSET2_TIMEV7                                  ((uint32_t)0x00040000U)            /* Bit[18] Refer to SHRTIM_TASET bits description. */
#define SHRTIM_TXSET2_TIMEV6                                  ((uint32_t)0x00020000U)            /* Bit[17] Refer to SHRTIM_TASET bits description. */
#define SHRTIM_TXSET2_TIMEV5                                  ((uint32_t)0x00010000U)            /* Bit[16] Refer to SHRTIM_TASET bits description. */
#define SHRTIM_TXSET2_TIMEV4                                  ((uint32_t)0x00008000U)            /* Bit[15] Refer to SHRTIM_TASET bits description. */
#define SHRTIM_TXSET2_TIMEV3                                  ((uint32_t)0x00004000U)            /* Bit[14] Refer to SHRTIM_TASET bits description. */
#define SHRTIM_TXSET2_TIMEV2                                  ((uint32_t)0x00002000U)            /* Bit[13] Refer to SHRTIM_TASET bits description. */
#define SHRTIM_TXSET2_TIMEV1                                  ((uint32_t)0x00001000U)            /* Bit[12] Refer to SHRTIM_TASET bits description. */
#define SHRTIM_TXSET2_MCMP4                                   ((uint32_t)0x00000800U)            /* Bit[11] Refer to SHRTIM_TASET bits description. */
#define SHRTIM_TXSET2_MCMP3                                   ((uint32_t)0x00000400U)            /* Bit[10] Refer to SHRTIM_TASET bits description. */
#define SHRTIM_TXSET2_MCMP2                                   ((uint32_t)0x00000200U)            /* Bit[9] Refer to SHRTIM_TASET bits description. */
#define SHRTIM_TXSET2_MCMP1                                   ((uint32_t)0x00000100U)            /* Bit[8] Refer to SHRTIM_TASET bits description. */
#define SHRTIM_TXSET2_MPRD                                    ((uint32_t)0x00000080U)            /* Bit[7] Refer to SHRTIM_TASET bits description. */
#define SHRTIM_TXSET2_CMP4                                    ((uint32_t)0x00000040U)            /* Bit[6] Refer to SHRTIM_TASET bits description. */
#define SHRTIM_TXSET2_CMP3                                    ((uint32_t)0x00000020U)            /* Bit[5] Refer to SHRTIM_TASET bits description. */
#define SHRTIM_TXSET2_CMP2                                    ((uint32_t)0x00000010U)            /* Bit[4] Refer to SHRTIM_TASET bits description. */
#define SHRTIM_TXSET2_CMP1                                    ((uint32_t)0x00000008U)            /* Bit[3] Refer to SHRTIM_TASET bits description. */
#define SHRTIM_TXSET2_PRD                                     ((uint32_t)0x00000004U)            /* Bit[2] Refer to SHRTIM_TASET bits description. */
#define SHRTIM_TXSET2_RSYNC                                    ((uint32_t)0x00000002U)            /* Bit[1] Refer to SHRTIM_TASET bits description. */
#define SHRTIM_TXSET2_SWT                                     ((uint32_t)0x00000001U)            /* Bit[0] Refer to SHRTIM_TASET bits description. */

/** Bit definition for SHRTIM_TXRST2 register  **/
#define SHRTIM_TXRST2_UPD                                     ((uint32_t)0x80000000U)            /* Bit[31] Refer to SHRTIM_TASET bits description. */
#define SHRTIM_TXRST2_EXEV10                                  ((uint32_t)0x40000000U)            /* Bit[30] Refer to SHRTIM_TASET bits description. */
#define SHRTIM_TXRST2_EXEV9                                   ((uint32_t)0x20000000U)            /* Bit[29] Refer to SHRTIM_TASET bits description. */
#define SHRTIM_TXRST2_EXEV8                                   ((uint32_t)0x10000000U)            /* Bit[28] Refer to SHRTIM_TASET bits description. */
#define SHRTIM_TXRST2_EXEV7                                   ((uint32_t)0x08000000U)            /* Bit[27] Refer to SHRTIM_TASET bits description. */
#define SHRTIM_TXRST2_EXEV6                                   ((uint32_t)0x04000000U)            /* Bit[26] Refer to SHRTIM_TASET bits description. */
#define SHRTIM_TXRST2_EXEV5                                   ((uint32_t)0x02000000U)            /* Bit[25] Refer to SHRTIM_TASET bits description. */
#define SHRTIM_TXRST2_EXEV4                                   ((uint32_t)0x01000000U)            /* Bit[24] Refer to SHRTIM_TASET bits description. */
#define SHRTIM_TXRST2_EXEV3                                   ((uint32_t)0x00800000U)            /* Bit[23] Refer to SHRTIM_TASET bits description. */
#define SHRTIM_TXRST2_EXEV2                                   ((uint32_t)0x00400000U)            /* Bit[22] Refer to SHRTIM_TASET bits description. */
#define SHRTIM_TXRST2_EXEV1                                   ((uint32_t)0x00200000U)            /* Bit[21] Refer to SHRTIM_TASET bits description. */
#define SHRTIM_TXRST2_TIMEV9                                  ((uint32_t)0x00100000U)            /* Bit[20] Refer to SHRTIM_TASET bits description. */
#define SHRTIM_TXRST2_TIMEV8                                  ((uint32_t)0x00080000U)            /* Bit[19] Refer to SHRTIM_TASET bits description. */
#define SHRTIM_TXRST2_TIMEV7                                  ((uint32_t)0x00040000U)            /* Bit[18] Refer to SHRTIM_TASET bits description. */
#define SHRTIM_TXRST2_TIMEV6                                  ((uint32_t)0x00020000U)            /* Bit[17] Refer to SHRTIM_TASET bits description. */
#define SHRTIM_TXRST2_TIMEV5                                  ((uint32_t)0x00010000U)            /* Bit[16] Refer to SHRTIM_TASET bits description. */
#define SHRTIM_TXRST2_TIMEV4                                  ((uint32_t)0x00008000U)            /* Bit[15] Refer to SHRTIM_TASET bits description. */
#define SHRTIM_TXRST2_TIMEV3                                  ((uint32_t)0x00004000U)            /* Bit[14] Refer to SHRTIM_TASET bits description. */
#define SHRTIM_TXRST2_TIMEV2                                  ((uint32_t)0x00002000U)            /* Bit[13] Refer to SHRTIM_TASET bits description. */
#define SHRTIM_TXRST2_TIMEV1                                  ((uint32_t)0x00001000U)            /* Bit[12] Refer to SHRTIM_TASET bits description. */
#define SHRTIM_TXRST2_MCMP4                                   ((uint32_t)0x00000800U)            /* Bit[11] Refer to SHRTIM_TASET bits description. */
#define SHRTIM_TXRST2_MCMP3                                   ((uint32_t)0x00000400U)            /* Bit[10] Refer to SHRTIM_TASET bits description. */
#define SHRTIM_TXRST2_MCMP2                                   ((uint32_t)0x00000200U)            /* Bit[9] Refer to SHRTIM_TASET bits description. */
#define SHRTIM_TXRST2_MCMP1                                   ((uint32_t)0x00000100U)            /* Bit[8] Refer to SHRTIM_TASET bits description. */
#define SHRTIM_TXRST2_MPRD                                    ((uint32_t)0x00000080U)            /* Bit[7] Refer to SHRTIM_TASET bits description. */
#define SHRTIM_TXRST2_CMP4                                    ((uint32_t)0x00000040U)            /* Bit[6] Refer to SHRTIM_TASET bits description. */
#define SHRTIM_TXRST2_CMP3                                    ((uint32_t)0x00000020U)            /* Bit[5] Refer to SHRTIM_TASET bits description. */
#define SHRTIM_TXRST2_CMP2                                    ((uint32_t)0x00000010U)            /* Bit[4] Refer to SHRTIM_TASET bits description. */
#define SHRTIM_TXRST2_CMP1                                    ((uint32_t)0x00000008U)            /* Bit[3] Refer to SHRTIM_TASET bits description. */
#define SHRTIM_TXRST2_PRD                                     ((uint32_t)0x00000004U)            /* Bit[2] Refer to SHRTIM_TASET bits description. */
#define SHRTIM_TXRST2_RSYNC                                    ((uint32_t)0x00000002U)            /* Bit[1] Refer to SHRTIM_TASET bits description. */
#define SHRTIM_TXRST2_SWT                                     ((uint32_t)0x00000001U)            /* Bit[0] Refer to SHRTIM_TASET bits description. */

/** Bit definition for SHRTIM_TXEXEVFLT1 register  **/
#define SHRTIM_TXEXEVFLT1_EXEV5FLT                                ((uint32_t)0x1E000000U)            /* Bit[28:25] External event 5 filter */
#define SHRTIM_TXEXEVFLT1_EXEV5FLT_0                              ((uint32_t)0x02000000U)            /* Bit25 */
#define SHRTIM_TXEXEVFLT1_EXEV5FLT_1                              ((uint32_t)0x04000000U)            /* Bit26 */
#define SHRTIM_TXEXEVFLT1_EXEV5FLT_2                              ((uint32_t)0x08000000U)            /* Bit27 */
#define SHRTIM_TXEXEVFLT1_EXEV5FLT_3                              ((uint32_t)0x10000000U)            /* Bit28 */
#define SHRTIM_TXEXEVFLT1_EXEV5LATCH                              ((uint32_t)0x01000000U)            /* Bit[24] External event 5 latch */
#define SHRTIM_TXEXEVFLT1_EXEV4FLT                                ((uint32_t)0x00780000U)            /* Bit[22:19] External event 4 filter */
#define SHRTIM_TXEXEVFLT1_EXEV4FLT_0                              ((uint32_t)0x00080000U)            /* Bit19 */
#define SHRTIM_TXEXEVFLT1_EXEV4FLT_1                              ((uint32_t)0x00100000U)            /* Bit20 */
#define SHRTIM_TXEXEVFLT1_EXEV4FLT_2                              ((uint32_t)0x00200000U)            /* Bit21 */
#define SHRTIM_TXEXEVFLT1_EXEV4FLT_3                              ((uint32_t)0x00400000U)            /* Bit22 */
#define SHRTIM_TXEXEVFLT1_EXEV4LATCH                              ((uint32_t)0x00040000U)            /* Bit[18] External event 4 latch */
#define SHRTIM_TXEXEVFLT1_EXEV3FLT                                ((uint32_t)0x0001E000U)            /* Bit[16:13] External event 3 filter */
#define SHRTIM_TXEXEVFLT1_EXEV3FLT_0                              ((ui