/*****************************************************************************
 * Copyright (c) 2019, Nations Technologies Inc.
 *
 * All rights reserved.
 * ****************************************************************************
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * - Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer below.
 *
 * Nations' name may not be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * DISCLAIMER: THIS SOFTWARE IS PROVIDED BY NATIONS "AS IS" AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE
 * DISCLAIMED. IN NO EVENT SHALL NATIONS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * ****************************************************************************/

/**
 * @file main.c
 * @author Nations
 * @version v1.0.1
 *
 * @copyright Copyright (c) 2019, Nations Technologies Inc. All rights reserved.
 */
#include "n32l43x.h"
#include "log.h"

/** @addtogroup hsi_opt_dec
 * @{
 */
#define AFEC_HSI_OPT_NUM0  ((uint32_t)0x0<<21)
#define AFEC_HSI_OPT_NUM1  ((uint32_t)0x1<<21)
#define AFEC_HSI_OPT_NUM2  ((uint32_t)0x2<<21)
#define AFEC_HSI_OPT_NUM3  ((uint32_t)0x3<<21)
#define AFEC_HSI_OPT_NUM4  ((uint32_t)0x4<<21)
#define AFEC_HSI_OPT_NUM5  ((uint32_t)0x5<<21)
#define AFEC_HSI_OPT_NUM6  ((uint32_t)0x6<<21)
#define AFEC_HSI_OPT_NUM7  ((uint32_t)0x7<<21)
#define AFEC_HSI_OPT_NUM8  ((uint32_t)0x8<<21)//default
#define AFEC_HSI_OPT_NUM9  ((uint32_t)0x9<<21)
#define AFEC_HSI_OPT_NUM10 ((uint32_t)0xA<<21)
#define AFEC_HSI_OPT_NUM11 ((uint32_t)0xB<<21)
#define AFEC_HSI_OPT_NUM12 ((uint32_t)0xC<<21)
#define AFEC_HSI_OPT_NUM13 ((uint32_t)0xD<<21)
#define AFEC_HSI_OPT_NUM14 ((uint32_t)0xE<<21)
#define AFEC_HSI_OPT_NUM15 ((uint32_t)0xF<<21)
#define IS_AFEC_HSI_OPT(NUM)                                                                              \
       (((NUM) == AFEC_HSI_OPT_NUM0)  || ((NUM) == AFEC_HSI_OPT_NUM1)  || ((NUM) == AFEC_HSI_OPT_NUM2)        \
     || ((NUM) == AFEC_HSI_OPT_NUM3)  || ((NUM) == AFEC_HSI_OPT_NUM4)  || ((NUM) == AFEC_HSI_OPT_NUM5)        \
     || ((NUM) == AFEC_HSI_OPT_NUM6)  || ((NUM) == AFEC_HSI_OPT_NUM7)  || ((NUM) == AFEC_HSI_OPT_NUM8)        \
     || ((NUM) == AFEC_HSI_OPT_NUM9)  || ((NUM) == AFEC_HSI_OPT_NUM10) || ((NUM) == AFEC_HSI_OPT_NUM11)       \
     || ((NUM) == AFEC_HSI_OPT_NUM12) || ((NUM) == AFEC_HSI_OPT_NUM13) || ((NUM) == AFEC_HSI_OPT_NUM14)       \
     || ((NUM) == AFEC_HSI_OPT_NUM15))	 
/**
 * @}
 */
 
/** @addtogroup hsi_trim_dec
 * @{
 */
#define AFEC_HSI_TRIM_NUM0 	((uint32_t)0x0<<16)
#define AFEC_HSI_TRIM_NUM1 	((uint32_t)0x1<<16)
#define AFEC_HSI_TRIM_NUM2 	((uint32_t)0x2<<16)
#define AFEC_HSI_TRIM_NUM3 	((uint32_t)0x3<<16)
#define AFEC_HSI_TRIM_NUM4 	((uint32_t)0x4<<16)
#define AFEC_HSI_TRIM_NUM5 	((uint32_t)0x5<<16)//default
#define AFEC_HSI_TRIM_NUM6 	((uint32_t)0x6<<16)
#define AFEC_HSI_TRIM_NUM7 	((uint32_t)0x7<<16)
#define AFEC_HSI_TRIM_NUM8 	((uint32_t)0x8<<16)
#define AFEC_HSI_TRIM_NUM9 	((uint32_t)0x9<<16)
#define AFEC_HSI_TRIM_NUM10	((uint32_t)0xA<<16)
#define AFEC_HSI_TRIM_NUM11	((uint32_t)0xB<<16)
#define AFEC_HSI_TRIM_NUM12	((uint32_t)0xC<<16)
#define AFEC_HSI_TRIM_NUM13	((uint32_t)0xD<<16)
#define AFEC_HSI_TRIM_NUM14	((uint32_t)0xE<<16)
#define AFEC_HSI_TRIM_NUM15	((uint32_t)0xF<<16)
#define AFEC_HSI_TRIM_NUM16	((uint32_t)0x10<<16)
#define AFEC_HSI_TRIM_NUM17	((uint32_t)0x11<<16)
#define AFEC_HSI_TRIM_NUM18	((uint32_t)0x12<<16)
#define AFEC_HSI_TRIM_NUM19	((uint32_t)0x13<<16)
#define AFEC_HSI_TRIM_NUM20	((uint32_t)0x14<<16)
#define AFEC_HSI_TRIM_NUM21	((uint32_t)0x15<<16)
#define AFEC_HSI_TRIM_NUM22	((uint32_t)0x16<<16)
#define AFEC_HSI_TRIM_NUM23	((uint32_t)0x17<<16)
#define AFEC_HSI_TRIM_NUM24	((uint32_t)0x18<<16)
#define AFEC_HSI_TRIM_NUM25	((uint32_t)0x19<<16)
#define AFEC_HSI_TRIM_NUM26	((uint32_t)0x1A<<16)
#define AFEC_HSI_TRIM_NUM27	((uint32_t)0x1B<<16)
#define AFEC_HSI_TRIM_NUM28	((uint32_t)0x1C<<16)
#define AFEC_HSI_TRIM_NUM29	((uint32_t)0x1D<<16)
#define AFEC_HSI_TRIM_NUM30	((uint32_t)0x1E<<16)
#define AFEC_HSI_TRIM_NUM31	((uint32_t)0x1F<<16)

#define IS_AFEC_HSI_TRIM(NUM)                                                                              \
       (((NUM) == AFEC_HSI_TRIM_NUM0)  || ((NUM) == AFEC_HSI_TRIM_NUM1)  || ((NUM) == AFEC_HSI_TRIM_NUM2)        \
     || ((NUM) == AFEC_HSI_TRIM_NUM3)  || ((NUM) == AFEC_HSI_TRIM_NUM4)  || ((NUM) == AFEC_HSI_TRIM_NUM5)        \
     || ((NUM) == AFEC_HSI_TRIM_NUM6)  || ((NUM) == AFEC_HSI_TRIM_NUM7)  || ((NUM) == AFEC_HSI_TRIM_NUM8)        \
     || ((NUM) == AFEC_HSI_TRIM_NUM9)  || ((NUM) == AFEC_HSI_TRIM_NUM10) || ((NUM) == AFEC_HSI_TRIM_NUM11)       \
     || ((NUM) == AFEC_HSI_TRIM_NUM12) || ((NUM) == AFEC_HSI_TRIM_NUM13) || ((NUM) == AFEC_HSI_TRIM_NUM14)       \
     || ((NUM) == AFEC_HSI_TRIM_NUM15) || ((NUM) == AFEC_HSI_TRIM_NUM16) || ((NUM) == AFEC_HSI_TRIM_NUM17)       \
     || ((NUM) == AFEC_HSI_TRIM_NUM18) || ((NUM) == AFEC_HSI_TRIM_NUM19) || ((NUM) == AFEC_HSI_TRIM_NUM20)       \
     || ((NUM) == AFEC_HSI_TRIM_NUM21) || ((NUM) == AFEC_HSI_TRIM_NUM22) || ((NUM) == AFEC_HSI_TRIM_NUM23)       \
     || ((NUM) == AFEC_HSI_TRIM_NUM24) || ((NUM) == AFEC_HSI_TRIM_NUM25) || ((NUM) == AFEC_HSI_TRIM_NUM26)       \
     || ((NUM) == AFEC_HSI_TRIM_NUM27) || ((NUM) == AFEC_HSI_TRIM_NUM28) || ((NUM) == AFEC_HSI_TRIM_NUM29)       \
     || ((NUM) == AFEC_HSI_TRIM_NUM30) || ((NUM) == AFEC_HSI_TRIM_NUM31))
/**
 * @}
 */

void SetSysClockToHSI(void);
void AFEC_ConfigHSITrim(uint32_t HSI_OPT,uint32_t HSI_TRIM);
void NVIC_Configuration(void);

GPIO_InitType GPIO_InitStructure;
RCC_ClocksType RCC_ClockFreq;
ErrorStatus HSEStartUpStatus;
ErrorStatus HSIStartUpStatus;

enum
{
    SYSCLK_PLLSRC_HSI,
    SYSCLK_PLLSRC_HSIDIV2,
    SYSCLK_PLLSRC_HSI_PLLDIV2,
    SYSCLK_PLLSRC_HSIDIV2_PLLDIV2,
    SYSCLK_PLLSRC_HSE,
    SYSCLK_PLLSRC_HSEDIV2,
    SYSCLK_PLLSRC_HSE_PLLDIV2,
    SYSCLK_PLLSRC_HSEDIV2_PLLDIV2,
};

void DumpClock(const char* msg)
{
    log_init(); // should reinit after sysclk changed
    log_info("--------------------------------\n");
    log_info("%s:\n", msg);
    RCC_GetClocksFreqValue(&RCC_ClockFreq);
    log_info("SYSCLK: %d\n", RCC_ClockFreq.SysclkFreq);
    log_info("HCLK: %d\n", RCC_ClockFreq.HclkFreq);
    log_info("PCLK1: %d\n", RCC_ClockFreq.Pclk1Freq);
    log_info("PCLK2: %d\n", RCC_ClockFreq.Pclk2Freq);
}

int main(void)
{
    log_init();
    log_info("-----------------\nRCC_ClockConfig Demo.\n");

    DumpClock("After reset");

    /* SystemClock: 108MHz, SystemClock Source: SYSCLK_USE_HSE_PLL, 
    Flash Latency Value:  */

//		AFEC_ConfigHSITrim(AFEC_HSI_OPT_NUM0,AFEC_HSI_TRIM_NUM0);
//		AFEC_ConfigHSITrim(AFEC_HSI_OPT_NUM8,AFEC_HSI_TRIM_NUM5);
		AFEC_ConfigHSITrim(AFEC_HSI_OPT_NUM15,AFEC_HSI_TRIM_NUM31);
//		AFEC_ConfigHSITrim(AFEC_HSI_OPT_NUM0,AFEC_HSI_TRIM_NUM31);
//		AFEC_ConfigHSITrim(AFEC_HSI_OPT_NUM15,AFEC_HSI_TRIM_NUM0);
//		AFEC_ConfigHSITrim(AFEC_HSI_OPT_NUM7,AFEC_HSI_TRIM_NUM0);
    SetSysClockToHSI();
    DumpClock("HSI, 16MHz");

    /* Enable Clock Security System(CSS): this will generate an NMI exception
       when HSE clock fails */
    RCC_EnableClockSecuritySystem(ENABLE);

    /* NVIC configuration
     * ------------------------------------------------------*/
    NVIC_Configuration();

    /* Output HSE clock on MCO pin
     * ---------------------------------------------*/
    RCC_EnableAPB2PeriphClk(RCC_APB2_PERIPH_GPIOA, ENABLE);

    GPIO_InitStruct(&GPIO_InitStructure);
    GPIO_InitStructure.Pin             = GPIO_PIN_8;
    GPIO_InitStructure.GPIO_Mode       = GPIO_Mode_AF_PP;
    GPIO_InitStructure.GPIO_Alternate  = GPIO_AF8_MCO;
    GPIO_InitPeripheral(GPIOA, &GPIO_InitStructure);

    RCC_ConfigMcoClkPre(RCC_MCO_CLK_NUM0);
    RCC_ConfigMco(RCC_MCO_SYSCLK);

    while (1);
}

/**
 * @brief  Selects HSI as System clock source and configure HCLK, PCLK2
 *         and PCLK1 prescalers.
 */
void SetSysClockToHSI(void)
{
    uint32_t msi_ready_flag = RESET;

    RCC_EnableHsi(ENABLE);

    /* Wait till HSI is ready */
    HSIStartUpStatus = RCC_WaitHsiStable();

    if (HSIStartUpStatus == SUCCESS)
    {
        /* Enable Prefetch Buffer */
        FLASH_PrefetchBufSet(FLASH_PrefetchBuf_EN);

        if(((*(__IO uint8_t*)((UCID_BASE + 0x2))) == 0x01)
        || ((*(__IO uint8_t*)((UCID_BASE + 0x2))) == 0x11)
        || ((*(__IO uint8_t*)((UCID_BASE + 0x2))) == 0xFF))
        {
            /* Cheak if MSI is Ready */
            if(RESET == RCC_GetFlagStatus(RCC_CTRLSTS_FLAG_MSIRD))
            {
                /* Enable MSI and Config Clock */
                RCC_ConfigMsi(RCC_MSI_ENABLE, RCC_MSI_RANGE_4M);
                /* Waits for MSI start-up */
                while(SUCCESS != RCC_WaitMsiStable());

                msi_ready_flag = SET;
            }

            /* Select MSI as system clock source */
            RCC_ConfigSysclk(RCC_SYSCLK_SRC_MSI);

            /* Disable PLL */
            RCC_EnablePll(DISABLE);

            RCC_ConfigPll(RCC_PLL_HSI_PRE_DIV2, RCC_PLL_MUL_2, RCC_PLLDIVCLK_DISABLE);

            /* Enable PLL */
            RCC_EnablePll(ENABLE);

            /* Wait till PLL is ready */
            while (RCC_GetFlagStatus(RCC_CTRL_FLAG_PLLRDF) == RESET);

            /* Select PLL as system clock source */
            RCC_ConfigSysclk(RCC_SYSCLK_SRC_PLLCLK);

            /* Wait till PLL is used as system clock source */
            while (RCC_GetSysclkSrc() != 0x0C);

            if(msi_ready_flag == SET)
            {
                /* MSI oscillator OFF */
                RCC_ConfigMsi(RCC_MSI_DISABLE, RCC_MSI_RANGE_4M);
            }
        }
        else
        {
            /* Select HSI as system clock source */
            RCC_ConfigSysclk(RCC_SYSCLK_SRC_HSI);

            /* Wait till HSI is used as system clock source */
            while (RCC_GetSysclkSrc() != 0x04)
            {
            }
        }

        /* Flash 0 wait state */
        FLASH_SetLatency(FLASH_LATENCY_0);

        /* HCLK = SYSCLK */
        RCC_ConfigHclk(RCC_SYSCLK_DIV1);

        /* PCLK2 = HCLK */
        RCC_ConfigPclk2(RCC_HCLK_DIV1);

        /* PCLK1 = HCLK */
        RCC_ConfigPclk1(RCC_HCLK_DIV1);
    }
    else
    {
        /* If HSI fails to start-up, the application will have wrong clock
           configuration. User can add here some code to deal with this error */

        /* Go to infinite loop */
        while (1)
        {
        }
    }
}

/**
 * @brief  Configures trim HSI clock
 */
void AFEC_ConfigHSITrim(uint32_t HSI_OPT,uint32_t HSI_TRIM)
{
    uint32_t tmpregister = 0;
    /* Check the parameters */
    assert_param(IS_AFEC_HSI_OPT(HSI_OPT));
    assert_param(IS_AFEC_HSI_TRIM(HSI_TRIM));

    tmpregister = AFEC->TRIMR1;
    /* Clear OPT and TRIM[24:16] bits */
    tmpregister &= ((uint32_t)0xFE00FFFF);
    /* Set OPT[24:21] bits according to AFEC_HSI_OPT value */
    tmpregister |= HSI_OPT;
    /* Set OPT[20:16] bits according to AFEC_HSI_TRIM value */
    tmpregister |= HSI_TRIM;
    /* Store the new value */
    AFEC->TRIMR1 = tmpregister;			
}

void NVIC_Configuration(void)
{
    NVIC_InitType NVIC_InitStructure;

    /* Enable and configure RCC global IRQ channel */
    NVIC_InitStructure.NVIC_IRQChannel                   = RCC_IRQn;
    NVIC_InitStructure.NVIC_IRQChannelPreemptionPriority = 0;
    NVIC_InitStructure.NVIC_IRQChannelSubPriority        = 0;
    NVIC_InitStructure.NVIC_IRQChannelCmd                = ENABLE;
    NVIC_Init(&NVIC_InitStructure);
}

#ifdef USE_FULL_ASSERT

/**
 * @brief  Reports the name of the source file and the source line number
 *         where the assert_param error has occurred.
 * @param file pointer to the source file name
 * @param line assert_param error line source number
 */
void assert_failed(const uint8_t* expr, const uint8_t* file, uint32_t line)
{
    /* User can add his own implementation to report the file name and line
       number, ex: printf("Wrong parameters value: file %s on line %d\r\n",
       file, line) */

    /* Infinite loop */
    while (1)
    {
    }
}

#endif

/**
 * @}
 */

/**
 * @}
 */
