/**
*     Copyright (c) 2022, Nations Technologies Inc.
* 
*     All rights reserved.
*
*     This software is the exclusive property of Nations Technologies Inc. (Hereinafter 
* referred to as NATIONS). This software, and the product of NATIONS described herein 
* (Hereinafter referred to as the Product) are owned by NATIONS under the laws and treaties
* of the People's Republic of China and other applicable jurisdictions worldwide.
*
*     NATIONS does not grant any license under its patents, copyrights, trademarks, or other 
* intellectual property rights. Names and brands of third party may be mentioned or referred 
* thereto (if any) for identification purposes only.
*
*     NATIONS reserves the right to make changes, corrections, enhancements, modifications, and 
* improvements to this software at any time without notice. Please contact NATIONS and obtain 
* the latest version of this software before placing orders.

*     Although NATIONS has attempted to provide accurate and reliable information, NATIONS assumes 
* no responsibility for the accuracy and reliability of this software.
* 
*     It is the responsibility of the user of this software to properly design, program, and test 
* the functionality and safety of any application made of this information and any resulting product. 
* In no event shall NATIONS be liable for any direct, indirect, incidental, special,exemplary, or 
* consequential damages arising in any way out of the use of this software or the Product.
*
*     NATIONS Products are neither intended nor warranted for usage in systems or equipment, any
* malfunction or failure of which may cause loss of human life, bodily injury or severe property 
* damage. Such applications are deemed, "Insecure Usage".
*
*     All Insecure Usage shall be made at user's risk. User shall indemnify NATIONS and hold NATIONS 
* harmless from and against all claims, costs, damages, and other liabilities, arising from or related 
* to any customer's Insecure Usage.

*     Any express or implied warranty with regard to this software or the Product, including,but not 
* limited to, the warranties of merchantability, fitness for a particular purpose and non-infringement
* are disclaimed to the fullest extent permitted by law.

*     Unless otherwise explicitly permitted by NATIONS, anyone may not duplicate, modify, transcribe
* or otherwise distribute this software for any purposes, in whole or in part.
*
*     NATIONS products and technologies shall not be used for or incorporated into any products or systems
* whose manufacture, use, or sale is prohibited under any applicable domestic or foreign laws or regulations. 
* User shall comply with any applicable export control laws and regulations promulgated and administered by 
* the governments of any countries asserting jurisdiction over the parties or transactions.
**/

/**
*\*\file main.c
*\*\author Nations
*\*\version v1.0.0
*\*\copyright Copyright (c) 2022, Nations Technologies Inc. All rights reserved.
**/
#include <stdio.h>
#include "main.h"


void m_delay_ms(uint32_t ms)
{
	uint32_t us = 0;
	
	for(; ms!=0; ms--)
	{
		us = 4800;
		while(us--);
	}
}

/**
*\*\name    main.
*\*\fun     Main program.
*\*\param   none
*\*\return  none
**/
int main(void)
{   
    FLASH->VTOR = 0x80000000 | USER_APP_START_ADDR;
    
    /* System Clocks Configuration */
    RCC_Configuration();

    /* Configure the GPIO ports */
    GPIO_Configuration();
    
    /* Configure the KEY port EXTI NVIC */
    EXTI_NVIC_Configuration();
   
    while (1)
    {
        m_delay_ms(500);
		
		GPIO_Pin_Toggle(LED1_PORT, LED1_PIN);
    }
}

/**
  * @name  tagUserApp()
  * @brief Tag on a reserved address after user application is downloaded.
  * @param
  * @retval 0: OK; others: error.
  */

static uint32_t tagUserBoot(void)
{
  if(*(uint32_t*)BOOT_APP_FLAG1_ADDR ==  USER_BOOT_DWNLD_FLAG && 
     *(uint32_t*)BOOT_APP_FLAG2_ADDR ==  USER_BOOT_DWNLD_FLAG) return 0; //OK, already tagged.

 
  FLASH_Unlock();
  FLASH->STS = FLASH->STS;
  if(FLASH_One_Page_Erase(BOOT_APP_FLGPG_ADDR) != FLASH_EOP) return 1;
  FLASH_Lock();
  
  FLASH_Unlock();
  if(FLASH_Word_Program(BOOT_APP_FLAG1_ADDR, USER_BOOT_DWNLD_FLAG) != FLASH_EOP ||
     FLASH_Word_Program(BOOT_APP_FLAG2_ADDR, USER_BOOT_DWNLD_FLAG) != FLASH_EOP)
  {
    return 1;
  }
  FLASH_Lock();

  return 0;
}
/**
*\*\name    EXTI4_17_IRQHandler.
*\*\fun     External lines 4 to 17 interrupt.
*\*\param   none
*\*\return  none 
**/
void EXTI4_17_IRQHandler(void)
{
    if (RESET != EXTI_Interrupt_Status_Get(KEY_EXTI_LINE))
    {
        EXTI_Interrupt_Status_Clear(KEY_EXTI_LINE);
        if(tagUserBoot())
        {
            GPIO_Pins_Set(LED1_PORT, LED1_PIN);
        }
        else
        {
            NVIC_SystemReset();
        }
    }
}
/**
*\*\name    RCC_Configuration.
*\*\fun     Configures the different system clocks.
*\*\param   none
*\*\return  none
**/
void RCC_Configuration(void)
{
    /* Enable GPIO clock */
    RCC_APB_Peripheral_Clock_Enable(RCC_APB_PERIPH_IOPA|RCC_APB_PERIPH_AFIO);
}

/**
*\*\name    GPIO_Configuration.
*\*\fun     Configures the different GPIO ports.
*\*\param   none
*\*\return  none
**/
void GPIO_Configuration(void)
{
    GPIO_InitType GPIO_InitStructure;
   
    /* Configure LED as function push-pull output */
    GPIO_Structure_Initialize(&GPIO_InitStructure);
    GPIO_InitStructure.Pin        = LED1_PIN;
    GPIO_InitStructure.GPIO_Mode  = GPIO_MODE_OUT_PP;
    GPIO_InitStructure.GPIO_Slew_Rate = GPIO_SLEW_RATE_FAST;
    GPIO_Peripheral_Initialize(LED1_PORT, &GPIO_InitStructure);
    
    /* Configure LED as function push-pull output */
    GPIO_Structure_Initialize(&GPIO_InitStructure);
    GPIO_InitStructure.Pin        = KEY_PIN;
    GPIO_InitStructure.GPIO_Pull    = GPIO_PULL_UP;
    GPIO_Peripheral_Initialize(KEY_PORT, &GPIO_InitStructure);
}

void EXTI_NVIC_Configuration(void)
{
    EXTI_InitType EXTI_InitStructure;
    NVIC_InitType NVIC_InitStructure;

    /* Configure key EXTI line */
    EXTI_InitStructure.EXTI_Line    = KEY_EXTI_LINE;
    EXTI_InitStructure.EXTI_Mode    = EXTI_Mode_Interrupt;
    EXTI_InitStructure.EXTI_Trigger = EXTI_Trigger_Falling; 
    EXTI_InitStructure.EXTI_LineCmd = ENABLE;
    EXTI_Peripheral_Initializes(&EXTI_InitStructure);

    /* Set key input interrupt priority */
    NVIC_InitStructure.NVIC_IRQChannel                   = KEY_IRQn;
    NVIC_InitStructure.NVIC_IRQChannelPriority           = 1;
    NVIC_InitStructure.NVIC_IRQChannelCmd                = ENABLE;
    NVIC_Initializes(&NVIC_InitStructure);
}



///**
//*\*\name    fputc.
//*\*\fun     retarget the C library printf function to the USART
//*\*\param   ch
//*\*\param   f
//*\*\return  none
//**/
//int fputc(int ch, FILE* f)
//{
//    UART_Data_Send(UARTx, (uint8_t)ch);
//    while (UART_Flag_Status_Get(UARTx, UART_FLAG_TXDE) == RESET)
//        ;

//    return (ch);
//}


