/*****************************************************************************
*         NationS Microcontroller Software Support
* ----------------------------------------------------------------------------
* Copyright (c) 2019, NationS Corporation
*
* All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions are met:
*
* - Redistributions of source code must retain the above copyright notice,
* this list of conditions and the disclaimer below.
*
* NationS's name may not be used to endorse or promote products derived from
* this software without specific prior written permission.
*
* DISCLAIMER: THIS SOFTWARE IS PROVIDED BY NATIONZ "AS IS" AND ANY EXPRESS OR
* IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
* MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE
* DISCLAIMED. IN NO EVENT SHALL NATIONZ BE LIABLE FOR ANY DIRECT, INDIRECT,
* INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
* LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
* OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
* LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
* NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
* EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
* ****************************************************************************/
/*****************************************************************************
* File Name: boot_Common.h
* Function: Defining the public functions used by other algorithm lib
* version: V1.0
* Author: huang.jinshang
* date: 2019-06-17
* ****************************************************************************/
#ifndef _boot_Common_H_
#define _boot_Common_H_
#include "Type.h"
#include <stdint.h>

//Boot Version Definition,using the ABSPLUTE address on purpose to make sure it can be checked through FT/COS conveniently.
#define BOOT_CMD_SET_VERSION  0x12  //Fixed BCD-coded BOOT CMD SET V1.2 version.
//
#define BOOT_VERSION_MAJOR    1     //[0~9]
#define BOOT_VERSION_MINOR    1     //[0~9]
#define BOOT_VERSION_BUILD    0     //SHOULD always keep as 0x0000 for compatibility purpose.

#define UCID_ADDR             (0x1FFFF4D0) //16B
#define UID_ADDR              (0x1FFFF4FC) //12B
#define DBGMCU_ID_ADDR        (0x1FFFF508) // 4B
//
#define BOOT_RESERVED_START   (0x08000BF8)
#define BOOT_VERSION_ADDR     (BOOT_RESERVED_START+0)
#define BOOT_CRCCHCK_ADDR     (BOOT_RESERVED_START+4)
//
#define USER_APP_START_ADDR   (0x08000C00)
#define BOOT_APP_FLGPG_ADDR   (0x08007400)
#define BOOT_APP_FLAG1_ADDR   (0x080075F8)
#define BOOT_APP_FLAG2_ADDR   (0x080075FC)
#define USER_APP_END_ADDR     (0x080075FF)
#define USER_APP_DWNLD_FLAG   (0xAAAABBBB)

#define FLASH_Page_Length           ((uint32_t)0x00000200)
#define FLASH_Address_Start         ((uint32_t)0x08000000)
#define FLASH_RDP_END_ADDR     ((uint32_t)0x08001000)

#endif //_boot_Common_H_
