/*****************************************************************************
 * Copyright (c) 2019, Nations Technologies Inc.
 *
 * All rights reserved.
 * ****************************************************************************
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * - Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer below.
 *
 * Nations' name may not be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * DISCLAIMER: THIS SOFTWARE IS PROVIDED BY NATIONS "AS IS" AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE
 * DISCLAIMED. IN NO EVENT SHALL NATIONS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * ****************************************************************************/
/** ****************************************************************************
 * @file     bootloader_cmd.h
 * @author
 * @date
 * @version  v1.0.0
 * @brief    Header for bootloader_cmd.c module
 ******************************************************************************/

#ifndef __BOOTLOADER_CMD_H
#define __BOOTLOADER_CMD_H

#ifdef __cplusplus
 extern "C" {
#endif

/* Includes ------------------------------------------------------------------*/
#include "main.h"

/* Exported types ------------------------------------------------------------*/
typedef enum
{
  CMD_RESERVED        = 0x00,
  CMD_SET_BR          = 0x01,
  CMD_GET_INF         = 0x10,
  CMD_GET_RNG         = 0x20,
  CMD_KEY_UPDATE      = 0x21,
  CMD_FLASH_ERASE     = 0x30,
  CMD_FLASH_DWNLD     = 0x31,
  CMD_DATA_CRC_CHECK  = 0x32,
  CMD_DATA_READ       = 0x33,
  CMD_OPT_RW          = 0x40,
  CMD_USERX_OP        = 0x41,
  CMD_NVR_CFG         = 0x42,
  CMD_NVR_GET         = 0x43,
  CMD_SYS_RESET       = 0x50,
  CMD_APP_GO          = 0x51
} CMD_H_NUM;

typedef enum
{
  CMD_LEN_BR              = 0x00,
  CMD_LEN_OPT_RW          = 0x10,
} CMD_LEN_NUM;

typedef enum
{
  OPT_READ            = 0x00,
  OPT_CFG             = 0x01,
  OPT_CFG_RESET       = 0x02
} CMD_L_OPT_RW;

typedef enum
{
  CMD_CR_SUCCESS      = 0x00,
  CMD_CR_FAILED       = 0x01,
  CMD_CR_IDINDEX      = 0x02,
  CMD_CR_KEYCRCERR    = 0x03,
  CMD_CR_UNCHECK      = 0x04,
  CMD_CR_CHECK        = 0x05,
  CMD_CR_CTFFAILD     = 0x06,
  CMD_CR_CTFLIMET     = 0x07,
  CMD_CR_RDP          = 0x08,
  CMD_CR_WRP          = 0x09,
  CMD_CR_USERP        = 0x0A,
  CMD_CR_CROSSUSER    = 0x0B,
  CMD_CR_FLASHLIMET   = 0x0C,
  CMD_CR_ADDERR       = 0x0D,
  CMD_CR_LENERR       = 0x0E,
  CMD_CR_PROGRAMERR   = 0x0F,
  CMD_CR_CRCERR       = 0x10,
  CMD_CR_RDPL1ERR     = 0x11,
  CMD_CR_USERCFGERR   = 0x12,
  CMD_CR_USERSIZEERR  = 0x13,
  CMD_CR_USERORDERERR = 0x14,
  CMD_CR_IDCFGERR     = 0x15,
  CMD_CR_CTCCFGERR    = 0x16,
  CMD_CR_UPDATAERR    = 0x17,
  CMD_CR_OTHER        = 0x18
} CMD_RETURN_CR;

typedef struct
{
  uint32_t CMD_H  : 8;
  uint32_t CMD_L  : 8;
  uint32_t LEN    :16;
  uint8_t Par[4];
  uint8_t Data[256];
  uint32_t XOR       : 8;
  uint32_t Flag      : 1;
  uint32_t Reserved  : 7;
  uint32_t Idx       :16;
} PC_CMD_Type;

typedef struct
{
  uint32_t CMD_H  : 8;
  uint32_t CMD_L  : 8;
  uint32_t LEN    :16;
  uint8_t Data[256];
  uint8_t CR1;
  uint8_t CR2;
} IC_CMD_Type;


/* Exported constants --------------------------------------------------------*/

/* Exported macro ------------------------------------------------------------*/
/* Exported functions ------------------------------------------------------- */
void BOOT_CMD(void);
void BOOT_End(void);
void runUserApp(void);
uint32_t checkBootCRC(void);
CMD_RETURN_CR FLASH_Range_Configuration(uint32_t addr, uint32_t size, uint8_t region);

#ifdef __cplusplus
}
#endif

#endif //__BOOTLOADER_CMD_H
