/**
*     Copyright (c) 2022, Nations Technologies Inc.
* 
*     All rights reserved.
*
*     This software is the exclusive property of Nations Technologies Inc. (Hereinafter 
* referred to as NATIONS). This software, and the product of NATIONS described herein 
* (Hereinafter referred to as the Product) are owned by NATIONS under the laws and treaties
* of the People's Republic of China and other applicable jurisdictions worldwide.
*
*     NATIONS does not grant any license under its patents, copyrights, trademarks, or other 
* intellectual property rights. Names and brands of third party may be mentioned or referred 
* thereto (if any) for identification purposes only.
*
*     NATIONS reserves the right to make changes, corrections, enhancements, modifications, and 
* improvements to this software at any time without notice. Please contact NATIONS and obtain 
* the latest version of this software before placing orders.

*     Although NATIONS has attempted to provide accurate and reliable information, NATIONS assumes 
* no responsibility for the accuracy and reliability of this software.
* 
*     It is the responsibility of the user of this software to properly design, program, and test 
* the functionality and safety of any application made of this information and any resulting product. 
* In no event shall NATIONS be liable for any direct, indirect, incidental, special,exemplary, or 
* consequential damages arising in any way out of the use of this software or the Product.
*
*     NATIONS Products are neither intended nor warranted for usage in systems or equipment, any
* malfunction or failure of which may cause loss of human life, bodily injury or severe property 
* damage. Such applications are deemed, "Insecure Usage".
*
*     All Insecure Usage shall be made at user's risk. User shall indemnify NATIONS and hold NATIONS 
* harmless from and against all claims, costs, damages, and other liabilities, arising from or related 
* to any customer's Insecure Usage.

*     Any express or implied warranty with regard to this software or the Product, including,but not 
* limited to, the warranties of merchantability, fitness for a particular purpose and non-infringement
* are disclaimed to the fullest extent permitted by law.

*     Unless otherwise explicitly permitted by NATIONS, anyone may not duplicate, modify, transcribe
* or otherwise distribute this software for any purposes, in whole or in part.
*
*     NATIONS products and technologies shall not be used for or incorporated into any products or systems
* whose manufacture, use, or sale is prohibited under any applicable domestic or foreign laws or regulations. 
* User shall comply with any applicable export control laws and regulations promulgated and administered by 
* the governments of any countries asserting jurisdiction over the parties or transactions.
**/

/**
*\*\file system_n32g003.c
*\*\author Nations
*\*\version v1.0.0
*\*\copyright Copyright (c) 2022, Nations Technologies Inc. All rights reserved.
 */
#include "n32g003.h"

/* Uncomment the line corresponding to the desired System clock (SYSCLK)
   frequency (after reset the HSI is used as SYSCLK source)

   IMPORTANT NOTE:
   ==============
   1. After each device reset the HSI is used as System clock source.

   2. Please make sure that the selected System clock doesn't exceed your
   device's maximum frequency.

   3. If none of the define below is enabled, the HSI is used as System clock
    source.

   4. The System clock configuration functions provided within this file assume
   that:
        - For Low, Medium and High density Value line devices an external 8MHz
          crystal is used to drive the System clock.
        - For Low, Medium and High density devices an external 8MHz crystal is
          used to drive the System clock.
        - For Connectivity line devices an external 25MHz crystal is used to
   drive the System clock. If you are using different crystal you have to adapt
   those functions accordingly.
    */


/*** Configure system clock frequency ***/
#ifndef SYSCLK_FREQ
#define SYSCLK_FREQ 48000000
#endif

/******* Select one ******
** SYSCLK_USE_HSI48M    **
** SYSCLK_USE_HSI40M  ***/
#ifndef SYSCLK_SRC
#define SYSCLK_SRC SYSCLK_USE_HSI48M
#endif

/**
*\*\name    System_Initializes.
*\*\fun     Setup the microcontroller system
*\*\        Initialize the Embedded Flash Interface, update the
*\*\        SystemCoreClockFrequency variable.
*\*\param   none.
*\*\return  none
*\*\note    This function should be used only after reset.
**/
void System_Initializes(void)
{
    uint32_t tmp = 0;
   
	/* Reset the RCC clock configuration to the default reset state(for debug purpose) */
	/* Set HSI 48M bit */
	PWR->CTRL3 &= ~((uint16_t)0x0040);	//48M

    //One wait state, if 24MHZ < SYSCLK = 48MHz
    tmp = FLASH->AC;
    tmp &= ~0x00000007;
    tmp |= 0x01; 
    FLASH->AC = tmp;

    //RCC_CFG[13:12]: b'00 HSICLK not divided ,for 48M
    tmp = RCC->CFG;
    tmp &= ~0x00003000; 
    RCC->CFG = tmp;

    //CRCEN: Bit6
    tmp  = RCC->AHBPCLKEN;
    tmp |= 0x40; 
    RCC->AHBPCLKEN = tmp;

    //Config hardware WDG if enabled
    if(!(FLASH->OB & FLASH_OB_WDG_SW))
    {
        IWDG->KEY = 0x5555;
        IWDG->PREDIV = 0x06;
    }
	
}






