/*****************************************************************************
 * Copyright (c) 2019, Nations Technologies Inc.
 *
 * All rights reserved.
 * ****************************************************************************
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * - Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer below.
 *
 * Nations' name may not be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * DISCLAIMER: THIS SOFTWARE IS PROVIDED BY NATIONS "AS IS" AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE
 * DISCLAIMED. IN NO EVENT SHALL NATIONS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * ****************************************************************************/

/**
 * @file n32l43x_it.c
 * @author Nations
 * @version v1.0.0
 *
 * @copyright Copyright (c) 2019, Nations Technologies Inc. All rights reserved.
 */
#include "n32l43x_it.h"
#include "log.h"
#include "main.h"
#include "n32l43x_lptim.h"
#include "User_LED_Config.h"


/** @addtogroup N32L43x_StdPeriph_Template
 * @{
 */

/******************************************************************************/
/*            Cortex-M4 Processor Exceptions Handlers                         */
/******************************************************************************/

/**
 * @brief  This function handles NMI exception.
 */
void NMI_Handler(void)
{
}

/**
 * @brief  This function handles Hard Fault exception.
 */
void HardFault_Handler(void)
{
    /* Go to infinite loop when Hard Fault exception occurs */
    while (1)
    {
    }
}

/**
 * @brief  This function handles Memory Manage exception.
 */
void MemManage_Handler(void)
{
    /* Go to infinite loop when Memory Manage exception occurs */
    while (1)
    {
    }
}

/**
 * @brief  This function handles Bus Fault exception.
 */
void BusFault_Handler(void)
{
    /* Go to infinite loop when Bus Fault exception occurs */
    while (1)
    {
    }
}

/**
 * @brief  This function handles Usage Fault exception.
 */
void UsageFault_Handler(void)
{
    /* Go to infinite loop when Usage Fault exception occurs */
    while (1)
    {
    }
}

/**
 * @brief  This function handles SVCall exception.
 */
void SVC_Handler(void)
{
}

/**
 * @brief  This function handles Debug Monitor exception.
 */
void DebugMon_Handler(void)
{
}

/**
 * @brief  This function handles SysTick Handler.
 */
void SysTick_Handler(void)
{
}

/******************************************************************************/
/*                 N32L43x Peripherals Interrupt Handlers                     */
/*  Add here the Interrupt Handler for the used peripheral(s) (PPP), for the  */
/*  available peripheral interrupt handler's name please refer to the startup */
/*  file (startup_n32l43x.s).                                                 */
/******************************************************************************/
/**
 * @brief  This function handles RCC interrupt request.
 */
void  TAMPER_IRQHandler(void)
{
    LEDBlink(LED4_PORT, LED4_PIN);
    EXTI_ClrITPendBit(EXTI_LINE19);
    if (RCC_GetFlagStatus(RCC_LDCTRL_FLAG_LSECLKSSF) != RESET)
    {
        /* clr flag */
        RCC->CLKINT |= (uint32_t)(0x04000000);
        RCC_ConfigLPTIMClk(RCC_LPTIMCLK_SRC_LSI);
        KeyInputExtiInit(KEY_INPUT_PORT, KEY_INPUT_PIN);
    }
}


/**
 * @brief  This function handles LLPTIM interrupt request.
 */
void LPTIM_WKUP_IRQHandler(void)
{
    if (LPTIM_IsActiveFlag_CMPM(LPTIM) != RESET)
    {
        LPTIM_ClearFLAG_CMPM(LPTIM);

        EXTI_ClrITPendBit(EXTI_LINE24);
        if(RCC_GetLSEClockSecuritySystemStatus() == RESET)
        {
            User_LPUART_Init();
            USER_LPTIM_Init();
        }    

    }
}

/**
 * @brief  This function handles the PVD Output interrupt request defined in main.h .
 */

void EXTI15_10_IRQHandler(void)
{
    int RxBuffer2 = 0,cnt = 0;
    if (EXTI_GetITStatus(EXTI_LINE11) != RESET)
    {
        /* Clear the Key Button EXTI line pending bit */
        EXTI_ClrITPendBit(EXTI_LINE11);
        /* Configures the High Speed Internal RC clock (HSI) */
        RCC_ConfigHsi(RCC_HSI_ENABLE);
        while (RCC_GetFlagStatus(RCC_CTRL_FLAG_HSIRDF) == RESET)
        {
        }
        /* Loop until the LPUART Receive Data Register is not empty */
        while (LPUART_GetFlagStatus(LPUART_FLAG_FIFO_NE) == RESET)
        {
            cnt++;
            if((cnt > 0xFF))//timeout
                break;
        }
        /* Store the received byte in RxBuffer */
        RxBuffer2 = LPUART_ReceiveData();
        if(RxBuffer2 == 0x5A){
            log_info("--------- \nOK:%x\n",RxBuffer2);
        }else{
            log_info("--------- \nNG:%x\n",RxBuffer2);
        }
    }
}
/**
 * @brief  This function handles PPP interrupt request.
 */
/*void PPP_IRQHandler(void)
{
}*/

/**
 * @}
 */
