/*****************************************************************************
 * Copyright (c) 2022, Nations Technologies Inc.
 *
 * All rights reserved.
 * ****************************************************************************
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * - Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer below.
 *
 * Nations' name may not be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * DISCLAIMER: THIS SOFTWARE IS PROVIDED BY NATIONS "AS IS" AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE
 * DISCLAIMED. IN NO EVENT SHALL NATIONS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * ****************************************************************************/

/**
 * @file hw_config.h
 * @author Nations
 * @version V1.2.2
 *
 * @copyright Copyright (c) 2022, Nations Technologies Inc. All rights reserved.
 */
#ifndef __HW_CONFIG_H__
#define __HW_CONFIG_H__

#include "n32l40x.h"
#include "usb_type.h"

/* Exported define -----------------------------------------------------------*/
#define SYSCLK_VALUE_48MHz            ((uint32_t)48000000)
#define SYSCLK_VALUE_72MHz            ((uint32_t)72000000)
#define SYSCLK_VALUE_96MHz            ((uint32_t)96000000)
#define SYSCLK_VALUE_108MHz           ((uint32_t)108000000)
#define PCLK2_VALUE_72MHz             ((uint32_t)72000000)
#define PCLK2_VALUE_48MHz             ((uint32_t)48000000)

#define OSC300_CTRL         ((__IO unsigned*)(0x40001824))

#define _DisOsc300Ldo()    (*OSC300_CTRL = (*OSC300_CTRL) | 0x800000);
#define _EnOsc300Ldo()     (*OSC300_CTRL = (*OSC300_CTRL) & (~0x800000));
#define _DisOsc300Core()   (*OSC300_CTRL = (*OSC300_CTRL) | 0x400000);
#define _EnOsc300Core()    (*OSC300_CTRL = (*OSC300_CTRL) & (~0x400000));
#define _DisOsc300Ibias()  (*OSC300_CTRL = (*OSC300_CTRL) | 0x1000000);
#define _EnOsc300Ibias()   (*OSC300_CTRL = (*OSC300_CTRL) & (~0x1000000));

#define KEY_A_PIN               GPIO_PIN_4
#define KEY_B_PIN               GPIO_PIN_5
#define KEY_C_PIN               GPIO_PIN_6

#define KEY_PORT                GPIOA

#define LED_CAPSLOCK_PIN        GPIO_PIN_5
#define LED_NUMLOCK_PIN         GPIO_PIN_8

#define LED_CAPSLOCK_PORT       GPIOB
#define LED_NUMLOCK_PORT        GPIOA

#define KEY_INPUT_PORT        GPIOA
#define KEY_INPUT_PIN         GPIO_PIN_0
#define KEY_INPUT_EXTI_LINE   EXTI_LINE0
#define KEY_INPUT_PORT_SOURCE GPIOA_PORT_SOURCE
#define KEY_INPUT_PIN_SOURCE  GPIO_PIN_SOURCE0
#define KEY_INPUT_IRQn        EXTI0_IRQn

#define open_capslock_led()   GPIO_SetBits(LED_CAPSLOCK_PORT, LED_CAPSLOCK_PIN);
#define close_capslock_led()  GPIO_ResetBits(LED_CAPSLOCK_PORT, LED_CAPSLOCK_PIN);

#define open_numlock_led()   GPIO_SetBits(LED_NUMLOCK_PORT, LED_NUMLOCK_PIN);
#define close_numlock_led()  GPIO_ResetBits(LED_NUMLOCK_PORT, LED_NUMLOCK_PIN);

//#define USB_LOW_PWR_MGMT_SUPPORT

void Set_System(void);
ErrorStatus Set_USBClock(uint32_t sysclk);
void Enter_LowPowerMode(void);
void Leave_LowPowerMode(void);
void USB_Interrupts_Config(void);
void TimingDelay_Decrement(void);
void Delay(__IO uint32_t nCount);
void Cfg_KeyIO(void);
void USB_XtallessIni(uint32_t RCC_UCDR300MSource);
ErrorStatus USB_Config(uint32_t sysclk);
void USB_ActiveRemoteWakeup(void);



#endif /*__HW_CONFIG_H__*/

/**
 * @}
 */

/**
 * @}
 */

/**
 * @}
 */
