/*****************************************************************************
 * Copyright (c) 2019, Nations Technologies Inc.
 *
 * All rights reserved.
 * ****************************************************************************
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * - Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer below.
 *
 * Nations' name may not be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * DISCLAIMER: THIS SOFTWARE IS PROVIDED BY NATIONS "AS IS" AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE
 * DISCLAIMED. IN NO EVENT SHALL NATIONS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * ****************************************************************************/

/**
 * @file main.c
 * @author Nations
 * @version v1.0.0
 *
 * @copyright Copyright (c) 2019, Nations Technologies Inc. All rights reserved.
 */
#include <stdio.h>
#include "main.h"
#include "log.h"
#include "n32l43x_lptim.h"
#include "User_LPTimer_Config.h"
#include "User_LPUART_Config.h"
#include "User_LSE_LSI_Config.h"
#include "User_LED_Config.h"


/** @addtogroup LPUART_WakeUpFromStop2
 * @{
 */


/**
 * @brief  Inserts a delay time.
 * @param nCount specifies the delay time length.
 */
void Delay(__IO uint32_t nCount)
{
    /* Decrement nCount value */
    for (; nCount != 0; nCount--);
}



void User_EnterSTOP2_Fun(void)
{
    log_info("\r\n MCU Goto STOP2 Mode \n");
    /* Request to enter STOP2 mode*/
    PWR_EnterSTOP2Mode(PWR_STOPENTRY_WFI, PWR_CTRL3_RAM1RET);
    log_info("\n MCU Wakeup From STOP2 Mode \n");
}



/**
 * @brief  Main program
 */
int main(void)
{
    LEDInit(LED4_PORT, LED4_PIN);
    /* Enable PWR Clock */
    RCC_EnableAPB1PeriphClk(RCC_APB1_PERIPH_PWR, ENABLE);
    /* should reinit after sysclk changed */
    log_init(); 
    log_info("\r\n MCU Reset \r\n");
    
    User_EnableLse();
    User_EnableLsi();

    /* Enable Clock Security System(CSS): 
       this will generate an NMI exception
       when LSE clock fails */
    RCC_EnableLSEClockSecuritySystem(ENABLE);
    User_ConfigLseCSSInt();   
    /* EXTI19_TAMPER_IRQn configuration */
    EXTI19_TAMPER_IRQn_Configuration();
    
    /* Enable the DBG_STOP to keep debug in low power */
    DBG_ConfigPeriph(DBG_STOP, ENABLE);
    User_EnterSTOP2_Fun();

    USER_LPTIM_Init();
    User_LPUART_Init();
    Delay(1000);
    while(1)
    {
        Delay(100);
        User_EnterSTOP2_Fun();
    }
}







#ifdef USE_FULL_ASSERT

/**
 * @brief  Reports the name of the source file and the source line number
 *         where the assert_param error has occurred.
 * @param file pointer to the source file name
 * @param line assert_param error line source number
 */
void assert_failed(const uint8_t* expr, const uint8_t* file, uint32_t line)
{
    /* User can add his own implementation to report the file name and line number,
       ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

    /* Infinite loop */
    while (1)
    {
    }
}

#endif

/**
 * @}
 */

/**
 * @}
 */
