#include <stdio.h>
#include <stdint.h>
#include "n32l43x.h"
#include "n32l43x_rtc.h"
#include "User_Systick_Config.h"
#include "n32l43x_adc.h"
#include "User_ADC_Config.h"
#include "User_Temp_Process.h"
#include "log.h"
#include "User_RTC_Config.h"

uint32_t temp_monitor_time;

/**
 * @brief  Temperature Deal Process Function
 */
void  User_Temp_Process(void)
{
      if(User_Time_Read(temp_monitor_time)>=(TIME_1S*1))
      {
         User_Time_Set(&temp_monitor_time);
         log_info("\r\n ADC Value: %x\r\n",ADC_Average_Value);
         if( (ADC_Average_Value >= TEMP_27_ADC_VALUE_RANGE_LOW) && (ADC_Average_Value <= TEMP_27_ADC_VALUE_RANGE_HIGH) )
         {
              //RTC_ConfigSmoothCalib(SMOOTH_CALIB_32SEC,RTC_SMOOTH_CALIB_PLUS_PULSES_RESET,0);
              RTC_ConfigSmoothCalib(SMOOTH_CALIB_32SEC,RTC_SMOOTH_CALIB_PLUS_PULSES_SET,510);
         }
         RTC_DateShow();
         RTC_TimeShow();
      }
}

