/*****************************************************************************
 * Copyright (c) 2019, Nations Technologies Inc.
 *
 * All rights reserved.
 * ****************************************************************************
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * - Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer below.
 *
 * Nations' name may not be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * DISCLAIMER: THIS SOFTWARE IS PROVIDED BY NATIONS "AS IS" AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE
 * DISCLAIMED. IN NO EVENT SHALL NATIONS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * ****************************************************************************/

/**
 * @file usb_ucdr.h
 * @author Nations
 * @version v1.0.0
 *
 * @copyright Copyright (c) 2019, Nations Technologies Inc. All rights reserved.
 */
#ifndef __USB_UCDR_H__
#define __USB_UCDR_H__

#include "n32l40x.h"
#include "usb_type.h"

#define UCDR_BASE           (USB_BASE + 0x300))

#define UCDR_CTRL           (( uint8_t*)(UCDR_BASE)
#define UCDR_DTCMODESEL     ((uint8_t*)(UCDR_BASE+0x08)
#define UCDR_DLYCNTDTC      ((uint8_t*)(UCDR_BASE+0x10)
#define UCDR_DLYCNTADJ      ((uint8_t*)(UCDR_BASE+0x14)
#define UCDR_CKCNTDTC       ((uint8_t*)(UCDR_BASE+0x1C)
#define UCDR_CKUNITDTC      ((uint8_t*)(UCDR_BASE+0x2C)
#define UCDR_ERRFLAGREG     ((uint8_t*)(UCDR_BASE+0x40)


//#define UCDR_CLKDIV         (( uint8_t*)(UCDR_BASE+0x04)
//#define UCDR_DTCMODESEL     (( uint8_t*)(UCDR_BASE+0x08)
//#define UCDR_DLYCNTDEFT     (( uint8_t*)(UCDR_BASE+0x0C)
//#define UCDR_DLYCNTDTC      (( uint8_t*)(UCDR_BASE+0x10)
//#define UCDR_DLYCNTADJ      (( uint8_t*)(UCDR_BASE+0x14)
//#define UCDR_CKCNTDEFT      (( uint8_t*)(UCDR_BASE+0x18)
//#define UCDR_CKCNTDTC       (( uint8_t*)(UCDR_BASE+0x1C)
//#define UCDR_CKCNTADJ       (( uint8_t*)(UCDR_BASE+0x20)
//#define UCDR_BITWIDTHCNT    (( uint8_t*)(UCDR_BASE+0x24)
//#define UCDR_CKUNITDEFT     (( uint8_t*)(UCDR_BASE+0x28)
//#define UCDR_CKUNITDTC      (( uint8_t*)(UCDR_BASE+0x2C)
//#define UCDR_CKUNITADJ      (( uint8_t*)(UCDR_BASE+0x30)
//#define UCDR_OSC300MCFG0    (( uint8_t*)(UCDR_BASE+0x34)
//#define UCDR_DLYCNTBIAS     (( uint8_t*)(UCDR_BASE+0x3C)
//#define UCDR_ERRFLAGREG     (( uint8_t*)(UCDR_BASE+0x40)
//#define UCDR_SYNCDTCFREQ    (( uint8_t*)(UCDR_BASE+0x44)


#define _UCDR_En()                              (*UCDR_CTRL = (*UCDR_CTRL) | 0x01)
#define _UCDR_Dis()                             (*UCDR_CTRL = (*UCDR_CTRL) | 0xFE)
#define _UCDR_SetDpDelayCount(delaycount)       (*UCDR_DTCMODESEL = (((*UCDR_DTCMODESEL) & 0x1F) | ((uint8_t)(delaycount<<5))))
#define _UCDR_ReadDelayCntVal()                 (uint8_t)(*UCDR_DLYCNTDTC)
#define _UCDR_SetDlyCntAdj(adj_dir, adj_value)  (*UCDR_DLYCNTADJ = (uint8_t)((adj_dir<<5) | adj_value))
#define _UCDR_ReadCkCntDtc()                    (uint8_t)(*UCDR_CKCNTDTC)
#define _UCDR_ReadCkUnitDtc()                   (uint8_t)(*UCDR_CKUNITDTC)
#define _UCDR_ReadErrFlag()                     (uint8_t)(*UCDR_ERRFLAGREG)
#define _UCDR_ClrErrFlag(flag)                  (*UCDR_ERRFLAGREG = (*UCDR_ERRFLAGREG) & flag)
#define _UCDR_EnErrInt()                        (*UCDR_ERRFLAGREG = *UCDR_ERRFLAGREG | (0x01<<3))
#define _UCDR_DisErrInt()                       (*UCDR_ERRFLAGREG = *UCDR_ERRFLAGREG & ~(0x01<<3))

typedef enum
{
	NO_DELAY = 0,
	ONE_CYCLE_DELAY = 1,
	TWO_CYCLE_DELAY ,
	THRESS_CYCLE_DELAY
}UCDR_DPDelayType;

typedef enum
{
    NEGATIVE_ADJ = 0,
    POSITIVE_ADJ = 1
}UCDR_DlyCntAdj_Dir;

typedef enum
{
    DLYCNTDIASERRFLAG = 0,
    BITWIDTHCNTBIADERRFLAG = 1,
    DTCERRFLAG = 2,
}UCDR_ErrFlag;

#define IS_UCDR_GET_FLAG(FLAG)  (((FLAG) == DLYCNTDIASERRFLAG) || ((FLAG) == BITWIDTHCNTBIADERRFLAG) || ((FLAG) == DTCERRFLAG))

void UCDR_Enable(void);
void UCDR_Disable(void);
void UCDR_SetDpDlySel(UCDR_DPDelayType  delaycount);
uint8_t UCDR_GetDlyCntDtc(void);
uint8_t UCDR_GetCkCntDtc(void);
uint8_t UCDR_GetCkUnitDtc(void);
void UCDR_SetDlyCntAdj(UCDR_DlyCntAdj_Dir adj_dir, uint8_t adj_value);
void UCDR_EnErrInt(void);
void UCDR_DisErrInt(void);
FlagStatus UCDR_GetErrFlag(uint8_t ucdr_errflag);
void UCDR_ClrErrFlag(uint8_t ucdr_errflag);

#endif /*__USB_UCDR_H__*/

/**
 * @}
 */

/**
 * @}
 */

/**
 * @}
 */

