/*****************************************************************************
 * Copyright (c) 2019, Nations Technologies Inc.
 *
 * All rights reserved.
 * ****************************************************************************
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * - Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the disclaimer below.
 *
 * Nations' name may not be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * DISCLAIMER: THIS SOFTWARE IS PROVIDED BY NATIONS "AS IS" AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NON-INFRINGEMENT ARE
 * DISCLAIMED. IN NO EVENT SHALL NATIONS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA,
 * OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 * ****************************************************************************/


/* Define to prevent recursive inclusion -------------------------------------*/
#ifndef __CAN_MAL_H
#define __CAN_MAL_H

/* Includes ------------------------------------------------------------------*/
#include "platform_config.h"

/* Exported types ------------------------------------------------------------*/
/* Exported constants --------------------------------------------------------*/
#define MAL_OK   0
#define MAL_FAIL 1
#define MAX_USED_MEDIA 3
#define MAL_MASK 0xFC000000

#define FLASH_2KB              ((uint32_t)0x800)

#define CAN_IAP_STD_ID         ((uint16_t)0x0400)
#define CAN_IAP_EXT_ID         ((uint16_t)0x00)

#define CAN_DWNLD_TIMEOUT      ((uint32_t)300)
/* utils macro ---------------------------------------------------------------*/
/* Exported macro ------------------------------------------------------------*/

typedef enum 
{
    CMD_FLASH_ERASE        = 0x10,
    CMD_FLASH_DWNLD        = 0x11,
    CMD_DATA_CRC_CHECK     = 0x12,
    CMD_SYS_RESET          = 0x13,
    CMD_APP_GO             = 0x14
} CMD_H_NUM;

typedef enum 
{
    CMD_PAR_SUCCESS        = 0x00,
    CMD_PAR_FAIL           = 0x01,
    CMD_PAR_RANGERROR      = 0x02,
    CMD_PAR_ALIGNMENTERROR = 0x03,
    CMD_PAR_MULTIPLEERROR  = 0x04,
    CMD_PAR_CMDERROR       = 0x05
} CMD_RETURN_PAR;

typedef struct
{
    uint8_t CMD_H;
    uint8_t CMD_L;
    uint8_t LEN[2];
    uint8_t Par[4];
    uint8_t Data[256];
    uint8_t Flag;
    uint16_t Data_len;
} BOOTLOADER_CMD_Type;

typedef enum 
{
    FLAG_START             = 0x00,
    FLAG_DWNLD             = 0x01,
    FLAG_CRC_CHECK         = 0x02,
    FLAG_DATA_DONE         = 0x03,
    FLAG_RETURN            = 0x04
} BOOTLOADER_FLAG_Type;

/* Exported functions ------------------------------------------------------- */
void Bootloader_Instruction_Processing(void);
void CAN_Get_PC_CMD_IRQ(void);

void Bootloader_Handle_CMD(void);
void Bootloader_Return_CMD(void);

void NVIC_Config(void);
void CAN_GPIO_Config(void);
void CAN_Config(uint32_t CAN_BaudRate);
uint8_t CANTxMessage(CAN_Module* CANx, CanTxMessage* TxMessage, 
                     uint32_t StdId, uint32_t ExtId, uint8_t IDE, uint8_t RTR, uint8_t DLC,
                     uint8_t Data0, uint8_t Data1, uint8_t Data2, uint8_t Data3, uint8_t Data4, uint8_t Data5, uint8_t Data6, uint8_t Data7);

uint16_t MAL_Init (void);
uint16_t MAL_Erase (uint32_t SectorAddress);
uint16_t MAL_Write (uint32_t SectorAddress, uint32_t DataLength);
uint8_t  *MAL_Read (uint32_t SectorAddress, uint32_t DataLength);
uint32_t FourByte_to_Word(uint8_t *addr);
uint32_t CRC_CalcBlockCRC(uint32_t pBuffer[], uint32_t BufferLength);
u32 Cpy_U8(uint8_t *dst, uint8_t *src, u32 byteLen);
extern uint8_t *MAL_Buffer; /* RAM Buffer for Downloaded Data */
#endif /* __CAN_MAL_H */

/**
 * @}
 */

/**
 * @}
 */

/**
 * @}
 */
