/**
*     Copyright (c) 2025, Nations Technologies Inc.
* 
*     All rights reserved.
*
*     This software is the exclusive property of Nations Technologies Inc. (Hereinafter 
* referred to as NATIONS). This software, and the product of NATIONS described herein 
* (Hereinafter referred to as the Product) are owned by NATIONS under the laws and treaties
* of the People's Republic of China and other applicable jurisdictions worldwide.
*
*     NATIONS does not grant any license under its patents, copyrights, trademarks, or other 
* intellectual property rights. Names and brands of third party may be mentioned or referred 
* thereto (if any) for identification purposes only.
*
*     NATIONS reserves the right to make changes, corrections, enhancements, modifications, and 
* improvements to this software at any time without notice. Please contact NATIONS and obtain 
* the latest version of this software before placing orders.

*     Although NATIONS has attempted to provide accurate and reliable information, NATIONS assumes 
* no responsibility for the accuracy and reliability of this software.
* 
*     It is the responsibility of the user of this software to properly design, program, and test 
* the functionality and safety of any application made of this information and any resulting product. 
* In no event shall NATIONS be liable for any direct, indirect, incidental, special,exemplary, or 
* consequential damages arising in any way out of the use of this software or the Product.
*
*     NATIONS Products are neither intended nor warranted for usage in systems or equipment, any
* malfunction or failure of which may cause loss of human life, bodily injury or severe property 
* damage. Such applications are deemed, "Insecure Usage".
*
*     All Insecure Usage shall be made at user's risk. User shall indemnify NATIONS and hold NATIONS 
* harmless from and against all claims, costs, damages, and other liabilities, arising from or related 
* to any customer's Insecure Usage.

*     Any express or implied warranty with regard to this software or the Product, including,but not 
* limited to, the warranties of merchantability, fitness for a particular purpose and non-infringement
* are disclaimed to the fullest extent permitted by law.

*     Unless otherwise explicitly permitted by NATIONS, anyone may not duplicate, modify, transcribe
* or otherwise distribute this software for any purposes, in whole or in part.
*
*     NATIONS products and technologies shall not be used for or incorporated into any products or systems
* whose manufacture, use, or sale is prohibited under any applicable domestic or foreign laws or regulations. 
* User shall comply with any applicable export control laws and regulations promulgated and administered by 
* the governments of any countries asserting jurisdiction over the parties or transactions.
**/
 
/**
 *\*\file main.c
 *\*\author Nations
 *\*\version v1.0.0
 *\*\copyright Copyright (c) 2025, Nations Technologies Inc. All rights reserved.
 **/

#include "main.h"
#include "delay.h"
#include "log.h"

void GPIO_Configuration(void);
void RCC_Configuration(void);
#ifndef USING_ExSDRAM
void CopyVectTableToITCM(void);
#else
void CopyVectTableToSDRAM(void) ;
#endif

#ifndef USING_ExSDRAM
#define     ITCM_BASE       (0x00000000UL)
/**
*\*\name    CopyVectTableToITCM.
*\*\fun     Copy the vector table from flash to ITCM.
*\*\param   none
*\*\return  none
**/
void CopyVectTableToITCM(void)
{
    uint32_t* pSrcVect = (uint32_t*)(FLASH_BASE);
    uint32_t* pDestVect = (uint32_t*)(ITCM_BASE); 
    uint32_t numVECT = 0x400 / 4;
    for(uint32_t i = 0; i < numVECT; i++)
    {
        pDestVect[i] = pSrcVect[i];
    }
    SCB->VTOR = ITCM_BASE;
    __ISB();
    __DSB();
}

#else
#define     SDRAM_REMAP_BASE       (0x60000000UL)
/**
*\*\name    CopyVectTableToSDRAM.
*\*\fun     Copy the vector table from flash to SDRAM.
*\*\param   none
*\*\return  none
**/
void CopyVectTableToSDRAM(void)   
{
    uint32_t* pSrcVect = (uint32_t*)(FLASH_BASE);
    uint32_t* pDestVect = (uint32_t*)(SDRAM_REMAP_BASE); 
    uint32_t numVECT = 0x400 / 4;
    for(uint32_t i = 0; i < numVECT; i++)
    {
        pDestVect[i] = pSrcVect[i];
    }
    SCB->VTOR = SDRAM_REMAP_BASE;
    __ISB();
    __DSB();
}
#endif

/**
 *\*\name   main.
 *\*\fun    Main program.
 *\*\param  none
 *\*\return none
 */
int main(void)
{
#ifdef USING_ExSDRAM
    CopyVectTableToSDRAM();
#else
    CopyVectTableToITCM();
#endif
    /* RCC configuration -------------------------------------------------------*/
    RCC_Configuration();
    /* LOG configuration -------------------------------------------------------*/
    log_init();
    /* GPIO configuration ------------------------------------------------------*/
    GPIO_Configuration();

    while (1)
    {
        GPIO_SetBits(LED1_PORT,LED1_PIN);
        GPIO_SetBits(LED2_PORT,LED2_PIN);
        systick_delay_ms(500);
        GPIO_ResetBits(LED1_PORT,LED1_PIN);
        GPIO_ResetBits(LED2_PORT,LED2_PIN);
        systick_delay_ms(500);
    }
}

/**
*\*\name    GPIO_Configuration.
*\*\fun     Configures the different GPIO ports.
*\*\return  none
**/
void GPIO_Configuration(void)
{
    GPIO_InitType GPIO_InitStructure;
    
    GPIO_InitStruct(&GPIO_InitStructure);
    GPIO_InitStructure.Pin     = LED1_PIN | LED2_PIN;
    GPIO_InitStructure.GPIO_Mode    = GPIO_MODE_OUTPUT_PP;
    GPIO_InitStructure.GPIO_Pull    = GPIO_NO_PULL;
    GPIO_InitPeripheral( LED1_PORT, &GPIO_InitStructure);
}
/**
*\*\name    RCC_Configuration.
*\*\fun     Configures the different system clocks.
*\*\return  none
**/
void RCC_Configuration(void)
{
    /* Enable peripheral clocks ------------------------------------------------*/
    /* Enable LED1 clocks */
    RCC_EnableAHB5PeriphClk1(LED1_CLOCK, ENABLE);
}


