/*
 * Copyright (c) 2013-2019 Huawei Technologies Co., Ltd. All rights reserved.
 * Copyright (c) 2020-2021 Huawei Device Co., Ltd. All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice, this list of
 * conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright notice, this list
 * of conditions and the following disclaimer in the documentation and/or other materials
 * provided with the distribution.
 *
 * 3. Neither the name of the copyright holder nor the names of its contributors may be used
 * to endorse or promote products derived from this software without specific prior written
 * permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
 * ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */


#include "it_los_atomic.h"

static UINT32 TestCase(VOID)
{
    volatile INT32 value = 0;
    UINTPTR ret;

    ret = LOS_AtomicDecRet(&value);
    ICUNIT_ASSERT_EQUAL(value, ret, value);
    ICUNIT_ASSERT_EQUAL(value, -1, value);

    ret = LOS_AtomicDecRet(&value);
    ICUNIT_ASSERT_EQUAL(value, ret, value);
    ICUNIT_ASSERT_EQUAL(value, -0x02, value);

    value = 0x7fffffff;
    ret = LOS_AtomicDecRet(&value);
    ICUNIT_ASSERT_EQUAL(value, ret, value);
    ICUNIT_ASSERT_EQUAL(value, 0x7ffffffe, value);

    value = -1;
    LOS_AtomicInc(&value);
    ICUNIT_ASSERT_EQUAL(value, 0, value);

    value = 0x7ffffffe;
    LOS_AtomicInc(&value);
    ICUNIT_ASSERT_EQUAL(value, 0x7fffffff, value);

    value = 0;
    LOS_AtomicDec(&value);
    ICUNIT_ASSERT_EQUAL(value, -1, value);

    value = 0x7fffffff;
    LOS_AtomicDec(&value);
    ICUNIT_ASSERT_EQUAL(value, 0x7ffffffe, value);

    return LOS_OK;
}

/**
 * @ingroup TEST_ATO
 * @par TestCase_Number
 * ItLosAtomic001
 * @par TestCase_TestCase_Type
 * Function test
 * @brief Test interface LOS_AtomicDecRet
 * @par TestCase_Pretreatment_Condition
 * NA.
 * @par TestCase_Test_Steps
 * step1: Invoke the LOS_AtomicDecRet interface.
 * @par TestCase_Expected_Result
 * 1.LOS_AtomicDecRet return expected result.
 * @par TestCase_Level
 * Level 0
 * @par TestCase_Automated
 * true
 * @par TestCase_Remark
 * null
 */

VOID ItLosAtomic001(VOID)
{
    TEST_ADD_CASE("ItLosAtomic001", TestCase, TEST_LOS, TEST_ATO, TEST_LEVEL0, TEST_FUNCTION);
}
