/**
*     Copyright (c) 2025, Nations Technologies Inc.
* 
*     All rights reserved.
*
*     This software is the exclusive property of Nations Technologies Inc. (Hereinafter 
* referred to as NATIONS). This software, and the product of NATIONS described herein 
* (Hereinafter referred to as the Product) are owned by NATIONS under the laws and treaties
* of the People's Republic of China and other applicable jurisdictions worldwide.
*
*     NATIONS does not grant any license under its patents, copyrights, trademarks, or other 
* intellectual property rights. Names and brands of third party may be mentioned or referred 
* thereto (if any) for identification purposes only.
*
*     NATIONS reserves the right to make changes, corrections, enhancements, modifications, and 
* improvements to this software at any time without notice. Please contact NATIONS and obtain 
* the latest version of this software before placing orders.

*     Although NATIONS has attempted to provide accurate and reliable information, NATIONS assumes 
* no responsibility for the accuracy and reliability of this software.
* 
*     It is the responsibility of the user of this software to properly design, program, and test 
* the functionality and safety of any application made of this information and any resulting product. 
* In no event shall NATIONS be liable for any direct, indirect, incidental, special,exemplary, or 
* consequential damages arising in any way out of the use of this software or the Product.
*
*     NATIONS Products are neither intended nor warranted for usage in systems or equipment, any
* malfunction or failure of which may cause loss of human life, bodily injury or severe property 
* damage. Such applications are deemed, "Insecure Usage".
*
*     All Insecure Usage shall be made at user's risk. User shall indemnify NATIONS and hold NATIONS 
* harmless from and against all claims, costs, damages, and other liabilities, arising from or related 
* to any customer's Insecure Usage.

*     Any express or implied warranty with regard to this software or the Product, including,but not 
* limited to, the warranties of merchantability, fitness for a particular purpose and non-infringement
* are disclaimed to the fullest extent permitted by law.

*     Unless otherwise explicitly permitted by NATIONS, anyone may not duplicate, modify, transcribe
* or otherwise distribute this software for any purposes, in whole or in part.
*
*     NATIONS products and technologies shall not be used for or incorporated into any products or systems
* whose manufacture, use, or sale is prohibited under any applicable domestic or foreign laws or regulations. 
* User shall comply with any applicable export control laws and regulations promulgated and administered by 
* the governments of any countries asserting jurisdiction over the parties or transactions.
**/
 
/**
 *\*\file main.c
 *\*\author Nations
 *\*\version v1.0.0
 *\*\copyright Copyright (c) 2025, Nations Technologies Inc. All rights reserved.
 **/
#include "main.h"
#include "log.h"
#include "delay.h"

#define  ITCM_BASE       			(0x00000000UL) 

/**
*\*\name    CopyVectTableToTCM.
*\*\fun     Copy the vector table from flash to TCM.
*\*\param   none
*\*\return  none
**/
void CopyVectTableToTCM(void)
{
    uint32_t* pSrcVect = (uint32_t*)(FLASH_BASE);
    uint32_t* pDestVect = (uint32_t*)(ITCM_BASE); 
    uint32_t numVECT = (*(uint32_t*)(FLASH_BASE + 4) - FLASH_BASE) / 4;
    for(uint32_t i = 0; i < numVECT; i++)
    {
        pDestVect[i] = pSrcVect[i];
    }
    SCB->VTOR = ITCM_BASE;
    __ISB();
    __DSB();
}
/**
*\*\name    GPIO_Configuration.
*\*\fun     Configures the different GPIO ports.
*\*\return  none
**/
void GPIO_Configuration(void)
{
    GPIO_InitType GPIO_InitStructure;
    
    GPIO_InitStruct(&GPIO_InitStructure);
    GPIO_InitStructure.Pin          = LED1_PIN;
    GPIO_InitStructure.GPIO_Mode    = GPIO_MODE_OUTPUT_PP;
    GPIO_InitStructure.GPIO_Pull    = GPIO_NO_PULL;
    GPIO_InitPeripheral( LED1_PORT, &GPIO_InitStructure );
}
/**
*\*\name    RCC_Configuration.
*\*\fun     Configures the different system clocks.
*\*\return  none
**/
void RCC_Configuration(void)
{
    /* Enable peripheral clocks ------------------------------------------------*/
    /* Enable LED1 clocks */
    RCC_EnableAHB5PeriphClk1(LED1_CLOCK, ENABLE);
	RCC_EnableAHB5PeriphClk2(RCC_AHB5_PERIPHEN_M7_SEMA4, ENABLE);
}

void PrintfClockInfo(const char* msg)
{
    RCC_ClocksTypeDef RCC_Clocks;
    
    log_info("%s\n", msg);
    RCC_GetClocksFreqValue(&RCC_Clocks);
    log_info("SysClkFreq: %d\n", RCC_Clocks.SysClkFreq); 
    log_info("SysBusDivClkFreq: %d\n", RCC_Clocks.SysBusDivClkFreq);
    log_info("M4ClkFreq: %d\n", RCC_Clocks.M4ClkFreq);  
    log_info("M7ClkFreq: %d\n", RCC_Clocks.M7ClkFreq);  
    log_info("AXIClkFreq: %d\n", RCC_Clocks.AXIClkFreq); 
    log_info("AHB1ClkFreq: %d\n", RCC_Clocks.AHB1ClkFreq);
    log_info("AHB2ClkFreq: %d\n", RCC_Clocks.AHB2ClkFreq);
    log_info("AHB5ClkFreq: %d\n", RCC_Clocks.AHB5ClkFreq);
    log_info("AHB6ClkFreq: %d\n", RCC_Clocks.AHB6ClkFreq);
    log_info("AHB9ClkFreq: %d\n", RCC_Clocks.AHB9ClkFreq);
    log_info("APB1ClkFreq: %d\n", RCC_Clocks.APB1ClkFreq);
    log_info("APB2ClkFreq: %d\n", RCC_Clocks.APB2ClkFreq);
    log_info("APB5ClkFreq: %d\n", RCC_Clocks.APB5ClkFreq);
    log_info("APB6ClkFreq: %d \n", RCC_Clocks.APB6ClkFreq);
}
/**
 *\*\name   main.
 *\*\fun    Main program.
 *\*\param  none
 *\*\return none
 */
int main(void)
{
	CopyVectTableToTCM();
    /* Enable Cortex-M4 boot*/
    RCC_EnableCM4(0x15080000);
    /* Add Cortex-M7 user application code here */
	
	/* RCC Configuration  ******/
    RCC_Configuration();
	/* GPIO Configuration ******/
	GPIO_Configuration();
	/* log Configuration  ******/
	log_init();
	PrintfClockInfo("Clock Freq Printf:\r\n");

    while (1)
    {
		GPIO_SetBits(LED1_PORT,LED1_PIN);
        systick_delay_ms(500);
        GPIO_ResetBits(LED1_PORT,LED1_PIN);
        systick_delay_ms(500);
    }
}



