/**
*     Copyright (c) 2025, Nations Technologies Inc.
* 
*     All rights reserved.
*
*     This software is the exclusive property of Nations Technologies Inc. (Hereinafter 
* referred to as NATIONS). This software, and the product of NATIONS described herein 
* (Hereinafter referred to as the Product) are owned by NATIONS under the laws and treaties
* of the People's Republic of China and other applicable jurisdictions worldwide.
*
*     NATIONS does not grant any license under its patents, copyrights, trademarks, or other 
* intellectual property rights. Names and brands of third party may be mentioned or referred 
* thereto (if any) for identification purposes only.
*
*     NATIONS reserves the right to make changes, corrections, enhancements, modifications, and 
* improvements to this software at any time without notice. Please contact NATIONS and obtain 
* the latest version of this software before placing orders.

*     Although NATIONS has attempted to provide accurate and reliable information, NATIONS assumes 
* no responsibility for the accuracy and reliability of this software.
* 
*     It is the responsibility of the user of this software to properly design, program, and test 
* the functionality and safety of any application made of this information and any resulting product. 
* In no event shall NATIONS be liable for any direct, indirect, incidental, special,exemplary, or 
* consequential damages arising in any way out of the use of this software or the Product.
*
*     NATIONS Products are neither intended nor warranted for usage in systems or equipment, any
* malfunction or failure of which may cause loss of human life, bodily injury or severe property 
* damage. Such applications are deemed, "Insecure Usage".
*
*     All Insecure Usage shall be made at user's risk. User shall indemnify NATIONS and hold NATIONS 
* harmless from and against all claims, costs, damages, and other liabilities, arising from or related 
* to any customer's Insecure Usage.

*     Any express or implied warranty with regard to this software or the Product, including,but not 
* limited to, the warranties of merchantability, fitness for a particular purpose and non-infringement
* are disclaimed to the fullest extent permitted by law.

*     Unless otherwise explicitly permitted by NATIONS, anyone may not duplicate, modify, transcribe
* or otherwise distribute this software for any purposes, in whole or in part.
*
*     NATIONS products and technologies shall not be used for or incorporated into any products or systems
* whose manufacture, use, or sale is prohibited under any applicable domestic or foreign laws or regulations. 
* User shall comply with any applicable export control laws and regulations promulgated and administered by 
* the governments of any countries asserting jurisdiction over the parties or transactions.
**/

/**
*\*\file n32h76x_78x.h
*\*\author Nations
*\*\version v1.0.0
*\*\copyright Copyright (c) 2025, Nations Technologies Inc. All rights reserved.
 */
#ifndef __N32H76X_78X_H__
#define __N32H76X_78X_H__

#ifdef __cplusplus
extern "C" {
#endif

/**  N32H76x_78x_Library_Basic **/

#if !defined USE_STDPERIPH_DRIVER
/*
 * Comment the line below if you will not use the peripherals drivers.
   In this case, these drivers will not be included and the application code will
   be based on direct access to peripherals registers
   */
#define USE_STDPERIPH_DRIVER
#endif

/*
 * In the following line adjust the value of External High Speed oscillator (HSE)
   used in your application

   Tip: To avoid modifying this file each time you need to use different HSE, you
        can define the HSE value in your toolchain compiler preprocessor.
  */
#if !defined HSE_VALUE
#define HSE_VALUE (25000000U) /* Value of the External oscillator in Hz */
#endif                      /* HSE_VALUE */

/** In the following line adjust the HSE\HSI\LSI\LSE Startup
   Timeout value **/
#define HSE_STARTUP_TIMEOUT ((uint16_t)0xF000)  /* SYSCLK= 600M Time out for HSE start up */
#define HSI_STARTUP_TIMEOUT ((uint16_t)0x1800)  /* SYSCLK= 600M Time out for HSI start up */
#define MSI_STARTUP_TIMEOUT ((uint16_t)0x1800)  /* SYSCLK= 600M Time out for HSI start up */
#define LSI_STARTUP_TIMEOUT ((uint16_t)0x1800)  /* SYSCLK= 600M Time out for LSI start up */
#define SECLSI_STARTUP_TIMEOUT ((uint16_t)0x1800)  /* SYSCLK= 600M Time out for LSI start up */
#define LSE_STARTUP_TIMEOUT ((uint32_t)0x01800000)  /* SYSCLK= 600M Time out for LSE start up */

#define HSI_VALUE (64000000U) /* Value of the Internal oscillator in Hz*/
#define MSI_VALUE (16000000U) /* Value of the Internal Medium Speed oscillator in Hz*/
#define LSI_VALUE (32000U) /* Value of the Internal Low Speed oscillator in Hz*/

#define __N32H76x_78x_STDPERIPH_VERSION_MAIN (0x00) /* [31:24] main version */
#define __N32H76x_78x_STDPERIPH_VERSION_SUB1 (0x00) /* [23:16] sub1 version */
#define __N32H76x_78x_STDPERIPH_VERSION_SUB2 (0x01) /* [15:8]  sub2 version */
#define __N32H76x_78x_STDPERIPH_VERSION_RC   (0x00) /* [7:0]  release candidate */

/**  N32H76x_78x Standard Peripheral Library version number  */
#define __N32H76x_78x_STDPERIPH_VERSION                                                                                    \
    ((__N32H76x_78x_STDPERIPH_VERSION_MAIN << 24) | (__N32H76x_78x_STDPERIPH_VERSION_SUB1 << 16)                               \
     | (__N32H76x_78x_STDPERIPH_VERSION_SUB2 << 8) | (__N32H76x_78x_STDPERIPH_VERSION_RC))

/*
 * Configuration of the Cortex-M7 Processor and Core Peripherals
 */
#if defined (N32H76x) || defined (N32H78x)
#define __MPU_PRESENT 1          /* MPU present*/
#define __FPU_PRESENT 1          /* FPU present                            */
#else
#define  __MPU_PRESENT             1 /*!< CORE CM7 devices provide an MPU */
#define __FPU_PRESENT              1 /*!< FPU present  */
#endif                            /* N32H76x_78x */

#if defined (N32H78x)
#define DUAL_CORE
#endif 
#define __NVIC_PRIO_BITS       4 /* N32H76x_78x uses 4 Bits for the Priority Levels    */
#define __Vendor_SysTickConfig 0 /* Set to 1 if different SysTick Config is used */


/**
 * N32H76x_78x Interrupt Number Definition
 */
typedef enum IRQn
{
    /******  Processor Exceptions Numbers ***********************************************************/
    NonMaskableInt_IRQn           = -14,             /* 2 Non Maskable Interrupt                              */
    HardFault_IRQn                = -13,             /* 3 Hard Fault Interrupt                                */
    MemoryManagement_IRQn         = -12,             /* 4 Memory Management Interrupt                         */
    BusFault_IRQn                 = -11,             /* 5 Bus Fault Interrupt                                 */
    UsageFault_IRQn               = -10,             /* 6 Usage Fault Interrupt                               */
    SVCall_IRQn                   = -5,              /* 11 SV Call Interrupt                                  */
    DebugMonitor_IRQn             = -4,              /* 12 Debug Monitor Interrupt                            */
    PendSV_IRQn                   = -2,              /* 14 Pend SV Interrupt                                  */
    SysTick_IRQn                  = -1,              /* 15 System Tick Interrupt                              */
#ifdef CORE_CM4                                                                                               
    WWDG2_IRQn                    = 0,               /* Window2 Watchdog interrupt                          */
#endif /* CORE_CM4 */                                                                                         
#ifdef CORE_CM7                                                                                               
    WWDG1_IRQn                    = 0,               /* Window1 Watchdog interrupt                          */
#endif /* CORE_CM7 */                                                                                         
    PVD_IRQn                      = 1,               /* PVD through EXTI Line16 detection interrupt         */
    RTC_TAMPER_IRQn               = 2,               /* RTC Tamper_Timestamp_Overflow or LSE-CSS through EXTI Line18 interrupt */
    RTC_WKUP_IRQn                 = 3,               /* RTC Wakeup timer through EXTI line 19 interrupt     */
    RCC_IRQn                      = 4,               /* RCC interrupt                                       */
    EXTI0_IRQn                    = 5,               /* EXTI Line 0 interrupt                               */
    EXTI1_IRQn                    = 6,               /* EXTI Line 1 interrupt                               */
    EXTI2_IRQn                    = 7,               /* EXTI Line 2 interrupt                               */
    EXTI3_IRQn                    = 8,               /* EXTI Line 3 interrupt                               */
    EXTI4_IRQn                    = 9,               /* EXTI Line 4 interrupt                               */
    EXTI9_5_IRQn                  = 10,              /* EXTI Line[9:5] interrupt                            */
    EXTI15_10_IRQn                = 11,              /* EXTI Line[15:10] interrupt                          */
    DMA1_Channel0_IRQn            = 12,              /* DMA1 Channel 0 global interrupt                     */
    DMA1_Channel1_IRQn            = 13,              /* DMA1 Channel 1 global interrupt                     */
    DMA1_Channel2_IRQn            = 14,              /* DMA1 Channel 2 global interrupt                     */
    DMA1_Channel3_IRQn            = 15,              /* DMA1 Channel 3 global interrupt                     */
    DMA1_Channel4_IRQn            = 16,              /* DMA1 Channel 4 global interrupt                     */
    DMA1_Channel5_IRQn            = 17,              /* DMA1 Channel 5 global interrupt                     */
    DMA1_Channel6_IRQn            = 18,              /* DMA1 Channel 6 global interrupt                     */
    DMA1_Channel7_IRQn            = 19,              /* DMA1 Channel 7 global interrupt                     */
    DMA2_Channel0_IRQn            = 20,              /* DMA2 Channel 0 global interrupt                     */
    DMA2_Channel1_IRQn            = 21,              /* DMA2 Channel 1 global interrupt                     */
    DMA2_Channel2_IRQn            = 22,              /* DMA2 Channel 2 global interrupt                     */
    DMA2_Channel3_IRQn            = 23,              /* DMA2 Channel 3 global interrupt                     */
    DMA2_Channel4_IRQn            = 24,              /* DMA2 Channel 4 global interrupt                     */
    DMA2_Channel5_IRQn            = 25,              /* DMA2 Channel 5 global interrupt                     */
    DMA2_Channel6_IRQn            = 26,              /* DMA2 Channel 6 global interrupt                     */
    DMA2_Channel7_IRQn            = 27,              /* DMA2 Channel 7 global interrupt                     */
    DMA3_Channel0_IRQn            = 28,              /* DMA3 Channel 0 global interrupt                     */
    DMA3_Channel1_IRQn            = 29,              /* DMA3 Channel 1 global interrupt                     */
    DMA3_Channel2_IRQn            = 30,              /* DMA3 Channel 2 global interrupt                     */
    DMA3_Channel3_IRQn            = 31,              /* DMA3 Channel 3 global interrupt                     */
    DMA3_Channel4_IRQn            = 32,              /* DMA3 Channel 4 global interrupt                     */
    DMA3_Channel5_IRQn            = 33,              /* DMA3 Channel 5 global interrupt                     */
    DMA3_Channel6_IRQn            = 34,              /* DMA3 Channel 6 global interrupt                     */
    DMA3_Channel7_IRQn            = 35,              /* DMA3 Channel 7 global interrupt                     */
    MDMA_Channel0_IRQn            = 36,              /* MDMA Channel 0 global interrupt                     */
    MDMA_Channel1_IRQn            = 37,              /* MDMA Channel 1 global interrupt                     */
    MDMA_Channel2_IRQn            = 38,              /* MDMA Channel 2 global interrupt                     */
    MDMA_Channel3_IRQn            = 39,              /* MDMA Channel 3 global interrupt                     */
    MDMA_Channel4_IRQn            = 40,              /* MDMA Channel 4 global interrupt                     */
    MDMA_Channel5_IRQn            = 41,              /* MDMA Channel 5 global interrupt                     */
    MDMA_Channel6_IRQn            = 42,              /* MDMA Channel 6 global interrupt                     */
    MDMA_Channel7_IRQn            = 43,              /* MDMA Channel 7 global interrupt                     */
    MDMA_Channel8_IRQn            = 44,              /* MDMA Channel 8 global interrupt                     */
    MDMA_Channel9_IRQn           = 45,               /* MDMA Channel 9 global interrupt                    */
    MDMA_Channel10_IRQn           = 46,              /* MDMA Channel 10 global interrupt                    */
    MDMA_Channel11_IRQn           = 47,              /* MDMA Channel 11 global interrupt                    */
    MDMA_Channel12_IRQn           = 48,              /* MDMA Channel 12 global interrupt                    */
    MDMA_Channel13_IRQn           = 49,              /* MDMA Channel 13 global interrupt                    */
    MDMA_Channel14_IRQn           = 50,              /* MDMA Channel 14 global interrupt                    */
    MDMA_Channel15_IRQn           = 51,              /* MDMA Channel 15 global interrupt                    */
    SDPU_IRQn                     = 52,              /* SDPU global interruptSDPU global interrupt          */
#ifdef CORE_CM4                                                                                               
    AHB_ICACHE_IRQn               = 53,              /*!< CM4 AHB iCache interrupt                            */
    AHB_DCACHE_IRQn               = 54,              /*!< CM4 AHB dCache interrupt                            */
    FPU_CPU2_IRQn                 = 55,              /*!< FPU_CM4 global interrupt                            */
#endif /* CORE_CM4 */                                                                                         
#ifdef CORE_CM7                                                                                               
    FPU_CPU1_IRQn                 = 55,              /*!< FPU_CM7 global interrupt                            */
#endif /* CORE_CM7 */                                                                                         
    ECCMON_IRQn                   = 56,              /*!< ECCMON global interrupt                             */
    RTC_ALARM_IRQn                = 57,              /*!< RTC Alarm via EXTI17 interrupt                      */
    I2C1_EV_IRQn                  = 58,              /*!< I2C1 event interrupt                                */
    I2C1_ER_IRQn                  = 59,              /*!< I2C1 error interrupt                                */
    I2C2_EV_IRQn                  = 60,              /*!< I2C2 event interrupt                                */
    I2C2_ER_IRQn                  = 61,              /*!< I2C2 error interrupt                                */
    I2C3_EV_IRQn                  = 62,              /*!< I2C3 event interrupt                                */
    I2C3_ER_IRQn                  = 63,              /*!< I2C3 error interrupt                                */
    I2C4_EV_IRQn                  = 64,              /*!< I2C4 event interrupt                                */
    I2C4_ER_IRQn                  = 65,              /*!< I2C4 error interrupt                                */
    I2C5_EV_IRQn                  = 66,              /*!< I2C5 event interrupt                                */
    I2C5_ER_IRQn                  = 67,              /*!< I2C5 error interrupt                                */
    I2C6_EV_IRQn                  = 68,              /*!< I2C6 event interrupt                                */
    I2C6_ER_IRQn                  = 69,              /*!< I2C6 error interrupt                                */
    I2C7_EV_IRQn                  = 70,              /*!< I2C7 event interrupt                                */
    I2C7_ER_IRQn                  = 71,              /*!< I2C7 error interrupt                                */
    I2C8_EV_IRQn                  = 72,              /*!< I2C8 event interrupt                                */
    I2C8_ER_IRQn                  = 73,              /*!< I2C8 error interrupt                                */
    I2C9_EV_IRQn                  = 74,              /*!< I2C9 event interrupt                                */
    I2C9_ER_IRQn                  = 75,              /*!< I2C9 error interrupt                                */
    I2C10_EV_IRQn                 = 76,              /*!< I2C10 event interrupt                               */
    I2C10_ER_IRQn                 = 77,              /*!< I2C10 error interrupt                               */
    I2S1_IRQn                     = 78,              /*!< I2S1 global interrupt                               */
    I2S2_IRQn                     = 79,              /*!< I2S1 global interrupt                               */
    I2S3_IRQn                     = 80,              /*!< I2S1 global interrupt                               */
    I2S4_IRQn                     = 81,              /*!< I2S1 global interrupt                               */
    xSPI1_IRQn                    = 82,              /*!< xSPI1 global interrupt                              */
    xSPI2_IRQn                    = 83,              /*!< xSPI1 global interrupt                              */
    SPI1_IRQn                     = 84,              /*!< SPI1 global interrupt                               */
    SPI2_IRQn                     = 85,              /*!< SPI2 global interrupt                               */
    SPI3_IRQn                     = 86,              /*!< SPI3 global interrupt                               */
    SPI4_IRQn                     = 87,              /*!< SPI4 global interrupt                               */
    SPI5_IRQn                     = 88,              /*!< SPI5 global interrupt                               */
    SPI6_IRQn                     = 89,              /*!< SPI6 global interrupt                               */
    SPI7_IRQn                     = 90,              /*!< SPI7 global interrupt                               */
    LCD_EV_IRQn                   = 91,              /*!< TFT LCD Controller event interrupt                  */
    LCD_ER_IRQn                   = 92,              /*!< TFT LCD Controller error interrupt                  */
    DVP1_IRQn                     = 93,              /*!< DVP1 global interrupt                               */
    DVP2_IRQn                     = 94,              /*!< DVP1 global interrupt                               */
    DMAMUX2_IRQn                  = 95,              /*!< DMAMUX2 (MDMA MUX) global interrupt                 */
    USB1_HS_EPx_OUT_IRQn          = 96,              /*!< USB1_HS endpoint out global interrupt               */
    USB1_HS_EPx_IN_IRQn           = 97,              /*!< USB1_HS endpoint in global interrupt                */
    USB1_HS_WKUP_IRQn             = 98,              /*!< USB1_HS WKUP interrupt through EXTI line 62         */
    USB1_HS_IRQn                  = 99,              /*!< USB1_HS global interrupt                            */
    USB2_HS_EPx_OUT_IRQn          = 100,             /*!< USB2_HS  endpoint out global interrupt              */
    USB2_HS_EPx_IN_IRQn           = 101,             /*!< USB2_HS  endpoint in global interrupt               */
    USB2_HS_WKUP_IRQn             = 102,             /*!< USB2_HS WKUP interrupt through EXTI line 63         */
    USB2_HS_IRQn                  = 103,             /*!< USB2_HS global interrupt                            */
    ETH1_IRQn                     = 104,             /*!< Ethernet 1 global interrupt                         */
    ETH1_PMT_LPI_IRQn             = 105,             /*!< Ethernet 1 PMT wakeup interrupt and LPI interrupt through EXTI line 83    */
    ETH2_IRQn                     = 106,             /*!< Ethernet 2 global interrupt                                               */
    ETH2_PMT_LPI_IRQn             = 107,             /*!< Ethernet 2  PMT wakeup interrupt and LPI interrupt through EXTI line 84   */
    FDCAN1_INT0_IRQn              = 108,             /*!< FDCAN1 global interrupt line 0                      */                                    
    FDCAN2_INT0_IRQn              = 109,             /*!< FDCAN2 global interrupt line 0                      */
    FDCAN3_INT0_IRQn              = 110,             /*!< FDCAN3 global interrupt line 0                      */
    FDCAN4_INT0_IRQn              = 111,             /*!< FDCAN4 global interrupt line 0                      */
    FDCAN1_INT1_IRQn              = 112,             /*!< FDCAN1 global interrupt line 1                      */
    FDCAN2_INT1_IRQn              = 113,             /*!< FDCAN2 global interrupt line 1                      */
    FDCAN3_INT1_IRQn              = 114,             /*!< FDCAN3 global interrupt line 1                      */
    FDCAN4_INT1_IRQn              = 115,             /*!< FDCAN4 global interrupt line 1                      */
    USART1_IRQn                   = 116,             /*!< USART1 global interrupt                             */
    USART2_IRQn                   = 117,             /*!< USART2 global interrupt                             */
    USART3_IRQn                   = 118,             /*!< USART3 global interrupt                             */
    USART4_IRQn                   = 119,             /*!< USART4 global interrupt                             */
    USART5_IRQn                   = 120,             /*!< USART5 global interrupt                             */
    USART6_IRQn                   = 121,             /*!< USART6 global interrupt                             */
    USART7_IRQn                   = 122,             /*!< USART7 global interrupt                             */
    USART8_IRQn                   = 123,             /*!< USART8 global interrupt                             */
    UART9_IRQn                    = 124,             /*!< UART9 global interrupt                              */
    UART10_IRQn                   = 125,             /*!< UART10 global interrupt                             */
    UART11_IRQn                   = 126,             /*!< UART11 global interrupt                             */
    UART12_IRQn                   = 127,             /*!< UART12 global interrupt                             */
    UART13_IRQn                   = 128,             /*!< UART13 global interrupt                             */
    UART14_IRQn                   = 129,             /*!< UART14 global interrupt                             */
    UART15_IRQn                   = 130,             /*!< UART15 global interrupt                             */
    LPUART1_IRQn                  = 131,             /*!< LPUART1 global interrupt + wakeup through EXTI line 49 */
    LPUART2_IRQn                  = 132,             /*!< LPUART2 global interrupt + wakeup through EXTI line 52 */
    GPU_IRQn                      = 133,             /*!< GPU global interrupt                                */
    SDMMC1_IRQn                   = 135,             /*!< SDMMC1_IRQ + WKUP through EXTI line 24              */
    SDMMC2_IRQn                   = 136,             /*!< SDMMC2_IRQ + WKUP  through EXTI line 25             */
    ADC1_IRQn                     = 137,             /*!< ADC1 global interrupt                               */
    ADC2_IRQn                     = 138,             /*!< ADC2 global interrupt                               */
    ADC3_IRQn                     = 139,             /*!< ADC3 global interrupt                               */
    COMP1_2_IRQn                  = 140,             /*!< COMP1 and COMP2 through EXTI line 20 and 21         */
    COMP3_4_IRQn                  = 141,             /*!< COMP3 and COMP4  through EXTI line 22 and 23        */
    SHRTIM1_INT1_IRQn             = 142,             /*!< High Resolution timer 1 interrupt 1                 */
    SHRTIM1_INT2_IRQn             = 143,             /*!< High Resolution timer 1 interrupt 2                 */
    SHRTIM1_INT3_IRQn             = 144,             /*!< High Resolution timer 1 interrupt 3                 */
    SHRTIM1_INT4_IRQn             = 145,             /*!< High Resolution timer 1 interrupt 4                 */
    SHRTIM1_INT5_IRQn             = 146,             /*!< High Resolution timer 1 interrupt 5                 */
    SHRTIM1_INT6_IRQn             = 147,             /*!< High Resolution timer 1 interrupt 6                 */
    SHRTIM1_INT7_IRQn             = 148,             /*!< High Resolution timer 1 interrupt 7                 */
    SHRTIM1_INT8_IRQn             = 149,             /*!< High Resolution timer 1 interrupt 8                 */
    SHRTIM2_INT1_IRQn             = 150,             /*!< High Resolution timer 1 interrupt 1                 */
    SHRTIM2_INT2_IRQn             = 151,             /*!< High Resolution timer 1 interrupt 2                 */
    SHRTIM2_INT3_IRQn             = 152,             /*!< High Resolution timer 1 interrupt 3                 */
    SHRTIM2_INT4_IRQn             = 153,             /*!< High Resolution timer 1 interrupt 4                 */
    SHRTIM2_INT5_IRQn             = 154,             /*!< High Resolution timer 1 interrupt 5                 */
    SHRTIM2_INT6_IRQn             = 155,             /*!< High Resolution timer 1 interrupt 6                 */
    SHRTIM2_INT7_IRQn             = 156,             /*!< High Resolution timer 1 interrupt 7                 */
    SHRTIM2_INT8_IRQn             = 157,             /*!< High Resolution timer 1 interrupt 8                 */
    FDCAN5_INT0_IRQn              = 158,             /*!< FDCAN5 global interrupt line 0                      */
    FDCAN6_INT0_IRQn              = 159,             /*!< FDCAN6 global interrupt  line 0                     */
    FDCAN7_INT0_IRQn              = 160,             /*!< FDCAN7 global interrupt line 0                      */
    FDCAN8_INT0_IRQn              = 161,             /*!< FDCAN8 global interrupt line 0                      */
    FDCAN5_INT1_IRQn              = 162,             /*!< FDCAN5 global interrupt line 1                      */
    FDCAN6_INT1_IRQn              = 163,             /*!< FDCAN6 global interrupt line 1                      */
    FDCAN7_INT1_IRQn              = 164,             /*!< FDCAN7 global interrupt line 1                      */
    FDCAN8_INT1_IRQn              = 165,             /*!< FDCAN8 global interrupt line 1                      */
    DSI_IRQn                      = 166,             /*!< MIPI DSI Interrupt through EXTI line 87             */
#ifdef CORE_CM4                                                                                               
    AHB_CACHE_PARMON_IRQn          = 167,             /*!< AHB i/dCACHE parity error intertupt                 */
#endif /* CORE_CM4 */                                                                                         
    LPTIM5_WKUP_IRQn              = 168,             /*!< LPTIM5 wakeup  through EXTI 86                      */
    JPEG_SGDMA_H2P_IRQn           = 169,             /*!< JPEG SGDMA Host to Peripheral Interrupt             */
    JPEG_SGDMA_P2H_IRQn           = 170,             /*!< JPEG SGDMA Peripheral to Host Interrupt             */
    WAKEUP_IO_IRQn                = 171,             /*!< 6 WAKEUP IOs through EXTI line 70-75                */
                                                                                                              
#ifdef CORE_CM4                                                                                               
    SEMA4_INT2_IRQn               = 173,             /*!< SEMA4 interrupt2                                    */
    WWDG1_RST_IRQn                = 174,             /*!< WWDG1 reset interrupt through EXTI line 81          */
#endif /* CORE_CM4 */                                                                                         
#ifdef CORE_CM7                                                                                               
    SEMA4_INT1_IRQn               = 172,             /*!< SEMA4 interrupt1                                    */
    WWDG2_RST_IRQn                = 174,             /*!< WWDG2 reset interrupt through EXTI line 82          */
#endif /* CORE_CM7 */                                                                                         
    OTPC_IRQn                     = 175,             /*!< OTPC interrupt                                      */
    FEMC_IRQn                     = 176,             /*!< FEMC interrupt                                      */
#ifdef CORE_CM4                                                                                               
    DCMUA_IRQn                    = 177,             /*!< DCMUA interrupt                                     */
#endif /* CORE_CM4 */                                                                                         
#ifdef CORE_CM7                                                                                               
    DCMUB_IRQn                    = 177,             /*!< DCMUB interrupt                                     */
#endif /* CORE_CM7 */                                                                                         
    DAC1_IRQn                     = 178,             /*!< DAC1 IRQ                                            */
    DAC2_IRQn                     = 179,             /*!< DAC2 IRQ                                            */
    MDMA_AHBS_ER_IRQn             = 180,             /*!< MDMA AHBS ERROR through EXTI line 90               */
    CM7_CATCH_READ_ER_IRQn        = 181,             /*!< CM7 Error on Cache Read  through EXTI line 64-65    */
    DAC3_IRQn                     = 182,             /*!< DAC3 interrupt                                      */
    DAC4_IRQn                     = 183,             /*!< DAC4 interrupt                                      */
    EMC_IRQn                      = 184,             /*!< EMC event interrupt through EXTI line 88-89         */
    DAC5_IRQn                     = 185,             /*!< DAC5 interrupt                                      */
    DAC6_IRQn                     = 186,             /*!< DAC6 interrupt                                      */
    ESC_OPB_IRQn                  = 187,             /*!< ETHERCAT OPB Interrupt                              */
    ESC_SYNC0_IRQn                = 188,             /*!< ETHERCAT SYNC0 Interrupt                            */
    ESC_SYNC1_RQn                 = 189,             /*!< ETHERCAT SYNC1 Interrupt                            */
    ESC_WRP_IRQn                  = 190,             /*!< ETHERCAT WRAPPER Interrupt                          */
    ATIM1_BRK_IRQn                = 192,             /*!< Advanced timer 1 break interrupt                    */
    ATIM1_TRG_COM_IRQn            = 193,             /*!< Advanced timer 1 trigger and commutation interrupts */
    ATIM1_CC_IRQn                 = 194,             /*!< Advanced timer 1 capture/compare interrupt          */
    ATIM1_UP_IRQn                 = 195,             /*!< Advanced timer 1 update interrupt                   */
    ATIM2_BRK_IRQn                = 196,             /*!< Advanced timer 2 break interrupt                    */
    ATIM2_TRG_COM_IRQn            = 197,             /*!< advanced timer 2 trigger and commutation interrupts */
    ATIM2_CC_IRQn                 = 198,             /*!< Advanced timer 2 capture/compare interrupt          */
    ATIM2_UP_IRQn                 = 199,             /*!< Advanced timer 2 update interrupt                   */
    ATIM3_BRK_IRQn                = 200,             /*!< Advanced timer 3 break interrupt                    */
    ATIM3_TRG_COM_IRQn            = 201,             /*!< Advanced timer 3 trigger and commutation interrupts */
    ATIM3_CC_IRQn                 = 202,             /*!< Advanced timer 3 capture/compare interrupt          */
    ATIM3_UP_IRQn                 = 203,             /*!< Advanced timer 3 update interrupt                   */
    ATIM4_BRK_IRQn                = 204,             /*!< Advanced timer 4 break interrupt                    */
    ATIM4_TRG_COM_IRQn            = 205,             /*!< Advanced timer 4 trigger and commutation interrupts */
    ATIM4_CC_IRQn                 = 206,             /*!< Advanced timer 4 capture/compare interrupt          */
    ATIM4_UP_IRQn                 = 207,             /*!< Advanced timer 4 update interrupt                   */
    GTIMA1_IRQn                   = 208,             /*!< General timer A 1 global interrupt                    */
    GTIMA2_IRQn                   = 209,             /*!< General timer A 2 global interrupt                    */
    GTIMA3_IRQn                   = 210,             /*!< General timer A 3 global interrupt                    */
    GTIMA4_IRQn                   = 211,             /*!< General timer A 4 global interrupt                    */
    GTIMA5_IRQn                   = 212,             /*!< General timer A 5 global interrupt                    */
    GTIMA6_IRQn                   = 213,             /*!< General timer A 6 global interrupt                    */
    GTIMA7_IRQn                   = 214,             /*!< General timer A 7 global interrupt                    */
    GTIMB1_IRQn                   = 215,             /*!< General timer B 1 global interrupt                    */
    GTIMB2_IRQn                   = 216,             /*!< General timer B 2 global interrupt                    */
    GTIMB3_IRQn                   = 217,             /*!< General timer B 3 global interrupt                   */
    BTIM1_IRQn                    = 218,             /*!< Base timer 1 global interrupt                       */
    BTIM2_IRQn                    = 219,             /*!< Base timer 2 global interrupt                       */
    BTIM3_IRQn                    = 220,             /*!< Base timer 3 global interrupt                       */
    BTIM4_IRQn                    = 221,             /*!< Base timer 4 global interrupt                       */
    LPTIM1_WKUP_IRQn              = 222,             /*!< LPTIM1 wakeup interrupt                             */
    LPTIM2_WKUP_IRQn              = 223,             /*!< LPTIM2 wakeup interrupt                             */
    LPTIM3_WKUP_IRQn              = 224,             /*!< LPTIM3 wakeup interrupt                             */
    LPTIM4_WKUP_IRQn              = 225,             /*!< LPTIM4 wakeup interrupt                             */
    DSMU_FLT0_IRQn                = 226,             /*!< DSMU_FLT0                                           */
    DSMU_FLT1_IRQn                = 227,             /*!< DSMU_FLT1                                           */
    DSMU_FLT2_IRQn                = 228,             /*!< DSMU_FLT2                                           */
    DSMU_FLT3_IRQn                = 229,             /*!< DSMU_FLT3                                           */
    FMAC_IRQn                     = 230,             /*!< FMAC global interrupt                               */
    CORDIC_IRQn                   = 231,             /*!< CORDIC global interrupt                             */
    DMAMUX_IRQn                   = 232,             /*!< DMAMUX interrupt                                    */
    MMU_INT_IRQn                  = 233,             /*!< MMU interrupt                                       */
} IRQn_Type;

#if defined (CORE_CM4)
#include "core_cm4.h"
#endif
#if defined (CORE_CM7)
#include "core_cm7.h"
#endif

#include "system_n32H76x_78x.h"
#include <stdint.h>
#include <stdio.h>
#include <stdbool.h>

typedef int32_t s32;
typedef int16_t s16;
typedef int8_t s8;

typedef const int32_t sc32; /* Read Only */
typedef const int16_t sc16; /* Read Only */
typedef const int8_t sc8;   /* Read Only */

typedef __IO int32_t vs32;
typedef __IO int16_t vs16;
typedef __IO int8_t vs8;

typedef __I int32_t vsc32; /* Read Only */
typedef __I int16_t vsc16; /* Read Only */
typedef __I int8_t vsc8;   /* Read Only */

typedef uint32_t u32;
typedef uint16_t u16;
typedef uint8_t u8;

typedef const uint32_t uc32; /* Read Only */
typedef const uint16_t uc16; /* Read Only */
typedef const uint8_t uc8;   /* Read Only */

typedef __IO uint32_t vu32;
typedef __IO uint16_t vu16;
typedef __IO uint8_t vu8;

typedef __I uint32_t vuc32; /* Read Only */
typedef __I uint16_t vuc16; /* Read Only */
typedef __I uint8_t vuc8;   /* Read Only */
typedef enum
{
    RESET = 0,
    SET   = !RESET
} FlagStatus,ITStatus,
    INTStatus;

typedef enum
{
    DISABLE = 0,
    ENABLE  = !DISABLE
} FunctionalState,FunctionalStatus;
#define IS_FUNCTIONAL_STATE(STATE) (((STATE) == DISABLE) || ((STATE) == ENABLE))

typedef enum
{
    ERROR   = 0,
    SUCCESS = !ERROR
} ErrorStatus;

/* N32H76x_78x Standard Peripheral Library old definitions (maintained for legacy purpose) */
#define HSEStartUp_TimeOut HSE_STARTUP_TIMEOUT
#define HSE_Value          HSE_VALUE
#define HSI_Value          HSI_VALUE

/*** Analog to Digital Converter ***/
typedef struct
{
    __IO uint32_t STS;          //0x00
    __IO uint32_t CTRL1;        //0x04
    __IO uint32_t CTRL2;        //0x08
    __IO uint32_t CTRL3;        //0x0C
    __IO uint32_t SAMPT1;       //0x10
    __IO uint32_t SAMPT2;       //0x14
    __IO uint32_t SAMPT3;       //0x18
    __IO uint32_t DIFSEL;       //0x1C
    __IO uint32_t AWDCTRL;      //0x20
    __IO uint32_t OFFSET1;      //0x24
    __IO uint32_t OFFSET2;      //0x28
    __IO uint32_t OFFSET3;      //0x2C
    __IO uint32_t OFFSET4;      //0x30
    __IO uint32_t AWD1HIGH;     //0x34
    __IO uint32_t AWD1LOW;      //0x38
    __IO uint32_t AWD2HIGH;     //0x3C
    __IO uint32_t AWD2LOW;      //0x40
    __IO uint32_t AWD3HIGH;     //0x44
    __IO uint32_t AWD3LOW;      //0x48
    __IO uint32_t AWD2EN;       //0x4C
    __IO uint32_t AWD3EN;       //0x50
    __IO uint32_t AWD2INTEN;    //0x54
    __IO uint32_t AWD3INTEN;    //0x58
    __IO uint32_t AWD2STS;      //0x5C
    __IO uint32_t AWD3STS;      //0x60
    __IO uint32_t RSEQ1;        //0x64
    __IO uint32_t RSEQ2;        //0x68
    __IO uint32_t RSEQ3;        //0x6C
    __IO uint32_t RSEQ4;        //0x70
    __IO uint32_t JSEQ;         //0x74
    __IO uint32_t JDAT1;        //0x78
    __IO uint32_t JDAT2;        //0x7C
    __IO uint32_t JDAT3;        //0x80 
    __IO uint32_t JDAT4;        //0x84
    __IO uint32_t DAT;          //0x88 
    __IO uint32_t FIFOCFG;      //0x8C
    __IO uint32_t FIFOSTS;      //0x90
    __IO uint32_t DLYSMP;       //0x94
    __IO uint32_t OSCFG;        //0x98
    __IO uint32_t INTLRCFG;     //0x9C
    __IO uint32_t GCOMP;        //0xA0
}ADC_Module;

   
/*** LCDC Register ***/
typedef struct
{
    __I  uint32_t RESERVED0[2];     /* Reserved, 0x00, 0x04 */
    __IO uint32_t SYNCCTRL;         /* LCDC Synchronization Size Conctrl Register,    Address offset: 0x08 */
    __IO uint32_t BPCTRL;           /* LCDC Back Porch Conctrl Register,              Address offset: 0x0C */
    __IO uint32_t AWCTRL;           /* LCDC Active Width Conctrl Register,            Address offset: 0x10 */
    __IO uint32_t TWCTRL;           /* LCDC Total Width Conctrl Register,             Address offset: 0x14 */
    __IO uint32_t GCTRL;            /* LCDC Global Control Register ,                 Address offset: 0x18 */
    __I  uint32_t RESERVED1[2];     /* Reserved, 0x1C, 0x20 */
    __IO uint32_t SRCTRL;           /* LCDC Shadow Reload Conctrl Register,           Address offset: 0x24 */
    __I  uint32_t RESERVED2;        /* Reserved, 0x28 */                
    __IO uint32_t BGCCTRL;          /* LCDC Background Color Conctrl Register,        Address offset: 0x2C */
    __I  uint32_t RESERVED3;        /* Reserved, 0x30 */
    __IO uint32_t INTEN;            /* LCDC Interrupt Enable Register,                Address offset: 0x34 */
    __IO uint32_t INTSTS;           /* LCDC Interrupt Status Register,                Address offset: 0x38 */
    __IO uint32_t INTCLR;           /* LCDC Interrupt Clear Register,                 Address offset: 0x3C */
    __IO uint32_t LINTPCTRL;        /* LCDC Line Interrupt Position Conctrl Register, Address offset: 0x40 */
    __IO uint32_t CPSTS;            /* LCDC Current Position Status Register,         Address offset: 0x44 */
    __IO uint32_t CDSTS;            /* LCDC Current Display Status Register,          Address offset: 0x48 */
    __I  uint32_t RESERVED4[5];     /* Reserved, 0x4C ~ 0x5C */
    __IO uint32_t EXTDCTRL;         /* LCDC External Display Control Register,        Address offset: 0x60 */
} LCDC_Module;  
      
typedef struct
{  
    __I  uint32_t RESERVED0[2];     /* Reserved, 0x00 0x04                                                                 */
    __IO uint32_t LSRCTRL;          /* LCDC Layerx Reload Control Register                           Address offset: 0x08  */
    __IO uint32_t LCTRL;            /* LCDC Layerx Control Register                                  Address offset: 0x0C  */
    __IO uint32_t WHPCTRL;          /* LCDC Layerx Window Horizontal Position Configuration Register Address offset: 0x10  */
    __IO uint32_t WVPCTRL;          /* LCDC Layerx Window Vertical Position Configuration Register   Address offset: 0x14  */
    __IO uint32_t CKCTRL;           /* LCDC Layerx Color Keying Configuration Register               Address offset: 0x18  */
    __IO uint32_t PFCTRL;           /* LCDC Layerx Pixel Format Configuration Register               Address offset: 0x1C  */
    __IO uint32_t CACTRL;           /* LCDC Layerx Constant Alpha Configuration Register             Address offset: 0x20  */
    __IO uint32_t DCCTRL;           /* LCDC Layerx Default Color Configuration Register              Address offset: 0x24  */
    __IO uint32_t BFCTRL;           /* LCDC Layerx Blending Factors Configuration Register           Address offset: 0x28  */
    __IO uint32_t FBBCTRL;          /* LCDC Layerx Frame Buffer Bus Control Register                 Address offset: 0x2C  */
    __IO uint32_t AFBCTRL;          /* LCDC Layerx Auxiliary Frame Buffer Control Register           Address offset: 0x30  */
    __IO uint32_t CFBADDR;          /* LCDC Layerx Color Frame Buffer Address Register               Address offset: 0x34  */
    __IO uint32_t CFBLEN;           /* LCDC Layerx Color Frame Buffer Length Register                Address offset: 0x38  */
    __IO uint32_t CFBLNUM;          /* LCDC Layerx Color Frame Buffer Line Number Register           Address offset: 0x3C  */
    __IO uint32_t AFBADDR0;         /* LCDC Layerx Auxiliary 0 Fram Buffer Address Register          Address offset: 0x40  */
    __IO uint32_t AFBADDR1;         /* LCDC Layerx Auxiliary 1 Fram Buffer Address Register          Address offset: 0x44  */
    __IO uint32_t AFBLEN;           /* LCDC Layerx Auxiliary Fram Buffer Length(pitch) Register      Address offset: 0x48  */
    __IO uint32_t AFBLNUM;          /* LCDC Layerx Auxiliary Fram Buffer Lines Register              Address offset: 0x4C  */
    __IO uint32_t CLUTWR;           /* LCDC Layerx CLUT Write Register                               Address offset: 0x50  */
    __IO uint32_t SINS;             /* LCDC Layerx Scaler Input Size Register                        Address offset: 0x54  */
    __IO uint32_t SOUTS;            /* LCDC Layerx Scaler Output Size Register                       Address offset: 0x58  */
    __IO uint32_t VSF;              /* LCDC Layerx Vertical Scaling Factor Register                  Address offset: 0x5C  */
    __IO uint32_t VSP;              /* LCDC Layerx Vertical Scaling Phase Register                   Address offset: 0x60  */
    __IO uint32_t HSF;              /* LCDC Layerx Horizontal Scaling Factor Register                Address offset: 0x64  */
    __IO uint32_t HSP;              /* LCDC Layerx Horizontal Scaling Phase Register                 Address offset: 0x68  */
    __IO uint32_t YUVS1;            /* LCDC Layerx YCbCr Scale 1 Register                            Address offset: 0x6c  */
    __IO uint32_t YUVS2;            /* LCDC Layerx YCbCr Scale 2 Register                            Address offset: 0x70  */
    __IO uint32_t FCF1;             /* LCDC Layerx Flexible color format 1 Register                  Address offset: 0x74  */
    __IO uint32_t FCF2;             /* LCDC Layerx Flexible color format 2 Register                  Address offset: 0x78  */
} LCDC_Layer_Module;

/*** COMP_Single ***/
typedef struct
{
    __IO uint32_t CTRL;
    __IO uint32_t FILC;
    __IO uint32_t FILP;
    __IO uint32_t RES;
} COMP_SingleType;

/*** Comparator ***/
typedef struct
{
    __IO uint32_t RES[4]; 
    COMP_SingleType Cmp[4]; //0x10
    __IO uint32_t LPR;      //0x50
    __IO uint32_t WINMODE;  //0x54
    __IO uint32_t RES1;     //0x58
    __IO uint32_t LOCK;     //0x5C
    __IO uint32_t INTEN;    //0x60
    __IO uint32_t INTSTS;   //0x64
    __IO uint32_t OTIMEN;   //0x68
}COMP_Module;


/*** Digital to Analog Converter ***/
typedef struct
{
    __IO uint32_t CTRL;     //0x00
    __IO uint32_t SOTTR;    //0x04
    __IO uint32_t DATO1;    //0x08
    __IO uint32_t DATO2;    //0x0C
    __IO uint32_t DR8CH1;   //0x10
    __IO uint32_t DL12CH1;  //0x14
    __IO uint32_t DR12CH1;  //0x18
    __IO uint32_t DR8CH2;   //0x1C
    __IO uint32_t DL12CH2;  //0x20
    __IO uint32_t DR12CH2;  //0x24
    __IO uint32_t DR8DCH;   //0x28
    __IO uint32_t DL12DCH;  //0x2C
    __IO uint32_t DR12DCH;  //0x30
    __IO uint32_t RES0;     //0x34
    __IO uint32_t SELCTRL;  //0x38
    __IO uint32_t STS;      //0x3C
    __IO uint32_t GCTRL;    //0x40
    __IO uint32_t STINC;    //0x44
    __IO uint32_t STRST;    //0x48
    __IO uint32_t RES1[4];  
    __IO uint32_t CALC;     //0x5C
} DAC_Module;


/*** CRC ***/
typedef struct
{
    __IO uint32_t   DAT;        //0x00
    __IO uint32_t   IDAT;       //0x04
    __IO uint32_t   CTRL;       //0x08
    __IO uint32_t   LRC;        //0x0C
    __IO uint32_t   INIT;       //0x10
    __IO uint32_t   POL;        //0x14
    __IO uint32_t   INXORDAT;   //0x18
    __IO uint32_t   OUTXORDAT;  //0x1C
} CRC_Module;

/**
  * @brief TCM Configuration
  */
typedef struct
{
    __IO uint32_t  TCM_CR;                  /*!< (offset 0x000) TCM configuration Register              */
} TCMSRAMC_TypeDef;



/*** DMA Controller on AHB Bus (DMA1,DMA2,DMA3) ***/
typedef struct
{
    __IO uint32_t  SA;           /* (offset 0x0000) Source Address Register */
    __I  uint32_t  RESERVED0;
    __IO uint32_t  DA;           /* (offset 0x0008) Destination Address Register */
    __I  uint32_t  RESERVED1;
    __IO uint32_t  LLP;          /* (offset 0x0010) Linked List Pointer Register */
    __I  uint32_t  RESERVED2;
    __IO uint64_t  CTRL;         /* (offset 0x0018) Control Register Low */
    __I  uint32_t  RESERVED3[8];
    __IO uint64_t  CFG;          /* (offset 0x0040) Configuration Register Low */
    __IO uint32_t  SG;           /* (offset 0x0048) Source Gather Register */
    __I  uint32_t  RESERVED4;
    __IO uint32_t  DS;           /* (offset 0x0050) Destination Scatter Register */
    __I  uint32_t  RESERVED5;
} DMA_ChannelType;

typedef struct
{
    /** DMA Channel Registers **/
    __IO DMA_ChannelType CH[8];    /* (offset 0x0000 + x * 0x58 ) Channel x from 0 to 7 */

    /** DMA Interrupt Registers **/
    __IO uint32_t  RAWTCINTSTS;    /* (offset 0x02C0) Raw IntTfr Status */
    __I  uint32_t  RESERVED0;
    __IO uint32_t  RAWBTCINTSTS;   /* (offset 0x02C8) Raw IntBlock Status */
    __I  uint32_t  RESERVED1;
    __IO uint32_t  RAWSTCINTSTS;   /* (offset 0x02D0) Raw IntSrcTran Status */
    __I  uint32_t  RESERVED2;
    __IO uint32_t  RAWDTCINTSTS;   /* (offset 0x02D8) Raw IntDstTran Status */
    __I  uint32_t  RESERVED3;
    __IO uint32_t  RAWERRINTSTS;   /* (offset 0x02E0) Raw IntErr Status */
    __I  uint32_t  RESERVED4;
    __I  uint32_t  TCINTSTS;       /* (offset 0x02E8) IntTfr Status */
    __I  uint32_t  RESERVED5;
    __I  uint32_t  BTCINTSTS;      /* (offset 0x02F0) IntBlock Status */
    __I  uint32_t  RESERVED6;
    __I  uint32_t  STCINTSTS;      /* (offset 0x02F8) IntSrcTran Status */
    __I  uint32_t  RESERVED7;
    __I  uint32_t  DTCINTSTS;      /* (offset 0x0300) IntDstTran Status */
    __I  uint32_t  RESERVED8;
    __I  uint32_t  ERRINTSTS;      /* (offset 0x0308) IntErr Status */
    __I  uint32_t  RESERVED9;
    __IO uint32_t  TCINTMSK;       /* (offset 0x0310) Mask for Raw IntTfr Status */
    __I  uint32_t  RESERVED10;
    __IO uint32_t  BTCINTMSK;      /* (offset 0x0318) Mask for Raw IntBlock Status */
    __I  uint32_t  RESERVED11;
    __IO uint32_t  STCINTMSK;      /* (offset 0x0320) Mask for Raw IntSrcTran Status */
    __I  uint32_t  RESERVED12;
    __IO uint32_t  DTCINTMSK;      /* (offset 0x0328) Mask for Raw IntDstTran Status */
    __I  uint32_t  RESERVED13;
    __IO uint32_t  ERRINTMSK;      /* (offset 0x0330) Mask for Raw IntErr Status */
    __I  uint32_t  RESERVED14;
    __O  uint32_t  TCINTCLR;       /* (offset 0x0338) Clear IntTfr Interrupt */
    __I  uint32_t  RESERVED15;
    __O  uint32_t  BTCINTCLR;      /* (offset 0x0340) Clear IntBlock Interrupt */
    __I  uint32_t  RESERVED16;
    __O  uint32_t  STCINTCLR;      /* (offset 0x0348) Clear IntSrcTran Interrupt */
    __I  uint32_t  RESERVED17;
    __O  uint32_t  DTCINTCLR;      /* (offset 0x0350) Clear IntDstTran Interrupt */
    __I  uint32_t  RESERVED18;
    __O  uint32_t  ERRINTCLR;      /* (offset 0x0358) Clear IntErr Interrupt */
    __I  uint32_t  RESERVED19;
    __I  uint32_t  INTCBESTS;      /* (offset 0x0360) Combined Interrupt Status Register */

    /** DMA Software Handshake Registers **/
    __I  uint32_t  RESERVED20;
    __IO uint32_t  SRCSWTREQ;      /* (offset 0x0368) Source Software Transaction Request Register */
    __I  uint32_t  RESERVED21;
    __IO uint32_t  DSTSWTREQ;      /* (offset 0x0370) Destination Software Transaction Request Register */
    __I  uint32_t  RESERVED22;
    __IO uint32_t  SRCSGTREQ;      /* (offset 0x0378) Single Source Transaction Request Register */
    __I  uint32_t  RESERVED23;
    __IO uint32_t  DSTSGTREQ;      /* (offset 0x0380) Single Destination Transaction Request Register */
    __I  uint32_t  RESERVED24;
    __IO uint32_t  SRCLTREQ;       /* (offset 0x0388) Last Source Transaction Request Register */
    __I  uint32_t  RESERVED25;
    __IO uint32_t  DSTLTREQ;       /* (offset 0x0390) Last Destination Transaction Request Register */

    /** DMA Miscellaneous Registers **/
    __I  uint32_t  RESERVED26;
    __IO uint32_t  CFG;            /* (offset 0x0398) DMA Configuration Register */
    __I  uint32_t  RESERVED27;
    __IO uint32_t  CHEN;           /* (offset 0x03A0) DMA Channel Enable Register */
    __I  uint32_t  RESERVED28;
    __I  uint32_t  ID;             /* (offset 0x03A8) DMA ID Register */
    __I  uint32_t  RESERVED29[19];
    __I  uint32_t  TYPE;           /* (offset 0x03F8) DMA Component Type */
    __I  uint32_t  VERSION;        /* (offset 0x03FC) DMA Component Version */
} DMA_Module;


/*** DMA AXI Bus Controller (MDMA) ***/
typedef struct
{
    __IO uint64_t  SA;             /* (offset 0x0100) Source Address */
    __IO uint64_t  DA;             /* (offset 0x0108) Destination Address */
    __IO uint32_t  BTS;            /* (offset 0x0110) Block Transfer Size */
    __I  uint32_t  RESERVED0;
    __IO uint64_t  CTRL;           /* (offset 0x0118) Control */
    __IO uint64_t  CFG;            /* (offset 0x0120) Configuration */
    __IO uint64_t  LLP;            /* (offset 0x0128) Linked List Pointer */
    __I  uint64_t  STS;            /* (offset 0x0130) Status */
    __IO uint32_t  SHSRC;          /* (offset 0x0138) Software Handshake Source */
    __I  uint32_t  RESERVED1;
    __IO uint32_t  SHDST;          /* (offset 0x0140) Software Handshake Destination */
    __I  uint32_t  RESERVED2;
    __O  uint32_t  BTRR;           /* (offset 0x0148)  Block Transfer Resume Request */
    __I  uint32_t  RESERVED3[3];
    __I  uint32_t  AXIQOS;         /* (offset 0x0158) AXI QOS */
    __I  uint32_t  RESERVED4[9];
    __IO uint32_t  INTSTSEN;       /* (offset 0x0180) Interrupt Status Enable */
    __I  uint32_t  RESERVED5;
    __I  uint32_t  INTSTS;         /* (offset 0x0188) Interrupt Status */
    __I  uint32_t  RESERVED6;
    __IO uint32_t  INTSGLEN;       /* (offset 0x0190) Interrupt Signal Enable */
    __I  uint32_t  RESERVED7;
    __O  uint32_t  INTCLR;         /* (offset 0x0198) Interrupt Clear */
    __I  uint32_t  RESERVED8[25];
} MDMA_ChannelType;

typedef struct
{
    /** MDMA Common Registers **/
    __I  uint32_t  ID;             /* (offset 0x0000) DMAC ID */
    __I  uint32_t  RESERVED0;
    __I  uint32_t  VERSION;        /* (offset 0x0008) DMAC Component Version */
    __I  uint32_t  RESERVED1;
    __IO uint32_t  CFG;            /* (offset 0x0010) DMAC Configuration */
    __I  uint32_t  RESERVED2;
    __IO uint32_t  CHEN;           /* (offset 0x0018) DMAC Channel Enable */
    __I  uint32_t  RESERVED3;
    __IO uint32_t  CHSUSP;         /* (offset 0x0020) DMAC Channel Suspend */
    __I  uint32_t  RESERVED4[3]; 
    __I  uint64_t  INTSTS;         /* (offset 0x0030) DMAC Interrupt Status */
    __O  uint32_t  CRINTCLR;       /* (offset 0x0038) DMAC Interrupt Clear */
    __I  uint32_t  RESERVED5;
    __IO uint32_t  CRINTSTSEN;     /* (offset 0x0040) DMAC Interrupt Status Enable */
    __I  uint32_t  RESERVED6;
    __IO uint32_t  CRINTSGLEN;     /* (offset 0x0048) DMAC Interrupt Signal Enable */
    __I  uint32_t  RESERVED7;
    __I  uint32_t  CRINTSTS;       /* (offset 0x0050) DMAC Interrupt Status */
    __I  uint32_t  RESERVED8;
    __IO uint32_t  SWRST;          /* (offset 0x0058) DMAC Software Reset Register */
    __I  uint32_t  RESERVED9;
    __IO uint64_t  LPCFG;          /* (offset 0x0060) DMAC Low Power Configuration Register */
    __I  uint32_t  RESERVED10[38];

    /** MDMA Channel Registers **/
    MDMA_ChannelType CH[16];       /* (offset 0x0100 + x * 0x100) Channel x from 0 to 15 */

} MDMA_Module;

/***  DMAMUX1 ***/
typedef struct
{
    __IO uint32_t  CHxCTRL[24]; /*  DMA Multiplexer Channel x Control Register */
    __IO uint32_t  STS;         /*  DMA Channel Status Register */
    __IO uint32_t  CLR;         /*  DMA Channel Clear Flag Register */
    __IO uint32_t  CHxCFG[24];  /*  DMA Request Generator x Control Register */
    __IO uint32_t  RGSTS;       /*  DMA Request Generator x Interrupt Status Register */
    __IO uint32_t  RGCLR;       /*  DMA Request Generator x Interrupt Clear Register */
}DMAMUX1_Module;

/***  DMAMUX2 ***/
typedef struct
{
    __IO uint32_t  CHxCTRL[15]; /*  DMA Multiplexer Channel x Control Register */
    __IO uint32_t  STS;         /*  DMA Channel Status Register */
    __IO uint32_t  CLR;         /*  DMA Channel Clear Flag Register */
    __IO uint32_t  CHxCFG[15];  /*  DMA Request Generator x Control Register */
    __IO uint32_t  RGSTS;       /*  DMA Request Generator x Interrupt Status Register */
    __IO uint32_t  RGCLR;       /*  DMA Request Generator x Interrupt Clear Register */
}DMAMUX2_Module;

typedef struct
{
  __IO uint32_t  CHCTRL;        /*!< DMA Multiplexer Channel x Control Register   */
}DMAMUX_Channel_TypeDef;

typedef struct
{
  __IO uint32_t  STS;      /*!< DMA Channel Status Register     */
  __IO uint32_t  CLR;      /*!< DMA Channel Clear Flag Register */
}DMAMUX_ChannelStatus_TypeDef;

typedef struct
{
  __IO uint32_t  CHCFG;        /*!< DMA Request Generator x Control Register   */
}DMAMUX_RequestGen_TypeDef;

typedef struct
{
  __IO uint32_t  RGSTS;        /*!< DMA Request Generator Status Register       */
  __IO uint32_t  RGCLR;       /*!< DMA Request Generator Clear Flag Register   */
}DMAMUX_RequestGenStatus_TypeDef;


/***  DCMU ***/
typedef struct
{
  __O  uint32_t TXMSG[4];   /*!< DCMU messaging transmit registers ,            Address offset: 00h-0Ch  */
  __I  uint32_t RCVMSG[4];  /*!< DCMU messaging receive registers ,             Address offset: 10h-1Ch  */
  __IO uint32_t STS;        /*!< DCMU messaging status register ,               Address offset: 20h      */
  __IO uint32_t CTRL;       /*!< DCMU messaging control register ,              Address offset: 24h      */

} DCMU_Module;

/***  SEMA4 ***/
typedef struct
{
    __IO uint32_t R[32];         /* 2-step write lock and read back registers,                Address offset: 00h-7Ch    */
    __IO uint32_t RL[32];        /* 1-step read lock registers,                               Address offset: 80h-FCh    */
    __IO uint32_t C1IEN;         /* SEMA4 Interrupt 0 enable register ,                       Address offset: 100h       */
    __IO uint32_t C1ICLR;        /* SEMA4 Interrupt 0 clear register ,                        Address offset: 104h       */
    __IO uint32_t C1ISTS;        /* SEMA4 Interrupt 0 Status register ,                       Address offset: 108h       */
    __IO uint32_t C1MISTS;       /* SEMA4 Interrupt 0 Masked Status register ,                Address offset: 10Ch       */
    __IO uint32_t C2IEN;         /* SEMA4 Interrupt 1 enable register ,                       Address offset: 110h       */
    __IO uint32_t C2ICLR;        /* SEMA4 Interrupt 1 clear register ,                        Address offset: 114h       */
    __IO uint32_t C2ISTS;        /* SEMA4 Interrupt 1 Status register ,                       Address offset: 118h       */
    __IO uint32_t C2MISTS;       /* SEMA4 Interrupt 1 Masked Status register ,                Address offset: 11Ch       */
    __IO uint32_t C1ILFSTS;      /* SEMA4 Interrupt 0 Interrupt Lock Fail Status register     Address offset: 0x120      */ 
    __IO uint32_t C2ILFSTS;      /* SEMA4 Interrupt 1 Interrupt Lock Fail Status register     Address offset: 0x124      */ 
    __IO uint32_t Res0[2];       /* Reserved                                                  Address offset: 128h-12Fh  */
    __IO uint32_t C1ILFEN;       /* SEMA4 Interrupt 0 Interrupt Lock Fail Enable register     Address offset: 0x130      */ 
    __IO uint32_t C2ILFEN;       /* SEMA4 Interrupt 1 Interrupt Lock Fail Enable register     Address offset: 0x134      */    
    __IO uint32_t Res1[2];       /* Reserved                                                  Address offset: 138h-13Fh  */
    __IO uint32_t CLR;           /* SEMA4 Semaphore clear register ,                          Address offset: 140h       */
    __IO uint32_t KEYCLR;        /* SEMA4 Semaphore clear key register ,                      Address offset: 144h       */
} SEMA4_Module;


    /**
      * @brief FLASH Registers
      */

    typedef struct
    {
        __IO uint32_t ACR;
        __IO uint32_t KEYR;
        __IO uint32_t OPTKEYR;
        __IO uint32_t SR;
        __IO uint32_t CR;
        __IO uint32_t AR;
        __IO uint32_t OBR2;
        __IO uint32_t OBR;
        __IO uint32_t WRPR;
        __IO uint32_t CR2;
        __IO uint32_t TIMR;
        __IO uint32_t RESERVED1;
        __IO uint32_t CAHR;
    } FLASH_TypeDef;

    /**
      * @brief Option Bytes Registers
      */

    typedef struct
    {
        __IO uint32_t USER_RDP;
        __IO uint32_t Data1_Data0;
        __IO uint32_t WRP1_WRP0;
        __IO uint32_t WRP3_WRP2;
        __IO uint32_t RDP2;
    } OB_TypeDef;

   


/**
 * @brief Digital to Analog Converter
 */

/**
 * @brief USB
 */

/** Flexible Extended Memory Controller SRAM/NOR Flash **/
typedef struct
{
    __IO uint32_t  FEMC_SNTSTS;
    __IO uint32_t  FEMC_SNOMSTS;
    uint32_t       RESERVED[6];
}FEMC_SN_Bank_Block;

/** Flexible Extended Memory Controller NAND **/
typedef struct
{
    __IO uint32_t  FEMC_NTSTS;
    __IO uint32_t  FEMC_NOMSTS;
    uint32_t       RESERVED[6];
}FEMC_NAND_Bank;


typedef struct 
{
    __IO uint32_t  FEMC_STS;        /* FEMC Status Register                     Address offset: 0x000 */
    __IO uint32_t  FEMC_STS1;       /* FEMC Status Register1                    Address offset: 0x004 */
    __IO uint32_t  FEMC_CFG;        /* FEMC Configuration Register              Address offset: 0x008 */
    __IO uint32_t  FEMC_CCFG;       /* FEMC Configuration clear Register        Address offset: 0x00C */
    __IO uint32_t  FEMC_CTRL;       /* FEMC Control Register1                   Address offset: 0x010 */
    __IO uint32_t  FEMC_TCFG;       /* FEMC Timing Configuration Register       Address offset: 0x014 */
    __IO uint32_t  FEMC_OMCFG;      /* FEMC Operate Mode Register               Address offset: 0x018 */
    uint32_t       RESERVED1C;
    __IO uint32_t  FEMC_RPE;        /* FEMC Refresh Period Register             Address offset: 0x020 */
    uint32_t       RESERVED24[55];  /* 0x24 ~ 0xFC */
    FEMC_SN_Bank_Block  block1;     /* 0x100 ~ 0x11C */
    FEMC_SN_Bank_Block  block2;     /* 0x120 ~ 0x13C */
    FEMC_SN_Bank_Block  block3;     /* 0x140 ~ 0x15C */
    FEMC_SN_Bank_Block  block4;     /* 0x160 ~ 0x17C */
    FEMC_NAND_Bank      bank1;      /* 0x180 ~ 0x18C */
    FEMC_NAND_Bank      bank2;      /* 0x1A0 ~ 0x1BC */
    uint32_t       RESERVED1B0[16]; /* 0x1C0 ~ 0x1FC */
    uint32_t       RESERVED125[128];/* 0x200 ~ 0x3FC */
    __IO uint32_t  FEMC_ECCSTS;     /* FEMC ECC Status Register                 Address offset: 0x400 */
    __IO uint32_t  FEMC_ECCCFG;     /* FEMC ECC Configure Register              Address offset: 0x404 */
    __IO uint32_t  FEMC_ECCMD0;     /* FEMC ECC Command0 Register               Address offset: 0x408 */
    __IO uint32_t  FEMC_ECCMD1;     /* FEMC ECC Command1 Register               Address offset: 0x40C */
    __IO uint32_t  FEMC_ECCADDR0;   /* FEMC ECC Address0 Register               Address offset: 0x410 */
    __IO uint32_t  FEMC_ECCADDR1;   /* FEMC ECC Address1 Register               Address offset: 0x414 */
    __IO uint32_t  FEMC_ECCBLK[4];   /* FEMC ECC Block0 Register                Address offset: 0x418 */
    __IO uint32_t  FEMC_ECCEBLK;    /* FEMC ECC Extra Block Register            Address offset: 0x428 */
    uint32_t       RESERVED42C[53]; /* 0x42C ~ 0x4FC */
    __IO uint32_t  FEMC_SNADD1;     /* FEMC SRAM/NOR Set Address1 Register      Address offset: 0x500 */
    __IO uint32_t  FEMC_SNADD2;     /* FEMC SRAM/NOR Set Address2 Register      Address offset: 0x504 */
    __IO uint32_t  FEMC_SNADD3;     /* FEMC SRAM/NOR Set Address3 Register      Address offset: 0x508 */
    __IO uint32_t  FEMC_SNADD4;     /* FEMC SRAM/NOR Set Address4 Register      Address offset: 0x50C */
    __IO uint32_t  FEMC_NADD1;      /* FEMC NAND Set Address1 Register          Address offset: 0x510 */
    __IO uint32_t  FEMC_NADD2;      /* FEMC NAND Set Address2 Register          Address offset: 0x514 */
    uint32_t       RESERVED518[2];  /* 0x518 ~ 0x51C */
    __IO uint32_t  FEMC_SNMOD;     /* FEMC SRAM/NOR Mode Register               Address offset: 0x520 */
    __IO uint32_t  FEMC_NMOD;      /* FEMC NAND Mode Register                   Address offset: 0x524 */
    __IO uint32_t  FEMC_REMAP;      /* FEMC Remap Register                      Address offset: 0x528 */
} FEMC_Module;


/*** USB High Speed Global Register ***/

typedef struct
{
    __IO uint32_t GCTRLSTS;                 /* USBHS global Control and Status Register     Address offset: 0x000 */
    uint32_t Reserved04;                    /* Reserved04                                   Address offset: 0x004 */
    __IO uint32_t GAHBCFG;                  /* Core AHB Configuration Register              Address offset: 0x008 */
    __IO uint32_t GCFG;                     /* Core USB Configuration Register              Address offset: 0x00C */
    __IO uint32_t GRSTCTRL;                 /* Core Reset Register                          Address offset: 0x010 */
    __IO uint32_t GINTSTS;                  /* Core Interrupt Register                      Address offset: 0x014 */
    __IO uint32_t GINTEN;                   /* Core Interrupt Mask Register                 Address offset: 0x018 */
    __IO uint32_t GRXSTS;                   /* Receive Sts Q Read Register                  Address offset: 0x01C */
    __IO uint32_t GRXSTSP;                  /* Receive Sts Q Read & POP Register            Address offset: 0x020 */
    __IO uint32_t GRXFSIZ;                  /* Receive FIFO Size Register                   Address offset: 0x024 */
    __IO uint32_t GNPTXFSIZ_DINEP0TXFSIZ;   /* Non Periodic/EP0 Tx FIFO Size/ Register      Address offset: 0x028 */
    __IO uint32_t GNPTXFSTS;                /* Non Periodic Tx FIFO/Queue Sts reg           Address offset: 0x02C */
    uint32_t Reserved30[3];                 /* Reserved                                     Address offset: 0x030 */
    __IO uint32_t CID;                      /* User ID Register                             Address offset: 0x03C */
    __IO uint32_t Reserved40[6];            /* Reserved40                                   Address offset: 0x040 */
    __IO uint32_t GPD;                      /* Power Down Register                          Address offset: 0x058 */
    __IO uint32_t GDFCFG;                   /* DFIFO Software Config Register               Address offset: 0x05C */
    uint32_t  Reserved58[40];               /* Reserved                                     Address offset: 0x60-0xFC */
    __IO uint32_t HPTXFSIZ;                 /* Host Periodic Tx FIFO Size Reg               Address offset: 0x100 */
    __IO uint32_t DINEPPTXFSIZ[16];         /* Device IN EP Periodic Transmit FIFO */
} USB_Global_Registers;

/*** USBHS Host Mode Register ***/
typedef struct 
{
    __IO uint32_t HCFG;                     /* Host Configuration Register                  Address offset: 0x400 */
    __IO uint32_t HFRI;                     /* Host Frame Interval Register                 Address offset: 0x404 */
    __IO uint32_t HFNUM;                    /* Host Frame number and Frame Remaining        Address offset: 0x408 */
    uint32_t Reserved0C;                    /* Reserved                                     Address offset: 0x40C */
    __IO uint32_t HPTXFQSTS;                /* Host Periodic Tx FIFO/Queue Status register  Address offset: 0x410 */
    __IO uint32_t HACHINT;                  /* Host All Channels Interrupt Register         Address offset: 0x414 */
    __IO uint32_t HACHINTEN;                /* Host All Channels Interrupt Enable           Address offset: 0x418 */
    uint32_t Reserved1C[0x0A];              /* Reserved                                     Address offset: 0x41C */
} USB_Host_Registers;

/*** USBHS Host Channel Register ***/

typedef struct
{
    __IO uint32_t HCHCTRL;                    /* Host Channel Control Register             Address offset: 0x500 */
    __IO uint32_t HCSCTRL;                    /* Host Channel Split Control Register       Address offset: 0x504 */
    __IO uint32_t HCHINTSTS;                  /* Host Channel Interrupt Register           Address offset: 0x508 */
    __IO uint32_t HCHINTEN;                   /* Host Channel Interrupt Enable Register    Address offset: 0x50C */
    __IO uint32_t HCHTXSIZ;                   /* Host Channel Transfer Size Register       Address offset: 0x510 */
    __IO uint32_t HCHDMADD;                   /* Host Channel DMA Address Register         Address offset: 0x514 */
    uint32_t Reserved[2];                     /* Reserved  */
} USB_HostCH_Registers;


/*** USBHS Device Register ***/

typedef struct 
{
    __IO uint32_t DCFG;                       /* dev Configuration Register                Address offset: 0x800 */
    __IO uint32_t DCTRL;                      /* dev Control Register                      Address offset: 0x804 */
    __IO uint32_t DSTS;                       /* dev Status Register                       Address offset: 0x808 */
    uint32_t Reserved0C;                      /* Reserved                                  Address offset: 0x80C */
    __IO uint32_t DINEPINTEN;                 /* dev IN Endpoint Interrupt Enable          Address offset: 0x810 */
    __IO uint32_t DOUTEPINTEN;                /* dev OUT Endpoint Interrupt Enable         Address offset: 0x814 */
    __IO uint32_t DAEPINTSTS;                 /* dev All Endpoints Interrupt Status        Address offset: 0x818 */
    __IO uint32_t DAEPINTEN;                  /* dev All Endpoints Interrupt Enable        Address offset: 0x81C */
    uint32_t  Reserved20[4];                  /* Reserved                                  Address offset: 0x820-0x82C*/
    __IO uint32_t DTHRCTRL;                   /* dev threshold Contrl register             Address offset: 0x830 */
    __IO uint32_t DINEPFEINTEN;               /* dev IN EP fifo empty interrupt enable     Address offset: 0x834 */
    __IO uint32_t DEEPINTSTS;                 /* Each EP interrupt Status register         Address offset: 0x838 */
    __IO uint32_t DEEPINTEN;                  /* Each EP interrupt enable                  Address offset: 0x83C */  
    __IO uint32_t DINEPXINTEN[9];             /* dedicated EP mask                         Address offset: 0x840-0x860 */
    uint32_t  Reserved64[7];                  /* Reserved                                  Address offset: 0x864-0x87C */
    __IO uint32_t DOUTEPXINTEN[9];            /* dedicated EP msk                          Address offset: 0x880-0x8A0 */   
} USB_Device_Registers;

/*** USBHS IN Endpoint Register ***/

typedef struct 
{
    __IO uint32_t DINEPCTRL;                    /* dev IN Endpoint Control Register       Address offset: 0x900 + (ep_num * 0x20) + 0x00 */
    uint32_t Reserved04;                        /* Reserved                               Address offset: 0x900 + (ep_num * 0x20) + 0x04 */
    __IO uint32_t DINEPINTSTS;                  /* dev IN Endpoint Interrupt Stauts       Address offset: 0x900 + (ep_num * 0x20) + 0x08 */
    uint32_t Reserved0C;                        /* Reserved                               Address offset: 0x900 + (ep_num * 0x20) + 0x0C */
    __IO uint32_t DINEPTXSIZ;                   /* dev IN Endpoint Txfer Size             Address offset: 0x900 + (ep_num * 0x20) + 0x10 */
    __IO uint32_t DINEPDMADD;                   /* dev IN Endpoint DMA Address            Address offset: 0x900 + (ep_num * 0x20) + 0x14 */
    __IO uint32_t DINEPTXFSTS;                  /* dev IN Endpoint Tx FIFO Status         Address offset: 0x900 + (ep_num * 0x20) + 0x18 */
    uint32_t Reserved1C;                        /* Reserved                               Address offset: 0x900 + (ep_num * 0x20) + 0x1C */
} USB_INEP_Registers;


/*** USBHS OUT Endpoint Register ***/

typedef struct 
{  
    __IO uint32_t DOUTEPCTRL;                   /* dev OUT Endpoint Control Register      Address offset: 0xB00 + (ep_num * 0x20) + 00 */
    uint32_t Reserved0;                         /* Reserved                               Address offset: 0xB00 + (ep_num * 0x20) + 04 */
    __IO uint32_t DOUTEPINTSTS;                 /* dev OUT Endpoint Interrupt Stauts      Address offset: 0xB00 + (ep_num * 0x20) + 08 */
    uint32_t Reserved1;                         /* Reserved                               Address offset: 0xB00 + (ep_num * 0x20) + 0C */
    __IO uint32_t DOUTEPTXSIZ;                  /* dev OUT Endpoint Txfer Size            Address offset: 0xB00 + (ep_num * 0x20) + 10 */
    __IO uint32_t DOUTEPDMADD;                  /* dev OUT Endpoint DMA Address           Address offset: 0xB00 + (ep_num * 0x20) + 14 */
    uint32_t Reserved18[2];                     /* Reserved */
} USB_OUTEP_Registers;

/*** USBHS PWR Control Register ***/

typedef struct 
{
    __IO uint32_t PWRCTRL;                     /* USBHS Power Control Register          Address offset: 0xE00 */
    __IO uint32_t PWRCTRL1;                    /* USBHS Power Control1 Register         Address offset: 0xE04 */
} USB_PWR_Registers;

/*** USBHS Wrapper Register ***/

typedef struct 
{
    __IO uint32_t WRPCTRL;                    /* USBHS Wrapper Control Register            Address offset: 0x000 */
    __IO uint32_t WRPCFG;                     /* USBHS Wrapper Configuration Register      Address offset: 0x004 */
} USB_Wrapper_Registers;


    typedef struct
    {
            
__IO uint32_t C1_PWR_CR;    //0x00
__IO uint32_t C1_PWR_CSR;   //0x04
__IO uint32_t C1_PWR_CR2;   //0x08
uint32_t RESERVE0[5];   
__IO uint32_t C2_PWR_CR;    //0x20
__IO uint32_t C2_PWR_CSR;   //0x24
__IO uint32_t C2_PWR_CR2;   //0x28
uint32_t RESERVE1[5];   
__IO uint32_t SYS_PWR_CR;   //0x40
__IO uint32_t SYS_PWR_CSR;  //0x44
__IO uint32_t SYS_PWR_CR2;  //0x48
__IO uint32_t SYS_PWR_CR3;  //0x4C
__IO uint32_t SYS_PWR_CR4;  //0x50
__IO uint32_t SYS_PWR_BOR_CR;   //0x54
__IO uint32_t IP_MEMPWR_CR; //0x58
__IO uint32_t IP_MEMPWR_CSR;    //0x5C
__IO uint32_t C1_MEM_LPCR1; //0x60
__IO uint32_t C1_MEM_LPSR1; //0x64
__IO uint32_t C1_TCM_PG0;   //0x68
__IO uint32_t C1_TCM_PG1;   //0x6C
__IO uint32_t C1_TCM_RET1N0;    //0x70
__IO uint32_t C1_TCM_RET1N1;    //0x74
__IO uint32_t C1_TCM_RET2N0;    //0x78
__IO uint32_t C1_TCM_RET2N1;    //0x7C
uint32_t RESERVE2[4];   
__IO uint32_t C2_MEM_LPCR;  //0x90
uint32_t RESERVE3[3];   
__IO uint32_t SYS_MEM_LPCR; //0xA0
uint32_t RESERVE4[3];   
__IO uint32_t SYS_PWR_SHRT_CR;  //0xB0
__IO uint32_t SYS_PWR_MDMA_CR;  //0xB4
__IO uint32_t SYS_PWR_ETHCAT_CR;    //0xB8
uint32_t RESERVE5[17];  
__IO uint32_t PWR_EMC_CR0;  //0x100
__IO uint32_t PWR_EMC_CR1;  //0x104
__IO uint32_t PWR_EMC_CR2;  //0x108
__IO uint32_t PWR_EMC_CR3;  //0x10C
__IO uint32_t PWR_EMC_CR4;  //0x110
__IO uint32_t PWR_EMC_CR5;  //0x114
__IO uint32_t PWR_EMC_CR6;  //0x118
__IO uint32_t PWR_EMC_CR7;  //0x11C
__IO uint32_t PWR_BKP_EMC_CR0;  //0x120
__IO uint32_t PWR_BKP_EMC_CR1;  //0x124
    } PWR_TypeDef;
    
    /** Reset and Clock Control **/
    typedef struct
    {
        __IO uint32_t PLL1CTRL1;    //0x00
        __IO uint32_t PLL1CTRL2;    //0x04
        uint32_t RESERVED1; //0x08
        uint32_t RESERVED2; //0x0C
        __IO uint32_t PLL2CTRL1;    //0x10
        __IO uint32_t PLL2CTRL2;    //0x14
        uint32_t RESERVED3; //0x18
        uint32_t RESERVED4; //0x1C
        __IO uint32_t PLL3CTRL1;    //0x20
        __IO uint32_t PLL3CTRL2;    //0x24
        uint32_t RESERVED5; //0x28
        uint32_t RESERVED6; //0x2C
        __IO uint32_t SRCCTRL1; //0x30
        __IO uint32_t PLL1DIV;  //0x34
        __IO uint32_t PLL2DIV;  //0x38
        __IO uint32_t PLL3DIV;  //0x3C
        __IO uint32_t SYSBUSDIV1;   //0x40
        __IO uint32_t SYSBUSDIV2;   //0x44
        __IO uint32_t BOOTMODE; //0x48
        __IO uint32_t AHB1DIV1; //0x4C
        __IO uint32_t AHB1SEL1; //0x50
        __IO uint32_t AHB1EN1;  //0x54
        __IO uint32_t AHB1EN2;  //0x58
        __IO uint32_t AHB1EN3;  //0x5C
        __IO uint32_t AHB1EN4;  //0x60
        __IO uint32_t AHB1RST1; //0x64
        __IO uint32_t AHB1RST2; //0x68
        __IO uint32_t AHB1RST3; //0x6C
        __IO uint32_t AHB1RST4; //0x70
        __IO uint32_t APB1DIV1; //0x74
        __IO uint32_t APB1SEL1; //0x78
        __IO uint32_t APB1SEL2; //0x7C
        __IO uint32_t APB1EN1;  //0x80
        __IO uint32_t APB1EN2;  //0x84
        __IO uint32_t APB1EN3;  //0x88
        __IO uint32_t APB1EN4;  //0x8C
        __IO uint32_t APB1EN5;  //0x90
        __IO uint32_t APB1RST1; //0x94
        __IO uint32_t APB1RST2; //0x98
        __IO uint32_t APB1RST3; //0x9C
        __IO uint32_t APB1RST4; //0xA0
        __IO uint32_t APB1RST5; //0xA4
        __IO uint32_t AHB2DIV1; //0xA8
        __IO uint32_t AHB2SEL1; //0xAC
        __IO uint32_t AHB2EN1;  //0xB0
        __IO uint32_t AHB2RST1; //0xB4
        __IO uint32_t APB2DIV1; //0xB8
        __IO uint32_t APB2SEL1; //0xBC
        __IO uint32_t APB2SEL2; //0xC0
        __IO uint32_t APB2EN1;  //0xC4
        __IO uint32_t APB2EN2;  //0xC8
        __IO uint32_t APB2EN3;  //0xCC
        __IO uint32_t APB2EN4;  //0xD0
        __IO uint32_t APB2RST1; //0xD4
        __IO uint32_t APB2RST2; //0xD8
        __IO uint32_t APB2RST3; //0xDC
        __IO uint32_t APB2RST4; //0xE0
        __IO uint32_t AHB5EN1;  //0xE4
        __IO uint32_t AHB5EN2;  //0xE8
        __IO uint32_t AHB5RST1; //0xEC
        __IO uint32_t AHB5RST2; //0xF0
        __IO uint32_t APB5DIV1; //0xF4
        __IO uint32_t APB5SEL1; //0xF8
        __IO uint32_t APB5EN1;  //0xFC
        __IO uint32_t APB5EN2;  //0x100
        __IO uint32_t APB5RST1; //0x104
        __IO uint32_t APB5RST2; //0x108
        __IO uint32_t RDDIV1;   //0x10C       
        __IO uint32_t RDSEL1;   //0x110
        __IO uint32_t RDEN1;    //0x114
        __IO uint32_t RDEN2;    //0x118
        __IO uint32_t RDRST1;   //0x11C
        __IO uint32_t RDRST2;   //0x120
        __IO uint32_t BDCTRL;   //0x124
        __IO uint32_t CTRLSTS;  //0x128
        __IO uint32_t CLKINT1;  //0x12C
        __IO uint32_t CLKINT2;  //0x130
        __IO uint32_t CFG1; //0x134
        __IO uint32_t AXIDIV1;  //0x138
        __IO uint32_t AXISEL1;  //0x13C
        __IO uint32_t AXIEN1;   //0x140
        __IO uint32_t AXIEN2;   //0x144
        __IO uint32_t AXIEN3;   //0x148
        __IO uint32_t AXIEN4;   //0x14C
        __IO uint32_t AXIRST1;  //0x150
        __IO uint32_t AXIRST2;  //0x154
        __IO uint32_t AXIRST3;  //0x158
        __IO uint32_t AXIRST4;  //0x15C
        __IO uint32_t CFG2; //0x160
        __IO uint32_t CFG3; //0x164
        __IO uint32_t CFG4; //0x168
        __IO uint32_t SRCCTRL2; //0x16C
        __IO uint32_t CFG5; //0x170
        __IO uint32_t M4RSTREL; //0x174
        __IO uint32_t AXIDIV2;  //0x178
        __IO uint32_t AXISEL2;  //0x17C
        uint32_t RESERVED7; //0x180
        uint32_t RESERVED8; //0x184
        uint32_t RESERVED9;       //0x188
        __IO uint32_t SHRPLLCTRL1;  //0x18C
        __IO uint32_t SHRPLLCTRL2;  //0x190
        __IO uint32_t AHB1DIV2; //0x194
        __IO uint32_t LSERDDL;  //0x198
        __IO uint32_t MSIRDDL;  //0x19C
        __IO uint32_t HSERDDL;  //0x1A0
        __IO uint32_t PLLSFTLK; //0x1A4
        __IO uint32_t RDCTRL1;  //0x1A8
        __IO uint32_t RDCTRL2;  //0x1AC
        __IO uint32_t RDCTRL3;  //0x1B0
        __IO uint32_t AHB2EN2;  //0x1B4
        __IO uint32_t AHB9DIV1; //0x1B8
        __IO uint32_t AHB9SEL1; //0x1BC
        __IO uint32_t AHB9EN1;  //0x1C0
        __IO uint32_t AHB9RST1; //0x1C4
        __IO uint32_t HSEOS;    //0x1C8
        __IO uint32_t LSEOS;    //0x1CC
        __IO uint32_t HSECAL;   //0x1D0
        __IO uint32_t CLKINT3;  //0x1D4
        __IO uint32_t PLLFD;    //0x1D8
        __IO uint32_t SRCCTRL3; //0x1DC
        __IO uint32_t LSICSSDL; //0x1E0
    } RCC_Module;





/*** @brief Debug MCU ***/

typedef struct
{
    __IO uint32_t ID;        //0x00
    __IO uint32_t CTRL;      //0x04
    __IO uint32_t M7APB1FZ;  //0x08
    __IO uint32_t M4APB1FZ;  //0x0C
    __IO uint32_t M7APB2FZ;  //0x10
    __IO uint32_t M4APB2FZ;  //0x14
    __IO uint32_t M7APB5FZ;  //0x18
    __IO uint32_t M4APB5FZ;  //0x1C
    __IO uint32_t M7APB6FZ;  //0x20
    __IO uint32_t M4APB6FZ;  //0x24
}DBG_Module;

/*** Ethernet MAC ***/
typedef struct
{
    __IO uint32_t MACCFG;         /* Offset: 0x0000 */
    __IO uint32_t MACEXTCFG;      /* Offset: 0x0004 */
    __IO uint32_t MACPFLT;        /* Offset: 0x0008 */
    __IO uint32_t MACWDGTO;       /* Offset: 0x000C */
    __IO uint32_t MACHASHTR0;     /* Offset: 0x0010 */
    __IO uint32_t MACHASHTR1;     /* Offset: 0x0014 */
    uint32_t      RESERVED0[14];
    __IO uint32_t MACVLANTAG;     /* Offset: 0x0050 */
    uint32_t      RESERVED1;
    __IO uint32_t MACVHASHT;      /* Offset: 0x0058 */
    uint32_t      RESERVED2;
    __IO uint32_t MACVLANINC;     /* Offset: 0x0060 */
    __IO uint32_t MACIVLANINC;    /* Offset: 0x0064 */
    uint32_t      RESERVED3[2];
    __IO uint32_t MACTXFLWCTRL;   /* Offset: 0x0070 */
    uint32_t      RESERVED4[7];
    __IO uint32_t MACRXFLWCTRL;   /* Offset: 0x0090 */
    uint32_t      RESERVED5[7];
    __IO uint32_t MACINTSTS;      /* Offset: 0x00B0 */
    __IO uint32_t MACINTEN;       /* Offset: 0x00B4 */
    __IO uint32_t MACRXTXSTS;     /* Offset: 0x00B8 */
    uint32_t      RESERVED6;
    __IO uint32_t MACPMTCTRLSTS;  /* Offset: 0x00C0 */
    __IO uint32_t MACRWUPFLT;     /* Offset: 0x00C4 */
    uint32_t      RESERVED7[2];
    __IO uint32_t MACLPICTRLSTS;  /* Offset: 0x00D0 */
    __IO uint32_t MACLPITIMCTRL;  /* Offset: 0x00D4 */
    __IO uint32_t MACLPIETYTIM;   /* Offset: 0x00D8 */
    __IO uint32_t MAC1USTICCNT;   /* Offset: 0x00DC */
    uint32_t      RESERVED8[12];
    __IO uint32_t MACVER;         /* Offset: 0x0110 */
    __IO uint32_t MACDBG;         /* Offset: 0x0114 */
    uint32_t      RESERVED9;
    __IO uint32_t MACHWF0;        /* Offset: 0x011C */
    __IO uint32_t MACHWF1;        /* Offset: 0x0120 */
    __IO uint32_t MACHWF2;        /* Offset: 0x0124 */
    __IO uint32_t MACHWF3;        /* Offset: 0x0128 */
    uint32_t      RESERVED10[53];
    __IO uint32_t MACMDIOADDR;    /* Offset: 0x0200 */
    __IO uint32_t MACMDIODATA;    /* Offset: 0x0204 */
    uint32_t      RESERVED11[2];
    __IO uint32_t MACARPADDR;     /* Offset: 0x0210 */
    uint32_t      RESERVED12[7];
    __IO uint32_t MACCSRSWCTRL;   /* Offset: 0x0230 */
    uint32_t      RESERVED13[3];
    __IO uint32_t MACPTNS;        /* Offset: 0x0240 */
    __IO uint32_t MACPTUPDT;      /* Offset: 0x0244 */
    uint32_t      RESERVED14[46];
    __IO uint32_t MACADDR0H;      /* Offset: 0x0300 */
    __IO uint32_t MACADDR0L;      /* Offset: 0x0304 */
    __IO uint32_t MACADDR1H;      /* Offset: 0x0308 */
    __IO uint32_t MACADDR1L;      /* Offset: 0x030C */
    __IO uint32_t MACADDR2H;      /* Offset: 0x0310 */
    __IO uint32_t MACADDR2L;      /* Offset: 0x0314 */
    __IO uint32_t MACADDR3H;      /* Offset: 0x0318 */
    __IO uint32_t MACADDR3L;      /* Offset: 0x031C */
    uint32_t      RESERVED15[248];
    __IO uint32_t MMCCTRL;        /* Offset: 0x0700 */
    __IO uint32_t MMCRXINT;       /* Offset: 0x0704 */
    __IO uint32_t MMCTXINT;       /* Offset: 0x0708 */
    __IO uint32_t MMCRXINTMSK;    /* Offset: 0x070C */
    __IO uint32_t MMCTXINTMSK;    /* Offset: 0x0710 */
    uint32_t      RESERVED16[14];
    __IO uint32_t MMCTXSCGP;      /* Offset: 0x074C */
    __IO uint32_t MMCTXMCGP;      /* Offset: 0x0750 */
    uint32_t      RESERVED17[5];
    __IO uint32_t MMCTXPCG;       /* Offset: 0x0768 */
    uint32_t      RESERVED18[8];
    __IO uint32_t MMCRXBPG;       /* Offset: 0x078C */
    __IO uint32_t MMCRXMPG;       /* Offset: 0x0790 */
    __IO uint32_t MMCRXCRCEP;     /* Offset: 0x0794 */
    __IO uint32_t MMCRXAEP;       /* Offset: 0x0798 */
    uint32_t      RESERVED19[10];
    __IO uint32_t MMCRXUPG;       /* Offset: 0x07C4 */
    uint32_t      RESERVED20[9];
    __IO uint32_t MMCTXLPIUS;     /* Offset: 0x07EC */
    __IO uint32_t MMCTXLPITRAN;   /* Offset: 0x07F0 */
    __IO uint32_t MMCRXLPIUS;     /* Offset: 0x07F4 */
    __IO uint32_t MMCRXLPITRAN;   /* Offset: 0x07F8 */
    uint32_t      RESERVED21;
    __IO uint32_t MMCIPCRXINTMSK; /* Offset: 0x0800 */
    uint32_t      RESERVED22;
    __IO uint32_t MMCIPCRXINT;    /* Offset: 0x0808 */
    uint32_t      RESERVED23;
    __IO uint32_t MMCRXIPV4GP;    /* Offset: 0x0810 */
    uint32_t      RESERVED24[4];
    __IO uint32_t MMCRXIPV6GP;    /* Offset: 0x0824 */
    uint32_t      RESERVED25[2];
    __IO uint32_t MMCRXUDPGP;     /* Offset: 0x0830 */
    __IO uint32_t MMCRXUDPEP;     /* Offset: 0x0834 */
    __IO uint32_t MMCRXTCPGP;     /* Offset: 0x0838 */
    __IO uint32_t MMCRXTCPEP;     /* Offset: 0x083C */
    __IO uint32_t MMCRXICMPGP;    /* Offset: 0x0840 */
    __IO uint32_t MMCRXICMPEP;    /* Offset: 0x0844 */
    uint32_t      RESERVED26[46];
    __IO uint32_t MACL3L4F0CTRL;  /* Offset: 0x0900 */
    __IO uint32_t MACL4F0PORT;    /* Offset: 0x0904 */
    uint32_t      RESERVED27[2];
    __IO uint32_t MACL3F0ADDR0;   /* Offset: 0x0910 */
    __IO uint32_t MACL3F0ADDR1;   /* Offset: 0x0914 */
    __IO uint32_t MACL3F0ADDR2;   /* Offset: 0x0918 */
    __IO uint32_t MACL3F0ADDR3;   /* Offset: 0x091C */
    uint32_t      RESERVED28[4];
    __IO uint32_t MACL3L4F1CTRL;  /* Offset: 0x0930 */
    __IO uint32_t MACL4F1PORT;    /* Offset: 0x0934 */
    uint32_t      RESERVED29[2];
    __IO uint32_t MACL3F1ADDR0;   /* Offset: 0x0940 */
    __IO uint32_t MACL3F1ADDR1;   /* Offset: 0x0944 */
    __IO uint32_t MACL3F1ADDR2;   /* Offset: 0x0948 */
    __IO uint32_t MACL3F1ADDR3;   /* Offset: 0x094C */
    uint32_t      RESERVED30[108];
    __IO uint32_t MACTSCTRL;      /* Offset: 0x0B00 */
    __IO uint32_t MACSUBSINC;     /* Offset: 0x0B04 */
    __IO uint32_t MACSYSTS;       /* Offset: 0x0B08 */
    __IO uint32_t MACSYSTNS;      /* Offset: 0x0B0C */
    __IO uint32_t MACSYSTSUP;     /* Offset: 0x0B10 */
    __IO uint32_t MACSYSTNSUP;    /* Offset: 0x0B14 */
    __IO uint32_t MACTSADD;       /* Offset: 0x0B18 */
    __IO uint32_t MACSYSTHWS;     /* Offset: 0x0B1C */
    __IO uint32_t MACTSSTS;       /* Offset: 0x0B20 */
    uint32_t      RESERVED31[3];
    __IO uint32_t MACTXTSSTSNS;   /* Offset: 0x0B30 */
    __IO uint32_t MACTXTSSTSS;    /* Offset: 0x0B34 */
    uint32_t      RESERVED32[2];
    __IO uint32_t MACAUXCTRL;     /* Offset: 0x0B40 */
    uint32_t      RESERVED33;
    __IO uint32_t MACAUXTSNS;     /* Offset: 0x0B48 */
    __IO uint32_t MACAUXTSS;      /* Offset: 0x0B4C */
    __IO uint32_t MACTSIGASYC;    /* Offset: 0x0B50 */
    __IO uint32_t MACTSEGASYC;    /* Offset: 0x0B54 */
    __IO uint32_t MACTSIGCNS;     /* Offset: 0x0B58 */
    __IO uint32_t MACTSEGCNS;     /* Offset: 0x0B5C */
    uint32_t      RESERVED34[2];
    __IO uint32_t MACTSIGLAT;     /* Offset: 0x0B68 */
    __IO uint32_t MACTSEGLAT;     /* Offset: 0x0B6C */
    __IO uint32_t MACPPSCTRL;     /* Offset: 0x0B70 */
    uint32_t      RESERVED35[3];
    __IO uint32_t MACPPSTTS;      /* Offset: 0x0B80 */
    __IO uint32_t MACPPSTTNS;     /* Offset: 0x0B84 */
    __IO uint32_t MACPPSINTE;     /* Offset: 0x0B88 */
    __IO uint32_t MACPPSWID;      /* Offset: 0x0B8C */
    uint32_t      RESERVED36[12];
    __IO uint32_t MACPTOCTRL;     /* Offset: 0x0BC0 */
    __IO uint32_t MACSRCPID0;     /* Offset: 0x0BC4 */
    __IO uint32_t MACSRCPID1;     /* Offset: 0x0BC8 */
    __IO uint32_t MACSRCPID2;     /* Offset: 0x0BCC */
    __IO uint32_t MACLOGMINTE;    /* Offset: 0x0BD0 */
    uint32_t      RESERVED37[11];

    __IO uint32_t MTLOPMOD;       /* Offset: 0x0C00 */
    uint32_t      RESERVED38[7];
    __IO uint32_t MTLINTSTS;      /* Offset: 0x0C20 */
    uint32_t      RESERVED39[55];
    __IO uint32_t MTLTXQOPMOD;    /* Offset: 0x0D00 */
    __IO uint32_t MTLTXQUDF;      /* Offset: 0x0D04 */
    __IO uint32_t MTLTXQDBG;      /* Offset: 0x0D08 */
    uint32_t      RESERVED40[8];
    __IO uint32_t MTLQINTCTRLSTS; /* Offset: 0x0D2C */
    __IO uint32_t MTLRXQOPMOD;    /* Offset: 0x0D30 */
    __IO uint32_t MTLRXQMPOFCNT;  /* Offset: 0x0D34 */
    __IO uint32_t MTLRXQDBG;      /* Offset: 0x0D38 */
    uint32_t      RESERVED41[177];

    __IO uint32_t DMAMODE;        /* Offset: 0x1000 */
    __IO uint32_t DMASBMODE;      /* Offset: 0x1004 */
    __IO uint32_t DMAINTSTS;      /* Offset: 0x1008 */
    __IO uint32_t DMADBGSTS;      /* Offset: 0x100C */
    uint32_t      RESERVED42[60];
    __IO uint32_t DMACH0CTRL;     /* Offset: 0x1100 */
    __IO uint32_t DMACH0TXCTRL;   /* Offset: 0x1104 */
    __IO uint32_t DMACH0RXCTRL;   /* Offset: 0x1108 */
    uint32_t      RESERVED43[2];
    __IO uint32_t DMACH0TXDLA;    /* Offset: 0x1114 */
    uint32_t      RESERVED44;
    __IO uint32_t DMACH0RXDLA;    /* Offset: 0x111C */
    __IO uint32_t DMACH0TXDTP;    /* Offset: 0x1120 */
    uint32_t      RESERVED45;
    __IO uint32_t DMACH0RXDTP;    /* Offset: 0x1128 */
    __IO uint32_t DMACH0TXDRLEN;  /* Offset: 0x112C */
    __IO uint32_t DMACH0RXCTRL2;  /* Offset: 0x1130 */
    __IO uint32_t DMACH0INTEN;    /* Offset: 0x1134 */
    __IO uint32_t DMACH0RXINTWT;  /* Offset: 0x1138 */
    uint32_t      RESERVED46[2];
    __IO uint32_t DMACH0CATXD;    /* Offset: 0x1144 */
    uint32_t      RESERVED47;
    __IO uint32_t DMACH0CARXD;    /* Offset: 0x114C */
    uint32_t      RESERVED48;
    __IO uint32_t DMACH0CATXB;    /* Offset: 0x1154 */
    uint32_t      RESERVED49;
    __IO uint32_t DMACH0CARXB;    /* Offset: 0x115C */
    __IO uint32_t DMACH0STS;      /* Offset: 0x1160 */
    __IO uint32_t DMACH0DPCNT;    /* Offset: 0x1164 */
    uint32_t      RESERVED50;
    __IO uint32_t DMACH0RXERICNT; /* Offset: 0x116C */
} ETH_Module;

/***  EXTI(External Interrupt/Event Controller) Regiters ***/
typedef struct
{
    __IO uint32_t RT_CFG[2];       //0x00
    __IO uint32_t RESERVED0[6];
    __IO uint32_t FT_CFG[2];       //0x20
    __IO uint32_t RESERVED1[6];
    __IO uint32_t SWIE[2];         //0x40
    __IO uint32_t RESERVED2[6];
    __IO uint32_t M7IMASK[2];      //0x60
    __IO uint32_t RESERVED3[6];
    __IO uint32_t M4IMASK[2];      //0x80
    __IO uint32_t RESERVED4[6];
    __IO uint32_t M7EMASK[2];      //0xA0
    __IO uint32_t RESERVED5[6];
    __IO uint32_t M4EMASK[2];      //0xC0
    __IO uint32_t RESERVED6[6];
    __IO uint32_t M7PEND[2];       //0xE0
    __IO uint32_t RESERVED7[6];
    __IO uint32_t M4PEND[2];       //0x100
    __IO uint32_t RESERVED8[6];
    __IO uint32_t M7IMASK_DRC[2];  //0x120
    __IO uint32_t RESERVED9[6];
    __IO uint32_t M4IMASK_DRC[2];  //0x140
    __IO uint32_t RESERVED10[6];
    __IO uint32_t M7EMASK_DRC[2];  //0x160
    __IO uint32_t RESERVED11[6];
    __IO uint32_t M4EMASK_DRC[2];  //0x180
    __IO uint32_t RESERVED12[14];
    __IO uint32_t TSSEL;           //0x1C0
}EXTI_Module;

/*** FDCAN(Flexible Datarate Controller Area Network) Registers ***/
typedef struct
{
    __IO uint32_t CREL;         //0x000
    __IO uint32_t ENDN;         //0x004
    __IO uint32_t RESERVED1;    //0x008
    __IO uint32_t DBTP;         //0x00C
    __IO uint32_t TEST;         //0x010
    __IO uint32_t RWD;          //0x014
    __IO uint32_t CCCR;         //0x018
    __IO uint32_t NBTP;         //0x01C
    __IO uint32_t TSCC;         //0x020
    __IO uint32_t TSCV;         //0x024
    __IO uint32_t TOCC;         //0x028
    __IO uint32_t TOCV;         //0x02C
    __IO uint32_t RESERVED2[4]; //0x030
    __IO uint32_t ECR;          //0x040
    __IO uint32_t PSR;          //0x044
    __IO uint32_t TDCR;         //0x048
    __IO uint32_t RESERVED3;    //0x04C
    __IO uint32_t IR;           //0x050
    __IO uint32_t IE;           //0x054
    __IO uint32_t ILS;          //0x058
    __IO uint32_t ILE;          //0x05C
    __IO uint32_t RESERVED4[8]; //0x060
    __IO uint32_t GFC;          //0x080
    __IO uint32_t SIDFC;        //0x084
    __IO uint32_t XIDFC;        //0x088
    __IO uint32_t RESERVED5;    //0x08C
    __IO uint32_t XIDAM;        //0x090
    __IO uint32_t HPMS;         //0x094
    __IO uint32_t NDAT1;        //0x098
    __IO uint32_t NDAT2;        //0x09C
    __IO uint32_t RXF0C;        //0x0A0
    __IO uint32_t RXF0S;        //0x0A4
    __IO uint32_t RXF0A;        //0x0A8
    __IO uint32_t RXBC;         //0x0AC
    __IO uint32_t RXF1C;        //0x0B0
    __IO uint32_t RXF1S;        //0x0B4
    __IO uint32_t RXF1A;        //0x0B8
    __IO uint32_t RXESC;        //0x0BC
    __IO uint32_t TXBC;         //0x0C0
    __IO uint32_t TXFQS;        //0x0C4
    __IO uint32_t TXESC;        //0x0C8
    __IO uint32_t TXBRP;        //0x0CC
    __IO uint32_t TXBAR;        //0x0D0
    __IO uint32_t TXBCR;        //0x0D4
    __IO uint32_t TXBTO;        //0x0D8
    __IO uint32_t TXBCF;        //0x0DC
    __IO uint32_t TXBTIE;       //0x0E0
    __IO uint32_t TXBCIE;       //0x0E4
    __IO uint32_t RESERVED6[2]; //0x0E8
    __IO uint32_t TXEFC;        //0x0F0
    __IO uint32_t TXEFS;        //0x0F4
    __IO uint32_t TXEFA;        //0x0F8
    __IO uint32_t RESERVED7[1]; //0x0FC
    __IO uint32_t TTTMC;        //0x100
    __IO uint32_t TTRMC;        //0x104
    __IO uint32_t TTOCF;        //0x108
    __IO uint32_t TTMLM;        //0x10c
    __IO uint32_t TURCF;        //0x110
    __IO uint32_t TTOCN;        //0x114
    __IO uint32_t TTGTP;        //0x118
    __IO uint32_t TTTMK;        //0x11c
    __IO uint32_t TTIR;         //0x120
    __IO uint32_t TTIE;         //0x124
    __IO uint32_t TTILS;        //0x128
    __IO uint32_t TTOST;        //0x12c
    __IO uint32_t TURNA;        //0x130
    __IO uint32_t TTLGT;        //0x134
    __IO uint32_t TTCTC;        //0x138
    __IO uint32_t TTCPT;        //0x13C
    __IO uint32_t TTCSM;        //0x140
    __IO uint32_t TTSS;         //0x144
} FDCAN_Module;

/*** FLASH Registers ***/
typedef struct
{
    __IO uint32_t AC;           //0x00
    __IO uint32_t CTRL;         //0x04
    __IO uint32_t STS;          //0x08
    __IO uint32_t ADD;          //0x0C
    __IO uint32_t KEY;          //0x10
    __IO uint32_t OPTKEY;       //0x14
    __IO uint32_t OB;           //0x18
    __IO uint32_t WRP;          //0x1C
    __IO uint32_t ECC;          //0x20
    __IO uint32_t RESERVED0[2];
    __IO uint32_t RDN;          //0x2C
    __IO uint32_t CAHR;         //0x30
    __IO uint32_t ROWP;         //0x34
    __IO uint32_t CCM_WRP1;     //0x38
    __IO uint32_t CCM_KEY;      //0x3C
    __IO uint32_t CCM_ERASE;    //0x40
    __IO uint32_t CCM_WRP2;     //0x44
    __IO uint32_t CCM_MODE;     //0x48
    __IO uint32_t XSPI_DSTRADD; //0x4C
    __IO uint32_t XSPI_DENDADD; //0x50
    __IO uint32_t FEMC_DSTRADD; //0x54
    __IO uint32_t FEMC_DENDADD; //0x58
    __IO uint32_t RTPD_KEY;     //0x5C
    __IO uint32_t JTAG_SEAL;    //0x60
    __IO uint32_t RTPD_KEY_WCNT;//0x64
    __IO uint32_t RESERVED1;
    __IO uint32_t XSPI_FEMC_DEN;//0x6C
    __IO uint32_t XUID;         //0x70
} FLASH_Module;

/*** Option Bytes Registers ***/

typedef struct
{
    __IO uint32_t USER_RDP;     //0x00 
    __IO uint32_t Data1_Data0;  //0x04
    __IO uint32_t WRP1_WRP0;    //0x08
    __IO uint32_t WRP3_WRP2;    //0x0C
    __IO uint32_t USER2_RDP2;   //0x10
    __IO uint32_t USER3;        //0x14
    __IO uint32_t CCMSRAM_RST;  //0x18
    __IO uint32_t RESERVED;
} OB_Module;

/*** GPIO(General Purpose I/O) Registers ***/
typedef struct
{
    __IO uint32_t PMODE;           //0x00
    __IO uint32_t POTYPE;          //0x04
    __IO uint32_t SR;              //0x08
    __IO uint32_t PUPD;            //0x0C
    __IO uint32_t PID;             //0x10
    __IO uint32_t POD;             //0x14
    __IO uint32_t PBSC;            //0x18
    __IO uint32_t PLOCK;           //0x1C
    __IO uint32_t AFL;             //0x20
    __IO uint32_t AFH;             //0x24
    __IO uint32_t PBC;             //0x28
    __IO uint32_t DS;              //0x2C
} GPIO_Module;

/*** AFIO(Alternate Function I/O) Registers ***/
typedef struct
{
    __IO uint32_t RMP_CFG;           //0x00
    __IO uint32_t FILTER_CFG;        //0x04
    __IO uint32_t XSPI1_NONCE0;      //0x08
    __IO uint32_t XSPI1_NONCE1;      //0x0C
    __IO uint32_t XSPI1_NONCE2;      //0x10
    __IO uint32_t ADCRMP_CFG;        //0x14
    __IO uint32_t EXTI_CFG[4];       //0x18
    __IO uint32_t TOL5V_CFG1;        //0x28
    __IO uint32_t TOL5V_CFG2;        //0x2C
    __IO uint32_t TOL5V_CFG3;        //0x30
    __IO uint32_t SHRT1_FALT_CFG;    //0x34
    __IO uint32_t SHRT2_FALT_CFG;    //0x38
    __IO uint32_t TOL5V_CFG4;        //0x3C
    __IO uint32_t RESERVED40;        //0x40
    __IO uint32_t TOL5V_CFG5;        //0x44
    __IO uint32_t TOL5V_CFG6;        //0x48
    __IO uint32_t TOL5V_CFG7;        //0x4C
    __IO uint32_t RESERVED50;        //0x50
    __IO uint32_t EFT_CFG[6];        //0x54
    __IO uint32_t DIGEFT_CFG[6];     //0x6C
    __IO uint32_t SHRT1_EXEV_CFG[2]; //0x84
    __IO uint32_t SHRT2_EXEV_CFG[2]; //0x8C
    __IO uint32_t SIP_PUPD;          //0x94
    __IO uint32_t HSMODE_CFG[5];     //0x98
    __IO uint32_t RESERVEDAC;        //0xAC
    __IO uint32_t SIPSR;             //0xB0
    __IO uint32_t SIPDS;             //0xB4
    __IO uint32_t RESERVEDB8[6];     //0xB8~0xCC
    __IO uint32_t ADCSW_CFG;         //0xD0
    __IO uint32_t RESERVEDD4;        //0xD4
    __IO uint32_t SDRAM_VREF_EN[3];  //0xD8
    __IO uint32_t SDRAMDSN_CFG[3];   //0xE4
    __IO uint32_t SDRAMDSP_CFG[3];   //0xF0
}AFIO_Module;

/*** Low-Power Timer ***/
typedef struct
{
    __IO uint32_t INTSTS; /* Offset: 0x0000 */
    __IO uint32_t INTCLR; /* Offset: 0x0004 */
    __IO uint32_t INTEN;  /* Offset: 0x0008 */
    __IO uint32_t CFG;    /* Offset: 0x000C */
    __IO uint32_t CTRL;   /* Offset: 0x0010 */
    __IO uint32_t CMP;    /* Offset: 0x0014 */
    __IO uint32_t ARR;    /* Offset: 0x0018 */
    __IO uint32_t CNT;    /* Offset: 0x001C */
    __IO uint32_t OPT;    /* Offset: 0x0020 */
} LPTIM_Module;

/*** Inter Integrated Circuit Interface ***/

typedef struct
{
		__IO uint32_t CTRL1;     				//0x00 
		__IO uint32_t CTRL2;       			//0x04 
		__IO uint32_t ADR1;     				//0x08 
		__IO uint32_t ADR2;    					//0x0C 
		__IO uint32_t BUSTIM;  					//0x10 
		__IO uint32_t TMOUTR;  					//0x14 
		__IO uint32_t STSINT;      			//0x18 
		__IO uint32_t INTCLR;      			//0x1C 
		__IO uint32_t CRCR;      				//0x20 
		__IO uint32_t RDR;      				//0x24 
		__IO uint32_t WDR;      				//0x28 
		__IO uint32_t HSBUSTM;  				//0x2C 
		__IO uint32_t FIFOCSR;  				//0x30 
		__IO uint32_t QCMD; 	  				//0x34 
		__IO uint32_t GFLTRCTRL; 				//0x38 
} I2C_Module;


/**
 * @brief Independent WATCHDOG
 */

typedef struct
{
    __IO uint32_t KEY;
    __IO uint32_t STS;
    __IO uint32_t PREDIV; /* IWDG PREDIV */
    __IO uint32_t RELV;
} IWDG_Module;

/** Power Control **/
typedef struct
{
    __IO uint32_t M7CTRL1;         //0x00
    __IO uint32_t M7CTRLSTS;       //0x04
    __IO uint32_t M7CTRL2;         //0x08
    __IO uint32_t RES1[5];         //0x0C
    __IO uint32_t M4CTRL1;         //0x20
    __IO uint32_t M4CTRLSTS;       //0x24
    __IO uint32_t M4CTRL2;         //0x28
    __IO uint32_t RES2[5];         //0x2C
    __IO uint32_t SYSCTRL1;        //0x40
    __IO uint32_t SYSCTRLSTS;      //0x44
    __IO uint32_t SYSCTRL2;        //0x48
    __IO uint32_t SYSCTRL3;        //0x4C
    __IO uint32_t SYSCTRL4;        //0x50
    __IO uint32_t BORCTRL;         //0x54
    __IO uint32_t IPMEMCTRL;       //0x58
    __IO uint32_t IPMEMCTRLSTS;    //0x5C
    __IO uint32_t M7MEMLPCTRL;     //0x60
    __IO uint32_t M7MEMLPSTS;      //0x64
    __IO uint32_t M7TCMPG0;        //0x68
    __IO uint32_t M7TCMPG1;        //0x6C
    __IO uint32_t M7TCMRET1N0;     //0x70
    __IO uint32_t M7TCMRET1N1;     //0x74
    __IO uint32_t M7TCMRET2N0;     //0x78
    __IO uint32_t M7TCMRET2N1;     //0x7C
    __IO uint32_t M7TCMPRDY0;      //0x80
    __IO uint32_t M7TCMPRDY1;      //0x84
    __IO uint32_t RES3[2];         //0x88
    __IO uint32_t M4MEMLPCTRL;     //0x90
    __IO uint32_t RES4[3];         //0x94
    __IO uint32_t SYSMEMLPCTRL;    //0xA0
    __IO uint32_t RES5[3];         //0xA4
    __IO uint32_t SHRTIMCTRL;      //0xB0
    __IO uint32_t MDMACTRL;        //0xB4
    __IO uint32_t ESCCTRL;         //0xB8
    __IO uint32_t RES6[17];        //0xBC
    __IO uint32_t EMCRETCTRL1;     //0x100
    __IO uint32_t EMCCTRLSTS1;     //0x104
    __IO uint32_t EMCRETCTRL2;     //0x108
    __IO uint32_t EMCRETSTS2;      //0x10C
    __IO uint32_t EMCRETCTRL3;     //0x110
    __IO uint32_t EMCRETSTS3;      //0x114
    __IO uint32_t EMCRETCTRL4;     //0x118
    __IO uint32_t EMCRETSTS4;      //0x11C
    __IO uint32_t EMCBKPCTRL;      //0x120
    __IO uint32_t EMCBKPSTS;       //0x124
}PWR_Module;

/** Real-Time Clock **/
typedef struct
{
    __IO uint32_t TSH;         /* RTC time register,                                         Address offset: 0x00 */
    __IO uint32_t DATE;        /* RTC date register,                                         Address offset: 0x04 */
    __IO uint32_t CTRL;        /* RTC control register,                                      Address offset: 0x08 */
    __IO uint32_t INITSTS;     /* RTC initialization and status register,                    Address offset: 0x0C */
    __IO uint32_t PRE;         /* RTC prescaler register,                                    Address offset: 0x10 */
    __IO uint32_t WKUPT;       /* RTC wakeup timer register,                                 Address offset: 0x14 */
    uint32_t reserved18;       /* Reserved  */
    __IO uint32_t ALARMA;      /* RTC alarm A register,                                      Address offset: 0x1C */
    __IO uint32_t ALARMB;      /* RTC alarm B register,                                      Address offset: 0x20 */
    __IO uint32_t WRP;         /* RTC write protection register,                             Address offset: 0x24 */
    __IO uint32_t SUBS;        /* RTC sub second register,                                   Address offset: 0x28 */
    __IO uint32_t SCTRL;       /* RTC shift control register,                                Address offset: 0x2C */
    __IO uint32_t TST;         /* RTC time stamp time register,                              Address offset: 0x30 */
    __IO uint32_t TSD;         /* RTC time stamp date register,                              Address offset: 0x34 */
    __IO uint32_t TSSS;        /* RTC time-stamp sub second register,                        Address offset: 0x38 */
    __IO uint32_t CALIB;       /* RTC calibration register,                                  Address offset: 0x3C */
    uint32_t reserved40;       /* Reserved  */
    __IO uint32_t ALRMASS;     /* RTC alarm A sub second register,                           Address offset: 0x44 */
    __IO uint32_t ALRMBSS;     /* RTC alarm B sub second register,                           Address offset: 0x48 */
    __IO uint32_t OPT;         /* RTC option register,                                       Address offset: 0x4C */
    __IO uint32_t BKP1;        /* RTC backup register 1,                                     Address offset: 0x50 */
    __IO uint32_t BKP2;        /* RTC backup register 2,                                     Address offset: 0x54 */
    __IO uint32_t BKP3;        /* RTC backup register 3,                                     Address offset: 0x58 */
    __IO uint32_t BKP4;        /* RTC backup register 4,                                     Address offset: 0x5C */
    __IO uint32_t BKP5;        /* RTC backup register 5,                                     Address offset: 0x60 */
    __IO uint32_t BKP6;        /* RTC backup register 6,                                     Address offset: 0x64 */
    __IO uint32_t BKP7;        /* RTC backup register 7,                                     Address offset: 0x68 */
    __IO uint32_t BKP8;        /* RTC backup register 8,                                     Address offset: 0x6C */
    __IO uint32_t BKP9;        /* RTC backup register 9,                                     Address offset: 0x70 */
    __IO uint32_t BKP10;       /* RTC backup register 10,                                    Address offset: 0x74 */
    __IO uint32_t BKP11;       /* RTC backup register 11,                                    Address offset: 0x78 */
    __IO uint32_t BKP12;       /* RTC backup register 12,                                    Address offset: 0x7C */
    __IO uint32_t BKP13;       /* RTC backup register 13,                                    Address offset: 0x80 */
    __IO uint32_t BKP14;       /* RTC backup register 14,                                    Address offset: 0x84 */
    __IO uint32_t BKP15;       /* RTC backup register 15,                                    Address offset: 0x88 */
    __IO uint32_t BKP16;       /* RTC backup register 16,                                    Address offset: 0x8C */
    __IO uint32_t BKP17;       /* RTC backup register 17,                                    Address offset: 0x90 */
    __IO uint32_t BKP18;       /* RTC backup register 18,                                    Address offset: 0x94 */
    __IO uint32_t BKP19;       /* RTC backup register 19,                                    Address offset: 0x98 */
    __IO uint32_t BKP20;       /* RTC backup register 20,                                    Address offset: 0x9C */
    __IO uint32_t BKP21;       /* RTC backup register 21,                                    Address offset: 0xA0 */
    __IO uint32_t BKP22;       /* RTC backup register 22,                                    Address offset: 0xA4 */
    __IO uint32_t BKP23;       /* RTC backup register 23,                                    Address offset: 0xA8 */
    __IO uint32_t BKP24;       /* RTC backup register 24,                                    Address offset: 0xAC */
    __IO uint32_t BKP25;       /* RTC backup register 25,                                    Address offset: 0xB0 */
    __IO uint32_t BKP26;       /* RTC backup register 26,                                    Address offset: 0xB4 */
    __IO uint32_t BKP27;       /* RTC backup register 27,                                    Address offset: 0xB8 */
    __IO uint32_t BKP28;       /* RTC backup register 28,                                    Address offset: 0xBC */
    __IO uint32_t BKP29;       /* RTC backup register 29,                                    Address offset: 0xC0 */
    __IO uint32_t BKP30;       /* RTC backup register 30,                                    Address offset: 0xC4 */
    __IO uint32_t BKP31;       /* RTC backup register 31,                                    Address offset: 0xC8 */
    __IO uint32_t BKP32;       /* RTC backup register 31,                                    Address offset: 0xCC */
    uint32_t reservedD0;       /* Reserved  */
    __IO uint32_t TMPCFG;      /* RTC tamper configuration register,                         Address offset: 0xD4 */
    __IO uint32_t TMPCTRL[8];  /* RTC tamper configuration register,                         Address offset: 0xD8~0xF4 */

} RTC_Module;

/** SDMMC Interface **/

typedef struct
{
	__IO uint32_t CFG1;          //0x00
	__IO uint32_t CFG2;          //0x04
	__IO uint32_t CFG3;          //0x08
	__IO uint32_t PV0CTRL;       //0x0C
	__IO uint32_t PV1CTRL;       //0x10
	__IO uint32_t PV2CTRL;       //0x14
	__IO uint32_t PV3CTRL;       //0x18
    uint32_t RESERVED;                 //0x1C
	__IO uint32_t DLYCTRL;       //0x20
}SDMMC_Module;

/** SD host Interface **/
typedef struct
{
	__IO uint32_t DSADD;        //0x00
	__IO uint32_t BLKCFG;       //0x04
	__IO uint32_t CMDARG1;      //0x08
	__IO uint32_t TMODE;        //0x0C
	__IO uint32_t CMDRSP0;      //0x10
	__IO uint32_t CMDRSP1;      //0x14
	__IO uint32_t CMDRSP2;      //0x18
	__IO uint32_t CMDRSP3;      //0x1C
	__IO uint32_t BUFDAT;       //0x20
	__IO uint32_t PRESTS;       //0x24
	__IO uint32_t CTRL1;        //0x28
	__IO uint32_t CTRL2;        //0x2C
	__IO uint32_t INTSTS;       //0x30
	__IO uint32_t IE;           //0x34
	__IO uint32_t ISE;          //0x38
	__IO uint32_t CTRLSTS;      //0x3C
	__IO uint32_t CAP0STS;      //0x40
	__IO uint32_t CAP1STS;      //0x44
    uint32_t RESERVED0[2];             //0x48
	__IO uint32_t STSFE;        //0x50
	__IO uint32_t ADMAESTS;     //0x54
	__IO uint32_t ASADD0;       //0x58
	__IO uint32_t ASADD1;       //0x5C
	__IO uint32_t PV0STS;       //0x60
	__IO uint32_t PV1STS;       //0x64
	__IO uint32_t PV2STS;       //0x68
	__IO uint32_t PV3STS;       //0x6C
	__IO uint32_t BOOTTCTRL;    //0x70
}SDHOST_Module;


/*** TIM ***/

typedef struct
{
    __IO uint32_t CTRL1;    //0x00
    __IO uint32_t CTRL2;    //0x04
    __IO uint32_t STS;      //0x08
    __IO uint32_t EVTGEN;   //0x0C
    __IO uint32_t SMCTRL;   //0x10
    __IO uint32_t DINTEN;   //0x14
    __IO uint32_t CCMOD1;   //0x18
    __IO uint32_t CCMOD2;   //0x1C
    __IO uint32_t CCMOD3;   //0x20
    __IO uint32_t CCEN;     //0x24
    __IO uint32_t CCDAT1;   //0x28
    __IO uint32_t CCDAT2;   //0x2C
    __IO uint32_t CCDAT3;   //0x30
    __IO uint32_t CCDAT4;   //0x34
    __IO uint32_t CCDAT5;   //0x38
    __IO uint32_t CCDAT6;   //0x3C    
    __IO uint32_t PSC;      //0x40   
    __IO uint32_t AR;       //0x44
    __IO uint32_t CNT;      //0x48
    __IO uint32_t REPCNT;   //0x4C
    __IO uint32_t BKDT;     //0x50
    __IO uint32_t CCDAT7;   //0x54
    __IO uint32_t CCDAT8;   //0x58
    __IO uint32_t CCDAT9;   //0x5C
    __IO uint32_t BKFR;     //0x60
    __IO uint32_t C1FILT;   //0x64
    __IO uint32_t C2FILT;   //0x68
    __IO uint32_t C3FILT;   //0x6C
    __IO uint32_t C4FILT;   //0x70
    __IO uint32_t FILTO;    //0x74
    __IO uint32_t INSEL;    //0x78
    __IO uint32_t AF1;      //0x7C
    __IO uint32_t AF2;      //0x80
    __IO uint32_t BKFR2;    //0x84
    __IO uint32_t RESERVED0[3]; 
    __IO uint32_t DCTRL;    //0x94
    __IO uint32_t DADDR;    //0x98
} TIM_Module;


/** Universal Synchronous Asynchronous Receiver Transmitter **/

typedef struct
{
    __IO uint32_t CTRL1;    //0x00
    __IO uint32_t CTRL2;    //0x04
    __IO uint32_t CTRL3;    //0x08
    __IO uint32_t STS;      //0x0C
    __IO uint32_t DAT;      //0x10
    __IO uint32_t BRCF;     //0x14
    __IO uint32_t GTP;      //0x18
    __IO uint32_t FIFO;     //0x1C
    __IO uint32_t IFW;      //0x20
    __IO uint32_t RTO;      //0x24
} USART_Module;

/**
 * @brief Window WATCHDOG
 */

typedef struct
{
    __IO uint32_t CFG;      /* WWDG Configuration Register      Address offset: 0x00 */
    __IO uint32_t CTRL;     /* WWDG Control Register            Address offset: 0x04 */
    __IO uint32_t STS;      /* WWDG Stauts Register             Address offset: 0x08 */
} WWDG_Module;

/*** xSPI ***/

typedef struct
{
    __IO uint32_t CTRL0;                /* xSPI Control Register 0,                                    Address offset: 0x00  */
    __IO uint32_t CTRL1;                /* xSPI Control Register 1,                                    Address offset: 0x04  */ 
    __IO uint32_t SSIENR;                   /* xSPI Enable Register,                                       Address offset: 0x08  */
    __IO uint32_t MW_CTRL;              /* xSPI Microwire Control Register,                            Address offset: 0x0C  */
    __IO uint32_t SLAVE_EN;             /* xSPI Slave Enable Register,                                 Address offset: 0x10  */ 
    __IO uint32_t BAUD;                 /* xSPI Baud Rate Select Register,                             Address offset: 0x14  */
    __IO uint32_t TXFT;                 /* xSPI Transmit FIFO Threshold Level,                         Address offset: 0x18  */
    __IO uint32_t RXFT;                 /* xSPI Receive FIFO Threshold Level,                          Address offset: 0x1C  */
    __IO uint32_t TXFN;                 /* xSPI Transmit FIFO Level Register,                          Address offset: 0x20  */ 
    __IO uint32_t RXFN;                 /* xSPI Receive FIFO Level Register,                           Address offset: 0x24  */
    __IO uint32_t STS;                  /* xSPI Status Register,                                       Address offset: 0x28  */
    __IO uint32_t IMASK;                /* xSPI Interrupt Mask Register,                               Address offset: 0x2C  */
    __IO uint32_t ISTS;                 /* xSPI Interrupt Status Register,                             Address offset: 0x30  */
    __IO uint32_t RISTS;                /* xSPI Raw Interrupt Status Register,                         Address offset: 0x34  */
    __IO uint32_t TXEICR_CLR;           /* xSPI Transmit FIFO Error Interrupt Clear Registers,         Address offset: 0x38  */ 
    __IO uint32_t RXFOI_CLR;            /* xSPI Receive FIFO Overflow Interrupt Clear Register,        Address offset: 0x3C  */
    __IO uint32_t RXFUI_CLR;            /* xSPI Receive FIFO Underflow Interrupt Clear Register,       Address offset: 0x40  */
    __IO uint32_t MMCI_CLR;             /* xSPI Multi-Master Interrupt Clear Register,                 Address offset: 0x44  */
    __IO uint32_t ICLR;                 /* xSPI Interrupt Clear Register,                              Address offset: 0x48  */ 
    __IO uint32_t DMA_CTRL;             /* xSPI DMA Control Register,                                  Address offset: 0x4C  */
    __IO uint32_t DMATDL_CTRL;          /* xSPI DMA Transmit Data Level,                               Address offset: 0x50  */
    __IO uint32_t DMARDL_CTRL;          /* xSPI DMA Receive Data Level,                                Address offset: 0x54  */
    __IO uint32_t IDR;                  /* xSPI Identification Register,                               Address offset: 0x58  */
    __IO uint32_t VERSION_ID;           /* xSPI component version,                                     Address offset: 0x5C  */
    __IO uint32_t DAT0;                 /* xSPI Data Register 0,                                       Address offset: 0x60  */             
    __IO uint32_t DAT1;                 /* xSPI Data Register 1,                                       Address offset: 0x64  */
    __IO uint32_t DAT2;                 /* xSPI Data Register 2,                                       Address offset: 0x68  */
    __IO uint32_t DAT3;                 /* xSPI Data Register 3,                                       Address offset: 0x6C  */
    __IO uint32_t DAT4;                 /* xSPI Data Register 4,                                       Address offset: 0x70  */
    __IO uint32_t DAT5;                 /* xSPI Data Register 5,                                       Address offset: 0x74  */
    __IO uint32_t DAT6;                 /* xSPI Data Register 6,                                       Address offset: 0x78  */
    __IO uint32_t DAT7;                 /* xSPI Data Register 7,                                       Address offset: 0x7C  */
    __IO uint32_t DAT8;                 /* xSPI Data Register 8,                                       Address offset: 0x80  */
    __IO uint32_t DAT9;                 /* xSPI Data Register 9,                                       Address offset: 0x84  */
    __IO uint32_t DAT10;                /* xSPI Data Register 10,                                      Address offset: 0x88  */
    __IO uint32_t DAT11;                /* xSPI Data Register 11,                                      Address offset: 0x8C  */
    __IO uint32_t DAT12;                /* xSPI Data Register 12,                                      Address offset: 0x90  */
    __IO uint32_t DAT13;                /* xSPI Data Register 13,                                      Address offset: 0x94  */
    __IO uint32_t DAT14;                /* xSPI Data Register 14,                                      Address offset: 0x98  */
    __IO uint32_t DAT15;                /* xSPI Data Register 15,                                      Address offset: 0x9C  */
    __IO uint32_t DAT16;                /* xSPI Data Register 16,                                      Address offset: 0xA0  */
    __IO uint32_t DAT17;                /* xSPI Data Register 17,                                      Address offset: 0xA4  */
    __IO uint32_t DAT18;                /* xSPI Data Register 18,                                      Address offset: 0xA8  */
    __IO uint32_t DAT19;                /* xSPI Data Register 19,                                      Address offset: 0xAC  */
    __IO uint32_t DAT20;                /* xSPI Data Register 20,                                      Address offset: 0xB0  */
    __IO uint32_t DAT21;                /* xSPI Data Register 21,                                      Address offset: 0xB4  */
    __IO uint32_t DAT22;                /* xSPI Data Register 22,                                      Address offset: 0xB8  */
    __IO uint32_t DAT23;                /* xSPI Data Register 23,                                      Address offset: 0xBC  */
    __IO uint32_t DAT24;                /* xSPI Data Register 24,                                      Address offset: 0xC0  */
    __IO uint32_t DAT25;                /* xSPI Data Register 25,                                      Address offset: 0xC4  */
    __IO uint32_t DAT26;                /* xSPI Data Register 26,                                      Address offset: 0xC8  */
    __IO uint32_t DAT27;                /* xSPI Data Register 27,                                      Address offset: 0xCC  */
    __IO uint32_t DAT28;                /* xSPI Data Register 28,                                      Address offset: 0xD0  */
    __IO uint32_t DAT29;                /* xSPI Data Register 29,                                      Address offset: 0xD4  */
    __IO uint32_t DAT30;                /* xSPI Data Register 30,                                      Address offset: 0xD8  */
    __IO uint32_t DAT31;                /* xSPI Data Register 31,                                      Address offset: 0xDC  */
    __IO uint32_t DAT32;            /* xSPI Data Register 32,                                      Address offset: 0xE0  */
    __IO uint32_t DAT33;            /* xSPI Data Register 33,                                      Address offset: 0xE4  */
    __IO uint32_t DAT34;            /* xSPI Data Register 34,                                      Address offset: 0xE8  */
    __IO uint32_t DAT35;            /* xSPI Data Register 35,                                      Address offset: 0xEC  */
    __IO uint32_t RX_DELAY;             /* xSPI RX Sample Delay Register,                              Address offset: 0xF0  */
    __IO uint32_t ENH_CTRL0;            /* xSPI Control Register,                                      Address offset: 0xF4  */ 
    __IO uint32_t DDR_TXDE;             /* xSPI Transmit Drive Edge Register,                          Address offset: 0xF8  */ 
    __IO uint32_t XIP_MODE;             /* xSPI eXecute in Place - Mode bits,                          Address offset: 0xFC  */
    __IO uint32_t XIP_INCR_TOC;         /* xSPI XIP INCR transfer opcode,                              Address offset: 0x100 */ 
    __IO uint32_t XIP_WRAP_TOC;         /* xSPI XIP WRAP transfer opcode,                              Address offset: 0x104 */
    __IO uint32_t XIP_CTRL;             /* xSPI XIP Control Register,                                  Address offset: 0x108 */
    __IO uint32_t XIP_SLAVE_EN;         /* xSPI Slave Enable Register,                                 Address offset: 0x10C */
    __IO uint32_t XIP_RXFOI_CLR;        /* xSPI XIP Receive FIFO Overflow Interrupt Clear Register,    Address offset: 0x110 */ 
      __IO uint32_t XIP_TOUT;               /* xSPI XIP time out register for continuous transfers,        Address offset: 0x114 */
      __IO uint32_t RESERVED0[10];
        __IO uint32_t XIP_WRITE_INCR_INST;  /* xSPI XIP Write INCR transfer opcode,                        Address offset: 0x140 */
      __IO uint32_t XIP_WRITE_WRAP_INST;  /* xSPI XIP Write WRAP transfer opcode,                        Address offset: 0x144 */
      __IO uint32_t XIP_WRITE_CTRL;         /* xSPI XIP Write Control Register,                         Address offset: 0x148 */
    __IO uint32_t RESERVED1[13];
        __IO uint32_t XIP_WRITE_TIMING;     /* xSPI XIP Write Timing Register,                            Address offset: 0x180 */
      __IO uint32_t RXDS_DELAY_CTRL;      /* xSPI RXDS Delay line control,                               Address offset: 0x184 */
} XSPI_Module;



/*** DVP ***/
typedef struct
{
    __IO uint32_t CTRL;    /* DVP control register */
    __IO uint32_t INTEN;   /* DVP interrupt enable register */
    __IO uint32_t INTSTS;  /* DVP interrupt flag and status register */
    __IO uint32_t PORTCFG; /* DVP control port configuration register */
    __IO uint32_t FIFOCFG; /* DVP control fifo configuration register */
    __IO uint32_t SMADDR1; /* DVP frame 1 start memory address register */
    __IO uint32_t SMADDR2; /* DVP frame 2 start memory address register */
    __IO uint32_t FBS;     /* DVP frame buffer size register */
    __IO uint32_t FPBC1;   /* DVP frame 1 PIXEL byte count register */
    __IO uint32_t FPBC2;   /* DVP frame 2 PIXEL byte count register */
    __IO uint32_t CSXY;    /* DVP crop start XY register */
    __IO uint32_t CEXY;    /* DVP crop end XY register */
    __IO uint32_t EMSC;    /* DVP embedded sync code marker register */
    __IO uint32_t EMSCM;   /* DVP embedded sync code mask register */
} DVP_Module;

/** FMAC **/
typedef struct
{
    __IO uint32_t X1BUFCFG;     //0x00
    __IO uint32_t X2BUFCFG;     //0x04
    __IO uint32_t YBUFCFG;      //0x08
    __IO uint32_t PARAMCFG;     //0x0C
    __IO uint32_t CTRL;         //0x10
    __IO uint32_t STS;          //0x14
    __IO uint32_t WDAT;         //0x18
    __IO uint32_t RDAT;         //0x1C 
} FMAC_Module;  


/** CORDIC **/
typedef struct
{
    __IO uint32_t CTRLSTS;      //0x00
    __IO uint32_t WDAT;         //0x04
    __IO uint32_t RDAT;         //0x08
} CORDIC_Module;

/** DSMU module registers **/
typedef struct
{
  __IO uint32_t FLTCTRL1;       //0x00
  __IO uint32_t FLTCTRL2;       //0x04
  __IO uint32_t FLTSTS;         //0x08
  __IO uint32_t FLTINTCLR;      //0x0C
  __IO uint32_t FLTJCHG;        //0x10
  __IO uint32_t FLTFCTRL;       //0x14
  __IO uint32_t FLTJDATA;       //0x18
  __IO uint32_t FLTRDATA;       //0x1C
  __IO uint32_t FLTAWDHT;       //0x20
  __IO uint32_t FLTAWDLT;       //0x24
  __IO uint32_t FLTAWDSTS;      //0x28
  __IO uint32_t FLTAWDCLR;      //0x2C
  __IO uint32_t FLTEXDETMAX;    //0x30
  __IO uint32_t FLTEXDETMIN;    //0x34
  __IO uint32_t FLTCOVTIM;      //0x38
} DSMU_Filter_Submodule;

/** DSMU channel configuration registers **/
typedef struct
{
  __IO uint32_t CHCFG1;         //0x00
  __IO uint32_t CHCFG2;         //0x04
  __IO uint32_t CHAWDSCDET;     //0x08
  __IO uint32_t CHAWDDAT;       //0x0C
  __IO uint32_t CHDATIN;        //0x10
} DSMU_Channel_Submodule;


typedef struct
{
    __IO uint32_t MCTRL;    /* SHRTIM configuration register for master timer, address offset: 0x00 */
    __IO uint32_t MINTSTS;  /* SHRTIM status register for master timer interrupt, address offset: 0x04 */
    __IO uint32_t MINTCLR;  /* SHRTIM master timer interrupt clear register, address offset: 0x08 */
    __IO uint32_t MIDEN;    /* SHRTIM master timer interrupt and DMA request enable register, address offset: 0x0C */
    __IO uint32_t MCNT;     /* SHRTIM master timer counter register, address offset: 0x10 */
    __IO uint32_t MPRD;     /* SHRTIM master timer period register, address offset: 0x14 */
    __IO uint32_t MREPT;    /* SHRTIM master timer repetition register, address offset: 0x18 */
    __IO uint32_t MCMP1DAT; /* SHRTIM master timer compare 1 register, address offset: 0x1C */
    uint32_t      RESERVED0;/* Reserved, address offset: 0x20 */
    __IO uint32_t MCMP2DAT; /* SHRTIM master timer compare 2 register, address offset: 0x24 */
    __IO uint32_t MCMP3DAT; /* SHRTIM master timer compare 3 register, address offset: 0x28 */
    __IO uint32_t MCMP4DAT; /* SHRTIM master timer compare 4 register, address offset: 0x2C */
    __IO uint32_t SYNCOUT;   /* SHRTIM SYNCOUT configure register, address offset: 0x30 */
    __IO uint32_t FRZDIS;   /* SHRTIM Timer behavior during CPU freeze, address offset: 0x34 */
    uint32_t      RESERVED1[18];  /* Reserved, 0x30..0x7C */
}SHRTIM_Master_Submodule;

/* SHRTIM Timer A to F registers definition */
typedef struct
{
    __IO uint32_t TxCTRL;      /* SHRTIM timer x control register, address offset: 0x00 */
    __IO uint32_t TxINTSTS;    /* SHRTIM timer x interrupt status register, address offset: 0x04 */
    __IO uint32_t TxINTCLR;    /* SHRTIM timer x interrupt clear register, address offset: 0x08 */
    __IO uint32_t TxIDEN;      /* SHRTIM timer x interrupt DMA  enable register, address offset: 0x0C */
    __IO uint32_t TxCNT;       /* SHRTIM timer x counter register, address offset: 0x10 */
    __IO uint32_t TxPRD;       /* SHRTIM timer x period register, address offset: 0x14 */
    __IO uint32_t TxREPT;      /* SHRTIM timer x repetition register, address offset: 0x18 */
    __IO uint32_t TxCMP1DAT;   /* SHRTIM timer x compare 1 register, address offset: 0x1C */
    __IO uint32_t TxRCMP1DAT;  /* SHRTIM timer x compare 1 repetition alias register, address offset: 0x20 */
    __IO uint32_t TxCMP2DAT;   /* SHRTIM timer x compare 2 register, address offset: 0x24 */
    __IO uint32_t TxCMP3DAT;   /* SHRTIM timer x compare 3 register, address offset: 0x28 */
    __IO uint32_t TxCMP4DAT;   /* SHRTIM timer x compare 4 register, address offset: 0x2C */
    __IO uint32_t TxCPT1;      /* SHRTIM timer x compare 1 register, address offset: 0x30 */
    __IO uint32_t TxCPT2;      /* SHRTIM timer x compare 2 register, address offset: 0x34 */
    __IO uint32_t TxDT;        /* SHRTIM timer x deadtime register, address offset: 0x38 */
    __IO uint32_t TxSET1;      /* SHRTIM timer x set register 1, address offset: 0x3C */
    __IO uint32_t TxRST1;      /* SHRTIM timer x reset register 1, address offset: 0x40 */
    __IO uint32_t TxSET2;      /* SHRTIM timer x set register 2, address offset: 0x44 */
    __IO uint32_t TxRST2;      /* SHRTIM timer x reset register 2, address offset: 0x48 */
    __IO uint32_t TxEXEVFLT1;  /* SHRTIM timer x external event filtering register 1, address offset: 0x4C */
    __IO uint32_t TxEXEVFLT2;  /* SHRTIM timer x external event filtering register 1, address offset: 0x50 */
    __IO uint32_t TxCNTRST;    /* SHRTIM timer x reset, address offset: 0x54 */
    __IO uint32_t TxCHOP;      /* SHRTIM timer x chopper register, address offset: 0x58 */
    __IO uint32_t TxCPT1CTRL;  /* SHRTIM timer x capture 1 control register, address offset: 0x5C */
    __IO uint32_t TxCPT2CTRL;  /* SHRTIM timer x capture 2 control register, address offset: 0x60 */
    __IO uint32_t TxOUT;       /* SHRTIM timer x output register, address offset: 0x64 */
    __IO uint32_t TxFALT;      /* SHRTIM timer x fault register, address offset: 0x68 */
    __IO uint32_t TxCTRL2;     /* SHRTIM timer x control register 2, address offset: 0x6C */
    __IO uint32_t TxEXEVFLT3;  /* SHRTIM timer x external event filter register 3, address offset: 0x70 */
    __IO uint32_t TxCMP5DAT;   /* SHRTIM timer x compare 5 register, address offset: 0x74 */
    uint32_t RESERVED0[2];     /* Reserved, address offset:0x78...0x7c */
}SHRTIM_Timerx_Submodule;


/* SHRTIM common register definition */
typedef struct
{
    __IO uint32_t CTRL1;        /* SHRTIM control register 1, address offset: 0x00 */
    __IO uint32_t CTRL2;        /* SHRTIM control register 2, address offset: 0x04 */
    __IO uint32_t INTSTS;       /* SHRTIM interrupt status register, address offset: 0x08 */
    __IO uint32_t INTCLR;       /* SHRTIM interrupt clear register, address offset: 0x0C */
    __IO uint32_t INTEN;        /* SHRTIM interrupt enable register, address offset: 0x10 */
    __IO uint32_t OEN;        /* SHRTIM output channel enable register, address offset: 0x14 */
    __IO uint32_t ODIS;       /* SHRTIM output channel disable register, address offset: 0x18 */
    __IO uint32_t ODISSTS;    /* SHRTIM output channel disable status register, address offset: 0x1C */
    __IO uint32_t BMCTRL;       /* SHRTIM burst mode control register, address offset: 0x20 */
    __IO uint32_t BMTG;         /* SHRTIM burst mode trigger register, address offset: 0x24 */
    __IO uint32_t BMCMP;        /* SHRTIM burst mode compare register, address offset: 0x28 */
    __IO uint32_t BMPRD;        /* SHRTIM burst mode period register, address offset: 0x2C */
    __IO uint32_t EXEVCTRL1;    /* SHRTIM external event control register 1, address offset: 0x30 */
    __IO uint32_t EXEVCTRL2;    /* SHRTIM external event control register 2, address offset: 0x34 */
    __IO uint32_t EXEVCTRL3;    /* SHRTIM external event control register 4, address offset: 0x38 */
    __IO uint32_t EXEVCTRL4;    /* SHRTIM external event control register 3, address offset: 0x3C */
    __IO uint32_t ADTG1SRC1;  /* SHRTIM ADC trigger 1's source group1 register, address offset: 0x40 */
    __IO uint32_t ADTG1SRC2;  /* SHRTIM ADC trigger 1's source group2 register, address offset: 0x44 */
    __IO uint32_t ADTG2SRC1;  /* SHRTIM ADC trigger 2's source group1 register, address offset: 0x48 */
    __IO uint32_t ADTG2SRC2;  /* SHRTIM ADC trigger 2's source group2 register, address offset: 0x4C */
    __IO uint32_t ADTG3SRC1;  /* SHRTIM ADC trigger 3's source group1 register, address offset: 0x50 */
    __IO uint32_t ADTG3SRC2;  /* SHRTIM ADC trigger 3's source group2 register, address offset: 0x54 */
    __IO uint32_t ADTG4SRC1;  /* SHRTIM ADC trigger 4's source group1 register, address offset: 0x58 */
    __IO uint32_t ADTG4SRC2;  /* SHRTIM ADC trigger 4's source group2 register, address offset: 0x5C */
    __IO uint32_t FALTIN1;      /* SHRTIM fault input register 1, address offset: 0x60 */
    __IO uint32_t FALTIN2;      /* SHRTIM fault input register 2, address offset: 0x64 */
    __IO uint32_t FALTIN3;      /* SHRTIM fault input register 3, address offset: 0x68 */
    __IO uint32_t FALTIN4;      /* SHRTIM fault input register 4, address offset: 0x6C */
    __IO uint32_t BDMTUPD;      /* SHRTIM burst DMA master timer update register, address offset: 0x70 */
    __IO uint32_t BDTAUPD;      /* SHRTIM burst DMA timer A update register, address offset: 0x74 */
    __IO uint32_t BDTBUPD;      /* SHRTIM burst DMA timer B update register, address offset: 0x78 */
    __IO uint32_t BDTCUPD;      /* SHRTIM burst DMA timer C update register, address offset: 0x7C */
    __IO uint32_t BDTDUPD;      /* SHRTIM burst DMA timer D update register, address offset: 0x80 */
    __IO uint32_t BDTEUPD;      /* SHRTIM burst DMA timer E update register, address offset: 0x84 */
    __IO uint32_t BDTFUPD;      /* SHRTIM burst DMA timer F update register, address offset: 0x88 */
    __IO uint32_t BDDAT;        /* SHRTIM burst DMA data register, address offset: 0x8C */
    __IO uint32_t ADTRGEX1;     /* SHRTIM ADC extended trigger register 1, address offset: 0x90 */
    __IO uint32_t ADTRGEX2;     /* SHRTIM ADC extended trigger register 2, address offset: 0x94 */
    __IO uint32_t ADTRGUPD;     /* SHRTIM ADC trigger update register, address offset: 0x98 */
    __IO uint32_t ADCPSC1;      /* SHRTIM ADC post scaler register 1, address offset: 0x9C */
    __IO uint32_t ADCPSC2;      /* SHRTIM ADC post scaler register 2, address offset: 0xA0 */
    uint32_t RESERVED0;         /* address offset: 0xA4 */
    __IO uint32_t SFTFALT;      /* SHRTIM soft fault trigger register, address offset: 0xA8 */
    __IO uint32_t SFTDP;        /* SHRTIM soft  delayed protection trigger register, address offset: 0xAC */
    __IO uint32_t FALTIN5;      /* SHRTIM fault input register 5, address offset: 0xB0 */
    __IO uint32_t EXEVCTRL5;    /* SHRTIM external event control register 5, address offset: 0xB4 */
    __IO uint32_t EXTEND;       /* SHRTIM extend register: 0xB8 */
}SHRTIM_Common_Submodule;

/* SHRTIM  register definition */
typedef struct {
  SHRTIM_Master_Submodule sMasterRegs;
  SHRTIM_Timerx_Submodule sTimerxRegs[6];
  SHRTIM_Common_Submodule sCommonRegs;
}SHRTIM_Module;

/**
 * @brief Serial Peripheral Interface
 */

typedef struct
{
    __IO uint16_t CTRL1;            /* SPI Control Register 1,                       Address offset: 0x00 */ 
    uint16_t RESERVED0;
    __IO uint16_t CTRL2;            /* SPI Control Register 2,                       Address offset: 0x04 */  
    uint16_t RESERVED1;
    __IO uint16_t STS;              /* SPI Status Register,                          Address offset: 0x08 */
    uint16_t RESERVED2; 
    __IO uint16_t DAT;              /* SPI Data Register,                            Address offset: 0x0C */
    uint16_t RESERVED3;
    __IO uint16_t CRCTDAT;          /* SPI Transmit CRC Register,                    Address offset: 0x10 */
    uint16_t RESERVED4;
    __IO uint16_t CRCRDAT;          /* SPI Receive CRC Register,                     Address offset: 0x14 */
    uint16_t RESERVED5;  
    __IO uint16_t CRCPOLY;          /* SPI CRC Polynomial Register,                  Address offset: 0x18 */
    uint16_t RESERVED6;             
    __IO uint16_t SPI_I2S_CFGR;     /* SPI_I2S Configuration Register,               Address offset: 0x1C */ 
    uint16_t RESERVED7;             
    __IO uint16_t I2SPREDIV;        /* SPI_I2S Prescaler Register,                   Address offset: 0x20 */ 
    uint16_t RESERVED8;             
    __IO uint16_t RX_FIFO;          /* SPI Receive FIFO,                             Address offset: 0x24 */ 
    uint16_t RESERVED9;             
    __IO uint16_t FIFONUM;          /* SPI FIFO Configuration register,              Address offset: 0x28 */ 
    uint16_t RESERVED10;
    uint16_t RESERVED11;        /* SPI FIFO Configuration register,              Address offset: 0x2C */ 
    uint16_t RESERVED12;        
    __IO uint16_t FIFOCNT;          /* SPI FIFO Count Register,                      Address offset: 0x30 */
    uint16_t RESERVED13;  
    __IO uint16_t TRANSNUM;         /* SPI Transfer Number Configuration Register,   Address offset: 0x34 */
    uint16_t RESERVED14;
    __IO uint16_t CR3;              /* SPI RX Sample Delay Register,                 Address offset: 0x38 */
} SPI_Module;

/**
	* @brief I2S
	*/
typedef struct
{
		__IO uint16_t CR1;
		uint16_t  RESERVED0;
		__IO uint16_t CR2;
		uint16_t  RESERVED1;
		__IO uint16_t SR;
		uint16_t  RESERVED2;
		__IO uint16_t DR;
		uint16_t  RESERVED3;
		__IO uint16_t TXCRCR;
		uint16_t  RESERVED4;
		__IO uint16_t RXCRCR;
		uint16_t  RESERVED5;
		__IO uint16_t CRCPR;
		uint16_t  RESERVED6;
		__IO uint16_t I2SCFGR;
		uint16_t  RESERVED7;
		__IO uint16_t I2SPR;
		uint16_t  RESERVED8;
		__IO uint16_t RXFIFO;
		uint16_t  RESERVED9;
		__IO uint16_t FIFONUM;
		uint16_t  RESERVED10;
		uint32_t  RESERVED11;
		__IO uint16_t FIFOCNT;
		uint16_t  RESERVED12;
		__IO uint32_t TRANSNUM;
} I2S_Module;


typedef struct
{
    uint32_t RESERVED0; 
    __IO uint16_t I2S_CTRL2;        /* I2S_EXT Control Register,                     Address offset: 0x04 */  
    uint16_t RESERVED1;             
    __IO uint16_t I2S_STS;          /* I2S_EXT Status Register,                      Address offset: 0x08 */
    uint16_t RESERVED2;             
    __IO uint16_t I2S_DAT;          /* I2S_EXT Data Register,                        Address offset: 0x0C */ 
    uint16_t RESERVED3;             
    uint32_t RESERVED4;             
    uint32_t RESERVED5;             
    uint32_t RESERVED6;             
    __IO uint16_t I2S_CFGR;         /* I2S_EXT Configuration Register                Address offset: 0x1C */ 
    uint16_t RESERVED17; 

}I2S_EXT_Module; 
 



typedef struct
{
    __IO uint32_t STS;         //0x00
    __IO uint32_t INTEN;       //0x04
    __IO uint32_t CTRL;        //0x08
    __IO uint32_t BRCFG1;      //0x0C
    __IO uint32_t TXDAT;       //0x10
    __IO uint32_t BRCFG2;      //0x14
    __IO uint32_t WUDAT1;      //0x18
    __IO uint32_t WUDAT2;      //0x1C
    __IO uint32_t RXDAT;       //0x20
}LPUART_Module;

typedef struct
{
    __IO uint32_t CTRL1;       //0x00
    __IO uint32_t CTRL2;       //0x04
    __IO uint32_t EINJ;       //0x08
    __IO uint32_t INTFS;       //0x0C
    __IO uint32_t INTF1;       //0x10
    __IO uint32_t FEADR1;       //0x14
    __IO uint32_t FEDATL1;       //0x18
    __IO uint32_t FEDATH1;       //0x1C
    __IO uint32_t FECOD1;       //0x20
    __IO uint32_t INTF2;       //0x24
    __IO uint32_t FEADR2;       //0x28
    __IO uint32_t FEDATL2;       //0x2C
    __IO uint32_t FEDATH2;       //0x30
    __IO uint32_t FECOD2;       //0x34
    __IO uint32_t INTF3;       //0x38
    __IO uint32_t FEADR3;       //0x3C
    __IO uint32_t FEDATL3;       //0x40
    __IO uint32_t FEDATH3;       //0x44
    __IO uint32_t FECOD3;       //0x48
    __IO uint32_t INTF4;       //0x4C
    __IO uint32_t FEADR4;       //0x50
    __IO uint32_t FEDATL4;       //0x54
    __IO uint32_t FEDATH4;       //0x58
    __IO uint32_t FECOD4;       //0x5C
    __IO uint32_t INTF5;       //0x60
    __IO uint32_t FEADR5;       //0x64
    __IO uint32_t FEDATL5;       //0x68
    __IO uint32_t FEDATH5;       //0x6C
    __IO uint32_t FECOD5;       //0x70
    __IO uint32_t INTF6;       //0x74
    __IO uint32_t FEADR6;       //0x78
    __IO uint32_t FEDATL6;       //0x7C
    __IO uint32_t FEDATH6;       //0x80
    __IO uint32_t FECOD6;       //0x84
}ECCMON_TypeDef;

typedef struct
{
    __IO uint32_t CTRL;           //0x00
    __IO uint32_t STS;            //0x04
    __IO uint32_t KEY;            //0x08
    __IO uint32_t USC;            //0x0C
    __IO uint32_t ADDR;           //0x10
    __IO uint32_t RDATA;          //0x14
    __IO uint32_t WDATA;          //0x18
    __IO uint32_t RESERVED0;      //0x1c
    __IO uint32_t SECJVLD;        //0x20
    __IO uint32_t RESERVED1;      //0x24
    __IO uint32_t SECMDVLD;       //0x28
    __IO uint32_t RESERVED2;      //0x2c
    __IO uint32_t RDP2PVLD;       //0x30
    __IO uint32_t RESERVED3;      //0x34
    __IO uint32_t BTMVLD;         //0x38
    __IO uint32_t BORVLD;         //0x3c
    __IO uint32_t IWDGVLD;        //0x40
    __IO uint32_t TCMSZVLD;       //0x44
    __IO uint32_t RESERVED4[2];   //0x48
    __IO uint32_t JTAGKVLD;       //0x50
    __IO uint32_t REKU1VLD;       //0x54
    __IO uint32_t REKU2VLD;       //0x58
    __IO uint32_t REKU3VLD;       //0x5c
    __IO uint32_t REKU4VLD;       //0x60
    __IO uint32_t IDKU1VLD;       //0x64
    __IO uint32_t IDKU2VLD;       //0x68
    __IO uint32_t IDKU3VLD;       //0x6c
    __IO uint32_t IDKU4VLD;       //0x70
    __IO uint32_t UMUU0;          //0x74
    __IO uint32_t UMUU1;          //0x78
    __IO uint32_t UMUU2;          //0x7c
    __IO uint32_t UMUU3;          //0x80
    __IO uint32_t UMUU4;          //0x84
    __IO uint32_t UMUU5;          //0x88
    __IO uint32_t UMUU6;          //0x8c
    __IO uint32_t UMUU7;          //0x90
    __IO uint32_t RESERVED5[9];   //0x94
    __IO uint32_t CRLD1;          //0xb8
    __IO uint32_t CRLD2;          //0xbc
}OTPC_Module;

typedef struct
{
    __IO uint32_t CTRL;         //0x00
    __IO uint32_t STS;          //0x04
    __IO uint32_t RESERVED0[11];//0x08
    __IO uint32_t RTADC1;       //0x34
    __IO uint32_t RTADC2;       //0x38
    __IO uint32_t RTADC3;       //0x3C
    __IO uint32_t RTADC4;       //0x40
    __IO uint32_t RTK1P0;       //0x44
    __IO uint32_t RTK1P1;       //0x48
    __IO uint32_t RTK1P2;       //0x4C
    __IO uint32_t RTK1P3;       //0x50
    __IO uint32_t RTK2P0;       //0x54
    __IO uint32_t RTK2P1;       //0x58
    __IO uint32_t RTK2P2;       //0x5c
    __IO uint32_t RTK2P3;       //0x60
    __IO uint32_t RTK3P0;       //0x64
    __IO uint32_t RTK3P1;       //0x68
    __IO uint32_t RTK3P2;       //0x6c
    __IO uint32_t RTK3P3;       //0x70
    __IO uint32_t RTK4P0;       //0x74
    __IO uint32_t RTK4P1;       //0x78
    __IO uint32_t RTK4P2;       //0x7c
    __IO uint32_t RTK4P3;       //0x80
    __IO uint32_t RTR1;         //0x84
    __IO uint32_t RTR2;         //0x88
    __IO uint32_t RTR3;         //0x8c
    __IO uint32_t RTR4;         //0x90
    __IO uint32_t RESERVED1[9]; //0x94
    __IO uint32_t RTCRC;        //0xb8
    __IO uint32_t RESERVED2[28];//0xbc
    __IO uint32_t ETH1ME;       //0x12c
    __IO uint32_t ETH2ME;       //0x130
    __IO uint32_t USB1ME;       //0x134
    __IO uint32_t USB2ME;       //0x138
    __IO uint32_t SD1ME;        //0x13c
    __IO uint32_t SD2ME;        //0x140
    __IO uint32_t DVP1ME;       //0x144
    __IO uint32_t DVP2ME;       //0x148
    __IO uint32_t DMA1ME;       //0x14c
    __IO uint32_t DMA2ME;       //0x150
    __IO uint32_t DMA3ME;       //0x154
    __IO uint32_t MDMAME;       //0x158
    __IO uint32_t JPEGME;       //0x15c
    __IO uint32_t LCDME;        //0x160
    __IO uint32_t GPUME;        //0x164
    __IO uint32_t SDPUME;       //0x168
    __IO uint32_t RESERVED3;    //0x16c
    __IO uint32_t XRD;          //0x170
    __IO uint32_t RESERVED4;    //0x174
    __IO uint32_t XRAD;         //0x178
    __IO uint32_t X1WD;         //0x17c
    __IO uint32_t X1RD;         //0x180
    __IO uint32_t X1WAD;        //0x184
    __IO uint32_t X1RAD;        //0x188
    __IO uint32_t X2WD;         //0x18c
    __IO uint32_t X2RD;         //0x190
    __IO uint32_t X2WAD;        //0x194
    __IO uint32_t X2RAD;        //0x198
    __IO uint32_t X3WD;         //0x19c
    __IO uint32_t X3RD;         //0x1A0
    __IO uint32_t X3WAD;        //0x1A4
    __IO uint32_t X3RAD;        //0x1A8
    __IO uint32_t RESERVED5[25];//0x1AC
    __IO uint32_t H1WD;         //0x210
    __IO uint32_t H1RD;         //0x214
    __IO uint32_t H1WAD;        //0x218
    __IO uint32_t H1RAD;        //0x21c
    __IO uint32_t H2WD;         //0x220
    __IO uint32_t H2RD;         //0x224
    __IO uint32_t H2WAD;        //0x228
    __IO uint32_t H2RAD;        //0x22c
    __IO uint32_t H3WD;         //0x230
    __IO uint32_t H3RD;         //0x234
    __IO uint32_t H3WAD;        //0x238
    __IO uint32_t H3RAD;        //0x23c
    __IO uint32_t H4WD;         //0x240
    __IO uint32_t H4RD;         //0x244
    __IO uint32_t H4WAD;        //0x248
    __IO uint32_t H4RAD;        //0x24c
    __IO uint32_t H5WD;         //0x250
    __IO uint32_t H5RD;         //0x254
    __IO uint32_t H5WAD;        //0x258
    __IO uint32_t H5RAD;        //0x25c
    __IO uint32_t BKWD;         //0x260
    __IO uint32_t BKRD;         //0x264
    __IO uint32_t BKWAD;        //0x268
    __IO uint32_t BKRAD;        //0x26c
    __IO uint32_t ITWD;         //0x270
    __IO uint32_t ITRD;         //0x274
    __IO uint32_t ITWAD;        //0x278
    __IO uint32_t ITRAD;        //0x27c
}MMU_Module;

typedef struct
{
    uint32_t      RESERVED0[32];
    __IO uint32_t BADD1;           // 0x80   
    __IO uint32_t ADDMASK1;        // 0x84
    __IO uint32_t BADD2;           // 0x88
    __IO uint32_t ADDMASK2;        // 0x8C
    uint32_t      RESERVED1[4];
    __IO uint32_t CFG1;            // 0xA0
    __IO uint32_t CFG2;            // 0xA4
    uint32_t      RESERVED2[2];
    __IO uint32_t RAT;             // 0xB0
    __IO uint32_t RCT;             // 0xB4
    __IO uint32_t RRDLY;           // 0xB8
    __IO uint32_t PT;              // 0xBC
    __IO uint32_t WRT;             // 0xC0
    __IO uint32_t RFCT;            // 0xC4
    __IO uint32_t RCDLY;           // 0xC8
    __IO uint32_t RI;              // 0xCC
    uint32_t      RESERVED3[4];
    __IO uint32_t CBO;             // 0xE0
    __IO uint32_t OR;              // 0xE4
    __IO uint32_t OS;              // 0xE8
    uint32_t      RESERVED4[1];
    __IO uint32_t IINFO;           // 0xF0
    uint32_t      RESERVED5[3];
    __IO uint32_t WP;              // 0x100
} SDRAM_Module;

/**
* @brief AFEC
*/
typedef struct
{
    __IO uint32_t TRIMR0;
    __IO uint32_t TRIMR1;
    __IO uint32_t TRIMR2;
    __IO uint32_t TRIMR3;
    __IO uint32_t TRIMR4;
    __IO uint32_t TRIMR5;
    __IO uint32_t TRIMR6;
    __IO uint32_t TRIMR7;
    __IO uint32_t TRIMR8;
    __IO uint32_t TRIMR9;
    __IO uint32_t TRIMR10;
    __IO uint32_t TRIMR11;
    __IO uint32_t TRIMR12;
    __IO uint32_t TESTR0;
    __IO uint32_t TESTR1;
    __IO uint32_t TESTR2;
    __IO uint32_t TESTR3;
    __IO uint32_t TESTR4;
    __IO uint32_t TESTR5;
    __IO uint32_t TESTR6;
    __IO uint32_t TESTR7;
    __IO uint32_t TESTR8;
    __IO uint32_t TESTR9;
    __IO uint32_t TESTR10;
    __IO uint32_t TESTR11;
    __IO uint32_t TESTR12;
    __IO uint32_t TESTR13;
    __IO uint32_t TESTR14;
    __IO uint32_t TESTR15;
    __IO uint32_t TESTR16;
    __IO uint32_t TESTR17;
    __IO uint32_t TESTR18;
    __IO uint32_t TESTR19;
    __IO uint32_t TESTR20;
    __IO uint32_t TESTR21;
    __IO uint32_t TESTR22;
    __IO uint32_t TESTR23;
    __IO uint32_t TESTR24;
    __IO uint32_t TESTR25;
    __IO uint32_t TESTR26;
    __IO uint32_t TESTR27;
    __IO uint32_t TESTR28;
    __IO uint32_t TESTR29;
    __IO uint32_t TESTR30;
    __IO uint32_t TESTR31;
    __IO uint32_t TESTR32;
    __IO uint32_t TESTR33;
    __IO uint32_t TESTR34;
    __IO uint32_t TESTR35;
    __IO uint32_t TESTR36;
    __IO uint32_t TESTR37;
    __IO uint32_t TESTR38;
    __IO uint32_t TESTR39;
    __IO uint32_t TESTR40;
    __IO uint32_t TESTR41;
    __IO uint32_t TESTR42;
    __IO uint32_t TESTR43;
    __IO uint32_t TESTR44;
    __IO uint32_t TRIMR13;
    __IO uint32_t TRIMR14;
    __IO uint32_t TESTR45;
} AFEC_TypeDef;

#define FLASH_BASE            ((uint32_t)0x15000000) /*!< FLASH base address in the alias region */
#define SRAM_BASE             ((uint32_t)0x24000000) /*!< SRAM base address in the alias region */
#define PERIPH_BASE           ((uint32_t)0x40000000) /*!< Peripheral base address in the alias region */

#define SRAM_BB_BASE          ((uint32_t)0x22000000) /*!< SRAM base address in the bit-band region */
#define PERIPH_BB_BASE        ((uint32_t)0x42000000) /*!< Peripheral base address in the bit-band region */

#define UCID_BASE             ((uint32_t)0x1FFFC238U) /* UCID Address : 0x1FFF_F238 */
#define UCID_LENGTH           ((uint32_t)0x10U)       /* UCID Length  : 16Bytes */
// #define UID_BASE              ((uint32_t)0x1FFFC760U) /* UID Address  : 0x1FFF_C760 */
// #define UID_LENGTH            ((uint32_t)0x0CU)       /* UID Length   : 12Bytes */
#define DBGMCU_ID_BASE        ((uint32_t)0x1FFFF248U) /* DBGMCU_ID Address: 0x1FFF_F248 */
#define DBGMCU_ID_LENGTH      ((uint32_t)0x04U)       /* DBGMCU_ID Length : 4 Bytes */

    /*!< Peripheral memory map */
#define APB1PERIPH_BASE       (PERIPH_BASE)
#define AHB1PERIPH_BASE       (PERIPH_BASE + 0x40000)
#define AHB9PERIPH_BASE       (PERIPH_BASE + 0xB0000)
#define APB2PERIPH_BASE       (PERIPH_BASE + 0xD0000)
#define AHB2PERIPH_BASE       (PERIPH_BASE + 0xF0000)
#define APB6PERIPH_BASE       (PERIPH_BASE + 0x10000000)
#define AHB6PERIPH_BASE       (PERIPH_BASE + 0x11000000)
#define APB5PERIPH_BASE       (PERIPH_BASE + 0x18000000)
#define AHB5PERIPH_BASE       (PERIPH_BASE + 0x18030000)

    /* APB1 */
#define BTIM4_BASE          (APB1PERIPH_BASE + 0x10C00)
#define BTIM3_BASE          (APB1PERIPH_BASE + 0x10800)
#define WWDG2_BASE            (APB1PERIPH_BASE + 0x10000)
#define DAC12_BASE            (APB1PERIPH_BASE + 0xFC00)
#define I2S4EXT_BASE          (APB1PERIPH_BASE + 0xFA00)
#define I2S3EXT_BASE          (APB1PERIPH_BASE + 0xF600)
#define I2S4_BASE             (APB1PERIPH_BASE + 0xF800)
#define I2S3_BASE             (APB1PERIPH_BASE + 0xF400)
#define I2C3_BASE             (APB1PERIPH_BASE + 0xF000)
#define I2C2_BASE             (APB1PERIPH_BASE + 0xEC00)
#define I2C1_BASE             (APB1PERIPH_BASE + 0xE800)
#define SPI3_BASE             (APB1PERIPH_BASE + 0xE400)
#define UART12_BASE           (APB1PERIPH_BASE + 0xE000)
#define UART11_BASE           (APB1PERIPH_BASE + 0xDC00)
#define UART10_BASE           (APB1PERIPH_BASE + 0xD800)
#define UART9_BASE            (APB1PERIPH_BASE + 0xD400)
#define USART4_BASE           (APB1PERIPH_BASE + 0xD000)
#define USART3_BASE           (APB1PERIPH_BASE + 0xCC00)
#define USART2_BASE           (APB1PERIPH_BASE + 0xC800)
#define USART1_BASE           (APB1PERIPH_BASE + 0xC400)
#define GTIMA7_BASE          (APB1PERIPH_BASE + 0xC000)
#define GTIMA6_BASE          (APB1PERIPH_BASE + 0xBC00)
#define GTIMA5_BASE          (APB1PERIPH_BASE + 0xB800)
#define GTIMA4_BASE          (APB1PERIPH_BASE + 0xB400)
#define GTIMB1_BASE         (APB1PERIPH_BASE + 0xA800)
#define GTIMB2_BASE          (APB1PERIPH_BASE + 0xAC00)
#define GTIMB3_BASE          (APB1PERIPH_BASE + 0xB000)
#define BTIM2_BASE          (APB1PERIPH_BASE + 0xA400)
#define BTIM1_BASE          (APB1PERIPH_BASE + 0xA000)
#define AHBdCache_BASE        (APB1PERIPH_BASE + 0x9000)
#define AHBiCache_BASE        (APB1PERIPH_BASE + 0x8000)
#define FDCAN6_BASE           (APB1PERIPH_BASE + 0xC00)
#define FDCAN5_BASE           (APB1PERIPH_BASE + 0x800)
#define FDCAN2_BASE           (APB1PERIPH_BASE + 0x400)
#define FDCAN1_BASE           (APB1PERIPH_BASE)


    /* APB2 */
#define UART15_BASE           (APB2PERIPH_BASE + 0xF800)
#define UART14_BASE           (APB2PERIPH_BASE + 0xF400)
#define UART13_BASE           (APB2PERIPH_BASE + 0xF000)
#define USART8_BASE           (APB2PERIPH_BASE + 0xEC00)
#define USART7_BASE           (APB2PERIPH_BASE + 0xE800)
#define USART6_BASE           (APB2PERIPH_BASE + 0xE400)
#define USART5_BASE           (APB2PERIPH_BASE + 0xE000)
#define I2C6_BASE             (APB2PERIPH_BASE + 0xDC00)
#define I2C5_BASE             (APB2PERIPH_BASE + 0xD800)
#define I2C4_BASE             (APB2PERIPH_BASE + 0xD400)
#define GTIMA3_BASE          (APB2PERIPH_BASE + 0xD000)
#define GTIMA2_BASE          (APB2PERIPH_BASE + 0xCC00)
#define GTIMA1_BASE          (APB2PERIPH_BASE + 0xC800)
#define SPI2_BASE             (APB2PERIPH_BASE + 0xC400)
#define SPI1_BASE             (APB2PERIPH_BASE + 0xC000)
#define I2S2_BASE             (APB2PERIPH_BASE + 0xBC00)
#define I2S1_BASE             (APB2PERIPH_BASE + 0xB800)
#define I2S2EXT_BASE          (APB2PERIPH_BASE + 0xBE00)
#define I2S1EXT_BASE          (APB2PERIPH_BASE + 0xBA00) 

#define ATIM2_BASE          (APB2PERIPH_BASE + 0xB400)
#define ATIM1_BASE          (APB2PERIPH_BASE + 0xB000)
#define DSMU_BASE             (APB2PERIPH_BASE + 0xA000)
#define DSMU_Channel0_BASE    (DSMU_BASE + 0x00UL)
#define DSMU_Channel1_BASE    (DSMU_BASE + 0x20UL)
#define DSMU_Channel2_BASE    (DSMU_BASE + 0x40UL)
#define DSMU_Channel3_BASE    (DSMU_BASE + 0x60UL)
#define DSMU_Channel4_BASE    (DSMU_BASE + 0x80UL)
#define DSMU_Channel5_BASE    (DSMU_BASE + 0xA0UL)
#define DSMU_Channel6_BASE    (DSMU_BASE + 0xC0UL)
#define DSMU_Channel7_BASE    (DSMU_BASE + 0xE0UL)
#define DSMU_Filter0_BASE     (DSMU_BASE + 0x100UL)
#define DSMU_Filter1_BASE     (DSMU_BASE + 0x180UL)
#define DSMU_Filter2_BASE     (DSMU_BASE + 0x200UL)
#define DSMU_Filter3_BASE     (DSMU_BASE + 0x280UL)

#define SHRTIM2_BASE          (APB2PERIPH_BASE + 0x9000)
#define SHRTIM1_BASE          (APB2PERIPH_BASE + 0x8000)
#define FDCAN8_BASE           (APB2PERIPH_BASE + 0x0C00)
#define FDCAN7_BASE           (APB2PERIPH_BASE + 0x0800)
#define FDCAN4_BASE           (APB2PERIPH_BASE + 0x0400)
#define FDCAN3_BASE           (APB2PERIPH_BASE)

    /* APB5 */
#define LPTIM5_BASE           (APB5PERIPH_BASE + 0x5800)
#define RTC_BASE              (APB5PERIPH_BASE + 0x5400)
#define IWDG2_BASE            (APB5PERIPH_BASE + 0x5000)
#define IWDG1_BASE            (APB5PERIPH_BASE + 0x4C00)
#define COMP_BASE             (APB5PERIPH_BASE + 0x4800)
#define ATIM4_BASE            (APB5PERIPH_BASE + 0x4400)
#define ATIM3_BASE            (APB5PERIPH_BASE + 0x4000)
#define I2C10_BASE            (APB5PERIPH_BASE + 0x3C00)
#define I2C9_BASE             (APB5PERIPH_BASE + 0x3800)
#define I2C8_BASE             (APB5PERIPH_BASE + 0x3400)
#define I2C7_BASE             (APB5PERIPH_BASE + 0x3000)
#define SPI7_BASE             (APB5PERIPH_BASE + 0x2C00)
#define SPI6_BASE             (APB5PERIPH_BASE + 0x2800)
#define SPI5_BASE             (APB5PERIPH_BASE + 0x2400)
#define SPI4_BASE             (APB5PERIPH_BASE + 0x2000)
#define LPTIM4_BASE           (APB5PERIPH_BASE + 0x1C00)
#define LPTIM3_BASE           (APB5PERIPH_BASE + 0x1800)
#define LPTIM2_BASE           (APB5PERIPH_BASE + 0x1400)
#define LPTIM1_BASE           (APB5PERIPH_BASE + 0x1000)
#define LPUART2_BASE          (APB5PERIPH_BASE + 0x0C00)
#define LPUART1_BASE          (APB5PERIPH_BASE + 0x0800)
#define AFEC_BASE             (APB5PERIPH_BASE + 0x0400)
#define EXTI_BASE             (APB5PERIPH_BASE)

    /* APB6 */
#define JPEG_CTRL_BASE        (APB6PERIPH_BASE + 0x90800)
#define JPEG_SGDMA_P2H_BASE   (APB6PERIPH_BASE + 0x90400)
#define JPEG_BRC_BASE         (APB6PERIPH_BASE + 0x90000)
#define JPEG_DEC_BASE         (APB6PERIPH_BASE + 0x80000)
#define JPEG_SGDMA_H2P_BASE   (APB6PERIPH_BASE + 0x70400)
#define JPEG_RBC_BASE         (APB6PERIPH_BASE + 0x70000)
#define JPEG_ENC_BASE         (APB6PERIPH_BASE + 0x60000)
#define FEMC_BASE             (APB6PERIPH_BASE + 0x4C000)
#define TCMSRAMC_BASE         (APB6PERIPH_BASE + 0x4B000)
#define DSI_HOST_WRAPPER_BASE (APB6PERIPH_BASE + 0x4AC00)
#define WWDG1_BASE            (APB6PERIPH_BASE + 0x4A800)
#define LCDC_BASE             (APB6PERIPH_BASE + 0x4A000)
#define LCDC_Layer1_BASE      (LCDC_BASE + 0x100)   
#define LCDC_Layer2_BASE      (LCDC_BASE + 0x200)   
#define LCDC_Layer3_BASE      (LCDC_BASE + 0x300)   
#define LCDC_Layer4_BASE      (LCDC_BASE + 0x400)
#define DVP2_BASE             (APB6PERIPH_BASE + 0x49000)
#define DVP1_BASE             (APB6PERIPH_BASE + 0x48000)
#define GPU_BASE              (APB6PERIPH_BASE + 0x40000)
#define DSI_HOST_BASE         (APB6PERIPH_BASE)

    /* AHB1 */
#define USB_CTRL2_WRAPPER_BASE (AHB1PERIPH_BASE + 0x60000)
#define USB_CTRL2_BASE        (AHB1PERIPH_BASE + 0x20000)
#define SDHOST2_BASE          (AHB1PERIPH_BASE + 0x10000)
#define SDMMC2_BASE           (AHB1PERIPH_BASE + 0xA000)
#define DMA3_BASE             (AHB1PERIPH_BASE + 0x7000)
#define DMA2_BASE             (AHB1PERIPH_BASE + 0x6C00)
#define DMA1_BASE             (AHB1PERIPH_BASE + 0x6800)
#define DMAMUX1_BASE          (AHB1PERIPH_BASE + 0x6400)
#define ECCMON_AHB_CACHE_BASE (AHB1PERIPH_BASE + 0x5000)
#define ADC1_BASE             (AHB1PERIPH_BASE + 0x4000)
#define ADC2_BASE             (AHB1PERIPH_BASE + 0x4400)
#define ADC3_BASE             (AHB1PERIPH_BASE + 0x4800)
#define ETH2_BASE             (AHB1PERIPH_BASE + 0x2000)

    /* AHB2 */
#define USB_CTRL1_WRAPPER_BASE (AHB1PERIPH_BASE + 0x50000)
#define USB_CTRL1_BASE        (AHB1PERIPH_BASE + 0x10000)
#define DCMUB_CM4_BASE        (AHB2PERIPH_BASE + 0x8000)
#define DCMUA_CM7_BASE        (AHB2PERIPH_BASE + 0x7000)
#define SEMA4_BASE            (AHB2PERIPH_BASE + 0x6000)
#define ETH1_BASE             (AHB2PERIPH_BASE + 0x4000)
#define SDPU_BASE             (AHB2PERIPH_BASE + 0x2000)
#define DAC56_BASE            (AHB2PERIPH_BASE + 0x1C00)
#define DAC34_BASE            (AHB2PERIPH_BASE + 0x1800)
#define FMAC_BASE             (AHB2PERIPH_BASE + 0x1400)
#define CORDIC_BASE           (AHB2PERIPH_BASE + 0x1000)
#define ECCMON2_BASE          (AHB2PERIPH_BASE )

/* AHB5 */
#define ECCMON3_BASE          (AHB5PERIPH_BASE + 0x6000)
#define DBGMCU_BASE           (AHB5PERIPH_BASE + 0x5400)
#define GPIOK_BASE            (AHB5PERIPH_BASE + 0x5000)
#define GPIOJ_BASE            (AHB5PERIPH_BASE + 0x4C00)
#define GPIOI_BASE            (AHB5PERIPH_BASE + 0x4800)
#define GPIOH_BASE            (AHB5PERIPH_BASE + 0x4400)
#define GPIOG_BASE            (AHB5PERIPH_BASE + 0x4000)
#define GPIOF_BASE            (AHB5PERIPH_BASE + 0x3C00)
#define GPIOE_BASE            (AHB5PERIPH_BASE + 0x3800)
#define GPIOD_BASE            (AHB5PERIPH_BASE + 0x3400)
#define GPIOC_BASE            (AHB5PERIPH_BASE + 0x3000)
#define GPIOB_BASE            (AHB5PERIPH_BASE + 0x2C00)
#define GPIOA_BASE            (AHB5PERIPH_BASE + 0x2800)
#define AFIO_BASE             (AHB5PERIPH_BASE + 0x2400)
#define CRC_BASE              (AHB5PERIPH_BASE + 0x2000)
#define PWR_BASE              (AHB5PERIPH_BASE + 0x1000)
#define RCC_BASE              (AHB5PERIPH_BASE)

/* AHB6 */
#define MDMA_WRAPPER_BASE     (AHB6PERIPH_BASE + 0x120800)
#define DMAMUX2_MDMA_BASE     (AHB6PERIPH_BASE + 0x120000)
#define OTPC_BASE             (AHB6PERIPH_BASE + 0x118000)
#define SDHOST1_BASE          (AHB6PERIPH_BASE + 0x110000)
#define SDMMC1_BASE           (AHB6PERIPH_BASE + 0x107000)
#define SDRAM_BASE            (AHB6PERIPH_BASE + 0x106000)
#define MMU_BASE              (AHB6PERIPH_BASE + 0x105000)
#define ECCMON1P1_BASE        (AHB6PERIPH_BASE + 0x104000)
#define ECCMON1P2_BASE        (AHB6PERIPH_BASE + 0x104400)
#define ECCMON1P3_BASE        (AHB6PERIPH_BASE + 0x104800)
#define ECCMON1P4_BASE        (AHB6PERIPH_BASE + 0x104c00)
#define MDMA_BASE             (AHB6PERIPH_BASE + 0x102000)
#define xSPI2_BASE            (AHB6PERIPH_BASE + 0x101000)
#define xSPI1_BASE            (AHB6PERIPH_BASE + 0x100000)
#define GPV_BASE              (AHB6PERIPH_BASE)

/*AHB9*/
#define ETHERCAT_WRAPPER_BASE  (AHB9PERIPH_BASE + 0x10000)
#define ETHERCAT_BASE          (AHB9PERIPH_BASE)


#define DMA1_CH0_BASE                 ( DMA1_BASE +0*0x58)
#define DMA1_CH1_BASE                 ( DMA1_BASE +1*0x58)
#define DMA1_CH2_BASE                 ( DMA1_BASE +2*0x58)
#define DMA1_CH3_BASE                 ( DMA1_BASE +3*0x58)
#define DMA1_CH4_BASE                 ( DMA1_BASE +4*0x58)
#define DMA1_CH5_BASE                 ( DMA1_BASE +5*0x58)
#define DMA1_CH6_BASE                 ( DMA1_BASE +6*0x58)
#define DMA1_CH7_BASE                 ( DMA1_BASE +7*0x58)

#define DMA2_CH0_BASE                 ( DMA2_BASE +0*0x58)
#define DMA2_CH1_BASE                 ( DMA2_BASE +1*0x58)
#define DMA2_CH2_BASE                 ( DMA2_BASE +2*0x58)
#define DMA2_CH3_BASE                 ( DMA2_BASE +3*0x58)
#define DMA2_CH4_BASE                 ( DMA2_BASE +4*0x58)
#define DMA2_CH5_BASE                 ( DMA2_BASE +5*0x58)
#define DMA2_CH6_BASE                 ( DMA2_BASE +6*0x58)
#define DMA2_CH7_BASE                 ( DMA2_BASE +7*0x58)

#define DMA3_CH0_BASE                 ( DMA3_BASE +0*0x58)
#define DMA3_CH1_BASE                 ( DMA3_BASE +1*0x58)
#define DMA3_CH2_BASE                 ( DMA3_BASE +2*0x58)
#define DMA3_CH3_BASE                 ( DMA3_BASE +3*0x58)
#define DMA3_CH4_BASE                 ( DMA3_BASE +4*0x58)
#define DMA3_CH5_BASE                 ( DMA3_BASE +5*0x58)
#define DMA3_CH6_BASE                 ( DMA3_BASE +6*0x58)
#define DMA3_CH7_BASE                 ( DMA3_BASE +7*0x58)

/** MDMA channel register base address: 0x0100 + 0x100 * n (n = 0 to 15) **/
#define MDMA_CH0_BASE                 ( MDMA_BASE +1*0x100)
#define MDMA_CH1_BASE                 ( MDMA_BASE +2*0x100)
#define MDMA_CH2_BASE                 ( MDMA_BASE +3*0x100)
#define MDMA_CH3_BASE                 ( MDMA_BASE +4*0x100)
#define MDMA_CH4_BASE                 ( MDMA_BASE +5*0x100)
#define MDMA_CH5_BASE                 ( MDMA_BASE +6*0x100)
#define MDMA_CH6_BASE                 ( MDMA_BASE +7*0x100)
#define MDMA_CH7_BASE                 ( MDMA_BASE +8*0x100)
#define MDMA_CH8_BASE                 ( MDMA_BASE +9*0x100)
#define MDMA_CH9_BASE                 ( MDMA_BASE +10*0x100)
#define MDMA_CH10_BASE                ( MDMA_BASE +11*0x100)
#define MDMA_CH11_BASE                ( MDMA_BASE +12*0x100)
#define MDMA_CH12_BASE                ( MDMA_BASE +13*0x100)
#define MDMA_CH13_BASE                ( MDMA_BASE +14*0x100)
#define MDMA_CH14_BASE                ( MDMA_BASE +15*0x100)
#define MDMA_CH15_BASE                ( MDMA_BASE +16*0x100)


//somema TBD
#define DMAMUX1_Channel0_BASE    (DMAMUX1_BASE + 0x0000UL)
#define DMAMUX1_Channel1_BASE    (DMAMUX1_BASE + 0x0004UL)
#define DMAMUX1_Channel2_BASE    (DMAMUX1_BASE + 0x0008UL)
#define DMAMUX1_Channel3_BASE    (DMAMUX1_BASE + 0x000CUL)
#define DMAMUX1_Channel4_BASE    (DMAMUX1_BASE + 0x0010UL)
#define DMAMUX1_Channel5_BASE    (DMAMUX1_BASE + 0x0014UL)
#define DMAMUX1_Channel6_BASE    (DMAMUX1_BASE + 0x0018UL)
#define DMAMUX1_Channel7_BASE    (DMAMUX1_BASE + 0x001CUL)
#define DMAMUX1_Channel8_BASE    (DMAMUX1_BASE + 0x0020UL)
#define DMAMUX1_Channel9_BASE    (DMAMUX1_BASE + 0x0024UL)
#define DMAMUX1_Channel10_BASE   (DMAMUX1_BASE + 0x0028UL)
#define DMAMUX1_Channel11_BASE   (DMAMUX1_BASE + 0x002CUL)
#define DMAMUX1_Channel12_BASE   (DMAMUX1_BASE + 0x0030UL)
#define DMAMUX1_Channel13_BASE   (DMAMUX1_BASE + 0x0034UL)
#define DMAMUX1_Channel14_BASE   (DMAMUX1_BASE + 0x0038UL)
#define DMAMUX1_Channel15_BASE   (DMAMUX1_BASE + 0x003CUL)
#define DMAMUX1_Channel16_BASE   (DMAMUX1_BASE + 0x0040UL)
#define DMAMUX1_Channel17_BASE   (DMAMUX1_BASE + 0x0044UL)
#define DMAMUX1_Channel18_BASE   (DMAMUX1_BASE + 0x0048UL)
#define DMAMUX1_Channel19_BASE   (DMAMUX1_BASE + 0x004CUL)
#define DMAMUX1_Channel20_BASE   (DMAMUX1_BASE + 0x0050UL)
#define DMAMUX1_Channel21_BASE   (DMAMUX1_BASE + 0x0044UL)
#define DMAMUX1_Channel22_BASE   (DMAMUX1_BASE + 0x0058UL)
#define DMAMUX1_Channel23_BASE   (DMAMUX1_BASE + 0x005CUL)

#define DMAMUX1_RequestGenerator0_BASE   (DMAMUX1_BASE + 0x0100UL)
#define DMAMUX1_RequestGenerator1_BASE   (DMAMUX1_BASE + 0x0104UL)
#define DMAMUX1_RequestGenerator2_BASE   (DMAMUX1_BASE + 0x0108UL)
#define DMAMUX1_RequestGenerator3_BASE   (DMAMUX1_BASE + 0x010CUL)
#define DMAMUX1_RequestGenerator4_BASE   (DMAMUX1_BASE + 0x0110UL)
#define DMAMUX1_RequestGenerator5_BASE   (DMAMUX1_BASE + 0x0114UL)
#define DMAMUX1_RequestGenerator6_BASE   (DMAMUX1_BASE + 0x0118UL)
#define DMAMUX1_RequestGenerator7_BASE   (DMAMUX1_BASE + 0x011CUL)
#define DMAMUX1_RequestGenerator8_BASE   (DMAMUX1_BASE + 0x0120UL)
#define DMAMUX1_RequestGenerator9_BASE   (DMAMUX1_BASE + 0x0124UL)
#define DMAMUX1_RequestGenerator10_BASE  (DMAMUX1_BASE + 0x0128UL)
#define DMAMUX1_RequestGenerator11_BASE  (DMAMUX1_BASE + 0x012CUL)
#define DMAMUX1_RequestGenerator12_BASE  (DMAMUX1_BASE + 0x0130UL)
#define DMAMUX1_RequestGenerator13_BASE  (DMAMUX1_BASE + 0x0134UL)
#define DMAMUX1_RequestGenerator14_BASE  (DMAMUX1_BASE + 0x0138UL)
#define DMAMUX1_RequestGenerator15_BASE  (DMAMUX1_BASE + 0x013CUL)
#define DMAMUX1_RequestGenerator16_BASE  (DMAMUX1_BASE + 0x0140UL)
#define DMAMUX1_RequestGenerator17_BASE  (DMAMUX1_BASE + 0x0144UL)
#define DMAMUX1_RequestGenerator18_BASE  (DMAMUX1_BASE + 0x0148UL)
#define DMAMUX1_RequestGenerator19_BASE  (DMAMUX1_BASE + 0x014CUL)
#define DMAMUX1_RequestGenerator20_BASE  (DMAMUX1_BASE + 0x0150UL)
#define DMAMUX1_RequestGenerator21_BASE  (DMAMUX1_BASE + 0x0154UL)
#define DMAMUX1_RequestGenerator22_BASE  (DMAMUX1_BASE + 0x0158UL)
#define DMAMUX1_RequestGenerator23_BASE  (DMAMUX1_BASE + 0x015CUL)

//somema TBD
#define DMAMUX1_ChannelStatus_BASE      (DMAMUX1_BASE + 0x0080UL)
#define DMAMUX1_RequestGenStatus_BASE   (DMAMUX1_BASE + 0x0140UL)

//somema TBD
#define DMAMUX1_RGISR_BASE               (DMAMUX1_BASE + 0x0180UL)
#define DMAMUX1_RGICF_BASE               (DMAMUX1_BASE + 0x0184UL)

#define DMAMUX_MDMA_RequestGenerator0_BASE   (DMAMUX_MDMA_BASE + 0x0100UL)
#define DMAMUX_MDMA_RequestGenerator1_BASE   (DMAMUX_MDMA_BASE + 0x0104UL)
#define DMAMUX_MDMA_RequestGenerator2_BASE   (DMAMUX_MDMA_BASE + 0x0108UL)
#define DMAMUX_MDMA_RequestGenerator3_BASE   (DMAMUX_MDMA_BASE + 0x010CUL)
#define DMAMUX_MDMA_RequestGenerator4_BASE   (DMAMUX_MDMA_BASE + 0x0110UL)
#define DMAMUX_MDMA_RequestGenerator5_BASE   (DMAMUX_MDMA_BASE + 0x0114UL)
#define DMAMUX_MDMA_RequestGenerator6_BASE   (DMAMUX_MDMA_BASE + 0x0118UL)
#define DMAMUX_MDMA_RequestGenerator7_BASE   (DMAMUX_MDMA_BASE + 0x011CUL)
//somema, TBD to confirm that MDMA only support 8 channel request generator
// #define DMAMUX_MDMA_RequestGenerator8_BASE   (DMAMUX_MDMA_BASE + 0x0120UL)
// #define DMAMUX_MDMA_RequestGenerator9_BASE   (DMAMUX_MDMA_BASE + 0x0124UL)
// #define DMAMUX_MDMA_RequestGenerator10_BASE  (DMAMUX_MDMA_BASE + 0x0128UL)
// #define DMAMUX_MDMA_RequestGenerator11_BASE  (DMAMUX_MDMA_BASE + 0x012CUL)
// #define DMAMUX_MDMA_RequestGenerator12_BASE  (DMAMUX_MDMA_BASE + 0x0130UL)
// #define DMAMUX_MDMA_RequestGenerator13_BASE  (DMAMUX_MDMA_BASE + 0x0134UL)
// #define DMAMUX_MDMA_RequestGenerator14_BASE  (DMAMUX_MDMA_BASE + 0x0138UL)
// #define DMAMUX_MDMA_RequestGenerator15_BASE  (DMAMUX_MDMA_BASE + 0x013CUL)
// #define DMAMUX_MDMA_RequestGenerator16_BASE  (DMAMUX_MDMA_BASE + 0x0140UL)
// #define DMAMUX_MDMA_RequestGenerator17_BASE  (DMAMUX_MDMA_BASE + 0x0144UL)
// #define DMAMUX_MDMA_RequestGenerator18_BASE  (DMAMUX_MDMA_BASE + 0x0148UL)
// #define DMAMUX_MDMA_RequestGenerator19_BASE  (DMAMUX_MDMA_BASE + 0x014CUL)
// #define DMAMUX_MDMA_RequestGenerator20_BASE  (DMAMUX_MDMA_BASE + 0x0150UL)
// #define DMAMUX_MDMA_RequestGenerator21_BASE  (DMAMUX_MDMA_BASE + 0x0154UL)
// #define DMAMUX_MDMA_RequestGenerator22_BASE  (DMAMUX_MDMA_BASE + 0x0158UL)
// #define DMAMUX_MDMA_RequestGenerator23_BASE  (DMAMUX_MDMA_BASE + 0x015CUL)

#define DMAMUX_MDMA_RGISR_BASE               (DMAMUX_MDMA_BASE + 0x0180UL)
#define DMAMUX_MDMA_RGICF_BASE               (DMAMUX_MDMA_BASE + 0x0184UL)

#if defined(CORE_CM7)
#define DCMU_BASE           ((DCMU_Module *) (DCMUA_CM7_BASE))
#else  /* CORE_CM4 */
#define DCMU_BASE           ((DCMU_Module *) (DCMUB_CM4_BASE))
#endif /* CORE_CM7 */


//#define JPEG IPs here
//#define GPU here






#define BTIM4                 ((TIM_Module *) BTIM4_BASE)
#define BTIM3                 ((TIM_Module *) BTIM3_BASE)
#define MMU                   ((MMU_Module *) MMU_BASE)
#define WWDG2                 ((WWDG_Module *) WWDG2_BASE)
#define DAC12                 ((DAC_Module *) DAC12_BASE)
#define DAC34                 ((DAC_Module *) DAC34_BASE)
#define DAC56                 ((DAC_Module *) DAC56_BASE)
#define I2S4_EXT              ((I2S_EXT_Module *) I2S4EXT_BASE)
#define I2S3_EXT              ((I2S_EXT_Module *) I2S3EXT_BASE)
#define I2S4                  ((I2S_Module *) I2S4_BASE)
#define I2S3                  ((I2S_Module *) I2S3_BASE)
#define I2C3                  ((I2C_Module *) I2C3_BASE)
#define I2C2                  ((I2C_Module *) I2C2_BASE)
#define I2C1                  ((I2C_Module *) I2C1_BASE)
#define SPI3                  ((SPI_Module *) SPI3_BASE)
#define UART12                ((USART_Module *) UART12_BASE)
#define UART11                ((USART_Module *) UART11_BASE)
#define UART10                ((USART_Module *) UART10_BASE)
#define UART9                 ((USART_Module *) UART9_BASE)
#define USART4                ((USART_Module *) USART4_BASE)
#define USART3                ((USART_Module *) USART3_BASE)
#define USART2                ((USART_Module *) USART2_BASE)
#define USART1                ((USART_Module *) USART1_BASE)
#define GTIMA7                ((TIM_Module *) GTIMA7_BASE)
#define GTIMA6                ((TIM_Module *) GTIMA6_BASE)
#define GTIMA5                ((TIM_Module *) GTIMA5_BASE)
#define GTIMA4                ((TIM_Module *) GTIMA4_BASE)
#define GTIMA3                ((TIM_Module *) GTIMA3_BASE)
#define GTIMA2                ((TIM_Module *) GTIMA2_BASE)
#define GTIMA1                ((TIM_Module *) GTIMA1_BASE)
#define BTIM2                 ((TIM_Module *) BTIM2_BASE)
#define BTIM1                 ((TIM_Module *) BTIM1_BASE)
#define FDCAN6                ((FDCAN_Module *) FDCAN6_BASE)
#define FDCAN5                ((FDCAN_Module *) FDCAN5_BASE)
#define FDCAN2                ((FDCAN_Module *) FDCAN2_BASE)
#define FDCAN1                ((FDCAN_Module *) FDCAN1_BASE)

#define UART15                ((USART_Module *) UART15_BASE)
#define UART14                ((USART_Module *) UART14_BASE)
#define UART13                ((USART_Module *) UART13_BASE)
#define USART8                ((USART_Module *) USART8_BASE)
#define USART7                ((USART_Module *) USART7_BASE)
#define USART6                ((USART_Module *) USART6_BASE)
#define USART5                ((USART_Module *) USART5_BASE)
#define I2C6                  ((I2C_Module *) I2C6_BASE)
#define I2C5                  ((I2C_Module *) I2C5_BASE)
#define I2C4                  ((I2C_Module *) I2C4_BASE)
#define GTIMB1                ((TIM_Module *) GTIMB1_BASE)
#define GTIMB2                ((TIM_Module *) GTIMB2_BASE)
#define GTIMB3                ((TIM_Module *) GTIMB3_BASE)
#define SPI2                  ((SPI_Module *) SPI2_BASE)
#define SPI1                  ((SPI_Module *) SPI1_BASE)
#define I2S2                  ((I2S_Module *) I2S2_BASE)
#define I2S1                  ((I2S_Module *) I2S1_BASE)
#define I2S2_EXT              ((I2S_EXT_Module *) I2S2EXT_BASE)
#define I2S1_EXT              ((I2S_EXT_Module *) I2S1EXT_BASE)
#define ATIM4                 ((TIM_Module *) ATIM4_BASE)
#define ATIM3                 ((TIM_Module *) ATIM3_BASE)
#define ATIM2                 ((TIM_Module *) ATIM2_BASE)
#define ATIM1                 ((TIM_Module *) ATIM1_BASE)
#define DSMU                  ((DSMU_TypeDef *) DSMU_BASE)
#define SHRTIM2               ((SHRTIM_Module *) SHRTIM2_BASE)
#define SHRTIM1               ((SHRTIM_Module *) SHRTIM1_BASE)
#define FDCAN8                ((FDCAN_Module *) FDCAN8_BASE)
#define FDCAN7                ((FDCAN_Module *) FDCAN7_BASE)
#define FDCAN4                ((FDCAN_Module *) FDCAN4_BASE)
#define FDCAN3                ((FDCAN_Module *) FDCAN3_BASE)

#define RTC                   ((RTC_Module *) RTC_BASE)
#define IWDG2                 ((IWDG_Module *) IWDG2_BASE)
#define IWDG1                 ((IWDG_Module *) IWDG1_BASE)
#define COMP                  ((COMP_Module *) COMP_BASE)
#define ATIMER4               ((ATIMER_TypeDef *) ATIMER4_BASE)
#define ATIMER3               ((ATIMER_TypeDef *) ATIMER3_BASE)
#define I2C10                 ((I2C_Module *) I2C10_BASE)
#define I2C9                  ((I2C_Module *) I2C9_BASE)
#define I2C8                  ((I2C_Module *) I2C8_BASE)
#define I2C7                  ((I2C_Module *) I2C7_BASE)
#define SPI7                  ((SPI_Module *) SPI7_BASE)
#define SPI6                  ((SPI_Module *) SPI6_BASE)
#define SPI5                  ((SPI_Module *) SPI5_BASE)
#define SPI4                  ((SPI_Module *) SPI4_BASE)
#define LPTIM5                ((LPTIM_Module *) LPTIM5_BASE)
#define LPTIM4                ((LPTIM_Module *) LPTIM4_BASE)
#define LPTIM3                ((LPTIM_Module *) LPTIM3_BASE)
#define LPTIM2                ((LPTIM_Module *) LPTIM2_BASE)
#define LPTIM1                ((LPTIM_Module *) LPTIM1_BASE)
#define LPUART2               ((LPUART_Module *) LPUART2_BASE)
#define LPUART1               ((LPUART_Module *) LPUART1_BASE)
#define AFEC                  ((AFEC_TypeDef *) AFEC_BASE)
#define EXTI                  ((EXTI_Module *) EXTI_BASE)

#define JPEG_SGDMA_P2H        ((JPEG_SGDMA_P2H_TypeDef *) JPEG_SGDMA_P2H_BASE)
#define JPEG_BRC              ((JPEG_BRC_TypeDef *) JPEG_BRC_BASE)
#define JPEG_DEC              ((JPEG_DEC_TypeDef *) JPEG_DEC_BASE)
#define JPEG_SGDMA_H2P        ((JPEG_SGDMA_H2P_TypeDef *) JPEG_SGDMA_H2P_BASE)
#define JPEG_RBC              ((JPEG_RBC_TypeDef *) JPEG_RBC_BASE)
#define JPEG_ENC              ((JPEG_ENC_TypeDef *) JPEG_ENC_BASE)
#define FEMC                  ((FEMC_Module *) FEMC_BASE)
#define TCMSRAMC              ((TCMSRAMC_TypeDef *) TCMSRAMC_BASE)
#define WWDG1                 ((WWDG_Module *) WWDG1_BASE)
#define LCDC                  ((LCDC_Module *) LCDC_BASE)
#define LCDC_Layer1           ((LCDC_Layer_Module *)LCDC_Layer1_BASE)
#define LCDC_Layer2           ((LCDC_Layer_Module *)LCDC_Layer2_BASE)
#define LCDC_Layer3           ((LCDC_Layer_Module *)LCDC_Layer3_BASE)
#define LCDC_Layer4           ((LCDC_Layer_Module *)LCDC_Layer4_BASE)
#define DVP2                  ((DVP_Module *) DVP2_BASE)
#define DVP1                  ((DVP_Module *) DVP1_BASE)
#define OTPC                  ((OTPC_Module *) OTPC_BASE)
#define GPU                   ((GPU_TypeDef *) GPU_BASE)
#define DSI_HOST              ((DSI_HOST_TypeDef *) DSI_HOST_BASE)

#define SDMMC2                ((SDMMC_Module *) SDMMC2_BASE)
#define SDHOST2               ((SDHOST_Module *) SDHOST2_BASE)
#define USB2OTG_HS            ((USBOTG_HS_TypeDef *) USB2OTG_HS_BASE)
#define USB1OTG_HS            ((USBOTG_HS_TypeDef *) USBOTG_HS_BASE)
#define DMA3                  ((DMA_Module *) DMA3_BASE)
#define DMA3_CH0              ((DMA_ChannelType *) DMA3_CH0_BASE)
#define DMA3_CH1              ((DMA_ChannelType *) DMA3_CH1_BASE)
#define DMA3_CH2              ((DMA_ChannelType *) DMA3_CH2_BASE)
#define DMA3_CH3              ((DMA_ChannelType *) DMA3_CH3_BASE)
#define DMA3_CH4              ((DMA_ChannelType *) DMA3_CH4_BASE)
#define DMA3_CH5              ((DMA_ChannelType *) DMA3_CH5_BASE)
#define DMA3_CH6              ((DMA_ChannelType *) DMA3_CH6_BASE)
#define DMA3_CH7              ((DMA_ChannelType *) DMA3_CH7_BASE)

#define DMA2                  ((DMA_Module *) DMA2_BASE)
#define DMA2_CH0              ((DMA_ChannelType *) DMA2_CH0_BASE)
#define DMA2_CH1              ((DMA_ChannelType *) DMA2_CH1_BASE)
#define DMA2_CH2              ((DMA_ChannelType *) DMA2_CH2_BASE)
#define DMA2_CH3              ((DMA_ChannelType *) DMA2_CH3_BASE)
#define DMA2_CH4              ((DMA_ChannelType *) DMA2_CH4_BASE)
#define DMA2_CH5              ((DMA_ChannelType *) DMA2_CH5_BASE)
#define DMA2_CH6              ((DMA_ChannelType *) DMA2_CH6_BASE)
#define DMA2_CH7              ((DMA_ChannelType *) DMA2_CH7_BASE)
#define DMA1                  ((DMA_Module *) DMA1_BASE)

#define DMA1_CH0              ((DMA_ChannelType *) DMA1_CH0_BASE)
#define DMA1_CH1              ((DMA_ChannelType *) DMA1_CH1_BASE)
#define DMA1_CH2              ((DMA_ChannelType *) DMA1_CH2_BASE)
#define DMA1_CH3              ((DMA_ChannelType *) DMA1_CH3_BASE)
#define DMA1_CH4              ((DMA_ChannelType *) DMA1_CH4_BASE)
#define DMA1_CH5              ((DMA_ChannelType *) DMA1_CH5_BASE)
#define DMA1_CH6              ((DMA_ChannelType *) DMA1_CH6_BASE)
#define DMA1_CH7              ((DMA_ChannelType *) DMA1_CH7_BASE)
#define DMAMUX1             ((DMAMUX1_Module *) DMAMUX1_BASE)
#define ADC1                ((ADC_Module *) ADC1_BASE)
#define ADC2                ((ADC_Module *) ADC2_BASE)
#define ADC3                ((ADC_Module *) ADC3_BASE)
#define ETH1                ((ETH_Module *) ETH1_BASE)
#define ETH2                ((ETH_Module *) ETH2_BASE)


//#define DCMUB_CM4             ((DCMUB_CM4_TypeDef *) DCMUB_CM4_BASE)
//#define DCMUA_CM7             ((DCMUA_CM7_TypeDef *) DCMUA_CM7_BASE)
#define DCMU                ((DCMU_Module *) DCMU_BASE)

#define SEMA4                 ((SEMA4_Module *) SEMA4_BASE)
#define CUSTOM                ((CUSTOM_TypeDef *) CUSTOM_BASE)
#define SDPU                  ((SDPU_TypeDef *) SDPU_BASE)
#define FMAC                  ((FMAC_Module *) FMAC_BASE)
#define CORDIC                ((CORDIC_Module *) CORDIC_BASE)
#define ECCMON2               ((ECCMON_TypeDef *) ECCMON2_BASE)

#define ECCMON3               ((ECCMON_TypeDef *) ECCMON3_BASE)
#define GPIOK                 ((GPIO_Module *) GPIOK_BASE)
#define GPIOJ                 ((GPIO_Module *) GPIOJ_BASE)
#define GPIOI                 ((GPIO_Module *) GPIOI_BASE)
#define GPIOH                 ((GPIO_Module *) GPIOH_BASE)
#define GPIOG                 ((GPIO_Module *) GPIOG_BASE)
#define GPIOF                 ((GPIO_Module *) GPIOF_BASE)
#define GPIOE                 ((GPIO_Module *) GPIOE_BASE)
#define GPIOD                 ((GPIO_Module *) GPIOD_BASE)
#define GPIOC                 ((GPIO_Module *) GPIOC_BASE)
#define GPIOB                 ((GPIO_Module *) GPIOB_BASE)
#define GPIOA                 ((GPIO_Module *) GPIOA_BASE)
#define AFIO                  ((AFIO_Module *) AFIO_BASE)
#define CRC                   ((CRC_Module *) CRC_BASE)
#define PWR                   ((PWR_Module *) PWR_BASE)
#define RCC                   ((RCC_Module *) RCC_BASE)

#define SDRAM                      ((SDRAM_Module*)SDRAM_BASE)
#define DMAMUX_MDMA           ((DMAMUX2_Module *) DMAMUX_MDMA_BASE)
#define SDMMC1                ((SDMMC_Module *) SDMMC1_BASE)
#define SDHOST1               ((SDHOST_Module *) SDHOST1_BASE)
#define ECCMON1P1          	  ((ECCMON_TypeDef *) ECCMON1P1_BASE)
#define ECCMON1P2             ((ECCMON_TypeDef *) ECCMON1P2_BASE)
#define ECCMON1P3             ((ECCMON_TypeDef *) ECCMON1P3_BASE)
#define ECCMON1P4             ((ECCMON_TypeDef *) ECCMON1P4_BASE)
#define MDMA                  ((MDMA_Module *) MDMA_BASE)
#define xSPI2                 ((XSPI_Module *) xSPI2_BASE)
#define xSPI1                 ((XSPI_Module *) xSPI1_BASE)
#define GPV                   ((GPV_TypeDef *) GPV_BASE  )

#define DBG                   ((DBG_Module *) DBGMCU_BASE)

#define DSMU_Channel0         ((DSMU_Channel_Submodule *) DSMU_Channel0_BASE)
#define DSMU_Channel1         ((DSMU_Channel_Submodule *) DSMU_Channel1_BASE)
#define DSMU_Channel2         ((DSMU_Channel_Submodule *) DSMU_Channel2_BASE)
#define DSMU_Channel3         ((DSMU_Channel_Submodule *) DSMU_Channel3_BASE)
#define DSMU_Channel4         ((DSMU_Channel_Submodule *) DSMU_Channel4_BASE)
#define DSMU_Channel5         ((DSMU_Channel_Submodule *) DSMU_Channel5_BASE)
#define DSMU_Channel6         ((DSMU_Channel_Submodule *) DSMU_Channel6_BASE)
#define DSMU_Channel7         ((DSMU_Channel_Submodule *) DSMU_Channel7_BASE)
#define DSMU_Filter0          ((DSMU_Filter_Submodule *) DSMU_Filter0_BASE)
#define DSMU_Filter1          ((DSMU_Filter_Submodule *) DSMU_Filter1_BASE)
#define DSMU_Filter2          ((DSMU_Filter_Submodule *) DSMU_Filter2_BASE)
#define DSMU_Filter3          ((DSMU_Filter_Submodule *) DSMU_Filter3_BASE)

/*** SystemTick ***/

/** Bit definition for SysTick_CTRL register **/
#define SysTick_CTRL_ENABLE    ((uint32_t)0x00000001U) /* Counter enable */
#define SysTick_CTRL_TICKINT   ((uint32_t)0x00000002U) /* Counting down to 0 pends the SysTick handler */
#define SysTick_CTRL_CLKSOURCE ((uint32_t)0x00000004U) /* Clock source */
#define SysTick_CTRL_COUNTFLAG ((uint32_t)0x00010000U) /* Count Flag */

/** Bit definition for SysTick_LOAD register **/
#define SysTick_LOAD_RELOAD ((uint32_t)0x00FFFFFFU) /* Value to load into the SysTick Current Value Register when the counter reaches 0 */
/** Bit definition for SysTick_VAL register **/
#define SysTick_VAL_CURRENT ((uint32_t)0x00FFFFFFU) /* Current value at the time the register is accessed */

/** Bit definition for SysTick_CALIB register **/
#define SysTick_CALIB_TENMS ((uint32_t)0x00FFFFFFU) /* Reload value to use for 10ms timing */
#define SysTick_CALIB_SKEW  ((uint32_t)0x40000000U) /* Calibration value is not exactly 10 ms */
#define SysTick_CALIB_NOREF ((uint32_t)0x80000000U) /* The reference clock is not provided */

/*** Nested Vectored Interrupt Controller ***/

/** Bit definition for NVIC_ISER register **/
#define NVIC_ISER_SETENA    ((uint32_t)0xFFFFFFFFU) /* Interrupt set enable bits */
#define NVIC_ISER_SETENA_0  ((uint32_t)0x00000001U) /* bit 0 */
#define NVIC_ISER_SETENA_1  ((uint32_t)0x00000002U) /* bit 1 */
#define NVIC_ISER_SETENA_2  ((uint32_t)0x00000004U) /* bit 2 */
#define NVIC_ISER_SETENA_3  ((uint32_t)0x00000008U) /* bit 3 */
#define NVIC_ISER_SETENA_4  ((uint32_t)0x00000010U) /* bit 4 */
#define NVIC_ISER_SETENA_5  ((uint32_t)0x00000020U) /* bit 5 */
#define NVIC_ISER_SETENA_6  ((uint32_t)0x00000040U) /* bit 6 */
#define NVIC_ISER_SETENA_7  ((uint32_t)0x00000080U) /* bit 7 */
#define NVIC_ISER_SETENA_8  ((uint32_t)0x00000100U) /* bit 8 */
#define NVIC_ISER_SETENA_9  ((uint32_t)0x00000200U) /* bit 9 */
#define NVIC_ISER_SETENA_10 ((uint32_t)0x00000400U) /* bit 10 */
#define NVIC_ISER_SETENA_11 ((uint32_t)0x00000800U) /* bit 11 */
#define NVIC_ISER_SETENA_12 ((uint32_t)0x00001000U) /* bit 12 */
#define NVIC_ISER_SETENA_13 ((uint32_t)0x00002000U) /* bit 13 */
#define NVIC_ISER_SETENA_14 ((uint32_t)0x00004000U) /* bit 14 */
#define NVIC_ISER_SETENA_15 ((uint32_t)0x00008000U) /* bit 15 */
#define NVIC_ISER_SETENA_16 ((uint32_t)0x00010000U) /* bit 16 */
#define NVIC_ISER_SETENA_17 ((uint32_t)0x00020000U) /* bit 17 */
#define NVIC_ISER_SETENA_18 ((uint32_t)0x00040000U) /* bit 18 */
#define NVIC_ISER_SETENA_19 ((uint32_t)0x00080000U) /* bit 19 */
#define NVIC_ISER_SETENA_20 ((uint32_t)0x00100000U) /* bit 20 */
#define NVIC_ISER_SETENA_21 ((uint32_t)0x00200000U) /* bit 21 */
#define NVIC_ISER_SETENA_22 ((uint32_t)0x00400000U) /* bit 22 */
#define NVIC_ISER_SETENA_23 ((uint32_t)0x00800000U) /* bit 23 */
#define NVIC_ISER_SETENA_24 ((uint32_t)0x01000000U) /* bit 24 */
#define NVIC_ISER_SETENA_25 ((uint32_t)0x02000000U) /* bit 25 */
#define NVIC_ISER_SETENA_26 ((uint32_t)0x04000000U) /* bit 26 */
#define NVIC_ISER_SETENA_27 ((uint32_t)0x08000000U) /* bit 27 */
#define NVIC_ISER_SETENA_28 ((uint32_t)0x10000000U) /* bit 28 */
#define NVIC_ISER_SETENA_29 ((uint32_t)0x20000000U) /* bit 29 */
#define NVIC_ISER_SETENA_30 ((uint32_t)0x40000000U) /* bit 30 */
#define NVIC_ISER_SETENA_31 ((uint32_t)0x80000000U) /* bit 31 */

/** Bit definition for NVIC_ICER register ***/
#define NVIC_ICER_CLRENA    ((uint32_t)0xFFFFFFFFU) /* Interrupt clear-enable bits */
#define NVIC_ICER_CLRENA_0  ((uint32_t)0x00000001U) /* bit 0 */
#define NVIC_ICER_CLRENA_1  ((uint32_t)0x00000002U) /* bit 1 */
#define NVIC_ICER_CLRENA_2  ((uint32_t)0x00000004U) /* bit 2 */
#define NVIC_ICER_CLRENA_3  ((uint32_t)0x00000008U) /* bit 3 */
#define NVIC_ICER_CLRENA_4  ((uint32_t)0x00000010U) /* bit 4 */
#define NVIC_ICER_CLRENA_5  ((uint32_t)0x00000020U) /* bit 5 */
#define NVIC_ICER_CLRENA_6  ((uint32_t)0x00000040U) /* bit 6 */
#define NVIC_ICER_CLRENA_7  ((uint32_t)0x00000080U) /* bit 7 */
#define NVIC_ICER_CLRENA_8  ((uint32_t)0x00000100U) /* bit 8 */
#define NVIC_ICER_CLRENA_9  ((uint32_t)0x00000200U) /* bit 9 */
#define NVIC_ICER_CLRENA_10 ((uint32_t)0x00000400U) /* bit 10 */
#define NVIC_ICER_CLRENA_11 ((uint32_t)0x00000800U) /* bit 11 */
#define NVIC_ICER_CLRENA_12 ((uint32_t)0x00001000U) /* bit 12 */
#define NVIC_ICER_CLRENA_13 ((uint32_t)0x00002000U) /* bit 13 */
#define NVIC_ICER_CLRENA_14 ((uint32_t)0x00004000U) /* bit 14 */
#define NVIC_ICER_CLRENA_15 ((uint32_t)0x00008000U) /* bit 15 */
#define NVIC_ICER_CLRENA_16 ((uint32_t)0x00010000U) /* bit 16 */
#define NVIC_ICER_CLRENA_17 ((uint32_t)0x00020000U) /* bit 17 */
#define NVIC_ICER_CLRENA_18 ((uint32_t)0x00040000U) /* bit 18 */
#define NVIC_ICER_CLRENA_19 ((uint32_t)0x00080000U) /* bit 19 */
#define NVIC_ICER_CLRENA_20 ((uint32_t)0x00100000U) /* bit 20 */
#define NVIC_ICER_CLRENA_21 ((uint32_t)0x00200000U) /* bit 21 */
#define NVIC_ICER_CLRENA_22 ((uint32_t)0x00400000U) /* bit 22 */
#define NVIC_ICER_CLRENA_23 ((uint32_t)0x00800000U) /* bit 23 */
#define NVIC_ICER_CLRENA_24 ((uint32_t)0x01000000U) /* bit 24 */
#define NVIC_ICER_CLRENA_25 ((uint32_t)0x02000000U) /* bit 25 */
#define NVIC_ICER_CLRENA_26 ((uint32_t)0x04000000U) /* bit 26 */
#define NVIC_ICER_CLRENA_27 ((uint32_t)0x08000000U) /* bit 27 */
#define NVIC_ICER_CLRENA_28 ((uint32_t)0x10000000U) /* bit 28 */
#define NVIC_ICER_CLRENA_29 ((uint32_t)0x20000000U) /* bit 29 */
#define NVIC_ICER_CLRENA_30 ((uint32_t)0x40000000U) /* bit 30 */
#define NVIC_ICER_CLRENA_31 ((uint32_t)0x80000000U) /* bit 31 */

/** Bit definition for NVIC_ISPR register **/
#define NVIC_ISPR_SETPEND    ((uint32_t)0xFFFFFFFFU) /* Interrupt set-pending bits */
#define NVIC_ISPR_SETPEND_0  ((uint32_t)0x00000001U) /* bit 0 */
#define NVIC_ISPR_SETPEND_1  ((uint32_t)0x00000002U) /* bit 1 */
#define NVIC_ISPR_SETPEND_2  ((uint32_t)0x00000004U) /* bit 2 */
#define NVIC_ISPR_SETPEND_3  ((uint32_t)0x00000008U) /* bit 3 */
#define NVIC_ISPR_SETPEND_4  ((uint32_t)0x00000010U) /* bit 4 */
#define NVIC_ISPR_SETPEND_5  ((uint32_t)0x00000020U) /* bit 5 */
#define NVIC_ISPR_SETPEND_6  ((uint32_t)0x00000040U) /* bit 6 */
#define NVIC_ISPR_SETPEND_7  ((uint32_t)0x00000080U) /* bit 7 */
#define NVIC_ISPR_SETPEND_8  ((uint32_t)0x00000100U) /* bit 8 */
#define NVIC_ISPR_SETPEND_9  ((uint32_t)0x00000200U) /* bit 9 */
#define NVIC_ISPR_SETPEND_10 ((uint32_t)0x00000400U) /* bit 10 */
#define NVIC_ISPR_SETPEND_11 ((uint32_t)0x00000800U) /* bit 11 */
#define NVIC_ISPR_SETPEND_12 ((uint32_t)0x00001000U) /* bit 12 */
#define NVIC_ISPR_SETPEND_13 ((uint32_t)0x00002000U) /* bit 13 */
#define NVIC_ISPR_SETPEND_14 ((uint32_t)0x00004000U) /* bit 14 */
#define NVIC_ISPR_SETPEND_15 ((uint32_t)0x00008000U) /* bit 15 */
#define NVIC_ISPR_SETPEND_16 ((uint32_t)0x00010000U) /* bit 16 */
#define NVIC_ISPR_SETPEND_17 ((uint32_t)0x00020000U) /* bit 17 */
#define NVIC_ISPR_SETPEND_18 ((uint32_t)0x00040000U) /* bit 18 */
#define NVIC_ISPR_SETPEND_19 ((uint32_t)0x00080000U) /* bit 19 */
#define NVIC_ISPR_SETPEND_20 ((uint32_t)0x00100000U) /* bit 20 */
#define NVIC_ISPR_SETPEND_21 ((uint32_t)0x00200000U) /* bit 21 */
#define NVIC_ISPR_SETPEND_22 ((uint32_t)0x00400000U) /* bit 22 */
#define NVIC_ISPR_SETPEND_23 ((uint32_t)0x00800000U) /* bit 23 */
#define NVIC_ISPR_SETPEND_24 ((uint32_t)0x01000000U) /* bit 24 */
#define NVIC_ISPR_SETPEND_25 ((uint32_t)0x02000000U) /* bit 25 */
#define NVIC_ISPR_SETPEND_26 ((uint32_t)0x04000000U) /* bit 26 */
#define NVIC_ISPR_SETPEND_27 ((uint32_t)0x08000000U) /* bit 27 */
#define NVIC_ISPR_SETPEND_28 ((uint32_t)0x10000000U) /* bit 28 */
#define NVIC_ISPR_SETPEND_29 ((uint32_t)0x20000000U) /* bit 29 */
#define NVIC_ISPR_SETPEND_30 ((uint32_t)0x40000000U) /* bit 30 */
#define NVIC_ISPR_SETPEND_31 ((uint32_t)0x80000000U) /* bit 31 */

/** Bit definition for NVIC_ICPR register **/
#define NVIC_ICPR_CLRPEND    ((uint32_t)0xFFFFFFFFU) /* Interrupt clear-pending bits */
#define NVIC_ICPR_CLRPEND_0  ((uint32_t)0x00000001U) /* bit 0 */
#define NVIC_ICPR_CLRPEND_1  ((uint32_t)0x00000002U) /* bit 1 */
#define NVIC_ICPR_CLRPEND_2  ((uint32_t)0x00000004U) /* bit 2 */
#define NVIC_ICPR_CLRPEND_3  ((uint32_t)0x00000008U) /* bit 3 */
#define NVIC_ICPR_CLRPEND_4  ((uint32_t)0x00000010U) /* bit 4 */
#define NVIC_ICPR_CLRPEND_5  ((uint32_t)0x00000020U) /* bit 5 */
#define NVIC_ICPR_CLRPEND_6  ((uint32_t)0x00000040U) /* bit 6 */
#define NVIC_ICPR_CLRPEND_7  ((uint32_t)0x00000080U) /* bit 7 */
#define NVIC_ICPR_CLRPEND_8  ((uint32_t)0x00000100U) /* bit 8 */
#define NVIC_ICPR_CLRPEND_9  ((uint32_t)0x00000200U) /* bit 9 */
#define NVIC_ICPR_CLRPEND_10 ((uint32_t)0x00000400U) /* bit 10 */
#define NVIC_ICPR_CLRPEND_11 ((uint32_t)0x00000800U) /* bit 11 */
#define NVIC_ICPR_CLRPEND_12 ((uint32_t)0x00001000U) /* bit 12 */
#define NVIC_ICPR_CLRPEND_13 ((uint32_t)0x00002000U) /* bit 13 */
#define NVIC_ICPR_CLRPEND_14 ((uint32_t)0x00004000U) /* bit 14 */
#define NVIC_ICPR_CLRPEND_15 ((uint32_t)0x00008000U) /* bit 15 */
#define NVIC_ICPR_CLRPEND_16 ((uint32_t)0x00010000U) /* bit 16 */
#define NVIC_ICPR_CLRPEND_17 ((uint32_t)0x00020000U) /* bit 17 */
#define NVIC_ICPR_CLRPEND_18 ((uint32_t)0x00040000U) /* bit 18 */
#define NVIC_ICPR_CLRPEND_19 ((uint32_t)0x00080000U) /* bit 19 */
#define NVIC_ICPR_CLRPEND_20 ((uint32_t)0x00100000U) /* bit 20 */
#define NVIC_ICPR_CLRPEND_21 ((uint32_t)0x00200000U) /* bit 21 */
#define NVIC_ICPR_CLRPEND_22 ((uint32_t)0x00400000U) /* bit 22 */
#define NVIC_ICPR_CLRPEND_23 ((uint32_t)0x00800000U) /* bit 23 */
#define NVIC_ICPR_CLRPEND_24 ((uint32_t)0x01000000U) /* bit 24 */
#define NVIC_ICPR_CLRPEND_25 ((uint32_t)0x02000000U) /* bit 25 */
#define NVIC_ICPR_CLRPEND_26 ((uint32_t)0x04000000U) /* bit 26 */
#define NVIC_ICPR_CLRPEND_27 ((uint32_t)0x08000000U) /* bit 27 */
#define NVIC_ICPR_CLRPEND_28 ((uint32_t)0x10000000U) /* bit 28 */
#define NVIC_ICPR_CLRPEND_29 ((uint32_t)0x20000000U) /* bit 29 */
#define NVIC_ICPR_CLRPEND_30 ((uint32_t)0x40000000U) /* bit 30 */
#define NVIC_ICPR_CLRPEND_31 ((uint32_t)0x80000000U) /* bit 31 */

/** Bit definition for NVIC_IABR register **/
#define NVIC_IABR_ACTIVE    ((uint32_t)0xFFFFFFFFU) /* Interrupt active flags */
#define NVIC_IABR_ACTIVE_0  ((uint32_t)0x00000001U) /* bit 0 */
#define NVIC_IABR_ACTIVE_1  ((uint32_t)0x00000002U) /* bit 1 */
#define NVIC_IABR_ACTIVE_2  ((uint32_t)0x00000004U) /* bit 2 */
#define NVIC_IABR_ACTIVE_3  ((uint32_t)0x00000008U) /* bit 3 */
#define NVIC_IABR_ACTIVE_4  ((uint32_t)0x00000010U) /* bit 4 */
#define NVIC_IABR_ACTIVE_5  ((uint32_t)0x00000020U) /* bit 5 */
#define NVIC_IABR_ACTIVE_6  ((uint32_t)0x00000040U) /* bit 6 */
#define NVIC_IABR_ACTIVE_7  ((uint32_t)0x00000080U) /* bit 7 */
#define NVIC_IABR_ACTIVE_8  ((uint32_t)0x00000100U) /* bit 8 */
#define NVIC_IABR_ACTIVE_9  ((uint32_t)0x00000200U) /* bit 9 */
#define NVIC_IABR_ACTIVE_10 ((uint32_t)0x00000400U) /* bit 10 */
#define NVIC_IABR_ACTIVE_11 ((uint32_t)0x00000800U) /* bit 11 */
#define NVIC_IABR_ACTIVE_12 ((uint32_t)0x00001000U) /* bit 12 */
#define NVIC_IABR_ACTIVE_13 ((uint32_t)0x00002000U) /* bit 13 */
#define NVIC_IABR_ACTIVE_14 ((uint32_t)0x00004000U) /* bit 14 */
#define NVIC_IABR_ACTIVE_15 ((uint32_t)0x00008000U) /* bit 15 */
#define NVIC_IABR_ACTIVE_16 ((uint32_t)0x00010000U) /* bit 16 */
#define NVIC_IABR_ACTIVE_17 ((uint32_t)0x00020000U) /* bit 17 */
#define NVIC_IABR_ACTIVE_18 ((uint32_t)0x00040000U) /* bit 18 */
#define NVIC_IABR_ACTIVE_19 ((uint32_t)0x00080000U) /* bit 19 */
#define NVIC_IABR_ACTIVE_20 ((uint32_t)0x00100000U) /* bit 20 */
#define NVIC_IABR_ACTIVE_21 ((uint32_t)0x00200000U) /* bit 21 */
#define NVIC_IABR_ACTIVE_22 ((uint32_t)0x00400000U) /* bit 22 */
#define NVIC_IABR_ACTIVE_23 ((uint32_t)0x00800000U) /* bit 23 */
#define NVIC_IABR_ACTIVE_24 ((uint32_t)0x01000000U) /* bit 24 */
#define NVIC_IABR_ACTIVE_25 ((uint32_t)0x02000000U) /* bit 25 */
#define NVIC_IABR_ACTIVE_26 ((uint32_t)0x04000000U) /* bit 26 */
#define NVIC_IABR_ACTIVE_27 ((uint32_t)0x08000000U) /* bit 27 */
#define NVIC_IABR_ACTIVE_28 ((uint32_t)0x10000000U) /* bit 28 */
#define NVIC_IABR_ACTIVE_29 ((uint32_t)0x20000000U) /* bit 29 */
#define NVIC_IABR_ACTIVE_30 ((uint32_t)0x40000000U) /* bit 30 */
#define NVIC_IABR_ACTIVE_31 ((uint32_t)0x80000000U) /* bit 31 */

/** Bit definition for NVIC_PRI0 register **/
#define NVIC_IPR0_PRI_0 ((uint32_t)0x000000FFU) /* Priority of interrupt 0 */
#define NVIC_IPR0_PRI_1 ((uint32_t)0x0000FF00U) /* Priority of interrupt 1 */
#define NVIC_IPR0_PRI_2 ((uint32_t)0x00FF0000U) /* Priority of interrupt 2 */
#define NVIC_IPR0_PRI_3 ((uint32_t)0xFF000000U) /* Priority of interrupt 3 */

/** Bit definition for NVIC_PRI1 register **/
#define NVIC_IPR1_PRI_4 ((uint32_t)0x000000FFU) /* Priority of interrupt 4 */
#define NVIC_IPR1_PRI_5 ((uint32_t)0x0000FF00U) /* Priority of interrupt 5 */
#define NVIC_IPR1_PRI_6 ((uint32_t)0x00FF0000U) /* Priority of interrupt 6 */
#define NVIC_IPR1_PRI_7 ((uint32_t)0xFF000000U) /* Priority of interrupt 7 */

/** Bit definition for NVIC_PRI2 register **/
#define NVIC_IPR2_PRI_8  ((uint32_t)0x000000FFU) /* Priority of interrupt 8 */
#define NVIC_IPR2_PRI_9  ((uint32_t)0x0000FF00U) /* Priority of interrupt 9 */
#define NVIC_IPR2_PRI_10 ((uint32_t)0x00FF0000U) /* Priority of interrupt 10 */
#define NVIC_IPR2_PRI_11 ((uint32_t)0xFF000000U) /* Priority of interrupt 11 */

/** Bit definition for NVIC_PRI3 register **/
#define NVIC_IPR3_PRI_12 ((uint32_t)0x000000FFU) /* Priority of interrupt 12 */
#define NVIC_IPR3_PRI_13 ((uint32_t)0x0000FF00U) /* Priority of interrupt 13 */
#define NVIC_IPR3_PRI_14 ((uint32_t)0x00FF0000U) /* Priority of interrupt 14 */
#define NVIC_IPR3_PRI_15 ((uint32_t)0xFF000000U) /* Priority of interrupt 15 */

/** Bit definition for NVIC_PRI4 register **/
#define NVIC_IPR4_PRI_16 ((uint32_t)0x000000FFU) /* Priority of interrupt 16 */
#define NVIC_IPR4_PRI_17 ((uint32_t)0x0000FF00U) /* Priority of interrupt 17 */
#define NVIC_IPR4_PRI_18 ((uint32_t)0x00FF0000U) /* Priority of interrupt 18 */
#define NVIC_IPR4_PRI_19 ((uint32_t)0xFF000000U) /* Priority of interrupt 19 */

/** Bit definition for NVIC_PRI5 register **/
#define NVIC_IPR5_PRI_20 ((uint32_t)0x000000FFU) /* Priority of interrupt 20 */
#define NVIC_IPR5_PRI_21 ((uint32_t)0x0000FF00U) /* Priority of interrupt 21 */
#define NVIC_IPR5_PRI_22 ((uint32_t)0x00FF0000U) /* Priority of interrupt 22 */
#define NVIC_IPR5_PRI_23 ((uint32_t)0xFF000000U) /* Priority of interrupt 23 */

/** Bit definition for NVIC_PRI6 register **/
#define NVIC_IPR6_PRI_24 ((uint32_t)0x000000FFU) /* Priority of interrupt 24 */
#define NVIC_IPR6_PRI_25 ((uint32_t)0x0000FF00U) /* Priority of interrupt 25 */
#define NVIC_IPR6_PRI_26 ((uint32_t)0x00FF0000U) /* Priority of interrupt 26 */
#define NVIC_IPR6_PRI_27 ((uint32_t)0xFF000000U) /* Priority of interrupt 27 */

/** Bit definition for NVIC_PRI7 register **/
#define NVIC_IPR7_PRI_28 ((uint32_t)0x000000FFU) /* Priority of interrupt 28 */
#define NVIC_IPR7_PRI_29 ((uint32_t)0x0000FF00U) /* Priority of interrupt 29 */
#define NVIC_IPR7_PRI_30 ((uint32_t)0x00FF0000U) /* Priority of interrupt 30 */
#define NVIC_IPR7_PRI_31 ((uint32_t)0xFF000000U) /* Priority of interrupt 31 */

/** Bit definition for SCB_CPUID register **/
#define SCB_CPUID_REVISION    ((uint32_t)0x0000000FU) /* Implementation defined revision number */
#define SCB_CPUID_PARTNO      ((uint32_t)0x0000FFF0U) /* Number of processor within family */
#define SCB_CPUID_Constant    ((uint32_t)0x000F0000U) /* Reads as 0x0F */
#define SCB_CPUID_VARIANT     ((uint32_t)0x00F00000U) /* Implementation defined variant number */
#define SCB_CPUID_IMPLEMENTER ((uint32_t)0xFF000000U) /* Implementer code. ARM is 0x41 */

/** Bit definition for SCB_ICSR register **/
#define SCB_ICSR_VECTACTIVE  ((uint32_t)0x000001FFU) /* Active INTSTS number field */
#define SCB_ICSR_RETTOBASE   ((uint32_t)0x00000800U) /* All active exceptions minus the IPSR_current_exception yields the empty set */
#define SCB_ICSR_VECTPENDING ((uint32_t)0x003FF000U) /* Pending INTSTS number field */
#define SCB_ICSR_ISRPENDING  ((uint32_t)0x00400000U) /* Interrupt pending flag */
#define SCB_ICSR_ISRPREEMPT  ((uint32_t)0x00800000U) /* It indicates that a pending interrupt becomes active in the next running cycle */
#define SCB_ICSR_PENDSTCLR   ((uint32_t)0x02000000U) /* Clear pending SysTick bit */
#define SCB_ICSR_PENDSTSET   ((uint32_t)0x04000000U) /* Set pending SysTick bit */
#define SCB_ICSR_PENDSVCLR   ((uint32_t)0x08000000U) /* Clear pending pendSV bit */
#define SCB_ICSR_PENDSVSET   ((uint32_t)0x10000000U) /* Set pending pendSV bit */
#define SCB_ICSR_NMIPENDSET  ((uint32_t)0x80000000U) /* Set pending NMI bit */

/** Bit definition for SCB_VTOR register **/
#define SCB_VTOR_TBLOFF  ((uint32_t)0x1FFFFF80U) /* Vector table base offset field */
#define SCB_VTOR_TBLBASE ((uint32_t)0x20000000U) /* Table base in code(0) or RAM(1) */

/** Bit definition for SCB_AIRCR register **/
#define SCB_AIRCR_VECTRESET     ((uint32_t)0x00000001U) /* System Reset bit */
#define SCB_AIRCR_VECTCLRACTIVE ((uint32_t)0x00000002U) /* Clear active vector bit */
#define SCB_AIRCR_SYSRESETREQ   ((uint32_t)0x00000004U) /* Requests chip control logic to generate a reset */

#define SCB_AIRCR_PRIGROUP   ((uint32_t)0x00000700U) /* PRIGROUP[2:0] bits (Priority group) */
#define SCB_AIRCR_PRIGROUP_0 ((uint32_t)0x00000100U) /* Bit 0 */
#define SCB_AIRCR_PRIGROUP_1 ((uint32_t)0x00000200U) /* Bit 1 */
#define SCB_AIRCR_PRIGROUP_2 ((uint32_t)0x00000400U) /* Bit 2  */

/** prority group configuration **/
#define SCB_AIRCR_PRIGROUP0   ((uint32_t)0x00000000U) /* Priority group=0 (7 bits of pre-emption priority, 1 bit of subpriority) */
#define SCB_AIRCR_PRIGROUP1   ((uint32_t)0x00000100U) /* Priority group=1 (6 bits of pre-emption priority, 2 bits of subpriority) */
#define SCB_AIRCR_PRIGROUP2   ((uint32_t)0x00000200U) /* Priority group=2 (5 bits of pre-emption priority, 3 bits of subpriority) */
#define SCB_AIRCR_PRIGROUP3   ((uint32_t)0x00000300U) /* Priority group=3 (4 bits of pre-emption priority, 4 bits of subpriority) */
#define SCB_AIRCR_PRIGROUP4   ((uint32_t)0x00000400U) /* Priority group=4 (3 bits of pre-emption priority, 5 bits of subpriority) */
#define SCB_AIRCR_PRIGROUP5   ((uint32_t)0x00000500U) /* Priority group=5 (2 bits of pre-emption priority, 6 bits of subpriority) */
#define SCB_AIRCR_PRIGROUP6   ((uint32_t)0x00000600U) /* Priority group=6 (1 bit of pre-emption priority, 7 bits of subpriority) */
#define SCB_AIRCR_PRIGROUP7   ((uint32_t)0x00000700U) /* Priority group=7 (no pre-emption priority, 8 bits of subpriority) */

#define SCB_AIRCR_ENDIANESS ((uint32_t)0x00008000U) /* Data endianness bit */
#define SCB_AIRCR_VECTKEY   ((uint32_t)0xFFFF0000U) /* Register key (VECTKEY) - Reads as 0xFA05 (VECTKEYSTAT) */

/** Bit definition for SCB_SCR register **/
#define SCB_SCR_SLEEPONEXIT ((uint8_t)0x02U) /* Sleep on exit bit */
#define SCB_SCR_SLEEPDEEP   ((uint8_t)0x04U) /* Sleep deep bit */
#define SCB_SCR_SEVONPEND   ((uint8_t)0x10U) /* Wake up from WFE */

/** Bit definition for SCB_CCR register **/
#define SCB_CCR_NONBASETHRDENA   ((uint16_t)0x0001U) /* Thread mode can be entered from any level in Handler mode by controlled return value */
#define SCB_CCR_USERSETMPEND     ((uint16_t)0x0002U) /* Enables user code to write the Software Trigger Interrupt register to trigger (pend) a     \
                          Main exception */
#define SCB_CCR_UNALIGN_TRP ((uint16_t)0x0008U) /* Trap for unaligned access */
#define SCB_CCR_DIV_0_TRP   ((uint16_t)0x0010U) /* Trap on Divide by 0 */
#define SCB_CCR_BFHFNMIGN   ((uint16_t)0x0100U) /* Handlers running at priority -1 and -2 */
#define SCB_CCR_STKALIGN    ((uint16_t)0x0200U) /* On exception entry, the SP used prior to the exception is adjusted to be 8-byte aligned */

/** Bit definition for SCB_SHPR register **/
#define SCB_SHPR_PRI_N    ((uint32_t)0x000000FFU) /* Priority of system handler 4,8, and 12. Mem Manage, reserved and Debug Monitor */
#define SCB_SHPR_PRI_N1   ((uint32_t)0x0000FF00U) /* Priority of system handler 5,9, and 13. Bus Fault, reserved and reserved */
#define SCB_SHPR_PRI_N2   ((uint32_t)0x00FF0000U) /* Priority of system handler 6,10, and 14. Usage Fault, reserved and PendSV */
#define SCB_SHPR_PRI_N3   ((uint32_t)0xFF000000U) /* Priority of system handler 7,11, and 15. Reserved, SVCall and SysTick */

/** Bit definition for SCB_SHCSR register **/
#define SCB_SHCSR_MEMFAULTACT    ((uint32_t)0x00000001U) /* MemManage is active */
#define SCB_SHCSR_BUSFAULTACT    ((uint32_t)0x00000002U) /* BusFault is active */
#define SCB_SHCSR_USGFAULTACT    ((uint32_t)0x00000008U) /* UsageFault is active */
#define SCB_SHCSR_SVCALLACT      ((uint32_t)0x00000080U) /* SVCall is active */
#define SCB_SHCSR_MONITORACT     ((uint32_t)0x00000100U) /* Monitor is active */
#define SCB_SHCSR_PENDSVACT      ((uint32_t)0x00000400U) /* PendSV is active */
#define SCB_SHCSR_SYSTICKACT     ((uint32_t)0x00000800U) /* SysTick is active */
#define SCB_SHCSR_USGFAULTPENDED ((uint32_t)0x00001000U) /* Usage Fault is pended */
#define SCB_SHCSR_MEMFAULTPENDED ((uint32_t)0x00002000U) /* MemManage is pended */
#define SCB_SHCSR_BUSFAULTPENDED ((uint32_t)0x00004000U) /* Bus Fault is pended */
#define SCB_SHCSR_SVCALLPENDED   ((uint32_t)0x00008000U) /* SVCall is pended */
#define SCB_SHCSR_MEMFAULTENA    ((uint32_t)0x00010000U) /* MemManage enable */
#define SCB_SHCSR_BUSFAULTENA    ((uint32_t)0x00020000U) /* Bus Fault enable */
#define SCB_SHCSR_USGFAULTENA    ((uint32_t)0x00040000U) /* UsageFault enable */

/*** Bit definition for SCB_CFSR register ***/
/** MFSR **/
#define SCB_CFSR_IACCVIOL  ((uint32_t)0x00000001U) /* Instruction access violation */
#define SCB_CFSR_DACCVIOL  ((uint32_t)0x00000002U) /* Data access violation */
#define SCB_CFSR_MUNSTKERR ((uint32_t)0x00000008U) /* Unstacking error */
#define SCB_CFSR_MSTKERR   ((uint32_t)0x00000010U) /* Stacking error */
#define SCB_CFSR_MMARVALID ((uint32_t)0x00000080U) /* Memory Manage Address Register address valid flag */
/** BFSR **/
#define SCB_CFSR_IBUSERR     ((uint32_t)0x00000100U) /* Instruction bus error flag */
#define SCB_CFSR_PRECISERR   ((uint32_t)0x00000200U) /* Precise data bus error */
#define SCB_CFSR_IMPRECISERR ((uint32_t)0x00000400U) /* Imprecise data bus error */
#define SCB_CFSR_UNSTKERR    ((uint32_t)0x00000800U) /* Unstacking error */
#define SCB_CFSR_STKERR      ((uint32_t)0x00001000U) /* Stacking error */
#define SCB_CFSR_BFARVALID   ((uint32_t)0x00008000U) /* Bus Fault Address Register address valid flag */
/** UFSR **/
#define SCB_CFSR_UNDEFINSTR ((uint32_t)0x00010000U) /* The processor attempt to execute an undefined instruction */
#define SCB_CFSR_INVSTATE   ((uint32_t)0x00020000U) /* Invalid combination of EPSR and instruction */
#define SCB_CFSR_INVPC      ((uint32_t)0x00040000U) /* Attempt to load EXC_RETURN into pc illegally */
#define SCB_CFSR_NOCP       ((uint32_t)0x00080000U) /* Attempt to use a coprocessor instruction */
#define SCB_CFSR_UNALIGNED  ((uint32_t)0x01000000U) /* Fault occurs when there is an attempt to make an unaligned memory access */
#define SCB_CFSR_DIVBYZERO  ((uint32_t)0x02000000U) /* Fault occurs when SDIV or DIV instruction is used with a divisor of 0 */

/** Bit definition for SCB_HFSR register **/
#define SCB_HFSR_VECTTBL  ((uint32_t)0x00000002U) /* Fault occurs because of vector table read on exception processing */
#define SCB_HFSR_FORCED   ((uint32_t)0x40000000U) /* Hard Fault activated when a configurable Fault was received and cannot activate */
#define SCB_HFSR_DEBUGEVT ((uint32_t)0x80000000U) /* Fault related to debug */

/** Bit definition for SCB_DFSR register **/
#define SCB_DFSR_HALTED   ((uint8_t)0x01U) /* Halt request flag */
#define SCB_DFSR_BKPT     ((uint8_t)0x02U) /* BKPT flag */
#define SCB_DFSR_DWTTRAP  ((uint8_t)0x04U) /* Data Watchpoint and Trace (DWT) flag */
#define SCB_DFSR_VCATCH   ((uint8_t)0x08U) /* Vector catch flag */
#define SCB_DFSR_EXTERNAL ((uint8_t)0x10U) /* External debug request flag */

/** Bit definition for SCB_MMFAR register **/
#define SCB_MMFAR_ADDRESS ((uint32_t)0xFFFFFFFFU) /* Mem Manage fault address field */

/** Bit definition for SCB_BFAR register **/
#define SCB_BFAR_ADDRESS ((uint32_t)0xFFFFFFFFU) /* Bus fault address field */

/** Bit definition for SCB_afsr register **/
#define SCB_AFSR_IMPDEF ((uint32_t)0xFFFFFFFFU) /* Implementation defined */
    /******************************************************************************/
    /*                                                                            */
    /*                    External Interrupt/Event Controller                     */
    /*                                                                            */
    /******************************************************************************/
/******** Bit definition for EXTI_RT_CFG0 register  ********/
#define EXTI_RT_CFG0_RT_CFG0x                                ((uint32_t)0xFFFFFFFFU)         /* Bit[31:0] */
#define EXTI_RT_CFG0_RT_CFG0x_0                              ((uint32_t)0x00000001U)         /* Bit0*/
#define EXTI_RT_CFG0_RT_CFG0x_1                              ((uint32_t)0x00000002U)         /* Bit1*/
#define EXTI_RT_CFG0_RT_CFG0x_2                              ((uint32_t)0x00000004U)         /* Bit2*/
#define EXTI_RT_CFG0_RT_CFG0x_3                              ((uint32_t)0x00000008U)         /* Bit3*/
#define EXTI_RT_CFG0_RT_CFG0x_4                              ((uint32_t)0x00000010U)         /* Bit4*/
#define EXTI_RT_CFG0_RT_CFG0x_5                              ((uint32_t)0x00000020U)         /* Bit5*/
#define EXTI_RT_CFG0_RT_CFG0x_6                              ((uint32_t)0x00000040U)         /* Bit6*/
#define EXTI_RT_CFG0_RT_CFG0x_7                              ((uint32_t)0x00000080U)         /* Bit7*/
#define EXTI_RT_CFG0_RT_CFG0x_8                              ((uint32_t)0x00000100U)         /* Bit8*/
#define EXTI_RT_CFG0_RT_CFG0x_9                              ((uint32_t)0x00000200U)         /* Bit9*/
#define EXTI_RT_CFG0_RT_CFG0x_10                             ((uint32_t)0x00000400U)         /* Bit10*/
#define EXTI_RT_CFG0_RT_CFG0x_11                             ((uint32_t)0x00000800U)         /* Bit11*/
#define EXTI_RT_CFG0_RT_CFG0x_12                             ((uint32_t)0x00001000U)         /* Bit12*/
#define EXTI_RT_CFG0_RT_CFG0x_13                             ((uint32_t)0x00002000U)         /* Bit13*/
#define EXTI_RT_CFG0_RT_CFG0x_14                             ((uint32_t)0x00004000U)         /* Bit14*/
#define EXTI_RT_CFG0_RT_CFG0x_15                             ((uint32_t)0x00008000U)         /* Bit15*/
#define EXTI_RT_CFG0_RT_CFG0x_16                             ((uint32_t)0x00010000U)         /* Bit16*/
#define EXTI_RT_CFG0_RT_CFG0x_17                             ((uint32_t)0x00020000U)         /* Bit17*/
#define EXTI_RT_CFG0_RT_CFG0x_18                             ((uint32_t)0x00040000U)         /* Bit18*/
#define EXTI_RT_CFG0_RT_CFG0x_19                             ((uint32_t)0x00080000U)         /* Bit19*/
#define EXTI_RT_CFG0_RT_CFG0x_20                             ((uint32_t)0x00100000U)         /* Bit20*/
#define EXTI_RT_CFG0_RT_CFG0x_21                             ((uint32_t)0x00200000U)         /* Bit21*/
#define EXTI_RT_CFG0_RT_CFG0x_22                             ((uint32_t)0x00400000U)         /* Bit22*/
#define EXTI_RT_CFG0_RT_CFG0x_23                             ((uint32_t)0x00800000U)         /* Bit23*/
#define EXTI_RT_CFG0_RT_CFG0x_24                             ((uint32_t)0x01000000U)         /* Bit24*/
#define EXTI_RT_CFG0_RT_CFG0x_25                             ((uint32_t)0x02000000U)         /* Bit25*/
#define EXTI_RT_CFG0_RT_CFG0x_26                             ((uint32_t)0x04000000U)         /* Bit26*/
#define EXTI_RT_CFG0_RT_CFG0x_27                             ((uint32_t)0x08000000U)         /* Bit27*/
#define EXTI_RT_CFG0_RT_CFG0x_28                             ((uint32_t)0x10000000U)         /* Bit28*/
#define EXTI_RT_CFG0_RT_CFG0x_29                             ((uint32_t)0x20000000U)         /* Bit29*/
#define EXTI_RT_CFG0_RT_CFG0x_30                             ((uint32_t)0x40000000U)         /* Bit30*/
#define EXTI_RT_CFG0_RT_CFG0x_31                             ((uint32_t)0x80000000U)         /* Bit31*/

/******** Bit definition for EXTI_RT_CFG1 register  ********/
#define EXTI_RT_CFG1_RT_CFG1x                                ((uint32_t)0x000FFFFFU)         /* Bit[19:0] */
#define EXTI_RT_CFG1_RT_CFG1x_0                              ((uint32_t)0x00000001U)         /* Bit0*/
#define EXTI_RT_CFG1_RT_CFG1x_1                              ((uint32_t)0x00000002U)         /* Bit1*/
#define EXTI_RT_CFG1_RT_CFG1x_2                              ((uint32_t)0x00000004U)         /* Bit2*/
#define EXTI_RT_CFG1_RT_CFG1x_3                              ((uint32_t)0x00000008U)         /* Bit3*/
#define EXTI_RT_CFG1_RT_CFG1x_4                              ((uint32_t)0x00000010U)         /* Bit4*/
#define EXTI_RT_CFG1_RT_CFG1x_5                              ((uint32_t)0x00000020U)         /* Bit5*/
#define EXTI_RT_CFG1_RT_CFG1x_6                              ((uint32_t)0x00000040U)         /* Bit6*/
#define EXTI_RT_CFG1_RT_CFG1x_7                              ((uint32_t)0x00000080U)         /* Bit7*/
#define EXTI_RT_CFG1_RT_CFG1x_8                              ((uint32_t)0x00000100U)         /* Bit8*/
#define EXTI_RT_CFG1_RT_CFG1x_9                              ((uint32_t)0x00000200U)         /* Bit9*/
#define EXTI_RT_CFG1_RT_CFG1x_10                             ((uint32_t)0x00000400U)         /* Bit10*/
#define EXTI_RT_CFG1_RT_CFG1x_11                             ((uint32_t)0x00000800U)         /* Bit11*/
#define EXTI_RT_CFG1_RT_CFG1x_12                             ((uint32_t)0x00001000U)         /* Bit12*/
#define EXTI_RT_CFG1_RT_CFG1x_13                             ((uint32_t)0x00002000U)         /* Bit13*/
#define EXTI_RT_CFG1_RT_CFG1x_14                             ((uint32_t)0x00004000U)         /* Bit14*/
#define EXTI_RT_CFG1_RT_CFG1x_15                             ((uint32_t)0x00008000U)         /* Bit15*/
#define EXTI_RT_CFG1_RT_CFG1x_16                             ((uint32_t)0x00010000U)         /* Bit16*/
#define EXTI_RT_CFG1_RT_CFG1x_17                             ((uint32_t)0x00020000U)         /* Bit17*/
#define EXTI_RT_CFG1_RT_CFG1x_18                             ((uint32_t)0x00040000U)         /* Bit18*/
#define EXTI_RT_CFG1_RT_CFG1x_19                             ((uint32_t)0x00080000U)         /* Bit19*/

/******** Bit definition for EXTI_FT_CFG0 register  ********/
#define EXTI_FT_CFG0_FT_CFG0x                                ((uint32_t)0xFFFFFFFFU)         /* Bit[31:0] */
#define EXTI_FT_CFG0_FT_CFG0x_0                              ((uint32_t)0x00000001U)         /* Bit0*/
#define EXTI_FT_CFG0_FT_CFG0x_1                              ((uint32_t)0x00000002U)         /* Bit1*/
#define EXTI_FT_CFG0_FT_CFG0x_2                              ((uint32_t)0x00000004U)         /* Bit2*/
#define EXTI_FT_CFG0_FT_CFG0x_3                              ((uint32_t)0x00000008U)         /* Bit3*/
#define EXTI_FT_CFG0_FT_CFG0x_4                              ((uint32_t)0x00000010U)         /* Bit4*/
#define EXTI_FT_CFG0_FT_CFG0x_5                              ((uint32_t)0x00000020U)         /* Bit5*/
#define EXTI_FT_CFG0_FT_CFG0x_6                              ((uint32_t)0x00000040U)         /* Bit6*/
#define EXTI_FT_CFG0_FT_CFG0x_7                              ((uint32_t)0x00000080U)         /* Bit7*/
#define EXTI_FT_CFG0_FT_CFG0x_8                              ((uint32_t)0x00000100U)         /* Bit8*/
#define EXTI_FT_CFG0_FT_CFG0x_9                              ((uint32_t)0x00000200U)         /* Bit9*/
#define EXTI_FT_CFG0_FT_CFG0x_10                             ((uint32_t)0x00000400U)         /* Bit10*/
#define EXTI_FT_CFG0_FT_CFG0x_11                             ((uint32_t)0x00000800U)         /* Bit11*/
#define EXTI_FT_CFG0_FT_CFG0x_12                             ((uint32_t)0x00001000U)         /* Bit12*/
#define EXTI_FT_CFG0_FT_CFG0x_13                             ((uint32_t)0x00002000U)         /* Bit13*/
#define EXTI_FT_CFG0_FT_CFG0x_14                             ((uint32_t)0x00004000U)         /* Bit14*/
#define EXTI_FT_CFG0_FT_CFG0x_15                             ((uint32_t)0x00008000U)         /* Bit15*/
#define EXTI_FT_CFG0_FT_CFG0x_16                             ((uint32_t)0x00010000U)         /* Bit16*/
#define EXTI_FT_CFG0_FT_CFG0x_17                             ((uint32_t)0x00020000U)         /* Bit17*/
#define EXTI_FT_CFG0_FT_CFG0x_18                             ((uint32_t)0x00040000U)         /* Bit18*/
#define EXTI_FT_CFG0_FT_CFG0x_19                             ((uint32_t)0x00080000U)         /* Bit19*/
#define EXTI_FT_CFG0_FT_CFG0x_20                             ((uint32_t)0x00100000U)         /* Bit20*/
#define EXTI_FT_CFG0_FT_CFG0x_21                             ((uint32_t)0x00200000U)         /* Bit21*/
#define EXTI_FT_CFG0_FT_CFG0x_22                             ((uint32_t)0x00400000U)         /* Bit22*/
#define EXTI_FT_CFG0_FT_CFG0x_23                             ((uint32_t)0x00800000U)         /* Bit23*/
#define EXTI_FT_CFG0_FT_CFG0x_24                             ((uint32_t)0x01000000U)         /* Bit24*/
#define EXTI_FT_CFG0_FT_CFG0x_25                             ((uint32_t)0x02000000U)         /* Bit25*/
#define EXTI_FT_CFG0_FT_CFG0x_26                             ((uint32_t)0x04000000U)         /* Bit26*/
#define EXTI_FT_CFG0_FT_CFG0x_27                             ((uint32_t)0x08000000U)         /* Bit27*/
#define EXTI_FT_CFG0_FT_CFG0x_28                             ((uint32_t)0x10000000U)         /* Bit28*/
#define EXTI_FT_CFG0_FT_CFG0x_29                             ((uint32_t)0x20000000U)         /* Bit29*/
#define EXTI_FT_CFG0_FT_CFG0x_30                             ((uint32_t)0x40000000U)         /* Bit30*/
#define EXTI_FT_CFG0_FT_CFG0x_31                             ((uint32_t)0x80000000U)         /* Bit31*/

/******** Bit definition for EXTI_FT_CFG1 register  ********/
#define EXTI_FT_CFG1_FT_CFG1x                                ((uint32_t)0x000FFFFFU)         /* Bit[19:0] */
#define EXTI_FT_CFG1_FT_CFG1x_0                              ((uint32_t)0x00000001U)         /* Bit0*/
#define EXTI_FT_CFG1_FT_CFG1x_1                              ((uint32_t)0x00000002U)         /* Bit1*/
#define EXTI_FT_CFG1_FT_CFG1x_2                              ((uint32_t)0x00000004U)         /* Bit2*/
#define EXTI_FT_CFG1_FT_CFG1x_3                              ((uint32_t)0x00000008U)         /* Bit3*/
#define EXTI_FT_CFG1_FT_CFG1x_4                              ((uint32_t)0x00000010U)         /* Bit4*/
#define EXTI_FT_CFG1_FT_CFG1x_5                              ((uint32_t)0x00000020U)         /* Bit5*/
#define EXTI_FT_CFG1_FT_CFG1x_6                              ((uint32_t)0x00000040U)         /* Bit6*/
#define EXTI_FT_CFG1_FT_CFG1x_7                              ((uint32_t)0x00000080U)         /* Bit7*/
#define EXTI_FT_CFG1_FT_CFG1x_8                              ((uint32_t)0x00000100U)         /* Bit8*/
#define EXTI_FT_CFG1_FT_CFG1x_9                              ((uint32_t)0x00000200U)         /* Bit9*/
#define EXTI_FT_CFG1_FT_CFG1x_10                             ((uint32_t)0x00000400U)         /* Bit10*/
#define EXTI_FT_CFG1_FT_CFG1x_11                             ((uint32_t)0x00000800U)         /* Bit11*/
#define EXTI_FT_CFG1_FT_CFG1x_12                             ((uint32_t)0x00001000U)         /* Bit12*/
#define EXTI_FT_CFG1_FT_CFG1x_13                             ((uint32_t)0x00002000U)         /* Bit13*/
#define EXTI_FT_CFG1_FT_CFG1x_14                             ((uint32_t)0x00004000U)         /* Bit14*/
#define EXTI_FT_CFG1_FT_CFG1x_15                             ((uint32_t)0x00008000U)         /* Bit15*/
#define EXTI_FT_CFG1_FT_CFG1x_16                             ((uint32_t)0x00010000U)         /* Bit16*/
#define EXTI_FT_CFG1_FT_CFG1x_17                             ((uint32_t)0x00020000U)         /* Bit17*/
#define EXTI_FT_CFG1_FT_CFG1x_18                             ((uint32_t)0x00040000U)         /* Bit18*/
#define EXTI_FT_CFG1_FT_CFG1x_19                             ((uint32_t)0x00080000U)         /* Bit19*/

/******** Bit definition for EXTI_SWIE0 register  ********/
#define EXTI_SWIE0_SWIE0x                                    ((uint32_t)0xFFFFFFFFU)         /* Bit[31:0] */
#define EXTI_SWIE0_SWIE0x_0                                  ((uint32_t)0x00000001U)         /* Bit0*/
#define EXTI_SWIE0_SWIE0x_1                                  ((uint32_t)0x00000002U)         /* Bit1*/
#define EXTI_SWIE0_SWIE0x_2                                  ((uint32_t)0x00000004U)         /* Bit2*/
#define EXTI_SWIE0_SWIE0x_3                                  ((uint32_t)0x00000008U)         /* Bit3*/
#define EXTI_SWIE0_SWIE0x_4                                  ((uint32_t)0x00000010U)         /* Bit4*/
#define EXTI_SWIE0_SWIE0x_5                                  ((uint32_t)0x00000020U)         /* Bit5*/
#define EXTI_SWIE0_SWIE0x_6                                  ((uint32_t)0x00000040U)         /* Bit6*/
#define EXTI_SWIE0_SWIE0x_7                                  ((uint32_t)0x00000080U)         /* Bit7*/
#define EXTI_SWIE0_SWIE0x_8                                  ((uint32_t)0x00000100U)         /* Bit8*/
#define EXTI_SWIE0_SWIE0x_9                                  ((uint32_t)0x00000200U)         /* Bit9*/
#define EXTI_SWIE0_SWIE0x_10                                 ((uint32_t)0x00000400U)         /* Bit10*/
#define EXTI_SWIE0_SWIE0x_11                                 ((uint32_t)0x00000800U)         /* Bit11*/
#define EXTI_SWIE0_SWIE0x_12                                 ((uint32_t)0x00001000U)         /* Bit12*/
#define EXTI_SWIE0_SWIE0x_13                                 ((uint32_t)0x00002000U)         /* Bit13*/
#define EXTI_SWIE0_SWIE0x_14                                 ((uint32_t)0x00004000U)         /* Bit14*/
#define EXTI_SWIE0_SWIE0x_15                                 ((uint32_t)0x00008000U)         /* Bit15*/
#define EXTI_SWIE0_SWIE0x_16                                 ((uint32_t)0x00010000U)         /* Bit16*/
#define EXTI_SWIE0_SWIE0x_17                                 ((uint32_t)0x00020000U)         /* Bit17*/
#define EXTI_SWIE0_SWIE0x_18                                 ((uint32_t)0x00040000U)         /* Bit18*/
#define EXTI_SWIE0_SWIE0x_19                                 ((uint32_t)0x00080000U)         /* Bit19*/
#define EXTI_SWIE0_SWIE0x_20                                 ((uint32_t)0x00100000U)         /* Bit20*/
#define EXTI_SWIE0_SWIE0x_21                                 ((uint32_t)0x00200000U)         /* Bit21*/
#define EXTI_SWIE0_SWIE0x_22                                 ((uint32_t)0x00400000U)         /* Bit22*/
#define EXTI_SWIE0_SWIE0x_23                                 ((uint32_t)0x00800000U)         /* Bit23*/
#define EXTI_SWIE0_SWIE0x_24                                 ((uint32_t)0x01000000U)         /* Bit24*/
#define EXTI_SWIE0_SWIE0x_25                                 ((uint32_t)0x02000000U)         /* Bit25*/
#define EXTI_SWIE0_SWIE0x_26                                 ((uint32_t)0x04000000U)         /* Bit26*/
#define EXTI_SWIE0_SWIE0x_27                                 ((uint32_t)0x08000000U)         /* Bit27*/
#define EXTI_SWIE0_SWIE0x_28                                 ((uint32_t)0x10000000U)         /* Bit28*/
#define EXTI_SWIE0_SWIE0x_29                                 ((uint32_t)0x20000000U)         /* Bit29*/
#define EXTI_SWIE0_SWIE0x_30                                 ((uint32_t)0x40000000U)         /* Bit30*/
#define EXTI_SWIE0_SWIE0x_31                                 ((uint32_t)0x80000000U)         /* Bit31*/

/******** Bit definition for EXTI_SWIE1 register  ********/
#define EXTI_SWIE1_SWIE1x                                    ((uint32_t)0x000FFFFFU)         /* Bit[19:0] */
#define EXTI_SWIE1_SWIE1x_0                                  ((uint32_t)0x00000001U)         /* Bit0*/
#define EXTI_SWIE1_SWIE1x_1                                  ((uint32_t)0x00000002U)         /* Bit1*/
#define EXTI_SWIE1_SWIE1x_2                                  ((uint32_t)0x00000004U)         /* Bit2*/
#define EXTI_SWIE1_SWIE1x_3                                  ((uint32_t)0x00000008U)         /* Bit3*/
#define EXTI_SWIE1_SWIE1x_4                                  ((uint32_t)0x00000010U)         /* Bit4*/
#define EXTI_SWIE1_SWIE1x_5                                  ((uint32_t)0x00000020U)         /* Bit5*/
#define EXTI_SWIE1_SWIE1x_6                                  ((uint32_t)0x00000040U)         /* Bit6*/
#define EXTI_SWIE1_SWIE1x_7                                  ((uint32_t)0x00000080U)         /* Bit7*/
#define EXTI_SWIE1_SWIE1x_8                                  ((uint32_t)0x00000100U)         /* Bit8*/
#define EXTI_SWIE1_SWIE1x_9                                  ((uint32_t)0x00000200U)         /* Bit9*/
#define EXTI_SWIE1_SWIE1x_10                                 ((uint32_t)0x00000400U)         /* Bit10*/
#define EXTI_SWIE1_SWIE1x_11                                 ((uint32_t)0x00000800U)         /* Bit11*/
#define EXTI_SWIE1_SWIE1x_12                                 ((uint32_t)0x00001000U)         /* Bit12*/
#define EXTI_SWIE1_SWIE1x_13                                 ((uint32_t)0x00002000U)         /* Bit13*/
#define EXTI_SWIE1_SWIE1x_14                                 ((uint32_t)0x00004000U)         /* Bit14*/
#define EXTI_SWIE1_SWIE1x_15                                 ((uint32_t)0x00008000U)         /* Bit15*/
#define EXTI_SWIE1_SWIE1x_16                                 ((uint32_t)0x00010000U)         /* Bit16*/
#define EXTI_SWIE1_SWIE1x_17                                 ((uint32_t)0x00020000U)         /* Bit17*/
#define EXTI_SWIE1_SWIE1x_18                                 ((uint32_t)0x00040000U)         /* Bit18*/
#define EXTI_SWIE1_SWIE1x_19                                 ((uint32_t)0x00080000U)         /* Bit19*/

/******** Bit definition for EXTI_M7IMASK0 register  ********/
#define EXTI_M7IMASK0_M7IMSK0x                               ((uint32_t)0xFFFFFFFFU)         /* Bit[31:0] */
#define EXTI_M7IMASK0_M7IMSK0x_0                             ((uint32_t)0x00000001U)         /* Bit0*/
#define EXTI_M7IMASK0_M7IMSK0x_1                             ((uint32_t)0x00000002U)         /* Bit1*/
#define EXTI_M7IMASK0_M7IMSK0x_2                             ((uint32_t)0x00000004U)         /* Bit2*/
#define EXTI_M7IMASK0_M7IMSK0x_3                             ((uint32_t)0x00000008U)         /* Bit3*/
#define EXTI_M7IMASK0_M7IMSK0x_4                             ((uint32_t)0x00000010U)         /* Bit4*/
#define EXTI_M7IMASK0_M7IMSK0x_5                             ((uint32_t)0x00000020U)         /* Bit5*/
#define EXTI_M7IMASK0_M7IMSK0x_6                             ((uint32_t)0x00000040U)         /* Bit6*/
#define EXTI_M7IMASK0_M7IMSK0x_7                             ((uint32_t)0x00000080U)         /* Bit7*/
#define EXTI_M7IMASK0_M7IMSK0x_8                             ((uint32_t)0x00000100U)         /* Bit8*/
#define EXTI_M7IMASK0_M7IMSK0x_9                             ((uint32_t)0x00000200U)         /* Bit9*/
#define EXTI_M7IMASK0_M7IMSK0x_10                            ((uint32_t)0x00000400U)         /* Bit10*/
#define EXTI_M7IMASK0_M7IMSK0x_11                            ((uint32_t)0x00000800U)         /* Bit11*/
#define EXTI_M7IMASK0_M7IMSK0x_12                            ((uint32_t)0x00001000U)         /* Bit12*/
#define EXTI_M7IMASK0_M7IMSK0x_13                            ((uint32_t)0x00002000U)         /* Bit13*/
#define EXTI_M7IMASK0_M7IMSK0x_14                            ((uint32_t)0x00004000U)         /* Bit14*/
#define EXTI_M7IMASK0_M7IMSK0x_15                            ((uint32_t)0x00008000U)         /* Bit15*/
#define EXTI_M7IMASK0_M7IMSK0x_16                            ((uint32_t)0x00010000U)         /* Bit16*/
#define EXTI_M7IMASK0_M7IMSK0x_17                            ((uint32_t)0x00020000U)         /* Bit17*/
#define EXTI_M7IMASK0_M7IMSK0x_18                            ((uint32_t)0x00040000U)         /* Bit18*/
#define EXTI_M7IMASK0_M7IMSK0x_19                            ((uint32_t)0x00080000U)         /* Bit19*/
#define EXTI_M7IMASK0_M7IMSK0x_20                            ((uint32_t)0x00100000U)         /* Bit20*/
#define EXTI_M7IMASK0_M7IMSK0x_21                            ((uint32_t)0x00200000U)         /* Bit21*/
#define EXTI_M7IMASK0_M7IMSK0x_22                            ((uint32_t)0x00400000U)         /* Bit22*/
#define EXTI_M7IMASK0_M7IMSK0x_23                            ((uint32_t)0x00800000U)         /* Bit23*/
#define EXTI_M7IMASK0_M7IMSK0x_24                            ((uint32_t)0x01000000U)         /* Bit24*/
#define EXTI_M7IMASK0_M7IMSK0x_25                            ((uint32_t)0x02000000U)         /* Bit25*/
#define EXTI_M7IMASK0_M7IMSK0x_26                            ((uint32_t)0x04000000U)         /* Bit26*/
#define EXTI_M7IMASK0_M7IMSK0x_27                            ((uint32_t)0x08000000U)         /* Bit27*/
#define EXTI_M7IMASK0_M7IMSK0x_28                            ((uint32_t)0x10000000U)         /* Bit28*/
#define EXTI_M7IMASK0_M7IMSK0x_29                            ((uint32_t)0x20000000U)         /* Bit29*/
#define EXTI_M7IMASK0_M7IMSK0x_30                            ((uint32_t)0x40000000U)         /* Bit30*/
#define EXTI_M7IMASK0_M7IMSK0x_31                            ((uint32_t)0x80000000U)         /* Bit31*/

/******** Bit definition for EXTI_M7IMASK1 register  ********/
#define EXTI_M7IMASK1_M7IMSK1x                               ((uint32_t)0x000FFFFFU)         /* Bit[19:0] */
#define EXTI_M7IMASK1_M7IMSK1x_0                             ((uint32_t)0x00000001U)         /* Bit0*/
#define EXTI_M7IMASK1_M7IMSK1x_1                             ((uint32_t)0x00000002U)         /* Bit1*/
#define EXTI_M7IMASK1_M7IMSK1x_2                             ((uint32_t)0x00000004U)         /* Bit2*/
#define EXTI_M7IMASK1_M7IMSK1x_3                             ((uint32_t)0x00000008U)         /* Bit3*/
#define EXTI_M7IMASK1_M7IMSK1x_4                             ((uint32_t)0x00000010U)         /* Bit4*/
#define EXTI_M7IMASK1_M7IMSK1x_5                             ((uint32_t)0x00000020U)         /* Bit5*/
#define EXTI_M7IMASK1_M7IMSK1x_6                             ((uint32_t)0x00000040U)         /* Bit6*/
#define EXTI_M7IMASK1_M7IMSK1x_7                             ((uint32_t)0x00000080U)         /* Bit7*/
#define EXTI_M7IMASK1_M7IMSK1x_8                             ((uint32_t)0x00000100U)         /* Bit8*/
#define EXTI_M7IMASK1_M7IMSK1x_9                             ((uint32_t)0x00000200U)         /* Bit9*/
#define EXTI_M7IMASK1_M7IMSK1x_10                            ((uint32_t)0x00000400U)         /* Bit10*/
#define EXTI_M7IMASK1_M7IMSK1x_11                            ((uint32_t)0x00000800U)         /* Bit11*/
#define EXTI_M7IMASK1_M7IMSK1x_12                            ((uint32_t)0x00001000U)         /* Bit12*/
#define EXTI_M7IMASK1_M7IMSK1x_13                            ((uint32_t)0x00002000U)         /* Bit13*/
#define EXTI_M7IMASK1_M7IMSK1x_14                            ((uint32_t)0x00004000U)         /* Bit14*/
#define EXTI_M7IMASK1_M7IMSK1x_15                            ((uint32_t)0x00008000U)         /* Bit15*/
#define EXTI_M7IMASK1_M7IMSK1x_16                            ((uint32_t)0x00010000U)         /* Bit16*/
#define EXTI_M7IMASK1_M7IMSK1x_17                            ((uint32_t)0x00020000U)         /* Bit17*/
#define EXTI_M7IMASK1_M7IMSK1x_18                            ((uint32_t)0x00040000U)         /* Bit18*/
#define EXTI_M7IMASK1_M7IMSK1x_19                            ((uint32_t)0x00080000U)         /* Bit19*/

/******** Bit definition for EXTI_M4IMASK0 register  ********/
#define EXTI_M4IMASK0_M4IMSK0x                               ((uint32_t)0xFFFFFFFFU)         /* Bit[31:0] */
#define EXTI_M4IMASK0_M4IMSK0x_0                             ((uint32_t)0x00000001U)         /* Bit0*/
#define EXTI_M4IMASK0_M4IMSK0x_1                             ((uint32_t)0x00000002U)         /* Bit1*/
#define EXTI_M4IMASK0_M4IMSK0x_2                             ((uint32_t)0x00000004U)         /* Bit2*/
#define EXTI_M4IMASK0_M4IMSK0x_3                             ((uint32_t)0x00000008U)         /* Bit3*/
#define EXTI_M4IMASK0_M4IMSK0x_4                             ((uint32_t)0x00000010U)         /* Bit4*/
#define EXTI_M4IMASK0_M4IMSK0x_5                             ((uint32_t)0x00000020U)         /* Bit5*/
#define EXTI_M4IMASK0_M4IMSK0x_6                             ((uint32_t)0x00000040U)         /* Bit6*/
#define EXTI_M4IMASK0_M4IMSK0x_7                             ((uint32_t)0x00000080U)         /* Bit7*/
#define EXTI_M4IMASK0_M4IMSK0x_8                             ((uint32_t)0x00000100U)         /* Bit8*/
#define EXTI_M4IMASK0_M4IMSK0x_9                             ((uint32_t)0x00000200U)         /* Bit9*/
#define EXTI_M4IMASK0_M4IMSK0x_10                            ((uint32_t)0x00000400U)         /* Bit10*/
#define EXTI_M4IMASK0_M4IMSK0x_11                            ((uint32_t)0x00000800U)         /* Bit11*/
#define EXTI_M4IMASK0_M4IMSK0x_12                            ((uint32_t)0x00001000U)         /* Bit12*/
#define EXTI_M4IMASK0_M4IMSK0x_13                            ((uint32_t)0x00002000U)         /* Bit13*/
#define EXTI_M4IMASK0_M4IMSK0x_14                            ((uint32_t)0x00004000U)         /* Bit14*/
#define EXTI_M4IMASK0_M4IMSK0x_15                            ((uint32_t)0x00008000U)         /* Bit15*/
#define EXTI_M4IMASK0_M4IMSK0x_16                            ((uint32_t)0x00010000U)         /* Bit16*/
#define EXTI_M4IMASK0_M4IMSK0x_17                            ((uint32_t)0x00020000U)         /* Bit17*/
#define EXTI_M4IMASK0_M4IMSK0x_18                            ((uint32_t)0x00040000U)         /* Bit18*/
#define EXTI_M4IMASK0_M4IMSK0x_19                            ((uint32_t)0x00080000U)         /* Bit19*/
#define EXTI_M4IMASK0_M4IMSK0x_20                            ((uint32_t)0x00100000U)         /* Bit20*/
#define EXTI_M4IMASK0_M4IMSK0x_21                            ((uint32_t)0x00200000U)         /* Bit21*/
#define EXTI_M4IMASK0_M4IMSK0x_22                            ((uint32_t)0x00400000U)         /* Bit22*/
#define EXTI_M4IMASK0_M4IMSK0x_23                            ((uint32_t)0x00800000U)         /* Bit23*/
#define EXTI_M4IMASK0_M4IMSK0x_24                            ((uint32_t)0x01000000U)         /* Bit24*/
#define EXTI_M4IMASK0_M4IMSK0x_25                            ((uint32_t)0x02000000U)         /* Bit25*/
#define EXTI_M4IMASK0_M4IMSK0x_26                            ((uint32_t)0x04000000U)         /* Bit26*/
#define EXTI_M4IMASK0_M4IMSK0x_27                            ((uint32_t)0x08000000U)         /* Bit27*/
#define EXTI_M4IMASK0_M4IMSK0x_28                            ((uint32_t)0x10000000U)         /* Bit28*/
#define EXTI_M4IMASK0_M4IMSK0x_29                            ((uint32_t)0x20000000U)         /* Bit29*/
#define EXTI_M4IMASK0_M4IMSK0x_30                            ((uint32_t)0x40000000U)         /* Bit30*/
#define EXTI_M4IMASK0_M4IMSK0x_31                            ((uint32_t)0x80000000U)         /* Bit31*/

/******** Bit definition for EXTI_M4IMASK1 register  ********/
#define EXTI_M4IMASK1_M4IMSK1x                               ((uint32_t)0x000FFFFFU)         /* Bit[19:0] */
#define EXTI_M4IMASK1_M4IMSK1x_0                             ((uint32_t)0x00000001U)         /* Bit0*/
#define EXTI_M4IMASK1_M4IMSK1x_1                             ((uint32_t)0x00000002U)         /* Bit1*/
#define EXTI_M4IMASK1_M4IMSK1x_2                             ((uint32_t)0x00000004U)         /* Bit2*/
#define EXTI_M4IMASK1_M4IMSK1x_3                             ((uint32_t)0x00000008U)         /* Bit3*/
#define EXTI_M4IMASK1_M4IMSK1x_4                             ((uint32_t)0x00000010U)         /* Bit4*/
#define EXTI_M4IMASK1_M4IMSK1x_5                             ((uint32_t)0x00000020U)         /* Bit5*/
#define EXTI_M4IMASK1_M4IMSK1x_6                             ((uint32_t)0x00000040U)         /* Bit6*/
#define EXTI_M4IMASK1_M4IMSK1x_7                             ((uint32_t)0x00000080U)         /* Bit7*/
#define EXTI_M4IMASK1_M4IMSK1x_8                             ((uint32_t)0x00000100U)         /* Bit8*/
#define EXTI_M4IMASK1_M4IMSK1x_9                             ((uint32_t)0x00000200U)         /* Bit9*/
#define EXTI_M4IMASK1_M4IMSK1x_10                            ((uint32_t)0x00000400U)         /* Bit10*/
#define EXTI_M4IMASK1_M4IMSK1x_11                            ((uint32_t)0x00000800U)         /* Bit11*/
#define EXTI_M4IMASK1_M4IMSK1x_12                            ((uint32_t)0x00001000U)         /* Bit12*/
#define EXTI_M4IMASK1_M4IMSK1x_13                            ((uint32_t)0x00002000U)         /* Bit13*/
#define EXTI_M4IMASK1_M4IMSK1x_14                            ((uint32_t)0x00004000U)         /* Bit14*/
#define EXTI_M4IMASK1_M4IMSK1x_15                            ((uint32_t)0x00008000U)         /* Bit15*/
#define EXTI_M4IMASK1_M4IMSK1x_16                            ((uint32_t)0x00010000U)         /* Bit16*/
#define EXTI_M4IMASK1_M4IMSK1x_17                            ((uint32_t)0x00020000U)         /* Bit17*/
#define EXTI_M4IMASK1_M4IMSK1x_18                            ((uint32_t)0x00040000U)         /* Bit18*/
#define EXTI_M4IMASK1_M4IMSK1x_19                            ((uint32_t)0x00080000U)         /* Bit19*/

/******** Bit definition for EXTI_M7EMASK0 register  ********/
#define EXTI_M7EMASK0_M7EMASK0x                              ((uint32_t)0xFFFFFFFFU)         /* Bit[31:0] */
#define EXTI_M7EMASK0_M7EMASK0x_0                            ((uint32_t)0x00000001U)         /* Bit0*/
#define EXTI_M7EMASK0_M7EMASK0x_1                            ((uint32_t)0x00000002U)         /* Bit1*/
#define EXTI_M7EMASK0_M7EMASK0x_2                            ((uint32_t)0x00000004U)         /* Bit2*/
#define EXTI_M7EMASK0_M7EMASK0x_3                            ((uint32_t)0x00000008U)         /* Bit3*/
#define EXTI_M7EMASK0_M7EMASK0x_4                            ((uint32_t)0x00000010U)         /* Bit4*/
#define EXTI_M7EMASK0_M7EMASK0x_5                            ((uint32_t)0x00000020U)         /* Bit5*/
#define EXTI_M7EMASK0_M7EMASK0x_6                            ((uint32_t)0x00000040U)         /* Bit6*/
#define EXTI_M7EMASK0_M7EMASK0x_7                            ((uint32_t)0x00000080U)         /* Bit7*/
#define EXTI_M7EMASK0_M7EMASK0x_8                            ((uint32_t)0x00000100U)         /* Bit8*/
#define EXTI_M7EMASK0_M7EMASK0x_9                            ((uint32_t)0x00000200U)         /* Bit9*/
#define EXTI_M7EMASK0_M7EMASK0x_10                           ((uint32_t)0x00000400U)         /* Bit10*/
#define EXTI_M7EMASK0_M7EMASK0x_11                           ((uint32_t)0x00000800U)         /* Bit11*/
#define EXTI_M7EMASK0_M7EMASK0x_12                           ((uint32_t)0x00001000U)         /* Bit12*/
#define EXTI_M7EMASK0_M7EMASK0x_13                           ((uint32_t)0x00002000U)         /* Bit13*/
#define EXTI_M7EMASK0_M7EMASK0x_14                           ((uint32_t)0x00004000U)         /* Bit14*/
#define EXTI_M7EMASK0_M7EMASK0x_15                           ((uint32_t)0x00008000U)         /* Bit15*/
#define EXTI_M7EMASK0_M7EMASK0x_16                           ((uint32_t)0x00010000U)         /* Bit16*/
#define EXTI_M7EMASK0_M7EMASK0x_17                           ((uint32_t)0x00020000U)         /* Bit17*/
#define EXTI_M7EMASK0_M7EMASK0x_18                           ((uint32_t)0x00040000U)         /* Bit18*/
#define EXTI_M7EMASK0_M7EMASK0x_19                           ((uint32_t)0x00080000U)         /* Bit19*/
#define EXTI_M7EMASK0_M7EMASK0x_20                           ((uint32_t)0x00100000U)         /* Bit20*/
#define EXTI_M7EMASK0_M7EMASK0x_21                           ((uint32_t)0x00200000U)         /* Bit21*/
#define EXTI_M7EMASK0_M7EMASK0x_22                           ((uint32_t)0x00400000U)         /* Bit22*/
#define EXTI_M7EMASK0_M7EMASK0x_23                           ((uint32_t)0x00800000U)         /* Bit23*/
#define EXTI_M7EMASK0_M7EMASK0x_24                           ((uint32_t)0x01000000U)         /* Bit24*/
#define EXTI_M7EMASK0_M7EMASK0x_25                           ((uint32_t)0x02000000U)         /* Bit25*/
#define EXTI_M7EMASK0_M7EMASK0x_26                           ((uint32_t)0x04000000U)         /* Bit26*/
#define EXTI_M7EMASK0_M7EMASK0x_27                           ((uint32_t)0x08000000U)         /* Bit27*/
#define EXTI_M7EMASK0_M7EMASK0x_28                           ((uint32_t)0x10000000U)         /* Bit28*/
#define EXTI_M7EMASK0_M7EMASK0x_29                           ((uint32_t)0x20000000U)         /* Bit29*/
#define EXTI_M7EMASK0_M7EMASK0x_30                           ((uint32_t)0x40000000U)         /* Bit30*/
#define EXTI_M7EMASK0_M7EMASK0x_31                           ((uint32_t)0x80000000U)         /* Bit31*/

/******** Bit definition for EXTI_M7EMASK1 register  ********/
#define EXTI_M7EMASK1_M7EMASK1x                              ((uint32_t)0x000FFFFFU)         /* Bit[19:0] */
#define EXTI_M7EMASK1_M7EMASK1x_0                            ((uint32_t)0x00000001U)         /* Bit0*/
#define EXTI_M7EMASK1_M7EMASK1x_1                            ((uint32_t)0x00000002U)         /* Bit1*/
#define EXTI_M7EMASK1_M7EMASK1x_2                            ((uint32_t)0x00000004U)         /* Bit2*/
#define EXTI_M7EMASK1_M7EMASK1x_3                            ((uint32_t)0x00000008U)         /* Bit3*/
#define EXTI_M7EMASK1_M7EMASK1x_4                            ((uint32_t)0x00000010U)         /* Bit4*/
#define EXTI_M7EMASK1_M7EMASK1x_5                            ((uint32_t)0x00000020U)         /* Bit5*/
#define EXTI_M7EMASK1_M7EMASK1x_6                            ((uint32_t)0x00000040U)         /* Bit6*/
#define EXTI_M7EMASK1_M7EMASK1x_7                            ((uint32_t)0x00000080U)         /* Bit7*/
#define EXTI_M7EMASK1_M7EMASK1x_8                            ((uint32_t)0x00000100U)         /* Bit8*/
#define EXTI_M7EMASK1_M7EMASK1x_9                            ((uint32_t)0x00000200U)         /* Bit9*/
#define EXTI_M7EMASK1_M7EMASK1x_10                           ((uint32_t)0x00000400U)         /* Bit10*/
#define EXTI_M7EMASK1_M7EMASK1x_11                           ((uint32_t)0x00000800U)         /* Bit11*/
#define EXTI_M7EMASK1_M7EMASK1x_12                           ((uint32_t)0x00001000U)         /* Bit12*/
#define EXTI_M7EMASK1_M7EMASK1x_13                           ((uint32_t)0x00002000U)         /* Bit13*/
#define EXTI_M7EMASK1_M7EMASK1x_14                           ((uint32_t)0x00004000U)         /* Bit14*/
#define EXTI_M7EMASK1_M7EMASK1x_15                           ((uint32_t)0x00008000U)         /* Bit15*/
#define EXTI_M7EMASK1_M7EMASK1x_16                           ((uint32_t)0x00010000U)         /* Bit16*/
#define EXTI_M7EMASK1_M7EMASK1x_17                           ((uint32_t)0x00020000U)         /* Bit17*/
#define EXTI_M7EMASK1_M7EMASK1x_18                           ((uint32_t)0x00040000U)         /* Bit18*/
#define EXTI_M7EMASK1_M7EMASK1x_19                           ((uint32_t)0x00080000U)         /* Bit19*/

/******** Bit definition for EXTI_M4EMASK0 register  ********/
#define EXTI_M4EMASK0_M4EMASK0x                              ((uint32_t)0xFFFFFFFFU)         /* Bit[31:0] */
#define EXTI_M4EMASK0_M4EMASK0x_0                            ((uint32_t)0x00000001U)         /* Bit0*/
#define EXTI_M4EMASK0_M4EMASK0x_1                            ((uint32_t)0x00000002U)         /* Bit1*/
#define EXTI_M4EMASK0_M4EMASK0x_2                            ((uint32_t)0x00000004U)         /* Bit2*/
#define EXTI_M4EMASK0_M4EMASK0x_3                            ((uint32_t)0x00000008U)         /* Bit3*/
#define EXTI_M4EMASK0_M4EMASK0x_4                            ((uint32_t)0x00000010U)         /* Bit4*/
#define EXTI_M4EMASK0_M4EMASK0x_5                            ((uint32_t)0x00000020U)         /* Bit5*/
#define EXTI_M4EMASK0_M4EMASK0x_6                            ((uint32_t)0x00000040U)         /* Bit6*/
#define EXTI_M4EMASK0_M4EMASK0x_7                            ((uint32_t)0x00000080U)         /* Bit7*/
#define EXTI_M4EMASK0_M4EMASK0x_8                            ((uint32_t)0x00000100U)         /* Bit8*/
#define EXTI_M4EMASK0_M4EMASK0x_9                            ((uint32_t)0x00000200U)         /* Bit9*/
#define EXTI_M4EMASK0_M4EMASK0x_10                           ((uint32_t)0x00000400U)         /* Bit10*/
#define EXTI_M4EMASK0_M4EMASK0x_11                           ((uint32_t)0x00000800U)         /* Bit11*/
#define EXTI_M4EMASK0_M4EMASK0x_12                           ((uint32_t)0x00001000U)         /* Bit12*/
#define EXTI_M4EMASK0_M4EMASK0x_13                           ((uint32_t)0x00002000U)         /* Bit13*/
#define EXTI_M4EMASK0_M4EMASK0x_14                           ((uint32_t)0x00004000U)         /* Bit14*/
#define EXTI_M4EMASK0_M4EMASK0x_15                           ((uint32_t)0x00008000U)         /* Bit15*/
#define EXTI_M4EMASK0_M4EMASK0x_16                           ((uint32_t)0x00010000U)         /* Bit16*/
#define EXTI_M4EMASK0_M4EMASK0x_17                           ((uint32_t)0x00020000U)         /* Bit17*/
#define EXTI_M4EMASK0_M4EMASK0x_18                           ((uint32_t)0x00040000U)         /* Bit18*/
#define EXTI_M4EMASK0_M4EMASK0x_19                           ((uint32_t)0x00080000U)         /* Bit19*/
#define EXTI_M4EMASK0_M4EMASK0x_20                           ((uint32_t)0x00100000U)         /* Bit20*/
#define EXTI_M4EMASK0_M4EMASK0x_21                           ((uint32_t)0x00200000U)         /* Bit21*/
#define EXTI_M4EMASK0_M4EMASK0x_22                           ((uint32_t)0x00400000U)         /* Bit22*/
#define EXTI_M4EMASK0_M4EMASK0x_23                           ((uint32_t)0x00800000U)         /* Bit23*/
#define EXTI_M4EMASK0_M4EMASK0x_24                           ((uint32_t)0x01000000U)         /* Bit24*/
#define EXTI_M4EMASK0_M4EMASK0x_25                           ((uint32_t)0x02000000U)         /* Bit25*/
#define EXTI_M4EMASK0_M4EMASK0x_26                           ((uint32_t)0x04000000U)         /* Bit26*/
#define EXTI_M4EMASK0_M4EMASK0x_27                           ((uint32_t)0x08000000U)         /* Bit27*/
#define EXTI_M4EMASK0_M4EMASK0x_28                           ((uint32_t)0x10000000U)         /* Bit28*/
#define EXTI_M4EMASK0_M4EMASK0x_29                           ((uint32_t)0x20000000U)         /* Bit29*/
#define EXTI_M4EMASK0_M4EMASK0x_30                           ((uint32_t)0x40000000U)         /* Bit30*/
#define EXTI_M4EMASK0_M4EMASK0x_31                           ((uint32_t)0x80000000U)         /* Bit31*/

/******** Bit definition for EXTI_M4EMASK1 register  ********/
#define EXTI_M4EMASK1_M4EMASK1x                              ((uint32_t)0x000FFFFFU)         /* Bit[19:0] */
#define EXTI_M4EMASK1_M4EMASK1x_0                            ((uint32_t)0x00000001U)         /* Bit0*/
#define EXTI_M4EMASK1_M4EMASK1x_1                            ((uint32_t)0x00000002U)         /* Bit1*/
#define EXTI_M4EMASK1_M4EMASK1x_2                            ((uint32_t)0x00000004U)         /* Bit2*/
#define EXTI_M4EMASK1_M4EMASK1x_3                            ((uint32_t)0x00000008U)         /* Bit3*/
#define EXTI_M4EMASK1_M4EMASK1x_4                            ((uint32_t)0x00000010U)         /* Bit4*/
#define EXTI_M4EMASK1_M4EMASK1x_5                            ((uint32_t)0x00000020U)         /* Bit5*/
#define EXTI_M4EMASK1_M4EMASK1x_6                            ((uint32_t)0x00000040U)         /* Bit6*/
#define EXTI_M4EMASK1_M4EMASK1x_7                            ((uint32_t)0x00000080U)         /* Bit7*/
#define EXTI_M4EMASK1_M4EMASK1x_8                            ((uint32_t)0x00000100U)         /* Bit8*/
#define EXTI_M4EMASK1_M4EMASK1x_9                            ((uint32_t)0x00000200U)         /* Bit9*/
#define EXTI_M4EMASK1_M4EMASK1x_10                           ((uint32_t)0x00000400U)         /* Bit10*/
#define EXTI_M4EMASK1_M4EMASK1x_11                           ((uint32_t)0x00000800U)         /* Bit11*/
#define EXTI_M4EMASK1_M4EMASK1x_12                           ((uint32_t)0x00001000U)         /* Bit12*/
#define EXTI_M4EMASK1_M4EMASK1x_13                           ((uint32_t)0x00002000U)         /* Bit13*/
#define EXTI_M4EMASK1_M4EMASK1x_14                           ((uint32_t)0x00004000U)         /* Bit14*/
#define EXTI_M4EMASK1_M4EMASK1x_15                           ((uint32_t)0x00008000U)         /* Bit15*/
#define EXTI_M4EMASK1_M4EMASK1x_16                           ((uint32_t)0x00010000U)         /* Bit16*/
#define EXTI_M4EMASK1_M4EMASK1x_17                           ((uint32_t)0x00020000U)         /* Bit17*/
#define EXTI_M4EMASK1_M4EMASK1x_18                           ((uint32_t)0x00040000U)         /* Bit18*/
#define EXTI_M4EMASK1_M4EMASK1x_19                           ((uint32_t)0x00080000U)         /* Bit19*/

/******** Bit definition for EXTI_M7PEND0 register  ********/
#define EXTI_M7PEND0_M7PEND0x                                ((uint32_t)0xFFFFFFFFU)         /* Bit[31:0] */
#define EXTI_M7PEND0_M7PEND0x_0                              ((uint32_t)0x00000001U)         /* Bit0*/
#define EXTI_M7PEND0_M7PEND0x_1                              ((uint32_t)0x00000002U)         /* Bit1*/
#define EXTI_M7PEND0_M7PEND0x_2                              ((uint32_t)0x00000004U)         /* Bit2*/
#define EXTI_M7PEND0_M7PEND0x_3                              ((uint32_t)0x00000008U)         /* Bit3*/
#define EXTI_M7PEND0_M7PEND0x_4                              ((uint32_t)0x00000010U)         /* Bit4*/
#define EXTI_M7PEND0_M7PEND0x_5                              ((uint32_t)0x00000020U)         /* Bit5*/
#define EXTI_M7PEND0_M7PEND0x_6                              ((uint32_t)0x00000040U)         /* Bit6*/
#define EXTI_M7PEND0_M7PEND0x_7                              ((uint32_t)0x00000080U)         /* Bit7*/
#define EXTI_M7PEND0_M7PEND0x_8                              ((uint32_t)0x00000100U)         /* Bit8*/
#define EXTI_M7PEND0_M7PEND0x_9                              ((uint32_t)0x00000200U)         /* Bit9*/
#define EXTI_M7PEND0_M7PEND0x_10                             ((uint32_t)0x00000400U)         /* Bit10*/
#define EXTI_M7PEND0_M7PEND0x_11                             ((uint32_t)0x00000800U)         /* Bit11*/
#define EXTI_M7PEND0_M7PEND0x_12                             ((uint32_t)0x00001000U)         /* Bit12*/
#define EXTI_M7PEND0_M7PEND0x_13                             ((uint32_t)0x00002000U)         /* Bit13*/
#define EXTI_M7PEND0_M7PEND0x_14                             ((uint32_t)0x00004000U)         /* Bit14*/
#define EXTI_M7PEND0_M7PEND0x_15                             ((uint32_t)0x00008000U)         /* Bit15*/
#define EXTI_M7PEND0_M7PEND0x_16                             ((uint32_t)0x00010000U)         /* Bit16*/
#define EXTI_M7PEND0_M7PEND0x_17                             ((uint32_t)0x00020000U)         /* Bit17*/
#define EXTI_M7PEND0_M7PEND0x_18                             ((uint32_t)0x00040000U)         /* Bit18*/
#define EXTI_M7PEND0_M7PEND0x_19                             ((uint32_t)0x00080000U)         /* Bit19*/
#define EXTI_M7PEND0_M7PEND0x_20                             ((uint32_t)0x00100000U)         /* Bit20*/
#define EXTI_M7PEND0_M7PEND0x_21                             ((uint32_t)0x00200000U)         /* Bit21*/
#define EXTI_M7PEND0_M7PEND0x_22                             ((uint32_t)0x00400000U)         /* Bit22*/
#define EXTI_M7PEND0_M7PEND0x_23                             ((uint32_t)0x00800000U)         /* Bit23*/
#define EXTI_M7PEND0_M7PEND0x_24                             ((uint32_t)0x01000000U)         /* Bit24*/
#define EXTI_M7PEND0_M7PEND0x_25                             ((uint32_t)0x02000000U)         /* Bit25*/
#define EXTI_M7PEND0_M7PEND0x_26                             ((uint32_t)0x04000000U)         /* Bit26*/
#define EXTI_M7PEND0_M7PEND0x_27                             ((uint32_t)0x08000000U)         /* Bit27*/
#define EXTI_M7PEND0_M7PEND0x_28                             ((uint32_t)0x10000000U)         /* Bit28*/
#define EXTI_M7PEND0_M7PEND0x_29                             ((uint32_t)0x20000000U)         /* Bit29*/
#define EXTI_M7PEND0_M7PEND0x_30                             ((uint32_t)0x40000000U)         /* Bit30*/
#define EXTI_M7PEND0_M7PEND0x_31                             ((uint32_t)0x80000000U)         /* Bit31*/

/******** Bit definition for EXTI_M7PEND1 register  ********/
#define EXTI_M7PEND1_M7PEND1x                                ((uint32_t)0x000FFFFFU)         /* Bit[19:0] */
#define EXTI_M7PEND1_M7PEND1x_0                              ((uint32_t)0x00000001U)         /* Bit0*/
#define EXTI_M7PEND1_M7PEND1x_1                              ((uint32_t)0x00000002U)         /* Bit1*/
#define EXTI_M7PEND1_M7PEND1x_2                              ((uint32_t)0x00000004U)         /* Bit2*/
#define EXTI_M7PEND1_M7PEND1x_3                              ((uint32_t)0x00000008U)         /* Bit3*/
#define EXTI_M7PEND1_M7PEND1x_4                              ((uint32_t)0x00000010U)         /* Bit4*/
#define EXTI_M7PEND1_M7PEND1x_5                              ((uint32_t)0x00000020U)         /* Bit5*/
#define EXTI_M7PEND1_M7PEND1x_6                              ((uint32_t)0x00000040U)         /* Bit6*/
#define EXTI_M7PEND1_M7PEND1x_7                              ((uint32_t)0x00000080U)         /* Bit7*/
#define EXTI_M7PEND1_M7PEND1x_8                              ((uint32_t)0x00000100U)         /* Bit8*/
#define EXTI_M7PEND1_M7PEND1x_9                              ((uint32_t)0x00000200U)         /* Bit9*/
#define EXTI_M7PEND1_M7PEND1x_10                             ((uint32_t)0x00000400U)         /* Bit10*/
#define EXTI_M7PEND1_M7PEND1x_11                             ((uint32_t)0x00000800U)         /* Bit11*/
#define EXTI_M7PEND1_M7PEND1x_12                             ((uint32_t)0x00001000U)         /* Bit12*/
#define EXTI_M7PEND1_M7PEND1x_13                             ((uint32_t)0x00002000U)         /* Bit13*/
#define EXTI_M7PEND1_M7PEND1x_14                             ((uint32_t)0x00004000U)         /* Bit14*/
#define EXTI_M7PEND1_M7PEND1x_15                             ((uint32_t)0x00008000U)         /* Bit15*/
#define EXTI_M7PEND1_M7PEND1x_16                             ((uint32_t)0x00010000U)         /* Bit16*/
#define EXTI_M7PEND1_M7PEND1x_17                             ((uint32_t)0x00020000U)         /* Bit17*/
#define EXTI_M7PEND1_M7PEND1x_18                             ((uint32_t)0x00040000U)         /* Bit18*/
#define EXTI_M7PEND1_M7PEND1x_19                             ((uint32_t)0x00080000U)         /* Bit19*/

/******** Bit definition for EXTI_M4PEND0 register  ********/
#define EXTI_M4PEND0_M4PEND0x                                ((uint32_t)0xFFFFFFFFU)         /* Bit[31:0] */
#define EXTI_M4PEND0_M4PEND0x_0                              ((uint32_t)0x00000001U)         /* Bit0*/
#define EXTI_M4PEND0_M4PEND0x_1                              ((uint32_t)0x00000002U)         /* Bit1*/
#define EXTI_M4PEND0_M4PEND0x_2                              ((uint32_t)0x00000004U)         /* Bit2*/
#define EXTI_M4PEND0_M4PEND0x_3                              ((uint32_t)0x00000008U)         /* Bit3*/
#define EXTI_M4PEND0_M4PEND0x_4                              ((uint32_t)0x00000010U)         /* Bit4*/
#define EXTI_M4PEND0_M4PEND0x_5                              ((uint32_t)0x00000020U)         /* Bit5*/
#define EXTI_M4PEND0_M4PEND0x_6                              ((uint32_t)0x00000040U)         /* Bit6*/
#define EXTI_M4PEND0_M4PEND0x_7                              ((uint32_t)0x00000080U)         /* Bit7*/
#define EXTI_M4PEND0_M4PEND0x_8                              ((uint32_t)0x00000100U)         /* Bit8*/
#define EXTI_M4PEND0_M4PEND0x_9                              ((uint32_t)0x00000200U)         /* Bit9*/
#define EXTI_M4PEND0_M4PEND0x_10                             ((uint32_t)0x00000400U)         /* Bit10*/
#define EXTI_M4PEND0_M4PEND0x_11                             ((uint32_t)0x00000800U)         /* Bit11*/
#define EXTI_M4PEND0_M4PEND0x_12                             ((uint32_t)0x00001000U)         /* Bit12*/
#define EXTI_M4PEND0_M4PEND0x_13                             ((uint32_t)0x00002000U)         /* Bit13*/
#define EXTI_M4PEND0_M4PEND0x_14                             ((uint32_t)0x00004000U)         /* Bit14*/
#define EXTI_M4PEND0_M4PEND0x_15                             ((uint32_t)0x00008000U)         /* Bit15*/
#define EXTI_M4PEND0_M4PEND0x_16                             ((uint32_t)0x00010000U)         /* Bit16*/
#define EXTI_M4PEND0_M4PEND0x_17                             ((uint32_t)0x00020000U)         /* Bit17*/
#define EXTI_M4PEND0_M4PEND0x_18                             ((uint32_t)0x00040000U)         /* Bit18*/
#define EXTI_M4PEND0_M4PEND0x_19                             ((uint32_t)0x00080000U)         /* Bit19*/
#define EXTI_M4PEND0_M4PEND0x_20                             ((uint32_t)0x00100000U)         /* Bit20*/
#define EXTI_M4PEND0_M4PEND0x_21                             ((uint32_t)0x00200000U)         /* Bit21*/
#define EXTI_M4PEND0_M4PEND0x_22                             ((uint32_t)0x00400000U)         /* Bit22*/
#define EXTI_M4PEND0_M4PEND0x_23                             ((uint32_t)0x00800000U)         /* Bit23*/
#define EXTI_M4PEND0_M4PEND0x_24                             ((uint32_t)0x01000000U)         /* Bit24*/
#define EXTI_M4PEND0_M4PEND0x_25                             ((uint32_t)0x02000000U)         /* Bit25*/
#define EXTI_M4PEND0_M4PEND0x_26                             ((uint32_t)0x04000000U)         /* Bit26*/
#define EXTI_M4PEND0_M4PEND0x_27                             ((uint32_t)0x08000000U)         /* Bit27*/
#define EXTI_M4PEND0_M4PEND0x_28                             ((uint32_t)0x10000000U)         /* Bit28*/
#define EXTI_M4PEND0_M4PEND0x_29                             ((uint32_t)0x20000000U)         /* Bit29*/
#define EXTI_M4PEND0_M4PEND0x_30                             ((uint32_t)0x40000000U)         /* Bit30*/
#define EXTI_M4PEND0_M4PEND0x_31                             ((uint32_t)0x80000000U)         /* Bit31*/

/******** Bit definition for EXTI_M4PEND1 register  ********/
#define EXTI_M4PEND1_M4PEND1x                                ((uint32_t)0x000FFFFFU)         /* Bit[19:0] */
#define EXTI_M4PEND1_M4PEND1x_0                              ((uint32_t)0x00000001U)         /* Bit0*/
#define EXTI_M4PEND1_M4PEND1x_1                              ((uint32_t)0x00000002U)         /* Bit1*/
#define EXTI_M4PEND1_M4PEND1x_2                              ((uint32_t)0x00000004U)         /* Bit2*/
#define EXTI_M4PEND1_M4PEND1x_3                              ((uint32_t)0x00000008U)         /* Bit3*/
#define EXTI_M4PEND1_M4PEND1x_4                              ((uint32_t)0x00000010U)         /* Bit4*/
#define EXTI_M4PEND1_M4PEND1x_5                              ((uint32_t)0x00000020U)         /* Bit5*/
#define EXTI_M4PEND1_M4PEND1x_6                              ((uint32_t)0x00000040U)         /* Bit6*/
#define EXTI_M4PEND1_M4PEND1x_7                              ((uint32_t)0x00000080U)         /* Bit7*/
#define EXTI_M4PEND1_M4PEND1x_8                              ((uint32_t)0x00000100U)         /* Bit8*/
#define EXTI_M4PEND1_M4PEND1x_9                              ((uint32_t)0x00000200U)         /* Bit9*/
#define EXTI_M4PEND1_M4PEND1x_10                             ((uint32_t)0x00000400U)         /* Bit10*/
#define EXTI_M4PEND1_M4PEND1x_11                             ((uint32_t)0x00000800U)         /* Bit11*/
#define EXTI_M4PEND1_M4PEND1x_12                             ((uint32_t)0x00001000U)         /* Bit12*/
#define EXTI_M4PEND1_M4PEND1x_13                             ((uint32_t)0x00002000U)         /* Bit13*/
#define EXTI_M4PEND1_M4PEND1x_14                             ((uint32_t)0x00004000U)         /* Bit14*/
#define EXTI_M4PEND1_M4PEND1x_15                             ((uint32_t)0x00008000U)         /* Bit15*/
#define EXTI_M4PEND1_M4PEND1x_16                             ((uint32_t)0x00010000U)         /* Bit16*/
#define EXTI_M4PEND1_M4PEND1x_17                             ((uint32_t)0x00020000U)         /* Bit17*/
#define EXTI_M4PEND1_M4PEND1x_18                             ((uint32_t)0x00040000U)         /* Bit18*/
#define EXTI_M4PEND1_M4PEND1x_19                             ((uint32_t)0x00080000U)         /* Bit19*/

/******** Bit definition for EXTI_M7IMASK0_DRC register  ********/
#define EXTI_M7IMASK0_DRC_M7IMASK0_DRCx                      ((uint32_t)0xFFFFFFFFU)         /* Bit[31:0] */
#define EXTI_M7IMASK0_DRC_M7IMASK0_DRCx_0                    ((uint32_t)0x00000001U)         /* Bit0*/
#define EXTI_M7IMASK0_DRC_M7IMASK0_DRCx_1                    ((uint32_t)0x00000002U)         /* Bit1*/
#define EXTI_M7IMASK0_DRC_M7IMASK0_DRCx_2                    ((uint32_t)0x00000004U)         /* Bit2*/
#define EXTI_M7IMASK0_DRC_M7IMASK0_DRCx_3                    ((uint32_t)0x00000008U)         /* Bit3*/
#define EXTI_M7IMASK0_DRC_M7IMASK0_DRCx_4                    ((uint32_t)0x00000010U)         /* Bit4*/
#define EXTI_M7IMASK0_DRC_M7IMASK0_DRCx_5                    ((uint32_t)0x00000020U)         /* Bit5*/
#define EXTI_M7IMASK0_DRC_M7IMASK0_DRCx_6                    ((uint32_t)0x00000040U)         /* Bit6*/
#define EXTI_M7IMASK0_DRC_M7IMASK0_DRCx_7                    ((uint32_t)0x00000080U)         /* Bit7*/
#define EXTI_M7IMASK0_DRC_M7IMASK0_DRCx_8                    ((uint32_t)0x00000100U)         /* Bit8*/
#define EXTI_M7IMASK0_DRC_M7IMASK0_DRCx_9                    ((uint32_t)0x00000200U)         /* Bit9*/
#define EXTI_M7IMASK0_DRC_M7IMASK0_DRCx_10                   ((uint32_t)0x00000400U)         /* Bit10*/
#define EXTI_M7IMASK0_DRC_M7IMASK0_DRCx_11                   ((uint32_t)0x00000800U)         /* Bit11*/
#define EXTI_M7IMASK0_DRC_M7IMASK0_DRCx_12                   ((uint32_t)0x00001000U)         /* Bit12*/
#define EXTI_M7IMASK0_DRC_M7IMASK0_DRCx_13                   ((uint32_t)0x00002000U)         /* Bit13*/
#define EXTI_M7IMASK0_DRC_M7IMASK0_DRCx_14                   ((uint32_t)0x00004000U)         /* Bit14*/
#define EXTI_M7IMASK0_DRC_M7IMASK0_DRCx_15                   ((uint32_t)0x00008000U)         /* Bit15*/
#define EXTI_M7IMASK0_DRC_M7IMASK0_DRCx_16                   ((uint32_t)0x00010000U)         /* Bit16*/
#define EXTI_M7IMASK0_DRC_M7IMASK0_DRCx_17                   ((uint32_t)0x00020000U)         /* Bit17*/
#define EXTI_M7IMASK0_DRC_M7IMASK0_DRCx_18                   ((uint32_t)0x00040000U)         /* Bit18*/
#define EXTI_M7IMASK0_DRC_M7IMASK0_DRCx_19                   ((uint32_t)0x00080000U)         /* Bit19*/
#define EXTI_M7IMASK0_DRC_M7IMASK0_DRCx_20                   ((uint32_t)0x00100000U)         /* Bit20*/
#define EXTI_M7IMASK0_DRC_M7IMASK0_DRCx_21                   ((uint32_t)0x00200000U)         /* Bit21*/
#define EXTI_M7IMASK0_DRC_M7IMASK0_DRCx_22                   ((uint32_t)0x00400000U)         /* Bit22*/
#define EXTI_M7IMASK0_DRC_M7IMASK0_DRCx_23                   ((uint32_t)0x00800000U)         /* Bit23*/
#define EXTI_M7IMASK0_DRC_M7IMASK0_DRCx_24                   ((uint32_t)0x01000000U)         /* Bit24*/
#define EXTI_M7IMASK0_DRC_M7IMASK0_DRCx_25                   ((uint32_t)0x02000000U)         /* Bit25*/
#define EXTI_M7IMASK0_DRC_M7IMASK0_DRCx_26                   ((uint32_t)0x04000000U)         /* Bit26*/
#define EXTI_M7IMASK0_DRC_M7IMASK0_DRCx_27                   ((uint32_t)0x08000000U)         /* Bit27*/
#define EXTI_M7IMASK0_DRC_M7IMASK0_DRCx_28                   ((uint32_t)0x10000000U)         /* Bit28*/
#define EXTI_M7IMASK0_DRC_M7IMASK0_DRCx_29                   ((uint32_t)0x20000000U)         /* Bit29*/
#define EXTI_M7IMASK0_DRC_M7IMASK0_DRCx_30                   ((uint32_t)0x40000000U)         /* Bit30*/
#define EXTI_M7IMASK0_DRC_M7IMASK0_DRCx_31                   ((uint32_t)0x80000000U)         /* Bit31*/

/******** Bit definition for EXTI_M7IMASK1_DRC register  ********/
#define EXTI_M7IMASK1_DRC_M7IMASK1_DRCx                      ((uint32_t)0x07FFFFFFU)         /* Bit[26:0] */
#define EXTI_M7IMASK1_DRC_M7IMASK1_DRCx_0                    ((uint32_t)0x00000001U)         /* Bit0*/
#define EXTI_M7IMASK1_DRC_M7IMASK1_DRCx_1                    ((uint32_t)0x00000002U)         /* Bit1*/
#define EXTI_M7IMASK1_DRC_M7IMASK1_DRCx_2                    ((uint32_t)0x00000004U)         /* Bit2*/
#define EXTI_M7IMASK1_DRC_M7IMASK1_DRCx_3                    ((uint32_t)0x00000008U)         /* Bit3*/
#define EXTI_M7IMASK1_DRC_M7IMASK1_DRCx_4                    ((uint32_t)0x00000010U)         /* Bit4*/
#define EXTI_M7IMASK1_DRC_M7IMASK1_DRCx_5                    ((uint32_t)0x00000020U)         /* Bit5*/
#define EXTI_M7IMASK1_DRC_M7IMASK1_DRCx_6                    ((uint32_t)0x00000040U)         /* Bit6*/
#define EXTI_M7IMASK1_DRC_M7IMASK1_DRCx_7                    ((uint32_t)0x00000080U)         /* Bit7*/
#define EXTI_M7IMASK1_DRC_M7IMASK1_DRCx_8                    ((uint32_t)0x00000100U)         /* Bit8*/
#define EXTI_M7IMASK1_DRC_M7IMASK1_DRCx_9                    ((uint32_t)0x00000200U)         /* Bit9*/
#define EXTI_M7IMASK1_DRC_M7IMASK1_DRCx_10                   ((uint32_t)0x00000400U)         /* Bit10*/
#define EXTI_M7IMASK1_DRC_M7IMASK1_DRCx_11                   ((uint32_t)0x00000800U)         /* Bit11*/
#define EXTI_M7IMASK1_DRC_M7IMASK1_DRCx_12                   ((uint32_t)0x00001000U)         /* Bit12*/
#define EXTI_M7IMASK1_DRC_M7IMASK1_DRCx_13                   ((uint32_t)0x00002000U)         /* Bit13*/
#define EXTI_M7IMASK1_DRC_M7IMASK1_DRCx_14                   ((uint32_t)0x00004000U)         /* Bit14*/
#define EXTI_M7IMASK1_DRC_M7IMASK1_DRCx_15                   ((uint32_t)0x00008000U)         /* Bit15*/
#define EXTI_M7IMASK1_DRC_M7IMASK1_DRCx_16                   ((uint32_t)0x00010000U)         /* Bit16*/
#define EXTI_M7IMASK1_DRC_M7IMASK1_DRCx_17                   ((uint32_t)0x00020000U)         /* Bit17*/
#define EXTI_M7IMASK1_DRC_M7IMASK1_DRCx_18                   ((uint32_t)0x00040000U)         /* Bit18*/
#define EXTI_M7IMASK1_DRC_M7IMASK1_DRCx_19                   ((uint32_t)0x00080000U)         /* Bit19*/
#define EXTI_M7IMASK1_DRC_M7IMASK1_DRCx_20                   ((uint32_t)0x00100000U)         /* Bit20*/
#define EXTI_M7IMASK1_DRC_M7IMASK1_DRCx_21                   ((uint32_t)0x00200000U)         /* Bit21*/
#define EXTI_M7IMASK1_DRC_M7IMASK1_DRCx_22                   ((uint32_t)0x00400000U)         /* Bit22*/
#define EXTI_M7IMASK1_DRC_M7IMASK1_DRCx_23                   ((uint32_t)0x00800000U)         /* Bit23*/
#define EXTI_M7IMASK1_DRC_M7IMASK1_DRCx_24                   ((uint32_t)0x01000000U)         /* Bit24*/
#define EXTI_M7IMASK1_DRC_M7IMASK1_DRCx_25                   ((uint32_t)0x02000000U)         /* Bit25*/
#define EXTI_M7IMASK1_DRC_M7IMASK1_DRCx_26                   ((uint32_t)0x04000000U)         /* Bit26*/

/******** Bit definition for EXTI_M4IMASK0_DRC register  ********/
#define EXTI_M4IMASK0_DRC_M4IMASK0_DRCx                      ((uint32_t)0xFFFFFFFFU)         /* Bit[31:0] */
#define EXTI_M4IMASK0_DRC_M4IMASK0_DRCx_0                    ((uint32_t)0x00000001U)         /* Bit0*/
#define EXTI_M4IMASK0_DRC_M4IMASK0_DRCx_1                    ((uint32_t)0x00000002U)         /* Bit1*/
#define EXTI_M4IMASK0_DRC_M4IMASK0_DRCx_2                    ((uint32_t)0x00000004U)         /* Bit2*/
#define EXTI_M4IMASK0_DRC_M4IMASK0_DRCx_3                    ((uint32_t)0x00000008U)         /* Bit3*/
#define EXTI_M4IMASK0_DRC_M4IMASK0_DRCx_4                    ((uint32_t)0x00000010U)         /* Bit4*/
#define EXTI_M4IMASK0_DRC_M4IMASK0_DRCx_5                    ((uint32_t)0x00000020U)         /* Bit5*/
#define EXTI_M4IMASK0_DRC_M4IMASK0_DRCx_6                    ((uint32_t)0x00000040U)         /* Bit6*/
#define EXTI_M4IMASK0_DRC_M4IMASK0_DRCx_7                    ((uint32_t)0x00000080U)         /* Bit7*/
#define EXTI_M4IMASK0_DRC_M4IMASK0_DRCx_8                    ((uint32_t)0x00000100U)         /* Bit8*/
#define EXTI_M4IMASK0_DRC_M4IMASK0_DRCx_9                    ((uint32_t)0x00000200U)         /* Bit9*/
#define EXTI_M4IMASK0_DRC_M4IMASK0_DRCx_10                   ((uint32_t)0x00000400U)         /* Bit10*/
#define EXTI_M4IMASK0_DRC_M4IMASK0_DRCx_11                   ((uint32_t)0x00000800U)         /* Bit11*/
#define EXTI_M4IMASK0_DRC_M4IMASK0_DRCx_12                   ((uint32_t)0x00001000U)         /* Bit12*/
#define EXTI_M4IMASK0_DRC_M4IMASK0_DRCx_13                   ((uint32_t)0x00002000U)         /* Bit13*/
#define EXTI_M4IMASK0_DRC_M4IMASK0_DRCx_14                   ((uint32_t)0x00004000U)         /* Bit14*/
#define EXTI_M4IMASK0_DRC_M4IMASK0_DRCx_15                   ((uint32_t)0x00008000U)         /* Bit15*/
#define EXTI_M4IMASK0_DRC_M4IMASK0_DRCx_16                   ((uint32_t)0x00010000U)         /* Bit16*/
#define EXTI_M4IMASK0_DRC_M4IMASK0_DRCx_17                   ((uint32_t)0x00020000U)         /* Bit17*/
#define EXTI_M4IMASK0_DRC_M4IMASK0_DRCx_18                   ((uint32_t)0x00040000U)         /* Bit18*/
#define EXTI_M4IMASK0_DRC_M4IMASK0_DRCx_19                   ((uint32_t)0x00080000U)         /* Bit19*/
#define EXTI_M4IMASK0_DRC_M4IMASK0_DRCx_20                   ((uint32_t)0x00100000U)         /* Bit20*/
#define EXTI_M4IMASK0_DRC_M4IMASK0_DRCx_21                   ((uint32_t)0x00200000U)         /* Bit21*/
#define EXTI_M4IMASK0_DRC_M4IMASK0_DRCx_22                   ((uint32_t)0x00400000U)         /* Bit22*/
#define EXTI_M4IMASK0_DRC_M4IMASK0_DRCx_23                   ((uint32_t)0x00800000U)         /* Bit23*/
#define EXTI_M4IMASK0_DRC_M4IMASK0_DRCx_24                   ((uint32_t)0x01000000U)         /* Bit24*/
#define EXTI_M4IMASK0_DRC_M4IMASK0_DRCx_25                   ((uint32_t)0x02000000U)         /* Bit25*/
#define EXTI_M4IMASK0_DRC_M4IMASK0_DRCx_26                   ((uint32_t)0x04000000U)         /* Bit26*/
#define EXTI_M4IMASK0_DRC_M4IMASK0_DRCx_27                   ((uint32_t)0x08000000U)         /* Bit27*/
#define EXTI_M4IMASK0_DRC_M4IMASK0_DRCx_28                   ((uint32_t)0x10000000U)         /* Bit28*/
#define EXTI_M4IMASK0_DRC_M4IMASK0_DRCx_29                   ((uint32_t)0x20000000U)         /* Bit29*/
#define EXTI_M4IMASK0_DRC_M4IMASK0_DRCx_30                   ((uint32_t)0x40000000U)         /* Bit30*/
#define EXTI_M4IMASK0_DRC_M4IMASK0_DRCx_31                   ((uint32_t)0x80000000U)         /* Bit31*/

/******** Bit definition for EXTI_M4IMASK1_DRC register  ********/
#define EXTI_M4IMASK1_DRC_M4IMASK1_DRCx                      ((uint32_t)0x07FFFFFFU)         /* Bit[26:0] */
#define EXTI_M4IMASK1_DRC_M4IMASK1_DRCx_0                    ((uint32_t)0x00000001U)         /* Bit0*/
#define EXTI_M4IMASK1_DRC_M4IMASK1_DRCx_1                    ((uint32_t)0x00000002U)         /* Bit1*/
#define EXTI_M4IMASK1_DRC_M4IMASK1_DRCx_2                    ((uint32_t)0x00000004U)         /* Bit2*/
#define EXTI_M4IMASK1_DRC_M4IMASK1_DRCx_3                    ((uint32_t)0x00000008U)         /* Bit3*/
#define EXTI_M4IMASK1_DRC_M4IMASK1_DRCx_4                    ((uint32_t)0x00000010U)         /* Bit4*/
#define EXTI_M4IMASK1_DRC_M4IMASK1_DRCx_5                    ((uint32_t)0x00000020U)         /* Bit5*/
#define EXTI_M4IMASK1_DRC_M4IMASK1_DRCx_6                    ((uint32_t)0x00000040U)         /* Bit6*/
#define EXTI_M4IMASK1_DRC_M4IMASK1_DRCx_7                    ((uint32_t)0x00000080U)         /* Bit7*/
#define EXTI_M4IMASK1_DRC_M4IMASK1_DRCx_8                    ((uint32_t)0x00000100U)         /* Bit8*/
#define EXTI_M4IMASK1_DRC_M4IMASK1_DRCx_9                    ((uint32_t)0x00000200U)         /* Bit9*/
#define EXTI_M4IMASK1_DRC_M4IMASK1_DRCx_10                   ((uint32_t)0x00000400U)         /* Bit10*/
#define EXTI_M4IMASK1_DRC_M4IMASK1_DRCx_11                   ((uint32_t)0x00000800U)         /* Bit11*/
#define EXTI_M4IMASK1_DRC_M4IMASK1_DRCx_12                   ((uint32_t)0x00001000U)         /* Bit12*/
#define EXTI_M4IMASK1_DRC_M4IMASK1_DRCx_13                   ((uint32_t)0x00002000U)         /* Bit13*/
#define EXTI_M4IMASK1_DRC_M4IMASK1_DRCx_14                   ((uint32_t)0x00004000U)         /* Bit14*/
#define EXTI_M4IMASK1_DRC_M4IMASK1_DRCx_15                   ((uint32_t)0x00008000U)         /* Bit15*/
#define EXTI_M4IMASK1_DRC_M4IMASK1_DRCx_16                   ((uint32_t)0x00010000U)         /* Bit16*/
#define EXTI_M4IMASK1_DRC_M4IMASK1_DRCx_17                   ((uint32_t)0x00020000U)         /* Bit17*/
#define EXTI_M4IMASK1_DRC_M4IMASK1_DRCx_18                   ((uint32_t)0x00040000U)         /* Bit18*/
#define EXTI_M4IMASK1_DRC_M4IMASK1_DRCx_19                   ((uint32_t)0x00080000U)         /* Bit19*/
#define EXTI_M4IMASK1_DRC_M4IMASK1_DRCx_20                   ((uint32_t)0x00100000U)         /* Bit20*/
#define EXTI_M4IMASK1_DRC_M4IMASK1_DRCx_21                   ((uint32_t)0x00200000U)         /* Bit21*/
#define EXTI_M4IMASK1_DRC_M4IMASK1_DRCx_22                   ((uint32_t)0x00400000U)         /* Bit22*/
#define EXTI_M4IMASK1_DRC_M4IMASK1_DRCx_23                   ((uint32_t)0x00800000U)         /* Bit23*/
#define EXTI_M4IMASK1_DRC_M4IMASK1_DRCx_24                   ((uint32_t)0x01000000U)         /* Bit24*/
#define EXTI_M4IMASK1_DRC_M4IMASK1_DRCx_25                   ((uint32_t)0x02000000U)         /* Bit25*/
#define EXTI_M4IMASK1_DRC_M4IMASK1_DRCx_26                   ((uint32_t)0x04000000U)         /* Bit26*/

/******** Bit definition for EXTI_M7EMASK0_DRC register  ********/
#define EXTI_M7EMASK0_DRC_M7EMASK0_DRCx                      ((uint32_t)0xFFFFFFFFU)         /* Bit[31:0] */
#define EXTI_M7EMASK0_DRC_M7EMASK0_DRCx_0                    ((uint32_t)0x00000001U)         /* Bit0*/
#define EXTI_M7EMASK0_DRC_M7EMASK0_DRCx_1                    ((uint32_t)0x00000002U)         /* Bit1*/
#define EXTI_M7EMASK0_DRC_M7EMASK0_DRCx_2                    ((uint32_t)0x00000004U)         /* Bit2*/
#define EXTI_M7EMASK0_DRC_M7EMASK0_DRCx_3                    ((uint32_t)0x00000008U)         /* Bit3*/
#define EXTI_M7EMASK0_DRC_M7EMASK0_DRCx_4                    ((uint32_t)0x00000010U)         /* Bit4*/
#define EXTI_M7EMASK0_DRC_M7EMASK0_DRCx_5                    ((uint32_t)0x00000020U)         /* Bit5*/
#define EXTI_M7EMASK0_DRC_M7EMASK0_DRCx_6                    ((uint32_t)0x00000040U)         /* Bit6*/
#define EXTI_M7EMASK0_DRC_M7EMASK0_DRCx_7                    ((uint32_t)0x00000080U)         /* Bit7*/
#define EXTI_M7EMASK0_DRC_M7EMASK0_DRCx_8                    ((uint32_t)0x00000100U)         /* Bit8*/
#define EXTI_M7EMASK0_DRC_M7EMASK0_DRCx_9                    ((uint32_t)0x00000200U)         /* Bit9*/
#define EXTI_M7EMASK0_DRC_M7EMASK0_DRCx_10                   ((uint32_t)0x00000400U)         /* Bit10*/
#define EXTI_M7EMASK0_DRC_M7EMASK0_DRCx_11                   ((uint32_t)0x00000800U)         /* Bit11*/
#define EXTI_M7EMASK0_DRC_M7EMASK0_DRCx_12                   ((uint32_t)0x00001000U)         /* Bit12*/
#define EXTI_M7EMASK0_DRC_M7EMASK0_DRCx_13                   ((uint32_t)0x00002000U)         /* Bit13*/
#define EXTI_M7EMASK0_DRC_M7EMASK0_DRCx_14                   ((uint32_t)0x00004000U)         /* Bit14*/
#define EXTI_M7EMASK0_DRC_M7EMASK0_DRCx_15                   ((uint32_t)0x00008000U)         /* Bit15*/
#define EXTI_M7EMASK0_DRC_M7EMASK0_DRCx_16                   ((uint32_t)0x00010000U)         /* Bit16*/
#define EXTI_M7EMASK0_DRC_M7EMASK0_DRCx_17                   ((uint32_t)0x00020000U)         /* Bit17*/
#define EXTI_M7EMASK0_DRC_M7EMASK0_DRCx_18                   ((uint32_t)0x00040000U)         /* Bit18*/
#define EXTI_M7EMASK0_DRC_M7EMASK0_DRCx_19                   ((uint32_t)0x00080000U)         /* Bit19*/
#define EXTI_M7EMASK0_DRC_M7EMASK0_DRCx_20                   ((uint32_t)0x00100000U)         /* Bit20*/
#define EXTI_M7EMASK0_DRC_M7EMASK0_DRCx_21                   ((uint32_t)0x00200000U)         /* Bit21*/
#define EXTI_M7EMASK0_DRC_M7EMASK0_DRCx_22                   ((uint32_t)0x00400000U)         /* Bit22*/
#define EXTI_M7EMASK0_DRC_M7EMASK0_DRCx_23                   ((uint32_t)0x00800000U)         /* Bit23*/
#define EXTI_M7EMASK0_DRC_M7EMASK0_DRCx_24                   ((uint32_t)0x01000000U)         /* Bit24*/
#define EXTI_M7EMASK0_DRC_M7EMASK0_DRCx_25                   ((uint32_t)0x02000000U)         /* Bit25*/
#define EXTI_M7EMASK0_DRC_M7EMASK0_DRCx_26                   ((uint32_t)0x04000000U)         /* Bit26*/
#define EXTI_M7EMASK0_DRC_M7EMASK0_DRCx_27                   ((uint32_t)0x08000000U)         /* Bit27*/
#define EXTI_M7EMASK0_DRC_M7EMASK0_DRCx_28                   ((uint32_t)0x10000000U)         /* Bit28*/
#define EXTI_M7EMASK0_DRC_M7EMASK0_DRCx_29                   ((uint32_t)0x20000000U)         /* Bit29*/
#define EXTI_M7EMASK0_DRC_M7EMASK0_DRCx_30                   ((uint32_t)0x40000000U)         /* Bit30*/
#define EXTI_M7EMASK0_DRC_M7EMASK0_DRCx_31                   ((uint32_t)0x80000000U)         /* Bit31*/

/******** Bit definition for EXTI_M7EMASK1_DRC register  ********/
#define EXTI_M7EMASK1_DRC_M7EMASK1_DRCx                      ((uint32_t)0x07FFFFFFU)         /* Bit[26:0] */
#define EXTI_M7EMASK1_DRC_M7EMASK1_DRCx_0                    ((uint32_t)0x00000001U)         /* Bit0*/
#define EXTI_M7EMASK1_DRC_M7EMASK1_DRCx_1                    ((uint32_t)0x00000002U)         /* Bit1*/
#define EXTI_M7EMASK1_DRC_M7EMASK1_DRCx_2                    ((uint32_t)0x00000004U)         /* Bit2*/
#define EXTI_M7EMASK1_DRC_M7EMASK1_DRCx_3                    ((uint32_t)0x00000008U)         /* Bit3*/
#define EXTI_M7EMASK1_DRC_M7EMASK1_DRCx_4                    ((uint32_t)0x00000010U)         /* Bit4*/
#define EXTI_M7EMASK1_DRC_M7EMASK1_DRCx_5                    ((uint32_t)0x00000020U)         /* Bit5*/
#define EXTI_M7EMASK1_DRC_M7EMASK1_DRCx_6                    ((uint32_t)0x00000040U)         /* Bit6*/
#define EXTI_M7EMASK1_DRC_M7EMASK1_DRCx_7                    ((uint32_t)0x00000080U)         /* Bit7*/
#define EXTI_M7EMASK1_DRC_M7EMASK1_DRCx_8                    ((uint32_t)0x00000100U)         /* Bit8*/
#define EXTI_M7EMASK1_DRC_M7EMASK1_DRCx_9                    ((uint32_t)0x00000200U)         /* Bit9*/
#define EXTI_M7EMASK1_DRC_M7EMASK1_DRCx_10                   ((uint32_t)0x00000400U)         /* Bit10*/
#define EXTI_M7EMASK1_DRC_M7EMASK1_DRCx_11                   ((uint32_t)0x00000800U)         /* Bit11*/
#define EXTI_M7EMASK1_DRC_M7EMASK1_DRCx_12                   ((uint32_t)0x00001000U)         /* Bit12*/
#define EXTI_M7EMASK1_DRC_M7EMASK1_DRCx_13                   ((uint32_t)0x00002000U)         /* Bit13*/
#define EXTI_M7EMASK1_DRC_M7EMASK1_DRCx_14                   ((uint32_t)0x00004000U)         /* Bit14*/
#define EXTI_M7EMASK1_DRC_M7EMASK1_DRCx_15                   ((uint32_t)0x00008000U)         /* Bit15*/
#define EXTI_M7EMASK1_DRC_M7EMASK1_DRCx_16                   ((uint32_t)0x00010000U)         /* Bit16*/
#define EXTI_M7EMASK1_DRC_M7EMASK1_DRCx_17                   ((uint32_t)0x00020000U)         /* Bit17*/
#define EXTI_M7EMASK1_DRC_M7EMASK1_DRCx_18                   ((uint32_t)0x00040000U)         /* Bit18*/
#define EXTI_M7EMASK1_DRC_M7EMASK1_DRCx_19                   ((uint32_t)0x00080000U)         /* Bit19*/
#define EXTI_M7EMASK1_DRC_M7EMASK1_DRCx_20                   ((uint32_t)0x00100000U)         /* Bit20*/
#define EXTI_M7EMASK1_DRC_M7EMASK1_DRCx_21                   ((uint32_t)0x00200000U)         /* Bit21*/
#define EXTI_M7EMASK1_DRC_M7EMASK1_DRCx_22                   ((uint32_t)0x00400000U)         /* Bit22*/
#define EXTI_M7EMASK1_DRC_M7EMASK1_DRCx_23                   ((uint32_t)0x00800000U)         /* Bit23*/
#define EXTI_M7EMASK1_DRC_M7EMASK1_DRCx_24                   ((uint32_t)0x01000000U)         /* Bit24*/
#define EXTI_M7EMASK1_DRC_M7EMASK1_DRCx_25                   ((uint32_t)0x02000000U)         /* Bit25*/
#define EXTI_M7EMASK1_DRC_M7EMASK1_DRCx_26                   ((uint32_t)0x04000000U)         /* Bit26*/

/******** Bit definition for EXTI_M4EMASK0_DRC register  ********/
#define EXTI_M4EMASK0_DRC_M4EMASK0_DRCx                      ((uint32_t)0xFFFFFFFFU)         /* Bit[31:0] */
#define EXTI_M4EMASK0_DRC_M4EMASK0_DRCx_0                    ((uint32_t)0x00000001U)         /* Bit0*/
#define EXTI_M4EMASK0_DRC_M4EMASK0_DRCx_1                    ((uint32_t)0x00000002U)         /* Bit1*/
#define EXTI_M4EMASK0_DRC_M4EMASK0_DRCx_2                    ((uint32_t)0x00000004U)         /* Bit2*/
#define EXTI_M4EMASK0_DRC_M4EMASK0_DRCx_3                    ((uint32_t)0x00000008U)         /* Bit3*/
#define EXTI_M4EMASK0_DRC_M4EMASK0_DRCx_4                    ((uint32_t)0x00000010U)         /* Bit4*/
#define EXTI_M4EMASK0_DRC_M4EMASK0_DRCx_5                    ((uint32_t)0x00000020U)         /* Bit5*/
#define EXTI_M4EMASK0_DRC_M4EMASK0_DRCx_6                    ((uint32_t)0x00000040U)         /* Bit6*/
#define EXTI_M4EMASK0_DRC_M4EMASK0_DRCx_7                    ((uint32_t)0x00000080U)         /* Bit7*/
#define EXTI_M4EMASK0_DRC_M4EMASK0_DRCx_8                    ((uint32_t)0x00000100U)         /* Bit8*/
#define EXTI_M4EMASK0_DRC_M4EMASK0_DRCx_9                    ((uint32_t)0x00000200U)         /* Bit9*/
#define EXTI_M4EMASK0_DRC_M4EMASK0_DRCx_10                   ((uint32_t)0x00000400U)         /* Bit10*/
#define EXTI_M4EMASK0_DRC_M4EMASK0_DRCx_11                   ((uint32_t)0x00000800U)         /* Bit11*/
#define EXTI_M4EMASK0_DRC_M4EMASK0_DRCx_12                   ((uint32_t)0x00001000U)         /* Bit12*/
#define EXTI_M4EMASK0_DRC_M4EMASK0_DRCx_13                   ((uint32_t)0x00002000U)         /* Bit13*/
#define EXTI_M4EMASK0_DRC_M4EMASK0_DRCx_14                   ((uint32_t)0x00004000U)         /* Bit14*/
#define EXTI_M4EMASK0_DRC_M4EMASK0_DRCx_15                   ((uint32_t)0x00008000U)         /* Bit15*/
#define EXTI_M4EMASK0_DRC_M4EMASK0_DRCx_16                   ((uint32_t)0x00010000U)         /* Bit16*/
#define EXTI_M4EMASK0_DRC_M4EMASK0_DRCx_17                   ((uint32_t)0x00020000U)         /* Bit17*/
#define EXTI_M4EMASK0_DRC_M4EMASK0_DRCx_18                   ((uint32_t)0x00040000U)         /* Bit18*/
#define EXTI_M4EMASK0_DRC_M4EMASK0_DRCx_19                   ((uint32_t)0x00080000U)         /* Bit19*/
#define EXTI_M4EMASK0_DRC_M4EMASK0_DRCx_20                   ((uint32_t)0x00100000U)         /* Bit20*/
#define EXTI_M4EMASK0_DRC_M4EMASK0_DRCx_21                   ((uint32_t)0x00200000U)         /* Bit21*/
#define EXTI_M4EMASK0_DRC_M4EMASK0_DRCx_22                   ((uint32_t)0x00400000U)         /* Bit22*/
#define EXTI_M4EMASK0_DRC_M4EMASK0_DRCx_23                   ((uint32_t)0x00800000U)         /* Bit23*/
#define EXTI_M4EMASK0_DRC_M4EMASK0_DRCx_24                   ((uint32_t)0x01000000U)         /* Bit24*/
#define EXTI_M4EMASK0_DRC_M4EMASK0_DRCx_25                   ((uint32_t)0x02000000U)         /* Bit25*/
#define EXTI_M4EMASK0_DRC_M4EMASK0_DRCx_26                   ((uint32_t)0x04000000U)         /* Bit26*/
#define EXTI_M4EMASK0_DRC_M4EMASK0_DRCx_27                   ((uint32_t)0x08000000U)         /* Bit27*/
#define EXTI_M4EMASK0_DRC_M4EMASK0_DRCx_28                   ((uint32_t)0x10000000U)         /* Bit28*/
#define EXTI_M4EMASK0_DRC_M4EMASK0_DRCx_29                   ((uint32_t)0x20000000U)         /* Bit29*/
#define EXTI_M4EMASK0_DRC_M4EMASK0_DRCx_30                   ((uint32_t)0x40000000U)         /* Bit30*/
#define EXTI_M4EMASK0_DRC_M4EMASK0_DRCx_31                   ((uint32_t)0x80000000U)         /* Bit31*/

/******** Bit definition for EXTI_M4EMASK1_DRC register  ********/
#define EXTI_M4EMASK1_DRC_M4EMASK1_DRCx                      ((uint32_t)0x07FFFFFFU)         /* Bit[26:0] */
#define EXTI_M4EMASK1_DRC_M4EMASK1_DRCx_0                    ((uint32_t)0x00000001U)         /* Bit0*/
#define EXTI_M4EMASK1_DRC_M4EMASK1_DRCx_1                    ((uint32_t)0x00000002U)         /* Bit1*/
#define EXTI_M4EMASK1_DRC_M4EMASK1_DRCx_2                    ((uint32_t)0x00000004U)         /* Bit2*/
#define EXTI_M4EMASK1_DRC_M4EMASK1_DRCx_3                    ((uint32_t)0x00000008U)         /* Bit3*/
#define EXTI_M4EMASK1_DRC_M4EMASK1_DRCx_4                    ((uint32_t)0x00000010U)         /* Bit4*/
#define EXTI_M4EMASK1_DRC_M4EMASK1_DRCx_5                    ((uint32_t)0x00000020U)         /* Bit5*/
#define EXTI_M4EMASK1_DRC_M4EMASK1_DRCx_6                    ((uint32_t)0x00000040U)         /* Bit6*/
#define EXTI_M4EMASK1_DRC_M4EMASK1_DRCx_7                    ((uint32_t)0x00000080U)         /* Bit7*/
#define EXTI_M4EMASK1_DRC_M4EMASK1_DRCx_8                    ((uint32_t)0x00000100U)         /* Bit8*/
#define EXTI_M4EMASK1_DRC_M4EMASK1_DRCx_9                    ((uint32_t)0x00000200U)         /* Bit9*/
#define EXTI_M4EMASK1_DRC_M4EMASK1_DRCx_10                   ((uint32_t)0x00000400U)         /* Bit10*/
#define EXTI_M4EMASK1_DRC_M4EMASK1_DRCx_11                   ((uint32_t)0x00000800U)         /* Bit11*/
#define EXTI_M4EMASK1_DRC_M4EMASK1_DRCx_12                   ((uint32_t)0x00001000U)         /* Bit12*/
#define EXTI_M4EMASK1_DRC_M4EMASK1_DRCx_13                   ((uint32_t)0x00002000U)         /* Bit13*/
#define EXTI_M4EMASK1_DRC_M4EMASK1_DRCx_14                   ((uint32_t)0x00004000U)         /* Bit14*/
#define EXTI_M4EMASK1_DRC_M4EMASK1_DRCx_15                   ((uint32_t)0x00008000U)         /* Bit15*/
#define EXTI_M4EMASK1_DRC_M4EMASK1_DRCx_16                   ((uint32_t)0x00010000U)         /* Bit16*/
#define EXTI_M4EMASK1_DRC_M4EMASK1_DRCx_17                   ((uint32_t)0x00020000U)         /* Bit17*/
#define EXTI_M4EMASK1_DRC_M4EMASK1_DRCx_18                   ((uint32_t)0x00040000U)         /* Bit18*/
#define EXTI_M4EMASK1_DRC_M4EMASK1_DRCx_19                   ((uint32_t)0x00080000U)         /* Bit19*/
#define EXTI_M4EMASK1_DRC_M4EMASK1_DRCx_20                   ((uint32_t)0x00100000U)         /* Bit20*/
#define EXTI_M4EMASK1_DRC_M4EMASK1_DRCx_21                   ((uint32_t)0x00200000U)         /* Bit21*/
#define EXTI_M4EMASK1_DRC_M4EMASK1_DRCx_22                   ((uint32_t)0x00400000U)         /* Bit22*/
#define EXTI_M4EMASK1_DRC_M4EMASK1_DRCx_23                   ((uint32_t)0x00800000U)         /* Bit23*/
#define EXTI_M4EMASK1_DRC_M4EMASK1_DRCx_24                   ((uint32_t)0x01000000U)         /* Bit24*/
#define EXTI_M4EMASK1_DRC_M4EMASK1_DRCx_25                   ((uint32_t)0x02000000U)         /* Bit25*/
#define EXTI_M4EMASK1_DRC_M4EMASK1_DRCx_26                   ((uint32_t)0x04000000U)         /* Bit26*/

/******** Bit definition for EXTI_TS_SEL register  ********/
#define EXTI_TS_SEL_TSSEL                                    ((uint32_t)0x00000F00U)         /* Bit[11:8] */
#define EXTI_TS_SEL_TSSEL_0                                  ((uint32_t)0x00000100U)         /* Bit8*/
#define EXTI_TS_SEL_TSSEL_1                                  ((uint32_t)0x00000200U)         /* Bit9*/
#define EXTI_TS_SEL_TSSEL_2                                  ((uint32_t)0x00000400U)         /* Bit10*/
#define EXTI_TS_SEL_TSSEL_3                                  ((uint32_t)0x00000800U)         /* Bit11*/

#define EXTI_TS_SEL_EXTI0                                    ((uint32_t)0x00000000U) /* Select EXTI0  as trigger source of timestamp event */
#define EXTI_TS_SEL_EXTI1                                    ((uint32_t)0x00000100U) /* Select EXTI1  as trigger source of timestamp event */
#define EXTI_TS_SEL_EXTI2                                    ((uint32_t)0x00000200U) /* Select EXTI2  as trigger source of timestamp event */
#define EXTI_TS_SEL_EXTI3                                    ((uint32_t)0x00000300U) /* Select EXTI3  as trigger source of timestamp event */
#define EXTI_TS_SEL_EXTI4                                    ((uint32_t)0x00000400U) /* Select EXTI4  as trigger source of timestamp event */
#define EXTI_TS_SEL_EXTI5                                    ((uint32_t)0x00000500U) /* Select EXTI5  as trigger source of timestamp event */
#define EXTI_TS_SEL_EXTI6                                    ((uint32_t)0x00000600U) /* Select EXTI6  as trigger source of timestamp event */
#define EXTI_TS_SEL_EXTI7                                    ((uint32_t)0x00000700U) /* Select EXTI7  as trigger source of timestamp event */
#define EXTI_TS_SEL_EXTI8                                    ((uint32_t)0x00000800U) /* Select EXTI8  as trigger source of timestamp event */
#define EXTI_TS_SEL_EXTI9                                    ((uint32_t)0x00000900U) /* Select EXTI9  as trigger source of timestamp event */
#define EXTI_TS_SEL_EXTI10                                   ((uint32_t)0x00000A00U) /* Select EXTI10 as trigger source of timestamp event */
#define EXTI_TS_SEL_EXTI11                                   ((uint32_t)0x00000B00U) /* Select EXTI11 as trigger source of timestamp event */
#define EXTI_TS_SEL_EXTI12                                   ((uint32_t)0x00000C00U) /* Select EXTI12 as trigger source of timestamp event */
#define EXTI_TS_SEL_EXTI13                                   ((uint32_t)0x00000D00U) /* Select EXTI13 as trigger source of timestamp event */
#define EXTI_TS_SEL_EXTI14                                   ((uint32_t)0x00000E00U) /* Select EXTI14 as trigger source of timestamp event */
#define EXTI_TS_SEL_EXTI15                                   ((uint32_t)0x00000F00U) /* Select EXTI15 as trigger source of timestamp event */

/*** Synchronous Dynamic Random Access Memory(SDRAM) interface ***/

/** Bit definition for SDRAM_BADD1 register  **/
#define SDRAM_BADD1_ADDBASE        ((uint32_t)0x000FFFFFU) /* ADDBASE[19:0] bits (Base address value for SDRAM1) */

/** Bit definition for SDRAM_ADDMASK1 register  **/
#define SDRAM_ADDMASK1_ADDMASK     ((uint32_t)0x000FFFFFU) /* ADDMASK[19:0] bits (Address mask value for SDRAM1) */

/** Bit definition for SDRAM_BADD2 register  **/
#define SDRAM_BADD2_ADDBASE        ((uint32_t)0x000FFFFFU) /* ADDBASE[19:0] bits (Base address value for SDRAM2) */                         

/** Bit definition for SDRAM_ADDMASK2 register  **/
#define SDRAM_ADDMASK2_ADDMASK     ((uint32_t)0x000FFFFFU) /* ADDMASK[19:0] bits (Address mask value for SDRAM2) */

/** Bit definition for SDRAM_CFG1 and SDRAM_CFG2 register  **/
#define SDRAM_CFG_SDRAMEN         ((uint32_t)0x80000000U) /* SDRAM1 or SDRAM2 enable bit */                       
#define SDRAM_CFG_REFRESHEN       ((uint32_t)0x40000000U) /* Refresh commands enable bit */                         
#define SDRAM_CFG_AUTOPCHEN       ((uint32_t)0x00800000U) /* Auto precharge enable bit */ 
#define SDRAM_CFG_BUSWID          ((uint32_t)0x00600000U) /* BUSWID[1:0] bits (bus width) */                     
#define SDRAM_CFG_BUSWID_0        ((uint32_t)0x00200000U) /* Bit 0 */                 
#define SDRAM_CFG_BUSWID_1        ((uint32_t)0x00400000U) /* Bit 1 */                  
#define SDRAM_CFG_BURSTLEN        ((uint32_t)0x001C0000U) /* BURSTLEN[2:0] bits (burst length) */                       
#define SDRAM_CFG_BURSTLEN_0      ((uint32_t)0x00040000U) /* Bit 0 */ 
#define SDRAM_CFG_BURSTLEN_1      ((uint32_t)0x00080000U) /* Bit 1 */ 
#define SDRAM_CFG_BURSTLEN_2      ((uint32_t)0x00100000U) /* Bit 2 */                    
#define SDRAM_CFG_CASLATENCY      ((uint32_t)0x00030000U) /* CASLATENCY[1:0] bits (CAS latency) */                       
#define SDRAM_CFG_CASLATENCY_0    ((uint32_t)0x00010000U) /* Bit 0 */ 
#define SDRAM_CFG_CASLATENCY_1    ((uint32_t)0x00020000U) /* Bit 1 */                    
#define SDRAM_CFG_PREFCHRDEN      ((uint32_t)0x00000200U) /* Prefetch read enable bit */  
#define SDRAM_CFG_SOMEN           ((uint32_t)0x00000100U) /* Write buffer store on miss(SOM) enable bit */  
#define SDRAM_CFG_BANKINTRLEN     ((uint32_t)0x00000010U) /* Bank interleaving enable bit */  
#define SDRAM_CFG_ADDCFG          ((uint32_t)0x0000000FU) /* ADDCFG[3:0] bits (Address organization configuration of SDRAM1 or SDRAM2) */                    
#define SDRAM_CFG_ADDCFG_0        ((uint32_t)0x00000001U) /* Bit 0 */                     
#define SDRAM_CFG_ADDCFG_1        ((uint32_t)0x00000002U) /* Bit 1 */                     
#define SDRAM_CFG_ADDCFG_2        ((uint32_t)0x00000004U) /* Bit 2 */                      
#define SDRAM_CFG_ADDCFG_3        ((uint32_t)0x00000008U) /* Bit 3 */    

/** Bit definition for SDRAM_RAT register  **/
#define SDRAM_RAT_TRAS             ((uint32_t)0x0000003FU) /* TRAS[5:0] bits (Row active time) */  

/** Bit definition for SDRAM_RCT register  **/
#define SDRAM_RCT_TRC              ((uint32_t)0x0000003FU) /* TRC[5:0] bits (Row cycle time) */ 

/** Bit definition for SDRAM_RRDLY register  **/
#define SDRAM_RRDLY_TRRD           ((uint32_t)0x0000003FU) /* TRRD[5:0] bits (Row active to row active delay time) */ 

/** Bit definition for SDRAM_PT register  **/
#define SDRAM_PT_TRP               ((uint32_t)0x0000003FU) /* TRP[5:0] bits (Precharge time) */ 

/** Bit definition for SDRAM_WRT register  **/
#define SDRAM_WRT_TWR              ((uint32_t)0x0000003FU) /* TWR[5:0] bits (Write recovery time) */ 

/** Bit definition for SDRAM_RFCT register  **/
#define SDRAM_RFCT_TRFC            ((uint32_t)0x0000003FU) /* TRFC[5:0] bits (Refresh cycle time) */ 

/** Bit definition for SDRAM_RCDLY register  **/
#define SDRAM_RCDLY_TRCD           ((uint32_t)0x0000000FU) /* TRCD[3:0] bits (RAS to CAS delay time) */ 

/** Bit definition for SDRAM_RI register  **/
#define SDRAM_RI_TRI               ((uint32_t)0x00FFFFFFU) /* TRI[23:0] bits (Refresh interval time) */ 

/** Bit definition for SDRAM_CBO register  **/
#define SDRAM_CBO_DUMMY            ((uint32_t)0xFFFFFFFFU) /* DUMMY[31:0] bits (Dummy data) */ 

/** Bit definition for SDRAM_OR register  **/
#define SDRAM_OR_DUMMY             ((uint32_t)0xFFFFFFFFU) /* DUMMY[31:0] bits (Dummy data) */ 

/** Bit definition for SDRAM_OS register  **/
#define SDRAM_OS_CKEN              ((uint32_t)0x40000000U) /* Clock enable bit */ 
#define SDRAM_OS_OPCODE            ((uint32_t)0x30000000U) /* OPCODE[1:0] bits (Operation code) */  
#define SDRAM_OS_OPCODE_0          ((uint32_t)0x10000000U) /* Bit 0 */
#define SDRAM_OS_OPCODE_1          ((uint32_t)0x20000000U) /* Bit 1 */
#define SDRAM_OS_CS                ((uint32_t)0x03000000U) /* CS[1:0] bits (Chip select) */  
#define SDRAM_OS_CS_0              ((uint32_t)0x01000000U) /* Bit 0 */
#define SDRAM_OS_CS_1              ((uint32_t)0x02000000U) /* Bit 1 */
#define SDRAM_OS_BANKADD           ((uint32_t)0x00030000U) /* BANKADD[1:0] bits (Bank address) */ 
#define SDRAM_OS_BANKADD_0         ((uint32_t)0x00010000U) /* Bit 0 */
#define SDRAM_OS_BANKADD_1         ((uint32_t)0x00020000U) /* Bit 1 */
#define SDRAM_OS_ADD               ((uint32_t)0x00003FFFU) /* ADD[3:0] bits (Address) */      


/** Bit definition for SDRAM_IINFO register  **/
#define SDRAM_IINFO_SYNCMEMBUFSIZE ((uint32_t)0x00FF0000U) /* SYNCMEMBUFSIZE[7:0] bits (Synchronous memory buffer size) */                            

/** Bit definition for SDRAM_WP register  **/
#define SDRAM_WP_WP1                ((uint32_t)0x00000001U) /* SRAM1 Write protection */   
#define SDRAM_WP_WP2                ((uint32_t)0x00000002U) /* SRAM2 Write protection */ 


/******** Bit definition for RCC_PLL1CTRL1 register  ********/
#define RCC_PLL1CTRL1_PLL1SRC                            ((uint32_t)0x30000000U)         /* Bit[29:28] */
#define RCC_PLL1CTRL1_PLL1SRC_0                          ((uint32_t)0x10000000U)         /* Bit28*/
#define RCC_PLL1CTRL1_PLL1SRC_1                          ((uint32_t)0x20000000U)         /* Bit29*/
#define RCC_PLL1CTRL1_PLL1PHLK                                ((uint32_t)0x00100000U)         /* Bit[20] */
#define RCC_PLL1CTRL1_PLL1LDOEN                               ((uint32_t)0x00080000U)         /* Bit[19] */
#define RCC_PLL1CTRL1_PLL1EN                                  ((uint32_t)0x00040000U)         /* Bit[18] */
#define RCC_PLL1CTRL1_PLL1RST                                 ((uint32_t)0x00020000U)         /* Bit[17] */
#define RCC_PLL1CTRL1_PLL1PD                                  ((uint32_t)0x00010000U)         /* Bit[16] */
#define RCC_PLL1CTRL1_PLL1BWAJ                          ((uint32_t)0x00000FFFU)         /* Bit */
#define RCC_PLL1CTRL1_PLL1BWAJ_0                        ((uint32_t)0x00000001U)         /* Bit0*/
#define RCC_PLL1CTRL1_PLL1BWAJ_1                        ((uint32_t)0x00000002U)         /* Bit1*/
#define RCC_PLL1CTRL1_PLL1BWAJ_2                        ((uint32_t)0x00000004U)         /* Bit2*/
#define RCC_PLL1CTRL1_PLL1BWAJ_3                        ((uint32_t)0x00000008U)         /* Bit3*/
#define RCC_PLL1CTRL1_PLL1BWAJ_4                        ((uint32_t)0x00000010U)         /* Bit4*/
#define RCC_PLL1CTRL1_PLL1BWAJ_5                        ((uint32_t)0x00000020U)         /* Bit5*/
#define RCC_PLL1CTRL1_PLL1BWAJ_6                        ((uint32_t)0x00000040U)         /* Bit6*/
#define RCC_PLL1CTRL1_PLL1BWAJ_7                        ((uint32_t)0x00000080U)         /* Bit7*/
#define RCC_PLL1CTRL1_PLL1BWAJ_8                        ((uint32_t)0x00000100U)         /* Bit8*/
#define RCC_PLL1CTRL1_PLL1BWAJ_9                        ((uint32_t)0x00000200U)         /* Bit9*/
#define RCC_PLL1CTRL1_PLL1BWAJ_10                       ((uint32_t)0x00000400U)         /* Bit10*/
#define RCC_PLL1CTRL1_PLL1BWAJ_11                       ((uint32_t)0x00000800U)         /* Bit11*/

/******** Bit definition for RCC_PLL1CTRL2 register  ********/
#define RCC_PLL1CTRL2_PLL1CLKR                           ((uint32_t)0xFC000000U)         /* Bit[31:26] */
#define RCC_PLL1CTRL2_PLL1CLKR_0                         ((uint32_t)0x04000000U)         /* Bit26*/
#define RCC_PLL1CTRL2_PLL1CLKR_1                         ((uint32_t)0x08000000U)         /* Bit27*/
#define RCC_PLL1CTRL2_PLL1CLKR_2                         ((uint32_t)0x10000000U)         /* Bit28*/
#define RCC_PLL1CTRL2_PLL1CLKR_3                         ((uint32_t)0x20000000U)         /* Bit29*/
#define RCC_PLL1CTRL2_PLL1CLKR_4                         ((uint32_t)0x40000000U)         /* Bit30*/
#define RCC_PLL1CTRL2_PLL1CLKR_5                         ((uint32_t)0x80000000U)         /* Bit31*/
#define RCC_PLL1CTRL2_PLL1CLKF                          ((uint32_t)0x03FFFFFFU)         /* Bit */
#define RCC_PLL1CTRL2_PLL1CLKF_0                        ((uint32_t)0x00000001U)         /* Bit0*/
#define RCC_PLL1CTRL2_PLL1CLKF_1                        ((uint32_t)0x00000002U)         /* Bit1*/
#define RCC_PLL1CTRL2_PLL1CLKF_2                        ((uint32_t)0x00000004U)         /* Bit2*/
#define RCC_PLL1CTRL2_PLL1CLKF_3                        ((uint32_t)0x00000008U)         /* Bit3*/
#define RCC_PLL1CTRL2_PLL1CLKF_4                        ((uint32_t)0x00000010U)         /* Bit4*/
#define RCC_PLL1CTRL2_PLL1CLKF_5                        ((uint32_t)0x00000020U)         /* Bit5*/
#define RCC_PLL1CTRL2_PLL1CLKF_6                        ((uint32_t)0x00000040U)         /* Bit6*/
#define RCC_PLL1CTRL2_PLL1CLKF_7                        ((uint32_t)0x00000080U)         /* Bit7*/
#define RCC_PLL1CTRL2_PLL1CLKF_8                        ((uint32_t)0x00000100U)         /* Bit8*/
#define RCC_PLL1CTRL2_PLL1CLKF_9                        ((uint32_t)0x00000200U)         /* Bit9*/
#define RCC_PLL1CTRL2_PLL1CLKF_10                       ((uint32_t)0x00000400U)         /* Bit10*/
#define RCC_PLL1CTRL2_PLL1CLKF_11                       ((uint32_t)0x00000800U)         /* Bit11*/
#define RCC_PLL1CTRL2_PLL1CLKF_12                       ((uint32_t)0x00001000U)         /* Bit12*/
#define RCC_PLL1CTRL2_PLL1CLKF_13                       ((uint32_t)0x00002000U)         /* Bit13*/
#define RCC_PLL1CTRL2_PLL1CLKF_14                       ((uint32_t)0x00004000U)         /* Bit14*/
#define RCC_PLL1CTRL2_PLL1CLKF_15                       ((uint32_t)0x00008000U)         /* Bit15*/
#define RCC_PLL1CTRL2_PLL1CLKF_16                       ((uint32_t)0x00010000U)         /* Bit16*/
#define RCC_PLL1CTRL2_PLL1CLKF_17                       ((uint32_t)0x00020000U)         /* Bit17*/
#define RCC_PLL1CTRL2_PLL1CLKF_18                       ((uint32_t)0x00040000U)         /* Bit18*/
#define RCC_PLL1CTRL2_PLL1CLKF_19                       ((uint32_t)0x00080000U)         /* Bit19*/
#define RCC_PLL1CTRL2_PLL1CLKF_20                       ((uint32_t)0x00100000U)         /* Bit20*/
#define RCC_PLL1CTRL2_PLL1CLKF_21                       ((uint32_t)0x00200000U)         /* Bit21*/
#define RCC_PLL1CTRL2_PLL1CLKF_22                       ((uint32_t)0x00400000U)         /* Bit22*/
#define RCC_PLL1CTRL2_PLL1CLKF_23                       ((uint32_t)0x00800000U)         /* Bit23*/
#define RCC_PLL1CTRL2_PLL1CLKF_24                       ((uint32_t)0x01000000U)         /* Bit24*/
#define RCC_PLL1CTRL2_PLL1CLKF_25                       ((uint32_t)0x02000000U)         /* Bit25*/

/******** Bit definition for RCC_PLL2CTRL1 register  ********/
#define RCC_PLL2CTRL1_PLL2SRC                            ((uint32_t)0x30000000U)         /* Bit[29:28] */
#define RCC_PLL2CTRL1_PLL2SRC_0                          ((uint32_t)0x10000000U)         /* Bit28*/
#define RCC_PLL2CTRL1_PLL2SRC_1                          ((uint32_t)0x20000000U)         /* Bit29*/
#define RCC_PLL2CTRL1_PLL2PHLK                                ((uint32_t)0x00100000U)         /* Bit[20] */
#define RCC_PLL2CTRL1_PLL2LDOEN                               ((uint32_t)0x00080000U)         /* Bit[19] */
#define RCC_PLL2CTRL1_PLL2EN                                  ((uint32_t)0x00040000U)         /* Bit[18] */
#define RCC_PLL2CTRL1_PLL2RST                                 ((uint32_t)0x00020000U)         /* Bit[17] */
#define RCC_PLL2CTRL1_PLL2PD                                  ((uint32_t)0x00010000U)         /* Bit[16] */
#define RCC_PLL2CTRL1_PLL2BWAJ                          ((uint32_t)0x00000FFFU)         /* Bit */
#define RCC_PLL2CTRL1_PLL2BWAJ_0                        ((uint32_t)0x00000001U)         /* Bit0*/
#define RCC_PLL2CTRL1_PLL2BWAJ_1                        ((uint32_t)0x00000002U)         /* Bit1*/
#define RCC_PLL2CTRL1_PLL2BWAJ_2                        ((uint32_t)0x00000004U)         /* Bit2*/
#define RCC_PLL2CTRL1_PLL2BWAJ_3                        ((uint32_t)0x00000008U)         /* Bit3*/
#define RCC_PLL2CTRL1_PLL2BWAJ_4                        ((uint32_t)0x00000010U)         /* Bit4*/
#define RCC_PLL2CTRL1_PLL2BWAJ_5                        ((uint32_t)0x00000020U)         /* Bit5*/
#define RCC_PLL2CTRL1_PLL2BWAJ_6                        ((uint32_t)0x00000040U)         /* Bit6*/
#define RCC_PLL2CTRL1_PLL2BWAJ_7                        ((uint32_t)0x00000080U)         /* Bit7*/
#define RCC_PLL2CTRL1_PLL2BWAJ_8                        ((uint32_t)0x00000100U)         /* Bit8*/
#define RCC_PLL2CTRL1_PLL2BWAJ_9                        ((uint32_t)0x00000200U)         /* Bit9*/
#define RCC_PLL2CTRL1_PLL2BWAJ_10                       ((uint32_t)0x00000400U)         /* Bit10*/
#define RCC_PLL2CTRL1_PLL2BWAJ_11                       ((uint32_t)0x00000800U)         /* Bit11*/

/******** Bit definition for RCC_PLL2CTRL2 register  ********/
#define RCC_PLL2CTRL2_PLL2CLKR                           ((uint32_t)0xFC000000U)         /* Bit[31:26] */
#define RCC_PLL2CTRL2_PLL2CLKR_0                         ((uint32_t)0x04000000U)         /* Bit26*/
#define RCC_PLL2CTRL2_PLL2CLKR_1                         ((uint32_t)0x08000000U)         /* Bit27*/
#define RCC_PLL2CTRL2_PLL2CLKR_2                         ((uint32_t)0x10000000U)         /* Bit28*/
#define RCC_PLL2CTRL2_PLL2CLKR_3                         ((uint32_t)0x20000000U)         /* Bit29*/
#define RCC_PLL2CTRL2_PLL2CLKR_4                         ((uint32_t)0x40000000U)         /* Bit30*/
#define RCC_PLL2CTRL2_PLL2CLKR_5                         ((uint32_t)0x80000000U)         /* Bit31*/
#define RCC_PLL2CTRL2_PLL2CLKF                          ((uint32_t)0x03FFFFFFU)         /* Bit */
#define RCC_PLL2CTRL2_PLL2CLKF_0                        ((uint32_t)0x00000001U)         /* Bit0*/
#define RCC_PLL2CTRL2_PLL2CLKF_1                        ((uint32_t)0x00000002U)         /* Bit1*/
#define RCC_PLL2CTRL2_PLL2CLKF_2                        ((uint32_t)0x00000004U)         /* Bit2*/
#define RCC_PLL2CTRL2_PLL2CLKF_3                        ((uint32_t)0x00000008U)         /* Bit3*/
#define RCC_PLL2CTRL2_PLL2CLKF_4                        ((uint32_t)0x00000010U)         /* Bit4*/
#define RCC_PLL2CTRL2_PLL2CLKF_5                        ((uint32_t)0x00000020U)         /* Bit5*/
#define RCC_PLL2CTRL2_PLL2CLKF_6                        ((uint32_t)0x00000040U)         /* Bit6*/
#define RCC_PLL2CTRL2_PLL2CLKF_7                        ((uint32_t)0x00000080U)         /* Bit7*/
#define RCC_PLL2CTRL2_PLL2CLKF_8                        ((uint32_t)0x00000100U)         /* Bit8*/
#define RCC_PLL2CTRL2_PLL2CLKF_9                        ((uint32_t)0x00000200U)         /* Bit9*/
#define RCC_PLL2CTRL2_PLL2CLKF_10                       ((uint32_t)0x00000400U)         /* Bit10*/
#define RCC_PLL2CTRL2_PLL2CLKF_11                       ((uint32_t)0x00000800U)         /* Bit11*/
#define RCC_PLL2CTRL2_PLL2CLKF_12                       ((uint32_t)0x00001000U)         /* Bit12*/
#define RCC_PLL2CTRL2_PLL2CLKF_13                       ((uint32_t)0x00002000U)         /* Bit13*/
#define RCC_PLL2CTRL2_PLL2CLKF_14                       ((uint32_t)0x00004000U)         /* Bit14*/
#define RCC_PLL2CTRL2_PLL2CLKF_15                       ((uint32_t)0x00008000U)         /* Bit15*/
#define RCC_PLL2CTRL2_PLL2CLKF_16                       ((uint32_t)0x00010000U)         /* Bit16*/
#define RCC_PLL2CTRL2_PLL2CLKF_17                       ((uint32_t)0x00020000U)         /* Bit17*/
#define RCC_PLL2CTRL2_PLL2CLKF_18                       ((uint32_t)0x00040000U)         /* Bit18*/
#define RCC_PLL2CTRL2_PLL2CLKF_19                       ((uint32_t)0x00080000U)         /* Bit19*/
#define RCC_PLL2CTRL2_PLL2CLKF_20                       ((uint32_t)0x00100000U)         /* Bit20*/
#define RCC_PLL2CTRL2_PLL2CLKF_21                       ((uint32_t)0x00200000U)         /* Bit21*/
#define RCC_PLL2CTRL2_PLL2CLKF_22                       ((uint32_t)0x00400000U)         /* Bit22*/
#define RCC_PLL2CTRL2_PLL2CLKF_23                       ((uint32_t)0x00800000U)         /* Bit23*/
#define RCC_PLL2CTRL2_PLL2CLKF_24                       ((uint32_t)0x01000000U)         /* Bit24*/
#define RCC_PLL2CTRL2_PLL2CLKF_25                       ((uint32_t)0x02000000U)         /* Bit25*/


/******** Bit definition for RCC_PLL3CTRL1 register  ********/
#define RCC_PLL3CTRL1_PLL3SRC                            ((uint32_t)0x30000000U)         /* Bit[29:28] */
#define RCC_PLL3CTRL1_PLL3SRC_0                          ((uint32_t)0x10000000U)         /* Bit28*/
#define RCC_PLL3CTRL1_PLL3SRC_1                          ((uint32_t)0x20000000U)         /* Bit29*/
#define RCC_PLL3CTRL1_PLL3PHLK                                ((uint32_t)0x00100000U)         /* Bit[20] */
#define RCC_PLL3CTRL1_PLL3LDOEN                               ((uint32_t)0x00080000U)         /* Bit[19] */
#define RCC_PLL3CTRL1_PLL3EN                                  ((uint32_t)0x00040000U)         /* Bit[18] */
#define RCC_PLL3CTRL1_PLL3RST                                 ((uint32_t)0x00020000U)         /* Bit[17] */
#define RCC_PLL3CTRL1_PLL3PD                                  ((uint32_t)0x00010000U)         /* Bit[16] */
#define RCC_PLL3CTRL1_PLL3BWAJ                          ((uint32_t)0x00000FFFU)         /* Bit */
#define RCC_PLL3CTRL1_PLL3BWAJ_0                        ((uint32_t)0x00000001U)         /* Bit0*/
#define RCC_PLL3CTRL1_PLL3BWAJ_1                        ((uint32_t)0x00000002U)         /* Bit1*/
#define RCC_PLL3CTRL1_PLL3BWAJ_2                        ((uint32_t)0x00000004U)         /* Bit2*/
#define RCC_PLL3CTRL1_PLL3BWAJ_3                        ((uint32_t)0x00000008U)         /* Bit3*/
#define RCC_PLL3CTRL1_PLL3BWAJ_4                        ((uint32_t)0x00000010U)         /* Bit4*/
#define RCC_PLL3CTRL1_PLL3BWAJ_5                        ((uint32_t)0x00000020U)         /* Bit5*/
#define RCC_PLL3CTRL1_PLL3BWAJ_6                        ((uint32_t)0x00000040U)         /* Bit6*/
#define RCC_PLL3CTRL1_PLL3BWAJ_7                        ((uint32_t)0x00000080U)         /* Bit7*/
#define RCC_PLL3CTRL1_PLL3BWAJ_8                        ((uint32_t)0x00000100U)         /* Bit8*/
#define RCC_PLL3CTRL1_PLL3BWAJ_9                        ((uint32_t)0x00000200U)         /* Bit9*/
#define RCC_PLL3CTRL1_PLL3BWAJ_10                       ((uint32_t)0x00000400U)         /* Bit10*/
#define RCC_PLL3CTRL1_PLL3BWAJ_11                       ((uint32_t)0x00000800U)         /* Bit11*/

/******** Bit definition for RCC_PLL3CTRL2 register  ********/
#define RCC_PLL3CTRL2_PLL3CLKR                           ((uint32_t)0xFC000000U)         /* Bit[31:26] */
#define RCC_PLL3CTRL2_PLL3CLKR_0                         ((uint32_t)0x04000000U)         /* Bit26*/
#define RCC_PLL3CTRL2_PLL3CLKR_1                         ((uint32_t)0x08000000U)         /* Bit27*/
#define RCC_PLL3CTRL2_PLL3CLKR_2                         ((uint32_t)0x10000000U)         /* Bit28*/
#define RCC_PLL3CTRL2_PLL3CLKR_3                         ((uint32_t)0x20000000U)         /* Bit29*/
#define RCC_PLL3CTRL2_PLL3CLKR_4                         ((uint32_t)0x40000000U)         /* Bit30*/
#define RCC_PLL3CTRL2_PLL3CLKR_5                         ((uint32_t)0x80000000U)         /* Bit31*/
#define RCC_PLL3CTRL2_PLL3CLKF                          ((uint32_t)0x03FFFFFFU)         /* Bit */
#define RCC_PLL3CTRL2_PLL3CLKF_0                        ((uint32_t)0x00000001U)         /* Bit0*/
#define RCC_PLL3CTRL2_PLL3CLKF_1                        ((uint32_t)0x00000002U)         /* Bit1*/
#define RCC_PLL3CTRL2_PLL3CLKF_2                        ((uint32_t)0x00000004U)         /* Bit2*/
#define RCC_PLL3CTRL2_PLL3CLKF_3                        ((uint32_t)0x00000008U)         /* Bit3*/
#define RCC_PLL3CTRL2_PLL3CLKF_4                        ((uint32_t)0x00000010U)         /* Bit4*/
#define RCC_PLL3CTRL2_PLL3CLKF_5                        ((uint32_t)0x00000020U)         /* Bit5*/
#define RCC_PLL3CTRL2_PLL3CLKF_6                        ((uint32_t)0x00000040U)         /* Bit6*/
#define RCC_PLL3CTRL2_PLL3CLKF_7                        ((uint32_t)0x00000080U)         /* Bit7*/
#define RCC_PLL3CTRL2_PLL3CLKF_8                        ((uint32_t)0x00000100U)         /* Bit8*/
#define RCC_PLL3CTRL2_PLL3CLKF_9                        ((uint32_t)0x00000200U)         /* Bit9*/
#define RCC_PLL3CTRL2_PLL3CLKF_10                       ((uint32_t)0x00000400U)         /* Bit10*/
#define RCC_PLL3CTRL2_PLL3CLKF_11                       ((uint32_t)0x00000800U)         /* Bit11*/
#define RCC_PLL3CTRL2_PLL3CLKF_12                       ((uint32_t)0x00001000U)         /* Bit12*/
#define RCC_PLL3CTRL2_PLL3CLKF_13                       ((uint32_t)0x00002000U)         /* Bit13*/
#define RCC_PLL3CTRL2_PLL3CLKF_14                       ((uint32_t)0x00004000U)         /* Bit14*/
#define RCC_PLL3CTRL2_PLL3CLKF_15                       ((uint32_t)0x00008000U)         /* Bit15*/
#define RCC_PLL3CTRL2_PLL3CLKF_16                       ((uint32_t)0x00010000U)         /* Bit16*/
#define RCC_PLL3CTRL2_PLL3CLKF_17                       ((uint32_t)0x00020000U)         /* Bit17*/
#define RCC_PLL3CTRL2_PLL3CLKF_18                       ((uint32_t)0x00040000U)         /* Bit18*/
#define RCC_PLL3CTRL2_PLL3CLKF_19                       ((uint32_t)0x00080000U)         /* Bit19*/
#define RCC_PLL3CTRL2_PLL3CLKF_20                       ((uint32_t)0x00100000U)         /* Bit20*/
#define RCC_PLL3CTRL2_PLL3CLKF_21                       ((uint32_t)0x00200000U)         /* Bit21*/
#define RCC_PLL3CTRL2_PLL3CLKF_22                       ((uint32_t)0x00400000U)         /* Bit22*/
#define RCC_PLL3CTRL2_PLL3CLKF_23                       ((uint32_t)0x00800000U)         /* Bit23*/
#define RCC_PLL3CTRL2_PLL3CLKF_24                       ((uint32_t)0x01000000U)         /* Bit24*/
#define RCC_PLL3CTRL2_PLL3CLKF_25                       ((uint32_t)0x02000000U)         /* Bit25*/


/******** Bit definition for RCC_SHRPLLCTRL1 register  ********/
#define RCC_SHRPLLCTRL1_SHRPLLSRC                          ((uint32_t)0x30000000U)         /* Bit[29:28] */
#define RCC_SHRPLLCTRL1_SHRPLLSRC_0                        ((uint32_t)0x10000000U)         /* Bit28*/
#define RCC_SHRPLLCTRL1_SHRPLLSRC_1                        ((uint32_t)0x20000000U)         /* Bit29*/
#define RCC_SHRPLLCTRL1_SHRPLLPHLK                              ((uint32_t)0x00100000U)         /* Bit[20] */
#define RCC_SHRPLLCTRL1_SHRPLLLDOEN                             ((uint32_t)0x00080000U)         /* Bit[19] */
#define RCC_SHRPLLCTRL1_SHRPLLEN                                ((uint32_t)0x00040000U)         /* Bit[18] */
#define RCC_SHRPLLCTRL1_SHRPLLRST                               ((uint32_t)0x00020000U)         /* Bit[17] */
#define RCC_SHRPLLCTRL1_SHRPLLPD                                ((uint32_t)0x00010000U)         /* Bit[16] */
#define RCC_SHRPLLCTRL1_SHRPLLBWAJ                        ((uint32_t)0x00000FFFU)         /* Bit */
#define RCC_SHRPLLCTRL1_SHRPLLBWAJ_0                      ((uint32_t)0x00000001U)         /* Bit0*/
#define RCC_SHRPLLCTRL1_SHRPLLBWAJ_1                      ((uint32_t)0x00000002U)         /* Bit1*/
#define RCC_SHRPLLCTRL1_SHRPLLBWAJ_2                      ((uint32_t)0x00000004U)         /* Bit2*/
#define RCC_SHRPLLCTRL1_SHRPLLBWAJ_3                      ((uint32_t)0x00000008U)         /* Bit3*/
#define RCC_SHRPLLCTRL1_SHRPLLBWAJ_4                      ((uint32_t)0x00000010U)         /* Bit4*/
#define RCC_SHRPLLCTRL1_SHRPLLBWAJ_5                      ((uint32_t)0x00000020U)         /* Bit5*/
#define RCC_SHRPLLCTRL1_SHRPLLBWAJ_6                      ((uint32_t)0x00000040U)         /* Bit6*/
#define RCC_SHRPLLCTRL1_SHRPLLBWAJ_7                      ((uint32_t)0x00000080U)         /* Bit7*/
#define RCC_SHRPLLCTRL1_SHRPLLBWAJ_8                      ((uint32_t)0x00000100U)         /* Bit8*/
#define RCC_SHRPLLCTRL1_SHRPLLBWAJ_9                      ((uint32_t)0x00000200U)         /* Bit9*/
#define RCC_SHRPLLCTRL1_SHRPLLBWAJ_10                     ((uint32_t)0x00000400U)         /* Bit10*/
#define RCC_SHRPLLCTRL1_SHRPLLBWAJ_11                     ((uint32_t)0x00000800U)         /* Bit11*/

/******** Bit definition for RCC_SHRPLLCTRL2 register  ********/
#define RCC_SHRPLLCTRL2_SHRPLLCLKR                         ((uint32_t)0xFC000000U)         /* Bit[31:26] */
#define RCC_SHRPLLCTRL2_SHRPLLCLKR_0                       ((uint32_t)0x04000000U)         /* Bit26*/
#define RCC_SHRPLLCTRL2_SHRPLLCLKR_1                       ((uint32_t)0x08000000U)         /* Bit27*/
#define RCC_SHRPLLCTRL2_SHRPLLCLKR_2                       ((uint32_t)0x10000000U)         /* Bit28*/
#define RCC_SHRPLLCTRL2_SHRPLLCLKR_3                       ((uint32_t)0x20000000U)         /* Bit29*/
#define RCC_SHRPLLCTRL2_SHRPLLCLKR_4                       ((uint32_t)0x40000000U)         /* Bit30*/
#define RCC_SHRPLLCTRL2_SHRPLLCLKR_5                       ((uint32_t)0x80000000U)         /* Bit31*/
#define RCC_SHRPLLCTRL2_SHRPLLCLKF                        ((uint32_t)0x03FFFFFFU)         /* Bit */
#define RCC_SHRPLLCTRL2_SHRPLLCLKF_0                      ((uint32_t)0x00000001U)         /* Bit0*/
#define RCC_SHRPLLCTRL2_SHRPLLCLKF_1                      ((uint32_t)0x00000002U)         /* Bit1*/
#define RCC_SHRPLLCTRL2_SHRPLLCLKF_2                      ((uint32_t)0x00000004U)         /* Bit2*/
#define RCC_SHRPLLCTRL2_SHRPLLCLKF_3                      ((uint32_t)0x00000008U)         /* Bit3*/
#define RCC_SHRPLLCTRL2_SHRPLLCLKF_4                      ((uint32_t)0x00000010U)         /* Bit4*/
#define RCC_SHRPLLCTRL2_SHRPLLCLKF_5                      ((uint32_t)0x00000020U)         /* Bit5*/
#define RCC_SHRPLLCTRL2_SHRPLLCLKF_6                      ((uint32_t)0x00000040U)         /* Bit6*/
#define RCC_SHRPLLCTRL2_SHRPLLCLKF_7                      ((uint32_t)0x00000080U)         /* Bit7*/
#define RCC_SHRPLLCTRL2_SHRPLLCLKF_8                      ((uint32_t)0x00000100U)         /* Bit8*/
#define RCC_SHRPLLCTRL2_SHRPLLCLKF_9                      ((uint32_t)0x00000200U)         /* Bit9*/
#define RCC_SHRPLLCTRL2_SHRPLLCLKF_10                     ((uint32_t)0x00000400U)         /* Bit10*/
#define RCC_SHRPLLCTRL2_SHRPLLCLKF_11                     ((uint32_t)0x00000800U)         /* Bit11*/
#define RCC_SHRPLLCTRL2_SHRPLLCLKF_12                     ((uint32_t)0x00001000U)         /* Bit12*/
#define RCC_SHRPLLCTRL2_SHRPLLCLKF_13                     ((uint32_t)0x00002000U)         /* Bit13*/
#define RCC_SHRPLLCTRL2_SHRPLLCLKF_14                     ((uint32_t)0x00004000U)         /* Bit14*/
#define RCC_SHRPLLCTRL2_SHRPLLCLKF_15                     ((uint32_t)0x00008000U)         /* Bit15*/
#define RCC_SHRPLLCTRL2_SHRPLLCLKF_16                     ((uint32_t)0x00010000U)         /* Bit16*/
#define RCC_SHRPLLCTRL2_SHRPLLCLKF_17                     ((uint32_t)0x00020000U)         /* Bit17*/
#define RCC_SHRPLLCTRL2_SHRPLLCLKF_18                     ((uint32_t)0x00040000U)         /* Bit18*/
#define RCC_SHRPLLCTRL2_SHRPLLCLKF_19                     ((uint32_t)0x00080000U)         /* Bit19*/
#define RCC_SHRPLLCTRL2_SHRPLLCLKF_20                     ((uint32_t)0x00100000U)         /* Bit20*/
#define RCC_SHRPLLCTRL2_SHRPLLCLKF_21                     ((uint32_t)0x00200000U)         /* Bit21*/
#define RCC_SHRPLLCTRL2_SHRPLLCLKF_22                     ((uint32_t)0x00400000U)         /* Bit22*/
#define RCC_SHRPLLCTRL2_SHRPLLCLKF_23                     ((uint32_t)0x00800000U)         /* Bit23*/
#define RCC_SHRPLLCTRL2_SHRPLLCLKF_24                     ((uint32_t)0x01000000U)         /* Bit24*/
#define RCC_SHRPLLCTRL2_SHRPLLCLKF_25                     ((uint32_t)0x02000000U)         /* Bit25*/

/******** Bit definition for RCC_SRCCTRL1 register  ********/
#define RCC_SRCCTRL1_AFEMSIRDF                               ((uint32_t)0x80000000U)         /* Bit[31] */
#define RCC_SRCCTRL1_AFEHSIRDF                               ((uint32_t)0x40000000U)         /* Bit[30] */

#define RCC_SRCCTRL1_SCLKSTS                            ((uint32_t)0x0C000000U)         /* Bit[27:26] */
#define RCC_SRCCTRL1_SCLKSTS_0                          ((uint32_t)0x04000000U)         /* Bit26*/
#define RCC_SRCCTRL1_SCLKSTS_1                          ((uint32_t)0x08000000U)         /* Bit27*/

#define RCC_SRCCTRL1_SCLKSTS_HSI                        ((uint32_t)0x00000000U)
#define RCC_SRCCTRL1_SCLKSTS_MSI                        ((uint32_t)0x04000000U)
#define RCC_SRCCTRL1_SCLKSTS_HSE                        ((uint32_t)0x08000000U)
#define RCC_SRCCTRL1_SCLKSTS_PLL1                       ((uint32_t)0x0C000000U)

#define RCC_SRCCTRL1_SCLKSW                             ((uint32_t)0x03000000U)         /* Bit[25:24] */
#define RCC_SRCCTRL1_SCLKSW_0                           ((uint32_t)0x01000000U)         /* Bit24*/
#define RCC_SRCCTRL1_SCLKSW_1                           ((uint32_t)0x02000000U)         /* Bit25*/

#define RCC_SRCCTRL1_SCLKSW_HSI                         ((uint32_t)0x00000000U)
#define RCC_SRCCTRL1_SCLKSW_MSI                         ((uint32_t)0x01000000U)
#define RCC_SRCCTRL1_SCLKSW_HSE                         ((uint32_t)0x02000000U)
#define RCC_SRCCTRL1_SCLKSW_PLL1                        ((uint32_t)0x03000000U)

#define RCC_SRCCTRL1_HSERDCNTEN                              ((uint32_t)0x00000100U)         /* Bit[8] */
#define RCC_SRCCTRL1_MSIRDF                                  ((uint32_t)0x00000080U)         /* Bit[7] */
#define RCC_SRCCTRL1_MSIEN                                   ((uint32_t)0x00000040U)         /* Bit[6] */
#define RCC_SRCCTRL1_HSECSSEN                                ((uint32_t)0x00000020U)         /* Bit[5] */
#define RCC_SRCCTRL1_HSEBP                                   ((uint32_t)0x00000010U)         /* Bit[4] */
#define RCC_SRCCTRL1_HSERDF                                  ((uint32_t)0x00000008U)         /* Bit[3] */
#define RCC_SRCCTRL1_HSEEN                                   ((uint32_t)0x00000004U)         /* Bit[2] */
#define RCC_SRCCTRL1_HSIRDF                                  ((uint32_t)0x00000002U)         /* Bit[1] */
#define RCC_SRCCTRL1_HSIEN                                   ((uint32_t)0x00000001U)         /* Bit[0] */

/******** Bit definition for RCC_SRCCTRL2 register  ********/
#define RCC_SRCCTRL2_BORF                                    ((uint32_t)0x40000000U)         /* Bit[30] */
#define RCC_SRCCTRL2_HSICALEF                                ((uint32_t)0x20000000U)         /* Bit[29] */
#define RCC_SRCCTRL2_MSICALEF                                ((uint32_t)0x10000000U)         /* Bit[28] */
#define RCC_SRCCTRL2_M7HYPSEL                                ((uint32_t)0x00020000U)         /* Bit[17] */
#define RCC_SRCCTRL2_AXIHYPSEL                               ((uint32_t)0x00010000U)         /* Bit[16] */
#define RCC_SRCCTRL2_MSICAL                             ((uint32_t)0x00001F00U)         /* Bit[12:8] */
#define RCC_SRCCTRL2_MSICAL_0                           ((uint32_t)0x00000100U)         /* Bit8*/
#define RCC_SRCCTRL2_MSICAL_1                           ((uint32_t)0x00000200U)         /* Bit9*/
#define RCC_SRCCTRL2_MSICAL_2                           ((uint32_t)0x00000400U)         /* Bit10*/
#define RCC_SRCCTRL2_MSICAL_3                           ((uint32_t)0x00000800U)         /* Bit11*/
#define RCC_SRCCTRL2_MSICAL_4                           ((uint32_t)0x00001000U)         /* Bit12*/
#define RCC_SRCCTRL2_MSITRIM                            ((uint32_t)0x0000001FU)         /* Bit */
#define RCC_SRCCTRL2_MSITRIM_0                          ((uint32_t)0x00000001U)         /* Bit0*/
#define RCC_SRCCTRL2_MSITRIM_1                          ((uint32_t)0x00000002U)         /* Bit1*/
#define RCC_SRCCTRL2_MSITRIM_2                          ((uint32_t)0x00000004U)         /* Bit2*/
#define RCC_SRCCTRL2_MSITRIM_3                          ((uint32_t)0x00000008U)         /* Bit3*/
#define RCC_SRCCTRL2_MSITRIM_4                          ((uint32_t)0x00000010U)         /* Bit4*/

/******** Bit definition for RCC_SRCCTRL3 register  ********/
#define RCC_SRCCTRL3_HSICAL                             ((uint32_t)0x01FF0000U)         /* Bit[24:16] */
#define RCC_SRCCTRL3_HSICAL_0                           ((uint32_t)0x00010000U)         /* Bit16*/
#define RCC_SRCCTRL3_HSICAL_1                           ((uint32_t)0x00020000U)         /* Bit17*/
#define RCC_SRCCTRL3_HSICAL_2                           ((uint32_t)0x00040000U)         /* Bit18*/
#define RCC_SRCCTRL3_HSICAL_3                           ((uint32_t)0x00080000U)         /* Bit19*/
#define RCC_SRCCTRL3_HSICAL_4                           ((uint32_t)0x00100000U)         /* Bit20*/
#define RCC_SRCCTRL3_HSICAL_5                           ((uint32_t)0x00200000U)         /* Bit21*/
#define RCC_SRCCTRL3_HSICAL_6                           ((uint32_t)0x00400000U)         /* Bit22*/
#define RCC_SRCCTRL3_HSICAL_7                           ((uint32_t)0x00800000U)         /* Bit23*/
#define RCC_SRCCTRL3_HSICAL_8                           ((uint32_t)0x01000000U)         /* Bit24*/
#define RCC_SRCCTRL3_HSITRIM                            ((uint32_t)0x000001FFU)         /* Bit */
#define RCC_SRCCTRL3_HSITRIM_0                          ((uint32_t)0x00000001U)         /* Bit0*/
#define RCC_SRCCTRL3_HSITRIM_1                          ((uint32_t)0x00000002U)         /* Bit1*/
#define RCC_SRCCTRL3_HSITRIM_2                          ((uint32_t)0x00000004U)         /* Bit2*/
#define RCC_SRCCTRL3_HSITRIM_3                          ((uint32_t)0x00000008U)         /* Bit3*/
#define RCC_SRCCTRL3_HSITRIM_4                          ((uint32_t)0x00000010U)         /* Bit4*/
#define RCC_SRCCTRL3_HSITRIM_5                          ((uint32_t)0x00000020U)         /* Bit5*/
#define RCC_SRCCTRL3_HSITRIM_6                          ((uint32_t)0x00000040U)         /* Bit6*/
#define RCC_SRCCTRL3_HSITRIM_7                          ((uint32_t)0x00000080U)         /* Bit7*/
#define RCC_SRCCTRL3_HSITRIM_8                          ((uint32_t)0x00000100U)         /* Bit8*/

/******** Bit definition for RCC_PLL1DIV register  ********/
#define RCC_PLL1DIV_PLL1CDIV                           ((uint32_t)0x003F0000U)         /* Bit[21:16] */
#define RCC_PLL1DIV_PLL1CDIV_0                         ((uint32_t)0x00010000U)         /* Bit16*/
#define RCC_PLL1DIV_PLL1CDIV_1                         ((uint32_t)0x00020000U)         /* Bit17*/
#define RCC_PLL1DIV_PLL1CDIV_2                         ((uint32_t)0x00040000U)         /* Bit18*/
#define RCC_PLL1DIV_PLL1CDIV_3                         ((uint32_t)0x00080000U)         /* Bit19*/
#define RCC_PLL1DIV_PLL1CDIV_4                         ((uint32_t)0x00100000U)         /* Bit20*/
#define RCC_PLL1DIV_PLL1CDIV_5                         ((uint32_t)0x00200000U)         /* Bit21*/

#define RCC_PLL1DIV_PLL1CDIV_DIV1                      ((uint32_t)0x00010000U)
#define RCC_PLL1DIV_PLL1CDIV_DIV2                      ((uint32_t)0x00020000U)
#define RCC_PLL1DIV_PLL1CDIV_DIV3                      ((uint32_t)0x00030000U)
#define RCC_PLL1DIV_PLL1CDIV_DIV4                      ((uint32_t)0x00040000U)
#define RCC_PLL1DIV_PLL1CDIV_DIV5                      ((uint32_t)0x00050000U)
#define RCC_PLL1DIV_PLL1CDIV_DIV6                      ((uint32_t)0x00060000U)
#define RCC_PLL1DIV_PLL1CDIV_DIV7                      ((uint32_t)0x00070000U)
#define RCC_PLL1DIV_PLL1CDIV_DIV8                      ((uint32_t)0x00080000U)
#define RCC_PLL1DIV_PLL1CDIV_DIV9                      ((uint32_t)0x00090000U)
#define RCC_PLL1DIV_PLL1CDIV_DIV10                     ((uint32_t)0x000A0000U)
#define RCC_PLL1DIV_PLL1CDIV_DIV11                     ((uint32_t)0x000B0000U)
#define RCC_PLL1DIV_PLL1CDIV_DIV12                     ((uint32_t)0x000C0000U)
#define RCC_PLL1DIV_PLL1CDIV_DIV13                     ((uint32_t)0x000D0000U)
#define RCC_PLL1DIV_PLL1CDIV_DIV14                     ((uint32_t)0x000E0000U)
#define RCC_PLL1DIV_PLL1CDIV_DIV15                     ((uint32_t)0x000F0000U)
#define RCC_PLL1DIV_PLL1CDIV_DIV16                     ((uint32_t)0x00100000U)
#define RCC_PLL1DIV_PLL1CDIV_DIV17                     ((uint32_t)0x00110000U)
#define RCC_PLL1DIV_PLL1CDIV_DIV18                     ((uint32_t)0x00120000U)
#define RCC_PLL1DIV_PLL1CDIV_DIV19                     ((uint32_t)0x00130000U)
#define RCC_PLL1DIV_PLL1CDIV_DIV20                     ((uint32_t)0x00140000U)
#define RCC_PLL1DIV_PLL1CDIV_DIV21                     ((uint32_t)0x00150000U)
#define RCC_PLL1DIV_PLL1CDIV_DIV22                     ((uint32_t)0x00160000U)
#define RCC_PLL1DIV_PLL1CDIV_DIV23                     ((uint32_t)0x00170000U)
#define RCC_PLL1DIV_PLL1CDIV_DIV24                     ((uint32_t)0x00180000U)
#define RCC_PLL1DIV_PLL1CDIV_DIV25                     ((uint32_t)0x00190000U)
#define RCC_PLL1DIV_PLL1CDIV_DIV26                     ((uint32_t)0x001A0000U)
#define RCC_PLL1DIV_PLL1CDIV_DIV27                     ((uint32_t)0x001B0000U)
#define RCC_PLL1DIV_PLL1CDIV_DIV28                     ((uint32_t)0x001C0000U)
#define RCC_PLL1DIV_PLL1CDIV_DIV29                     ((uint32_t)0x001D0000U)
#define RCC_PLL1DIV_PLL1CDIV_DIV30                     ((uint32_t)0x001E0000U)
#define RCC_PLL1DIV_PLL1CDIV_DIV31                     ((uint32_t)0x001F0000U)
#define RCC_PLL1DIV_PLL1CDIV_DIV32                     ((uint32_t)0x00200000U)
#define RCC_PLL1DIV_PLL1CDIV_DIV33                     ((uint32_t)0x00210000U)
#define RCC_PLL1DIV_PLL1CDIV_DIV34                     ((uint32_t)0x00220000U)
#define RCC_PLL1DIV_PLL1CDIV_DIV35                     ((uint32_t)0x00230000U)
#define RCC_PLL1DIV_PLL1CDIV_DIV36                     ((uint32_t)0x00240000U)
#define RCC_PLL1DIV_PLL1CDIV_DIV37                     ((uint32_t)0x00250000U)
#define RCC_PLL1DIV_PLL1CDIV_DIV38                     ((uint32_t)0x00260000U)
#define RCC_PLL1DIV_PLL1CDIV_DIV39                     ((uint32_t)0x00270000U)
#define RCC_PLL1DIV_PLL1CDIV_DIV40                     ((uint32_t)0x00280000U)
#define RCC_PLL1DIV_PLL1CDIV_DIV41                     ((uint32_t)0x00290000U)
#define RCC_PLL1DIV_PLL1CDIV_DIV42                     ((uint32_t)0x002A0000U)
#define RCC_PLL1DIV_PLL1CDIV_DIV43                     ((uint32_t)0x002B0000U)
#define RCC_PLL1DIV_PLL1CDIV_DIV44                     ((uint32_t)0x002C0000U)
#define RCC_PLL1DIV_PLL1CDIV_DIV45                     ((uint32_t)0x002D0000U)
#define RCC_PLL1DIV_PLL1CDIV_DIV46                     ((uint32_t)0x002E0000U)
#define RCC_PLL1DIV_PLL1CDIV_DIV47                     ((uint32_t)0x002F0000U)
#define RCC_PLL1DIV_PLL1CDIV_DIV48                     ((uint32_t)0x00300000U)
#define RCC_PLL1DIV_PLL1CDIV_DIV49                     ((uint32_t)0x00310000U)
#define RCC_PLL1DIV_PLL1CDIV_DIV50                     ((uint32_t)0x00320000U)
#define RCC_PLL1DIV_PLL1CDIV_DIV51                     ((uint32_t)0x00330000U)
#define RCC_PLL1DIV_PLL1CDIV_DIV52                     ((uint32_t)0x00340000U)
#define RCC_PLL1DIV_PLL1CDIV_DIV53                     ((uint32_t)0x00350000U)
#define RCC_PLL1DIV_PLL1CDIV_DIV54                     ((uint32_t)0x00360000U)
#define RCC_PLL1DIV_PLL1CDIV_DIV55                     ((uint32_t)0x00370000U)
#define RCC_PLL1DIV_PLL1CDIV_DIV56                     ((uint32_t)0x00380000U)
#define RCC_PLL1DIV_PLL1CDIV_DIV57                     ((uint32_t)0x00390000U)
#define RCC_PLL1DIV_PLL1CDIV_DIV58                     ((uint32_t)0x003A0000U)
#define RCC_PLL1DIV_PLL1CDIV_DIV59                     ((uint32_t)0x003B0000U)
#define RCC_PLL1DIV_PLL1CDIV_DIV60                     ((uint32_t)0x003C0000U)
#define RCC_PLL1DIV_PLL1CDIV_DIV61                     ((uint32_t)0x003D0000U)
#define RCC_PLL1DIV_PLL1CDIV_DIV62                     ((uint32_t)0x003E0000U)
#define RCC_PLL1DIV_PLL1CDIV_DIV63                     ((uint32_t)0x003F0000U)

#define RCC_PLL1DIV_PLL1BDIV                           ((uint32_t)0x00003F00U)         /* Bit[13:8] */
#define RCC_PLL1DIV_PLL1BDIV_0                         ((uint32_t)0x00000100U)         /* Bit8*/
#define RCC_PLL1DIV_PLL1BDIV_1                         ((uint32_t)0x00000200U)         /* Bit9*/
#define RCC_PLL1DIV_PLL1BDIV_2                         ((uint32_t)0x00000400U)         /* Bit10*/
#define RCC_PLL1DIV_PLL1BDIV_3                         ((uint32_t)0x00000800U)         /* Bit11*/
#define RCC_PLL1DIV_PLL1BDIV_4                         ((uint32_t)0x00001000U)         /* Bit12*/
#define RCC_PLL1DIV_PLL1BDIV_5                         ((uint32_t)0x00002000U)         /* Bit13*/

#define RCC_PLL1DIV_PLL1BDIV_DIV1                      ((uint32_t)0x00000100U)
#define RCC_PLL1DIV_PLL1BDIV_DIV2                      ((uint32_t)0x00000200U)
#define RCC_PLL1DIV_PLL1BDIV_DIV3                      ((uint32_t)0x00000300U)
#define RCC_PLL1DIV_PLL1BDIV_DIV4                      ((uint32_t)0x00000400U)
#define RCC_PLL1DIV_PLL1BDIV_DIV5                      ((uint32_t)0x00000500U)
#define RCC_PLL1DIV_PLL1BDIV_DIV6                      ((uint32_t)0x00000600U)
#define RCC_PLL1DIV_PLL1BDIV_DIV7                      ((uint32_t)0x00000700U)
#define RCC_PLL1DIV_PLL1BDIV_DIV8                      ((uint32_t)0x00000800U)
#define RCC_PLL1DIV_PLL1BDIV_DIV9                      ((uint32_t)0x00000900U)
#define RCC_PLL1DIV_PLL1BDIV_DIV10                     ((uint32_t)0x00000A00U)
#define RCC_PLL1DIV_PLL1BDIV_DIV11                     ((uint32_t)0x00000B00U)
#define RCC_PLL1DIV_PLL1BDIV_DIV12                     ((uint32_t)0x00000C00U)
#define RCC_PLL1DIV_PLL1BDIV_DIV13                     ((uint32_t)0x00000D00U)
#define RCC_PLL1DIV_PLL1BDIV_DIV14                     ((uint32_t)0x00000E00U)
#define RCC_PLL1DIV_PLL1BDIV_DIV15                     ((uint32_t)0x00000F00U)
#define RCC_PLL1DIV_PLL1BDIV_DIV16                     ((uint32_t)0x00001000U)
#define RCC_PLL1DIV_PLL1BDIV_DIV17                     ((uint32_t)0x00001100U)
#define RCC_PLL1DIV_PLL1BDIV_DIV18                     ((uint32_t)0x00001200U)
#define RCC_PLL1DIV_PLL1BDIV_DIV19                     ((uint32_t)0x00001300U)
#define RCC_PLL1DIV_PLL1BDIV_DIV20                     ((uint32_t)0x00001400U)
#define RCC_PLL1DIV_PLL1BDIV_DIV21                     ((uint32_t)0x00001500U)
#define RCC_PLL1DIV_PLL1BDIV_DIV22                     ((uint32_t)0x00001600U)
#define RCC_PLL1DIV_PLL1BDIV_DIV23                     ((uint32_t)0x00001700U)
#define RCC_PLL1DIV_PLL1BDIV_DIV24                     ((uint32_t)0x00001800U)
#define RCC_PLL1DIV_PLL1BDIV_DIV25                     ((uint32_t)0x00001900U)
#define RCC_PLL1DIV_PLL1BDIV_DIV26                     ((uint32_t)0x00001A00U)
#define RCC_PLL1DIV_PLL1BDIV_DIV27                     ((uint32_t)0x00001B00U)
#define RCC_PLL1DIV_PLL1BDIV_DIV28                     ((uint32_t)0x00001C00U)
#define RCC_PLL1DIV_PLL1BDIV_DIV29                     ((uint32_t)0x00001D00U)
#define RCC_PLL1DIV_PLL1BDIV_DIV30                     ((uint32_t)0x00001E00U)
#define RCC_PLL1DIV_PLL1BDIV_DIV31                     ((uint32_t)0x00001F00U)
#define RCC_PLL1DIV_PLL1BDIV_DIV32                     ((uint32_t)0x00002000U)
#define RCC_PLL1DIV_PLL1BDIV_DIV33                     ((uint32_t)0x00002100U)
#define RCC_PLL1DIV_PLL1BDIV_DIV34                     ((uint32_t)0x00002200U)
#define RCC_PLL1DIV_PLL1BDIV_DIV35                     ((uint32_t)0x00002300U)
#define RCC_PLL1DIV_PLL1BDIV_DIV36                     ((uint32_t)0x00002400U)
#define RCC_PLL1DIV_PLL1BDIV_DIV37                     ((uint32_t)0x00002500U)
#define RCC_PLL1DIV_PLL1BDIV_DIV38                     ((uint32_t)0x00002600U)
#define RCC_PLL1DIV_PLL1BDIV_DIV39                     ((uint32_t)0x00002700U)
#define RCC_PLL1DIV_PLL1BDIV_DIV40                     ((uint32_t)0x00002800U)
#define RCC_PLL1DIV_PLL1BDIV_DIV41                     ((uint32_t)0x00002900U)
#define RCC_PLL1DIV_PLL1BDIV_DIV42                     ((uint32_t)0x00002A00U)
#define RCC_PLL1DIV_PLL1BDIV_DIV43                     ((uint32_t)0x00002B00U)
#define RCC_PLL1DIV_PLL1BDIV_DIV44                     ((uint32_t)0x00002C00U)
#define RCC_PLL1DIV_PLL1BDIV_DIV45                     ((uint32_t)0x00002D00U)
#define RCC_PLL1DIV_PLL1BDIV_DIV46                     ((uint32_t)0x00002E00U)
#define RCC_PLL1DIV_PLL1BDIV_DIV47                     ((uint32_t)0x00002F00U)
#define RCC_PLL1DIV_PLL1BDIV_DIV48                     ((uint32_t)0x00003000U)
#define RCC_PLL1DIV_PLL1BDIV_DIV49                     ((uint32_t)0x00003100U)
#define RCC_PLL1DIV_PLL1BDIV_DIV50                     ((uint32_t)0x00003200U)
#define RCC_PLL1DIV_PLL1BDIV_DIV51                     ((uint32_t)0x00003300U)
#define RCC_PLL1DIV_PLL1BDIV_DIV52                     ((uint32_t)0x00003400U)
#define RCC_PLL1DIV_PLL1BDIV_DIV53                     ((uint32_t)0x00003500U)
#define RCC_PLL1DIV_PLL1BDIV_DIV54                     ((uint32_t)0x00003600U)
#define RCC_PLL1DIV_PLL1BDIV_DIV55                     ((uint32_t)0x00003700U)
#define RCC_PLL1DIV_PLL1BDIV_DIV56                     ((uint32_t)0x00003800U)
#define RCC_PLL1DIV_PLL1BDIV_DIV57                     ((uint32_t)0x00003900U)
#define RCC_PLL1DIV_PLL1BDIV_DIV58                     ((uint32_t)0x00003A00U)
#define RCC_PLL1DIV_PLL1BDIV_DIV59                     ((uint32_t)0x00003B00U)
#define RCC_PLL1DIV_PLL1BDIV_DIV60                     ((uint32_t)0x00003C00U)
#define RCC_PLL1DIV_PLL1BDIV_DIV61                     ((uint32_t)0x00003D00U)
#define RCC_PLL1DIV_PLL1BDIV_DIV62                     ((uint32_t)0x00003E00U)
#define RCC_PLL1DIV_PLL1BDIV_DIV63                     ((uint32_t)0x00003F00U)

#define RCC_PLL1DIV_PLL1ADIV                           ((uint32_t)0x0000003FU)         /* Bit */
#define RCC_PLL1DIV_PLL1ADIV_0                         ((uint32_t)0x00000001U)         /* Bit0*/
#define RCC_PLL1DIV_PLL1ADIV_1                         ((uint32_t)0x00000002U)         /* Bit1*/
#define RCC_PLL1DIV_PLL1ADIV_2                         ((uint32_t)0x00000004U)         /* Bit2*/
#define RCC_PLL1DIV_PLL1ADIV_3                         ((uint32_t)0x00000008U)         /* Bit3*/
#define RCC_PLL1DIV_PLL1ADIV_4                         ((uint32_t)0x00000010U)         /* Bit4*/
#define RCC_PLL1DIV_PLL1ADIV_5                         ((uint32_t)0x00000020U)         /* Bit5*/

#define RCC_PLL1DIV_PLL1ADIV_DIV1                      ((uint32_t)0x00000001U)
#define RCC_PLL1DIV_PLL1ADIV_DIV2                      ((uint32_t)0x00000002U)
#define RCC_PLL1DIV_PLL1ADIV_DIV3                      ((uint32_t)0x00000003U)
#define RCC_PLL1DIV_PLL1ADIV_DIV4                      ((uint32_t)0x00000004U)
#define RCC_PLL1DIV_PLL1ADIV_DIV5                      ((uint32_t)0x00000005U)
#define RCC_PLL1DIV_PLL1ADIV_DIV6                      ((uint32_t)0x00000006U)
#define RCC_PLL1DIV_PLL1ADIV_DIV7                      ((uint32_t)0x00000007U)
#define RCC_PLL1DIV_PLL1ADIV_DIV8                      ((uint32_t)0x00000008U)
#define RCC_PLL1DIV_PLL1ADIV_DIV9                      ((uint32_t)0x00000009U)
#define RCC_PLL1DIV_PLL1ADIV_DIV10                     ((uint32_t)0x0000000AU)
#define RCC_PLL1DIV_PLL1ADIV_DIV11                     ((uint32_t)0x0000000BU)
#define RCC_PLL1DIV_PLL1ADIV_DIV12                     ((uint32_t)0x0000000CU)
#define RCC_PLL1DIV_PLL1ADIV_DIV13                     ((uint32_t)0x0000000DU)
#define RCC_PLL1DIV_PLL1ADIV_DIV14                     ((uint32_t)0x0000000EU)
#define RCC_PLL1DIV_PLL1ADIV_DIV15                     ((uint32_t)0x0000000FU) 
#define RCC_PLL1DIV_PLL1ADIV_DIV16                     ((uint32_t)0x00000010U)
#define RCC_PLL1DIV_PLL1ADIV_DIV17                     ((uint32_t)0x00000011U)
#define RCC_PLL1DIV_PLL1ADIV_DIV18                     ((uint32_t)0x00000012U)
#define RCC_PLL1DIV_PLL1ADIV_DIV19                     ((uint32_t)0x00000013U)
#define RCC_PLL1DIV_PLL1ADIV_DIV20                     ((uint32_t)0x00000014U)
#define RCC_PLL1DIV_PLL1ADIV_DIV21                     ((uint32_t)0x00000015U)
#define RCC_PLL1DIV_PLL1ADIV_DIV22                     ((uint32_t)0x00000016U)
#define RCC_PLL1DIV_PLL1ADIV_DIV23                     ((uint32_t)0x00000017U)
#define RCC_PLL1DIV_PLL1ADIV_DIV24                     ((uint32_t)0x00000018U)
#define RCC_PLL1DIV_PLL1ADIV_DIV25                     ((uint32_t)0x00000019U)
#define RCC_PLL1DIV_PLL1ADIV_DIV26                     ((uint32_t)0x0000001AU)
#define RCC_PLL1DIV_PLL1ADIV_DIV27                     ((uint32_t)0x0000001BU)
#define RCC_PLL1DIV_PLL1ADIV_DIV28                     ((uint32_t)0x0000001CU)
#define RCC_PLL1DIV_PLL1ADIV_DIV29                     ((uint32_t)0x0000001DU)
#define RCC_PLL1DIV_PLL1ADIV_DIV30                     ((uint32_t)0x0000001EU)
#define RCC_PLL1DIV_PLL1ADIV_DIV31                     ((uint32_t)0x0000001FU)
#define RCC_PLL1DIV_PLL1ADIV_DIV32                     ((uint32_t)0x00000020U)
#define RCC_PLL1DIV_PLL1ADIV_DIV33                     ((uint32_t)0x00000021U)
#define RCC_PLL1DIV_PLL1ADIV_DIV34                     ((uint32_t)0x00000022U)
#define RCC_PLL1DIV_PLL1ADIV_DIV35                     ((uint32_t)0x00000023U)
#define RCC_PLL1DIV_PLL1ADIV_DIV36                     ((uint32_t)0x00000024U)
#define RCC_PLL1DIV_PLL1ADIV_DIV37                     ((uint32_t)0x00000025U)
#define RCC_PLL1DIV_PLL1ADIV_DIV38                     ((uint32_t)0x00000026U)
#define RCC_PLL1DIV_PLL1ADIV_DIV39                     ((uint32_t)0x00000027U)
#define RCC_PLL1DIV_PLL1ADIV_DIV40                     ((uint32_t)0x00000028U)
#define RCC_PLL1DIV_PLL1ADIV_DIV41                     ((uint32_t)0x00000029U)
#define RCC_PLL1DIV_PLL1ADIV_DIV42                     ((uint32_t)0x0000002AU)
#define RCC_PLL1DIV_PLL1ADIV_DIV43                     ((uint32_t)0x0000002BU)
#define RCC_PLL1DIV_PLL1ADIV_DIV44                     ((uint32_t)0x0000002CU)
#define RCC_PLL1DIV_PLL1ADIV_DIV45                     ((uint32_t)0x0000002DU)
#define RCC_PLL1DIV_PLL1ADIV_DIV46                     ((uint32_t)0x0000002EU)
#define RCC_PLL1DIV_PLL1ADIV_DIV47                     ((uint32_t)0x0000002FU)
#define RCC_PLL1DIV_PLL1ADIV_DIV48                     ((uint32_t)0x00000030U)
#define RCC_PLL1DIV_PLL1ADIV_DIV49                     ((uint32_t)0x00000031U)
#define RCC_PLL1DIV_PLL1ADIV_DIV50                     ((uint32_t)0x00000032U)
#define RCC_PLL1DIV_PLL1ADIV_DIV51                     ((uint32_t)0x00000033U)
#define RCC_PLL1DIV_PLL1ADIV_DIV52                     ((uint32_t)0x00000034U)
#define RCC_PLL1DIV_PLL1ADIV_DIV53                     ((uint32_t)0x00000035U)
#define RCC_PLL1DIV_PLL1ADIV_DIV54                     ((uint32_t)0x00000036U)
#define RCC_PLL1DIV_PLL1ADIV_DIV55                     ((uint32_t)0x00000037U)
#define RCC_PLL1DIV_PLL1ADIV_DIV56                     ((uint32_t)0x00000038U)
#define RCC_PLL1DIV_PLL1ADIV_DIV57                     ((uint32_t)0x00000039U)
#define RCC_PLL1DIV_PLL1ADIV_DIV58                     ((uint32_t)0x0000003AU)
#define RCC_PLL1DIV_PLL1ADIV_DIV59                     ((uint32_t)0x0000003BU)
#define RCC_PLL1DIV_PLL1ADIV_DIV60                     ((uint32_t)0x0000003CU)
#define RCC_PLL1DIV_PLL1ADIV_DIV61                     ((uint32_t)0x0000003DU)
#define RCC_PLL1DIV_PLL1ADIV_DIV62                     ((uint32_t)0x0000003EU)
#define RCC_PLL1DIV_PLL1ADIV_DIV63                     ((uint32_t)0x0000003FU)


/******** Bit definition for RCC_PLL2DIV register  ********/
#define RCC_PLL2DIV_PLL2CDIV                                ((uint32_t)0x003F0000U)         /* Bit[21:16] */
#define RCC_PLL2DIV_PLL2CDIV_0                              ((uint32_t)0x00010000U)         /* Bit16*/
#define RCC_PLL2DIV_PLL2CDIV_1                              ((uint32_t)0x00020000U)         /* Bit17*/
#define RCC_PLL2DIV_PLL2CDIV_2                              ((uint32_t)0x00040000U)         /* Bit18*/
#define RCC_PLL2DIV_PLL2CDIV_3                              ((uint32_t)0x00080000U)         /* Bit19*/
#define RCC_PLL2DIV_PLL2CDIV_4                              ((uint32_t)0x00100000U)         /* Bit20*/
#define RCC_PLL2DIV_PLL2CDIV_5                              ((uint32_t)0x00200000U)         /* Bit21*/
#define RCC_PLL2DIV_PLL2BDIV                                ((uint32_t)0x00003F00U)         /* Bit[13:8] */
#define RCC_PLL2DIV_PLL2BDIV_0                              ((uint32_t)0x00000100U)         /* Bit8*/
#define RCC_PLL2DIV_PLL2BDIV_1                              ((uint32_t)0x00000200U)         /* Bit9*/
#define RCC_PLL2DIV_PLL2BDIV_2                              ((uint32_t)0x00000400U)         /* Bit10*/
#define RCC_PLL2DIV_PLL2BDIV_3                              ((uint32_t)0x00000800U)         /* Bit11*/
#define RCC_PLL2DIV_PLL2BDIV_4                              ((uint32_t)0x00001000U)         /* Bit12*/
#define RCC_PLL2DIV_PLL2BDIV_5                              ((uint32_t)0x00002000U)         /* Bit13*/
#define RCC_PLL2DIV_PLL2ADIV                                ((uint32_t)0x0000003FU)         /* Bit */
#define RCC_PLL2DIV_PLL2ADIV_0                              ((uint32_t)0x00000001U)         /* Bit0*/
#define RCC_PLL2DIV_PLL2ADIV_1                              ((uint32_t)0x00000002U)         /* Bit1*/
#define RCC_PLL2DIV_PLL2ADIV_2                              ((uint32_t)0x00000004U)         /* Bit2*/
#define RCC_PLL2DIV_PLL2ADIV_3                              ((uint32_t)0x00000008U)         /* Bit3*/
#define RCC_PLL2DIV_PLL2ADIV_4                              ((uint32_t)0x00000010U)         /* Bit4*/
#define RCC_PLL2DIV_PLL2ADIV_5                              ((uint32_t)0x00000020U)         /* Bit5*/

/******** Bit definition for RCC_PLL3DIV register  ********/
#define RCC_PLL3DIV_PLL3CDIV                                ((uint32_t)0x003F0000U)         /* Bit[21:16] */
#define RCC_PLL3DIV_PLL3CDIV_0                              ((uint32_t)0x00010000U)         /* Bit16*/
#define RCC_PLL3DIV_PLL3CDIV_1                              ((uint32_t)0x00020000U)         /* Bit17*/
#define RCC_PLL3DIV_PLL3CDIV_2                              ((uint32_t)0x00040000U)         /* Bit18*/
#define RCC_PLL3DIV_PLL3CDIV_3                              ((uint32_t)0x00080000U)         /* Bit19*/
#define RCC_PLL3DIV_PLL3CDIV_4                              ((uint32_t)0x00100000U)         /* Bit20*/
#define RCC_PLL3DIV_PLL3CDIV_5                              ((uint32_t)0x00200000U)         /* Bit21*/
#define RCC_PLL3DIV_PLL3BDIV                                ((uint32_t)0x00003F00U)         /* Bit[13:8] */
#define RCC_PLL3DIV_PLL3BDIV_0                              ((uint32_t)0x00000100U)         /* Bit8*/
#define RCC_PLL3DIV_PLL3BDIV_1                              ((uint32_t)0x00000200U)         /* Bit9*/
#define RCC_PLL3DIV_PLL3BDIV_2                              ((uint32_t)0x00000400U)         /* Bit10*/
#define RCC_PLL3DIV_PLL3BDIV_3                              ((uint32_t)0x00000800U)         /* Bit11*/
#define RCC_PLL3DIV_PLL3BDIV_4                              ((uint32_t)0x00001000U)         /* Bit12*/
#define RCC_PLL3DIV_PLL3BDIV_5                              ((uint32_t)0x00002000U)         /* Bit13*/
#define RCC_PLL3DIV_PLL3ADIV                                ((uint32_t)0x0000003FU)         /* Bit */
#define RCC_PLL3DIV_PLL3ADIV_0                              ((uint32_t)0x00000001U)         /* Bit0*/
#define RCC_PLL3DIV_PLL3ADIV_1                              ((uint32_t)0x00000002U)         /* Bit1*/
#define RCC_PLL3DIV_PLL3ADIV_2                              ((uint32_t)0x00000004U)         /* Bit2*/
#define RCC_PLL3DIV_PLL3ADIV_3                              ((uint32_t)0x00000008U)         /* Bit3*/
#define RCC_PLL3DIV_PLL3ADIV_4                              ((uint32_t)0x00000010U)         /* Bit4*/
#define RCC_PLL3DIV_PLL3ADIV_5                              ((uint32_t)0x00000020U)         /* Bit5*/

/******** Bit definition for RCC_SYSBUSDIV1 register  ********/
#define RCC_SYSBUSDIV1_AXIHYPDIV                          ((uint32_t)0x0F000000U)         /* Bit[27:24] */
#define RCC_SYSBUSDIV1_AXIHYPDIV_0                        ((uint32_t)0x01000000U)         /* Bit24*/
#define RCC_SYSBUSDIV1_AXIHYPDIV_1                        ((uint32_t)0x02000000U)         /* Bit25*/
#define RCC_SYSBUSDIV1_AXIHYPDIV_2                        ((uint32_t)0x04000000U)         /* Bit26*/
#define RCC_SYSBUSDIV1_AXIHYPDIV_3                        ((uint32_t)0x08000000U)         /* Bit27*/

#define RCC_SYSBUSDIV1_AXIHYPDIV_DIV1                     ((uint32_t)0x00000000U)
#define RCC_SYSBUSDIV1_AXIHYPDIV_DIV2                     ((uint32_t)0x01000000U)
#define RCC_SYSBUSDIV1_AXIHYPDIV_DIV4                     ((uint32_t)0x02000000U)
#define RCC_SYSBUSDIV1_AXIHYPDIV_DIV8                     ((uint32_t)0x04000000U)
#define RCC_SYSBUSDIV1_AXIHYPDIV_DIV16                    ((uint32_t)0x07000000U)
#define RCC_SYSBUSDIV1_AXIHYPDIV_DIV32                    ((uint32_t)0x08000000U)
#define RCC_SYSBUSDIV1_AXIHYPDIV_DIV64                    ((uint32_t)0x09000000U)
#define RCC_SYSBUSDIV1_AXIHYPDIV_DIV128                   ((uint32_t)0x0A000000U)
#define RCC_SYSBUSDIV1_AXIHYPDIV_DIV256                   ((uint32_t)0x0B000000U)
#define RCC_SYSBUSDIV1_AXIHYPDIV_DIV512                   ((uint32_t)0x0C000000U)

#define RCC_SYSBUSDIV1_HSIDIV                             ((uint32_t)0x00F00000U)         /* Bit[23:20] */
#define RCC_SYSBUSDIV1_HSIDIV_0                           ((uint32_t)0x00100000U)         /* Bit20*/
#define RCC_SYSBUSDIV1_HSIDIV_1                           ((uint32_t)0x00200000U)         /* Bit21*/
#define RCC_SYSBUSDIV1_HSIDIV_2                           ((uint32_t)0x00400000U)         /* Bit22*/
#define RCC_SYSBUSDIV1_HSIDIV_3                           ((uint32_t)0x00800000U)         /* Bit23*/

#define RCC_SYSBUSDIV1_HSIDIV_DIV1                        ((uint32_t)0x00000000U)
#define RCC_SYSBUSDIV1_HSIDIV_DIV2                        ((uint32_t)0x00100000U)
#define RCC_SYSBUSDIV1_HSIDIV_DIV4                        ((uint32_t)0x00200000U)
#define RCC_SYSBUSDIV1_HSIDIV_DIV8                        ((uint32_t)0x00400000U)
#define RCC_SYSBUSDIV1_HSIDIV_DIV16                       ((uint32_t)0x00700000U)
#define RCC_SYSBUSDIV1_HSIDIV_DIV32                       ((uint32_t)0x00800000U)
#define RCC_SYSBUSDIV1_HSIDIV_DIV64                       ((uint32_t)0x00900000U)
#define RCC_SYSBUSDIV1_HSIDIV_DIV128                      ((uint32_t)0x00A00000U)
#define RCC_SYSBUSDIV1_HSIDIV_DIV256                      ((uint32_t)0x00B00000U)
#define RCC_SYSBUSDIV1_HSIDIV_DIV512                      ((uint32_t)0x00C00000U)

#define RCC_SYSBUSDIV1_M7HYPDIV                           ((uint32_t)0x000F0000U)         /* Bit[19:16] */
#define RCC_SYSBUSDIV1_M7HYPDIV_0                         ((uint32_t)0x00010000U)         /* Bit16*/
#define RCC_SYSBUSDIV1_M7HYPDIV_1                         ((uint32_t)0x00020000U)         /* Bit17*/
#define RCC_SYSBUSDIV1_M7HYPDIV_2                         ((uint32_t)0x00040000U)         /* Bit18*/
#define RCC_SYSBUSDIV1_M7HYPDIV_3                         ((uint32_t)0x00080000U)         /* Bit19*/

#define RCC_SYSBUSDIV1_M7HYPDIV_DIV1                      ((uint32_t)0x00000000U)
#define RCC_SYSBUSDIV1_M7HYPDIV_DIV2                      ((uint32_t)0x00010000U)
#define RCC_SYSBUSDIV1_M7HYPDIV_DIV4                      ((uint32_t)0x00020000U)
#define RCC_SYSBUSDIV1_M7HYPDIV_DIV8                      ((uint32_t)0x00040000U)
#define RCC_SYSBUSDIV1_M7HYPDIV_DIV16                     ((uint32_t)0x00070000U)
#define RCC_SYSBUSDIV1_M7HYPDIV_DIV32                     ((uint32_t)0x00080000U)
#define RCC_SYSBUSDIV1_M7HYPDIV_DIV64                     ((uint32_t)0x00090000U)
#define RCC_SYSBUSDIV1_M7HYPDIV_DIV128                    ((uint32_t)0x000A0000U)
#define RCC_SYSBUSDIV1_M7HYPDIV_DIV256                    ((uint32_t)0x000B0000U)
#define RCC_SYSBUSDIV1_M7HYPDIV_DIV512                    ((uint32_t)0x000C0000U)

#define RCC_SYSBUSDIV1_AXIDIV                             ((uint32_t)0x0000F000U)         /* Bit[15:12] */
#define RCC_SYSBUSDIV1_AXIDIV_0                           ((uint32_t)0x00001000U)         /* Bit12*/
#define RCC_SYSBUSDIV1_AXIDIV_1                           ((uint32_t)0x00002000U)         /* Bit13*/
#define RCC_SYSBUSDIV1_AXIDIV_2                           ((uint32_t)0x00004000U)         /* Bit14*/
#define RCC_SYSBUSDIV1_AXIDIV_3                           ((uint32_t)0x00008000U)         /* Bit15*/

#define RCC_SYSBUSDIV1_AXIDIV_DIV1                        ((uint32_t)0x00000000U)
#define RCC_SYSBUSDIV1_AXIDIV_DIV2                        ((uint32_t)0x00001000U)
#define RCC_SYSBUSDIV1_AXIDIV_DIV4                        ((uint32_t)0x00002000U)
#define RCC_SYSBUSDIV1_AXIDIV_DIV8                        ((uint32_t)0x00004000U)
#define RCC_SYSBUSDIV1_AXIDIV_DIV16                       ((uint32_t)0x00007000U)
#define RCC_SYSBUSDIV1_AXIDIV_DIV32                       ((uint32_t)0x00008000U)
#define RCC_SYSBUSDIV1_AXIDIV_DIV64                       ((uint32_t)0x00009000U)
#define RCC_SYSBUSDIV1_AXIDIV_DIV128                      ((uint32_t)0x0000A000U)
#define RCC_SYSBUSDIV1_AXIDIV_DIV256                      ((uint32_t)0x0000B000U)
#define RCC_SYSBUSDIV1_AXIDIV_DIV512                      ((uint32_t)0x0000C000U)

#define RCC_SYSBUSDIV1_BUSDIV                             ((uint32_t)0x00000F00U)         /* Bit[11:8] */
#define RCC_SYSBUSDIV1_BUSDIV_0                           ((uint32_t)0x00000100U)         /* Bit8*/
#define RCC_SYSBUSDIV1_BUSDIV_1                           ((uint32_t)0x00000200U)         /* Bit9*/
#define RCC_SYSBUSDIV1_BUSDIV_2                           ((uint32_t)0x00000400U)         /* Bit10*/
#define RCC_SYSBUSDIV1_BUSDIV_3                           ((uint32_t)0x00000800U)         /* Bit11*/

#define RCC_SYSBUSDIV1_BUSDIV_DIV1                        ((uint32_t)0x00000000U)
#define RCC_SYSBUSDIV1_BUSDIV_DIV2                        ((uint32_t)0x00000100U)
#define RCC_SYSBUSDIV1_BUSDIV_DIV4                        ((uint32_t)0x00000200U)
#define RCC_SYSBUSDIV1_BUSDIV_DIV8                        ((uint32_t)0x00000400U)
#define RCC_SYSBUSDIV1_BUSDIV_DIV16                       ((uint32_t)0x00000700U)
#define RCC_SYSBUSDIV1_BUSDIV_DIV32                       ((uint32_t)0x00000800U)
#define RCC_SYSBUSDIV1_BUSDIV_DIV64                       ((uint32_t)0x00000900U)
#define RCC_SYSBUSDIV1_BUSDIV_DIV128                      ((uint32_t)0x00000A00U)
#define RCC_SYSBUSDIV1_BUSDIV_DIV256                      ((uint32_t)0x00000B00U)
#define RCC_SYSBUSDIV1_BUSDIV_DIV512                      ((uint32_t)0x00000C00U)

#define RCC_SYSBUSDIV1_MSIDIV                             ((uint32_t)0x000000F0U)         /* Bit[7:4] */
#define RCC_SYSBUSDIV1_MSIDIV_0                           ((uint32_t)0x00000010U)         /* Bit4*/
#define RCC_SYSBUSDIV1_MSIDIV_1                           ((uint32_t)0x00000020U)         /* Bit5*/
#define RCC_SYSBUSDIV1_MSIDIV_2                           ((uint32_t)0x00000040U)         /* Bit6*/
#define RCC_SYSBUSDIV1_MSIDIV_3                           ((uint32_t)0x00000080U)         /* Bit7*/

#define RCC_SYSBUSDIV1_MSIDIV_DIV1                        ((uint32_t)0x00000000U)
#define RCC_SYSBUSDIV1_MSIDIV_DIV2                        ((uint32_t)0x00000010U)
#define RCC_SYSBUSDIV1_MSIDIV_DIV4                        ((uint32_t)0x00000020U)
#define RCC_SYSBUSDIV1_MSIDIV_DIV8                        ((uint32_t)0x00000040U)
#define RCC_SYSBUSDIV1_MSIDIV_DIV16                       ((uint32_t)0x00000070U)
#define RCC_SYSBUSDIV1_MSIDIV_DIV32                       ((uint32_t)0x00000080U)
#define RCC_SYSBUSDIV1_MSIDIV_DIV64                       ((uint32_t)0x00000090U)
#define RCC_SYSBUSDIV1_MSIDIV_DIV128                      ((uint32_t)0x000000A0U)
#define RCC_SYSBUSDIV1_MSIDIV_DIV256                      ((uint32_t)0x000000B0U)
#define RCC_SYSBUSDIV1_MSIDIV_DIV512                      ((uint32_t)0x000000C0U)

#define RCC_SYSBUSDIV1_SCLKDIV                            ((uint32_t)0x0000000FU)         /* Bit */
#define RCC_SYSBUSDIV1_SCLKDIV_0                          ((uint32_t)0x00000001U)         /* Bit0*/
#define RCC_SYSBUSDIV1_SCLKDIV_1                          ((uint32_t)0x00000002U)         /* Bit1*/
#define RCC_SYSBUSDIV1_SCLKDIV_2                          ((uint32_t)0x00000004U)         /* Bit2*/
#define RCC_SYSBUSDIV1_SCLKDIV_3                          ((uint32_t)0x00000008U)         /* Bit3*/

#define RCC_SYSBUSDIV1_SCLKDIV_DIV1                       ((uint32_t)0x00000000U)
#define RCC_SYSBUSDIV1_SCLKDIV_DIV2                       ((uint32_t)0x00000001U)
#define RCC_SYSBUSDIV1_SCLKDIV_DIV4                       ((uint32_t)0x00000002U)
#define RCC_SYSBUSDIV1_SCLKDIV_DIV8                       ((uint32_t)0x00000004U)
#define RCC_SYSBUSDIV1_SCLKDIV_DIV16                      ((uint32_t)0x00000007U)
#define RCC_SYSBUSDIV1_SCLKDIV_DIV32                      ((uint32_t)0x00000008U)
#define RCC_SYSBUSDIV1_SCLKDIV_DIV64                      ((uint32_t)0x00000009U)
#define RCC_SYSBUSDIV1_SCLKDIV_DIV128                     ((uint32_t)0x0000000AU)
#define RCC_SYSBUSDIV1_SCLKDIV_DIV256                     ((uint32_t)0x0000000BU)
#define RCC_SYSBUSDIV1_SCLKDIV_DIV512                     ((uint32_t)0x0000000CU)

/******** Bit definition for RCC_SYSBUSDIV2 register  ********/
#define RCC_SYSBUSDIV2_APB6DIV                            ((uint32_t)0x07000000U)         /* Bit[26:24] */
#define RCC_SYSBUSDIV2_APB6DIV_0                          ((uint32_t)0x01000000U)         /* Bit24*/
#define RCC_SYSBUSDIV2_APB6DIV_1                          ((uint32_t)0x02000000U)         /* Bit25*/
#define RCC_SYSBUSDIV2_APB6DIV_2                          ((uint32_t)0x04000000U)         /* Bit26*/

#define RCC_SYSBUSDIV2_APB6DIV_DIV1                       ((uint32_t)0x00000000U)
#define RCC_SYSBUSDIV2_APB6DIV_DIV2                       ((uint32_t)0x04000000U)
#define RCC_SYSBUSDIV2_APB6DIV_DIV4                       ((uint32_t)0x05000000U)
#define RCC_SYSBUSDIV2_APB6DIV_DIV8                       ((uint32_t)0x06000000U)
#define RCC_SYSBUSDIV2_APB6DIV_DIV16                      ((uint32_t)0x07000000U)

#define RCC_SYSBUSDIV2_APB5DIV                            ((uint32_t)0x00070000U)         /* Bit[18:16] */
#define RCC_SYSBUSDIV2_APB5DIV_0                          ((uint32_t)0x00010000U)         /* Bit16*/
#define RCC_SYSBUSDIV2_APB5DIV_1                          ((uint32_t)0x00020000U)         /* Bit17*/
#define RCC_SYSBUSDIV2_APB5DIV_2                          ((uint32_t)0x00040000U)         /* Bit18*/

#define RCC_SYSBUSDIV2_APB5DIV_DIV1                       ((uint32_t)0x00000000U)
#define RCC_SYSBUSDIV2_APB5DIV_DIV2                       ((uint32_t)0x00040000U)
#define RCC_SYSBUSDIV2_APB5DIV_DIV4                       ((uint32_t)0x00050000U)
#define RCC_SYSBUSDIV2_APB5DIV_DIV8                       ((uint32_t)0x00060000U)
#define RCC_SYSBUSDIV2_APB5DIV_DIV16                      ((uint32_t)0x00070000U)
        
#define RCC_SYSBUSDIV2_APB2DIV                            ((uint32_t)0x00000700U)         /* Bit[10:8] */
#define RCC_SYSBUSDIV2_APB2DIV_0                          ((uint32_t)0x00000100U)         /* Bit8*/
#define RCC_SYSBUSDIV2_APB2DIV_1                          ((uint32_t)0x00000200U)         /* Bit9*/
#define RCC_SYSBUSDIV2_APB2DIV_2                          ((uint32_t)0x00000400U)         /* Bit10*/

#define RCC_SYSBUSDIV2_APB2DIV_DIV1                       ((uint32_t)0x00000000U)
#define RCC_SYSBUSDIV2_APB2DIV_DIV2                       ((uint32_t)0x00000400U)
#define RCC_SYSBUSDIV2_APB2DIV_DIV4                       ((uint32_t)0x00000500U)
#define RCC_SYSBUSDIV2_APB2DIV_DIV8                       ((uint32_t)0x00000600U)
#define RCC_SYSBUSDIV2_APB2DIV_DIV16                      ((uint32_t)0x00000700U)

#define RCC_SYSBUSDIV2_APB1DIV                            ((uint32_t)0x00000007U)         /* Bit */
#define RCC_SYSBUSDIV2_APB1DIV_0                          ((uint32_t)0x00000001U)         /* Bit0*/
#define RCC_SYSBUSDIV2_APB1DIV_1                          ((uint32_t)0x00000002U)         /* Bit1*/
#define RCC_SYSBUSDIV2_APB1DIV_2                          ((uint32_t)0x00000004U)         /* Bit2*/

#define RCC_SYSBUSDIV2_APB1DIV_DIV1                       ((uint32_t)0x00000000U)
#define RCC_SYSBUSDIV2_APB1DIV_DIV2                       ((uint32_t)0x00000004U)
#define RCC_SYSBUSDIV2_APB1DIV_DIV4                       ((uint32_t)0x00000005U)
#define RCC_SYSBUSDIV2_APB1DIV_DIV8                       ((uint32_t)0x00000006U)
#define RCC_SYSBUSDIV2_APB1DIV_DIV16                      ((uint32_t)0x00000007U)
    
/******** Bit definition for RCC_BOOTMODE register  ********/
#define RCC_BOOTMODE_MODE                              ((uint32_t)0xFFFFFFFFU)         /* Bit */
#define RCC_BOOTMODE_MODE_0                            ((uint32_t)0x00000001U)         /* Bit0*/
#define RCC_BOOTMODE_MODE_1                            ((uint32_t)0x00000002U)         /* Bit1*/
#define RCC_BOOTMODE_MODE_2                            ((uint32_t)0x00000004U)         /* Bit2*/
#define RCC_BOOTMODE_MODE_3                            ((uint32_t)0x00000008U)         /* Bit3*/
#define RCC_BOOTMODE_MODE_4                            ((uint32_t)0x00000010U)         /* Bit4*/
#define RCC_BOOTMODE_MODE_5                            ((uint32_t)0x00000020U)         /* Bit5*/
#define RCC_BOOTMODE_MODE_6                            ((uint32_t)0x00000040U)         /* Bit6*/
#define RCC_BOOTMODE_MODE_7                            ((uint32_t)0x00000080U)         /* Bit7*/
#define RCC_BOOTMODE_MODE_8                            ((uint32_t)0x00000100U)         /* Bit8*/
#define RCC_BOOTMODE_MODE_9                            ((uint32_t)0x00000200U)         /* Bit9*/
#define RCC_BOOTMODE_MODE_10                           ((uint32_t)0x00000400U)         /* Bit10*/
#define RCC_BOOTMODE_MODE_11                           ((uint32_t)0x00000800U)         /* Bit11*/
#define RCC_BOOTMODE_MODE_12                           ((uint32_t)0x00001000U)         /* Bit12*/
#define RCC_BOOTMODE_MODE_13                           ((uint32_t)0x00002000U)         /* Bit13*/
#define RCC_BOOTMODE_MODE_14                           ((uint32_t)0x00004000U)         /* Bit14*/
#define RCC_BOOTMODE_MODE_15                           ((uint32_t)0x00008000U)         /* Bit15*/
#define RCC_BOOTMODE_MODE_16                           ((uint32_t)0x00010000U)         /* Bit16*/
#define RCC_BOOTMODE_MODE_17                           ((uint32_t)0x00020000U)         /* Bit17*/
#define RCC_BOOTMODE_MODE_18                           ((uint32_t)0x00040000U)         /* Bit18*/
#define RCC_BOOTMODE_MODE_19                           ((uint32_t)0x00080000U)         /* Bit19*/
#define RCC_BOOTMODE_MODE_20                           ((uint32_t)0x00100000U)         /* Bit20*/
#define RCC_BOOTMODE_MODE_21                           ((uint32_t)0x00200000U)         /* Bit21*/
#define RCC_BOOTMODE_MODE_22                           ((uint32_t)0x00400000U)         /* Bit22*/
#define RCC_BOOTMODE_MODE_23                           ((uint32_t)0x00800000U)         /* Bit23*/
#define RCC_BOOTMODE_MODE_24                           ((uint32_t)0x01000000U)         /* Bit24*/
#define RCC_BOOTMODE_MODE_25                           ((uint32_t)0x02000000U)         /* Bit25*/
#define RCC_BOOTMODE_MODE_26                           ((uint32_t)0x04000000U)         /* Bit26*/
#define RCC_BOOTMODE_MODE_27                           ((uint32_t)0x08000000U)         /* Bit27*/
#define RCC_BOOTMODE_MODE_28                           ((uint32_t)0x10000000U)         /* Bit28*/
#define RCC_BOOTMODE_MODE_29                           ((uint32_t)0x20000000U)         /* Bit29*/
#define RCC_BOOTMODE_MODE_30                           ((uint32_t)0x40000000U)         /* Bit30*/
#define RCC_BOOTMODE_MODE_31                           ((uint32_t)0x80000000U)         /* Bit31*/

/******** Bit definition for RCC_AHB1DIV1 register  ********/
#define RCC_AHB1DIV1_ETH2SYSDIV                         ((uint32_t)0xF0000000U)         /* Bit[31:28] */
#define RCC_AHB1DIV1_ETH2SYSDIV_0                       ((uint32_t)0x10000000U)         /* Bit28*/
#define RCC_AHB1DIV1_ETH2SYSDIV_1                       ((uint32_t)0x20000000U)         /* Bit29*/
#define RCC_AHB1DIV1_ETH2SYSDIV_2                       ((uint32_t)0x40000000U)         /* Bit30*/
#define RCC_AHB1DIV1_ETH2SYSDIV_3                       ((uint32_t)0x80000000U)         /* Bit31*/
#define RCC_AHB1DIV1_SDMMC2SYSDIV                       ((uint32_t)0x0F000000U)         /* Bit[27:24] */
#define RCC_AHB1DIV1_SDMMC2SYSDIV_0                     ((uint32_t)0x01000000U)         /* Bit24*/
#define RCC_AHB1DIV1_SDMMC2SYSDIV_1                     ((uint32_t)0x02000000U)         /* Bit25*/
#define RCC_AHB1DIV1_SDMMC2SYSDIV_2                     ((uint32_t)0x04000000U)         /* Bit26*/
#define RCC_AHB1DIV1_SDMMC2SYSDIV_3                     ((uint32_t)0x08000000U)         /* Bit27*/

#define RCC_AHB1DIV1_SDMMC2SYSDIV_DIV1                  ((uint32_t)0x00000000U)
#define RCC_AHB1DIV1_SDMMC2SYSDIV_DIV2                  ((uint32_t)0x01000000U)
#define RCC_AHB1DIV1_SDMMC2SYSDIV_DIV4                  ((uint32_t)0x02000000U)
#define RCC_AHB1DIV1_SDMMC2SYSDIV_DIV8                  ((uint32_t)0x04000000U)
#define RCC_AHB1DIV1_SDMMC2SYSDIV_DIV16                 ((uint32_t)0x07000000U)
#define RCC_AHB1DIV1_SDMMC2SYSDIV_DIV32                 ((uint32_t)0x08000000U)
#define RCC_AHB1DIV1_SDMMC2SYSDIV_DIV64                 ((uint32_t)0x09000000U)
#define RCC_AHB1DIV1_SDMMC2SYSDIV_DIV128                ((uint32_t)0x0A000000U)
#define RCC_AHB1DIV1_SDMMC2SYSDIV_DIV256                ((uint32_t)0x0B000000U)
#define RCC_AHB1DIV1_SDMMC2SYSDIV_DIV512                ((uint32_t)0x0C000000U)
/******** Bit definition for RCC_AHB1DIV2 register  ********/
#define RCC_AHB1DIV2_ADC3SYSDIV                         ((uint32_t)0x003F0000U)         /* Bit[21:16] */
#define RCC_AHB1DIV2_ADC3SYSDIV_0                       ((uint32_t)0x00010000U)         /* Bit16*/
#define RCC_AHB1DIV2_ADC3SYSDIV_1                       ((uint32_t)0x00020000U)         /* Bit17*/
#define RCC_AHB1DIV2_ADC3SYSDIV_2                       ((uint32_t)0x00040000U)         /* Bit18*/
#define RCC_AHB1DIV2_ADC3SYSDIV_3                       ((uint32_t)0x00080000U)         /* Bit19*/
#define RCC_AHB1DIV2_ADC3SYSDIV_4                       ((uint32_t)0x00100000U)         /* Bit20*/
#define RCC_AHB1DIV2_ADC3SYSDIV_5                       ((uint32_t)0x00200000U)         /* Bit21*/
#define RCC_AHB1DIV2_ADC2SYSDIV                         ((uint32_t)0x00003F00U)         /* Bit[13:8] */
#define RCC_AHB1DIV2_ADC2SYSDIV_0                       ((uint32_t)0x00000100U)         /* Bit8*/
#define RCC_AHB1DIV2_ADC2SYSDIV_1                       ((uint32_t)0x00000200U)         /* Bit9*/
#define RCC_AHB1DIV2_ADC2SYSDIV_2                       ((uint32_t)0x00000400U)         /* Bit10*/
#define RCC_AHB1DIV2_ADC2SYSDIV_3                       ((uint32_t)0x00000800U)         /* Bit11*/
#define RCC_AHB1DIV2_ADC2SYSDIV_4                       ((uint32_t)0x00001000U)         /* Bit12*/
#define RCC_AHB1DIV2_ADC2SYSDIV_5                       ((uint32_t)0x00002000U)         /* Bit13*/

#define RCC_AHB1DIV2_ADC1SYSDIV                         ((uint32_t)0x0000003FU)         /* Bit */
#define RCC_AHB1DIV2_ADC1SYSDIV_0                       ((uint32_t)0x00000001U)         /* Bit0*/
#define RCC_AHB1DIV2_ADC1SYSDIV_1                       ((uint32_t)0x00000002U)         /* Bit1*/
#define RCC_AHB1DIV2_ADC1SYSDIV_2                       ((uint32_t)0x00000004U)         /* Bit2*/
#define RCC_AHB1DIV2_ADC1SYSDIV_3                       ((uint32_t)0x00000008U)         /* Bit3*/
#define RCC_AHB1DIV2_ADC1SYSDIV_4                       ((uint32_t)0x00000010U)         /* Bit4*/
#define RCC_AHB1DIV2_ADC1SYSDIV_5                       ((uint32_t)0x00000020U)         /* Bit5*/

#define RCC_AHB1DIV2_ADC1SYSDIV_DIV1                     ((uint32_t)0x00000001U)
#define RCC_AHB1DIV2_ADC1SYSDIV_DIV2                     ((uint32_t)0x00000002U)
#define RCC_AHB1DIV2_ADC1SYSDIV_DIV3                     ((uint32_t)0x00000003U)
#define RCC_AHB1DIV2_ADC1SYSDIV_DIV4                     ((uint32_t)0x00000004U)
#define RCC_AHB1DIV2_ADC1SYSDIV_DIV5                     ((uint32_t)0x00000005U)
#define RCC_AHB1DIV2_ADC1SYSDIV_DIV6                     ((uint32_t)0x00000006U)
#define RCC_AHB1DIV2_ADC1SYSDIV_DIV7                     ((uint32_t)0x00000007U)
#define RCC_AHB1DIV2_ADC1SYSDIV_DIV8                     ((uint32_t)0x00000008U)
#define RCC_AHB1DIV2_ADC1SYSDIV_DIV9                     ((uint32_t)0x00000009U)
#define RCC_AHB1DIV2_ADC1SYSDIV_DIV10                    ((uint32_t)0x0000000AU)
#define RCC_AHB1DIV2_ADC1SYSDIV_DIV11                    ((uint32_t)0x0000000BU)
#define RCC_AHB1DIV2_ADC1SYSDIV_DIV12                    ((uint32_t)0x0000000CU)
#define RCC_AHB1DIV2_ADC1SYSDIV_DIV13                    ((uint32_t)0x0000000DU)
#define RCC_AHB1DIV2_ADC1SYSDIV_DIV14                    ((uint32_t)0x0000000EU)
#define RCC_AHB1DIV2_ADC1SYSDIV_DIV15                    ((uint32_t)0x0000000FU)
#define RCC_AHB1DIV2_ADC1SYSDIV_DIV16                    ((uint32_t)0x00000010U)
#define RCC_AHB1DIV2_ADC1SYSDIV_DIV17                    ((uint32_t)0x00000011U)
#define RCC_AHB1DIV2_ADC1SYSDIV_DIV18                    ((uint32_t)0x00000012U)
#define RCC_AHB1DIV2_ADC1SYSDIV_DIV19                    ((uint32_t)0x00000013U)
#define RCC_AHB1DIV2_ADC1SYSDIV_DIV20                    ((uint32_t)0x00000014U)
#define RCC_AHB1DIV2_ADC1SYSDIV_DIV21                    ((uint32_t)0x00000015U)
#define RCC_AHB1DIV2_ADC1SYSDIV_DIV22                    ((uint32_t)0x00000016U)
#define RCC_AHB1DIV2_ADC1SYSDIV_DIV23                    ((uint32_t)0x00000017U)
#define RCC_AHB1DIV2_ADC1SYSDIV_DIV24                    ((uint32_t)0x00000018U)
#define RCC_AHB1DIV2_ADC1SYSDIV_DIV25                    ((uint32_t)0x00000019U)
#define RCC_AHB1DIV2_ADC1SYSDIV_DIV26                    ((uint32_t)0x0000001AU)
#define RCC_AHB1DIV2_ADC1SYSDIV_DIV27                    ((uint32_t)0x0000001BU)
#define RCC_AHB1DIV2_ADC1SYSDIV_DIV28                    ((uint32_t)0x0000001CU)
#define RCC_AHB1DIV2_ADC1SYSDIV_DIV29                    ((uint32_t)0x0000001DU)
#define RCC_AHB1DIV2_ADC1SYSDIV_DIV30                    ((uint32_t)0x0000001EU)
#define RCC_AHB1DIV2_ADC1SYSDIV_DIV31                    ((uint32_t)0x0000001FU)
#define RCC_AHB1DIV2_ADC1SYSDIV_DIV32                    ((uint32_t)0x00000020U)
#define RCC_AHB1DIV2_ADC1SYSDIV_DIV33                    ((uint32_t)0x00000021U)
#define RCC_AHB1DIV2_ADC1SYSDIV_DIV34                    ((uint32_t)0x00000022U)
#define RCC_AHB1DIV2_ADC1SYSDIV_DIV35                    ((uint32_t)0x00000023U)
#define RCC_AHB1DIV2_ADC1SYSDIV_DIV36                    ((uint32_t)0x00000024U)
#define RCC_AHB1DIV2_ADC1SYSDIV_DIV37                    ((uint32_t)0x00000025U)
#define RCC_AHB1DIV2_ADC1SYSDIV_DIV38                    ((uint32_t)0x00000026U)
#define RCC_AHB1DIV2_ADC1SYSDIV_DIV39                    ((uint32_t)0x00000027U)
#define RCC_AHB1DIV2_ADC1SYSDIV_DIV40                    ((uint32_t)0x00000028U)
#define RCC_AHB1DIV2_ADC1SYSDIV_DIV41                    ((uint32_t)0x00000029U)
#define RCC_AHB1DIV2_ADC1SYSDIV_DIV42                    ((uint32_t)0x0000002AU)
#define RCC_AHB1DIV2_ADC1SYSDIV_DIV43                    ((uint32_t)0x0000002BU)
#define RCC_AHB1DIV2_ADC1SYSDIV_DIV44                    ((uint32_t)0x0000002CU)
#define RCC_AHB1DIV2_ADC1SYSDIV_DIV45                    ((uint32_t)0x0000002DU)
#define RCC_AHB1DIV2_ADC1SYSDIV_DIV46                    ((uint32_t)0x0000002EU)
#define RCC_AHB1DIV2_ADC1SYSDIV_DIV47                    ((uint32_t)0x0000002FU)
#define RCC_AHB1DIV2_ADC1SYSDIV_DIV48                    ((uint32_t)0x00000030U)
#define RCC_AHB1DIV2_ADC1SYSDIV_DIV49                    ((uint32_t)0x00000031U)
#define RCC_AHB1DIV2_ADC1SYSDIV_DIV50                    ((uint32_t)0x00000032U)
#define RCC_AHB1DIV2_ADC1SYSDIV_DIV51                    ((uint32_t)0x00000033U)
#define RCC_AHB1DIV2_ADC1SYSDIV_DIV52                    ((uint32_t)0x00000034U)
#define RCC_AHB1DIV2_ADC1SYSDIV_DIV53                    ((uint32_t)0x00000035U)
#define RCC_AHB1DIV2_ADC1SYSDIV_DIV54                    ((uint32_t)0x00000036U)
#define RCC_AHB1DIV2_ADC1SYSDIV_DIV55                    ((uint32_t)0x00000037U)
#define RCC_AHB1DIV2_ADC1SYSDIV_DIV56                    ((uint32_t)0x00000038U)
#define RCC_AHB1DIV2_ADC1SYSDIV_DIV57                    ((uint32_t)0x00000039U)
#define RCC_AHB1DIV2_ADC1SYSDIV_DIV58                    ((uint32_t)0x0000003AU)
#define RCC_AHB1DIV2_ADC1SYSDIV_DIV59                    ((uint32_t)0x0000003BU)
#define RCC_AHB1DIV2_ADC1SYSDIV_DIV60                    ((uint32_t)0x0000003CU)
#define RCC_AHB1DIV2_ADC1SYSDIV_DIV61                    ((uint32_t)0x0000003DU)
#define RCC_AHB1DIV2_ADC1SYSDIV_DIV62                    ((uint32_t)0x0000003EU)
#define RCC_AHB1DIV2_ADC1SYSDIV_DIV63                    ((uint32_t)0x0000003FU)
/******** Bit definition for RCC_AHB1SEL1 register  ********/
#define RCC_AHB1SEL1_ETH2PTPSEL                         ((uint32_t)0x00300000U)         /* Bit[21:20] */
#define RCC_AHB1SEL1_ETH2PTPSEL_0                       ((uint32_t)0x00100000U)         /* Bit20*/
#define RCC_AHB1SEL1_ETH2PTPSEL_1                       ((uint32_t)0x00200000U)         /* Bit21*/
#define RCC_AHB1SEL1_SDMMC2KERSEL                       ((uint32_t)0x00007000U)         /* Bit[14:12] */
#define RCC_AHB1SEL1_SDMMC2KERSEL_0                     ((uint32_t)0x00001000U)         /* Bit12*/
#define RCC_AHB1SEL1_SDMMC2KERSEL_1                     ((uint32_t)0x00002000U)         /* Bit13*/
#define RCC_AHB1SEL1_SDMMC2KERSEL_2                     ((uint32_t)0x00004000U)         /* Bit14*/

#define RCC_AHB1SEL1_SDMMC2KERSEL_SYSDIV                     ((uint32_t)0x00000000U)
#define RCC_AHB1SEL1_SDMMC2KERSEL_PERIPH                     ((uint32_t)0x00001000U)
#define RCC_AHB1SEL1_SDMMC2KERSEL_PLL2A                     ((uint32_t)0x00002000U)
#define RCC_AHB1SEL1_SDMMC2KERSEL_PLL3A                     ((uint32_t)0x00003000U)
#define RCC_AHB1SEL1_SDMMC2KERSEL_PLL1B                     ((uint32_t)0x00004000U)

#define RCC_AHB1SEL1_ADC3PLLSEL                         ((uint32_t)0x00000300U)         /* Bit[9:8] */
#define RCC_AHB1SEL1_ADC3PLLSEL_0                       ((uint32_t)0x00000100U)         /* Bit8*/
#define RCC_AHB1SEL1_ADC3PLLSEL_1                       ((uint32_t)0x00000200U)         /* Bit9*/
#define RCC_AHB1SEL1_ADC2PLLSEL                         ((uint32_t)0x00000030U)         /* Bit[5:4] */
#define RCC_AHB1SEL1_ADC2PLLSEL_0                       ((uint32_t)0x00000010U)         /* Bit4*/
#define RCC_AHB1SEL1_ADC2PLLSEL_1                       ((uint32_t)0x00000020U)         /* Bit5*/

#define RCC_AHB1SEL1_ADC1PLLSEL                         ((uint32_t)0x00000003U)         /* Bit */
#define RCC_AHB1SEL1_ADC1PLLSEL_0                       ((uint32_t)0x00000001U)         /* Bit0*/
#define RCC_AHB1SEL1_ADC1PLLSEL_1                       ((uint32_t)0x00000002U)         /* Bit1*/

#define RCC_AHB1SEL1_ADC1PLLSEL_PLL2B                   ((uint32_t)0x00000000U)         /* Bit */
#define RCC_AHB1SEL1_ADC1PLLSEL_PLL1B                   ((uint32_t)0x00000001U)         /* Bit0*/
#define RCC_AHB1SEL1_ADC1PLLSEL_PLL3B                   ((uint32_t)0x00000002U)
#define RCC_AHB1SEL1_ADC1PLLSEL_PLL3C                   ((uint32_t)0x00000003U) 
/******** Bit definition for RCC_AHB1EN1 register  ********/
#define RCC_AHB1EN1_M7SDMMC2EN                              ((uint32_t)0x80000000U)         /* Bit[31] */
#define RCC_AHB1EN1_M4SDMMC2EN                              ((uint32_t)0x40000000U)         /* Bit[30] */
#define RCC_AHB1EN1_M7SDMMC2LPEN                            ((uint32_t)0x20000000U)         /* Bit[29] */
#define RCC_AHB1EN1_M4SDMMC2LPEN                            ((uint32_t)0x10000000U)         /* Bit[28] */
#define RCC_AHB1EN1_M7USB2EN                                ((uint32_t)0x00800000U)         /* Bit[23] */
#define RCC_AHB1EN1_M4USB2EN                                ((uint32_t)0x00400000U)         /* Bit[22] */
#define RCC_AHB1EN1_M7USB2LPEN                              ((uint32_t)0x00200000U)         /* Bit[21] */
#define RCC_AHB1EN1_M4USB2LPEN                              ((uint32_t)0x00100000U)         /* Bit[20] */
#define RCC_AHB1EN1_M7DMAMUX1EN                                ((uint32_t)0x00080000U)         /* Bit[19] */
#define RCC_AHB1EN1_M4DMAMUX1EN                                ((uint32_t)0x00040000U)         /* Bit[18] */
#define RCC_AHB1EN1_M7DMAMUX1LPEN                              ((uint32_t)0x00020000U)         /* Bit[17] */
#define RCC_AHB1EN1_M4DMAMUX1LPEN                              ((uint32_t)0x00010000U)         /* Bit[16] */
#define RCC_AHB1EN1_M7ADC1PLLEN                             ((uint32_t)0x00008000U)         /* Bit[15] */
#define RCC_AHB1EN1_M4ADC1PLLEN                             ((uint32_t)0x00004000U)         /* Bit[14] */
#define RCC_AHB1EN1_M7ADC1PLLLPEN                           ((uint32_t)0x00002000U)         /* Bit[13] */
#define RCC_AHB1EN1_M4ADC1PLLLPEN                           ((uint32_t)0x00001000U)         /* Bit[12] */
#define RCC_AHB1EN1_M7ADC1SYSEN                             ((uint32_t)0x00000800U)         /* Bit[11] */
#define RCC_AHB1EN1_M4ADC1SYSEN                             ((uint32_t)0x00000400U)         /* Bit[10] */
#define RCC_AHB1EN1_M7ADC1SYSLPEN                           ((uint32_t)0x00000200U)         /* Bit[9] */
#define RCC_AHB1EN1_M4ADC1SYSLPEN                           ((uint32_t)0x00000100U)         /* Bit[8] */
#define RCC_AHB1EN1_M7ADC1BUSEN                             ((uint32_t)0x00000008U)         /* Bit[3] */
#define RCC_AHB1EN1_M4ADC1BUSEN                             ((uint32_t)0x00000004U)         /* Bit[2] */
#define RCC_AHB1EN1_M7ADC1BUSLPEN                           ((uint32_t)0x00000002U)         /* Bit[1] */
#define RCC_AHB1EN1_M4ADC1BUSLPEN                           ((uint32_t)0x00000001U)         /* Bit[0] */

/******** Bit definition for RCC_AHB1EN2 register  ********/
#define RCC_AHB1EN2_M7ETH2TXEN                              ((uint32_t)0x00000800U)         /* Bit[11] */
#define RCC_AHB1EN2_M4ETH2TXEN                              ((uint32_t)0x00000400U)         /* Bit[10] */
#define RCC_AHB1EN2_M7ETH2TXLPEN                            ((uint32_t)0x00000200U)         /* Bit[9] */
#define RCC_AHB1EN2_M4ETH2TXLPEN                            ((uint32_t)0x00000100U)         /* Bit[8] */
#define RCC_AHB1EN2_M7ETH2RXEN                              ((uint32_t)0x00000080U)         /* Bit[7] */
#define RCC_AHB1EN2_M4ETH2RXEN                              ((uint32_t)0x00000040U)         /* Bit[6] */
#define RCC_AHB1EN2_M7ETH2RXLPEN                            ((uint32_t)0x00000020U)         /* Bit[5] */
#define RCC_AHB1EN2_M4ETH2RXLPEN                            ((uint32_t)0x00000010U)         /* Bit[4] */
#define RCC_AHB1EN2_M7ETH2MACEN                             ((uint32_t)0x00000008U)         /* Bit[3] */
#define RCC_AHB1EN2_M4ETH2MACEN                             ((uint32_t)0x00000004U)         /* Bit[2] */
#define RCC_AHB1EN2_M7ETH2MACLPEN                           ((uint32_t)0x00000002U)         /* Bit[1] */
#define RCC_AHB1EN2_M4ETH2MACLPEN                           ((uint32_t)0x00000001U)         /* Bit[0] */

/******** Bit definition for RCC_AHB1EN3 register  ********/
#define RCC_AHB1EN3_M7ECCMACEN                              ((uint32_t)0x08000000U)         /* Bit[27] */
#define RCC_AHB1EN3_M4ECCMACEN                              ((uint32_t)0x04000000U)         /* Bit[26] */
#define RCC_AHB1EN3_M7ECCMACLPEN                            ((uint32_t)0x02000000U)         /* Bit[25] */
#define RCC_AHB1EN3_M4ECCMACLPEN                            ((uint32_t)0x01000000U)         /* Bit[24] */
#define RCC_AHB1EN3_M7DMA1EN                                ((uint32_t)0x00080000U)         /* Bit[19] */
#define RCC_AHB1EN3_M4DMA1EN                                ((uint32_t)0x00040000U)         /* Bit[18] */
#define RCC_AHB1EN3_M7DMA1LPEN                              ((uint32_t)0x00020000U)         /* Bit[17] */
#define RCC_AHB1EN3_M4DMA1LPEN                              ((uint32_t)0x00010000U)         /* Bit[16] */
#define RCC_AHB1EN3_M7DMA2EN                                ((uint32_t)0x00000800U)         /* Bit[11] */
#define RCC_AHB1EN3_M4DMA2EN                                ((uint32_t)0x00000400U)         /* Bit[10] */
#define RCC_AHB1EN3_M7DMA2LPEN                              ((uint32_t)0x00000200U)         /* Bit[9] */
#define RCC_AHB1EN3_M4DMA2LPEN                              ((uint32_t)0x00000100U)         /* Bit[8] */
#define RCC_AHB1EN3_M7DMA3EN                                ((uint32_t)0x00000008U)         /* Bit[3] */
#define RCC_AHB1EN3_M4DMA3EN                                ((uint32_t)0x00000004U)         /* Bit[2] */
#define RCC_AHB1EN3_M7DMA3LPEN                              ((uint32_t)0x00000002U)         /* Bit[1] */
#define RCC_AHB1EN3_M4DMA3LPEN                              ((uint32_t)0x00000001U)         /* Bit[0] */

/******** Bit definition for RCC_AHB1EN4 register  ********/
#define RCC_AHB1EN4_M7ADC2PLLEN                             ((uint32_t)0x80000000U)         /* Bit[31] */
#define RCC_AHB1EN4_M4ADC2PLLEN                             ((uint32_t)0x40000000U)         /* Bit[30] */
#define RCC_AHB1EN4_M7ADC2PLLLPEN                           ((uint32_t)0x20000000U)         /* Bit[29] */
#define RCC_AHB1EN4_M4ADC2PLLLPEN                           ((uint32_t)0x10000000U)         /* Bit[28] */
#define RCC_AHB1EN4_M7ADC2SYSEN                             ((uint32_t)0x08000000U)         /* Bit[27] */
#define RCC_AHB1EN4_M4ADC2SYSEN                             ((uint32_t)0x04000000U)         /* Bit[26] */
#define RCC_AHB1EN4_M7ADC2SYSLPEN                           ((uint32_t)0x02000000U)         /* Bit[25] */
#define RCC_AHB1EN4_M4ADC2SYSLPEN                           ((uint32_t)0x01000000U)         /* Bit[24] */
#define RCC_AHB1EN4_M7ADC2BUSEN                             ((uint32_t)0x00080000U)         /* Bit[19] */
#define RCC_AHB1EN4_M4ADC2BUSEN                             ((uint32_t)0x00040000U)         /* Bit[18] */
#define RCC_AHB1EN4_M7ADC2BUSLPEN                           ((uint32_t)0x00020000U)         /* Bit[17] */
#define RCC_AHB1EN4_M4ADC2BUSLPEN                           ((uint32_t)0x00010000U)         /* Bit[16] */
#define RCC_AHB1EN4_M7ADC3PLLEN                             ((uint32_t)0x00008000U)         /* Bit[15] */
#define RCC_AHB1EN4_M4ADC3PLLEN                             ((uint32_t)0x00004000U)         /* Bit[14] */
#define RCC_AHB1EN4_M7ADC3PLLLPEN                           ((uint32_t)0x00002000U)         /* Bit[13] */
#define RCC_AHB1EN4_M4ADC3PLLLPEN                           ((uint32_t)0x00001000U)         /* Bit[12] */
#define RCC_AHB1EN4_M7ADC3SYSEN                             ((uint32_t)0x00000800U)         /* Bit[11] */
#define RCC_AHB1EN4_M4ADC3SYSEN                             ((uint32_t)0x00000400U)         /* Bit[10] */
#define RCC_AHB1EN4_M7ADC3SYSLPEN                           ((uint32_t)0x00000200U)         /* Bit[9] */
#define RCC_AHB1EN4_M4ADC3SYSLPEN                           ((uint32_t)0x00000100U)         /* Bit[8] */
#define RCC_AHB1EN4_M7ADC3BUSEN                             ((uint32_t)0x00000008U)         /* Bit[3] */
#define RCC_AHB1EN4_M4ADC3BUSEN                             ((uint32_t)0x00000004U)         /* Bit[2] */
#define RCC_AHB1EN4_M7ADC3BUSLPEN                           ((uint32_t)0x00000002U)         /* Bit[1] */
#define RCC_AHB1EN4_M4ADC3BUSLPEN                           ((uint32_t)0x00000001U)         /* Bit[0] */

/******** Bit definition for RCC_AHB1RST1 register  ********/
#define RCC_AHB1RST1_SDMMC2RST                            ((uint32_t)0x20000000U)         /* Bit[29] */
#define RCC_AHB1RST1_SDHOST2RST                               ((uint32_t)0x10000000U)         /* Bit[28] */
#define RCC_AHB1RST1_USB2WRAPRST                             ((uint32_t)0x00400000U)         /* Bit[22] */
#define RCC_AHB1RST1_USB2PORRST                              ((uint32_t)0x00200000U)         /* Bit[21] */
#define RCC_AHB1RST1_USB2RST                                 ((uint32_t)0x00100000U)         /* Bit[20] */
#define RCC_AHB1RST1_DMAMUX1RST                              ((uint32_t)0x00010000U)         /* Bit[16] */
#define RCC_AHB1RST1_ADC1RST                                 ((uint32_t)0x00000001U)         /* Bit[0] */

/******** Bit definition for RCC_AHB1RST2 register  ********/
#define RCC_AHB1RST2_ETH2RST                                 ((uint32_t)0x00000001U)         /* Bit[0] */

/******** Bit definition for RCC_AHB1RST3 register  ********/
#define RCC_AHB1RST3_ECCMACRST                               ((uint32_t)0x01000000U)         /* Bit[24] */
#define RCC_AHB1RST3_DMA1RST                                 ((uint32_t)0x00010000U)         /* Bit[16] */
#define RCC_AHB1RST3_DMA2RST                                 ((uint32_t)0x00000100U)         /* Bit[8] */
#define RCC_AHB1RST3_DMA3RST                                 ((uint32_t)0x00000001U)         /* Bit[0] */

/******** Bit definition for RCC_AHB1RST4 register  ********/
#define RCC_AHB1RST4_ADC2RST                                 ((uint32_t)0x00010000U)         /* Bit[16] */
#define RCC_AHB1RST4_ADC3RST                                 ((uint32_t)0x00000001U)         /* Bit[0] */

/******** Bit definition for RCC_APB1DIV1 register  ********/
#define RCC_APB1DIV1_APB1USARTDIV                       ((uint32_t)0x70000000U)         /* Bit[30:28] */
#define RCC_APB1DIV1_APB1USARTDIV_0                     ((uint32_t)0x10000000U)         /* Bit28*/
#define RCC_APB1DIV1_APB1USARTDIV_1                     ((uint32_t)0x20000000U)         /* Bit29*/
#define RCC_APB1DIV1_APB1USARTDIV_2                     ((uint32_t)0x40000000U)         /* Bit30*/

#define RCC_APB1DIV1_APB1USARTDIV_DIV1                   ((uint32_t)0x00000000U)
#define RCC_APB1DIV1_APB1USARTDIV_DIV2                   ((uint32_t)0x40000000U)
#define RCC_APB1DIV1_APB1USARTDIV_DIV4                   ((uint32_t)0x50000000U)
#define RCC_APB1DIV1_APB1USARTDIV_DIV8                   ((uint32_t)0x60000000U)
#define RCC_APB1DIV1_APB1USARTDIV_DIV16                  ((uint32_t)0x70000000U)

#define RCC_APB1DIV1_APB1BTIMDIV                        ((uint32_t)0x07000000U)         /* Bit[26:24] */
#define RCC_APB1DIV1_APB1BTIMDIV_0                      ((uint32_t)0x01000000U)         /* Bit24*/
#define RCC_APB1DIV1_APB1BTIMDIV_1                      ((uint32_t)0x02000000U)         /* Bit25*/
#define RCC_APB1DIV1_APB1BTIMDIV_2                      ((uint32_t)0x04000000U)         /* Bit26*/

#define RCC_APB1DIV1_APB1BTIMDIV_DIV1                   ((uint32_t)0x00000000U)
#define RCC_APB1DIV1_APB1BTIMDIV_DIV2                   ((uint32_t)0x04000000U)
#define RCC_APB1DIV1_APB1BTIMDIV_DIV4                   ((uint32_t)0x05000000U)
#define RCC_APB1DIV1_APB1BTIMDIV_DIV8                   ((uint32_t)0x06000000U)
#define RCC_APB1DIV1_APB1BTIMDIV_DIV16                  ((uint32_t)0x07000000U)

#define RCC_APB1DIV1_APB1GTIMDIV                        ((uint32_t)0x00070000U)         /* Bit[18:16] */
#define RCC_APB1DIV1_APB1GTIMDIV_0                      ((uint32_t)0x00010000U)         /* Bit16*/
#define RCC_APB1DIV1_APB1GTIMDIV_1                      ((uint32_t)0x00020000U)         /* Bit17*/
#define RCC_APB1DIV1_APB1GTIMDIV_2                      ((uint32_t)0x00040000U)         /* Bit18*/

#define RCC_APB1DIV1_APB1GTIMDIV_DIV1                   ((uint32_t)0x00000000U)
#define RCC_APB1DIV1_APB1GTIMDIV_DIV2                   ((uint32_t)0x00040000U)
#define RCC_APB1DIV1_APB1GTIMDIV_DIV4                   ((uint32_t)0x00050000U)
#define RCC_APB1DIV1_APB1GTIMDIV_DIV8                   ((uint32_t)0x00060000U)
#define RCC_APB1DIV1_APB1GTIMDIV_DIV16                  ((uint32_t)0x00070000U)

#define RCC_APB1DIV1_APB1I2SDIV                         ((uint32_t)0x00000700U)         /* Bit[10:8] */
#define RCC_APB1DIV1_APB1I2SDIV_0                       ((uint32_t)0x00000100U)         /* Bit8*/
#define RCC_APB1DIV1_APB1I2SDIV_1                       ((uint32_t)0x00000200U)         /* Bit9*/
#define RCC_APB1DIV1_APB1I2SDIV_2                       ((uint32_t)0x00000400U)         /* Bit10*/

#define RCC_APB1DIV1_APB1I2SDIV_DIV1                   ((uint32_t)0x00000000U)
#define RCC_APB1DIV1_APB1I2SDIV_DIV2                   ((uint32_t)0x00000400U)
#define RCC_APB1DIV1_APB1I2SDIV_DIV4                   ((uint32_t)0x00000500U)
#define RCC_APB1DIV1_APB1I2SDIV_DIV8                   ((uint32_t)0x00000600U)
#define RCC_APB1DIV1_APB1I2SDIV_DIV16                  ((uint32_t)0x00000700U)

#define RCC_APB1DIV1_APB1FDCANDIV                       ((uint32_t)0x00000070U)         /* Bit[6:4] */
#define RCC_APB1DIV1_APB1FDCANDIV_0                     ((uint32_t)0x00000010U)         /* Bit4*/
#define RCC_APB1DIV1_APB1FDCANDIV_1                     ((uint32_t)0x00000020U)         /* Bit5*/
#define RCC_APB1DIV1_APB1FDCANDIV_2                     ((uint32_t)0x00000040U)         /* Bit6*/

#define RCC_APB1DIV1_APB1FDCANDIV_DIV1                  ((uint32_t)0x00000000U)
#define RCC_APB1DIV1_APB1FDCANDIV_DIV2                  ((uint32_t)0x00000040U)
#define RCC_APB1DIV1_APB1FDCANDIV_DIV4                  ((uint32_t)0x00000050U)
#define RCC_APB1DIV1_APB1FDCANDIV_DIV8                  ((uint32_t)0x00000060U)
#define RCC_APB1DIV1_APB1FDCANDIV_DIV16                 ((uint32_t)0x00000070U)  

#define RCC_APB1DIV1_APB1I2CDIV                         ((uint32_t)0x00000007U)         /* Bit */
#define RCC_APB1DIV1_APB1I2CDIV_0                       ((uint32_t)0x00000001U)         /* Bit0*/
#define RCC_APB1DIV1_APB1I2CDIV_1                       ((uint32_t)0x00000002U)         /* Bit1*/
#define RCC_APB1DIV1_APB1I2CDIV_2                       ((uint32_t)0x00000004U)         /* Bit2*/

#define RCC_APB1DIV1_APB1I2CDIV_DIV1                   ((uint32_t)0x00000000U)
#define RCC_APB1DIV1_APB1I2CDIV_DIV2                   ((uint32_t)0x00000004U)
#define RCC_APB1DIV1_APB1I2CDIV_DIV4                   ((uint32_t)0x00000005U)
#define RCC_APB1DIV1_APB1I2CDIV_DIV8                   ((uint32_t)0x00000006U)
#define RCC_APB1DIV1_APB1I2CDIV_DIV16                  ((uint32_t)0x00000007U)  
/******** Bit definition for RCC_APB1SEL1 register  ********/
#define RCC_APB1SEL1_I2C1KERSEL                         ((uint32_t)0x70000000U)         /* Bit[30:28] */
#define RCC_APB1SEL1_I2C1KERSEL_0                       ((uint32_t)0x10000000U)         /* Bit28*/
#define RCC_APB1SEL1_I2C1KERSEL_1                       ((uint32_t)0x20000000U)         /* Bit29*/
#define RCC_APB1SEL1_I2C1KERSEL_2                       ((uint32_t)0x40000000U)         /* Bit30*/
#define RCC_APB1SEL1_I2C2KERSEL                         ((uint32_t)0x07000000U)         /* Bit[26:24] */
#define RCC_APB1SEL1_I2C2KERSEL_0                       ((uint32_t)0x01000000U)         /* Bit24*/
#define RCC_APB1SEL1_I2C2KERSEL_1                       ((uint32_t)0x02000000U)         /* Bit25*/
#define RCC_APB1SEL1_I2C2KERSEL_2                       ((uint32_t)0x04000000U)         /* Bit26*/

#define RCC_APB1SEL1_I2C3KERSEL                         ((uint32_t)0x00700000U)         /* Bit[22:20] */
#define RCC_APB1SEL1_I2C3KERSEL_0                       ((uint32_t)0x00100000U)         /* Bit20*/
#define RCC_APB1SEL1_I2C3KERSEL_1                       ((uint32_t)0x00200000U)         /* Bit21*/
#define RCC_APB1SEL1_I2C3KERSEL_2                       ((uint32_t)0x00400000U)         /* Bit22*/

#define RCC_APB1SEL1_I2C3KERSEL_SYSDIV                       ((uint32_t)0x00000000U)
#define RCC_APB1SEL1_I2C3KERSEL_PLL3C                        ((uint32_t)0x00100000U)
#define RCC_APB1SEL1_I2C3KERSEL_HSI                          ((uint32_t)0x00200000U)
#define RCC_APB1SEL1_I2C3KERSEL_MSI                        ((uint32_t)0x00300000U)

#define RCC_APB1SEL1_FDCAN1KERSEL                       ((uint32_t)0x00070000U)         /* Bit[18:16] */
#define RCC_APB1SEL1_FDCAN1KERSEL_0                     ((uint32_t)0x00010000U)         /* Bit16*/
#define RCC_APB1SEL1_FDCAN1KERSEL_1                     ((uint32_t)0x00020000U)         /* Bit17*/
#define RCC_APB1SEL1_FDCAN1KERSEL_2                     ((uint32_t)0x00040000U)         /* Bit18*/

#define RCC_APB1SEL1_FDCAN2KERSEL                       ((uint32_t)0x00000700U)         /* Bit[10:8] */
#define RCC_APB1SEL1_FDCAN2KERSEL_0                     ((uint32_t)0x00000100U)         /* Bit8*/
#define RCC_APB1SEL1_FDCAN2KERSEL_1                     ((uint32_t)0x00000200U)         /* Bit9*/
#define RCC_APB1SEL1_FDCAN2KERSEL_2                     ((uint32_t)0x00000400U)         /* Bit10*/

#define RCC_APB1SEL1_FDCAN2KERSEL_SYSDIV                                ((uint32_t)0x00000000U)
#define RCC_APB1SEL1_FDCAN2KERSEL_PLL1C                                ((uint32_t)0x00000100U)
#define RCC_APB1SEL1_FDCAN2KERSEL_PLL2C                                ((uint32_t)0x00000200U)
#define RCC_APB1SEL1_FDCAN2KERSEL_PLL3B                                ((uint32_t)0x00000300U)
#define RCC_APB1SEL1_FDCAN2KERSEL_PERIPH                                ((uint32_t)0x00000400U)

#define RCC_APB1SEL1_I2S4KERSEL                         ((uint32_t)0x0000000CU)         /* Bit[3:2] */
#define RCC_APB1SEL1_I2S4KERSEL_0                       ((uint32_t)0x00000004U)         /* Bit2*/
#define RCC_APB1SEL1_I2S4KERSEL_1                       ((uint32_t)0x00000008U)         /* Bit3*/
#define RCC_APB1SEL1_I2S3KERSEL                         ((uint32_t)0x00000003U)         /* Bit */
#define RCC_APB1SEL1_I2S3KERSEL_0                       ((uint32_t)0x00000001U)         /* Bit0*/
#define RCC_APB1SEL1_I2S3KERSEL_1                       ((uint32_t)0x00000002U)         /* Bit1*/

/******** Bit definition for RCC_APB1SEL2 register  ********/
#define RCC_APB1SEL2_FDCAN5KERSEL                       ((uint32_t)0x70000000U)         /* Bit[30:28] */
#define RCC_APB1SEL2_FDCAN5KERSEL_0                     ((uint32_t)0x10000000U)         /* Bit28*/
#define RCC_APB1SEL2_FDCAN5KERSEL_1                     ((uint32_t)0x20000000U)         /* Bit29*/
#define RCC_APB1SEL2_FDCAN5KERSEL_2                     ((uint32_t)0x40000000U)         /* Bit30*/
#define RCC_APB1SEL2_FDCAN6KERSEL                       ((uint32_t)0x00700000U)         /* Bit[22:20] */
#define RCC_APB1SEL2_FDCAN6KERSEL_0                     ((uint32_t)0x00100000U)         /* Bit20*/
#define RCC_APB1SEL2_FDCAN6KERSEL_1                     ((uint32_t)0x00200000U)         /* Bit21*/
#define RCC_APB1SEL2_FDCAN6KERSEL_2                     ((uint32_t)0x00400000U)         /* Bit22*/

/******** Bit definition for RCC_APB1EN1 register  ********/
#define RCC_APB1EN1_M7BTIM1EN                               ((uint32_t)0x80000000U)         /* Bit[31] */
#define RCC_APB1EN1_M4BTIM1EN                               ((uint32_t)0x40000000U)         /* Bit[30] */
#define RCC_APB1EN1_M7BTIM1LPEN                             ((uint32_t)0x20000000U)         /* Bit[29] */
#define RCC_APB1EN1_M4BTIM1LPEN                             ((uint32_t)0x10000000U)         /* Bit[28] */
#define RCC_APB1EN1_M7BTIM2EN                               ((uint32_t)0x08000000U)         /* Bit[27] */
#define RCC_APB1EN1_M4BTIM2EN                               ((uint32_t)0x04000000U)         /* Bit[26] */
#define RCC_APB1EN1_M7BTIM2LPEN                             ((uint32_t)0x02000000U)         /* Bit[25] */
#define RCC_APB1EN1_M4BTIM2LPEN                             ((uint32_t)0x01000000U)         /* Bit[24] */
#define RCC_APB1EN1_M7BTIM3EN                               ((uint32_t)0x00800000U)         /* Bit[23] */
#define RCC_APB1EN1_M4BTIM3EN                               ((uint32_t)0x00400000U)         /* Bit[22] */
#define RCC_APB1EN1_M7BTIM3LPEN                             ((uint32_t)0x00200000U)         /* Bit[21] */
#define RCC_APB1EN1_M4BTIM3LPEN                             ((uint32_t)0x00100000U)         /* Bit[20] */
#define RCC_APB1EN1_M7BTIM4EN                               ((uint32_t)0x00080000U)         /* Bit[19] */
#define RCC_APB1EN1_M4BTIM4EN                               ((uint32_t)0x00040000U)         /* Bit[18] */
#define RCC_APB1EN1_M7BTIM4LPEN                             ((uint32_t)0x00020000U)         /* Bit[17] */
#define RCC_APB1EN1_M4BTIM4LPEN                             ((uint32_t)0x00010000U)         /* Bit[16] */
#define RCC_APB1EN1_M7GTIMB1EN                               ((uint32_t)0x00008000U)         /* Bit[15] */
#define RCC_APB1EN1_M4GTIMB1EN                               ((uint32_t)0x00004000U)         /* Bit[14] */
#define RCC_APB1EN1_M7GTIMB1LPEN                             ((uint32_t)0x00002000U)         /* Bit[13] */
#define RCC_APB1EN1_M4GTIMB1LPEN                             ((uint32_t)0x00001000U)         /* Bit[12] */
#define RCC_APB1EN1_M7GTIMB2EN                               ((uint32_t)0x00000800U)         /* Bit[11] */
#define RCC_APB1EN1_M4GTIMB2EN                               ((uint32_t)0x00000400U)         /* Bit[10] */
#define RCC_APB1EN1_M7GTIMB2LPEN                             ((uint32_t)0x00000200U)         /* Bit[9] */
#define RCC_APB1EN1_M4GTIMB2LPEN                             ((uint32_t)0x00000100U)         /* Bit[8] */
#define RCC_APB1EN1_M7GTIMB3EN                              ((uint32_t)0x00000080U)         /* Bit[7] */
#define RCC_APB1EN1_M4GTIMB3EN                              ((uint32_t)0x00000040U)         /* Bit[6] */
#define RCC_APB1EN1_M7GTIMB3LPEN                            ((uint32_t)0x00000020U)         /* Bit[5] */
#define RCC_APB1EN1_M4GTIMB3LPEN                            ((uint32_t)0x00000010U)         /* Bit[4] */
#define RCC_APB1EN1_M7GTIMA4EN                               ((uint32_t)0x00000008U)         /* Bit[3] */
#define RCC_APB1EN1_M4GTIMA4EN                               ((uint32_t)0x00000004U)         /* Bit[2] */
#define RCC_APB1EN1_M7GTIMA4LPEN                             ((uint32_t)0x00000002U)         /* Bit[1] */
#define RCC_APB1EN1_M4GTIMA4LPEN                             ((uint32_t)0x00000001U)         /* Bit[0] */

/******** Bit definition for RCC_APB1EN2 register  ********/
#define RCC_APB1EN2_M7GTIMA5EN                               ((uint32_t)0x80000000U)         /* Bit[31] */
#define RCC_APB1EN2_M4GTIMA5EN                               ((uint32_t)0x40000000U)         /* Bit[30] */
#define RCC_APB1EN2_M7GTIMA5LPEN                             ((uint32_t)0x20000000U)         /* Bit[29] */
#define RCC_APB1EN2_M4GTIMA5LPEN                             ((uint32_t)0x10000000U)         /* Bit[28] */
#define RCC_APB1EN2_M7GTIMA6EN                               ((uint32_t)0x08000000U)         /* Bit[27] */
#define RCC_APB1EN2_M4GTIMA6EN                               ((uint32_t)0x04000000U)         /* Bit[26] */
#define RCC_APB1EN2_M7GTIMA6LPEN                             ((uint32_t)0x02000000U)         /* Bit[25] */
#define RCC_APB1EN2_M4GTIMA6LPEN                             ((uint32_t)0x01000000U)         /* Bit[24] */
#define RCC_APB1EN2_M7GTIMA7EN                               ((uint32_t)0x00800000U)         /* Bit[23] */
#define RCC_APB1EN2_M4GTIMA7EN                               ((uint32_t)0x00400000U)         /* Bit[22] */
#define RCC_APB1EN2_M7GTIMA7LPEN                             ((uint32_t)0x00200000U)         /* Bit[21] */
#define RCC_APB1EN2_M4GTIMA7LPEN                             ((uint32_t)0x00100000U)         /* Bit[20] */
#define RCC_APB1EN2_M7SPI3EN                                ((uint32_t)0x00080000U)         /* Bit[19] */
#define RCC_APB1EN2_M4SPI3EN                                ((uint32_t)0x00040000U)         /* Bit[18] */
#define RCC_APB1EN2_M7SPI3LPEN                              ((uint32_t)0x00020000U)         /* Bit[17] */
#define RCC_APB1EN2_M4SPI3LPEN                              ((uint32_t)0x00010000U)         /* Bit[16] */
#define RCC_APB1EN2_M7DAC12EN                                ((uint32_t)0x00008000U)         /* Bit[15] */
#define RCC_APB1EN2_M4DAC12EN                                ((uint32_t)0x00004000U)         /* Bit[14] */
#define RCC_APB1EN2_M7DAC12LPEN                              ((uint32_t)0x00002000U)         /* Bit[13] */
#define RCC_APB1EN2_M4DAC12LPEN                              ((uint32_t)0x00001000U)         /* Bit[12] */
#define RCC_APB1EN2_M7WWDG2EN                               ((uint32_t)0x00000080U)         /* Bit[7] */
#define RCC_APB1EN2_M4WWDG2EN                               ((uint32_t)0x00000040U)         /* Bit[6] */
#define RCC_APB1EN2_M7WWDG2LPEN                             ((uint32_t)0x00000020U)         /* Bit[5] */
#define RCC_APB1EN2_M4WWDG2LPEN                             ((uint32_t)0x00000010U)         /* Bit[4] */

/******** Bit definition for RCC_APB1EN3 register  ********/
#define RCC_APB1EN3_M7USART1EN                              ((uint32_t)0x80000000U)         /* Bit[31] */
#define RCC_APB1EN3_M4USART1EN                              ((uint32_t)0x40000000U)         /* Bit[30] */
#define RCC_APB1EN3_M7USART1LPEN                            ((uint32_t)0x20000000U)         /* Bit[29] */
#define RCC_APB1EN3_M4USART1LPEN                            ((uint32_t)0x10000000U)         /* Bit[28] */
#define RCC_APB1EN3_M7USART2EN                              ((uint32_t)0x08000000U)         /* Bit[27] */
#define RCC_APB1EN3_M4USART2EN                              ((uint32_t)0x04000000U)         /* Bit[26] */
#define RCC_APB1EN3_M7USART2LPEN                            ((uint32_t)0x02000000U)         /* Bit[25] */
#define RCC_APB1EN3_M4USART2LPEN                            ((uint32_t)0x01000000U)         /* Bit[24] */
#define RCC_APB1EN3_M7USART3EN                              ((uint32_t)0x00800000U)         /* Bit[23] */
#define RCC_APB1EN3_M4USART3EN                              ((uint32_t)0x00400000U)         /* Bit[22] */
#define RCC_APB1EN3_M7USART3LPEN                            ((uint32_t)0x00200000U)         /* Bit[21] */
#define RCC_APB1EN3_M4USART3LPEN                            ((uint32_t)0x00100000U)         /* Bit[20] */
#define RCC_APB1EN3_M7USART4EN                              ((uint32_t)0x00080000U)         /* Bit[19] */
#define RCC_APB1EN3_M4USART4EN                              ((uint32_t)0x00040000U)         /* Bit[18] */
#define RCC_APB1EN3_M7USART4LPEN                            ((uint32_t)0x00020000U)         /* Bit[17] */
#define RCC_APB1EN3_M4USART4LPEN                            ((uint32_t)0x00010000U)         /* Bit[16] */
#define RCC_APB1EN3_M7UART9EN                               ((uint32_t)0x00008000U)         /* Bit[15] */
#define RCC_APB1EN3_M4UART9EN                               ((uint32_t)0x00004000U)         /* Bit[14] */
#define RCC_APB1EN3_M7UART9LPEN                             ((uint32_t)0x00002000U)         /* Bit[13] */
#define RCC_APB1EN3_M4UART9LPEN                             ((uint32_t)0x00001000U)         /* Bit[12] */
#define RCC_APB1EN3_M7UART10EN                               ((uint32_t)0x00000800U)         /* Bit[11] */
#define RCC_APB1EN3_M4UART10EN                               ((uint32_t)0x00000400U)         /* Bit[10] */
#define RCC_APB1EN3_M7UART10LPEN                             ((uint32_t)0x00000200U)         /* Bit[9] */
#define RCC_APB1EN3_M4UART10LPEN                             ((uint32_t)0x00000100U)         /* Bit[8] */
#define RCC_APB1EN3_M7UART11EN                               ((uint32_t)0x00000080U)         /* Bit[7] */
#define RCC_APB1EN3_M4UART11EN                               ((uint32_t)0x00000040U)         /* Bit[6] */
#define RCC_APB1EN3_M7UART11LPEN                             ((uint32_t)0x00000020U)         /* Bit[5] */
#define RCC_APB1EN3_M4UART11LPEN                             ((uint32_t)0x00000010U)         /* Bit[4] */
#define RCC_APB1EN3_M7UART12EN                               ((uint32_t)0x00000008U)         /* Bit[3] */
#define RCC_APB1EN3_M4UART12EN                               ((uint32_t)0x00000004U)         /* Bit[2] */
#define RCC_APB1EN3_M7UART12LPEN                             ((uint32_t)0x00000002U)         /* Bit[1] */
#define RCC_APB1EN3_M4UART12LPEN                             ((uint32_t)0x00000001U)         /* Bit[0] */

/******** Bit definition for RCC_APB1EN4 register  ********/
#define RCC_APB1EN4_M7I2S3EN                                ((uint32_t)0x80000000U)         /* Bit[31] */
#define RCC_APB1EN4_M4I2S3EN                                ((uint32_t)0x40000000U)         /* Bit[30] */
#define RCC_APB1EN4_M7I2S3LPEN                              ((uint32_t)0x20000000U)         /* Bit[29] */
#define RCC_APB1EN4_M4I2S3LPEN                              ((uint32_t)0x10000000U)         /* Bit[28] */
#define RCC_APB1EN4_M7I2S4EN                                ((uint32_t)0x08000000U)         /* Bit[27] */
#define RCC_APB1EN4_M4I2S4EN                                ((uint32_t)0x04000000U)         /* Bit[26] */
#define RCC_APB1EN4_M7I2S4LPEN                              ((uint32_t)0x02000000U)         /* Bit[25] */
#define RCC_APB1EN4_M4I2S4LPEN                              ((uint32_t)0x01000000U)         /* Bit[24] */
#define RCC_APB1EN4_M7I2C1EN                                ((uint32_t)0x00800000U)         /* Bit[23] */
#define RCC_APB1EN4_M4I2C1EN                                ((uint32_t)0x00400000U)         /* Bit[22] */
#define RCC_APB1EN4_M7I2C1LPEN                              ((uint32_t)0x00200000U)         /* Bit[21] */
#define RCC_APB1EN4_M4I2C1LPEN                              ((uint32_t)0x00100000U)         /* Bit[20] */
#define RCC_APB1EN4_M7I2C2EN                                ((uint32_t)0x00080000U)         /* Bit[19] */
#define RCC_APB1EN4_M4I2C2EN                                ((uint32_t)0x00040000U)         /* Bit[18] */
#define RCC_APB1EN4_M7I2C2LPEN                              ((uint32_t)0x00020000U)         /* Bit[17] */
#define RCC_APB1EN4_M4I2C2LPEN                              ((uint32_t)0x00010000U)         /* Bit[16] */
#define RCC_APB1EN4_M7I2C3EN                                ((uint32_t)0x00008000U)         /* Bit[15] */
#define RCC_APB1EN4_M4I2C3EN                                ((uint32_t)0x00004000U)         /* Bit[14] */
#define RCC_APB1EN4_M7I2C3LPEN                              ((uint32_t)0x00002000U)         /* Bit[13] */
#define RCC_APB1EN4_M4I2C3LPEN                              ((uint32_t)0x00001000U)         /* Bit[12] */

/******** Bit definition for RCC_APB1EN5 register  ********/
#define RCC_APB1EN5_M7FDCAN1EN                              ((uint32_t)0x80000000U)         /* Bit[31] */
#define RCC_APB1EN5_M4FDCAN1EN                              ((uint32_t)0x40000000U)         /* Bit[30] */
#define RCC_APB1EN5_M7FDCAN1LPEN                            ((uint32_t)0x20000000U)         /* Bit[29] */
#define RCC_APB1EN5_M4FDCAN1LPEN                            ((uint32_t)0x10000000U)         /* Bit[28] */
#define RCC_APB1EN5_M7FDCAN2EN                              ((uint32_t)0x08000000U)         /* Bit[27] */
#define RCC_APB1EN5_M4FDCAN2EN                              ((uint32_t)0x04000000U)         /* Bit[26] */
#define RCC_APB1EN5_M7FDCAN2LPEN                            ((uint32_t)0x02000000U)         /* Bit[25] */
#define RCC_APB1EN5_M4FDCAN2LPEN                            ((uint32_t)0x01000000U)         /* Bit[24] */
#define RCC_APB1EN5_M7FDCAN5EN                              ((uint32_t)0x00800000U)         /* Bit[23] */
#define RCC_APB1EN5_M4FDCAN5EN                              ((uint32_t)0x00400000U)         /* Bit[22] */
#define RCC_APB1EN5_M7FDCAN5LPEN                            ((uint32_t)0x00200000U)         /* Bit[21] */
#define RCC_APB1EN5_M4FDCAN5LPEN                            ((uint32_t)0x00100000U)         /* Bit[20] */
#define RCC_APB1EN5_M7FDCAN6EN                              ((uint32_t)0x00080000U)         /* Bit[19] */
#define RCC_APB1EN5_M4FDCAN6EN                              ((uint32_t)0x00040000U)         /* Bit[18] */
#define RCC_APB1EN5_M7FDCAN6LPEN                            ((uint32_t)0x00020000U)         /* Bit[17] */
#define RCC_APB1EN5_M4FDCAN6LPEN                            ((uint32_t)0x00010000U)         /* Bit[16] */
#define RCC_APB1EN5_FDCAN1STPREQ                            ((uint32_t)0x00008000U)         /* Bit[15] */
#define RCC_APB1EN5_FDCAN1STPACK                            ((uint32_t)0x00004000U)         /* Bit[14] */
#define RCC_APB1EN5_FDCAN2STPREQ                            ((uint32_t)0x00000800U)         /* Bit[11] */
#define RCC_APB1EN5_FDCAN2STPACK                            ((uint32_t)0x00000400U)         /* Bit[10] */
#define RCC_APB1EN5_FDCAN5STPREQ                            ((uint32_t)0x00000080U)         /* Bit[7] */
#define RCC_APB1EN5_FDCAN5STPACK                            ((uint32_t)0x00000040U)         /* Bit[6] */
#define RCC_APB1EN5_FDCAN6STPREQ                            ((uint32_t)0x00000008U)         /* Bit[3] */
#define RCC_APB1EN5_FDCAN6STPACK                            ((uint32_t)0x00000004U)         /* Bit[2] */

/******** Bit definition for RCC_APB1RST1 register  ********/
#define RCC_APB1RST1_BTIM1RST                                ((uint32_t)0x10000000U)         /* Bit[28] */
#define RCC_APB1RST1_BTIM2RST                                ((uint32_t)0x01000000U)         /* Bit[24] */
#define RCC_APB1RST1_BTIM3RST                                ((uint32_t)0x00100000U)         /* Bit[20] */
#define RCC_APB1RST1_BTIM4RST                                ((uint32_t)0x00010000U)         /* Bit[16] */
#define RCC_APB1RST1_GTIMB1RST                                ((uint32_t)0x00001000U)         /* Bit[12] */
#define RCC_APB1RST1_GTIMB2RST                                ((uint32_t)0x00000100U)         /* Bit[8] */
#define RCC_APB1RST1_GTIMB3RST                               ((uint32_t)0x00000010U)         /* Bit[4] */
#define RCC_APB1RST1_GTIMA4RST                                ((uint32_t)0x00000001U)         /* Bit[0] */

/******** Bit definition for RCC_APB1RST2 register  ********/
#define RCC_APB1RST2_GTIMA5RST                                ((uint32_t)0x10000000U)         /* Bit[28] */
#define RCC_APB1RST2_GTIMA6RST                                ((uint32_t)0x01000000U)         /* Bit[24] */
#define RCC_APB1RST2_GTIMA7RST                                ((uint32_t)0x00100000U)         /* Bit[20] */
#define RCC_APB1RST2_SPI3RST                                 ((uint32_t)0x00010000U)         /* Bit[16] */
#define RCC_APB1RST2_DAC12RST                                 ((uint32_t)0x00001000U)         /* Bit[12] */
#define RCC_APB1RST2_WWDG2RST                                ((uint32_t)0x00000010U)         /* Bit[4] */

/******** Bit definition for RCC_APB1RST3 register  ********/
#define RCC_APB1RST3_USART1RST                               ((uint32_t)0x10000000U)         /* Bit[28] */
#define RCC_APB1RST3_USART2RST                               ((uint32_t)0x01000000U)         /* Bit[24] */
#define RCC_APB1RST3_USART3RST                               ((uint32_t)0x00100000U)         /* Bit[20] */
#define RCC_APB1RST3_USART4RST                               ((uint32_t)0x00010000U)         /* Bit[16] */
#define RCC_APB1RST3_UART9RST                                ((uint32_t)0x00001000U)         /* Bit[12] */
#define RCC_APB1RST3_UART10RST                                ((uint32_t)0x00000100U)         /* Bit[8] */
#define RCC_APB1RST3_UART11RST                                ((uint32_t)0x00000010U)         /* Bit[4] */
#define RCC_APB1RST3_UART12RST                                ((uint32_t)0x00000001U)         /* Bit[0] */

/******** Bit definition for RCC_APB1RST4 register  ********/
#define RCC_APB1RST4_I2S3RST                                 ((uint32_t)0x10000000U)         /* Bit[28] */
#define RCC_APB1RST4_I2S4RST                                 ((uint32_t)0x01000000U)         /* Bit[24] */
#define RCC_APB1RST4_I2C1RST                                 ((uint32_t)0x00100000U)         /* Bit[20] */
#define RCC_APB1RST4_I2C2RST                                 ((uint32_t)0x00010000U)         /* Bit[16] */
#define RCC_APB1RST4_I2C3RST                                 ((uint32_t)0x00001000U)         /* Bit[12] */

/******** Bit definition for RCC_APB1RST5 register  ********/
#define RCC_APB1RST5_FDCAN1RST                               ((uint32_t)0x10000000U)         /* Bit[28] */
#define RCC_APB1RST5_FDCAN2RST                               ((uint32_t)0x01000000U)         /* Bit[24] */
#define RCC_APB1RST5_FDCAN5RST                               ((uint32_t)0x00100000U)         /* Bit[20] */
#define RCC_APB1RST5_FDCAN6RST                               ((uint32_t)0x00010000U)         /* Bit[16] */
#define RCC_APB1RST5_CAHIRST                                 ((uint32_t)0x00000010U)         /* Bit[4] */
#define RCC_APB1RST5_CAHDRST                                 ((uint32_t)0x00000001U)         /* Bit[0] */

/******** Bit definition for RCC_AHB2DIV1 register  ********/
#define RCC_AHB2DIV1_ETH1SYSDIV                         ((uint32_t)0xF0000000U)         /* Bit[31:28] */
#define RCC_AHB2DIV1_ETH1SYSDIV_0                       ((uint32_t)0x10000000U)         /* Bit28*/
#define RCC_AHB2DIV1_ETH1SYSDIV_1                       ((uint32_t)0x20000000U)         /* Bit29*/
#define RCC_AHB2DIV1_ETH1SYSDIV_2                       ((uint32_t)0x40000000U)         /* Bit30*/
#define RCC_AHB2DIV1_ETH1SYSDIV_3                       ((uint32_t)0x80000000U)         /* Bit31*/

#define RCC_AHB2DIV1_ETH1SYSDIV_DIV1                    ((uint32_t)0x00000000U)
#define RCC_AHB2DIV1_ETH1SYSDIV_DIV2                    ((uint32_t)0x10000000U)
#define RCC_AHB2DIV1_ETH1SYSDIV_DIV4                    ((uint32_t)0x20000000U)
#define RCC_AHB2DIV1_ETH1SYSDIV_DIV8                    ((uint32_t)0x40000000U)
#define RCC_AHB2DIV1_ETH1SYSDIV_DIV16                   ((uint32_t)0x70000000U)
#define RCC_AHB2DIV1_ETH1SYSDIV_DIV32                   ((uint32_t)0x80000000U)
#define RCC_AHB2DIV1_ETH1SYSDIV_DIV64                   ((uint32_t)0x90000000U)
#define RCC_AHB2DIV1_ETH1SYSDIV_DIV128                  ((uint32_t)0xA0000000U)
#define RCC_AHB2DIV1_ETH1SYSDIV_DIV256                  ((uint32_t)0xB0000000U)
#define RCC_AHB2DIV1_ETH1SYSDIV_DIV512                  ((uint32_t)0xC0000000U)

#define RCC_AHB2DIV1_USBHSEDIV                          ((uint32_t)0x0000000FU)         /* Bit */
#define RCC_AHB2DIV1_USBHSEDIV_0                        ((uint32_t)0x00000001U)         /* Bit0*/
#define RCC_AHB2DIV1_USBHSEDIV_1                        ((uint32_t)0x00000002U)         /* Bit1*/
#define RCC_AHB2DIV1_USBHSEDIV_2                        ((uint32_t)0x00000004U)         /* Bit2*/
#define RCC_AHB2DIV1_USBHSEDIV_3                        ((uint32_t)0x00000008U)         /* Bit3*/

#define RCC_AHB2DIV1_USBHSEDIV_DIV1                     ((uint32_t)0x00000000U)         /* Bit */
#define RCC_AHB2DIV1_USBHSEDIV_DIV2                     ((uint32_t)0x00000001U) 
/******** Bit definition for RCC_AHB2SEL1 register  ********/
#define RCC_AHB2SEL1_ETH1PTPSEL                         ((uint32_t)0x00300000U)         /* Bit[21:20] */
#define RCC_AHB2SEL1_ETH1PTPSEL_0                       ((uint32_t)0x00100000U)         /* Bit20*/
#define RCC_AHB2SEL1_ETH1PTPSEL_1                       ((uint32_t)0x00200000U)         /* Bit21*/

#define RCC_AHB2SEL1_ETH1PTPSEL_SYSDIV                  ((uint32_t)0x00000000U)
#define RCC_AHB2SEL1_ETH1PTPSEL_PERIPH                  ((uint32_t)0x00100000U)
#define RCC_AHB2SEL1_ETH1PTPSEL_PLL2C                   ((uint32_t)0x00200000U)
#define RCC_AHB2SEL1_ETH1PTPSEL_PLL3A                   ((uint32_t)0x00300000U)

#define RCC_AHB2SEL1_ETH1GMIITXSEL                      ((uint32_t)0x000C0000U)         /* Bit[19:18] */
#define RCC_AHB2SEL1_ETH1GMIITXSEL_0                    ((uint32_t)0x00040000U)         /* Bit18*/
#define RCC_AHB2SEL1_ETH1GMIITXSEL_1                    ((uint32_t)0x00080000U)         /* Bit19*/

#define RCC_AHB2SEL1_ETH1GMIITXSEL_PLL3A                ((uint32_t)0x00000000U)
#define RCC_AHB2SEL1_ETH1GMIITXSEL_PLL2B                ((uint32_t)0x00040000U)
#define RCC_AHB2SEL1_ETH1GMIITXSEL_IOM                  ((uint32_t)0x00080000U)
#define RCC_AHB2SEL1_ETH1GMIITXSEL_PLL1C                ((uint32_t)0x000C0000U)
/******** Bit definition for RCC_AHB2EN1 register  ********/
#define RCC_AHB2EN1_M7USB1EN                                ((uint32_t)0x00800000U)         /* Bit[23] */
#define RCC_AHB2EN1_M4USB1EN                                ((uint32_t)0x00400000U)         /* Bit[22] */
#define RCC_AHB2EN1_M7USB1LPEN                              ((uint32_t)0x00200000U)         /* Bit[21] */
#define RCC_AHB2EN1_M4USB1LPEN                              ((uint32_t)0x00100000U)         /* Bit[20] */
#define RCC_AHB2EN1_M7ECCM2EN                               ((uint32_t)0x00008000U)         /* Bit[15] */
#define RCC_AHB2EN1_M4ECCM2EN                               ((uint32_t)0x00004000U)         /* Bit[14] */
#define RCC_AHB2EN1_M7ECCM2LPEN                             ((uint32_t)0x00002000U)         /* Bit[13] */
#define RCC_AHB2EN1_M4ECCM2LPEN                             ((uint32_t)0x00001000U)         /* Bit[12] */
#define RCC_AHB2EN1_M7CORDICEN                              ((uint32_t)0x00000800U)         /* Bit[11] */
#define RCC_AHB2EN1_M4CORDICEN                              ((uint32_t)0x00000400U)         /* Bit[10] */
#define RCC_AHB2EN1_M7CORDICLPEN                            ((uint32_t)0x00000200U)         /* Bit[9] */
#define RCC_AHB2EN1_M4CORDICLPEN                            ((uint32_t)0x00000100U)         /* Bit[8] */
#define RCC_AHB2EN1_M7SDPUEN                                ((uint32_t)0x00000080U)         /* Bit[7] */
#define RCC_AHB2EN1_M4SDPUEN                                ((uint32_t)0x00000040U)         /* Bit[6] */
#define RCC_AHB2EN1_M7SDPULPEN                              ((uint32_t)0x00000020U)         /* Bit[5] */
#define RCC_AHB2EN1_M4SDPULPEN                              ((uint32_t)0x00000010U)         /* Bit[4] */
#define RCC_AHB2EN1_M7FMACEN                                ((uint32_t)0x00000008U)         /* Bit[3] */
#define RCC_AHB2EN1_M4FMACEN                                ((uint32_t)0x00000004U)         /* Bit[2] */
#define RCC_AHB2EN1_M7FMACLPEN                              ((uint32_t)0x00000002U)         /* Bit[1] */
#define RCC_AHB2EN1_M4FMACLPEN                              ((uint32_t)0x00000001U)         /* Bit[0] */

/******** Bit definition for RCC_AHB2EN2 register  ********/
#define RCC_AHB2EN2_M7DAC56EN                                ((uint32_t)0x00800000U)         /* Bit[23] */
#define RCC_AHB2EN2_M4DAC56EN                                ((uint32_t)0x00400000U)         /* Bit[22] */
#define RCC_AHB2EN2_M7DAC56LPEN                              ((uint32_t)0x00200000U)         /* Bit[21] */
#define RCC_AHB2EN2_M4DAC56LPEN                              ((uint32_t)0x00100000U)         /* Bit[20] */
#define RCC_AHB2EN2_M7DAC34EN                                ((uint32_t)0x00080000U)         /* Bit[19] */
#define RCC_AHB2EN2_M4DAC34EN                                ((uint32_t)0x00040000U)         /* Bit[18] */
#define RCC_AHB2EN2_M7DAC34LPEN                              ((uint32_t)0x00020000U)         /* Bit[17] */
#define RCC_AHB2EN2_M4DAC34LPEN                              ((uint32_t)0x00010000U)         /* Bit[16] */
#define RCC_AHB2EN2_M7ETH1TXEN                              ((uint32_t)0x00000800U)         /* Bit[11] */
#define RCC_AHB2EN2_M4ETH1TXEN                              ((uint32_t)0x00000400U)         /* Bit[10] */
#define RCC_AHB2EN2_M7ETH1TXLPEN                            ((uint32_t)0x00000200U)         /* Bit[9] */
#define RCC_AHB2EN2_M4ETH1TXLPEN                            ((uint32_t)0x00000100U)         /* Bit[8] */
#define RCC_AHB2EN2_M7ETH1RXEN                              ((uint32_t)0x00000080U)         /* Bit[7] */
#define RCC_AHB2EN2_M4ETH1RXEN                              ((uint32_t)0x00000040U)         /* Bit[6] */
#define RCC_AHB2EN2_M7ETH1RXLPEN                            ((uint32_t)0x00000020U)         /* Bit[5] */
#define RCC_AHB2EN2_M4ETH1RXLPEN                            ((uint32_t)0x00000010U)         /* Bit[4] */
#define RCC_AHB2EN2_M7ETH1MACEN                             ((uint32_t)0x00000008U)         /* Bit[3] */
#define RCC_AHB2EN2_M4ETH1MACEN                             ((uint32_t)0x00000004U)         /* Bit[2] */
#define RCC_AHB2EN2_M7ETH1MACLPEN                           ((uint32_t)0x00000002U)         /* Bit[1] */
#define RCC_AHB2EN2_M4ETH1MACLPEN                           ((uint32_t)0x00000001U)         /* Bit[0] */

/******** Bit definition for RCC_AHB2RST1 register  ********/
#define RCC_AHB2RST1_DAC56RST                                 ((uint32_t)0x02000000U)         /* Bit[25] */
#define RCC_AHB2RST1_DAC34RST                                 ((uint32_t)0x01000000U)         /* Bit[24] */
#define RCC_AHB2RST1_USB1WRAPRST                             ((uint32_t)0x00400000U)         /* Bit[22] */
#define RCC_AHB2RST1_USB1PORRST                              ((uint32_t)0x00200000U)         /* Bit[21] */
#define RCC_AHB2RST1_USB1RST                                 ((uint32_t)0x00100000U)         /* Bit[20] */
#define RCC_AHB2RST1_ETH1RST                                 ((uint32_t)0x00010000U)         /* Bit[16] */
#define RCC_AHB2RST1_ECCM2RST                                ((uint32_t)0x00001000U)         /* Bit[12] */
#define RCC_AHB2RST1_CORDICRST                               ((uint32_t)0x00000100U)         /* Bit[8] */
#define RCC_AHB2RST1_SDPURST                                 ((uint32_t)0x00000010U)         /* Bit[4] */
#define RCC_AHB2RST1_FMACRST                                 ((uint32_t)0x00000001U)         /* Bit[0] */

/******** Bit definition for RCC_APB2DIV1 register  ********/
#define RCC_APB2DIV1_APB2ATIMDIV                        ((uint32_t)0x70000000U)         /* Bit[30:28] */
#define RCC_APB2DIV1_APB2ATIMDIV_0                      ((uint32_t)0x10000000U)         /* Bit28*/
#define RCC_APB2DIV1_APB2ATIMDIV_1                      ((uint32_t)0x20000000U)         /* Bit29*/
#define RCC_APB2DIV1_APB2ATIMDIV_2                      ((uint32_t)0x40000000U)         /* Bit30*/

#define RCC_APB2DIV1_APB2ATIMDIV_DIV1                   ((uint32_t)0x00000000U)
#define RCC_APB2DIV1_APB2ATIMDIV_DIV2                   ((uint32_t)0x40000000U)
#define RCC_APB2DIV1_APB2ATIMDIV_DIV4                   ((uint32_t)0x50000000U)
#define RCC_APB2DIV1_APB2ATIMDIV_DIV8                   ((uint32_t)0x60000000U)
#define RCC_APB2DIV1_APB2ATIMDIV_DIV16                  ((uint32_t)0x70000000U)

#define RCC_APB2DIV1_APB2GTIMDIV                        ((uint32_t)0x07000000U)         /* Bit[26:24] */
#define RCC_APB2DIV1_APB2GTIMDIV_0                      ((uint32_t)0x01000000U)         /* Bit24*/
#define RCC_APB2DIV1_APB2GTIMDIV_1                      ((uint32_t)0x02000000U)         /* Bit25*/
#define RCC_APB2DIV1_APB2GTIMDIV_2                      ((uint32_t)0x04000000U)         /* Bit26*/

#define RCC_APB2DIV1_APB2GTIMDIV_DIV1                   ((uint32_t)0x00000000U)
#define RCC_APB2DIV1_APB2GTIMDIV_DIV2                   ((uint32_t)0x04000000U)
#define RCC_APB2DIV1_APB2GTIMDIV_DIV4                   ((uint32_t)0x05000000U)
#define RCC_APB2DIV1_APB2GTIMDIV_DIV8                   ((uint32_t)0x06000000U)
#define RCC_APB2DIV1_APB2GTIMDIV_DIV16                  ((uint32_t)0x07000000U)


#define RCC_APB2DIV1_APB2I2SDIV                         ((uint32_t)0x00070000U)         /* Bit[18:16] */
#define RCC_APB2DIV1_APB2I2SDIV_0                       ((uint32_t)0x00010000U)         /* Bit16*/
#define RCC_APB2DIV1_APB2I2SDIV_1                       ((uint32_t)0x00020000U)         /* Bit17*/
#define RCC_APB2DIV1_APB2I2SDIV_2                       ((uint32_t)0x00040000U)         /* Bit18*/

#define RCC_APB2DIV1_APB2DSMUDIV                        ((uint32_t)0x00007000U)         /* Bit[14:12] */
#define RCC_APB2DIV1_APB2DSMUDIV_0                      ((uint32_t)0x00001000U)         /* Bit12*/
#define RCC_APB2DIV1_APB2DSMUDIV_1                      ((uint32_t)0x00002000U)         /* Bit13*/
#define RCC_APB2DIV1_APB2DSMUDIV_2                      ((uint32_t)0x00004000U)         /* Bit14*/

#define RCC_APB2DIV1_APB2DSMUDIV_DIV1                   ((uint32_t)0x00000000U)
#define RCC_APB2DIV1_APB2DSMUDIV_DIV2                   ((uint32_t)0x00004000U)
#define RCC_APB2DIV1_APB2DSMUDIV_DIV4                   ((uint32_t)0x00005000U)
#define RCC_APB2DIV1_APB2DSMUDIV_DIV8                   ((uint32_t)0x00006000U)
#define RCC_APB2DIV1_APB2DSMUDIV_DIV16                  ((uint32_t)0x00007000U)

#define RCC_APB2DIV1_APB2I2CDIV                         ((uint32_t)0x00000700U)         /* Bit[10:8] */
#define RCC_APB2DIV1_APB2I2CDIV_0                       ((uint32_t)0x00000100U)         /* Bit8*/
#define RCC_APB2DIV1_APB2I2CDIV_1                       ((uint32_t)0x00000200U)         /* Bit9*/
#define RCC_APB2DIV1_APB2I2CDIV_2                       ((uint32_t)0x00000400U)         /* Bit10*/

#define RCC_APB2DIV1_APB2FDCANDIV                       ((uint32_t)0x00000070U)         /* Bit[6:4] */
#define RCC_APB2DIV1_APB2FDCANDIV_0                     ((uint32_t)0x00000010U)         /* Bit4*/
#define RCC_APB2DIV1_APB2FDCANDIV_1                     ((uint32_t)0x00000020U)         /* Bit5*/
#define RCC_APB2DIV1_APB2FDCANDIV_2                     ((uint32_t)0x00000040U)         /* Bit6*/

/******** Bit definition for RCC_APB2SEL1 register  ********/
#define RCC_APB2SEL1_DSMUKERSEL                              ((uint32_t)0x00100000U)         /* Bit[20] */

#define RCC_APB2SEL1_DSMUKERSEL_APB2                         ((uint32_t)0x00000000U)
#define RCC_APB2SEL1_DSMUKERSEL_SYSDIV                       ((uint32_t)0x00100000U)

#define RCC_APB2SEL1_DSMUKERASEL                        ((uint32_t)0x00070000U)         /* Bit[18:16] */
#define RCC_APB2SEL1_DSMUKERASEL_0                      ((uint32_t)0x00010000U)         /* Bit16*/
#define RCC_APB2SEL1_DSMUKERASEL_1                      ((uint32_t)0x00020000U)         /* Bit17*/
#define RCC_APB2SEL1_DSMUKERASEL_2                      ((uint32_t)0x00040000U)         /* Bit18*/

#define RCC_APB2SEL1_DSMUKERASEL_APB2                   ((uint32_t)0x00000000U)
#define RCC_APB2SEL1_DSMUKERASEL_PLL1B                  ((uint32_t)0x00010000U)
#define RCC_APB2SEL1_DSMUKERASEL_PLL2B                  ((uint32_t)0x00020000U)
#define RCC_APB2SEL1_DSMUKERASEL_PLL3A                  ((uint32_t)0x00030000U)
#define RCC_APB2SEL1_DSMUKERASEL_CKIN                   ((uint32_t)0x00040000U)
#define RCC_APB2SEL1_DSMUKERASEL_PERIPH                 ((uint32_t)0x00050000U)

#define RCC_APB2SEL1_I2C4KERSEL                         ((uint32_t)0x00007000U)         /* Bit[14:12] */
#define RCC_APB2SEL1_I2C4KERSEL_0                       ((uint32_t)0x00001000U)         /* Bit12*/
#define RCC_APB2SEL1_I2C4KERSEL_1                       ((uint32_t)0x00002000U)         /* Bit13*/
#define RCC_APB2SEL1_I2C4KERSEL_2                       ((uint32_t)0x00004000U)         /* Bit14*/
#define RCC_APB2SEL1_I2C5KERSEL                         ((uint32_t)0x00000700U)         /* Bit[10:8] */
#define RCC_APB2SEL1_I2C5KERSEL_0                       ((uint32_t)0x00000100U)         /* Bit8*/
#define RCC_APB2SEL1_I2C5KERSEL_1                       ((uint32_t)0x00000200U)         /* Bit9*/
#define RCC_APB2SEL1_I2C5KERSEL_2                       ((uint32_t)0x00000400U)         /* Bit10*/
#define RCC_APB2SEL1_I2C6KERSEL                         ((uint32_t)0x00000070U)         /* Bit[6:4] */
#define RCC_APB2SEL1_I2C6KERSEL_0                       ((uint32_t)0x00000010U)         /* Bit4*/
#define RCC_APB2SEL1_I2C6KERSEL_1                       ((uint32_t)0x00000020U)         /* Bit5*/
#define RCC_APB2SEL1_I2C6KERSEL_2                       ((uint32_t)0x00000040U)         /* Bit6*/

#define RCC_APB2SEL1_I2S2KERSEL                         ((uint32_t)0x0000000CU)         /* Bit[3:2] */
#define RCC_APB2SEL1_I2S2KERSEL_0                       ((uint32_t)0x00000004U)         /* Bit2*/
#define RCC_APB2SEL1_I2S2KERSEL_1                       ((uint32_t)0x00000008U)         /* Bit3*/

#define RCC_APB2SEL1_I2S1KERSEL                         ((uint32_t)0x00000003U)         /* Bit */
#define RCC_APB2SEL1_I2S1KERSEL_0                       ((uint32_t)0x00000001U)         /* Bit0*/
#define RCC_APB2SEL1_I2S1KERSEL_1                       ((uint32_t)0x00000002U)         /* Bit1*/

#define RCC_APB2SEL1_I2S1KERSEL_SYSDIV                                ((uint32_t)0x00000000U)
#define RCC_APB2SEL1_I2S1KERSEL_PLL3B                                 ((uint32_t)0x00000001U)
#define RCC_APB2SEL1_I2S1KERSEL_HSI                                   ((uint32_t)0x00000002U)
#define RCC_APB2SEL1_I2S1KERSEL_CLKIN                                 ((uint32_t)0x00000003U)
/******** Bit definition for RCC_APB2SEL2 register  ********/
#define RCC_APB2SEL2_FDCAN3KERSEL                       ((uint32_t)0x70000000U)         /* Bit[30:28] */
#define RCC_APB2SEL2_FDCAN3KERSEL_0                     ((uint32_t)0x10000000U)         /* Bit28*/
#define RCC_APB2SEL2_FDCAN3KERSEL_1                     ((uint32_t)0x20000000U)         /* Bit29*/
#define RCC_APB2SEL2_FDCAN3KERSEL_2                     ((uint32_t)0x40000000U)         /* Bit30*/
#define RCC_APB2SEL2_FDCAN4KERSEL                       ((uint32_t)0x00700000U)         /* Bit[22:20] */
#define RCC_APB2SEL2_FDCAN4KERSEL_0                     ((uint32_t)0x00100000U)         /* Bit20*/
#define RCC_APB2SEL2_FDCAN4KERSEL_1                     ((uint32_t)0x00200000U)         /* Bit21*/
#define RCC_APB2SEL2_FDCAN4KERSEL_2                     ((uint32_t)0x00400000U)         /* Bit22*/
#define RCC_APB2SEL2_FDCAN7KERSEL                       ((uint32_t)0x00007000U)         /* Bit[14:12] */
#define RCC_APB2SEL2_FDCAN7KERSEL_0                     ((uint32_t)0x00001000U)         /* Bit12*/
#define RCC_APB2SEL2_FDCAN7KERSEL_1                     ((uint32_t)0x00002000U)         /* Bit13*/
#define RCC_APB2SEL2_FDCAN7KERSEL_2                     ((uint32_t)0x00004000U)         /* Bit14*/
#define RCC_APB2SEL2_FDCAN8KERSEL                       ((uint32_t)0x00000070U)         /* Bit[6:4] */
#define RCC_APB2SEL2_FDCAN8KERSEL_0                     ((uint32_t)0x00000010U)         /* Bit4*/
#define RCC_APB2SEL2_FDCAN8KERSEL_1                     ((uint32_t)0x00000020U)         /* Bit5*/
#define RCC_APB2SEL2_FDCAN8KERSEL_2                     ((uint32_t)0x00000040U)         /* Bit6*/

/******** Bit definition for RCC_APB2EN1 register  ********/
#define RCC_APB2EN1_M7ATIM1EN                               ((uint32_t)0x80000000U)         /* Bit[31] */
#define RCC_APB2EN1_M4ATIM1EN                               ((uint32_t)0x40000000U)         /* Bit[30] */
#define RCC_APB2EN1_M7ATIM1LPEN                             ((uint32_t)0x20000000U)         /* Bit[29] */
#define RCC_APB2EN1_M4ATIM1LPEN                             ((uint32_t)0x10000000U)         /* Bit[28] */
#define RCC_APB2EN1_M7ATIM2EN                               ((uint32_t)0x08000000U)         /* Bit[27] */
#define RCC_APB2EN1_M4ATIM2EN                               ((uint32_t)0x04000000U)         /* Bit[26] */
#define RCC_APB2EN1_M7ATIM2LPEN                             ((uint32_t)0x02000000U)         /* Bit[25] */
#define RCC_APB2EN1_M4ATIM2LPEN                             ((uint32_t)0x01000000U)         /* Bit[24] */
#define RCC_APB2EN1_M7GTIMA1EN                               ((uint32_t)0x00800000U)         /* Bit[23] */
#define RCC_APB2EN1_M4GTIMA1EN                               ((uint32_t)0x00400000U)         /* Bit[22] */
#define RCC_APB2EN1_M7GTIMA1LPEN                             ((uint32_t)0x00200000U)         /* Bit[21] */
#define RCC_APB2EN1_M4GTIMA1LPEN                             ((uint32_t)0x00100000U)         /* Bit[20] */
#define RCC_APB2EN1_M7GTIMA2EN                               ((uint32_t)0x00080000U)         /* Bit[19] */
#define RCC_APB2EN1_M4GTIMA2EN                               ((uint32_t)0x00040000U)         /* Bit[18] */
#define RCC_APB2EN1_M7GTIMA2LPEN                             ((uint32_t)0x00020000U)         /* Bit[17] */
#define RCC_APB2EN1_M4GTIMA2LPEN                             ((uint32_t)0x00010000U)         /* Bit[16] */
#define RCC_APB2EN1_M7GTIMA3EN                               ((uint32_t)0x00008000U)         /* Bit[15] */
#define RCC_APB2EN1_M4GTIMA3EN                               ((uint32_t)0x00004000U)         /* Bit[14] */
#define RCC_APB2EN1_M7GTIMA3LPEN                             ((uint32_t)0x00002000U)         /* Bit[13] */
#define RCC_APB2EN1_M4GTIMA3LPEN                             ((uint32_t)0x00001000U)         /* Bit[12] */
#define RCC_APB2EN1_M7SHRTIM1EN                             ((uint32_t)0x00000800U)         /* Bit[11] */
#define RCC_APB2EN1_M4SHRTIM1EN                             ((uint32_t)0x00000400U)         /* Bit[10] */
#define RCC_APB2EN1_M7SHRTIM1LPEN                           ((uint32_t)0x00000200U)         /* Bit[9] */
#define RCC_APB2EN1_M4SHRTIM1LPEN                           ((uint32_t)0x00000100U)         /* Bit[8] */
#define RCC_APB2EN1_M7SHRTIM2EN                             ((uint32_t)0x00000080U)         /* Bit[7] */
#define RCC_APB2EN1_M4SHRTIM2EN                             ((uint32_t)0x00000040U)         /* Bit[6] */
#define RCC_APB2EN1_M7SHRTIM2LPEN                           ((uint32_t)0x00000020U)         /* Bit[5] */
#define RCC_APB2EN1_M4SHRTIM2LPEN                           ((uint32_t)0x00000010U)         /* Bit[4] */

/******** Bit definition for RCC_APB2EN2 register  ********/
#define RCC_APB2EN2_M7I2S1EN                                ((uint32_t)0x80000000U)         /* Bit[31] */
#define RCC_APB2EN2_M4I2S1EN                                ((uint32_t)0x40000000U)         /* Bit[30] */
#define RCC_APB2EN2_M7I2S1LPEN                              ((uint32_t)0x20000000U)         /* Bit[29] */
#define RCC_APB2EN2_M4I2S1LPEN                              ((uint32_t)0x10000000U)         /* Bit[28] */
#define RCC_APB2EN2_M7I2S2EN                                ((uint32_t)0x08000000U)         /* Bit[27] */
#define RCC_APB2EN2_M4I2S2EN                                ((uint32_t)0x04000000U)         /* Bit[26] */
#define RCC_APB2EN2_M7I2S2LPEN                              ((uint32_t)0x02000000U)         /* Bit[25] */
#define RCC_APB2EN2_M4I2S2LPEN                              ((uint32_t)0x01000000U)         /* Bit[24] */
#define RCC_APB2EN2_M7SPI1EN                                ((uint32_t)0x00800000U)         /* Bit[23] */
#define RCC_APB2EN2_M4SPI1EN                                ((uint32_t)0x00400000U)         /* Bit[22] */
#define RCC_APB2EN2_M7SPI1LPEN                              ((uint32_t)0x00200000U)         /* Bit[21] */
#define RCC_APB2EN2_M4SPI1LPEN                              ((uint32_t)0x00100000U)         /* Bit[20] */
#define RCC_APB2EN2_M7SPI2EN                                ((uint32_t)0x00080000U)         /* Bit[19] */
#define RCC_APB2EN2_M4SPI2EN                                ((uint32_t)0x00040000U)         /* Bit[18] */
#define RCC_APB2EN2_M7SPI2LPEN                              ((uint32_t)0x00020000U)         /* Bit[17] */
#define RCC_APB2EN2_M4SPI2LPEN                              ((uint32_t)0x00010000U)         /* Bit[16] */
#define RCC_APB2EN2_M7DSMUEN                                ((uint32_t)0x00008000U)         /* Bit[15] */
#define RCC_APB2EN2_M4DSMUEN                                ((uint32_t)0x00004000U)         /* Bit[14] */
#define RCC_APB2EN2_M7DSMULPEN                              ((uint32_t)0x00002000U)         /* Bit[13] */
#define RCC_APB2EN2_M4DSMULPEN                              ((uint32_t)0x00001000U)         /* Bit[12] */
#define RCC_APB2EN2_M7I2C4EN                                ((uint32_t)0x00000800U)         /* Bit[11] */
#define RCC_APB2EN2_M4I2C4EN                                ((uint32_t)0x00000400U)         /* Bit[10] */
#define RCC_APB2EN2_M7I2C4LPEN                              ((uint32_t)0x00000200U)         /* Bit[9] */
#define RCC_APB2EN2_M4I2C4LPEN                              ((uint32_t)0x00000100U)         /* Bit[8] */
#define RCC_APB2EN2_M7I2C5EN                                ((uint32_t)0x00000080U)         /* Bit[7] */
#define RCC_APB2EN2_M4I2C5EN                                ((uint32_t)0x00000040U)         /* Bit[6] */
#define RCC_APB2EN2_M7I2C5LPEN                              ((uint32_t)0x00000020U)         /* Bit[5] */
#define RCC_APB2EN2_M4I2C5LPEN                              ((uint32_t)0x00000010U)         /* Bit[4] */
#define RCC_APB2EN2_M7I2C6EN                                ((uint32_t)0x00000008U)         /* Bit[3] */
#define RCC_APB2EN2_M4I2C6EN                                ((uint32_t)0x00000004U)         /* Bit[2] */
#define RCC_APB2EN2_M7I2C6LPEN                              ((uint32_t)0x00000002U)         /* Bit[1] */
#define RCC_APB2EN2_M4I2C6LPEN                              ((uint32_t)0x00000001U)         /* Bit[0] */

/******** Bit definition for RCC_APB2EN3 register  ********/
#define RCC_APB2EN3_M7USART5EN                              ((uint32_t)0x80000000U)         /* Bit[31] */
#define RCC_APB2EN3_M4USART5EN                              ((uint32_t)0x40000000U)         /* Bit[30] */
#define RCC_APB2EN3_M7USART5LPEN                            ((uint32_t)0x20000000U)         /* Bit[29] */
#define RCC_APB2EN3_M4USART5LPEN                            ((uint32_t)0x10000000U)         /* Bit[28] */
#define RCC_APB2EN3_M7USART6EN                              ((uint32_t)0x08000000U)         /* Bit[27] */
#define RCC_APB2EN3_M4USART6EN                              ((uint32_t)0x04000000U)         /* Bit[26] */
#define RCC_APB2EN3_M7USART6LPEN                            ((uint32_t)0x02000000U)         /* Bit[25] */
#define RCC_APB2EN3_M4USART6LPEN                            ((uint32_t)0x01000000U)         /* Bit[24] */
#define RCC_APB2EN3_M7USART7EN                              ((uint32_t)0x00800000U)         /* Bit[23] */
#define RCC_APB2EN3_M4USART7EN                              ((uint32_t)0x00400000U)         /* Bit[22] */
#define RCC_APB2EN3_M7USART7LPEN                            ((uint32_t)0x00200000U)         /* Bit[21] */
#define RCC_APB2EN3_M4USART7LPEN                            ((uint32_t)0x00100000U)         /* Bit[20] */
#define RCC_APB2EN3_M7USART8EN                              ((uint32_t)0x00080000U)         /* Bit[19] */
#define RCC_APB2EN3_M4USART8EN                              ((uint32_t)0x00040000U)         /* Bit[18] */
#define RCC_APB2EN3_M7USART8LPEN                            ((uint32_t)0x00020000U)         /* Bit[17] */
#define RCC_APB2EN3_M4USART8LPEN                            ((uint32_t)0x00010000U)         /* Bit[16] */
#define RCC_APB2EN3_M7UART13EN                               ((uint32_t)0x00008000U)         /* Bit[15] */
#define RCC_APB2EN3_M4UART13EN                               ((uint32_t)0x00004000U)         /* Bit[14] */
#define RCC_APB2EN3_M7UART13LPEN                             ((uint32_t)0x00002000U)         /* Bit[13] */
#define RCC_APB2EN3_M4UART13LPEN                             ((uint32_t)0x00001000U)         /* Bit[12] */
#define RCC_APB2EN3_M7UART14EN                               ((uint32_t)0x00000800U)         /* Bit[11] */
#define RCC_APB2EN3_M4UART14EN                               ((uint32_t)0x00000400U)         /* Bit[10] */
#define RCC_APB2EN3_M7UART14LPEN                             ((uint32_t)0x00000200U)         /* Bit[9] */
#define RCC_APB2EN3_M4UART14LPEN                             ((uint32_t)0x00000100U)         /* Bit[8] */
#define RCC_APB2EN3_M7UART15EN                               ((uint32_t)0x00000080U)         /* Bit[7] */
#define RCC_APB2EN3_M4UART15EN                               ((uint32_t)0x00000040U)         /* Bit[6] */
#define RCC_APB2EN3_M7UART15LPEN                             ((uint32_t)0x00000020U)         /* Bit[5] */
#define RCC_APB2EN3_M4UART15LPEN                             ((uint32_t)0x00000010U)         /* Bit[4] */

/******** Bit definition for RCC_APB2EN4 register  ********/
#define RCC_APB2EN4_M7FDCAN3EN                              ((uint32_t)0x80000000U)         /* Bit[31] */
#define RCC_APB2EN4_M4FDCAN3EN                              ((uint32_t)0x40000000U)         /* Bit[30] */
#define RCC_APB2EN4_M7FDCAN3LPEN                            ((uint32_t)0x20000000U)         /* Bit[29] */
#define RCC_APB2EN4_M4FDCAN3LPEN                            ((uint32_t)0x10000000U)         /* Bit[28] */
#define RCC_APB2EN4_M7FDCAN4EN                              ((uint32_t)0x08000000U)         /* Bit[27] */
#define RCC_APB2EN4_M4FDCAN4EN                              ((uint32_t)0x04000000U)         /* Bit[26] */
#define RCC_APB2EN4_M7FDCAN4LPEN                            ((uint32_t)0x02000000U)         /* Bit[25] */
#define RCC_APB2EN4_M4FDCAN4LPEN                            ((uint32_t)0x01000000U)         /* Bit[24] */
#define RCC_APB2EN4_M7FDCAN7EN                              ((uint32_t)0x00800000U)         /* Bit[23] */
#define RCC_APB2EN4_M4FDCAN7EN                              ((uint32_t)0x00400000U)         /* Bit[22] */
#define RCC_APB2EN4_M7FDCAN7LPEN                            ((uint32_t)0x00200000U)         /* Bit[21] */
#define RCC_APB2EN4_M4FDCAN7LPEN                            ((uint32_t)0x00100000U)         /* Bit[20] */
#define RCC_APB2EN4_M7FDCAN8EN                              ((uint32_t)0x00080000U)         /* Bit[19] */
#define RCC_APB2EN4_M4FDCAN8EN                              ((uint32_t)0x00040000U)         /* Bit[18] */
#define RCC_APB2EN4_M7FDCAN8LPEN                            ((uint32_t)0x00020000U)         /* Bit[17] */
#define RCC_APB2EN4_M4FDCAN8LPEN                            ((uint32_t)0x00010000U)         /* Bit[16] */
#define RCC_APB2EN4_FDCAN3STPREQ                            ((uint32_t)0x00008000U)         /* Bit[15] */
#define RCC_APB2EN4_FDCAN3STPACK                            ((uint32_t)0x00004000U)         /* Bit[14] */
#define RCC_APB2EN4_FDCAN4STPREQ                            ((uint32_t)0x00000800U)         /* Bit[11] */
#define RCC_APB2EN4_FDCAN4STPACK                            ((uint32_t)0x00000400U)         /* Bit[10] */
#define RCC_APB2EN4_FDCAN7STPREQ                            ((uint32_t)0x00000080U)         /* Bit[7] */
#define RCC_APB2EN4_FDCAN7STPACK                            ((uint32_t)0x00000040U)         /* Bit[6] */
#define RCC_APB2EN4_FDCAN8STPREQ                            ((uint32_t)0x00000008U)         /* Bit[3] */
#define RCC_APB2EN4_FDCAN8STPACK                            ((uint32_t)0x00000004U)         /* Bit[2] */

/******** Bit definition for RCC_APB2RST1 register  ********/
#define RCC_APB2RST1_ATIM1RST                                ((uint32_t)0x10000000U)         /* Bit[28] */
#define RCC_APB2RST1_ATIM2RST                                ((uint32_t)0x01000000U)         /* Bit[24] */
#define RCC_APB2RST1_GTIMA1RST                                ((uint32_t)0x00100000U)         /* Bit[20] */
#define RCC_APB2RST1_GTIMA2RST                                ((uint32_t)0x00010000U)         /* Bit[16] */
#define RCC_APB2RST1_GTIMA3RST                                ((uint32_t)0x00001000U)         /* Bit[12] */
#define RCC_APB2RST1_SHRTIM1RST                              ((uint32_t)0x00000100U)         /* Bit[8] */
#define RCC_APB2RST1_SHRTIM2RST                              ((uint32_t)0x00000010U)         /* Bit[4] */

/******** Bit definition for RCC_APB2RST2 register  ********/
#define RCC_APB2RST2_I2S1RST                                 ((uint32_t)0x10000000U)         /* Bit[28] */
#define RCC_APB2RST2_I2S2RST                                 ((uint32_t)0x01000000U)         /* Bit[24] */
#define RCC_APB2RST2_SPI1RST                                 ((uint32_t)0x00100000U)         /* Bit[20] */
#define RCC_APB2RST2_SPI2RST                                 ((uint32_t)0x00010000U)         /* Bit[16] */
#define RCC_APB2RST2_DSMURST                                 ((uint32_t)0x00001000U)         /* Bit[12] */
#define RCC_APB2RST2_I2C4RST                                 ((uint32_t)0x00000100U)         /* Bit[8] */
#define RCC_APB2RST2_I2C5RST                                 ((uint32_t)0x00000010U)         /* Bit[4] */
#define RCC_APB2RST2_I2C6RST                                 ((uint32_t)0x00000001U)         /* Bit[0] */

/******** Bit definition for RCC_APB2RST3 register  ********/
#define RCC_APB2RST3_USART5RST                               ((uint32_t)0x10000000U)         /* Bit[28] */
#define RCC_APB2RST3_USART6RST                               ((uint32_t)0x01000000U)         /* Bit[24] */
#define RCC_APB2RST3_USART7RST                               ((uint32_t)0x00100000U)         /* Bit[20] */
#define RCC_APB2RST3_USART8RST                               ((uint32_t)0x00010000U)         /* Bit[16] */
#define RCC_APB2RST3_UART13RST                                ((uint32_t)0x00001000U)         /* Bit[12] */
#define RCC_APB2RST3_UART14RST                                ((uint32_t)0x00000100U)         /* Bit[8] */
#define RCC_APB2RST3_UART15RST                                ((uint32_t)0x00000010U)         /* Bit[4] */

/******** Bit definition for RCC_APB2RST4 register  ********/
#define RCC_APB2RST4_FDCAN3RST                               ((uint32_t)0x10000000U)         /* Bit[28] */
#define RCC_APB2RST4_FDCAN4RST                               ((uint32_t)0x01000000U)         /* Bit[24] */
#define RCC_APB2RST4_FDCAN7RST                               ((uint32_t)0x00100000U)         /* Bit[20] */
#define RCC_APB2RST4_FDCAN8RST                               ((uint32_t)0x00010000U)         /* Bit[16] */

/******** Bit definition for RCC_AHB5EN1 register  ********/
#define RCC_AHB5EN1_M7GPIOAEN                               ((uint32_t)0x80000000U)         /* Bit[31] */
#define RCC_AHB5EN1_M4GPIOAEN                               ((uint32_t)0x40000000U)         /* Bit[30] */
#define RCC_AHB5EN1_M7GPIOALPEN                             ((uint32_t)0x20000000U)         /* Bit[29] */
#define RCC_AHB5EN1_M4GPIOALPEN                             ((uint32_t)0x10000000U)         /* Bit[28] */
#define RCC_AHB5EN1_M7GPIOBEN                               ((uint32_t)0x08000000U)         /* Bit[27] */
#define RCC_AHB5EN1_M4GPIOBEN                               ((uint32_t)0x04000000U)         /* Bit[26] */
#define RCC_AHB5EN1_M7GPIOBLPEN                             ((uint32_t)0x02000000U)         /* Bit[25] */
#define RCC_AHB5EN1_M4GPIOBLPEN                             ((uint32_t)0x01000000U)         /* Bit[24] */
#define RCC_AHB5EN1_M7GPIOCEN                               ((uint32_t)0x00800000U)         /* Bit[23] */
#define RCC_AHB5EN1_M4GPIOCEN                               ((uint32_t)0x00400000U)         /* Bit[22] */
#define RCC_AHB5EN1_M7GPIOCLPEN                             ((uint32_t)0x00200000U)         /* Bit[21] */
#define RCC_AHB5EN1_M4GPIOCLPEN                             ((uint32_t)0x00100000U)         /* Bit[20] */
#define RCC_AHB5EN1_M7GPIODEN                               ((uint32_t)0x00080000U)         /* Bit[19] */
#define RCC_AHB5EN1_M4GPIODEN                               ((uint32_t)0x00040000U)         /* Bit[18] */
#define RCC_AHB5EN1_M7GPIODLPEN                             ((uint32_t)0x00020000U)         /* Bit[17] */
#define RCC_AHB5EN1_M4GPIODLPEN                             ((uint32_t)0x00010000U)         /* Bit[16] */
#define RCC_AHB5EN1_M7GPIOEEN                               ((uint32_t)0x00008000U)         /* Bit[15] */
#define RCC_AHB5EN1_M4GPIOEEN                               ((uint32_t)0x00004000U)         /* Bit[14] */
#define RCC_AHB5EN1_M7GPIOELPEN                             ((uint32_t)0x00002000U)         /* Bit[13] */
#define RCC_AHB5EN1_M4GPIOELPEN                             ((uint32_t)0x00001000U)         /* Bit[12] */
#define RCC_AHB5EN1_M7GPIOFEN                               ((uint32_t)0x00000800U)         /* Bit[11] */
#define RCC_AHB5EN1_M4GPIOFEN                               ((uint32_t)0x00000400U)         /* Bit[10] */
#define RCC_AHB5EN1_M7GPIOFLPEN                             ((uint32_t)0x00000200U)         /* Bit[9] */
#define RCC_AHB5EN1_M4GPIOFLPEN                             ((uint32_t)0x00000100U)         /* Bit[8] */
#define RCC_AHB5EN1_M7GPIOGEN                               ((uint32_t)0x00000080U)         /* Bit[7] */
#define RCC_AHB5EN1_M4GPIOGEN                               ((uint32_t)0x00000040U)         /* Bit[6] */
#define RCC_AHB5EN1_M7GPIOGLPEN                             ((uint32_t)0x00000020U)         /* Bit[5] */
#define RCC_AHB5EN1_M4GPIOGLPEN                             ((uint32_t)0x00000010U)         /* Bit[4] */
#define RCC_AHB5EN1_M7GPIOHEN                               ((uint32_t)0x00000008U)         /* Bit[3] */
#define RCC_AHB5EN1_M4GPIOHEN                               ((uint32_t)0x00000004U)         /* Bit[2] */
#define RCC_AHB5EN1_M7GPIOHLPEN                             ((uint32_t)0x00000002U)         /* Bit[1] */
#define RCC_AHB5EN1_M4GPIOHLPEN                             ((uint32_t)0x00000001U)         /* Bit[0] */

/******** Bit definition for RCC_AHB5EN2 register  ********/
#define RCC_AHB5EN2_M7GPIOIEN                               ((uint32_t)0x80000000U)         /* Bit[31] */
#define RCC_AHB5EN2_M4GPIOIEN                               ((uint32_t)0x40000000U)         /* Bit[30] */
#define RCC_AHB5EN2_M7GPIOILPEN                             ((uint32_t)0x20000000U)         /* Bit[29] */
#define RCC_AHB5EN2_M4GPIOILPEN                             ((uint32_t)0x10000000U)         /* Bit[28] */
#define RCC_AHB5EN2_M7GPIOJEN                               ((uint32_t)0x08000000U)         /* Bit[27] */
#define RCC_AHB5EN2_M4GPIOJEN                               ((uint32_t)0x04000000U)         /* Bit[26] */
#define RCC_AHB5EN2_M7GPIOJLPEN                             ((uint32_t)0x02000000U)         /* Bit[25] */
#define RCC_AHB5EN2_M4GPIOJLPEN                             ((uint32_t)0x01000000U)         /* Bit[24] */
#define RCC_AHB5EN2_M7GPIOKEN                               ((uint32_t)0x00800000U)         /* Bit[23] */
#define RCC_AHB5EN2_M4GPIOKEN                               ((uint32_t)0x00400000U)         /* Bit[22] */
#define RCC_AHB5EN2_M7GPIOKLPEN                             ((uint32_t)0x00200000U)         /* Bit[21] */
#define RCC_AHB5EN2_M4GPIOKLPEN                             ((uint32_t)0x00100000U)         /* Bit[20] */
#define RCC_AHB5EN2_M7ECCM3EN                               ((uint32_t)0x00080000U)         /* Bit[19] */
#define RCC_AHB5EN2_M4ECCM3EN                               ((uint32_t)0x00040000U)         /* Bit[18] */
#define RCC_AHB5EN2_M7ECCM3LPEN                             ((uint32_t)0x00020000U)         /* Bit[17] */
#define RCC_AHB5EN2_M4ECCM3LPEN                             ((uint32_t)0x00010000U)         /* Bit[16] */
#define RCC_AHB5EN2_PWREN                                   ((uint32_t)0x00008000U)         /* Bit[15] */
#define RCC_AHB5EN2_PWRLPEN                                 ((uint32_t)0x00002000U)         /* Bit[13] */
#define RCC_AHB5EN2_M7CRCEN                                 ((uint32_t)0x00000800U)         /* Bit[11] */
#define RCC_AHB5EN2_M4CRCEN                                 ((uint32_t)0x00000400U)         /* Bit[10] */
#define RCC_AHB5EN2_M7CRCLPEN                               ((uint32_t)0x00000200U)         /* Bit[9] */
#define RCC_AHB5EN2_M4CRCLPEN                               ((uint32_t)0x00000100U)         /* Bit[8] */
#define RCC_AHB5EN2_M7SEMA4EN                               ((uint32_t)0x00000080U)         /* Bit[7] */
#define RCC_AHB5EN2_M4SEMA4EN                               ((uint32_t)0x00000040U)         /* Bit[6] */
#define RCC_AHB5EN2_M7SEMA4LPEN                             ((uint32_t)0x00000020U)         /* Bit[5] */
#define RCC_AHB5EN2_M4SEMA4LPEN                             ((uint32_t)0x00000010U)         /* Bit[4] */
#define RCC_AHB5EN2_M7AFIOEN                                ((uint32_t)0x00000008U)         /* Bit[3] */
#define RCC_AHB5EN2_M4AFIOEN                                ((uint32_t)0x00000004U)         /* Bit[2] */
#define RCC_AHB5EN2_M7AFIOLPEN                              ((uint32_t)0x00000002U)         /* Bit[1] */
#define RCC_AHB5EN2_M4AFIOLPEN                              ((uint32_t)0x00000001U)         /* Bit[0] */

/******** Bit definition for RCC_AHB5RST1 register  ********/
#define RCC_AHB5RST1_GPIOARST                                ((uint32_t)0x10000000U)         /* Bit[28] */
#define RCC_AHB5RST1_GPIOBRST                                ((uint32_t)0x01000000U)         /* Bit[24] */
#define RCC_AHB5RST1_GPIOCRST                                ((uint32_t)0x00100000U)         /* Bit[20] */
#define RCC_AHB5RST1_GPIODRST                                ((uint32_t)0x00010000U)         /* Bit[16] */
#define RCC_AHB5RST1_GPIOERST                                ((uint32_t)0x00001000U)         /* Bit[12] */
#define RCC_AHB5RST1_GPIOFRST                                ((uint32_t)0x00000100U)         /* Bit[8] */
#define RCC_AHB5RST1_GPIOGRST                                ((uint32_t)0x00000010U)         /* Bit[4] */
#define RCC_AHB5RST1_GPIOHRST                                ((uint32_t)0x00000001U)         /* Bit[0] */

/******** Bit definition for RCC_AHB5RST2 register  ********/
#define RCC_AHB5RST2_GPIOIRST                                ((uint32_t)0x10000000U)         /* Bit[28] */
#define RCC_AHB5RST2_GPIOJRST                                ((uint32_t)0x01000000U)         /* Bit[24] */
#define RCC_AHB5RST2_GPIOKRST                                ((uint32_t)0x00100000U)         /* Bit[20] */
#define RCC_AHB5RST2_ECCM3RST                                ((uint32_t)0x00010000U)         /* Bit[16] */
#define RCC_AHB5RST2_PWRRST                                  ((uint32_t)0x00001000U)         /* Bit[12] */
#define RCC_AHB5RST2_CRCRST                                  ((uint32_t)0x00000100U)         /* Bit[8] */
#define RCC_AHB5RST2_SEMA4RST                                ((uint32_t)0x00000010U)         /* Bit[4] */
#define RCC_AHB5RST2_AFIORST                                 ((uint32_t)0x00000001U)         /* Bit[0] */

/******** Bit definition for RCC_APB5DIV1 register  ********/
#define RCC_APB5DIV1_APB5ATIMDIV                        ((uint32_t)0x70000000U)         /* Bit[30:28] */
#define RCC_APB5DIV1_APB5ATIMDIV_0                      ((uint32_t)0x10000000U)         /* Bit28*/
#define RCC_APB5DIV1_APB5ATIMDIV_1                      ((uint32_t)0x20000000U)         /* Bit29*/
#define RCC_APB5DIV1_APB5ATIMDIV_2                      ((uint32_t)0x40000000U)         /* Bit30*/

#define RCC_APB5DIV1_APB5ATIMDIV_DIV1                   ((uint32_t)0x00000000U)
#define RCC_APB5DIV1_APB5ATIMDIV_DIV2                   ((uint32_t)0x40000000U)
#define RCC_APB5DIV1_APB5ATIMDIV_DIV4                   ((uint32_t)0x50000000U)
#define RCC_APB5DIV1_APB5ATIMDIV_DIV8                   ((uint32_t)0x60000000U)
#define RCC_APB5DIV1_APB5ATIMDIV_DIV16                  ((uint32_t)0x70000000U)

#define RCC_APB5DIV1_APB5I2CDIV                         ((uint32_t)0x07000000U)         /* Bit[26:24] */
#define RCC_APB5DIV1_APB5I2CDIV_0                       ((uint32_t)0x01000000U)         /* Bit24*/
#define RCC_APB5DIV1_APB5I2CDIV_1                       ((uint32_t)0x02000000U)         /* Bit25*/
#define RCC_APB5DIV1_APB5I2CDIV_2                       ((uint32_t)0x04000000U)         /* Bit26*/

#define RCC_APB5DIV1_APB5EXTIDIV                        ((uint32_t)0x00700000U)         /* Bit[22:20] */
#define RCC_APB5DIV1_APB5EXTIDIV_0                      ((uint32_t)0x00100000U)         /* Bit20*/
#define RCC_APB5DIV1_APB5EXTIDIV_1                      ((uint32_t)0x00200000U)         /* Bit21*/
#define RCC_APB5DIV1_APB5EXTIDIV_2                      ((uint32_t)0x00400000U)         /* Bit22*/

#define RCC_APB5DIV1_APB5EXTIDIV_DIV1                   ((uint32_t)0x00000000U)
#define RCC_APB5DIV1_APB5EXTIDIV_DIV2                   ((uint32_t)0x00400000U)
#define RCC_APB5DIV1_APB5EXTIDIV_DIV4                   ((uint32_t)0x00500000U)
#define RCC_APB5DIV1_APB5EXTIDIV_DIV8                   ((uint32_t)0x00600000U)
#define RCC_APB5DIV1_APB5EXTIDIV_DIV16                  ((uint32_t)0x00700000U)
/******** Bit definition for RCC_APB5SEL1 register  ********/
#define RCC_APB5SEL1_I2C7KERSEL                         ((uint32_t)0x70000000U)         /* Bit[30:28] */
#define RCC_APB5SEL1_I2C7KERSEL_0                       ((uint32_t)0x10000000U)         /* Bit28*/
#define RCC_APB5SEL1_I2C7KERSEL_1                       ((uint32_t)0x20000000U)         /* Bit29*/
#define RCC_APB5SEL1_I2C7KERSEL_2                       ((uint32_t)0x40000000U)         /* Bit30*/
#define RCC_APB5SEL1_I2C8KERSEL                         ((uint32_t)0x07000000U)         /* Bit[26:24] */
#define RCC_APB5SEL1_I2C8KERSEL_0                       ((uint32_t)0x01000000U)         /* Bit24*/
#define RCC_APB5SEL1_I2C8KERSEL_1                       ((uint32_t)0x02000000U)         /* Bit25*/
#define RCC_APB5SEL1_I2C8KERSEL_2                       ((uint32_t)0x04000000U)         /* Bit26*/
#define RCC_APB5SEL1_I2C9KERSEL                         ((uint32_t)0x00700000U)         /* Bit[22:20] */
#define RCC_APB5SEL1_I2C9KERSEL_0                       ((uint32_t)0x00100000U)         /* Bit20*/
#define RCC_APB5SEL1_I2C9KERSEL_1                       ((uint32_t)0x00200000U)         /* Bit21*/
#define RCC_APB5SEL1_I2C9KERSEL_2                       ((uint32_t)0x00400000U)         /* Bit22*/
#define RCC_APB5SEL1_I2C10KERSEL                        ((uint32_t)0x00070000U)         /* Bit[18:16] */
#define RCC_APB5SEL1_I2C10KERSEL_0                      ((uint32_t)0x00010000U)         /* Bit16*/
#define RCC_APB5SEL1_I2C10KERSEL_1                      ((uint32_t)0x00020000U)         /* Bit17*/
#define RCC_APB5SEL1_I2C10KERSEL_2                      ((uint32_t)0x00040000U)         /* Bit18*/

/******** Bit definition for RCC_APB5EN1 register  ********/
#define RCC_APB5EN1_M7ATIM3EN                               ((uint32_t)0x80000000U)         /* Bit[31] */
#define RCC_APB5EN1_M4ATIM3EN                               ((uint32_t)0x40000000U)         /* Bit[30] */
#define RCC_APB5EN1_M7ATIM3LPEN                             ((uint32_t)0x20000000U)         /* Bit[29] */
#define RCC_APB5EN1_M4ATIM3LPEN                             ((uint32_t)0x10000000U)         /* Bit[28] */
#define RCC_APB5EN1_M7ATIM4EN                               ((uint32_t)0x08000000U)         /* Bit[27] */
#define RCC_APB5EN1_M4ATIM4EN                               ((uint32_t)0x04000000U)         /* Bit[26] */
#define RCC_APB5EN1_M7ATIM4LPEN                             ((uint32_t)0x02000000U)         /* Bit[25] */
#define RCC_APB5EN1_M4ATIM4LPEN                             ((uint32_t)0x01000000U)         /* Bit[24] */
#define RCC_APB5EN1_M7AFECEN                                ((uint32_t)0x00800000U)         /* Bit[23] */
#define RCC_APB5EN1_M4AFECEN                                ((uint32_t)0x00400000U)         /* Bit[22] */
#define RCC_APB5EN1_M7AFECLPEN                              ((uint32_t)0x00200000U)         /* Bit[21] */
#define RCC_APB5EN1_M4AFECLPEN                              ((uint32_t)0x00100000U)         /* Bit[20] */
#define RCC_APB5EN1_M7SPI4EN                                ((uint32_t)0x00008000U)         /* Bit[15] */
#define RCC_APB5EN1_M4SPI4EN                                ((uint32_t)0x00004000U)         /* Bit[14] */
#define RCC_APB5EN1_M7SPI4LPEN                              ((uint32_t)0x00002000U)         /* Bit[13] */
#define RCC_APB5EN1_M4SPI4LPEN                              ((uint32_t)0x00001000U)         /* Bit[12] */
#define RCC_APB5EN1_M7SPI5EN                                ((uint32_t)0x00000800U)         /* Bit[11] */
#define RCC_APB5EN1_M4SPI5EN                                ((uint32_t)0x00000400U)         /* Bit[10] */
#define RCC_APB5EN1_M7SPI5LPEN                              ((uint32_t)0x00000200U)         /* Bit[9] */
#define RCC_APB5EN1_M4SPI5LPEN                              ((uint32_t)0x00000100U)         /* Bit[8] */
#define RCC_APB5EN1_M7SPI6EN                                ((uint32_t)0x00000080U)         /* Bit[7] */
#define RCC_APB5EN1_M4SPI6EN                                ((uint32_t)0x00000040U)         /* Bit[6] */
#define RCC_APB5EN1_M7SPI6LPEN                              ((uint32_t)0x00000020U)         /* Bit[5] */
#define RCC_APB5EN1_M4SPI6LPEN                              ((uint32_t)0x00000010U)         /* Bit[4] */
#define RCC_APB5EN1_M7SPI7EN                                ((uint32_t)0x00000008U)         /* Bit[3] */
#define RCC_APB5EN1_M4SPI7EN                                ((uint32_t)0x00000004U)         /* Bit[2] */
#define RCC_APB5EN1_M7SPI7LPEN                              ((uint32_t)0x00000002U)         /* Bit[1] */
#define RCC_APB5EN1_M4SPI7LPEN                              ((uint32_t)0x00000001U)         /* Bit[0] */

/******** Bit definition for RCC_APB5EN2 register  ********/
#define RCC_APB5EN2_M7I2C7EN                                ((uint32_t)0x80000000U)         /* Bit[31] */
#define RCC_APB5EN2_M4I2C7EN                                ((uint32_t)0x40000000U)         /* Bit[30] */
#define RCC_APB5EN2_M7I2C7LPEN                              ((uint32_t)0x20000000U)         /* Bit[29] */
#define RCC_APB5EN2_M4I2C7LPEN                              ((uint32_t)0x10000000U)         /* Bit[28] */
#define RCC_APB5EN2_M7I2C8EN                                ((uint32_t)0x08000000U)         /* Bit[27] */
#define RCC_APB5EN2_M4I2C8EN                                ((uint32_t)0x04000000U)         /* Bit[26] */
#define RCC_APB5EN2_M7I2C8LPEN                              ((uint32_t)0x02000000U)         /* Bit[25] */
#define RCC_APB5EN2_M4I2C8LPEN                              ((uint32_t)0x01000000U)         /* Bit[24] */
#define RCC_APB5EN2_M7I2C9EN                                ((uint32_t)0x00800000U)         /* Bit[23] */
#define RCC_APB5EN2_M4I2C9EN                                ((uint32_t)0x00400000U)         /* Bit[22] */
#define RCC_APB5EN2_M7I2C9LPEN                              ((uint32_t)0x00200000U)         /* Bit[21] */
#define RCC_APB5EN2_M4I2C9LPEN                              ((uint32_t)0x00100000U)         /* Bit[20] */
#define RCC_APB5EN2_M7I2C10EN                               ((uint32_t)0x00080000U)         /* Bit[19] */
#define RCC_APB5EN2_M4I2C10EN                               ((uint32_t)0x00040000U)         /* Bit[18] */
#define RCC_APB5EN2_M7I2C10LPEN                             ((uint32_t)0x00020000U)         /* Bit[17] */
#define RCC_APB5EN2_M4I2C10LPEN                             ((uint32_t)0x00010000U)         /* Bit[16] */
#define RCC_APB5EN2_EXTIEN                                  ((uint32_t)0x00008000U)         /* Bit[15] */
#define RCC_APB5EN2_EXTILPEN                                ((uint32_t)0x00002000U)         /* Bit[13] */
#define RCC_APB5EN2_M7RTCPCLKEN                             ((uint32_t)0x00000800U)         /* Bit[11] */
#define RCC_APB5EN2_M4RTCPCLKEN                             ((uint32_t)0x00000400U)         /* Bit[10] */
#define RCC_APB5EN2_M7RTCPCLKLPEN                           ((uint32_t)0x00000200U)         /* Bit[9] */
#define RCC_APB5EN2_M4RTCPCLKLPEN                           ((uint32_t)0x00000100U)         /* Bit[8] */
#define RCC_APB5EN2_IWDG1PCLKEN                             ((uint32_t)0x00000080U)         /* Bit[7] */
#define RCC_APB5EN2_IWDG1PCLKLPEN                           ((uint32_t)0x00000020U)         /* Bit[5] */
#define RCC_APB5EN2_IWDG2PCLKEN                             ((uint32_t)0x00000008U)         /* Bit[3] */
#define RCC_APB5EN2_IWDG2PCLKLPEN                           ((uint32_t)0x00000002U)         /* Bit[1] */

/******** Bit definition for RCC_APB5RST1 register  ********/
#define RCC_APB5RST1_ATIM3RST                                ((uint32_t)0x10000000U)         /* Bit[28] */
#define RCC_APB5RST1_ATIM4RST                                ((uint32_t)0x01000000U)         /* Bit[24] */
#define RCC_APB5RST1_AFECRST                                 ((uint32_t)0x00100000U)
#define RCC_APB5RST1_SPI4RST                                 ((uint32_t)0x00001000U)         /* Bit[12] */
#define RCC_APB5RST1_SPI5RST                                 ((uint32_t)0x00000100U)         /* Bit[8] */
#define RCC_APB5RST1_SPI6RST                                 ((uint32_t)0x00000010U)         /* Bit[4] */
#define RCC_APB5RST1_SPI7RST                                 ((uint32_t)0x00000001U)         /* Bit[0] */

/******** Bit definition for RCC_APB5RST2 register  ********/
#define RCC_APB5RST2_I2C7RST                                 ((uint32_t)0x10000000U)         /* Bit[28] */
#define RCC_APB5RST2_I2C8RST                                 ((uint32_t)0x01000000U)         /* Bit[24] */
#define RCC_APB5RST2_I2C9RST                                 ((uint32_t)0x00100000U)         /* Bit[20] */
#define RCC_APB5RST2_I2C10RST                                ((uint32_t)0x00010000U)         /* Bit[16] */

/******** Bit definition for RCC_AHB9DIV1 register  ********/
#define RCC_AHB9DIV1_ESCSYSDIV                         ((uint32_t)0x0000000FU)         /* Bit */
#define RCC_AHB9DIV1_ESCSYSDIV_0                       ((uint32_t)0x00000001U)         /* Bit0*/
#define RCC_AHB9DIV1_ESCSYSDIV_1                       ((uint32_t)0x00000002U)         /* Bit1*/
#define RCC_AHB9DIV1_ESCSYSDIV_2                       ((uint32_t)0x00000004U)         /* Bit2*/
#define RCC_AHB9DIV1_ESCSYSDIV_3                       ((uint32_t)0x00000008U)         /* Bit3*/

#define RCC_AHB9DIV1_ESCSYSDIV_DIV1                   ((uint32_t)0x00000000U)
#define RCC_AHB9DIV1_ESCSYSDIV_DIV2                   ((uint32_t)0x00000001U)
#define RCC_AHB9DIV1_ESCSYSDIV_DIV4                   ((uint32_t)0x00000002U)
#define RCC_AHB9DIV1_ESCSYSDIV_DIV8                   ((uint32_t)0x00000004U)
#define RCC_AHB9DIV1_ESCSYSDIV_DIV16                  ((uint32_t)0x00000007U)
#define RCC_AHB9DIV1_ESCSYSDIV_DIV32                  ((uint32_t)0x00000008U)
#define RCC_AHB9DIV1_ESCSYSDIV_DIV64                  ((uint32_t)0x00000009U)
#define RCC_AHB9DIV1_ESCSYSDIV_DIV128                 ((uint32_t)0x0000000AU)
#define RCC_AHB9DIV1_ESCSYSDIV_DIV256                 ((uint32_t)0x0000000BU)
#define RCC_AHB9DIV1_ESCSYSDIV_DIV512                 ((uint32_t)0x0000000CU)
/******** Bit definition for RCC_AHB9SEL1 register  ********/
#define RCC_AHB9SEL1_ESCKERSEL                         ((uint32_t)0x00000007U)         /* Bit */
#define RCC_AHB9SEL1_ESCKERSEL_0                       ((uint32_t)0x00000001U)         /* Bit0*/
#define RCC_AHB9SEL1_ESCKERSEL_1                       ((uint32_t)0x00000002U)         /* Bit1*/
#define RCC_AHB9SEL1_ESCKERSEL_2                       ((uint32_t)0x00000004U)         /* Bit2*/

#define RCC_AHB9SEL1_ESCKERSEL_SYSDIV                  ((uint32_t)0x00000000U)
#define RCC_AHB9SEL1_ESCKERSEL_PLL2B                   ((uint32_t)0x00000001U)
#define RCC_AHB9SEL1_ESCKERSEL_PLL3A                   ((uint32_t)0x00000002U)
#define RCC_AHB9SEL1_ESCKERSEL_PLL3C                   ((uint32_t)0x00000003U)
#define RCC_AHB9SEL1_ESCKERSEL_PLL1B                   ((uint32_t)0x00000004U)
/******** Bit definition for RCC_AHB9EN1 register  ********/
#define RCC_AHB9EN1_M7ESCEN                                ((uint32_t)0x00000008U)         /* Bit[3] */
#define RCC_AHB9EN1_M4ESCEN                                ((uint32_t)0x00000004U)         /* Bit[2] */
#define RCC_AHB9EN1_M7ESCLPEN                              ((uint32_t)0x00000002U)         /* Bit[1] */
#define RCC_AHB9EN1_M4ESCLPEN                              ((uint32_t)0x00000001U)         /* Bit[0] */

/******** Bit definition for RCC_AHB9RST1 register  ********/
#define RCC_AHB9RST1_ESCRST                                 ((uint32_t)0x00000001U)         /* Bit[0] */

/******** Bit definition for RCC_RDDIV1 register  ********/
#define RCC_RDDIV1_COMPDIV                            ((uint32_t)0x70000000U)         /* Bit[30:28] */
#define RCC_RDDIV1_COMPDIV_0                          ((uint32_t)0x10000000U)         /* Bit28*/
#define RCC_RDDIV1_COMPDIV_1                          ((uint32_t)0x20000000U)         /* Bit29*/
#define RCC_RDDIV1_COMPDIV_2                          ((uint32_t)0x40000000U)         /* Bit30*/

#define RCC_RDDIV1_COMPDIV_DIV1                       ((uint32_t)0x00000000U)
#define RCC_RDDIV1_COMPDIV_DIV2                       ((uint32_t)0x40000000U)
#define RCC_RDDIV1_COMPDIV_DIV4                       ((uint32_t)0x50000000U)
#define RCC_RDDIV1_COMPDIV_DIV8                       ((uint32_t)0x60000000U)
#define RCC_RDDIV1_COMPDIV_DIV16                      ((uint32_t)0x70000000U)

#define RCC_RDDIV1_LPUARTDIV                          ((uint32_t)0x07000000U)         /* Bit[26:24] */
#define RCC_RDDIV1_LPUARTDIV_0                        ((uint32_t)0x01000000U)         /* Bit24*/
#define RCC_RDDIV1_LPUARTDIV_1                        ((uint32_t)0x02000000U)         /* Bit25*/
#define RCC_RDDIV1_LPUARTDIV_2                        ((uint32_t)0x04000000U)         /* Bit26*/

#define RCC_RDDIV1_LPUARTDIV_DIV1                     ((uint32_t)0x00000000U)
#define RCC_RDDIV1_LPUARTDIV_DIV2                     ((uint32_t)0x04000000U)
#define RCC_RDDIV1_LPUARTDIV_DIV4                     ((uint32_t)0x05000000U)
#define RCC_RDDIV1_LPUARTDIV_DIV8                     ((uint32_t)0x06000000U)
#define RCC_RDDIV1_LPUARTDIV_DIV16                    ((uint32_t)0x07000000U)
/******** Bit definition for RCC_RDSEL1 register  ********/
#define RCC_RDSEL1_LPTIM1SEL                          ((uint32_t)0xF0000000U)         /* Bit[31:28] */
#define RCC_RDSEL1_LPTIM1SEL_0                        ((uint32_t)0x10000000U)         /* Bit28*/
#define RCC_RDSEL1_LPTIM1SEL_1                        ((uint32_t)0x20000000U)         /* Bit29*/
#define RCC_RDSEL1_LPTIM1SEL_2                        ((uint32_t)0x40000000U)         /* Bit30*/
#define RCC_RDSEL1_LPTIM1SEL_3                        ((uint32_t)0x80000000U)         /* Bit31*/

#define RCC_RDSEL1_LPTIM1SEL_APB5                                 ((uint32_t)0x00000000)
#define RCC_RDSEL1_LPTIM1SEL_LSI                                  ((uint32_t)0x10000000)
#define RCC_RDSEL1_LPTIM1SEL_LSE                                  ((uint32_t)0x20000000)
#define RCC_RDSEL1_LPTIM1SEL_HSE                                  ((uint32_t)0x30000000)
#define RCC_RDSEL1_LPTIM1SEL_HSI                                  ((uint32_t)0x40000000)
#define RCC_RDSEL1_LPTIM1SEL_MSI                                  ((uint32_t)0x50000000)
#define RCC_RDSEL1_LPTIM1SEL_COMP1                                ((uint32_t)0x80000000)
#define RCC_RDSEL1_LPTIM1SEL_COMP2                                ((uint32_t)0x90000000)
#define RCC_RDSEL1_LPTIM1SEL_COMP3                                ((uint32_t)0xA0000000)
#define RCC_RDSEL1_LPTIM1SEL_COMP4                                ((uint32_t)0xB0000000)

#define RCC_RDSEL1_LPTIM2SEL                          ((uint32_t)0x0F000000U)         /* Bit[27:24] */
#define RCC_RDSEL1_LPTIM2SEL_0                        ((uint32_t)0x01000000U)         /* Bit24*/
#define RCC_RDSEL1_LPTIM2SEL_1                        ((uint32_t)0x02000000U)         /* Bit25*/
#define RCC_RDSEL1_LPTIM2SEL_2                        ((uint32_t)0x04000000U)         /* Bit26*/
#define RCC_RDSEL1_LPTIM2SEL_3                        ((uint32_t)0x08000000U)         /* Bit27*/
#define RCC_RDSEL1_LPTIM3SEL                          ((uint32_t)0x00F00000U)         /* Bit[23:20] */
#define RCC_RDSEL1_LPTIM3SEL_0                        ((uint32_t)0x00100000U)         /* Bit20*/
#define RCC_RDSEL1_LPTIM3SEL_1                        ((uint32_t)0x00200000U)         /* Bit21*/
#define RCC_RDSEL1_LPTIM3SEL_2                        ((uint32_t)0x00400000U)         /* Bit22*/
#define RCC_RDSEL1_LPTIM3SEL_3                        ((uint32_t)0x00800000U)         /* Bit23*/
#define RCC_RDSEL1_LPTIM4SEL                          ((uint32_t)0x000F0000U)         /* Bit[19:16] */
#define RCC_RDSEL1_LPTIM4SEL_0                        ((uint32_t)0x00010000U)         /* Bit16*/
#define RCC_RDSEL1_LPTIM4SEL_1                        ((uint32_t)0x00020000U)         /* Bit17*/
#define RCC_RDSEL1_LPTIM4SEL_2                        ((uint32_t)0x00040000U)         /* Bit18*/
#define RCC_RDSEL1_LPTIM4SEL_3                        ((uint32_t)0x00080000U)         /* Bit19*/
#define RCC_RDSEL1_LPTIM5SEL                          ((uint32_t)0x0000F000U)         /* Bit[15:12] */
#define RCC_RDSEL1_LPTIM5SEL_0                        ((uint32_t)0x00001000U)         /* Bit12*/
#define RCC_RDSEL1_LPTIM5SEL_1                        ((uint32_t)0x00002000U)         /* Bit13*/
#define RCC_RDSEL1_LPTIM5SEL_2                        ((uint32_t)0x00004000U)         /* Bit14*/
#define RCC_RDSEL1_LPTIM5SEL_3                        ((uint32_t)0x00008000U)         /* Bit15*/

#define RCC_RDSEL1_LPUART1SEL                         ((uint32_t)0x00000700U)         /* Bit[10:8] */
#define RCC_RDSEL1_LPUART1SEL_0                       ((uint32_t)0x00000100U)         /* Bit8*/
#define RCC_RDSEL1_LPUART1SEL_1                       ((uint32_t)0x00000200U)         /* Bit9*/
#define RCC_RDSEL1_LPUART1SEL_2                       ((uint32_t)0x00000400U)         /* Bit10*/

#define RCC_RDSEL1_LPUART1SEL_SYSDIV                  ((uint32_t)0x00000000U)
#define RCC_RDSEL1_LPUART1SEL_HSI                     ((uint32_t)0x00000100U)
#define RCC_RDSEL1_LPUART1SEL_LSE                     ((uint32_t)0x00000200U)
#define RCC_RDSEL1_LPUART1SEL_HSE                     ((uint32_t)0x00000300U)
#define RCC_RDSEL1_LPUART1SEL_MSI                     ((uint32_t)0x00000400U)

#define RCC_RDSEL1_LPUART2SEL                         ((uint32_t)0x00000070U)         /* Bit[6:4] */
#define RCC_RDSEL1_LPUART2SEL_0                       ((uint32_t)0x00000010U)         /* Bit4*/
#define RCC_RDSEL1_LPUART2SEL_1                       ((uint32_t)0x00000020U)         /* Bit5*/
#define RCC_RDSEL1_LPUART2SEL_2                       ((uint32_t)0x00000040U)         /* Bit6*/

#define RCC_RDSEL1_COMPSEL                                 ((uint32_t)0x00000001U)         /* Bit[0] */

/******** Bit definition for RCC_RDCTRL1 register  ********/
#define RCC_RDCTRL1_LPTIM2FLTEN                             ((uint32_t)0x20000000U)         /* Bit[29] */
#define RCC_RDCTRL1_LPTIM2FLTSEL                            ((uint32_t)0x10000000U)         /* Bit[28] */
#define RCC_RDCTRL1_LPTIM2COMP4EN                           ((uint32_t)0x08000000U)         /* Bit[27] */
#define RCC_RDCTRL1_LPTIM2COMP3EN                           ((uint32_t)0x04000000U)         /* Bit[26] */
#define RCC_RDCTRL1_LPTIM2COMP2EN                           ((uint32_t)0x02000000U)         /* Bit[25] */
#define RCC_RDCTRL1_LPTIM2COMP1EN                           ((uint32_t)0x01000000U)         /* Bit[24] */
#define RCC_RDCTRL1_LPTIM2FLTDFC                       ((uint32_t)0x001F0000U)         /* Bit[20:16] */
#define RCC_RDCTRL1_LPTIM2FLTDFC_0                     ((uint32_t)0x00010000U)         /* Bit16*/
#define RCC_RDCTRL1_LPTIM2FLTDFC_1                     ((uint32_t)0x00020000U)         /* Bit17*/
#define RCC_RDCTRL1_LPTIM2FLTDFC_2                     ((uint32_t)0x00040000U)         /* Bit18*/
#define RCC_RDCTRL1_LPTIM2FLTDFC_3                     ((uint32_t)0x00080000U)         /* Bit19*/
#define RCC_RDCTRL1_LPTIM2FLTDFC_4                     ((uint32_t)0x00100000U)         /* Bit20*/
#define RCC_RDCTRL1_LPTIM1FLTEN                             ((uint32_t)0x00002000U)         /* Bit[13] */
#define RCC_RDCTRL1_LPTIM1FLTSEL                            ((uint32_t)0x00001000U)         /* Bit[12] */
#define RCC_RDCTRL1_LPTIM1COMP4EN                           ((uint32_t)0x00000800U)         /* Bit[11] */
#define RCC_RDCTRL1_LPTIM1COMP3EN                           ((uint32_t)0x00000400U)         /* Bit[10] */
#define RCC_RDCTRL1_LPTIM1COMP2EN                           ((uint32_t)0x00000200U)         /* Bit[9] */
#define RCC_RDCTRL1_LPTIM1COMP1EN                           ((uint32_t)0x00000100U)         /* Bit[8] */
#define RCC_RDCTRL1_LPTIM1FLTDFC                       ((uint32_t)0x0000001FU)         /* Bit */
#define RCC_RDCTRL1_LPTIM1FLTDFC_0                     ((uint32_t)0x00000001U)         /* Bit0*/
#define RCC_RDCTRL1_LPTIM1FLTDFC_1                     ((uint32_t)0x00000002U)         /* Bit1*/
#define RCC_RDCTRL1_LPTIM1FLTDFC_2                     ((uint32_t)0x00000004U)         /* Bit2*/
#define RCC_RDCTRL1_LPTIM1FLTDFC_3                     ((uint32_t)0x00000008U)         /* Bit3*/
#define RCC_RDCTRL1_LPTIM1FLTDFC_4                     ((uint32_t)0x00000010U)         /* Bit4*/

/******** Bit definition for RCC_RDCTRL2 register  ********/
#define RCC_RDCTRL2_LPTIM4FLTEN                             ((uint32_t)0x20000000U)         /* Bit[29] */
#define RCC_RDCTRL2_LPTIM4FLTSEL                            ((uint32_t)0x10000000U)         /* Bit[28] */
#define RCC_RDCTRL2_LPTIM4COMP4EN                           ((uint32_t)0x08000000U)         /* Bit[27] */
#define RCC_RDCTRL2_LPTIM4COMP3EN                           ((uint32_t)0x04000000U)         /* Bit[26] */
#define RCC_RDCTRL2_LPTIM4COMP2EN                           ((uint32_t)0x02000000U)         /* Bit[25] */
#define RCC_RDCTRL2_LPTIM4COMP1EN                           ((uint32_t)0x01000000U)         /* Bit[24] */
#define RCC_RDCTRL2_LPTIM4FLTDFC                       ((uint32_t)0x001F0000U)         /* Bit[20:16] */
#define RCC_RDCTRL2_LPTIM4FLTDFC_0                     ((uint32_t)0x00010000U)         /* Bit16*/
#define RCC_RDCTRL2_LPTIM4FLTDFC_1                     ((uint32_t)0x00020000U)         /* Bit17*/
#define RCC_RDCTRL2_LPTIM4FLTDFC_2                     ((uint32_t)0x00040000U)         /* Bit18*/
#define RCC_RDCTRL2_LPTIM4FLTDFC_3                     ((uint32_t)0x00080000U)         /* Bit19*/
#define RCC_RDCTRL2_LPTIM4FLTDFC_4                     ((uint32_t)0x00100000U)         /* Bit20*/
#define RCC_RDCTRL2_LPTIM3FLTEN                             ((uint32_t)0x00002000U)         /* Bit[13] */
#define RCC_RDCTRL2_LPTIM3FLTSEL                            ((uint32_t)0x00001000U)         /* Bit[12] */
#define RCC_RDCTRL2_LPTIM3COMP4EN                           ((uint32_t)0x00000800U)         /* Bit[11] */
#define RCC_RDCTRL2_LPTIM3COMP3EN                           ((uint32_t)0x00000400U)         /* Bit[10] */
#define RCC_RDCTRL2_LPTIM3COMP2EN                           ((uint32_t)0x00000200U)         /* Bit[9] */
#define RCC_RDCTRL2_LPTIM3COMP1EN                           ((uint32_t)0x00000100U)         /* Bit[8] */
#define RCC_RDCTRL2_LPTIM3FLTDFC                       ((uint32_t)0x0000001FU)         /* Bit */
#define RCC_RDCTRL2_LPTIM3FLTDFC_0                     ((uint32_t)0x00000001U)         /* Bit0*/
#define RCC_RDCTRL2_LPTIM3FLTDFC_1                     ((uint32_t)0x00000002U)         /* Bit1*/
#define RCC_RDCTRL2_LPTIM3FLTDFC_2                     ((uint32_t)0x00000004U)         /* Bit2*/
#define RCC_RDCTRL2_LPTIM3FLTDFC_3                     ((uint32_t)0x00000008U)         /* Bit3*/
#define RCC_RDCTRL2_LPTIM3FLTDFC_4                     ((uint32_t)0x00000010U)         /* Bit4*/

/******** Bit definition for RCC_RDCTRL3 register  ********/
#define RCC_RDCTRL3_LPTIM5FLTEN                             ((uint32_t)0x00002000U)         /* Bit[13] */
#define RCC_RDCTRL3_LPTIM5FLTSEL                            ((uint32_t)0x00001000U)         /* Bit[12] */
#define RCC_RDCTRL3_LPTIM5COMP4EN                           ((uint32_t)0x00000800U)         /* Bit[11] */
#define RCC_RDCTRL3_LPTIM5COMP3EN                           ((uint32_t)0x00000400U)         /* Bit[10] */
#define RCC_RDCTRL3_LPTIM5COMP2EN                           ((uint32_t)0x00000200U)         /* Bit[9] */
#define RCC_RDCTRL3_LPTIM5COMP1EN                           ((uint32_t)0x00000100U)         /* Bit[8] */
#define RCC_RDCTRL3_LPTIM5FLTDFC                       ((uint32_t)0x0000001FU)         /* Bit */
#define RCC_RDCTRL3_LPTIM5FLTDFC_0                     ((uint32_t)0x00000001U)         /* Bit0*/
#define RCC_RDCTRL3_LPTIM5FLTDFC_1                     ((uint32_t)0x00000002U)         /* Bit1*/
#define RCC_RDCTRL3_LPTIM5FLTDFC_2                     ((uint32_t)0x00000004U)         /* Bit2*/
#define RCC_RDCTRL3_LPTIM5FLTDFC_3                     ((uint32_t)0x00000008U)         /* Bit3*/
#define RCC_RDCTRL3_LPTIM5FLTDFC_4                     ((uint32_t)0x00000010U)         /* Bit4*/

/******** Bit definition for RCC_RDEN1 register  ********/
#define RCC_RDEN1_M7LPTIM1EN                              ((uint32_t)0x80000000U)         /* Bit[31] */
#define RCC_RDEN1_M4LPTIM1EN                              ((uint32_t)0x40000000U)         /* Bit[30] */
#define RCC_RDEN1_M7LPTIM1LPEN                            ((uint32_t)0x20000000U)         /* Bit[29] */
#define RCC_RDEN1_M4LPTIM1LPEN                            ((uint32_t)0x10000000U)         /* Bit[28] */
#define RCC_RDEN1_M7LPTIM2EN                              ((uint32_t)0x08000000U)         /* Bit[27] */
#define RCC_RDEN1_M4LPTIM2EN                              ((uint32_t)0x04000000U)         /* Bit[26] */
#define RCC_RDEN1_M7LPTIM2LPEN                            ((uint32_t)0x02000000U)         /* Bit[25] */
#define RCC_RDEN1_M4LPTIM2LPEN                            ((uint32_t)0x01000000U)         /* Bit[24] */
#define RCC_RDEN1_M7LPTIM3EN                              ((uint32_t)0x00800000U)         /* Bit[23] */
#define RCC_RDEN1_M4LPTIM3EN                              ((uint32_t)0x00400000U)         /* Bit[22] */
#define RCC_RDEN1_M7LPTIM3LPEN                            ((uint32_t)0x00200000U)         /* Bit[21] */
#define RCC_RDEN1_M4LPTIM3LPEN                            ((uint32_t)0x00100000U)         /* Bit[20] */
#define RCC_RDEN1_M7LPTIM4EN                              ((uint32_t)0x00080000U)         /* Bit[19] */
#define RCC_RDEN1_M4LPTIM4EN                              ((uint32_t)0x00040000U)         /* Bit[18] */
#define RCC_RDEN1_M7LPTIM4LPEN                            ((uint32_t)0x00020000U)         /* Bit[17] */
#define RCC_RDEN1_M4LPTIM4LPEN                            ((uint32_t)0x00010000U)         /* Bit[16] */
#define RCC_RDEN1_M7LPTIM5EN                              ((uint32_t)0x00008000U)         /* Bit[15] */
#define RCC_RDEN1_M4LPTIM5EN                              ((uint32_t)0x00004000U)         /* Bit[14] */
#define RCC_RDEN1_M7LPTIM5LPEN                            ((uint32_t)0x00002000U)         /* Bit[13] */
#define RCC_RDEN1_M4LPTIM5LPEN                            ((uint32_t)0x00001000U)         /* Bit[12] */
#define RCC_RDEN1_M7LPUART1EN                             ((uint32_t)0x00000800U)         /* Bit[11] */
#define RCC_RDEN1_M4LPUART1EN                             ((uint32_t)0x00000400U)         /* Bit[10] */
#define RCC_RDEN1_M7LPUART1LPEN                           ((uint32_t)0x00000200U)         /* Bit[9] */
#define RCC_RDEN1_M4LPUART1LPEN                           ((uint32_t)0x00000100U)         /* Bit[8] */
#define RCC_RDEN1_M7LPUART2EN                             ((uint32_t)0x00000080U)         /* Bit[7] */
#define RCC_RDEN1_M4LPUART2EN                             ((uint32_t)0x00000040U)         /* Bit[6] */
#define RCC_RDEN1_M7LPUART2LPEN                           ((uint32_t)0x00000020U)         /* Bit[5] */
#define RCC_RDEN1_M4LPUART2LPEN                           ((uint32_t)0x00000010U)         /* Bit[4] */

/******** Bit definition for RCC_RDEN2 register  ********/
#define RCC_RDEN2_M7COMPEN                                ((uint32_t)0x80000000U)         /* Bit[31] */
#define RCC_RDEN2_M4COMPEN                                ((uint32_t)0x40000000U)         /* Bit[30] */
#define RCC_RDEN2_M7COMPLPEN                              ((uint32_t)0x20000000U)         /* Bit[29] */
#define RCC_RDEN2_M4COMPLPEN                              ((uint32_t)0x10000000U)         /* Bit[28] */

/******** Bit definition for RCC_RDRST1 register  ********/
#define RCC_RDRST1_LPTIM1RST                               ((uint32_t)0x10000000U)         /* Bit[28] */
#define RCC_RDRST1_LPTIM2RST                               ((uint32_t)0x01000000U)         /* Bit[24] */
#define RCC_RDRST1_LPTIM3RST                               ((uint32_t)0x00100000U)         /* Bit[20] */
#define RCC_RDRST1_LPTIM4RST                               ((uint32_t)0x00010000U)         /* Bit[16] */
#define RCC_RDRST1_LPTIM5RST                               ((uint32_t)0x00001000U)         /* Bit[12] */
#define RCC_RDRST1_LPUART1RST                              ((uint32_t)0x00000100U)         /* Bit[8] */
#define RCC_RDRST1_LPUART2RST                              ((uint32_t)0x00000010U)         /* Bit[4] */

/******** Bit definition for RCC_RDRST2 register  ********/
#define RCC_RDRST2_COMPRST                                 ((uint32_t)0x10000000U)         /* Bit[28] */

/******** Bit definition for RCC_BDCTRL register  ********/
#define RCC_BDCTRL_AFELSERDF                               ((uint32_t)0x80000000U)         /* Bit[31] */
#define RCC_BDCTRL_AFELSIRDF                               ((uint32_t)0x40000000U)         /* Bit[30] */
#define RCC_BDCTRL_LSELDOEN                                ((uint32_t)0x10000000U)         /* Bit[28] */
#define RCC_BDCTRL_LSIOVREN                                ((uint32_t)0x08000000U)         /* Bit[27] */
#define RCC_BDCTRL_LSIPFACK                                ((uint32_t)0x04000000U)         /* Bit[26] */
#define RCC_BDCTRL_LSIPFF                                  ((uint32_t)0x02000000U)         /* Bit[25] */
#define RCC_BDCTRL_LSICSSEN                                ((uint32_t)0x01000000U)         /* Bit[24] */
#define RCC_BDCTRL_LSERDCNTEN                              ((uint32_t)0x00400000U)         /* Bit[22] */
#define RCC_BDCTRL_RTCLSFSW                                ((uint32_t)0x00200000U)         /* Bit[21] */
#define RCC_BDCTRL_RTCHSFSW                                ((uint32_t)0x00100000U)         /* Bit[20] */
#define RCC_BDCTRL_LSISECRDF                               ((uint32_t)0x00080000U)         /* Bit[19] */

#define RCC_BDCTRL_RTCEN                                   ((uint32_t)0x00040000U)         /* Bit[18] */

#define RCC_BDCTRL_RTCSEL                             ((uint32_t)0x00030000U)         /* Bit[17:16] */
#define RCC_BDCTRL_RTCSEL_0                           ((uint32_t)0x00010000U)         /* Bit16*/
#define RCC_BDCTRL_RTCSEL_1                           ((uint32_t)0x00020000U)         /* Bit17*/

#define RCC_BDCTRL_RTCSEL_LSE                           ((uint32_t)0x00010000U)  
#define RCC_BDCTRL_RTCSEL_LSI                           ((uint32_t)0x00020000U)  
#define RCC_BDCTRL_RTCSEL_HSEDIV                           ((uint32_t)0x00030000U)  

#define RCC_BDCTRL_BORRSTEN                                ((uint32_t)0x00008000U)         /* Bit[15] */
#define RCC_BDCTRL_C1LPRSTEN                               ((uint32_t)0x00004000U)         /* Bit[14] */
#define RCC_BDCTRL_C2LPRSTEN                               ((uint32_t)0x00002000U)         /* Bit[13] */
#define RCC_BDCTRL_BDRST                                   ((uint32_t)0x00001000U)         /* Bit[12] */
#define RCC_BDCTRL_BKPEMCRSTEN                             ((uint32_t)0x00000800U)         /* Bit[11] */
#define RCC_BDCTRL_RETEMCRSTEN                             ((uint32_t)0x00000400U)         /* Bit[10] */
#define RCC_BDCTRL_LSECSSF                                 ((uint32_t)0x00000200U)         /* Bit[9] */
#define RCC_BDCTRL_LSECSSEN                                ((uint32_t)0x00000100U)         /* Bit[8] */
#define RCC_BDCTRL_LSERDEN                                 ((uint32_t)0x00000080U)         /* Bit[7] */
#define RCC_BDCTRL_LSEBP                                   ((uint32_t)0x00000040U)         /* Bit[6] */
#define RCC_BDCTRL_LSERDF                                  ((uint32_t)0x00000020U)         /* Bit[5] */
#define RCC_BDCTRL_LSEEN                                   ((uint32_t)0x00000010U)         /* Bit[4] */
#define RCC_BDCTRL_LSIRDEN                                 ((uint32_t)0x00000008U)         /* Bit[3] */
#define RCC_BDCTRL_LSISECEN                                ((uint32_t)0x00000004U)         /* Bit[2] */
#define RCC_BDCTRL_LSIRDF                                  ((uint32_t)0x00000002U)         /* Bit[1] */
#define RCC_BDCTRL_LSIEN                                   ((uint32_t)0x00000001U)         /* Bit[0] */

/******** Bit definition for RCC_LSICSSDL register  ********/
#define RCC_LSICSSDL_DELAY                             ((uint32_t)0xFFFFFFFFU)         /* Bit */
#define RCC_LSICSSDL_DELAY_0                           ((uint32_t)0x00000001U)         /* Bit0*/
#define RCC_LSICSSDL_DELAY_1                           ((uint32_t)0x00000002U)         /* Bit1*/
#define RCC_LSICSSDL_DELAY_2                           ((uint32_t)0x00000004U)         /* Bit2*/
#define RCC_LSICSSDL_DELAY_3                           ((uint32_t)0x00000008U)         /* Bit3*/
#define RCC_LSICSSDL_DELAY_4                           ((uint32_t)0x00000010U)         /* Bit4*/
#define RCC_LSICSSDL_DELAY_5                           ((uint32_t)0x00000020U)         /* Bit5*/
#define RCC_LSICSSDL_DELAY_6                           ((uint32_t)0x00000040U)         /* Bit6*/
#define RCC_LSICSSDL_DELAY_7                           ((uint32_t)0x00000080U)         /* Bit7*/
#define RCC_LSICSSDL_DELAY_8                           ((uint32_t)0x00000100U)         /* Bit8*/
#define RCC_LSICSSDL_DELAY_9                           ((uint32_t)0x00000200U)         /* Bit9*/
#define RCC_LSICSSDL_DELAY_10                          ((uint32_t)0x00000400U)         /* Bit10*/
#define RCC_LSICSSDL_DELAY_11                          ((uint32_t)0x00000800U)         /* Bit11*/
#define RCC_LSICSSDL_DELAY_12                          ((uint32_t)0x00001000U)         /* Bit12*/
#define RCC_LSICSSDL_DELAY_13                          ((uint32_t)0x00002000U)         /* Bit13*/
#define RCC_LSICSSDL_DELAY_14                          ((uint32_t)0x00004000U)         /* Bit14*/
#define RCC_LSICSSDL_DELAY_15                          ((uint32_t)0x00008000U)         /* Bit15*/
#define RCC_LSICSSDL_DELAY_16                          ((uint32_t)0x00010000U)         /* Bit16*/
#define RCC_LSICSSDL_DELAY_17                          ((uint32_t)0x00020000U)         /* Bit17*/
#define RCC_LSICSSDL_DELAY_18                          ((uint32_t)0x00040000U)         /* Bit18*/
#define RCC_LSICSSDL_DELAY_19                          ((uint32_t)0x00080000U)         /* Bit19*/
#define RCC_LSICSSDL_DELAY_20                          ((uint32_t)0x00100000U)         /* Bit20*/
#define RCC_LSICSSDL_DELAY_21                          ((uint32_t)0x00200000U)         /* Bit21*/
#define RCC_LSICSSDL_DELAY_22                          ((uint32_t)0x00400000U)         /* Bit22*/
#define RCC_LSICSSDL_DELAY_23                          ((uint32_t)0x00800000U)         /* Bit23*/
#define RCC_LSICSSDL_DELAY_24                          ((uint32_t)0x01000000U)         /* Bit24*/
#define RCC_LSICSSDL_DELAY_25                          ((uint32_t)0x02000000U)         /* Bit25*/
#define RCC_LSICSSDL_DELAY_26                          ((uint32_t)0x04000000U)         /* Bit26*/
#define RCC_LSICSSDL_DELAY_27                          ((uint32_t)0x08000000U)         /* Bit27*/
#define RCC_LSICSSDL_DELAY_28                          ((uint32_t)0x10000000U)         /* Bit28*/
#define RCC_LSICSSDL_DELAY_29                          ((uint32_t)0x20000000U)         /* Bit29*/
#define RCC_LSICSSDL_DELAY_30                          ((uint32_t)0x40000000U)         /* Bit30*/
#define RCC_LSICSSDL_DELAY_31                          ((uint32_t)0x80000000U)         /* Bit31*/

/******** Bit definition for RCC_CTRLSTS register  ********/
#define RCC_CTRLSTS_RMRSTF                                  ((uint32_t)0x80000000U)         /* Bit[31] */
#define RCC_CTRLSTS_C1LPRSTF                                ((uint32_t)0x00008000U)         /* Bit[15] */
#define RCC_CTRLSTS_C2LPRSTF                                ((uint32_t)0x00004000U)         /* Bit[14] */
#define RCC_CTRLSTS_RETEMCRSTF                              ((uint32_t)0x00002000U)         /* Bit[13] */
#define RCC_CTRLSTS_BKPEMCRSTF                              ((uint32_t)0x00001000U)         /* Bit[12] */
#define RCC_CTRLSTS_BORRSTF                                 ((uint32_t)0x00000800U)         /* Bit[11] */
#define RCC_CTRLSTS_MMURSTF                               ((uint32_t)0x00000200U)         /* Bit[9] */
#define RCC_CTRLSTS_WWDG1RSTF                               ((uint32_t)0x00000080U)         /* Bit[7] */
#define RCC_CTRLSTS_WWDG2RSTF                               ((uint32_t)0x00000040U)         /* Bit[6] */
#define RCC_CTRLSTS_IWDG1RSTF                               ((uint32_t)0x00000020U)         /* Bit[5] */
#define RCC_CTRLSTS_IWDG2RSTF                               ((uint32_t)0x00000010U)         /* Bit[4] */
#define RCC_CTRLSTS_CM4SFTRSTF                              ((uint32_t)0x00000008U)         /* Bit[3] */
#define RCC_CTRLSTS_CM7SFTRSTF                              ((uint32_t)0x00000004U)         /* Bit[2] */
#define RCC_CTRLSTS_PORRSTF                                 ((uint32_t)0x00000002U)         /* Bit[1] */
#define RCC_CTRLSTS_PINRSTF                                 ((uint32_t)0x00000001U)         /* Bit[0] */

/******** Bit definition for RCC_CLKINT1 register  ********/
#define RCC_CLKINT1_LSECSSIE                                ((uint32_t)0x40000000U)         /* Bit[30] */
#define RCC_CLKINT1_LSECSSIF                                ((uint32_t)0x20000000U)         /* Bit[29] */
#define RCC_CLKINT1_LSECSSIC                                ((uint32_t)0x10000000U)         /* Bit[28] */
#define RCC_CLKINT1_HSECSSIF                                ((uint32_t)0x02000000U)         /* Bit[25] */
#define RCC_CLKINT1_HSECSSIC                                ((uint32_t)0x01000000U)         /* Bit[24] */
#define RCC_CLKINT1_BORIE                                   ((uint32_t)0x00400000U)         /* Bit[22] */
#define RCC_CLKINT1_BORIF                                   ((uint32_t)0x00200000U)         /* Bit[21] */
#define RCC_CLKINT1_BORIC                                   ((uint32_t)0x00100000U)         /* Bit[20] */
#define RCC_CLKINT1_PLL1RDIE                                ((uint32_t)0x00040000U)         /* Bit[18] */
#define RCC_CLKINT1_PLL1RDIF                                ((uint32_t)0x00020000U)         /* Bit[17] */
#define RCC_CLKINT1_PLL1RDIC                                ((uint32_t)0x00010000U)         /* Bit[16] */
#define RCC_CLKINT1_PLL2RDIE                                ((uint32_t)0x00004000U)         /* Bit[14] */
#define RCC_CLKINT1_PLL2RDIF                                ((uint32_t)0x00002000U)         /* Bit[13] */
#define RCC_CLKINT1_PLL2RDIC                                ((uint32_t)0x00001000U)         /* Bit[12] */
#define RCC_CLKINT1_PLL3RDIE                                ((uint32_t)0x00000400U)         /* Bit[10] */
#define RCC_CLKINT1_PLL3RDIF                                ((uint32_t)0x00000200U)         /* Bit[9] */
#define RCC_CLKINT1_PLL3RDIC                                ((uint32_t)0x00000100U)         /* Bit[8] */
#define RCC_CLKINT1_SHRPLLRDIE                              ((uint32_t)0x00000040U)         /* Bit[6] */
#define RCC_CLKINT1_SHRPLLRDIF                              ((uint32_t)0x00000020U)         /* Bit[5] */
#define RCC_CLKINT1_SHRPLLRDIC                              ((uint32_t)0x00000010U)         /* Bit[4] */

/******** Bit definition for RCC_CLKINT2 register  ********/
#define RCC_CLKINT2_HSERDIE                                 ((uint32_t)0x40000000U)         /* Bit[30] */
#define RCC_CLKINT2_HSERDIF                                 ((uint32_t)0x20000000U)         /* Bit[29] */
#define RCC_CLKINT2_HSERDIC                                 ((uint32_t)0x10000000U)         /* Bit[28] */
#define RCC_CLKINT2_HSIRDIE                                 ((uint32_t)0x04000000U)         /* Bit[26] */
#define RCC_CLKINT2_HSIRDIF                                 ((uint32_t)0x02000000U)         /* Bit[25] */
#define RCC_CLKINT2_HSIRDIC                                 ((uint32_t)0x01000000U)         /* Bit[24] */
#define RCC_CLKINT2_MSIRDIE                                 ((uint32_t)0x00400000U)         /* Bit[22] */
#define RCC_CLKINT2_MSIRDIF                                 ((uint32_t)0x00200000U)         /* Bit[21] */
#define RCC_CLKINT2_MSIRDIC                                 ((uint32_t)0x00100000U)         /* Bit[20] */
#define RCC_CLKINT2_LSERDIE                                 ((uint32_t)0x00040000U)         /* Bit[18] */
#define RCC_CLKINT2_LSERDIF                                 ((uint32_t)0x00020000U)         /* Bit[17] */
#define RCC_CLKINT2_LSERDIC                                 ((uint32_t)0x00010000U)         /* Bit[16] */
#define RCC_CLKINT2_LSIRDIE                                 ((uint32_t)0x00004000U)         /* Bit[14] */
#define RCC_CLKINT2_LSIRDIF                                 ((uint32_t)0x00002000U)         /* Bit[13] */
#define RCC_CLKINT2_LSIRDIC                                 ((uint32_t)0x00001000U)         /* Bit[12] */
#define RCC_CLKINT2_HSICALEIE                               ((uint32_t)0x00000400U)         /* Bit[10] */
#define RCC_CLKINT2_HSICALEIF                               ((uint32_t)0x00000200U)         /* Bit[9] */
#define RCC_CLKINT2_HSICALEIC                               ((uint32_t)0x00000100U)         /* Bit[8] */
#define RCC_CLKINT2_MSICALEIE                               ((uint32_t)0x00000040U)         /* Bit[6] */
#define RCC_CLKINT2_MSICALEIF                               ((uint32_t)0x00000020U)         /* Bit[5] */
#define RCC_CLKINT2_MSICALEIC                               ((uint32_t)0x00000010U)         /* Bit[4] */

/******** Bit definition for RCC_CLKINT3 register  ********/
#define RCC_CLKINT3_PLL1LKFIE                               ((uint32_t)0x00040000U)         /* Bit[18] */
#define RCC_CLKINT3_PLL1LKFIF                               ((uint32_t)0x00020000U)         /* Bit[17] */
#define RCC_CLKINT3_PLL1LKFIC                               ((uint32_t)0x00010000U)         /* Bit[16] */
#define RCC_CLKINT3_PLL2LKFIE                               ((uint32_t)0x00004000U)         /* Bit[14] */
#define RCC_CLKINT3_PLL2LKFIF                               ((uint32_t)0x00002000U)         /* Bit[13] */
#define RCC_CLKINT3_PLL2LKFIC                               ((uint32_t)0x00001000U)         /* Bit[12] */
#define RCC_CLKINT3_PLL3LKFIE                               ((uint32_t)0x00000400U)         /* Bit[10] */
#define RCC_CLKINT3_PLL3LKFIF                               ((uint32_t)0x00000200U)         /* Bit[9] */
#define RCC_CLKINT3_PLL3LKFIC                               ((uint32_t)0x00000100U)         /* Bit[8] */
#define RCC_CLKINT3_SHRPLLLKFIE                             ((uint32_t)0x00000040U)         /* Bit[6] */
#define RCC_CLKINT3_SHRPLLLKFIF                             ((uint32_t)0x00000020U)         /* Bit[5] */
#define RCC_CLKINT3_SHRPLLLKFIC                             ((uint32_t)0x00000010U)         /* Bit[4] */
#define RCC_CLKINT3_LSIFIE                                  ((uint32_t)0x00000004U)         /* Bit[2] */
#define RCC_CLKINT3_LSIFIF                                  ((uint32_t)0x00000002U)         /* Bit[1] */
#define RCC_CLKINT3_LSIFIC                                  ((uint32_t)0x00000001U)         /* Bit[0] */

/******** Bit definition for RCC_CFG1 register  ********/
#define RCC_CFG1_WWDG2RSTDLCNT                      ((uint32_t)0x00F00000U)         /* Bit[23:20] */
#define RCC_CFG1_WWDG2RSTDLCNT_0                    ((uint32_t)0x00100000U)         /* Bit20*/
#define RCC_CFG1_WWDG2RSTDLCNT_1                    ((uint32_t)0x00200000U)         /* Bit21*/
#define RCC_CFG1_WWDG2RSTDLCNT_2                    ((uint32_t)0x00400000U)         /* Bit22*/
#define RCC_CFG1_WWDG2RSTDLCNT_3                    ((uint32_t)0x00800000U)         /* Bit23*/
#define RCC_CFG1_WWDG1RSTDLCNT                      ((uint32_t)0x000F0000U)         /* Bit[19:16] */
#define RCC_CFG1_WWDG1RSTDLCNT_0                    ((uint32_t)0x00010000U)         /* Bit16*/
#define RCC_CFG1_WWDG1RSTDLCNT_1                    ((uint32_t)0x00020000U)         /* Bit17*/
#define RCC_CFG1_WWDG1RSTDLCNT_2                    ((uint32_t)0x00040000U)         /* Bit18*/
#define RCC_CFG1_WWDG1RSTDLCNT_3                    ((uint32_t)0x00080000U)         /* Bit19*/
#define RCC_CFG1_WWDG2RSTEN                              ((uint32_t)0x00000200U)         /* Bit[9] */
#define RCC_CFG1_WWDG1RSTEN                              ((uint32_t)0x00000100U)         /* Bit[8] */
#define RCC_CFG1_M7TRACEDIV                         ((uint32_t)0x000000F0U)         /* Bit[7:4] */
#define RCC_CFG1_M7TRACEDIV_0                       ((uint32_t)0x00000010U)         /* Bit4*/
#define RCC_CFG1_M7TRACEDIV_1                       ((uint32_t)0x00000020U)         /* Bit5*/
#define RCC_CFG1_M7TRACEDIV_2                       ((uint32_t)0x00000040U)         /* Bit6*/
#define RCC_CFG1_M7TRACEDIV_3                       ((uint32_t)0x00000080U)         /* Bit7*/

#define RCC_CFG1_M7TRACEDIV_DIV1                  ((uint32_t)0x00000000U)
#define RCC_CFG1_M7TRACEDIV_DIV2                  ((uint32_t)0x00000010U)
#define RCC_CFG1_M7TRACEDIV_DIV4                  ((uint32_t)0x00000020U)
#define RCC_CFG1_M7TRACEDIV_DIV8                  ((uint32_t)0x00000040U)
#define RCC_CFG1_M7TRACEDIV_DIV16                 ((uint32_t)0x00000070U)
#define RCC_CFG1_M7TRACEDIV_DIV32                 ((uint32_t)0x00000080U)
#define RCC_CFG1_M7TRACEDIV_DIV64                 ((uint32_t)0x00000090U)
#define RCC_CFG1_M7TRACEDIV_DIV128                ((uint32_t)0x000000A0U)
#define RCC_CFG1_M7TRACEDIV_DIV256                ((uint32_t)0x000000B0U)
#define RCC_CFG1_M7TRACEDIV_DIV512                ((uint32_t)0x000000C0U)

#define RCC_CFG1_M4TRACEDIV                         ((uint32_t)0x0000000FU)         /* Bit */
#define RCC_CFG1_M4TRACEDIV_0                       ((uint32_t)0x00000001U)         /* Bit0*/
#define RCC_CFG1_M4TRACEDIV_1                       ((uint32_t)0x00000002U)         /* Bit1*/
#define RCC_CFG1_M4TRACEDIV_2                       ((uint32_t)0x00000004U)         /* Bit2*/
#define RCC_CFG1_M4TRACEDIV_3                       ((uint32_t)0x00000008U)         /* Bit3*/

/******** Bit definition for RCC_AXIDIV1 register  ********/
#define RCC_AXIDIV1_JPEGAXIDIV                         ((uint32_t)0xF0000000U)         /* Bit[31:28] */
#define RCC_AXIDIV1_JPEGAXIDIV_0                       ((uint32_t)0x10000000U)         /* Bit28*/
#define RCC_AXIDIV1_JPEGAXIDIV_1                       ((uint32_t)0x20000000U)         /* Bit29*/
#define RCC_AXIDIV1_JPEGAXIDIV_2                       ((uint32_t)0x40000000U)         /* Bit30*/
#define RCC_AXIDIV1_JPEGAXIDIV_3                       ((uint32_t)0x80000000U)         /* Bit31*/
#define RCC_AXIDIV1_JPEGSGDMADIV                       ((uint32_t)0x0F000000U)         /* Bit[27:24] */
#define RCC_AXIDIV1_JPEGSGDMADIV_0                     ((uint32_t)0x01000000U)         /* Bit24*/
#define RCC_AXIDIV1_JPEGSGDMADIV_1                     ((uint32_t)0x02000000U)         /* Bit25*/
#define RCC_AXIDIV1_JPEGSGDMADIV_2                     ((uint32_t)0x04000000U)         /* Bit26*/
#define RCC_AXIDIV1_JPEGSGDMADIV_3                     ((uint32_t)0x08000000U)         /* Bit27*/

#define RCC_AXIDIV1_SDMMC1AXIDIV                       ((uint32_t)0x00F00000U)         /* Bit[23:20] */
#define RCC_AXIDIV1_SDMMC1AXIDIV_0                     ((uint32_t)0x00100000U)         /* Bit20*/
#define RCC_AXIDIV1_SDMMC1AXIDIV_1                     ((uint32_t)0x00200000U)         /* Bit21*/
#define RCC_AXIDIV1_SDMMC1AXIDIV_2                     ((uint32_t)0x00400000U)         /* Bit22*/
#define RCC_AXIDIV1_SDMMC1AXIDIV_3                     ((uint32_t)0x00800000U)         /* Bit23*/

#define RCC_AXIDIV1_SDMMC1AXIDIV_DIV1                  ((uint32_t)0x00000000U)
#define RCC_AXIDIV1_SDMMC1AXIDIV_DIV2                  ((uint32_t)0x00100000U)
#define RCC_AXIDIV1_SDMMC1AXIDIV_DIV4                  ((uint32_t)0x00200000U)
#define RCC_AXIDIV1_SDMMC1AXIDIV_DIV8                  ((uint32_t)0x00400000U)
#define RCC_AXIDIV1_SDMMC1AXIDIV_DIV16                 ((uint32_t)0x00700000U)
#define RCC_AXIDIV1_SDMMC1AXIDIV_DIV32                 ((uint32_t)0x00800000U)
#define RCC_AXIDIV1_SDMMC1AXIDIV_DIV64                 ((uint32_t)0x00900000U)
#define RCC_AXIDIV1_SDMMC1AXIDIV_DIV128                ((uint32_t)0x00A00000U)
#define RCC_AXIDIV1_SDMMC1AXIDIV_DIV256                ((uint32_t)0x00B00000U)
#define RCC_AXIDIV1_SDMMC1AXIDIV_DIV512                ((uint32_t)0x00C00000U)

#define RCC_AXIDIV1_DSIREFDIV                          ((uint32_t)0x000F0000U)         /* Bit[19:16] */
#define RCC_AXIDIV1_DSIREFDIV_0                        ((uint32_t)0x00010000U)         /* Bit16*/
#define RCC_AXIDIV1_DSIREFDIV_1                        ((uint32_t)0x00020000U)         /* Bit17*/
#define RCC_AXIDIV1_DSIREFDIV_2                        ((uint32_t)0x00040000U)         /* Bit18*/
#define RCC_AXIDIV1_DSIREFDIV_3                        ((uint32_t)0x00080000U)         /* Bit19*/

#define RCC_AXIDIV1_DSIREFDIV_DIV1                        ((uint32_t)0x00000000U)
#define RCC_AXIDIV1_DSIREFDIV_DIV2                        ((uint32_t)0x00010000U)
#define RCC_AXIDIV1_DSIREFDIV_DIV4                        ((uint32_t)0x00020000U)
#define RCC_AXIDIV1_DSIREFDIV_DIV8                        ((uint32_t)0x00040000U)
#define RCC_AXIDIV1_DSIREFDIV_DIV16                       ((uint32_t)0x00070000U)
#define RCC_AXIDIV1_DSIREFDIV_DIV32                       ((uint32_t)0x00080000U)
#define RCC_AXIDIV1_DSIREFDIV_DIV64                       ((uint32_t)0x00090000U)
#define RCC_AXIDIV1_DSIREFDIV_DIV128                      ((uint32_t)0x000A0000U)
#define RCC_AXIDIV1_DSIREFDIV_DIV256                      ((uint32_t)0x000B0000U)
#define RCC_AXIDIV1_DSIREFDIV_DIV512                      ((uint32_t)0x000C0000U)

#define RCC_AXIDIV1_LCDCAXIDIV                          ((uint32_t)0x0000F000U)         /* Bit[15:12] */
#define RCC_AXIDIV1_LCDCAXIDIV_0                        ((uint32_t)0x00001000U)         /* Bit12*/
#define RCC_AXIDIV1_LCDCAXIDIV_1                        ((uint32_t)0x00002000U)         /* Bit13*/
#define RCC_AXIDIV1_LCDCAXIDIV_2                        ((uint32_t)0x00004000U)         /* Bit14*/
#define RCC_AXIDIV1_LCDCAXIDIV_3                        ((uint32_t)0x00008000U)         /* Bit15*/

#define RCC_AXIDIV1_LCDCAXIDIV_DIV1                     ((uint32_t)0x00000000U)
#define RCC_AXIDIV1_LCDCAXIDIV_DIV2                     ((uint32_t)0x00001000U)
#define RCC_AXIDIV1_LCDCAXIDIV_DIV4                     ((uint32_t)0x00002000U)
#define RCC_AXIDIV1_LCDCAXIDIV_DIV8                     ((uint32_t)0x00004000U)
#define RCC_AXIDIV1_LCDCAXIDIV_DIV16                    ((uint32_t)0x00007000U)
#define RCC_AXIDIV1_LCDCAXIDIV_DIV32                    ((uint32_t)0x00008000U)
#define RCC_AXIDIV1_LCDCAXIDIV_DIV64                    ((uint32_t)0x00009000U)
#define RCC_AXIDIV1_LCDCAXIDIV_DIV128                   ((uint32_t)0x0000A000U)
#define RCC_AXIDIV1_LCDCAXIDIV_DIV256                   ((uint32_t)0x0000B000U)
#define RCC_AXIDIV1_LCDCAXIDIV_DIV512                   ((uint32_t)0x0000C000U)

#define RCC_AXIDIV1_DVPMAXIDIV                         ((uint32_t)0x00000F00U)         /* Bit[11:8] */
#define RCC_AXIDIV1_DVPMAXIDIV_0                       ((uint32_t)0x00000100U)         /* Bit8*/
#define RCC_AXIDIV1_DVPMAXIDIV_1                       ((uint32_t)0x00000200U)         /* Bit9*/
#define RCC_AXIDIV1_DVPMAXIDIV_2                       ((uint32_t)0x00000400U)         /* Bit10*/
#define RCC_AXIDIV1_DVPMAXIDIV_3                       ((uint32_t)0x00000800U)         /* Bit11*/

#define RCC_AXIDIV1_DVPMAXIDIV_DIV1                    ((uint32_t)0x00000000U)
#define RCC_AXIDIV1_DVPMAXIDIV_DIV2                    ((uint32_t)0x00000100U)
#define RCC_AXIDIV1_DVPMAXIDIV_DIV4                    ((uint32_t)0x00000200U)
#define RCC_AXIDIV1_DVPMAXIDIV_DIV8                    ((uint32_t)0x00000400U)
#define RCC_AXIDIV1_DVPMAXIDIV_DIV16                   ((uint32_t)0x00000700U)
#define RCC_AXIDIV1_DVPMAXIDIV_DIV32                   ((uint32_t)0x00000800U)
#define RCC_AXIDIV1_DVPMAXIDIV_DIV64                   ((uint32_t)0x00000900U)
#define RCC_AXIDIV1_DVPMAXIDIV_DIV128                  ((uint32_t)0x00000A00U)
#define RCC_AXIDIV1_DVPMAXIDIV_DIV256                  ((uint32_t)0x00000B00U)
#define RCC_AXIDIV1_DVPMAXIDIV_DIV512                  ((uint32_t)0x00000C00U)
/******** Bit definition for RCC_AXIDIV2 register  ********/
#define RCC_AXIDIV2_DSIAXIPPIDIV                       ((uint32_t)0x00F00000U)         /* Bit[23:20] */
#define RCC_AXIDIV2_DSIAXIPPIDIV_0                     ((uint32_t)0x00100000U)         /* Bit20*/
#define RCC_AXIDIV2_DSIAXIPPIDIV_1                     ((uint32_t)0x00200000U)         /* Bit21*/
#define RCC_AXIDIV2_DSIAXIPPIDIV_2                     ((uint32_t)0x00400000U)         /* Bit22*/
#define RCC_AXIDIV2_DSIAXIPPIDIV_3                     ((uint32_t)0x00800000U)         /* Bit23*/

#define RCC_AXIDIV2_DSIREFULPSDIV                      ((uint32_t)0x000F0000U)         /* Bit[19:16] */
#define RCC_AXIDIV2_DSIREFULPSDIV_0                    ((uint32_t)0x00010000U)         /* Bit16*/
#define RCC_AXIDIV2_DSIREFULPSDIV_1                    ((uint32_t)0x00020000U)         /* Bit17*/
#define RCC_AXIDIV2_DSIREFULPSDIV_2                    ((uint32_t)0x00040000U)         /* Bit18*/
#define RCC_AXIDIV2_DSIREFULPSDIV_3                    ((uint32_t)0x00080000U)         /* Bit19*/

#define RCC_AXIDIV2_DSIREFULPSDIV_DIV1                 ((uint32_t)0x00000000U)
#define RCC_AXIDIV2_DSIREFULPSDIV_DIV2                 ((uint32_t)0x00010000U)
#define RCC_AXIDIV2_DSIREFULPSDIV_DIV4                 ((uint32_t)0x00020000U)
#define RCC_AXIDIV2_DSIREFULPSDIV_DIV8                 ((uint32_t)0x00040000U)
#define RCC_AXIDIV2_DSIREFULPSDIV_DIV16                ((uint32_t)0x00070000U)
#define RCC_AXIDIV2_DSIREFULPSDIV_DIV32                ((uint32_t)0x00080000U)
#define RCC_AXIDIV2_DSIREFULPSDIV_DIV64                ((uint32_t)0x00090000U)
#define RCC_AXIDIV2_DSIREFULPSDIV_DIV128               ((uint32_t)0x000A0000U)
#define RCC_AXIDIV2_DSIREFULPSDIV_DIV256               ((uint32_t)0x000B0000U)
#define RCC_AXIDIV2_DSIREFULPSDIV_DIV512               ((uint32_t)0x000C0000U)

#define RCC_AXIDIV2_SDRAMMEMDIV                        ((uint32_t)0x00000F00U)         /* Bit[11:8] */
#define RCC_AXIDIV2_SDRAMMEMDIV_0                      ((uint32_t)0x00000100U)         /* Bit8*/
#define RCC_AXIDIV2_SDRAMMEMDIV_1                      ((uint32_t)0x00000200U)         /* Bit9*/
#define RCC_AXIDIV2_SDRAMMEMDIV_2                      ((uint32_t)0x00000400U)         /* Bit10*/
#define RCC_AXIDIV2_SDRAMMEMDIV_3                      ((uint32_t)0x00000800U)         /* Bit11*/

#define RCC_AXIDIV2_SDRAMMEMDIV_DIV1                   ((uint32_t)0x00000000U)
#define RCC_AXIDIV2_SDRAMMEMDIV_DIV2                   ((uint32_t)0x00000100U)
#define RCC_AXIDIV2_SDRAMMEMDIV_DIV4                   ((uint32_t)0x00000200U)
#define RCC_AXIDIV2_SDRAMMEMDIV_DIV8                   ((uint32_t)0x00000400U)
#define RCC_AXIDIV2_SDRAMMEMDIV_DIV16                  ((uint32_t)0x00000700U)
#define RCC_AXIDIV2_SDRAMMEMDIV_DIV32                  ((uint32_t)0x00000800U)
#define RCC_AXIDIV2_SDRAMMEMDIV_DIV64                  ((uint32_t)0x00000900U)
#define RCC_AXIDIV2_SDRAMMEMDIV_DIV128                 ((uint32_t)0x00000A00U)
#define RCC_AXIDIV2_SDRAMMEMDIV_DIV256                 ((uint32_t)0x00000B00U)
#define RCC_AXIDIV2_SDRAMMEMDIV_DIV512                 ((uint32_t)0x00000C00U)

#define RCC_AXIDIV2_FEMCM1AXIDIV                       ((uint32_t)0x000000F0U)         /* Bit[7:4] */
#define RCC_AXIDIV2_FEMCM1AXIDIV_0                     ((uint32_t)0x00000010U)         /* Bit4*/
#define RCC_AXIDIV2_FEMCM1AXIDIV_1                     ((uint32_t)0x00000020U)         /* Bit5*/
#define RCC_AXIDIV2_FEMCM1AXIDIV_2                     ((uint32_t)0x00000040U)         /* Bit6*/
#define RCC_AXIDIV2_FEMCM1AXIDIV_3                     ((uint32_t)0x00000080U)         /* Bit7*/

#define RCC_AXIDIV2_FEMCM0AXIDIV                       ((uint32_t)0x0000000FU)         /* Bit */
#define RCC_AXIDIV2_FEMCM0AXIDIV_0                     ((uint32_t)0x00000001U)         /* Bit0*/
#define RCC_AXIDIV2_FEMCM0AXIDIV_1                     ((uint32_t)0x00000002U)         /* Bit1*/
#define RCC_AXIDIV2_FEMCM0AXIDIV_2                     ((uint32_t)0x00000004U)         /* Bit2*/
#define RCC_AXIDIV2_FEMCM0AXIDIV_3                     ((uint32_t)0x00000008U)         /* Bit3*/

#define RCC_AXIDIV2_FEMCM0AXIDIV_DIV1                 ((uint32_t)0x00000001U)
#define RCC_AXIDIV2_FEMCM0AXIDIV_DIV2                 ((uint32_t)0x00000002U)
#define RCC_AXIDIV2_FEMCM0AXIDIV_DIV3                 ((uint32_t)0x00000003U)
#define RCC_AXIDIV2_FEMCM0AXIDIV_DIV4                 ((uint32_t)0x00000004U)
#define RCC_AXIDIV2_FEMCM0AXIDIV_DIV5                 ((uint32_t)0x00000005U)
#define RCC_AXIDIV2_FEMCM0AXIDIV_DIV6                 ((uint32_t)0x00000006U)
#define RCC_AXIDIV2_FEMCM0AXIDIV_DIV7                 ((uint32_t)0x00000007U)
#define RCC_AXIDIV2_FEMCM0AXIDIV_DIV8                 ((uint32_t)0x00000008U)
#define RCC_AXIDIV2_FEMCM0AXIDIV_DIV9                 ((uint32_t)0x00000009U)
#define RCC_AXIDIV2_FEMCM0AXIDIV_DIV10                ((uint32_t)0x0000000AU)
#define RCC_AXIDIV2_FEMCM0AXIDIV_DIV11                ((uint32_t)0x0000000BU)
#define RCC_AXIDIV2_FEMCM0AXIDIV_DIV12                ((uint32_t)0x0000000CU)
#define RCC_AXIDIV2_FEMCM0AXIDIV_DIV13                ((uint32_t)0x0000000DU)
#define RCC_AXIDIV2_FEMCM0AXIDIV_DIV14                ((uint32_t)0x0000000EU)
#define RCC_AXIDIV2_FEMCM0AXIDIV_DIV15                ((uint32_t)0x0000000FU)
/******** Bit definition for RCC_AXISEL1 register  ********/
#define RCC_AXISEL1_DSIULPSSEL                         ((uint32_t)0x0C000000U)         /* Bit[27:26] */
#define RCC_AXISEL1_DSIULPSSEL_0                       ((uint32_t)0x04000000U)         /* Bit26*/
#define RCC_AXISEL1_DSIULPSSEL_1                       ((uint32_t)0x08000000U)         /* Bit27*/
#define RCC_AXISEL1_DSIKERSEL                          ((uint32_t)0x03000000U)         /* Bit[25:24] */
#define RCC_AXISEL1_DSIKERSEL_0                        ((uint32_t)0x01000000U)         /* Bit24*/
#define RCC_AXISEL1_DSIKERSEL_1                        ((uint32_t)0x02000000U)         /* Bit25*/

#define RCC_AXISEL1_SDMMC1KERSEL                       ((uint32_t)0x00700000U)         /* Bit[22:20] */
#define RCC_AXISEL1_SDMMC1KERSEL_0                     ((uint32_t)0x00100000U)         /* Bit20*/
#define RCC_AXISEL1_SDMMC1KERSEL_1                     ((uint32_t)0x00200000U)         /* Bit21*/
#define RCC_AXISEL1_SDMMC1KERSEL_2                     ((uint32_t)0x00400000U)         /* Bit22*/

#define RCC_AXISEL1_SDMMC1KERSEL_AXIDIV                ((uint32_t)0x00000000U)
#define RCC_AXISEL1_SDMMC1KERSEL_PERIPH                ((uint32_t)0x00100000U)
#define RCC_AXISEL1_SDMMC1KERSEL_PLL2A                 ((uint32_t)0x00200000U)
#define RCC_AXISEL1_SDMMC1KERSEL_PLL3A                 ((uint32_t)0x00300000U)
#define RCC_AXISEL1_SDMMC1KERSEL_PLL1B                 ((uint32_t)0x00400000U)

#define RCC_AXISEL1_DSIPPITXSEL                        ((uint32_t)0x00030000U)         /* Bit[17:16] */
#define RCC_AXISEL1_DSIPPITXSEL_0                      ((uint32_t)0x00010000U)         /* Bit16*/
#define RCC_AXISEL1_DSIPPITXSEL_1                      ((uint32_t)0x00020000U)         /* Bit17*/

#define RCC_AXISEL1_DSIPPITXSEL_REFDIV                      ((uint32_t)0x00000000U)
#define RCC_AXISEL1_DSIPPITXSEL_PLL2B                       ((uint32_t)0x00010000U)
#define RCC_AXISEL1_DSIPPITXSEL_PERIPH                      ((uint32_t)0x00020000U)
#define RCC_AXISEL1_DSIPPITXSEL_AXIDIV                      ((uint32_t)0x00030000U)

#define RCC_AXISEL1_LCDCKERSEL                          ((uint32_t)0x00003000U)         /* Bit[13:12] */
#define RCC_AXISEL1_LCDCKERSEL_0                        ((uint32_t)0x00001000U)         /* Bit12*/
#define RCC_AXISEL1_LCDCKERSEL_1                        ((uint32_t)0x00002000U)         /* Bit13*/

#define RCC_AXISEL1_LCDCKERSEL_AXIDIV                              ((uint32_t)0x00000000U)
#define RCC_AXISEL1_LCDCKERSEL_PERIPH                              ((uint32_t)0x00001000U)
#define RCC_AXISEL1_LCDCKERSEL_PLL2C                              ((uint32_t)0x00002000U)
#define RCC_AXISEL1_LCDCKERSEL_PLL3B                              ((uint32_t)0x00003000U)

#define RCC_AXISEL1_DVP1MSEL                           ((uint32_t)0x00000C00U)         /* Bit[11:10] */
#define RCC_AXISEL1_DVP1MSEL_0                         ((uint32_t)0x00000400U)         /* Bit10*/
#define RCC_AXISEL1_DVP1MSEL_1                         ((uint32_t)0x00000800U)         /* Bit11*/

#define RCC_AXISEL1_DVP1MSEL_AXIDIV                                     ((uint32_t)0x00000000U)
#define RCC_AXISEL1_DVP1MSEL_PERIPH                                     ((uint32_t)0x00000400U)
#define RCC_AXISEL1_DVP1MSEL_PLL2C                                      ((uint32_t)0x00000800U)
#define RCC_AXISEL1_DVP1MSEL_PLL3A                                      ((uint32_t)0x00000C00U)

#define RCC_AXISEL1_DVP2MSEL                           ((uint32_t)0x00000300U)         /* Bit[9:8] */
#define RCC_AXISEL1_DVP2MSEL_0                         ((uint32_t)0x00000100U)         /* Bit8*/
#define RCC_AXISEL1_DVP2MSEL_1                         ((uint32_t)0x00000200U)         /* Bit9*/

#define RCC_AXISEL1_XSPI1SSISEL                        ((uint32_t)0x00000070U)         /* Bit[6:4] */
#define RCC_AXISEL1_XSPI1SSISEL_0                      ((uint32_t)0x00000010U)         /* Bit4*/
#define RCC_AXISEL1_XSPI1SSISEL_1                      ((uint32_t)0x00000020U)         /* Bit5*/
#define RCC_AXISEL1_XSPI1SSISEL_2                      ((uint32_t)0x00000040U)         /* Bit6*/

#define RCC_AXISEL1_XSPI1SSISEL_AXI                    ((uint32_t)0x00000000U)
#define RCC_AXISEL1_XSPI1SSISEL_PLL3C                  ((uint32_t)0x00000010U)
#define RCC_AXISEL1_XSPI1SSISEL_PLL1B                  ((uint32_t)0x00000020U)
#define RCC_AXISEL1_XSPI1SSISEL_PLL2A                  ((uint32_t)0x00000030U)
#define RCC_AXISEL1_XSPI1SSISEL_PLL2C                  ((uint32_t)0x00000040U)

#define RCC_AXISEL1_XSPI2SSISEL                        ((uint32_t)0x00000007U)         /* Bit */
#define RCC_AXISEL1_XSPI2SSISEL_0                      ((uint32_t)0x00000001U)         /* Bit0*/
#define RCC_AXISEL1_XSPI2SSISEL_1                      ((uint32_t)0x00000002U)         /* Bit1*/
#define RCC_AXISEL1_XSPI2SSISEL_2                      ((uint32_t)0x00000004U)         /* Bit2*/

/******** Bit definition for RCC_AXISEL2 register  ********/
#define RCC_AXISEL2_SDRAMMEMSEL                        ((uint32_t)0x00000700U)         /* Bit[10:8] */
#define RCC_AXISEL2_SDRAMMEMSEL_0                      ((uint32_t)0x00000100U)         /* Bit8*/
#define RCC_AXISEL2_SDRAMMEMSEL_1                      ((uint32_t)0x00000200U)         /* Bit9*/
#define RCC_AXISEL2_SDRAMMEMSEL_2                      ((uint32_t)0x00000400U)         /* Bit10*/

#define RCC_AXISEL2_SDRAMMEMSEL_AXIDIV                  ((uint32_t)0x00000000U)
#define RCC_AXISEL2_SDRAMMEMSEL_PERIPH                  ((uint32_t)0x00000100U)
#define RCC_AXISEL2_SDRAMMEMSEL_PLL2A                   ((uint32_t)0x00000200U)
#define RCC_AXISEL2_SDRAMMEMSEL_PLL3A                   ((uint32_t)0x00000300U)
#define RCC_AXISEL2_SDRAMMEMSEL_PLL1B                   ((uint32_t)0x00000400U)

#define RCC_AXISEL2_FEMCM1SEL                          ((uint32_t)0x00000070U)         /* Bit[6:4] */
#define RCC_AXISEL2_FEMCM1SEL_0                        ((uint32_t)0x00000010U)         /* Bit4*/
#define RCC_AXISEL2_FEMCM1SEL_1                        ((uint32_t)0x00000020U)         /* Bit5*/
#define RCC_AXISEL2_FEMCM1SEL_2                        ((uint32_t)0x00000040U)         /* Bit6*/

#define RCC_AXISEL2_FEMCM0SEL                          ((uint32_t)0x00000007U)         /* Bit */
#define RCC_AXISEL2_FEMCM0SEL_0                        ((uint32_t)0x00000001U)         /* Bit0*/
#define RCC_AXISEL2_FEMCM0SEL_1                        ((uint32_t)0x00000002U)         /* Bit1*/
#define RCC_AXISEL2_FEMCM0SEL_2                        ((uint32_t)0x00000004U)         /* Bit2*/

#define RCC_AXISEL2_FEMCM0SEL_AXIDIV                  ((uint32_t)0x00000000U)
#define RCC_AXISEL2_FEMCM0SEL_PERIPH                  ((uint32_t)0x00000001U)
#define RCC_AXISEL2_FEMCM0SEL_PLL2C                   ((uint32_t)0x00000002U)
#define RCC_AXISEL2_FEMCM0SEL_PLL3B                   ((uint32_t)0x00000003U)
#define RCC_AXISEL2_FEMCM0SEL_PLL1B                   ((uint32_t)0x00000004U)
/******** Bit definition for RCC_AXIEN1 register  ********/
#define RCC_AXIEN1_M7JPEGDEN                               ((uint32_t)0x80000000U)         /* Bit[31] */
#define RCC_AXIEN1_M4JPEGDEN                               ((uint32_t)0x40000000U)         /* Bit[30] */
#define RCC_AXIEN1_M7JPEGDLPEN                             ((uint32_t)0x20000000U)         /* Bit[29] */
#define RCC_AXIEN1_M4JPEGDLPEN                             ((uint32_t)0x10000000U)         /* Bit[28] */
#define RCC_AXIEN1_M7JPEGEEN                               ((uint32_t)0x00800000U)         /* Bit[23] */
#define RCC_AXIEN1_M4JPEGEEN                               ((uint32_t)0x00400000U)         /* Bit[22] */
#define RCC_AXIEN1_M7JPEGELPEN                             ((uint32_t)0x00200000U)         /* Bit[21] */
#define RCC_AXIEN1_M4JPEGELPEN                             ((uint32_t)0x00100000U)         /* Bit[20] */
#define RCC_AXIEN1_M7DMAMUX2EN                             ((uint32_t)0x00080000U)         /* Bit[19] */
#define RCC_AXIEN1_M4DMAMUX2EN                             ((uint32_t)0x00040000U)         /* Bit[18] */
#define RCC_AXIEN1_M7DMAMUX2LPEN                           ((uint32_t)0x00020000U)         /* Bit[17] */
#define RCC_AXIEN1_M4DMAMUX2LPEN                           ((uint32_t)0x00010000U)         /* Bit[16] */
#define RCC_AXIEN1_M7MDMAEN                                ((uint32_t)0x00008000U)         /* Bit[15] */
#define RCC_AXIEN1_M4MDMAEN                                ((uint32_t)0x00004000U)         /* Bit[14] */
#define RCC_AXIEN1_M7MDMALPEN                              ((uint32_t)0x00002000U)         /* Bit[13] */
#define RCC_AXIEN1_M4MDMALPEN                              ((uint32_t)0x00001000U)         /* Bit[12] */
#define RCC_AXIEN1_M7SDMMC1EN                              ((uint32_t)0x00000800U)         /* Bit[11] */
#define RCC_AXIEN1_M4SDMMC1EN                              ((uint32_t)0x00000400U)         /* Bit[10] */
#define RCC_AXIEN1_M7SDMMC1LPEN                            ((uint32_t)0x00000200U)         /* Bit[9] */
#define RCC_AXIEN1_M4SDMMC1LPEN                            ((uint32_t)0x00000100U)         /* Bit[8] */
#define RCC_AXIEN1_M7ECCM1EN                               ((uint32_t)0x00000080U)         /* Bit[7] */
#define RCC_AXIEN1_M4ECCM1EN                               ((uint32_t)0x00000040U)         /* Bit[6] */
#define RCC_AXIEN1_M7ECCM1LPEN                             ((uint32_t)0x00000020U)         /* Bit[5] */
#define RCC_AXIEN1_M4ECCM1LPEN                             ((uint32_t)0x00000010U)         /* Bit[4] */
#define RCC_AXIEN1_M7OTPCEN                                ((uint32_t)0x00000008U)         /* Bit[3] */
#define RCC_AXIEN1_M4OTPCEN                                ((uint32_t)0x00000004U)         /* Bit[2] */
#define RCC_AXIEN1_M7OTPCLPEN                              ((uint32_t)0x00000002U)         /* Bit[1] */
#define RCC_AXIEN1_M4OTPCLPEN                              ((uint32_t)0x00000001U)         /* Bit[0] */

/******** Bit definition for RCC_AXIEN2 register  ********/
#define RCC_AXIEN2_M7DSIEN                                 ((uint32_t)0x80000000U)         /* Bit[31] */
#define RCC_AXIEN2_M4DSIEN                                 ((uint32_t)0x40000000U)         /* Bit[30] */
#define RCC_AXIEN2_M7DSILPEN                               ((uint32_t)0x20000000U)         /* Bit[29] */
#define RCC_AXIEN2_M4DSILPEN                               ((uint32_t)0x10000000U)         /* Bit[28] */
#define RCC_AXIEN2_M7LCDCEN                                 ((uint32_t)0x08000000U)         /* Bit[27] */
#define RCC_AXIEN2_M4LCDCEN                                 ((uint32_t)0x04000000U)         /* Bit[26] */
#define RCC_AXIEN2_M7LCDCLPEN                               ((uint32_t)0x02000000U)         /* Bit[25] */
#define RCC_AXIEN2_M4LCDCLPEN                               ((uint32_t)0x01000000U)         /* Bit[24] */
#define RCC_AXIEN2_M7LCDCAPBEN                              ((uint32_t)0x00800000U)         /* Bit[23] */
#define RCC_AXIEN2_M4LCDCAPBEN                              ((uint32_t)0x00400000U)         /* Bit[22] */
#define RCC_AXIEN2_M7LCDCAPBLPEN                            ((uint32_t)0x00200000U)         /* Bit[21] */
#define RCC_AXIEN2_M4LCDCAPBLPEN                            ((uint32_t)0x00100000U)         /* Bit[20] */
#define RCC_AXIEN2_M7DVP1EN                                ((uint32_t)0x00080000U)         /* Bit[19] */
#define RCC_AXIEN2_M4DVP1EN                                ((uint32_t)0x00040000U)         /* Bit[18] */
#define RCC_AXIEN2_M7DVP1LPEN                              ((uint32_t)0x00020000U)         /* Bit[17] */
#define RCC_AXIEN2_M4DVP1LPEN                              ((uint32_t)0x00010000U)         /* Bit[16] */
#define RCC_AXIEN2_M7DVP1APBEN                             ((uint32_t)0x00008000U)         /* Bit[15] */
#define RCC_AXIEN2_M4DVP1APBEN                             ((uint32_t)0x00004000U)         /* Bit[14] */
#define RCC_AXIEN2_M7DVP1APBLPEN                           ((uint32_t)0x00002000U)         /* Bit[13] */
#define RCC_AXIEN2_M4DVP1APBLPEN                           ((uint32_t)0x00001000U)         /* Bit[12] */
#define RCC_AXIEN2_M7DVP2EN                                ((uint32_t)0x00000800U)         /* Bit[11] */
#define RCC_AXIEN2_M4DVP2EN                                ((uint32_t)0x00000400U)         /* Bit[10] */
#define RCC_AXIEN2_M7DVP2LPEN                              ((uint32_t)0x00000200U)         /* Bit[9] */
#define RCC_AXIEN2_M4DVP2LPEN                              ((uint32_t)0x00000100U)         /* Bit[8] */
#define RCC_AXIEN2_M7DVP2APBEN                             ((uint32_t)0x00000080U)         /* Bit[7] */
#define RCC_AXIEN2_M4DVP2APBEN                             ((uint32_t)0x00000040U)         /* Bit[6] */
#define RCC_AXIEN2_M7DVP2APBLPEN                           ((uint32_t)0x00000020U)         /* Bit[5] */
#define RCC_AXIEN2_M4DVP2APBLPEN                           ((uint32_t)0x00000010U)         /* Bit[4] */
#define RCC_AXIEN2_M7WWDG1EN                               ((uint32_t)0x00000008U)         /* Bit[3] */
#define RCC_AXIEN2_M4WWDG1EN                               ((uint32_t)0x00000004U)         /* Bit[2] */
#define RCC_AXIEN2_M7WWDG1LPEN                             ((uint32_t)0x00000002U)         /* Bit[1] */
#define RCC_AXIEN2_M4WWDG1LPEN                             ((uint32_t)0x00000001U)         /* Bit[0] */

/******** Bit definition for RCC_AXIEN3 register  ********/
#define RCC_AXIEN3_M7TASRAM2EN                             ((uint32_t)0x80000000U)         /* Bit[31] */
#define RCC_AXIEN3_M4TASRAM2EN                             ((uint32_t)0x40000000U)         /* Bit[30] */
#define RCC_AXIEN3_M7TASRAM2LPEN                           ((uint32_t)0x20000000U)         /* Bit[29] */
#define RCC_AXIEN3_M4TASRAM2LPEN                           ((uint32_t)0x10000000U)         /* Bit[28] */
#define RCC_AXIEN3_M7TASRAM3EN                             ((uint32_t)0x08000000U)         /* Bit[27] */
#define RCC_AXIEN3_M4TASRAM3EN                             ((uint32_t)0x04000000U)         /* Bit[26] */
#define RCC_AXIEN3_M7TASRAM3LPEN                           ((uint32_t)0x02000000U)         /* Bit[25] */
#define RCC_AXIEN3_M4TASRAM3LPEN                           ((uint32_t)0x01000000U)         /* Bit[24] */
#define RCC_AXIEN3_M7TCMEN                                 ((uint32_t)0x00800000U)         /* Bit[23] */
#define RCC_AXIEN3_M4TCMEN                                 ((uint32_t)0x00400000U)         /* Bit[22] */
#define RCC_AXIEN3_M7TCMLPEN                               ((uint32_t)0x00200000U)         /* Bit[21] */
#define RCC_AXIEN3_M4TCMLPEN                               ((uint32_t)0x00100000U)         /* Bit[20] */
#define RCC_AXIEN3_M7TCMAXIEN                              ((uint32_t)0x00080000U)         /* Bit[19] */
#define RCC_AXIEN3_M4TCMAXIEN                              ((uint32_t)0x00040000U)         /* Bit[18] */
#define RCC_AXIEN3_M7TCMAXILPEN                            ((uint32_t)0x00020000U)         /* Bit[17] */
#define RCC_AXIEN3_M4TCMAXILPEN                            ((uint32_t)0x00010000U)         /* Bit[16] */
#define RCC_AXIEN3_M7TCMAPBEN                              ((uint32_t)0x00008000U)         /* Bit[15] */
#define RCC_AXIEN3_M4TCMAPBEN                              ((uint32_t)0x00004000U)         /* Bit[14] */
#define RCC_AXIEN3_M7TCMAPBLPEN                            ((uint32_t)0x00002000U)         /* Bit[13] */
#define RCC_AXIEN3_M4TCMAPBLPEN                            ((uint32_t)0x00001000U)         /* Bit[12] */
#define RCC_AXIEN3_M7ASRAM1EN                              ((uint32_t)0x00000800U)         /* Bit[11] */
#define RCC_AXIEN3_M4ASRAM1EN                              ((uint32_t)0x00000400U)         /* Bit[10] */
#define RCC_AXIEN3_M7ASRAM1LPEN                            ((uint32_t)0x00000200U)         /* Bit[9] */
#define RCC_AXIEN3_M4ASRAM1LPEN                            ((uint32_t)0x00000100U)         /* Bit[8] */
#define RCC_AXIEN3_M7AXIROMEN                              ((uint32_t)0x00000080U)         /* Bit[7] */
#define RCC_AXIEN3_M4AXIROMEN                              ((uint32_t)0x00000040U)         /* Bit[6] */
#define RCC_AXIEN3_M7AXIROMLPEN                            ((uint32_t)0x00000020U)         /* Bit[5] */
#define RCC_AXIEN3_M4AXIROMLPEN                            ((uint32_t)0x00000010U)         /* Bit[4] */
#define RCC_AXIEN3_M7GPUEN                                 ((uint32_t)0x00000008U)         /* Bit[3] */
#define RCC_AXIEN3_M4GPUEN                                 ((uint32_t)0x00000004U)         /* Bit[2] */
#define RCC_AXIEN3_M7GPULPEN                               ((uint32_t)0x00000002U)         /* Bit[1] */
#define RCC_AXIEN3_M4GPULPEN                               ((uint32_t)0x00000001U)         /* Bit[0] */

/******** Bit definition for RCC_AXIEN4 register  ********/
#define RCC_AXIEN4_M7XSPI1EN                               ((uint32_t)0x80000000U)         /* Bit[31] */
#define RCC_AXIEN4_M4XSPI1EN                               ((uint32_t)0x40000000U)         /* Bit[30] */
#define RCC_AXIEN4_M7XSPI1LPEN                             ((uint32_t)0x20000000U)         /* Bit[29] */
#define RCC_AXIEN4_M4XSPI1LPEN                             ((uint32_t)0x10000000U)         /* Bit[28] */
#define RCC_AXIEN4_M7XSPI2EN                               ((uint32_t)0x08000000U)         /* Bit[27] */
#define RCC_AXIEN4_M4XSPI2EN                               ((uint32_t)0x04000000U)         /* Bit[26] */
#define RCC_AXIEN4_M7XSPI2LPEN                             ((uint32_t)0x02000000U)         /* Bit[25] */
#define RCC_AXIEN4_M4XSPI2LPEN                             ((uint32_t)0x01000000U)         /* Bit[24] */
#define RCC_AXIEN4_M7FEMCEN                                ((uint32_t)0x00800000U)         /* Bit[23] */
#define RCC_AXIEN4_M4FEMCEN                                ((uint32_t)0x00400000U)         /* Bit[22] */
#define RCC_AXIEN4_M7FEMCLPEN                              ((uint32_t)0x00200000U)         /* Bit[21] */
#define RCC_AXIEN4_M4FEMCLPEN                              ((uint32_t)0x00100000U)         /* Bit[20] */
#define RCC_AXIEN4_M7SDRAMEN                               ((uint32_t)0x00080000U)         /* Bit[19] */
#define RCC_AXIEN4_M4SDRAMEN                               ((uint32_t)0x00040000U)         /* Bit[18] */
#define RCC_AXIEN4_M7SDRAMLPEN                             ((uint32_t)0x00020000U)         /* Bit[17] */
#define RCC_AXIEN4_M4SDRAMLPEN                             ((uint32_t)0x00010000U)         /* Bit[16] */
#define RCC_AXIEN4_M7DSIULPSEN                             ((uint32_t)0x00000008U)         /* Bit[3] */
#define RCC_AXIEN4_M4DSIULPSEN                             ((uint32_t)0x00000004U)         /* Bit[2] */
#define RCC_AXIEN4_M7DSIULPSLPEN                           ((uint32_t)0x00000002U)         /* Bit[1] */
#define RCC_AXIEN4_M4DSIULPSLPEN                           ((uint32_t)0x00000001U)         /* Bit[0] */

/******** Bit definition for RCC_AXIRST1 register  ********/
#define RCC_AXIRST1_JPEGDRST                                ((uint32_t)0x10000000U)         /* Bit[28] */
#define RCC_AXIRST1_JPEGERST                                ((uint32_t)0x00100000U)         /* Bit[20] */
#define RCC_AXIRST1_DMAMUX2RST                              ((uint32_t)0x00010000U)         /* Bit[16] */
#define RCC_AXIRST1_MDMARST                                 ((uint32_t)0x00001000U)         /* Bit[12] */
#define RCC_AXIRST1_SDMMC1RST                            ((uint32_t)0x00000200U)         /* Bit[9] */
#define RCC_AXIRST1_SDHOST1RST                               ((uint32_t)0x00000100U)         /* Bit[8] */
#define RCC_AXIRST1_ECCM1RST                                ((uint32_t)0x00000010U)         /* Bit[4] */
#define RCC_AXIRST1_OTPCRST                                 ((uint32_t)0x00000001U)         /* Bit[0] */

/******** Bit definition for RCC_AXIRST2 register  ********/
#define RCC_AXIRST2_DSICFGRST                               ((uint32_t)0x20000000U)         /* Bit[29] */
#define RCC_AXIRST2_DSIRST                                  ((uint32_t)0x10000000U)         /* Bit[28] */
#define RCC_AXIRST2_LCDCRST                                  ((uint32_t)0x01000000U)         /* Bit[24] */
#define RCC_AXIRST2_DVP1RST                                 ((uint32_t)0x00010000U)         /* Bit[16] */
#define RCC_AXIRST2_DVP2RST                                 ((uint32_t)0x00000100U)         /* Bit[8] */
#define RCC_AXIRST2_WWDG1RST                                ((uint32_t)0x00000001U)         /* Bit[0] */

/******** Bit definition for RCC_AXIRST3 register  ********/
#define RCC_AXIRST3_GPURST                                  ((uint32_t)0x00000001U)         /* Bit[0] */

/******** Bit definition for RCC_AXIRST4 register  ********/
#define RCC_AXIRST4_XSPI1RST                                ((uint32_t)0x10000000U)         /* Bit[28] */
#define RCC_AXIRST4_XSPI2RST                                ((uint32_t)0x01000000U)         /* Bit[24] */
#define RCC_AXIRST4_FEMCCFGRST                              ((uint32_t)0x00200000U)         /* Bit[21] */
#define RCC_AXIRST4_FEMCRST                                 ((uint32_t)0x00100000U)         /* Bit[20] */
#define RCC_AXIRST4_SDRAMRST                                ((uint32_t)0x00010000U)         /* Bit[16] */

/******** Bit definition for RCC_CFG2 register  ********/
#define RCC_CFG2_M4CAHIEN                                ((uint32_t)0x40000000U)         /* Bit[30] */
#define RCC_CFG2_M4CAHIPCLKEN                            ((uint32_t)0x10000000U)         /* Bit[28] */
#define RCC_CFG2_M4CAHDEN                                ((uint32_t)0x04000000U)         /* Bit[26] */
#define RCC_CFG2_M4CAHDPCLKEN                            ((uint32_t)0x01000000U)         /* Bit[24] */
#define RCC_CFG2_M7MMUEN                                 ((uint32_t)0x00800000U)         /* Bit[23] */
#define RCC_CFG2_M7MMULPEN                               ((uint32_t)0x00400000U)         /* Bit[22] */
#define RCC_CFG2_M4MMUEN                                 ((uint32_t)0x00200000U)         /* Bit[21] */
#define RCC_CFG2_M4MMULPEN                               ((uint32_t)0x00100000U)         /* Bit[20] */
#define RCC_CFG2_M7SRAMBKPEN                             ((uint32_t)0x00080000U)         /* Bit[19] */
#define RCC_CFG2_M4SRAMBKPEN                             ((uint32_t)0x00040000U)         /* Bit[18] */
#define RCC_CFG2_M7SRAMBKPLPEN                           ((uint32_t)0x00020000U)         /* Bit[17] */
#define RCC_CFG2_M4SRAMBKPLPEN                           ((uint32_t)0x00010000U)         /* Bit[16] */
#define RCC_CFG2_M7SRAM1EN                               ((uint32_t)0x00008000U)         /* Bit[15] */
#define RCC_CFG2_M4SRAM1EN                               ((uint32_t)0x00004000U)         /* Bit[14] */
#define RCC_CFG2_M7SRAM1LPEN                             ((uint32_t)0x00002000U)         /* Bit[13] */
#define RCC_CFG2_M4SRAM1LPEN                             ((uint32_t)0x00001000U)         /* Bit[12] */
#define RCC_CFG2_M7SRAM2EN                               ((uint32_t)0x00000800U)         /* Bit[11] */
#define RCC_CFG2_M4SRAM2EN                               ((uint32_t)0x00000400U)         /* Bit[10] */
#define RCC_CFG2_M7SRAM2LPEN                             ((uint32_t)0x00000200U)         /* Bit[9] */
#define RCC_CFG2_M4SRAM2LPEN                             ((uint32_t)0x00000100U)         /* Bit[8] */
#define RCC_CFG2_M7SRAM3EN                               ((uint32_t)0x00000080U)         /* Bit[7] */
#define RCC_CFG2_M4SRAM3EN                               ((uint32_t)0x00000040U)         /* Bit[6] */
#define RCC_CFG2_M7SRAM3LPEN                             ((uint32_t)0x00000020U)         /* Bit[5] */
#define RCC_CFG2_M4SRAM3LPEN                             ((uint32_t)0x00000010U)         /* Bit[4] */
#define RCC_CFG2_M7SRAM4EN                               ((uint32_t)0x00000008U)         /* Bit[3] */
#define RCC_CFG2_M4SRAM4EN                               ((uint32_t)0x00000004U)         /* Bit[2] */
#define RCC_CFG2_M7SRAM4LPEN                             ((uint32_t)0x00000002U)         /* Bit[1] */
#define RCC_CFG2_M4SRAM4LPEN                             ((uint32_t)0x00000001U)         /* Bit[0] */

/******** Bit definition for RCC_CFG3 register  ********/
#define RCC_CFG3_MCO1SEL                            ((uint32_t)0xF0000000U)         /* Bit[31:28] */
#define RCC_CFG3_MCO1SEL_0                          ((uint32_t)0x10000000U)         /* Bit28*/
#define RCC_CFG3_MCO1SEL_1                          ((uint32_t)0x20000000U)         /* Bit29*/
#define RCC_CFG3_MCO1SEL_2                          ((uint32_t)0x40000000U)         /* Bit30*/
#define RCC_CFG3_MCO1SEL_3                          ((uint32_t)0x80000000U)         /* Bit31*/

#define RCC_CFG3_MCO1SEL_LSI                        ((uint32_t)0x80000000U)
#define RCC_CFG3_MCO1SEL_HSI                        ((uint32_t)0x90000000U)
#define RCC_CFG3_MCO1SEL_MSI                        ((uint32_t)0xA0000000U)
#define RCC_CFG3_MCO1SEL_LSE                        ((uint32_t)0xB0000000U)
#define RCC_CFG3_MCO1SEL_HSE                        ((uint32_t)0xC0000000U)
#define RCC_CFG3_MCO1SEL_PLL3B                      ((uint32_t)0xD0000000U)

#define RCC_CFG3_MCO1DIV                            ((uint32_t)0x0F000000U)         /* Bit[27:24] */
#define RCC_CFG3_MCO1DIV_0                          ((uint32_t)0x01000000U)         /* Bit24*/
#define RCC_CFG3_MCO1DIV_1                          ((uint32_t)0x02000000U)         /* Bit25*/
#define RCC_CFG3_MCO1DIV_2                          ((uint32_t)0x04000000U)         /* Bit26*/
#define RCC_CFG3_MCO1DIV_3                          ((uint32_t)0x08000000U)         /* Bit27*/

#define RCC_CFG3_MCO1DIV_DIV1                         ((uint32_t)0x00000000U)
#define RCC_CFG3_MCO1DIV_DIV2                         ((uint32_t)0x01000000U)
#define RCC_CFG3_MCO1DIV_DIV4                         ((uint32_t)0x02000000U)
#define RCC_CFG3_MCO1DIV_DIV8                         ((uint32_t)0x04000000U)
#define RCC_CFG3_MCO1DIV_DIV16                        ((uint32_t)0x07000000U)
#define RCC_CFG3_MCO1DIV_DIV32                        ((uint32_t)0x08000000U)
#define RCC_CFG3_MCO1DIV_DIV64                        ((uint32_t)0x09000000U)
#define RCC_CFG3_MCO1DIV_DIV128                        ((uint32_t)0x0A000000U)

#define RCC_CFG3_MCO2SEL                            ((uint32_t)0x00F00000U)         /* Bit[23:20] */
#define RCC_CFG3_MCO2SEL_0                          ((uint32_t)0x00100000U)         /* Bit20*/
#define RCC_CFG3_MCO2SEL_1                          ((uint32_t)0x00200000U)         /* Bit21*/
#define RCC_CFG3_MCO2SEL_2                          ((uint32_t)0x00400000U)         /* Bit22*/
#define RCC_CFG3_MCO2SEL_3                          ((uint32_t)0x00800000U)         /* Bit23*/

#define RCC_CFG3_MCO2SEL_SYSCLK                     ((uint32_t)0x00800000U)
#define RCC_CFG3_MCO2SEL_PLL1A                      ((uint32_t)0x00900000U)
#define RCC_CFG3_MCO2SEL_PLL2A                      ((uint32_t)0x00A00000U)
#define RCC_CFG3_MCO2SEL_PLL3A                      ((uint32_t)0x00B00000U)
#define RCC_CFG3_MCO2SEL_SHRPLL                     ((uint32_t)0x00C00000U)
#define RCC_CFG3_MCO2SEL_LSE                        ((uint32_t)0x00D00000U)

#define RCC_CFG3_MCO2DIV                            ((uint32_t)0x000F0000U)         /* Bit[19:16] */
#define RCC_CFG3_MCO2DIV_0                          ((uint32_t)0x00010000U)         /* Bit16*/
#define RCC_CFG3_MCO2DIV_1                          ((uint32_t)0x00020000U)         /* Bit17*/
#define RCC_CFG3_MCO2DIV_2                          ((uint32_t)0x00040000U)         /* Bit18*/
#define RCC_CFG3_MCO2DIV_3                          ((uint32_t)0x00080000U)         /* Bit19*/

#define RCC_CFG3_MCO2DIV_DIV1                       ((uint32_t)0x00000000U)
#define RCC_CFG3_MCO2DIV_DIV2                       ((uint32_t)0x00010000U)
#define RCC_CFG3_MCO2DIV_DIV4                       ((uint32_t)0x00020000U)
#define RCC_CFG3_MCO2DIV_DIV8                       ((uint32_t)0x00040000U)
#define RCC_CFG3_MCO2DIV_DIV16                      ((uint32_t)0x00070000U)
#define RCC_CFG3_MCO2DIV_DIV32                      ((uint32_t)0x00080000U)
#define RCC_CFG3_MCO2DIV_DIV64                      ((uint32_t)0x00090000U)
#define RCC_CFG3_MCO2DIV_DIV128                     ((uint32_t)0x000A0000U)

#define RCC_CFG3_I2SSEL                             ((uint32_t)0x0000C000U)         /* Bit[15:14] */
#define RCC_CFG3_I2SSEL_0                           ((uint32_t)0x00004000U)         /* Bit14*/
#define RCC_CFG3_I2SSEL_1                           ((uint32_t)0x00008000U)         /* Bit15*/

#define RCC_CFG3_I2SSEL_I2S1                        ((uint32_t)0x00000000U)
#define RCC_CFG3_I2SSEL_I2S2                        ((uint32_t)0x00004000U)
#define RCC_CFG3_I2SSEL_I2S3                        ((uint32_t)0x00008000U)
#define RCC_CFG3_I2SSEL_I2S4                        ((uint32_t)0x0000C000U)

#define RCC_CFG3_PERSW                              ((uint32_t)0x00003000U)         /* Bit[13:12] */
#define RCC_CFG3_PERSW_0                            ((uint32_t)0x00001000U)         /* Bit12*/
#define RCC_CFG3_PERSW_1                            ((uint32_t)0x00002000U)         /* Bit13*/
#define RCC_CFG3_M7STCLKDIV                         ((uint32_t)0x000000F0U)         /* Bit[7:4] */
#define RCC_CFG3_M7STCLKDIV_0                       ((uint32_t)0x00000010U)         /* Bit4*/
#define RCC_CFG3_M7STCLKDIV_1                       ((uint32_t)0x00000020U)         /* Bit5*/
#define RCC_CFG3_M7STCLKDIV_2                       ((uint32_t)0x00000040U)         /* Bit6*/
#define RCC_CFG3_M7STCLKDIV_3                       ((uint32_t)0x00000080U)         /* Bit7*/

#define RCC_CFG3_M7STCLKDIV_DIV1                  ((uint32_t)0x00000000U)
#define RCC_CFG3_M7STCLKDIV_DIV2                  ((uint32_t)0x00000010U)
#define RCC_CFG3_M7STCLKDIV_DIV4                  ((uint32_t)0x00000020U)
#define RCC_CFG3_M7STCLKDIV_DIV8                  ((uint32_t)0x00000040U)
#define RCC_CFG3_M7STCLKDIV_DIV16                 ((uint32_t)0x00000070U)
#define RCC_CFG3_M7STCLKDIV_DIV32                 ((uint32_t)0x00000080U)
#define RCC_CFG3_M7STCLKDIV_DIV64                 ((uint32_t)0x00000090U)
#define RCC_CFG3_M7STCLKDIV_DIV128                ((uint32_t)0x000000A0U)
#define RCC_CFG3_M7STCLKDIV_DIV256                ((uint32_t)0x000000B0U)
#define RCC_CFG3_M7STCLKDIV_DIV512                ((uint32_t)0x000000C0U)

#define RCC_CFG3_M4STCLKDIV                         ((uint32_t)0x0000000FU)         /* Bit */
#define RCC_CFG3_M4STCLKDIV_0                       ((uint32_t)0x00000001U)         /* Bit0*/
#define RCC_CFG3_M4STCLKDIV_1                       ((uint32_t)0x00000002U)         /* Bit1*/
#define RCC_CFG3_M4STCLKDIV_2                       ((uint32_t)0x00000004U)         /* Bit2*/
#define RCC_CFG3_M4STCLKDIV_3                       ((uint32_t)0x00000008U)         /* Bit3*/

/******** Bit definition for RCC_CFG4 register  ********/
#define RCC_CFG4_AHB1CLKEN                               ((uint32_t)0x80000000U)         /* Bit[31] */
#define RCC_CFG4_AHB2CLKEN                               ((uint32_t)0x40000000U)         /* Bit[30] */
#define RCC_CFG4_AHB3CLKEN                               ((uint32_t)0x20000000U)         /* Bit[29] */
#define RCC_CFG4_AHB5CLKEN                               ((uint32_t)0x08000000U)         /* Bit[27] */
#define RCC_CFG4_AHB6CLKEN                               ((uint32_t)0x04000000U)         /* Bit[26] */
#define RCC_CFG4_AXICLKEN                                ((uint32_t)0x00800000U)         /* Bit[23] */
#define RCC_CFG4_APB1CLKEN                               ((uint32_t)0x00400000U)         /* Bit[22] */
#define RCC_CFG4_APB2CLKEN                               ((uint32_t)0x00200000U)         /* Bit[21] */
#define RCC_CFG4_APB5CLKEN                               ((uint32_t)0x00100000U)         /* Bit[20] */
#define RCC_CFG4_APB6CLKEN                               ((uint32_t)0x00080000U)         /* Bit[19] */
#define RCC_CFG4_AHB9CLKEN                               ((uint32_t)0x00040000U)         /* Bit[18] */
#define RCC_CFG4_AXIMM7GCLKEN                            ((uint32_t)0x00020000U)         /* Bit[17] */
#define RCC_CFG4_AXIMM4GCLKEN                            ((uint32_t)0x00010000U)         /* Bit[16] */
#define RCC_CFG4_HSICGEN                                 ((uint32_t)0x00008000U)         /* Bit[15] */
#define RCC_CFG4_HSIKERCGEN                              ((uint32_t)0x00004000U)         /* Bit[14] */
#define RCC_CFG4_HSECGEN                                 ((uint32_t)0x00002000U)         /* Bit[13] */
#define RCC_CFG4_HSEKERCGEN                              ((uint32_t)0x00001000U)         /* Bit[12] */
#define RCC_CFG4_MSICGEN                                 ((uint32_t)0x00000800U)         /* Bit[11] */
#define RCC_CFG4_MSIKERCGEN                              ((uint32_t)0x00000400U)         /* Bit[10] */
#define RCC_CFG4_AXIMM7CLKEN                             ((uint32_t)0x00000100U)         /* Bit[8] */
#define RCC_CFG4_AXIGCLKEN                               ((uint32_t)0x00000080U)         /* Bit[7] */
#define RCC_CFG4_AXIMM4CLKEN                             ((uint32_t)0x00000040U)         /* Bit[6] */
#define RCC_CFG4_DCMUM7CLKEN                             ((uint32_t)0x00000020U)         /* Bit[5] */
#define RCC_CFG4_DCMUM4CLKEN                             ((uint32_t)0x00000010U)         /* Bit[4] */
#define RCC_CFG4_AHBM1CLKEN                              ((uint32_t)0x00000008U)         /* Bit[3] */
#define RCC_CFG4_AHBM2CLKEN                              ((uint32_t)0x00000004U)         /* Bit[2] */
#define RCC_CFG4_AHBM3CLKEN                              ((uint32_t)0x00000002U)         /* Bit[1] */
#define RCC_CFG4_DCMURST                                 ((uint32_t)0x00000001U)         /* Bit[0] */

/******** Bit definition for RCC_CFG5 register  ********/
#define RCC_CFG5_RTCHSEDIV                          ((uint32_t)0x3F000000U)         /* Bit[29:24] */
#define RCC_CFG5_RTCHSEDIV_0                        ((uint32_t)0x01000000U)         /* Bit24*/
#define RCC_CFG5_RTCHSEDIV_1                        ((uint32_t)0x02000000U)         /* Bit25*/
#define RCC_CFG5_RTCHSEDIV_2                        ((uint32_t)0x04000000U)         /* Bit26*/
#define RCC_CFG5_RTCHSEDIV_3                        ((uint32_t)0x08000000U)         /* Bit27*/
#define RCC_CFG5_RTCHSEDIV_4                        ((uint32_t)0x10000000U)         /* Bit28*/
#define RCC_CFG5_RTCHSEDIV_5                        ((uint32_t)0x20000000U)         /* Bit29*/

#define RCC_CFG5_RTCHSEDIV_DIV1                      ((uint32_t)0x01000000U)
#define RCC_CFG5_RTCHSEDIV_DIV2                      ((uint32_t)0x02000000U)
#define RCC_CFG5_RTCHSEDIV_DIV3                      ((uint32_t)0x03000000U)
#define RCC_CFG5_RTCHSEDIV_DIV4                      ((uint32_t)0x04000000U)
#define RCC_CFG5_RTCHSEDIV_DIV5                      ((uint32_t)0x05000000U)
#define RCC_CFG5_RTCHSEDIV_DIV6                      ((uint32_t)0x06000000U)
#define RCC_CFG5_RTCHSEDIV_DIV7                      ((uint32_t)0x07000000U)
#define RCC_CFG5_RTCHSEDIV_DIV8                      ((uint32_t)0x08000000U)
#define RCC_CFG5_RTCHSEDIV_DIV9                      ((uint32_t)0x09000000U)
#define RCC_CFG5_RTCHSEDIV_DIV10                     ((uint32_t)0x0A000000U)
#define RCC_CFG5_RTCHSEDIV_DIV11                     ((uint32_t)0x0B000000U)
#define RCC_CFG5_RTCHSEDIV_DIV12                     ((uint32_t)0x0C000000U)
#define RCC_CFG5_RTCHSEDIV_DIV13                     ((uint32_t)0x0D000000U)
#define RCC_CFG5_RTCHSEDIV_DIV14                     ((uint32_t)0x0E000000U)
#define RCC_CFG5_RTCHSEDIV_DIV15                     ((uint32_t)0x0F000000U)
#define RCC_CFG5_RTCHSEDIV_DIV16                     ((uint32_t)0x10000000U)
#define RCC_CFG5_RTCHSEDIV_DIV17                     ((uint32_t)0x11000000U)
#define RCC_CFG5_RTCHSEDIV_DIV18                     ((uint32_t)0x12000000U)
#define RCC_CFG5_RTCHSEDIV_DIV19                     ((uint32_t)0x13000000U)
#define RCC_CFG5_RTCHSEDIV_DIV20                     ((uint32_t)0x14000000U)
#define RCC_CFG5_RTCHSEDIV_DIV21                     ((uint32_t)0x15000000U)
#define RCC_CFG5_RTCHSEDIV_DIV22                     ((uint32_t)0x16000000U)
#define RCC_CFG5_RTCHSEDIV_DIV23                     ((uint32_t)0x17000000U)
#define RCC_CFG5_RTCHSEDIV_DIV24                     ((uint32_t)0x18000000U)
#define RCC_CFG5_RTCHSEDIV_DIV25                     ((uint32_t)0x19000000U)
#define RCC_CFG5_RTCHSEDIV_DIV26                     ((uint32_t)0x1A000000U)
#define RCC_CFG5_RTCHSEDIV_DIV27                     ((uint32_t)0x1B000000U)
#define RCC_CFG5_RTCHSEDIV_DIV28                     ((uint32_t)0x1C000000U)
#define RCC_CFG5_RTCHSEDIV_DIV29                     ((uint32_t)0x1D000000U)
#define RCC_CFG5_RTCHSEDIV_DIV30                     ((uint32_t)0x1E000000U)
#define RCC_CFG5_RTCHSEDIV_DIV31                     ((uint32_t)0x1F000000U)
#define RCC_CFG5_RTCHSEDIV_DIV32                     ((uint32_t)0x20000000U)
#define RCC_CFG5_RTCHSEDIV_DIV33                     ((uint32_t)0x21000000U)
#define RCC_CFG5_RTCHSEDIV_DIV34                     ((uint32_t)0x22000000U)
#define RCC_CFG5_RTCHSEDIV_DIV35                     ((uint32_t)0x23000000U)
#define RCC_CFG5_RTCHSEDIV_DIV36                     ((uint32_t)0x24000000U)
#define RCC_CFG5_RTCHSEDIV_DIV37                     ((uint32_t)0x25000000U)
#define RCC_CFG5_RTCHSEDIV_DIV38                     ((uint32_t)0x26000000U)
#define RCC_CFG5_RTCHSEDIV_DIV39                     ((uint32_t)0x27000000U)
#define RCC_CFG5_RTCHSEDIV_DIV40                     ((uint32_t)0x28000000U)
#define RCC_CFG5_RTCHSEDIV_DIV41                     ((uint32_t)0x29000000U)
#define RCC_CFG5_RTCHSEDIV_DIV42                     ((uint32_t)0x2A000000U)
#define RCC_CFG5_RTCHSEDIV_DIV43                     ((uint32_t)0x2B000000U)
#define RCC_CFG5_RTCHSEDIV_DIV44                     ((uint32_t)0x2C000000U)
#define RCC_CFG5_RTCHSEDIV_DIV45                     ((uint32_t)0x2D000000U)
#define RCC_CFG5_RTCHSEDIV_DIV46                     ((uint32_t)0x2E000000U)
#define RCC_CFG5_RTCHSEDIV_DIV47                     ((uint32_t)0x2F000000U)
#define RCC_CFG5_RTCHSEDIV_DIV48                     ((uint32_t)0x30000000U)
#define RCC_CFG5_RTCHSEDIV_DIV49                     ((uint32_t)0x31000000U)
#define RCC_CFG5_RTCHSEDIV_DIV50                     ((uint32_t)0x32000000U)
#define RCC_CFG5_RTCHSEDIV_DIV51                     ((uint32_t)0x33000000U)
#define RCC_CFG5_RTCHSEDIV_DIV52                     ((uint32_t)0x34000000U)
#define RCC_CFG5_RTCHSEDIV_DIV53                     ((uint32_t)0x35000000U)
#define RCC_CFG5_RTCHSEDIV_DIV54                     ((uint32_t)0x36000000U)
#define RCC_CFG5_RTCHSEDIV_DIV55                     ((uint32_t)0x37000000U)
#define RCC_CFG5_RTCHSEDIV_DIV56                     ((uint32_t)0x38000000U)
#define RCC_CFG5_RTCHSEDIV_DIV57                     ((uint32_t)0x39000000U)
#define RCC_CFG5_RTCHSEDIV_DIV58                     ((uint32_t)0x3A000000U)
#define RCC_CFG5_RTCHSEDIV_DIV59                     ((uint32_t)0x3B000000U)
#define RCC_CFG5_RTCHSEDIV_DIV60                     ((uint32_t)0x3C000000U)
#define RCC_CFG5_RTCHSEDIV_DIV61                     ((uint32_t)0x3D000000U)
#define RCC_CFG5_RTCHSEDIV_DIV62                     ((uint32_t)0x3E000000U)
#define RCC_CFG5_RTCHSEDIV_DIV63                     ((uint32_t)0x3F000000U)

#define RCC_CFG5_M7SRAM5EN                               ((uint32_t)0x00800000U)         /* Bit[23] */
#define RCC_CFG5_M4SRAM5EN                               ((uint32_t)0x00400000U)         /* Bit[22] */
#define RCC_CFG5_M7SRAM5LPEN                             ((uint32_t)0x00200000U)         /* Bit[21] */
#define RCC_CFG5_M4SRAM5LPEN                             ((uint32_t)0x00100000U)         /* Bit[20] */
#define RCC_CFG5_DCDCLKEN                                ((uint32_t)0x00010000U)         /* Bit[16] */
#define RCC_CFG5_TRNGEN                                  ((uint32_t)0x00002000U)         /* Bit[13] */
#define RCC_CFG5_TRNGSEL                                 ((uint32_t)0x00001000U)         /* Bit[12] */

#define RCC_CFG5_TRNGDIV                            ((uint32_t)0x00000F00U)         /* Bit[11:8] */
#define RCC_CFG5_TRNGDIV_0                          ((uint32_t)0x00000100U)         /* Bit8*/
#define RCC_CFG5_TRNGDIV_1                          ((uint32_t)0x00000200U)         /* Bit9*/
#define RCC_CFG5_TRNGDIV_2                          ((uint32_t)0x00000400U)         /* Bit10*/
#define RCC_CFG5_TRNGDIV_3                          ((uint32_t)0x00000800U)         /* Bit11*/

#define RCC_CFG5_TRNGDIV_DIV1                       ((uint32_t)0x00000000U)
#define RCC_CFG5_TRNGDIV_DIV2                       ((uint32_t)0x00000100U)
#define RCC_CFG5_TRNGDIV_DIV4                       ((uint32_t)0x00000200U)
#define RCC_CFG5_TRNGDIV_DIV8                       ((uint32_t)0x00000400U)
#define RCC_CFG5_TRNGDIV_DIV16                      ((uint32_t)0x00000700U)
#define RCC_CFG5_TRNGDIV_DIV32                      ((uint32_t)0x00000800U)
#define RCC_CFG5_TRNGDIV_DIV64                      ((uint32_t)0x00000900U)
#define RCC_CFG5_TRNGDIV_DIV128                     ((uint32_t)0x00000A00U)
#define RCC_CFG5_TRNGDIV_DIV256                     ((uint32_t)0x00000B00U)
#define RCC_CFG5_TRNGDIV_DIV512                     ((uint32_t)0x00000C00U)

#define RCC_CFG5_DSIHSEDIV                          ((uint32_t)0x000000F0U)         /* Bit[7:4] */
#define RCC_CFG5_DSIHSEDIV_0                        ((uint32_t)0x00000010U)         /* Bit4*/
#define RCC_CFG5_DSIHSEDIV_1                        ((uint32_t)0x00000020U)         /* Bit5*/
#define RCC_CFG5_DSIHSEDIV_2                        ((uint32_t)0x00000040U)         /* Bit6*/
#define RCC_CFG5_DSIHSEDIV_3                        ((uint32_t)0x00000080U)         /* Bit7*/

#define RCC_CFG5_RTCHSIDIV                          ((uint32_t)0x0000000FU)         /* Bit */
#define RCC_CFG5_RTCHSIDIV_0                        ((uint32_t)0x00000001U)         /* Bit0*/
#define RCC_CFG5_RTCHSIDIV_1                        ((uint32_t)0x00000002U)         /* Bit1*/
#define RCC_CFG5_RTCHSIDIV_2                        ((uint32_t)0x00000004U)         /* Bit2*/
#define RCC_CFG5_RTCHSIDIV_3                        ((uint32_t)0x00000008U)         /* Bit3*/

#define RCC_CFG5_RTCHSIDIV_DIV1                     ((uint32_t)0x00000000U)
#define RCC_CFG5_RTCHSIDIV_DIV2                     ((uint32_t)0x00000001U)
#define RCC_CFG5_RTCHSIDIV_DIV4                     ((uint32_t)0x00000002U)
#define RCC_CFG5_RTCHSIDIV_DIV8                     ((uint32_t)0x00000004U)
#define RCC_CFG5_RTCHSIDIV_DIV16                    ((uint32_t)0x00000007U)
#define RCC_CFG5_RTCHSIDIV_DIV32                    ((uint32_t)0x00000008U)
#define RCC_CFG5_RTCHSIDIV_DIV64                    ((uint32_t)0x00000009U)
#define RCC_CFG5_RTCHSIDIV_DIV128                   ((uint32_t)0x0000000AU)
#define RCC_CFG5_RTCHSIDIV_DIV256                   ((uint32_t)0x0000000BU)
#define RCC_CFG5_RTCHSIDIV_DIV512                   ((uint32_t)0x0000000CU)
/******** Bit definition for RCC_M4RSTREL register  ********/
#define RCC_M4RSTREL_EN                                      ((uint32_t)0x00000001U)         /* Bit[0] */

/******** Bit definition for RCC_LSERDDL register  ********/
#define RCC_LSERDDL_DELAY                             ((uint32_t)0xFFFFFFFFU)         /* Bit */
#define RCC_LSERDDL_DELAY_0                           ((uint32_t)0x00000001U)         /* Bit0*/
#define RCC_LSERDDL_DELAY_1                           ((uint32_t)0x00000002U)         /* Bit1*/
#define RCC_LSERDDL_DELAY_2                           ((uint32_t)0x00000004U)         /* Bit2*/
#define RCC_LSERDDL_DELAY_3                           ((uint32_t)0x00000008U)         /* Bit3*/
#define RCC_LSERDDL_DELAY_4                           ((uint32_t)0x00000010U)         /* Bit4*/
#define RCC_LSERDDL_DELAY_5                           ((uint32_t)0x00000020U)         /* Bit5*/
#define RCC_LSERDDL_DELAY_6                           ((uint32_t)0x00000040U)         /* Bit6*/
#define RCC_LSERDDL_DELAY_7                           ((uint32_t)0x00000080U)         /* Bit7*/
#define RCC_LSERDDL_DELAY_8                           ((uint32_t)0x00000100U)         /* Bit8*/
#define RCC_LSERDDL_DELAY_9                           ((uint32_t)0x00000200U)         /* Bit9*/
#define RCC_LSERDDL_DELAY_10                          ((uint32_t)0x00000400U)         /* Bit10*/
#define RCC_LSERDDL_DELAY_11                          ((uint32_t)0x00000800U)         /* Bit11*/
#define RCC_LSERDDL_DELAY_12                          ((uint32_t)0x00001000U)         /* Bit12*/
#define RCC_LSERDDL_DELAY_13                          ((uint32_t)0x00002000U)         /* Bit13*/
#define RCC_LSERDDL_DELAY_14                          ((uint32_t)0x00004000U)         /* Bit14*/
#define RCC_LSERDDL_DELAY_15                          ((uint32_t)0x00008000U)         /* Bit15*/
#define RCC_LSERDDL_DELAY_16                          ((uint32_t)0x00010000U)         /* Bit16*/
#define RCC_LSERDDL_DELAY_17                          ((uint32_t)0x00020000U)         /* Bit17*/
#define RCC_LSERDDL_DELAY_18                          ((uint32_t)0x00040000U)         /* Bit18*/
#define RCC_LSERDDL_DELAY_19                          ((uint32_t)0x00080000U)         /* Bit19*/
#define RCC_LSERDDL_DELAY_20                          ((uint32_t)0x00100000U)         /* Bit20*/
#define RCC_LSERDDL_DELAY_21                          ((uint32_t)0x00200000U)         /* Bit21*/
#define RCC_LSERDDL_DELAY_22                          ((uint32_t)0x00400000U)         /* Bit22*/
#define RCC_LSERDDL_DELAY_23                          ((uint32_t)0x00800000U)         /* Bit23*/
#define RCC_LSERDDL_DELAY_24                          ((uint32_t)0x01000000U)         /* Bit24*/
#define RCC_LSERDDL_DELAY_25                          ((uint32_t)0x02000000U)         /* Bit25*/
#define RCC_LSERDDL_DELAY_26                          ((uint32_t)0x04000000U)         /* Bit26*/
#define RCC_LSERDDL_DELAY_27                          ((uint32_t)0x08000000U)         /* Bit27*/
#define RCC_LSERDDL_DELAY_28                          ((uint32_t)0x10000000U)         /* Bit28*/
#define RCC_LSERDDL_DELAY_29                          ((uint32_t)0x20000000U)         /* Bit29*/
#define RCC_LSERDDL_DELAY_30                          ((uint32_t)0x40000000U)         /* Bit30*/
#define RCC_LSERDDL_DELAY_31                          ((uint32_t)0x80000000U)         /* Bit31*/

/******** Bit definition for RCC_MSIRDDL register  ********/
#define RCC_MSIRDDL_DELAY                             ((uint32_t)0xFFFFFFFFU)         /* Bit */
#define RCC_MSIRDDL_DELAY_0                           ((uint32_t)0x00000001U)         /* Bit0*/
#define RCC_MSIRDDL_DELAY_1                           ((uint32_t)0x00000002U)         /* Bit1*/
#define RCC_MSIRDDL_DELAY_2                           ((uint32_t)0x00000004U)         /* Bit2*/
#define RCC_MSIRDDL_DELAY_3                           ((uint32_t)0x00000008U)         /* Bit3*/
#define RCC_MSIRDDL_DELAY_4                           ((uint32_t)0x00000010U)         /* Bit4*/
#define RCC_MSIRDDL_DELAY_5                           ((uint32_t)0x00000020U)         /* Bit5*/
#define RCC_MSIRDDL_DELAY_6                           ((uint32_t)0x00000040U)         /* Bit6*/
#define RCC_MSIRDDL_DELAY_7                           ((uint32_t)0x00000080U)         /* Bit7*/
#define RCC_MSIRDDL_DELAY_8                           ((uint32_t)0x00000100U)         /* Bit8*/
#define RCC_MSIRDDL_DELAY_9                           ((uint32_t)0x00000200U)         /* Bit9*/
#define RCC_MSIRDDL_DELAY_10                          ((uint32_t)0x00000400U)         /* Bit10*/
#define RCC_MSIRDDL_DELAY_11                          ((uint32_t)0x00000800U)         /* Bit11*/
#define RCC_MSIRDDL_DELAY_12                          ((uint32_t)0x00001000U)         /* Bit12*/
#define RCC_MSIRDDL_DELAY_13                          ((uint32_t)0x00002000U)         /* Bit13*/
#define RCC_MSIRDDL_DELAY_14                          ((uint32_t)0x00004000U)         /* Bit14*/
#define RCC_MSIRDDL_DELAY_15                          ((uint32_t)0x00008000U)         /* Bit15*/
#define RCC_MSIRDDL_DELAY_16                          ((uint32_t)0x00010000U)         /* Bit16*/
#define RCC_MSIRDDL_DELAY_17                          ((uint32_t)0x00020000U)         /* Bit17*/
#define RCC_MSIRDDL_DELAY_18                          ((uint32_t)0x00040000U)         /* Bit18*/
#define RCC_MSIRDDL_DELAY_19                          ((uint32_t)0x00080000U)         /* Bit19*/
#define RCC_MSIRDDL_DELAY_20                          ((uint32_t)0x00100000U)         /* Bit20*/
#define RCC_MSIRDDL_DELAY_21                          ((uint32_t)0x00200000U)         /* Bit21*/
#define RCC_MSIRDDL_DELAY_22                          ((uint32_t)0x00400000U)         /* Bit22*/
#define RCC_MSIRDDL_DELAY_23                          ((uint32_t)0x00800000U)         /* Bit23*/
#define RCC_MSIRDDL_DELAY_24                          ((uint32_t)0x01000000U)         /* Bit24*/
#define RCC_MSIRDDL_DELAY_25                          ((uint32_t)0x02000000U)         /* Bit25*/
#define RCC_MSIRDDL_DELAY_26                          ((uint32_t)0x04000000U)         /* Bit26*/
#define RCC_MSIRDDL_DELAY_27                          ((uint32_t)0x08000000U)         /* Bit27*/
#define RCC_MSIRDDL_DELAY_28                          ((uint32_t)0x10000000U)         /* Bit28*/
#define RCC_MSIRDDL_DELAY_29                          ((uint32_t)0x20000000U)         /* Bit29*/
#define RCC_MSIRDDL_DELAY_30                          ((uint32_t)0x40000000U)         /* Bit30*/
#define RCC_MSIRDDL_DELAY_31                          ((uint32_t)0x80000000U)         /* Bit31*/

/******** Bit definition for RCC_HSERDDL register  ********/
#define RCC_HSERDDL_DELAY                             ((uint32_t)0xFFFFFFFFU)         /* Bit */
#define RCC_HSERDDL_DELAY_0                           ((uint32_t)0x00000001U)         /* Bit0*/
#define RCC_HSERDDL_DELAY_1                           ((uint32_t)0x00000002U)         /* Bit1*/
#define RCC_HSERDDL_DELAY_2                           ((uint32_t)0x00000004U)         /* Bit2*/
#define RCC_HSERDDL_DELAY_3                           ((uint32_t)0x00000008U)         /* Bit3*/
#define RCC_HSERDDL_DELAY_4                           ((uint32_t)0x00000010U)         /* Bit4*/
#define RCC_HSERDDL_DELAY_5                           ((uint32_t)0x00000020U)         /* Bit5*/
#define RCC_HSERDDL_DELAY_6                           ((uint32_t)0x00000040U)         /* Bit6*/
#define RCC_HSERDDL_DELAY_7                           ((uint32_t)0x00000080U)         /* Bit7*/
#define RCC_HSERDDL_DELAY_8                           ((uint32_t)0x00000100U)         /* Bit8*/
#define RCC_HSERDDL_DELAY_9                           ((uint32_t)0x00000200U)         /* Bit9*/
#define RCC_HSERDDL_DELAY_10                          ((uint32_t)0x00000400U)         /* Bit10*/
#define RCC_HSERDDL_DELAY_11                          ((uint32_t)0x00000800U)         /* Bit11*/
#define RCC_HSERDDL_DELAY_12                          ((uint32_t)0x00001000U)         /* Bit12*/
#define RCC_HSERDDL_DELAY_13                          ((uint32_t)0x00002000U)         /* Bit13*/
#define RCC_HSERDDL_DELAY_14                          ((uint32_t)0x00004000U)         /* Bit14*/
#define RCC_HSERDDL_DELAY_15                          ((uint32_t)0x00008000U)         /* Bit15*/
#define RCC_HSERDDL_DELAY_16                          ((uint32_t)0x00010000U)         /* Bit16*/
#define RCC_HSERDDL_DELAY_17                          ((uint32_t)0x00020000U)         /* Bit17*/
#define RCC_HSERDDL_DELAY_18                          ((uint32_t)0x00040000U)         /* Bit18*/
#define RCC_HSERDDL_DELAY_19                          ((uint32_t)0x00080000U)         /* Bit19*/
#define RCC_HSERDDL_DELAY_20                          ((uint32_t)0x00100000U)         /* Bit20*/
#define RCC_HSERDDL_DELAY_21                          ((uint32_t)0x00200000U)         /* Bit21*/
#define RCC_HSERDDL_DELAY_22                          ((uint32_t)0x00400000U)         /* Bit22*/
#define RCC_HSERDDL_DELAY_23                          ((uint32_t)0x00800000U)         /* Bit23*/
#define RCC_HSERDDL_DELAY_24                          ((uint32_t)0x01000000U)         /* Bit24*/
#define RCC_HSERDDL_DELAY_25                          ((uint32_t)0x02000000U)         /* Bit25*/
#define RCC_HSERDDL_DELAY_26                          ((uint32_t)0x04000000U)         /* Bit26*/
#define RCC_HSERDDL_DELAY_27                          ((uint32_t)0x08000000U)         /* Bit27*/
#define RCC_HSERDDL_DELAY_28                          ((uint32_t)0x10000000U)         /* Bit28*/
#define RCC_HSERDDL_DELAY_29                          ((uint32_t)0x20000000U)         /* Bit29*/
#define RCC_HSERDDL_DELAY_30                          ((uint32_t)0x40000000U)         /* Bit30*/
#define RCC_HSERDDL_DELAY_31                          ((uint32_t)0x80000000U)         /* Bit31*/

/******** Bit definition for RCC_PLLSFTLK register  ********/
#define RCC_PLLSFTLK_SDRAMDLSEL                         ((uint32_t)0x1E000000U)         /* Bit[28:25] */
#define RCC_PLLSFTLK_SDRAMDLSEL_0                       ((uint32_t)0x02000000U)         /* Bit25*/
#define RCC_PLLSFTLK_SDRAMDLSEL_1                       ((uint32_t)0x04000000U)         /* Bit26*/
#define RCC_PLLSFTLK_SDRAMDLSEL_2                       ((uint32_t)0x08000000U)         /* Bit27*/
#define RCC_PLLSFTLK_SDRAMDLSEL_3                       ((uint32_t)0x10000000U)         /* Bit28*/

#define RCC_PLLSFTLK_SDRAMDLSEL_0_2NS                ((uint32_t)0x00000000U)
#define RCC_PLLSFTLK_SDRAMDLSEL_0_4NS                ((uint32_t)0x02000000U)
#define RCC_PLLSFTLK_SDRAMDLSEL_0_6NS                ((uint32_t)0x04000000U)
#define RCC_PLLSFTLK_SDRAMDLSEL_0_8NS                ((uint32_t)0x06000000U)
#define RCC_PLLSFTLK_SDRAMDLSEL_1_0NS                ((uint32_t)0x08000000U)
#define RCC_PLLSFTLK_SDRAMDLSEL_1_2NS                ((uint32_t)0x0A000000U)
#define RCC_PLLSFTLK_SDRAMDLSEL_1_4NS                ((uint32_t)0x0C000000U)
#define RCC_PLLSFTLK_SDRAMDLSEL_1_6NS                ((uint32_t)0x0E000000U)
#define RCC_PLLSFTLK_SDRAMDLSEL_1_8NS                ((uint32_t)0x10000000U)
#define RCC_PLLSFTLK_SDRAMDLSEL_2_0NS                ((uint32_t)0x12000000U)
#define RCC_PLLSFTLK_SDRAMDLSEL_2_2NS                ((uint32_t)0x14000000U)
#define RCC_PLLSFTLK_SDRAMDLSEL_2_4NS                ((uint32_t)0x16000000U)
#define RCC_PLLSFTLK_SDRAMDLSEL_2_6NS                ((uint32_t)0x18000000U)
#define RCC_PLLSFTLK_SDRAMDLSEL_2_8NS                ((uint32_t)0x1A000000U)
#define RCC_PLLSFTLK_SDRAMDLSEL_3_0NS                ((uint32_t)0x1C000000U)
#define RCC_PLLSFTLK_SDRAMDLSEL_3_2NS                ((uint32_t)0x1E000000U)

#define RCC_PLLSFTLK_SDRAMDLEN                               ((uint32_t)0x01000000U)         /* Bit[24] */
#define RCC_PLLSFTLK_SHRTIMAFERST                            ((uint32_t)0x00000020U)         /* Bit[5] */
#define RCC_PLLSFTLK_SHRPLLSFTLK                             ((uint32_t)0x00000008U)         /* Bit[3] */
#define RCC_PLLSFTLK_PLL3SFTLK                               ((uint32_t)0x00000004U)         /* Bit[2] */
#define RCC_PLLSFTLK_PLL2SFTLK                               ((uint32_t)0x00000002U)         /* Bit[1] */
#define RCC_PLLSFTLK_PLL1SFTLK                               ((uint32_t)0x00000001U)         /* Bit[0] */

/******** Bit definition for RCC_HSEOS register  ********/
#define RCC_HSEOS_HSEMAXPDTHR                        ((uint32_t)0xFF000000U)         /* Bit[31:24] */
#define RCC_HSEOS_HSEMAXPDTHR_0                      ((uint32_t)0x01000000U)         /* Bit24*/
#define RCC_HSEOS_HSEMAXPDTHR_1                      ((uint32_t)0x02000000U)         /* Bit25*/
#define RCC_HSEOS_HSEMAXPDTHR_2                      ((uint32_t)0x04000000U)         /* Bit26*/
#define RCC_HSEOS_HSEMAXPDTHR_3                      ((uint32_t)0x08000000U)         /* Bit27*/
#define RCC_HSEOS_HSEMAXPDTHR_4                      ((uint32_t)0x10000000U)         /* Bit28*/
#define RCC_HSEOS_HSEMAXPDTHR_5                      ((uint32_t)0x20000000U)         /* Bit29*/
#define RCC_HSEOS_HSEMAXPDTHR_6                      ((uint32_t)0x40000000U)         /* Bit30*/
#define RCC_HSEOS_HSEMAXPDTHR_7                      ((uint32_t)0x80000000U)         /* Bit31*/
#define RCC_HSEOS_HSEMINNDTHR                        ((uint32_t)0x00FF0000U)         /* Bit[23:16] */
#define RCC_HSEOS_HSEMINNDTHR_0                      ((uint32_t)0x00010000U)         /* Bit16*/
#define RCC_HSEOS_HSEMINNDTHR_1                      ((uint32_t)0x00020000U)         /* Bit17*/
#define RCC_HSEOS_HSEMINNDTHR_2                      ((uint32_t)0x00040000U)         /* Bit18*/
#define RCC_HSEOS_HSEMINNDTHR_3                      ((uint32_t)0x00080000U)         /* Bit19*/
#define RCC_HSEOS_HSEMINNDTHR_4                      ((uint32_t)0x00100000U)         /* Bit20*/
#define RCC_HSEOS_HSEMINNDTHR_5                      ((uint32_t)0x00200000U)         /* Bit21*/
#define RCC_HSEOS_HSEMINNDTHR_6                      ((uint32_t)0x00400000U)         /* Bit22*/
#define RCC_HSEOS_HSEMINNDTHR_7                      ((uint32_t)0x00800000U)         /* Bit23*/
#define RCC_HSEOS_HSEOSTHR                           ((uint32_t)0x0000FF00U)         /* Bit[15:8] */
#define RCC_HSEOS_HSEOSTHR_0                         ((uint32_t)0x00000100U)         /* Bit8*/
#define RCC_HSEOS_HSEOSTHR_1                         ((uint32_t)0x00000200U)         /* Bit9*/
#define RCC_HSEOS_HSEOSTHR_2                         ((uint32_t)0x00000400U)         /* Bit10*/
#define RCC_HSEOS_HSEOSTHR_3                         ((uint32_t)0x00000800U)         /* Bit11*/
#define RCC_HSEOS_HSEOSTHR_4                         ((uint32_t)0x00001000U)         /* Bit12*/
#define RCC_HSEOS_HSEOSTHR_5                         ((uint32_t)0x00002000U)         /* Bit13*/
#define RCC_HSEOS_HSEOSTHR_6                         ((uint32_t)0x00004000U)         /* Bit14*/
#define RCC_HSEOS_HSEOSTHR_7                         ((uint32_t)0x00008000U)         /* Bit15*/
#define RCC_HSEOS_HSEMAXPDF                               ((uint32_t)0x00000040U)         /* Bit[6] */
#define RCC_HSEOS_HSEMINNDF                               ((uint32_t)0x00000020U)         /* Bit[5] */
#define RCC_HSEOS_HSEOSF                                  ((uint32_t)0x00000010U)         /* Bit[4] */
#define RCC_HSEOS_HSEMAXPDEN                              ((uint32_t)0x00000004U)         /* Bit[2] */
#define RCC_HSEOS_HSEMINNDEN                              ((uint32_t)0x00000002U)         /* Bit[1] */
#define RCC_HSEOS_HSEOSEN                                 ((uint32_t)0x00000001U)         /* Bit[0] */

/******** Bit definition for RCC_HSECAL register  ********/
#define RCC_HSECAL_HSECALCNTEN                             ((uint32_t)0x00020000U)         /* Bit[17] */
#define RCC_HSECAL_HSECALCNTF                              ((uint32_t)0x00010000U)         /* Bit[16] */
#define RCC_HSECAL_HSECALCNT                         ((uint32_t)0x0000FFFFU)         /* Bit[15:0] */
#define RCC_HSECAL_HSECALCNT_0                       ((uint32_t)0x00000001U)         /* Bit0*/
#define RCC_HSECAL_HSECALCNT_1                       ((uint32_t)0x00000002U)         /* Bit1*/
#define RCC_HSECAL_HSECALCNT_2                       ((uint32_t)0x00000004U)         /* Bit2*/
#define RCC_HSECAL_HSECALCNT_3                       ((uint32_t)0x00000008U)         /* Bit3*/
#define RCC_HSECAL_HSECALCNT_4                       ((uint32_t)0x00000010U)         /* Bit4*/
#define RCC_HSECAL_HSECALCNT_5                       ((uint32_t)0x00000020U)         /* Bit5*/
#define RCC_HSECAL_HSECALCNT_6                       ((uint32_t)0x00000040U)         /* Bit6*/
#define RCC_HSECAL_HSECALCNT_7                       ((uint32_t)0x00000080U)         /* Bit7*/
#define RCC_HSECAL_HSECALCNT_8                       ((uint32_t)0x00000100U)         /* Bit8*/
#define RCC_HSECAL_HSECALCNT_9                       ((uint32_t)0x00000200U)         /* Bit9*/
#define RCC_HSECAL_HSECALCNT_10                      ((uint32_t)0x00000400U)         /* Bit10*/
#define RCC_HSECAL_HSECALCNT_11                      ((uint32_t)0x00000800U)         /* Bit11*/
#define RCC_HSECAL_HSECALCNT_12                      ((uint32_t)0x00001000U)         /* Bit12*/
#define RCC_HSECAL_HSECALCNT_13                      ((uint32_t)0x00002000U)         /* Bit13*/
#define RCC_HSECAL_HSECALCNT_14                      ((uint32_t)0x00004000U)         /* Bit14*/
#define RCC_HSECAL_HSECALCNT_15                      ((uint32_t)0x00008000U)         /* Bit15*/

/******** Bit definition for RCC_LSEOS register  ********/
#define RCC_LSEOS_LSECALCNTEN                             ((uint32_t)0x02000000U)         /* Bit[25] */
#define RCC_LSEOS_LSECALCNTF                              ((uint32_t)0x01000000U)         /* Bit[24] */
#define RCC_LSEOS_LSECALCNT                          ((uint32_t)0x00FF0000U)         /* Bit[23:16] */
#define RCC_LSEOS_LSECALCNT_0                        ((uint32_t)0x00010000U)         /* Bit16*/
#define RCC_LSEOS_LSECALCNT_1                        ((uint32_t)0x00020000U)         /* Bit17*/
#define RCC_LSEOS_LSECALCNT_2                        ((uint32_t)0x00040000U)         /* Bit18*/
#define RCC_LSEOS_LSECALCNT_3                        ((uint32_t)0x00080000U)         /* Bit19*/
#define RCC_LSEOS_LSECALCNT_4                        ((uint32_t)0x00100000U)         /* Bit20*/
#define RCC_LSEOS_LSECALCNT_5                        ((uint32_t)0x00200000U)         /* Bit21*/
#define RCC_LSEOS_LSECALCNT_6                        ((uint32_t)0x00400000U)         /* Bit22*/
#define RCC_LSEOS_LSECALCNT_7                        ((uint32_t)0x00800000U)         /* Bit23*/
#define RCC_LSEOS_LSEOSF                                  ((uint32_t)0x00000200U)         /* Bit[9] */
#define RCC_LSEOS_LSEOSEN                                 ((uint32_t)0x00000100U)         /* Bit[8] */
#define RCC_LSEOS_LSEOSTHR                           ((uint32_t)0x000000FFU)         /* Bit */
#define RCC_LSEOS_LSEOSTHR_0                         ((uint32_t)0x00000001U)         /* Bit0*/
#define RCC_LSEOS_LSEOSTHR_1                         ((uint32_t)0x00000002U)         /* Bit1*/
#define RCC_LSEOS_LSEOSTHR_2                         ((uint32_t)0x00000004U)         /* Bit2*/
#define RCC_LSEOS_LSEOSTHR_3                         ((uint32_t)0x00000008U)         /* Bit3*/
#define RCC_LSEOS_LSEOSTHR_4                         ((uint32_t)0x00000010U)         /* Bit4*/
#define RCC_LSEOS_LSEOSTHR_5                         ((uint32_t)0x00000020U)         /* Bit5*/
#define RCC_LSEOS_LSEOSTHR_6                         ((uint32_t)0x00000040U)         /* Bit6*/
#define RCC_LSEOS_LSEOSTHR_7                         ((uint32_t)0x00000080U)         /* Bit7*/

/******** Bit definition for RCC_PLLFD register  ********/
#define RCC_PLLFD_SHRPLLGF                                ((uint32_t)0x00000800U)         /* Bit[11] */
#define RCC_PLLFD_PLL3GF                                  ((uint32_t)0x00000400U)         /* Bit[10] */
#define RCC_PLLFD_PLL2GF                                  ((uint32_t)0x00000200U)         /* Bit[9] */
#define RCC_PLLFD_PLL1GF                                  ((uint32_t)0x00000100U)         /* Bit[8] */
#define RCC_PLLFD_SHRPLLFF                                ((uint32_t)0x00000080U)         /* Bit[7] */
#define RCC_PLLFD_PLL3FF                                  ((uint32_t)0x00000040U)         /* Bit[6] */
#define RCC_PLLFD_PLL2FF                                  ((uint32_t)0x00000020U)         /* Bit[5] */
#define RCC_PLLFD_PLL1FF                                  ((uint32_t)0x00000010U)         /* Bit[4] */
#define RCC_PLLFD_SHRPLLFEN                               ((uint32_t)0x00000008U)         /* Bit[3] */
#define RCC_PLLFD_PLL3FEN                                 ((uint32_t)0x00000004U)         /* Bit[2] */
#define RCC_PLLFD_PLL2FEN                                 ((uint32_t)0x00000002U)         /* Bit[1] */
#define RCC_PLLFD_PLL1FEN                                 ((uint32_t)0x00000001U)         /* Bit[0] */


/*** Power Control   ***/

/******** Bit definition for PWR_M7CTRL1 register  ********/
#define PWR_M7CTRL1_CVBATF                                    ((uint32_t)0x00010000U)         /* Bit[16] Clear VBAT flags*/
#define PWR_M7CTRL1_CSBF                                      ((uint32_t)0x00000008U)         /* Bit[3] Clear STANDBY flags*/
#define PWR_M7CTRL1_CWKUPF                                    ((uint32_t)0x00000004U)         /* Bit[2] Clear the pin wakeup bit*/
#define PWR_M7CTRL1_PDS                                       ((uint32_t)0x00000002U)         /* Bit[1] Power down deep sleep bit*/

/******** Bit definition for PWR_M7CTRLSTS register  ********/
#define PWR_M7CTRLSTS_WKUPxF_MASK                             ((uint32_t)0x07F00000U)         /* Bit[26:20] WKUPx pin wakeup flag*/
#define PWR_M7CTRLSTS_WKUP0F                                  ((uint32_t)0x00100000U)         /* Bit20*/
#define PWR_M7CTRLSTS_WKUP1F                                  ((uint32_t)0x00200000U)         /* Bit21*/
#define PWR_M7CTRLSTS_WKUP2F                                  ((uint32_t)0x00400000U)         /* Bit22*/
#define PWR_M7CTRLSTS_WKUP3F                                  ((uint32_t)0x00800000U)         /* Bit23*/
#define PWR_M7CTRLSTS_WKUP4F                                  ((uint32_t)0x01000000U)         /* Bit24*/
#define PWR_M7CTRLSTS_WKUP5F                                  ((uint32_t)0x02000000U)         /* Bit25*/
#define PWR_M7CTRLSTS_WKUP6F                                  ((uint32_t)0x04000000U)         /* Bit26*/

#define PWR_M7CTRLSTS_WKUPxPOL_MASK                           ((uint32_t)0x000FC000U)         /* Bit[19:14] Wake-up polarity for the WKUPx pin*/
#define PWR_M7CTRLSTS_WKUP0POL                                ((uint32_t)0x00004000U)         /* Bit14*/
#define PWR_M7CTRLSTS_WKUP1POL                                ((uint32_t)0x00008000U)         /* Bit15*/
#define PWR_M7CTRLSTS_WKUP2POL                                ((uint32_t)0x00010000U)         /* Bit16*/
#define PWR_M7CTRLSTS_WKUP3POL                                ((uint32_t)0x00020000U)         /* Bit17*/
#define PWR_M7CTRLSTS_WKUP4POL                                ((uint32_t)0x00040000U)         /* Bit18*/
#define PWR_M7CTRLSTS_WKUP5POL                                ((uint32_t)0x00080000U)         /* Bit19*/

#define PWR_M7CTRLSTS_WKUPxEN_MASK                            ((uint32_t)0x00003F00U)         /* Bit[13:8] WKUPx pin wakeup enable*/
#define PWR_M7CTRLSTS_WKUP0EN                                 ((uint32_t)0x00000100U)         /* Bit8*/
#define PWR_M7CTRLSTS_WKUP1EN                                 ((uint32_t)0x00000200U)         /* Bit9*/
#define PWR_M7CTRLSTS_WKUP2EN                                 ((uint32_t)0x00000400U)         /* Bit10*/
#define PWR_M7CTRLSTS_WKUP3EN                                 ((uint32_t)0x00000800U)         /* Bit11*/
#define PWR_M7CTRLSTS_WKUP4EN                                 ((uint32_t)0x00001000U)         /* Bit12*/
#define PWR_M7CTRLSTS_WKUP5EN                                 ((uint32_t)0x00002000U)         /* Bit13*/

#define PWR_M7CTRLSTS_VBATF                                   ((uint32_t)0x00000004U)         /* Bit[2] VBAT flag*/
#define PWR_M7CTRLSTS_SBF                                     ((uint32_t)0x00000002U)         /* Bit[1] STANDBY flag*/

/******** Bit definition for PWR_M7CTRL2 register  ********/
#define PWR_M7CTRL2_MEM_CNTVAL                                ((uint32_t)0x7E000000U)         /* Bit[30:25] counter value for memory power ready count down*/

#define PWR_M7CTRL2_PWR_CNTVAL                                ((uint32_t)0x01FE0000U)         /* Bit[24:17] counter value for CM7 logic power ready count down*/

#define PWR_M7CTRL2_TCM_RDYMD                                 ((uint32_t)0x00018000U)         /* Bit[16:15] Selected the way of check TCM power ready for CM7 domain*/
#define PWR_M7CTRL2_TCM_RDYMD_0                               ((uint32_t)0x00008000U)         /* Bit15*/
#define PWR_M7CTRL2_TCM_RDYMD_1                               ((uint32_t)0x00010000U)         /* Bit16*/

#define PWR_M7CTRL2_PWR_RDYMD                                 ((uint32_t)0x00006000U)         /* Bit[14:13] Selected the way of check power ready for CM7 domain*/
#define PWR_M7CTRL2_PWR_RDYMD_0                               ((uint32_t)0x00002000U)         /* Bit13*/
#define PWR_M7CTRL2_PWR_RDYMD_1                               ((uint32_t)0x00004000U)         /* Bit14*/

#define PWR_M7CTRL2_HCLK_ONINSLP                              ((uint32_t)0x00001000U)         /* Bit[12] HCLK is on when M7 core in sleep*/
#define PWR_M7CTRL2_NRST_WUPEN                                ((uint32_t)0x00000800U)         /* Bit[11] NRST wakeup event enable in standby mode for M7 core*/
#define PWR_M7CTRL2_RET_PSWACK1                               ((uint32_t)0x00000400U)         /* Bit[10] M7 retention power switch ACK1 used as ENA2 enanle for dual-input-header*/
#define PWR_M7CTRL2_DMN_PSWACK1                               ((uint32_t)0x00000200U)         /* Bit[9] M7 Domain power switch ACK1 used as ENA2 enanle for dual-input-header*/
#define PWR_M7CTRL2_RTC_ALMWUPEN                              ((uint32_t)0x00000100U)         /* Bit[8] RTC_ALARM wakeup enable in standby mode for M7 core*/
#define PWR_M7CTRL2_BSRSTBRET                                 ((uint32_t)0x00000004U)         /* Bit[2] Backup SRAM retention enable in STANDBY mode*/
#define PWR_M7CTRL2_BSRVBRET                                  ((uint32_t)0x00000002U)         /* Bit[1] Backup SRAM retention enable in VBAT mode*/
#define PWR_M7CTRL2_STOP2EN                                   ((uint32_t)0x00000001U)         /* Bit[0] M7 core STOP2 mode enable*/

/******** Bit definition for PWR_M4CTRL1 register  ********/
#define PWR_M4CTRL1_CVBATF                                    ((uint32_t)0x00010000U)         /* Bit[16] Clear VBAT flags*/
#define PWR_M4CTRL1_CSBVBF                                    ((uint32_t)0x00000008U)         /* Bit[3] Clear STANDBY flags*/
#define PWR_M4CTRL1_CWKUPF                                    ((uint32_t)0x00000004U)         /* Bit[2] Clear the pin wakeup bit*/
#define PWR_M4CTRL1_PDS                                       ((uint32_t)0x00000002U)         /* Bit[1] Power down deep sleep bit*/

/******** Bit definition for PWR_M4CTRLSTS register  ********/
#define PWR_M4CTRLSTS_WKUPxF_MASK                             ((uint32_t)0x07F00000U)         /* Bit[26:20] WKUP pin flag*/
#define PWR_M4CTRLSTS_WKUP0F                                  ((uint32_t)0x00100000U)         /* Bit20*/
#define PWR_M4CTRLSTS_WKUP1F                                  ((uint32_t)0x00200000U)         /* Bit21*/
#define PWR_M4CTRLSTS_WKUP2F                                  ((uint32_t)0x00400000U)         /* Bit22*/
#define PWR_M4CTRLSTS_WKUP3F                                  ((uint32_t)0x00800000U)         /* Bit23*/
#define PWR_M4CTRLSTS_WKUP4F                                  ((uint32_t)0x01000000U)         /* Bit24*/
#define PWR_M4CTRLSTS_WKUP5F                                  ((uint32_t)0x02000000U)         /* Bit25*/
#define PWR_M4CTRLSTS_WKUP6F                                  ((uint32_t)0x04000000U)         /* Bit26*/

#define PWR_M4CTRLSTS_WKUPxPOL_MASK                           ((uint32_t)0x000FC000U)         /* Bit[19:14] Wake-up polarity for the WKUPX pin*/
#define PWR_M4CTRLSTS_WKUP0POL                                ((uint32_t)0x00004000U)         /* Bit14*/
#define PWR_M4CTRLSTS_WKUP1POL                                ((uint32_t)0x00008000U)         /* Bit15*/
#define PWR_M4CTRLSTS_WKUP2POL                                ((uint32_t)0x00010000U)         /* Bit16*/
#define PWR_M4CTRLSTS_WKUP3POL                                ((uint32_t)0x00020000U)         /* Bit17*/
#define PWR_M4CTRLSTS_WKUP4POL                                ((uint32_t)0x00040000U)         /* Bit18*/
#define PWR_M4CTRLSTS_WKUP5POL                                ((uint32_t)0x00080000U)         /* Bit19*/

#define PWR_M4CTRLSTS_WKUPxEN                                 ((uint32_t)0x00003F00U)         /* Bit[13:8] WKUPx pin wakeup enable*/
#define PWR_M4CTRLSTS_WKUP0EN                                 ((uint32_t)0x00000100U)         /* Bit8*/
#define PWR_M4CTRLSTS_WKUP1EN                                 ((uint32_t)0x00000200U)         /* Bit9*/
#define PWR_M4CTRLSTS_WKUP2EN                                 ((uint32_t)0x00000400U)         /* Bit10*/
#define PWR_M4CTRLSTS_WKUP3EN                                 ((uint32_t)0x00000800U)         /* Bit11*/
#define PWR_M4CTRLSTS_WKUP4EN                                 ((uint32_t)0x00001000U)         /* Bit12*/
#define PWR_M4CTRLSTS_WKUP5EN                                 ((uint32_t)0x00002000U)         /* Bit13*/

#define PWR_M4CTRLSTS_VBATF                                   ((uint32_t)0x00000004U)         /* Bit[2] VBAT flag.*/
#define PWR_M4CTRLSTS_SBF                                     ((uint32_t)0x00000002U)         /* Bit[1] STANDBY flag.*/

/******** Bit definition for PWR_M4CTRL2 register  ********/
#define PWR_M4CTRL2_MEM_CNTVAL                                ((uint32_t)0x7E000000U)         /* Bit[30:25] counter value for M4 memory power ready count down*/
#define PWR_M4CTRL2_MEM_CNTVAL_0                              ((uint32_t)0x02000000U)         /* Bit25*/
#define PWR_M4CTRL2_MEM_CNTVAL_1                              ((uint32_t)0x04000000U)         /* Bit26*/
#define PWR_M4CTRL2_MEM_CNTVAL_2                              ((uint32_t)0x08000000U)         /* Bit27*/
#define PWR_M4CTRL2_MEM_CNTVAL_3                              ((uint32_t)0x10000000U)         /* Bit28*/
#define PWR_M4CTRL2_MEM_CNTVAL_4                              ((uint32_t)0x20000000U)         /* Bit29*/
#define PWR_M4CTRL2_MEM_CNTVAL_5                              ((uint32_t)0x40000000U)         /* Bit30*/

#define PWR_M4CTRL2_PWR_CNTVAL                                ((uint32_t)0x01FE0000U)         /* Bit[24:17] counter value for CM4 logic power ready count down*/
#define PWR_M4CTRL2_PWR_CNTVAL_0                              ((uint32_t)0x00020000U)         /* Bit17*/
#define PWR_M4CTRL2_PWR_CNTVAL_1                              ((uint32_t)0x00040000U)         /* Bit18*/
#define PWR_M4CTRL2_PWR_CNTVAL_2                              ((uint32_t)0x00080000U)         /* Bit19*/
#define PWR_M4CTRL2_PWR_CNTVAL_3                              ((uint32_t)0x00100000U)         /* Bit20*/
#define PWR_M4CTRL2_PWR_CNTVAL_4                              ((uint32_t)0x00200000U)         /* Bit21*/
#define PWR_M4CTRL2_PWR_CNTVAL_5                              ((uint32_t)0x00400000U)         /* Bit22*/
#define PWR_M4CTRL2_PWR_CNTVAL_6                              ((uint32_t)0x00800000U)         /* Bit23*/
#define PWR_M4CTRL2_PWR_CNTVAL_7                              ((uint32_t)0x01000000U)         /* Bit24*/

#define PWR_M4CTRL2_MEM_RDYMD                                 ((uint32_t)0x00018000U)         /* Bit[16:15] Selected the way of check TCM power ready for CM4 domain*/
#define PWR_M4CTRL2_MEM_RDYMD_0                               ((uint32_t)0x00008000U)         /* Bit15*/
#define PWR_M4CTRL2_MEM_RDYMD_1                               ((uint32_t)0x00010000U)         /* Bit16*/

#define PWR_M4CTRL2_PWR_RDYMD                                 ((uint32_t)0x00006000U)         /* Bit[14:13] Selected the way of check power ready for CM4 domain*/
#define PWR_M4CTRL2_PWR_RDYMD_0                               ((uint32_t)0x00002000U)         /* Bit13*/
#define PWR_M4CTRL2_PWR_RDYMD_1                               ((uint32_t)0x00004000U)         /* Bit14*/

#define PWR_M4CTRL2_NRST_WAUPEN                               ((uint32_t)0x00000800U)         /* Bit[11] NRST wakeup event enable in standby mode for M4 core*/
#define PWR_M4CTRL2_RET_PSWACK1                               ((uint32_t)0x00000400U)         /* Bit[10] M4 retention power switch ACK1 used as ENA2 enanle for dual-input-header*/
#define PWR_M4CTRL2_DMN_PSWACK1                               ((uint32_t)0x00000200U)         /* Bit[9] M4 Domain power switch ACK1 used as ENA2 enanle for dual-input-header*/
#define PWR_M4CTRL2_RTC_ALMWUPEN                              ((uint32_t)0x00000100U)         /* Bit[8] RTC_ALARM wakeup enable in standby mode for M4 core*/
#define PWR_M4CTRL2_BSRSTBRET                                 ((uint32_t)0x00000004U)         /* Bit[2] Backup SRAM retention enable in STANDBY mode*/
#define PWR_M4CTRL2_BSRVBRET                                  ((uint32_t)0x00000002U)         /* Bit[1] Backup SRAM retention enable in VBAT mode*/
#define PWR_M4CTRL2_STOP2EN                                   ((uint32_t)0x00000001U)         /* Bit[0] M4 core STOP2 mode enable*/

/******** Bit definition for PWR_SYSCTRL1 register  ********/
#define PWR_SYSCTRL1_DCDC_VSELKEY                             ((uint32_t)0xF0000000U)         /* Bit[31:28] DCDC_VSELKEY_UNLOCK key*/
#define PWR_SYSCTRL1_DCDC_VSELKEY_0                           ((uint32_t)0x10000000U)         /* Bit28*/
#define PWR_SYSCTRL1_DCDC_VSELKEY_1                           ((uint32_t)0x20000000U)         /* Bit29*/
#define PWR_SYSCTRL1_DCDC_VSELKEY_2                           ((uint32_t)0x40000000U)         /* Bit30*/
#define PWR_SYSCTRL1_DCDC_VSELKEY_3                           ((uint32_t)0x80000000U)         /* Bit31*/

#define PWR_SYSCTRL1_NRST_DGFCNT                              ((uint32_t)0x0FFF0000U)         /* Bit[27:16] Digtal Glitch Filter on NRST filtered pulse width configuration*/

#define PWR_SYSCTRL1_NRST_DGFBP                               ((uint32_t)0x00008000U)         /* Bit[15] Bypass digital glitch Filter on NRST*/
#define PWR_SYSCTRL1_AGF_STBWUPPBP                            ((uint32_t)0x00002000U)         /* Bit[13] Bypass analog glitch filter on stanby wakeup pads*/
#define PWR_SYSCTRL1_AGF_DTASGBP                              ((uint32_t)0x00001000U)         /* Bit[12] Bypass analog glitch filter on some Digtal to Analog Enable singnals*/
#define PWR_SYSCTRL1_AGF_ARSTOBP                              ((uint32_t)0x00000800U)         /* Bit[11] Bypass analog glitch filter on Analog Reset outputs*/
#define PWR_SYSCTRL1_VDDDRET_PSWACK1                          ((uint32_t)0x00000400U)         /* Bit[10] Retention domain power switch ACK1 used as ENA2 for dual-input-header*/
#define PWR_SYSCTRL1_VDDDM_PSWACK1                            ((uint32_t)0x00000200U)         /* Bit[9] VDDD Main Domain power switch ACK1 used as ENA2 for dual-input-header*/
#define PWR_SYSCTRL1_DBKP                                     ((uint32_t)0x00000100U)         /* Bit[8] Disable write protection for the backup domain*/
#define PWR_SYSCTRL1_PVDEN                                    ((uint32_t)0x00000010U)         /* Bit[4] Power Voltage Detector (PVD) Enable*/
#define PWR_SYSCTRL1_AVDEN                                    ((uint32_t)0x00000008U)         /* Bit[3] Anolog Voltage Detector (AVD) Enable.*/
#define PWR_SYSCTRL1_SW3EN                                    ((uint32_t)0x00000002U)         /* Bit[1] VDDD Backup from Backup LDO*/
#define PWR_SYSCTRL1_BKPLDOEN                                 ((uint32_t)0x00000001U)         /* Bit[0] Backup LDO enable*/

/******** Bit definition for PWR_SYSCTRLSTS register  ********/
#define PWR_SYSCTRLSTS_PVDO                                   ((uint32_t)0x00000010U)         /* Bit[4] PVD output.*/
#define PWR_SYSCTRLSTS_AVDO                                   ((uint32_t)0x00000008U)         /* Bit[3] AVD output.*/
#define PWR_SYSCTRLSTS_OTP_PWRRDY                             ((uint32_t)0x00000002U)         /* Bit[1] OTP Power Ready*/
#define PWR_SYSCTRLSTS_DCDC_BPF                               ((uint32_t)0x00000001U)         /* Bit[0] Working mode is bypass or not for DCDC*/

/******** Bit definition for PWR_SYSCTRL2 register  ********/
#define PWR_SYSCTRL2_OTP_LPCLKDIV                             ((uint32_t)0x07000000U)         /* Bit[26:24] Clock dividor of pwr_sys_clk for OTP low power mode cotrol*/
#define PWR_SYSCTRL2_OTP_LPCLKDIV_0                           ((uint32_t)0x01000000U)         /* Bit24*/
#define PWR_SYSCTRL2_OTP_LPCLKDIV_1                           ((uint32_t)0x02000000U)         /* Bit25*/
#define PWR_SYSCTRL2_OTP_LPCLKDIV_2                           ((uint32_t)0x04000000U)         /* Bit26*/

#define PWR_SYSCTRL2_OTP_FRCSTB                               ((uint32_t)0x00800000U)         /* Bit[23] OTP_FRCDSTB and OTP_FRCSTB decide the OTP power state in all system power modes*/
#define PWR_SYSCTRL2_OTP_FRCDSTB                              ((uint32_t)0x00400000U)         /* Bit[22] */

#define PWR_SYSCTRL2_OTP_STB_INSTP0                           ((uint32_t)0x00200000U)         /* Bit[21] OTP_DSTB_INSTP0 and OTP_STB_INSTP0 decide the OTP power state in system STOP0 mode*/
#define PWR_SYSCTRL2_OTP_DSTB_INSTP0                          ((uint32_t)0x00100000U)         /* Bit[20] */

#define PWR_SYSCTRL2_OTP_STB_INSTP2                           ((uint32_t)0x00080000U)         /* Bit[19] OTP_DSTB_INSTP2 and OTP_STB_INSTP2 decide the OTP power state in system STOP2 mode*/
#define PWR_SYSCTRL2_OTP_DSTB_INSTP2                          ((uint32_t)0x00040000U)         /* Bit[18] */

#define PWR_SYSCTRL2_EXTI_MASKRSTEN                           ((uint32_t)0x00020000U)         /* Bit[17] When PWR start to power down CPUn to standby mode, EXTI's IMRn/EMRn register will be reset \
                                                                                                and no interrupt/event will be send to CPU from exti*/

#define PWR_SYSCTRL2_VDDDM_RDYMD                              ((uint32_t)0x00010000U)         /* Bit[16] PWR use dpts4 rdy(feedback from power switch chain) + 2cycle LSI delay as main domain ready*/
#define PWR_SYSCTRL2_PVS_STBRET                               ((uint32_t)0x00002000U)         /* Bit[13] IO in Retention domain in Retention mode in STANDBY*/
#define PWR_SYSCTRL2_BKLDO_RUNOFFEN                           ((uint32_t)0x00000800U)         /* Bit[11] Eanble/disable of BKLDO*/
#define PWR_SYSCTRL2_BG_CTRLEN                                ((uint32_t)0x00000400U)         /* Bit[10] BG is controlled by pwr*/
#define PWR_SYSCTRL2_SRAM_CTRLEN                              ((uint32_t)0x00000200U)         /* Bit[9] BKP SRAM Power control interface is controlled by pwr*/
#define PWR_SYSCTRL2_PVS_RETCTRLEN                            ((uint32_t)0x00000100U)         /* Bit[8] PV sense retation on/off is controlled by pwr.*/
#define PWR_SYSCTRL2_PVS_CTRLEN                               ((uint32_t)0x00000080U)         /* Bit[7] PV sense is controlled by pwr*/
#define PWR_SYSCTRL2_HSE_CTRLEN                               ((uint32_t)0x00000040U)         /* Bit[6] HSE is controlled by pwr*/
#define PWR_SYSCTRL2_HSI_CTRLEN                               ((uint32_t)0x00000020U)         /* Bit[5] HSI is controlled by pwr*/
#define PWR_SYSCTRL2_PLL_CTRLEN                               ((uint32_t)0x00000010U)         /* Bit[4] PLL is controlled by pwr*/
#define PWR_SYSCTRL2_MR_STBOFFEN                              ((uint32_t)0x00000002U)         /* Bit[1] MR off enable when system enters into Standby mode*/
 
/******** Bit definition for PWR_SYSCTRL3 register  ********/
#define PWR_SYSCTRL3_HSC2_PSWACK1                             ((uint32_t)0x00400000U)         /* Bit[22] HSC2 Domain power switch ACK1 used as ENA2 for dual-input-header*/
#define PWR_SYSCTRL3_HSC1_PSW_ACK1                            ((uint32_t)0x00200000U)         /* Bit[21] HSC1 Domain power switch ACK1 used as ENA2 for dual-input-header*/
#define PWR_SYSCTRL3_GRC_PSWACK1                              ((uint32_t)0x00100000U)         /* Bit[20] GRAPHIC Domain power switch ACK1 used as ENA2 for dual-input-header*/
#define PWR_SYSCTRL3_HSC2_PWRRDY                              ((uint32_t)0x00040000U)         /* Bit[18] HSC2 power domain ready flag*/
#define PWR_SYSCTRL3_HSC1_PWRRDY                              ((uint32_t)0x00020000U)         /* Bit[17] HSC1 power domain ready flag*/
#define PWR_SYSCTRL3_GRC_PWRRDY                               ((uint32_t)0x00010000U)         /* Bit[16] GRAPHIC power domain ready flag*/
#define PWR_SYSCTRL3_HSC2_ISNEN                               ((uint32_t)0x00000400U)         /* Bit[10] HSC2 power domain isolation signal*/
#define PWR_SYSCTRL3_HSC1_ISNEN                               ((uint32_t)0x00000200U)         /* Bit[9] HSC1 power domain isolation signal*/
#define PWR_SYSCTRL3_GRC_ISNEN                                ((uint32_t)0x00000100U)         /* Bit[8] GRAPHIC power domain isolation signal*/
#define PWR_SYSCTRL3_HSC2_FUCEN                               ((uint32_t)0x00000040U)         /* Bit[6] Function mode enable for HSC2 domain*/
#define PWR_SYSCTRL3_HSC1_FUCEN                               ((uint32_t)0x00000020U)         /* Bit[5] Function mode enable for HSC1 domain*/
#define PWR_SYSCTRL3_GRC_FUCEN                                ((uint32_t)0x00000010U)         /* Bit[4] Function mode enable for GRAPHIC domain*/
#define PWR_SYSCTRL3_HSC2_PWREN                               ((uint32_t)0x00000004U)         /* Bit[2] HSC2 domain power enable*/
#define PWR_SYSCTRL3_HSC1_PWREN                               ((uint32_t)0x00000002U)         /* Bit[1] HSC1 domain power enable*/
#define PWR_SYSCTRL3_GRC_PWREN                                ((uint32_t)0x00000001U)         /* Bit[0] GRPAHIC domain power enable*/

/******** Bit definition for PWR_SYSCTRL4 register  ********/
#define PWR_SYSCTRL4_MR_LPVSELEN                              ((uint32_t)0x20000000U)         /* Bit[29] Enable targeting MR voltage output in low power mode*/

#define PWR_SYSCTRL4_DCDC_LPVSEL_MASK                         ((uint32_t)0x0F000000U)         /* Bit[27:24] Targeting dcdc voltage in low power mode*/
#define PWR_SYSCTRL4_DCDC_LPVSEL_0                            ((uint32_t)0x01000000U)         /* Bit24*/
#define PWR_SYSCTRL4_DCDC_LPVSEL_1                            ((uint32_t)0x02000000U)         /* Bit25*/
#define PWR_SYSCTRL4_DCDC_LPVSEL_2                            ((uint32_t)0x04000000U)         /* Bit26*/
#define PWR_SYSCTRL4_DCDC_LPVSEL_3                            ((uint32_t)0x08000000U)         /* Bit27*/

#define PWR_SYSCTRL4_VDDD_LPPORSEL_MASK                       ((uint32_t)0x00C00000U)         /* Bit[23:22] VDDD por config in low power mode*/
#define PWR_SYSCTRL4_VDDD_LPPORSEL_0                          ((uint32_t)0x00400000U)         /* Bit22*/
#define PWR_SYSCTRL4_VDDD_LPPORSEL_1                          ((uint32_t)0x00800000U)         /* Bit23*/

#define PWR_SYSCTRL4_DCDC_LPPORVSEL                           ((uint32_t)0x003E0000U)         /* Bit[21:17] DCDC POR voltage value 0.05V per step in low power mode*/
#define PWR_SYSCTRL4_DCDC_LPPORVSEL_0                         ((uint32_t)0x00020000U)         /* Bit17*/
#define PWR_SYSCTRL4_DCDC_LPPORVSEL_1                         ((uint32_t)0x00040000U)         /* Bit18*/
#define PWR_SYSCTRL4_DCDC_LPPORVSEL_2                         ((uint32_t)0x00080000U)         /* Bit19*/
#define PWR_SYSCTRL4_DCDC_LPPORVSEL_3                         ((uint32_t)0x00100000U)         /* Bit20*/
#define PWR_SYSCTRL4_DCDC_LPPORVSEL_4                         ((uint32_t)0x00200000U)         /* Bit21*/

#define PWR_SYSCTRL4_BG_LPVREFVSEL                            ((uint32_t)0x00010000U)         /* Bit[16] targeting aldo ref in low power mode*/
#define PWR_SYSCTRL4_BG_VREFVSEL                              ((uint32_t)0x00008000U)         /* Bit[15] targeting BG in low power mode*/

#define PWR_SYSCTRL4_VDDD_PORSEL                            ((uint32_t)0x00003000U)         /* Bit[13:12] VDDD por config in low power  mode*/
#define PWR_SYSCTRL4_VDDD_PORSEL_0                          ((uint32_t)0x00001000U)         /* Bit12*/
#define PWR_SYSCTRL4_VDDD_PORSEL_1                          ((uint32_t)0x00002000U)         /* Bit13*/

#define PWR_SYSCTRL4_MLDO_LPOVSEL                             ((uint32_t)0x00000C00U)         /* Bit[11:10] Output voltage of Main Regulator LDO option in SYS STOP2 and STANDBY mode*/
#define PWR_SYSCTRL4_MLDO_LPOVSEL_0                           ((uint32_t)0x00000400U)         /* Bit10*/
#define PWR_SYSCTRL4_MLDO_LPOVSEL_1                           ((uint32_t)0x00000800U)         /* Bit11*/

#define PWR_SYSCTRL4_MLDO_OVSEL                               ((uint32_t)0x00000300U)         /* Bit[9:8] Output voltage of Main Regulator LDO option in SYS RUN mode*/
#define PWR_SYSCTRL4_MLDO_OVSEL_0                             ((uint32_t)0x00000100U)         /* Bit8*/
#define PWR_SYSCTRL4_MLDO_OVSEL_1                             ((uint32_t)0x00000200U)         /* Bit9*/

#define PWR_SYSCTRL4_DCDCFRCEN                                ((uint32_t)0x00000008U)         /* Bit[3] DCDC is forcibly activated*/
#define PWR_SYSCTRL4_DCDCEN                                   ((uint32_t)0x00000004U)         /* Bit[2] DCDC is activated*/
#define PWR_SYSCTRL4_MLDOEN                                   ((uint32_t)0x00000002U)         /* Bit[1] LDO is forcibly activated*/
#define PWR_SYSCTRL4_VCORESRC                                 ((uint32_t)0x00000001U)         /* Bit[0] VCORE/VDDD spupplied by external source*/

/******** Bit definition for PWR_BORCTRL register  ********/
#define PWR_BORCTRL_BORVSEL_MASK                              ((uint32_t)0x0000003EU)         /* Bit[5:1] BOR voltage selelction*/
#define PWR_BORCTRL_BORVSEL_0                                 ((uint32_t)0x00000002U)         /* Bit1*/
#define PWR_BORCTRL_BORVSEL_1                                 ((uint32_t)0x00000004U)         /* Bit2*/
#define PWR_BORCTRL_BORVSEL_2                                 ((uint32_t)0x00000008U)         /* Bit3*/
#define PWR_BORCTRL_BORVSEL_3                                 ((uint32_t)0x00000010U)         /* Bit4*/
#define PWR_BORCTRL_BORVSEL_4                                 ((uint32_t)0x00000020U)         /* Bit5*/

#define PWR_BORCTRL_BOREN                                     ((uint32_t)0x00000001U)         /* Bit[0] BOR enable*/

/******** Bit definition for PWR_IPMEMCTRL register  ********/
#define PWR_IPMEMCTRL_ESC_PWREN                               ((uint32_t)0x00001000U)         /* Bit[12] ESC memory power gate enable*/
#define PWR_IPMEMCTRL_FMAC_PWREN                              ((uint32_t)0x00000800U)         /* Bit[11] FMAC memory power gate enable*/
#define PWR_IPMEMCTRL_SDMMC1_PWREN                            ((uint32_t)0x00000400U)         /* Bit[10] SDMMC1 memory power gate enable*/
#define PWR_IPMEMCTRL_USB1_PWREN                              ((uint32_t)0x00000200U)         /* Bit[9] USB1 memory power gate enable*/
#define PWR_IPMEMCTRL_ETH1_PWREN                              ((uint32_t)0x00000100U)         /* Bit[8] ETH1 memory power gate enable*/
#define PWR_IPMEMCTRL_SDMMC2_PWREN                            ((uint32_t)0x00000080U)         /* Bit[7] SDMMC2 memory power gate enable*/
#define PWR_IPMEMCTRL_USB2_PWREN                              ((uint32_t)0x00000040U)         /* Bit[6] USB2 memory power gate enable*/
#define PWR_IPMEMCTRL_ETH2_PWREN                              ((uint32_t)0x00000020U)         /* Bit[5] ETH2 memory power gate enable*/
#define PWR_IPMEMCTRL_DVP_PWREN                               ((uint32_t)0x00000010U)         /* Bit[4] DVP memory power gate enable*/
#define PWR_IPMEMCTRL_DSI_PWREN                               ((uint32_t)0x00000008U)         /* Bit[3] DSI memory power gate enable*/
#define PWR_IPMEMCTRL_JPEG_PWREN                              ((uint32_t)0x00000004U)         /* Bit[2] JPEG memory power gate enable*/
#define PWR_IPMEMCTRL_LCDC_PWREN                              ((uint32_t)0x00000002U)         /* Bit[1] LCDC memory power gate enable*/
#define PWR_IPMEMCTRL_GPU_PWREN                               ((uint32_t)0x00000001U)         /* Bit[0] GPU memory power gate enable*/

/******** Bit definition for PWR_IPMEMCTRLSTS register  ********/
#define PWR_IPMEMCTRLSTS_AIP_MEMPWRRDY                        ((uint32_t)0x80000000U)         /* Bit[31] ALL IP memory power ready flag*/
#define PWR_IPMEMCTRLSTS_ESC_PWRRDY                           ((uint32_t)0x00001000U)         /* Bit[12] ESC memory power ready flag*/
#define PWR_IPMEMCTRLSTS_FMAC_PWRRDY                          ((uint32_t)0x00000800U)         /* Bit[11] FMAC memory power ready flag*/
#define PWR_IPMEMCTRLSTS_SDMMC1_PWRRDY                        ((uint32_t)0x00000400U)         /* Bit[10] SDMMC1 memory power ready flag*/
#define PWR_IPMEMCTRLSTS_USB1_PWRRDY                          ((uint32_t)0x00000200U)         /* Bit[9] USB1 memory power ready flag*/
#define PWR_IPMEMCTRLSTS_ETH1_PWRRDY                          ((uint32_t)0x00000100U)         /* Bit[8] ETH1 memory power ready flag*/
#define PWR_IPMEMCTRLSTS_SDMMC2_PWRRDY                        ((uint32_t)0x00000080U)         /* Bit[7] SDMMC2 memory power ready flag*/
#define PWR_IPMEMCTRLSTS_USB2_PWRRDY                          ((uint32_t)0x00000040U)         /* Bit[6] USB2 memory power ready flag*/
#define PWR_IPMEMCTRLSTS_ETH2_PWRRDY                          ((uint32_t)0x00000020U)         /* Bit[5] ETH2 memory power ready flag*/
#define PWR_IPMEMCTRLSTS_DVP_PWRRDY                           ((uint32_t)0x00000010U)         /* Bit[4] DVP memory power ready flag*/
#define PWR_IPMEMCTRLSTS_DSI_PWRRDY                           ((uint32_t)0x00000008U)         /* Bit[3] DSI memory power ready flag*/
#define PWR_IPMEMCTRLSTS_JPEG_PWRRDY                          ((uint32_t)0x00000004U)         /* Bit[2] JPEG memory power ready flag*/
#define PWR_IPMEMCTRLSTS_LCDC_PWRRDY                          ((uint32_t)0x00000002U)         /* Bit[1] LCDC memory power ready flag*/
#define PWR_IPMEMCTRLSTS_GPU_PWRRDY                           ((uint32_t)0x00000001U)         /* Bit[0] GPU memory power ready flag*/

/******** Bit definition for PWR_M7MEMLPCTRL register  ********/
#define PWR_M7MEMLPCTRL_MEM_PGCFG                             ((uint32_t)0x0000000CU)         /* Bit[3:2] Memory power gate sequence control*/
#define PWR_M7MEMLPCTRL_MEM_PGCFG_0                           ((uint32_t)0x00000004U)         /* Bit2*/
#define PWR_M7MEMLPCTRL_MEM_PGCFG_1                           ((uint32_t)0x00000008U)         /* Bit3*/
#define PWR_M7MEMLPCTRL_MEM_RETSTP0EN                         ((uint32_t)0x00000002U)         /* Bit[1] */
#define PWR_M7MEMLPCTRL_MEM_PGENSTP0                          ((uint32_t)0x00000001U)         /* Bit[0] */

/******** Bit definition for PWR_M7MEMLPSTS register  ********/
#define PWR_M7MEMLPSTS_TCMRDY                                 ((uint32_t)0x80000000U)         /* Bit[31] All enabled TCM memory power ready flag*/

/******** Bit definition for PWR_M7TCMPG0 register  ********/
#define PWR_M7TCMPG0_M7TCM_SWPG0                              ((uint32_t)0xFFFFFFFFU)         /* Bit[31:0] Software control to power gate TCM memories*/
#define PWR_M7TCMPG0_M7TCM_SWPG0_0                            ((uint32_t)0x00000001U)         /* Bit0   range :0x20000000U ?C 0x20003FFFU*/
#define PWR_M7TCMPG0_M7TCM_SWPG0_1                            ((uint32_t)0x00000002U)         /* Bit1   range :0x20004000U ?C 0x20007FFFU*/
#define PWR_M7TCMPG0_M7TCM_SWPG0_2                            ((uint32_t)0x00000004U)         /* Bit2   ....                            */
#define PWR_M7TCMPG0_M7TCM_SWPG0_3                            ((uint32_t)0x00000008U)         /* Bit3   ....                         */
#define PWR_M7TCMPG0_M7TCM_SWPG0_4                            ((uint32_t)0x00000010U)         /* Bit4   ....                         */
#define PWR_M7TCMPG0_M7TCM_SWPG0_5                            ((uint32_t)0x00000020U)         /* Bit5   ....                         */
#define PWR_M7TCMPG0_M7TCM_SWPG0_6                            ((uint32_t)0x00000040U)         /* Bit6   ....                         */
#define PWR_M7TCMPG0_M7TCM_SWPG0_7                            ((uint32_t)0x00000080U)         /* Bit7   ....                         */
#define PWR_M7TCMPG0_M7TCM_SWPG0_8                            ((uint32_t)0x00000100U)         /* Bit8   ....                         */
#define PWR_M7TCMPG0_M7TCM_SWPG0_9                            ((uint32_t)0x00000200U)         /* Bit9   ....                         */
#define PWR_M7TCMPG0_M7TCM_SWPG0_10                           ((uint32_t)0x00000400U)         /* Bit10  ....                         */
#define PWR_M7TCMPG0_M7TCM_SWPG0_11                           ((uint32_t)0x00000800U)         /* Bit11  ....                         */
#define PWR_M7TCMPG0_M7TCM_SWPG0_12                           ((uint32_t)0x00001000U)         /* Bit12  ....                         */
#define PWR_M7TCMPG0_M7TCM_SWPG0_13                           ((uint32_t)0x00002000U)         /* Bit13  ....                         */
#define PWR_M7TCMPG0_M7TCM_SWPG0_14                           ((uint32_t)0x00004000U)         /* Bit14  ....                         */
#define PWR_M7TCMPG0_M7TCM_SWPG0_15                           ((uint32_t)0x00008000U)         /* Bit15  ....                         */
#define PWR_M7TCMPG0_M7TCM_SWPG0_16                           ((uint32_t)0x00010000U)         /* Bit16  ....                         */
#define PWR_M7TCMPG0_M7TCM_SWPG0_17                           ((uint32_t)0x00020000U)         /* Bit17  ....                         */
#define PWR_M7TCMPG0_M7TCM_SWPG0_18                           ((uint32_t)0x00040000U)         /* Bit18  ....                         */
#define PWR_M7TCMPG0_M7TCM_SWPG0_19                           ((uint32_t)0x00080000U)         /* Bit19  ....                         */
#define PWR_M7TCMPG0_M7TCM_SWPG0_20                           ((uint32_t)0x00100000U)         /* Bit20  ....                         */
#define PWR_M7TCMPG0_M7TCM_SWPG0_21                           ((uint32_t)0x00200000U)         /* Bit21  ....                         */
#define PWR_M7TCMPG0_M7TCM_SWPG0_22                           ((uint32_t)0x00400000U)         /* Bit22  ....                         */
#define PWR_M7TCMPG0_M7TCM_SWPG0_23                           ((uint32_t)0x00800000U)         /* Bit23  ....                         */
#define PWR_M7TCMPG0_M7TCM_SWPG0_24                           ((uint32_t)0x01000000U)         /* Bit24  ....                         */
#define PWR_M7TCMPG0_M7TCM_SWPG0_25                           ((uint32_t)0x02000000U)         /* Bit25  ....                         */
#define PWR_M7TCMPG0_M7TCM_SWPG0_26                           ((uint32_t)0x04000000U)         /* Bit26  ....                         */
#define PWR_M7TCMPG0_M7TCM_SWPG0_27                           ((uint32_t)0x08000000U)         /* Bit27  ....                         */
#define PWR_M7TCMPG0_M7TCM_SWPG0_28                           ((uint32_t)0x10000000U)         /* Bit28  ....                         */
#define PWR_M7TCMPG0_M7TCM_SWPG0_29                           ((uint32_t)0x20000000U)         /* Bit29  ....                         */
#define PWR_M7TCMPG0_M7TCM_SWPG0_30                           ((uint32_t)0x40000000U)         /* Bit30  ....                         */
#define PWR_M7TCMPG0_M7TCM_SWPG0_31                           ((uint32_t)0x80000000U)         /* Bit31  range :0x2007FBFFU ?C 0x2007FFFFU*/

/******** Bit definition for PWR_M7TCMPG1 register  ********/
#define PWR_M7TCMPG1_M7TCM_SWPG1                              ((uint32_t)0xFFFFFFFFU)         /* Bit[31:0] Software control to power gate TCM memories*/
#define PWR_M7TCMPG1_M7TCM_SWPG1_0                            ((uint32_t)0x00000001U)         /* Bit0    range :0x20080000U ?C 0x20083FFFU*/
#define PWR_M7TCMPG1_M7TCM_SWPG1_1                            ((uint32_t)0x00000002U)         /* Bit1    range :0x20084000U ?C 0x20087FFFU*/
#define PWR_M7TCMPG1_M7TCM_SWPG1_2                            ((uint32_t)0x00000004U)         /* Bit2    ....                            */
#define PWR_M7TCMPG1_M7TCM_SWPG1_3                            ((uint32_t)0x00000008U)         /* Bit3    ....                            */
#define PWR_M7TCMPG1_M7TCM_SWPG1_4                            ((uint32_t)0x00000010U)         /* Bit4    ....                            */
#define PWR_M7TCMPG1_M7TCM_SWPG1_5                            ((uint32_t)0x00000020U)         /* Bit5    ....                            */
#define PWR_M7TCMPG1_M7TCM_SWPG1_6                            ((uint32_t)0x00000040U)         /* Bit6    ....                            */
#define PWR_M7TCMPG1_M7TCM_SWPG1_7                            ((uint32_t)0x00000080U)         /* Bit7    ....                            */
#define PWR_M7TCMPG1_M7TCM_SWPG1_8                            ((uint32_t)0x00000100U)         /* Bit8    ....                            */
#define PWR_M7TCMPG1_M7TCM_SWPG1_9                            ((uint32_t)0x00000200U)         /* Bit9    ....                            */
#define PWR_M7TCMPG1_M7TCM_SWPG1_10                           ((uint32_t)0x00000400U)         /* Bit10   ....                            */
#define PWR_M7TCMPG1_M7TCM_SWPG1_11                           ((uint32_t)0x00000800U)         /* Bit11   ....                            */
#define PWR_M7TCMPG1_M7TCM_SWPG1_12                           ((uint32_t)0x00001000U)         /* Bit12   ....                            */
#define PWR_M7TCMPG1_M7TCM_SWPG1_13                           ((uint32_t)0x00002000U)         /* Bit13   ....                            */
#define PWR_M7TCMPG1_M7TCM_SWPG1_14                           ((uint32_t)0x00004000U)         /* Bit14   ....                            */
#define PWR_M7TCMPG1_M7TCM_SWPG1_15                           ((uint32_t)0x00008000U)         /* Bit15   ....                            */
#define PWR_M7TCMPG1_M7TCM_SWPG1_16                           ((uint32_t)0x00010000U)         /* Bit16   ....                            */
#define PWR_M7TCMPG1_M7TCM_SWPG1_17                           ((uint32_t)0x00020000U)         /* Bit17   ....                            */
#define PWR_M7TCMPG1_M7TCM_SWPG1_18                           ((uint32_t)0x00040000U)         /* Bit18   ....                            */
#define PWR_M7TCMPG1_M7TCM_SWPG1_19                           ((uint32_t)0x00080000U)         /* Bit19   ....                            */
#define PWR_M7TCMPG1_M7TCM_SWPG1_20                           ((uint32_t)0x00100000U)         /* Bit20   ....                            */
#define PWR_M7TCMPG1_M7TCM_SWPG1_21                           ((uint32_t)0x00200000U)         /* Bit21   ....                            */
#define PWR_M7TCMPG1_M7TCM_SWPG1_22                           ((uint32_t)0x00400000U)         /* Bit22   ....                            */
#define PWR_M7TCMPG1_M7TCM_SWPG1_23                           ((uint32_t)0x00800000U)         /* Bit23   ....                            */
#define PWR_M7TCMPG1_M7TCM_SWPG1_24                           ((uint32_t)0x01000000U)         /* Bit24   ....                            */
#define PWR_M7TCMPG1_M7TCM_SWPG1_25                           ((uint32_t)0x02000000U)         /* Bit25   ....                            */
#define PWR_M7TCMPG1_M7TCM_SWPG1_26                           ((uint32_t)0x04000000U)         /* Bit26   ....                            */
#define PWR_M7TCMPG1_M7TCM_SWPG1_27                           ((uint32_t)0x08000000U)         /* Bit27   ....                            */
#define PWR_M7TCMPG1_M7TCM_SWPG1_28                           ((uint32_t)0x10000000U)         /* Bit28   ....                            */
#define PWR_M7TCMPG1_M7TCM_SWPG1_29                           ((uint32_t)0x20000000U)         /* Bit29   ....                            */
#define PWR_M7TCMPG1_M7TCM_SWPG1_30                           ((uint32_t)0x40000000U)         /* Bit30   ....                            */
#define PWR_M7TCMPG1_M7TCM_SWPG1_31                           ((uint32_t)0x80000000U)         /* Bit31   range :0x200FFBFFU ?C 0x200FFFFFU*/

/******** Bit definition for PWR_M7TCMRET1N0 register  ********/
#define PWR_M7TCMRET1N0_M7TCM_RET1CFG0                        ((uint32_t)0xFFFFFFFFU)         /* Bit[31:0] */

/******** Bit definition for PWR_M7TCMRET1N1 register  ********/
#define PWR_M7TCMRET1N1_M7TCM_RET1CFG1                        ((uint32_t)0xFFFFFFFFU)         /* Bit[31:0] */

/******** Bit definition for PWR_M7TCMRET2CFG0 register  ********/
#define PWR_M7TCMRET2CFG0_M7TCM_RET2CFG0                      ((uint32_t)0xFFFFFFFFU)         /* Bit[31:0] */

/******** Bit definition for PWR_M7TCM_RET2CFG1 register  ********/
#define PWR_M7TCM_RET2CFG1_M7TCM_RET2CFG1                     ((uint32_t)0xFFFFFFFFU)         /* Bit[31:0] */

/******** Bit definition for PWR_M7TCMPRDY0 register  ********/
#define PWR_M7TCMPRDY0_TCM_PRDY0                              ((uint32_t)0xFFFFFFFFU)         /* Bit[31:0] */

/******** Bit definition for PWR_M7TCMPRDY1 register  ********/
#define PWR_M7TCMPRDY1_TCM_PRDY1                              ((uint32_t)0xFFFFFFFFU)         /* Bit[31:0] */

/******** Bit definition for PWR_M4MEMLPCTRL register  ********/
#define PWR_M4MEMLPCTRL_MEM_PGCFG                             ((uint32_t)0x0000000CU)         /* Bit[3:2] Memory power gate sequence control*/
#define PWR_M4MEMLPCTRL_MEM_PGCFG_0                           ((uint32_t)0x00000004U)         /* Bit2  */
#define PWR_M4MEMLPCTRL_MEM_PGCFG_1                           ((uint32_t)0x00000008U)         /* Bit3  */

#define PWR_M4MEMLPCTRL_MEM_RETSTP0EN                         ((uint32_t)0x00000002U)         /* Bit[1] */
#define PWR_M4MEMLPCTRL_MEM_PGSTP0EN                          ((uint32_t)0x00000001U)         /* Bit[0] */

/******** Bit definition for PWR_SYSMEMLPCTRL register  ********/
#define PWR_SYSMEMLPCTRL_ALLPRDY                              ((uint32_t)0x80000000U)         /* Bit[31] All enabled system memory power ready flag*/
#define PWR_SYSMEMLPCTRL_AHBSRAM5S2_RET2N                     ((uint32_t)0x04000000U)         /* Bit[26] System SRAM5S2 memory status control */
#define PWR_SYSMEMLPCTRL_AHBSRAM5S2_RET1N                     ((uint32_t)0x02000000U)         /* Bit[25] System SRAM5S2 memory status control*/
#define PWR_SYSMEMLPCTRL_AHBSRAM5S1_RET2N                     ((uint32_t)0x01000000U)         /* Bit[24] System SRAM5S1 memory status control*/
#define PWR_SYSMEMLPCTRL_AHBSRAM5S1_RET1N                     ((uint32_t)0x00800000U)         /* Bit[23] System SRAM5S1 memory status control*/
#define PWR_SYSMEMLPCTRL_AHBSRAM4_RET2N                       ((uint32_t)0x00400000U)         /* Bit[22] System SRAM4 memory status control*/
#define PWR_SYSMEMLPCTRL_AHBSRAM4_RET1N                       ((uint32_t)0x00200000U)         /* Bit[21] System SRAM4 memory status control*/
#define PWR_SYSMEMLPCTRL_AHBSRAM3_RET2N                       ((uint32_t)0x00100000U)         /* Bit[20] System SRAM3 memory status control*/
#define PWR_SYSMEMLPCTRL_AHBSRAM3_RET1N                       ((uint32_t)0x00080000U)         /* Bit[19] System SRAM3 memory status control*/
#define PWR_SYSMEMLPCTRL_AHBSRAM2_RET2N                       ((uint32_t)0x00040000U)         /* Bit[18] System SRAM2 memory status control*/
#define PWR_SYSMEMLPCTRL_AHBSRAM2_RET1N                       ((uint32_t)0x00020000U)         /* Bit[17] System SRAM2 memory status control*/
#define PWR_SYSMEMLPCTRL_AHBSRAM1_RET2N                       ((uint32_t)0x00010000U)         /* Bit[16] System SRAM1 memory status control*/
#define PWR_SYSMEMLPCTRL_AHBSRAM1_RET1N                       ((uint32_t)0x00008000U)         /* Bit[15] System SRAM1 memory status control*/
#define PWR_SYSMEMLPCTRL_AXISRAM_RET2N                        ((uint32_t)0x00004000U)         /* Bit[14] System memory status control*/
#define PWR_SYSMEMLPCTRL_AXISRAM_RET1N                        ((uint32_t)0x00002000U)         /* Bit[13] System memory status control*/
#define PWR_SYSMEMLPCTRL_MEM_RETSTP0EN                        ((uint32_t)0x00000200U)         /* Bit[9] all system memory control*/
#define PWR_SYSMEMLPCTRL_MEM_PGSTP0EN                         ((uint32_t)0x00000100U)         /* Bit[8] all system memory control*/
#define PWR_SYSMEMLPCTRL_AHBSRAM5S2PG                         ((uint32_t)0x00000040U)         /* Bit[6] Software control to power gate AHB SRAM5S2 in SYS RUN mode*/
#define PWR_SYSMEMLPCTRL_AHBSRAM5S1_PG                        ((uint32_t)0x00000020U)         /* Bit[5] Software control to power gate AHB SRAM5S1 in SYS RUN mode*/
#define PWR_SYSMEMLPCTRL_AHBSRAM4PG                           ((uint32_t)0x00000010U)         /* Bit[4] Software control to power gate AHB SRAM4 in SYS RUN mode*/
#define PWR_SYSMEMLPCTRL_AHBSRAM3_PG                          ((uint32_t)0x00000008U)         /* Bit[3] Software control to power gate AHB SRAM3 in SYS RUN mode*/
#define PWR_SYSMEMLPCTRL_AHBSRAM2_PG                          ((uint32_t)0x00000004U)         /* Bit[2] Software control to power gate AHB SRAM2 in SYS RUN mode*/
#define PWR_SYSMEMLPCTRL_AHBSRAM1_PG                          ((uint32_t)0x00000002U)         /* Bit[1] Software control to power gate AHB SRAM1 in SYS RUN mode*/
#define PWR_SYSMEMLPCTRL_AXISRAM_PG                           ((uint32_t)0x00000001U)         /* Bit[0] Software control to power gate AXI SRAM in SYS RUN mode*/

/******** Bit definition for PWR_SHRTIMCTRL register  ********/
#define PWR_SHRTIMCTRL_SHRA_PSWACK1                           ((uint32_t)0x00100000U)         /* Bit[20] SHRTIM AFE Domain power switch ACK1 used as ENA2 for dual-input-header*/
#define PWR_SHRTIMCTRL_SHRA_PRDY                              ((uint32_t)0x00080000U)         /* Bit[19] SHRTIM AFE power domain ready flag*/
#define PWR_SHRTIMCTRL_SHRA_ISNEN                             ((uint32_t)0x00040000U)         /* Bit[18] SHRTIM AFE power domain isolation signal*/
#define PWR_SHRTIMCTRL_SHRA_FUCEN                             ((uint32_t)0x00020000U)         /* Bit[17] Function mode enable for SHRTIM AFE*/
#define PWR_SHRTIMCTRL_SHRA_PWREN                             ((uint32_t)0x00010000U)         /* Bit[16] SHRTIM AFE  power gate enable*/
#define PWR_SHRTIMCTRL_SHR2_PSWACK1                           ((uint32_t)0x00001000U)         /* Bit[12] HRTIM2 Domain power switch ACK1 used as ENA2 for dual-input-header*/
#define PWR_SHRTIMCTRL_SHR2_PRDY                              ((uint32_t)0x00000800U)         /* Bit[11] SHRTIM2 power domain ready flag*/
#define PWR_SHRTIMCTRL_SHR2_ISNEN                             ((uint32_t)0x00000400U)         /* Bit[10] SHRTIM2 power domain isolation signal*/
#define PWR_SHRTIMCTRL_SHR2_FUCEN                             ((uint32_t)0x00000200U)         /* Bit[9] Function mode enable for SHRTIM2 */
#define PWR_SHRTIMCTRL_SHR2_PWREN                             ((uint32_t)0x00000100U)         /* Bit[8] SHRTIM2  power gate enable*/
#define PWR_SHRTIMCTRL_SHR1_PSWACK1                           ((uint32_t)0x00000010U)         /* Bit[4] HRTIM1 Domain power switch ACK1 used as ENA2 for dual-input-header*/
#define PWR_SHRTIMCTRL_SHR1_PRDY                              ((uint32_t)0x00000008U)         /* Bit[3] SHRTIM1 power domain ready flag*/
#define PWR_SHRTIMCTRL_SHR1_ISNEN                             ((uint32_t)0x00000004U)         /* Bit[2] SHRTIM1 power domain isolation signal*/
#define PWR_SHRTIMCTRL_SHR1_FUCEN                             ((uint32_t)0x00000002U)         /* Bit[1] Function mode enable for SHRTIM1 */
#define PWR_SHRTIMCTRL_SHR1_PWREN                             ((uint32_t)0x00000001U)         /* Bit[0] SHRTIM1  power gate enable*/

/******** Bit definition for PWR_MDMACTRL register  ********/
#define PWR_MDMACTRL_MDMA_PSWACK1                             ((uint32_t)0x00000010U)         /* Bit[4] MDMA Domain power switch ACK1 used as ENA2 for dual-input-header*/
#define PWR_MDMACTRL_MDMA_PRDY                                ((uint32_t)0x00000008U)         /* Bit[3] MDMA power domain ready flag*/
#define PWR_MDMACTRL_MDMA_ISNEN                               ((uint32_t)0x00000004U)         /* Bit[2] MDMA power domain isolation signal*/
#define PWR_MDMACTRL_MDMA_FUCEN                               ((uint32_t)0x00000002U)         /* Bit[1] Function mode enable for MDMA*/
#define PWR_MDMACTRL_MDMA_PWREN                               ((uint32_t)0x00000001U)         /* Bit[0] MDMA  power gate enable*/

/******** Bit definition for PWR_ESCCTRL register  ********/
#define PWR_ESCCTRL_ESC_PSWACK1                               ((uint32_t)0x00000010U)         /* Bit[4] ESC Domain power switch ACK1 used as ENA2 for dual-input-header */
#define PWR_ESCCTRL_ESC_PRDY                                  ((uint32_t)0x00000008U)         /* Bit[3] ESC power domain ready flag*/
#define PWR_ESCCTRL_ESC_ISNEN                                 ((uint32_t)0x00000004U)         /* Bit[2] ESC power domain isolation signal*/
#define PWR_ESCCTRL_ESC_FUCEN                                 ((uint32_t)0x00000002U)         /* Bit[1] Function mode enable for ESC*/
#define PWR_ESCCTRL_ESC_PWREN                                 ((uint32_t)0x00000001U)         /* Bit[0] ESC power gate enable*/

/******** Bit definition for PWR_DBGPROB0 register  ********/
#define PWR_DBGPROB0_DBG_PRO1                                 ((uint32_t)0xFFFF0000U)         /* Bit[31:16] Debug probe observation to PWR interanl signals set 1*/

#define PWR_DBGPROB0_DBG_PRO0                                 ((uint32_t)0x0000FFFFU)         /* Bit[15:0] Debug probe observation to PWR interanl signals set 0*/

/******** Bit definition for PWR_DBGPROB1 register  ********/
#define PWR_DBGPROB1_DBG_PRO3                                 ((uint32_t)0xFFFF0000U)         /* Bit[31:16] Debug probe observation to PWR interanl signals set 3*/

#define PWR_DBGPROB1_DBG_PRO2                                 ((uint32_t)0x0000FFFFU)         /* Bit[15:0] Debug probe observation to PWR interanl signals set 2*/

/******** Bit definition for PWR_DBGPRO2 register  ********/
#define PWR_DBGPRO2_DBG_PRO5                                  ((uint32_t)0xFFFF0000U)         /* Bit[31:16] Debug probe observation to PWR interanl signals set 5*/

#define PWR_DBGPRO2_DBG_PRO4                                  ((uint32_t)0x0000FFFFU)         /* Bit[15:0] Debug probe observation to PWR interanl signals set 4*/

/******** Bit definition for PWR_DBGPRO3 register  ********/
#define PWR_DBGPRO3_DBG_PRO7                                  ((uint32_t)0xFFFF0000U)         /* Bit[31:16] Debug probe observation to PWR interanl signals set 5*/

#define PWR_DBGPRO3_DBG_PRO6                                  ((uint32_t)0x0000FFFFU)         /* Bit[15:0] Debug probe observation to PWR interanl signals set 6*/

/******** Bit definition for PWR_DBGPRO4 register  ********/
#define PWR_DBGPRO4_DBG_PRO9                                  ((uint32_t)0xFFFF0000U)         /* Bit[31:16] Debug probe observation to PWR interanl signals set 9*/

#define PWR_DBGPRO4_DBG_PRO8                                  ((uint32_t)0x0000FFFFU)         /* Bit[15:0] Debug probe observation to PWR interanl signals set 8*/

/******** Bit definition for PWR_DBGPRO5 register  ********/
#define PWR_DBGPRO5_DBG_PROB                                  ((uint32_t)0xFFFF0000U)         /* Bit[31:16] Debug probe observation to PWR interanl signals set B*/

#define PWR_DBGPRO5_DBG_PROA                                  ((uint32_t)0x0000FFFFU)         /* Bit[15:0] Debug probe observation to PWR interanl signals set A*/

/******** Bit definition for PWR_DBGPRO6 register  ********/
#define PWR_DBGPRO6_DBG_PROD                                  ((uint32_t)0xFFFF0000U)         /* Bit[31:16] Debug probe observation to PWR interanl signals set D*/

#define PWR_DBGPRO6_DBG_PROC                                  ((uint32_t)0x0000FFFFU)         /* Bit[15:0] Debug probe observation to PWR interanl signals set C*/

/******** Bit definition for PWR_DBGPRO7 register  ********/
#define PWR_DBGPRO7_DBG_PROF                                  ((uint32_t)0xFFFF0000U)         /* Bit[31:16] Debug probe observation to PWR interanl signals set F*/

#define PWR_DBGPRO7_DBG_PROE                                  ((uint32_t)0x0000FFFFU)         /* Bit[15:0] Debug probe observation to PWR interanl signals set E*/

/******** Bit definition for PWR_DBGPROBCTRL register  ********/
#define PWR_DBGPROBCTRL_PROB_SEL_MASK                         ((uint32_t)0x0000000FU)         /* Bit[3:0] */
#define PWR_DBGPROBCTRL_PROB_SEL_0                            ((uint32_t)0x00000001U)         /* Bit0*/
#define PWR_DBGPROBCTRL_PROB_SEL_1                            ((uint32_t)0x00000002U)         /* Bit1*/
#define PWR_DBGPROBCTRL_PROB_SEL_2                            ((uint32_t)0x00000004U)         /* Bit2*/
#define PWR_DBGPROBCTRL_PROB_SEL_3                            ((uint32_t)0x00000008U)         /* Bit3*/

/******** Bit definition for PWR_EMCRETCTRL1 register  ********/
#define PWR_EMCRETCTRL1_RETGBxDET                             ((uint32_t)0x00000F00U)         /* Bit[11:8] RET domain EMC GBx detection enable*/
#define PWR_EMCRETCTRL1_RETGBxDET_0                           ((uint32_t)0x00000100U)         /* Bit8*/
#define PWR_EMCRETCTRL1_RETGBxDET_1                           ((uint32_t)0x00000200U)         /* Bit9*/
#define PWR_EMCRETCTRL1_RETGBxDET_2                           ((uint32_t)0x00000400U)         /* Bit10*/
#define PWR_EMCRETCTRL1_RETGBxDET_3                           ((uint32_t)0x00000800U)         /* Bit11*/

#define PWR_EMCRETCTRL1_RETGBNxDET                            ((uint32_t)0x000000F0U)         /* Bit[7:4] RET domain EMC GBNx detection enable*/
#define PWR_EMCRETCTRL1_RETGBNxDET_0                          ((uint32_t)0x00000010U)         /* Bit4*/
#define PWR_EMCRETCTRL1_RETGBNxDET_1                          ((uint32_t)0x00000020U)         /* Bit5*/
#define PWR_EMCRETCTRL1_RETGBNxDET_2                          ((uint32_t)0x00000040U)         /* Bit6*/
#define PWR_EMCRETCTRL1_RETGBNxDET_3                          ((uint32_t)0x00000080U)         /* Bit7*/

#define PWR_EMCRETCTRL1_RETCLPxDET                            ((uint32_t)0x0000000FU)         /* Bit[3:0] RET domain EMC Clampx detection enable*/
#define PWR_EMCRETCTRL1_RETCLPxDET_0                          ((uint32_t)0x00000001U)         /* Bit0*/
#define PWR_EMCRETCTRL1_RETCLPxDET_1                          ((uint32_t)0x00000002U)         /* Bit1*/
#define PWR_EMCRETCTRL1_RETCLPxDET_2                          ((uint32_t)0x00000004U)         /* Bit2*/
#define PWR_EMCRETCTRL1_RETCLPxDET_3                          ((uint32_t)0x00000008U)         /* Bit3*/

/******** Bit definition for PWR_EMCCTRLSTS1 register  ********/
#define PWR_EMCCTRLSTS1_EMCFCLR                               ((uint32_t)0x01000000U)         /* Bit[24] Clear EMC Flag*/

#define PWR_EMCCTRLSTS1_RETGBxF                               ((uint32_t)0x00000F00U)         /* Bit[11:8] RET Domain EMC GBx Flag*/
#define PWR_EMCCTRLSTS1_RETGBxF_0                             ((uint32_t)0x00000100U)         /* Bit8*/
#define PWR_EMCCTRLSTS1_RETGBxF_1                             ((uint32_t)0x00000200U)         /* Bit9*/
#define PWR_EMCCTRLSTS1_RETGBxF_2                             ((uint32_t)0x00000400U)         /* Bit10*/
#define PWR_EMCCTRLSTS1_RETGBxF_3                             ((uint32_t)0x00000800U)         /* Bit11*/

#define PWR_EMCCTRLSTS1_RETGBNxF                              ((uint32_t)0x000000F0U)         /* Bit[7:4] RET Domain EMC GBNx Flag*/
#define PWR_EMCCTRLSTS1_RETGBNxF_0                            ((uint32_t)0x00000010U)         /* Bit4*/
#define PWR_EMCCTRLSTS1_RETGBNxF_1                            ((uint32_t)0x00000020U)         /* Bit5*/
#define PWR_EMCCTRLSTS1_RETGBNxF_2                            ((uint32_t)0x00000040U)         /* Bit6*/
#define PWR_EMCCTRLSTS1_RETGBNxF_3                            ((uint32_t)0x00000080U)         /* Bit7*/

#define PWR_EMCCTRLSTS1_RETCLPxF                              ((uint32_t)0x0000000FU)         /* Bit[3:0] RET Domain EMC Clampx Flag*/
#define PWR_EMCCTRLSTS1_RETCLPxF_0                            ((uint32_t)0x00000001U)         /* Bit0*/
#define PWR_EMCCTRLSTS1_RETCLPxF_1                            ((uint32_t)0x00000002U)         /* Bit1*/
#define PWR_EMCCTRLSTS1_RETCLPxF_2                            ((uint32_t)0x00000004U)         /* Bit2*/
#define PWR_EMCCTRLSTS1_RETCLPxF_3                            ((uint32_t)0x00000008U)         /* Bit3*/

/******** Bit definition for PWR_EMCRETCTRL2 register  ********/
#define PWR_EMCRETCTRL2_RETGBxDET                             ((uint32_t)0x00000F00U)         /* Bit[11:8] RET domain EMC GBx detection enable*/
#define PWR_EMCRETCTRL2_RETGBxDET_0                           ((uint32_t)0x00000100U)         /* Bit8*/
#define PWR_EMCRETCTRL2_RETGBxDET_1                           ((uint32_t)0x00000200U)         /* Bit9*/
#define PWR_EMCRETCTRL2_RETGBxDET_2                           ((uint32_t)0x00000400U)         /* Bit10*/
#define PWR_EMCRETCTRL2_RETGBxDET_3                           ((uint32_t)0x00000800U)         /* Bit11*/

#define PWR_EMCRETCTRL2_RETGBNxDET                            ((uint32_t)0x000000F0U)         /* Bit[7:4] RET domain EMC GBNx detection enable*/
#define PWR_EMCRETCTRL2_RETGBNxDET_0                          ((uint32_t)0x00000010U)         /* Bit4*/
#define PWR_EMCRETCTRL2_RETGBNxDET_1                          ((uint32_t)0x00000020U)         /* Bit5*/
#define PWR_EMCRETCTRL2_RETGBNxDET_2                          ((uint32_t)0x00000040U)         /* Bit6*/
#define PWR_EMCRETCTRL2_RETGBNxDET_3                          ((uint32_t)0x00000080U)         /* Bit7*/

#define PWR_EMCRETCTRL2_RETCLPxDET                            ((uint32_t)0x0000000FU)         /* Bit[3:0] RET domain EMC Clampx detection enable*/
#define PWR_EMCRETCTRL2_RETCLPxDET_0                          ((uint32_t)0x00000001U)         /* Bit0*/
#define PWR_EMCRETCTRL2_RETCLPxDET_1                          ((uint32_t)0x00000002U)         /* Bit1*/
#define PWR_EMCRETCTRL2_RETCLPxDET_2                          ((uint32_t)0x00000004U)         /* Bit2*/
#define PWR_EMCRETCTRL2_RETCLPxDET_3                          ((uint32_t)0x00000008U)         /* Bit3*/

/******** Bit definition for PWR_EMCRETSTS2 register  ********/
#define PWR_EMCRETSTS2_RETGBxF                                ((uint32_t)0x00000F00U)         /* Bit[11:8] RET Domain EMC GBx Flag*/
#define PWR_EMCRETSTS2_RETGBxF_0                              ((uint32_t)0x00000100U)         /* Bit8*/
#define PWR_EMCRETSTS2_RETGBxF_1                              ((uint32_t)0x00000200U)         /* Bit9*/
#define PWR_EMCRETSTS2_RETGBxF_2                              ((uint32_t)0x00000400U)         /* Bit10*/
#define PWR_EMCRETSTS2_RETGBxF_3                              ((uint32_t)0x00000800U)         /* Bit11*/

#define PWR_EMCRETSTS2_RETGBNxF                               ((uint32_t)0x000000F0U)         /* Bit[7:4] RET Domain EMC GBNx Flag*/
#define PWR_EMCRETSTS2_RETGBNxF_0                             ((uint32_t)0x00000010U)         /* Bit4*/
#define PWR_EMCRETSTS2_RETGBNxF_1                             ((uint32_t)0x00000020U)         /* Bit5*/
#define PWR_EMCRETSTS2_RETGBNxF_2                             ((uint32_t)0x00000040U)         /* Bit6*/
#define PWR_EMCRETSTS2_RETGBNxF_3                             ((uint32_t)0x00000080U)         /* Bit7*/

#define PWR_EMCRETSTS2_RETCLPxF                               ((uint32_t)0x0000000FU)         /* Bit[3:0] RET Domain EMC Clampx Flag*/
#define PWR_EMCRETSTS2_RETCLPxF_0                             ((uint32_t)0x00000001U)         /* Bit0*/
#define PWR_EMCRETSTS2_RETCLPxF_1                             ((uint32_t)0x00000002U)         /* Bit1*/
#define PWR_EMCRETSTS2_RETCLPxF_2                             ((uint32_t)0x00000004U)         /* Bit2*/
#define PWR_EMCRETSTS2_RETCLPxF_3                             ((uint32_t)0x00000008U)         /* Bit3*/

/******** Bit definition for PWR_EMCRETCTRL3 register  ********/
#define PWR_EMCRETCTRL3_RETGBxDET                             ((uint32_t)0x00000F00U)         /* Bit[11:8] RET domain EMC GBx detection enable*/
#define PWR_EMCRETCTRL3_RETGBxDET_0                           ((uint32_t)0x00000100U)         /* Bit8*/
#define PWR_EMCRETCTRL3_RETGBxDET_1                           ((uint32_t)0x00000200U)         /* Bit9*/
#define PWR_EMCRETCTRL3_RETGBxDET_2                           ((uint32_t)0x00000400U)         /* Bit10*/
#define PWR_EMCRETCTRL3_RETGBxDET_3                           ((uint32_t)0x00000800U)         /* Bit11*/

#define PWR_EMCRETCTRL3_RETGBNxDET                            ((uint32_t)0x000000F0U)         /* Bit[7:4] RET domain EMC GBNx detection enable*/
#define PWR_EMCRETCTRL3_RETGBNxDET_0                          ((uint32_t)0x00000010U)         /* Bit4*/
#define PWR_EMCRETCTRL3_RETGBNxDET_1                          ((uint32_t)0x00000020U)         /* Bit5*/
#define PWR_EMCRETCTRL3_RETGBNxDET_2                          ((uint32_t)0x00000040U)         /* Bit6*/
#define PWR_EMCRETCTRL3_RETGBNxDET_3                          ((uint32_t)0x00000080U)         /* Bit7*/

#define PWR_EMCRETCTRL3_RETCLPxDET                            ((uint32_t)0x0000000FU)         /* Bit[3:0] RET domain EMC Clampx detection enable*/
#define PWR_EMCRETCTRL3_RETCLPxDET_0                          ((uint32_t)0x00000001U)         /* Bit0*/
#define PWR_EMCRETCTRL3_RETCLPxDET_1                          ((uint32_t)0x00000002U)         /* Bit1*/
#define PWR_EMCRETCTRL3_RETCLPxDET_2                          ((uint32_t)0x00000004U)         /* Bit2*/
#define PWR_EMCRETCTRL3_RETCLPxDET_3                          ((uint32_t)0x00000008U)         /* Bit3*/

/******** Bit definition for PWR_EMCRETSTS3 register  ********/
#define PWR_EMCRETSTS3_RETGBF                                 ((uint32_t)0x00000F00U)         /* Bit[11:8] RET Domain EMC GBx Flag*/
#define PWR_EMCRETSTS3_RETGBF_0                               ((uint32_t)0x00000100U)         /* Bit8*/
#define PWR_EMCRETSTS3_RETGBF_1                               ((uint32_t)0x00000200U)         /* Bit9*/
#define PWR_EMCRETSTS3_RETGBF_2                               ((uint32_t)0x00000400U)         /* Bit10*/
#define PWR_EMCRETSTS3_RETGBF_3                               ((uint32_t)0x00000800U)         /* Bit11*/

#define PWR_EMCRETSTS3_RETGBNF                                ((uint32_t)0x000000F0U)         /* Bit[7:4] RET Domain EMC GBNx Flag*/
#define PWR_EMCRETSTS3_RETGBNF_0                              ((uint32_t)0x00000010U)         /* Bit4*/
#define PWR_EMCRETSTS3_RETGBNF_1                              ((uint32_t)0x00000020U)         /* Bit5*/
#define PWR_EMCRETSTS3_RETGBNF_2                              ((uint32_t)0x00000040U)         /* Bit6*/
#define PWR_EMCRETSTS3_RETGBNF_3                              ((uint32_t)0x00000080U)         /* Bit7*/

#define PWR_EMCRETSTS3_RETCLPF                                ((uint32_t)0x0000000FU)         /* Bit[3:0] RET Domain EMC Clampx Flag*/
#define PWR_EMCRETSTS3_RETCLPF_0                              ((uint32_t)0x00000001U)         /* Bit0*/
#define PWR_EMCRETSTS3_RETCLPF_1                              ((uint32_t)0x00000002U)         /* Bit1*/
#define PWR_EMCRETSTS3_RETCLPF_2                              ((uint32_t)0x00000004U)         /* Bit2*/
#define PWR_EMCRETSTS3_RETCLPF_3                              ((uint32_t)0x00000008U)         /* Bit3*/

/******** Bit definition for PWR_EMCRETCTRL4 register  ********/
#define PWR_EMCRETCTRL4_RETGBxDET                             ((uint32_t)0x00000700U)         /* Bit[10:8] RET domain EMC GBx detection enable*/
#define PWR_EMCRETCTRL4_RETGBxDET_0                           ((uint32_t)0x00000100U)         /* Bit8*/
#define PWR_EMCRETCTRL4_RETGBxDET_1                           ((uint32_t)0x00000200U)         /* Bit9*/
#define PWR_EMCRETCTRL4_RETGBxDET_2                           ((uint32_t)0x00000400U)         /* Bit10*/

#define PWR_EMCRETCTRL4_RETGBNxDET                            ((uint32_t)0x00000070U)         /* Bit[6:4] RET domain EMC GBNx detection enable*/
#define PWR_EMCRETCTRL4_RETGBNxDET_0                          ((uint32_t)0x00000010U)         /* Bit4*/
#define PWR_EMCRETCTRL4_RETGBNxDET_1                          ((uint32_t)0x00000020U)         /* Bit5*/
#define PWR_EMCRETCTRL4_RETGBNxDET_2                          ((uint32_t)0x00000040U)         /* Bit6*/

#define PWR_EMCRETCTRL4_RETCLPxDET                            ((uint32_t)0x00000007U)         /* Bit[2:0] RET domain EMC Clampx detection enable*/
#define PWR_EMCRETCTRL4_RETCLPxDET_0                          ((uint32_t)0x00000001U)         /* Bit0*/
#define PWR_EMCRETCTRL4_RETCLPxDET_1                          ((uint32_t)0x00000002U)         /* Bit1*/
#define PWR_EMCRETCTRL4_RETCLPxDET_2                          ((uint32_t)0x00000004U)         /* Bit2*/

/******** Bit definition for PWR_EMCRETSTS4 register  ********/
#define PWR_EMCRETSTS4_RETGBxF                                ((uint32_t)0x00000700U)         /* Bit[10:8] RET Domain EMC GBx Flag*/
#define PWR_EMCRETSTS4_RETGBxF_0                              ((uint32_t)0x00000100U)         /* Bit8*/
#define PWR_EMCRETSTS4_RETGBxF_1                              ((uint32_t)0x00000200U)         /* Bit9*/
#define PWR_EMCRETSTS4_RETGBxF_2                              ((uint32_t)0x00000400U)         /* Bit10*/

#define PWR_EMCRETSTS4_RETGBNxF                               ((uint32_t)0x00000070U)         /* Bit[6:4] RET Domain EMC GBNx Flag*/
#define PWR_EMCRETSTS4_RETGBNxF_0                             ((uint32_t)0x00000010U)         /* Bit4*/
#define PWR_EMCRETSTS4_RETGBNxF_1                             ((uint32_t)0x00000020U)         /* Bit5*/
#define PWR_EMCRETSTS4_RETGBNxF_2                             ((uint32_t)0x00000040U)         /* Bit6*/

#define PWR_EMCRETSTS4_RETCLPxF                               ((uint32_t)0x00000007U)         /* Bit[2:0] RET Domain EMC Clampx Flag*/
#define PWR_EMCRETSTS4_RETCLPxF_0                             ((uint32_t)0x00000001U)         /* Bit0*/
#define PWR_EMCRETSTS4_RETCLPxF_1                             ((uint32_t)0x00000002U)         /* Bit1*/
#define PWR_EMCRETSTS4_RETCLPxF_2                             ((uint32_t)0x00000004U)         /* Bit2*/

/******** Bit definition for PWR_EMCBKPCTRL register  ********/
#define PWR_EMCBKPCTRL_BKPCBDET                               ((uint32_t)0x00000100U)         /* Bit[8] Backup domain EMC GB detection enable*/
#define PWR_EMCBKPCTRL_BKPCBNDET                              ((uint32_t)0x00000010U)         /* Bit[4] Backup domain EMC GBN detection enable*/
#define PWR_EMCBKPCTRL_BKPCLPDET                              ((uint32_t)0x00000001U)         /* Bit[0] Backup domain EMC Clamp  detection enable*/

/******** Bit definition for PWR_EMCBKPSTS register  ********/
#define PWR_EMCBKPSTS_BKPCLR                                  ((uint32_t)0x01000000U)         /* Bit[24] Clear EMC BKP flag*/
#define PWR_EMCBKPSTS_BKPGBF                                  ((uint32_t)0x00000100U)         /* Bit[8] Backup Domain EMC GB Flag*/
#define PWR_EMCBKPSTS_BKPGBNF                                 ((uint32_t)0x00000010U)         /* Bit[4] Backup Domain EMC GBN Flag*/
#define PWR_EMCBKPSTS_BKPCLPF                                 ((uint32_t)0x00000001U)         /* Bit[0] Backup Domain EMC Clamp Flag*/


    /******************************************************************************/
    /*                                                                            */
    /*                            Low Power UART                                  */
    /*                                                                            */
    /******************************************************************************/
/******** Bit definition for LPUART_STS register  ********/
#define LPUART_STS_TXFEF                                   ((uint32_t)0x00010000U)         /* Bit[16] transmit FIFO Empty Flag,1:FIFO is empty*/
#define LPUART_STS_FE                                      ((uint32_t)0x00008000U)         /* Bit[15]frame error detected, 1:detect frame error*/
#define LPUART_STS_IDLEF                                   ((uint32_t)0x00004000U)         /* Bit[14] IDLE frame detected,1:detect idle frame*/
#define LPUART_STS_TXFNEF                                  ((uint32_t)0x00002000U)         /* Bit[13] transmit FIFO Non-Empty Flag,1:FIFO is non-empty*/
#define LPUART_STS_TXFHFF                                  ((uint32_t)0x00001000U)         /* Bit[12] transmit FIFO Half Full Flag,1:FIFO is Half-Full*/
#define LPUART_STS_TXFQFF                                  ((uint32_t)0x00000800U)         /* Bit[11] transmit FIFO quarter Full Flag,1:FIFO is three-QUAR-Full*/
#define LPUART_STS_TXFFF                                   ((uint32_t)0x00000400U)         /* Bit[10] transmit FIFO Full Flag,1:FIFO is Full*/
#define LPUART_STS_TXFOF                                   ((uint32_t)0x00000200U)         /* Bit[9] transmit FIFO Overflow Flag,1:FIFO is overflow   */
#define LPUART_STS_NEF                                     ((uint32_t)0x00000100U)         /* Bit[8] Noise error Flag,1:Noise is detected*/
#define LPUART_STS_WUF                                     ((uint32_t)0x00000080U)         /* Bit[7] Wakeup from Stop mode Flag,1:Wakeup Events Detected*/
#define LPUART_STS_CTSF                                    ((uint32_t)0x00000040U)         /* Bit[6] Clear to Send Flag,1:CTS Line is Set*/
#define LPUART_STS_RXFNEF                                  ((uint32_t)0x00000020U)         /* Bit[5] FIFO Non-Empty Flag,1:FIFO is non-empty*/
#define LPUART_STS_RXFHFF                                  ((uint32_t)0x00000010U)         /* Bit[4] FIFO Half Full Flag,1:FIFO is Half-Full*/
#define LPUART_STS_RXFFF                                   ((uint32_t)0x00000008U)         /* Bit[3] FIFO Full Flag,1:FIFO is Full */
#define LPUART_STS_RXFOF                                   ((uint32_t)0x00000004U)         /* Bit[2] FIFO Overflow Flag, 1:FIFO is overflow*/
#define LPUART_STS_TXCF                                    ((uint32_t)0x00000002U)         /* Bit[1] TX Complete Flag,1:TX Transmission is Done*/
#define LPUART_STS_PCEF                                    ((uint32_t)0x00000001U)         /* Bit[0] Parity Check Error Flag,1:TX/RX Parity Error is Detected*/

/******** Bit definition for LPUART_INTEN register  ********/
#define LPUART_INTEN_TXFEIEN                                 ((uint32_t)0x00004000U)         /* Bit[14] TXFIFO Empty Interrupt Enable */
#define LPUART_INTEN_FEIEN                                   ((uint32_t)0x00002000U)         /* Bit[13] FRAME_ERROR Interrupt Enable*/
#define LPUART_INTEN_IDLEFIEN                                ((uint32_t)0x00001000U)         /* Bit[12] IDLE_FRAMEIE Interrupt Enable*/
#define LPUART_INTEN_TXFNEIEN                                ((uint32_t)0x00000800U)         /* Bit[11] TXFIFO Non-Empty Interrupt Enable*/
#define LPUART_INTEN_TXFHFIEN                                ((uint32_t)0x00000400U)         /* Bit[10] TXFIFO Half Full Interrupt Enable*/
#define LPUART_INTEN_TXFQFIEN                                ((uint32_t)0x00000200U)         /* Bit[9] TXFIFO QUAR Full Interrupt Enable*/
#define LPUART_INTEN_TXFFIEN                                 ((uint32_t)0x00000100U)         /* Bit[8] TXFIFO Full Interrupt Enable*/
#define LPUART_INTEN_TXFOIEN                                 ((uint32_t)0x00000080U)         /* Bit[7] TXFIFO Overflow Interrupt Enable*/
#define LPUART_INTEN_WUIEN                                   ((uint32_t)0x00000040U)         /* Bit[6] Wakeup Interrupt Enable*/
#define LPUART_INTEN_RXFNEIEN                                ((uint32_t)0x00000020U)         /* Bit[5] FIFO Non-Empty Interrupt Enable*/
#define LPUART_INTEN_RXFHFIEN                                ((uint32_t)0x00000010U)         /* Bit[4] FIFO Half Full Interrupt Enable*/
#define LPUART_INTEN_RXFFIEN                                 ((uint32_t)0x00000008U)         /* Bit[3] FIFO Full Interrupt Enable*/
#define LPUART_INTEN_RXFOIEN                                 ((uint32_t)0x00000004U)         /* Bit[2] FIFO Overflow Interrupt Enable*/
#define LPUART_INTEN_TXCIEN                                  ((uint32_t)0x00000002U)         /* Bit[1] TX Complete Interrupt Enable*/
#define LPUART_INTEN_PCEIEN                                  ((uint32_t)0x00000001U)         /* Bit[0] Parity Check Error Interrupt Enable*/

/******** Bit definition for LPUART_CTRL register  ********/
#define LPUART_CTRL_RXEN                                    ((uint32_t)0x01000000U)         /* Bit[24] RX Enable,1 Enable RX*/
#define LPUART_CTRL_RXNUMWU                            ((uint32_t)0x00F80000U)         /* Bit[23:19] can be configured to receive how many bytes of data to wake */
#define LPUART_CTRL_RXNUMWU_0                          ((uint32_t)0x00080000U)         /* Bit19*/
#define LPUART_CTRL_RXNUMWU_1                          ((uint32_t)0x00100000U)         /* Bit20*/
#define LPUART_CTRL_RXNUMWU_2                          ((uint32_t)0x00200000U)         /* Bit21*/
#define LPUART_CTRL_RXNUMWU_3                          ((uint32_t)0x00400000U)         /* Bit22*/
#define LPUART_CTRL_RXNUMWU_4                          ((uint32_t)0x00800000U)         /* Bit23*/
#define LPUART_CTRL_FTXF                               ((uint32_t)0x00040000U)         /* Bit[18] Flush transmit TXFIFO,1:Enable to Flush TXFIFO Content*/
#define LPUART_CTRL_IDLEFEN                            ((uint32_t)0x00020000U)         /* Bit[17] idle frame detect en,1:enable*/
#define LPUART_CTRL_SSM                                ((uint32_t)0x00010000U)         /* Bit[16] Specify the sampling method,1: 1 Sample*/
#define LPUART_CTRL_WUS                                ((uint32_t)0x0000F000U)         /* Bit[15:12] Wakeup Event Selection*/
#define LPUART_CTRL_WUS_0                              ((uint32_t)0x00001000U)         /* Bit12*/
#define LPUART_CTRL_WUS_1                              ((uint32_t)0x00002000U)         /* Bit13*/
#define LPUART_CTRL_WUS_2                              ((uint32_t)0x00004000U)         /* Bit14*/
#define LPUART_CTRL_WUS_3                              ((uint32_t)0x00008000U)         /* Bit15*/
#define LPUART_CTRL_RTSEN                              ((uint32_t)0x00000800U)         /* Bit[11] Hardware Flow Control RX Enable,1: Enable*/
#define LPUART_CTRL_CTSEN                              ((uint32_t)0x00000400U)         /* Bit[10] Hardware Flow Control TX Enable,1: Enable*/
#define LPUART_CTRL_RTST                               ((uint32_t)0x00000300U)         /* Bit[9:8] RTS Threshold*/
#define LPUART_CTRL_RTST_0                             ((uint32_t)0x00000100U)         /* Bit8*/
#define LPUART_CTRL_RTST_1                             ((uint32_t)0x00000200U)         /* Bit9*/
#define LPUART_CTRL_WUSTPEN                                 ((uint32_t)0x00000080U)         /* Bit[7] LPUART Wakeup Enable in Stop mode,1: Able to Wakeup in Stop mode*/
#define LPUART_CTRL_DMARXEN                                 ((uint32_t)0x00000040U)         /* Bit[6] DMA RX Request Enable*/
#define LPUART_CTRL_DMATXEN                                 ((uint32_t)0x00000020U)         /* Bit[5] DMA TX Request Enable*/
#define LPUART_CTRL_LB                                      ((uint32_t)0x00000010U)         /* Bit[4] LoopBack Self-Test,1: Loop Back Test*/
#define LPUART_CTRL_PC                                      ((uint32_t)0x00000008U)         /* Bit[3] Parity Control,1: Disabled Parity Bit*/
#define LPUART_CTRL_FRXF                                    ((uint32_t)0x00000004U)         /* Bit[2] Flush Receiver FIFO,1: Enable to Flush FIFO Content*/
#define LPUART_CTRL_TXEN                                    ((uint32_t)0x00000002U)         /* Bit[1] TX Enable,1: Enable TX*/
#define LPUART_CTRL_PEN                                     ((uint32_t)0x00000001U)         /* Bit[0] Odd Parity Bit Enable,1: Odd Parity Bit*/

/******** Bit definition for LPUART_BRCFG1 register  ********/
#define LPUART_BRCFG1_BRP                              ((uint32_t)0x0000FFFFU)         /* Bit[15:0] Baud Rate Parameter Register*/
#define LPUART_BRCFG1_BRP_0                            ((uint32_t)0x00000001U)         /* Bit0*/
#define LPUART_BRCFG1_BRP_1                            ((uint32_t)0x00000002U)         /* Bit1*/
#define LPUART_BRCFG1_BRP_2                            ((uint32_t)0x00000004U)         /* Bit2*/
#define LPUART_BRCFG1_BRP_3                            ((uint32_t)0x00000008U)         /* Bit3*/
#define LPUART_BRCFG1_BRP_4                            ((uint32_t)0x00000010U)         /* Bit4*/
#define LPUART_BRCFG1_BRP_5                            ((uint32_t)0x00000020U)         /* Bit5*/
#define LPUART_BRCFG1_BRP_6                            ((uint32_t)0x00000040U)         /* Bit6*/
#define LPUART_BRCFG1_BRP_7                            ((uint32_t)0x00000080U)         /* Bit7*/
#define LPUART_BRCFG1_BRP_8                            ((uint32_t)0x00000100U)         /* Bit8*/
#define LPUART_BRCFG1_BRP_9                            ((uint32_t)0x00000200U)         /* Bit9*/
#define LPUART_BRCFG1_BRP_10                           ((uint32_t)0x00000400U)         /* Bit10*/
#define LPUART_BRCFG1_BRP_11                           ((uint32_t)0x00000800U)         /* Bit11*/
#define LPUART_BRCFG1_BRP_12                           ((uint32_t)0x00001000U)         /* Bit12*/
#define LPUART_BRCFG1_BRP_13                           ((uint32_t)0x00002000U)         /* Bit13*/
#define LPUART_BRCFG1_BRP_14                           ((uint32_t)0x00004000U)         /* Bit14*/
#define LPUART_BRCFG1_BRP_15                           ((uint32_t)0x00008000U)        /* Bit15*/

/******** Bit definition for LPUART_TXDAT register  ********/
#define LPUART_TXDAT_DAT                                ((uint32_t)0x000000FFU)         /* Bit[7:0] Write to Data Register for TXFIFO */
#define LPUART_TXDAT_DAT_0                              ((uint32_t)0x00000001U)         /* Bit0*/
#define LPUART_TXDAT_DAT_1                              ((uint32_t)0x00000002U)         /* Bit1*/
#define LPUART_TXDAT_DAT_2                              ((uint32_t)0x00000004U)         /* Bit2*/
#define LPUART_TXDAT_DAT_3                              ((uint32_t)0x00000008U)         /* Bit3*/
#define LPUART_TXDAT_DAT_4                              ((uint32_t)0x00000010U)         /* Bit4*/
#define LPUART_TXDAT_DAT_5                              ((uint32_t)0x00000020U)         /* Bit5*/
#define LPUART_TXDAT_DAT_6                              ((uint32_t)0x00000040U)         /* Bit6*/
#define LPUART_TXDAT_DAT_7                              ((uint32_t)0x00000080U)         /* Bit7*/

/******** Bit definition for LPUART_BRCFG2 register  ********/
#define LPUART_BRCFG2_MC                                ((uint32_t)0x000000FFU)         /* Bit[7:0] Modulation Control Register For Baud Rate Error Correction at Low */
#define LPUART_BRCFG2_MC_0                              ((uint32_t)0x00000001U)         /* Bit0*/
#define LPUART_BRCFG2_MC_1                              ((uint32_t)0x00000002U)         /* Bit1*/
#define LPUART_BRCFG2_MC_2                              ((uint32_t)0x00000004U)         /* Bit2*/
#define LPUART_BRCFG2_MC_3                              ((uint32_t)0x00000008U)         /* Bit3*/
#define LPUART_BRCFG2_MC_4                              ((uint32_t)0x00000010U)         /* Bit4*/
#define LPUART_BRCFG2_MC_5                              ((uint32_t)0x00000020U)         /* Bit5*/
#define LPUART_BRCFG2_MC_6                              ((uint32_t)0x00000040U)         /* Bit6*/
#define LPUART_BRCFG2_MC_7                              ((uint32_t)0x00000080U)         /* Bit7*/

/******** Bit definition for LPUART_WUDAT1 register  ********/
#define LPUART_WUDAT1_DAT                               ((uint32_t)0xFFFFFFFFU)         /* Bit[31:0] Configure this register to detect byte or frame match for wakeup CPU from stop mode*/

/******** Bit definition for LPUART_WUDAT2 register  ********/
#define LPUART_WUDAT2_DAT                              ((uint32_t)0xFFFFFFFFU)         /* Bit[31:0] Configure this register to detect byte or frame match for wakeup CPU from stop mode*/

/******** Bit definition for LPUART_RXDAT register  ********/
#define LPUART_RXDAT_DAT                                ((uint32_t)0x000000FFU)         /* Bit[7:0] Read this register to read RX data from RX FIFO*/
#define LPUART_RXDAT_DAT_0                              ((uint32_t)0x00000001U)         /* Bit0*/
#define LPUART_RXDAT_DAT_1                              ((uint32_t)0x00000002U)         /* Bit1*/
#define LPUART_RXDAT_DAT_2                              ((uint32_t)0x00000004U)         /* Bit2*/
#define LPUART_RXDAT_DAT_3                              ((uint32_t)0x00000008U)         /* Bit3*/
#define LPUART_RXDAT_DAT_4                              ((uint32_t)0x00000010U)         /* Bit4*/
#define LPUART_RXDAT_DAT_5                              ((uint32_t)0x00000020U)         /* Bit5*/
#define LPUART_RXDAT_DAT_6                              ((uint32_t)0x00000040U)         /* Bit6*/
#define LPUART_RXDAT_DAT_7                              ((uint32_t)0x00000080U)         /* Bit7*/

    

    /******************************************************************************/
    /*                                                                            */
    /*                            Backup registers                                */
    /*                                                                            */
    /******************************************************************************/

    /*******************  Bit definition for BKP_DR1 register  ********************/
#define  BKP_DR1_D                           ((uint16_t)0xFFFF)     /*!< Backup data */

    /*******************  Bit definition for BKP_DR2 register  ********************/
#define  BKP_DR2_D                           ((uint16_t)0xFFFF)     /*!< Backup data */

    /*******************  Bit definition for BKP_DR3 register  ********************/
#define  BKP_DR3_D                           ((uint16_t)0xFFFF)     /*!< Backup data */

    /*******************  Bit definition for BKP_DR4 register  ********************/
#define  BKP_DR4_D                           ((uint16_t)0xFFFF)     /*!< Backup data */

    /*******************  Bit definition for BKP_DR5 register  ********************/
#define  BKP_DR5_D                           ((uint16_t)0xFFFF)     /*!< Backup data */

    /*******************  Bit definition for BKP_DR6 register  ********************/
#define  BKP_DR6_D                           ((uint16_t)0xFFFF)     /*!< Backup data */

    /*******************  Bit definition for BKP_DR7 register  ********************/
#define  BKP_DR7_D                           ((uint16_t)0xFFFF)     /*!< Backup data */

    /*******************  Bit definition for BKP_DR8 register  ********************/
#define  BKP_DR8_D                           ((uint16_t)0xFFFF)     /*!< Backup data */

    /*******************  Bit definition for BKP_DR9 register  ********************/
#define  BKP_DR9_D                           ((uint16_t)0xFFFF)     /*!< Backup data */

    /*******************  Bit definition for BKP_DR10 register  *******************/
#define  BKP_DR10_D                          ((uint16_t)0xFFFF)     /*!< Backup data */

    /*******************  Bit definition for BKP_DR11 register  *******************/
#define  BKP_DR11_D                          ((uint16_t)0xFFFF)     /*!< Backup data */

    /*******************  Bit definition for BKP_DR12 register  *******************/
#define  BKP_DR12_D                          ((uint16_t)0xFFFF)     /*!< Backup data */

    /*******************  Bit definition for BKP_DR13 register  *******************/
#define  BKP_DR13_D                          ((uint16_t)0xFFFF)     /*!< Backup data */

    /*******************  Bit definition for BKP_DR14 register  *******************/
#define  BKP_DR14_D                          ((uint16_t)0xFFFF)     /*!< Backup data */

    /*******************  Bit definition for BKP_DR15 register  *******************/
#define  BKP_DR15_D                          ((uint16_t)0xFFFF)     /*!< Backup data */

    /*******************  Bit definition for BKP_DR16 register  *******************/
#define  BKP_DR16_D                          ((uint16_t)0xFFFF)     /*!< Backup data */

    /*******************  Bit definition for BKP_DR17 register  *******************/
#define  BKP_DR17_D                          ((uint16_t)0xFFFF)     /*!< Backup data */

    /******************  Bit definition for BKP_DR18 register  ********************/
#define  BKP_DR18_D                          ((uint16_t)0xFFFF)     /*!< Backup data */

    /*******************  Bit definition for BKP_DR19 register  *******************/
#define  BKP_DR19_D                          ((uint16_t)0xFFFF)     /*!< Backup data */

    /*******************  Bit definition for BKP_DR20 register  *******************/
#define  BKP_DR20_D                          ((uint16_t)0xFFFF)     /*!< Backup data */

    /*******************  Bit definition for BKP_DR21 register  *******************/
#define  BKP_DR21_D                          ((uint16_t)0xFFFF)     /*!< Backup data */

    /*******************  Bit definition for BKP_DR22 register  *******************/
#define  BKP_DR22_D                          ((uint16_t)0xFFFF)     /*!< Backup data */

    /*******************  Bit definition for BKP_DR23 register  *******************/
#define  BKP_DR23_D                          ((uint16_t)0xFFFF)     /*!< Backup data */

    /*******************  Bit definition for BKP_DR24 register  *******************/
#define  BKP_DR24_D                          ((uint16_t)0xFFFF)     /*!< Backup data */

    /*******************  Bit definition for BKP_DR25 register  *******************/
#define  BKP_DR25_D                          ((uint16_t)0xFFFF)     /*!< Backup data */

    /*******************  Bit definition for BKP_DR26 register  *******************/
#define  BKP_DR26_D                          ((uint16_t)0xFFFF)     /*!< Backup data */

    /*******************  Bit definition for BKP_DR27 register  *******************/
#define  BKP_DR27_D                          ((uint16_t)0xFFFF)     /*!< Backup data */

    /*******************  Bit definition for BKP_DR28 register  *******************/
#define  BKP_DR28_D                          ((uint16_t)0xFFFF)     /*!< Backup data */

    /*******************  Bit definition for BKP_DR29 register  *******************/
#define  BKP_DR29_D                          ((uint16_t)0xFFFF)     /*!< Backup data */

    /*******************  Bit definition for BKP_DR30 register  *******************/
#define  BKP_DR30_D                          ((uint16_t)0xFFFF)     /*!< Backup data */

    /*******************  Bit definition for BKP_DR31 register  *******************/
#define  BKP_DR31_D                          ((uint16_t)0xFFFF)     /*!< Backup data */

    /*******************  Bit definition for BKP_DR32 register  *******************/
#define  BKP_DR32_D                          ((uint16_t)0xFFFF)     /*!< Backup data */

    /*******************  Bit definition for BKP_DR33 register  *******************/
#define  BKP_DR33_D                          ((uint16_t)0xFFFF)     /*!< Backup data */

    /*******************  Bit definition for BKP_DR34 register  *******************/
#define  BKP_DR34_D                          ((uint16_t)0xFFFF)     /*!< Backup data */

    /*******************  Bit definition for BKP_DR35 register  *******************/
#define  BKP_DR35_D                          ((uint16_t)0xFFFF)     /*!< Backup data */

    /*******************  Bit definition for BKP_DR36 register  *******************/
#define  BKP_DR36_D                          ((uint16_t)0xFFFF)     /*!< Backup data */

    /*******************  Bit definition for BKP_DR37 register  *******************/
#define  BKP_DR37_D                          ((uint16_t)0xFFFF)     /*!< Backup data */

    /*******************  Bit definition for BKP_DR38 register  *******************/
#define  BKP_DR38_D                          ((uint16_t)0xFFFF)     /*!< Backup data */

    /*******************  Bit definition for BKP_DR39 register  *******************/
#define  BKP_DR39_D                          ((uint16_t)0xFFFF)     /*!< Backup data */

    /*******************  Bit definition for BKP_DR40 register  *******************/
#define  BKP_DR40_D                          ((uint16_t)0xFFFF)     /*!< Backup data */

    /*******************  Bit definition for BKP_DR41 register  *******************/
#define  BKP_DR41_D                          ((uint16_t)0xFFFF)     /*!< Backup data */

    /*******************  Bit definition for BKP_DR42 register  *******************/
#define  BKP_DR42_D                          ((uint16_t)0xFFFF)     /*!< Backup data */

    /******************  Bit definition for BKP_RTCCR register  *******************/
#define  BKP_RTCCR_CAL                       ((uint16_t)0x007F)     /*!< Calibration value */
#define  BKP_RTCCR_CCO                       ((uint16_t)0x0080)     /*!< Calibration Clock Output */
#define  BKP_RTCCR_ASOE                      ((uint16_t)0x0100)     /*!< Alarm or Second Output Enable */
#define  BKP_RTCCR_ASOS                      ((uint16_t)0x0200)     /*!< Alarm or Second Output Selection */

    /********************  Bit definition for BKP_CR register  ********************/
#define  BKP_CR_TPE                          ((uint8_t)0x01)        /*!< TAMPER pin enable */
#define  BKP_CR_TPAL                         ((uint8_t)0x02)        /*!< TAMPER pin active level */

    /*******************  Bit definition for BKP_CSR register  ********************/
#define  BKP_CSR_CTE                         ((uint16_t)0x0001)     /*!< Clear Tamper event */
#define  BKP_CSR_CTI                         ((uint16_t)0x0002)     /*!< Clear Tamper Interrupt */
#define  BKP_CSR_TPIE                        ((uint16_t)0x0004)     /*!< TAMPER Pin interrupt enable */
#define  BKP_CSR_TEF                         ((uint16_t)0x0100)     /*!< Tamper Event Flag */
#define  BKP_CSR_TIF                         ((uint16_t)0x0200)     /*!< Tamper Interrupt Flag */



/***    Cylic Redundancy Check(CRC) Calculation Unit  ***/
/********************  Bit definition for CRC_DAT register  ********************/
#define CRC_DAT_DAT                 ((uint32_t)0xFFFFFFFFU) /* Bit[31:0] CRC data */

/********************  Bit definition for CRC_IDAT register  ********************/
#define CRC_IDAT_IDAT               ((uint32_t)0xFFFFFFFFU) /* Bit[31:0] CRC independent data */

/********************  Bit definition for CRC_CTRL register  ********************/
#define CRC_CTRL_RESET              ((uint32_t)0x00000001U) /* Bit[0] CRC calculation unit reset */

#define CRC_CTRL_BYTEENDIAN         ((uint32_t)0x00000006U) /* Bit[2:1] CRC byte Endian bits[1:0] */
#define CRC_CTRL_BYTEENDIAN_0       ((uint32_t)0x00000002U) /* Bit[1] CRC byte Endian bit0 */
#define CRC_CTRL_BYTEENDIAN_1       ((uint32_t)0x00000004U) /* Bit[2] CRC byte Endian bit1 */

#define CRC_CTRL_POLYSIZE           ((uint32_t)0x00000018U) /* Bit[4:3] CRC polynomial size bits[1:0] */
#define CRC_CTRL_POLYSIZE_0         ((uint32_t)0x00000008U) /* Bit[3] CRC polynomial size bit0 */
#define CRC_CTRL_POLYSIZE_1         ((uint32_t)0x00000010U) /* Bit[4] CRC polynomial size bit1 */

#define CRC_CTRL_REVIN              ((uint32_t)0x00000060U) /* Bit[6:5] CRC input data reverse bits[1:0] */
#define CRC_CTRL_REVIN_0            ((uint32_t)0x00000020U) /* Bit[5] CRC input data reverse bit0 */
#define CRC_CTRL_REVIN_1            ((uint32_t)0x00000040U) /* Bit[6] CRC input data reverse bit1 */

#define CRC_CTRL_REVOUT             ((uint32_t)0x00000080U) /* Bit[7] CRC output data reverse bit */

/********************  Bit definition for CRC_LRC register  ********************/
#define CRC_LRC_LRC                 ((uint32_t)0xFFFFFFFFU) /* Bit[31:0] CRC LRC value bits */

/*******************  Bit definition for CRC_INIT register  *******************/
#define CRC_INIT_INIT               ((uint32_t)0xFFFFFFFFU) /* Bit[31:0] CRC initial value bits */

/*******************  Bit definition for CRC_POL register  ********************/
#define CRC_POL_POL                 ((uint32_t)0xFFFFFFFFU) /* Bit[31:0] CRC pllynomial coefficients bits */

/*******************  Bit definition for CRC_INXORDAT register  ********************/
#define CRC_INXORDAT_INXOR          ((uint32_t)0xFFFFFFFFU) /* Bit[31:0] CRC XOR bits before calculation */

/*******************  Bit definition for CRC_OUTXORDAT register  ********************/
#define CRC_OUTXORDAT_OUTXOR        ((uint32_t)0xFFFFFFFFU) /* Bit[31:0] CRC XOR bits after calculation */



    /******************************************************************************/
    /*                                                                            */
    /*                General Purpose and Alternate Function I/O                  */
    /*                                                                            */
    /******************************************************************************/

/******** Bit definition for GPIOx_PMODE register  ********/
#define GPIO_PMODE_PMODE0           ((uint32_t)0x00000003U) /* Port x Pin 0 mode bits */
#define GPIO_PMODE_PMODE0_0         ((uint32_t)0x00000001U) /* Port x Pin 0 mode bit 0 */
#define GPIO_PMODE_PMODE0_1         ((uint32_t)0x00000002U) /* Port x Pin 0 mode bit 1 */

#define GPIO_PMODE_PMODE1           ((uint32_t)0x0000000CU) /* Port x Pin 1 mode bits */
#define GPIO_PMODE_PMODE1_0         ((uint32_t)0x00000004U) /* Port x Pin 1 mode bit 0 */
#define GPIO_PMODE_PMODE1_1         ((uint32_t)0x00000008U) /* Port x Pin 1 mode bit 1 */

#define GPIO_PMODE_PMODE2           ((uint32_t)0x00000030U) /* Port x Pin 2 mode bits */
#define GPIO_PMODE_PMODE2_0         ((uint32_t)0x00000010U) /* Port x Pin 2 mode bit 0 */
#define GPIO_PMODE_PMODE2_1         ((uint32_t)0x00000020U) /* Port x Pin 2 mode bit 1 */

#define GPIO_PMODE_PMODE3           ((uint32_t)0x000000C0U) /* Port x Pin 3 mode bits */
#define GPIO_PMODE_PMODE3_0         ((uint32_t)0x00000040U) /* Port x Pin 3 mode bit 0 */
#define GPIO_PMODE_PMODE3_1         ((uint32_t)0x00000080U) /* Port x Pin 3 mode bit 1 */

#define GPIO_PMODE_PMODE4           ((uint32_t)0x00000300U) /* Port x Pin 4 mode bits */
#define GPIO_PMODE_PMODE4_0         ((uint32_t)0x00000100U) /* Port x Pin 4 mode bit 0 */
#define GPIO_PMODE_PMODE4_1         ((uint32_t)0x00000200U) /* Port x Pin 4 mode bit 1 */

#define GPIO_PMODE_PMODE5           ((uint32_t)0x00000C00U) /* Port x Pin 5 mode bits */
#define GPIO_PMODE_PMODE5_0         ((uint32_t)0x00000400U) /* Port x Pin 5 mode bit 0 */
#define GPIO_PMODE_PMODE5_1         ((uint32_t)0x00000800U) /* Port x Pin 5 mode bit 1 */

#define GPIO_PMODE_PMODE6           ((uint32_t)0x00003000U) /* Port x Pin 6 mode bits */
#define GPIO_PMODE_PMODE6_0         ((uint32_t)0x00001000U) /* Port x Pin 6 mode bit 0 */
#define GPIO_PMODE_PMODE6_1         ((uint32_t)0x00002000U) /* Port x Pin 6 mode bit 1 */

#define GPIO_PMODE_PMODE7           ((uint32_t)0x0000C000U) /* Port x Pin 7 mode bits */
#define GPIO_PMODE_PMODE7_0         ((uint32_t)0x00004000U) /* Port x Pin 7 mode bit 0 */
#define GPIO_PMODE_PMODE7_1         ((uint32_t)0x00008000U) /* Port x Pin 7 mode bit 1 */

#define GPIO_PMODE_PMODE8           ((uint32_t)0x00030000U) /* Port x Pin 8 mode bits */
#define GPIO_PMODE_PMODE8_0         ((uint32_t)0x00010000U) /* Port x Pin 8 mode bit 0 */
#define GPIO_PMODE_PMODE8_1         ((uint32_t)0x00020000U) /* Port x Pin 8 mode bit 1 */

#define GPIO_PMODE_PMODE9           ((uint32_t)0x000C0000U) /* Port x Pin 9 mode bits */
#define GPIO_PMODE_PMODE9_0         ((uint32_t)0x00040000U) /* Port x Pin 9 mode bit 0 */
#define GPIO_PMODE_PMODE9_1         ((uint32_t)0x00080000U) /* Port x Pin 9 mode bit 1 */

#define GPIO_PMODE_PMODE10          ((uint32_t)0x00300000U) /* Port x Pin 10 mode bits */
#define GPIO_PMODE_PMODE10_0        ((uint32_t)0x00100000U) /* Port x Pin 10 mode bit 0 */
#define GPIO_PMODE_PMODE10_1        ((uint32_t)0x00200000U) /* Port x Pin 10 mode bit 1 */

#define GPIO_PMODE_PMODE11          ((uint32_t)0x00C00000U) /* Port x Pin 11 mode bits */
#define GPIO_PMODE_PMODE11_0        ((uint32_t)0x00400000U) /* Port x Pin 11 mode bit 0 */
#define GPIO_PMODE_PMODE11_1        ((uint32_t)0x00800000U) /* Port x Pin 11 mode bit 1 */

#define GPIO_PMODE_PMODE12          ((uint32_t)0x03000000U) /* Port x Pin 12 mode bits */
#define GPIO_PMODE_PMODE12_0        ((uint32_t)0x01000000U) /* Port x Pin 12 mode bit 0 */
#define GPIO_PMODE_PMODE12_1        ((uint32_t)0x02000000U) /* Port x Pin 12 mode bit 1 */

#define GPIO_PMODE_PMODE13          ((uint32_t)0x0C000000U) /* Port x Pin 13 mode bits */
#define GPIO_PMODE_PMODE13_0        ((uint32_t)0x04000000U) /* Port x Pin 13 mode bit 0 */
#define GPIO_PMODE_PMODE13_1        ((uint32_t)0x08000000U) /* Port x Pin 13 mode bit 1 */

#define GPIO_PMODE_PMODE14          ((uint32_t)0x30000000U) /* Port x Pin 14 mode bits */
#define GPIO_PMODE_PMODE14_0        ((uint32_t)0x10000000U) /* Port x Pin 14 mode bit 0 */
#define GPIO_PMODE_PMODE14_1        ((uint32_t)0x20000000U) /* Port x Pin 14 mode bit 1 */

#define GPIO_PMODE_PMODE15          ((uint32_t)0xC0000000U) /* Port x Pin 15 mode bits */
#define GPIO_PMODE_PMODE15_0        ((uint32_t)0x40000000U) /* Port x Pin 15 mode bit 0 */
#define GPIO_PMODE_PMODE15_1        ((uint32_t)0x80000000U) /* Port x Pin 15 mode bit 1 */

#define GPIO_PMODE_INPUT            ((uint32_t)0x00000000U)  /* Input mode */
#define GPIO_PMODE_OUTPUT           ((uint32_t)0x00000001U)  /* General output mode */
#define GPIO_PMODE_AF_OUTPUT        ((uint32_t)0x00000002U)  /* Alternate output mode */
#define GPIO_PMODE_ANALOG           ((uint32_t)0x00000003U)  /* Analog mode */

    /******************  Bit definition for GPIO_POTYPE register  *****************/
#define GPIO_POTYPE_POT0            ((uint32_t)0x00000001U)  /* Port x Pin 0 output type bits */
#define GPIO_POTYPE_POT1            ((uint32_t)0x00000002U)  /* Port x Pin 1 output type bits */
#define GPIO_POTYPE_POT2            ((uint32_t)0x00000004U)  /* Port x Pin 2 output type bits */
#define GPIO_POTYPE_POT3            ((uint32_t)0x00000008U)  /* Port x Pin 3 output type bits */
#define GPIO_POTYPE_POT4            ((uint32_t)0x00000010U)  /* Port x Pin 4 output type bits */
#define GPIO_POTYPE_POT5            ((uint32_t)0x00000020U)  /* Port x Pin 5 output type bits */
#define GPIO_POTYPE_POT6            ((uint32_t)0x00000040U)  /* Port x Pin 6 output type bits */
#define GPIO_POTYPE_POT7            ((uint32_t)0x00000080U)  /* Port x Pin 7 output type bits */
#define GPIO_POTYPE_POT8            ((uint32_t)0x00000100U)  /* Port x Pin 8 output type bits */
#define GPIO_POTYPE_POT9            ((uint32_t)0x00000200U)  /* Port x Pin 9 output type bits */
#define GPIO_POTYPE_POT10           ((uint32_t)0x00000400U)  /* Port x Pin 10 output type bits */
#define GPIO_POTYPE_POT11           ((uint32_t)0x00000800U)  /* Port x Pin 11 output type bits */
#define GPIO_POTYPE_POT12           ((uint32_t)0x00001000U)  /* Port x Pin 12 output type bits */
#define GPIO_POTYPE_POT13           ((uint32_t)0x00002000U)  /* Port x Pin 13 output type bits */
#define GPIO_POTYPE_POT14           ((uint32_t)0x00004000U)  /* Port x Pin 14 output type bits */
#define GPIO_POTYPE_POT15           ((uint32_t)0x00008000U)  /* Port x Pin 15 output type bits */

#define GPIO_POTYPE_PUSH_PULL       ((uint32_t)0x00000000U)
#define GPIO_POTYPE_OPEN_DRAIN      ((uint32_t)0x00000001U)

/** Bit definition for GPIO_SR register **/
#define GPIO_SR_SR0                 ((uint32_t)0x00000001U) /* Port x Pin 0 Slew rate bit  */
#define GPIO_SR_SR1                 ((uint32_t)0x00000002U) /* Port x Pin 1 Slew rate bit  */
#define GPIO_SR_SR2                 ((uint32_t)0x00000004U) /* Port x Pin 2 Slew rate bit  */
#define GPIO_SR_SR3                 ((uint32_t)0x00000008U) /* Port x Pin 3 Slew rate bit  */
#define GPIO_SR_SR4                 ((uint32_t)0x00000010U) /* Port x Pin 4 Slew rate bit  */
#define GPIO_SR_SR5                 ((uint32_t)0x00000020U) /* Port x Pin 5 Slew rate bit  */
#define GPIO_SR_SR6                 ((uint32_t)0x00000040U) /* Port x Pin 6 Slew rate bit  */
#define GPIO_SR_SR7                 ((uint32_t)0x00000080U) /* Port x Pin 7 Slew rate bit  */
#define GPIO_SR_SR8                 ((uint32_t)0x00000100U) /* Port x Pin 8 Slew rate bit  */
#define GPIO_SR_SR9                 ((uint32_t)0x00000200U) /* Port x Pin 9 Slew rate bit  */
#define GPIO_SR_SR10                ((uint32_t)0x00000400U) /* Port x Pin 10 Slew rate bit  */
#define GPIO_SR_SR11                ((uint32_t)0x00000800U) /* Port x Pin 11 Slew rate bit  */
#define GPIO_SR_SR12                ((uint32_t)0x00001000U) /* Port x Pin 12 Slew rate bit  */
#define GPIO_SR_SR13                ((uint32_t)0x00002000U) /* Port x Pin 13 Slew rate bit  */
#define GPIO_SR_SR14                ((uint32_t)0x00004000U) /* Port x Pin 14 Slew rate bit  */
#define GPIO_SR_SR15                ((uint32_t)0x00008000U) /* Port x Pin 15 Slew rate bit  */

#define GPIO_SR_FAST_SLEW           ((uint32_t)0x00000000U) /* Fast slew rate */
#define GPIO_SR_SLOW_SLEW           ((uint32_t)0x00000001U) /* Slow slew rate */

/** Bit definition for GPIO_PUPD register **/
#define GPIO_PUPD_PUPD0             ((uint32_t)0x00000003U)  /* Port x Pin 0 pull control bits */
#define GPIO_PUPD_PUPD0_0           ((uint32_t)0x00000001U)  /* Port x Pin 0 pull control bit 0 */
#define GPIO_PUPD_PUPD0_1           ((uint32_t)0x00000002U)  /* Port x Pin 0 pull control bit 1 */

#define GPIO_PUPD_PUPD1             ((uint32_t)0x0000000CU)  /* Port x Pin 1 pull control bits */
#define GPIO_PUPD_PUPD1_0           ((uint32_t)0x00000004U)  /* Port x Pin 1 pull control bit 0 */
#define GPIO_PUPD_PUPD1_1           ((uint32_t)0x00000008U)  /* Port x Pin 1 pull control bit 1 */

#define GPIO_PUPD_PUPD2             ((uint32_t)0x00000030U)  /* Port x Pin 2 pull control bits */
#define GPIO_PUPD_PUPD2_0           ((uint32_t)0x00000010U)  /* Port x Pin 2 pull control bit 0 */
#define GPIO_PUPD_PUPD2_1           ((uint32_t)0x00000020U)  /* Port x Pin 2 pull control bit 1 */

#define GPIO_PUPD_PUPD3             ((uint32_t)0x000000C0U)  /* Port x Pin 3 pull control bits */
#define GPIO_PUPD_PUPD3_0           ((uint32_t)0x00000040U)  /* Port x Pin 3 pull control bit 0 */
#define GPIO_PUPD_PUPD3_1           ((uint32_t)0x00000080U)  /* Port x Pin 3 pull control bit 1 */

#define GPIO_PUPD_PUPD4             ((uint32_t)0x00000300U)  /* Port x Pin 4 pull control bits */
#define GPIO_PUPD_PUPD4_0           ((uint32_t)0x00000100U)  /* Port x Pin 4 pull control bit 0 */
#define GPIO_PUPD_PUPD4_1           ((uint32_t)0x00000200U)  /* Port x Pin 4 pull control bit 1 */

#define GPIO_PUPD_PUPD5             ((uint32_t)0x00000C00U)  /* Port x Pin 5 pull control bits */
#define GPIO_PUPD_PUPD5_0           ((uint32_t)0x00000400U)  /* Port x Pin 5 pull control bit 0 */
#define GPIO_PUPD_PUPD5_1           ((uint32_t)0x00000800U)  /* Port x Pin 5 pull control bit 1 */

#define GPIO_PUPD_PUPD6             ((uint32_t)0x00003000U)  /* Port x Pin 6 pull control bits */
#define GPIO_PUPD_PUPD6_0           ((uint32_t)0x00001000U)  /* Port x Pin 6 pull control bit 0 */
#define GPIO_PUPD_PUPD6_1           ((uint32_t)0x00002000U)  /* Port x Pin 6 pull control bit 1 */

#define GPIO_PUPD_PUPD7             ((uint32_t)0x0000C000U)  /* Port x Pin 7 pull control bits */
#define GPIO_PUPD_PUPD7_0           ((uint32_t)0x00004000U)  /* Port x Pin 7 pull control bit 0 */
#define GPIO_PUPD_PUPD7_1           ((uint32_t)0x00008000U)  /* Port x Pin 7 pull control bit 1 */

#define GPIO_PUPD_PUPD8             ((uint32_t)0x00030000U)  /* Port x Pin 8 pull control bits */
#define GPIO_PUPD_PUPD8_0           ((uint32_t)0x00010000U)  /* Port x Pin 8 pull control bit 0 */
#define GPIO_PUPD_PUPD8_1           ((uint32_t)0x00020000U)  /* Port x Pin 8 pull control bit 1 */

#define GPIO_PUPD_PUPD9             ((uint32_t)0x000C0000U)  /* Port x Pin 9 pull control bits */
#define GPIO_PUPD_PUPD9_0           ((uint32_t)0x00040000U)  /* Port x Pin 9 pull control bit 0 */
#define GPIO_PUPD_PUPD9_1           ((uint32_t)0x00080000U)  /* Port x Pin 9 pull control bit 1 */

#define GPIO_PUPD_PUPD10            ((uint32_t)0x00300000U)  /* Port x Pin 10 pull control bits */
#define GPIO_PUPD_PUPD10_0          ((uint32_t)0x00100000U)  /* Port x Pin 10 pull control bit 0 */
#define GPIO_PUPD_PUPD10_1          ((uint32_t)0x00200000U)  /* Port x Pin 10 pull control bit 1 */

#define GPIO_PUPD_PUPD11            ((uint32_t)0x00C00000U)  /* Port x Pin 11 pull control bits */
#define GPIO_PUPD_PUPD11_0          ((uint32_t)0x00400000U)  /* Port x Pin 11 pull control bit 0 */
#define GPIO_PUPD_PUPD11_1          ((uint32_t)0x00800000U)  /* Port x Pin 11 pull control bit 1 */

#define GPIO_PUPD_PUPD12            ((uint32_t)0x03000000U)  /* Port x Pin 12 pull control bits */
#define GPIO_PUPD_PUPD12_0          ((uint32_t)0x01000000U)  /* Port x Pin 12 pull control bit 0 */
#define GPIO_PUPD_PUPD12_1          ((uint32_t)0x02000000U)  /* Port x Pin 12 pull control bit 1 */

#define GPIO_PUPD_PUPD13            ((uint32_t)0x0C000000U)  /* Port x Pin 13 pull control bits */
#define GPIO_PUPD_PUPD13_0          ((uint32_t)0x04000000U)  /* Port x Pin 13 pull control bit 0 */
#define GPIO_PUPD_PUPD13_1          ((uint32_t)0x08000000U)  /* Port x Pin 13 pull control bit 1 */

#define GPIO_PUPD_PUPD14            ((uint32_t)0x30000000U)  /* Port x Pin 14 pull control bits */
#define GPIO_PUPD_PUPD14_0          ((uint32_t)0x10000000U)  /* Port x Pin 14 pull control bit 0 */
#define GPIO_PUPD_PUPD14_1          ((uint32_t)0x20000000U)  /* Port x Pin 14 pull control bit 1 */

#define GPIO_PUPD_PUPD15            ((uint32_t)0xC0000000U)  /* Port x Pin 15 pull control bits */
#define GPIO_PUPD_PUPD15_0          ((uint32_t)0x40000000U)  /* Port x Pin 15 pull control bit 0 */
#define GPIO_PUPD_PUPD15_1          ((uint32_t)0x80000000U)  /* Port x Pin 15 pull control bit 1 */


#define GPIO_PUPD_NO_PULL           ((uint32_t)0x00000000U)  /* No pull */
#define GPIO_PUPD_PULL_UP           ((uint32_t)0x00000001U)  /* Pull up*/
#define GPIO_PUPD_PULL_DOWN         ((uint32_t)0x00000002U)  /* Pull down */

/** Bit definition for GPIO_PID register **/
#define GPIO_PID_PID0               ((uint16_t)0x0001U) /* Port x Pin 0 input bit */
#define GPIO_PID_PID1               ((uint16_t)0x0002U) /* Port x Pin 1 input bit */
#define GPIO_PID_PID2               ((uint16_t)0x0004U) /* Port x Pin 2 input bit */
#define GPIO_PID_PID3               ((uint16_t)0x0008U) /* Port x Pin 3 input bit */
#define GPIO_PID_PID4               ((uint16_t)0x0010U) /* Port x Pin 4 input bit */
#define GPIO_PID_PID5               ((uint16_t)0x0020U) /* Port x Pin 5 input bit */
#define GPIO_PID_PID6               ((uint16_t)0x0040U) /* Port x Pin 6 input bit */
#define GPIO_PID_PID7               ((uint16_t)0x0080U) /* Port x Pin 7 input bit */
#define GPIO_PID_PID8               ((uint16_t)0x0100U) /* Port x Pin 8 input bit */
#define GPIO_PID_PID9               ((uint16_t)0x0200U) /* Port x Pin 9 input bit */
#define GPIO_PID_PID10              ((uint16_t)0x0400U) /* Port x Pin 10 input bit */
#define GPIO_PID_PID11              ((uint16_t)0x0800U) /* Port x Pin 11 input bit */
#define GPIO_PID_PID12              ((uint16_t)0x1000U) /* Port x Pin 12 input bit */
#define GPIO_PID_PID13              ((uint16_t)0x2000U) /* Port x Pin 13 input bit */
#define GPIO_PID_PID14              ((uint16_t)0x4000U) /* Port x Pin 14 input bit */
#define GPIO_PID_PID15              ((uint16_t)0x8000U) /* Port x Pin 15 input bit */

/** Bit definition for GPIO_POD register **/
#define GPIO_POD_POD0               ((uint16_t)0x0001U) /* Port x Pin 0 output bit */
#define GPIO_POD_POD1               ((uint16_t)0x0002U) /* Port x Pin 1 output bit */
#define GPIO_POD_POD2               ((uint16_t)0x0004U) /* Port x Pin 2 output bit */
#define GPIO_POD_POD3               ((uint16_t)0x0008U) /* Port x Pin 3 output bit */
#define GPIO_POD_POD4               ((uint16_t)0x0010U) /* Port x Pin 4 output bit */
#define GPIO_POD_POD5               ((uint16_t)0x0020U) /* Port x Pin 5 output bit */
#define GPIO_POD_POD6               ((uint16_t)0x0040U) /* Port x Pin 6 output bit */
#define GPIO_POD_POD7               ((uint16_t)0x0080U) /* Port x Pin 7 output bit */
#define GPIO_POD_POD8               ((uint16_t)0x0100U) /* Port x Pin 8 output bit */
#define GPIO_POD_POD9               ((uint16_t)0x0200U) /* Port x Pin 9 output bit */
#define GPIO_POD_POD10              ((uint16_t)0x0400U) /* Port x Pin 10 output bit */
#define GPIO_POD_POD11              ((uint16_t)0x0800U) /* Port x Pin 11 output bit */
#define GPIO_POD_POD12              ((uint16_t)0x1000U) /* Port x Pin 12 output bit */
#define GPIO_POD_POD13              ((uint16_t)0x2000U) /* Port x Pin 13 output bit */
#define GPIO_POD_POD14              ((uint16_t)0x4000U) /* Port x Pin 14 output bit */
#define GPIO_POD_POD15              ((uint16_t)0x8000U) /* Port x Pin 15 output bit */

/** Bit definition for GPIO_PBSC register **/
#define GPIO_PBSC_PBS0              ((uint32_t)0x00000001U) /* Port x Pin 0 Set bit 0 */
#define GPIO_PBSC_PBS1              ((uint32_t)0x00000002U) /* Port x Pin 1 Set bit 1 */
#define GPIO_PBSC_PBS2              ((uint32_t)0x00000004U) /* Port x Pin 2 Set bit 2 */
#define GPIO_PBSC_PBS3              ((uint32_t)0x00000008U) /* Port x Pin 3 Set bit 3 */
#define GPIO_PBSC_PBS4              ((uint32_t)0x00000010U) /* Port x Pin 4 Set bit 4 */
#define GPIO_PBSC_PBS5              ((uint32_t)0x00000020U) /* Port x Pin 5 Set bit 5 */
#define GPIO_PBSC_PBS6              ((uint32_t)0x00000040U) /* Port x Pin 6 Set bit 6 */
#define GPIO_PBSC_PBS7              ((uint32_t)0x00000080U) /* Port x Pin 7 Set bit 7 */
#define GPIO_PBSC_PBS8              ((uint32_t)0x00000100U) /* Port x Pin 8 Set bit 8 */
#define GPIO_PBSC_PBS9              ((uint32_t)0x00000200U) /* Port x Pin 9 Set bit 9 */
#define GPIO_PBSC_PBS10             ((uint32_t)0x00000400U) /* Port x Pin 10 Set bit 10 */
#define GPIO_PBSC_PBS11             ((uint32_t)0x00000800U) /* Port x Pin 11 Set bit 11 */
#define GPIO_PBSC_PBS12             ((uint32_t)0x00001000U) /* Port x Pin 12 Set bit 12 */
#define GPIO_PBSC_PBS13             ((uint32_t)0x00002000U) /* Port x Pin 13 Set bit 13 */
#define GPIO_PBSC_PBS14             ((uint32_t)0x00004000U) /* Port x Pin 14 Set bit 14 */
#define GPIO_PBSC_PBS15             ((uint32_t)0x00008000U) /* Port x Pin 15 Set bit 15 */

#define GPIO_PBSC_PBC0              ((uint32_t)0x00010000U) /* Port x Pin 0 Reset bit 0 */
#define GPIO_PBSC_PBC1              ((uint32_t)0x00020000U) /* Port x Pin 1 Reset bit 1 */
#define GPIO_PBSC_PBC2              ((uint32_t)0x00040000U) /* Port x Pin 2 Reset bit 2 */
#define GPIO_PBSC_PBC3              ((uint32_t)0x00080000U) /* Port x Pin 3 Reset bit 3 */
#define GPIO_PBSC_PBC4              ((uint32_t)0x00100000U) /* Port x Pin 4 Reset bit 4 */
#define GPIO_PBSC_PBC5              ((uint32_t)0x00200000U) /* Port x Pin 5 Reset bit 5 */
#define GPIO_PBSC_PBC6              ((uint32_t)0x00400000U) /* Port x Pin 6 Reset bit 6 */
#define GPIO_PBSC_PBC7              ((uint32_t)0x00800000U) /* Port x Pin 7 Reset bit 7 */
#define GPIO_PBSC_PBC8              ((uint32_t)0x01000000U) /* Port x Pin 8 Reset bit 8 */
#define GPIO_PBSC_PBC9              ((uint32_t)0x02000000U) /* Port x Pin 9 Reset bit 9 */
#define GPIO_PBSC_PBC10             ((uint32_t)0x04000000U) /* Port x Pin 10 Reset bit 10 */
#define GPIO_PBSC_PBC11             ((uint32_t)0x08000000U) /* Port x Pin 11 Reset bit 11 */
#define GPIO_PBSC_PBC12             ((uint32_t)0x10000000U) /* Port x Pin 12 Reset bit 12 */
#define GPIO_PBSC_PBC13             ((uint32_t)0x20000000U) /* Port x Pin 13 Reset bit 13 */
#define GPIO_PBSC_PBC14             ((uint32_t)0x40000000U) /* Port x Pin 14 Reset bit 14 */
#define GPIO_PBSC_PBC15             ((uint32_t)0x80000000U) /* Port x Pin 15 Reset bit 15 */

/** Bit definition for GPIO_PLOCK register **/
#define GPIO_PLOCK_PLOCK0           ((uint32_t)0x00000001U) /* Port x Pin 0 Lock bit */
#define GPIO_PLOCK_PLOCK1           ((uint32_t)0x00000002U) /* Port x Pin 1 Lock bit */
#define GPIO_PLOCK_PLOCK2           ((uint32_t)0x00000004U) /* Port x Pin 2 Lock bit */
#define GPIO_PLOCK_PLOCK3           ((uint32_t)0x00000008U) /* Port x Pin 3 Lock bit */
#define GPIO_PLOCK_PLOCK4           ((uint32_t)0x00000010U) /* Port x Pin 4 Lock bit */
#define GPIO_PLOCK_PLOCK5           ((uint32_t)0x00000020U) /* Port x Pin 5 Lock bit */
#define GPIO_PLOCK_PLOCK6           ((uint32_t)0x00000040U) /* Port x Pin 6 Lock bit */
#define GPIO_PLOCK_PLOCK7           ((uint32_t)0x00000080U) /* Port x Pin 7 Lock bit */
#define GPIO_PLOCK_PLOCK8           ((uint32_t)0x00000100U) /* Port x Pin 8 Lock bit */
#define GPIO_PLOCK_PLOCK9           ((uint32_t)0x00000200U) /* Port x Pin 9 Lock bit */
#define GPIO_PLOCK_PLOCK10          ((uint32_t)0x00000400U) /* Port x Pin 10 Lock bit */
#define GPIO_PLOCK_PLOCK11          ((uint32_t)0x00000800U) /* Port x Pin 11 Lock bit */
#define GPIO_PLOCK_PLOCK12          ((uint32_t)0x00001000U) /* Port x Pin 12 Lock bit */
#define GPIO_PLOCK_PLOCK13          ((uint32_t)0x00002000U) /* Port x Pin 13 Lock bit */
#define GPIO_PLOCK_PLOCK14          ((uint32_t)0x00004000U) /* Port x Pin 14 Lock bit */
#define GPIO_PLOCK_PLOCK15          ((uint32_t)0x00008000U) /* Port x Pin 15 Lock bit */
#define GPIO_PLOCK_PLOCKK           ((uint32_t)0x00010000U) /* Port x Lock key */

/******** Bit definition for GPIOx_AFRL register  ********/
#define GPIOx_AFRL_AFSEL7           ((uint32_t)0xF0000000)         /* Bit[31:28] */
#define GPIOx_AFRL_AFSEL7_0         ((uint32_t)0x10000000)         /* Bit28*/
#define GPIOx_AFRL_AFSEL7_1         ((uint32_t)0x20000000)         /* Bit29*/
#define GPIOx_AFRL_AFSEL7_2         ((uint32_t)0x40000000)         /* Bit30*/
#define GPIOx_AFRL_AFSEL7_3         ((uint32_t)0x80000000)         /* Bit31*/
#define GPIOx_AFRL_AFSEL6           ((uint32_t)0x0F000000)         /* Bit[27:24] */
#define GPIOx_AFRL_AFSEL6_0         ((uint32_t)0x01000000)         /* Bit24*/
#define GPIOx_AFRL_AFSEL6_1         ((uint32_t)0x02000000)         /* Bit25*/
#define GPIOx_AFRL_AFSEL6_2         ((uint32_t)0x04000000)         /* Bit26*/
#define GPIOx_AFRL_AFSEL6_3         ((uint32_t)0x08000000)         /* Bit27*/
#define GPIOx_AFRL_AFSEL5           ((uint32_t)0x00F00000)         /* Bit[23:20] */
#define GPIOx_AFRL_AFSEL5_0         ((uint32_t)0x00100000)         /* Bit20*/
#define GPIOx_AFRL_AFSEL5_1         ((uint32_t)0x00200000)         /* Bit21*/
#define GPIOx_AFRL_AFSEL5_2         ((uint32_t)0x00400000)         /* Bit22*/
#define GPIOx_AFRL_AFSEL5_3         ((uint32_t)0x00800000)         /* Bit23*/
#define GPIOx_AFRL_AFSEL4           ((uint32_t)0x000F0000)         /* Bit[19:16] */
#define GPIOx_AFRL_AFSEL4_0         ((uint32_t)0x00010000)         /* Bit16*/
#define GPIOx_AFRL_AFSEL4_1         ((uint32_t)0x00020000)         /* Bit17*/
#define GPIOx_AFRL_AFSEL4_2         ((uint32_t)0x00040000)         /* Bit18*/
#define GPIOx_AFRL_AFSEL4_3         ((uint32_t)0x00080000)         /* Bit19*/
#define GPIOx_AFRL_AFSEL3           ((uint32_t)0x0000F000)         /* Bit[15:12] */
#define GPIOx_AFRL_AFSEL3_0         ((uint32_t)0x00001000)         /* Bit12*/
#define GPIOx_AFRL_AFSEL3_1         ((uint32_t)0x00002000)         /* Bit13*/
#define GPIOx_AFRL_AFSEL3_2         ((uint32_t)0x00004000)         /* Bit14*/
#define GPIOx_AFRL_AFSEL3_3         ((uint32_t)0x00008000)         /* Bit15*/
#define GPIOx_AFRL_AFSEL2           ((uint32_t)0x00000F00)         /* Bit[11:8] */
#define GPIOx_AFRL_AFSEL2_0         ((uint32_t)0x00000100)         /* Bit8*/
#define GPIOx_AFRL_AFSEL2_1         ((uint32_t)0x00000200)         /* Bit9*/
#define GPIOx_AFRL_AFSEL2_2         ((uint32_t)0x00000400)         /* Bit10*/
#define GPIOx_AFRL_AFSEL2_3         ((uint32_t)0x00000800)         /* Bit11*/
#define GPIOx_AFRL_AFSEL1           ((uint32_t)0x000000F0)         /* Bit[7:4] */
#define GPIOx_AFRL_AFSEL1_0         ((uint32_t)0x00000010)         /* Bit4*/
#define GPIOx_AFRL_AFSEL1_1         ((uint32_t)0x00000020)         /* Bit5*/
#define GPIOx_AFRL_AFSEL1_2         ((uint32_t)0x00000040)         /* Bit6*/
#define GPIOx_AFRL_AFSEL1_3         ((uint32_t)0x00000080)         /* Bit7*/
#define GPIOx_AFRL_AFSEL0           ((uint32_t)0x0000000F)         /* Bit[3:0] */
#define GPIOx_AFRL_AFSEL0_0         ((uint32_t)0x00000001)         /* Bit0*/
#define GPIOx_AFRL_AFSEL0_1         ((uint32_t)0x00000002)         /* Bit1*/
#define GPIOx_AFRL_AFSEL0_2         ((uint32_t)0x00000004)         /* Bit2*/
#define GPIOx_AFRL_AFSEL0_3         ((uint32_t)0x00000008)         /* Bit3*/

/******** Bit definition for GPIOx_AFRH register  ********/
#define GPIOx_AFRH_AFSEL15          ((uint32_t)0xF0000000)         /* Bit[31:28] */
#define GPIOx_AFRH_AFSEL15_0        ((uint32_t)0x10000000)         /* Bit28*/
#define GPIOx_AFRH_AFSEL15_1        ((uint32_t)0x20000000)         /* Bit29*/
#define GPIOx_AFRH_AFSEL15_2        ((uint32_t)0x40000000)         /* Bit30*/
#define GPIOx_AFRH_AFSEL15_3        ((uint32_t)0x80000000)         /* Bit31*/
#define GPIOx_AFRH_AFSEL14          ((uint32_t)0x0F000000)         /* Bit[27:24] */
#define GPIOx_AFRH_AFSEL14_0        ((uint32_t)0x01000000)         /* Bit24*/
#define GPIOx_AFRH_AFSEL14_1        ((uint32_t)0x02000000)         /* Bit25*/
#define GPIOx_AFRH_AFSEL14_2        ((uint32_t)0x04000000)         /* Bit26*/
#define GPIOx_AFRH_AFSEL14_3        ((uint32_t)0x08000000)         /* Bit27*/
#define GPIOx_AFRH_AFSEL13          ((uint32_t)0x00F00000)         /* Bit[23:20] */
#define GPIOx_AFRH_AFSEL13_0        ((uint32_t)0x00100000)         /* Bit20*/
#define GPIOx_AFRH_AFSEL13_1        ((uint32_t)0x00200000)         /* Bit21*/
#define GPIOx_AFRH_AFSEL13_2        ((uint32_t)0x00400000)         /* Bit22*/
#define GPIOx_AFRH_AFSEL13_3        ((uint32_t)0x00800000)         /* Bit23*/
#define GPIOx_AFRH_AFSEL12          ((uint32_t)0x000F0000)         /* Bit[19:16] */
#define GPIOx_AFRH_AFSEL12_0        ((uint32_t)0x00010000)         /* Bit16*/
#define GPIOx_AFRH_AFSEL12_1        ((uint32_t)0x00020000)         /* Bit17*/
#define GPIOx_AFRH_AFSEL12_2        ((uint32_t)0x00040000)         /* Bit18*/
#define GPIOx_AFRH_AFSEL12_3        ((uint32_t)0x00080000)         /* Bit19*/
#define GPIOx_AFRH_AFSEL11          ((uint32_t)0x0000F000)         /* Bit[15:12] */
#define GPIOx_AFRH_AFSEL11_0        ((uint32_t)0x00001000)         /* Bit12*/
#define GPIOx_AFRH_AFSEL11_1        ((uint32_t)0x00002000)         /* Bit13*/
#define GPIOx_AFRH_AFSEL11_2        ((uint32_t)0x00004000)         /* Bit14*/
#define GPIOx_AFRH_AFSEL11_3        ((uint32_t)0x00008000)         /* Bit15*/
#define GPIOx_AFRH_AFSEL10          ((uint32_t)0x00000F00)         /* Bit[11:8] */
#define GPIOx_AFRH_AFSEL10_0        ((uint32_t)0x00000100)         /* Bit8*/
#define GPIOx_AFRH_AFSEL10_1        ((uint32_t)0x00000200)         /* Bit9*/
#define GPIOx_AFRH_AFSEL10_2        ((uint32_t)0x00000400)         /* Bit10*/
#define GPIOx_AFRH_AFSEL10_3        ((uint32_t)0x00000800)         /* Bit11*/
#define GPIOx_AFRH_AFSEL9           ((uint32_t)0x000000F0)         /* Bit[7:4] */
#define GPIOx_AFRH_AFSEL9_0         ((uint32_t)0x00000010)         /* Bit4*/
#define GPIOx_AFRH_AFSEL9_1         ((uint32_t)0x00000020)         /* Bit5*/
#define GPIOx_AFRH_AFSEL9_2         ((uint32_t)0x00000040)         /* Bit6*/
#define GPIOx_AFRH_AFSEL9_3         ((uint32_t)0x00000080)         /* Bit7*/
#define GPIOx_AFRH_AFSEL8           ((uint32_t)0x0000000F)         /* Bit[3:0] */
#define GPIOx_AFRH_AFSEL8_0         ((uint32_t)0x00000001)         /* Bit0*/
#define GPIOx_AFRH_AFSEL8_1         ((uint32_t)0x00000002)         /* Bit1*/
#define GPIOx_AFRH_AFSEL8_2         ((uint32_t)0x00000004)         /* Bit2*/
#define GPIOx_AFRH_AFSEL8_3         ((uint32_t)0x00000008)         /* Bit3*/


#define GPIO_AFSEL_AF0              ((uint32_t)0x00000000U)  /* Alternate function 0  */
#define GPIO_AFSEL_AF1              ((uint32_t)0x00000001U)  /* Alternate function 1  */
#define GPIO_AFSEL_AF2              ((uint32_t)0x00000002U)  /* Alternate function 2  */
#define GPIO_AFSEL_AF3              ((uint32_t)0x00000003U)  /* Alternate function 3  */
#define GPIO_AFSEL_AF4              ((uint32_t)0x00000004U)  /* Alternate function 4  */
#define GPIO_AFSEL_AF5              ((uint32_t)0x00000005U)  /* Alternate function 5  */
#define GPIO_AFSEL_AF6              ((uint32_t)0x00000006U)  /* Alternate function 6  */
#define GPIO_AFSEL_AF7              ((uint32_t)0x00000007U)  /* Alternate function 7  */
#define GPIO_AFSEL_AF8              ((uint32_t)0x00000008U)  /* Alternate function 8  */
#define GPIO_AFSEL_AF9              ((uint32_t)0x00000009U)  /* Alternate function 9  */
#define GPIO_AFSEL_AF10             ((uint32_t)0x0000000AU)  /* Alternate function 10 */
#define GPIO_AFSEL_AF11             ((uint32_t)0x0000000BU)  /* Alternate function 11 */
#define GPIO_AFSEL_AF12             ((uint32_t)0x0000000CU)  /* Alternate function 12 */
#define GPIO_AFSEL_AF13             ((uint32_t)0x0000000DU)  /* Alternate function 13 */
#define GPIO_AFSEL_AF14             ((uint32_t)0x0000000EU)  /* Alternate function 14 */
#define GPIO_AFSEL_AF15             ((uint32_t)0x0000000FU)  /* Alternate function 15 */

/** Bit definition for GPIO_PBC register **/
#define GPIO_PBC_PBC0               ((uint16_t)0x0001U) /* Port x Pin 0 Reset bit 0 */
#define GPIO_PBC_PBC1               ((uint16_t)0x0002U) /* Port x Pin 1 Reset bit 1 */
#define GPIO_PBC_PBC2               ((uint16_t)0x0004U) /* Port x Pin 2 Reset bit 2 */
#define GPIO_PBC_PBC3               ((uint16_t)0x0008U) /* Port x Pin 3 Reset bit 3 */
#define GPIO_PBC_PBC4               ((uint16_t)0x0010U) /* Port x Pin 4 Reset bit 4 */
#define GPIO_PBC_PBC5               ((uint16_t)0x0020U) /* Port x Pin 5 Reset bit 5 */
#define GPIO_PBC_PBC6               ((uint16_t)0x0040U) /* Port x Pin 6 Reset bit 6 */
#define GPIO_PBC_PBC7               ((uint16_t)0x0080U) /* Port x Pin 7 Reset bit 7 */
#define GPIO_PBC_PBC8               ((uint16_t)0x0100U) /* Port x Pin 8 Reset bit 8 */
#define GPIO_PBC_PBC9               ((uint16_t)0x0200U) /* Port x Pin 9 Reset bit 9 */
#define GPIO_PBC_PBC10              ((uint16_t)0x0400U) /* Port x Pin 10 Reset bit 10 */
#define GPIO_PBC_PBC11              ((uint16_t)0x0800U) /* Port x Pin 11 Reset bit 11 */
#define GPIO_PBC_PBC12              ((uint16_t)0x1000U) /* Port x Pin 12 Reset bit 12 */
#define GPIO_PBC_PBC13              ((uint16_t)0x2000U) /* Port x Pin 13 Reset bit 13 */
#define GPIO_PBC_PBC14              ((uint16_t)0x4000U) /* Port x Pin 14 Reset bit 14 */
#define GPIO_PBC_PBC15              ((uint16_t)0x8000U) /* Port x Pin 15 Reset bit 15 */

/** Bit definition for GPIO_DS register **/
#define GPIO_DS_DS0                 ((uint32_t)0x00000003U) /* Port x Pin 0 Drive bitS */
#define GPIO_DS_DS0_0               ((uint32_t)0x00000001U) /* Port x Pin 0 Drive bit 0 */
#define GPIO_DS_DS0_1               ((uint32_t)0x00000002U) /* Port x Pin 0 Drive bit 1 */

#define GPIO_DS_DS1                 ((uint32_t)0x0000000CU) /* Port x Pin 1 Drive bitS */
#define GPIO_DS_DS1_0               ((uint32_t)0x00000004U) /* Port x Pin 1 Drive bit 0 */
#define GPIO_DS_DS1_1               ((uint32_t)0x00000008U) /* Port x Pin 1 Drive bit 1 */

#define GPIO_DS_DS2                 ((uint32_t)0x00000030U) /* Port x Pin 2 Drive bitS */
#define GPIO_DS_DS2_0               ((uint32_t)0x00000010U) /* Port x Pin 2 Drive bit 0 */
#define GPIO_DS_DS2_1               ((uint32_t)0x00000020U) /* Port x Pin 2 Drive bit 1 */

#define GPIO_DS_DS3                 ((uint32_t)0x000000C0U) /* Port x Pin 3 Drive bitS */
#define GPIO_DS_DS3_0               ((uint32_t)0x00000040U) /* Port x Pin 3 Drive bit 0 */
#define GPIO_DS_DS3_1               ((uint32_t)0x00000080U) /* Port x Pin 3 Drive bit 1 */

#define GPIO_DS_DS4                 ((uint32_t)0x00000300U) /* Port x Pin 4 Drive bitS */
#define GPIO_DS_DS4_0               ((uint32_t)0x00000100U) /* Port x Pin 4 Drive bit 0 */
#define GPIO_DS_DS4_1               ((uint32_t)0x00000200U) /* Port x Pin 4 Drive bit 1 */

#define GPIO_DS_DS5                 ((uint32_t)0x00000C00U) /* Port x Pin 5 Drive bitS */
#define GPIO_DS_DS5_0               ((uint32_t)0x00000400U) /* Port x Pin 5 Drive bit 0 */
#define GPIO_DS_DS5_1               ((uint32_t)0x00000800U) /* Port x Pin 5 Drive bit 1 */

#define GPIO_DS_DS6                 ((uint32_t)0x00003000U) /* Port x Pin 6 Drive bitS */
#define GPIO_DS_DS6_0               ((uint32_t)0x00001000U) /* Port x Pin 6 Drive bit 0 */
#define GPIO_DS_DS6_1               ((uint32_t)0x00002000U) /* Port x Pin 6 Drive bit 1 */

#define GPIO_DS_DS7                 ((uint32_t)0x0000C000U) /* Port x Pin 7 Drive bitS */
#define GPIO_DS_DS7_0               ((uint32_t)0x00004000U) /* Port x Pin 7 Drive bit 0 */
#define GPIO_DS_DS7_1               ((uint32_t)0x00008000U) /* Port x Pin 7 Drive bit 1 */

#define GPIO_DS_DS8                 ((uint32_t)0x00030000U) /* Port x Pin 8 Drive bitS */
#define GPIO_DS_DS8_0               ((uint32_t)0x00010000U) /* Port x Pin 8 Drive bit 0 */
#define GPIO_DS_DS8_1               ((uint32_t)0x00020000U) /* Port x Pin 8 Drive bit 1 */

#define GPIO_DS_DS9                 ((uint32_t)0x000C0000U) /* Port x Pin 9 Drive bitS */
#define GPIO_DS_DS9_0               ((uint32_t)0x00040000U) /* Port x Pin 9 Drive bit 0 */
#define GPIO_DS_DS9_1               ((uint32_t)0x00080000U) /* Port x Pin 9 Drive bit 1 */

#define GPIO_DS_DS10                ((uint32_t)0x00300000U) /* Port x Pin 10 Drive bitS */
#define GPIO_DS_DS10_0              ((uint32_t)0x00100000U) /* Port x Pin 10 Drive bit 0 */
#define GPIO_DS_DS10_1              ((uint32_t)0x00200000U) /* Port x Pin 10 Drive bit 1 */

#define GPIO_DS_DS11                ((uint32_t)0x00C00000U) /* Port x Pin 11 Drive bitS */
#define GPIO_DS_DS11_0              ((uint32_t)0x00400000U) /* Port x Pin 11 Drive bit 0 */
#define GPIO_DS_DS11_1              ((uint32_t)0x00800000U) /* Port x Pin 11 Drive bit 1 */

#define GPIO_DS_DS12                ((uint32_t)0x03000000U) /* Port x Pin 12 Drive bitS */
#define GPIO_DS_DS12_0              ((uint32_t)0x01000000U) /* Port x Pin 12 Drive bit 0 */
#define GPIO_DS_DS12_1              ((uint32_t)0x02000000U) /* Port x Pin 12 Drive bit 1 */

#define GPIO_DS_DS13                ((uint32_t)0x0C000000U) /* Port x Pin 13 Drive bitS */
#define GPIO_DS_DS13_0              ((uint32_t)0x04000000U) /* Port x Pin 13 Drive bit 0 */
#define GPIO_DS_DS13_1              ((uint32_t)0x08000000U) /* Port x Pin 13 Drive bit 1 */

#define GPIO_DS_DS14                ((uint32_t)0x30000000U) /* Port x Pin 14 Drive bitS */
#define GPIO_DS_DS14_0              ((uint32_t)0x10000000U) /* Port x Pin 14 Drive bit 0 */
#define GPIO_DS_DS14_1              ((uint32_t)0x20000000U) /* Port x Pin 14 Drive bit 1 */

#define GPIO_DS_DS15                ((uint32_t)0xC0000000U) /* Port x Pin 15 Drive bitS */
#define GPIO_DS_DS15_0              ((uint32_t)0x40000000U) /* Port x Pin 15 Drive bit 0 */
#define GPIO_DS_DS15_1              ((uint32_t)0x80000000U) /* Port x Pin 15 Drive bit 1 */

#define GPIO_DS_2mA                 ((uint32_t)0x00000000U) /* Drive strength is 2mA  */
#define GPIO_DS_4mA                 ((uint32_t)0x00000002U) /* Drive strength is 4mA  */
#define GPIO_DS_8mA                 ((uint32_t)0x00000001U) /* Drive strength is 8mA  */
#define GPIO_DS_12mA                ((uint32_t)0x00000003U) /* Drive strength is 12mA */



/******** Bit definition for AFIO_RMP_CFG register  ********/
#define AFIO_RMP_CFG_EXTI_AFLTBYPS                           ((uint32_t)0x40000000)         /* Bit[30] */
#define AFIO_RMP_CFG_SIP_SDRAM_SEL                           ((uint32_t)0x20000000)         /* Bit[29] */
#define AFIO_RMP_CFG_SPI4_SEL                                ((uint32_t)0x10000000)         /* Bit[28] */
#define AFIO_RMP_CFG_SPI3_SEL                                ((uint32_t)0x08000000)         /* Bit[27] */
#define AFIO_RMP_CFG_SPI2_SEL                                ((uint32_t)0x04000000)         /* Bit[26] */
#define AFIO_RMP_CFG_SPI1_SEL                                ((uint32_t)0x02000000)         /* Bit[25] */
#define AFIO_RMP_CFG_SDMMC1_CLKFB                            ((uint32_t)0x01000000)         /* Bit[24] */
#define AFIO_RMP_CFG_SDMMC2_CLKFB                            ((uint32_t)0x00800000)         /* Bit[23] */
#define AFIO_RMP_CFG_I2S_FDUP                                ((uint32_t)0x00600000)         /* Bit[22:21] */
#define AFIO_RMP_CFG_I2S_FDUP_0                              ((uint32_t)0x00200000)         /* Bit21*/
#define AFIO_RMP_CFG_I2S_FDUP_1                              ((uint32_t)0x00400000)         /* Bit22*/
#define AFIO_RMP_CFG_XSPI2_EDN                               ((uint32_t)0x00080000)         /* Bit[19] */
#define AFIO_RMP_CFG_XSPI1_EDN                               ((uint32_t)0x00040000)         /* Bit[18] */
#define AFIO_RMP_CFG_FEMCSEL                                 ((uint32_t)0x00020000)         /* Bit[17] */
#define AFIO_RMP_CFG_FEMC_NOBYTE                             ((uint32_t)0x00010000)         /* Bit[16] */
#define AFIO_RMP_CFG_ETH2_PHY                                ((uint32_t)0x00008000)         /* Bit[15] */
#define AFIO_RMP_CFG_ETH1_PHY                                ((uint32_t)0x00006000)         /* Bit[14:13] */
#define AFIO_RMP_CFG_ETH1_PHY_0                              ((uint32_t)0x00002000)         /* Bit13*/
#define AFIO_RMP_CFG_ETH1_PHY_1                              ((uint32_t)0x00004000)         /* Bit14*/
#define AFIO_RMP_CFG_SPI7_NSS                                ((uint32_t)0x00001000)         /* Bit[12] */
#define AFIO_RMP_CFG_SPI6_NSS                                ((uint32_t)0x00000800)         /* Bit[11] */
#define AFIO_RMP_CFG_SPI5_NSS                                ((uint32_t)0x00000400)         /* Bit[10] */
#define AFIO_RMP_CFG_SPI4_NSS                                ((uint32_t)0x00000200)         /* Bit[9] */
#define AFIO_RMP_CFG_SPI3_NSS                                ((uint32_t)0x00000100)         /* Bit[8] */
#define AFIO_RMP_CFG_SPI2_NSS                                ((uint32_t)0x00000080)         /* Bit[7] */
#define AFIO_RMP_CFG_SPI1_NSS                                ((uint32_t)0x00000040)         /* Bit[6] */
#define AFIO_RMP_CFG_SIP_FLASHSEL                            ((uint32_t)0x00000007)         /* Bit[2:0] */
#define AFIO_RMP_CFG_SIP_FLASHSEL_0                          ((uint32_t)0x00000001)         /* Bit0*/
#define AFIO_RMP_CFG_SIP_FLASHSEL_1                          ((uint32_t)0x00000002)         /* Bit1*/
#define AFIO_RMP_CFG_SIP_FLASHSEL_2                          ((uint32_t)0x00000004)         /* Bit2*/

/******** Bit definition for AFIO_FILTER_CFG register  ********/
#define AFIO_FILTER_CFG_IOFLTCFG                             ((uint32_t)0x0000007F)         /* Bit[6:0] */
#define AFIO_FILTER_CFG_IOFLTCFG_0                           ((uint32_t)0x00000001)         /* Bit0*/
#define AFIO_FILTER_CFG_IOFLTCFG_1                           ((uint32_t)0x00000002)         /* Bit1*/
#define AFIO_FILTER_CFG_IOFLTCFG_2                           ((uint32_t)0x00000004)         /* Bit2*/
#define AFIO_FILTER_CFG_IOFLTCFG_3                           ((uint32_t)0x00000008)         /* Bit3*/
#define AFIO_FILTER_CFG_IOFLTCFG_4                           ((uint32_t)0x00000010)         /* Bit4*/
#define AFIO_FILTER_CFG_IOFLTCFG_5                           ((uint32_t)0x00000020)         /* Bit5*/
#define AFIO_FILTER_CFG_IOFLTCFG_6                           ((uint32_t)0x00000040)         /* Bit6*/

/** Bit definition for AFIO_XSPI1_NON0 register **/
#define AFIO_XSPI1_NON0_XSPI1_DEC_NONCE                      ((uint32_t)0xFFFFFFFF)         /* Bit[31:0] */
/** Bit definition for AFIO_XSPI1_NON1 register **/
#define AFIO_XSPI1_NON1_XSPI1_DEC_NONCE                      ((uint32_t)0xFFFFFFFF)         /* Bit[31:0] */
/** Bit definition for AFIO_XSPI1_NON2 register **/
#define AFIO_XSPI1_NON2_XSPI1_DEC_NONCE                      ((uint32_t)0xFFFFFFFF)         /* Bit[31:0] */

/** Bit definition for AFIO_ADCRMP_CFG register **/
#define AFIO_ADCRMP_CFG_ADC1_EXTIRISEL                       ((uint32_t)0x00F00000)         /* Bit[23:20] */
#define AFIO_ADCRMP_CFG_ADC1_EXTIRISEL_0                     ((uint32_t)0x00100000)         /* Bit20*/
#define AFIO_ADCRMP_CFG_ADC1_EXTIRISEL_1                     ((uint32_t)0x00200000)         /* Bit21*/
#define AFIO_ADCRMP_CFG_ADC1_EXTIRISEL_2                     ((uint32_t)0x00400000)         /* Bit22*/
#define AFIO_ADCRMP_CFG_ADC1_EXTIRISEL_3                     ((uint32_t)0x00800000)         /* Bit23*/
#define AFIO_ADCRMP_CFG_ADC1_EXTIRRSEL                       ((uint32_t)0x000F0000)         /* Bit[19:16] */
#define AFIO_ADCRMP_CFG_ADC1_EXTIRRSEL_0                     ((uint32_t)0x00010000)         /* Bit16*/
#define AFIO_ADCRMP_CFG_ADC1_EXTIRRSEL_1                     ((uint32_t)0x00020000)         /* Bit17*/
#define AFIO_ADCRMP_CFG_ADC1_EXTIRRSEL_2                     ((uint32_t)0x00040000)         /* Bit18*/
#define AFIO_ADCRMP_CFG_ADC1_EXTIRRSEL_3                     ((uint32_t)0x00080000)         /* Bit19*/
#define AFIO_ADCRMP_CFG_ADC2_EXTIRISEL                       ((uint32_t)0x0000F000)         /* Bit[15:12] */
#define AFIO_ADCRMP_CFG_ADC2_EXTIRISEL_0                     ((uint32_t)0x00001000)         /* Bit12*/
#define AFIO_ADCRMP_CFG_ADC2_EXTIRISEL_1                     ((uint32_t)0x00002000)         /* Bit13*/
#define AFIO_ADCRMP_CFG_ADC2_EXTIRISEL_2                     ((uint32_t)0x00004000)         /* Bit14*/
#define AFIO_ADCRMP_CFG_ADC2_EXTIRISEL_3                     ((uint32_t)0x00008000)         /* Bit15*/
#define AFIO_ADCRMP_CFG_ADC2_EXTIRRSEL                       ((uint32_t)0x00000F00)         /* Bit[11:8] */
#define AFIO_ADCRMP_CFG_ADC2_EXTIRRSEL_0                     ((uint32_t)0x00000100)         /* Bit8*/
#define AFIO_ADCRMP_CFG_ADC2_EXTIRRSEL_1                     ((uint32_t)0x00000200)         /* Bit9*/
#define AFIO_ADCRMP_CFG_ADC2_EXTIRRSEL_2                     ((uint32_t)0x00000400)         /* Bit10*/
#define AFIO_ADCRMP_CFG_ADC2_EXTIRRSEL_3                     ((uint32_t)0x00000800)         /* Bit11*/
#define AFIO_ADCRMP_CFG_ADC3_EXTIRISEL                       ((uint32_t)0x000000F0)         /* Bit[7:4] */
#define AFIO_ADCRMP_CFG_ADC3_EXTIRISEL_0                     ((uint32_t)0x00000010)         /* Bit4*/
#define AFIO_ADCRMP_CFG_ADC3_EXTIRISEL_1                     ((uint32_t)0x00000020)         /* Bit5*/
#define AFIO_ADCRMP_CFG_ADC3_EXTIRISEL_2                     ((uint32_t)0x00000040)         /* Bit6*/
#define AFIO_ADCRMP_CFG_ADC3_EXTIRISEL_3                     ((uint32_t)0x00000080)         /* Bit7*/
#define AFIO_ADCRMP_CFG_ADC3_EXTIRRSEL                       ((uint32_t)0x0000000F)         /* Bit[3:0] */
#define AFIO_ADCRMP_CFG_ADC3_EXTIRRSEL_0                     ((uint32_t)0x00000001)         /* Bit0*/
#define AFIO_ADCRMP_CFG_ADC3_EXTIRRSEL_1                     ((uint32_t)0x00000002)         /* Bit1*/
#define AFIO_ADCRMP_CFG_ADC3_EXTIRRSEL_2                     ((uint32_t)0x00000004)         /* Bit2*/
#define AFIO_ADCRMP_CFG_ADC3_EXTIRRSEL_3                     ((uint32_t)0x00000008)         /* Bit3*/

/******** Bit definition for AFIO_EXTI_CFG1 register  ********/
#define AFIO_EXTI_CFG1_EXTI3                                   ((uint32_t)0xFF000000)         /* Bit[31:24] */
#define AFIO_EXTI_CFG1_EXTI3_0                                 ((uint32_t)0x01000000)         /* Bit24*/
#define AFIO_EXTI_CFG1_EXTI3_1                                 ((uint32_t)0x02000000)         /* Bit25*/
#define AFIO_EXTI_CFG1_EXTI3_2                                 ((uint32_t)0x04000000)         /* Bit26*/
#define AFIO_EXTI_CFG1_EXTI3_3                                 ((uint32_t)0x08000000)         /* Bit27*/
#define AFIO_EXTI_CFG1_EXTI3_4                                 ((uint32_t)0x10000000)         /* Bit28*/
#define AFIO_EXTI_CFG1_EXTI3_5                                 ((uint32_t)0x20000000)         /* Bit29*/
#define AFIO_EXTI_CFG1_EXTI3_6                                 ((uint32_t)0x40000000)         /* Bit30*/
#define AFIO_EXTI_CFG1_EXTI3_7                                 ((uint32_t)0x80000000)         /* Bit31*/
#define AFIO_EXTI_CFG1_EXTI2                                   ((uint32_t)0x00FF0000)         /* Bit[23:16] */
#define AFIO_EXTI_CFG1_EXTI2_0                                 ((uint32_t)0x00010000)         /* Bit16*/
#define AFIO_EXTI_CFG1_EXTI2_1                                 ((uint32_t)0x00020000)         /* Bit17*/
#define AFIO_EXTI_CFG1_EXTI2_2                                 ((uint32_t)0x00040000)         /* Bit18*/
#define AFIO_EXTI_CFG1_EXTI2_3                                 ((uint32_t)0x00080000)         /* Bit19*/
#define AFIO_EXTI_CFG1_EXTI2_4                                 ((uint32_t)0x00100000)         /* Bit20*/
#define AFIO_EXTI_CFG1_EXTI2_5                                 ((uint32_t)0x00200000)         /* Bit21*/
#define AFIO_EXTI_CFG1_EXTI2_6                                 ((uint32_t)0x00400000)         /* Bit22*/
#define AFIO_EXTI_CFG1_EXTI2_7                                 ((uint32_t)0x00800000)         /* Bit23*/
#define AFIO_EXTI_CFG1_EXTI1                                   ((uint32_t)0x0000FF00)         /* Bit[15:8] */
#define AFIO_EXTI_CFG1_EXTI1_0                                 ((uint32_t)0x00000100)         /* Bit8*/
#define AFIO_EXTI_CFG1_EXTI1_1                                 ((uint32_t)0x00000200)         /* Bit9*/
#define AFIO_EXTI_CFG1_EXTI1_2                                 ((uint32_t)0x00000400)         /* Bit10*/
#define AFIO_EXTI_CFG1_EXTI1_3                                 ((uint32_t)0x00000800)         /* Bit11*/
#define AFIO_EXTI_CFG1_EXTI1_4                                 ((uint32_t)0x00001000)         /* Bit12*/
#define AFIO_EXTI_CFG1_EXTI1_5                                 ((uint32_t)0x00002000)         /* Bit13*/
#define AFIO_EXTI_CFG1_EXTI1_6                                 ((uint32_t)0x00004000)         /* Bit14*/
#define AFIO_EXTI_CFG1_EXTI1_7                                 ((uint32_t)0x00008000)         /* Bit15*/
#define AFIO_EXTI_CFG1_EXTI0                                   ((uint32_t)0x000000FF)         /* Bit[7:0] */
#define AFIO_EXTI_CFG1_EXTI0_0                                 ((uint32_t)0x00000001)         /* Bit0*/
#define AFIO_EXTI_CFG1_EXTI0_1                                 ((uint32_t)0x00000002)         /* Bit1*/
#define AFIO_EXTI_CFG1_EXTI0_2                                 ((uint32_t)0x00000004)         /* Bit2*/
#define AFIO_EXTI_CFG1_EXTI0_3                                 ((uint32_t)0x00000008)         /* Bit3*/
#define AFIO_EXTI_CFG1_EXTI0_4                                 ((uint32_t)0x00000010)         /* Bit4*/
#define AFIO_EXTI_CFG1_EXTI0_5                                 ((uint32_t)0x00000020)         /* Bit5*/
#define AFIO_EXTI_CFG1_EXTI0_6                                 ((uint32_t)0x00000040)         /* Bit6*/
#define AFIO_EXTI_CFG1_EXTI0_7                                 ((uint32_t)0x00000080)         /* Bit7*/

/******** Bit definition for AFIO_EXTI_CFG2 register  ********/
#define AFIO_EXTI_CFG2_EXTI7                                   ((uint32_t)0xFF000000)         /* Bit[31:24] */
#define AFIO_EXTI_CFG2_EXTI7_0                                 ((uint32_t)0x01000000)         /* Bit24*/
#define AFIO_EXTI_CFG2_EXTI7_1                                 ((uint32_t)0x02000000)         /* Bit25*/
#define AFIO_EXTI_CFG2_EXTI7_2                                 ((uint32_t)0x04000000)         /* Bit26*/
#define AFIO_EXTI_CFG2_EXTI7_3                                 ((uint32_t)0x08000000)         /* Bit27*/
#define AFIO_EXTI_CFG2_EXTI7_4                                 ((uint32_t)0x10000000)         /* Bit28*/
#define AFIO_EXTI_CFG2_EXTI7_5                                 ((uint32_t)0x20000000)         /* Bit29*/
#define AFIO_EXTI_CFG2_EXTI7_6                                 ((uint32_t)0x40000000)         /* Bit30*/
#define AFIO_EXTI_CFG2_EXTI7_7                                 ((uint32_t)0x80000000)         /* Bit31*/
#define AFIO_EXTI_CFG2_EXTI6                                   ((uint32_t)0x00FF0000)         /* Bit[23:16] */
#define AFIO_EXTI_CFG2_EXTI6_0                                 ((uint32_t)0x00010000)         /* Bit16*/
#define AFIO_EXTI_CFG2_EXTI6_1                                 ((uint32_t)0x00020000)         /* Bit17*/
#define AFIO_EXTI_CFG2_EXTI6_2                                 ((uint32_t)0x00040000)         /* Bit18*/
#define AFIO_EXTI_CFG2_EXTI6_3                                 ((uint32_t)0x00080000)         /* Bit19*/
#define AFIO_EXTI_CFG2_EXTI6_4                                 ((uint32_t)0x00100000)         /* Bit20*/
#define AFIO_EXTI_CFG2_EXTI6_5                                 ((uint32_t)0x00200000)         /* Bit21*/
#define AFIO_EXTI_CFG2_EXTI6_6                                 ((uint32_t)0x00400000)         /* Bit22*/
#define AFIO_EXTI_CFG2_EXTI6_7                                 ((uint32_t)0x00800000)         /* Bit23*/
#define AFIO_EXTI_CFG2_EXTI5                                   ((uint32_t)0x0000FF00)         /* Bit[15:8] */
#define AFIO_EXTI_CFG2_EXTI5_0                                 ((uint32_t)0x00000100)         /* Bit8*/
#define AFIO_EXTI_CFG2_EXTI5_1                                 ((uint32_t)0x00000200)         /* Bit9*/
#define AFIO_EXTI_CFG2_EXTI5_2                                 ((uint32_t)0x00000400)         /* Bit10*/
#define AFIO_EXTI_CFG2_EXTI5_3                                 ((uint32_t)0x00000800)         /* Bit11*/
#define AFIO_EXTI_CFG2_EXTI5_4                                 ((uint32_t)0x00001000)         /* Bit12*/
#define AFIO_EXTI_CFG2_EXTI5_5                                 ((uint32_t)0x00002000)         /* Bit13*/
#define AFIO_EXTI_CFG2_EXTI5_6                                 ((uint32_t)0x00004000)         /* Bit14*/
#define AFIO_EXTI_CFG2_EXTI5_7                                 ((uint32_t)0x00008000)         /* Bit15*/
#define AFIO_EXTI_CFG2_EXTI4                                   ((uint32_t)0x000000FF)         /* Bit[7:0] */
#define AFIO_EXTI_CFG2_EXTI4_0                                 ((uint32_t)0x00000001)         /* Bit0*/
#define AFIO_EXTI_CFG2_EXTI4_1                                 ((uint32_t)0x00000002)         /* Bit1*/
#define AFIO_EXTI_CFG2_EXTI4_2                                 ((uint32_t)0x00000004)         /* Bit2*/
#define AFIO_EXTI_CFG2_EXTI4_3                                 ((uint32_t)0x00000008)         /* Bit3*/
#define AFIO_EXTI_CFG2_EXTI4_4                                 ((uint32_t)0x00000010)         /* Bit4*/
#define AFIO_EXTI_CFG2_EXTI4_5                                 ((uint32_t)0x00000020)         /* Bit5*/
#define AFIO_EXTI_CFG2_EXTI4_6                                 ((uint32_t)0x00000040)         /* Bit6*/
#define AFIO_EXTI_CFG2_EXTI4_7                                 ((uint32_t)0x00000080)         /* Bit7*/

/******** Bit definition for AFIO_EXTI_CFG3 register  ********/
#define AFIO_EXTI_CFG3_EXTI11                                  ((uint32_t)0xFF000000)         /* Bit[31:24] */
#define AFIO_EXTI_CFG3_EXTI11_0                                ((uint32_t)0x01000000)         /* Bit24*/
#define AFIO_EXTI_CFG3_EXTI11_1                                ((uint32_t)0x02000000)         /* Bit25*/
#define AFIO_EXTI_CFG3_EXTI11_2                                ((uint32_t)0x04000000)         /* Bit26*/
#define AFIO_EXTI_CFG3_EXTI11_3                                ((uint32_t)0x08000000)         /* Bit27*/
#define AFIO_EXTI_CFG3_EXTI11_4                                ((uint32_t)0x10000000)         /* Bit28*/
#define AFIO_EXTI_CFG3_EXTI11_5                                ((uint32_t)0x20000000)         /* Bit29*/
#define AFIO_EXTI_CFG3_EXTI11_6                                ((uint32_t)0x40000000)         /* Bit30*/
#define AFIO_EXTI_CFG3_EXTI11_7                                ((uint32_t)0x80000000)         /* Bit31*/
#define AFIO_EXTI_CFG3_EXTI10                                  ((uint32_t)0x00FF0000)         /* Bit[23:16] */
#define AFIO_EXTI_CFG3_EXTI10_0                                ((uint32_t)0x00010000)         /* Bit16*/
#define AFIO_EXTI_CFG3_EXTI10_1                                ((uint32_t)0x00020000)         /* Bit17*/
#define AFIO_EXTI_CFG3_EXTI10_2                                ((uint32_t)0x00040000)         /* Bit18*/
#define AFIO_EXTI_CFG3_EXTI10_3                                ((uint32_t)0x00080000)         /* Bit19*/
#define AFIO_EXTI_CFG3_EXTI10_4                                ((uint32_t)0x00100000)         /* Bit20*/
#define AFIO_EXTI_CFG3_EXTI10_5                                ((uint32_t)0x00200000)         /* Bit21*/
#define AFIO_EXTI_CFG3_EXTI10_6                                ((uint32_t)0x00400000)         /* Bit22*/
#define AFIO_EXTI_CFG3_EXTI10_7                                ((uint32_t)0x00800000)         /* Bit23*/
#define AFIO_EXTI_CFG3_EXTI9                                   ((uint32_t)0x0000FF00)         /* Bit[15:8] */
#define AFIO_EXTI_CFG3_EXTI9_0                                 ((uint32_t)0x00000100)         /* Bit8*/
#define AFIO_EXTI_CFG3_EXTI9_1                                 ((uint32_t)0x00000200)         /* Bit9*/
#define AFIO_EXTI_CFG3_EXTI9_2                                 ((uint32_t)0x00000400)         /* Bit10*/
#define AFIO_EXTI_CFG3_EXTI9_3                                 ((uint32_t)0x00000800)         /* Bit11*/
#define AFIO_EXTI_CFG3_EXTI9_4                                 ((uint32_t)0x00001000)         /* Bit12*/
#define AFIO_EXTI_CFG3_EXTI9_5                                 ((uint32_t)0x00002000)         /* Bit13*/
#define AFIO_EXTI_CFG3_EXTI9_6                                 ((uint32_t)0x00004000)         /* Bit14*/
#define AFIO_EXTI_CFG3_EXTI9_7                                 ((uint32_t)0x00008000)         /* Bit15*/
#define AFIO_EXTI_CFG3_EXTI8                                   ((uint32_t)0x000000FF)         /* Bit[7:0] */
#define AFIO_EXTI_CFG3_EXTI8_0                                 ((uint32_t)0x00000001)         /* Bit0*/
#define AFIO_EXTI_CFG3_EXTI8_1                                 ((uint32_t)0x00000002)         /* Bit1*/
#define AFIO_EXTI_CFG3_EXTI8_2                                 ((uint32_t)0x00000004)         /* Bit2*/
#define AFIO_EXTI_CFG3_EXTI8_3                                 ((uint32_t)0x00000008)         /* Bit3*/
#define AFIO_EXTI_CFG3_EXTI8_4                                 ((uint32_t)0x00000010)         /* Bit4*/
#define AFIO_EXTI_CFG3_EXTI8_5                                 ((uint32_t)0x00000020)         /* Bit5*/
#define AFIO_EXTI_CFG3_EXTI8_6                                 ((uint32_t)0x00000040)         /* Bit6*/
#define AFIO_EXTI_CFG3_EXTI8_7                                 ((uint32_t)0x00000080)         /* Bit7*/

/******** Bit definition for AFIO_EXTI_CFG4 register  ********/
#define AFIO_EXTI_CFG4_EXTI15                                  ((uint32_t)0xFF000000)         /* Bit[31:24] */
#define AFIO_EXTI_CFG4_EXTI15_0                                ((uint32_t)0x01000000)         /* Bit24*/
#define AFIO_EXTI_CFG4_EXTI15_1                                ((uint32_t)0x02000000)         /* Bit25*/
#define AFIO_EXTI_CFG4_EXTI15_2                                ((uint32_t)0x04000000)         /* Bit26*/
#define AFIO_EXTI_CFG4_EXTI15_3                                ((uint32_t)0x08000000)         /* Bit27*/
#define AFIO_EXTI_CFG4_EXTI15_4                                ((uint32_t)0x10000000)         /* Bit28*/
#define AFIO_EXTI_CFG4_EXTI15_5                                ((uint32_t)0x20000000)         /* Bit29*/
#define AFIO_EXTI_CFG4_EXTI15_6                                ((uint32_t)0x40000000)         /* Bit30*/
#define AFIO_EXTI_CFG4_EXTI15_7                                ((uint32_t)0x80000000)         /* Bit31*/
#define AFIO_EXTI_CFG4_EXTI14                                  ((uint32_t)0x00FF0000)         /* Bit[23:16] */
#define AFIO_EXTI_CFG4_EXTI14_0                                ((uint32_t)0x00010000)         /* Bit16*/
#define AFIO_EXTI_CFG4_EXTI14_1                                ((uint32_t)0x00020000)         /* Bit17*/
#define AFIO_EXTI_CFG4_EXTI14_2                                ((uint32_t)0x00040000)         /* Bit18*/
#define AFIO_EXTI_CFG4_EXTI14_3                                ((uint32_t)0x00080000)         /* Bit19*/
#define AFIO_EXTI_CFG4_EXTI14_4                                ((uint32_t)0x00100000)         /* Bit20*/
#define AFIO_EXTI_CFG4_EXTI14_5                                ((uint32_t)0x00200000)         /* Bit21*/
#define AFIO_EXTI_CFG4_EXTI14_6                                ((uint32_t)0x00400000)         /* Bit22*/
#define AFIO_EXTI_CFG4_EXTI14_7                                ((uint32_t)0x00800000)         /* Bit23*/
#define AFIO_EXTI_CFG4_EXTI13                                  ((uint32_t)0x0000FF00)         /* Bit[15:8] */
#define AFIO_EXTI_CFG4_EXTI13_0                                ((uint32_t)0x00000100)         /* Bit8*/
#define AFIO_EXTI_CFG4_EXTI13_1                                ((uint32_t)0x00000200)         /* Bit9*/
#define AFIO_EXTI_CFG4_EXTI13_2                                ((uint32_t)0x00000400)         /* Bit10*/
#define AFIO_EXTI_CFG4_EXTI13_3                                ((uint32_t)0x00000800)         /* Bit11*/
#define AFIO_EXTI_CFG4_EXTI13_4                                ((uint32_t)0x00001000)         /* Bit12*/
#define AFIO_EXTI_CFG4_EXTI13_5                                ((uint32_t)0x00002000)         /* Bit13*/
#define AFIO_EXTI_CFG4_EXTI13_6                                ((uint32_t)0x00004000)         /* Bit14*/
#define AFIO_EXTI_CFG4_EXTI13_7                                ((uint32_t)0x00008000)         /* Bit15*/
#define AFIO_EXTI_CFG4_EXTI12                                  ((uint32_t)0x000000FF)         /* Bit[7:0] */
#define AFIO_EXTI_CFG4_EXTI12_0                                ((uint32_t)0x00000001)         /* Bit0*/
#define AFIO_EXTI_CFG4_EXTI12_1                                ((uint32_t)0x00000002)         /* Bit1*/
#define AFIO_EXTI_CFG4_EXTI12_2                                ((uint32_t)0x00000004)         /* Bit2*/
#define AFIO_EXTI_CFG4_EXTI12_3                                ((uint32_t)0x00000008)         /* Bit3*/
#define AFIO_EXTI_CFG4_EXTI12_4                                ((uint32_t)0x00000010)         /* Bit4*/
#define AFIO_EXTI_CFG4_EXTI12_5                                ((uint32_t)0x00000020)         /* Bit5*/
#define AFIO_EXTI_CFG4_EXTI12_6                                ((uint32_t)0x00000040)         /* Bit6*/
#define AFIO_EXTI_CFG4_EXTI12_7                                ((uint32_t)0x00000080)         /* Bit7*/

/******** Bit definition for AFIO_TOL5V_CFG1 register  ********/
#define AFIO_TOL5V_CFG1_PA7TOLENN                              ((uint32_t)0x00000200)         /* Bit[9] */
#define AFIO_TOL5V_CFG1_PA6TOLENN                              ((uint32_t)0x00000100)         /* Bit[8] */
#define AFIO_TOL5V_CFG1_PA5TOLENN                              ((uint32_t)0x00000080)         /* Bit[7] */
#define AFIO_TOL5V_CFG1_PA4TOLENN                              ((uint32_t)0x00000040)         /* Bit[6] */
#define AFIO_TOL5V_CFG1_PA3TOLENN                              ((uint32_t)0x00000020)         /* Bit[5] */
#define AFIO_TOL5V_CFG1_PA2TOLENN                              ((uint32_t)0x00000010)         /* Bit[4] */
#define AFIO_TOL5V_CFG1_PA1_C_TOLENN                           ((uint32_t)0x00000008)         /* Bit[3] */
#define AFIO_TOL5V_CFG1_PA1TOLENN                              ((uint32_t)0x00000004)         /* Bit[2] */
#define AFIO_TOL5V_CFG1_PA0_C_TOLENN                           ((uint32_t)0x00000002)         /* Bit[1] */
#define AFIO_TOL5V_CFG1_PA0TOLENN                              ((uint32_t)0x00000001)         /* Bit[0] */

/******** Bit definition for AFIO_TOL5V_CFG2 register  ********/
#define AFIO_TOL5V_CFG2_PB1TOLENN                              ((uint32_t)0x00000002)         /* Bit[1] */
#define AFIO_TOL5V_CFG2_PB0TOLENN                              ((uint32_t)0x00000001)         /* Bit[0] */

/******** Bit definition for AFIO_TOL5V_CFG3 register  ********/
#define AFIO_TOL5V_CFG3_PC13TOLENN                             ((uint32_t)0x00000400)         /* Bit[10] */
#define AFIO_TOL5V_CFG3_PC8TOLENN                              ((uint32_t)0x00000200)         /* Bit[9] */
#define AFIO_TOL5V_CFG3_PC6TOLENN                              ((uint32_t)0x00000100)         /* Bit[8] */
#define AFIO_TOL5V_CFG3_PC5TOLENN                              ((uint32_t)0x00000080)         /* Bit[7] */
#define AFIO_TOL5V_CFG3_PC4TOLENN                              ((uint32_t)0x00000040)         /* Bit[6] */
#define AFIO_TOL5V_CFG3_PC3_C_TOLENN                           ((uint32_t)0x00000020)         /* Bit[5] */
#define AFIO_TOL5V_CFG3_PC3TOLENN                              ((uint32_t)0x00000010)         /* Bit[4] */
#define AFIO_TOL5V_CFG3_PC2_C_TOLENN                           ((uint32_t)0x00000008)         /* Bit[3] */
#define AFIO_TOL5V_CFG3_PC2TOLENN                              ((uint32_t)0x00000004)         /* Bit[2] */
#define AFIO_TOL5V_CFG3_PC1TOLENN                              ((uint32_t)0x00000002)         /* Bit[1] */
#define AFIO_TOL5V_CFG3_PC0TOLENN                              ((uint32_t)0x00000001)         /* Bit[0] */

/******** Bit definition for AFIO_SHRT1_FALT_CFG register  ********/
#define AFIO_SHRT1_FALT_CFG_SHRT_FALT6                         ((uint32_t)0x00F00000)         /* Bit[23:20] */
#define AFIO_SHRT1_FALT_CFG_SHRT_FALT6_0                       ((uint32_t)0x00100000)         /* Bit20*/
#define AFIO_SHRT1_FALT_CFG_SHRT_FALT6_1                       ((uint32_t)0x00200000)         /* Bit21*/
#define AFIO_SHRT1_FALT_CFG_SHRT_FALT6_2                       ((uint32_t)0x00400000)         /* Bit22*/
#define AFIO_SHRT1_FALT_CFG_SHRT_FALT6_3                       ((uint32_t)0x00800000)         /* Bit23*/
#define AFIO_SHRT1_FALT_CFG_SHRT_FALT5                         ((uint32_t)0x000F0000)         /* Bit[19:16] */
#define AFIO_SHRT1_FALT_CFG_SHRT_FALT5_0                       ((uint32_t)0x00010000)         /* Bit16*/
#define AFIO_SHRT1_FALT_CFG_SHRT_FALT5_1                       ((uint32_t)0x00020000)         /* Bit17*/
#define AFIO_SHRT1_FALT_CFG_SHRT_FALT5_2                       ((uint32_t)0x00040000)         /* Bit18*/
#define AFIO_SHRT1_FALT_CFG_SHRT_FALT5_3                       ((uint32_t)0x00080000)         /* Bit19*/
#define AFIO_SHRT1_FALT_CFG_SHRT_FALT4                         ((uint32_t)0x0000F000)         /* Bit[15:12] */
#define AFIO_SHRT1_FALT_CFG_SHRT_FALT4_0                       ((uint32_t)0x00001000)         /* Bit12*/
#define AFIO_SHRT1_FALT_CFG_SHRT_FALT4_1                       ((uint32_t)0x00002000)         /* Bit13*/
#define AFIO_SHRT1_FALT_CFG_SHRT_FALT4_2                       ((uint32_t)0x00004000)         /* Bit14*/
#define AFIO_SHRT1_FALT_CFG_SHRT_FALT4_3                       ((uint32_t)0x00008000)         /* Bit15*/
#define AFIO_SHRT1_FALT_CFG_SHRT_FALT3                         ((uint32_t)0x00000F00)         /* Bit[11:8] */
#define AFIO_SHRT1_FALT_CFG_SHRT_FALT3_0                       ((uint32_t)0x00000100)         /* Bit8*/
#define AFIO_SHRT1_FALT_CFG_SHRT_FALT3_1                       ((uint32_t)0x00000200)         /* Bit9*/
#define AFIO_SHRT1_FALT_CFG_SHRT_FALT3_2                       ((uint32_t)0x00000400)         /* Bit10*/
#define AFIO_SHRT1_FALT_CFG_SHRT_FALT3_3                       ((uint32_t)0x00000800)         /* Bit11*/
#define AFIO_SHRT1_FALT_CFG_SHRT_FALT2                         ((uint32_t)0x000000F0)         /* Bit[7:4] */
#define AFIO_SHRT1_FALT_CFG_SHRT_FALT2_0                       ((uint32_t)0x00000010)         /* Bit4*/
#define AFIO_SHRT1_FALT_CFG_SHRT_FALT2_1                       ((uint32_t)0x00000020)         /* Bit5*/
#define AFIO_SHRT1_FALT_CFG_SHRT_FALT2_2                       ((uint32_t)0x00000040)         /* Bit6*/
#define AFIO_SHRT1_FALT_CFG_SHRT_FALT2_3                       ((uint32_t)0x00000080)         /* Bit7*/
#define AFIO_SHRT1_FALT_CFG_SHRT_FALT1                         ((uint32_t)0x0000000F)         /* Bit[3:0] */
#define AFIO_SHRT1_FALT_CFG_SHRT_FALT1_0                       ((uint32_t)0x00000001)         /* Bit0*/
#define AFIO_SHRT1_FALT_CFG_SHRT_FALT1_1                       ((uint32_t)0x00000002)         /* Bit1*/
#define AFIO_SHRT1_FALT_CFG_SHRT_FALT1_2                       ((uint32_t)0x00000004)         /* Bit2*/
#define AFIO_SHRT1_FALT_CFG_SHRT_FALT1_3                       ((uint32_t)0x00000008)         /* Bit3*/

/******** Bit definition for AFIO_SHRT2_FALT_CFG register  ********/
#define AFIO_SHRT2_FALT_CFG_SHRT_FALT6                         ((uint32_t)0x00F00000)         /* Bit[23:20] */
#define AFIO_SHRT2_FALT_CFG_SHRT_FALT6_0                       ((uint32_t)0x00100000)         /* Bit20*/
#define AFIO_SHRT2_FALT_CFG_SHRT_FALT6_1                       ((uint32_t)0x00200000)         /* Bit21*/
#define AFIO_SHRT2_FALT_CFG_SHRT_FALT6_2                       ((uint32_t)0x00400000)         /* Bit22*/
#define AFIO_SHRT2_FALT_CFG_SHRT_FALT6_3                       ((uint32_t)0x00800000)         /* Bit23*/
#define AFIO_SHRT2_FALT_CFG_SHRT_FALT5                         ((uint32_t)0x000F0000)         /* Bit[19:16] */
#define AFIO_SHRT2_FALT_CFG_SHRT_FALT5_0                       ((uint32_t)0x00010000)         /* Bit16*/
#define AFIO_SHRT2_FALT_CFG_SHRT_FALT5_1                       ((uint32_t)0x00020000)         /* Bit17*/
#define AFIO_SHRT2_FALT_CFG_SHRT_FALT5_2                       ((uint32_t)0x00040000)         /* Bit18*/
#define AFIO_SHRT2_FALT_CFG_SHRT_FALT5_3                       ((uint32_t)0x00080000)         /* Bit19*/
#define AFIO_SHRT2_FALT_CFG_SHRT_FALT4                         ((uint32_t)0x0000F000)         /* Bit[15:12] */
#define AFIO_SHRT2_FALT_CFG_SHRT_FALT4_0                       ((uint32_t)0x00001000)         /* Bit12*/
#define AFIO_SHRT2_FALT_CFG_SHRT_FALT4_1                       ((uint32_t)0x00002000)         /* Bit13*/
#define AFIO_SHRT2_FALT_CFG_SHRT_FALT4_2                       ((uint32_t)0x00004000)         /* Bit14*/
#define AFIO_SHRT2_FALT_CFG_SHRT_FALT4_3                       ((uint32_t)0x00008000)         /* Bit15*/
#define AFIO_SHRT2_FALT_CFG_SHRT_FALT3                         ((uint32_t)0x00000F00)         /* Bit[11:8] */
#define AFIO_SHRT2_FALT_CFG_SHRT_FALT3_0                       ((uint32_t)0x00000100)         /* Bit8*/
#define AFIO_SHRT2_FALT_CFG_SHRT_FALT3_1                       ((uint32_t)0x00000200)         /* Bit9*/
#define AFIO_SHRT2_FALT_CFG_SHRT_FALT3_2                       ((uint32_t)0x00000400)         /* Bit10*/
#define AFIO_SHRT2_FALT_CFG_SHRT_FALT3_3                       ((uint32_t)0x00000800)         /* Bit11*/
#define AFIO_SHRT2_FALT_CFG_SHRT_FALT2                         ((uint32_t)0x000000F0)         /* Bit[7:4] */
#define AFIO_SHRT2_FALT_CFG_SHRT_FALT2_0                       ((uint32_t)0x00000010)         /* Bit4*/
#define AFIO_SHRT2_FALT_CFG_SHRT_FALT2_1                       ((uint32_t)0x00000020)         /* Bit5*/
#define AFIO_SHRT2_FALT_CFG_SHRT_FALT2_2                       ((uint32_t)0x00000040)         /* Bit6*/
#define AFIO_SHRT2_FALT_CFG_SHRT_FALT2_3                       ((uint32_t)0x00000080)         /* Bit7*/
#define AFIO_SHRT2_FALT_CFG_SHRT_FALT1                         ((uint32_t)0x0000000F)         /* Bit[3:0] */
#define AFIO_SHRT2_FALT_CFG_SHRT_FALT1_0                       ((uint32_t)0x00000001)         /* Bit0*/
#define AFIO_SHRT2_FALT_CFG_SHRT_FALT1_1                       ((uint32_t)0x00000002)         /* Bit1*/
#define AFIO_SHRT2_FALT_CFG_SHRT_FALT1_2                       ((uint32_t)0x00000004)         /* Bit2*/
#define AFIO_SHRT2_FALT_CFG_SHRT_FALT1_3                       ((uint32_t)0x00000008)         /* Bit3*/

/******** Bit definition for AFIO_TOL5V_CFG4 register  ********/
#define AFIO_TOL5V_CFG4_PF14TOLENN                             ((uint32_t)0x00000800)         /* Bit[11] */
#define AFIO_TOL5V_CFG4_PF13TOLENN                             ((uint32_t)0x00000400)         /* Bit[10] */
#define AFIO_TOL5V_CFG4_PF12TOLENN                             ((uint32_t)0x00000200)         /* Bit[9] */
#define AFIO_TOL5V_CFG4_PF11TOLENN                             ((uint32_t)0x00000100)         /* Bit[8] */
#define AFIO_TOL5V_CFG4_PF10TOLENN                             ((uint32_t)0x00000080)         /* Bit[7] */
#define AFIO_TOL5V_CFG4_PF9TOLENN                              ((uint32_t)0x00000040)         /* Bit[6] */
#define AFIO_TOL5V_CFG4_PF8TOLENN                              ((uint32_t)0x00000020)         /* Bit[5] */
#define AFIO_TOL5V_CFG4_PF7TOLENN                              ((uint32_t)0x00000010)         /* Bit[4] */
#define AFIO_TOL5V_CFG4_PF6TOLENN                              ((uint32_t)0x00000008)         /* Bit[3] */
#define AFIO_TOL5V_CFG4_PF5TOLENN                              ((uint32_t)0x00000004)         /* Bit[2] */
#define AFIO_TOL5V_CFG4_PF4TOLENN                              ((uint32_t)0x00000002)         /* Bit[1] */
#define AFIO_TOL5V_CFG4_PF3TOLENN                              ((uint32_t)0x00000001)         /* Bit[0] */

/******** Bit definition for AFIO_TOL5V_CFG5 register  ********/
#define AFIO_TOL5V_CFG5_PH5TOLENN                              ((uint32_t)0x00000008)         /* Bit[3] */
#define AFIO_TOL5V_CFG5_PH4TOLENN                              ((uint32_t)0x00000004)         /* Bit[2] */
#define AFIO_TOL5V_CFG5_PH3TOLENN                              ((uint32_t)0x00000002)         /* Bit[1] */
#define AFIO_TOL5V_CFG5_PH2TOLENN                              ((uint32_t)0x00000001)         /* Bit[0] */

/******** Bit definition for AFIO_TOL5V_CFG6 register  ********/
#define AFIO_TOL5V_CFG6_PI15TOLENN                             ((uint32_t)0x00000002)         /* Bit[1] */
#define AFIO_TOL5V_CFG6_PI8TOLENN                              ((uint32_t)0x00000001)         /* Bit[0] */

/******** Bit definition for AFIO_TOL5V_CFG7 register  ********/
#define AFIO_TOL5V_CFG7_PJ7TOLENN                              ((uint32_t)0x00000020)         /* Bit[5] */
#define AFIO_TOL5V_CFG7_PJ6TOLENN                              ((uint32_t)0x00000010)         /* Bit[4] */
#define AFIO_TOL5V_CFG7_PJ5TOLENN                              ((uint32_t)0x00000008)         /* Bit[3] */
#define AFIO_TOL5V_CFG7_PJ4TOLENN                              ((uint32_t)0x00000004)         /* Bit[2] */
#define AFIO_TOL5V_CFG7_PJ3TOLENN                              ((uint32_t)0x00000002)         /* Bit[1] */
#define AFIO_TOL5V_CFG7_PJ0TOLENN                              ((uint32_t)0x00000001)         /* Bit[0] */

/******** Bit definition for AFIO_EFT_CFG1 register  ********/
#define AFIO_EFT_CFG1_PB_EFTEN                                 ((uint32_t)0xFFFF0000)         /* Bit[31:16] */
#define AFIO_EFT_CFG1_PB_EFTEN_0                               ((uint32_t)0x00010000)         /* Bit16*/
#define AFIO_EFT_CFG1_PB_EFTEN_1                               ((uint32_t)0x00020000)         /* Bit17*/
#define AFIO_EFT_CFG1_PB_EFTEN_2                               ((uint32_t)0x00040000)         /* Bit18*/
#define AFIO_EFT_CFG1_PB_EFTEN_3                               ((uint32_t)0x00080000)         /* Bit19*/
#define AFIO_EFT_CFG1_PB_EFTEN_4                               ((uint32_t)0x00100000)         /* Bit20*/
#define AFIO_EFT_CFG1_PB_EFTEN_5                               ((uint32_t)0x00200000)         /* Bit21*/
#define AFIO_EFT_CFG1_PB_EFTEN_6                               ((uint32_t)0x00400000)         /* Bit22*/
#define AFIO_EFT_CFG1_PB_EFTEN_7                               ((uint32_t)0x00800000)         /* Bit23*/
#define AFIO_EFT_CFG1_PB_EFTEN_8                               ((uint32_t)0x01000000)         /* Bit24*/
#define AFIO_EFT_CFG1_PB_EFTEN_9                               ((uint32_t)0x02000000)         /* Bit25*/
#define AFIO_EFT_CFG1_PB_EFTEN_10                              ((uint32_t)0x04000000)         /* Bit26*/
#define AFIO_EFT_CFG1_PB_EFTEN_11                              ((uint32_t)0x08000000)         /* Bit27*/
#define AFIO_EFT_CFG1_PB_EFTEN_12                              ((uint32_t)0x10000000)         /* Bit28*/
#define AFIO_EFT_CFG1_PB_EFTEN_13                              ((uint32_t)0x20000000)         /* Bit29*/
#define AFIO_EFT_CFG1_PB_EFTEN_14                              ((uint32_t)0x40000000)         /* Bit30*/
#define AFIO_EFT_CFG1_PB_EFTEN_15                              ((uint32_t)0x80000000)         /* Bit31*/
#define AFIO_EFT_CFG1_PA_EFTEN                                 ((uint32_t)0x0000FFFF)         /* Bit[15:0] */
#define AFIO_EFT_CFG1_PA_EFTEN_0                               ((uint32_t)0x00000001)         /* Bit0*/
#define AFIO_EFT_CFG1_PA_EFTEN_1                               ((uint32_t)0x00000002)         /* Bit1*/
#define AFIO_EFT_CFG1_PA_EFTEN_2                               ((uint32_t)0x00000004)         /* Bit2*/
#define AFIO_EFT_CFG1_PA_EFTEN_3                               ((uint32_t)0x00000008)         /* Bit3*/
#define AFIO_EFT_CFG1_PA_EFTEN_4                               ((uint32_t)0x00000010)         /* Bit4*/
#define AFIO_EFT_CFG1_PA_EFTEN_5                               ((uint32_t)0x00000020)         /* Bit5*/
#define AFIO_EFT_CFG1_PA_EFTEN_6                               ((uint32_t)0x00000040)         /* Bit6*/
#define AFIO_EFT_CFG1_PA_EFTEN_7                               ((uint32_t)0x00000080)         /* Bit7*/
#define AFIO_EFT_CFG1_PA_EFTEN_8                               ((uint32_t)0x00000100)         /* Bit8*/
#define AFIO_EFT_CFG1_PA_EFTEN_9                               ((uint32_t)0x00000200)         /* Bit9*/
#define AFIO_EFT_CFG1_PA_EFTEN_10                              ((uint32_t)0x00000400)         /* Bit10*/
#define AFIO_EFT_CFG1_PA_EFTEN_11                              ((uint32_t)0x00000800)         /* Bit11*/
#define AFIO_EFT_CFG1_PA_EFTEN_12                              ((uint32_t)0x00001000)         /* Bit12*/
#define AFIO_EFT_CFG1_PA_EFTEN_13                              ((uint32_t)0x00002000)         /* Bit13*/
#define AFIO_EFT_CFG1_PA_EFTEN_14                              ((uint32_t)0x00004000)         /* Bit14*/
#define AFIO_EFT_CFG1_PA_EFTEN_15                              ((uint32_t)0x00008000)         /* Bit15*/

/******** Bit definition for AFIO_EFT_CFG2 register  ********/
#define AFIO_EFT_CFG2_PD_EFTEN                                 ((uint32_t)0xFFFF0000)         /* Bit[31:16] */
#define AFIO_EFT_CFG2_PD_EFTEN_0                               ((uint32_t)0x00010000)         /* Bit16*/
#define AFIO_EFT_CFG2_PD_EFTEN_1                               ((uint32_t)0x00020000)         /* Bit17*/
#define AFIO_EFT_CFG2_PD_EFTEN_2                               ((uint32_t)0x00040000)         /* Bit18*/
#define AFIO_EFT_CFG2_PD_EFTEN_3                               ((uint32_t)0x00080000)         /* Bit19*/
#define AFIO_EFT_CFG2_PD_EFTEN_4                               ((uint32_t)0x00100000)         /* Bit20*/
#define AFIO_EFT_CFG2_PD_EFTEN_5                               ((uint32_t)0x00200000)         /* Bit21*/
#define AFIO_EFT_CFG2_PD_EFTEN_6                               ((uint32_t)0x00400000)         /* Bit22*/
#define AFIO_EFT_CFG2_PD_EFTEN_7                               ((uint32_t)0x00800000)         /* Bit23*/
#define AFIO_EFT_CFG2_PD_EFTEN_8                               ((uint32_t)0x01000000)         /* Bit24*/
#define AFIO_EFT_CFG2_PD_EFTEN_9                               ((uint32_t)0x02000000)         /* Bit25*/
#define AFIO_EFT_CFG2_PD_EFTEN_10                              ((uint32_t)0x04000000)         /* Bit26*/
#define AFIO_EFT_CFG2_PD_EFTEN_11                              ((uint32_t)0x08000000)         /* Bit27*/
#define AFIO_EFT_CFG2_PD_EFTEN_12                              ((uint32_t)0x10000000)         /* Bit28*/
#define AFIO_EFT_CFG2_PD_EFTEN_13                              ((uint32_t)0x20000000)         /* Bit29*/
#define AFIO_EFT_CFG2_PD_EFTEN_14                              ((uint32_t)0x40000000)         /* Bit30*/
#define AFIO_EFT_CFG2_PD_EFTEN_15                              ((uint32_t)0x80000000)         /* Bit31*/
#define AFIO_EFT_CFG2_PC_EFTEN                                 ((uint32_t)0x0000FFFF)         /* Bit[15:0] */
#define AFIO_EFT_CFG2_PC_EFTEN_0                               ((uint32_t)0x00000001)         /* Bit0*/
#define AFIO_EFT_CFG2_PC_EFTEN_1                               ((uint32_t)0x00000002)         /* Bit1*/
#define AFIO_EFT_CFG2_PC_EFTEN_2                               ((uint32_t)0x00000004)         /* Bit2*/
#define AFIO_EFT_CFG2_PC_EFTEN_3                               ((uint32_t)0x00000008)         /* Bit3*/
#define AFIO_EFT_CFG2_PC_EFTEN_4                               ((uint32_t)0x00000010)         /* Bit4*/
#define AFIO_EFT_CFG2_PC_EFTEN_5                               ((uint32_t)0x00000020)         /* Bit5*/
#define AFIO_EFT_CFG2_PC_EFTEN_6                               ((uint32_t)0x00000040)         /* Bit6*/
#define AFIO_EFT_CFG2_PC_EFTEN_7                               ((uint32_t)0x00000080)         /* Bit7*/
#define AFIO_EFT_CFG2_PC_EFTEN_8                               ((uint32_t)0x00000100)         /* Bit8*/
#define AFIO_EFT_CFG2_PC_EFTEN_9                               ((uint32_t)0x00000200)         /* Bit9*/
#define AFIO_EFT_CFG2_PC_EFTEN_10                              ((uint32_t)0x00000400)         /* Bit10*/
#define AFIO_EFT_CFG2_PC_EFTEN_11                              ((uint32_t)0x00000800)         /* Bit11*/
#define AFIO_EFT_CFG2_PC_EFTEN_12                              ((uint32_t)0x00001000)         /* Bit12*/
#define AFIO_EFT_CFG2_PC_EFTEN_13                              ((uint32_t)0x00002000)         /* Bit13*/
#define AFIO_EFT_CFG2_PC_EFTEN_14                              ((uint32_t)0x00004000)         /* Bit14*/
#define AFIO_EFT_CFG2_PC_EFTEN_15                              ((uint32_t)0x00008000)         /* Bit15*/

/******** Bit definition for AFIO_EFT_CFG3 register  ********/
#define AFIO_EFT_CFG3_PF_EFTEN                                 ((uint32_t)0xFFFF0000)         /* Bit[31:16] */
#define AFIO_EFT_CFG3_PF_EFTEN_0                               ((uint32_t)0x00010000)         /* Bit16*/
#define AFIO_EFT_CFG3_PF_EFTEN_1                               ((uint32_t)0x00020000)         /* Bit17*/
#define AFIO_EFT_CFG3_PF_EFTEN_2                               ((uint32_t)0x00040000)         /* Bit18*/
#define AFIO_EFT_CFG3_PF_EFTEN_3                               ((uint32_t)0x00080000)         /* Bit19*/
#define AFIO_EFT_CFG3_PF_EFTEN_4                               ((uint32_t)0x00100000)         /* Bit20*/
#define AFIO_EFT_CFG3_PF_EFTEN_5                               ((uint32_t)0x00200000)         /* Bit21*/
#define AFIO_EFT_CFG3_PF_EFTEN_6                               ((uint32_t)0x00400000)         /* Bit22*/
#define AFIO_EFT_CFG3_PF_EFTEN_7                               ((uint32_t)0x00800000)         /* Bit23*/
#define AFIO_EFT_CFG3_PF_EFTEN_8                               ((uint32_t)0x01000000)         /* Bit24*/
#define AFIO_EFT_CFG3_PF_EFTEN_9                               ((uint32_t)0x02000000)         /* Bit25*/
#define AFIO_EFT_CFG3_PF_EFTEN_10                              ((uint32_t)0x04000000)         /* Bit26*/
#define AFIO_EFT_CFG3_PF_EFTEN_11                              ((uint32_t)0x08000000)         /* Bit27*/
#define AFIO_EFT_CFG3_PF_EFTEN_12                              ((uint32_t)0x10000000)         /* Bit28*/
#define AFIO_EFT_CFG3_PF_EFTEN_13                              ((uint32_t)0x20000000)         /* Bit29*/
#define AFIO_EFT_CFG3_PF_EFTEN_14                              ((uint32_t)0x40000000)         /* Bit30*/
#define AFIO_EFT_CFG3_PF_EFTEN_15                              ((uint32_t)0x80000000)         /* Bit31*/
#define AFIO_EFT_CFG3_PE_EFTEN                                 ((uint32_t)0x0000FFFF)         /* Bit[15:0] */
#define AFIO_EFT_CFG3_PE_EFTEN_0                               ((uint32_t)0x00000001)         /* Bit0*/
#define AFIO_EFT_CFG3_PE_EFTEN_1                               ((uint32_t)0x00000002)         /* Bit1*/
#define AFIO_EFT_CFG3_PE_EFTEN_2                               ((uint32_t)0x00000004)         /* Bit2*/
#define AFIO_EFT_CFG3_PE_EFTEN_3                               ((uint32_t)0x00000008)         /* Bit3*/
#define AFIO_EFT_CFG3_PE_EFTEN_4                               ((uint32_t)0x00000010)         /* Bit4*/
#define AFIO_EFT_CFG3_PE_EFTEN_5                               ((uint32_t)0x00000020)         /* Bit5*/
#define AFIO_EFT_CFG3_PE_EFTEN_6                               ((uint32_t)0x00000040)         /* Bit6*/
#define AFIO_EFT_CFG3_PE_EFTEN_7                               ((uint32_t)0x00000080)         /* Bit7*/
#define AFIO_EFT_CFG3_PE_EFTEN_8                               ((uint32_t)0x00000100)         /* Bit8*/
#define AFIO_EFT_CFG3_PE_EFTEN_9                               ((uint32_t)0x00000200)         /* Bit9*/
#define AFIO_EFT_CFG3_PE_EFTEN_10                              ((uint32_t)0x00000400)         /* Bit10*/
#define AFIO_EFT_CFG3_PE_EFTEN_11                              ((uint32_t)0x00000800)         /* Bit11*/
#define AFIO_EFT_CFG3_PE_EFTEN_12                              ((uint32_t)0x00001000)         /* Bit12*/
#define AFIO_EFT_CFG3_PE_EFTEN_13                              ((uint32_t)0x00002000)         /* Bit13*/
#define AFIO_EFT_CFG3_PE_EFTEN_14                              ((uint32_t)0x00004000)         /* Bit14*/
#define AFIO_EFT_CFG3_PE_EFTEN_15                              ((uint32_t)0x00008000)         /* Bit15*/

/******** Bit definition for AFIO_EFT_CFG4 register  ********/
#define AFIO_EFT_CFG4_PH_EFTEN                                 ((uint32_t)0xFFFF0000)         /* Bit[31:16] */
#define AFIO_EFT_CFG4_PH_EFTEN_0                               ((uint32_t)0x00010000)         /* Bit16*/
#define AFIO_EFT_CFG4_PH_EFTEN_1                               ((uint32_t)0x00020000)         /* Bit17*/
#define AFIO_EFT_CFG4_PH_EFTEN_2                               ((uint32_t)0x00040000)         /* Bit18*/
#define AFIO_EFT_CFG4_PH_EFTEN_3                               ((uint32_t)0x00080000)         /* Bit19*/
#define AFIO_EFT_CFG4_PH_EFTEN_4                               ((uint32_t)0x00100000)         /* Bit20*/
#define AFIO_EFT_CFG4_PH_EFTEN_5                               ((uint32_t)0x00200000)         /* Bit21*/
#define AFIO_EFT_CFG4_PH_EFTEN_6                               ((uint32_t)0x00400000)         /* Bit22*/
#define AFIO_EFT_CFG4_PH_EFTEN_7                               ((uint32_t)0x00800000)         /* Bit23*/
#define AFIO_EFT_CFG4_PH_EFTEN_8                               ((uint32_t)0x01000000)         /* Bit24*/
#define AFIO_EFT_CFG4_PH_EFTEN_9                               ((uint32_t)0x02000000)         /* Bit25*/
#define AFIO_EFT_CFG4_PH_EFTEN_10                              ((uint32_t)0x04000000)         /* Bit26*/
#define AFIO_EFT_CFG4_PH_EFTEN_11                              ((uint32_t)0x08000000)         /* Bit27*/
#define AFIO_EFT_CFG4_PH_EFTEN_12                              ((uint32_t)0x10000000)         /* Bit28*/
#define AFIO_EFT_CFG4_PH_EFTEN_13                              ((uint32_t)0x20000000)         /* Bit29*/
#define AFIO_EFT_CFG4_PH_EFTEN_14                              ((uint32_t)0x40000000)         /* Bit30*/
#define AFIO_EFT_CFG4_PH_EFTEN_15                              ((uint32_t)0x80000000)         /* Bit31*/
#define AFIO_EFT_CFG4_PG_EFTEN                                 ((uint32_t)0x0000FFFF)         /* Bit[15:0] */
#define AFIO_EFT_CFG4_PG_EFTEN_0                               ((uint32_t)0x00000001)         /* Bit0*/
#define AFIO_EFT_CFG4_PG_EFTEN_1                               ((uint32_t)0x00000002)         /* Bit1*/
#define AFIO_EFT_CFG4_PG_EFTEN_2                               ((uint32_t)0x00000004)         /* Bit2*/
#define AFIO_EFT_CFG4_PG_EFTEN_3                               ((uint32_t)0x00000008)         /* Bit3*/
#define AFIO_EFT_CFG4_PG_EFTEN_4                               ((uint32_t)0x00000010)         /* Bit4*/
#define AFIO_EFT_CFG4_PG_EFTEN_5                               ((uint32_t)0x00000020)         /* Bit5*/
#define AFIO_EFT_CFG4_PG_EFTEN_6                               ((uint32_t)0x00000040)         /* Bit6*/
#define AFIO_EFT_CFG4_PG_EFTEN_7                               ((uint32_t)0x00000080)         /* Bit7*/
#define AFIO_EFT_CFG4_PG_EFTEN_8                               ((uint32_t)0x00000100)         /* Bit8*/
#define AFIO_EFT_CFG4_PG_EFTEN_9                               ((uint32_t)0x00000200)         /* Bit9*/
#define AFIO_EFT_CFG4_PG_EFTEN_10                              ((uint32_t)0x00000400)         /* Bit10*/
#define AFIO_EFT_CFG4_PG_EFTEN_11                              ((uint32_t)0x00000800)         /* Bit11*/
#define AFIO_EFT_CFG4_PG_EFTEN_12                              ((uint32_t)0x00001000)         /* Bit12*/
#define AFIO_EFT_CFG4_PG_EFTEN_13                              ((uint32_t)0x00002000)         /* Bit13*/
#define AFIO_EFT_CFG4_PG_EFTEN_14                              ((uint32_t)0x00004000)         /* Bit14*/
#define AFIO_EFT_CFG4_PG_EFTEN_15                              ((uint32_t)0x00008000)         /* Bit15*/

/******** Bit definition for AFIO_EFT_CFG5 register  ********/
#define AFIO_EFT_CFG5_PI_EFTEN                                 ((uint32_t)0xFFFF0000)         /* Bit[31:16] */
#define AFIO_EFT_CFG5_PI_EFTEN_0                               ((uint32_t)0x00010000)         /* Bit16*/
#define AFIO_EFT_CFG5_PI_EFTEN_1                               ((uint32_t)0x00020000)         /* Bit17*/
#define AFIO_EFT_CFG5_PI_EFTEN_2                               ((uint32_t)0x00040000)         /* Bit18*/
#define AFIO_EFT_CFG5_PI_EFTEN_3                               ((uint32_t)0x00080000)         /* Bit19*/
#define AFIO_EFT_CFG5_PI_EFTEN_4                               ((uint32_t)0x00100000)         /* Bit20*/
#define AFIO_EFT_CFG5_PI_EFTEN_5                               ((uint32_t)0x00200000)         /* Bit21*/
#define AFIO_EFT_CFG5_PI_EFTEN_6                               ((uint32_t)0x00400000)         /* Bit22*/
#define AFIO_EFT_CFG5_PI_EFTEN_7                               ((uint32_t)0x00800000)         /* Bit23*/
#define AFIO_EFT_CFG5_PI_EFTEN_8                               ((uint32_t)0x01000000)         /* Bit24*/
#define AFIO_EFT_CFG5_PI_EFTEN_9                               ((uint32_t)0x02000000)         /* Bit25*/
#define AFIO_EFT_CFG5_PI_EFTEN_10                              ((uint32_t)0x04000000)         /* Bit26*/
#define AFIO_EFT_CFG5_PI_EFTEN_11                              ((uint32_t)0x08000000)         /* Bit27*/
#define AFIO_EFT_CFG5_PI_EFTEN_12                              ((uint32_t)0x10000000)         /* Bit28*/
#define AFIO_EFT_CFG5_PI_EFTEN_13                              ((uint32_t)0x20000000)         /* Bit29*/
#define AFIO_EFT_CFG5_PI_EFTEN_14                              ((uint32_t)0x40000000)         /* Bit30*/
#define AFIO_EFT_CFG5_PI_EFTEN_15                              ((uint32_t)0x80000000)         /* Bit31*/
#define AFIO_EFT_CFG5_PJ_EFTEN                                 ((uint32_t)0x0000FFFF)         /* Bit[15:0] */
#define AFIO_EFT_CFG5_PJ_EFTEN_0                               ((uint32_t)0x00000001)         /* Bit0*/
#define AFIO_EFT_CFG5_PJ_EFTEN_1                               ((uint32_t)0x00000002)         /* Bit1*/
#define AFIO_EFT_CFG5_PJ_EFTEN_2                               ((uint32_t)0x00000004)         /* Bit2*/
#define AFIO_EFT_CFG5_PJ_EFTEN_3                               ((uint32_t)0x00000008)         /* Bit3*/
#define AFIO_EFT_CFG5_PJ_EFTEN_4                               ((uint32_t)0x00000010)         /* Bit4*/
#define AFIO_EFT_CFG5_PJ_EFTEN_5                               ((uint32_t)0x00000020)         /* Bit5*/
#define AFIO_EFT_CFG5_PJ_EFTEN_6                               ((uint32_t)0x00000040)         /* Bit6*/
#define AFIO_EFT_CFG5_PJ_EFTEN_7                               ((uint32_t)0x00000080)         /* Bit7*/
#define AFIO_EFT_CFG5_PJ_EFTEN_8                               ((uint32_t)0x00000100)         /* Bit8*/
#define AFIO_EFT_CFG5_PJ_EFTEN_9                               ((uint32_t)0x00000200)         /* Bit9*/
#define AFIO_EFT_CFG5_PJ_EFTEN_10                              ((uint32_t)0x00000400)         /* Bit10*/
#define AFIO_EFT_CFG5_PJ_EFTEN_11                              ((uint32_t)0x00000800)         /* Bit11*/
#define AFIO_EFT_CFG5_PJ_EFTEN_12                              ((uint32_t)0x00001000)         /* Bit12*/
#define AFIO_EFT_CFG5_PJ_EFTEN_13                              ((uint32_t)0x00002000)         /* Bit13*/
#define AFIO_EFT_CFG5_PJ_EFTEN_14                              ((uint32_t)0x00004000)         /* Bit14*/
#define AFIO_EFT_CFG5_PJ_EFTEN_15                              ((uint32_t)0x00008000)         /* Bit15*/

/******** Bit definition for AFIO_EFTIE_CFG6 register  ********/
#define AFIO_EFT_CFG6_JRST_ANA_FIL_BYPASS                      ((uint32_t)0x00000200)         /* Bit[9] */
#define AFIO_EFT_CFG6_BOOT_EFTEN                               ((uint32_t)0x00000100)         /* Bit[8] */
#define AFIO_EFT_CFG6_PK_EFTEN                                 ((uint32_t)0x000000FF)         /* Bit[7:0] */
#define AFIO_EFT_CFG6_PK_EFTEN_0                               ((uint32_t)0x00000001)         /* Bit0*/
#define AFIO_EFT_CFG6_PK_EFTEN_1                               ((uint32_t)0x00000002)         /* Bit1*/
#define AFIO_EFT_CFG6_PK_EFTEN_2                               ((uint32_t)0x00000004)         /* Bit2*/
#define AFIO_EFT_CFG6_PK_EFTEN_3                               ((uint32_t)0x00000008)         /* Bit3*/
#define AFIO_EFT_CFG6_PK_EFTEN_4                               ((uint32_t)0x00000010)         /* Bit4*/
#define AFIO_EFT_CFG6_PK_EFTEN_5                               ((uint32_t)0x00000020)         /* Bit5*/
#define AFIO_EFT_CFG6_PK_EFTEN_6                               ((uint32_t)0x00000040)         /* Bit6*/
#define AFIO_EFT_CFG6_PK_EFTEN_7                               ((uint32_t)0x00000080)         /* Bit7*/

/******** Bit definition for AFIO_DIGEFT_CFG1 register  ********/
#define AFIO_DIGEFT_CFG1_PB_DIGEFTEN                        ((uint32_t)0xFFFF0000)         /* Bit[31:16] */
#define AFIO_DIGEFT_CFG1_PB_DIGEFTEN_0                      ((uint32_t)0x00010000)         /* Bit16*/
#define AFIO_DIGEFT_CFG1_PB_DIGEFTEN_1                      ((uint32_t)0x00020000)         /* Bit17*/
#define AFIO_DIGEFT_CFG1_PB_DIGEFTEN_2                      ((uint32_t)0x00040000)         /* Bit18*/
#define AFIO_DIGEFT_CFG1_PB_DIGEFTEN_3                      ((uint32_t)0x00080000)         /* Bit19*/
#define AFIO_DIGEFT_CFG1_PB_DIGEFTEN_4                      ((uint32_t)0x00100000)         /* Bit20*/
#define AFIO_DIGEFT_CFG1_PB_DIGEFTEN_5                      ((uint32_t)0x00200000)         /* Bit21*/
#define AFIO_DIGEFT_CFG1_PB_DIGEFTEN_6                      ((uint32_t)0x00400000)         /* Bit22*/
#define AFIO_DIGEFT_CFG1_PB_DIGEFTEN_7                      ((uint32_t)0x00800000)         /* Bit23*/
#define AFIO_DIGEFT_CFG1_PB_DIGEFTEN_8                      ((uint32_t)0x01000000)         /* Bit24*/
#define AFIO_DIGEFT_CFG1_PB_DIGEFTEN_9                      ((uint32_t)0x02000000)         /* Bit25*/
#define AFIO_DIGEFT_CFG1_PB_DIGEFTEN_10                     ((uint32_t)0x04000000)         /* Bit26*/
#define AFIO_DIGEFT_CFG1_PB_DIGEFTEN_11                     ((uint32_t)0x08000000)         /* Bit27*/
#define AFIO_DIGEFT_CFG1_PB_DIGEFTEN_12                     ((uint32_t)0x10000000)         /* Bit28*/
#define AFIO_DIGEFT_CFG1_PB_DIGEFTEN_13                     ((uint32_t)0x20000000)         /* Bit29*/
#define AFIO_DIGEFT_CFG1_PB_DIGEFTEN_14                     ((uint32_t)0x40000000)         /* Bit30*/
#define AFIO_DIGEFT_CFG1_PB_DIGEFTEN_15                     ((uint32_t)0x80000000)         /* Bit31*/
#define AFIO_DIGEFT_CFG1_PA_DIGEFTEN                        ((uint32_t)0x0000FFFF)         /* Bit[15:0] */
#define AFIO_DIGEFT_CFG1_PA_DIGEFTEN_0                      ((uint32_t)0x00000001)         /* Bit0*/
#define AFIO_DIGEFT_CFG1_PA_DIGEFTEN_1                      ((uint32_t)0x00000002)         /* Bit1*/
#define AFIO_DIGEFT_CFG1_PA_DIGEFTEN_2                      ((uint32_t)0x00000004)         /* Bit2*/
#define AFIO_DIGEFT_CFG1_PA_DIGEFTEN_3                      ((uint32_t)0x00000008)         /* Bit3*/
#define AFIO_DIGEFT_CFG1_PA_DIGEFTEN_4                      ((uint32_t)0x00000010)         /* Bit4*/
#define AFIO_DIGEFT_CFG1_PA_DIGEFTEN_5                      ((uint32_t)0x00000020)         /* Bit5*/
#define AFIO_DIGEFT_CFG1_PA_DIGEFTEN_6                      ((uint32_t)0x00000040)         /* Bit6*/
#define AFIO_DIGEFT_CFG1_PA_DIGEFTEN_7                      ((uint32_t)0x00000080)         /* Bit7*/
#define AFIO_DIGEFT_CFG1_PA_DIGEFTEN_8                      ((uint32_t)0x00000100)         /* Bit8*/
#define AFIO_DIGEFT_CFG1_PA_DIGEFTEN_9                      ((uint32_t)0x00000200)         /* Bit9*/
#define AFIO_DIGEFT_CFG1_PA_DIGEFTEN_10                     ((uint32_t)0x00000400)         /* Bit10*/
#define AFIO_DIGEFT_CFG1_PA_DIGEFTEN_11                     ((uint32_t)0x00000800)         /* Bit11*/
#define AFIO_DIGEFT_CFG1_PA_DIGEFTEN_12                     ((uint32_t)0x00001000)         /* Bit12*/
#define AFIO_DIGEFT_CFG1_PA_DIGEFTEN_13                     ((uint32_t)0x00002000)         /* Bit13*/
#define AFIO_DIGEFT_CFG1_PA_DIGEFTEN_14                     ((uint32_t)0x00004000)         /* Bit14*/
#define AFIO_DIGEFT_CFG1_PA_DIGEFTEN_15                     ((uint32_t)0x00008000)         /* Bit15*/

/******** Bit definition for AFIO_DIGEFT_CFG2 register  ********/
#define AFIO_DIGEFT_CFG2_PD_DIGEFTEN                        ((uint32_t)0xFFFF0000)         /* Bit[31:16] */
#define AFIO_DIGEFT_CFG2_PD_DIGEFTEN_0                      ((uint32_t)0x00010000)         /* Bit16*/
#define AFIO_DIGEFT_CFG2_PD_DIGEFTEN_1                      ((uint32_t)0x00020000)         /* Bit17*/
#define AFIO_DIGEFT_CFG2_PD_DIGEFTEN_2                      ((uint32_t)0x00040000)         /* Bit18*/
#define AFIO_DIGEFT_CFG2_PD_DIGEFTEN_3                      ((uint32_t)0x00080000)         /* Bit19*/
#define AFIO_DIGEFT_CFG2_PD_DIGEFTEN_4                      ((uint32_t)0x00100000)         /* Bit20*/
#define AFIO_DIGEFT_CFG2_PD_DIGEFTEN_5                      ((uint32_t)0x00200000)         /* Bit21*/
#define AFIO_DIGEFT_CFG2_PD_DIGEFTEN_6                      ((uint32_t)0x00400000)         /* Bit22*/
#define AFIO_DIGEFT_CFG2_PD_DIGEFTEN_7                      ((uint32_t)0x00800000)         /* Bit23*/
#define AFIO_DIGEFT_CFG2_PD_DIGEFTEN_8                      ((uint32_t)0x01000000)         /* Bit24*/
#define AFIO_DIGEFT_CFG2_PD_DIGEFTEN_9                      ((uint32_t)0x02000000)         /* Bit25*/
#define AFIO_DIGEFT_CFG2_PD_DIGEFTEN_10                     ((uint32_t)0x04000000)         /* Bit26*/
#define AFIO_DIGEFT_CFG2_PD_DIGEFTEN_11                     ((uint32_t)0x08000000)         /* Bit27*/
#define AFIO_DIGEFT_CFG2_PD_DIGEFTEN_12                     ((uint32_t)0x10000000)         /* Bit28*/
#define AFIO_DIGEFT_CFG2_PD_DIGEFTEN_13                     ((uint32_t)0x20000000)         /* Bit29*/
#define AFIO_DIGEFT_CFG2_PD_DIGEFTEN_14                     ((uint32_t)0x40000000)         /* Bit30*/
#define AFIO_DIGEFT_CFG2_PD_DIGEFTEN_15                     ((uint32_t)0x80000000)         /* Bit31*/
#define AFIO_DIGEFT_CFG2_PC_DIGEFTEN                        ((uint32_t)0x0000FFFF)         /* Bit[15:0] */
#define AFIO_DIGEFT_CFG2_PC_DIGEFTEN_0                      ((uint32_t)0x00000001)         /* Bit0*/
#define AFIO_DIGEFT_CFG2_PC_DIGEFTEN_1                      ((uint32_t)0x00000002)         /* Bit1*/
#define AFIO_DIGEFT_CFG2_PC_DIGEFTEN_2                      ((uint32_t)0x00000004)         /* Bit2*/
#define AFIO_DIGEFT_CFG2_PC_DIGEFTEN_3                      ((uint32_t)0x00000008)         /* Bit3*/
#define AFIO_DIGEFT_CFG2_PC_DIGEFTEN_4                      ((uint32_t)0x00000010)         /* Bit4*/
#define AFIO_DIGEFT_CFG2_PC_DIGEFTEN_5                      ((uint32_t)0x00000020)         /* Bit5*/
#define AFIO_DIGEFT_CFG2_PC_DIGEFTEN_6                      ((uint32_t)0x00000040)         /* Bit6*/
#define AFIO_DIGEFT_CFG2_PC_DIGEFTEN_7                      ((uint32_t)0x00000080)         /* Bit7*/
#define AFIO_DIGEFT_CFG2_PC_DIGEFTEN_8                      ((uint32_t)0x00000100)         /* Bit8*/
#define AFIO_DIGEFT_CFG2_PC_DIGEFTEN_9                      ((uint32_t)0x00000200)         /* Bit9*/
#define AFIO_DIGEFT_CFG2_PC_DIGEFTEN_10                     ((uint32_t)0x00000400)         /* Bit10*/
#define AFIO_DIGEFT_CFG2_PC_DIGEFTEN_11                     ((uint32_t)0x00000800)         /* Bit11*/
#define AFIO_DIGEFT_CFG2_PC_DIGEFTEN_12                     ((uint32_t)0x00001000)         /* Bit12*/
#define AFIO_DIGEFT_CFG2_PC_DIGEFTEN_13                     ((uint32_t)0x00002000)         /* Bit13*/
#define AFIO_DIGEFT_CFG2_PC_DIGEFTEN_14                     ((uint32_t)0x00004000)         /* Bit14*/
#define AFIO_DIGEFT_CFG2_PC_DIGEFTEN_15                     ((uint32_t)0x00008000)         /* Bit15*/

/******** Bit definition for AFIO_DIGEFT_CFG3 register  ********/
#define AFIO_DIGEFT_CFG3_PF_DIGEFTEN                        ((uint32_t)0xFFFF0000)         /* Bit[31:16] */
#define AFIO_DIGEFT_CFG3_PF_DIGEFTEN_0                      ((uint32_t)0x00010000)         /* Bit16*/
#define AFIO_DIGEFT_CFG3_PF_DIGEFTEN_1                      ((uint32_t)0x00020000)         /* Bit17*/
#define AFIO_DIGEFT_CFG3_PF_DIGEFTEN_2                      ((uint32_t)0x00040000)         /* Bit18*/
#define AFIO_DIGEFT_CFG3_PF_DIGEFTEN_3                      ((uint32_t)0x00080000)         /* Bit19*/
#define AFIO_DIGEFT_CFG3_PF_DIGEFTEN_4                      ((uint32_t)0x00100000)         /* Bit20*/
#define AFIO_DIGEFT_CFG3_PF_DIGEFTEN_5                      ((uint32_t)0x00200000)         /* Bit21*/
#define AFIO_DIGEFT_CFG3_PF_DIGEFTEN_6                      ((uint32_t)0x00400000)         /* Bit22*/
#define AFIO_DIGEFT_CFG3_PF_DIGEFTEN_7                      ((uint32_t)0x00800000)         /* Bit23*/
#define AFIO_DIGEFT_CFG3_PF_DIGEFTEN_8                      ((uint32_t)0x01000000)         /* Bit24*/
#define AFIO_DIGEFT_CFG3_PF_DIGEFTEN_9                      ((uint32_t)0x02000000)         /* Bit25*/
#define AFIO_DIGEFT_CFG3_PF_DIGEFTEN_10                     ((uint32_t)0x04000000)         /* Bit26*/
#define AFIO_DIGEFT_CFG3_PF_DIGEFTEN_11                     ((uint32_t)0x08000000)         /* Bit27*/
#define AFIO_DIGEFT_CFG3_PF_DIGEFTEN_12                     ((uint32_t)0x10000000)         /* Bit28*/
#define AFIO_DIGEFT_CFG3_PF_DIGEFTEN_13                     ((uint32_t)0x20000000)         /* Bit29*/
#define AFIO_DIGEFT_CFG3_PF_DIGEFTEN_14                     ((uint32_t)0x40000000)         /* Bit30*/
#define AFIO_DIGEFT_CFG3_PF_DIGEFTEN_15                     ((uint32_t)0x80000000)         /* Bit31*/
#define AFIO_DIGEFT_CFG3_PE_DIGEFTEN                        ((uint32_t)0x0000FFFF)         /* Bit[15:0] */
#define AFIO_DIGEFT_CFG3_PE_DIGEFTEN_0                      ((uint32_t)0x00000001)         /* Bit0*/
#define AFIO_DIGEFT_CFG3_PE_DIGEFTEN_1                      ((uint32_t)0x00000002)         /* Bit1*/
#define AFIO_DIGEFT_CFG3_PE_DIGEFTEN_2                      ((uint32_t)0x00000004)         /* Bit2*/
#define AFIO_DIGEFT_CFG3_PE_DIGEFTEN_3                      ((uint32_t)0x00000008)         /* Bit3*/
#define AFIO_DIGEFT_CFG3_PE_DIGEFTEN_4                      ((uint32_t)0x00000010)         /* Bit4*/
#define AFIO_DIGEFT_CFG3_PE_DIGEFTEN_5                      ((uint32_t)0x00000020)         /* Bit5*/
#define AFIO_DIGEFT_CFG3_PE_DIGEFTEN_6                      ((uint32_t)0x00000040)         /* Bit6*/
#define AFIO_DIGEFT_CFG3_PE_DIGEFTEN_7                      ((uint32_t)0x00000080)         /* Bit7*/
#define AFIO_DIGEFT_CFG3_PE_DIGEFTEN_8                      ((uint32_t)0x00000100)         /* Bit8*/
#define AFIO_DIGEFT_CFG3_PE_DIGEFTEN_9                      ((uint32_t)0x00000200)         /* Bit9*/
#define AFIO_DIGEFT_CFG3_PE_DIGEFTEN_10                     ((uint32_t)0x00000400)         /* Bit10*/
#define AFIO_DIGEFT_CFG3_PE_DIGEFTEN_11                     ((uint32_t)0x00000800)         /* Bit11*/
#define AFIO_DIGEFT_CFG3_PE_DIGEFTEN_12                     ((uint32_t)0x00001000)         /* Bit12*/
#define AFIO_DIGEFT_CFG3_PE_DIGEFTEN_13                     ((uint32_t)0x00002000)         /* Bit13*/
#define AFIO_DIGEFT_CFG3_PE_DIGEFTEN_14                     ((uint32_t)0x00004000)         /* Bit14*/
#define AFIO_DIGEFT_CFG3_PE_DIGEFTEN_15                     ((uint32_t)0x00008000)         /* Bit15*/

/******** Bit definition for AFIO_DIGEFT_CFG4 register  ********/
#define AFIO_DIGEFT_CFG4_PH_DIGEFTEN                        ((uint32_t)0xFFFF0000)         /* Bit[31:16] */
#define AFIO_DIGEFT_CFG4_PH_DIGEFTEN_0                      ((uint32_t)0x00010000)         /* Bit16*/
#define AFIO_DIGEFT_CFG4_PH_DIGEFTEN_1                      ((uint32_t)0x00020000)         /* Bit17*/
#define AFIO_DIGEFT_CFG4_PH_DIGEFTEN_2                      ((uint32_t)0x00040000)         /* Bit18*/
#define AFIO_DIGEFT_CFG4_PH_DIGEFTEN_3                      ((uint32_t)0x00080000)         /* Bit19*/
#define AFIO_DIGEFT_CFG4_PH_DIGEFTEN_4                      ((uint32_t)0x00100000)         /* Bit20*/
#define AFIO_DIGEFT_CFG4_PH_DIGEFTEN_5                      ((uint32_t)0x00200000)         /* Bit21*/
#define AFIO_DIGEFT_CFG4_PH_DIGEFTEN_6                      ((uint32_t)0x00400000)         /* Bit22*/
#define AFIO_DIGEFT_CFG4_PH_DIGEFTEN_7                      ((uint32_t)0x00800000)         /* Bit23*/
#define AFIO_DIGEFT_CFG4_PH_DIGEFTEN_8                      ((uint32_t)0x01000000)         /* Bit24*/
#define AFIO_DIGEFT_CFG4_PH_DIGEFTEN_9                      ((uint32_t)0x02000000)         /* Bit25*/
#define AFIO_DIGEFT_CFG4_PH_DIGEFTEN_10                     ((uint32_t)0x04000000)         /* Bit26*/
#define AFIO_DIGEFT_CFG4_PH_DIGEFTEN_11                     ((uint32_t)0x08000000)         /* Bit27*/
#define AFIO_DIGEFT_CFG4_PH_DIGEFTEN_12                     ((uint32_t)0x10000000)         /* Bit28*/
#define AFIO_DIGEFT_CFG4_PH_DIGEFTEN_13                     ((uint32_t)0x20000000)         /* Bit29*/
#define AFIO_DIGEFT_CFG4_PH_DIGEFTEN_14                     ((uint32_t)0x40000000)         /* Bit30*/
#define AFIO_DIGEFT_CFG4_PH_DIGEFTEN_15                     ((uint32_t)0x80000000)         /* Bit31*/
#define AFIO_DIGEFT_CFG4_PG_DIGEFTEN                        ((uint32_t)0x0000FFFF)         /* Bit[15:0] */
#define AFIO_DIGEFT_CFG4_PG_DIGEFTEN_0                      ((uint32_t)0x00000001)         /* Bit0*/
#define AFIO_DIGEFT_CFG4_PG_DIGEFTEN_1                      ((uint32_t)0x00000002)         /* Bit1*/
#define AFIO_DIGEFT_CFG4_PG_DIGEFTEN_2                      ((uint32_t)0x00000004)         /* Bit2*/
#define AFIO_DIGEFT_CFG4_PG_DIGEFTEN_3                      ((uint32_t)0x00000008)         /* Bit3*/
#define AFIO_DIGEFT_CFG4_PG_DIGEFTEN_4                      ((uint32_t)0x00000010)         /* Bit4*/
#define AFIO_DIGEFT_CFG4_PG_DIGEFTEN_5                      ((uint32_t)0x00000020)         /* Bit5*/
#define AFIO_DIGEFT_CFG4_PG_DIGEFTEN_6                      ((uint32_t)0x00000040)         /* Bit6*/
#define AFIO_DIGEFT_CFG4_PG_DIGEFTEN_7                      ((uint32_t)0x00000080)         /* Bit7*/
#define AFIO_DIGEFT_CFG4_PG_DIGEFTEN_8                      ((uint32_t)0x00000100)         /* Bit8*/
#define AFIO_DIGEFT_CFG4_PG_DIGEFTEN_9                      ((uint32_t)0x00000200)         /* Bit9*/
#define AFIO_DIGEFT_CFG4_PG_DIGEFTEN_10                     ((uint32_t)0x00000400)         /* Bit10*/
#define AFIO_DIGEFT_CFG4_PG_DIGEFTEN_11                     ((uint32_t)0x00000800)         /* Bit11*/
#define AFIO_DIGEFT_CFG4_PG_DIGEFTEN_12                     ((uint32_t)0x00001000)         /* Bit12*/
#define AFIO_DIGEFT_CFG4_PG_DIGEFTEN_13                     ((uint32_t)0x00002000)         /* Bit13*/
#define AFIO_DIGEFT_CFG4_PG_DIGEFTEN_14                     ((uint32_t)0x00004000)         /* Bit14*/
#define AFIO_DIGEFT_CFG4_PG_DIGEFTEN_15                     ((uint32_t)0x00008000)         /* Bit15*/

/******** Bit definition for AFIO_DIGEFT_CFG5 register  ********/
#define AFIO_DIGEFT_CFG5_PI_DIGEFTEN                        ((uint32_t)0xFFFF0000)         /* Bit[31:16] */
#define AFIO_DIGEFT_CFG5_PI_DIGEFTEN_0                      ((uint32_t)0x00010000)         /* Bit16*/
#define AFIO_DIGEFT_CFG5_PI_DIGEFTEN_1                      ((uint32_t)0x00020000)         /* Bit17*/
#define AFIO_DIGEFT_CFG5_PI_DIGEFTEN_2                      ((uint32_t)0x00040000)         /* Bit18*/
#define AFIO_DIGEFT_CFG5_PI_DIGEFTEN_3                      ((uint32_t)0x00080000)         /* Bit19*/
#define AFIO_DIGEFT_CFG5_PI_DIGEFTEN_4                      ((uint32_t)0x00100000)         /* Bit20*/
#define AFIO_DIGEFT_CFG5_PI_DIGEFTEN_5                      ((uint32_t)0x00200000)         /* Bit21*/
#define AFIO_DIGEFT_CFG5_PI_DIGEFTEN_6                      ((uint32_t)0x00400000)         /* Bit22*/
#define AFIO_DIGEFT_CFG5_PI_DIGEFTEN_7                      ((uint32_t)0x00800000)         /* Bit23*/
#define AFIO_DIGEFT_CFG5_PI_DIGEFTEN_8                      ((uint32_t)0x01000000)         /* Bit24*/
#define AFIO_DIGEFT_CFG5_PI_DIGEFTEN_9                      ((uint32_t)0x02000000)         /* Bit25*/
#define AFIO_DIGEFT_CFG5_PI_DIGEFTEN_10                     ((uint32_t)0x04000000)         /* Bit26*/
#define AFIO_DIGEFT_CFG5_PI_DIGEFTEN_11                     ((uint32_t)0x08000000)         /* Bit27*/
#define AFIO_DIGEFT_CFG5_PI_DIGEFTEN_12                     ((uint32_t)0x10000000)         /* Bit28*/
#define AFIO_DIGEFT_CFG5_PI_DIGEFTEN_13                     ((uint32_t)0x20000000)         /* Bit29*/
#define AFIO_DIGEFT_CFG5_PI_DIGEFTEN_14                     ((uint32_t)0x40000000)         /* Bit30*/
#define AFIO_DIGEFT_CFG5_PI_DIGEFTEN_15                     ((uint32_t)0x80000000)         /* Bit31*/
#define AFIO_DIGEFT_CFG5_PJ_DIGEFTEN                        ((uint32_t)0x0000FFFF)         /* Bit[15:0] */
#define AFIO_DIGEFT_CFG5_PJ_DIGEFTEN_0                      ((uint32_t)0x00000001)         /* Bit0*/
#define AFIO_DIGEFT_CFG5_PJ_DIGEFTEN_1                      ((uint32_t)0x00000002)         /* Bit1*/
#define AFIO_DIGEFT_CFG5_PJ_DIGEFTEN_2                      ((uint32_t)0x00000004)         /* Bit2*/
#define AFIO_DIGEFT_CFG5_PJ_DIGEFTEN_3                      ((uint32_t)0x00000008)         /* Bit3*/
#define AFIO_DIGEFT_CFG5_PJ_DIGEFTEN_4                      ((uint32_t)0x00000010)         /* Bit4*/
#define AFIO_DIGEFT_CFG5_PJ_DIGEFTEN_5                      ((uint32_t)0x00000020)         /* Bit5*/
#define AFIO_DIGEFT_CFG5_PJ_DIGEFTEN_6                      ((uint32_t)0x00000040)         /* Bit6*/
#define AFIO_DIGEFT_CFG5_PJ_DIGEFTEN_7                      ((uint32_t)0x00000080)         /* Bit7*/
#define AFIO_DIGEFT_CFG5_PJ_DIGEFTEN_8                      ((uint32_t)0x00000100)         /* Bit8*/
#define AFIO_DIGEFT_CFG5_PJ_DIGEFTEN_9                      ((uint32_t)0x00000200)         /* Bit9*/
#define AFIO_DIGEFT_CFG5_PJ_DIGEFTEN_10                     ((uint32_t)0x00000400)         /* Bit10*/
#define AFIO_DIGEFT_CFG5_PJ_DIGEFTEN_11                     ((uint32_t)0x00000800)         /* Bit11*/
#define AFIO_DIGEFT_CFG5_PJ_DIGEFTEN_12                     ((uint32_t)0x00001000)         /* Bit12*/
#define AFIO_DIGEFT_CFG5_PJ_DIGEFTEN_13                     ((uint32_t)0x00002000)         /* Bit13*/
#define AFIO_DIGEFT_CFG5_PJ_DIGEFTEN_14                     ((uint32_t)0x00004000)         /* Bit14*/
#define AFIO_DIGEFT_CFG5_PJ_DIGEFTEN_15                     ((uint32_t)0x00008000)         /* Bit15*/

/******** Bit definition for AFIO_DIGEFT_CFG6 register  ********/
#define AFIO_DIGEFT_CFG6_PK_DIGEFTEN                        ((uint32_t)0x000000FF)         /* Bit[7:0] */
#define AFIO_DIGEFT_CFG6_PK_DIGEFTEN_0                      ((uint32_t)0x00000001)         /* Bit0*/
#define AFIO_DIGEFT_CFG6_PK_DIGEFTEN_1                      ((uint32_t)0x00000002)         /* Bit1*/
#define AFIO_DIGEFT_CFG6_PK_DIGEFTEN_2                      ((uint32_t)0x00000004)         /* Bit2*/
#define AFIO_DIGEFT_CFG6_PK_DIGEFTEN_3                      ((uint32_t)0x00000008)         /* Bit3*/
#define AFIO_DIGEFT_CFG6_PK_DIGEFTEN_4                      ((uint32_t)0x00000010)         /* Bit4*/
#define AFIO_DIGEFT_CFG6_PK_DIGEFTEN_5                      ((uint32_t)0x00000020)         /* Bit5*/
#define AFIO_DIGEFT_CFG6_PK_DIGEFTEN_6                      ((uint32_t)0x00000040)         /* Bit6*/
#define AFIO_DIGEFT_CFG6_PK_DIGEFTEN_7                      ((uint32_t)0x00000080)         /* Bit7*/

/******** Bit definition for AFIO_SHRT1_EXEV_CFG1 register  ********/
#define AFIO_SHRT1_EXEV_CFG1_SHRT_EXEV5                     ((uint32_t)0x01F00000)         /* Bit[24:20] */
#define AFIO_SHRT1_EXEV_CFG1_SHRT_EXEV5_0                   ((uint32_t)0x00100000)         /* Bit20*/
#define AFIO_SHRT1_EXEV_CFG1_SHRT_EXEV5_1                   ((uint32_t)0x00200000)         /* Bit21*/
#define AFIO_SHRT1_EXEV_CFG1_SHRT_EXEV5_2                   ((uint32_t)0x00400000)         /* Bit22*/
#define AFIO_SHRT1_EXEV_CFG1_SHRT_EXEV5_3                   ((uint32_t)0x00800000)         /* Bit23*/
#define AFIO_SHRT1_EXEV_CFG1_SHRT_EXEV5_4                   ((uint32_t)0x01000000)         /* Bit24*/
#define AFIO_SHRT1_EXEV_CFG1_SHRT_EXEV4                     ((uint32_t)0x000F8000)         /* Bit[19:15] */
#define AFIO_SHRT1_EXEV_CFG1_SHRT_EXEV4_0                   ((uint32_t)0x00008000)         /* Bit15*/
#define AFIO_SHRT1_EXEV_CFG1_SHRT_EXEV4_1                   ((uint32_t)0x00010000)         /* Bit16*/
#define AFIO_SHRT1_EXEV_CFG1_SHRT_EXEV4_2                   ((uint32_t)0x00020000)         /* Bit17*/
#define AFIO_SHRT1_EXEV_CFG1_SHRT_EXEV4_3                   ((uint32_t)0x00040000)         /* Bit18*/
#define AFIO_SHRT1_EXEV_CFG1_SHRT_EXEV4_4                   ((uint32_t)0x00080000)         /* Bit19*/
#define AFIO_SHRT1_EXEV_CFG1_SHRT_EXEV3                     ((uint32_t)0x00007C00)         /* Bit[14:10] */
#define AFIO_SHRT1_EXEV_CFG1_SHRT_EXEV3_0                   ((uint32_t)0x00000400)         /* Bit10*/
#define AFIO_SHRT1_EXEV_CFG1_SHRT_EXEV3_1                   ((uint32_t)0x00000800)         /* Bit11*/
#define AFIO_SHRT1_EXEV_CFG1_SHRT_EXEV3_2                   ((uint32_t)0x00001000)         /* Bit12*/
#define AFIO_SHRT1_EXEV_CFG1_SHRT_EXEV3_3                   ((uint32_t)0x00002000)         /* Bit13*/
#define AFIO_SHRT1_EXEV_CFG1_SHRT_EXEV3_4                   ((uint32_t)0x00004000)         /* Bit14*/
#define AFIO_SHRT1_EXEV_CFG1_SHRT_EXEV2                     ((uint32_t)0x000003E0)         /* Bit[9:5] */
#define AFIO_SHRT1_EXEV_CFG1_SHRT_EXEV2_0                   ((uint32_t)0x00000020)         /* Bit5*/
#define AFIO_SHRT1_EXEV_CFG1_SHRT_EXEV2_1                   ((uint32_t)0x00000040)         /* Bit6*/
#define AFIO_SHRT1_EXEV_CFG1_SHRT_EXEV2_2                   ((uint32_t)0x00000080)         /* Bit7*/
#define AFIO_SHRT1_EXEV_CFG1_SHRT_EXEV2_3                   ((uint32_t)0x00000100)         /* Bit8*/
#define AFIO_SHRT1_EXEV_CFG1_SHRT_EXEV2_4                   ((uint32_t)0x00000200)         /* Bit9*/
#define AFIO_SHRT1_EXEV_CFG1_SHRT_EXEV1                     ((uint32_t)0x0000001F)         /* Bit[4:0] */
#define AFIO_SHRT1_EXEV_CFG1_SHRT_EXEV1_0                   ((uint32_t)0x00000001)         /* Bit0*/
#define AFIO_SHRT1_EXEV_CFG1_SHRT_EXEV1_1                   ((uint32_t)0x00000002)         /* Bit1*/
#define AFIO_SHRT1_EXEV_CFG1_SHRT_EXEV1_2                   ((uint32_t)0x00000004)         /* Bit2*/
#define AFIO_SHRT1_EXEV_CFG1_SHRT_EXEV1_3                   ((uint32_t)0x00000008)         /* Bit3*/
#define AFIO_SHRT1_EXEV_CFG1_SHRT_EXEV1_4                   ((uint32_t)0x00000010)         /* Bit4*/

/******** Bit definition for AFIO_SHRT1_EXEV_CFG2 register  ********/
#define AFIO_SHRT1_EXEV_CFG2_SHRT_EXEV10                    ((uint32_t)0x01F00000)         /* Bit[24:20] */
#define AFIO_SHRT1_EXEV_CFG2_SHRT_EXEV10_0                  ((uint32_t)0x00100000)         /* Bit20*/
#define AFIO_SHRT1_EXEV_CFG2_SHRT_EXEV10_1                  ((uint32_t)0x00200000)         /* Bit21*/
#define AFIO_SHRT1_EXEV_CFG2_SHRT_EXEV10_2                  ((uint32_t)0x00400000)         /* Bit22*/
#define AFIO_SHRT1_EXEV_CFG2_SHRT_EXEV10_3                  ((uint32_t)0x00800000)         /* Bit23*/
#define AFIO_SHRT1_EXEV_CFG2_SHRT_EXEV10_4                  ((uint32_t)0x01000000)         /* Bit24*/
#define AFIO_SHRT1_EXEV_CFG2_SHRT_EXEV9                     ((uint32_t)0x000F8000)         /* Bit[19:15] */
#define AFIO_SHRT1_EXEV_CFG2_SHRT_EXEV9_0                   ((uint32_t)0x00008000)         /* Bit15*/
#define AFIO_SHRT1_EXEV_CFG2_SHRT_EXEV9_1                   ((uint32_t)0x00010000)         /* Bit16*/
#define AFIO_SHRT1_EXEV_CFG2_SHRT_EXEV9_2                   ((uint32_t)0x00020000)         /* Bit17*/
#define AFIO_SHRT1_EXEV_CFG2_SHRT_EXEV9_3                   ((uint32_t)0x00040000)         /* Bit18*/
#define AFIO_SHRT1_EXEV_CFG2_SHRT_EXEV9_4                   ((uint32_t)0x00080000)         /* Bit19*/
#define AFIO_SHRT1_EXEV_CFG2_SHRT_EXEV8                     ((uint32_t)0x00007C00)         /* Bit[14:10] */
#define AFIO_SHRT1_EXEV_CFG2_SHRT_EXEV8_0                   ((uint32_t)0x00000400)         /* Bit10*/
#define AFIO_SHRT1_EXEV_CFG2_SHRT_EXEV8_1                   ((uint32_t)0x00000800)         /* Bit11*/
#define AFIO_SHRT1_EXEV_CFG2_SHRT_EXEV8_2                   ((uint32_t)0x00001000)         /* Bit12*/
#define AFIO_SHRT1_EXEV_CFG2_SHRT_EXEV8_3                   ((uint32_t)0x00002000)         /* Bit13*/
#define AFIO_SHRT1_EXEV_CFG2_SHRT_EXEV8_4                   ((uint32_t)0x00004000)         /* Bit14*/
#define AFIO_SHRT1_EXEV_CFG2_SHRT_EXEV7                     ((uint32_t)0x000003E0)         /* Bit[9:5] */
#define AFIO_SHRT1_EXEV_CFG2_SHRT_EXEV7_0                   ((uint32_t)0x00000020)         /* Bit5*/
#define AFIO_SHRT1_EXEV_CFG2_SHRT_EXEV7_1                   ((uint32_t)0x00000040)         /* Bit6*/
#define AFIO_SHRT1_EXEV_CFG2_SHRT_EXEV7_2                   ((uint32_t)0x00000080)         /* Bit7*/
#define AFIO_SHRT1_EXEV_CFG2_SHRT_EXEV7_3                   ((uint32_t)0x00000100)         /* Bit8*/
#define AFIO_SHRT1_EXEV_CFG2_SHRT_EXEV7_4                   ((uint32_t)0x00000200)         /* Bit9*/
#define AFIO_SHRT1_EXEV_CFG2_SHRT_EXEV6                     ((uint32_t)0x0000001F)         /* Bit[4:0] */
#define AFIO_SHRT1_EXEV_CFG2_SHRT_EXEV6_0                   ((uint32_t)0x00000001)         /* Bit0*/
#define AFIO_SHRT1_EXEV_CFG2_SHRT_EXEV6_1                   ((uint32_t)0x00000002)         /* Bit1*/
#define AFIO_SHRT1_EXEV_CFG2_SHRT_EXEV6_2                   ((uint32_t)0x00000004)         /* Bit2*/
#define AFIO_SHRT1_EXEV_CFG2_SHRT_EXEV6_3                   ((uint32_t)0x00000008)         /* Bit3*/
#define AFIO_SHRT1_EXEV_CFG2_SHRT_EXEV6_4                   ((uint32_t)0x00000010)         /* Bit4*/

/******** Bit definition for AFIO_SHRT2_EXEV_CFG1 register  ********/
#define AFIO_SHRT2_EXEV_CFG1_SHRT_EXEV5                     ((uint32_t)0x01F00000)         /* Bit[24:20] */
#define AFIO_SHRT2_EXEV_CFG1_SHRT_EXEV5_0                   ((uint32_t)0x00100000)         /* Bit20*/
#define AFIO_SHRT2_EXEV_CFG1_SHRT_EXEV5_1                   ((uint32_t)0x00200000)         /* Bit21*/
#define AFIO_SHRT2_EXEV_CFG1_SHRT_EXEV5_2                   ((uint32_t)0x00400000)         /* Bit22*/
#define AFIO_SHRT2_EXEV_CFG1_SHRT_EXEV5_3                   ((uint32_t)0x00800000)         /* Bit23*/
#define AFIO_SHRT2_EXEV_CFG1_SHRT_EXEV5_4                   ((uint32_t)0x01000000)         /* Bit24*/
#define AFIO_SHRT2_EXEV_CFG1_SHRT_EXEV4                     ((uint32_t)0x000F8000)         /* Bit[19:15] */
#define AFIO_SHRT2_EXEV_CFG1_SHRT_EXEV4_0                   ((uint32_t)0x00008000)         /* Bit15*/
#define AFIO_SHRT2_EXEV_CFG1_SHRT_EXEV4_1                   ((uint32_t)0x00010000)         /* Bit16*/
#define AFIO_SHRT2_EXEV_CFG1_SHRT_EXEV4_2                   ((uint32_t)0x00020000)         /* Bit17*/
#define AFIO_SHRT2_EXEV_CFG1_SHRT_EXEV4_3                   ((uint32_t)0x00040000)         /* Bit18*/
#define AFIO_SHRT2_EXEV_CFG1_SHRT_EXEV4_4                   ((uint32_t)0x00080000)         /* Bit19*/
#define AFIO_SHRT2_EXEV_CFG1_SHRT_EXEV3                     ((uint32_t)0x00007C00)         /* Bit[14:10] */
#define AFIO_SHRT2_EXEV_CFG1_SHRT_EXEV3_0                   ((uint32_t)0x00000400)         /* Bit10*/
#define AFIO_SHRT2_EXEV_CFG1_SHRT_EXEV3_1                   ((uint32_t)0x00000800)         /* Bit11*/
#define AFIO_SHRT2_EXEV_CFG1_SHRT_EXEV3_2                   ((uint32_t)0x00001000)         /* Bit12*/
#define AFIO_SHRT2_EXEV_CFG1_SHRT_EXEV3_3                   ((uint32_t)0x00002000)         /* Bit13*/
#define AFIO_SHRT2_EXEV_CFG1_SHRT_EXEV3_4                   ((uint32_t)0x00004000)         /* Bit14*/
#define AFIO_SHRT2_EXEV_CFG1_SHRT_EXEV2                     ((uint32_t)0x000003E0)         /* Bit[9:5] */
#define AFIO_SHRT2_EXEV_CFG1_SHRT_EXEV2_0                   ((uint32_t)0x00000020)         /* Bit5*/
#define AFIO_SHRT2_EXEV_CFG1_SHRT_EXEV2_1                   ((uint32_t)0x00000040)         /* Bit6*/
#define AFIO_SHRT2_EXEV_CFG1_SHRT_EXEV2_2                   ((uint32_t)0x00000080)         /* Bit7*/
#define AFIO_SHRT2_EXEV_CFG1_SHRT_EXEV2_3                   ((uint32_t)0x00000100)         /* Bit8*/
#define AFIO_SHRT2_EXEV_CFG1_SHRT_EXEV2_4                   ((uint32_t)0x00000200)         /* Bit9*/
#define AFIO_SHRT2_EXEV_CFG1_SHRT_EXEV1                     ((uint32_t)0x0000001F)         /* Bit[4:0] */
#define AFIO_SHRT2_EXEV_CFG1_SHRT_EXEV1_0                   ((uint32_t)0x00000001)         /* Bit0*/
#define AFIO_SHRT2_EXEV_CFG1_SHRT_EXEV1_1                   ((uint32_t)0x00000002)         /* Bit1*/
#define AFIO_SHRT2_EXEV_CFG1_SHRT_EXEV1_2                   ((uint32_t)0x00000004)         /* Bit2*/
#define AFIO_SHRT2_EXEV_CFG1_SHRT_EXEV1_3                   ((uint32_t)0x00000008)         /* Bit3*/
#define AFIO_SHRT2_EXEV_CFG1_SHRT_EXEV1_4                   ((uint32_t)0x00000010)         /* Bit4*/

/******** Bit definition for AFIO_SHRT2_EXEV_CFG2 register  ********/
#define AFIO_SHRT2_EXEV_CFG2_SHRT_EXEV10                    ((uint32_t)0x01F00000)         /* Bit[24:20] */
#define AFIO_SHRT2_EXEV_CFG2_SHRT_EXEV10_0                  ((uint32_t)0x00100000)         /* Bit20*/
#define AFIO_SHRT2_EXEV_CFG2_SHRT_EXEV10_1                  ((uint32_t)0x00200000)         /* Bit21*/
#define AFIO_SHRT2_EXEV_CFG2_SHRT_EXEV10_2                  ((uint32_t)0x00400000)         /* Bit22*/
#define AFIO_SHRT2_EXEV_CFG2_SHRT_EXEV10_3                  ((uint32_t)0x00800000)         /* Bit23*/
#define AFIO_SHRT2_EXEV_CFG2_SHRT_EXEV10_4                  ((uint32_t)0x01000000)         /* Bit24*/
#define AFIO_SHRT2_EXEV_CFG2_SHRT_EXEV9                     ((uint32_t)0x000F8000)         /* Bit[19:15] */
#define AFIO_SHRT2_EXEV_CFG2_SHRT_EXEV9_0                   ((uint32_t)0x00008000)         /* Bit15*/
#define AFIO_SHRT2_EXEV_CFG2_SHRT_EXEV9_1                   ((uint32_t)0x00010000)         /* Bit16*/
#define AFIO_SHRT2_EXEV_CFG2_SHRT_EXEV9_2                   ((uint32_t)0x00020000)         /* Bit17*/
#define AFIO_SHRT2_EXEV_CFG2_SHRT_EXEV9_3                   ((uint32_t)0x00040000)         /* Bit18*/
#define AFIO_SHRT2_EXEV_CFG2_SHRT_EXEV9_4                   ((uint32_t)0x00080000)         /* Bit19*/
#define AFIO_SHRT2_EXEV_CFG2_SHRT_EXEV8                     ((uint32_t)0x00007C00)         /* Bit[14:10] */
#define AFIO_SHRT2_EXEV_CFG2_SHRT_EXEV8_0                   ((uint32_t)0x00000400)         /* Bit10*/
#define AFIO_SHRT2_EXEV_CFG2_SHRT_EXEV8_1                   ((uint32_t)0x00000800)         /* Bit11*/
#define AFIO_SHRT2_EXEV_CFG2_SHRT_EXEV8_2                   ((uint32_t)0x00001000)         /* Bit12*/
#define AFIO_SHRT2_EXEV_CFG2_SHRT_EXEV8_3                   ((uint32_t)0x00002000)         /* Bit13*/
#define AFIO_SHRT2_EXEV_CFG2_SHRT_EXEV8_4                   ((uint32_t)0x00004000)         /* Bit14*/
#define AFIO_SHRT2_EXEV_CFG2_SHRT_EXEV7                     ((uint32_t)0x000003E0)         /* Bit[9:5] */
#define AFIO_SHRT2_EXEV_CFG2_SHRT_EXEV7_0                   ((uint32_t)0x00000020)         /* Bit5*/
#define AFIO_SHRT2_EXEV_CFG2_SHRT_EXEV7_1                   ((uint32_t)0x00000040)         /* Bit6*/
#define AFIO_SHRT2_EXEV_CFG2_SHRT_EXEV7_2                   ((uint32_t)0x00000080)         /* Bit7*/
#define AFIO_SHRT2_EXEV_CFG2_SHRT_EXEV7_3                   ((uint32_t)0x00000100)         /* Bit8*/
#define AFIO_SHRT2_EXEV_CFG2_SHRT_EXEV7_4                   ((uint32_t)0x00000200)         /* Bit9*/
#define AFIO_SHRT2_EXEV_CFG2_SHRT_EXEV6                     ((uint32_t)0x0000001F)         /* Bit[4:0] */
#define AFIO_SHRT2_EXEV_CFG2_SHRT_EXEV6_0                   ((uint32_t)0x00000001)         /* Bit0*/
#define AFIO_SHRT2_EXEV_CFG2_SHRT_EXEV6_1                   ((uint32_t)0x00000002)         /* Bit1*/
#define AFIO_SHRT2_EXEV_CFG2_SHRT_EXEV6_2                   ((uint32_t)0x00000004)         /* Bit2*/
#define AFIO_SHRT2_EXEV_CFG2_SHRT_EXEV6_3                   ((uint32_t)0x00000008)         /* Bit3*/
#define AFIO_SHRT2_EXEV_CFG2_SHRT_EXEV6_4                   ((uint32_t)0x00000010)         /* Bit4*/

/******** Bit definition for AFIO_SIP_PUPD register  ********/
#define AFIO_SIP_PUPD_PUPD7                                 ((uint32_t)0x0000C000)         /* Bit[15:14] */
#define AFIO_SIP_PUPD_PUPD7_0                               ((uint32_t)0x00004000)         /* Bit14*/
#define AFIO_SIP_PUPD_PUPD7_1                               ((uint32_t)0x00008000)         /* Bit15*/
#define AFIO_SIP_PUPD_PUPD6                                 ((uint32_t)0x00003000)         /* Bit[13:12] */
#define AFIO_SIP_PUPD_PUPD6_0                               ((uint32_t)0x00001000)         /* Bit12*/
#define AFIO_SIP_PUPD_PUPD6_1                               ((uint32_t)0x00002000)         /* Bit13*/
#define AFIO_SIP_PUPD_PUPD5                                 ((uint32_t)0x00000C00)         /* Bit[11:10] */
#define AFIO_SIP_PUPD_PUPD5_0                               ((uint32_t)0x00000400)         /* Bit10*/
#define AFIO_SIP_PUPD_PUPD5_1                               ((uint32_t)0x00000800)         /* Bit11*/
#define AFIO_SIP_PUPD_PUPD4                                 ((uint32_t)0x00000300)         /* Bit[9:8] */
#define AFIO_SIP_PUPD_PUPD4_0                               ((uint32_t)0x00000100)         /* Bit8*/
#define AFIO_SIP_PUPD_PUPD4_1                               ((uint32_t)0x00000200)         /* Bit9*/
#define AFIO_SIP_PUPD_PUPD3                                 ((uint32_t)0x000000C0)         /* Bit[7:6] */
#define AFIO_SIP_PUPD_PUPD3_0                               ((uint32_t)0x00000040)         /* Bit6*/
#define AFIO_SIP_PUPD_PUPD3_1                               ((uint32_t)0x00000080)         /* Bit7*/
#define AFIO_SIP_PUPD_PUPD2                                 ((uint32_t)0x00000030)         /* Bit[5:4] */
#define AFIO_SIP_PUPD_PUPD2_0                               ((uint32_t)0x00000010)         /* Bit4*/
#define AFIO_SIP_PUPD_PUPD2_1                               ((uint32_t)0x00000020)         /* Bit5*/
#define AFIO_SIP_PUPD_PUPD1                                 ((uint32_t)0x0000000C)         /* Bit[3:2] */
#define AFIO_SIP_PUPD_PUPD1_0                               ((uint32_t)0x00000004)         /* Bit2*/
#define AFIO_SIP_PUPD_PUPD1_1                               ((uint32_t)0x00000008)         /* Bit3*/
#define AFIO_SIP_PUPD_PUPD0                                 ((uint32_t)0x00000003)         /* Bit[1:0] */
#define AFIO_SIP_PUPD_PUPD0_0                               ((uint32_t)0x00000001)         /* Bit0*/
#define AFIO_SIP_PUPD_PUPD0_1                               ((uint32_t)0x00000002)         /* Bit1*/

/******** Bit definition for AFIO_SDRAM_HSMOD_CFG1 register  ********/
#define AFIO_SDRAM_HSMOD_CFG1_HSA                           ((uint32_t)0xFFFF0000)         /* Bit[31:16] */
#define AFIO_SDRAM_HSMOD_CFG1_HSA_0                         ((uint32_t)0x00010000)         /* Bit16*/
#define AFIO_SDRAM_HSMOD_CFG1_HSA_1                         ((uint32_t)0x00020000)         /* Bit17*/
#define AFIO_SDRAM_HSMOD_CFG1_HSA_2                         ((uint32_t)0x00040000)         /* Bit18*/
#define AFIO_SDRAM_HSMOD_CFG1_HSA_3                         ((uint32_t)0x00080000)         /* Bit19*/
#define AFIO_SDRAM_HSMOD_CFG1_HSA_4                         ((uint32_t)0x00100000)         /* Bit20*/
#define AFIO_SDRAM_HSMOD_CFG1_HSA_5                         ((uint32_t)0x00200000)         /* Bit21*/
#define AFIO_SDRAM_HSMOD_CFG1_HSA_6                         ((uint32_t)0x00400000)         /* Bit22*/
#define AFIO_SDRAM_HSMOD_CFG1_HSA_7                         ((uint32_t)0x00800000)         /* Bit23*/
#define AFIO_SDRAM_HSMOD_CFG1_HSA_8                         ((uint32_t)0x01000000)         /* Bit24*/
#define AFIO_SDRAM_HSMOD_CFG1_HSA_9                         ((uint32_t)0x02000000)         /* Bit25*/
#define AFIO_SDRAM_HSMOD_CFG1_HSA_10                        ((uint32_t)0x04000000)         /* Bit26*/
#define AFIO_SDRAM_HSMOD_CFG1_HSA_11                        ((uint32_t)0x08000000)         /* Bit27*/
#define AFIO_SDRAM_HSMOD_CFG1_HSA_12                        ((uint32_t)0x10000000)         /* Bit28*/
#define AFIO_SDRAM_HSMOD_CFG1_HSA_13                        ((uint32_t)0x20000000)         /* Bit29*/
#define AFIO_SDRAM_HSMOD_CFG1_HSA_14                        ((uint32_t)0x40000000)         /* Bit30*/
#define AFIO_SDRAM_HSMOD_CFG1_HSA_15                        ((uint32_t)0x80000000)         /* Bit31*/
#define AFIO_SDRAM_HSMOD_CFG1_HSB                           ((uint32_t)0x0000FFFF)         /* Bit[15:0] */
#define AFIO_SDRAM_HSMOD_CFG1_HSB_0                         ((uint32_t)0x00000001)         /* Bit0*/
#define AFIO_SDRAM_HSMOD_CFG1_HSB_1                         ((uint32_t)0x00000002)         /* Bit1*/
#define AFIO_SDRAM_HSMOD_CFG1_HSB_2                         ((uint32_t)0x00000004)         /* Bit2*/
#define AFIO_SDRAM_HSMOD_CFG1_HSB_3                         ((uint32_t)0x00000008)         /* Bit3*/
#define AFIO_SDRAM_HSMOD_CFG1_HSB_4                         ((uint32_t)0x00000010)         /* Bit4*/
#define AFIO_SDRAM_HSMOD_CFG1_HSB_5                         ((uint32_t)0x00000020)         /* Bit5*/
#define AFIO_SDRAM_HSMOD_CFG1_HSB_6                         ((uint32_t)0x00000040)         /* Bit6*/
#define AFIO_SDRAM_HSMOD_CFG1_HSB_7                         ((uint32_t)0x00000080)         /* Bit7*/
#define AFIO_SDRAM_HSMOD_CFG1_HSB_8                         ((uint32_t)0x00000100)         /* Bit8*/
#define AFIO_SDRAM_HSMOD_CFG1_HSB_9                         ((uint32_t)0x00000200)         /* Bit9*/
#define AFIO_SDRAM_HSMOD_CFG1_HSB_10                        ((uint32_t)0x00000400)         /* Bit10*/
#define AFIO_SDRAM_HSMOD_CFG1_HSB_11                        ((uint32_t)0x00000800)         /* Bit11*/
#define AFIO_SDRAM_HSMOD_CFG1_HSB_12                        ((uint32_t)0x00001000)         /* Bit12*/
#define AFIO_SDRAM_HSMOD_CFG1_HSB_13                        ((uint32_t)0x00002000)         /* Bit13*/
#define AFIO_SDRAM_HSMOD_CFG1_HSB_14                        ((uint32_t)0x00004000)         /* Bit14*/
#define AFIO_SDRAM_HSMOD_CFG1_HSB_15                        ((uint32_t)0x00008000)         /* Bit15*/

/******** Bit definition for AFIO_SDRAM_HSMOD_CFG2 register  ********/
#define AFIO_SDRAM_HSMOD_CFG2_HSC                               ((uint32_t)0xFFFF0000)         /* Bit[31:16] */
#define AFIO_SDRAM_HSMOD_CFG2_HSC_0                             ((uint32_t)0x00010000)         /* Bit16*/
#define AFIO_SDRAM_HSMOD_CFG2_HSC_1                             ((uint32_t)0x00020000)         /* Bit17*/
#define AFIO_SDRAM_HSMOD_CFG2_HSC_2                             ((uint32_t)0x00040000)         /* Bit18*/
#define AFIO_SDRAM_HSMOD_CFG2_HSC_3                             ((uint32_t)0x00080000)         /* Bit19*/
#define AFIO_SDRAM_HSMOD_CFG2_HSC_4                             ((uint32_t)0x00100000)         /* Bit20*/
#define AFIO_SDRAM_HSMOD_CFG2_HSC_5                             ((uint32_t)0x00200000)         /* Bit21*/
#define AFIO_SDRAM_HSMOD_CFG2_HSC_6                             ((uint32_t)0x00400000)         /* Bit22*/
#define AFIO_SDRAM_HSMOD_CFG2_HSC_7                             ((uint32_t)0x00800000)         /* Bit23*/
#define AFIO_SDRAM_HSMOD_CFG2_HSC_8                             ((uint32_t)0x01000000)         /* Bit24*/
#define AFIO_SDRAM_HSMOD_CFG2_HSC_9                             ((uint32_t)0x02000000)         /* Bit25*/
#define AFIO_SDRAM_HSMOD_CFG2_HSC_10                            ((uint32_t)0x04000000)         /* Bit26*/
#define AFIO_SDRAM_HSMOD_CFG2_HSC_11                            ((uint32_t)0x08000000)         /* Bit27*/
#define AFIO_SDRAM_HSMOD_CFG2_HSC_12                            ((uint32_t)0x10000000)         /* Bit28*/
#define AFIO_SDRAM_HSMOD_CFG2_HSC_13                            ((uint32_t)0x20000000)         /* Bit29*/
#define AFIO_SDRAM_HSMOD_CFG2_HSC_14                            ((uint32_t)0x40000000)         /* Bit30*/
#define AFIO_SDRAM_HSMOD_CFG2_HSC_15                            ((uint32_t)0x80000000)         /* Bit31*/
#define AFIO_SDRAM_HSMOD_CFG2_HSD                               ((uint32_t)0x0000FFFF)         /* Bit[15:0] */
#define AFIO_SDRAM_HSMOD_CFG2_HSD_0                             ((uint32_t)0x00000001)         /* Bit0*/
#define AFIO_SDRAM_HSMOD_CFG2_HSD_1                             ((uint32_t)0x00000002)         /* Bit1*/
#define AFIO_SDRAM_HSMOD_CFG2_HSD_2                             ((uint32_t)0x00000004)         /* Bit2*/
#define AFIO_SDRAM_HSMOD_CFG2_HSD_3                             ((uint32_t)0x00000008)         /* Bit3*/
#define AFIO_SDRAM_HSMOD_CFG2_HSD_4                             ((uint32_t)0x00000010)         /* Bit4*/
#define AFIO_SDRAM_HSMOD_CFG2_HSD_5                             ((uint32_t)0x00000020)         /* Bit5*/
#define AFIO_SDRAM_HSMOD_CFG2_HSD_6                             ((uint32_t)0x00000040)         /* Bit6*/
#define AFIO_SDRAM_HSMOD_CFG2_HSD_7                             ((uint32_t)0x00000080)         /* Bit7*/
#define AFIO_SDRAM_HSMOD_CFG2_HSD_8                             ((uint32_t)0x00000100)         /* Bit8*/
#define AFIO_SDRAM_HSMOD_CFG2_HSD_9                             ((uint32_t)0x00000200)         /* Bit9*/
#define AFIO_SDRAM_HSMOD_CFG2_HSD_10                            ((uint32_t)0x00000400)         /* Bit10*/
#define AFIO_SDRAM_HSMOD_CFG2_HSD_11                            ((uint32_t)0x00000800)         /* Bit11*/
#define AFIO_SDRAM_HSMOD_CFG2_HSD_12                            ((uint32_t)0x00001000)         /* Bit12*/
#define AFIO_SDRAM_HSMOD_CFG2_HSD_13                            ((uint32_t)0x00002000)         /* Bit13*/
#define AFIO_SDRAM_HSMOD_CFG2_HSD_14                            ((uint32_t)0x00004000)         /* Bit14*/
#define AFIO_SDRAM_HSMOD_CFG2_HSD_15                            ((uint32_t)0x00008000)         /* Bit15*/

/******** Bit definition for AFIO_SDRAM_HSMOD_CFG3 register  ********/
#define AFIO_SDRAM_HSMOD_CFG3_HSE                               ((uint32_t)0xFFFF0000)         /* Bit[31:16] */
#define AFIO_SDRAM_HSMOD_CFG3_HSE_0                             ((uint32_t)0x00010000)         /* Bit16*/
#define AFIO_SDRAM_HSMOD_CFG3_HSE_1                             ((uint32_t)0x00020000)         /* Bit17*/
#define AFIO_SDRAM_HSMOD_CFG3_HSE_2                             ((uint32_t)0x00040000)         /* Bit18*/
#define AFIO_SDRAM_HSMOD_CFG3_HSE_3                             ((uint32_t)0x00080000)         /* Bit19*/
#define AFIO_SDRAM_HSMOD_CFG3_HSE_4                             ((uint32_t)0x00100000)         /* Bit20*/
#define AFIO_SDRAM_HSMOD_CFG3_HSE_5                             ((uint32_t)0x00200000)         /* Bit21*/
#define AFIO_SDRAM_HSMOD_CFG3_HSE_6                             ((uint32_t)0x00400000)         /* Bit22*/
#define AFIO_SDRAM_HSMOD_CFG3_HSE_7                             ((uint32_t)0x00800000)         /* Bit23*/
#define AFIO_SDRAM_HSMOD_CFG3_HSE_8                             ((uint32_t)0x01000000)         /* Bit24*/
#define AFIO_SDRAM_HSMOD_CFG3_HSE_9                             ((uint32_t)0x02000000)         /* Bit25*/
#define AFIO_SDRAM_HSMOD_CFG3_HSE_10                            ((uint32_t)0x04000000)         /* Bit26*/
#define AFIO_SDRAM_HSMOD_CFG3_HSE_11                            ((uint32_t)0x08000000)         /* Bit27*/
#define AFIO_SDRAM_HSMOD_CFG3_HSE_12                            ((uint32_t)0x10000000)         /* Bit28*/
#define AFIO_SDRAM_HSMOD_CFG3_HSE_13                            ((uint32_t)0x20000000)         /* Bit29*/
#define AFIO_SDRAM_HSMOD_CFG3_HSE_14                            ((uint32_t)0x40000000)         /* Bit30*/
#define AFIO_SDRAM_HSMOD_CFG3_HSE_15                            ((uint32_t)0x80000000)         /* Bit31*/
#define AFIO_SDRAM_HSMOD_CFG3_HSF                               ((uint32_t)0x0000FFFF)         /* Bit[15:0] */
#define AFIO_SDRAM_HSMOD_CFG3_HSF_0                             ((uint32_t)0x00000001)         /* Bit0*/
#define AFIO_SDRAM_HSMOD_CFG3_HSF_1                             ((uint32_t)0x00000002)         /* Bit1*/
#define AFIO_SDRAM_HSMOD_CFG3_HSF_2                             ((uint32_t)0x00000004)         /* Bit2*/
#define AFIO_SDRAM_HSMOD_CFG3_HSF_3                             ((uint32_t)0x00000008)         /* Bit3*/
#define AFIO_SDRAM_HSMOD_CFG3_HSF_4                             ((uint32_t)0x00000010)         /* Bit4*/
#define AFIO_SDRAM_HSMOD_CFG3_HSF_5                             ((uint32_t)0x00000020)         /* Bit5*/
#define AFIO_SDRAM_HSMOD_CFG3_HSF_6                             ((uint32_t)0x00000040)         /* Bit6*/
#define AFIO_SDRAM_HSMOD_CFG3_HSF_7                             ((uint32_t)0x00000080)         /* Bit7*/
#define AFIO_SDRAM_HSMOD_CFG3_HSF_8                             ((uint32_t)0x00000100)         /* Bit8*/
#define AFIO_SDRAM_HSMOD_CFG3_HSF_9                             ((uint32_t)0x00000200)         /* Bit9*/
#define AFIO_SDRAM_HSMOD_CFG3_HSF_10                            ((uint32_t)0x00000400)         /* Bit10*/
#define AFIO_SDRAM_HSMOD_CFG3_HSF_11                            ((uint32_t)0x00000800)         /* Bit11*/
#define AFIO_SDRAM_HSMOD_CFG3_HSF_12                            ((uint32_t)0x00001000)         /* Bit12*/
#define AFIO_SDRAM_HSMOD_CFG3_HSF_13                            ((uint32_t)0x00002000)         /* Bit13*/
#define AFIO_SDRAM_HSMOD_CFG3_HSF_14                            ((uint32_t)0x00004000)         /* Bit14*/
#define AFIO_SDRAM_HSMOD_CFG3_HSF_15                            ((uint32_t)0x00008000)         /* Bit15*/

/******** Bit definition for AFIO_SDRAM_HSMOD_CFG4 register  ********/
#define AFIO_SDRAM_HSMOD_CFG4_HSG                               ((uint32_t)0xFFFF0000)         /* Bit[31:16] */
#define AFIO_SDRAM_HSMOD_CFG4_HSG_0                             ((uint32_t)0x00010000)         /* Bit16*/
#define AFIO_SDRAM_HSMOD_CFG4_HSG_1                             ((uint32_t)0x00020000)         /* Bit17*/
#define AFIO_SDRAM_HSMOD_CFG4_HSG_2                             ((uint32_t)0x00040000)         /* Bit18*/
#define AFIO_SDRAM_HSMOD_CFG4_HSG_3                             ((uint32_t)0x00080000)         /* Bit19*/
#define AFIO_SDRAM_HSMOD_CFG4_HSG_4                             ((uint32_t)0x00100000)         /* Bit20*/
#define AFIO_SDRAM_HSMOD_CFG4_HSG_5                             ((uint32_t)0x00200000)         /* Bit21*/
#define AFIO_SDRAM_HSMOD_CFG4_HSG_6                             ((uint32_t)0x00400000)         /* Bit22*/
#define AFIO_SDRAM_HSMOD_CFG4_HSG_7                             ((uint32_t)0x00800000)         /* Bit23*/
#define AFIO_SDRAM_HSMOD_CFG4_HSG_8                             ((uint32_t)0x01000000)         /* Bit24*/
#define AFIO_SDRAM_HSMOD_CFG4_HSG_9                             ((uint32_t)0x02000000)         /* Bit25*/
#define AFIO_SDRAM_HSMOD_CFG4_HSG_10                            ((uint32_t)0x04000000)         /* Bit26*/
#define AFIO_SDRAM_HSMOD_CFG4_HSG_11                            ((uint32_t)0x08000000)         /* Bit27*/
#define AFIO_SDRAM_HSMOD_CFG4_HSG_12                            ((uint32_t)0x10000000)         /* Bit28*/
#define AFIO_SDRAM_HSMOD_CFG4_HSG_13                            ((uint32_t)0x20000000)         /* Bit29*/
#define AFIO_SDRAM_HSMOD_CFG4_HSG_14                            ((uint32_t)0x40000000)         /* Bit30*/
#define AFIO_SDRAM_HSMOD_CFG4_HSG_15                            ((uint32_t)0x80000000)         /* Bit31*/
#define AFIO_SDRAM_HSMOD_CFG4_HSH                               ((uint32_t)0x0000FFFF)         /* Bit[15:0] */
#define AFIO_SDRAM_HSMOD_CFG4_HSH_0                             ((uint32_t)0x00000001)         /* Bit0*/
#define AFIO_SDRAM_HSMOD_CFG4_HSH_1                             ((uint32_t)0x00000002)         /* Bit1*/
#define AFIO_SDRAM_HSMOD_CFG4_HSH_2                             ((uint32_t)0x00000004)         /* Bit2*/
#define AFIO_SDRAM_HSMOD_CFG4_HSH_3                             ((uint32_t)0x00000008)         /* Bit3*/
#define AFIO_SDRAM_HSMOD_CFG4_HSH_4                             ((uint32_t)0x00000010)         /* Bit4*/
#define AFIO_SDRAM_HSMOD_CFG4_HSH_5                             ((uint32_t)0x00000020)         /* Bit5*/
#define AFIO_SDRAM_HSMOD_CFG4_HSH_6                             ((uint32_t)0x00000040)         /* Bit6*/
#define AFIO_SDRAM_HSMOD_CFG4_HSH_7                             ((uint32_t)0x00000080)         /* Bit7*/
#define AFIO_SDRAM_HSMOD_CFG4_HSH_8                             ((uint32_t)0x00000100)         /* Bit8*/
#define AFIO_SDRAM_HSMOD_CFG4_HSH_9                             ((uint32_t)0x00000200)         /* Bit9*/
#define AFIO_SDRAM_HSMOD_CFG4_HSH_10                            ((uint32_t)0x00000400)         /* Bit10*/
#define AFIO_SDRAM_HSMOD_CFG4_HSH_11                            ((uint32_t)0x00000800)         /* Bit11*/
#define AFIO_SDRAM_HSMOD_CFG4_HSH_12                            ((uint32_t)0x00001000)         /* Bit12*/
#define AFIO_SDRAM_HSMOD_CFG4_HSH_13                            ((uint32_t)0x00002000)         /* Bit13*/
#define AFIO_SDRAM_HSMOD_CFG4_HSH_14                            ((uint32_t)0x00004000)         /* Bit14*/
#define AFIO_SDRAM_HSMOD_CFG4_HSH_15                            ((uint32_t)0x00008000)         /* Bit15*/

/******** Bit definition for AFIO_SDRAM_HSMOD_CFG5 register  ********/
#define AFIO_SDRAM_HSMOD_CFG5_HSI                               ((uint32_t)0xFFFF0000)         /* Bit[31:16] */
#define AFIO_SDRAM_HSMOD_CFG5_HSI_0                             ((uint32_t)0x00010000)         /* Bit16*/
#define AFIO_SDRAM_HSMOD_CFG5_HSI_1                             ((uint32_t)0x00020000)         /* Bit17*/
#define AFIO_SDRAM_HSMOD_CFG5_HSI_2                             ((uint32_t)0x00040000)         /* Bit18*/
#define AFIO_SDRAM_HSMOD_CFG5_HSI_3                             ((uint32_t)0x00080000)         /* Bit19*/
#define AFIO_SDRAM_HSMOD_CFG5_HSI_4                             ((uint32_t)0x00100000)         /* Bit20*/
#define AFIO_SDRAM_HSMOD_CFG5_HSI_5                             ((uint32_t)0x00200000)         /* Bit21*/
#define AFIO_SDRAM_HSMOD_CFG5_HSI_6                             ((uint32_t)0x00400000)         /* Bit22*/
#define AFIO_SDRAM_HSMOD_CFG5_HSI_7                             ((uint32_t)0x00800000)         /* Bit23*/
#define AFIO_SDRAM_HSMOD_CFG5_HSI_8                             ((uint32_t)0x01000000)         /* Bit24*/
#define AFIO_SDRAM_HSMOD_CFG5_HSI_9                             ((uint32_t)0x02000000)         /* Bit25*/
#define AFIO_SDRAM_HSMOD_CFG5_HSI_10                            ((uint32_t)0x04000000)         /* Bit26*/
#define AFIO_SDRAM_HSMOD_CFG5_HSI_11                            ((uint32_t)0x08000000)         /* Bit27*/
#define AFIO_SDRAM_HSMOD_CFG5_HSI_12                            ((uint32_t)0x10000000)         /* Bit28*/
#define AFIO_SDRAM_HSMOD_CFG5_HSI_13                            ((uint32_t)0x20000000)         /* Bit29*/
#define AFIO_SDRAM_HSMOD_CFG5_HSI_14                            ((uint32_t)0x40000000)         /* Bit30*/
#define AFIO_SDRAM_HSMOD_CFG5_HSI_15                            ((uint32_t)0x80000000)         /* Bit31*/

/******** Bit definition for AFIO_SIP_SR register  ********/
#define AFIO_SIP_SR_SR7                                         ((uint32_t)0x00000080)         /* Bit[7] */
#define AFIO_SIP_SR_SR6                                         ((uint32_t)0x00000040)         /* Bit[6] */
#define AFIO_SIP_SR_SR5                                         ((uint32_t)0x00000020)         /* Bit[5] */
#define AFIO_SIP_SR_SR4                                         ((uint32_t)0x00000010)         /* Bit[4] */
#define AFIO_SIP_SR_SR3                                         ((uint32_t)0x00000008)         /* Bit[3] */
#define AFIO_SIP_SR_SR2                                         ((uint32_t)0x00000004)         /* Bit[2] */
#define AFIO_SIP_SR_SR1                                         ((uint32_t)0x00000002)         /* Bit[1] */
#define AFIO_SIP_SR_SR0                                         ((uint32_t)0x00000001)         /* Bit[0] */

/******** Bit definition for AFIO_SIPDS_CFG register  ********/
#define AFIO_SIP_DS_DS7                                         ((uint32_t)0x0000C000)         /* Bit[15:14] */
#define AFIO_SIP_DS_DS7_0                                       ((uint32_t)0x00004000)         /* Bit14*/
#define AFIO_SIP_DS_DS7_1                                       ((uint32_t)0x00008000)         /* Bit15*/
#define AFIO_SIP_DS_DS6                                         ((uint32_t)0x00003000)         /* Bit[13:12] */
#define AFIO_SIP_DS_DS6_0                                       ((uint32_t)0x00001000)         /* Bit12*/
#define AFIO_SIP_DS_DS6_1                                       ((uint32_t)0x00002000)         /* Bit13*/
#define AFIO_SIP_DS_DS5                                         ((uint32_t)0x00000C00)         /* Bit[11:10] */
#define AFIO_SIP_DS_DS5_0                                       ((uint32_t)0x00000400)         /* Bit10*/
#define AFIO_SIP_DS_DS5_1                                       ((uint32_t)0x00000800)         /* Bit11*/
#define AFIO_SIP_DS_DS4                                         ((uint32_t)0x00000300)         /* Bit[9:8] */
#define AFIO_SIP_DS_DS4_0                                       ((uint32_t)0x00000100)         /* Bit8*/
#define AFIO_SIP_DS_DS4_1                                       ((uint32_t)0x00000200)         /* Bit9*/
#define AFIO_SIP_DS_DS3                                         ((uint32_t)0x000000C0)         /* Bit[7:6] */
#define AFIO_SIP_DS_DS3_0                                       ((uint32_t)0x00000040)         /* Bit6*/
#define AFIO_SIP_DS_DS3_1                                       ((uint32_t)0x00000080)         /* Bit7*/
#define AFIO_SIP_DS_DS2                                         ((uint32_t)0x00000030)         /* Bit[5:4] */
#define AFIO_SIP_DS_DS2_0                                       ((uint32_t)0x00000010)         /* Bit4*/
#define AFIO_SIP_DS_DS2_1                                       ((uint32_t)0x00000020)         /* Bit5*/
#define AFIO_SIP_DS_DS1                                         ((uint32_t)0x0000000C)         /* Bit[3:2] */
#define AFIO_SIP_DS_DS1_0                                       ((uint32_t)0x00000004)         /* Bit2*/
#define AFIO_SIP_DS_DS1_1                                       ((uint32_t)0x00000008)         /* Bit3*/
#define AFIO_SIP_DS_DS0                                         ((uint32_t)0x00000003)         /* Bit[1:0] */
#define AFIO_SIP_DS_DS0_0                                       ((uint32_t)0x00000001)         /* Bit0*/
#define AFIO_SIP_DS_DS0_1                                       ((uint32_t)0x00000002)         /* Bit1*/

/******** Bit definition for AFIO_ADCSW_CFG register  ********/
#define AFIO_ADCSW_CFG_VREF                                     ((uint32_t)0x10000000)         /* Bit[28] */
#define AFIO_ADCSW_CFG_SW_PJ7                                   ((uint32_t)0x08000000)         /* Bit[27] */
#define AFIO_ADCSW_CFG_SW_PJ6                                   ((uint32_t)0x04000000)         /* Bit[26] */
#define AFIO_ADCSW_CFG_SW_DAC135_OUT                            ((uint32_t)0x03800000)         /* Bit[25:23] */
#define AFIO_ADCSW_CFG_SW_DAC5_OUT                              ((uint32_t)0x02000000)         /* Bit[25] */
#define AFIO_ADCSW_CFG_SW_DAC3_OUT                              ((uint32_t)0x01000000)         /* Bit[24] */
#define AFIO_ADCSW_CFG_SW_DAC1_OUT                              ((uint32_t)0x00800000)         /* Bit[23] */
#define AFIO_ADCSW_CFG_SW_PJ5                                   ((uint32_t)0x00400000)         /* Bit[22] */
#define AFIO_ADCSW_CFG_SW_PJ4                                   ((uint32_t)0x00200000)         /* Bit[21] */
#define AFIO_ADCSW_CFG_SW_TEMP                                  ((uint32_t)0x00100000)         /* Bit[20] */
#define AFIO_ADCSW_CFG_SW_PJ3                                   ((uint32_t)0x00080000)         /* Bit[19] */
#define AFIO_ADCSW_CFG_SW_PJ0                                   ((uint32_t)0x00040000)         /* Bit[18] */
#define AFIO_ADCSW_CFG_SW_DAC246_OUT                            ((uint32_t)0x00038000)         /* Bit[17:15] */
#define AFIO_ADCSW_CFG_SW_DAC6_OUT                              ((uint32_t)0x00020000)         /* Bit[17] */
#define AFIO_ADCSW_CFG_SW_DAC4_OUT                              ((uint32_t)0x00010000)         /* Bit[16] */
#define AFIO_ADCSW_CFG_SW_DAC2_OUT                              ((uint32_t)0x00008000)         /* Bit[15] */
#define AFIO_ADCSW_CFG_VBAT                                     ((uint32_t)0x00004000)         /* Bit[14] */
#define AFIO_ADCSW_CFG_SWPI15                                   ((uint32_t)0x00003000)         /* Bit[13:12] */
#define AFIO_ADCSW_CFG_SWPI15_1                                 ((uint32_t)0x00002000)         /* Bit[13] */
#define AFIO_ADCSW_CFG_SWPI15_0                                 ((uint32_t)0x00001000)         /* Bit[12] */
#define AFIO_ADCSW_CFG_SWPA1_C                                  ((uint32_t)0x00000C00)         /* Bit[11:10] */
#define AFIO_ADCSW_CFG_SWPA1_C_1                                ((uint32_t)0x00000800)         /* Bit[11] */
#define AFIO_ADCSW_CFG_SWPA1_C_0                                ((uint32_t)0x00000400)         /* Bit[10] */
#define AFIO_ADCSW_CFG_SWPC3_C                                  ((uint32_t)0x00000300)         /* Bit[9:8] */
#define AFIO_ADCSW_CFG_SWPC3_C_1                                ((uint32_t)0x00000200)         /* Bit[9] */
#define AFIO_ADCSW_CFG_SWPC3_C_0                                ((uint32_t)0x00000100)         /* Bit[8] */
#define AFIO_ADCSW_CFG_SWPC2_C                                  ((uint32_t)0x000000F0)         /* Bit[7:4] */
#define AFIO_ADCSW_CFG_SWPC2_C_3                                ((uint32_t)0x00000080)         /* Bit[7] */
#define AFIO_ADCSW_CFG_SWPC2_C_2                                ((uint32_t)0x00000040)         /* Bit[6] */
#define AFIO_ADCSW_CFG_SWPC2_C_1                                ((uint32_t)0x00000020)         /* Bit[5] */
#define AFIO_ADCSW_CFG_SWPC2_C_0                                ((uint32_t)0x00000010)         /* Bit[4] */
#define AFIO_ADCSW_CFG_SWPA0_C                                  ((uint32_t)0x0000000F)         /* Bit[3:0] */
#define AFIO_ADCSW_CFG_SWPA0_C_3                                ((uint32_t)0x00000008)         /* Bit[3] */
#define AFIO_ADCSW_CFG_SWPA0_C_2                                ((uint32_t)0x00000004)         /* Bit[2] */
#define AFIO_ADCSW_CFG_SWPA0_C_1                                ((uint32_t)0x00000002)         /* Bit[1] */
#define AFIO_ADCSW_CFG_SWPA0_C_0                                ((uint32_t)0x00000001)         /* Bit[0] */

/******** Bit definition for AFIO_SDRAM_VREF_EN0 register  ********/
#define AFIO_SDRAM_VREF_EN0_VREF_EN0                            ((uint32_t)0xFFFFFFFF)         /* Bit[31:0] */
#define AFIO_SDRAM_VREF_EN0_VREF_EN0_0                          ((uint32_t)0x00000001)         /* Bit0*/
#define AFIO_SDRAM_VREF_EN0_VREF_EN0_1                          ((uint32_t)0x00000002)         /* Bit1*/
#define AFIO_SDRAM_VREF_EN0_VREF_EN0_2                          ((uint32_t)0x00000004)         /* Bit2*/
#define AFIO_SDRAM_VREF_EN0_VREF_EN0_3                          ((uint32_t)0x00000008)         /* Bit3*/
#define AFIO_SDRAM_VREF_EN0_VREF_EN0_4                          ((uint32_t)0x00000010)         /* Bit4*/
#define AFIO_SDRAM_VREF_EN0_VREF_EN0_5                          ((uint32_t)0x00000020)         /* Bit5*/
#define AFIO_SDRAM_VREF_EN0_VREF_EN0_6                          ((uint32_t)0x00000040)         /* Bit6*/
#define AFIO_SDRAM_VREF_EN0_VREF_EN0_7                          ((uint32_t)0x00000080)         /* Bit7*/
#define AFIO_SDRAM_VREF_EN0_VREF_EN0_8                          ((uint32_t)0x00000100)         /* Bit8*/
#define AFIO_SDRAM_VREF_EN0_VREF_EN0_9                          ((uint32_t)0x00000200)         /* Bit9*/
#define AFIO_SDRAM_VREF_EN0_VREF_EN0_10                         ((uint32_t)0x00000400)         /* Bit10*/
#define AFIO_SDRAM_VREF_EN0_VREF_EN0_11                         ((uint32_t)0x00000800)         /* Bit11*/
#define AFIO_SDRAM_VREF_EN0_VREF_EN0_12                         ((uint32_t)0x00001000)         /* Bit12*/
#define AFIO_SDRAM_VREF_EN0_VREF_EN0_13                         ((uint32_t)0x00002000)         /* Bit13*/
#define AFIO_SDRAM_VREF_EN0_VREF_EN0_14                         ((uint32_t)0x00004000)         /* Bit14*/
#define AFIO_SDRAM_VREF_EN0_VREF_EN0_15                         ((uint32_t)0x00008000)         /* Bit15*/
#define AFIO_SDRAM_VREF_EN0_VREF_EN0_16                         ((uint32_t)0x00010000)         /* Bit16*/
#define AFIO_SDRAM_VREF_EN0_VREF_EN0_17                         ((uint32_t)0x00020000)         /* Bit17*/
#define AFIO_SDRAM_VREF_EN0_VREF_EN0_18                         ((uint32_t)0x00040000)         /* Bit18*/
#define AFIO_SDRAM_VREF_EN0_VREF_EN0_19                         ((uint32_t)0x00080000)         /* Bit19*/
#define AFIO_SDRAM_VREF_EN0_VREF_EN0_20                         ((uint32_t)0x00100000)         /* Bit20*/
#define AFIO_SDRAM_VREF_EN0_VREF_EN0_21                         ((uint32_t)0x00200000)         /* Bit21*/
#define AFIO_SDRAM_VREF_EN0_VREF_EN0_22                         ((uint32_t)0x00400000)         /* Bit22*/
#define AFIO_SDRAM_VREF_EN0_VREF_EN0_23                         ((uint32_t)0x00800000)         /* Bit23*/
#define AFIO_SDRAM_VREF_EN0_VREF_EN0_24                         ((uint32_t)0x01000000)         /* Bit24*/
#define AFIO_SDRAM_VREF_EN0_VREF_EN0_25                         ((uint32_t)0x02000000)         /* Bit25*/
#define AFIO_SDRAM_VREF_EN0_VREF_EN0_26                         ((uint32_t)0x04000000)         /* Bit26*/
#define AFIO_SDRAM_VREF_EN0_VREF_EN0_27                         ((uint32_t)0x08000000)         /* Bit27*/
#define AFIO_SDRAM_VREF_EN0_VREF_EN0_28                         ((uint32_t)0x10000000)         /* Bit28*/
#define AFIO_SDRAM_VREF_EN0_VREF_EN0_29                         ((uint32_t)0x20000000)         /* Bit29*/
#define AFIO_SDRAM_VREF_EN0_VREF_EN0_30                         ((uint32_t)0x40000000)         /* Bit30*/
#define AFIO_SDRAM_VREF_EN0_VREF_EN0_31                         ((uint32_t)0x80000000)         /* Bit31*/

/******** Bit definition for AFIO_SDRAM_VREF_EN1 register  ********/
#define AFIO_SDRAM_VREF_EN1_VREF_EN1                            ((uint32_t)0xFFFFFFFF)         /* Bit[31:0] */
#define AFIO_SDRAM_VREF_EN1_VREF_EN1_0                          ((uint32_t)0x00000001)         /* Bit0*/
#define AFIO_SDRAM_VREF_EN1_VREF_EN1_1                          ((uint32_t)0x00000002)         /* Bit1*/
#define AFIO_SDRAM_VREF_EN1_VREF_EN1_2                          ((uint32_t)0x00000004)         /* Bit2*/
#define AFIO_SDRAM_VREF_EN1_VREF_EN1_3                          ((uint32_t)0x00000008)         /* Bit3*/
#define AFIO_SDRAM_VREF_EN1_VREF_EN1_4                          ((uint32_t)0x00000010)         /* Bit4*/
#define AFIO_SDRAM_VREF_EN1_VREF_EN1_5                          ((uint32_t)0x00000020)         /* Bit5*/
#define AFIO_SDRAM_VREF_EN1_VREF_EN1_6                          ((uint32_t)0x00000040)         /* Bit6*/
#define AFIO_SDRAM_VREF_EN1_VREF_EN1_7                          ((uint32_t)0x00000080)         /* Bit7*/
#define AFIO_SDRAM_VREF_EN1_VREF_EN1_8                          ((uint32_t)0x00000100)         /* Bit8*/
#define AFIO_SDRAM_VREF_EN1_VREF_EN1_9                          ((uint32_t)0x00000200)         /* Bit9*/
#define AFIO_SDRAM_VREF_EN1_VREF_EN1_10                         ((uint32_t)0x00000400)         /* Bit10*/
#define AFIO_SDRAM_VREF_EN1_VREF_EN1_11                         ((uint32_t)0x00000800)         /* Bit11*/
#define AFIO_SDRAM_VREF_EN1_VREF_EN1_12                         ((uint32_t)0x00001000)         /* Bit12*/
#define AFIO_SDRAM_VREF_EN1_VREF_EN1_13                         ((uint32_t)0x00002000)         /* Bit13*/
#define AFIO_SDRAM_VREF_EN1_VREF_EN1_14                         ((uint32_t)0x00004000)         /* Bit14*/
#define AFIO_SDRAM_VREF_EN1_VREF_EN1_15                         ((uint32_t)0x00008000)         /* Bit15*/
#define AFIO_SDRAM_VREF_EN1_VREF_EN1_16                         ((uint32_t)0x00010000)         /* Bit16*/
#define AFIO_SDRAM_VREF_EN1_VREF_EN1_17                         ((uint32_t)0x00020000)         /* Bit17*/
#define AFIO_SDRAM_VREF_EN1_VREF_EN1_18                         ((uint32_t)0x00040000)         /* Bit18*/
#define AFIO_SDRAM_VREF_EN1_VREF_EN1_19                         ((uint32_t)0x00080000)         /* Bit19*/
#define AFIO_SDRAM_VREF_EN1_VREF_EN1_20                         ((uint32_t)0x00100000)         /* Bit20*/
#define AFIO_SDRAM_VREF_EN1_VREF_EN1_21                         ((uint32_t)0x00200000)         /* Bit21*/
#define AFIO_SDRAM_VREF_EN1_VREF_EN1_22                         ((uint32_t)0x00400000)         /* Bit22*/
#define AFIO_SDRAM_VREF_EN1_VREF_EN1_23                         ((uint32_t)0x00800000)         /* Bit23*/
#define AFIO_SDRAM_VREF_EN1_VREF_EN1_24                         ((uint32_t)0x01000000)         /* Bit24*/
#define AFIO_SDRAM_VREF_EN1_VREF_EN1_25                         ((uint32_t)0x02000000)         /* Bit25*/
#define AFIO_SDRAM_VREF_EN1_VREF_EN1_26                         ((uint32_t)0x04000000)         /* Bit26*/
#define AFIO_SDRAM_VREF_EN1_VREF_EN1_27                         ((uint32_t)0x08000000)         /* Bit27*/
#define AFIO_SDRAM_VREF_EN1_VREF_EN1_28                         ((uint32_t)0x10000000)         /* Bit28*/
#define AFIO_SDRAM_VREF_EN1_VREF_EN1_29                         ((uint32_t)0x20000000)         /* Bit29*/
#define AFIO_SDRAM_VREF_EN1_VREF_EN1_30                         ((uint32_t)0x40000000)         /* Bit30*/
#define AFIO_SDRAM_VREF_EN1_VREF_EN1_31                         ((uint32_t)0x80000000)         /* Bit31*/

/******** Bit definition for AFIO_SDRAM_VREF_EN2 register  ********/
#define AFIO_SDRAM_VREF_EN2_VREF_EN2                            ((uint32_t)0x000007FF)         /* Bit[10:0] */
#define AFIO_SDRAM_VREF_EN2_VREF_EN2_0                          ((uint32_t)0x00000001)         /* Bit0*/
#define AFIO_SDRAM_VREF_EN2_VREF_EN2_1                          ((uint32_t)0x00000002)         /* Bit1*/
#define AFIO_SDRAM_VREF_EN2_VREF_EN2_2                          ((uint32_t)0x00000004)         /* Bit2*/
#define AFIO_SDRAM_VREF_EN2_VREF_EN2_3                          ((uint32_t)0x00000008)         /* Bit3*/
#define AFIO_SDRAM_VREF_EN2_VREF_EN2_4                          ((uint32_t)0x00000010)         /* Bit4*/
#define AFIO_SDRAM_VREF_EN2_VREF_EN2_5                          ((uint32_t)0x00000020)         /* Bit5*/
#define AFIO_SDRAM_VREF_EN2_VREF_EN2_6                          ((uint32_t)0x00000040)         /* Bit6*/
#define AFIO_SDRAM_VREF_EN2_VREF_EN2_7                          ((uint32_t)0x00000080)         /* Bit7*/
#define AFIO_SDRAM_VREF_EN2_VREF_EN2_8                          ((uint32_t)0x00000100)         /* Bit8*/
#define AFIO_SDRAM_VREF_EN2_VREF_EN2_9                          ((uint32_t)0x00000200)         /* Bit9*/
#define AFIO_SDRAM_VREF_EN2_VREF_EN2_10                         ((uint32_t)0x00000400)         /* Bit10*/
    
/******** Bit definition for AFIO_SDRAMDSN_CFG0 register  ********/
#define AFIO_SDRAMDSN_CFG0_DSN0                                 ((uint32_t)0xFFFFFFFF)         /* Bit[31:0] */
#define AFIO_SDRAMDSN_CFG0_DSN0_0                               ((uint32_t)0x00000001)         /* Bit0*/
#define AFIO_SDRAMDSN_CFG0_DSN0_1                               ((uint32_t)0x00000002)         /* Bit1*/
#define AFIO_SDRAMDSN_CFG0_DSN0_2                               ((uint32_t)0x00000004)         /* Bit2*/
#define AFIO_SDRAMDSN_CFG0_DSN0_3                               ((uint32_t)0x00000008)         /* Bit3*/
#define AFIO_SDRAMDSN_CFG0_DSN0_4                               ((uint32_t)0x00000010)         /* Bit4*/
#define AFIO_SDRAMDSN_CFG0_DSN0_5                               ((uint32_t)0x00000020)         /* Bit5*/
#define AFIO_SDRAMDSN_CFG0_DSN0_6                               ((uint32_t)0x00000040)         /* Bit6*/
#define AFIO_SDRAMDSN_CFG0_DSN0_7                               ((uint32_t)0x00000080)         /* Bit7*/
#define AFIO_SDRAMDSN_CFG0_DSN0_8                               ((uint32_t)0x00000100)         /* Bit8*/
#define AFIO_SDRAMDSN_CFG0_DSN0_9                               ((uint32_t)0x00000200)         /* Bit9*/
#define AFIO_SDRAMDSN_CFG0_DSN0_10                              ((uint32_t)0x00000400)         /* Bit10*/
#define AFIO_SDRAMDSN_CFG0_DSN0_11                              ((uint32_t)0x00000800)         /* Bit11*/
#define AFIO_SDRAMDSN_CFG0_DSN0_12                              ((uint32_t)0x00001000)         /* Bit12*/
#define AFIO_SDRAMDSN_CFG0_DSN0_13                              ((uint32_t)0x00002000)         /* Bit13*/
#define AFIO_SDRAMDSN_CFG0_DSN0_14                              ((uint32_t)0x00004000)         /* Bit14*/
#define AFIO_SDRAMDSN_CFG0_DSN0_15                              ((uint32_t)0x00008000)         /* Bit15*/
#define AFIO_SDRAMDSN_CFG0_DSN0_16                              ((uint32_t)0x00010000)         /* Bit16*/
#define AFIO_SDRAMDSN_CFG0_DSN0_17                              ((uint32_t)0x00020000)         /* Bit17*/
#define AFIO_SDRAMDSN_CFG0_DSN0_18                              ((uint32_t)0x00040000)         /* Bit18*/
#define AFIO_SDRAMDSN_CFG0_DSN0_19                              ((uint32_t)0x00080000)         /* Bit19*/
#define AFIO_SDRAMDSN_CFG0_DSN0_20                              ((uint32_t)0x00100000)         /* Bit20*/
#define AFIO_SDRAMDSN_CFG0_DSN0_21                              ((uint32_t)0x00200000)         /* Bit21*/
#define AFIO_SDRAMDSN_CFG0_DSN0_22                              ((uint32_t)0x00400000)         /* Bit22*/
#define AFIO_SDRAMDSN_CFG0_DSN0_23                              ((uint32_t)0x00800000)         /* Bit23*/
#define AFIO_SDRAMDSN_CFG0_DSN0_24                              ((uint32_t)0x01000000)         /* Bit24*/
#define AFIO_SDRAMDSN_CFG0_DSN0_25                              ((uint32_t)0x02000000)         /* Bit25*/
#define AFIO_SDRAMDSN_CFG0_DSN0_26                              ((uint32_t)0x04000000)         /* Bit26*/
#define AFIO_SDRAMDSN_CFG0_DSN0_27                              ((uint32_t)0x08000000)         /* Bit27*/
#define AFIO_SDRAMDSN_CFG0_DSN0_28                              ((uint32_t)0x10000000)         /* Bit28*/
#define AFIO_SDRAMDSN_CFG0_DSN0_29                              ((uint32_t)0x20000000)         /* Bit29*/
#define AFIO_SDRAMDSN_CFG0_DSN0_30                              ((uint32_t)0x40000000)         /* Bit30*/
#define AFIO_SDRAMDSN_CFG0_DSN0_31                              ((uint32_t)0x80000000)         /* Bit31*/
    
/******** Bit definition for AFIO_SDRAMDSN_CFG1 register  ********/
#define AFIO_SDRAMDSN_CFG1_DSN1                                 ((uint32_t)0xFFFFFFFF)         /* Bit[31:0] */
#define AFIO_SDRAMDSN_CFG1_DSN1_0                               ((uint32_t)0x00000001)         /* Bit0*/
#define AFIO_SDRAMDSN_CFG1_DSN1_1                               ((uint32_t)0x00000002)         /* Bit1*/
#define AFIO_SDRAMDSN_CFG1_DSN1_2                               ((uint32_t)0x00000004)         /* Bit2*/
#define AFIO_SDRAMDSN_CFG1_DSN1_3                               ((uint32_t)0x00000008)         /* Bit3*/
#define AFIO_SDRAMDSN_CFG1_DSN1_4                               ((uint32_t)0x00000010)         /* Bit4*/
#define AFIO_SDRAMDSN_CFG1_DSN1_5                               ((uint32_t)0x00000020)         /* Bit5*/
#define AFIO_SDRAMDSN_CFG1_DSN1_6                               ((uint32_t)0x00000040)         /* Bit6*/
#define AFIO_SDRAMDSN_CFG1_DSN1_7                               ((uint32_t)0x00000080)         /* Bit7*/
#define AFIO_SDRAMDSN_CFG1_DSN1_8                               ((uint32_t)0x00000100)         /* Bit8*/
#define AFIO_SDRAMDSN_CFG1_DSN1_9                               ((uint32_t)0x00000200)         /* Bit9*/
#define AFIO_SDRAMDSN_CFG1_DSN1_10                              ((uint32_t)0x00000400)         /* Bit10*/
#define AFIO_SDRAMDSN_CFG1_DSN1_11                              ((uint32_t)0x00000800)         /* Bit11*/
#define AFIO_SDRAMDSN_CFG1_DSN1_12                              ((uint32_t)0x00001000)         /* Bit12*/
#define AFIO_SDRAMDSN_CFG1_DSN1_13                              ((uint32_t)0x00002000)         /* Bit13*/
#define AFIO_SDRAMDSN_CFG1_DSN1_14                              ((uint32_t)0x00004000)         /* Bit14*/
#define AFIO_SDRAMDSN_CFG1_DSN1_15                              ((uint32_t)0x00008000)         /* Bit15*/
#define AFIO_SDRAMDSN_CFG1_DSN1_16                              ((uint32_t)0x00010000)         /* Bit16*/
#define AFIO_SDRAMDSN_CFG1_DSN1_17                              ((uint32_t)0x00020000)         /* Bit17*/
#define AFIO_SDRAMDSN_CFG1_DSN1_18                              ((uint32_t)0x00040000)         /* Bit18*/
#define AFIO_SDRAMDSN_CFG1_DSN1_19                              ((uint32_t)0x00080000)         /* Bit19*/
#define AFIO_SDRAMDSN_CFG1_DSN1_20                              ((uint32_t)0x00100000)         /* Bit20*/
#define AFIO_SDRAMDSN_CFG1_DSN1_21                              ((uint32_t)0x00200000)         /* Bit21*/
#define AFIO_SDRAMDSN_CFG1_DSN1_22                              ((uint32_t)0x00400000)         /* Bit22*/
#define AFIO_SDRAMDSN_CFG1_DSN1_23                              ((uint32_t)0x00800000)         /* Bit23*/
#define AFIO_SDRAMDSN_CFG1_DSN1_24                              ((uint32_t)0x01000000)         /* Bit24*/
#define AFIO_SDRAMDSN_CFG1_DSN1_25                              ((uint32_t)0x02000000)         /* Bit25*/
#define AFIO_SDRAMDSN_CFG1_DSN1_26                              ((uint32_t)0x04000000)         /* Bit26*/
#define AFIO_SDRAMDSN_CFG1_DSN1_27                              ((uint32_t)0x08000000)         /* Bit27*/
#define AFIO_SDRAMDSN_CFG1_DSN1_28                              ((uint32_t)0x10000000)         /* Bit28*/
#define AFIO_SDRAMDSN_CFG1_DSN1_29                              ((uint32_t)0x20000000)         /* Bit29*/
#define AFIO_SDRAMDSN_CFG1_DSN1_30                              ((uint32_t)0x40000000)         /* Bit30*/
#define AFIO_SDRAMDSN_CFG1_DSN1_31                              ((uint32_t)0x80000000)         /* Bit31*/

/******** Bit definition for AFIO_SDRAMDSN_CFG2 register  ********/
#define AFIO_SDRAMDSN_CFG2_DSN2                                 ((uint32_t)0x000007FF)         /* Bit[10:0] */
#define AFIO_SDRAMDSN_CFG2_DSN2_0                               ((uint32_t)0x00000001)         /* Bit0*/
#define AFIO_SDRAMDSN_CFG2_DSN2_1                               ((uint32_t)0x00000002)         /* Bit1*/
#define AFIO_SDRAMDSN_CFG2_DSN2_2                               ((uint32_t)0x00000004)         /* Bit2*/
#define AFIO_SDRAMDSN_CFG2_DSN2_3                               ((uint32_t)0x00000008)         /* Bit3*/
#define AFIO_SDRAMDSN_CFG2_DSN2_4                               ((uint32_t)0x00000010)         /* Bit4*/
#define AFIO_SDRAMDSN_CFG2_DSN2_5                               ((uint32_t)0x00000020)         /* Bit5*/
#define AFIO_SDRAMDSN_CFG2_DSN2_6                               ((uint32_t)0x00000040)         /* Bit6*/
#define AFIO_SDRAMDSN_CFG2_DSN2_7                               ((uint32_t)0x00000080)         /* Bit7*/
#define AFIO_SDRAMDSN_CFG2_DSN2_8                               ((uint32_t)0x00000100)         /* Bit8*/
#define AFIO_SDRAMDSN_CFG2_DSN2_9                               ((uint32_t)0x00000200)         /* Bit9*/
#define AFIO_SDRAMDSN_CFG2_DSN2_10                              ((uint32_t)0x00000400)         /* Bit10*/

/******** Bit definition for AFIO_SDRAMDSP_CFG0 register  ********/
#define AFIO_SDRAMDSP_CFG0_DSP0                                 ((uint32_t)0xFFFFFFFF)         /* Bit[31:0] */
#define AFIO_SDRAMDSP_CFG0_DSP0_0                               ((uint32_t)0x00000001)         /* Bit0*/
#define AFIO_SDRAMDSP_CFG0_DSP0_1                               ((uint32_t)0x00000002)         /* Bit1*/
#define AFIO_SDRAMDSP_CFG0_DSP0_2                               ((uint32_t)0x00000004)         /* Bit2*/
#define AFIO_SDRAMDSP_CFG0_DSP0_3                               ((uint32_t)0x00000008)         /* Bit3*/
#define AFIO_SDRAMDSP_CFG0_DSP0_4                               ((uint32_t)0x00000010)         /* Bit4*/
#define AFIO_SDRAMDSP_CFG0_DSP0_5                               ((uint32_t)0x00000020)         /* Bit5*/
#define AFIO_SDRAMDSP_CFG0_DSP0_6                               ((uint32_t)0x00000040)         /* Bit6*/
#define AFIO_SDRAMDSP_CFG0_DSP0_7                               ((uint32_t)0x00000080)         /* Bit7*/
#define AFIO_SDRAMDSP_CFG0_DSP0_8                               ((uint32_t)0x00000100)         /* Bit8*/
#define AFIO_SDRAMDSP_CFG0_DSP0_9                               ((uint32_t)0x00000200)         /* Bit9*/
#define AFIO_SDRAMDSP_CFG0_DSP0_10                              ((uint32_t)0x00000400)         /* Bit10*/
#define AFIO_SDRAMDSP_CFG0_DSP0_11                              ((uint32_t)0x00000800)         /* Bit11*/
#define AFIO_SDRAMDSP_CFG0_DSP0_12                              ((uint32_t)0x00001000)         /* Bit12*/
#define AFIO_SDRAMDSP_CFG0_DSP0_13                              ((uint32_t)0x00002000)         /* Bit13*/
#define AFIO_SDRAMDSP_CFG0_DSP0_14                              ((uint32_t)0x00004000)         /* Bit14*/
#define AFIO_SDRAMDSP_CFG0_DSP0_15                              ((uint32_t)0x00008000)         /* Bit15*/
#define AFIO_SDRAMDSP_CFG0_DSP0_16                              ((uint32_t)0x00010000)         /* Bit16*/
#define AFIO_SDRAMDSP_CFG0_DSP0_17                              ((uint32_t)0x00020000)         /* Bit17*/
#define AFIO_SDRAMDSP_CFG0_DSP0_18                              ((uint32_t)0x00040000)         /* Bit18*/
#define AFIO_SDRAMDSP_CFG0_DSP0_19                              ((uint32_t)0x00080000)         /* Bit19*/
#define AFIO_SDRAMDSP_CFG0_DSP0_20                              ((uint32_t)0x00100000)         /* Bit20*/
#define AFIO_SDRAMDSP_CFG0_DSP0_21                              ((uint32_t)0x00200000)         /* Bit21*/
#define AFIO_SDRAMDSP_CFG0_DSP0_22                              ((uint32_t)0x00400000)         /* Bit22*/
#define AFIO_SDRAMDSP_CFG0_DSP0_23                              ((uint32_t)0x00800000)         /* Bit23*/
#define AFIO_SDRAMDSP_CFG0_DSP0_24                              ((uint32_t)0x01000000)         /* Bit24*/
#define AFIO_SDRAMDSP_CFG0_DSP0_25                              ((uint32_t)0x02000000)         /* Bit25*/
#define AFIO_SDRAMDSP_CFG0_DSP0_26                              ((uint32_t)0x04000000)         /* Bit26*/
#define AFIO_SDRAMDSP_CFG0_DSP0_27                              ((uint32_t)0x08000000)         /* Bit27*/
#define AFIO_SDRAMDSP_CFG0_DSP0_28                              ((uint32_t)0x10000000)         /* Bit28*/
#define AFIO_SDRAMDSP_CFG0_DSP0_29                              ((uint32_t)0x20000000)         /* Bit29*/
#define AFIO_SDRAMDSP_CFG0_DSP0_30                              ((uint32_t)0x40000000)         /* Bit30*/
#define AFIO_SDRAMDSP_CFG0_DSP0_31                              ((uint32_t)0x80000000)         /* Bit31*/

/******** Bit definition for AFIO_SDRAMDSP_CFG1 register  ********/
#define AFIO_SDRAMDSP_CFG1_DSP1                                 ((uint32_t)0xFFFFFFFF)         /* Bit[31:0] */
#define AFIO_SDRAMDSP_CFG1_DSP1_0                               ((uint32_t)0x00000001)         /* Bit0*/
#define AFIO_SDRAMDSP_CFG1_DSP1_1                               ((uint32_t)0x00000002)         /* Bit1*/
#define AFIO_SDRAMDSP_CFG1_DSP1_2                               ((uint32_t)0x00000004)         /* Bit2*/
#define AFIO_SDRAMDSP_CFG1_DSP1_3                               ((uint32_t)0x00000008)         /* Bit3*/
#define AFIO_SDRAMDSP_CFG1_DSP1_4                               ((uint32_t)0x00000010)         /* Bit4*/
#define AFIO_SDRAMDSP_CFG1_DSP1_5                               ((uint32_t)0x00000020)         /* Bit5*/
#define AFIO_SDRAMDSP_CFG1_DSP1_6                               ((uint32_t)0x00000040)         /* Bit6*/
#define AFIO_SDRAMDSP_CFG1_DSP1_7                               ((uint32_t)0x00000080)         /* Bit7*/
#define AFIO_SDRAMDSP_CFG1_DSP1_8                               ((uint32_t)0x00000100)         /* Bit8*/
#define AFIO_SDRAMDSP_CFG1_DSP1_9                               ((uint32_t)0x00000200)         /* Bit9*/
#define AFIO_SDRAMDSP_CFG1_DSP1_10                              ((uint32_t)0x00000400)         /* Bit10*/
#define AFIO_SDRAMDSP_CFG1_DSP1_11                              ((uint32_t)0x00000800)         /* Bit11*/
#define AFIO_SDRAMDSP_CFG1_DSP1_12                              ((uint32_t)0x00001000)         /* Bit12*/
#define AFIO_SDRAMDSP_CFG1_DSP1_13                              ((uint32_t)0x00002000)         /* Bit13*/
#define AFIO_SDRAMDSP_CFG1_DSP1_14                              ((uint32_t)0x00004000)         /* Bit14*/
#define AFIO_SDRAMDSP_CFG1_DSP1_15                              ((uint32_t)0x00008000)         /* Bit15*/
#define AFIO_SDRAMDSP_CFG1_DSP1_16                              ((uint32_t)0x00010000)         /* Bit16*/
#define AFIO_SDRAMDSP_CFG1_DSP1_17                              ((uint32_t)0x00020000)         /* Bit17*/
#define AFIO_SDRAMDSP_CFG1_DSP1_18                              ((uint32_t)0x00040000)         /* Bit18*/
#define AFIO_SDRAMDSP_CFG1_DSP1_19                              ((uint32_t)0x00080000)         /* Bit19*/
#define AFIO_SDRAMDSP_CFG1_DSP1_20                              ((uint32_t)0x00100000)         /* Bit20*/
#define AFIO_SDRAMDSP_CFG1_DSP1_21                              ((uint32_t)0x00200000)         /* Bit21*/
#define AFIO_SDRAMDSP_CFG1_DSP1_22                              ((uint32_t)0x00400000)         /* Bit22*/
#define AFIO_SDRAMDSP_CFG1_DSP1_23                              ((uint32_t)0x00800000)         /* Bit23*/
#define AFIO_SDRAMDSP_CFG1_DSP1_24                              ((uint32_t)0x01000000)         /* Bit24*/
#define AFIO_SDRAMDSP_CFG1_DSP1_25                              ((uint32_t)0x02000000)         /* Bit25*/
#define AFIO_SDRAMDSP_CFG1_DSP1_26                              ((uint32_t)0x04000000)         /* Bit26*/
#define AFIO_SDRAMDSP_CFG1_DSP1_27                              ((uint32_t)0x08000000)         /* Bit27*/
#define AFIO_SDRAMDSP_CFG1_DSP1_28                              ((uint32_t)0x10000000)         /* Bit28*/
#define AFIO_SDRAMDSP_CFG1_DSP1_29                              ((uint32_t)0x20000000)         /* Bit29*/
#define AFIO_SDRAMDSP_CFG1_DSP1_30                              ((uint32_t)0x40000000)         /* Bit30*/
#define AFIO_SDRAMDSP_CFG1_DSP1_31                              ((uint32_t)0x80000000)         /* Bit31*/

/******** Bit definition for AFIO_SDRAMDSP_CFG2 register  ********/
#define AFIO_SDRAMDSP_CFG2_DSP2                                 ((uint32_t)0x000007FF)         /* Bit[10:0] */
#define AFIO_SDRAMDSP_CFG2_DSP2_0                               ((uint32_t)0x00000001)         /* Bit0*/
#define AFIO_SDRAMDSP_CFG2_DSP2_1                               ((uint32_t)0x00000002)         /* Bit1*/
#define AFIO_SDRAMDSP_CFG2_DSP2_2                               ((uint32_t)0x00000004)         /* Bit2*/
#define AFIO_SDRAMDSP_CFG2_DSP2_3                               ((uint32_t)0x00000008)         /* Bit3*/
#define AFIO_SDRAMDSP_CFG2_DSP2_4                               ((uint32_t)0x00000010)         /* Bit4*/
#define AFIO_SDRAMDSP_CFG2_DSP2_5                               ((uint32_t)0x00000020)         /* Bit5*/
#define AFIO_SDRAMDSP_CFG2_DSP2_6                               ((uint32_t)0x00000040)         /* Bit6*/
#define AFIO_SDRAMDSP_CFG2_DSP2_7                               ((uint32_t)0x00000080)         /* Bit7*/
#define AFIO_SDRAMDSP_CFG2_DSP2_8                               ((uint32_t)0x00000100)         /* Bit8*/
#define AFIO_SDRAMDSP_CFG2_DSP2_9                               ((uint32_t)0x00000200)         /* Bit9*/
#define AFIO_SDRAMDSP_CFG2_DSP2_10                              ((uint32_t)0x00000400)         /* Bit10*/



/***    Analog to Digital Converter Peripheral Interface   ***/
/********************  Bit definition for ADC_STS register  ********************/
#define ADC_STS_ALL                                         ((uint32_t)0x0003EB7FU)         
#define ADC_STS_WEFLAG                                      ((uint32_t)0x00020000U)         /* Bit[17] FIFO write error status */
#define ADC_STS_REFLAG                                      ((uint32_t)0x00010000U)         /* Bit[16] FIFO read error status */
#define ADC_STS_ROSOVFDSMU                                  ((uint32_t)0x00004000U)         /* Bit[14] Regular channel oversampling overrun flag in DSMU mode */
#define ADC_STS_JOSOVF                                      ((uint32_t)0x00002000U)         /* Bit[13] Injected channel oversampling overrun flag*/
#define ADC_STS_ROSOVF                                      ((uint32_t)0x00001000U)         /* Bit[12] Regular channel oversampling overrun flag*/
#define ADC_STS_EOSAMP                                      ((uint32_t)0x00000800U)         /* Bit[11] End of Sampling */
#define ADC_STS_PDRDY                                       ((uint32_t)0x00000200U)         /* Bit[9] ADC power down ready*/
#define ADC_STS_RDY                                         ((uint32_t)0x00000100U)         /* Bit[8] ADC power up ready */
#define ADC_STS_AWDG1                                       ((uint32_t)0x00000040U)         /* Bit[6] Analog watchdog 1 flag */
#define ADC_STS_STR                                         ((uint32_t)0x00000020U)         /* Bit[5] Regular channel Start flag */
#define ADC_STS_JENDCA                                      ((uint32_t)0x00000010U)         /* Bit[4] Any injected channel end of conversion */
#define ADC_STS_JENDC                                       ((uint32_t)0x00000008U)         /* Bit[3] Injected channel end of conversion */
#define ADC_STS_JSTR                                        ((uint32_t)0x00000004U)         /* Bit[2] Injected channel Start flag*/
#define ADC_STS_ENDCA                                       ((uint32_t)0x00000002U)         /* Bit[1] Any end of conversion */
#define ADC_STS_ENDC                                        ((uint32_t)0x00000001U)         /* Bit[0] End of conversion */

/*******************  Bit definition for ADC_CTRL1 register  ********************/
#define ADC_CTRL1_WEIEN                                     ((uint32_t)0x40000000U)         /* Bit[30] FIFO write error interrupt enable */
#define ADC_CTRL1_REIEN                                     ((uint32_t)0x20000000U)         /* Bit[29] FIFO read error interrupt enable*/

#define ADC_CTRL1_EOSMPIEN                                  ((uint32_t)0x10000000U)         /* Bit[28] End of Sampling interrupt enable */
#define ADC_CTRL1_PDRDYIEN                                  ((uint32_t)0x08000000U)         /* Bit[27] ADC power up ready interrupt enable */
#define ADC_CTRL1_RDYIEN                                    ((uint32_t)0x04000000U)         /* Bit[26] ADC power up ready interrupt enable */
#define ADC_CTRL1_DJCH                                      ((uint32_t)0x01000000U)         /* Bit[24] Discontinuous mode on injected channels */
#define ADC_CTRL1_DREGCH                                    ((uint32_t)0x00800000U)         /* Bit[23] Discontinuous mode on regular channels*/
#define ADC_CTRL1_AWD1ERCH                                  ((uint32_t)0x00400000U)         /* Bit[22] Analog watchdog 1 enable on regular channels */
#define ADC_CTRL1_AWD1EJCH                                  ((uint32_t)0x00200000U)         /* Bit[21] Analog watchdog 1 enable on injected channels */

#define ADC_CTRL1_AWD1CH                                    ((uint32_t)0x001F0000U)         /* Bit[20:16] Analog watchdog 1 channel select bits */
#define ADC_CTRL1_AWD1CH_0                                  ((uint32_t)0x00010000U)         /* Bit16*/
#define ADC_CTRL1_AWD1CH_1                                  ((uint32_t)0x00020000U)         /* Bit17*/
#define ADC_CTRL1_AWD1CH_2                                  ((uint32_t)0x00040000U)         /* Bit18*/
#define ADC_CTRL1_AWD1CH_3                                  ((uint32_t)0x00080000U)         /* Bit19*/
#define ADC_CTRL1_AWD1CH_4                                  ((uint32_t)0x00100000U)         /* Bit20*/

#define ADC_CTRL1_MULTMODE                                  ((uint32_t)0x0000F800U)         /* Bit[15:11] Mult-ADC mode selection*/
#define ADC_CTRL1_MULTMODE_0                                ((uint32_t)0x00000800U)         /* Bit11*/
#define ADC_CTRL1_MULTMODE_1                                ((uint32_t)0x00001000U)         /* Bit12*/
#define ADC_CTRL1_MULTMODE_2                                ((uint32_t)0x00002000U)         /* Bit13*/
#define ADC_CTRL1_MULTMODE_3                                ((uint32_t)0x00004000U)         /* Bit14*/
#define ADC_CTRL1_MULTMODE_4                                ((uint32_t)0x00008000U)         /* Bit15*/

#define ADC_CTRL1_DCTU                                      ((uint32_t)0x00000700U)         /* Bit[10:8] DISC_NUM[2:0] bits (Discontinuous mode channel count)*/
#define ADC_CTRL1_DCTU_0                                    ((uint32_t)0x00000100U)         /* Bit8*/
#define ADC_CTRL1_DCTU_1                                    ((uint32_t)0x00000200U)         /* Bit9*/
#define ADC_CTRL1_DCTU_2                                    ((uint32_t)0x00000400U)         /* Bit10*/

#define ADC_CTRL1_AUTOJC                                    ((uint32_t)0x00000080U)         /* Bit[7] Automatic injected group conversion*/
#define ADC_CTRL1_AWD1SGLEN                                 ((uint32_t)0x00000040U)         /* Bit[6] Enable the watchdog 1 on a single channel in scan mode */

#define ADC_CTRL1_AWD1IEN                                   ((uint32_t)0x00000020U)         /* Bit[5] Analog watchdog 1 interrupt enable*/
#define ADC_CTRL1_JENDCIEN                                  ((uint32_t)0x00000010U)         /* Bit[4] Injected channel end of conversion interrupt enable */
#define ADC_CTRL1_JENDCAIEN                                 ((uint32_t)0x00000008U)         /* Bit[3] Any injected channel end of conversion interrupt enable */
#define ADC_CTRL1_ENDCIEN                                   ((uint32_t)0x00000004U)         /* Bit[2] End of conversion interrupt enable*/
#define ADC_CTRL1_ENDCAIEN                                  ((uint32_t)0x00000002U)         /* Bit[1] Any end of conversion interrupt enable */

#define ADC_CTRL1_SCANMD                                    ((uint32_t)0x00000001U)         /* Bit[0] Scan mode */

/*******************  Bit definition for ADC_CTRL2 register  ********************/
#define ADC_CTRL2_EXTPRSEL                                  ((uint32_t)0xC0000000U)         /* Bit[31:30] External trigger enable and polarity selection for regular channels */
#define ADC_CTRL2_EXTPRSEL_0                                ((uint32_t)0x40000000U)         /* Bit30*/
#define ADC_CTRL2_EXTPRSEL_1                                ((uint32_t)0x80000000U)         /* Bit31*/

#define ADC_CTRL2_EXTRSEL                                   ((uint32_t)0x3F000000U)         /* Bit[29:24] External event select for regular group */
#define ADC_CTRL2_EXTRSEL_0                                 ((uint32_t)0x01000000U)         /* Bit24*/
#define ADC_CTRL2_EXTRSEL_1                                 ((uint32_t)0x02000000U)         /* Bit25*/
#define ADC_CTRL2_EXTRSEL_2                                 ((uint32_t)0x04000000U)         /* Bit26*/
#define ADC_CTRL2_EXTRSEL_3                                 ((uint32_t)0x08000000U)         /* Bit27*/
#define ADC_CTRL2_EXTRSEL_4                                 ((uint32_t)0x10000000U)         /* Bit28*/
#define ADC_CTRL2_EXTRSEL_5                                 ((uint32_t)0x20000000U)         /* Bit29*/

#define ADC_CTRL2_TEMPEN                                    ((uint32_t)0x00800000U)         /* Bit[23] Temperature Sensor Enable*/
#define ADC_CTRL2_SWSTRRCH                                  ((uint32_t)0x00400000U)         /* Bit[22] Start Conversion of regular channels*/
#define ADC_CTRL2_SWSTRJCH                                  ((uint32_t)0x00200000U)         /* Bit[21] Start Conversion of injected channels*/
#define ADC_CTRL2_EXTTRIG                                   ((uint32_t)0x00100000U)         /* Bit[20] External event trigger of regular channels enable*/

#define ADC_CTRL2_EXTJSEL                                   ((uint32_t)0x0007E000U)         /* Bit[18:13] External event select for injected group*/
#define ADC_CTRL2_EXTJSEL_0                                 ((uint32_t)0x00002000U)         /* Bit13*/
#define ADC_CTRL2_EXTJSEL_1                                 ((uint32_t)0x00004000U)         /* Bit14*/
#define ADC_CTRL2_EXTJSEL_2                                 ((uint32_t)0x00008000U)         /* Bit15*/
#define ADC_CTRL2_EXTJSEL_3                                 ((uint32_t)0x00010000U)         /* Bit16*/
#define ADC_CTRL2_EXTJSEL_4                                 ((uint32_t)0x00020000U)         /* Bit17*/
#define ADC_CTRL2_EXTJSEL_5                                 ((uint32_t)0x00040000U)         /* Bit18*/

#define ADC_CTRL2_JEXTTRIG                                  ((uint32_t)0x00001000U)         /* Bit[12] External event trigger of injected channels enable*/
#define ADC_CTRL2_ALIG                                      ((uint32_t)0x00000800U)         /* Bit[11] Data Alignment*/

#define ADC_CTRL2_EXTPJSEL                                  ((uint32_t)0x00000600U)         /* Bit[10:9] External trigger enable and polarity selection for injected channels*/
#define ADC_CTRL2_EXTPJSEL_0                                ((uint32_t)0x00000200U)         /* Bit9*/
#define ADC_CTRL2_EXTPJSEL_1                                ((uint32_t)0x00000400U)         /* Bit10*/

#define ADC_CTRL2_DMAMD                                     ((uint32_t)0x00000180U)         /* Bit[8:7] DMA mode*/
#define ADC_CTRL2_DMAMD_0                                   ((uint32_t)0x00000080U)         /* Bit7*/
#define ADC_CTRL2_DMAMD_1                                   ((uint32_t)0x00000100U)         /* Bit8*/

#define ADC_CTRL2_MDSMU                                     ((uint32_t)0x00000040U)         /* Bit[6] Multi-adc DSMU mode*/

#define ADC_CTRL2_DMNGT                                     ((uint32_t)0x00000030U)         /* Bit[5:4] Data management configuration for regular conversion data*/
#define ADC_CTRL2_DMNGT_0                                   ((uint32_t)0x00000010U)         /* Bit4*/
#define ADC_CTRL2_DMNGT_1                                   ((uint32_t)0x00000020U)         /* Bit5*/

#define ADC_CTRL2_ENCAL                                     ((uint32_t)0x00000004U)         /* Bit[2] A/D Calibration */
#define ADC_CTRL2_CTU                                       ((uint32_t)0x00000002U)         /* Bit[1] Continuous Conversion*/
#define ADC_CTRL2_ON                                        ((uint32_t)0x00000001U)         /* Bit[0] A/D Converter ON / OFF */

/*******************  Bit definition for ADC_CTRL3 register  ********************/
#define ADC_CTRL3_GCOMP_SATEN                               ((uint32_t)0x20000000U)         /* Bit[29] Gain compensation saturation enable*/
#define ADC_CTRL3_GCOMPEN                                   ((uint32_t)0x10000000U)         /* Bit[28] Gain compensation Enable*/

#define ADC_CTRL3_SWJSTOP                                   ((uint32_t)0x08000000U)         /* Bit[27] Stop Conversion of injected channels*/
#define ADC_CTRL3_SWRSTOP                                   ((uint32_t)0x04000000U)         /* Bit[26] Stop Conversion of regular channels*/

#define ADC_CTRL3_JSTART                                    ((uint32_t)0x02000000U)         /* Bit[25] ADC start of injected conversion*/
#define ADC_CTRL3_RSTART                                    ((uint32_t)0x01000000U)         /* Bit[24] ADC start of regular conversion*/

#define ADC_CTRL3_VBATMEN                                   ((uint32_t)0x00000200U)         /* Bit[9] Vbat monitor enable*/
#define ADC_CTRL3_VREFINTEN                                 ((uint32_t)0x00000100U)         /* Bit[8] Internal Vrefence Voltage enable*/

#define ADC_CTRL3_BPCAL                                     ((uint32_t)0x00000080U)         /* Bit[7] Bypass calibration*/

#define ADC_CTRL3_PDRDY                                     ((uint32_t)0x00000040U)         /* Bit[6] 6.0*/
#define ADC_CTRL3_RDY                                       ((uint32_t)0x00000020U)         /* Bit[5] 5.0*/

#define ADC_CTRL3_CLOCKMOD                                  ((uint32_t)0x00000010U)         /* Bit[4] Clock Mode*/

#define ADC_CTRL3_RES                                       ((uint32_t)0x00000002U)         /* Bit[1] Data resolution*/

/******************  Bit definition for ADC_SAMPT1 register  *******************/
#define ADC_SAMPT1_SAMP0                                    ((uint32_t)0x0000000FU)        /* SAMP0[3:0] bits (Channel 0 Sample time selection) */
#define ADC_SAMPT1_SAMP0_0                                  ((uint32_t)0x00000001U)        /* Bit 0 */
#define ADC_SAMPT1_SAMP0_1                                  ((uint32_t)0x00000002U)        /* Bit 1 */
#define ADC_SAMPT1_SAMP0_2                                  ((uint32_t)0x00000004U)        /* Bit 2 */
#define ADC_SAMPT1_SAMP0_3                                  ((uint32_t)0x00000008U)        /* Bit 3 */

#define ADC_SAMPT1_SAMP1                                    ((uint32_t)0x000000F0U)        /* SAMP1[3:0] bits (Channel 1 Sample time selection) */
#define ADC_SAMPT1_SAMP1_0                                  ((uint32_t)0x00000010U)        /* Bit 0 */
#define ADC_SAMPT1_SAMP1_1                                  ((uint32_t)0x00000020U)        /* Bit 1 */
#define ADC_SAMPT1_SAMP1_2                                  ((uint32_t)0x00000040U)        /* Bit 2 */
#define ADC_SAMPT1_SAMP1_3                                  ((uint32_t)0x00000080U)        /* Bit 3 */

#define ADC_SAMPT1_SAMP2                                    ((uint32_t)0x00000F00U)        /* SAMP2[3:0] bits (Channel 2 Sample time selection) */
#define ADC_SAMPT1_SAMP2_0                                  ((uint32_t)0x00000100U)        /* Bit 0 */
#define ADC_SAMPT1_SAMP2_1                                  ((uint32_t)0x00000200U)        /* Bit 1 */
#define ADC_SAMPT1_SAMP2_2                                  ((uint32_t)0x00000400U)        /* Bit 2 */
#define ADC_SAMPT1_SAMP2_3                                  ((uint32_t)0x00000800U)        /* Bit 3 */

#define ADC_SAMPT1_SAMP3                                    ((uint32_t)0x0000F000U)        /* SAMP3[3:0] bits (Channel 3 Sample time selection) */
#define ADC_SAMPT1_SAMP3_0                                  ((uint32_t)0x00001000U)        /* Bit 0 */
#define ADC_SAMPT1_SAMP3_1                                  ((uint32_t)0x00002000U)        /* Bit 1 */
#define ADC_SAMPT1_SAMP3_2                                  ((uint32_t)0x00004000U)        /* Bit 2 */
#define ADC_SAMPT1_SAMP3_3                                  ((uint32_t)0x00008000U)        /* Bit 3 */

#define ADC_SAMPT1_SAMP4                                    ((uint32_t)0x000F0000U)        /* SAMP4[3:0] bits (Channel 4 Sample time selection) */
#define ADC_SAMPT1_SAMP4_0                                  ((uint32_t)0x00010000U)        /* Bit 0 */
#define ADC_SAMPT1_SAMP4_1                                  ((uint32_t)0x00020000U)        /* Bit 1 */
#define ADC_SAMPT1_SAMP4_2                                  ((uint32_t)0x00040000U)        /* Bit 2 */
#define ADC_SAMPT1_SAMP4_3                                  ((uint32_t)0x00080000U)        /* Bit 3 */

#define ADC_SAMPT1_SAMP5                                    ((uint32_t)0x00F00000U)        /* SAMP5[3:0] bits (Channel 5 Sample time selection) */
#define ADC_SAMPT1_SAMP5_0                                  ((uint32_t)0x00100000U)        /* Bit 0 */
#define ADC_SAMPT1_SAMP5_1                                  ((uint32_t)0x00200000U)        /* Bit 1 */
#define ADC_SAMPT1_SAMP5_2                                  ((uint32_t)0x00400000U)        /* Bit 2 */
#define ADC_SAMPT1_SAMP5_3                                  ((uint32_t)0x00800000U)        /* Bit 3 */

#define ADC_SAMPT1_SAMP6                                    ((uint32_t)0x0F000000U)        /* SAMP6[3:0] bits (Channel 6 Sample time selection) */
#define ADC_SAMPT1_SAMP6_0                                  ((uint32_t)0x01000000U)        /* Bit 0 */
#define ADC_SAMPT1_SAMP6_1                                  ((uint32_t)0x02000000U)        /* Bit 1 */
#define ADC_SAMPT1_SAMP6_2                                  ((uint32_t)0x04000000U)        /* Bit 2 */
#define ADC_SAMPT1_SAMP6_3                                  ((uint32_t)0x08000000U)        /* Bit 3 */

#define ADC_SAMPT1_SAMP7                                    ((uint32_t)0xF0000000U)        /* SAMP7[3:0] bits (Channel 7 Sample time selection) */
#define ADC_SAMPT1_SAMP7_0                                  ((uint32_t)0x10000000U)        /* Bit 0 */
#define ADC_SAMPT1_SAMP7_1                                  ((uint32_t)0x20000000U)        /* Bit 1 */
#define ADC_SAMPT1_SAMP7_2                                  ((uint32_t)0x40000000U)        /* Bit 2 */
#define ADC_SAMPT1_SAMP7_3                                  ((uint32_t)0x80000000U)        /* Bit 3 */

/******************  Bit definition for ADC_SAMPT2 register  *******************/
#define ADC_SAMPT2_SAMP8                                    ((uint32_t)0x0000000FU)        /* SAMP8[3:0] bits (Channel 8 Sample time selection) */
#define ADC_SAMPT2_SAMP8_0                                  ((uint32_t)0x00000001U)        /* Bit 0 */
#define ADC_SAMPT2_SAMP8_1                                  ((uint32_t)0x00000002U)        /* Bit 1 */
#define ADC_SAMPT2_SAMP8_2                                  ((uint32_t)0x00000004U)        /* Bit 2 */
#define ADC_SAMPT2_SAMP8_3                                  ((uint32_t)0x00000008U)        /* Bit 3 */

#define ADC_SAMPT2_SAMP9                                    ((uint32_t)0x000000F0U)        /* SAMP9[3:0] bits (Channel 9 Sample time selection) */
#define ADC_SAMPT2_SAMP9_0                                  ((uint32_t)0x00000010U)        /* Bit 0 */
#define ADC_SAMPT2_SAMP9_1                                  ((uint32_t)0x00000020U)        /* Bit 1 */
#define ADC_SAMPT2_SAMP9_2                                  ((uint32_t)0x00000040U)        /* Bit 2 */
#define ADC_SAMPT2_SAMP9_3                                  ((uint32_t)0x00000080U)        /* Bit 3 */

#define ADC_SAMPT2_SAMP10                                   ((uint32_t)0x00000F00U)        /* SAMP10[3:0] bits (Channel 10 Sample time selection) */
#define ADC_SAMPT2_SAMP10_0                                 ((uint32_t)0x00000100U)        /* Bit 0 */
#define ADC_SAMPT2_SAMP10_1                                 ((uint32_t)0x00000200U)        /* Bit 1 */
#define ADC_SAMPT2_SAMP10_2                                 ((uint32_t)0x00000400U)        /* Bit 2 */
#define ADC_SAMPT2_SAMP10_3                                 ((uint32_t)0x00000800U)        /* Bit 3 */

#define ADC_SAMPT2_SAMP11                                   ((uint32_t)0x0000F000U)        /* SAMP11[3:0] bits (Channel 11 Sample time selection) */
#define ADC_SAMPT2_SAMP11_0                                 ((uint32_t)0x00001000U)        /* Bit 0 */
#define ADC_SAMPT2_SAMP11_1                                 ((uint32_t)0x00002000U)        /* Bit 1 */
#define ADC_SAMPT2_SAMP11_2                                 ((uint32_t)0x00004000U)        /* Bit 2 */
#define ADC_SAMPT2_SAMP11_3                                 ((uint32_t)0x00008000U)        /* Bit 3 */

#define ADC_SAMPT2_SAMP12                                   ((uint32_t)0x000F0000U)        /* SAMP12[3:0] bits (Channel 12 Sample time selection) */
#define ADC_SAMPT2_SAMP12_0                                 ((uint32_t)0x00010000U)        /* Bit 0 */
#define ADC_SAMPT2_SAMP12_1                                 ((uint32_t)0x00020000U)        /* Bit 1 */
#define ADC_SAMPT2_SAMP12_2                                 ((uint32_t)0x00040000U)        /* Bit 2 */
#define ADC_SAMPT2_SAMP12_3                                 ((uint32_t)0x00080000U)        /* Bit 3 */

#define ADC_SAMPT2_SAMP13                                   ((uint32_t)0x00F00000U)        /* SAMP13[3:0] bits (Channel 13 Sample time selection) */
#define ADC_SAMPT2_SAMP13_0                                 ((uint32_t)0x00100000U)        /* Bit 0 */
#define ADC_SAMPT2_SAMP13_1                                 ((uint32_t)0x00200000U)        /* Bit 1 */
#define ADC_SAMPT2_SAMP13_2                                 ((uint32_t)0x00400000U)        /* Bit 2 */
#define ADC_SAMPT2_SAMP13_3                                 ((uint32_t)0x00800000U)        /* Bit 3 */

#define ADC_SAMPT2_SAMP14                                   ((uint32_t)0x0F000000U)        /* SAMP14[3:0] bits (Channel 14 Sample time selection) */
#define ADC_SAMPT2_SAMP14_0                                 ((uint32_t)0x01000000U)        /* Bit 0 */
#define ADC_SAMPT2_SAMP14_1                                 ((uint32_t)0x02000000U)        /* Bit 1 */
#define ADC_SAMPT2_SAMP14_2                                 ((uint32_t)0x04000000U)        /* Bit 2 */
#define ADC_SAMPT2_SAMP14_3                                 ((uint32_t)0x08000000U)        /* Bit 3 */

#define ADC_SAMPT2_SAMP15                                   ((uint32_t)0xF0000000U)        /* SAMP15[3:0] bits (Channel 15 Sample time selection) */
#define ADC_SAMPT2_SAMP15_0                                 ((uint32_t)0x10000000U)        /* Bit 0 */
#define ADC_SAMPT2_SAMP15_1                                 ((uint32_t)0x20000000U)        /* Bit 1 */
#define ADC_SAMPT2_SAMP15_2                                 ((uint32_t)0x40000000U)        /* Bit 2 */
#define ADC_SAMPT2_SAMP15_3                                 ((uint32_t)0x80000000U)        /* Bit 3 */

/******************  Bit definition for ADC_SAMPT3 register  *******************/
#define ADC_SAMPT3_SAMP16                                   ((uint32_t)0x0000000FU)        /* SAMP16[3:0] bits (Channel 16 Sample time selection) */
#define ADC_SAMPT3_SAMP16_0                                 ((uint32_t)0x00000001U)        /* Bit 0 */
#define ADC_SAMPT3_SAMP16_1                                 ((uint32_t)0x00000002U)        /* Bit 1 */
#define ADC_SAMPT3_SAMP16_2                                 ((uint32_t)0x00000004U)        /* Bit 2 */
#define ADC_SAMPT3_SAMP16_3                                 ((uint32_t)0x00000008U)        /* Bit 3 */

#define ADC_SAMPT3_SAMP17                                   ((uint32_t)0x000000F0U)        /* SAMP17[3:0] bits (Channel 17 Sample time selection) */
#define ADC_SAMPT3_SAMP17_0                                 ((uint32_t)0x00000010U)        /* Bit 0 */
#define ADC_SAMPT3_SAMP17_1                                 ((uint32_t)0x00000020U)        /* Bit 1 */
#define ADC_SAMPT3_SAMP17_2                                 ((uint32_t)0x00000040U)        /* Bit 2 */
#define ADC_SAMPT3_SAMP17_3                                 ((uint32_t)0x00000080U)        /* Bit 3 */

#define ADC_SAMPT3_SAMP18                                   ((uint32_t)0x00000F00U)        /* SAMP18[3:0] bits (Channel 18 Sample time selection) */
#define ADC_SAMPT3_SAMP18_0                                 ((uint32_t)0x00000100U)        /* Bit 0 */
#define ADC_SAMPT3_SAMP18_1                                 ((uint32_t)0x00000200U)        /* Bit 1 */
#define ADC_SAMPT3_SAMP18_2                                 ((uint32_t)0x00000400U)        /* Bit 2 */
#define ADC_SAMPT3_SAMP18_3                                 ((uint32_t)0x00000800U)        /* Bit 3 */

#define ADC_SAMPT3_SAMP19                                   ((uint32_t)0x0000F000U)        /* SAMP19[3:0] bits (Channel 19 Sample time selection) */
#define ADC_SAMPT3_SAMP19_0                                 ((uint32_t)0x00001000U)        /* Bit 0 */
#define ADC_SAMPT3_SAMP19_1                                 ((uint32_t)0x00002000U)        /* Bit 1 */
#define ADC_SAMPT3_SAMP19_2                                 ((uint32_t)0x00004000U)        /* Bit 2 */
#define ADC_SAMPT3_SAMP19_3                                 ((uint32_t)0x00008000U)        /* Bit 3 */

/********************  Bit definition for ADC_DIFSEL register  *****************/
#define ADC_DIFSEL_DIFSEL                                   ((uint32_t)0x000FFFFEU)        /* SAMP19[3:0] bits (Differential mode for channels 19 to 1) */
#define ADC_DIFSEL_DIFSEL_CH1                               ((uint32_t)0x00000002U)        /* Bit1 */ 
#define ADC_DIFSEL_DIFSEL_CH2                               ((uint32_t)0x00000004U)        /* Bit2 */ 
#define ADC_DIFSEL_DIFSEL_CH3                               ((uint32_t)0x00000008U)        /* Bit3 */ 
#define ADC_DIFSEL_DIFSEL_CH4                               ((uint32_t)0x00000010U)        /* Bit4 */ 
#define ADC_DIFSEL_DIFSEL_CH5                               ((uint32_t)0x00000020U)        /* Bit5 */ 
#define ADC_DIFSEL_DIFSEL_CH6                               ((uint32_t)0x00000040U)        /* Bit6 */ 
#define ADC_DIFSEL_DIFSEL_CH7                               ((uint32_t)0x00000080U)        /* Bit7 */ 
#define ADC_DIFSEL_DIFSEL_CH8                               ((uint32_t)0x00000100U)        /* Bit8 */ 
#define ADC_DIFSEL_DIFSEL_CH9                               ((uint32_t)0x00000200U)        /* Bit9 */ 
#define ADC_DIFSEL_DIFSEL_CH10                              ((uint32_t)0x00000400U)        /* Bit10 */
#define ADC_DIFSEL_DIFSEL_CH11                              ((uint32_t)0x00000800U)        /* Bit11 */
#define ADC_DIFSEL_DIFSEL_CH12                              ((uint32_t)0x00001000U)        /* Bit12 */
#define ADC_DIFSEL_DIFSEL_CH13                              ((uint32_t)0x00002000U)        /* Bit13 */
#define ADC_DIFSEL_DIFSEL_CH14                              ((uint32_t)0x00004000U)        /* Bit14 */
#define ADC_DIFSEL_DIFSEL_CH15                              ((uint32_t)0x00008000U)        /* Bit15 */
#define ADC_DIFSEL_DIFSEL_CH16                              ((uint32_t)0x00010000U)        /* Bit16 */
#define ADC_DIFSEL_DIFSEL_CH17                              ((uint32_t)0x00020000U)        /* Bit17 */
#define ADC_DIFSEL_DIFSEL_CH18                              ((uint32_t)0x00040000U)        /* Bit18 */
#define ADC_DIFSEL_DIFSEL_CH19                              ((uint32_t)0x00080000U)        /* Bit19 */

/********************  Bit definition for ADC_AWDOTIM register  ***************/
#define ADC_AWDCTRL_AWD3TIMEN                               ((uint32_t)0x00000004U)        /* Bit[2] Analog watchdog 3 event to timer enable*/
#define ADC_AWDCTRL_AWD2TIMEN                               ((uint32_t)0x00000002U)        /* Bit[1] Analog watchdog 2 event to timer enable*/
#define ADC_AWDCTRL_AWD1TIMEN                               ((uint32_t)0x00000001U)        /* Bit[0] Analog watchdog 1 event to timer enable*/


/******************  Bit definition for ADC_OFFSET1 register  *******************/
#define ADC_OFFSET1_OFFSCH1DAT                              ((uint32_t)0x00000FFFU)        /* ADC offset number 1 offset date */
#define ADC_OFFSET1_OFFSCH1DIR                              ((uint32_t)0x01000000U)        /* ADC offset number 1 positive */
#define ADC_OFFSET1_OFFSCH1SATEN                            ((uint32_t)0x02000000U)        /* ADC offset number 1 saturation enable */

#define ADC_OFFSET1_OFFSCH1CH                               ((uint32_t)0x7C000000U)        /* OFFSCH1CH[4:0] bits (ADC offset number 1 channel selection) */
#define ADC_OFFSET1_OFFSCH1CH_0                             ((uint32_t)0x04000000U)        /* Bit 0 */
#define ADC_OFFSET1_OFFSCH1CH_1                             ((uint32_t)0x08000000U)        /* Bit 1 */
#define ADC_OFFSET1_OFFSCH1CH_2                             ((uint32_t)0x10000000U)        /* Bit 2 */
#define ADC_OFFSET1_OFFSCH1CH_3                             ((uint32_t)0x20000000U)        /* Bit 3 */
#define ADC_OFFSET1_OFFSCH1CH_4                             ((uint32_t)0x40000000U)        /* Bit 4 */

#define ADC_OFFSET1_OFFSCH1EN                               ((uint32_t)0x80000000U)        /* ADC offset number 1 offset enable */

/******************  Bit definition for ADC_OFFSET2 register  *******************/
#define ADC_OFFSET2_OFFSCH2DAT                              ((uint32_t)0x00000FFFU)        /* ADC offset number 2 offset date */
#define ADC_OFFSET2_OFFSCH2DIR                              ((uint32_t)0x01000000U)        /* ADC offset number 2 positive */
#define ADC_OFFSET2_OFFSCH2SATEN                            ((uint32_t)0x02000000U)        /* ADC offset number 2 saturation enable */

#define ADC_OFFSET2_OFFSCH2CH                               ((uint32_t)0x7C000000U)        /* OFFSCH2CH[4:0] bits (ADC offset number 2 channel selection) */
#define ADC_OFFSET2_OFFSCH2CH_0                             ((uint32_t)0x04000000U)        /* Bit 0 */
#define ADC_OFFSET2_OFFSCH2CH_1                             ((uint32_t)0x08000000U)        /* Bit 1 */
#define ADC_OFFSET2_OFFSCH2CH_2                             ((uint32_t)0x10000000U)        /* Bit 2 */
#define ADC_OFFSET2_OFFSCH2CH_3                             ((uint32_t)0x20000000U)        /* Bit 3 */
#define ADC_OFFSET2_OFFSCH2CH_4                             ((uint32_t)0x40000000U)        /* Bit 4 */

#define ADC_OFFSET2_OFFSCH2EN                               ((uint32_t)0x80000000U)        /* ADC offset number 2 offset enable */

/******************  Bit definition for ADC_OFFSET3 register  *******************/
#define ADC_OFFSET3_OFFSCH3DAT                              ((uint32_t)0x00000FFFU)        /* ADC offset number 3 offset date */
#define ADC_OFFSET3_OFFSCH3DIR                              ((uint32_t)0x01000000U)        /* ADC offset number 3 positive */
#define ADC_OFFSET3_OFFSCH3SATEN                            ((uint32_t)0x02000000U)        /* ADC offset number 3 saturation enable */

#define ADC_OFFSET3_OFFSCH3CH                               ((uint32_t)0x7C000000U)        /* OFFSCH3CH[4:0] bits (ADC offset number 3 channel selection) */
#define ADC_OFFSET3_OFFSCH3CH_0                             ((uint32_t)0x04000000U)        /* Bit 0 */
#define ADC_OFFSET3_OFFSCH3CH_1                             ((uint32_t)0x08000000U)        /* Bit 1 */
#define ADC_OFFSET3_OFFSCH3CH_2                             ((uint32_t)0x10000000U)        /* Bit 2 */
#define ADC_OFFSET3_OFFSCH3CH_3                             ((uint32_t)0x20000000U)        /* Bit 3 */
#define ADC_OFFSET3_OFFSCH3CH_4                             ((uint32_t)0x40000000U)        /* Bit 4 */

#define ADC_OFFSET3_OFFSCH3EN                               ((uint32_t)0x80000000U)        /* ADC offset number 3 offset enable */

/******************  Bit definition for ADC_OFFSET4 register  *******************/
#define ADC_OFFSET4_OFFSCH4DAT                              ((uint32_t)0x00000FFFU)        /* ADC offset number 4 offset date */
#define ADC_OFFSET4_OFFSCH4DIR                              ((uint32_t)0x01000000U)        /* ADC offset number 4 positive */
#define ADC_OFFSET4_OFFSCH4SATEN                            ((uint32_t)0x02000000U)        /* ADC offset number 4 saturation enable */

#define ADC_OFFSET4_OFFSCH4CH                               ((uint32_t)0x7C000000U)        /* OFFSCH4CH[4:0] bits (ADC offset number 4 channel selection) */
#define ADC_OFFSET4_OFFSCH4CH_0                             ((uint32_t)0x04000000U)        /* Bit 0 */
#define ADC_OFFSET4_OFFSCH4CH_1                             ((uint32_t)0x08000000U)        /* Bit 1 */
#define ADC_OFFSET4_OFFSCH4CH_2                             ((uint32_t)0x10000000U)        /* Bit 2 */
#define ADC_OFFSET4_OFFSCH4CH_3                             ((uint32_t)0x20000000U)        /* Bit 3 */
#define ADC_OFFSET4_OFFSCH4CH_4                             ((uint32_t)0x40000000U)        /* Bit 4 */

#define ADC_OFFSET4_OFFSCH1EN                               ((uint32_t)0x80000000U)        /* ADC offset number 4 offset enable */

/****************** Bit definition for ADC_AWD1HIGH register  *******************/
#define ADC_AWD1HIGH_HTH                                    ((uint32_t)0x00000FFFU)        /* Analog watchdog 1 high threshold */

/****************** Bit definition for ADC_AWD1LOW register  ********************/
#define ADC_AWD1LOW_LTH                                     ((uint32_t)0x00000FFFU)        /* Analog watchdog 1 low threshold */

#define ADC_AWD1LOW_AWDFIL                                  ((uint32_t)0x00007000U)        /* AWDFIL[2:0] bits (Analog watchdog 1 Filter value) */
#define ADC_AWD1LOW_AWDFIL_0                                ((uint32_t)0x00001000U)        /* Bit 0 */
#define ADC_AWD1LOW_AWDFIL_1                                ((uint32_t)0x00002000U)        /* Bit 1 */
#define ADC_AWD1LOW_AWDFIL_2                                ((uint32_t)0x00004000U)        /* Bit 2 */

/******************* Bit definition for ADC_AWD2HIGH register  *****************/
#define ADC_AWD2HIGH_HTH                                    ((uint32_t)0x00000FFFU)        /* Analog watchdog 2 high threshold */

/******************* Bit definition for ADC_AWD2LOW register  ******************/
#define ADC_AWD2LOW_LTH                                     ((uint32_t)0x00000FFFU)        /* Analog watchdog 2 low threshold */

/*******************  Bit definition for ADC_AWD3HIGH register *****************/
#define ADC_AWD3HIGH_HTH                                    ((uint32_t)0x00000FFFU)        /* Analog watchdog 3 high threshold */

/******************* Bit definition for ADC_AWD3LOW register  ******************/
#define ADC_AWD3LOW_LTH                                     ((uint32_t)0x00000FFFU)        /* Analog watchdog 3 low threshold */

/********************  Bit definition for ADC_AWD2EN register  ****************/
#define ADC_AWD2EN_AWD2EN                                   ((uint32_t)0x000FFFFFU)        /* AWD2EN[19:0] bits (ADC analog watchdog 2 monitored channel selection) */
#define ADC_AWD2EN_AWD2EN_CH0                               ((uint32_t)0x00000001U)        /* ADC analog watchdog 2 monitored channel 0 */
#define ADC_AWD2EN_AWD2EN_CH1                               ((uint32_t)0x00000002U)        /* ADC analog watchdog 2 monitored channel 1 */
#define ADC_AWD2EN_AWD2EN_CH2                               ((uint32_t)0x00000004U)        /* ADC analog watchdog 2 monitored channel 2 */
#define ADC_AWD2EN_AWD2EN_CH3                               ((uint32_t)0x00000008U)        /* ADC analog watchdog 2 monitored channel 3 */
#define ADC_AWD2EN_AWD2EN_CH4                               ((uint32_t)0x00000010U)        /* ADC analog watchdog 2 monitored channel 4 */
#define ADC_AWD2EN_AWD2EN_CH5                               ((uint32_t)0x00000020U)        /* ADC analog watchdog 2 monitored channel 5 */
#define ADC_AWD2EN_AWD2EN_CH6                               ((uint32_t)0x00000040U)        /* ADC analog watchdog 2 monitored channel 6 */
#define ADC_AWD2EN_AWD2EN_CH7                               ((uint32_t)0x00000080U)        /* ADC analog watchdog 2 monitored channel 7 */
#define ADC_AWD2EN_AWD2EN_CH8                               ((uint32_t)0x00000100U)        /* ADC analog watchdog 2 monitored channel 8 */
#define ADC_AWD2EN_AWD2EN_CH9                               ((uint32_t)0x00000200U)        /* ADC analog watchdog 2 monitored channel 9 */
#define ADC_AWD2EN_AWD2EN_CH10                              ((uint32_t)0x00000400U)        /* ADC analog watchdog 2 monitored channel 10 */
#define ADC_AWD2EN_AWD2EN_CH11                              ((uint32_t)0x00000800U)        /* ADC analog watchdog 2 monitored channel 11 */
#define ADC_AWD2EN_AWD2EN_CH12                              ((uint32_t)0x00001000U)        /* ADC analog watchdog 2 monitored channel 12 */
#define ADC_AWD2EN_AWD2EN_CH13                              ((uint32_t)0x00002000U)        /* ADC analog watchdog 2 monitored channel 13 */
#define ADC_AWD2EN_AWD2EN_CH14                              ((uint32_t)0x00004000U)        /* ADC analog watchdog 2 monitored channel 14 */
#define ADC_AWD2EN_AWD2EN_CH15                              ((uint32_t)0x00008000U)        /* ADC analog watchdog 2 monitored channel 15 */
#define ADC_AWD2EN_AWD2EN_CH16                              ((uint32_t)0x00010000U)        /* ADC analog watchdog 2 monitored channel 16 */
#define ADC_AWD2EN_AWD2EN_CH17                              ((uint32_t)0x00020000U)        /* ADC analog watchdog 2 monitored channel 17 */
#define ADC_AWD2EN_AWD2EN_CH18                              ((uint32_t)0x00040000U)        /* ADC analog watchdog 2 monitored channel 18 */
#define ADC_AWD2EN_AWD2EN_CH19                              ((uint32_t)0x00080000U)        /* ADC analog watchdog 2 monitored channel 19 */

/********************  Bit definition for ADC_AWD3EN register  ****************/
#define ADC_AWD3EN_AWD3EN                                   ((uint32_t)0x000FFFFFU)        /* AWD3EN[19:0] bits (ADC analog watchdog 3 monitored channel selection) */
#define ADC_AWD3EN_AWD3EN_CH0                               ((uint32_t)0x00000001U)        /* ADC analog watchdog 3 monitored channel 0 */
#define ADC_AWD3EN_AWD3EN_CH1                               ((uint32_t)0x00000002U)        /* ADC analog watchdog 3 monitored channel 1 */
#define ADC_AWD3EN_AWD3EN_CH2                               ((uint32_t)0x00000004U)        /* ADC analog watchdog 3 monitored channel 2 */
#define ADC_AWD3EN_AWD3EN_CH3                               ((uint32_t)0x00000008U)        /* ADC analog watchdog 3 monitored channel 3 */
#define ADC_AWD3EN_AWD3EN_CH4                               ((uint32_t)0x00000010U)        /* ADC analog watchdog 3 monitored channel 4 */
#define ADC_AWD3EN_AWD3EN_CH5                               ((uint32_t)0x00000020U)        /* ADC analog watchdog 3 monitored channel 5 */
#define ADC_AWD3EN_AWD3EN_CH6                               ((uint32_t)0x00000040U)        /* ADC analog watchdog 3 monitored channel 6 */
#define ADC_AWD3EN_AWD3EN_CH7                               ((uint32_t)0x00000080U)        /* ADC analog watchdog 3 monitored channel 7 */
#define ADC_AWD3EN_AWD3EN_CH8                               ((uint32_t)0x00000100U)        /* ADC analog watchdog 3 monitored channel 8 */
#define ADC_AWD3EN_AWD3EN_CH9                               ((uint32_t)0x00000200U)        /* ADC analog watchdog 3 monitored channel 9 */
#define ADC_AWD3EN_AWD3EN_CH10                              ((uint32_t)0x00000400U)        /* ADC analog watchdog 3 monitored channel 10 */
#define ADC_AWD3EN_AWD3EN_CH11                              ((uint32_t)0x00000800U)        /* ADC analog watchdog 3 monitored channel 11 */
#define ADC_AWD3EN_AWD3EN_CH12                              ((uint32_t)0x00001000U)        /* ADC analog watchdog 3 monitored channel 12 */
#define ADC_AWD3EN_AWD3EN_CH13                              ((uint32_t)0x00002000U)        /* ADC analog watchdog 3 monitored channel 13 */
#define ADC_AWD3EN_AWD3EN_CH14                              ((uint32_t)0x00004000U)        /* ADC analog watchdog 3 monitored channel 14 */
#define ADC_AWD3EN_AWD3EN_CH15                              ((uint32_t)0x00008000U)        /* ADC analog watchdog 3 monitored channel 15 */
#define ADC_AWD3EN_AWD3EN_CH16                              ((uint32_t)0x00010000U)        /* ADC analog watchdog 3 monitored channel 16 */
#define ADC_AWD3EN_AWD3EN_CH17                              ((uint32_t)0x00020000U)        /* ADC analog watchdog 3 monitored channel 17 */
#define ADC_AWD3EN_AWD3EN_CH18                              ((uint32_t)0x00040000U)        /* ADC analog watchdog 3 monitored channel 18 */
#define ADC_AWD3EN_AWD3EN_CH19                              ((uint32_t)0x00080000U)        /* ADC analog watchdog 3 monitored channel 19 */

/********************  Bit definition for ADC_AWD2INTEN register  ****************/
#define ADC_AWD2INTEN                                       ((uint32_t)0x000FFFFFU)        /* AWD2INTEN[19:0] bits (ADC analog watchdog 2 channel interrupt enable) */
#define ADC_AWD2INTEN_CH0                                   ((uint32_t)0x00000001U)        /* ADC analog watchdog 2 channel0 interrupt enable */
#define ADC_AWD2INTEN_CH1                                   ((uint32_t)0x00000002U)        /* ADC analog watchdog 2 channel1 interrupt enable */
#define ADC_AWD2INTEN_CH2                                   ((uint32_t)0x00000004U)        /* ADC analog watchdog 2 channel2 interrupt enable */
#define ADC_AWD2INTEN_CH3                                   ((uint32_t)0x00000008U)        /* ADC analog watchdog 2 channel3 interrupt enable */
#define ADC_AWD2INTEN_CH4                                   ((uint32_t)0x00000010U)        /* ADC analog watchdog 2 channel4 interrupt enable */
#define ADC_AWD2INTEN_CH5                                   ((uint32_t)0x00000020U)        /* ADC analog watchdog 2 channel5 interrupt enable */
#define ADC_AWD2INTEN_CH6                                   ((uint32_t)0x00000040U)        /* ADC analog watchdog 2 channel6 interrupt enable */
#define ADC_AWD2INTEN_CH7                                   ((uint32_t)0x00000080U)        /* ADC analog watchdog 2 channel7 interrupt enable */
#define ADC_AWD2INTEN_CH8                                   ((uint32_t)0x00000100U)        /* ADC analog watchdog 2 channel8 interrupt enable */
#define ADC_AWD2INTEN_CH9                                   ((uint32_t)0x00000200U)        /* ADC analog watchdog 2 channel9 interrupt enable */
#define ADC_AWD2INTEN_CH10                                  ((uint32_t)0x00000400U)        /* ADC analog watchdog 2 channel10 interrupt enable */
#define ADC_AWD2INTEN_CH11                                  ((uint32_t)0x00000800U)        /* ADC analog watchdog 2 channel11 interrupt enable */
#define ADC_AWD2INTEN_CH12                                  ((uint32_t)0x00001000U)        /* ADC analog watchdog 2 channel12 interrupt enable */
#define ADC_AWD2INTEN_CH13                                  ((uint32_t)0x00002000U)        /* ADC analog watchdog 2 channel13 interrupt enable */
#define ADC_AWD2INTEN_CH14                                  ((uint32_t)0x00004000U)        /* ADC analog watchdog 2 channel14 interrupt enable */
#define ADC_AWD2INTEN_CH15                                  ((uint32_t)0x00008000U)        /* ADC analog watchdog 2 channel15 interrupt enable */
#define ADC_AWD2INTEN_CH16                                  ((uint32_t)0x00010000U)        /* ADC analog watchdog 2 channel16 interrupt enable */
#define ADC_AWD2INTEN_CH17                                  ((uint32_t)0x00020000U)        /* ADC analog watchdog 2 channel17 interrupt enable */
#define ADC_AWD2INTEN_CH18                                  ((uint32_t)0x00040000U)        /* ADC analog watchdog 2 channel18 interrupt enable */
#define ADC_AWD2INTEN_CH19                                  ((uint32_t)0x00080000U)        /* ADC analog watchdog 2 channel19 interrupt enable */

/********************  Bit definition for ADC_AWD3EN register  ****************/
#define ADC_AWD3INTEN                                       ((uint32_t)0x000FFFFFU)        /* AWD3INTEN[19:0] bits (ADC analog watchdog 3 channel interrupt enable) */
#define ADC_AWD3INTEN_CH0                                   ((uint32_t)0x00000001U)        /* ADC analog watchdog 3 channel0 interrupt enable */
#define ADC_AWD3INTEN_CH1                                   ((uint32_t)0x00000002U)        /* ADC analog watchdog 3 channel1 interrupt enable */
#define ADC_AWD3INTEN_CH2                                   ((uint32_t)0x00000004U)        /* ADC analog watchdog 3 channel2 interrupt enable */
#define ADC_AWD3INTEN_CH3                                   ((uint32_t)0x00000008U)        /* ADC analog watchdog 3 channel3 interrupt enable */
#define ADC_AWD3INTEN_CH4                                   ((uint32_t)0x00000010U)        /* ADC analog watchdog 3 channel4 interrupt enable */
#define ADC_AWD3INTEN_CH5                                   ((uint32_t)0x00000020U)        /* ADC analog watchdog 3 channel5 interrupt enable */
#define ADC_AWD3INTEN_CH6                                   ((uint32_t)0x00000040U)        /* ADC analog watchdog 3 channel6 interrupt enable */
#define ADC_AWD3INTEN_CH7                                   ((uint32_t)0x00000080U)        /* ADC analog watchdog 3 channel7 interrupt enable */
#define ADC_AWD3INTEN_CH8                                   ((uint32_t)0x00000100U)        /* ADC analog watchdog 3 channel8 interrupt enable */
#define ADC_AWD3INTEN_CH9                                   ((uint32_t)0x00000200U)        /* ADC analog watchdog 3 channel9 interrupt enable */
#define ADC_AWD3INTEN_CH10                                  ((uint32_t)0x00000400U)        /* ADC analog watchdog 3 channel10 interrupt enable */
#define ADC_AWD3INTEN_CH11                                  ((uint32_t)0x00000800U)        /* ADC analog watchdog 3 channel11 interrupt enable */
#define ADC_AWD3INTEN_CH12                                  ((uint32_t)0x00001000U)        /* ADC analog watchdog 3 channel12 interrupt enable */
#define ADC_AWD3INTEN_CH13                                  ((uint32_t)0x00002000U)        /* ADC analog watchdog 3 channel13 interrupt enable */
#define ADC_AWD3INTEN_CH14                                  ((uint32_t)0x00004000U)        /* ADC analog watchdog 3 channel14 interrupt enable */
#define ADC_AWD3INTEN_CH15                                  ((uint32_t)0x00008000U)        /* ADC analog watchdog 3 channel15 interrupt enable */
#define ADC_AWD3INTEN_CH16                                  ((uint32_t)0x00010000U)        /* ADC analog watchdog 3 channel16 interrupt enable */
#define ADC_AWD3INTEN_CH17                                  ((uint32_t)0x00020000U)        /* ADC analog watchdog 3 channel17 interrupt enable */
#define ADC_AWD3INTEN_CH18                                  ((uint32_t)0x00040000U)        /* ADC analog watchdog 3 channel18 interrupt enable */
#define ADC_AWD3INTEN_CH19                                  ((uint32_t)0x00080000U)        /* ADC analog watchdog 3 channel19 interrupt enable */

/********************  Bit definition for ADC_AWD2STS register  ****************/
#define ADC_AWD2STS                                         ((uint32_t)0x000FFFFFU)        /* AWD2FLAG[18:0] bits (ADC analog watchdog 2 status flag) */
#define ADC_AWD2STS_AWD2FLAG_CH0                            ((uint32_t)0x00000001U)        /* ADC analog watchdog 2 channel0 status flag */
#define ADC_AWD2STS_AWD2FLAG_CH1                            ((uint32_t)0x00000002U)        /* ADC analog watchdog 2 channel1 status flag */
#define ADC_AWD2STS_AWD2FLAG_CH2                            ((uint32_t)0x00000004U)        /* ADC analog watchdog 2 channel2 status flag */
#define ADC_AWD2STS_AWD2FLAG_CH3                            ((uint32_t)0x00000008U)        /* ADC analog watchdog 2 channel3 status flag */
#define ADC_AWD2STS_AWD2FLAG_CH4                            ((uint32_t)0x00000010U)        /* ADC analog watchdog 2 channel4 status flag */
#define ADC_AWD2STS_AWD2FLAG_CH5                            ((uint32_t)0x00000020U)        /* ADC analog watchdog 2 channel5 status flag */
#define ADC_AWD2STS_AWD2FLAG_CH6                            ((uint32_t)0x00000040U)        /* ADC analog watchdog 2 channel6 status flag */
#define ADC_AWD2STS_AWD2FLAG_CH7                            ((uint32_t)0x00000080U)        /* ADC analog watchdog 2 channel7 status flag */
#define ADC_AWD2STS_AWD2FLAG_CH8                            ((uint32_t)0x00000100U)        /* ADC analog watchdog 2 channel8 status flag */
#define ADC_AWD2STS_AWD2FLAG_CH9                            ((uint32_t)0x00000200U)        /* ADC analog watchdog 2 channel9 status flag */
#define ADC_AWD2STS_AWD2FLAG_CH10                           ((uint32_t)0x00000400U)        /* ADC analog watchdog 2 channel10 status flag */
#define ADC_AWD2STS_AWD2FLAG_CH11                           ((uint32_t)0x00000800U)        /* ADC analog watchdog 2 channel11 status flag */
#define ADC_AWD2STS_AWD2FLAG_CH12                           ((uint32_t)0x00001000U)        /* ADC analog watchdog 2 channel12 status flag */
#define ADC_AWD2STS_AWD2FLAG_CH13                           ((uint32_t)0x00002000U)        /* ADC analog watchdog 2 channel13 status flag */
#define ADC_AWD2STS_AWD2FLAG_CH14                           ((uint32_t)0x00004000U)        /* ADC analog watchdog 2 channel14 status flag */
#define ADC_AWD2STS_AWD2FLAG_CH15                           ((uint32_t)0x00008000U)        /* ADC analog watchdog 2 channel15 status flag */
#define ADC_AWD2STS_AWD2FLAG_CH16                           ((uint32_t)0x00010000U)        /* ADC analog watchdog 2 channel16 status flag */
#define ADC_AWD2STS_AWD2FLAG_CH17                           ((uint32_t)0x00020000U)        /* ADC analog watchdog 2 channel17 status flag */
#define ADC_AWD2STS_AWD2FLAG_CH18                           ((uint32_t)0x00040000U)        /* ADC analog watchdog 2 channel18 status flag */
#define ADC_AWD2STS_AWD2FLAG_CH19                           ((uint32_t)0x00080000U)        /* ADC analog watchdog 2 channel19 status flag */

/********************  Bit definition for ADC_AWD3STS register  ****************/
#define ADC_AWD3STS                                         ((uint32_t)0x000FFFFFU)        /* AWD3FLAG[19:0] bits (ADC analog watchdog 3 status flag) */
#define ADC_AWD3STS_AWD3FLAG_CH0                            ((uint32_t)0x00000001U)        /* ADC analog watchdog 3 channel0 status flag */
#define ADC_AWD3STS_AWD3FLAG_CH1                            ((uint32_t)0x00000002U)        /* ADC analog watchdog 3 channel1 status flag */
#define ADC_AWD3STS_AWD3FLAG_CH2                            ((uint32_t)0x00000004U)        /* ADC analog watchdog 3 channel2 status flag */
#define ADC_AWD3STS_AWD3FLAG_CH3                            ((uint32_t)0x00000008U)        /* ADC analog watchdog 3 channel3 status flag */
#define ADC_AWD3STS_AWD3FLAG_CH4                            ((uint32_t)0x00000010U)        /* ADC analog watchdog 3 channel4 status flag */
#define ADC_AWD3STS_AWD3FLAG_CH5                            ((uint32_t)0x00000020U)        /* ADC analog watchdog 3 channel5 status flag */
#define ADC_AWD3STS_AWD3FLAG_CH6                            ((uint32_t)0x00000040U)        /* ADC analog watchdog 3 channel6 status flag */
#define ADC_AWD3STS_AWD3FLAG_CH7                            ((uint32_t)0x00000080U)        /* ADC analog watchdog 3 channel7 status flag */
#define ADC_AWD3STS_AWD3FLAG_CH8                            ((uint32_t)0x00000100U)        /* ADC analog watchdog 3 channel8 status flag */
#define ADC_AWD3STS_AWD3FLAG_CH9                            ((uint32_t)0x00000200U)        /* ADC analog watchdog 3 channel9 status flag */
#define ADC_AWD3STS_AWD3FLAG_CH10                           ((uint32_t)0x00000400U)        /* ADC analog watchdog 3 channel10 status flag */
#define ADC_AWD3STS_AWD3FLAG_CH11                           ((uint32_t)0x00000800U)        /* ADC analog watchdog 3 channel11 status flag */
#define ADC_AWD3STS_AWD3FLAG_CH12                           ((uint32_t)0x00001000U)        /* ADC analog watchdog 3 channel12 status flag */
#define ADC_AWD3STS_AWD3FLAG_CH13                           ((uint32_t)0x00002000U)        /* ADC analog watchdog 3 channel13 status flag */
#define ADC_AWD3STS_AWD3FLAG_CH14                           ((uint32_t)0x00004000U)        /* ADC analog watchdog 3 channel14 status flag */
#define ADC_AWD3STS_AWD3FLAG_CH15                           ((uint32_t)0x00008000U)        /* ADC analog watchdog 3 channel15 status flag */
#define ADC_AWD3STS_AWD3FLAG_CH16                           ((uint32_t)0x00010000U)        /* ADC analog watchdog 3 channel16 status flag */
#define ADC_AWD3STS_AWD3FLAG_CH17                           ((uint32_t)0x00020000U)        /* ADC analog watchdog 3 channel17 status flag */
#define ADC_AWD3STS_AWD3FLAG_CH18                           ((uint32_t)0x00040000U)        /* ADC analog watchdog 3 channel18 status flag */
#define ADC_AWD2STS_AWD3FLAG_CH19                           ((uint32_t)0x00080000U)        /* ADC analog watchdog 3 channel19 status flag */

/*******************  Bit definition for ADC_RSEQ1 register  *******************/
#define ADC_RSEQ1_SEQ19                                 ((uint32_t)0x0000001FU)            /* SEQ19[4:0] bits (19th conversion in regular sequence) */
#define ADC_RSEQ1_SEQ19_0                               ((uint32_t)0x00000001U)            /* Bit 0 */
#define ADC_RSEQ1_SEQ19_1                               ((uint32_t)0x00000002U)            /* Bit 1 */
#define ADC_RSEQ1_SEQ19_2                               ((uint32_t)0x00000004U)            /* Bit 2 */
#define ADC_RSEQ1_SEQ19_3                               ((uint32_t)0x00000008U)            /* Bit 3 */
#define ADC_RSEQ1_SEQ19_4                               ((uint32_t)0x00000010U)            /* Bit 4 */
    
#define ADC_RSEQ1_SEQ20                                 ((uint32_t)0x000003E0U)            /* SEQ20[4:0] bits (20th conversion in regular sequence) */
#define ADC_RSEQ1_SEQ20_0                               ((uint32_t)0x00000020U)            /* Bit 0 */
#define ADC_RSEQ1_SEQ20_1                               ((uint32_t)0x00000040U)            /* Bit 1 */
#define ADC_RSEQ1_SEQ20_2                               ((uint32_t)0x00000080U)            /* Bit 2 */
#define ADC_RSEQ1_SEQ20_3                               ((uint32_t)0x00000100U)            /* Bit 3 */
#define ADC_RSEQ1_SEQ20_4                               ((uint32_t)0x00000200U)            /* Bit 4 */
    
#define ADC_RSEQ1_LEN                                   ((uint32_t)0x00007C00U)            /* LEN[4:0] bits (Regular channel sequence length) */
#define ADC_RSEQ1_LEN_0                                 ((uint32_t)0x00000400U)            /* Bit 0 */
#define ADC_RSEQ1_LEN_1                                 ((uint32_t)0x00000800U)            /* Bit 1 */
#define ADC_RSEQ1_LEN_2                                 ((uint32_t)0x00001000U)            /* Bit 2 */
#define ADC_RSEQ1_LEN_3                                 ((uint32_t)0x00002000U)            /* Bit 3 */
#define ADC_RSEQ1_LEN_4                                 ((uint32_t)0x00004000U)            /* Bit 4 */

/*******************  Bit definition for ADC_RSEQ2 register  *******************/
#define ADC_RSEQ2_SEQ13                                 ((uint32_t)0x0000001FU)            /* SEQ13[4:0] bits (13th conversion in regular sequence) */
#define ADC_RSEQ2_SEQ13_0                               ((uint32_t)0x00000001U)            /* Bit 0 */
#define ADC_RSEQ2_SEQ13_1                               ((uint32_t)0x00000002U)            /* Bit 1 */
#define ADC_RSEQ2_SEQ13_2                               ((uint32_t)0x00000004U)            /* Bit 2 */
#define ADC_RSEQ2_SEQ13_3                               ((uint32_t)0x00000008U)            /* Bit 3 */
#define ADC_RSEQ2_SEQ13_4                               ((uint32_t)0x00000010U)            /* Bit 4 */

#define ADC_RSEQ2_SEQ14                                 ((uint32_t)0x000003E0U)            /* SEQ14[4:0] bits (14th conversion in regular sequence) */
#define ADC_RSEQ2_SEQ14_0                               ((uint32_t)0x00000020U)            /* Bit 0 */
#define ADC_RSEQ2_SEQ14_1                               ((uint32_t)0x00000040U)            /* Bit 1 */
#define ADC_RSEQ2_SEQ14_2                               ((uint32_t)0x00000080U)            /* Bit 2 */
#define ADC_RSEQ2_SEQ14_3                               ((uint32_t)0x00000100U)            /* Bit 3 */
#define ADC_RSEQ2_SEQ14_4                               ((uint32_t)0x00000200U)            /* Bit 4 */

#define ADC_RSEQ2_SEQ15                                 ((uint32_t)0x00007C00U)            /* SEQ15[4:0] bits (15th conversion in regular sequence) */
#define ADC_RSEQ2_SEQ15_0                               ((uint32_t)0x00000400U)            /* Bit 0 */
#define ADC_RSEQ2_SEQ15_1                               ((uint32_t)0x00000800U)            /* Bit 1 */
#define ADC_RSEQ2_SEQ15_2                               ((uint32_t)0x00001000U)            /* Bit 2 */
#define ADC_RSEQ2_SEQ15_3                               ((uint32_t)0x00002000U)            /* Bit 3 */
#define ADC_RSEQ2_SEQ15_4                               ((uint32_t)0x00004000U)            /* Bit 4 */

#define ADC_RSEQ2_SEQ16                                 ((uint32_t)0x000F8000U)            /* SEQ16[4:0] bits (16th conversion in regular sequence) */
#define ADC_RSEQ2_SEQ16_0                               ((uint32_t)0x00008000U)            /* Bit 0 */
#define ADC_RSEQ2_SEQ16_1                               ((uint32_t)0x00010000U)            /* Bit 1 */
#define ADC_RSEQ2_SEQ16_2                               ((uint32_t)0x00020000U)            /* Bit 2 */
#define ADC_RSEQ2_SEQ16_3                               ((uint32_t)0x00040000U)            /* Bit 3 */
#define ADC_RSEQ2_SEQ16_4                               ((uint32_t)0x00080000U)            /* Bit 4 */

#define ADC_RSEQ2_SEQ17                                 ((uint32_t)0x01F00000U)            /* SEQ17[4:0] bits (17th conversion in regular sequence) */
#define ADC_RSEQ2_SEQ17_0                               ((uint32_t)0x00100000U)            /* Bit 0 */
#define ADC_RSEQ2_SEQ17_1                               ((uint32_t)0x00200000U)            /* Bit 1 */
#define ADC_RSEQ2_SEQ17_2                               ((uint32_t)0x00400000U)            /* Bit 2 */
#define ADC_RSEQ2_SEQ17_3                               ((uint32_t)0x00800000U)            /* Bit 3 */
#define ADC_RSEQ2_SEQ17_4                               ((uint32_t)0x01000000U)            /* Bit 4 */

#define ADC_RSEQ2_SEQ18                                 ((uint32_t)0x3E000000U)            /* SEQ18[4:0] bits (18th conversion in regular sequence) */
#define ADC_RSEQ2_SEQ18_0                               ((uint32_t)0x02000000U)            /* Bit 0 */
#define ADC_RSEQ2_SEQ18_1                               ((uint32_t)0x04000000U)            /* Bit 1 */
#define ADC_RSEQ2_SEQ18_2                               ((uint32_t)0x08000000U)            /* Bit 2 */
#define ADC_RSEQ2_SEQ18_3                               ((uint32_t)0x10000000U)            /* Bit 3 */
#define ADC_RSEQ2_SEQ18_4                               ((uint32_t)0x20000000U)            /* Bit 4 */

/*******************  Bit definition for ADC_RSEQ3 register  *******************/
#define ADC_RSEQ3_SEQ7                                  ((uint32_t)0x0000001FU)            /* SEQ7[4:0] bits (7th conversion in regular sequence) */
#define ADC_RSEQ3_SEQ7_0                                ((uint32_t)0x00000001U)            /* Bit 0 */
#define ADC_RSEQ3_SEQ7_1                                ((uint32_t)0x00000002U)            /* Bit 1 */
#define ADC_RSEQ3_SEQ7_2                                ((uint32_t)0x00000004U)            /* Bit 2 */
#define ADC_RSEQ3_SEQ7_3                                ((uint32_t)0x00000008U)            /* Bit 3 */
#define ADC_RSEQ3_SEQ7_4                                ((uint32_t)0x00000010U)            /* Bit 4 */

#define ADC_RSEQ3_SEQ8                                  ((uint32_t)0x000003E0U)            /* SEQ8[4:0] bits (8th conversion in regular sequence) */
#define ADC_RSEQ3_SEQ8_0                                ((uint32_t)0x00000020U)            /* Bit 0 */
#define ADC_RSEQ3_SEQ8_1                                ((uint32_t)0x00000040U)            /* Bit 1 */
#define ADC_RSEQ3_SEQ8_2                                ((uint32_t)0x00000080U)            /* Bit 2 */
#define ADC_RSEQ3_SEQ8_3                                ((uint32_t)0x00000100U)            /* Bit 3 */
#define ADC_RSEQ3_SEQ8_4                                ((uint32_t)0x00000200U)            /* Bit 4 */

#define ADC_RSEQ3_SEQ9                                  ((uint32_t)0x00007C00U)            /* SEQ9[4:0] bits (9th conversion in regular sequence) */
#define ADC_RSEQ3_SEQ9_0                                ((uint32_t)0x00000400U)            /* Bit 0 */
#define ADC_RSEQ3_SEQ9_1                                ((uint32_t)0x00000800U)            /* Bit 1 */
#define ADC_RSEQ3_SEQ9_2                                ((uint32_t)0x00001000U)            /* Bit 2 */
#define ADC_RSEQ3_SEQ9_3                                ((uint32_t)0x00002000U)            /* Bit 3 */
#define ADC_RSEQ3_SEQ9_4                                ((uint32_t)0x00004000U)            /* Bit 4 */

#define ADC_RSEQ3_SEQ10                                 ((uint32_t)0x000F8000U)            /* SEQ10[4:0] bits (10th conversion in regular sequence) */
#define ADC_RSEQ3_SEQ10_0                               ((uint32_t)0x00008000U)            /* Bit 0 */
#define ADC_RSEQ3_SEQ10_1                               ((uint32_t)0x00010000U)            /* Bit 1 */
#define ADC_RSEQ3_SEQ10_2                               ((uint32_t)0x00020000U)            /* Bit 2 */
#define ADC_RSEQ3_SEQ10_3                               ((uint32_t)0x00040000U)            /* Bit 3 */
#define ADC_RSEQ3_SEQ10_4                               ((uint32_t)0x00080000U)            /* Bit 4 */

#define ADC_RSEQ3_SEQ11                                 ((uint32_t)0x01F00000U)            /* SEQ11[4:0] bits (11th conversion in regular sequence) */
#define ADC_RSEQ3_SEQ11_0                               ((uint32_t)0x00100000U)            /* Bit 0 */
#define ADC_RSEQ3_SEQ11_1                               ((uint32_t)0x00200000U)            /* Bit 1 */
#define ADC_RSEQ3_SEQ11_2                               ((uint32_t)0x00400000U)            /* Bit 2 */
#define ADC_RSEQ3_SEQ11_3                               ((uint32_t)0x00800000U)            /* Bit 3 */
#define ADC_RSEQ3_SEQ11_4                               ((uint32_t)0x01000000U)            /* Bit 4 */

#define ADC_RSEQ3_SEQ12                                 ((uint32_t)0x3E000000U)            /* SEQ12[4:0] bits (12th conversion in regular sequence) */
#define ADC_RSEQ3_SEQ12_0                               ((uint32_t)0x02000000U)            /* Bit 0 */
#define ADC_RSEQ3_SEQ12_1                               ((uint32_t)0x04000000U)            /* Bit 1 */
#define ADC_RSEQ3_SEQ12_2                               ((uint32_t)0x08000000U)            /* Bit 2 */
#define ADC_RSEQ3_SEQ12_3                               ((uint32_t)0x10000000U)            /* Bit 3 */
#define ADC_RSEQ3_SEQ12_4                               ((uint32_t)0x20000000U)            /* Bit 4 */

/*******************  Bit definition for ADC_RSEQ4 register  *******************/
#define ADC_RSEQ4_SEQ1                                  ((uint32_t)0x0000001FU)            /* SEQ1[4:0] bits (1st conversion in regular sequence) */
#define ADC_RSEQ4_SEQ1_0                                ((uint32_t)0x00000001U)            /* Bit 0 */
#define ADC_RSEQ4_SEQ1_1                                ((uint32_t)0x00000002U)            /* Bit 1 */
#define ADC_RSEQ4_SEQ1_2                                ((uint32_t)0x00000004U)            /* Bit 2 */
#define ADC_RSEQ4_SEQ1_3                                ((uint32_t)0x00000008U)            /* Bit 3 */
#define ADC_RSEQ4_SEQ1_4                                ((uint32_t)0x00000010U)            /* Bit 4 */

#define ADC_RSEQ4_SEQ2                                  ((uint32_t)0x000003E0U)            /* SEQ2[4:0] bits (2nd conversion in regular sequence) */
#define ADC_RSEQ4_SEQ2_0                                ((uint32_t)0x00000020U)            /* Bit 0 */
#define ADC_RSEQ4_SEQ2_1                                ((uint32_t)0x00000040U)            /* Bit 1 */
#define ADC_RSEQ4_SEQ2_2                                ((uint32_t)0x00000080U)            /* Bit 2 */
#define ADC_RSEQ4_SEQ2_3                                ((uint32_t)0x00000100U)            /* Bit 3 */
#define ADC_RSEQ4_SEQ2_4                                ((uint32_t)0x00000200U)            /* Bit 4 */

#define ADC_RSEQ4_SEQ3                                  ((uint32_t)0x00007C00U)            /* SEQ3[4:0] bits (3rd conversion in regular sequence) */
#define ADC_RSEQ4_SEQ3_0                                ((uint32_t)0x00000400U)            /* Bit 0 */
#define ADC_RSEQ4_SEQ3_1                                ((uint32_t)0x00000800U)            /* Bit 1 */
#define ADC_RSEQ4_SEQ3_2                                ((uint32_t)0x00001000U)            /* Bit 2 */
#define ADC_RSEQ4_SEQ3_3                                ((uint32_t)0x00002000U)            /* Bit 3 */
#define ADC_RSEQ4_SEQ3_4                                ((uint32_t)0x00004000U)            /* Bit 4 */

#define ADC_RSEQ4_SEQ4                                  ((uint32_t)0x000F8000U)            /* SEQ4[4:0] bits (4th conversion in regular sequence) */
#define ADC_RSEQ4_SEQ4_0                                ((uint32_t)0x00008000U)            /* Bit 0 */
#define ADC_RSEQ4_SEQ4_1                                ((uint32_t)0x00010000U)            /* Bit 1 */
#define ADC_RSEQ4_SEQ4_2                                ((uint32_t)0x00020000U)            /* Bit 2 */
#define ADC_RSEQ4_SEQ4_3                                ((uint32_t)0x00040000U)            /* Bit 3 */
#define ADC_RSEQ4_SEQ4_4                                ((uint32_t)0x00080000U)            /* Bit 4 */

#define ADC_RSEQ4_SEQ5                                  ((uint32_t)0x01F00000U)            /* SEQ5[4:0] bits (5th conversion in regular sequence) */
#define ADC_RSEQ4_SEQ5_0                                ((uint32_t)0x00100000U)            /* Bit 0 */
#define ADC_RSEQ4_SEQ5_1                                ((uint32_t)0x00200000U)            /* Bit 1 */
#define ADC_RSEQ4_SEQ5_2                                ((uint32_t)0x00400000U)            /* Bit 2 */
#define ADC_RSEQ4_SEQ5_3                                ((uint32_t)0x00800000U)            /* Bit 3 */
#define ADC_RSEQ4_SEQ5_4                                ((uint32_t)0x01000000U)            /* Bit 4 */

#define ADC_RSEQ4_SEQ6                                  ((uint32_t)0x3E000000U)            /* SEQ6[4:0] bits (6th conversion in regular sequence) */
#define ADC_RSEQ4_SEQ6_0                                ((uint32_t)0x02000000U)            /* Bit 0 */
#define ADC_RSEQ4_SEQ6_1                                ((uint32_t)0x04000000U)            /* Bit 1 */
#define ADC_RSEQ4_SEQ6_2                                ((uint32_t)0x08000000U)            /* Bit 2 */
#define ADC_RSEQ4_SEQ6_3                                ((uint32_t)0x10000000U)            /* Bit 3 */
#define ADC_RSEQ4_SEQ6_4                                ((uint32_t)0x20000000U)            /* Bit 4 */

/*******************  Bit definition for ADC_JSEQ register  *******************/
#define ADC_JSEQ_JSEQ1                                  ((uint32_t)0x0000001FU)            /* JSEQ1[4:0] bits (1st conversion in injected sequence) */
#define ADC_JSEQ_JSEQ1_0                                ((uint32_t)0x00000001U)            /* Bit 0 */
#define ADC_JSEQ_JSEQ1_1                                ((uint32_t)0x00000002U)            /* Bit 1 */
#define ADC_JSEQ_JSEQ1_2                                ((uint32_t)0x00000004U)            /* Bit 2 */
#define ADC_JSEQ_JSEQ1_3                                ((uint32_t)0x00000008U)            /* Bit 3 */
#define ADC_JSEQ_JSEQ1_4                                ((uint32_t)0x00000010U)            /* Bit 4 */

#define ADC_JSEQ_JSEQ2                                  ((uint32_t)0x000003E0U)            /* JSEQ2[4:0] bits (2nd conversion in injected sequence) */
#define ADC_JSEQ_JSEQ2_0                                ((uint32_t)0x00000020U)            /* Bit 0 */
#define ADC_JSEQ_JSEQ2_1                                ((uint32_t)0x00000040U)            /* Bit 1 */
#define ADC_JSEQ_JSEQ2_2                                ((uint32_t)0x00000080U)            /* Bit 2 */
#define ADC_JSEQ_JSEQ2_3                                ((uint32_t)0x00000100U)            /* Bit 3 */
#define ADC_JSEQ_JSEQ2_4                                ((uint32_t)0x00000200U)            /* Bit 4 */

#define ADC_JSEQ_JSEQ3                                  ((uint32_t)0x00007C00U)            /* JSEQ3[4:0] bits (3rd conversion in injected sequence) */
#define ADC_JSEQ_JSEQ3_0                                ((uint32_t)0x00000400U)            /* Bit 0 */
#define ADC_JSEQ_JSEQ3_1                                ((uint32_t)0x00000800U)            /* Bit 1 */
#define ADC_JSEQ_JSEQ3_2                                ((uint32_t)0x00001000U)            /* Bit 2 */
#define ADC_JSEQ_JSEQ3_3                                ((uint32_t)0x00002000U)            /* Bit 3 */
#define ADC_JSEQ_JSEQ3_4                                ((uint32_t)0x00004000U)            /* Bit 4 */

#define ADC_JSEQ_JSEQ4                                  ((uint32_t)0x000F8000U)            /* JSEQ4[4:0] bits (4th conversion in injected sequence) */
#define ADC_JSEQ_JSEQ4_0                                ((uint32_t)0x00008000U)            /* Bit 0 */
#define ADC_JSEQ_JSEQ4_1                                ((uint32_t)0x00010000U)            /* Bit 1 */
#define ADC_JSEQ_JSEQ4_2                                ((uint32_t)0x00020000U)            /* Bit 2 */
#define ADC_JSEQ_JSEQ4_3                                ((uint32_t)0x00040000U)            /* Bit 3 */
#define ADC_JSEQ_JSEQ4_4                                ((uint32_t)0x00080000U)            /* Bit 4 */

#define ADC_JSEQ_JLEN                                   ((uint32_t)0x06000000U)            /* JLEN[1:0] bits (Injected Sequence length) */
#define ADC_JSEQ_JLEN_0                                 ((uint32_t)0x02000000U)            /* Bit 0 */
#define ADC_JSEQ_JLEN_1                                 ((uint32_t)0x04000000U)            /* Bit 1 */

/*******************  Bit definition for ADC_JDAT1 register  *******************/
#define ADC_JDAT1_JDAT                                  ((uint16_t)0xFFFFU)                /* Injected data */

/*******************  Bit definition for ADC_JDAT2 register  *******************/
#define ADC_JDAT2_JDAT                                  ((uint16_t)0xFFFFU)                /* Injected data */

/*******************  Bit definition for ADC_JDAT3 register  *******************/
#define ADC_JDAT3_JDAT                                  ((uint16_t)0xFFFFU)                /* Injected data */

/*******************  Bit definition for ADC_JDAT4 register  *******************/
#define ADC_JDAT4_JDAT                                  ((uint16_t)0xFFFFU)                /* Injected data */

/********************  Bit definition for ADC_DAT register  ********************/
#define ADC_DAT_DAT                                     ((uint32_t)0x0000FFFFU)            /* Regular data */
#define ADC_DAT_ADC2DAT                                 ((uint32_t)0xFFFF0000U)            /* Slave ADC data when operating on Muti-ADC */

/********************  Bit definition for ADC_FIFOCFG register  ********************/
#define ADC_FIFOCFG_FINTEN                              ((uint32_t)0x00000004U)            /* FIFO full interrup enable */
#define ADC_FIFOCFG_EINTEN                              ((uint32_t)0x00000008U)            /* FIFO empty interrup enable */
#define ADC_FIFOCFG_HFINTEN                             ((uint32_t)0x00000010U)            /* FIFO half-full interrup enable */
#define ADC_FIFOCFG_EN                                  ((uint32_t)0x00000020U)            /* FIFO enable */

#define ADC_FIFOCFG_WL                                  ((uint32_t)0x000003C0U)            /* WL[1:0] bits (FIFO water level) */
#define ADC_FIFOCFG_WL_0                                ((uint32_t)0x00000040U)            /* Bit 0 */
#define ADC_FIFOCFG_WL_1                                ((uint32_t)0x00000080U)            /* Bit 1 */
#define ADC_FIFOCFG_WL_2                                ((uint32_t)0x00000100U)            /* Bit 2 */
#define ADC_FIFOCFG_WL_3                                ((uint32_t)0x00000200U)            /* Bit 3 */

#define ADC_FIFOCFG_CLR                                 ((uint32_t)0x00000400U)            /* FIFO clear enable */
#define ADC_FIFOCFG_NEINTEN                             ((uint32_t)0x00000800U)            /* FIFO non-empty interrupt enable */

/********************  Bit definition for ADC_FIFOSTS register     ********************/
#define ADC_FIFOSTS_FFLAG                               ((uint32_t)0x00000004U)            /* FIFO full status flag */
#define ADC_FIFOSTS_EFLAG                               ((uint32_t)0x00000008U)            /* FIFO empty status flag*/
#define ADC_FIFOSTS_HFFLAG                              ((uint32_t)0x00000010U)            /* FIFO half-full status flag */

#define ADC_FIFOSTS_DATCNT                              ((uint32_t)0x000003E0U)            /* DATCNT[4:0] bits (FIFO invalid data count) */
#define ADC_FIFOSTS_DATCNT_0                            ((uint32_t)0x00000020U)            /* Bit 0 */
#define ADC_FIFOSTS_DATCNT_1                            ((uint32_t)0x00000040U)            /* Bit 1 */
#define ADC_FIFOSTS_DATCNT_2                            ((uint32_t)0x00000080U)            /* Bit 2 */
#define ADC_FIFOSTS_DATCNT_3                            ((uint32_t)0x00000100U)            /* Bit 3 */
#define ADC_FIFOSTS_DATCNT_4                            ((uint32_t)0x00000200U)            /* Bit 4 */

#define ADC_FIFOSTS_NEFLAG                              ((uint32_t)0x00000800U)            /* FIFO non-empty status flag */

/********************  Bit definition for ADC_DLYSMP register  ********************/
#define ADC_DLYSMP_INTLEADVAL                           ((uint32_t)0xF0000000U)            /* Bit[31:28] The delay time when operating on interleaved mode of dual-ADC or Tripple- ADC */
#define ADC_DLYSMP_INTLEADVAL_0                         ((uint32_t)0x10000000U)            /* Bit28*/
#define ADC_DLYSMP_INTLEADVAL_1                         ((uint32_t)0x20000000U)            /* Bit29*/
#define ADC_DLYSMP_INTLEADVAL_2                         ((uint32_t)0x40000000U)            /* Bit30*/
#define ADC_DLYSMP_INTLEADVAL_3                         ((uint32_t)0x80000000U)            /* Bit31*/

#define ADC_DLYSMP_DLYVAL                               ((uint32_t)0x0F000000U)            /* Bit[27:24] Delayed sampling cycle configuration in independent mode*/
#define ADC_DLYSMP_DLYVAL_0                             ((uint32_t)0x01000000U)            /* Bit24*/
#define ADC_DLYSMP_DLYVAL_1                             ((uint32_t)0x02000000U)            /* Bit25*/
#define ADC_DLYSMP_DLYVAL_2                             ((uint32_t)0x04000000U)            /* Bit26*/
#define ADC_DLYSMP_DLYVAL_3                             ((uint32_t)0x08000000U)            /* Bit27*/

#define ADC_DLYSMP_DLYSAMPEN                            ((uint32_t)0x00800000U)            /* Bit[23] */

/********************  Bit definition for ADC_OSCFG register  *****************/
#define ADC_OSCFG_OSAWD                                 ((uint32_t)0x01000000U)            /* Bit[24] Oversampling data for analog watchdog comparision */
#define ADC_OSCFG_OSRMD                                 ((uint32_t)0x00800000U)            /* Bit[23] Regular channels oversample mode */
#define ADC_OSCFG_OSRTRIG                               ((uint32_t)0x00400000U)            /* Bit[22] egular channels oversample triagger mode */

#define ADC_OSCFG_OSS                                   ((uint32_t)0x003C0000U)            /* Bit[21:18] Oversample data right shift */
#define ADC_OSCFG_OSS_0                                 ((uint32_t)0x00040000U)            /* Bit18*/
#define ADC_OSCFG_OSS_1                                 ((uint32_t)0x00080000U)            /* Bit19*/
#define ADC_OSCFG_OSS_2                                 ((uint32_t)0x00100000U)            /* Bit20*/
#define ADC_OSCFG_OSS_3                                 ((uint32_t)0x00200000U)            /* Bit21*/

#define ADC_OSCFG_OSR                                   ((uint32_t)0x0003C000U)            /* Bit[17:14] ADC oversampling ratio times */
#define ADC_OSCFG_OSR_0                                 ((uint32_t)0x00004000U)            /* Bit14*/
#define ADC_OSCFG_OSR_1                                 ((uint32_t)0x00008000U)            /* Bit15*/
#define ADC_OSCFG_OSR_2                                 ((uint32_t)0x00010000U)            /* Bit16*/
#define ADC_OSCFG_OSR_3                                 ((uint32_t)0x00020000U)            /* Bit17*/

#define ADC_OSCFG_OSJE                                  ((uint32_t)0x00002000U)            /* Bit[13] Injected channels oversample enable*/
#define ADC_OSCFG_OSRE                                  ((uint32_t)0x00001000U)            /* Bit[12] Regular channels oversample enable */

/********************  Bit definition for ADC_INTLRCFG register  ****************/
#define ADC_INTLRCFG_WEN                                ((uint32_t)0x80000000U)            /* WEN bits (Write enable) */
#define ADC_INTLRCFG_RWSTART                            ((uint32_t)0x40000000U)            /* RWSTART bits (Start Write/Read Internal Register) */
#define ADC_INTLRCFG_DONE                               ((uint32_t)0x20000000U)            /* DONE bits (Write/Read Internal Register Finish Flag) */

#define ADC_INTLRCFG_ADDR                               ((uint32_t)0x1C000000U)            /* ADDR[2:0] bits (The address of internal registers) */
#define ADC_INTLRCFG_WDATA                              ((uint32_t)0x03FC0000U)            /* WDATA[7:0] bits (Data write into internal register) */
#define ADC_INTLRCFG_RDATA                              ((uint32_t)0x00003FC0U)            /* RDATA[7:0] bits (Data read from internal register) */

/********************  Bit definition for ADC_GCOMP register  ****************/
#define ADC_GCOMP_GCOMPDAT                              ((uint32_t)0x00003FFFU)            /* GCOMPDAT[13:0] bits (ADC Gain Compensation Coefficient) */


/***    Digital to Analog Converter Peripheral Interface   ***/
/********************  Bit definition for DAC_CTRL register  ********************/
#define DAC_CTRL_DACxEN                                 ((uint32_t)0x00000001U)           /* DACx enable */
#define DAC_CTRL_DMAxEN                                 ((uint32_t)0x00000002U)           /* DACx DMA enable */
#define DAC_CTRL_BxEN                                   ((uint32_t)0x00000004U)           /* DACx output buffer enable */
#define DAC_CTRL_TxEN                                   ((uint32_t)0x00000008U)           /* DACx Trigger enable */
#define DAC_CTRL_DMAUDRxIEn                             ((uint32_t)0x00000010U)           /* DACx DMA underrun interrupt enable */
#define DAC_CTRL_HDBxEN                                 ((uint32_t)0x00000020U)           /* DACx high driver output buffer enable */
#define DAC_CTRL_DMADOUBLExEN                           ((uint32_t)0x00000040U)           /* DACx DMA double data mode enable */
#define DAC_CTRL_SINFORMATxEN                           ((uint32_t)0x00000080U)           /* DACx signed format enable */

#define DAC_CTRL_WxEN                                   ((uint32_t)0x00000700U)           /* WAVE1[1:0] (DACx noise/triangle wave generation enable) */
#define DAC_CTRL_WxEN_0                                 ((uint32_t)0x00000100U)           /* Bit 0 */
#define DAC_CTRL_WxEN_1                                 ((uint32_t)0x00000200U)           /* Bit 1 */
#define DAC_CTRL_WxEN_2                                 ((uint32_t)0x00000400U)           /* Bit 2 */

#define DAC_CTRL_CALxEN                                 ((uint32_t)0x00000800U)           /* DACx calibrate enable */
#define DAC_CTRL_INOUTx                                 ((uint32_t)0x00001000U)           /* DACx is connected to on chip peripherals enable */
#define DAC_CTRL_EXOUTx                                 ((uint32_t)0x00002000U)           /* DACx is connected to external pin enable */
#define DAC_CTRL_TROVCxIEN                              ((uint32_t)0x00004000U)           /* DACx's trigger overclock interrupt enable */

#define DAC_CTRL_DACyEN                                 ((uint32_t)0x00010000U)           /* DACy enable */
#define DAC_CTRL_DMAyEN                                 ((uint32_t)0x00020000U)           /* DACy DMA enable */
#define DAC_CTRL_ByEN                                   ((uint32_t)0x00040000U)           /* DACy output buffer enable */
#define DAC_CTRL_TyEN                                   ((uint32_t)0x00080000U)           /* DACy Trigger enable */
#define DAC_CTRL_DMAUDRyIEn                             ((uint32_t)0x00100000U)           /* DACy DMA underrun interrupt enable */
#define DAC_CTRL_HDByEN                                 ((uint32_t)0x00200000U)           /* DACy high driver output buffer enable */
#define DAC_CTRL_DMADOUBLEyEN                           ((uint32_t)0x00400000U)           /* DACy DMA double data mode enable */
#define DAC_CTRL_SINFORMATyEN                           ((uint32_t)0x00800000U)           /* DACy signed format enable */

#define DAC_CTRL_WyEN                                   ((uint32_t)0x07000000U)           /* WAVE2[1:0] (DACy noise/triangle wave generation enable) */
#define DAC_CTRL_WyEN_0                                 ((uint32_t)0x01000000U)           /* Bit 0 */
#define DAC_CTRL_WyEN_1                                 ((uint32_t)0x02000000U)           /* Bit 1 */
#define DAC_CTRL_WyEN_2                                 ((uint32_t)0x04000000U)           /* Bit 2 */

#define DAC_CTRL_CALyEN                                 ((uint32_t)0x08000000U)           /* DACy calibrate enable */
#define DAC_CTRL_INOUTy                                 ((uint32_t)0x10000000U)           /* DACy is connected to on chip peripherals enable */
#define DAC_CTRL_EXOUTy                                 ((uint32_t)0x20000000U)           /* DACy is connected to external pin enable */
#define DAC_CTRL_TROVCyIEN                              ((uint32_t)0x40000000U)           /* DACy's trigger overclock interrupt enable */

/*****************  Bit definition for DAC_SOTTR register  ******************/
#define DAC_SOTTR_TRxEN                                 ((uint32_t)0x00000001U)           /* DACx software trigger */
#define DAC_SOTTR_TRyEN                                 ((uint32_t)0x00000002U)           /* DACy software trigger */
#define DAC_SOTTR_TRBxEN                                ((uint32_t)0x00010000U)           /* DACx sawtooth step signal software trigger */
#define DAC_SOTTR_TRByEN                                ((uint32_t)0x00020000U)           /* DACy sawtooth step signal software trigger */

/*******************  Bit definiti on for DAC_DATO1 register  *******************/
#define DACx_DATO_DACxDO                                ((uint16_t)0x0FFFU)               /* DACx data output */

/*******************  Bit definition for DAC_DATO2 register  *******************/
#define DACy_DATO_DACyDO                                ((uint16_t)0x0FFFU)               /* DACy data output */

/******************  Bit definition for DAC_DR8CH1 register  ******************/
#define DACx_DR8_DACxD                                  ((uint16_t)0xFF00U)               /* DACx 8-bit Right aligned data */
#define DACx_DR8_DACxDB                                 ((uint16_t)0x00FFU)               /* DACx 8-bit Right aligned data, operating only on double data mode */

/*****************  Bit definition for DAC_DL12CH1 register  ******************/
#define DACx_DL12_DACxDB                                ((uint32_t)0x0000FFF0U)           /* DACx 12-bit Left aligned data */
#define DACx_DL12_DACxD                                 ((uint32_t)0xFFF00000U)           /* DACx 12-bit Left aligned data, operating only on double data mode  */

/*****************  Bit definition for DAC_DR12CH1 register  ******************/
#define DACx_DR12_DACxDB                                ((uint32_t)0x00000FFFU)           /* DACx 12-bit Right aligned data */
#define DACx_DR12_DACxD                                 ((uint32_t)0x0FFF0000U)           /* DACx 12-bit Right aligned data, operating only on double data mode  */

/******************  Bit definition for DAC_DR8CH2 register  ******************/
#define DACy_DR8_DACyD                                  ((uint16_t)0xFF00U)               /* DACy 8-bit Right aligned data */
#define DACy_DR8_DACyDB                                 ((uint16_t)0x00FFU)               /* DACy 8-bit Right aligned data, operating only on double data mode */

/*****************  Bit definition for DAC_DL12CH2 register  ******************/
#define DACy_DL12_DACyDB                                ((uint32_t)0x0000FFF0U)           /* DACy 12-bit Left aligned data */
#define DACy_DL12_DACyD                                 ((uint32_t)0xFFF00000U)           /* DACy 12-bit Left aligned data, operating only on double data mode  */

/*****************  Bit definition for DAC_DR12CH2 register  ******************/
#define DACy_DR12_DACyDB                                ((uint32_t)0x00000FFFU)           /* DACy 12-bit Right aligned data */
#define DACy_DR12_DACyD                                 ((uint32_t)0x0FFF0000U)           /* DACy 12-bit Right aligned data, operating only on double data mode  */

/******************  Bit definition for DAC_DR8DCH register  ******************/
#define DAC_DR8D_DACxD                                  ((uint16_t)0x00FFU)               /* DACx 8-bit Right aligned data */
#define DAC_DR8D_DACyD                                  ((uint16_t)0xFF00U)               /* DACy 8-bit Right aligned data */

/*****************  Bit definition for DAC_DL12DCH register  ******************/
#define DAC_DL12D_DACxD                                 ((uint32_t)0x0000FFF0U)           /* DACx 12-bit Left aligned data */
#define DAC_DL12D_DACyD                                 ((uint32_t)0xFFF00000U)           /* DACy 12-bit Left aligned data */

/*****************  Bit definition for DAC_DR12DCH register  ******************/
#define DAC_DR12D_DACxD                                 ((uint32_t)0x00000FFFU)           /* DACx 12-bit Right aligned data */
#define DAC_DR12D_DACyD                                 ((uint32_t)0x0FFF0000U)           /* DACy 12-bit Right aligned data */

/*****************  Bit definition for DAC_SELCTRL register  ******************/
#define DAC_SETCTRL_SINCSELx                            ((uint32_t)0x0000003EU)           /* DACx sawtooth increment trigger selection */
#define DAC_SETCTRL_SINCSELx_0                          ((uint32_t)0x00000002U)           /* Bit 0 */
#define DAC_SETCTRL_SINCSELx_1                          ((uint32_t)0x00000004U)           /* Bit 1 */
#define DAC_SETCTRL_SINCSELx_2                          ((uint32_t)0x00000008U)           /* Bit 2 */
#define DAC_SETCTRL_SINCSELx_3                          ((uint32_t)0x00000010U)           /* Bit 3 */
#define DAC_SETCTRL_SINCSELx_4                          ((uint32_t)0x00000020U)           /* Bit 4 */

#define DAC_SETCTRL_MAxSEL                              ((uint32_t)0x000003C0U)           /* MAMPx[3:0] (DACx Mask/Amplitude selector) */
#define DAC_SETCTRL_MAxSEL_0                            ((uint32_t)0x00000040U)           /* Bit 0 */
#define DAC_SETCTRL_MAxSEL_1                            ((uint32_t)0x00000080U)           /* Bit 1 */
#define DAC_SETCTRL_MAxSEL_2                            ((uint32_t)0x00000100U)           /* Bit 2 */
#define DAC_SETCTRL_MAxSEL_3                            ((uint32_t)0x00000200U)           /* Bit 3 */

#define DAC_SETCTRL_TxSEL                               ((uint32_t)0x0000F100U)           /* TSELx[4:0] (DACx Trigger source selection) */
#define DAC_SETCTRL_TxSEL_0                             ((uint32_t)0x00000100U)           /* Bit 0 */
#define DAC_SETCTRL_TxSEL_1                             ((uint32_t)0x00001000U)           /* Bit 1 */
#define DAC_SETCTRL_TxSEL_2                             ((uint32_t)0x00002000U)           /* Bit 2 */
#define DAC_SETCTRL_TxSEL_3                             ((uint32_t)0x00004000U)           /* Bit 3 */
#define DAC_SETCTRL_TxSEL_4                             ((uint32_t)0x00008000U)           /* Bit 4 */

#define DAC_SETCTRL_SINCSELy                            ((uint32_t)0x003E0000U)           /* SINCSELy[3:0] (DACy sawtooth increment trigger selection) */
#define DAC_SETCTRL_SINCSELy_0                          ((uint32_t)0x00020000U)           /* Bit 0 */
#define DAC_SETCTRL_SINCSELy_1                          ((uint32_t)0x00040000U)           /* Bit 1 */
#define DAC_SETCTRL_SINCSELy_2                          ((uint32_t)0x00080000U)           /* Bit 2 */
#define DAC_SETCTRL_SINCSELy_3                          ((uint32_t)0x00100000U)           /* Bit 3 */
#define DAC_SETCTRL_SINCSELy_4                          ((uint32_t)0x00200000U)           /* Bit 4 */

#define DAC_SETCTRL_MAySEL                              ((uint32_t)0x03C00000U)           /* MAMPy[3:0] (DACy Mask/Amplitude selector) */
#define DAC_SETCTRL_MAySEL_0                            ((uint32_t)0x00400000U)           /* Bit 0 */
#define DAC_SETCTRL_MAySEL_1                            ((uint32_t)0x00800000U)           /* Bit 1 */
#define DAC_SETCTRL_MAySEL_2                            ((uint32_t)0x01000000U)           /* Bit 2 */
#define DAC_SETCTRL_MAySEL_3                            ((uint32_t)0x02000000U)           /* Bit 3 */

#define DAC_SETCTRL_TySEL                               ((uint32_t)0xF1000000U)           /* TSELy[4:0] (DACy Trigger source selection) */
#define DAC_SETCTRL_TySEL_0                             ((uint32_t)0x01000000U)           /* Bit 0 */
#define DAC_SETCTRL_TySEL_1                             ((uint32_t)0x10000000U)           /* Bit 1 */
#define DAC_SETCTRL_TySEL_2                             ((uint32_t)0x20000000U)           /* Bit 2 */
#define DAC_SETCTRL_TySEL_3                             ((uint32_t)0x40000000U)           /* Bit 3 */
#define DAC_SETCTRL_TySEL_4                             ((uint32_t)0x80000000U)           /* Bit 4 */

/*****************  Bit definition for DAC_STS register  ******************/
#define DAC_STS_DMAUDRx                                 ((uint32_t)0x00000001U)           /* DACx DMA underrun status flag  */
#define DAC_STS_CALFLAGx                                ((uint32_t)0x00000002U)           /* DACx calibrate offset status flag  */
#define DAC_STS_DORSTATx                                ((uint32_t)0x00000004U)           /* DACx data output register status flag  */
#define DAC_STS_TROVCFLAGx                              ((uint32_t)0x00000008U)           /* DACx trigger source overclock status flag  */
#define DAC_STS_VFLAGxCOMP                              ((uint32_t)0x00000010U)           /* Status flag that indicates DACx output is stable or not */

#define DAC_STS_DMAUDRy                                 ((uint32_t)0x00010000U)           /* DACy DMA underrun status flag  */
#define DAC_STS_CALFLAGy                                ((uint32_t)0x00020000U)           /* DACy calibrate offset status flag  */
#define DAC_STS_DORSTATy                                ((uint32_t)0x00040000U)           /* DACy data output register status flag  */
#define DAC_STS_TROVCFLAGy                              ((uint32_t)0x00080000U)           /* DACy trigger source overclock status flag  */
#define DAC_STS_VFLAGyCOMP                              ((uint32_t)0x00100000U)           /* Status flag that indicates DACy output is stable or not */

/*****************  Bit definition for DAC_GCTRL register  ******************/
#define DAC12_GCTRL_HFSEL                               ((uint32_t)0x00000006U)           /* HFSEL[1:0] (High frequency interface mode selection for DAC1/DAC2)  */
#define DAC12_GCTRL_HFSEL_0                             ((uint32_t)0x00000002U)           /* Bit 0 */
#define DAC12_GCTRL_HFSEL_1                             ((uint32_t)0x00000004U)           /* Bit 1 */

#define DAC12_GCTRL_PCS                                 ((uint32_t)0x00FF0000U)           /* PCS[7:0] (The clock prescale of DAC1/DAC2 selection)  */
#define DAC12_GCTRL_PCS_0                               ((uint32_t)0x00010000U)           /* Bit 0 */
#define DAC12_GCTRL_PCS_1                               ((uint32_t)0x00020000U)           /* Bit 1 */
#define DAC12_GCTRL_PCS_2                               ((uint32_t)0x00040000U)           /* Bit 2 */
#define DAC12_GCTRL_PCS_3                               ((uint32_t)0x00080000U)           /* Bit 3 */
#define DAC12_GCTRL_PCS_4                               ((uint32_t)0x00100000U)           /* Bit 4 */
#define DAC12_GCTRL_PCS_5                               ((uint32_t)0x00200000U)           /* Bit 5 */
#define DAC12_GCTRL_PCS_6                               ((uint32_t)0x00400000U)           /* Bit 6 */
#define DAC12_GCTRL_PCS_7                               ((uint32_t)0x00800000U)           /* Bit 7 */

#define DAC3456_GCTRL_PCS                               ((uint32_t)0x001F0000U)           /* PCS[4:0] (The clock prescale of DAC3/DAC4DAC5/DAC6 selection)  */
#define DAC3456_GCTRL_PCS_0                             ((uint32_t)0x00010000U)           /* Bit 0 */
#define DAC3456_GCTRL_PCS_1                             ((uint32_t)0x00020000U)           /* Bit 1 */
#define DAC3456_GCTRL_PCS_2                             ((uint32_t)0x00040000U)           /* Bit 2 */
#define DAC3456_GCTRL_PCS_3                             ((uint32_t)0x00080000U)           /* Bit 3 */
#define DAC3456_GCTRL_PCS_4                             ((uint32_t)0x00100000U)           /* Bit 4 */

/*****************  Bit definition for DAC_STINC register  ******************/
#define DAC_STINC_STINCDATAx                            ((uint32_t)0x00000FFFU)           /* STINCDATAx[11:0] (The sawtooth step value of DACx)  */
#define DAC_STINC_STINCDATAy                            ((uint32_t)0x0FFF0000U)           /* STINCDATAy[11:0] (The sawtooth step value of DACy)  */

/*****************  Bit definition for DAC_STRST register  ******************/
#define DAC_STRST_STRSTDATAx                            ((uint32_t)0x00000FFFU)           /* STRSTDATAx[11:0] (The sawtooth reset value of DACx)  */
#define DAC_STRST_STRSTDATAy                            ((uint32_t)0x0FFF0000U)           /* STRSTDATAy[11:0] (The sawtooth reset value of DACy)  */

/*****************  Bit definition for DAC_CALC register  ******************/
#define DAC_CALC_OTRIMx                                 ((uint32_t)0x0000001FU)           /* OTRIMx[4:0] (The calibration offset value of DACx)  */
#define DAC_CALC_OTRIMy                                 ((uint32_t)0x001F0000U)           /* OTRIMy[4:0] (The calibration offset value of DACy)  */


/***   Comparators Peripheral Interface   ***/
/******** Bit definition for COMP1_CTRL register  ********/
#define COMP1_CTRL_VV1TRM                                   ((uint32_t)0x1F800000U)         /* Bit[28:23] Internal 6bit-dac1 output voltage size*/
#define COMP1_CTRL_VV1TRM_0                                 ((uint32_t)0x00800000U)         /* Bit23*/
#define COMP1_CTRL_VV1TRM_1                                 ((uint32_t)0x01000000U)         /* Bit24*/
#define COMP1_CTRL_VV1TRM_2                                 ((uint32_t)0x02000000U)         /* Bit25*/
#define COMP1_CTRL_VV1TRM_3                                 ((uint32_t)0x04000000U)         /* Bit26*/
#define COMP1_CTRL_VV1TRM_4                                 ((uint32_t)0x08000000U)         /* Bit27*/
#define COMP1_CTRL_VV1TRM_5                                 ((uint32_t)0x10000000U)         /* Bit28*/

#define COMP1_CTRL_VV1EN                                    ((uint32_t)0x00400000U)         /* Bit[22] Internal 6bit-dac1 output enable*/

#define COMP1_CTRL_OUT                                      ((uint32_t)0x00200000U)         /* Bit[21] Output state of Comparator_1 */

#define COMP1_CTRL_BLKINGEN                                 ((uint32_t)0x00100000U)         /* Bit[20] Comparator_1 Blanking enable */

#define COMP1_CTRL_BLKING                                   ((uint32_t)0x000F0000U)         /* Bit[19:16] Blanking source select of Comparator_1 */
#define COMP1_CTRL_BLKING_0                                 ((uint32_t)0x00010000U)         /* Bit16*/
#define COMP1_CTRL_BLKING_1                                 ((uint32_t)0x00020000U)         /* Bit17*/
#define COMP1_CTRL_BLKING_2                                 ((uint32_t)0x00040000U)         /* Bit18*/
#define COMP1_CTRL_BLKING_3                                 ((uint32_t)0x00080000U)         /* Bit19*/

#define COMP1_CTRL_HYST                                     ((uint32_t)0x0000C000U)         /* Bit[15:14] Hysteresis level select of Comparator_1*/
#define COMP1_CTRL_HYST_0                                   ((uint32_t)0x00004000U)         /* Bit14*/
#define COMP1_CTRL_HYST_1                                   ((uint32_t)0x00008000U)         /* Bit15*/

#define COMP1_CTRL_POL                                      ((uint32_t)0x00002000U)         /* Bit[13] */

#define COMP1_CTRL_INPSEL                                   ((uint32_t)0x000001E0U)         /* Bit[8:5] Non inverting input select of Comparator_1*/
#define COMP1_CTRL_INPSEL_0                                 ((uint32_t)0x00000020U)         /* Bit5*/
#define COMP1_CTRL_INPSEL_1                                 ((uint32_t)0x00000040U)         /* Bit6*/
#define COMP1_CTRL_INPSEL_2                                 ((uint32_t)0x00000080U)         /* Bit7*/
#define COMP1_CTRL_INPSEL_3                                 ((uint32_t)0x00000100U)         /* Bit8*/

#define COMP1_CTRL_INMSEL                                   ((uint32_t)0x0000001EU)         /* Bit[4:1] Inverting input select of Comparator_1*/
#define COMP1_CTRL_INMSEL_0                                 ((uint32_t)0x00000002U)         /* Bit1*/
#define COMP1_CTRL_INMSEL_1                                 ((uint32_t)0x00000004U)         /* Bit2*/
#define COMP1_CTRL_INMSEL_2                                 ((uint32_t)0x00000008U)         /* Bit3*/
#define COMP1_CTRL_INMSEL_3                                 ((uint32_t)0x00000010U)         /* Bit4*/

#define COMP1_CTRL_EN                                       ((uint32_t)0x00000001U)         /* Bit[0] Comparator_1 enable */

/******** Bit definition for COMP1_FILC register  ********/
#define COMP1_FILC_VN_FLAG                                  ((uint32_t)0x00001000U)         /* Bit12*/
#define COMP1_FILC_VP_FLAG                                  ((uint32_t)0x00000800U)         /* Bit11*/

#define COMP1_FILC_SAMPW                                    ((uint32_t)0x000007C0U)         /* Bit[10:6] Comparator_1 filter window size*/
#define COMP1_FILC_SAMPW_0                                  ((uint32_t)0x00000040U)         /* Bit6*/
#define COMP1_FILC_SAMPW_1                                  ((uint32_t)0x00000080U)         /* Bit7*/
#define COMP1_FILC_SAMPW_2                                  ((uint32_t)0x00000100U)         /* Bit8*/
#define COMP1_FILC_SAMPW_3                                  ((uint32_t)0x00000200U)         /* Bit9*/
#define COMP1_FILC_SAMPW_4                                  ((uint32_t)0x00000400U)         /* Bit10*/

#define COMP1_FILC_THRESH                                   ((uint32_t)0x0000003EU)         /* Bit[5:1] Comparator_1 filter threshold size*/
#define COMP1_FILC_THRESH_0                                 ((uint32_t)0x00000002U)         /* Bit1*/
#define COMP1_FILC_THRESH_1                                 ((uint32_t)0x00000004U)         /* Bit2*/
#define COMP1_FILC_THRESH_2                                 ((uint32_t)0x00000008U)         /* Bit3*/
#define COMP1_FILC_THRESH_3                                 ((uint32_t)0x00000010U)         /* Bit4*/
#define COMP1_FILC_THRESH_4                                 ((uint32_t)0x00000020U)         /* Bit5*/

#define COMP1_FILC_FILEN                                    ((uint32_t)0x00000001U)         /* Bit[0] Comparator_1 filter enable*/

/******** Bit definition for COMP1_FILP register  ********/
#define COMP1_FILP_CLKPSC                                   ((uint32_t)0x0000FFFFU)         /* Bit[15:0] Comparator_1 filter sample clock prescale*/

/******** Bit definition for COMP2_CTRL register  ********/
#define COMP2_CTRL_VV2TRM                                   ((uint32_t)0x1F800000U)         /* Bit[28:23] Internal 6bit-dac2 output voltage size*/
#define COMP2_CTRL_VV2TRM_0                                 ((uint32_t)0x00800000U)         /* Bit23*/
#define COMP2_CTRL_VV2TRM_1                                 ((uint32_t)0x01000000U)         /* Bit24*/
#define COMP2_CTRL_VV2TRM_2                                 ((uint32_t)0x02000000U)         /* Bit25*/
#define COMP2_CTRL_VV2TRM_3                                 ((uint32_t)0x04000000U)         /* Bit26*/
#define COMP2_CTRL_VV2TRM_4                                 ((uint32_t)0x08000000U)         /* Bit27*/
#define COMP2_CTRL_VV2TRM_5                                 ((uint32_t)0x10000000U)         /* Bit28*/

#define COMP2_CTRL_VV2EN                                    ((uint32_t)0x00400000U)         /* Bit[22] Internal 6bit-dac2 output enable*/
#define COMP2_CTRL_OUT                                      ((uint32_t)0x00200000U)         /* Bit[21] Output state of Comparator_2*/

#define COMP2_CTRL_BLKINGEN                                 ((uint32_t)0x00100000U)         /* Bit[20] Comparator_2 Blanking enable*/

#define COMP2_CTRL_BLKING                                   ((uint32_t)0x000F0000U)         /* Bit[19:16] Blanking source select of Comparator_2*/
#define COMP2_CTRL_BLKING_0                                 ((uint32_t)0x00010000U)         /* Bit16*/
#define COMP2_CTRL_BLKING_1                                 ((uint32_t)0x00020000U)         /* Bit17*/
#define COMP2_CTRL_BLKING_2                                 ((uint32_t)0x00040000U)         /* Bit18*/
#define COMP2_CTRL_BLKING_3                                 ((uint32_t)0x00080000U)         /* Bit19*/

#define COMP2_CTRL_HYST                                     ((uint32_t)0x0000C000U)         /* Bit[15:14] Hysteresis level select of Comparator_2*/
#define COMP2_CTRL_HYST_0                                   ((uint32_t)0x00004000U)         /* Bit14*/
#define COMP2_CTRL_HYST_1                                   ((uint32_t)0x00008000U)         /* Bit15*/

#define COMP2_CTRL_POL                                      ((uint32_t)0x00002000U)         /* Bit[13] */

#define COMP2_CTRL_INPSEL                                   ((uint32_t)0x000001E0U)         /* Bit[8:5] Non inverting input select of Comparator_2*/
#define COMP2_CTRL_INPSEL_0                                 ((uint32_t)0x00000020U)         /* Bit5*/
#define COMP2_CTRL_INPSEL_1                                 ((uint32_t)0x00000040U)         /* Bit6*/
#define COMP2_CTRL_INPSEL_2                                 ((uint32_t)0x00000080U)         /* Bit7*/
#define COMP2_CTRL_INPSEL_3                                 ((uint32_t)0x00000100U)         /* Bit8*/

#define COMP2_CTRL_INMSEL                                   ((uint32_t)0x0000001EU)         /* Bit[4:1] Inverting input select of Comparator_2*/
#define COMP2_CTRL_INMSEL_0                                 ((uint32_t)0x00000002U)         /* Bit1*/
#define COMP2_CTRL_INMSEL_1                                 ((uint32_t)0x00000004U)         /* Bit2*/
#define COMP2_CTRL_INMSEL_2                                 ((uint32_t)0x00000008U)         /* Bit3*/
#define COMP2_CTRL_INMSEL_3                                 ((uint32_t)0x00000010U)         /* Bit4*/

#define COMP2_CTRL_EN                                       ((uint32_t)0x00000001U)         /* Bit[0] Comparator_2 enable*/

/******** Bit definition for COMP2_FILC register  ********/
#define COMP2_FILC_SAMPW                                    ((uint32_t)0x000007C0U)         /* Bit[10:6] Comparator_2 filter window size*/
#define COMP2_FILC_SAMPW_0                                  ((uint32_t)0x00000040U)         /* Bit6*/
#define COMP2_FILC_SAMPW_1                                  ((uint32_t)0x00000080U)         /* Bit7*/
#define COMP2_FILC_SAMPW_2                                  ((uint32_t)0x00000100U)         /* Bit8*/
#define COMP2_FILC_SAMPW_3                                  ((uint32_t)0x00000200U)         /* Bit9*/
#define COMP2_FILC_SAMPW_4                                  ((uint32_t)0x00000400U)         /* Bit10*/

#define COMP2_FILC_THRESH                                   ((uint32_t)0x0000003EU)         /* Bit[5:1] Comparator_2 filter threshold size*/
#define COMP2_FILC_THRESH_0                                 ((uint32_t)0x00000002U)         /* Bit1*/
#define COMP2_FILC_THRESH_1                                 ((uint32_t)0x00000004U)         /* Bit2*/
#define COMP2_FILC_THRESH_2                                 ((uint32_t)0x00000008U)         /* Bit3*/
#define COMP2_FILC_THRESH_3                                 ((uint32_t)0x00000010U)         /* Bit4*/
#define COMP2_FILC_THRESH_4                                 ((uint32_t)0x00000020U)         /* Bit5*/

#define COMP2_FILC_FILEN                                    ((uint32_t)0x00000001U)         /* Bit[0] Comparator_2 filter enable */

/******** Bit definition for COMP2_FILP register  ********/
#define COMP2_FILP_CLKPSC                                   ((uint32_t)0x0000FFFFU)         /* Bit[15:0] Comparator_2 filter sample clock prescale*/

/******** Bit definition for COMP3_CTRL register  ********/
#define COMP3_CTRL_OUT                                      ((uint32_t)0x00200000U)         /* Bit[21] Output state of Comparator_3*/

#define COMP3_CTRL_BLKINGEN                                 ((uint32_t)0x00100000U)         /* Bit[20] Comparator_3 Blanking enable*/

#define COMP3_CTRL_BLKING                                   ((uint32_t)0x000F0000U)         /* Bit[19:16] Blanking source select of Comparator_3*/
#define COMP3_CTRL_BLKING_0                                 ((uint32_t)0x00010000U)         /* Bit16*/
#define COMP3_CTRL_BLKING_1                                 ((uint32_t)0x00020000U)         /* Bit17*/
#define COMP3_CTRL_BLKING_2                                 ((uint32_t)0x00040000U)         /* Bit18*/
#define COMP3_CTRL_BLKING_3                                 ((uint32_t)0x00080000U)         /* Bit19*/

#define COMP3_CTRL_HYST                                     ((uint32_t)0x0000C000U)         /* Bit[15:14] Hysteresis level select of Comparator_3*/
#define COMP3_CTRL_HYST_0                                   ((uint32_t)0x00004000U)         /* Bit14*/
#define COMP3_CTRL_HYST_1                                   ((uint32_t)0x00008000U)         /* Bit15*/
#define COMP3_CTRL_POL                                      ((uint32_t)0x00002000U)         /* Bit[13] */

#define COMP3_CTRL_INPSEL                                   ((uint32_t)0x000001E0U)         /* Bit[8:5] Non inverting input select of Comparator_3*/
#define COMP3_CTRL_INPSEL_0                                 ((uint32_t)0x00000020U)         /* Bit5*/
#define COMP3_CTRL_INPSEL_1                                 ((uint32_t)0x00000040U)         /* Bit6*/
#define COMP3_CTRL_INPSEL_2                                 ((uint32_t)0x00000080U)         /* Bit7*/
#define COMP3_CTRL_INPSEL_3                                 ((uint32_t)0x00000100U)         /* Bit8*/

#define COMP3_CTRL_INMSEL                                   ((uint32_t)0x0000001EU)         /* Bit[4:1] Inverting input select of Comparator_3*/
#define COMP3_CTRL_INMSEL_0                                 ((uint32_t)0x00000002U)         /* Bit1*/
#define COMP3_CTRL_INMSEL_1                                 ((uint32_t)0x00000004U)         /* Bit2*/
#define COMP3_CTRL_INMSEL_2                                 ((uint32_t)0x00000008U)         /* Bit3*/
#define COMP3_CTRL_INMSEL_3                                 ((uint32_t)0x00000010U)         /* Bit4*/

#define COMP3_CTRL_EN                                       ((uint32_t)0x00000001U)         /* Bit[0] Comparator_3 enable*/

/******** Bit definition for COMP3_FILC register  ********/
#define COMP3_FILC_SAMPW                                    ((uint32_t)0x000007C0U)         /* Bit[10:6] Comparator_3 filter window size*/
#define COMP3_FILC_SAMPW_0                                  ((uint32_t)0x00000040U)         /* Bit6*/
#define COMP3_FILC_SAMPW_1                                  ((uint32_t)0x00000080U)         /* Bit7*/
#define COMP3_FILC_SAMPW_2                                  ((uint32_t)0x00000100U)         /* Bit8*/
#define COMP3_FILC_SAMPW_3                                  ((uint32_t)0x00000200U)         /* Bit9*/
#define COMP3_FILC_SAMPW_4                                  ((uint32_t)0x00000400U)         /* Bit10*/

#define COMP3_FILC_THRESH                                   ((uint32_t)0x0000003EU)         /* Bit[5:1] Comparator_3 filter threshold size*/
#define COMP3_FILC_THRESH_0                                 ((uint32_t)0x00000002U)         /* Bit1*/
#define COMP3_FILC_THRESH_1                                 ((uint32_t)0x00000004U)         /* Bit2*/
#define COMP3_FILC_THRESH_2                                 ((uint32_t)0x00000008U)         /* Bit3*/
#define COMP3_FILC_THRESH_3                                 ((uint32_t)0x00000010U)         /* Bit4*/
#define COMP3_FILC_THRESH_4                                 ((uint32_t)0x00000020U)         /* Bit5*/

#define COMP3_FILC_FILEN                                    ((uint32_t)0x00000001U)         /* Bit[0] Comparator_3 filter enable */

/******** Bit definition for COMP3_FILP register  ********/
#define COMP3_FILP_CLKPSC                                   ((uint32_t)0x0000FFFFU)         /* Bit[15:0] Comparator_3 filter sample clock prescale*/

/******** Bit definition for COMP4_CTRL register  ********/
#define COMP4_CTRL_OUT                                      ((uint32_t)0x00100000U)          /* Bit[20] Output state of Comparator_4*/

#define COMP4_CTRL_BLKINGEN                                 ((uint32_t)0x00100000U)          /* Bit[20] Comparator_4 Blanking enable*/

#define COMP4_CTRL_BLKING                                   ((uint32_t)0x000F0000U)         /* Bit[19:16] Blanking source select of Comparator_4*/
#define COMP4_CTRL_BLKING_0                                 ((uint32_t)0x00010000U)         /* Bit16*/
#define COMP4_CTRL_BLKING_1                                 ((uint32_t)0x00020000U)         /* Bit17*/
#define COMP4_CTRL_BLKING_2                                 ((uint32_t)0x00040000U)         /* Bit18*/
#define COMP4_CTRL_BLKING_3                                 ((uint32_t)0x00080000U)         /* Bit19*/

#define COMP4_CTRL_HYST                                     ((uint32_t)0x0000C000U)         /* Bit[15:14] Hysteresis level select of Comparator_4*/
#define COMP4_CTRL_HYST_0                                   ((uint32_t)0x00004000U)         /* Bit14*/
#define COMP4_CTRL_HYST_1                                   ((uint32_t)0x00008000U)         /* Bit15*/
#define COMP4_CTRL_POL                                      ((uint32_t)0x00002000U)         /* Bit[13] */

#define COMP4_CTRL_INPSEL                                   ((uint32_t)0x000001E0U)         /* Bit[8:5] Non inverting input select of Comparator_4*/
#define COMP4_CTRL_INPSEL_0                                 ((uint32_t)0x00000020U)         /* Bit5*/
#define COMP4_CTRL_INPSEL_1                                 ((uint32_t)0x00000040U)         /* Bit6*/
#define COMP4_CTRL_INPSEL_2                                 ((uint32_t)0x00000080U)         /* Bit7*/
#define COMP4_CTRL_INPSEL_3                                 ((uint32_t)0x00000100U)         /* Bit8*/

#define COMP4_CTRL_INMSEL                                   ((uint32_t)0x0000001EU)         /* Bit[4:1] Inverting input select of Comparator_4*/
#define COMP4_CTRL_INMSEL_0                                 ((uint32_t)0x00000002U)         /* Bit1*/
#define COMP4_CTRL_INMSEL_1                                 ((uint32_t)0x00000004U)         /* Bit2*/
#define COMP4_CTRL_INMSEL_2                                 ((uint32_t)0x00000008U)         /* Bit3*/
#define COMP4_CTRL_INMSEL_3                                 ((uint32_t)0x00000010U)         /* Bit4*/

#define COMP4_CTRL_EN                                       ((uint32_t)0x00000001U)         /* Bit[0] Comparator_4 enable*/

/******** Bit definition for COMP4_FILC register  ********/
#define COMP4_FILC_SAMPW                                    ((uint32_t)0x000007C0U)         /* Bit[10:6] Comparator_4 filter window size*/
#define COMP4_FILC_SAMPW_0                                  ((uint32_t)0x00000040U)         /* Bit6*/
#define COMP4_FILC_SAMPW_1                                  ((uint32_t)0x00000080U)         /* Bit7*/
#define COMP4_FILC_SAMPW_2                                  ((uint32_t)0x00000100U)         /* Bit8*/
#define COMP4_FILC_SAMPW_3                                  ((uint32_t)0x00000200U)         /* Bit9*/
#define COMP4_FILC_SAMPW_4                                  ((uint32_t)0x00000400U)         /* Bit10*/

#define COMP4_FILC_THRESH                                   ((uint32_t)0x0000003EU)         /* Bit[5:1] Comparator_4 filter threshold size*/
#define COMP4_FILC_THRESH_0                                 ((uint32_t)0x00000002U)         /* Bit1*/
#define COMP4_FILC_THRESH_1                                 ((uint32_t)0x00000004U)         /* Bit2*/
#define COMP4_FILC_THRESH_2                                 ((uint32_t)0x00000008U)         /* Bit3*/
#define COMP4_FILC_THRESH_3                                 ((uint32_t)0x00000010U)         /* Bit4*/
#define COMP4_FILC_THRESH_4                                 ((uint32_t)0x00000020U)         /* Bit5*/

#define COMP4_FILC_FILEN                                    ((uint32_t)0x00000001U)         /* Bit[0] Comparator_4 filter enable */

/******** Bit definition for COMP4_FILP register  ********/
#define COMP4_FILP_CLKPSC                                   ((uint32_t)0x0000FFFFU)         /* Bit[15:0] Comparator_4 filter sample clock prescale*/

/******** Bit definition for COMP_LPR register  ********/
#define COMP_LPR_CLKSEL                                     ((uint32_t)0x00000001U)         /* Bit[0] */

/******** Bit definition for COMP_WINMODE register  ********/
#define COMP_WINMODE_COMP34MD                                ((uint32_t)0x00000002U)         /* Bit[1] Comparator_3&4 XOR output*/
#define COMP_WINMODE_COMP12MD                                ((uint32_t)0x00000001U)         /* Bit[0] Comparator_1&2 XOR output*/

/******** Bit definition for COMP_LOCK register  ********/
#define COMP_LOCK_MASK                                      ((uint32_t)0x0000000FU)         /* All comparator lock enable */
#define COMP_LOCK_CMP4LK                                    ((uint32_t)0x00000008U)         /* Bit[3] */
#define COMP_LOCK_CMP3LK                                    ((uint32_t)0x00000004U)         /* Bit[2] */
#define COMP_LOCK_CMP2LK                                    ((uint32_t)0x00000002U)         /* Bit[1] */
#define COMP_LOCK_CMP1LK                                    ((uint32_t)0x00000001U)         /* Bit[0] */

/******** Bit definition for COMP_INTEN register  ********/
#define COMP_INTEN_MASK                                     ((uint32_t)0x0000000FU)         /* Interrupt enable for all COMP */
#define COMP_INTEN_CMP4IEN                                  ((uint32_t)0x00000008U)         /* Bit[3] */
#define COMP_INTEN_CMP3IEN                                  ((uint32_t)0x00000004U)         /* Bit[2] */
#define COMP_INTEN_CMP2IEN                                  ((uint32_t)0x00000002U)         /* Bit[1] */
#define COMP_INTEN_CMP1IEN                                  ((uint32_t)0x00000001U)         /* Bit[0] */

/******** Bit definition for COMP_STS register  ********/
#define COMP_STS_MASK                                       ((uint32_t)0x0000007FU)         /* status of all Comparator */
#define COMP_STS_CMP4IS                                     ((uint32_t)0x00000008U)         /* Bit[3] */
#define COMP_STS_CMP3IS                                     ((uint32_t)0x00000004U)         /* Bit[2] */
#define COMP_STS_CMP2IS                                     ((uint32_t)0x00000002U)         /* Bit[1] */
#define COMP_STS_CMP1IS                                     ((uint32_t)0x00000001U)         /* Bit[0] */

/******** Bit definition for COMP_OTIMEN register  ********/
#define COMP_OTIMEN_MASK                                    ((uint32_t)0x0000000FU)         /* Output to timer for all Comparator */
#define COMP_OTIMEN_CMP4OEN                                 ((uint32_t)0x00000008U)         /* Bit[3] */
#define COMP_OTIMEN_CMP3OEN                                 ((uint32_t)0x00000004U)         /* Bit[2] */
#define COMP_OTIMEN_CMP2OEN                                 ((uint32_t)0x00000002U)         /* Bit[1] */
#define COMP_OTIMEN_CMP1OEN                                 ((uint32_t)0x00000001U)         /* Bit[0] */

/*** VREFBUF ***/
/******** Bit definition for VREFBUF_TRIM1 register  ********/
#define VREFBUF_TRIM1_2_5V_MASK                             ((uint32_t)0x003F0000U)         /* VREFBUF 2.5V TRIMMING*/
#define VREFBUF_TRIM1_2_048V_MASK                           ((uint32_t)0x0FC00000U)         /* VREFBUF 2.048V TRIMMING */

/******** Bit definition for VREFBUF_STS register  ********/
#define VREFBUF_STS_RDY                                     ((uint32_t)0x20000000U)         /* VREFBUF ready flag */

/******** Bit definition for VREFBUF_CTRL1 register  ********/
#define VREFBUF_CTRL1_EN                                    ((uint32_t)0x00000080U)         /* VREFBUF enable */
#define VREFBUF_CTRL1_HIM                                   ((uint32_t)0x00000200U)         /* VREFBUF high implement enable */

/******** Bit definition for VREFBUF_CTRL2 register  ********/
#define VREFBUF_CTRL2_VLSEL                                 ((uint32_t)0x00000003U) /* VLSEL[1:0]*/ 
#define VREFBUF_CTRL2_VLSEL_0                               ((uint32_t)0x00000001U) /* Bit 0 */ 
#define VREFBUF_CTRL2_VLSEL_1                               ((uint32_t)0x00000002U) /* Bit 1 */ 

/******** Bit definition for VREFBUF_TRIM1 register  ********/
#define VREFBUF_TRIM1_1_5V_MASK                             ((uint32_t)0x00003F00U)         /* VREFBUF 1.5V TRIMMING*/
#define VREFBUF_TRIM1_1_8V_MASK                             ((uint32_t)0x0000003FU)         /* VREFBUF 1.8V TRIMMING */


/*** TIM ***/

/** Bit definition for TIM_CTRL1 register  **/
#define TIM_CTRL1_CNTEN                         ((uint32_t)0x00000001U) /* Counter enable */
#define TIM_CTRL1_DIR                           ((uint32_t)0x00000002U) /* Direction */

#define TIM_CTRL1_CAMSEL                        ((uint32_t)0x0000000CU) /* CMS[1:0] bits (Center-aligned mode selection) */
#define TIM_CTRL1_CAMSEL_0                      ((uint32_t)0x00000004U) /* Bit 0 */
#define TIM_CTRL1_CAMSEL_1                      ((uint32_t)0x00000008U) /* Bit 1 */

#define TIM_CTRL1_UPRS                          ((uint32_t)0x00000010U) /* Update request source */
#define TIM_CTRL1_UPDIS                         ((uint32_t)0x00000020U) /* Update disable */

#define TIM_CTRL1_CLKD                          ((uint32_t)0x000000C0U) /* CKD[1:0] bits (clock division) */
#define TIM_CTRL1_CLKD_0                        ((uint32_t)0x00000040U) /* Bit 0 */
#define TIM_CTRL1_CLKD_1                        ((uint32_t)0x00000080U) /* Bit 1 */

#define TIM_CTRL1_ONEPM                         ((uint32_t)0x00000100U) /* One pulse mode */
#define TIM_CTRL1_ARPEN                         ((uint32_t)0x00000200U) /* Auto-reload preload enable */
#define TIM_CTRL1_LBKPEN                        ((uint32_t)0x00000400U) /* LOCKUP as bkp Enable*/
#define TIM_CTRL1_PBKPEN                        ((uint32_t)0x00000800U) /* PVD as bkp Enable */
#define TIM_CTRL1_SMPARERREN                    ((uint32_t)0x00001000U) /* Sram parity error as bkp Enable */
#define TIM_CTRL1_CLRSEL                        ((uint32_t)0x00002000U) /* OCxRef clear selection */
#define TIM_CTRL1_SMECCERREN                    ((uint32_t)0x00008000U) /* Sram ecc error as bkp Enable */

#define TIM_CTRL1_C1SEL                         ((uint32_t)0x00010000U) /* Channel 1 selection */
#define TIM_CTRL1_C2SEL                         ((uint32_t)0x00020000U) /* Channel 2 selection */
#define TIM_CTRL1_C3SEL                         ((uint32_t)0x00040000U) /* Channel 3 selection */
#define TIM_CTRL1_C4SEL                         ((uint32_t)0x00080000U) /* Channel 4 selection */

#define TIM_CTRL1_CMODE                         ((uint32_t)0x00300000U)  /* In center-aligned mode, channel 4/7/8/9 trigger mode */
#define TIM_CTRL1_CMODE_0                       ((uint32_t)0x00100000U)  /* Bit0 */
#define TIM_CTRL1_CMODE_1                       ((uint32_t)0x00200000U)  /* Bit1 */

#define TIM_CTRL1_ASMMETRIC                     ((uint32_t)0x00800000U)  /* Asynmmetric mode enable in center-aligned */
#define TIM_CTRL1_UDITFREMAP                    ((uint32_t)0x01000000U)  /* UDITF status bit remapping */

/** Bit definition for TIM_CTRL2 register **/
#define TIM_CTRL2_OI1                           ((uint32_t)0x00000001U) /* Output Idle state 1 (OC1 output) */
#define TIM_CTRL2_OI1N                          ((uint32_t)0x00000002U) /* Output Idle state 1 (OC1N output) */
#define TIM_CTRL2_OI2                           ((uint32_t)0x00000004U) /* Output Idle state 2 (OC2 output) */
#define TIM_CTRL2_OI2N                          ((uint32_t)0x00000008U) /* Output Idle state 2 (OC2N output) */
#define TIM_CTRL2_OI3                           ((uint32_t)0x00000010U) /* Output Idle state 3 (OC3 output) */
#define TIM_CTRL2_OI3N                          ((uint32_t)0x00000020U) /* Output Idle state 3 (OC3N output) */
#define TIM_CTRL2_OI4                           ((uint32_t)0x00000040U) /* Output Idle state 4 (OC4 output) */
#define TIM_CTRL2_OI4N                          ((uint32_t)0x00000080U) /* Output Idle state 4 (OC4N output) */
#define TIM_CTRL2_OI5                           ((uint32_t)0x00000100U) /* Output Idle state 5 (OC5 output) */
#define TIM_CTRL2_OI6                           ((uint32_t)0x00000400U) /* Output Idle state 6 (OC6 output) */

#define TIM_CTRL2_MMSEL                         ((uint32_t)0x0000F000U) /* MMSEL[3:0] bits (Master Mode Selection) */
#define TIM_CTRL2_MMSEL_0                       ((uint32_t)0x00001000U) /* Bit 0 */
#define TIM_CTRL2_MMSEL_1                       ((uint32_t)0x00002000U) /* Bit 1 */
#define TIM_CTRL2_MMSEL_2                       ((uint32_t)0x00004000U) /* Bit 2 */
#define TIM_CTRL2_MMSEL_3                       ((uint32_t)0x00008000U) /* Bit 3 */

#define TIM_CTRL2_CCUSEL                        ((uint32_t)0x00010000U) /* Capture/Compare Control Update Selection */
#define TIM_CTRL2_CCDSEL                        ((uint32_t)0x00020000U) /* Capture/Compare DMA Selection */
#define TIM_CTRL2_CCPCTL                        ((uint32_t)0x00040000U) /* Capture/Compare Preloaded Control */
#define TIM_CTRL2_TI1SEL                        ((uint32_t)0x00080000U) /* TI1 Selection */
#define TIM_CTRL2_TRIG4                         ((uint32_t)0x00100000U) /* OC4REF trigger to ADC enable */
#define TIM_CTRL2_TRIG7                         ((uint32_t)0x00200000U) /* OC7REF trigger to ADC enable */
#define TIM_CTRL2_TRIG8                         ((uint32_t)0x00400000U) /* OC7REF trigger to ADC enable */
#define TIM_CTRL2_TRIG9                         ((uint32_t)0x00800000U) /* OC7REF trigger to ADC enable */

#define TIM_CTRL2_MMSEL2                        ((uint32_t)0x0F000000U) /* MMSEL2[3:0] bits (Master Mode Selection) */
#define TIM_CTRL2_MMSEL2_0                      ((uint32_t)0x01000000U) /* Bit 0 */
#define TIM_CTRL2_MMSEL2_1                      ((uint32_t)0x02000000U) /* Bit 1 */
#define TIM_CTRL2_MMSEL2_2                      ((uint32_t)0x04000000U) /* Bit 2 */
#define TIM_CTRL2_MMSEL2_3                      ((uint32_t)0x08000000U) /* Bit 3 */

/** Bit definition for TIM_STS register **/
#define TIM_STS_CC1ITF                          ((uint32_t)0x00000001U) /* Capture/Compare 1 interrupt Flag */
#define TIM_STS_CC2ITF                          ((uint32_t)0x00000002U) /* Capture/Compare 2 interrupt Flag */
#define TIM_STS_CC3ITF                          ((uint32_t)0x00000004U) /* Capture/Compare 3 interrupt Flag */
#define TIM_STS_CC4ITF                          ((uint32_t)0x00000008U) /* Capture/Compare 4 interrupt Flag */
#define TIM_STS_CC5ITF                          ((uint32_t)0x00000010U) /* Capture/Compare 5 interrupt Flag */
#define TIM_STS_CC6ITF                          ((uint32_t)0x00000020U) /* Capture/Compare 6 interrupt Flag */
#define TIM_STS_CC1OCF                          ((uint32_t)0x00000100U) /* Capture/Compare 1 Overcapture Flag */
#define TIM_STS_CC2OCF                          ((uint32_t)0x00000200U) /* Capture/Compare 2 Overcapture Flag */
#define TIM_STS_CC3OCF                          ((uint32_t)0x00000400U) /* Capture/Compare 3 Overcapture Flag */
#define TIM_STS_CC4OCF                          ((uint32_t)0x00000800U) /* Capture/Compare 4 Overcapture Flag */
#define TIM_STS_UDITF                           ((uint32_t)0x00010000U) /* Update interrupt Flag */
#define TIM_STS_COMITF                          ((uint32_t)0x00020000U) /* COM interrupt Flag */
#define TIM_STS_TITF                            ((uint32_t)0x00040000U) /* Trigger interrupt Flag */
#define TIM_STS_BITF                            ((uint32_t)0x00080000U) /* Break interrupt Flag */
#define TIM_STS_BITF2                           ((uint32_t)0x00100000U) /* Break2 interrupt Flag */
#define TIM_STS_SBITF                           ((uint32_t)0x00200000U) /* System Break interrupt Flag */
#define TIM_STS_CC7ITF                          ((uint32_t)0x01000000U) /* Capture/Compare 7 interrupt Flag */
#define TIM_STS_CC8ITF                          ((uint32_t)0x02000000U) /* Capture/Compare 8 interrupt Flag */
#define TIM_STS_CC9ITF                          ((uint32_t)0x04000000U) /* Capture/Compare 9 interrupt Flag */

/** Bit definition for TIM_EVTGEN register **/
#define TIM_EVTGEN_CC1GN                        ((uint32_t)0x00000001U) /* Capture/Compare 1 Generation */
#define TIM_EVTGEN_CC2GN                        ((uint32_t)0x00000002U) /* Capture/Compare 2 Generation */
#define TIM_EVTGEN_CC3GN                        ((uint32_t)0x00000004U) /* Capture/Compare 3 Generation */
#define TIM_EVTGEN_CC4GN                        ((uint32_t)0x00000008U) /* Capture/Compare 4 Generation */
#define TIM_EVTGEN_UDGN                         ((uint32_t)0x00000100U) /* Update Generation */
#define TIM_EVTGEN_CCUDGN                       ((uint32_t)0x00000200U) /* Capture/Compare Control Update Generation */
#define TIM_EVTGEN_TGN                          ((uint32_t)0x00000400U) /* Trigger Generation */
#define TIM_EVTGEN_BGN                          ((uint32_t)0x00000800U) /* Break Generation */
#define TIM_EVTGEN_BGN2                         ((uint32_t)0x00001000U) /* Break2 Generation */

/** Bit definition for TIM_SMCTRL register **/
#define TIM_SMCTRL_TSEL                         ((uint32_t)0x00000007U) /* TS[2:0] bits (Trigger selection) */
#define TIM_SMCTRL_TSEL_0                       ((uint32_t)0x00000001U) /* Bit 0 */
#define TIM_SMCTRL_TSEL_1                       ((uint32_t)0x00000002U) /* Bit 1 */
#define TIM_SMCTRL_TSEL_2                       ((uint32_t)0x00000004U) /* Bit 2 */

#define TIM_SMCTRL_SMSEL                        ((uint32_t)0x000000F0U) /* SMS[2:0] bits (Slave mode selection) */
#define TIM_SMCTRL_SMSEL_0                      ((uint32_t)0x00000010U) /* Bit 0 */
#define TIM_SMCTRL_SMSEL_1                      ((uint32_t)0x00000020U) /* Bit 1 */
#define TIM_SMCTRL_SMSEL_2                      ((uint32_t)0x00000040U) /* Bit 2 */
#define TIM_SMCTRL_SMSEL_3                      ((uint32_t)0x00000080U) /* Bit 3 */

#define TIM_SMCTRL_EXTPS                        ((uint32_t)0x00000300U) /* ETPS[1:0] bits (External trigger prescaler) */
#define TIM_SMCTRL_EXTPS_0                      ((uint32_t)0x00000100U) /* Bit 0 */
#define TIM_SMCTRL_EXTPS_1                      ((uint32_t)0x00000200U) /* Bit 1 */

#define TIM_SMCTRL_EXCEN                        ((uint32_t)0x00000400U) /* External clock enable */
#define TIM_SMCTRL_EXTP                         ((uint32_t)0x00000800U) /* External trigger polarity */

#define TIM_SMCTRL_EXTF                         ((uint32_t)0x0000F000U) /* ETF[3:0] bits (External trigger filter) */
#define TIM_SMCTRL_EXTF_0                       ((uint32_t)0x00001000U) /* Bit 0 */
#define TIM_SMCTRL_EXTF_1                       ((uint32_t)0x00002000U) /* Bit 1 */
#define TIM_SMCTRL_EXTF_2                       ((uint32_t)0x00004000U) /* Bit 2 */
#define TIM_SMCTRL_EXTF_3                       ((uint32_t)0x00008000U) /* Bit 3 */

#define TIM_SMCTRL_MSMD                         ((uint32_t)0x00010000U) /* Master/slave mode */

#define TIM_SMCTRL_OCREFCLRP                    ((uint32_t)0x00080000U) /* Ocrefclear signal polarity */

#define TIM_SMCTRL_OCREFCLRF                    ((uint32_t)0x00F00000U) /* OCREFCLRF[3:0] bits (Ocrefclear signal prescaler) */
#define TIM_SMCTRL_OCREFCLRF_0                  ((uint32_t)0x00100000U) /* Bit 0 */
#define TIM_SMCTRL_OCREFCLRF_1                  ((uint32_t)0x00200000U) /* Bit 1 */
#define TIM_SMCTRL_OCREFCLRF_2                  ((uint32_t)0x00400000U) /* Bit 2 */
#define TIM_SMCTRL_OCREFCLRF_3                  ((uint32_t)0x00800000U) /* Bit 3 */

/** Bit definition for TIM_DINTEN register **/
#define TIM_DINTEN_CC1IEN                       ((uint32_t)0x00000001U) /* Capture/Compare 1 interrupt enable */
#define TIM_DINTEN_CC2IEN                       ((uint32_t)0x00000002U) /* Capture/Compare 2 interrupt enable */
#define TIM_DINTEN_CC3IEN                       ((uint32_t)0x00000004U) /* Capture/Compare 3 interrupt enable */
#define TIM_DINTEN_CC4IEN                       ((uint32_t)0x00000008U) /* Capture/Compare 4 interrupt enable */
#define TIM_DINTEN_CC5IEN                       ((uint32_t)0x00000010U) /* Capture/Compare 5 interrupt enable */
#define TIM_DINTEN_CC6IEN                       ((uint32_t)0x00000020U) /* Capture/Compare 6 interrupt enable */
#define TIM_DINTEN_CC7IEN                       ((uint32_t)0x00000040U) /* Capture/Compare 7 interrupt enable */
#define TIM_DINTEN_CC8IEN                       ((uint32_t)0x00000080U) /* Capture/Compare 8 interrupt enable */
#define TIM_DINTEN_CC1DEN                       ((uint32_t)0x00000100U) /* Capture/Compare 1 DMA request enable */
#define TIM_DINTEN_CC2DEN                       ((uint32_t)0x00000200U) /* Capture/Compare 2 DMA request enable */
#define TIM_DINTEN_CC3DEN                       ((uint32_t)0x00000400U) /* Capture/Compare 3 DMA request enable */
#define TIM_DINTEN_CC4DEN                       ((uint32_t)0x00000800U) /* Capture/Compare 4 DMA request enable */
#define TIM_DINTEN_UIEN                         ((uint32_t)0x00010000U) /* Update interrupt enable */
#define TIM_DINTEN_TIEN                         ((uint32_t)0x00020000U) /* Trigger interrupt enable */
#define TIM_DINTEN_BIEN                         ((uint32_t)0x00040000U) /* Break interrupt enable */
#define TIM_DINTEN_UDEN                         ((uint32_t)0x00080000U) /* Update DMA request enable */
#define TIM_DINTEN_COMDEN                       ((uint32_t)0x00100000U) /* COM DMA request enable */
#define TIM_DINTEN_TDEN                         ((uint32_t)0x00200000U) /* Trigger DMA request enable */
#define TIM_DINTEN_COMIEN                       ((uint32_t)0x00400000U) /* COM interrupt enable */
#define TIM_DINTEN_CC9IEN                       ((uint32_t)0x00800000U) /* Capture/Compare 9 interrupt enable */

/** Bit definition for TIM_CCMOD1 register **/
#define TIM_CCMOD1_CC1SEL                       ((uint32_t)0x00000003U) /* CC1S[1:0] bits (Capture/Compare 1 Selection) */
#define TIM_CCMOD1_CC1SEL_0                     ((uint32_t)0x00000001U) /* Bit 0 */
#define TIM_CCMOD1_CC1SEL_1                     ((uint32_t)0x00000002U) /* Bit 1 */

#define TIM_CCMOD1_OC1PEN                       ((uint32_t)0x00000004U) /* Output Compare 1 Preload enable */
#define TIM_CCMOD1_OC1FEN                       ((uint32_t)0x00000008U) /* Output Compare 1 Fast enable */
#define TIM_CCMOD1_OC1CEN                       ((uint32_t)0x00000010U) /* Output Compare 1 Clear Enable */

#define TIM_CCMOD1_OC1MD                        ((uint32_t)0x000000E0U) /* OC1MD[2:0] bits (Output Compare 1 Mode) */
#define TIM_CCMOD1_OC1MD_0                      ((uint32_t)0x00000020U) /* Bit 0 */
#define TIM_CCMOD1_OC1MD_1                      ((uint32_t)0x00000040U) /* Bit 1 */
#define TIM_CCMOD1_OC1MD_2                      ((uint32_t)0x00000080U) /* Bit 2 */

#define TIM_CCMOD1_CC2SEL                       ((uint32_t)0x00000300U) /* CC2S[1:0] bits (Capture/Compare 2 Selection) */
#define TIM_CCMOD1_CC2SEL_0                     ((uint32_t)0x00000100U) /* Bit 0 */
#define TIM_CCMOD1_CC2SEL_1                     ((uint32_t)0x00000200U) /* Bit 1 */

#define TIM_CCMOD1_OC2PEN                       ((uint32_t)0x00000400U) /* Output Compare 2 Preload enable */
#define TIM_CCMOD1_OC2FEN                       ((uint32_t)0x00000800U) /* Output Compare 2 Fast enable */
#define TIM_CCMOD1_OC2CEN                       ((uint32_t)0x00001000U) /* Output Compare 2 Clear Enable */

#define TIM_CCMOD1_OC2MD                        ((uint32_t)0x0000E000U) /* OC2MD[2:0] bits (Output Compare 2 Mode) */
#define TIM_CCMOD1_OC2MD_0                      ((uint32_t)0x00002000U) /* Bit 0 */
#define TIM_CCMOD1_OC2MD_1                      ((uint32_t)0x00004000U) /* Bit 1 */
#define TIM_CCMOD1_OC2MD_2                      ((uint32_t)0x00008000U) /* Bit 2 */

#define TIM_CCMOD1_OC1MD_3                      ((uint32_t)0x00020000U) /* OC1MD3 bit (Output Compare 1 Mode) */
#define TIM_CCMOD1_OC2MD_3                      ((uint32_t)0x00040000U) /* OC2MD3 bit (Output Compare 2 Mode) */

#define TIM_CCMOD1_IC1PSC                       ((uint32_t)0x0000000CU) /* IC1PSC[1:0] bits (Input Capture 1 Prescaler) */
#define TIM_CCMOD1_IC1PSC_0                     ((uint32_t)0x00000004U) /* Bit 0 */
#define TIM_CCMOD1_IC1PSC_1                     ((uint32_t)0x00000008U) /* Bit 1 */

#define TIM_CCMOD1_IC1F                         ((uint32_t)0x000000F0U) /* IC1F[3:0] bits (Input Capture 1 Filter) */
#define TIM_CCMOD1_IC1F_0                       ((uint32_t)0x00000010U) /* Bit 0 */
#define TIM_CCMOD1_IC1F_1                       ((uint32_t)0x00000020U) /* Bit 1 */
#define TIM_CCMOD1_IC1F_2                       ((uint32_t)0x00000040U) /* Bit 2 */
#define TIM_CCMOD1_IC1F_3                       ((uint32_t)0x00000080U) /* Bit 3 */

#define TIM_CCMOD1_IC2PSC                       ((uint32_t)0x00000C00U) /* IC2PSC[1:0] bits (Input Capture 2 Prescaler) */
#define TIM_CCMOD1_IC2PSC_0                     ((uint32_t)0x00000400U) /* Bit 0 */
#define TIM_CCMOD1_IC2PSC_1                     ((uint32_t)0x00000800U) /* Bit 1 */

#define TIM_CCMOD1_IC2F                         ((uint32_t)0x0000F000U) /* IC2F[3:0] bits (Input Capture 2 Filter) */
#define TIM_CCMOD1_IC2F_0                       ((uint32_t)0x00001000U) /* Bit 0 */
#define TIM_CCMOD1_IC2F_1                       ((uint32_t)0x00002000U) /* Bit 1 */
#define TIM_CCMOD1_IC2F_2                       ((uint32_t)0x00004000U) /* Bit 2 */
#define TIM_CCMOD1_IC2F_3                       ((uint32_t)0x00008000U) /* Bit 3 */

/** Bit definition for TIM_CCMOD2 register **/
#define TIM_CCMOD2_CC3SEL                       ((uint32_t)0x00000003U) /* CC3S[1:0] bits (Capture/Compare 3 Selection) */
#define TIM_CCMOD2_CC3SEL_0                     ((uint32_t)0x00000001U) /* Bit 0 */
#define TIM_CCMOD2_CC3SEL_1                     ((uint32_t)0x00000002U) /* Bit 1 */

#define TIM_CCMOD2_OC3PEN                       ((uint32_t)0x00000004U) /* Output Compare 3 Preload enable */
#define TIM_CCMOD2_OC3FEN                       ((uint32_t)0x00000008U) /* Output Compare 3 Fast enable */
#define TIM_CCMOD2_OC3CEN                       ((uint32_t)0x00000010U) /* Output Compare 3 Clear Enable */

#define TIM_CCMOD2_OC3MD                        ((uint32_t)0x000000E0U) /* OC3MD[2:0] bits (Output Compare 3 Mode) */
#define TIM_CCMOD2_OC3MD_0                      ((uint32_t)0x00000020U) /* Bit 0 */
#define TIM_CCMOD2_OC3MD_1                      ((uint32_t)0x00000040U) /* Bit 1 */
#define TIM_CCMOD2_OC3MD_2                      ((uint32_t)0x00000080U) /* Bit 2 */

#define TIM_CCMOD2_CC4SEL                       ((uint32_t)0x00000300U) /* CC3S[1:0] bits (Capture/Compare 4 Selection) */
#define TIM_CCMOD2_CC4SEL_0                     ((uint32_t)0x00000100U) /* Bit 0 */
#define TIM_CCMOD2_CC4SEL_1                     ((uint32_t)0x00000200U) /* Bit 1 */

#define TIM_CCMOD2_OC4PEN                       ((uint32_t)0x00000400U) /* Output Compare 4 Preload enable */
#define TIM_CCMOD2_OC4FEN                       ((uint32_t)0x00000800U) /* Output Compare 4 Fast enable */
#define TIM_CCMOD2_OC4CEN                       ((uint32_t)0x00001000U) /* Output Compare 4 Clear Enable */

#define TIM_CCMOD2_OC4MD                        ((uint32_t)0x0000E000U) /* OC4MD[2:0] bits (Output Compare 4 Mode) */
#define TIM_CCMOD2_OC4MD_0                      ((uint32_t)0x00002000U) /* Bit 0 */
#define TIM_CCMOD2_OC4MD_1                      ((uint32_t)0x00004000U) /* Bit 1 */
#define TIM_CCMOD2_OC4MD_2                      ((uint32_t)0x00008000U) /* Bit 2 */

#define TIM_CCMOD2_OC3MD_3                      ((uint32_t)0x00020000U) /* OC3MD3 bit (Output Compare 3 Mode) */
#define TIM_CCMOD2_OC4MD_3                      ((uint32_t)0x00040000U) /* OC4MD3 bit (Output Compare 4 Mode) */

#define TIM_CCMOD2_IC3PSC                       ((uint32_t)0x0000000CU) /* IC3PSC[1:0] bits (Input Capture 3 Prescaler) */
#define TIM_CCMOD2_IC3PSC_0                     ((uint32_t)0x00000004U) /* Bit 0 */
#define TIM_CCMOD2_IC3PSC_1                     ((uint32_t)0x00000008U) /* Bit 1 */

#define TIM_CCMOD2_IC3F                         ((uint32_t)0x000000F0U) /* IC3F[3:0] bits (Input Capture 3 Filter) */
#define TIM_CCMOD2_IC3F_0                       ((uint32_t)0x00000010U) /* Bit 0 */
#define TIM_CCMOD2_IC3F_1                       ((uint32_t)0x00000020U) /* Bit 1 */
#define TIM_CCMOD2_IC3F_2                       ((uint32_t)0x00000040U) /* Bit 2 */
#define TIM_CCMOD2_IC3F_3                       ((uint32_t)0x00000080U) /* Bit 3 */

#define TIM_CCMOD2_IC4PSC                       ((uint32_t)0x00000C00U) /* IC4PSC[1:0] bits (Input Capture 4 Prescaler) */
#define TIM_CCMOD2_IC4PSC_0                     ((uint32_t)0x00000400U) /* Bit 0 */
#define TIM_CCMOD2_IC4PSC_1                     ((uint32_t)0x00000800U) /* Bit 1 */

#define TIM_CCMOD2_IC4F                         ((uint32_t)0x0000F000U) /* IC4F[3:0] bits (Input Capture 4 Filter) */
#define TIM_CCMOD2_IC4F_0                       ((uint32_t)0x00001000U) /* Bit 0 */
#define TIM_CCMOD2_IC4F_1                       ((uint32_t)0x00002000U) /* Bit 1 */
#define TIM_CCMOD2_IC4F_2                       ((uint32_t)0x00004000U) /* Bit 2 */
#define TIM_CCMOD2_IC4F_3                       ((uint32_t)0x00008000U) /* Bit 3 */

/** Bit definition for TIM_CCMOD3 register **/
#define TIM_CCMOD3_OC5PEN                       ((uint32_t)0x00000004U) /* Output Compare 5 Preload enable */
#define TIM_CCMOD3_OC5FEN                       ((uint32_t)0x00000008U) /* Output Compare 5 Fast enable */
#define TIM_CCMOD3_OC5CEN                       ((uint32_t)0x00000010U) /* Output Compare 5 Clear Enable */

#define TIM_CCMOD3_OC5MD                        ((uint32_t)0x000000E0U) /* OC5M[2:0] bits (Output Compare 5 Mode) */
#define TIM_CCMOD3_OC5MD_0                      ((uint32_t)0x00000020U) /* Bit 0 */
#define TIM_CCMOD3_OC5MD_1                      ((uint32_t)0x00000040U) /* Bit 1 */
#define TIM_CCMOD3_OC5MD_2                      ((uint32_t)0x00000080U) /* Bit 2 */

#define TIM_CCMOD3_OC6PEN                       ((uint32_t)0x00000400U) /* Output Compare 6 Preload enable */
#define TIM_CCMOD3_OC6FEN                       ((uint32_t)0x00000800U) /* Output Compare 6 Fast enable */
#define TIM_CCMOD3_OC6CEN                       ((uint32_t)0x00001000U) /* Output Compare 6 Clear Enable */

#define TIM_CCMOD3_OC6MD                        ((uint32_t)0x0000E000U) /* OC6M[2:0] bits (Output Compare 6 Mode) */
#define TIM_CCMOD3_OC6MD_0                      ((uint32_t)0x00002000U) /* Bit 0 */
#define TIM_CCMOD3_OC6MD_1                      ((uint32_t)0x00004000U) /* Bit 1 */
#define TIM_CCMOD3_OC6MD_2                      ((uint32_t)0x00008000U) /* Bit 2 */

#define TIM_CCMOD3_OC7PEN                       ((uint32_t)0x00010000U) /* Output Compare 7 Preload enable */
#define TIM_CCMOD3_OC8PEN                       ((uint32_t)0x00100000U) /* Output Compare 8 Preload enable */
#define TIM_CCMOD3_OC9PEN                       ((uint32_t)0x01000000U) /* Output Compare 9 Preload enable */

/** Bit definition for TIM_CCEN register **/
#define TIM_CCEN_CC1NEN                         ((uint32_t)0x00000001U) /* Capture/Compare 1 Complementary output enable */
#define TIM_CCEN_CC1NP                          ((uint32_t)0x00000002U) /* Capture/Compare 1 Complementary output Polarity */
#define TIM_CCEN_CC1EN                          ((uint32_t)0x00000004U) /* Capture/Compare 1 output enable */
#define TIM_CCEN_CC1P                           ((uint32_t)0x00000008U) /* Capture/Compare 1 output Polarity */
#define TIM_CCEN_CC2NEN                         ((uint32_t)0x00000010U) /* Capture/Compare 2 Complementary output enable */
#define TIM_CCEN_CC2NP                          ((uint32_t)0x00000020U) /* Capture/Compare 2 Complementary output Polarity */
#define TIM_CCEN_CC2EN                          ((uint32_t)0x00000040U) /* Capture/Compare 2 output enable */
#define TIM_CCEN_CC2P                           ((uint32_t)0x00000080U) /* Capture/Compare 2 output Polarity */
#define TIM_CCEN_CC3NEN                         ((uint32_t)0x00000100U) /* Capture/Compare 3 Complementary output enable */
#define TIM_CCEN_CC3NP                          ((uint32_t)0x00000200U) /* Capture/Compare 3 Complementary output Polarity */
#define TIM_CCEN_CC3EN                          ((uint32_t)0x00000400U) /* Capture/Compare 3 output enable */
#define TIM_CCEN_CC3P                           ((uint32_t)0x00000800U) /* Capture/Compare 3 output Polarity */
#define TIM_CCEN_CC4NEN                         ((uint32_t)0x00001000U) /* Capture/Compare 4 Complementary output enable */
#define TIM_CCEN_CC4NP                          ((uint32_t)0x00002000U) /* Capture/Compare 4 Complementary output Polarity */
#define TIM_CCEN_CC4EN                          ((uint32_t)0x00004000U) /* Capture/Compare 4 output enable */
#define TIM_CCEN_CC4P                           ((uint32_t)0x00008000U) /* Capture/Compare 4 output Polarity */
#define TIM_CCEN_CC5EN                          ((uint32_t)0x00040000U) /* Capture/Compare 5 output enable */
#define TIM_CCEN_CC5P                           ((uint32_t)0x00080000U) /* Capture/Compare 5 output Polarity */
#define TIM_CCEN_CC6EN                          ((uint32_t)0x00400000U) /* Capture/Compare 6 output enable */
#define TIM_CCEN_CC6P                           ((uint32_t)0x00800000U) /* Capture/Compare 6 output Polarity */

/** Bit definition for TIM_CCDAT1 register **/
#define TIM_CCDAT1_CCDAT1                       ((uint32_t)0x0000FFFFU)  /* Capture/Compare 1 Value */
#define TIM_CCDAT1_CCDDAT1                      ((uint32_t)0xFFFF0000U)  /* Capture/Compare 1 down-counting Value */

/** Bit definition for TIM_CCDAT2 register **/
#define TIM_CCDAT2_CCDAT2                       ((uint32_t)0x0000FFFFU)  /* Capture/Compare 2 Value */
#define TIM_CCDAT2_CCDDAT2                      ((uint32_t)0xFFFF0000U)  /* Capture/Compare 2 down-counting Value */

/** Bit definition for TIM_CCDAT3 register **/
#define TIM_CCDAT3_CCDAT3                       ((uint32_t)0x0000FFFFU)  /* Capture/Compare 3 Value */
#define TIM_CCDAT3_CCDDAT3                      ((uint32_t)0xFFFF0000U)  /* Capture/Compare 3 down-counting Value */

/** Bit definition for TIM_CCDAT4 register **/
#define TIM_CCDAT4_CCDAT4                       ((uint32_t)0x0000FFFFU)  /* Capture/Compare 4 Value */
#define TIM_CCDAT4_CCDDAT4                      ((uint32_t)0xFFFF0000U)  /* Capture/Compare 4 down-counting Value */

/** Bit definition for TIM_CCDAT5 register **/
#define TIM_CCDAT5_CCDAT5                       ((uint32_t)0x0000FFFFU)  /* Capture/Compare 5 Value */

/** Bit definition for TIM_CCDAT6 register **/
#define TIM_CCDAT6_CCDAT6                       ((uint32_t)0x0000FFFFU)  /* Capture/Compare 6 Value */

/** Bit definition for TIM_PSC register **/
#define TIM_PSC_PSC                             ((uint32_t)0x0000FFFFU)  /* Prescaler Value */

/** Bit definition for TIM_AR register **/
#define TIM_AR_AR                               ((uint32_t)0x0000FFFFU)  /* actual auto-reload Value */

/** Bit definition for TIM_CNT register **/
#define TIM_CNT_CNT                             ((uint32_t)0xFFFFFFFFU)  /* Counter Value */

/** Bit definition for TIM_REPCNT register **/
#define TIM_REPCNT_REPCNT                       ((uint32_t)0x000000FFU) /* Repetition Counter Value */

/** Bit definition for TIM_BKDT register **/
#define TIM_BKDT_DTGN                           ((uint32_t)0x000000FFU) /* DTG[0:7] bits (Dead-Time Generator set-up) */
#define TIM_BKDT_DTGN_0                         ((uint32_t)0x00000001U) /* Bit 0 */
#define TIM_BKDT_DTGN_1                         ((uint32_t)0x00000002U) /* Bit 1 */
#define TIM_BKDT_DTGN_2                         ((uint32_t)0x00000004U) /* Bit 2 */
#define TIM_BKDT_DTGN_3                         ((uint32_t)0x00000008U) /* Bit 3 */
#define TIM_BKDT_DTGN_4                         ((uint32_t)0x00000010U) /* Bit 4 */
#define TIM_BKDT_DTGN_5                         ((uint32_t)0x00000020U) /* Bit 5 */
#define TIM_BKDT_DTGN_6                         ((uint32_t)0x00000040U) /* Bit 6 */
#define TIM_BKDT_DTGN_7                         ((uint32_t)0x00000080U) /* Bit 7 */

#define TIM_BKDT_MOEN                           ((uint32_t)0x00000100U) /* Main Output enable */
#define TIM_BKDT_AOEN                           ((uint32_t)0x00000200U) /* Automatic Output enable */
#define TIM_BKDT_BKP                            ((uint32_t)0x00000400U) /* Break Polarity */
#define TIM_BKDT_BKEN                           ((uint32_t)0x00000800U) /* Break enable */
#define TIM_BKDT_OSSI                           ((uint32_t)0x00001000U) /* Off-State Selection for Idle mode */
#define TIM_BKDT_OSSR                           ((uint32_t)0x00002000U) /* Off-State Selection for Run mode */

#define TIM_BKDT_LCKCFG                         ((uint32_t)0x0000C000U) /* LOCK[1:0] bits (Lock Configuration) */
#define TIM_BKDT_LCKCFG_0                       ((uint32_t)0x00004000U) /* Bit 0 */
#define TIM_BKDT_LCKCFG_1                       ((uint32_t)0x00008000U) /* Bit 1 */

#define TIM_BKDT_BK2P                           ((uint32_t)0x00010000U) /* Break2 Polarity */
#define TIM_BKDT_BK2EN                           ((uint32_t)0x00020000U) /* Break2 enable */
#define TIM_BKDT_BRKDSRM                        ((uint32_t)0x00040000U) /* Break disarm */
#define TIM_BKDT_BRK2DSRM                       ((uint32_t)0x00080000U) /* Break2 disarm */
#define TIM_BKDT_BRKBID                         ((uint32_t)0x00100000U) /* Break bidirectional enable */
#define TIM_BKDT_BRK2BID                        ((uint32_t)0x00200000U) /* Break2 bidirectional enable */

/** Bit definition for TIM_CCDAT7 register **/
#define TIM_CCDAT7_CCDAT7                       ((uint32_t)0x0000FFFFU)  /* Capture/Compare 7 Value */

/** Bit definition for TIM_CCDAT8 register **/
#define TIM_CCDAT8_CCDAT8                       ((uint32_t)0x0000FFFFU)  /* Capture/Compare 8 Value */

/** Bit definition for TIM_CCDAT9 register **/
#define TIM_CCDAT9_CCDAT9                       ((uint32_t)0x0000FFFFU)  /* Capture/Compare 9 Value */

/** Bit definition for TIM_BKFR register **/     
#define TIM_BKFR_THRESH                         ((uint32_t)0x3F000000U) /* Break1 filter threshold */
#define TIM_BKFR_THRESH_0                       ((uint32_t)0x01000000U) /* Bit 0 */
#define TIM_BKFR_THRESH_1                       ((uint32_t)0x02000000U) /* Bit 1 */
#define TIM_BKFR_THRESH_2                       ((uint32_t)0x04000000U) /* Bit 2 */
#define TIM_BKFR_THRESH_3                       ((uint32_t)0x08000000U) /* Bit 3 */
#define TIM_BKFR_THRESH_4                       ((uint32_t)0x10000000U) /* Bit 4 */
#define TIM_BKFR_THRESH_5                       ((uint32_t)0x20000000U) /* Bit 5 */

#define TIM_BKFR_WSIZE                          ((uint32_t)0x007E0000U) /* Break1 filter window size */
#define TIM_BKFR_WSIZE_0                        ((uint32_t)0x00020000U) /* Bit 0 */
#define TIM_BKFR_WSIZE_1                        ((uint32_t)0x00040000U) /* Bit 1 */
#define TIM_BKFR_WSIZE_2                        ((uint32_t)0x00080000U) /* Bit 2 */
#define TIM_BKFR_WSIZE_3                        ((uint32_t)0x00100000U) /* Bit 3 */
#define TIM_BKFR_WSIZE_4                        ((uint32_t)0x00200000U) /* Bit 4 */
#define TIM_BKFR_WSIZE_5                        ((uint32_t)0x00400000U) /* Bit 5 */

#define TIM_BKFR_FILTEN                         ((uint32_t)0x00010000U) /* Break1 filter enable */
#define TIM_BKFR_SFPSC                          ((uint32_t)0x0000FFFFU)  

/** Bit definition for TIM_C1FILT register **/
#define TIM_C1FILT_THRESH                       ((uint32_t)0x3F000000U) /* CH1 filter threshold */
#define TIM_C1FILT_THRESH_0                     ((uint32_t)0x01000000U) /* Bit 0 */
#define TIM_C1FILT_THRESH_1                     ((uint32_t)0x02000000U) /* Bit 1 */
#define TIM_C1FILT_THRESH_2                     ((uint32_t)0x04000000U) /* Bit 2 */
#define TIM_C1FILT_THRESH_3                     ((uint32_t)0x08000000U) /* Bit 3 */
#define TIM_C1FILT_THRESH_4                     ((uint32_t)0x10000000U) /* Bit 4 */
#define TIM_C1FILT_THRESH_5                     ((uint32_t)0x20000000U) /* Bit 5 */

#define TIM_C1FILT_WSIZE                        ((uint32_t)0x007E0000U) /* CH1 filter window size */
#define TIM_C1FILT_WSIZE_0                      ((uint32_t)0x00020000U) /* Bit 0 */
#define TIM_C1FILT_WSIZE_1                      ((uint32_t)0x00040000U) /* Bit 1 */
#define TIM_C1FILT_WSIZE_2                      ((uint32_t)0x00080000U) /* Bit 2 */
#define TIM_C1FILT_WSIZE_3                      ((uint32_t)0x00100000U) /* Bit 3 */
#define TIM_C1FILT_WSIZE_4                      ((uint32_t)0x00200000U) /* Bit 4 */
#define TIM_C1FILT_WSIZE_5                      ((uint32_t)0x00400000U) /* Bit 5 */

#define TIM_C1FILT_FILTEN                       ((uint32_t)0x00010000U)
#define TIM_C1FILT_SFPSC                        ((uint32_t)0x0000FFFFU)  

/** Bit definition for TIM_C2FILT register **/
#define TIM_C2FILT_THRESH                       ((uint32_t)0x3F000000U) /* CH2 filter threshold */
#define TIM_C2FILT_THRESH_0                     ((uint32_t)0x01000000U) /* Bit 0 */
#define TIM_C2FILT_THRESH_1                     ((uint32_t)0x02000000U) /* Bit 1 */
#define TIM_C2FILT_THRESH_2                     ((uint32_t)0x04000000U) /* Bit 2 */
#define TIM_C2FILT_THRESH_3                     ((uint32_t)0x08000000U) /* Bit 3 */
#define TIM_C2FILT_THRESH_4                     ((uint32_t)0x10000000U) /* Bit 4 */
#define TIM_C2FILT_THRESH_5                     ((uint32_t)0x20000000U) /* Bit 5 */

#define TIM_C2FILT_WSIZE                        ((uint32_t)0x007E0000U) /* CH2 filter window size */
#define TIM_C2FILT_WSIZE_0                      ((uint32_t)0x00020000U) /* Bit 0 */
#define TIM_C2FILT_WSIZE_1                      ((uint32_t)0x00040000U) /* Bit 1 */
#define TIM_C2FILT_WSIZE_2                      ((uint32_t)0x00080000U) /* Bit 2 */
#define TIM_C2FILT_WSIZE_3                      ((uint32_t)0x00100000U) /* Bit 3 */
#define TIM_C2FILT_WSIZE_4                      ((uint32_t)0x00200000U) /* Bit 4 */
#define TIM_C2FILT_WSIZE_5                      ((uint32_t)0x00400000U) /* Bit 5 */

#define TIM_C2FILT_FILTEN                       ((uint32_t)0x00010000U)
#define TIM_C2FILT_SFPSC                        ((uint32_t)0x0000FFFFU) 

/** Bit definition for TIM_C3FILT register **/
#define TIM_C3FILT_THRESH                       ((uint32_t)0x3F000000U) /* CH3 filter threshold */
#define TIM_C3FILT_THRESH_0                     ((uint32_t)0x01000000U) /* Bit 0 */
#define TIM_C3FILT_THRESH_1                     ((uint32_t)0x02000000U) /* Bit 1 */
#define TIM_C3FILT_THRESH_2                     ((uint32_t)0x04000000U) /* Bit 2 */
#define TIM_C3FILT_THRESH_3                     ((uint32_t)0x08000000U) /* Bit 3 */
#define TIM_C3FILT_THRESH_4                     ((uint32_t)0x10000000U) /* Bit 4 */
#define TIM_C3FILT_THRESH_5                     ((uint32_t)0x20000000U) /* Bit 5 */

#define TIM_C3FILT_WSIZE                        ((uint32_t)0x007E0000U) /* CH3 filter window size */
#define TIM_C3FILT_WSIZE_0                      ((uint32_t)0x00020000U) /* Bit 0 */
#define TIM_C3FILT_WSIZE_1                      ((uint32_t)0x00040000U) /* Bit 1 */
#define TIM_C3FILT_WSIZE_2                      ((uint32_t)0x00080000U) /* Bit 2 */
#define TIM_C3FILT_WSIZE_3                      ((uint32_t)0x00100000U) /* Bit 3 */
#define TIM_C3FILT_WSIZE_4                      ((uint32_t)0x00200000U) /* Bit 4 */
#define TIM_C3FILT_WSIZE_5                      ((uint32_t)0x00400000U) /* Bit 5 */

#define TIM_C3FILT_FILTEN                       ((uint32_t)0x00010000U)
#define TIM_C3FILT_SFPSC                        ((uint32_t)0x0000FFFFU) 

/** Bit definition for TIM_C4FILT register **/
#define TIM_C4FILT_THRESH                       ((uint32_t)0x3F000000U) /* CH4 filter threshold */
#define TIM_C4FILT_THRESH_0                     ((uint32_t)0x01000000U) /* Bit 0 */
#define TIM_C4FILT_THRESH_1                     ((uint32_t)0x02000000U) /* Bit 1 */
#define TIM_C4FILT_THRESH_2                     ((uint32_t)0x04000000U) /* Bit 2 */
#define TIM_C4FILT_THRESH_3                     ((uint32_t)0x08000000U) /* Bit 3 */
#define TIM_C4FILT_THRESH_4                     ((uint32_t)0x10000000U) /* Bit 4 */
#define TIM_C4FILT_THRESH_5                     ((uint32_t)0x20000000U) /* Bit 5 */

#define TIM_C4FILT_WSIZE                        ((uint32_t)0x007E0000U) /* CH4 filter window size */
#define TIM_C4FILT_WSIZE_0                      ((uint32_t)0x00020000U) /* Bit 0 */
#define TIM_C4FILT_WSIZE_1                      ((uint32_t)0x00040000U) /* Bit 1 */
#define TIM_C4FILT_WSIZE_2                      ((uint32_t)0x00080000U) /* Bit 2 */
#define TIM_C4FILT_WSIZE_3                      ((uint32_t)0x00100000U) /* Bit 3 */
#define TIM_C4FILT_WSIZE_4                      ((uint32_t)0x00200000U) /* Bit 4 */
#define TIM_C4FILT_WSIZE_5                      ((uint32_t)0x00400000U) /* Bit 5 */

#define TIM_C4FILT_FILTEN                       ((uint32_t)0x00010000U)
#define TIM_C4FILT_SFPSC                        ((uint32_t)0x0000FFFFU) 

/** Bit definition for TIM_FILTO register **/
#define TIM_FILTO_C1FILTO                       ((uint32_t)0x00000001U) /* CH1 filter output state */
#define TIM_FILTO_C2FILTO                       ((uint32_t)0x00000002U) /* CH2 filter output state */
#define TIM_FILTO_C3FILTO                       ((uint32_t)0x00000004U) /* CH3 filter output state */
#define TIM_FILTO_C4FILTO                       ((uint32_t)0x00000008U) /* CH4 filter output state */

/** Bit definition for TIM_INSEL register **/
#define TIM_INSEL_TI1S                          ((uint32_t)0x0000000FU) /* TI1 signal selection */
#define TIM_INSEL_TI1S_0                        ((uint32_t)0x00000001U) /* Bit 0 */
#define TIM_INSEL_TI1S_1                        ((uint32_t)0x00000002U) /* Bit 1 */
#define TIM_INSEL_TI1S_2                        ((uint32_t)0x00000004U) /* Bit 2 */
#define TIM_INSEL_TI1S_3                        ((uint32_t)0x00000008U) /* Bit 3 */

#define TIM_INSEL_TI2S                          ((uint32_t)0x000000F0U) /* TI2 signal selection */
#define TIM_INSEL_TI2S_0                        ((uint32_t)0x00000010U) /* Bit 0 */
#define TIM_INSEL_TI2S_1                        ((uint32_t)0x00000020U) /* Bit 1 */
#define TIM_INSEL_TI2S_2                        ((uint32_t)0x00000040U) /* Bit 2 */
#define TIM_INSEL_TI2S_3                        ((uint32_t)0x00000080U) /* Bit 3 */

#define TIM_INSEL_TI3S                          ((uint32_t)0x00000F00U) /* TI3 signal selection */
#define TIM_INSEL_TI3S_0                        ((uint32_t)0x00000100U) /* Bit 0 */
#define TIM_INSEL_TI3S_1                        ((uint32_t)0x00000200U) /* Bit 1 */
#define TIM_INSEL_TI3S_2                        ((uint32_t)0x00000400U) /* Bit 2 */
#define TIM_INSEL_TI3S_3                        ((uint32_t)0x00000800U) /* Bit 3 */

#define TIM_INSEL_TI4S                          ((uint32_t)0x0000F000U) /* TI4 signal selection */
#define TIM_INSEL_TI4S_0                        ((uint32_t)0x00001000U) /* Bit 0 */
#define TIM_INSEL_TI4S_1                        ((uint32_t)0x00002000U) /* Bit 1 */
#define TIM_INSEL_TI4S_2                        ((uint32_t)0x00004000U) /* Bit 2 */
#define TIM_INSEL_TI4S_3                        ((uint32_t)0x00008000U) /* Bit 3 */

#define TIM_INSEL_ETRS                          ((uint32_t)0x000F0000U) /* etr signal selection */
#define TIM_INSEL_ETRS_0                        ((uint32_t)0x00010000U) /* Bit 0 */
#define TIM_INSEL_ETRS_1                        ((uint32_t)0x00020000U) /* Bit 1 */
#define TIM_INSEL_ETRS_2                        ((uint32_t)0x00040000U) /* Bit 2 */
#define TIM_INSEL_ETRS_3                        ((uint32_t)0x00080000U) /* Bit 3 */

#define TIM_INSEL_ITRS                          ((uint32_t)0x00F00000U) /* itr signal selection */
#define TIM_INSEL_ITRS_0                        ((uint32_t)0x00100000U) /* Bit 0 */
#define TIM_INSEL_ITRS_1                        ((uint32_t)0x00200000U) /* Bit 1 */
#define TIM_INSEL_ITRS_2                        ((uint32_t)0x00400000U) /* Bit 2 */
#define TIM_INSEL_ITRS_3                        ((uint32_t)0x00800000U) /* Bit 3 */

#define TIM_INSEL_CLRS                          ((uint32_t)0x0F000000U) /* Ocrefclear signal selection */
#define TIM_INSEL_CLRS_0                        ((uint32_t)0x01000000U) /* Bit 0 */
#define TIM_INSEL_CLRS_1                        ((uint32_t)0x02000000U) /* Bit 1 */
#define TIM_INSEL_CLRS_2                        ((uint32_t)0x04000000U) /* Bit 2 */
#define TIM_INSEL_CLRS_3                        ((uint32_t)0x08000000U) /* Bit 3 */

/** Bit definition for TIM_AF1 register **/
#define TIM_AF1_IOMBRKEN                        ((uint32_t)0x00000001U) /* Enable IOM as break1 input */
#define TIM_AF1_COMP1BRKEN                      ((uint32_t)0x00000002U) /* Enable COMP1 as break1 input */
#define TIM_AF1_COMP2BRKEN                      ((uint32_t)0x00000004U) /* Enable COMP2 as break1 input */
#define TIM_AF1_COMP3BRKEN                      ((uint32_t)0x00000008U) /* Enable COMP3 as break1 input */
#define TIM_AF1_COMP4BRKEN                      ((uint32_t)0x00000010U) /* Enable COMP4 as break1 input */
#define TIM_AF1_DSMU0BRKEN                      ((uint32_t)0x01000000U) /* Enable DSMU0 as break1 input */
#define TIM_AF1_DSMU1BRKEN                      ((uint32_t)0x02000000U) /* Enable DSMU1 as break1 input */
#define TIM_AF1_DSMU2BRKEN                      ((uint32_t)0x04000000U) /* Enable DSMU2 as break1 input */
#define TIM_AF1_DSMU3BRKEN                      ((uint32_t)0x08000000U) /* Enable DSMU3 as break1 input */

#define TIM_AF1_IOMBRKP                         ((uint32_t)0x00000200U) /* Select polarity of break1 input from IOM */
#define TIM_AF1_COMP1BRKP                       ((uint32_t)0x00000400U) /* Select polarity of break1 input from COMP1 */
#define TIM_AF1_COMP2BRKP                       ((uint32_t)0x00000800U) /* Select polarity of break1 input from COMP2 */
#define TIM_AF1_COMP3BRKP                       ((uint32_t)0x00001000U) /* Select polarity of break1 input from COMP3 */
#define TIM_AF1_COMP4BRKP                       ((uint32_t)0x00002000U) /* Select polarity of break1 input from COMP4 */

/** Bit definition for TIM_AF2 register **/
#define TIM_AF2_IOMBRK2EN                       ((uint32_t)0x00000001U) /* Enable IOM as break2 input */
#define TIM_AF2_COMP1BRK2EN                     ((uint32_t)0x00000002U) /* Enable COMP1 as break2 input */
#define TIM_AF2_COMP2BRK2EN                     ((uint32_t)0x00000004U) /* Enable COMP2 as break2 input */
#define TIM_AF2_COMP3BRK2EN                     ((uint32_t)0x00000008U) /* Enable COMP3 as break2 input */
#define TIM_AF2_COMP4BRK2EN                     ((uint32_t)0x00000010U) /* Enable COMP4 as break2 input */
#define TIM_AF2_DSMU0BRK2EN                     ((uint32_t)0x01000000U) /* Enable DSMU0 as break2 input */
#define TIM_AF2_DSMU1BRK2EN                     ((uint32_t)0x02000000U) /* Enable DSMU1 as break2 input */
#define TIM_AF2_DSMU2BRK2EN                     ((uint32_t)0x04000000U) /* Enable DSMU2 as break2 input */
#define TIM_AF2_DSMU3BRK2EN                     ((uint32_t)0x08000000U) /* Enable DSMU3 as break2 input */


#define TIM_AF2_IOMBRK2P                        ((uint32_t)0x00000200U) /* Select polarity of break2 input from IOM */
#define TIM_AF2_COMP1BRK2P                      ((uint32_t)0x00000400U) /* Select polarity of break2 input from COMP1 */
#define TIM_AF2_COMP2BRK2P                      ((uint32_t)0x00000800U) /* Select polarity of break2 input from COMP2 */
#define TIM_AF2_COMP3BRK2P                      ((uint32_t)0x00001000U) /* Select polarity of break2 input from COMP3 */
#define TIM_AF2_COMP4BRK2P                      ((uint32_t)0x00002000U) /* Select polarity of break2 input from COMP4 */

/** Bit definition for TIM_BKFR2 register **/
#define TIM_BKFR2_THRESH                        ((uint32_t)0x3F000000U) /* Break2 filter threshold */
#define TIM_BKFR2_THRESH_0                      ((uint32_t)0x01000000U) /* Bit 0 */
#define TIM_BKFR2_THRESH_1                      ((uint32_t)0x02000000U) /* Bit 1 */
#define TIM_BKFR2_THRESH_2                      ((uint32_t)0x04000000U) /* Bit 2 */
#define TIM_BKFR2_THRESH_3                      ((uint32_t)0x08000000U) /* Bit 3 */
#define TIM_BKFR2_THRESH_4                      ((uint32_t)0x10000000U) /* Bit 4 */
#define TIM_BKFR2_THRESH_5                      ((uint32_t)0x20000000U) /* Bit 5 */

#define TIM_BKFR2_WSIZE                         ((uint32_t)0x007E0000U)  /* Break2 filter window size */
#define TIM_BKFR2_WSIZE_0                       ((uint32_t)0x00020000U) /* Bit 0 */
#define TIM_BKFR2_WSIZE_1                       ((uint32_t)0x00040000U) /* Bit 1 */
#define TIM_BKFR2_WSIZE_2                       ((uint32_t)0x00080000U) /* Bit 2 */
#define TIM_BKFR2_WSIZE_3                       ((uint32_t)0x00100000U) /* Bit 3 */
#define TIM_BKFR2_WSIZE_4                       ((uint32_t)0x00200000U) /* Bit 4 */
#define TIM_BKFR2_WSIZE_5                       ((uint32_t)0x00400000U) /* Bit 5 */

#define TIM_BKFR2_FILTEN                        ((uint32_t)0x00010000U)
#define TIM_BKFR2_SFPSC                         ((uint32_t)0x0000FFFFU)  



/** Bit definition for TIM_DCTRL register **/
#define TIM_DCTRL_DBADDR                        ((uint32_t)0x00003F00U) /* DBA[5:0] bits (DMA Base Address) */
#define TIM_DCTRL_DBADDR_0                      ((uint32_t)0x00000100U) /* Bit 0 */
#define TIM_DCTRL_DBADDR_1                      ((uint32_t)0x00000200U) /* Bit 1 */
#define TIM_DCTRL_DBADDR_2                      ((uint32_t)0x00000400U) /* Bit 2 */
#define TIM_DCTRL_DBADDR_3                      ((uint32_t)0x00000800U) /* Bit 3 */
#define TIM_DCTRL_DBADDR_4                      ((uint32_t)0x00001000U) /* Bit 4 */
#define TIM_DCTRL_DBADDR_5                      ((uint32_t)0x00002000U) /* Bit 5 */

#define TIM_DCTRL_DBLEN                         ((uint32_t)0x0000003FU) /* DBL[5:0] bits (DMA Burst Length) */
#define TIM_DCTRL_DBLEN_0                       ((uint32_t)0x00000001U) /* Bit 0 */
#define TIM_DCTRL_DBLEN_1                       ((uint32_t)0x00000002U) /* Bit 1 */
#define TIM_DCTRL_DBLEN_2                       ((uint32_t)0x00000004U) /* Bit 2 */
#define TIM_DCTRL_DBLEN_3                       ((uint32_t)0x00000008U) /* Bit 3 */
#define TIM_DCTRL_DBLEN_4                       ((uint32_t)0x00000010U) /* Bit 4 */
#define TIM_DCTRL_DBLEN_5                       ((uint32_t)0x00000020U) /* Bit 5 */

/** Bit definition for TIM_DADDR register **/
#define TIM_DADDR_BURST                         ((uint32_t)0xFFFFFFFFU) /* DMA register for burst accesses */

/*** LCDC ***/

/** Bit definition for LCDC_SYNCCTRL register **/
#define LCDC_SYNCCTRL_VSH                       ((uint32_t)0x0000FFFFU) /* Vertical synchronization height */
#define LCDC_SYNCCTRL_HSW                       ((uint32_t)0xFFFF0000U) /* Horizontal synchronization width */

/** Bit definition for LCDC_BPCTRL register **/
#define LCDC_BPCTRL_AHBP                        ((uint32_t)0x0000FFFFU) /* Accumulated vertical back porch */
#define LCDC_BPCTRL_AVBP                        ((uint32_t)0xFFFF0000U) /* Accumulated horizontal back porch */

/** Bit definition for LCDC_AWCTRL register **/
#define LCDC_AWCTRL_AAH                         ((uint32_t)0x0000FFFFU) /* Accumulated active height */
#define LCDC_AWCTRL_AAW                         ((uint32_t)0xFFFF0000U) /* Accumulated active width */

/** Bit definition for LCDC_TWCTRL register **/
#define LCDC_TWCTRL_TOTALH                      ((uint32_t)0x0000FFFFU) /* Total height */
#define LCDC_TWCTRL_TOTALW                      ((uint32_t)0xFFFF0000U) /* Total width */

/** Bit definition for LCDC_GCTRL register **/
#define LCDC_GCTRL_EN                           ((uint32_t)0x00000001U) /* LCDC enable */
#define LCDC_GCTRL_GCEN                         ((uint32_t)0x00000002U) /* Gamma correction enable */
#define LCDC_GCTRL_DBW                          ((uint32_t)0x00000070U) /* Bit[6:4] Dither blue width */
#define LCDC_GCTRL_DGW                          ((uint32_t)0x00000700U) /* Bit[10:8] Dither green width */
#define LCDC_GCTRL_DRW                          ((uint32_t)0x00007000U) /* Bit[14:12] Dither red width */
#define LCDC_GCTRL_DEN                          ((uint32_t)0x00010000U) /* Dither enable */
#define LCDC_GCTRL_PCLKPOL                      ((uint32_t)0x10000000U) /* Pixel clock polarity */
#define LCDC_GCTRL_DEPOL                        ((uint32_t)0x20000000U) /* Data enable polarity */
#define LCDC_GCTRL_VSPOL              