/**
*     Copyright (c) 2023, Nations Technologies Inc.
* 
*     All rights reserved.
*
*     This software is the exclusive property of Nations Technologies Inc. (Hereinafter 
* referred to as NATIONS). This software, and the product of NATIONS described herein 
* (Hereinafter referred to as the Product) are owned by NATIONS under the laws and treaties
* of the People's Republic of China and other applicable jurisdictions worldwide.
*
*     NATIONS does not grant any license under its patents, copyrights, trademarks, or other 
* intellectual property rights. Names and brands of third party may be mentioned or referred 
* thereto (if any) for identification purposes only.
*
*     NATIONS reserves the right to make changes, corrections, enhancements, modifications, and 
* improvements to this software at any time without notice. Please contact NATIONS and obtain 
* the latest version of this software before placing orders.

*     Although NATIONS has attempted to provide accurate and reliable information, NATIONS assumes 
* no responsibility for the accuracy and reliability of this software.
* 
*     It is the responsibility of the user of this software to properly design, program, and test 
* the functionality and safety of any application made of this information and any resulting product. 
* In no event shall NATIONS be liable for any direct, indirect, incidental, special,exemplary, or 
* consequential damages arising in any way out of the use of this software or the Product.
*
*     NATIONS Products are neither intended nor warranted for usage in systems or equipment, any
* malfunction or failure of which may cause loss of human life, bodily injury or severe property 
* damage. Such applications are deemed, "Insecure Usage".
*
*     All Insecure Usage shall be made at user's risk. User shall indemnify NATIONS and hold NATIONS 
* harmless from and against all claims, costs, damages, and other liabilities, arising from or related 
* to any customer's Insecure Usage.

*     Any express or implied warranty with regard to this software or the Product, including,but not 
* limited to, the warranties of merchantability, fitness for a particular purpose and non-infringement
* are disclaimed to the fullest extent permitted by law.

*     Unless otherwise explicitly permitted by NATIONS, anyone may not duplicate, modify, transcribe
* or otherwise distribute this software for any purposes, in whole or in part.
*
*     NATIONS products and technologies shall not be used for or incorporated into any products or systems
* whose manufacture, use, or sale is prohibited under any applicable domestic or foreign laws or regulations. 
* User shall comply with any applicable export control laws and regulations promulgated and administered by 
* the governments of any countries asserting jurisdiction over the parties or transactions.
**/
 
/**
 *\*\file main.h
 *\*\author Nations
 *\*\version v1.0.0
 *\*\copyright Copyright (c) 2023, Nations Technologies Inc. All rights reserved.
 **/

#ifndef __MAIN_H__
#define __MAIN_H__

#ifdef __cplusplus
extern "C" {
#endif

#include "n32h76x_78x.h"
#include "n32h76x_78x_gpio.h"
#include "los_compiler.h"

#define USART1_BUFSIZE      (32U)
    
#define KEY_SEM_PORT        GPIOC
#define KEY_SEM_PIN         GPIO_PIN_0
#define KEY_SEM_PULL        GPIO_PULL_UP
#define KEY_SEM_READ        ((KEY_SEM_PORT->PID & KEY_SEM_PIN) ? 0U : 1U)

#define KEY_PM_PORT         GPIOC
#define KEY_PM_PIN          GPIO_PIN_1
#define KEY_PM_PULL         GPIO_PULL_UP
#define KEY_PM_READ         ((KEY_PM_PORT->PID & KEY_PM_PIN) ? 0U : 1U)

#define KEY_WKUP_PORT       GPIOA
#define KEY_WKUP_PIN        GPIO_PIN_0
#define KEY_WKUP_PULL       GPIO_NO_PULL
#define KEY_WKUP_READ       ((KEY_WKUP_PORT->PID & KEY_WKUP_PIN) ? 1U : 0U)

#define LED_PORT    GPIOA
#define LED_PIN     GPIO_PIN_4

#define TEST_PORT    GPIOA
#define TEST_PIN     GPIO_PIN_2

void KeyInit(GPIO_Module *Port, UINT32 Pin, UINT32 pull);
void LedInit(GPIO_Module *Port, UINT32 Pin);
void ExtiWakeUpConfig(void);

#ifdef __cplusplus
}
#endif

#endif /* __MAIN_H__ */

