/**
*     Copyright (c) 2025, Nations Technologies Inc.
* 
*     All rights reserved.
*
*     This software is the exclusive property of Nations Technologies Inc. (Hereinafter 
* referred to as NATIONS). This software, and the product of NATIONS described herein 
* (Hereinafter referred to as the Product) are owned by NATIONS under the laws and treaties
* of the People's Republic of China and other applicable jurisdictions worldwide.
*
*     NATIONS does not grant any license under its patents, copyrights, trademarks, or other 
* intellectual property rights. Names and brands of third party may be mentioned or referred 
* thereto (if any) for identification purposes only.
*
*     NATIONS reserves the right to make changes, corrections, enhancements, modifications, and 
* improvements to this software at any time without notice. Please contact NATIONS and obtain 
* the latest version of this software before placing orders.

*     Although NATIONS has attempted to provide accurate and reliable information, NATIONS assumes 
* no responsibility for the accuracy and reliability of this software.
* 
*     It is the responsibility of the user of this software to properly design, program, and test 
* the functionality and safety of any application made of this information and any resulting product. 
* In no event shall NATIONS be liable for any direct, indirect, incidental, special,exemplary, or 
* consequential damages arising in any way out of the use of this software or the Product.
*
*     NATIONS Products are neither intended nor warranted for usage in systems or equipment, any
* malfunction or failure of which may cause loss of human life, bodily injury or severe property 
* damage. Such applications are deemed, "Insecure Usage".
*
*     All Insecure Usage shall be made at user's risk. User shall indemnify NATIONS and hold NATIONS 
* harmless from and against all claims, costs, damages, and other liabilities, arising from or related 
* to any customer's Insecure Usage.

*     Any express or implied warranty with regard to this software or the Product, including,but not 
* limited to, the warranties of merchantability, fitness for a particular purpose and non-infringement
* are disclaimed to the fullest extent permitted by law.

*     Unless otherwise explicitly permitted by NATIONS, anyone may not duplicate, modify, transcribe
* or otherwise distribute this software for any purposes, in whole or in part.
*
*     NATIONS products and technologies shall not be used for or incorporated into any products or systems
* whose manufacture, use, or sale is prohibited under any applicable domestic or foreign laws or regulations. 
* User shall comply with any applicable export control laws and regulations promulgated and administered by 
* the governments of any countries asserting jurisdiction over the parties or transactions.
**/

/**
*\*\file system_n32h76x_78x.h
*\*\author Nations
*\*\version v1.0.0
*\*\copyright Copyright (c) 2025, Nations Technologies Inc. All rights reserved.
 */

#include "n32h76x_78x.h"
#include "n32h76x_78x_rcc.h"

#if !defined  (HSE_VALUE)
#define HSE_VALUE    ((uint32_t)8000000) /* Value of the External oscillator in Hz */
#endif /* HSE_VALUE */

#if !defined  (CSI_VALUE)
  #define CSI_VALUE           ((uint32_t)4000000UL) /* Value of the Internal oscillator in Hz*/
#endif /* CSI_VALUE */

#if !defined  (HSI_VALUE)
  #define HSI_VALUE           ((uint32_t)64000000UL) /* Value of the Internal oscillator in Hz*/
#endif /* HSI_VALUE */

#define VECT_TAB_OFFSET       ((uint32_t)0x00000000UL) /* Vector Table base offset field.   */

#define FLASH_BANK1_BASE      (0x15000000U)

#define FLASH_BANK2_BASE      (0x15080000U)

uint32_t SystemCoreClock = 600000000;

#define TCM_SIZE_VALUE        (0x00) /*TCM_SIZE=0x00 :1024KB ITCM,0   KB DTCM,0   KB AXI_SRAM*/

/** Private_Functions  */

/* defaule power supply is extern LDO. User can change the way of power supply*/
//#define PWR_SUPPLY_SELECTION       (PWR_LDO_SUPPLY)  /* External LDO Supply  */
#define PWR_SUPPLY_SELECTION       (PWR_DIRECT_SMPS_SUPPLY)  /* DCDC Supply  */
//#define PWR_SUPPLY_SELECTION       (PWR_EXTERNAL_SOURCE_SUPPLY)  /* VCAP Supply  */


#define DBG_CPU_DELAY_INTI()    do{                             \
                                /* Enable DWT*/             \
                                DEM_CR |= DEM_CR_TRCENA;    \
                                /* Clear DWT CYCCNT*/       \
                                DWT_CYCCNT = 0U;            \
                                /* Enable DWT CYCCNT*/      \
                                DWT_CR |= DWT_CR_CYCCNTENA; \
                            }while(0)                      

#define DBG_CPU_DELAY_DISABLE() do{                             \
                                /* Disable DWT*/            \
                                DEM_CR &= (uint32_t)(~(uint32_t)DEM_CR_TRCENA); \
                            }while(0)   

#define __DBG_RCC_DELAY_US(usec)     do{                                       \
                                    uint32_t delay_end;                   \
                                    DBG_CPU_DELAY_INTI();                     \
                                    /* Delay*/                            \
                                    delay_end = DWT_CYCCNT + (usec * (64000000/1000000)); \
                                    while(DWT_CYCCNT < delay_end){};      \
                                    DBG_CPU_DELAY_DISABLE();                  \
                                  }while(0) 

/**
 *\*\name   ConfigTcmSize.
 *\*\fun    Config TCM_SIZE
 *\*\param  tcmSizeValue : 
 *\*\           0x00 :1024KB ITCM,0   KB DTCM,0   KB AXI_SRAM
 *\*\           0x01 :896 KB ITCM,128 KB DTCM,0   KB AXI_SRAM
 *\*\           0x02 :768 KB ITCM,256 KB DTCM,0   KB AXI_SRAM
 *\*\           0x03 :640 KB ITCM,384 KB DTCM,0   KB AXI_SRAM
 *\*\           0x04 :512 KB ITCM,512 KB DTCM,0   KB AXI_SRAM
 *\*\           0x05 :384 KB ITCM,640 KB DTCM,0   KB AXI_SRAM
 *\*\           0x06 :256 KB ITCM,768 KB DTCM,0   KB AXI_SRAM
 *\*\           0x07 :128 KB ITCM,896 KB DTCM,0   KB AXI_SRAM
 *\*\           0x08 :0   KB ITCM,1024KB DTCM,0   KB AXI_SRAM
 *\*\           0x09 :896 KB ITCM,0   KB DTCM,128 KB AXI_SRAM
 *\*\           0x0A :768 KB ITCM,128 KB DTCM,128 KB AXI_SRAM
 *\*\           0x0B :640 KB ITCM,256 KB DTCM,128 KB AXI_SRAM
 *\*\           0x0C :512 KB ITCM,384 KB DTCM,128 KB AXI_SRAM
 *\*\           0x0D :384 KB ITCM,512 KB DTCM,128 KB AXI_SRAM
 *\*\           0x0E :256 KB ITCM,640 KB DTCM,128 KB AXI_SRAM
 *\*\           0x0F :128 KB ITCM,768 KB DTCM,128 KB AXI_SRAM
 *\*\           0x10 :0   KB ITCM,896 KB DTCM,128 KB AXI_SRAM
 *\*\           0x11 :768 KB ITCM,0   KB DTCM,256 KB AXI_SRAM
 *\*\           0x12 :640 KB ITCM,128 KB DTCM,256 KB AXI_SRAM
 *\*\           0x13 :512 KB ITCM,256 KB DTCM,256 KB AXI_SRAM
 *\*\           0x14 :384 KB ITCM,384 KB DTCM,256 KB AXI_SRAM
 *\*\           0x15 :256 KB ITCM,512 KB DTCM,256 KB AXI_SRAM
 *\*\           0x16 :128 KB ITCM,640 KB DTCM,256 KB AXI_SRAM
 *\*\           0x17 :0   KB ITCM,768 KB DTCM,256 KB AXI_SRAM
 *\*\           0x18 :640 KB ITCM,0   KB DTCM,386 KB AXI_SRAM
 *\*\           0x19 :512 KB ITCM,128 KB DTCM,386 KB AXI_SRAM
 *\*\           0x1A :384 KB ITCM,256 KB DTCM,386 KB AXI_SRAM
 *\*\           0x1B :256 KB ITCM,384 KB DTCM,386 KB AXI_SRAM
 *\*\           0x1C :128 KB ITCM,512 KB DTCM,386 KB AXI_SRAM
 *\*\           0x1D :0   KB ITCM,640 KB DTCM,386 KB AXI_SRAM
 *\*\           0x1E :512 KB ITCM,0   KB DTCM,512 KB AXI_SRAM
 *\*\           0x1F :384 KB ITCM,128 KB DTCM,512 KB AXI_SRAM
 *\*\           0x20 :256 KB ITCM,256 KB DTCM,512 KB AXI_SRAM
 *\*\           0x21 :128 KB ITCM,384 KB DTCM,512 KB AXI_SRAM
 *\*\           0x22 :0   KB ITCM,512 KB DTCM,512 KB AXI_SRAM
 *\*\           0x23 :384 KB ITCM,0   KB DTCM,640 KB AXI_SRAM
 *\*\           0x24 :256 KB ITCM,128 KB DTCM,640 KB AXI_SRAM
 *\*\           0x25 :128 KB ITCM,256 KB DTCM,640 KB AXI_SRAM
 *\*\           0x26 :0   KB ITCM,384 KB DTCM,640 KB AXI_SRAM
 *\*\           0x27 :256 KB ITCM,0   KB DTCM,768 KB AXI_SRAM
 *\*\           0x28 :128 KB ITCM,128 KB DTCM,768 KB AXI_SRAM
 *\*\           0x29 :0   KB ITCM,256 KB DTCM,768 KB AXI_SRAM
 *\*\           0x2A :128 KB ITCM,0   KB DTCM,896 KB AXI_SRAM
 *\*\           0x2B :0   KB ITCM,128 KB DTCM,896 KB AXI_SRAM
 *\*\           0x2C~2F :0KB ITCM,0   KB DTCM,1024KB AXI_SRAM
 *\*\return none  
 */               
void ConfigTcmSize(uint32_t tcmSizeValue)
{
    uint32_t currValue = (*(uint32_t(*)(void))0x1ff00f01)();
    if((currValue == 0x2c) && (currValue != tcmSizeValue))
    {
        *(uint32_t*)0x51105280 = tcmSizeValue;
        NVIC_SystemReset();
    }
}
#ifdef CORE_CM7
/**
*\*\name    PWR_ConfigSupply.
*\*\fun     Configure the PWR supply.
*\*\param   SupplySource (The input parameters must be the following values):
*\*\          - PWR_LDO_SUPPLY               :External LDO  SUPPLY 
*\*\          - PWR_DIRECT_SMPS_SUPPLY       :DCDC SUPPLY 
*\*\          - PWR_EXTERNAL_SOURCE_SUPPLY   :External VCAP SUPPLY 
*\*\return  none
**/
static void PWR_ConfigSupply(uint32_t SupplySource)
{
    __IO uint32_t tempreg;
    /* Get the old register value */
    tempreg = PWR->SYSCTRL4;
    /* Clear the old  value */
    tempreg &= (~PWR_SUPPLY_MODE_MASK);
    /* Set the new values */
    tempreg |= SupplySource;
    /* Set the power supply configuration */
    PWR->SYSCTRL4 = tempreg;
}
#endif

#ifdef USING_ExSDRAM
/**
*\*\name    ExSDRAM_Config.
*\*\fun     Configure the external SDRAM.
*\*\param   none 
*\*\return  none
**/
static void ExSDRAM_Config(void)
{
	uint32_t delaytime = 0; 
    uint32_t temp_value1,temp_value2;
	
	RCC->AHB5EN1 |= (RCC_AHB5_PERIPHEN_M7_GPIOA|RCC_AHB5_PERIPHEN_M7_GPIOB|RCC_AHB5_PERIPHEN_M7_GPIOC|RCC_AHB5_PERIPHEN_M7_GPIOD);
    RCC->AHB5EN1 |= (RCC_AHB5_PERIPHEN_M7_GPIOE|RCC_AHB5_PERIPHEN_M7_GPIOF|RCC_AHB5_PERIPHEN_M7_GPIOG|RCC_AHB5_PERIPHEN_M7_GPIOH); 
    RCC->AHB5EN2 |= (RCC_AHB5_PERIPHEN_M7_GPIOI|RCC_AHB5_PERIPHEN_M7_AFIO);
    
    /* Reset HSERDCNTEN bit */
    RCC->SRCCTRL1 &= (~RCC_HSE_RDCNTEN);
    /* Set HSEEN bit */
    RCC->SRCCTRL1 |= RCC_HSE_ENABLE;
    __DBG_RCC_DELAY_US(50);
     /* Set HSERDCNTEN bit */
    RCC->SRCCTRL1 |= (RCC_HSE_RDCNTEN);

    /* Wait till HSE is ready */
    while ((RCC->SRCCTRL1&RCC_HSE_STABLE_FLAG) == 0)
    {}
    
    temp_value1 = RCC->PLL3CTRL1;
    temp_value2 = RCC->PLL3CTRL2;
    /* Clear BWAJ[11:0] bits */
    temp_value1 &= RCC_PLL_BWAJ_MASK;
    /* Clear CLKF[25:0] and CLKR[5:0] bits */
    temp_value2 &= RCC_PLL_CLKR_CLKF_MASK;
    
     /* Set BWAJ[11:0] bits - 665M */
    temp_value1 |= 0x41;
    /* Set CLKF[25:0] and CLKR[5:0]  bits */
    temp_value2 |= 0x10214000;
    
    /* Store the new value */
    RCC->PLL3CTRL1  = temp_value1;
    RCC->PLL3CTRL2  = temp_value2;
        
    /* Enable PLL module power */
    RCC->PLL2CTRL1 |= RCC_PLL_LDO_ENABLE;
    __DBG_RCC_DELAY_US(10);

    /* Enable power to analog circuitry in PLL */
    RCC->PLL3CTRL1 &= (~RCC_PLL_POWER_DOWN);

    /* Select Clock Source */
    temp_value1 = RCC->PLL3CTRL1;
    temp_value1 &= RCC_PLL_SRC_MASK;
    temp_value1 |= RCC_PLL_SRC_HSE;
    RCC->PLL3CTRL1 = temp_value1;
    __DBG_RCC_DELAY_US(10);

    /* Clear PLL reset */
    RCC->PLL3CTRL1 &= (~RCC_PLL_RESET_ENABLE);
    while((RCC->PLL3CTRL1&RCC_PLL_LOCK_FLAG) != RCC_PLL_LOCK_FLAG)
    {}
    
    /* Enable PLL */
    RCC->PLL3CTRL1 |= RCC_PLL_ENABLE;
    /*  PLL3A is 133M  */
    RCC->PLL3DIV = 0x00020205; 

    /*  SDRAM kernel clock = PLL3A is 133M  */
    RCC->AXISEL2 = 0x00000300;
    RCC->AXIEN4 |= (RCC_AXI_PERIPHEN_M7_SDRAM | RCC_AXI_PERIPHEN_M7_SDRAMLP);
    RCC->PLLSFTLK = 0x01000020;        

    /* SDRAM_GPIO_Init */
    GPIOA->AFH= 0xFFFFFFFF;
    GPIOA->AFL= 0xFFFFFFFF;
    GPIOA-> POTYPE= 0x00000000;
    GPIOA-> PMODE= 0xABFFFFFF;
    GPIOA-> PUPD= 0x64000000;
    GPIOA->SR= 0x0000FFFF;
    GPIOA->DS= 0xAAAAAAAA;

    GPIOC->AFH= 0xFFFFFFFF;
    GPIOC->AFL= 0xFF00FFFF;
    GPIOC-> POTYPE= 0x00000000;
    GPIOC-> PMODE= 0xFFFFFAFF;
    GPIOC-> PUPD= 0x00000000;
    GPIOC->SR= 0x0000FFCF;
    GPIOC->DS= 0xAAAAA0AA;

    GPIOD->AFH= 0x00FFF000;
    GPIOD->AFL= 0xFFFFFF00;
    GPIOD-> POTYPE= 0x00000000;
    GPIOD-> PMODE= 0xAFEAFFFA;
    GPIOD-> PUPD= 0x00000000;
    GPIOD->SR= 0x000038FC;
    GPIOD->DS= 0x0A80AAA0;

    GPIOE->AFH= 0x00000000;
    GPIOE->AFL= 0x0FFFFF00;
    GPIOE-> POTYPE= 0x00000000;
    GPIOE-> PMODE= 0xAAAABFFA;
    GPIOE-> PUPD= 0x00000000;
    GPIOE->SR= 0x0000007C;
    GPIOE->DS= 0x00002AA0;

    GPIOF->AFH=0x00000FFF;
    GPIOF->AFL= 0xFF000000;
    GPIOF-> POTYPE= 0x00000000;
    GPIOF-> PMODE= 0xAABFFAAA;
    GPIOF-> PUPD= 0x00000000;
    GPIOF->SR= 0x000007C0;
    GPIOF->DS= 0x002AA000;

    GPIOG->AFH= 0x0FFFFFF0;
    GPIOG->AFL= 0xFF00F000;
    GPIOG-> POTYPE= 0x00000000;
    GPIOG-> PMODE= 0xBFFEFAEA;
    GPIOG-> PUPD= 0x00000000;
    GPIOG->SR= 0x00007EC8;
    GPIOG->DS= 0x2AA8A080;

    GPIOH->AFH= 0xFFFFFFFF;
    GPIOH->AFL= 0xFF0FFFFF;
    GPIOH-> POTYPE= 0x00000000;
    GPIOH-> PMODE= 0xFFFFFBFF;
    GPIOH-> PUPD= 0x00000000;
    GPIOH->SR= 0x0000FFDF;
    GPIOH->DS= 0xAAAAA2AA;
    
    /* SDRAM_Init */
    SDRAM->BADD1    = 0xC0000000;
    SDRAM->ADDMASK1 = 0xFE000000;

    SDRAM->RI = 0x00000300;// 133M

    SDRAM->RAT    = 0x00000007;
    SDRAM->RCT    = 0x00000009;
    SDRAM->RRDLY  = 0x00000003;
    SDRAM->PT     = 0x00000004;
    SDRAM->WRT    = 0x00000003;
    SDRAM->RFCT   = 0x00000009;
    SDRAM->RCDLY  = 0x00000004;

    SDRAM->CFG1 = 0xC02F0105;

    SDRAM->OS = 0x52000000;
    SDRAM->OR = 0x52000000;

    SDRAM->OS = 0x62000000;
    SDRAM->OR = 0x62000000;
    
    SDRAM->OS = 0x62000000;
    SDRAM->OR = 0x62000000;

    SDRAM->OS = 0x72000032;
    SDRAM->OR = 0x72000032;

    /* wait at least 300us*/
    for( delaytime = 0; delaytime < 100000; delaytime++); 

    FEMC->FEMC_REMAP = (0x1U);
}
#endif /* USING_ExSDRAM */

/**
 *\*\name   SystemInit.
 *\*\fun    Setup the microcontroller system.Initialize the FPU setting, vector table location and External memory configuration.
 *\*\param  none
 *\*\return none
 */
void SystemInit (void)
{    
  /* FPU settings ------------------------------------------------------------*/
  #if (__FPU_PRESENT == 1) && (__FPU_USED == 1)
    SCB->CPACR |= ((3UL << (10*2))|(3UL << (11*2)));  /* set CP10 and CP11 Full Access */
  #endif

	/*SEVONPEND enabled so that an interrupt coming from the CPU(n) interrupt signal is
     detectable by the CPU after a WFI/WFE instruction.*/ 
  SCB->SCR |= SCB_SCR_SEVONPEND_Msk;

#ifdef CORE_CM7 
	uint32_t temp_value1,temp_value2; 
	/********600M *********/
	RCC->SYSBUSDIV1=0x01001100;
    
    __DBG_RCC_DELAY_US(1);
    /* Configure APB1  APB2 APB5 APB6 clock is 150M */
    RCC->SYSBUSDIV2=0x04040404;
    
    /* configure PLL1 source is HSI, frequency is 600M */
    /* get the register value */
    temp_value1 = RCC->PLL1CTRL1;
    temp_value2 = RCC->PLL1CTRL2;

    /* Clear BWAJ[11:0] bits */
    temp_value1 &= RCC_PLL_BWAJ_MASK;
    /* Clear CLKF[25:0] and CLKR[5:0] bits */
    temp_value2 &= RCC_PLL_CLKR_CLKF_MASK;
    
     /* Set BWAJ[11:0] bits - 600M */
    temp_value1 |= 0x3;
    /* Set CLKF[25:0] and CLKR[5:0]  bits */
    temp_value2 |= 0x25800;
    
    /* Store the new value */
    RCC->PLL1CTRL1  = temp_value1;
    RCC->PLL1CTRL2  = temp_value2;
    
    /* Enable PLL module power */
    RCC->PLL1CTRL1 |= RCC_PLL_LDO_ENABLE;
    __DBG_RCC_DELAY_US(10);

    /* Enable power to analog circuitry in PLL */
    RCC->PLL1CTRL1 &= (~RCC_PLL_POWER_DOWN);

    /* Select Clock Source */
    temp_value1 = RCC->PLL1CTRL1;
    temp_value1 &= RCC_PLL_SRC_MASK;
    temp_value1 |= RCC_PLL_SRC_HSI;
    RCC->PLL1CTRL1 = temp_value1;
    __DBG_RCC_DELAY_US(10);

    /* Clear PLL reset */
    RCC->PLL1CTRL1 &= (~RCC_PLL_RESET_ENABLE);
    while((RCC->PLL1CTRL1&RCC_PLL_LOCK_FLAG) != RCC_PLL_LOCK_FLAG)
    {}
    
    /* Enable PLL */
    RCC->PLL1CTRL1 |= RCC_PLL_ENABLE;
    /* configure PLL1 source is HSI, frequency is 600M end*/
        
    __DBG_RCC_DELAY_US(1);
    
    /* configure PLL1A is 600M */
      RCC->PLL1DIV=0x00020201;
    
    /* configure sys_clk source is PLL1A */
      RCC->SRCCTRL1=0x6F000103;
    /* Check if sys_clk source is PLL1A */
    while((RCC->SRCCTRL1 & RCC_SYSCLK_STS_MASK) != RCC_SYSCLK_STS_PLL1A)
    {}

#endif /* CORE_CM7*/

#ifdef CORE_CM4

  /* Configure the Vector Table location add offset address ------------------*/
#ifdef VECT_TAB_SRAM
//  SCB->VTOR = D2_AXISRAM_BASE | VECT_TAB_OFFSET; /* Vector Table Relocation in Internal SRAM */
#else
  SCB->VTOR = FLASH_BANK2_BASE | VECT_TAB_OFFSET; /* Vector Table Relocation in Internal FLASH */
#endif  

#else
	
#ifdef CORE_CM7

  /* Configure the Vector Table location add offset address ------------------*/
#ifdef VECT_TAB_SRAM
  SCB->VTOR = 0x24000000;       /* Vector Table Relocation in Internal SRAM */
#else
  SCB->VTOR = FLASH_BANK1_BASE | VECT_TAB_OFFSET;       /* Vector Table Relocation in Internal FLASH */
#endif


   /*defaule TCM_SIZE=0x3f,All TCMSRAM are AXI_SRAM,if you want to use ITCM/DTCM, define INIT_TCM_SIZE*/
#ifdef USING_TCM
    ConfigTcmSize(TCM_SIZE_VALUE);
#endif
    /*User can change the way of power supply */
    PWR_ConfigSupply(PWR_SUPPLY_SELECTION);
		
#ifdef USING_ExSDRAM
	ExSDRAM_Config();
#endif

#else
#error Please #define CORE_CM4 or CORE_CM7
#endif                       
#endif

}


