/**
*     Copyright (c) 2025, Nations Technologies Inc.
* 
*     All rights reserved.
*
*     This software is the exclusive property of Nations Technologies Inc. (Hereinafter 
* referred to as NATIONS). This software, and the product of NATIONS described herein 
* (Hereinafter referred to as the Product) are owned by NATIONS under the laws and treaties
* of the People's Republic of China and other applicable jurisdictions worldwide.
*
*     NATIONS does not grant any license under its patents, copyrights, trademarks, or other 
* intellectual property rights. Names and brands of third party may be mentioned or referred 
* thereto (if any) for identification purposes only.
*
*     NATIONS reserves the right to make changes, corrections, enhancements, modifications, and 
* improvements to this software at any time without notice. Please contact NATIONS and obtain 
* the latest version of this software before placing orders.

*     Although NATIONS has attempted to provide accurate and reliable information, NATIONS assumes 
* no responsibility for the accuracy and reliability of this software.
* 
*     It is the responsibility of the user of this software to properly design, program, and test 
* the functionality and safety of any application made of this information and any resulting product. 
* In no event shall NATIONS be liable for any direct, indirect, incidental, special,exemplary, or 
* consequential damages arising in any way out of the use of this software or the Product.
*
*     NATIONS Products are neither intended nor warranted for usage in systems or equipment, any
* malfunction or failure of which may cause loss of human life, bodily injury or severe property 
* damage. Such applications are deemed, "Insecure Usage".
*
*     All Insecure Usage shall be made at user's risk. User shall indemnify NATIONS and hold NATIONS 
* harmless from and against all claims, costs, damages, and other liabilities, arising from or related 
* to any customer's Insecure Usage.

*     Any express or implied warranty with regard to this software or the Product, including,but not 
* limited to, the warranties of merchantability, fitness for a particular purpose and non-infringement
* are disclaimed to the fullest extent permitted by law.

*     Unless otherwise explicitly permitted by NATIONS, anyone may not duplicate, modify, transcribe
* or otherwise distribute this software for any purposes, in whole or in part.
*
*     NATIONS products and technologies shall not be used for or incorporated into any products or systems
* whose manufacture, use, or sale is prohibited under any applicable domestic or foreign laws or regulations. 
* User shall comply with any applicable export control laws and regulations promulgated and administered by 
* the governments of any countries asserting jurisdiction over the parties or transactions.
**/

/**
*\*\file n32h76x_78x_sema4.h
*\*\author Nations
*\*\version v1.0.0
*\*\copyright Copyright (c) 2025, Nations Technologies Inc. All rights reserved.
**/

#ifndef __n32H76X_78X_SEMA4_H__
#define __n32H76X_78X_SEMA4_H__

#ifdef __cplusplus
extern "C" {
#endif

#include "n32h76x_78x.h"

/** n32h76x_78x_StdPeriph_Driver **/

/** SEMA4_Exported_Constants **/
#define CM7_COREID    				(0x00000003U) /* Semaphore Core CM7 ID */
#define CM4_COREID    				(0x00000001U) /* Semaphore Core CM4 ID */

#define SEMA4_R_LOCK_MASK   		(SEMA4_R_LOCK)
#define SEMA4_R_PROCESS_ID_MASK   	(SEMA4_R_PROCID)

#if defined(CORE_CM7)
#define SEMA4_CLR_COREID_CURRENT   (CM7_COREID << SEMA4_CLR_COREID_OFFSET)
#else  /* CORE_CM4 */
#define SEMA4_CLR_COREID_CURRENT   (CM4_COREID << SEMA4_CLR_COREID_OFFSET)
#endif /* CORE_CM7 */

typedef enum 
{
	LOCK_ID_0 = 0,
	LOCK_ID_1,
	LOCK_ID_2,
	LOCK_ID_3,
	LOCK_ID_4,
	LOCK_ID_5,
	LOCK_ID_6,
	LOCK_ID_7,
	LOCK_ID_8,
	LOCK_ID_9,
	LOCK_ID_10,
	LOCK_ID_11,
	LOCK_ID_12,
	LOCK_ID_13,
	LOCK_ID_14,
	LOCK_ID_15,
	LOCK_ID_16,
	LOCK_ID_17,
	LOCK_ID_18,
	LOCK_ID_19,
	LOCK_ID_20,
	LOCK_ID_21,
	LOCK_ID_22,
	LOCK_ID_23,
	LOCK_ID_24,
	LOCK_ID_25,
	LOCK_ID_26,
	LOCK_ID_27,
	LOCK_ID_28,
	LOCK_ID_29,
	LOCK_ID_30,
	LOCK_ID_31,
	LOCK_ID_MAX
}SEMA4_LockId;


/** SEMA4_Exported_Functions **/
void SEMA4_DeInit( void );

bool SEMA4_IsLocked( SEMA4_LockId LockID );
bool SEMA4_Lock( SEMA4_LockId LockID, uint8_t ProcessID );
bool SEMA4_FastLock( SEMA4_LockId eLockID );
void SEMA4_Unlock( SEMA4_LockId eLockID, uint8_t u8ProcessID );
void SEMA4_UnLockAll( uint32_t Key, uint32_t CoreID );
void SEMA4_SetClearKey( uint32_t Key );
uint32_t SEMA4_GetClearKey(void);
void SEMA4_EnableLockInterrupt(uint32_t SemMask, FunctionalState Cmd);
void SEMA4_EnableLockFailInterrupt( uint32_t SemMask, FunctionalState en );
uint32_t SEMA4_GetMaskInterruptFlag(void );
void SEMA4_ClearInterruptFlag( uint32_t SemMask );
bool SEMA4_IsLockInterrupt( uint32_t SemMask );
bool SEMA4_IsFailLockInterrupt( uint32_t SemMask );


#ifdef __cplusplus
}
#endif

#endif /*__n32H76X_78X_SEMA4_H__ */
